#ifndef _RHEO_FIELD_VISU_H
#define _RHEO_FIELD_VISU_H
///
/// This file is part of Rheolef.
///
/// Copyright (C) 2000-2009 Pierre Saramito <Pierre.Saramito@imag.fr>
///
/// Rheolef is free software; you can redistribute it and/or modify
/// it under the terms of the GNU General Public License as published by
/// the Free Software Foundation; either version 2 of the License, or
/// (at your option) any later version.
///
/// Rheolef is distributed in the hope that it will be useful,
/// but WITHOUT ANY WARRANTY; without even the implied warranty of
/// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
/// GNU General Public License for more details.
///
/// You should have received a copy of the GNU General Public License
/// along with Rheolef; if not, write to the Free Software
/// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
/// 
/// =========================================================================
//
// option : internal data structure
// shared by visualization modules
// used to send options as a packet
//
//  author: Pierre.Saramito@imag.fr
//
#include "rheolef/field.h"
#include "rheolef/iorheo.h"
namespace rheolef { 

class field_visu_option_type {
public:
  
     field_visu_option_type (std::ostream& s);
     void dump (std::ostream& os = std::cerr) const;

// data:

     iorheo::flag_type format;

     bool execute;
     bool clean;
     bool verbose;

     std::string basename;
     
     bool color;
     bool gray;
     bool black_and_white;
     bool cut;
     bool iso;
     bool fill;
     bool stereo;
     bool grid;
     bool domains;
     bool volume;
     bool elevation;
     bool velocity;
     bool deformation;
     bool label;
     
     size_t n_isovalue;
     size_t n_isovalue_negative;
     Float isovalue;
     Float vscale;
     bool autovscale;
     
     point origin;
     point normal;
};
}// namespace rheolef
# endif // _RHEO_FIELD_VISU_H
