///
/// This file is part of Rheolef.
///
/// Copyright (C) 2000-2009 Pierre Saramito <Pierre.Saramito@imag.fr>
///
/// Rheolef is free software; you can redistribute it and/or modify
/// it under the terms of the GNU General Public License as published by
/// the Free Software Foundation; either version 2 of the License, or
/// (at your option) any later version.
///
/// Rheolef is distributed in the hope that it will be useful,
/// but WITHOUT ANY WARRANTY; without even the implied warranty of
/// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
/// GNU General Public License for more details.
///
/// You should have received a copy of the GNU General Public License
/// along with Rheolef; if not, write to the Free Software
/// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
/// 
/// =========================================================================
/*
   example:			abbrev

   int 				i
   T				t	n_scalar=2

   field<T,M>			F
   field_indirect<T,M>		G	n_class=3
   field_indirect_const<T,M>	H

   field_expr<E>		E	expr

  => binary matrix profile :

                iF iG iH   iE
                tF tG tH   tE

	Fi Ft   FF FG FH   FE
	Gi Gt   GF GG GH   GE
	Hi Ht   HF HG HH   HE

	Ei Et   EF EG EH   EE

  template:
     xY	Xy => template<T,M>		x=i,t  X=F,G,H
	XY => template<T1,T2,M>		X,Y=F,G,H
     iE Ei => template<E>		x=i
     tE Et => template<T,E>		x=t
     XE EX => template<E,T,M>		X=F,G,H
     EE    => template<E1,E2>
*/
#include "expr_ops_make.icc"
// =====================================================================================
int main() {
// =====================================================================================
  s expr    = "field_expr";
  s details = "field_detail";
  s domain  = "field_domain";
  s tag  = "is_field";

  vector<rhs> Rhsclass;
  Rhsclass.push_back (rhs("field_basic",   "&"));
  Rhsclass.push_back (rhs("field_indirect",""));
  Rhsclass.push_back (rhs("field_component",""));

  vector<s> Class;
  Class.push_back ("field_basic");
  Class.push_back ("field_indirect");
  Class.push_back ("field_indirect_const");
  Class.push_back ("field_component");
  Class.push_back ("field_component_const");

  vector<op> Unop;
  Unop.push_back (op("+", "boost::proto::tag::unary_plus"));
  Unop.push_back (op("-", "boost::proto::tag::negate"));

  vector<op> BinopLinear;
  BinopLinear.push_back (op("+", "boost::proto::tag::plus"));
  BinopLinear.push_back (op("-", "boost::proto::tag::minus"));

  vector<op> BinopNonlinear;
  BinopNonlinear.push_back (op("*", "boost::proto::tag::multiplies"));
  BinopNonlinear.push_back (op("/", "boost::proto::tag::divides"));

  vector<aop> AssignopLinear;
  AssignopLinear.push_back (aop("+=", "plus_assign"));
  AssignopLinear.push_back (aop("-=", "minus_assign"));

  vector<aop> AssignopNonlinear;
  AssignopNonlinear.push_back (aop("*=", "multiplies_assign"));
  AssignopNonlinear.push_back (aop("/=", "divides_assign"));

  header("FIELD", "field");
  all_unops                (tag, domain, Unop,           Class, expr);
  all_binops               (tag, domain, BinopLinear,    Class, expr);
  all_binops_with_constant (tag, domain, BinopNonlinear, Class, expr);
  all_assign_ops               ("field", "stamp", tag, domain, details, AssignopLinear,    Rhsclass, Class, expr);
  all_assign_ops_with_constant ("field", "stamp", tag, domain, details, AssignopNonlinear, Rhsclass, Class, expr);

  dot ("dual", "field", Class, expr, "ndof", "scalar_type");
  footer("FIELD", "field");
}
