#!/bin/bash
#
# RC sample administration - grant General Users no write access outside
# /home tree.
#
#
# Redo security check
#if test "`attr_get_file_dir DIR /home rc_type_fd`" != "65"
#then echo "/home already has a rc_type_fd set, exiting!" ; exit
#fi
HOMEAREATYPE=`rc_get_item list_used_fd_types | grep 'Home_Area' | cut -f 1 -d ' '`
if test -z $HOMEAREATYPE
then HOMEAREATYPE=`rc_get_item list_unused_fd_type_nr | head -n 1`
else
echo Redoing settings for \"Home Area\" type $HOMEAREATYPE
fi
#
GENERALTYPE=0
GENERALUSERROLE=0
ROLEADMINROLE=1
SYSADMINROLE=2
#
echo ""
echo Create new type \"Home Area\"
rc_set_item TYPE $HOMEAREATYPE type_fd_name "Home Area"
#
echo ""
echo Give \"Role Admin\" read rights to HOMEAREATYPE $HOMEAREATYPE
rc_set_item ROLE $ROLEADMINROLE type_comp_fd $HOMEAREATYPE R 1
#
echo ""
echo Give \"System Admin\" SEARCH right to HOMEAREATYPE $HOMEAREATYPE
rc_set_item ROLE $SYSADMINROLE type_comp_fd $HOMEAREATYPE SEARCH 1
#
echo ""
echo Give \"General User\" read-write rights to HOMEAREATYPE $HOMEAREATYPE
rc_set_item ROLE $GENERALUSERROLE type_comp_fd $HOMEAREATYPE RW 1
#
#echo ""
#echo Revoke \"General User\" EXECUTE right to HOMEAREATYPE $HOMEAREATYPE
#rc_set_item ROLE $GENERALUSERROLE type_comp_fd $HOMEAREATYPE EXECUTE 0
#
echo ""
echo Revoke \"General User\" write rights to \"General FD\"
rc_set_item ROLE $GENERALUSERROLE type_comp_fd $GENERALTYPE A 0
rc_set_item ROLE $GENERALUSERROLE type_comp_fd $GENERALTYPE R 1
#
echo ""
echo Set type $HOMEAREATYPE \"Home Area\" for /home
attr_set_file_dir DIR /home rc_type_fd $HOMEAREATYPE
