//! Autogenerated: 'src/ExtractionOCaml/word_by_word_montgomery' --lang Rust --inline sm2 32 '2^256 - 2^224 - 2^96 + 2^64 - 1' mul square add sub opp from_montgomery to_montgomery nonzero selectznz to_bytes from_bytes one msat divstep divstep_precomp
//! curve description: sm2
//! machine_wordsize = 32 (from "32")
//! requested operations: mul, square, add, sub, opp, from_montgomery, to_montgomery, nonzero, selectznz, to_bytes, from_bytes, one, msat, divstep, divstep_precomp
//! m = 0xfffffffeffffffffffffffffffffffffffffffff00000000ffffffffffffffff (from "2^256 - 2^224 - 2^96 + 2^64 - 1")
//!
//! NOTE: In addition to the bounds specified above each function, all
//!   functions synthesized for this Montgomery arithmetic require the
//!   input to be strictly less than the prime modulus (m), and also
//!   require the input to be in the unique saturated representation.
//!   All functions also ensure that these two properties are true of
//!   return values.
//!
//! Computed values:
//!   eval z = z[0] + (z[1] << 32) + (z[2] << 64) + (z[3] << 96) + (z[4] << 128) + (z[5] << 160) + (z[6] << 192) + (z[7] << 224)
//!   bytes_eval z = z[0] + (z[1] << 8) + (z[2] << 16) + (z[3] << 24) + (z[4] << 32) + (z[5] << 40) + (z[6] << 48) + (z[7] << 56) + (z[8] << 64) + (z[9] << 72) + (z[10] << 80) + (z[11] << 88) + (z[12] << 96) + (z[13] << 104) + (z[14] << 112) + (z[15] << 120) + (z[16] << 128) + (z[17] << 136) + (z[18] << 144) + (z[19] << 152) + (z[20] << 160) + (z[21] << 168) + (z[22] << 176) + (z[23] << 184) + (z[24] << 192) + (z[25] << 200) + (z[26] << 208) + (z[27] << 216) + (z[28] << 224) + (z[29] << 232) + (z[30] << 240) + (z[31] << 248)
//!   twos_complement_eval z = let x1 := z[0] + (z[1] << 32) + (z[2] << 64) + (z[3] << 96) + (z[4] << 128) + (z[5] << 160) + (z[6] << 192) + (z[7] << 224) in
//!                            if x1 & (2^256-1) < 2^255 then x1 & (2^256-1) else (x1 & (2^256-1)) - 2^256

#![allow(unused_parens)]
#![allow(non_camel_case_types)]

/// Since `Index` and `IndexMut` aren't callable in `const` contexts yet, this helper type helps unify
/// arrays and user-defined array-wrapper types into a single type which can be indexed in `const`
/// contexts. Once `const trait`s are stabilized this type can go away
struct IndexConst<T: ?Sized>(T);

impl<'a, T, const N: usize> IndexConst<&'a [T; N]> {
    #[inline(always)]
    #[allow(unused)]
    const fn index(self, i: usize) -> &'a T {
        &self.0[i]
    }
}
impl<'a, 'b, T, const N: usize> IndexConst<&'a mut &'b mut [T; N]> {
    #[inline(always)]
    #[allow(unused)]
    const fn index_mut(self, i: usize) -> &'a mut T {
        &mut self.0[i]
    }
}

/** fiat_sm2_u1 represents values of 1 bits, stored in one byte. */
pub type fiat_sm2_u1 = u8;
/** fiat_sm2_i1 represents values of 1 bits, stored in one byte. */
pub type fiat_sm2_i1 = i8;
/** fiat_sm2_u2 represents values of 2 bits, stored in one byte. */
pub type fiat_sm2_u2 = u8;
/** fiat_sm2_i2 represents values of 2 bits, stored in one byte. */
pub type fiat_sm2_i2 = i8;

/** The type fiat_sm2_montgomery_domain_field_element is a field element in the Montgomery domain. */
/** Bounds: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]] */
#[derive(Clone, Copy)]
pub struct fiat_sm2_montgomery_domain_field_element(pub [u32; 8]);

impl core::ops::Index<usize> for fiat_sm2_montgomery_domain_field_element {
    type Output = u32;
    #[inline]
    fn index(&self, index: usize) -> &Self::Output {
        &self.0[index]
    }
}

impl core::ops::IndexMut<usize> for fiat_sm2_montgomery_domain_field_element {
    #[inline]
    fn index_mut(&mut self, index: usize) -> &mut Self::Output {
        &mut self.0[index]
    }
}

impl<'a> IndexConst<&'a fiat_sm2_montgomery_domain_field_element> {
    #[allow(unused)]
    #[inline(always)]
    const fn index(self, i: usize) -> &'a u32 {
        &self.0.0[i]
    }
}

impl<'a, 'b> IndexConst<&'a mut &'b mut fiat_sm2_montgomery_domain_field_element> {
    #[allow(unused)]
    #[inline(always)]
    const fn index_mut(self, i: usize) -> &'a mut u32 {
        &mut self.0.0[i]
    }
}

/** The type fiat_sm2_non_montgomery_domain_field_element is a field element NOT in the Montgomery domain. */
/** Bounds: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]] */
#[derive(Clone, Copy)]
pub struct fiat_sm2_non_montgomery_domain_field_element(pub [u32; 8]);

impl core::ops::Index<usize> for fiat_sm2_non_montgomery_domain_field_element {
    type Output = u32;
    #[inline]
    fn index(&self, index: usize) -> &Self::Output {
        &self.0[index]
    }
}

impl core::ops::IndexMut<usize> for fiat_sm2_non_montgomery_domain_field_element {
    #[inline]
    fn index_mut(&mut self, index: usize) -> &mut Self::Output {
        &mut self.0[index]
    }
}

impl<'a> IndexConst<&'a fiat_sm2_non_montgomery_domain_field_element> {
    #[allow(unused)]
    #[inline(always)]
    const fn index(self, i: usize) -> &'a u32 {
        &self.0.0[i]
    }
}

impl<'a, 'b> IndexConst<&'a mut &'b mut fiat_sm2_non_montgomery_domain_field_element> {
    #[allow(unused)]
    #[inline(always)]
    const fn index_mut(self, i: usize) -> &'a mut u32 {
        &mut self.0.0[i]
    }
}


/// The function fiat_sm2_addcarryx_u32 is an addition with carry.
///
/// Postconditions:
///   out1 = (arg1 + arg2 + arg3) mod 2^32
///   out2 = ⌊(arg1 + arg2 + arg3) / 2^32⌋
///
/// Input Bounds:
///   arg1: [0x0 ~> 0x1]
///   arg2: [0x0 ~> 0xffffffff]
///   arg3: [0x0 ~> 0xffffffff]
/// Output Bounds:
///   out1: [0x0 ~> 0xffffffff]
///   out2: [0x0 ~> 0x1]
#[inline]
pub const fn fiat_sm2_addcarryx_u32(out1: &mut u32, out2: &mut fiat_sm2_u1, arg1: fiat_sm2_u1, arg2: u32, arg3: u32) {
  let x1: u64 = (((arg1 as u64) + (arg2 as u64)) + (arg3 as u64));
  let x2: u32 = ((x1 & (0xffffffff as u64)) as u32);
  let x3: fiat_sm2_u1 = ((x1 >> 32) as fiat_sm2_u1);
  *out1 = x2;
  *out2 = x3;
}

/// The function fiat_sm2_subborrowx_u32 is a subtraction with borrow.
///
/// Postconditions:
///   out1 = (-arg1 + arg2 + -arg3) mod 2^32
///   out2 = -⌊(-arg1 + arg2 + -arg3) / 2^32⌋
///
/// Input Bounds:
///   arg1: [0x0 ~> 0x1]
///   arg2: [0x0 ~> 0xffffffff]
///   arg3: [0x0 ~> 0xffffffff]
/// Output Bounds:
///   out1: [0x0 ~> 0xffffffff]
///   out2: [0x0 ~> 0x1]
#[inline]
pub const fn fiat_sm2_subborrowx_u32(out1: &mut u32, out2: &mut fiat_sm2_u1, arg1: fiat_sm2_u1, arg2: u32, arg3: u32) {
  let x1: i64 = (((arg2 as i64) - (arg1 as i64)) - (arg3 as i64));
  let x2: fiat_sm2_i1 = ((x1 >> 32) as fiat_sm2_i1);
  let x3: u32 = ((x1 & (0xffffffff as i64)) as u32);
  *out1 = x3;
  *out2 = (((0x0 as fiat_sm2_i2) - (x2 as fiat_sm2_i2)) as fiat_sm2_u1);
}

/// The function fiat_sm2_mulx_u32 is a multiplication, returning the full double-width result.
///
/// Postconditions:
///   out1 = (arg1 * arg2) mod 2^32
///   out2 = ⌊arg1 * arg2 / 2^32⌋
///
/// Input Bounds:
///   arg1: [0x0 ~> 0xffffffff]
///   arg2: [0x0 ~> 0xffffffff]
/// Output Bounds:
///   out1: [0x0 ~> 0xffffffff]
///   out2: [0x0 ~> 0xffffffff]
#[inline]
pub const fn fiat_sm2_mulx_u32(out1: &mut u32, out2: &mut u32, arg1: u32, arg2: u32) {
  let x1: u64 = ((arg1 as u64) * (arg2 as u64));
  let x2: u32 = ((x1 & (0xffffffff as u64)) as u32);
  let x3: u32 = ((x1 >> 32) as u32);
  *out1 = x2;
  *out2 = x3;
}

/// The function fiat_sm2_cmovznz_u32 is a single-word conditional move.
///
/// Postconditions:
///   out1 = (if arg1 = 0 then arg2 else arg3)
///
/// Input Bounds:
///   arg1: [0x0 ~> 0x1]
///   arg2: [0x0 ~> 0xffffffff]
///   arg3: [0x0 ~> 0xffffffff]
/// Output Bounds:
///   out1: [0x0 ~> 0xffffffff]
#[inline]
pub const fn fiat_sm2_cmovznz_u32(out1: &mut u32, arg1: fiat_sm2_u1, arg2: u32, arg3: u32) {
  let x1: fiat_sm2_u1 = (!(!arg1));
  let x2: u32 = ((((((0x0 as fiat_sm2_i2) - (x1 as fiat_sm2_i2)) as fiat_sm2_i1) as i64) & (0xffffffff as i64)) as u32);
  let x3: u32 = ((x2 & arg3) | ((!x2) & arg2));
  *out1 = x3;
}

/// The function fiat_sm2_mul multiplies two field elements in the Montgomery domain.
///
/// Preconditions:
///   0 ≤ eval arg1 < m
///   0 ≤ eval arg2 < m
/// Postconditions:
///   eval (from_montgomery out1) mod m = (eval (from_montgomery arg1) * eval (from_montgomery arg2)) mod m
///   0 ≤ eval out1 < m
///
#[inline]
pub const fn fiat_sm2_mul(mut out1: &mut fiat_sm2_montgomery_domain_field_element, arg1: &fiat_sm2_montgomery_domain_field_element, arg2: &fiat_sm2_montgomery_domain_field_element) {
  let x1: u32 = (*IndexConst(arg1).index(1));
  let x2: u32 = (*IndexConst(arg1).index(2));
  let x3: u32 = (*IndexConst(arg1).index(3));
  let x4: u32 = (*IndexConst(arg1).index(4));
  let x5: u32 = (*IndexConst(arg1).index(5));
  let x6: u32 = (*IndexConst(arg1).index(6));
  let x7: u32 = (*IndexConst(arg1).index(7));
  let x8: u32 = (*IndexConst(arg1).index(0));
  let mut x9: u32 = 0;
  let mut x10: u32 = 0;
  fiat_sm2_mulx_u32(&mut x9, &mut x10, x8, (*IndexConst(arg2).index(7)));
  let mut x11: u32 = 0;
  let mut x12: u32 = 0;
  fiat_sm2_mulx_u32(&mut x11, &mut x12, x8, (*IndexConst(arg2).index(6)));
  let mut x13: u32 = 0;
  let mut x14: u32 = 0;
  fiat_sm2_mulx_u32(&mut x13, &mut x14, x8, (*IndexConst(arg2).index(5)));
  let mut x15: u32 = 0;
  let mut x16: u32 = 0;
  fiat_sm2_mulx_u32(&mut x15, &mut x16, x8, (*IndexConst(arg2).index(4)));
  let mut x17: u32 = 0;
  let mut x18: u32 = 0;
  fiat_sm2_mulx_u32(&mut x17, &mut x18, x8, (*IndexConst(arg2).index(3)));
  let mut x19: u32 = 0;
  let mut x20: u32 = 0;
  fiat_sm2_mulx_u32(&mut x19, &mut x20, x8, (*IndexConst(arg2).index(2)));
  let mut x21: u32 = 0;
  let mut x22: u32 = 0;
  fiat_sm2_mulx_u32(&mut x21, &mut x22, x8, (*IndexConst(arg2).index(1)));
  let mut x23: u32 = 0;
  let mut x24: u32 = 0;
  fiat_sm2_mulx_u32(&mut x23, &mut x24, x8, (*IndexConst(arg2).index(0)));
  let mut x25: u32 = 0;
  let mut x26: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x25, &mut x26, 0x0, x24, x21);
  let mut x27: u32 = 0;
  let mut x28: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x27, &mut x28, x26, x22, x19);
  let mut x29: u32 = 0;
  let mut x30: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x29, &mut x30, x28, x20, x17);
  let mut x31: u32 = 0;
  let mut x32: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x31, &mut x32, x30, x18, x15);
  let mut x33: u32 = 0;
  let mut x34: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x33, &mut x34, x32, x16, x13);
  let mut x35: u32 = 0;
  let mut x36: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x35, &mut x36, x34, x14, x11);
  let mut x37: u32 = 0;
  let mut x38: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x37, &mut x38, x36, x12, x9);
  let x39: u32 = ((x38 as u32) + x10);
  let mut x40: u32 = 0;
  let mut x41: u32 = 0;
  fiat_sm2_mulx_u32(&mut x40, &mut x41, x23, 0xfffffffe);
  let mut x42: u32 = 0;
  let mut x43: u32 = 0;
  fiat_sm2_mulx_u32(&mut x42, &mut x43, x23, 0xffffffff);
  let mut x44: u32 = 0;
  let mut x45: u32 = 0;
  fiat_sm2_mulx_u32(&mut x44, &mut x45, x23, 0xffffffff);
  let mut x46: u32 = 0;
  let mut x47: u32 = 0;
  fiat_sm2_mulx_u32(&mut x46, &mut x47, x23, 0xffffffff);
  let mut x48: u32 = 0;
  let mut x49: u32 = 0;
  fiat_sm2_mulx_u32(&mut x48, &mut x49, x23, 0xffffffff);
  let mut x50: u32 = 0;
  let mut x51: u32 = 0;
  fiat_sm2_mulx_u32(&mut x50, &mut x51, x23, 0xffffffff);
  let mut x52: u32 = 0;
  let mut x53: u32 = 0;
  fiat_sm2_mulx_u32(&mut x52, &mut x53, x23, 0xffffffff);
  let mut x54: u32 = 0;
  let mut x55: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x54, &mut x55, 0x0, x53, x50);
  let x56: u32 = ((x55 as u32) + x51);
  let mut x57: u32 = 0;
  let mut x58: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x57, &mut x58, 0x0, x49, x46);
  let mut x59: u32 = 0;
  let mut x60: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x59, &mut x60, x58, x47, x44);
  let mut x61: u32 = 0;
  let mut x62: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x61, &mut x62, x60, x45, x42);
  let mut x63: u32 = 0;
  let mut x64: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x63, &mut x64, x62, x43, x40);
  let x65: u32 = ((x64 as u32) + x41);
  let mut x66: u32 = 0;
  let mut x67: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x66, &mut x67, 0x0, x23, x52);
  let mut x68: u32 = 0;
  let mut x69: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x68, &mut x69, x67, x25, x54);
  let mut x70: u32 = 0;
  let mut x71: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x70, &mut x71, x69, x27, x56);
  let mut x72: u32 = 0;
  let mut x73: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x72, &mut x73, x71, x29, x48);
  let mut x74: u32 = 0;
  let mut x75: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x74, &mut x75, x73, x31, x57);
  let mut x76: u32 = 0;
  let mut x77: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x76, &mut x77, x75, x33, x59);
  let mut x78: u32 = 0;
  let mut x79: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x78, &mut x79, x77, x35, x61);
  let mut x80: u32 = 0;
  let mut x81: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x80, &mut x81, x79, x37, x63);
  let mut x82: u32 = 0;
  let mut x83: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x82, &mut x83, x81, x39, x65);
  let mut x84: u32 = 0;
  let mut x85: u32 = 0;
  fiat_sm2_mulx_u32(&mut x84, &mut x85, x1, (*IndexConst(arg2).index(7)));
  let mut x86: u32 = 0;
  let mut x87: u32 = 0;
  fiat_sm2_mulx_u32(&mut x86, &mut x87, x1, (*IndexConst(arg2).index(6)));
  let mut x88: u32 = 0;
  let mut x89: u32 = 0;
  fiat_sm2_mulx_u32(&mut x88, &mut x89, x1, (*IndexConst(arg2).index(5)));
  let mut x90: u32 = 0;
  let mut x91: u32 = 0;
  fiat_sm2_mulx_u32(&mut x90, &mut x91, x1, (*IndexConst(arg2).index(4)));
  let mut x92: u32 = 0;
  let mut x93: u32 = 0;
  fiat_sm2_mulx_u32(&mut x92, &mut x93, x1, (*IndexConst(arg2).index(3)));
  let mut x94: u32 = 0;
  let mut x95: u32 = 0;
  fiat_sm2_mulx_u32(&mut x94, &mut x95, x1, (*IndexConst(arg2).index(2)));
  let mut x96: u32 = 0;
  let mut x97: u32 = 0;
  fiat_sm2_mulx_u32(&mut x96, &mut x97, x1, (*IndexConst(arg2).index(1)));
  let mut x98: u32 = 0;
  let mut x99: u32 = 0;
  fiat_sm2_mulx_u32(&mut x98, &mut x99, x1, (*IndexConst(arg2).index(0)));
  let mut x100: u32 = 0;
  let mut x101: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x100, &mut x101, 0x0, x99, x96);
  let mut x102: u32 = 0;
  let mut x103: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x102, &mut x103, x101, x97, x94);
  let mut x104: u32 = 0;
  let mut x105: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x104, &mut x105, x103, x95, x92);
  let mut x106: u32 = 0;
  let mut x107: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x106, &mut x107, x105, x93, x90);
  let mut x108: u32 = 0;
  let mut x109: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x108, &mut x109, x107, x91, x88);
  let mut x110: u32 = 0;
  let mut x111: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x110, &mut x111, x109, x89, x86);
  let mut x112: u32 = 0;
  let mut x113: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x112, &mut x113, x111, x87, x84);
  let x114: u32 = ((x113 as u32) + x85);
  let mut x115: u32 = 0;
  let mut x116: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x115, &mut x116, 0x0, x68, x98);
  let mut x117: u32 = 0;
  let mut x118: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x117, &mut x118, x116, x70, x100);
  let mut x119: u32 = 0;
  let mut x120: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x119, &mut x120, x118, x72, x102);
  let mut x121: u32 = 0;
  let mut x122: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x121, &mut x122, x120, x74, x104);
  let mut x123: u32 = 0;
  let mut x124: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x123, &mut x124, x122, x76, x106);
  let mut x125: u32 = 0;
  let mut x126: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x125, &mut x126, x124, x78, x108);
  let mut x127: u32 = 0;
  let mut x128: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x127, &mut x128, x126, x80, x110);
  let mut x129: u32 = 0;
  let mut x130: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x129, &mut x130, x128, x82, x112);
  let mut x131: u32 = 0;
  let mut x132: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x131, &mut x132, x130, (x83 as u32), x114);
  let mut x133: u32 = 0;
  let mut x134: u32 = 0;
  fiat_sm2_mulx_u32(&mut x133, &mut x134, x115, 0xfffffffe);
  let mut x135: u32 = 0;
  let mut x136: u32 = 0;
  fiat_sm2_mulx_u32(&mut x135, &mut x136, x115, 0xffffffff);
  let mut x137: u32 = 0;
  let mut x138: u32 = 0;
  fiat_sm2_mulx_u32(&mut x137, &mut x138, x115, 0xffffffff);
  let mut x139: u32 = 0;
  let mut x140: u32 = 0;
  fiat_sm2_mulx_u32(&mut x139, &mut x140, x115, 0xffffffff);
  let mut x141: u32 = 0;
  let mut x142: u32 = 0;
  fiat_sm2_mulx_u32(&mut x141, &mut x142, x115, 0xffffffff);
  let mut x143: u32 = 0;
  let mut x144: u32 = 0;
  fiat_sm2_mulx_u32(&mut x143, &mut x144, x115, 0xffffffff);
  let mut x145: u32 = 0;
  let mut x146: u32 = 0;
  fiat_sm2_mulx_u32(&mut x145, &mut x146, x115, 0xffffffff);
  let mut x147: u32 = 0;
  let mut x148: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x147, &mut x148, 0x0, x146, x143);
  let x149: u32 = ((x148 as u32) + x144);
  let mut x150: u32 = 0;
  let mut x151: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x150, &mut x151, 0x0, x142, x139);
  let mut x152: u32 = 0;
  let mut x153: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x152, &mut x153, x151, x140, x137);
  let mut x154: u32 = 0;
  let mut x155: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x154, &mut x155, x153, x138, x135);
  let mut x156: u32 = 0;
  let mut x157: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x156, &mut x157, x155, x136, x133);
  let x158: u32 = ((x157 as u32) + x134);
  let mut x159: u32 = 0;
  let mut x160: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x159, &mut x160, 0x0, x115, x145);
  let mut x161: u32 = 0;
  let mut x162: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x161, &mut x162, x160, x117, x147);
  let mut x163: u32 = 0;
  let mut x164: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x163, &mut x164, x162, x119, x149);
  let mut x165: u32 = 0;
  let mut x166: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x165, &mut x166, x164, x121, x141);
  let mut x167: u32 = 0;
  let mut x168: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x167, &mut x168, x166, x123, x150);
  let mut x169: u32 = 0;
  let mut x170: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x169, &mut x170, x168, x125, x152);
  let mut x171: u32 = 0;
  let mut x172: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x171, &mut x172, x170, x127, x154);
  let mut x173: u32 = 0;
  let mut x174: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x173, &mut x174, x172, x129, x156);
  let mut x175: u32 = 0;
  let mut x176: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x175, &mut x176, x174, x131, x158);
  let x177: u32 = ((x176 as u32) + (x132 as u32));
  let mut x178: u32 = 0;
  let mut x179: u32 = 0;
  fiat_sm2_mulx_u32(&mut x178, &mut x179, x2, (*IndexConst(arg2).index(7)));
  let mut x180: u32 = 0;
  let mut x181: u32 = 0;
  fiat_sm2_mulx_u32(&mut x180, &mut x181, x2, (*IndexConst(arg2).index(6)));
  let mut x182: u32 = 0;
  let mut x183: u32 = 0;
  fiat_sm2_mulx_u32(&mut x182, &mut x183, x2, (*IndexConst(arg2).index(5)));
  let mut x184: u32 = 0;
  let mut x185: u32 = 0;
  fiat_sm2_mulx_u32(&mut x184, &mut x185, x2, (*IndexConst(arg2).index(4)));
  let mut x186: u32 = 0;
  let mut x187: u32 = 0;
  fiat_sm2_mulx_u32(&mut x186, &mut x187, x2, (*IndexConst(arg2).index(3)));
  let mut x188: u32 = 0;
  let mut x189: u32 = 0;
  fiat_sm2_mulx_u32(&mut x188, &mut x189, x2, (*IndexConst(arg2).index(2)));
  let mut x190: u32 = 0;
  let mut x191: u32 = 0;
  fiat_sm2_mulx_u32(&mut x190, &mut x191, x2, (*IndexConst(arg2).index(1)));
  let mut x192: u32 = 0;
  let mut x193: u32 = 0;
  fiat_sm2_mulx_u32(&mut x192, &mut x193, x2, (*IndexConst(arg2).index(0)));
  let mut x194: u32 = 0;
  let mut x195: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x194, &mut x195, 0x0, x193, x190);
  let mut x196: u32 = 0;
  let mut x197: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x196, &mut x197, x195, x191, x188);
  let mut x198: u32 = 0;
  let mut x199: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x198, &mut x199, x197, x189, x186);
  let mut x200: u32 = 0;
  let mut x201: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x200, &mut x201, x199, x187, x184);
  let mut x202: u32 = 0;
  let mut x203: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x202, &mut x203, x201, x185, x182);
  let mut x204: u32 = 0;
  let mut x205: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x204, &mut x205, x203, x183, x180);
  let mut x206: u32 = 0;
  let mut x207: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x206, &mut x207, x205, x181, x178);
  let x208: u32 = ((x207 as u32) + x179);
  let mut x209: u32 = 0;
  let mut x210: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x209, &mut x210, 0x0, x161, x192);
  let mut x211: u32 = 0;
  let mut x212: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x211, &mut x212, x210, x163, x194);
  let mut x213: u32 = 0;
  let mut x214: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x213, &mut x214, x212, x165, x196);
  let mut x215: u32 = 0;
  let mut x216: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x215, &mut x216, x214, x167, x198);
  let mut x217: u32 = 0;
  let mut x218: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x217, &mut x218, x216, x169, x200);
  let mut x219: u32 = 0;
  let mut x220: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x219, &mut x220, x218, x171, x202);
  let mut x221: u32 = 0;
  let mut x222: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x221, &mut x222, x220, x173, x204);
  let mut x223: u32 = 0;
  let mut x224: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x223, &mut x224, x222, x175, x206);
  let mut x225: u32 = 0;
  let mut x226: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x225, &mut x226, x224, x177, x208);
  let mut x227: u32 = 0;
  let mut x228: u32 = 0;
  fiat_sm2_mulx_u32(&mut x227, &mut x228, x209, 0xfffffffe);
  let mut x229: u32 = 0;
  let mut x230: u32 = 0;
  fiat_sm2_mulx_u32(&mut x229, &mut x230, x209, 0xffffffff);
  let mut x231: u32 = 0;
  let mut x232: u32 = 0;
  fiat_sm2_mulx_u32(&mut x231, &mut x232, x209, 0xffffffff);
  let mut x233: u32 = 0;
  let mut x234: u32 = 0;
  fiat_sm2_mulx_u32(&mut x233, &mut x234, x209, 0xffffffff);
  let mut x235: u32 = 0;
  let mut x236: u32 = 0;
  fiat_sm2_mulx_u32(&mut x235, &mut x236, x209, 0xffffffff);
  let mut x237: u32 = 0;
  let mut x238: u32 = 0;
  fiat_sm2_mulx_u32(&mut x237, &mut x238, x209, 0xffffffff);
  let mut x239: u32 = 0;
  let mut x240: u32 = 0;
  fiat_sm2_mulx_u32(&mut x239, &mut x240, x209, 0xffffffff);
  let mut x241: u32 = 0;
  let mut x242: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x241, &mut x242, 0x0, x240, x237);
  let x243: u32 = ((x242 as u32) + x238);
  let mut x244: u32 = 0;
  let mut x245: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x244, &mut x245, 0x0, x236, x233);
  let mut x246: u32 = 0;
  let mut x247: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x246, &mut x247, x245, x234, x231);
  let mut x248: u32 = 0;
  let mut x249: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x248, &mut x249, x247, x232, x229);
  let mut x250: u32 = 0;
  let mut x251: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x250, &mut x251, x249, x230, x227);
  let x252: u32 = ((x251 as u32) + x228);
  let mut x253: u32 = 0;
  let mut x254: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x253, &mut x254, 0x0, x209, x239);
  let mut x255: u32 = 0;
  let mut x256: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x255, &mut x256, x254, x211, x241);
  let mut x257: u32 = 0;
  let mut x258: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x257, &mut x258, x256, x213, x243);
  let mut x259: u32 = 0;
  let mut x260: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x259, &mut x260, x258, x215, x235);
  let mut x261: u32 = 0;
  let mut x262: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x261, &mut x262, x260, x217, x244);
  let mut x263: u32 = 0;
  let mut x264: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x263, &mut x264, x262, x219, x246);
  let mut x265: u32 = 0;
  let mut x266: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x265, &mut x266, x264, x221, x248);
  let mut x267: u32 = 0;
  let mut x268: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x267, &mut x268, x266, x223, x250);
  let mut x269: u32 = 0;
  let mut x270: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x269, &mut x270, x268, x225, x252);
  let x271: u32 = ((x270 as u32) + (x226 as u32));
  let mut x272: u32 = 0;
  let mut x273: u32 = 0;
  fiat_sm2_mulx_u32(&mut x272, &mut x273, x3, (*IndexConst(arg2).index(7)));
  let mut x274: u32 = 0;
  let mut x275: u32 = 0;
  fiat_sm2_mulx_u32(&mut x274, &mut x275, x3, (*IndexConst(arg2).index(6)));
  let mut x276: u32 = 0;
  let mut x277: u32 = 0;
  fiat_sm2_mulx_u32(&mut x276, &mut x277, x3, (*IndexConst(arg2).index(5)));
  let mut x278: u32 = 0;
  let mut x279: u32 = 0;
  fiat_sm2_mulx_u32(&mut x278, &mut x279, x3, (*IndexConst(arg2).index(4)));
  let mut x280: u32 = 0;
  let mut x281: u32 = 0;
  fiat_sm2_mulx_u32(&mut x280, &mut x281, x3, (*IndexConst(arg2).index(3)));
  let mut x282: u32 = 0;
  let mut x283: u32 = 0;
  fiat_sm2_mulx_u32(&mut x282, &mut x283, x3, (*IndexConst(arg2).index(2)));
  let mut x284: u32 = 0;
  let mut x285: u32 = 0;
  fiat_sm2_mulx_u32(&mut x284, &mut x285, x3, (*IndexConst(arg2).index(1)));
  let mut x286: u32 = 0;
  let mut x287: u32 = 0;
  fiat_sm2_mulx_u32(&mut x286, &mut x287, x3, (*IndexConst(arg2).index(0)));
  let mut x288: u32 = 0;
  let mut x289: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x288, &mut x289, 0x0, x287, x284);
  let mut x290: u32 = 0;
  let mut x291: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x290, &mut x291, x289, x285, x282);
  let mut x292: u32 = 0;
  let mut x293: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x292, &mut x293, x291, x283, x280);
  let mut x294: u32 = 0;
  let mut x295: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x294, &mut x295, x293, x281, x278);
  let mut x296: u32 = 0;
  let mut x297: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x296, &mut x297, x295, x279, x276);
  let mut x298: u32 = 0;
  let mut x299: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x298, &mut x299, x297, x277, x274);
  let mut x300: u32 = 0;
  let mut x301: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x300, &mut x301, x299, x275, x272);
  let x302: u32 = ((x301 as u32) + x273);
  let mut x303: u32 = 0;
  let mut x304: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x303, &mut x304, 0x0, x255, x286);
  let mut x305: u32 = 0;
  let mut x306: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x305, &mut x306, x304, x257, x288);
  let mut x307: u32 = 0;
  let mut x308: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x307, &mut x308, x306, x259, x290);
  let mut x309: u32 = 0;
  let mut x310: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x309, &mut x310, x308, x261, x292);
  let mut x311: u32 = 0;
  let mut x312: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x311, &mut x312, x310, x263, x294);
  let mut x313: u32 = 0;
  let mut x314: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x313, &mut x314, x312, x265, x296);
  let mut x315: u32 = 0;
  let mut x316: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x315, &mut x316, x314, x267, x298);
  let mut x317: u32 = 0;
  let mut x318: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x317, &mut x318, x316, x269, x300);
  let mut x319: u32 = 0;
  let mut x320: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x319, &mut x320, x318, x271, x302);
  let mut x321: u32 = 0;
  let mut x322: u32 = 0;
  fiat_sm2_mulx_u32(&mut x321, &mut x322, x303, 0xfffffffe);
  let mut x323: u32 = 0;
  let mut x324: u32 = 0;
  fiat_sm2_mulx_u32(&mut x323, &mut x324, x303, 0xffffffff);
  let mut x325: u32 = 0;
  let mut x326: u32 = 0;
  fiat_sm2_mulx_u32(&mut x325, &mut x326, x303, 0xffffffff);
  let mut x327: u32 = 0;
  let mut x328: u32 = 0;
  fiat_sm2_mulx_u32(&mut x327, &mut x328, x303, 0xffffffff);
  let mut x329: u32 = 0;
  let mut x330: u32 = 0;
  fiat_sm2_mulx_u32(&mut x329, &mut x330, x303, 0xffffffff);
  let mut x331: u32 = 0;
  let mut x332: u32 = 0;
  fiat_sm2_mulx_u32(&mut x331, &mut x332, x303, 0xffffffff);
  let mut x333: u32 = 0;
  let mut x334: u32 = 0;
  fiat_sm2_mulx_u32(&mut x333, &mut x334, x303, 0xffffffff);
  let mut x335: u32 = 0;
  let mut x336: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x335, &mut x336, 0x0, x334, x331);
  let x337: u32 = ((x336 as u32) + x332);
  let mut x338: u32 = 0;
  let mut x339: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x338, &mut x339, 0x0, x330, x327);
  let mut x340: u32 = 0;
  let mut x341: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x340, &mut x341, x339, x328, x325);
  let mut x342: u32 = 0;
  let mut x343: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x342, &mut x343, x341, x326, x323);
  let mut x344: u32 = 0;
  let mut x345: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x344, &mut x345, x343, x324, x321);
  let x346: u32 = ((x345 as u32) + x322);
  let mut x347: u32 = 0;
  let mut x348: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x347, &mut x348, 0x0, x303, x333);
  let mut x349: u32 = 0;
  let mut x350: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x349, &mut x350, x348, x305, x335);
  let mut x351: u32 = 0;
  let mut x352: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x351, &mut x352, x350, x307, x337);
  let mut x353: u32 = 0;
  let mut x354: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x353, &mut x354, x352, x309, x329);
  let mut x355: u32 = 0;
  let mut x356: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x355, &mut x356, x354, x311, x338);
  let mut x357: u32 = 0;
  let mut x358: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x357, &mut x358, x356, x313, x340);
  let mut x359: u32 = 0;
  let mut x360: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x359, &mut x360, x358, x315, x342);
  let mut x361: u32 = 0;
  let mut x362: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x361, &mut x362, x360, x317, x344);
  let mut x363: u32 = 0;
  let mut x364: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x363, &mut x364, x362, x319, x346);
  let x365: u32 = ((x364 as u32) + (x320 as u32));
  let mut x366: u32 = 0;
  let mut x367: u32 = 0;
  fiat_sm2_mulx_u32(&mut x366, &mut x367, x4, (*IndexConst(arg2).index(7)));
  let mut x368: u32 = 0;
  let mut x369: u32 = 0;
  fiat_sm2_mulx_u32(&mut x368, &mut x369, x4, (*IndexConst(arg2).index(6)));
  let mut x370: u32 = 0;
  let mut x371: u32 = 0;
  fiat_sm2_mulx_u32(&mut x370, &mut x371, x4, (*IndexConst(arg2).index(5)));
  let mut x372: u32 = 0;
  let mut x373: u32 = 0;
  fiat_sm2_mulx_u32(&mut x372, &mut x373, x4, (*IndexConst(arg2).index(4)));
  let mut x374: u32 = 0;
  let mut x375: u32 = 0;
  fiat_sm2_mulx_u32(&mut x374, &mut x375, x4, (*IndexConst(arg2).index(3)));
  let mut x376: u32 = 0;
  let mut x377: u32 = 0;
  fiat_sm2_mulx_u32(&mut x376, &mut x377, x4, (*IndexConst(arg2).index(2)));
  let mut x378: u32 = 0;
  let mut x379: u32 = 0;
  fiat_sm2_mulx_u32(&mut x378, &mut x379, x4, (*IndexConst(arg2).index(1)));
  let mut x380: u32 = 0;
  let mut x381: u32 = 0;
  fiat_sm2_mulx_u32(&mut x380, &mut x381, x4, (*IndexConst(arg2).index(0)));
  let mut x382: u32 = 0;
  let mut x383: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x382, &mut x383, 0x0, x381, x378);
  let mut x384: u32 = 0;
  let mut x385: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x384, &mut x385, x383, x379, x376);
  let mut x386: u32 = 0;
  let mut x387: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x386, &mut x387, x385, x377, x374);
  let mut x388: u32 = 0;
  let mut x389: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x388, &mut x389, x387, x375, x372);
  let mut x390: u32 = 0;
  let mut x391: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x390, &mut x391, x389, x373, x370);
  let mut x392: u32 = 0;
  let mut x393: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x392, &mut x393, x391, x371, x368);
  let mut x394: u32 = 0;
  let mut x395: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x394, &mut x395, x393, x369, x366);
  let x396: u32 = ((x395 as u32) + x367);
  let mut x397: u32 = 0;
  let mut x398: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x397, &mut x398, 0x0, x349, x380);
  let mut x399: u32 = 0;
  let mut x400: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x399, &mut x400, x398, x351, x382);
  let mut x401: u32 = 0;
  let mut x402: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x401, &mut x402, x400, x353, x384);
  let mut x403: u32 = 0;
  let mut x404: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x403, &mut x404, x402, x355, x386);
  let mut x405: u32 = 0;
  let mut x406: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x405, &mut x406, x404, x357, x388);
  let mut x407: u32 = 0;
  let mut x408: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x407, &mut x408, x406, x359, x390);
  let mut x409: u32 = 0;
  let mut x410: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x409, &mut x410, x408, x361, x392);
  let mut x411: u32 = 0;
  let mut x412: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x411, &mut x412, x410, x363, x394);
  let mut x413: u32 = 0;
  let mut x414: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x413, &mut x414, x412, x365, x396);
  let mut x415: u32 = 0;
  let mut x416: u32 = 0;
  fiat_sm2_mulx_u32(&mut x415, &mut x416, x397, 0xfffffffe);
  let mut x417: u32 = 0;
  let mut x418: u32 = 0;
  fiat_sm2_mulx_u32(&mut x417, &mut x418, x397, 0xffffffff);
  let mut x419: u32 = 0;
  let mut x420: u32 = 0;
  fiat_sm2_mulx_u32(&mut x419, &mut x420, x397, 0xffffffff);
  let mut x421: u32 = 0;
  let mut x422: u32 = 0;
  fiat_sm2_mulx_u32(&mut x421, &mut x422, x397, 0xffffffff);
  let mut x423: u32 = 0;
  let mut x424: u32 = 0;
  fiat_sm2_mulx_u32(&mut x423, &mut x424, x397, 0xffffffff);
  let mut x425: u32 = 0;
  let mut x426: u32 = 0;
  fiat_sm2_mulx_u32(&mut x425, &mut x426, x397, 0xffffffff);
  let mut x427: u32 = 0;
  let mut x428: u32 = 0;
  fiat_sm2_mulx_u32(&mut x427, &mut x428, x397, 0xffffffff);
  let mut x429: u32 = 0;
  let mut x430: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x429, &mut x430, 0x0, x428, x425);
  let x431: u32 = ((x430 as u32) + x426);
  let mut x432: u32 = 0;
  let mut x433: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x432, &mut x433, 0x0, x424, x421);
  let mut x434: u32 = 0;
  let mut x435: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x434, &mut x435, x433, x422, x419);
  let mut x436: u32 = 0;
  let mut x437: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x436, &mut x437, x435, x420, x417);
  let mut x438: u32 = 0;
  let mut x439: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x438, &mut x439, x437, x418, x415);
  let x440: u32 = ((x439 as u32) + x416);
  let mut x441: u32 = 0;
  let mut x442: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x441, &mut x442, 0x0, x397, x427);
  let mut x443: u32 = 0;
  let mut x444: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x443, &mut x444, x442, x399, x429);
  let mut x445: u32 = 0;
  let mut x446: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x445, &mut x446, x444, x401, x431);
  let mut x447: u32 = 0;
  let mut x448: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x447, &mut x448, x446, x403, x423);
  let mut x449: u32 = 0;
  let mut x450: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x449, &mut x450, x448, x405, x432);
  let mut x451: u32 = 0;
  let mut x452: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x451, &mut x452, x450, x407, x434);
  let mut x453: u32 = 0;
  let mut x454: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x453, &mut x454, x452, x409, x436);
  let mut x455: u32 = 0;
  let mut x456: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x455, &mut x456, x454, x411, x438);
  let mut x457: u32 = 0;
  let mut x458: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x457, &mut x458, x456, x413, x440);
  let x459: u32 = ((x458 as u32) + (x414 as u32));
  let mut x460: u32 = 0;
  let mut x461: u32 = 0;
  fiat_sm2_mulx_u32(&mut x460, &mut x461, x5, (*IndexConst(arg2).index(7)));
  let mut x462: u32 = 0;
  let mut x463: u32 = 0;
  fiat_sm2_mulx_u32(&mut x462, &mut x463, x5, (*IndexConst(arg2).index(6)));
  let mut x464: u32 = 0;
  let mut x465: u32 = 0;
  fiat_sm2_mulx_u32(&mut x464, &mut x465, x5, (*IndexConst(arg2).index(5)));
  let mut x466: u32 = 0;
  let mut x467: u32 = 0;
  fiat_sm2_mulx_u32(&mut x466, &mut x467, x5, (*IndexConst(arg2).index(4)));
  let mut x468: u32 = 0;
  let mut x469: u32 = 0;
  fiat_sm2_mulx_u32(&mut x468, &mut x469, x5, (*IndexConst(arg2).index(3)));
  let mut x470: u32 = 0;
  let mut x471: u32 = 0;
  fiat_sm2_mulx_u32(&mut x470, &mut x471, x5, (*IndexConst(arg2).index(2)));
  let mut x472: u32 = 0;
  let mut x473: u32 = 0;
  fiat_sm2_mulx_u32(&mut x472, &mut x473, x5, (*IndexConst(arg2).index(1)));
  let mut x474: u32 = 0;
  let mut x475: u32 = 0;
  fiat_sm2_mulx_u32(&mut x474, &mut x475, x5, (*IndexConst(arg2).index(0)));
  let mut x476: u32 = 0;
  let mut x477: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x476, &mut x477, 0x0, x475, x472);
  let mut x478: u32 = 0;
  let mut x479: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x478, &mut x479, x477, x473, x470);
  let mut x480: u32 = 0;
  let mut x481: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x480, &mut x481, x479, x471, x468);
  let mut x482: u32 = 0;
  let mut x483: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x482, &mut x483, x481, x469, x466);
  let mut x484: u32 = 0;
  let mut x485: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x484, &mut x485, x483, x467, x464);
  let mut x486: u32 = 0;
  let mut x487: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x486, &mut x487, x485, x465, x462);
  let mut x488: u32 = 0;
  let mut x489: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x488, &mut x489, x487, x463, x460);
  let x490: u32 = ((x489 as u32) + x461);
  let mut x491: u32 = 0;
  let mut x492: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x491, &mut x492, 0x0, x443, x474);
  let mut x493: u32 = 0;
  let mut x494: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x493, &mut x494, x492, x445, x476);
  let mut x495: u32 = 0;
  let mut x496: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x495, &mut x496, x494, x447, x478);
  let mut x497: u32 = 0;
  let mut x498: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x497, &mut x498, x496, x449, x480);
  let mut x499: u32 = 0;
  let mut x500: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x499, &mut x500, x498, x451, x482);
  let mut x501: u32 = 0;
  let mut x502: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x501, &mut x502, x500, x453, x484);
  let mut x503: u32 = 0;
  let mut x504: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x503, &mut x504, x502, x455, x486);
  let mut x505: u32 = 0;
  let mut x506: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x505, &mut x506, x504, x457, x488);
  let mut x507: u32 = 0;
  let mut x508: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x507, &mut x508, x506, x459, x490);
  let mut x509: u32 = 0;
  let mut x510: u32 = 0;
  fiat_sm2_mulx_u32(&mut x509, &mut x510, x491, 0xfffffffe);
  let mut x511: u32 = 0;
  let mut x512: u32 = 0;
  fiat_sm2_mulx_u32(&mut x511, &mut x512, x491, 0xffffffff);
  let mut x513: u32 = 0;
  let mut x514: u32 = 0;
  fiat_sm2_mulx_u32(&mut x513, &mut x514, x491, 0xffffffff);
  let mut x515: u32 = 0;
  let mut x516: u32 = 0;
  fiat_sm2_mulx_u32(&mut x515, &mut x516, x491, 0xffffffff);
  let mut x517: u32 = 0;
  let mut x518: u32 = 0;
  fiat_sm2_mulx_u32(&mut x517, &mut x518, x491, 0xffffffff);
  let mut x519: u32 = 0;
  let mut x520: u32 = 0;
  fiat_sm2_mulx_u32(&mut x519, &mut x520, x491, 0xffffffff);
  let mut x521: u32 = 0;
  let mut x522: u32 = 0;
  fiat_sm2_mulx_u32(&mut x521, &mut x522, x491, 0xffffffff);
  let mut x523: u32 = 0;
  let mut x524: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x523, &mut x524, 0x0, x522, x519);
  let x525: u32 = ((x524 as u32) + x520);
  let mut x526: u32 = 0;
  let mut x527: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x526, &mut x527, 0x0, x518, x515);
  let mut x528: u32 = 0;
  let mut x529: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x528, &mut x529, x527, x516, x513);
  let mut x530: u32 = 0;
  let mut x531: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x530, &mut x531, x529, x514, x511);
  let mut x532: u32 = 0;
  let mut x533: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x532, &mut x533, x531, x512, x509);
  let x534: u32 = ((x533 as u32) + x510);
  let mut x535: u32 = 0;
  let mut x536: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x535, &mut x536, 0x0, x491, x521);
  let mut x537: u32 = 0;
  let mut x538: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x537, &mut x538, x536, x493, x523);
  let mut x539: u32 = 0;
  let mut x540: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x539, &mut x540, x538, x495, x525);
  let mut x541: u32 = 0;
  let mut x542: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x541, &mut x542, x540, x497, x517);
  let mut x543: u32 = 0;
  let mut x544: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x543, &mut x544, x542, x499, x526);
  let mut x545: u32 = 0;
  let mut x546: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x545, &mut x546, x544, x501, x528);
  let mut x547: u32 = 0;
  let mut x548: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x547, &mut x548, x546, x503, x530);
  let mut x549: u32 = 0;
  let mut x550: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x549, &mut x550, x548, x505, x532);
  let mut x551: u32 = 0;
  let mut x552: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x551, &mut x552, x550, x507, x534);
  let x553: u32 = ((x552 as u32) + (x508 as u32));
  let mut x554: u32 = 0;
  let mut x555: u32 = 0;
  fiat_sm2_mulx_u32(&mut x554, &mut x555, x6, (*IndexConst(arg2).index(7)));
  let mut x556: u32 = 0;
  let mut x557: u32 = 0;
  fiat_sm2_mulx_u32(&mut x556, &mut x557, x6, (*IndexConst(arg2).index(6)));
  let mut x558: u32 = 0;
  let mut x559: u32 = 0;
  fiat_sm2_mulx_u32(&mut x558, &mut x559, x6, (*IndexConst(arg2).index(5)));
  let mut x560: u32 = 0;
  let mut x561: u32 = 0;
  fiat_sm2_mulx_u32(&mut x560, &mut x561, x6, (*IndexConst(arg2).index(4)));
  let mut x562: u32 = 0;
  let mut x563: u32 = 0;
  fiat_sm2_mulx_u32(&mut x562, &mut x563, x6, (*IndexConst(arg2).index(3)));
  let mut x564: u32 = 0;
  let mut x565: u32 = 0;
  fiat_sm2_mulx_u32(&mut x564, &mut x565, x6, (*IndexConst(arg2).index(2)));
  let mut x566: u32 = 0;
  let mut x567: u32 = 0;
  fiat_sm2_mulx_u32(&mut x566, &mut x567, x6, (*IndexConst(arg2).index(1)));
  let mut x568: u32 = 0;
  let mut x569: u32 = 0;
  fiat_sm2_mulx_u32(&mut x568, &mut x569, x6, (*IndexConst(arg2).index(0)));
  let mut x570: u32 = 0;
  let mut x571: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x570, &mut x571, 0x0, x569, x566);
  let mut x572: u32 = 0;
  let mut x573: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x572, &mut x573, x571, x567, x564);
  let mut x574: u32 = 0;
  let mut x575: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x574, &mut x575, x573, x565, x562);
  let mut x576: u32 = 0;
  let mut x577: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x576, &mut x577, x575, x563, x560);
  let mut x578: u32 = 0;
  let mut x579: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x578, &mut x579, x577, x561, x558);
  let mut x580: u32 = 0;
  let mut x581: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x580, &mut x581, x579, x559, x556);
  let mut x582: u32 = 0;
  let mut x583: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x582, &mut x583, x581, x557, x554);
  let x584: u32 = ((x583 as u32) + x555);
  let mut x585: u32 = 0;
  let mut x586: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x585, &mut x586, 0x0, x537, x568);
  let mut x587: u32 = 0;
  let mut x588: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x587, &mut x588, x586, x539, x570);
  let mut x589: u32 = 0;
  let mut x590: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x589, &mut x590, x588, x541, x572);
  let mut x591: u32 = 0;
  let mut x592: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x591, &mut x592, x590, x543, x574);
  let mut x593: u32 = 0;
  let mut x594: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x593, &mut x594, x592, x545, x576);
  let mut x595: u32 = 0;
  let mut x596: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x595, &mut x596, x594, x547, x578);
  let mut x597: u32 = 0;
  let mut x598: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x597, &mut x598, x596, x549, x580);
  let mut x599: u32 = 0;
  let mut x600: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x599, &mut x600, x598, x551, x582);
  let mut x601: u32 = 0;
  let mut x602: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x601, &mut x602, x600, x553, x584);
  let mut x603: u32 = 0;
  let mut x604: u32 = 0;
  fiat_sm2_mulx_u32(&mut x603, &mut x604, x585, 0xfffffffe);
  let mut x605: u32 = 0;
  let mut x606: u32 = 0;
  fiat_sm2_mulx_u32(&mut x605, &mut x606, x585, 0xffffffff);
  let mut x607: u32 = 0;
  let mut x608: u32 = 0;
  fiat_sm2_mulx_u32(&mut x607, &mut x608, x585, 0xffffffff);
  let mut x609: u32 = 0;
  let mut x610: u32 = 0;
  fiat_sm2_mulx_u32(&mut x609, &mut x610, x585, 0xffffffff);
  let mut x611: u32 = 0;
  let mut x612: u32 = 0;
  fiat_sm2_mulx_u32(&mut x611, &mut x612, x585, 0xffffffff);
  let mut x613: u32 = 0;
  let mut x614: u32 = 0;
  fiat_sm2_mulx_u32(&mut x613, &mut x614, x585, 0xffffffff);
  let mut x615: u32 = 0;
  let mut x616: u32 = 0;
  fiat_sm2_mulx_u32(&mut x615, &mut x616, x585, 0xffffffff);
  let mut x617: u32 = 0;
  let mut x618: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x617, &mut x618, 0x0, x616, x613);
  let x619: u32 = ((x618 as u32) + x614);
  let mut x620: u32 = 0;
  let mut x621: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x620, &mut x621, 0x0, x612, x609);
  let mut x622: u32 = 0;
  let mut x623: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x622, &mut x623, x621, x610, x607);
  let mut x624: u32 = 0;
  let mut x625: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x624, &mut x625, x623, x608, x605);
  let mut x626: u32 = 0;
  let mut x627: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x626, &mut x627, x625, x606, x603);
  let x628: u32 = ((x627 as u32) + x604);
  let mut x629: u32 = 0;
  let mut x630: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x629, &mut x630, 0x0, x585, x615);
  let mut x631: u32 = 0;
  let mut x632: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x631, &mut x632, x630, x587, x617);
  let mut x633: u32 = 0;
  let mut x634: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x633, &mut x634, x632, x589, x619);
  let mut x635: u32 = 0;
  let mut x636: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x635, &mut x636, x634, x591, x611);
  let mut x637: u32 = 0;
  let mut x638: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x637, &mut x638, x636, x593, x620);
  let mut x639: u32 = 0;
  let mut x640: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x639, &mut x640, x638, x595, x622);
  let mut x641: u32 = 0;
  let mut x642: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x641, &mut x642, x640, x597, x624);
  let mut x643: u32 = 0;
  let mut x644: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x643, &mut x644, x642, x599, x626);
  let mut x645: u32 = 0;
  let mut x646: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x645, &mut x646, x644, x601, x628);
  let x647: u32 = ((x646 as u32) + (x602 as u32));
  let mut x648: u32 = 0;
  let mut x649: u32 = 0;
  fiat_sm2_mulx_u32(&mut x648, &mut x649, x7, (*IndexConst(arg2).index(7)));
  let mut x650: u32 = 0;
  let mut x651: u32 = 0;
  fiat_sm2_mulx_u32(&mut x650, &mut x651, x7, (*IndexConst(arg2).index(6)));
  let mut x652: u32 = 0;
  let mut x653: u32 = 0;
  fiat_sm2_mulx_u32(&mut x652, &mut x653, x7, (*IndexConst(arg2).index(5)));
  let mut x654: u32 = 0;
  let mut x655: u32 = 0;
  fiat_sm2_mulx_u32(&mut x654, &mut x655, x7, (*IndexConst(arg2).index(4)));
  let mut x656: u32 = 0;
  let mut x657: u32 = 0;
  fiat_sm2_mulx_u32(&mut x656, &mut x657, x7, (*IndexConst(arg2).index(3)));
  let mut x658: u32 = 0;
  let mut x659: u32 = 0;
  fiat_sm2_mulx_u32(&mut x658, &mut x659, x7, (*IndexConst(arg2).index(2)));
  let mut x660: u32 = 0;
  let mut x661: u32 = 0;
  fiat_sm2_mulx_u32(&mut x660, &mut x661, x7, (*IndexConst(arg2).index(1)));
  let mut x662: u32 = 0;
  let mut x663: u32 = 0;
  fiat_sm2_mulx_u32(&mut x662, &mut x663, x7, (*IndexConst(arg2).index(0)));
  let mut x664: u32 = 0;
  let mut x665: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x664, &mut x665, 0x0, x663, x660);
  let mut x666: u32 = 0;
  let mut x667: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x666, &mut x667, x665, x661, x658);
  let mut x668: u32 = 0;
  let mut x669: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x668, &mut x669, x667, x659, x656);
  let mut x670: u32 = 0;
  let mut x671: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x670, &mut x671, x669, x657, x654);
  let mut x672: u32 = 0;
  let mut x673: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x672, &mut x673, x671, x655, x652);
  let mut x674: u32 = 0;
  let mut x675: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x674, &mut x675, x673, x653, x650);
  let mut x676: u32 = 0;
  let mut x677: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x676, &mut x677, x675, x651, x648);
  let x678: u32 = ((x677 as u32) + x649);
  let mut x679: u32 = 0;
  let mut x680: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x679, &mut x680, 0x0, x631, x662);
  let mut x681: u32 = 0;
  let mut x682: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x681, &mut x682, x680, x633, x664);
  let mut x683: u32 = 0;
  let mut x684: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x683, &mut x684, x682, x635, x666);
  let mut x685: u32 = 0;
  let mut x686: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x685, &mut x686, x684, x637, x668);
  let mut x687: u32 = 0;
  let mut x688: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x687, &mut x688, x686, x639, x670);
  let mut x689: u32 = 0;
  let mut x690: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x689, &mut x690, x688, x641, x672);
  let mut x691: u32 = 0;
  let mut x692: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x691, &mut x692, x690, x643, x674);
  let mut x693: u32 = 0;
  let mut x694: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x693, &mut x694, x692, x645, x676);
  let mut x695: u32 = 0;
  let mut x696: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x695, &mut x696, x694, x647, x678);
  let mut x697: u32 = 0;
  let mut x698: u32 = 0;
  fiat_sm2_mulx_u32(&mut x697, &mut x698, x679, 0xfffffffe);
  let mut x699: u32 = 0;
  let mut x700: u32 = 0;
  fiat_sm2_mulx_u32(&mut x699, &mut x700, x679, 0xffffffff);
  let mut x701: u32 = 0;
  let mut x702: u32 = 0;
  fiat_sm2_mulx_u32(&mut x701, &mut x702, x679, 0xffffffff);
  let mut x703: u32 = 0;
  let mut x704: u32 = 0;
  fiat_sm2_mulx_u32(&mut x703, &mut x704, x679, 0xffffffff);
  let mut x705: u32 = 0;
  let mut x706: u32 = 0;
  fiat_sm2_mulx_u32(&mut x705, &mut x706, x679, 0xffffffff);
  let mut x707: u32 = 0;
  let mut x708: u32 = 0;
  fiat_sm2_mulx_u32(&mut x707, &mut x708, x679, 0xffffffff);
  let mut x709: u32 = 0;
  let mut x710: u32 = 0;
  fiat_sm2_mulx_u32(&mut x709, &mut x710, x679, 0xffffffff);
  let mut x711: u32 = 0;
  let mut x712: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x711, &mut x712, 0x0, x710, x707);
  let x713: u32 = ((x712 as u32) + x708);
  let mut x714: u32 = 0;
  let mut x715: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x714, &mut x715, 0x0, x706, x703);
  let mut x716: u32 = 0;
  let mut x717: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x716, &mut x717, x715, x704, x701);
  let mut x718: u32 = 0;
  let mut x719: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x718, &mut x719, x717, x702, x699);
  let mut x720: u32 = 0;
  let mut x721: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x720, &mut x721, x719, x700, x697);
  let x722: u32 = ((x721 as u32) + x698);
  let mut x723: u32 = 0;
  let mut x724: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x723, &mut x724, 0x0, x679, x709);
  let mut x725: u32 = 0;
  let mut x726: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x725, &mut x726, x724, x681, x711);
  let mut x727: u32 = 0;
  let mut x728: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x727, &mut x728, x726, x683, x713);
  let mut x729: u32 = 0;
  let mut x730: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x729, &mut x730, x728, x685, x705);
  let mut x731: u32 = 0;
  let mut x732: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x731, &mut x732, x730, x687, x714);
  let mut x733: u32 = 0;
  let mut x734: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x733, &mut x734, x732, x689, x716);
  let mut x735: u32 = 0;
  let mut x736: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x735, &mut x736, x734, x691, x718);
  let mut x737: u32 = 0;
  let mut x738: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x737, &mut x738, x736, x693, x720);
  let mut x739: u32 = 0;
  let mut x740: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x739, &mut x740, x738, x695, x722);
  let x741: u32 = ((x740 as u32) + (x696 as u32));
  let mut x742: u32 = 0;
  let mut x743: fiat_sm2_u1 = 0;
  fiat_sm2_subborrowx_u32(&mut x742, &mut x743, 0x0, x725, 0xffffffff);
  let mut x744: u32 = 0;
  let mut x745: fiat_sm2_u1 = 0;
  fiat_sm2_subborrowx_u32(&mut x744, &mut x745, x743, x727, 0xffffffff);
  let mut x746: u32 = 0;
  let mut x747: fiat_sm2_u1 = 0;
  fiat_sm2_subborrowx_u32(&mut x746, &mut x747, x745, x729, (0x0 as u32));
  let mut x748: u32 = 0;
  let mut x749: fiat_sm2_u1 = 0;
  fiat_sm2_subborrowx_u32(&mut x748, &mut x749, x747, x731, 0xffffffff);
  let mut x750: u32 = 0;
  let mut x751: fiat_sm2_u1 = 0;
  fiat_sm2_subborrowx_u32(&mut x750, &mut x751, x749, x733, 0xffffffff);
  let mut x752: u32 = 0;
  let mut x753: fiat_sm2_u1 = 0;
  fiat_sm2_subborrowx_u32(&mut x752, &mut x753, x751, x735, 0xffffffff);
  let mut x754: u32 = 0;
  let mut x755: fiat_sm2_u1 = 0;
  fiat_sm2_subborrowx_u32(&mut x754, &mut x755, x753, x737, 0xffffffff);
  let mut x756: u32 = 0;
  let mut x757: fiat_sm2_u1 = 0;
  fiat_sm2_subborrowx_u32(&mut x756, &mut x757, x755, x739, 0xfffffffe);
  let mut x758: u32 = 0;
  let mut x759: fiat_sm2_u1 = 0;
  fiat_sm2_subborrowx_u32(&mut x758, &mut x759, x757, x741, (0x0 as u32));
  let mut x760: u32 = 0;
  fiat_sm2_cmovznz_u32(&mut x760, x759, x742, x725);
  let mut x761: u32 = 0;
  fiat_sm2_cmovznz_u32(&mut x761, x759, x744, x727);
  let mut x762: u32 = 0;
  fiat_sm2_cmovznz_u32(&mut x762, x759, x746, x729);
  let mut x763: u32 = 0;
  fiat_sm2_cmovznz_u32(&mut x763, x759, x748, x731);
  let mut x764: u32 = 0;
  fiat_sm2_cmovznz_u32(&mut x764, x759, x750, x733);
  let mut x765: u32 = 0;
  fiat_sm2_cmovznz_u32(&mut x765, x759, x752, x735);
  let mut x766: u32 = 0;
  fiat_sm2_cmovznz_u32(&mut x766, x759, x754, x737);
  let mut x767: u32 = 0;
  fiat_sm2_cmovznz_u32(&mut x767, x759, x756, x739);
  *IndexConst(&mut out1).index_mut(0) = x760;
  *IndexConst(&mut out1).index_mut(1) = x761;
  *IndexConst(&mut out1).index_mut(2) = x762;
  *IndexConst(&mut out1).index_mut(3) = x763;
  *IndexConst(&mut out1).index_mut(4) = x764;
  *IndexConst(&mut out1).index_mut(5) = x765;
  *IndexConst(&mut out1).index_mut(6) = x766;
  *IndexConst(&mut out1).index_mut(7) = x767;
}

/// The function fiat_sm2_square squares a field element in the Montgomery domain.
///
/// Preconditions:
///   0 ≤ eval arg1 < m
/// Postconditions:
///   eval (from_montgomery out1) mod m = (eval (from_montgomery arg1) * eval (from_montgomery arg1)) mod m
///   0 ≤ eval out1 < m
///
#[inline]
pub const fn fiat_sm2_square(mut out1: &mut fiat_sm2_montgomery_domain_field_element, arg1: &fiat_sm2_montgomery_domain_field_element) {
  let x1: u32 = (*IndexConst(arg1).index(1));
  let x2: u32 = (*IndexConst(arg1).index(2));
  let x3: u32 = (*IndexConst(arg1).index(3));
  let x4: u32 = (*IndexConst(arg1).index(4));
  let x5: u32 = (*IndexConst(arg1).index(5));
  let x6: u32 = (*IndexConst(arg1).index(6));
  let x7: u32 = (*IndexConst(arg1).index(7));
  let x8: u32 = (*IndexConst(arg1).index(0));
  let mut x9: u32 = 0;
  let mut x10: u32 = 0;
  fiat_sm2_mulx_u32(&mut x9, &mut x10, x8, (*IndexConst(arg1).index(7)));
  let mut x11: u32 = 0;
  let mut x12: u32 = 0;
  fiat_sm2_mulx_u32(&mut x11, &mut x12, x8, (*IndexConst(arg1).index(6)));
  let mut x13: u32 = 0;
  let mut x14: u32 = 0;
  fiat_sm2_mulx_u32(&mut x13, &mut x14, x8, (*IndexConst(arg1).index(5)));
  let mut x15: u32 = 0;
  let mut x16: u32 = 0;
  fiat_sm2_mulx_u32(&mut x15, &mut x16, x8, (*IndexConst(arg1).index(4)));
  let mut x17: u32 = 0;
  let mut x18: u32 = 0;
  fiat_sm2_mulx_u32(&mut x17, &mut x18, x8, (*IndexConst(arg1).index(3)));
  let mut x19: u32 = 0;
  let mut x20: u32 = 0;
  fiat_sm2_mulx_u32(&mut x19, &mut x20, x8, (*IndexConst(arg1).index(2)));
  let mut x21: u32 = 0;
  let mut x22: u32 = 0;
  fiat_sm2_mulx_u32(&mut x21, &mut x22, x8, (*IndexConst(arg1).index(1)));
  let mut x23: u32 = 0;
  let mut x24: u32 = 0;
  fiat_sm2_mulx_u32(&mut x23, &mut x24, x8, (*IndexConst(arg1).index(0)));
  let mut x25: u32 = 0;
  let mut x26: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x25, &mut x26, 0x0, x24, x21);
  let mut x27: u32 = 0;
  let mut x28: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x27, &mut x28, x26, x22, x19);
  let mut x29: u32 = 0;
  let mut x30: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x29, &mut x30, x28, x20, x17);
  let mut x31: u32 = 0;
  let mut x32: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x31, &mut x32, x30, x18, x15);
  let mut x33: u32 = 0;
  let mut x34: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x33, &mut x34, x32, x16, x13);
  let mut x35: u32 = 0;
  let mut x36: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x35, &mut x36, x34, x14, x11);
  let mut x37: u32 = 0;
  let mut x38: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x37, &mut x38, x36, x12, x9);
  let x39: u32 = ((x38 as u32) + x10);
  let mut x40: u32 = 0;
  let mut x41: u32 = 0;
  fiat_sm2_mulx_u32(&mut x40, &mut x41, x23, 0xfffffffe);
  let mut x42: u32 = 0;
  let mut x43: u32 = 0;
  fiat_sm2_mulx_u32(&mut x42, &mut x43, x23, 0xffffffff);
  let mut x44: u32 = 0;
  let mut x45: u32 = 0;
  fiat_sm2_mulx_u32(&mut x44, &mut x45, x23, 0xffffffff);
  let mut x46: u32 = 0;
  let mut x47: u32 = 0;
  fiat_sm2_mulx_u32(&mut x46, &mut x47, x23, 0xffffffff);
  let mut x48: u32 = 0;
  let mut x49: u32 = 0;
  fiat_sm2_mulx_u32(&mut x48, &mut x49, x23, 0xffffffff);
  let mut x50: u32 = 0;
  let mut x51: u32 = 0;
  fiat_sm2_mulx_u32(&mut x50, &mut x51, x23, 0xffffffff);
  let mut x52: u32 = 0;
  let mut x53: u32 = 0;
  fiat_sm2_mulx_u32(&mut x52, &mut x53, x23, 0xffffffff);
  let mut x54: u32 = 0;
  let mut x55: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x54, &mut x55, 0x0, x53, x50);
  let x56: u32 = ((x55 as u32) + x51);
  let mut x57: u32 = 0;
  let mut x58: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x57, &mut x58, 0x0, x49, x46);
  let mut x59: u32 = 0;
  let mut x60: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x59, &mut x60, x58, x47, x44);
  let mut x61: u32 = 0;
  let mut x62: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x61, &mut x62, x60, x45, x42);
  let mut x63: u32 = 0;
  let mut x64: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x63, &mut x64, x62, x43, x40);
  let x65: u32 = ((x64 as u32) + x41);
  let mut x66: u32 = 0;
  let mut x67: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x66, &mut x67, 0x0, x23, x52);
  let mut x68: u32 = 0;
  let mut x69: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x68, &mut x69, x67, x25, x54);
  let mut x70: u32 = 0;
  let mut x71: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x70, &mut x71, x69, x27, x56);
  let mut x72: u32 = 0;
  let mut x73: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x72, &mut x73, x71, x29, x48);
  let mut x74: u32 = 0;
  let mut x75: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x74, &mut x75, x73, x31, x57);
  let mut x76: u32 = 0;
  let mut x77: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x76, &mut x77, x75, x33, x59);
  let mut x78: u32 = 0;
  let mut x79: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x78, &mut x79, x77, x35, x61);
  let mut x80: u32 = 0;
  let mut x81: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x80, &mut x81, x79, x37, x63);
  let mut x82: u32 = 0;
  let mut x83: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x82, &mut x83, x81, x39, x65);
  let mut x84: u32 = 0;
  let mut x85: u32 = 0;
  fiat_sm2_mulx_u32(&mut x84, &mut x85, x1, (*IndexConst(arg1).index(7)));
  let mut x86: u32 = 0;
  let mut x87: u32 = 0;
  fiat_sm2_mulx_u32(&mut x86, &mut x87, x1, (*IndexConst(arg1).index(6)));
  let mut x88: u32 = 0;
  let mut x89: u32 = 0;
  fiat_sm2_mulx_u32(&mut x88, &mut x89, x1, (*IndexConst(arg1).index(5)));
  let mut x90: u32 = 0;
  let mut x91: u32 = 0;
  fiat_sm2_mulx_u32(&mut x90, &mut x91, x1, (*IndexConst(arg1).index(4)));
  let mut x92: u32 = 0;
  let mut x93: u32 = 0;
  fiat_sm2_mulx_u32(&mut x92, &mut x93, x1, (*IndexConst(arg1).index(3)));
  let mut x94: u32 = 0;
  let mut x95: u32 = 0;
  fiat_sm2_mulx_u32(&mut x94, &mut x95, x1, (*IndexConst(arg1).index(2)));
  let mut x96: u32 = 0;
  let mut x97: u32 = 0;
  fiat_sm2_mulx_u32(&mut x96, &mut x97, x1, (*IndexConst(arg1).index(1)));
  let mut x98: u32 = 0;
  let mut x99: u32 = 0;
  fiat_sm2_mulx_u32(&mut x98, &mut x99, x1, (*IndexConst(arg1).index(0)));
  let mut x100: u32 = 0;
  let mut x101: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x100, &mut x101, 0x0, x99, x96);
  let mut x102: u32 = 0;
  let mut x103: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x102, &mut x103, x101, x97, x94);
  let mut x104: u32 = 0;
  let mut x105: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x104, &mut x105, x103, x95, x92);
  let mut x106: u32 = 0;
  let mut x107: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x106, &mut x107, x105, x93, x90);
  let mut x108: u32 = 0;
  let mut x109: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x108, &mut x109, x107, x91, x88);
  let mut x110: u32 = 0;
  let mut x111: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x110, &mut x111, x109, x89, x86);
  let mut x112: u32 = 0;
  let mut x113: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x112, &mut x113, x111, x87, x84);
  let x114: u32 = ((x113 as u32) + x85);
  let mut x115: u32 = 0;
  let mut x116: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x115, &mut x116, 0x0, x68, x98);
  let mut x117: u32 = 0;
  let mut x118: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x117, &mut x118, x116, x70, x100);
  let mut x119: u32 = 0;
  let mut x120: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x119, &mut x120, x118, x72, x102);
  let mut x121: u32 = 0;
  let mut x122: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x121, &mut x122, x120, x74, x104);
  let mut x123: u32 = 0;
  let mut x124: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x123, &mut x124, x122, x76, x106);
  let mut x125: u32 = 0;
  let mut x126: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x125, &mut x126, x124, x78, x108);
  let mut x127: u32 = 0;
  let mut x128: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x127, &mut x128, x126, x80, x110);
  let mut x129: u32 = 0;
  let mut x130: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x129, &mut x130, x128, x82, x112);
  let mut x131: u32 = 0;
  let mut x132: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x131, &mut x132, x130, (x83 as u32), x114);
  let mut x133: u32 = 0;
  let mut x134: u32 = 0;
  fiat_sm2_mulx_u32(&mut x133, &mut x134, x115, 0xfffffffe);
  let mut x135: u32 = 0;
  let mut x136: u32 = 0;
  fiat_sm2_mulx_u32(&mut x135, &mut x136, x115, 0xffffffff);
  let mut x137: u32 = 0;
  let mut x138: u32 = 0;
  fiat_sm2_mulx_u32(&mut x137, &mut x138, x115, 0xffffffff);
  let mut x139: u32 = 0;
  let mut x140: u32 = 0;
  fiat_sm2_mulx_u32(&mut x139, &mut x140, x115, 0xffffffff);
  let mut x141: u32 = 0;
  let mut x142: u32 = 0;
  fiat_sm2_mulx_u32(&mut x141, &mut x142, x115, 0xffffffff);
  let mut x143: u32 = 0;
  let mut x144: u32 = 0;
  fiat_sm2_mulx_u32(&mut x143, &mut x144, x115, 0xffffffff);
  let mut x145: u32 = 0;
  let mut x146: u32 = 0;
  fiat_sm2_mulx_u32(&mut x145, &mut x146, x115, 0xffffffff);
  let mut x147: u32 = 0;
  let mut x148: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x147, &mut x148, 0x0, x146, x143);
  let x149: u32 = ((x148 as u32) + x144);
  let mut x150: u32 = 0;
  let mut x151: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x150, &mut x151, 0x0, x142, x139);
  let mut x152: u32 = 0;
  let mut x153: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x152, &mut x153, x151, x140, x137);
  let mut x154: u32 = 0;
  let mut x155: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x154, &mut x155, x153, x138, x135);
  let mut x156: u32 = 0;
  let mut x157: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x156, &mut x157, x155, x136, x133);
  let x158: u32 = ((x157 as u32) + x134);
  let mut x159: u32 = 0;
  let mut x160: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x159, &mut x160, 0x0, x115, x145);
  let mut x161: u32 = 0;
  let mut x162: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x161, &mut x162, x160, x117, x147);
  let mut x163: u32 = 0;
  let mut x164: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x163, &mut x164, x162, x119, x149);
  let mut x165: u32 = 0;
  let mut x166: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x165, &mut x166, x164, x121, x141);
  let mut x167: u32 = 0;
  let mut x168: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x167, &mut x168, x166, x123, x150);
  let mut x169: u32 = 0;
  let mut x170: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x169, &mut x170, x168, x125, x152);
  let mut x171: u32 = 0;
  let mut x172: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x171, &mut x172, x170, x127, x154);
  let mut x173: u32 = 0;
  let mut x174: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x173, &mut x174, x172, x129, x156);
  let mut x175: u32 = 0;
  let mut x176: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x175, &mut x176, x174, x131, x158);
  let x177: u32 = ((x176 as u32) + (x132 as u32));
  let mut x178: u32 = 0;
  let mut x179: u32 = 0;
  fiat_sm2_mulx_u32(&mut x178, &mut x179, x2, (*IndexConst(arg1).index(7)));
  let mut x180: u32 = 0;
  let mut x181: u32 = 0;
  fiat_sm2_mulx_u32(&mut x180, &mut x181, x2, (*IndexConst(arg1).index(6)));
  let mut x182: u32 = 0;
  let mut x183: u32 = 0;
  fiat_sm2_mulx_u32(&mut x182, &mut x183, x2, (*IndexConst(arg1).index(5)));
  let mut x184: u32 = 0;
  let mut x185: u32 = 0;
  fiat_sm2_mulx_u32(&mut x184, &mut x185, x2, (*IndexConst(arg1).index(4)));
  let mut x186: u32 = 0;
  let mut x187: u32 = 0;
  fiat_sm2_mulx_u32(&mut x186, &mut x187, x2, (*IndexConst(arg1).index(3)));
  let mut x188: u32 = 0;
  let mut x189: u32 = 0;
  fiat_sm2_mulx_u32(&mut x188, &mut x189, x2, (*IndexConst(arg1).index(2)));
  let mut x190: u32 = 0;
  let mut x191: u32 = 0;
  fiat_sm2_mulx_u32(&mut x190, &mut x191, x2, (*IndexConst(arg1).index(1)));
  let mut x192: u32 = 0;
  let mut x193: u32 = 0;
  fiat_sm2_mulx_u32(&mut x192, &mut x193, x2, (*IndexConst(arg1).index(0)));
  let mut x194: u32 = 0;
  let mut x195: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x194, &mut x195, 0x0, x193, x190);
  let mut x196: u32 = 0;
  let mut x197: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x196, &mut x197, x195, x191, x188);
  let mut x198: u32 = 0;
  let mut x199: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x198, &mut x199, x197, x189, x186);
  let mut x200: u32 = 0;
  let mut x201: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x200, &mut x201, x199, x187, x184);
  let mut x202: u32 = 0;
  let mut x203: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x202, &mut x203, x201, x185, x182);
  let mut x204: u32 = 0;
  let mut x205: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x204, &mut x205, x203, x183, x180);
  let mut x206: u32 = 0;
  let mut x207: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x206, &mut x207, x205, x181, x178);
  let x208: u32 = ((x207 as u32) + x179);
  let mut x209: u32 = 0;
  let mut x210: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x209, &mut x210, 0x0, x161, x192);
  let mut x211: u32 = 0;
  let mut x212: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x211, &mut x212, x210, x163, x194);
  let mut x213: u32 = 0;
  let mut x214: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x213, &mut x214, x212, x165, x196);
  let mut x215: u32 = 0;
  let mut x216: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x215, &mut x216, x214, x167, x198);
  let mut x217: u32 = 0;
  let mut x218: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x217, &mut x218, x216, x169, x200);
  let mut x219: u32 = 0;
  let mut x220: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x219, &mut x220, x218, x171, x202);
  let mut x221: u32 = 0;
  let mut x222: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x221, &mut x222, x220, x173, x204);
  let mut x223: u32 = 0;
  let mut x224: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x223, &mut x224, x222, x175, x206);
  let mut x225: u32 = 0;
  let mut x226: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x225, &mut x226, x224, x177, x208);
  let mut x227: u32 = 0;
  let mut x228: u32 = 0;
  fiat_sm2_mulx_u32(&mut x227, &mut x228, x209, 0xfffffffe);
  let mut x229: u32 = 0;
  let mut x230: u32 = 0;
  fiat_sm2_mulx_u32(&mut x229, &mut x230, x209, 0xffffffff);
  let mut x231: u32 = 0;
  let mut x232: u32 = 0;
  fiat_sm2_mulx_u32(&mut x231, &mut x232, x209, 0xffffffff);
  let mut x233: u32 = 0;
  let mut x234: u32 = 0;
  fiat_sm2_mulx_u32(&mut x233, &mut x234, x209, 0xffffffff);
  let mut x235: u32 = 0;
  let mut x236: u32 = 0;
  fiat_sm2_mulx_u32(&mut x235, &mut x236, x209, 0xffffffff);
  let mut x237: u32 = 0;
  let mut x238: u32 = 0;
  fiat_sm2_mulx_u32(&mut x237, &mut x238, x209, 0xffffffff);
  let mut x239: u32 = 0;
  let mut x240: u32 = 0;
  fiat_sm2_mulx_u32(&mut x239, &mut x240, x209, 0xffffffff);
  let mut x241: u32 = 0;
  let mut x242: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x241, &mut x242, 0x0, x240, x237);
  let x243: u32 = ((x242 as u32) + x238);
  let mut x244: u32 = 0;
  let mut x245: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x244, &mut x245, 0x0, x236, x233);
  let mut x246: u32 = 0;
  let mut x247: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x246, &mut x247, x245, x234, x231);
  let mut x248: u32 = 0;
  let mut x249: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x248, &mut x249, x247, x232, x229);
  let mut x250: u32 = 0;
  let mut x251: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x250, &mut x251, x249, x230, x227);
  let x252: u32 = ((x251 as u32) + x228);
  let mut x253: u32 = 0;
  let mut x254: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x253, &mut x254, 0x0, x209, x239);
  let mut x255: u32 = 0;
  let mut x256: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x255, &mut x256, x254, x211, x241);
  let mut x257: u32 = 0;
  let mut x258: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x257, &mut x258, x256, x213, x243);
  let mut x259: u32 = 0;
  let mut x260: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x259, &mut x260, x258, x215, x235);
  let mut x261: u32 = 0;
  let mut x262: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x261, &mut x262, x260, x217, x244);
  let mut x263: u32 = 0;
  let mut x264: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x263, &mut x264, x262, x219, x246);
  let mut x265: u32 = 0;
  let mut x266: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x265, &mut x266, x264, x221, x248);
  let mut x267: u32 = 0;
  let mut x268: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x267, &mut x268, x266, x223, x250);
  let mut x269: u32 = 0;
  let mut x270: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x269, &mut x270, x268, x225, x252);
  let x271: u32 = ((x270 as u32) + (x226 as u32));
  let mut x272: u32 = 0;
  let mut x273: u32 = 0;
  fiat_sm2_mulx_u32(&mut x272, &mut x273, x3, (*IndexConst(arg1).index(7)));
  let mut x274: u32 = 0;
  let mut x275: u32 = 0;
  fiat_sm2_mulx_u32(&mut x274, &mut x275, x3, (*IndexConst(arg1).index(6)));
  let mut x276: u32 = 0;
  let mut x277: u32 = 0;
  fiat_sm2_mulx_u32(&mut x276, &mut x277, x3, (*IndexConst(arg1).index(5)));
  let mut x278: u32 = 0;
  let mut x279: u32 = 0;
  fiat_sm2_mulx_u32(&mut x278, &mut x279, x3, (*IndexConst(arg1).index(4)));
  let mut x280: u32 = 0;
  let mut x281: u32 = 0;
  fiat_sm2_mulx_u32(&mut x280, &mut x281, x3, (*IndexConst(arg1).index(3)));
  let mut x282: u32 = 0;
  let mut x283: u32 = 0;
  fiat_sm2_mulx_u32(&mut x282, &mut x283, x3, (*IndexConst(arg1).index(2)));
  let mut x284: u32 = 0;
  let mut x285: u32 = 0;
  fiat_sm2_mulx_u32(&mut x284, &mut x285, x3, (*IndexConst(arg1).index(1)));
  let mut x286: u32 = 0;
  let mut x287: u32 = 0;
  fiat_sm2_mulx_u32(&mut x286, &mut x287, x3, (*IndexConst(arg1).index(0)));
  let mut x288: u32 = 0;
  let mut x289: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x288, &mut x289, 0x0, x287, x284);
  let mut x290: u32 = 0;
  let mut x291: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x290, &mut x291, x289, x285, x282);
  let mut x292: u32 = 0;
  let mut x293: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x292, &mut x293, x291, x283, x280);
  let mut x294: u32 = 0;
  let mut x295: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x294, &mut x295, x293, x281, x278);
  let mut x296: u32 = 0;
  let mut x297: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x296, &mut x297, x295, x279, x276);
  let mut x298: u32 = 0;
  let mut x299: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x298, &mut x299, x297, x277, x274);
  let mut x300: u32 = 0;
  let mut x301: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x300, &mut x301, x299, x275, x272);
  let x302: u32 = ((x301 as u32) + x273);
  let mut x303: u32 = 0;
  let mut x304: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x303, &mut x304, 0x0, x255, x286);
  let mut x305: u32 = 0;
  let mut x306: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x305, &mut x306, x304, x257, x288);
  let mut x307: u32 = 0;
  let mut x308: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x307, &mut x308, x306, x259, x290);
  let mut x309: u32 = 0;
  let mut x310: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x309, &mut x310, x308, x261, x292);
  let mut x311: u32 = 0;
  let mut x312: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x311, &mut x312, x310, x263, x294);
  let mut x313: u32 = 0;
  let mut x314: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x313, &mut x314, x312, x265, x296);
  let mut x315: u32 = 0;
  let mut x316: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x315, &mut x316, x314, x267, x298);
  let mut x317: u32 = 0;
  let mut x318: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x317, &mut x318, x316, x269, x300);
  let mut x319: u32 = 0;
  let mut x320: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x319, &mut x320, x318, x271, x302);
  let mut x321: u32 = 0;
  let mut x322: u32 = 0;
  fiat_sm2_mulx_u32(&mut x321, &mut x322, x303, 0xfffffffe);
  let mut x323: u32 = 0;
  let mut x324: u32 = 0;
  fiat_sm2_mulx_u32(&mut x323, &mut x324, x303, 0xffffffff);
  let mut x325: u32 = 0;
  let mut x326: u32 = 0;
  fiat_sm2_mulx_u32(&mut x325, &mut x326, x303, 0xffffffff);
  let mut x327: u32 = 0;
  let mut x328: u32 = 0;
  fiat_sm2_mulx_u32(&mut x327, &mut x328, x303, 0xffffffff);
  let mut x329: u32 = 0;
  let mut x330: u32 = 0;
  fiat_sm2_mulx_u32(&mut x329, &mut x330, x303, 0xffffffff);
  let mut x331: u32 = 0;
  let mut x332: u32 = 0;
  fiat_sm2_mulx_u32(&mut x331, &mut x332, x303, 0xffffffff);
  let mut x333: u32 = 0;
  let mut x334: u32 = 0;
  fiat_sm2_mulx_u32(&mut x333, &mut x334, x303, 0xffffffff);
  let mut x335: u32 = 0;
  let mut x336: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x335, &mut x336, 0x0, x334, x331);
  let x337: u32 = ((x336 as u32) + x332);
  let mut x338: u32 = 0;
  let mut x339: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x338, &mut x339, 0x0, x330, x327);
  let mut x340: u32 = 0;
  let mut x341: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x340, &mut x341, x339, x328, x325);
  let mut x342: u32 = 0;
  let mut x343: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x342, &mut x343, x341, x326, x323);
  let mut x344: u32 = 0;
  let mut x345: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x344, &mut x345, x343, x324, x321);
  let x346: u32 = ((x345 as u32) + x322);
  let mut x347: u32 = 0;
  let mut x348: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x347, &mut x348, 0x0, x303, x333);
  let mut x349: u32 = 0;
  let mut x350: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x349, &mut x350, x348, x305, x335);
  let mut x351: u32 = 0;
  let mut x352: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x351, &mut x352, x350, x307, x337);
  let mut x353: u32 = 0;
  let mut x354: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x353, &mut x354, x352, x309, x329);
  let mut x355: u32 = 0;
  let mut x356: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x355, &mut x356, x354, x311, x338);
  let mut x357: u32 = 0;
  let mut x358: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x357, &mut x358, x356, x313, x340);
  let mut x359: u32 = 0;
  let mut x360: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x359, &mut x360, x358, x315, x342);
  let mut x361: u32 = 0;
  let mut x362: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x361, &mut x362, x360, x317, x344);
  let mut x363: u32 = 0;
  let mut x364: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x363, &mut x364, x362, x319, x346);
  let x365: u32 = ((x364 as u32) + (x320 as u32));
  let mut x366: u32 = 0;
  let mut x367: u32 = 0;
  fiat_sm2_mulx_u32(&mut x366, &mut x367, x4, (*IndexConst(arg1).index(7)));
  let mut x368: u32 = 0;
  let mut x369: u32 = 0;
  fiat_sm2_mulx_u32(&mut x368, &mut x369, x4, (*IndexConst(arg1).index(6)));
  let mut x370: u32 = 0;
  let mut x371: u32 = 0;
  fiat_sm2_mulx_u32(&mut x370, &mut x371, x4, (*IndexConst(arg1).index(5)));
  let mut x372: u32 = 0;
  let mut x373: u32 = 0;
  fiat_sm2_mulx_u32(&mut x372, &mut x373, x4, (*IndexConst(arg1).index(4)));
  let mut x374: u32 = 0;
  let mut x375: u32 = 0;
  fiat_sm2_mulx_u32(&mut x374, &mut x375, x4, (*IndexConst(arg1).index(3)));
  let mut x376: u32 = 0;
  let mut x377: u32 = 0;
  fiat_sm2_mulx_u32(&mut x376, &mut x377, x4, (*IndexConst(arg1).index(2)));
  let mut x378: u32 = 0;
  let mut x379: u32 = 0;
  fiat_sm2_mulx_u32(&mut x378, &mut x379, x4, (*IndexConst(arg1).index(1)));
  let mut x380: u32 = 0;
  let mut x381: u32 = 0;
  fiat_sm2_mulx_u32(&mut x380, &mut x381, x4, (*IndexConst(arg1).index(0)));
  let mut x382: u32 = 0;
  let mut x383: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x382, &mut x383, 0x0, x381, x378);
  let mut x384: u32 = 0;
  let mut x385: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x384, &mut x385, x383, x379, x376);
  let mut x386: u32 = 0;
  let mut x387: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x386, &mut x387, x385, x377, x374);
  let mut x388: u32 = 0;
  let mut x389: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x388, &mut x389, x387, x375, x372);
  let mut x390: u32 = 0;
  let mut x391: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x390, &mut x391, x389, x373, x370);
  let mut x392: u32 = 0;
  let mut x393: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x392, &mut x393, x391, x371, x368);
  let mut x394: u32 = 0;
  let mut x395: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x394, &mut x395, x393, x369, x366);
  let x396: u32 = ((x395 as u32) + x367);
  let mut x397: u32 = 0;
  let mut x398: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x397, &mut x398, 0x0, x349, x380);
  let mut x399: u32 = 0;
  let mut x400: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x399, &mut x400, x398, x351, x382);
  let mut x401: u32 = 0;
  let mut x402: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x401, &mut x402, x400, x353, x384);
  let mut x403: u32 = 0;
  let mut x404: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x403, &mut x404, x402, x355, x386);
  let mut x405: u32 = 0;
  let mut x406: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x405, &mut x406, x404, x357, x388);
  let mut x407: u32 = 0;
  let mut x408: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x407, &mut x408, x406, x359, x390);
  let mut x409: u32 = 0;
  let mut x410: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x409, &mut x410, x408, x361, x392);
  let mut x411: u32 = 0;
  let mut x412: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x411, &mut x412, x410, x363, x394);
  let mut x413: u32 = 0;
  let mut x414: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x413, &mut x414, x412, x365, x396);
  let mut x415: u32 = 0;
  let mut x416: u32 = 0;
  fiat_sm2_mulx_u32(&mut x415, &mut x416, x397, 0xfffffffe);
  let mut x417: u32 = 0;
  let mut x418: u32 = 0;
  fiat_sm2_mulx_u32(&mut x417, &mut x418, x397, 0xffffffff);
  let mut x419: u32 = 0;
  let mut x420: u32 = 0;
  fiat_sm2_mulx_u32(&mut x419, &mut x420, x397, 0xffffffff);
  let mut x421: u32 = 0;
  let mut x422: u32 = 0;
  fiat_sm2_mulx_u32(&mut x421, &mut x422, x397, 0xffffffff);
  let mut x423: u32 = 0;
  let mut x424: u32 = 0;
  fiat_sm2_mulx_u32(&mut x423, &mut x424, x397, 0xffffffff);
  let mut x425: u32 = 0;
  let mut x426: u32 = 0;
  fiat_sm2_mulx_u32(&mut x425, &mut x426, x397, 0xffffffff);
  let mut x427: u32 = 0;
  let mut x428: u32 = 0;
  fiat_sm2_mulx_u32(&mut x427, &mut x428, x397, 0xffffffff);
  let mut x429: u32 = 0;
  let mut x430: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x429, &mut x430, 0x0, x428, x425);
  let x431: u32 = ((x430 as u32) + x426);
  let mut x432: u32 = 0;
  let mut x433: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x432, &mut x433, 0x0, x424, x421);
  let mut x434: u32 = 0;
  let mut x435: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x434, &mut x435, x433, x422, x419);
  let mut x436: u32 = 0;
  let mut x437: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x436, &mut x437, x435, x420, x417);
  let mut x438: u32 = 0;
  let mut x439: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x438, &mut x439, x437, x418, x415);
  let x440: u32 = ((x439 as u32) + x416);
  let mut x441: u32 = 0;
  let mut x442: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x441, &mut x442, 0x0, x397, x427);
  let mut x443: u32 = 0;
  let mut x444: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x443, &mut x444, x442, x399, x429);
  let mut x445: u32 = 0;
  let mut x446: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x445, &mut x446, x444, x401, x431);
  let mut x447: u32 = 0;
  let mut x448: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x447, &mut x448, x446, x403, x423);
  let mut x449: u32 = 0;
  let mut x450: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x449, &mut x450, x448, x405, x432);
  let mut x451: u32 = 0;
  let mut x452: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x451, &mut x452, x450, x407, x434);
  let mut x453: u32 = 0;
  let mut x454: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x453, &mut x454, x452, x409, x436);
  let mut x455: u32 = 0;
  let mut x456: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x455, &mut x456, x454, x411, x438);
  let mut x457: u32 = 0;
  let mut x458: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x457, &mut x458, x456, x413, x440);
  let x459: u32 = ((x458 as u32) + (x414 as u32));
  let mut x460: u32 = 0;
  let mut x461: u32 = 0;
  fiat_sm2_mulx_u32(&mut x460, &mut x461, x5, (*IndexConst(arg1).index(7)));
  let mut x462: u32 = 0;
  let mut x463: u32 = 0;
  fiat_sm2_mulx_u32(&mut x462, &mut x463, x5, (*IndexConst(arg1).index(6)));
  let mut x464: u32 = 0;
  let mut x465: u32 = 0;
  fiat_sm2_mulx_u32(&mut x464, &mut x465, x5, (*IndexConst(arg1).index(5)));
  let mut x466: u32 = 0;
  let mut x467: u32 = 0;
  fiat_sm2_mulx_u32(&mut x466, &mut x467, x5, (*IndexConst(arg1).index(4)));
  let mut x468: u32 = 0;
  let mut x469: u32 = 0;
  fiat_sm2_mulx_u32(&mut x468, &mut x469, x5, (*IndexConst(arg1).index(3)));
  let mut x470: u32 = 0;
  let mut x471: u32 = 0;
  fiat_sm2_mulx_u32(&mut x470, &mut x471, x5, (*IndexConst(arg1).index(2)));
  let mut x472: u32 = 0;
  let mut x473: u32 = 0;
  fiat_sm2_mulx_u32(&mut x472, &mut x473, x5, (*IndexConst(arg1).index(1)));
  let mut x474: u32 = 0;
  let mut x475: u32 = 0;
  fiat_sm2_mulx_u32(&mut x474, &mut x475, x5, (*IndexConst(arg1).index(0)));
  let mut x476: u32 = 0;
  let mut x477: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x476, &mut x477, 0x0, x475, x472);
  let mut x478: u32 = 0;
  let mut x479: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x478, &mut x479, x477, x473, x470);
  let mut x480: u32 = 0;
  let mut x481: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x480, &mut x481, x479, x471, x468);
  let mut x482: u32 = 0;
  let mut x483: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x482, &mut x483, x481, x469, x466);
  let mut x484: u32 = 0;
  let mut x485: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x484, &mut x485, x483, x467, x464);
  let mut x486: u32 = 0;
  let mut x487: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x486, &mut x487, x485, x465, x462);
  let mut x488: u32 = 0;
  let mut x489: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x488, &mut x489, x487, x463, x460);
  let x490: u32 = ((x489 as u32) + x461);
  let mut x491: u32 = 0;
  let mut x492: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x491, &mut x492, 0x0, x443, x474);
  let mut x493: u32 = 0;
  let mut x494: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x493, &mut x494, x492, x445, x476);
  let mut x495: u32 = 0;
  let mut x496: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x495, &mut x496, x494, x447, x478);
  let mut x497: u32 = 0;
  let mut x498: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x497, &mut x498, x496, x449, x480);
  let mut x499: u32 = 0;
  let mut x500: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x499, &mut x500, x498, x451, x482);
  let mut x501: u32 = 0;
  let mut x502: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x501, &mut x502, x500, x453, x484);
  let mut x503: u32 = 0;
  let mut x504: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x503, &mut x504, x502, x455, x486);
  let mut x505: u32 = 0;
  let mut x506: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x505, &mut x506, x504, x457, x488);
  let mut x507: u32 = 0;
  let mut x508: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x507, &mut x508, x506, x459, x490);
  let mut x509: u32 = 0;
  let mut x510: u32 = 0;
  fiat_sm2_mulx_u32(&mut x509, &mut x510, x491, 0xfffffffe);
  let mut x511: u32 = 0;
  let mut x512: u32 = 0;
  fiat_sm2_mulx_u32(&mut x511, &mut x512, x491, 0xffffffff);
  let mut x513: u32 = 0;
  let mut x514: u32 = 0;
  fiat_sm2_mulx_u32(&mut x513, &mut x514, x491, 0xffffffff);
  let mut x515: u32 = 0;
  let mut x516: u32 = 0;
  fiat_sm2_mulx_u32(&mut x515, &mut x516, x491, 0xffffffff);
  let mut x517: u32 = 0;
  let mut x518: u32 = 0;
  fiat_sm2_mulx_u32(&mut x517, &mut x518, x491, 0xffffffff);
  let mut x519: u32 = 0;
  let mut x520: u32 = 0;
  fiat_sm2_mulx_u32(&mut x519, &mut x520, x491, 0xffffffff);
  let mut x521: u32 = 0;
  let mut x522: u32 = 0;
  fiat_sm2_mulx_u32(&mut x521, &mut x522, x491, 0xffffffff);
  let mut x523: u32 = 0;
  let mut x524: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x523, &mut x524, 0x0, x522, x519);
  let x525: u32 = ((x524 as u32) + x520);
  let mut x526: u32 = 0;
  let mut x527: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x526, &mut x527, 0x0, x518, x515);
  let mut x528: u32 = 0;
  let mut x529: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x528, &mut x529, x527, x516, x513);
  let mut x530: u32 = 0;
  let mut x531: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x530, &mut x531, x529, x514, x511);
  let mut x532: u32 = 0;
  let mut x533: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x532, &mut x533, x531, x512, x509);
  let x534: u32 = ((x533 as u32) + x510);
  let mut x535: u32 = 0;
  let mut x536: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x535, &mut x536, 0x0, x491, x521);
  let mut x537: u32 = 0;
  let mut x538: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x537, &mut x538, x536, x493, x523);
  let mut x539: u32 = 0;
  let mut x540: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x539, &mut x540, x538, x495, x525);
  let mut x541: u32 = 0;
  let mut x542: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x541, &mut x542, x540, x497, x517);
  let mut x543: u32 = 0;
  let mut x544: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x543, &mut x544, x542, x499, x526);
  let mut x545: u32 = 0;
  let mut x546: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x545, &mut x546, x544, x501, x528);
  let mut x547: u32 = 0;
  let mut x548: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x547, &mut x548, x546, x503, x530);
  let mut x549: u32 = 0;
  let mut x550: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x549, &mut x550, x548, x505, x532);
  let mut x551: u32 = 0;
  let mut x552: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x551, &mut x552, x550, x507, x534);
  let x553: u32 = ((x552 as u32) + (x508 as u32));
  let mut x554: u32 = 0;
  let mut x555: u32 = 0;
  fiat_sm2_mulx_u32(&mut x554, &mut x555, x6, (*IndexConst(arg1).index(7)));
  let mut x556: u32 = 0;
  let mut x557: u32 = 0;
  fiat_sm2_mulx_u32(&mut x556, &mut x557, x6, (*IndexConst(arg1).index(6)));
  let mut x558: u32 = 0;
  let mut x559: u32 = 0;
  fiat_sm2_mulx_u32(&mut x558, &mut x559, x6, (*IndexConst(arg1).index(5)));
  let mut x560: u32 = 0;
  let mut x561: u32 = 0;
  fiat_sm2_mulx_u32(&mut x560, &mut x561, x6, (*IndexConst(arg1).index(4)));
  let mut x562: u32 = 0;
  let mut x563: u32 = 0;
  fiat_sm2_mulx_u32(&mut x562, &mut x563, x6, (*IndexConst(arg1).index(3)));
  let mut x564: u32 = 0;
  let mut x565: u32 = 0;
  fiat_sm2_mulx_u32(&mut x564, &mut x565, x6, (*IndexConst(arg1).index(2)));
  let mut x566: u32 = 0;
  let mut x567: u32 = 0;
  fiat_sm2_mulx_u32(&mut x566, &mut x567, x6, (*IndexConst(arg1).index(1)));
  let mut x568: u32 = 0;
  let mut x569: u32 = 0;
  fiat_sm2_mulx_u32(&mut x568, &mut x569, x6, (*IndexConst(arg1).index(0)));
  let mut x570: u32 = 0;
  let mut x571: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x570, &mut x571, 0x0, x569, x566);
  let mut x572: u32 = 0;
  let mut x573: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x572, &mut x573, x571, x567, x564);
  let mut x574: u32 = 0;
  let mut x575: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x574, &mut x575, x573, x565, x562);
  let mut x576: u32 = 0;
  let mut x577: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x576, &mut x577, x575, x563, x560);
  let mut x578: u32 = 0;
  let mut x579: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x578, &mut x579, x577, x561, x558);
  let mut x580: u32 = 0;
  let mut x581: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x580, &mut x581, x579, x559, x556);
  let mut x582: u32 = 0;
  let mut x583: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x582, &mut x583, x581, x557, x554);
  let x584: u32 = ((x583 as u32) + x555);
  let mut x585: u32 = 0;
  let mut x586: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x585, &mut x586, 0x0, x537, x568);
  let mut x587: u32 = 0;
  let mut x588: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x587, &mut x588, x586, x539, x570);
  let mut x589: u32 = 0;
  let mut x590: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x589, &mut x590, x588, x541, x572);
  let mut x591: u32 = 0;
  let mut x592: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x591, &mut x592, x590, x543, x574);
  let mut x593: u32 = 0;
  let mut x594: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x593, &mut x594, x592, x545, x576);
  let mut x595: u32 = 0;
  let mut x596: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x595, &mut x596, x594, x547, x578);
  let mut x597: u32 = 0;
  let mut x598: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x597, &mut x598, x596, x549, x580);
  let mut x599: u32 = 0;
  let mut x600: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x599, &mut x600, x598, x551, x582);
  let mut x601: u32 = 0;
  let mut x602: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x601, &mut x602, x600, x553, x584);
  let mut x603: u32 = 0;
  let mut x604: u32 = 0;
  fiat_sm2_mulx_u32(&mut x603, &mut x604, x585, 0xfffffffe);
  let mut x605: u32 = 0;
  let mut x606: u32 = 0;
  fiat_sm2_mulx_u32(&mut x605, &mut x606, x585, 0xffffffff);
  let mut x607: u32 = 0;
  let mut x608: u32 = 0;
  fiat_sm2_mulx_u32(&mut x607, &mut x608, x585, 0xffffffff);
  let mut x609: u32 = 0;
  let mut x610: u32 = 0;
  fiat_sm2_mulx_u32(&mut x609, &mut x610, x585, 0xffffffff);
  let mut x611: u32 = 0;
  let mut x612: u32 = 0;
  fiat_sm2_mulx_u32(&mut x611, &mut x612, x585, 0xffffffff);
  let mut x613: u32 = 0;
  let mut x614: u32 = 0;
  fiat_sm2_mulx_u32(&mut x613, &mut x614, x585, 0xffffffff);
  let mut x615: u32 = 0;
  let mut x616: u32 = 0;
  fiat_sm2_mulx_u32(&mut x615, &mut x616, x585, 0xffffffff);
  let mut x617: u32 = 0;
  let mut x618: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x617, &mut x618, 0x0, x616, x613);
  let x619: u32 = ((x618 as u32) + x614);
  let mut x620: u32 = 0;
  let mut x621: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x620, &mut x621, 0x0, x612, x609);
  let mut x622: u32 = 0;
  let mut x623: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x622, &mut x623, x621, x610, x607);
  let mut x624: u32 = 0;
  let mut x625: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x624, &mut x625, x623, x608, x605);
  let mut x626: u32 = 0;
  let mut x627: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x626, &mut x627, x625, x606, x603);
  let x628: u32 = ((x627 as u32) + x604);
  let mut x629: u32 = 0;
  let mut x630: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x629, &mut x630, 0x0, x585, x615);
  let mut x631: u32 = 0;
  let mut x632: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x631, &mut x632, x630, x587, x617);
  let mut x633: u32 = 0;
  let mut x634: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x633, &mut x634, x632, x589, x619);
  let mut x635: u32 = 0;
  let mut x636: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x635, &mut x636, x634, x591, x611);
  let mut x637: u32 = 0;
  let mut x638: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x637, &mut x638, x636, x593, x620);
  let mut x639: u32 = 0;
  let mut x640: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x639, &mut x640, x638, x595, x622);
  let mut x641: u32 = 0;
  let mut x642: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x641, &mut x642, x640, x597, x624);
  let mut x643: u32 = 0;
  let mut x644: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x643, &mut x644, x642, x599, x626);
  let mut x645: u32 = 0;
  let mut x646: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x645, &mut x646, x644, x601, x628);
  let x647: u32 = ((x646 as u32) + (x602 as u32));
  let mut x648: u32 = 0;
  let mut x649: u32 = 0;
  fiat_sm2_mulx_u32(&mut x648, &mut x649, x7, (*IndexConst(arg1).index(7)));
  let mut x650: u32 = 0;
  let mut x651: u32 = 0;
  fiat_sm2_mulx_u32(&mut x650, &mut x651, x7, (*IndexConst(arg1).index(6)));
  let mut x652: u32 = 0;
  let mut x653: u32 = 0;
  fiat_sm2_mulx_u32(&mut x652, &mut x653, x7, (*IndexConst(arg1).index(5)));
  let mut x654: u32 = 0;
  let mut x655: u32 = 0;
  fiat_sm2_mulx_u32(&mut x654, &mut x655, x7, (*IndexConst(arg1).index(4)));
  let mut x656: u32 = 0;
  let mut x657: u32 = 0;
  fiat_sm2_mulx_u32(&mut x656, &mut x657, x7, (*IndexConst(arg1).index(3)));
  let mut x658: u32 = 0;
  let mut x659: u32 = 0;
  fiat_sm2_mulx_u32(&mut x658, &mut x659, x7, (*IndexConst(arg1).index(2)));
  let mut x660: u32 = 0;
  let mut x661: u32 = 0;
  fiat_sm2_mulx_u32(&mut x660, &mut x661, x7, (*IndexConst(arg1).index(1)));
  let mut x662: u32 = 0;
  let mut x663: u32 = 0;
  fiat_sm2_mulx_u32(&mut x662, &mut x663, x7, (*IndexConst(arg1).index(0)));
  let mut x664: u32 = 0;
  let mut x665: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x664, &mut x665, 0x0, x663, x660);
  let mut x666: u32 = 0;
  let mut x667: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x666, &mut x667, x665, x661, x658);
  let mut x668: u32 = 0;
  let mut x669: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x668, &mut x669, x667, x659, x656);
  let mut x670: u32 = 0;
  let mut x671: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x670, &mut x671, x669, x657, x654);
  let mut x672: u32 = 0;
  let mut x673: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x672, &mut x673, x671, x655, x652);
  let mut x674: u32 = 0;
  let mut x675: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x674, &mut x675, x673, x653, x650);
  let mut x676: u32 = 0;
  let mut x677: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x676, &mut x677, x675, x651, x648);
  let x678: u32 = ((x677 as u32) + x649);
  let mut x679: u32 = 0;
  let mut x680: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x679, &mut x680, 0x0, x631, x662);
  let mut x681: u32 = 0;
  let mut x682: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x681, &mut x682, x680, x633, x664);
  let mut x683: u32 = 0;
  let mut x684: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x683, &mut x684, x682, x635, x666);
  let mut x685: u32 = 0;
  let mut x686: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x685, &mut x686, x684, x637, x668);
  let mut x687: u32 = 0;
  let mut x688: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x687, &mut x688, x686, x639, x670);
  let mut x689: u32 = 0;
  let mut x690: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x689, &mut x690, x688, x641, x672);
  let mut x691: u32 = 0;
  let mut x692: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x691, &mut x692, x690, x643, x674);
  let mut x693: u32 = 0;
  let mut x694: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x693, &mut x694, x692, x645, x676);
  let mut x695: u32 = 0;
  let mut x696: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x695, &mut x696, x694, x647, x678);
  let mut x697: u32 = 0;
  let mut x698: u32 = 0;
  fiat_sm2_mulx_u32(&mut x697, &mut x698, x679, 0xfffffffe);
  let mut x699: u32 = 0;
  let mut x700: u32 = 0;
  fiat_sm2_mulx_u32(&mut x699, &mut x700, x679, 0xffffffff);
  let mut x701: u32 = 0;
  let mut x702: u32 = 0;
  fiat_sm2_mulx_u32(&mut x701, &mut x702, x679, 0xffffffff);
  let mut x703: u32 = 0;
  let mut x704: u32 = 0;
  fiat_sm2_mulx_u32(&mut x703, &mut x704, x679, 0xffffffff);
  let mut x705: u32 = 0;
  let mut x706: u32 = 0;
  fiat_sm2_mulx_u32(&mut x705, &mut x706, x679, 0xffffffff);
  let mut x707: u32 = 0;
  let mut x708: u32 = 0;
  fiat_sm2_mulx_u32(&mut x707, &mut x708, x679, 0xffffffff);
  let mut x709: u32 = 0;
  let mut x710: u32 = 0;
  fiat_sm2_mulx_u32(&mut x709, &mut x710, x679, 0xffffffff);
  let mut x711: u32 = 0;
  let mut x712: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x711, &mut x712, 0x0, x710, x707);
  let x713: u32 = ((x712 as u32) + x708);
  let mut x714: u32 = 0;
  let mut x715: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x714, &mut x715, 0x0, x706, x703);
  let mut x716: u32 = 0;
  let mut x717: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x716, &mut x717, x715, x704, x701);
  let mut x718: u32 = 0;
  let mut x719: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x718, &mut x719, x717, x702, x699);
  let mut x720: u32 = 0;
  let mut x721: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x720, &mut x721, x719, x700, x697);
  let x722: u32 = ((x721 as u32) + x698);
  let mut x723: u32 = 0;
  let mut x724: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x723, &mut x724, 0x0, x679, x709);
  let mut x725: u32 = 0;
  let mut x726: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x725, &mut x726, x724, x681, x711);
  let mut x727: u32 = 0;
  let mut x728: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x727, &mut x728, x726, x683, x713);
  let mut x729: u32 = 0;
  let mut x730: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x729, &mut x730, x728, x685, x705);
  let mut x731: u32 = 0;
  let mut x732: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x731, &mut x732, x730, x687, x714);
  let mut x733: u32 = 0;
  let mut x734: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x733, &mut x734, x732, x689, x716);
  let mut x735: u32 = 0;
  let mut x736: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x735, &mut x736, x734, x691, x718);
  let mut x737: u32 = 0;
  let mut x738: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x737, &mut x738, x736, x693, x720);
  let mut x739: u32 = 0;
  let mut x740: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x739, &mut x740, x738, x695, x722);
  let x741: u32 = ((x740 as u32) + (x696 as u32));
  let mut x742: u32 = 0;
  let mut x743: fiat_sm2_u1 = 0;
  fiat_sm2_subborrowx_u32(&mut x742, &mut x743, 0x0, x725, 0xffffffff);
  let mut x744: u32 = 0;
  let mut x745: fiat_sm2_u1 = 0;
  fiat_sm2_subborrowx_u32(&mut x744, &mut x745, x743, x727, 0xffffffff);
  let mut x746: u32 = 0;
  let mut x747: fiat_sm2_u1 = 0;
  fiat_sm2_subborrowx_u32(&mut x746, &mut x747, x745, x729, (0x0 as u32));
  let mut x748: u32 = 0;
  let mut x749: fiat_sm2_u1 = 0;
  fiat_sm2_subborrowx_u32(&mut x748, &mut x749, x747, x731, 0xffffffff);
  let mut x750: u32 = 0;
  let mut x751: fiat_sm2_u1 = 0;
  fiat_sm2_subborrowx_u32(&mut x750, &mut x751, x749, x733, 0xffffffff);
  let mut x752: u32 = 0;
  let mut x753: fiat_sm2_u1 = 0;
  fiat_sm2_subborrowx_u32(&mut x752, &mut x753, x751, x735, 0xffffffff);
  let mut x754: u32 = 0;
  let mut x755: fiat_sm2_u1 = 0;
  fiat_sm2_subborrowx_u32(&mut x754, &mut x755, x753, x737, 0xffffffff);
  let mut x756: u32 = 0;
  let mut x757: fiat_sm2_u1 = 0;
  fiat_sm2_subborrowx_u32(&mut x756, &mut x757, x755, x739, 0xfffffffe);
  let mut x758: u32 = 0;
  let mut x759: fiat_sm2_u1 = 0;
  fiat_sm2_subborrowx_u32(&mut x758, &mut x759, x757, x741, (0x0 as u32));
  let mut x760: u32 = 0;
  fiat_sm2_cmovznz_u32(&mut x760, x759, x742, x725);
  let mut x761: u32 = 0;
  fiat_sm2_cmovznz_u32(&mut x761, x759, x744, x727);
  let mut x762: u32 = 0;
  fiat_sm2_cmovznz_u32(&mut x762, x759, x746, x729);
  let mut x763: u32 = 0;
  fiat_sm2_cmovznz_u32(&mut x763, x759, x748, x731);
  let mut x764: u32 = 0;
  fiat_sm2_cmovznz_u32(&mut x764, x759, x750, x733);
  let mut x765: u32 = 0;
  fiat_sm2_cmovznz_u32(&mut x765, x759, x752, x735);
  let mut x766: u32 = 0;
  fiat_sm2_cmovznz_u32(&mut x766, x759, x754, x737);
  let mut x767: u32 = 0;
  fiat_sm2_cmovznz_u32(&mut x767, x759, x756, x739);
  *IndexConst(&mut out1).index_mut(0) = x760;
  *IndexConst(&mut out1).index_mut(1) = x761;
  *IndexConst(&mut out1).index_mut(2) = x762;
  *IndexConst(&mut out1).index_mut(3) = x763;
  *IndexConst(&mut out1).index_mut(4) = x764;
  *IndexConst(&mut out1).index_mut(5) = x765;
  *IndexConst(&mut out1).index_mut(6) = x766;
  *IndexConst(&mut out1).index_mut(7) = x767;
}

/// The function fiat_sm2_add adds two field elements in the Montgomery domain.
///
/// Preconditions:
///   0 ≤ eval arg1 < m
///   0 ≤ eval arg2 < m
/// Postconditions:
///   eval (from_montgomery out1) mod m = (eval (from_montgomery arg1) + eval (from_montgomery arg2)) mod m
///   0 ≤ eval out1 < m
///
#[inline]
pub const fn fiat_sm2_add(mut out1: &mut fiat_sm2_montgomery_domain_field_element, arg1: &fiat_sm2_montgomery_domain_field_element, arg2: &fiat_sm2_montgomery_domain_field_element) {
  let mut x1: u32 = 0;
  let mut x2: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x1, &mut x2, 0x0, (*IndexConst(arg1).index(0)), (*IndexConst(arg2).index(0)));
  let mut x3: u32 = 0;
  let mut x4: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x3, &mut x4, x2, (*IndexConst(arg1).index(1)), (*IndexConst(arg2).index(1)));
  let mut x5: u32 = 0;
  let mut x6: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x5, &mut x6, x4, (*IndexConst(arg1).index(2)), (*IndexConst(arg2).index(2)));
  let mut x7: u32 = 0;
  let mut x8: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x7, &mut x8, x6, (*IndexConst(arg1).index(3)), (*IndexConst(arg2).index(3)));
  let mut x9: u32 = 0;
  let mut x10: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x9, &mut x10, x8, (*IndexConst(arg1).index(4)), (*IndexConst(arg2).index(4)));
  let mut x11: u32 = 0;
  let mut x12: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x11, &mut x12, x10, (*IndexConst(arg1).index(5)), (*IndexConst(arg2).index(5)));
  let mut x13: u32 = 0;
  let mut x14: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x13, &mut x14, x12, (*IndexConst(arg1).index(6)), (*IndexConst(arg2).index(6)));
  let mut x15: u32 = 0;
  let mut x16: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x15, &mut x16, x14, (*IndexConst(arg1).index(7)), (*IndexConst(arg2).index(7)));
  let mut x17: u32 = 0;
  let mut x18: fiat_sm2_u1 = 0;
  fiat_sm2_subborrowx_u32(&mut x17, &mut x18, 0x0, x1, 0xffffffff);
  let mut x19: u32 = 0;
  let mut x20: fiat_sm2_u1 = 0;
  fiat_sm2_subborrowx_u32(&mut x19, &mut x20, x18, x3, 0xffffffff);
  let mut x21: u32 = 0;
  let mut x22: fiat_sm2_u1 = 0;
  fiat_sm2_subborrowx_u32(&mut x21, &mut x22, x20, x5, (0x0 as u32));
  let mut x23: u32 = 0;
  let mut x24: fiat_sm2_u1 = 0;
  fiat_sm2_subborrowx_u32(&mut x23, &mut x24, x22, x7, 0xffffffff);
  let mut x25: u32 = 0;
  let mut x26: fiat_sm2_u1 = 0;
  fiat_sm2_subborrowx_u32(&mut x25, &mut x26, x24, x9, 0xffffffff);
  let mut x27: u32 = 0;
  let mut x28: fiat_sm2_u1 = 0;
  fiat_sm2_subborrowx_u32(&mut x27, &mut x28, x26, x11, 0xffffffff);
  let mut x29: u32 = 0;
  let mut x30: fiat_sm2_u1 = 0;
  fiat_sm2_subborrowx_u32(&mut x29, &mut x30, x28, x13, 0xffffffff);
  let mut x31: u32 = 0;
  let mut x32: fiat_sm2_u1 = 0;
  fiat_sm2_subborrowx_u32(&mut x31, &mut x32, x30, x15, 0xfffffffe);
  let mut x33: u32 = 0;
  let mut x34: fiat_sm2_u1 = 0;
  fiat_sm2_subborrowx_u32(&mut x33, &mut x34, x32, (x16 as u32), (0x0 as u32));
  let mut x35: u32 = 0;
  fiat_sm2_cmovznz_u32(&mut x35, x34, x17, x1);
  let mut x36: u32 = 0;
  fiat_sm2_cmovznz_u32(&mut x36, x34, x19, x3);
  let mut x37: u32 = 0;
  fiat_sm2_cmovznz_u32(&mut x37, x34, x21, x5);
  let mut x38: u32 = 0;
  fiat_sm2_cmovznz_u32(&mut x38, x34, x23, x7);
  let mut x39: u32 = 0;
  fiat_sm2_cmovznz_u32(&mut x39, x34, x25, x9);
  let mut x40: u32 = 0;
  fiat_sm2_cmovznz_u32(&mut x40, x34, x27, x11);
  let mut x41: u32 = 0;
  fiat_sm2_cmovznz_u32(&mut x41, x34, x29, x13);
  let mut x42: u32 = 0;
  fiat_sm2_cmovznz_u32(&mut x42, x34, x31, x15);
  *IndexConst(&mut out1).index_mut(0) = x35;
  *IndexConst(&mut out1).index_mut(1) = x36;
  *IndexConst(&mut out1).index_mut(2) = x37;
  *IndexConst(&mut out1).index_mut(3) = x38;
  *IndexConst(&mut out1).index_mut(4) = x39;
  *IndexConst(&mut out1).index_mut(5) = x40;
  *IndexConst(&mut out1).index_mut(6) = x41;
  *IndexConst(&mut out1).index_mut(7) = x42;
}

/// The function fiat_sm2_sub subtracts two field elements in the Montgomery domain.
///
/// Preconditions:
///   0 ≤ eval arg1 < m
///   0 ≤ eval arg2 < m
/// Postconditions:
///   eval (from_montgomery out1) mod m = (eval (from_montgomery arg1) - eval (from_montgomery arg2)) mod m
///   0 ≤ eval out1 < m
///
#[inline]
pub const fn fiat_sm2_sub(mut out1: &mut fiat_sm2_montgomery_domain_field_element, arg1: &fiat_sm2_montgomery_domain_field_element, arg2: &fiat_sm2_montgomery_domain_field_element) {
  let mut x1: u32 = 0;
  let mut x2: fiat_sm2_u1 = 0;
  fiat_sm2_subborrowx_u32(&mut x1, &mut x2, 0x0, (*IndexConst(arg1).index(0)), (*IndexConst(arg2).index(0)));
  let mut x3: u32 = 0;
  let mut x4: fiat_sm2_u1 = 0;
  fiat_sm2_subborrowx_u32(&mut x3, &mut x4, x2, (*IndexConst(arg1).index(1)), (*IndexConst(arg2).index(1)));
  let mut x5: u32 = 0;
  let mut x6: fiat_sm2_u1 = 0;
  fiat_sm2_subborrowx_u32(&mut x5, &mut x6, x4, (*IndexConst(arg1).index(2)), (*IndexConst(arg2).index(2)));
  let mut x7: u32 = 0;
  let mut x8: fiat_sm2_u1 = 0;
  fiat_sm2_subborrowx_u32(&mut x7, &mut x8, x6, (*IndexConst(arg1).index(3)), (*IndexConst(arg2).index(3)));
  let mut x9: u32 = 0;
  let mut x10: fiat_sm2_u1 = 0;
  fiat_sm2_subborrowx_u32(&mut x9, &mut x10, x8, (*IndexConst(arg1).index(4)), (*IndexConst(arg2).index(4)));
  let mut x11: u32 = 0;
  let mut x12: fiat_sm2_u1 = 0;
  fiat_sm2_subborrowx_u32(&mut x11, &mut x12, x10, (*IndexConst(arg1).index(5)), (*IndexConst(arg2).index(5)));
  let mut x13: u32 = 0;
  let mut x14: fiat_sm2_u1 = 0;
  fiat_sm2_subborrowx_u32(&mut x13, &mut x14, x12, (*IndexConst(arg1).index(6)), (*IndexConst(arg2).index(6)));
  let mut x15: u32 = 0;
  let mut x16: fiat_sm2_u1 = 0;
  fiat_sm2_subborrowx_u32(&mut x15, &mut x16, x14, (*IndexConst(arg1).index(7)), (*IndexConst(arg2).index(7)));
  let mut x17: u32 = 0;
  fiat_sm2_cmovznz_u32(&mut x17, x16, (0x0 as u32), 0xffffffff);
  let mut x18: u32 = 0;
  let mut x19: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x18, &mut x19, 0x0, x1, x17);
  let mut x20: u32 = 0;
  let mut x21: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x20, &mut x21, x19, x3, x17);
  let mut x22: u32 = 0;
  let mut x23: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x22, &mut x23, x21, x5, (0x0 as u32));
  let mut x24: u32 = 0;
  let mut x25: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x24, &mut x25, x23, x7, x17);
  let mut x26: u32 = 0;
  let mut x27: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x26, &mut x27, x25, x9, x17);
  let mut x28: u32 = 0;
  let mut x29: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x28, &mut x29, x27, x11, x17);
  let mut x30: u32 = 0;
  let mut x31: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x30, &mut x31, x29, x13, x17);
  let mut x32: u32 = 0;
  let mut x33: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x32, &mut x33, x31, x15, (x17 & 0xfffffffe));
  *IndexConst(&mut out1).index_mut(0) = x18;
  *IndexConst(&mut out1).index_mut(1) = x20;
  *IndexConst(&mut out1).index_mut(2) = x22;
  *IndexConst(&mut out1).index_mut(3) = x24;
  *IndexConst(&mut out1).index_mut(4) = x26;
  *IndexConst(&mut out1).index_mut(5) = x28;
  *IndexConst(&mut out1).index_mut(6) = x30;
  *IndexConst(&mut out1).index_mut(7) = x32;
}

/// The function fiat_sm2_opp negates a field element in the Montgomery domain.
///
/// Preconditions:
///   0 ≤ eval arg1 < m
/// Postconditions:
///   eval (from_montgomery out1) mod m = -eval (from_montgomery arg1) mod m
///   0 ≤ eval out1 < m
///
#[inline]
pub const fn fiat_sm2_opp(mut out1: &mut fiat_sm2_montgomery_domain_field_element, arg1: &fiat_sm2_montgomery_domain_field_element) {
  let mut x1: u32 = 0;
  let mut x2: fiat_sm2_u1 = 0;
  fiat_sm2_subborrowx_u32(&mut x1, &mut x2, 0x0, (0x0 as u32), (*IndexConst(arg1).index(0)));
  let mut x3: u32 = 0;
  let mut x4: fiat_sm2_u1 = 0;
  fiat_sm2_subborrowx_u32(&mut x3, &mut x4, x2, (0x0 as u32), (*IndexConst(arg1).index(1)));
  let mut x5: u32 = 0;
  let mut x6: fiat_sm2_u1 = 0;
  fiat_sm2_subborrowx_u32(&mut x5, &mut x6, x4, (0x0 as u32), (*IndexConst(arg1).index(2)));
  let mut x7: u32 = 0;
  let mut x8: fiat_sm2_u1 = 0;
  fiat_sm2_subborrowx_u32(&mut x7, &mut x8, x6, (0x0 as u32), (*IndexConst(arg1).index(3)));
  let mut x9: u32 = 0;
  let mut x10: fiat_sm2_u1 = 0;
  fiat_sm2_subborrowx_u32(&mut x9, &mut x10, x8, (0x0 as u32), (*IndexConst(arg1).index(4)));
  let mut x11: u32 = 0;
  let mut x12: fiat_sm2_u1 = 0;
  fiat_sm2_subborrowx_u32(&mut x11, &mut x12, x10, (0x0 as u32), (*IndexConst(arg1).index(5)));
  let mut x13: u32 = 0;
  let mut x14: fiat_sm2_u1 = 0;
  fiat_sm2_subborrowx_u32(&mut x13, &mut x14, x12, (0x0 as u32), (*IndexConst(arg1).index(6)));
  let mut x15: u32 = 0;
  let mut x16: fiat_sm2_u1 = 0;
  fiat_sm2_subborrowx_u32(&mut x15, &mut x16, x14, (0x0 as u32), (*IndexConst(arg1).index(7)));
  let mut x17: u32 = 0;
  fiat_sm2_cmovznz_u32(&mut x17, x16, (0x0 as u32), 0xffffffff);
  let mut x18: u32 = 0;
  let mut x19: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x18, &mut x19, 0x0, x1, x17);
  let mut x20: u32 = 0;
  let mut x21: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x20, &mut x21, x19, x3, x17);
  let mut x22: u32 = 0;
  let mut x23: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x22, &mut x23, x21, x5, (0x0 as u32));
  let mut x24: u32 = 0;
  let mut x25: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x24, &mut x25, x23, x7, x17);
  let mut x26: u32 = 0;
  let mut x27: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x26, &mut x27, x25, x9, x17);
  let mut x28: u32 = 0;
  let mut x29: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x28, &mut x29, x27, x11, x17);
  let mut x30: u32 = 0;
  let mut x31: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x30, &mut x31, x29, x13, x17);
  let mut x32: u32 = 0;
  let mut x33: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x32, &mut x33, x31, x15, (x17 & 0xfffffffe));
  *IndexConst(&mut out1).index_mut(0) = x18;
  *IndexConst(&mut out1).index_mut(1) = x20;
  *IndexConst(&mut out1).index_mut(2) = x22;
  *IndexConst(&mut out1).index_mut(3) = x24;
  *IndexConst(&mut out1).index_mut(4) = x26;
  *IndexConst(&mut out1).index_mut(5) = x28;
  *IndexConst(&mut out1).index_mut(6) = x30;
  *IndexConst(&mut out1).index_mut(7) = x32;
}

/// The function fiat_sm2_from_montgomery translates a field element out of the Montgomery domain.
///
/// Preconditions:
///   0 ≤ eval arg1 < m
/// Postconditions:
///   eval out1 mod m = (eval arg1 * ((2^32)⁻¹ mod m)^8) mod m
///   0 ≤ eval out1 < m
///
#[inline]
pub const fn fiat_sm2_from_montgomery(mut out1: &mut fiat_sm2_non_montgomery_domain_field_element, arg1: &fiat_sm2_montgomery_domain_field_element) {
  let x1: u32 = (*IndexConst(arg1).index(0));
  let mut x2: u32 = 0;
  let mut x3: u32 = 0;
  fiat_sm2_mulx_u32(&mut x2, &mut x3, x1, 0xfffffffe);
  let mut x4: u32 = 0;
  let mut x5: u32 = 0;
  fiat_sm2_mulx_u32(&mut x4, &mut x5, x1, 0xffffffff);
  let mut x6: u32 = 0;
  let mut x7: u32 = 0;
  fiat_sm2_mulx_u32(&mut x6, &mut x7, x1, 0xffffffff);
  let mut x8: u32 = 0;
  let mut x9: u32 = 0;
  fiat_sm2_mulx_u32(&mut x8, &mut x9, x1, 0xffffffff);
  let mut x10: u32 = 0;
  let mut x11: u32 = 0;
  fiat_sm2_mulx_u32(&mut x10, &mut x11, x1, 0xffffffff);
  let mut x12: u32 = 0;
  let mut x13: u32 = 0;
  fiat_sm2_mulx_u32(&mut x12, &mut x13, x1, 0xffffffff);
  let mut x14: u32 = 0;
  let mut x15: u32 = 0;
  fiat_sm2_mulx_u32(&mut x14, &mut x15, x1, 0xffffffff);
  let mut x16: u32 = 0;
  let mut x17: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x16, &mut x17, 0x0, x15, x12);
  let mut x18: u32 = 0;
  let mut x19: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x18, &mut x19, 0x0, x11, x8);
  let mut x20: u32 = 0;
  let mut x21: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x20, &mut x21, x19, x9, x6);
  let mut x22: u32 = 0;
  let mut x23: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x22, &mut x23, x21, x7, x4);
  let mut x24: u32 = 0;
  let mut x25: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x24, &mut x25, x23, x5, x2);
  let mut x26: u32 = 0;
  let mut x27: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x26, &mut x27, 0x0, x1, x14);
  let mut x28: u32 = 0;
  let mut x29: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x28, &mut x29, x27, (0x0 as u32), x16);
  let mut x30: u32 = 0;
  let mut x31: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x30, &mut x31, x29, (0x0 as u32), ((x17 as u32) + x13));
  let mut x32: u32 = 0;
  let mut x33: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x32, &mut x33, x31, (0x0 as u32), x10);
  let mut x34: u32 = 0;
  let mut x35: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x34, &mut x35, x33, (0x0 as u32), x18);
  let mut x36: u32 = 0;
  let mut x37: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x36, &mut x37, x35, (0x0 as u32), x20);
  let mut x38: u32 = 0;
  let mut x39: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x38, &mut x39, x37, (0x0 as u32), x22);
  let mut x40: u32 = 0;
  let mut x41: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x40, &mut x41, x39, (0x0 as u32), x24);
  let mut x42: u32 = 0;
  let mut x43: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x42, &mut x43, 0x0, x28, (*IndexConst(arg1).index(1)));
  let mut x44: u32 = 0;
  let mut x45: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x44, &mut x45, x43, x30, (0x0 as u32));
  let mut x46: u32 = 0;
  let mut x47: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x46, &mut x47, x45, x32, (0x0 as u32));
  let mut x48: u32 = 0;
  let mut x49: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x48, &mut x49, x47, x34, (0x0 as u32));
  let mut x50: u32 = 0;
  let mut x51: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x50, &mut x51, x49, x36, (0x0 as u32));
  let mut x52: u32 = 0;
  let mut x53: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x52, &mut x53, x51, x38, (0x0 as u32));
  let mut x54: u32 = 0;
  let mut x55: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x54, &mut x55, x53, x40, (0x0 as u32));
  let mut x56: u32 = 0;
  let mut x57: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x56, &mut x57, x55, ((x41 as u32) + ((x25 as u32) + x3)), (0x0 as u32));
  let mut x58: u32 = 0;
  let mut x59: u32 = 0;
  fiat_sm2_mulx_u32(&mut x58, &mut x59, x42, 0xfffffffe);
  let mut x60: u32 = 0;
  let mut x61: u32 = 0;
  fiat_sm2_mulx_u32(&mut x60, &mut x61, x42, 0xffffffff);
  let mut x62: u32 = 0;
  let mut x63: u32 = 0;
  fiat_sm2_mulx_u32(&mut x62, &mut x63, x42, 0xffffffff);
  let mut x64: u32 = 0;
  let mut x65: u32 = 0;
  fiat_sm2_mulx_u32(&mut x64, &mut x65, x42, 0xffffffff);
  let mut x66: u32 = 0;
  let mut x67: u32 = 0;
  fiat_sm2_mulx_u32(&mut x66, &mut x67, x42, 0xffffffff);
  let mut x68: u32 = 0;
  let mut x69: u32 = 0;
  fiat_sm2_mulx_u32(&mut x68, &mut x69, x42, 0xffffffff);
  let mut x70: u32 = 0;
  let mut x71: u32 = 0;
  fiat_sm2_mulx_u32(&mut x70, &mut x71, x42, 0xffffffff);
  let mut x72: u32 = 0;
  let mut x73: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x72, &mut x73, 0x0, x71, x68);
  let mut x74: u32 = 0;
  let mut x75: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x74, &mut x75, 0x0, x67, x64);
  let mut x76: u32 = 0;
  let mut x77: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x76, &mut x77, x75, x65, x62);
  let mut x78: u32 = 0;
  let mut x79: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x78, &mut x79, x77, x63, x60);
  let mut x80: u32 = 0;
  let mut x81: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x80, &mut x81, x79, x61, x58);
  let mut x82: u32 = 0;
  let mut x83: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x82, &mut x83, 0x0, x42, x70);
  let mut x84: u32 = 0;
  let mut x85: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x84, &mut x85, x83, x44, x72);
  let mut x86: u32 = 0;
  let mut x87: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x86, &mut x87, x85, x46, ((x73 as u32) + x69));
  let mut x88: u32 = 0;
  let mut x89: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x88, &mut x89, x87, x48, x66);
  let mut x90: u32 = 0;
  let mut x91: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x90, &mut x91, x89, x50, x74);
  let mut x92: u32 = 0;
  let mut x93: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x92, &mut x93, x91, x52, x76);
  let mut x94: u32 = 0;
  let mut x95: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x94, &mut x95, x93, x54, x78);
  let mut x96: u32 = 0;
  let mut x97: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x96, &mut x97, x95, x56, x80);
  let mut x98: u32 = 0;
  let mut x99: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x98, &mut x99, x97, (x57 as u32), ((x81 as u32) + x59));
  let mut x100: u32 = 0;
  let mut x101: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x100, &mut x101, 0x0, x84, (*IndexConst(arg1).index(2)));
  let mut x102: u32 = 0;
  let mut x103: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x102, &mut x103, x101, x86, (0x0 as u32));
  let mut x104: u32 = 0;
  let mut x105: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x104, &mut x105, x103, x88, (0x0 as u32));
  let mut x106: u32 = 0;
  let mut x107: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x106, &mut x107, x105, x90, (0x0 as u32));
  let mut x108: u32 = 0;
  let mut x109: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x108, &mut x109, x107, x92, (0x0 as u32));
  let mut x110: u32 = 0;
  let mut x111: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x110, &mut x111, x109, x94, (0x0 as u32));
  let mut x112: u32 = 0;
  let mut x113: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x112, &mut x113, x111, x96, (0x0 as u32));
  let mut x114: u32 = 0;
  let mut x115: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x114, &mut x115, x113, x98, (0x0 as u32));
  let mut x116: u32 = 0;
  let mut x117: u32 = 0;
  fiat_sm2_mulx_u32(&mut x116, &mut x117, x100, 0xfffffffe);
  let mut x118: u32 = 0;
  let mut x119: u32 = 0;
  fiat_sm2_mulx_u32(&mut x118, &mut x119, x100, 0xffffffff);
  let mut x120: u32 = 0;
  let mut x121: u32 = 0;
  fiat_sm2_mulx_u32(&mut x120, &mut x121, x100, 0xffffffff);
  let mut x122: u32 = 0;
  let mut x123: u32 = 0;
  fiat_sm2_mulx_u32(&mut x122, &mut x123, x100, 0xffffffff);
  let mut x124: u32 = 0;
  let mut x125: u32 = 0;
  fiat_sm2_mulx_u32(&mut x124, &mut x125, x100, 0xffffffff);
  let mut x126: u32 = 0;
  let mut x127: u32 = 0;
  fiat_sm2_mulx_u32(&mut x126, &mut x127, x100, 0xffffffff);
  let mut x128: u32 = 0;
  let mut x129: u32 = 0;
  fiat_sm2_mulx_u32(&mut x128, &mut x129, x100, 0xffffffff);
  let mut x130: u32 = 0;
  let mut x131: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x130, &mut x131, 0x0, x129, x126);
  let mut x132: u32 = 0;
  let mut x133: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x132, &mut x133, 0x0, x125, x122);
  let mut x134: u32 = 0;
  let mut x135: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x134, &mut x135, x133, x123, x120);
  let mut x136: u32 = 0;
  let mut x137: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x136, &mut x137, x135, x121, x118);
  let mut x138: u32 = 0;
  let mut x139: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x138, &mut x139, x137, x119, x116);
  let mut x140: u32 = 0;
  let mut x141: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x140, &mut x141, 0x0, x100, x128);
  let mut x142: u32 = 0;
  let mut x143: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x142, &mut x143, x141, x102, x130);
  let mut x144: u32 = 0;
  let mut x145: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x144, &mut x145, x143, x104, ((x131 as u32) + x127));
  let mut x146: u32 = 0;
  let mut x147: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x146, &mut x147, x145, x106, x124);
  let mut x148: u32 = 0;
  let mut x149: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x148, &mut x149, x147, x108, x132);
  let mut x150: u32 = 0;
  let mut x151: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x150, &mut x151, x149, x110, x134);
  let mut x152: u32 = 0;
  let mut x153: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x152, &mut x153, x151, x112, x136);
  let mut x154: u32 = 0;
  let mut x155: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x154, &mut x155, x153, x114, x138);
  let mut x156: u32 = 0;
  let mut x157: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x156, &mut x157, x155, ((x115 as u32) + (x99 as u32)), ((x139 as u32) + x117));
  let mut x158: u32 = 0;
  let mut x159: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x158, &mut x159, 0x0, x142, (*IndexConst(arg1).index(3)));
  let mut x160: u32 = 0;
  let mut x161: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x160, &mut x161, x159, x144, (0x0 as u32));
  let mut x162: u32 = 0;
  let mut x163: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x162, &mut x163, x161, x146, (0x0 as u32));
  let mut x164: u32 = 0;
  let mut x165: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x164, &mut x165, x163, x148, (0x0 as u32));
  let mut x166: u32 = 0;
  let mut x167: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x166, &mut x167, x165, x150, (0x0 as u32));
  let mut x168: u32 = 0;
  let mut x169: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x168, &mut x169, x167, x152, (0x0 as u32));
  let mut x170: u32 = 0;
  let mut x171: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x170, &mut x171, x169, x154, (0x0 as u32));
  let mut x172: u32 = 0;
  let mut x173: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x172, &mut x173, x171, x156, (0x0 as u32));
  let mut x174: u32 = 0;
  let mut x175: u32 = 0;
  fiat_sm2_mulx_u32(&mut x174, &mut x175, x158, 0xfffffffe);
  let mut x176: u32 = 0;
  let mut x177: u32 = 0;
  fiat_sm2_mulx_u32(&mut x176, &mut x177, x158, 0xffffffff);
  let mut x178: u32 = 0;
  let mut x179: u32 = 0;
  fiat_sm2_mulx_u32(&mut x178, &mut x179, x158, 0xffffffff);
  let mut x180: u32 = 0;
  let mut x181: u32 = 0;
  fiat_sm2_mulx_u32(&mut x180, &mut x181, x158, 0xffffffff);
  let mut x182: u32 = 0;
  let mut x183: u32 = 0;
  fiat_sm2_mulx_u32(&mut x182, &mut x183, x158, 0xffffffff);
  let mut x184: u32 = 0;
  let mut x185: u32 = 0;
  fiat_sm2_mulx_u32(&mut x184, &mut x185, x158, 0xffffffff);
  let mut x186: u32 = 0;
  let mut x187: u32 = 0;
  fiat_sm2_mulx_u32(&mut x186, &mut x187, x158, 0xffffffff);
  let mut x188: u32 = 0;
  let mut x189: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x188, &mut x189, 0x0, x187, x184);
  let mut x190: u32 = 0;
  let mut x191: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x190, &mut x191, 0x0, x183, x180);
  let mut x192: u32 = 0;
  let mut x193: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x192, &mut x193, x191, x181, x178);
  let mut x194: u32 = 0;
  let mut x195: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x194, &mut x195, x193, x179, x176);
  let mut x196: u32 = 0;
  let mut x197: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x196, &mut x197, x195, x177, x174);
  let mut x198: u32 = 0;
  let mut x199: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x198, &mut x199, 0x0, x158, x186);
  let mut x200: u32 = 0;
  let mut x201: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x200, &mut x201, x199, x160, x188);
  let mut x202: u32 = 0;
  let mut x203: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x202, &mut x203, x201, x162, ((x189 as u32) + x185));
  let mut x204: u32 = 0;
  let mut x205: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x204, &mut x205, x203, x164, x182);
  let mut x206: u32 = 0;
  let mut x207: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x206, &mut x207, x205, x166, x190);
  let mut x208: u32 = 0;
  let mut x209: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x208, &mut x209, x207, x168, x192);
  let mut x210: u32 = 0;
  let mut x211: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x210, &mut x211, x209, x170, x194);
  let mut x212: u32 = 0;
  let mut x213: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x212, &mut x213, x211, x172, x196);
  let mut x214: u32 = 0;
  let mut x215: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x214, &mut x215, x213, ((x173 as u32) + (x157 as u32)), ((x197 as u32) + x175));
  let mut x216: u32 = 0;
  let mut x217: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x216, &mut x217, 0x0, x200, (*IndexConst(arg1).index(4)));
  let mut x218: u32 = 0;
  let mut x219: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x218, &mut x219, x217, x202, (0x0 as u32));
  let mut x220: u32 = 0;
  let mut x221: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x220, &mut x221, x219, x204, (0x0 as u32));
  let mut x222: u32 = 0;
  let mut x223: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x222, &mut x223, x221, x206, (0x0 as u32));
  let mut x224: u32 = 0;
  let mut x225: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x224, &mut x225, x223, x208, (0x0 as u32));
  let mut x226: u32 = 0;
  let mut x227: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x226, &mut x227, x225, x210, (0x0 as u32));
  let mut x228: u32 = 0;
  let mut x229: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x228, &mut x229, x227, x212, (0x0 as u32));
  let mut x230: u32 = 0;
  let mut x231: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x230, &mut x231, x229, x214, (0x0 as u32));
  let mut x232: u32 = 0;
  let mut x233: u32 = 0;
  fiat_sm2_mulx_u32(&mut x232, &mut x233, x216, 0xfffffffe);
  let mut x234: u32 = 0;
  let mut x235: u32 = 0;
  fiat_sm2_mulx_u32(&mut x234, &mut x235, x216, 0xffffffff);
  let mut x236: u32 = 0;
  let mut x237: u32 = 0;
  fiat_sm2_mulx_u32(&mut x236, &mut x237, x216, 0xffffffff);
  let mut x238: u32 = 0;
  let mut x239: u32 = 0;
  fiat_sm2_mulx_u32(&mut x238, &mut x239, x216, 0xffffffff);
  let mut x240: u32 = 0;
  let mut x241: u32 = 0;
  fiat_sm2_mulx_u32(&mut x240, &mut x241, x216, 0xffffffff);
  let mut x242: u32 = 0;
  let mut x243: u32 = 0;
  fiat_sm2_mulx_u32(&mut x242, &mut x243, x216, 0xffffffff);
  let mut x244: u32 = 0;
  let mut x245: u32 = 0;
  fiat_sm2_mulx_u32(&mut x244, &mut x245, x216, 0xffffffff);
  let mut x246: u32 = 0;
  let mut x247: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x246, &mut x247, 0x0, x245, x242);
  let mut x248: u32 = 0;
  let mut x249: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x248, &mut x249, 0x0, x241, x238);
  let mut x250: u32 = 0;
  let mut x251: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x250, &mut x251, x249, x239, x236);
  let mut x252: u32 = 0;
  let mut x253: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x252, &mut x253, x251, x237, x234);
  let mut x254: u32 = 0;
  let mut x255: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x254, &mut x255, x253, x235, x232);
  let mut x256: u32 = 0;
  let mut x257: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x256, &mut x257, 0x0, x216, x244);
  let mut x258: u32 = 0;
  let mut x259: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x258, &mut x259, x257, x218, x246);
  let mut x260: u32 = 0;
  let mut x261: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x260, &mut x261, x259, x220, ((x247 as u32) + x243));
  let mut x262: u32 = 0;
  let mut x263: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x262, &mut x263, x261, x222, x240);
  let mut x264: u32 = 0;
  let mut x265: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x264, &mut x265, x263, x224, x248);
  let mut x266: u32 = 0;
  let mut x267: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x266, &mut x267, x265, x226, x250);
  let mut x268: u32 = 0;
  let mut x269: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x268, &mut x269, x267, x228, x252);
  let mut x270: u32 = 0;
  let mut x271: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x270, &mut x271, x269, x230, x254);
  let mut x272: u32 = 0;
  let mut x273: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x272, &mut x273, x271, ((x231 as u32) + (x215 as u32)), ((x255 as u32) + x233));
  let mut x274: u32 = 0;
  let mut x275: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x274, &mut x275, 0x0, x258, (*IndexConst(arg1).index(5)));
  let mut x276: u32 = 0;
  let mut x277: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x276, &mut x277, x275, x260, (0x0 as u32));
  let mut x278: u32 = 0;
  let mut x279: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x278, &mut x279, x277, x262, (0x0 as u32));
  let mut x280: u32 = 0;
  let mut x281: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x280, &mut x281, x279, x264, (0x0 as u32));
  let mut x282: u32 = 0;
  let mut x283: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x282, &mut x283, x281, x266, (0x0 as u32));
  let mut x284: u32 = 0;
  let mut x285: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x284, &mut x285, x283, x268, (0x0 as u32));
  let mut x286: u32 = 0;
  let mut x287: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x286, &mut x287, x285, x270, (0x0 as u32));
  let mut x288: u32 = 0;
  let mut x289: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x288, &mut x289, x287, x272, (0x0 as u32));
  let mut x290: u32 = 0;
  let mut x291: u32 = 0;
  fiat_sm2_mulx_u32(&mut x290, &mut x291, x274, 0xfffffffe);
  let mut x292: u32 = 0;
  let mut x293: u32 = 0;
  fiat_sm2_mulx_u32(&mut x292, &mut x293, x274, 0xffffffff);
  let mut x294: u32 = 0;
  let mut x295: u32 = 0;
  fiat_sm2_mulx_u32(&mut x294, &mut x295, x274, 0xffffffff);
  let mut x296: u32 = 0;
  let mut x297: u32 = 0;
  fiat_sm2_mulx_u32(&mut x296, &mut x297, x274, 0xffffffff);
  let mut x298: u32 = 0;
  let mut x299: u32 = 0;
  fiat_sm2_mulx_u32(&mut x298, &mut x299, x274, 0xffffffff);
  let mut x300: u32 = 0;
  let mut x301: u32 = 0;
  fiat_sm2_mulx_u32(&mut x300, &mut x301, x274, 0xffffffff);
  let mut x302: u32 = 0;
  let mut x303: u32 = 0;
  fiat_sm2_mulx_u32(&mut x302, &mut x303, x274, 0xffffffff);
  let mut x304: u32 = 0;
  let mut x305: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x304, &mut x305, 0x0, x303, x300);
  let mut x306: u32 = 0;
  let mut x307: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x306, &mut x307, 0x0, x299, x296);
  let mut x308: u32 = 0;
  let mut x309: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x308, &mut x309, x307, x297, x294);
  let mut x310: u32 = 0;
  let mut x311: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x310, &mut x311, x309, x295, x292);
  let mut x312: u32 = 0;
  let mut x313: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x312, &mut x313, x311, x293, x290);
  let mut x314: u32 = 0;
  let mut x315: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x314, &mut x315, 0x0, x274, x302);
  let mut x316: u32 = 0;
  let mut x317: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x316, &mut x317, x315, x276, x304);
  let mut x318: u32 = 0;
  let mut x319: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x318, &mut x319, x317, x278, ((x305 as u32) + x301));
  let mut x320: u32 = 0;
  let mut x321: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x320, &mut x321, x319, x280, x298);
  let mut x322: u32 = 0;
  let mut x323: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x322, &mut x323, x321, x282, x306);
  let mut x324: u32 = 0;
  let mut x325: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x324, &mut x325, x323, x284, x308);
  let mut x326: u32 = 0;
  let mut x327: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x326, &mut x327, x325, x286, x310);
  let mut x328: u32 = 0;
  let mut x329: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x328, &mut x329, x327, x288, x312);
  let mut x330: u32 = 0;
  let mut x331: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x330, &mut x331, x329, ((x289 as u32) + (x273 as u32)), ((x313 as u32) + x291));
  let mut x332: u32 = 0;
  let mut x333: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x332, &mut x333, 0x0, x316, (*IndexConst(arg1).index(6)));
  let mut x334: u32 = 0;
  let mut x335: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x334, &mut x335, x333, x318, (0x0 as u32));
  let mut x336: u32 = 0;
  let mut x337: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x336, &mut x337, x335, x320, (0x0 as u32));
  let mut x338: u32 = 0;
  let mut x339: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x338, &mut x339, x337, x322, (0x0 as u32));
  let mut x340: u32 = 0;
  let mut x341: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x340, &mut x341, x339, x324, (0x0 as u32));
  let mut x342: u32 = 0;
  let mut x343: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x342, &mut x343, x341, x326, (0x0 as u32));
  let mut x344: u32 = 0;
  let mut x345: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x344, &mut x345, x343, x328, (0x0 as u32));
  let mut x346: u32 = 0;
  let mut x347: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x346, &mut x347, x345, x330, (0x0 as u32));
  let mut x348: u32 = 0;
  let mut x349: u32 = 0;
  fiat_sm2_mulx_u32(&mut x348, &mut x349, x332, 0xfffffffe);
  let mut x350: u32 = 0;
  let mut x351: u32 = 0;
  fiat_sm2_mulx_u32(&mut x350, &mut x351, x332, 0xffffffff);
  let mut x352: u32 = 0;
  let mut x353: u32 = 0;
  fiat_sm2_mulx_u32(&mut x352, &mut x353, x332, 0xffffffff);
  let mut x354: u32 = 0;
  let mut x355: u32 = 0;
  fiat_sm2_mulx_u32(&mut x354, &mut x355, x332, 0xffffffff);
  let mut x356: u32 = 0;
  let mut x357: u32 = 0;
  fiat_sm2_mulx_u32(&mut x356, &mut x357, x332, 0xffffffff);
  let mut x358: u32 = 0;
  let mut x359: u32 = 0;
  fiat_sm2_mulx_u32(&mut x358, &mut x359, x332, 0xffffffff);
  let mut x360: u32 = 0;
  let mut x361: u32 = 0;
  fiat_sm2_mulx_u32(&mut x360, &mut x361, x332, 0xffffffff);
  let mut x362: u32 = 0;
  let mut x363: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x362, &mut x363, 0x0, x361, x358);
  let mut x364: u32 = 0;
  let mut x365: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x364, &mut x365, 0x0, x357, x354);
  let mut x366: u32 = 0;
  let mut x367: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x366, &mut x367, x365, x355, x352);
  let mut x368: u32 = 0;
  let mut x369: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x368, &mut x369, x367, x353, x350);
  let mut x370: u32 = 0;
  let mut x371: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x370, &mut x371, x369, x351, x348);
  let mut x372: u32 = 0;
  let mut x373: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x372, &mut x373, 0x0, x332, x360);
  let mut x374: u32 = 0;
  let mut x375: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x374, &mut x375, x373, x334, x362);
  let mut x376: u32 = 0;
  let mut x377: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x376, &mut x377, x375, x336, ((x363 as u32) + x359));
  let mut x378: u32 = 0;
  let mut x379: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x378, &mut x379, x377, x338, x356);
  let mut x380: u32 = 0;
  let mut x381: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x380, &mut x381, x379, x340, x364);
  let mut x382: u32 = 0;
  let mut x383: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x382, &mut x383, x381, x342, x366);
  let mut x384: u32 = 0;
  let mut x385: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x384, &mut x385, x383, x344, x368);
  let mut x386: u32 = 0;
  let mut x387: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x386, &mut x387, x385, x346, x370);
  let mut x388: u32 = 0;
  let mut x389: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x388, &mut x389, x387, ((x347 as u32) + (x331 as u32)), ((x371 as u32) + x349));
  let mut x390: u32 = 0;
  let mut x391: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x390, &mut x391, 0x0, x374, (*IndexConst(arg1).index(7)));
  let mut x392: u32 = 0;
  let mut x393: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x392, &mut x393, x391, x376, (0x0 as u32));
  let mut x394: u32 = 0;
  let mut x395: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x394, &mut x395, x393, x378, (0x0 as u32));
  let mut x396: u32 = 0;
  let mut x397: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x396, &mut x397, x395, x380, (0x0 as u32));
  let mut x398: u32 = 0;
  let mut x399: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x398, &mut x399, x397, x382, (0x0 as u32));
  let mut x400: u32 = 0;
  let mut x401: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x400, &mut x401, x399, x384, (0x0 as u32));
  let mut x402: u32 = 0;
  let mut x403: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x402, &mut x403, x401, x386, (0x0 as u32));
  let mut x404: u32 = 0;
  let mut x405: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x404, &mut x405, x403, x388, (0x0 as u32));
  let mut x406: u32 = 0;
  let mut x407: u32 = 0;
  fiat_sm2_mulx_u32(&mut x406, &mut x407, x390, 0xfffffffe);
  let mut x408: u32 = 0;
  let mut x409: u32 = 0;
  fiat_sm2_mulx_u32(&mut x408, &mut x409, x390, 0xffffffff);
  let mut x410: u32 = 0;
  let mut x411: u32 = 0;
  fiat_sm2_mulx_u32(&mut x410, &mut x411, x390, 0xffffffff);
  let mut x412: u32 = 0;
  let mut x413: u32 = 0;
  fiat_sm2_mulx_u32(&mut x412, &mut x413, x390, 0xffffffff);
  let mut x414: u32 = 0;
  let mut x415: u32 = 0;
  fiat_sm2_mulx_u32(&mut x414, &mut x415, x390, 0xffffffff);
  let mut x416: u32 = 0;
  let mut x417: u32 = 0;
  fiat_sm2_mulx_u32(&mut x416, &mut x417, x390, 0xffffffff);
  let mut x418: u32 = 0;
  let mut x419: u32 = 0;
  fiat_sm2_mulx_u32(&mut x418, &mut x419, x390, 0xffffffff);
  let mut x420: u32 = 0;
  let mut x421: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x420, &mut x421, 0x0, x419, x416);
  let mut x422: u32 = 0;
  let mut x423: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x422, &mut x423, 0x0, x415, x412);
  let mut x424: u32 = 0;
  let mut x425: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x424, &mut x425, x423, x413, x410);
  let mut x426: u32 = 0;
  let mut x427: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x426, &mut x427, x425, x411, x408);
  let mut x428: u32 = 0;
  let mut x429: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x428, &mut x429, x427, x409, x406);
  let mut x430: u32 = 0;
  let mut x431: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x430, &mut x431, 0x0, x390, x418);
  let mut x432: u32 = 0;
  let mut x433: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x432, &mut x433, x431, x392, x420);
  let mut x434: u32 = 0;
  let mut x435: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x434, &mut x435, x433, x394, ((x421 as u32) + x417));
  let mut x436: u32 = 0;
  let mut x437: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x436, &mut x437, x435, x396, x414);
  let mut x438: u32 = 0;
  let mut x439: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x438, &mut x439, x437, x398, x422);
  let mut x440: u32 = 0;
  let mut x441: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x440, &mut x441, x439, x400, x424);
  let mut x442: u32 = 0;
  let mut x443: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x442, &mut x443, x441, x402, x426);
  let mut x444: u32 = 0;
  let mut x445: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x444, &mut x445, x443, x404, x428);
  let mut x446: u32 = 0;
  let mut x447: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x446, &mut x447, x445, ((x405 as u32) + (x389 as u32)), ((x429 as u32) + x407));
  let mut x448: u32 = 0;
  let mut x449: fiat_sm2_u1 = 0;
  fiat_sm2_subborrowx_u32(&mut x448, &mut x449, 0x0, x432, 0xffffffff);
  let mut x450: u32 = 0;
  let mut x451: fiat_sm2_u1 = 0;
  fiat_sm2_subborrowx_u32(&mut x450, &mut x451, x449, x434, 0xffffffff);
  let mut x452: u32 = 0;
  let mut x453: fiat_sm2_u1 = 0;
  fiat_sm2_subborrowx_u32(&mut x452, &mut x453, x451, x436, (0x0 as u32));
  let mut x454: u32 = 0;
  let mut x455: fiat_sm2_u1 = 0;
  fiat_sm2_subborrowx_u32(&mut x454, &mut x455, x453, x438, 0xffffffff);
  let mut x456: u32 = 0;
  let mut x457: fiat_sm2_u1 = 0;
  fiat_sm2_subborrowx_u32(&mut x456, &mut x457, x455, x440, 0xffffffff);
  let mut x458: u32 = 0;
  let mut x459: fiat_sm2_u1 = 0;
  fiat_sm2_subborrowx_u32(&mut x458, &mut x459, x457, x442, 0xffffffff);
  let mut x460: u32 = 0;
  let mut x461: fiat_sm2_u1 = 0;
  fiat_sm2_subborrowx_u32(&mut x460, &mut x461, x459, x444, 0xffffffff);
  let mut x462: u32 = 0;
  let mut x463: fiat_sm2_u1 = 0;
  fiat_sm2_subborrowx_u32(&mut x462, &mut x463, x461, x446, 0xfffffffe);
  let mut x464: u32 = 0;
  let mut x465: fiat_sm2_u1 = 0;
  fiat_sm2_subborrowx_u32(&mut x464, &mut x465, x463, (x447 as u32), (0x0 as u32));
  let mut x466: u32 = 0;
  fiat_sm2_cmovznz_u32(&mut x466, x465, x448, x432);
  let mut x467: u32 = 0;
  fiat_sm2_cmovznz_u32(&mut x467, x465, x450, x434);
  let mut x468: u32 = 0;
  fiat_sm2_cmovznz_u32(&mut x468, x465, x452, x436);
  let mut x469: u32 = 0;
  fiat_sm2_cmovznz_u32(&mut x469, x465, x454, x438);
  let mut x470: u32 = 0;
  fiat_sm2_cmovznz_u32(&mut x470, x465, x456, x440);
  let mut x471: u32 = 0;
  fiat_sm2_cmovznz_u32(&mut x471, x465, x458, x442);
  let mut x472: u32 = 0;
  fiat_sm2_cmovznz_u32(&mut x472, x465, x460, x444);
  let mut x473: u32 = 0;
  fiat_sm2_cmovznz_u32(&mut x473, x465, x462, x446);
  *IndexConst(&mut out1).index_mut(0) = x466;
  *IndexConst(&mut out1).index_mut(1) = x467;
  *IndexConst(&mut out1).index_mut(2) = x468;
  *IndexConst(&mut out1).index_mut(3) = x469;
  *IndexConst(&mut out1).index_mut(4) = x470;
  *IndexConst(&mut out1).index_mut(5) = x471;
  *IndexConst(&mut out1).index_mut(6) = x472;
  *IndexConst(&mut out1).index_mut(7) = x473;
}

/// The function fiat_sm2_to_montgomery translates a field element into the Montgomery domain.
///
/// Preconditions:
///   0 ≤ eval arg1 < m
/// Postconditions:
///   eval (from_montgomery out1) mod m = eval arg1 mod m
///   0 ≤ eval out1 < m
///
#[inline]
pub const fn fiat_sm2_to_montgomery(mut out1: &mut fiat_sm2_montgomery_domain_field_element, arg1: &fiat_sm2_non_montgomery_domain_field_element) {
  let x1: u32 = (*IndexConst(arg1).index(1));
  let x2: u32 = (*IndexConst(arg1).index(2));
  let x3: u32 = (*IndexConst(arg1).index(3));
  let x4: u32 = (*IndexConst(arg1).index(4));
  let x5: u32 = (*IndexConst(arg1).index(5));
  let x6: u32 = (*IndexConst(arg1).index(6));
  let x7: u32 = (*IndexConst(arg1).index(7));
  let x8: u32 = (*IndexConst(arg1).index(0));
  let mut x9: u32 = 0;
  let mut x10: u32 = 0;
  fiat_sm2_mulx_u32(&mut x9, &mut x10, x8, 0x4);
  let mut x11: u32 = 0;
  let mut x12: u32 = 0;
  fiat_sm2_mulx_u32(&mut x11, &mut x12, x8, 0x2);
  let mut x13: u32 = 0;
  let mut x14: u32 = 0;
  fiat_sm2_mulx_u32(&mut x13, &mut x14, x8, 0x2);
  let mut x15: u32 = 0;
  let mut x16: u32 = 0;
  fiat_sm2_mulx_u32(&mut x15, &mut x16, x8, 0xffffffff);
  let mut x17: u32 = 0;
  let mut x18: u32 = 0;
  fiat_sm2_mulx_u32(&mut x17, &mut x18, x8, 0x2);
  let mut x19: u32 = 0;
  let mut x20: u32 = 0;
  fiat_sm2_mulx_u32(&mut x19, &mut x20, x8, 0x3);
  let mut x21: u32 = 0;
  let mut x22: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x21, &mut x22, 0x0, x20, x17);
  let mut x23: u32 = 0;
  let mut x24: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x23, &mut x24, x22, ((x18 as fiat_sm2_u1) as u32), x15);
  let mut x25: u32 = 0;
  let mut x26: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x25, &mut x26, x24, x16, x13);
  let mut x27: u32 = 0;
  let mut x28: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x27, &mut x28, x26, ((x14 as fiat_sm2_u1) as u32), x8);
  let mut x29: u32 = 0;
  let mut x30: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x29, &mut x30, x28, (0x0 as u32), x8);
  let mut x31: u32 = 0;
  let mut x32: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x31, &mut x32, x30, (0x0 as u32), x11);
  let mut x33: u32 = 0;
  let mut x34: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x33, &mut x34, x32, ((x12 as fiat_sm2_u1) as u32), x9);
  let mut x35: u32 = 0;
  let mut x36: u32 = 0;
  fiat_sm2_mulx_u32(&mut x35, &mut x36, x19, 0xfffffffe);
  let mut x37: u32 = 0;
  let mut x38: u32 = 0;
  fiat_sm2_mulx_u32(&mut x37, &mut x38, x19, 0xffffffff);
  let mut x39: u32 = 0;
  let mut x40: u32 = 0;
  fiat_sm2_mulx_u32(&mut x39, &mut x40, x19, 0xffffffff);
  let mut x41: u32 = 0;
  let mut x42: u32 = 0;
  fiat_sm2_mulx_u32(&mut x41, &mut x42, x19, 0xffffffff);
  let mut x43: u32 = 0;
  let mut x44: u32 = 0;
  fiat_sm2_mulx_u32(&mut x43, &mut x44, x19, 0xffffffff);
  let mut x45: u32 = 0;
  let mut x46: u32 = 0;
  fiat_sm2_mulx_u32(&mut x45, &mut x46, x19, 0xffffffff);
  let mut x47: u32 = 0;
  let mut x48: u32 = 0;
  fiat_sm2_mulx_u32(&mut x47, &mut x48, x19, 0xffffffff);
  let mut x49: u32 = 0;
  let mut x50: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x49, &mut x50, 0x0, x48, x45);
  let mut x51: u32 = 0;
  let mut x52: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x51, &mut x52, 0x0, x44, x41);
  let mut x53: u32 = 0;
  let mut x54: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x53, &mut x54, x52, x42, x39);
  let mut x55: u32 = 0;
  let mut x56: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x55, &mut x56, x54, x40, x37);
  let mut x57: u32 = 0;
  let mut x58: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x57, &mut x58, x56, x38, x35);
  let mut x59: u32 = 0;
  let mut x60: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x59, &mut x60, 0x0, x19, x47);
  let mut x61: u32 = 0;
  let mut x62: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x61, &mut x62, x60, x21, x49);
  let mut x63: u32 = 0;
  let mut x64: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x63, &mut x64, x62, x23, ((x50 as u32) + x46));
  let mut x65: u32 = 0;
  let mut x66: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x65, &mut x66, x64, x25, x43);
  let mut x67: u32 = 0;
  let mut x68: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x67, &mut x68, x66, x27, x51);
  let mut x69: u32 = 0;
  let mut x70: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x69, &mut x70, x68, x29, x53);
  let mut x71: u32 = 0;
  let mut x72: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x71, &mut x72, x70, x31, x55);
  let mut x73: u32 = 0;
  let mut x74: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x73, &mut x74, x72, x33, x57);
  let mut x75: u32 = 0;
  let mut x76: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x75, &mut x76, x74, ((x34 as u32) + x10), ((x58 as u32) + x36));
  let mut x77: u32 = 0;
  let mut x78: u32 = 0;
  fiat_sm2_mulx_u32(&mut x77, &mut x78, x1, 0x4);
  let mut x79: u32 = 0;
  let mut x80: u32 = 0;
  fiat_sm2_mulx_u32(&mut x79, &mut x80, x1, 0x2);
  let mut x81: u32 = 0;
  let mut x82: u32 = 0;
  fiat_sm2_mulx_u32(&mut x81, &mut x82, x1, 0x2);
  let mut x83: u32 = 0;
  let mut x84: u32 = 0;
  fiat_sm2_mulx_u32(&mut x83, &mut x84, x1, 0xffffffff);
  let mut x85: u32 = 0;
  let mut x86: u32 = 0;
  fiat_sm2_mulx_u32(&mut x85, &mut x86, x1, 0x2);
  let mut x87: u32 = 0;
  let mut x88: u32 = 0;
  fiat_sm2_mulx_u32(&mut x87, &mut x88, x1, 0x3);
  let mut x89: u32 = 0;
  let mut x90: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x89, &mut x90, 0x0, x88, x85);
  let mut x91: u32 = 0;
  let mut x92: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x91, &mut x92, x90, ((x86 as fiat_sm2_u1) as u32), x83);
  let mut x93: u32 = 0;
  let mut x94: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x93, &mut x94, x92, x84, x81);
  let mut x95: u32 = 0;
  let mut x96: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x95, &mut x96, x94, ((x82 as fiat_sm2_u1) as u32), x1);
  let mut x97: u32 = 0;
  let mut x98: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x97, &mut x98, x96, (0x0 as u32), x1);
  let mut x99: u32 = 0;
  let mut x100: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x99, &mut x100, x98, (0x0 as u32), x79);
  let mut x101: u32 = 0;
  let mut x102: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x101, &mut x102, x100, ((x80 as fiat_sm2_u1) as u32), x77);
  let mut x103: u32 = 0;
  let mut x104: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x103, &mut x104, 0x0, x61, x87);
  let mut x105: u32 = 0;
  let mut x106: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x105, &mut x106, x104, x63, x89);
  let mut x107: u32 = 0;
  let mut x108: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x107, &mut x108, x106, x65, x91);
  let mut x109: u32 = 0;
  let mut x110: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x109, &mut x110, x108, x67, x93);
  let mut x111: u32 = 0;
  let mut x112: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x111, &mut x112, x110, x69, x95);
  let mut x113: u32 = 0;
  let mut x114: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x113, &mut x114, x112, x71, x97);
  let mut x115: u32 = 0;
  let mut x116: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x115, &mut x116, x114, x73, x99);
  let mut x117: u32 = 0;
  let mut x118: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x117, &mut x118, x116, x75, x101);
  let mut x119: u32 = 0;
  let mut x120: u32 = 0;
  fiat_sm2_mulx_u32(&mut x119, &mut x120, x103, 0xfffffffe);
  let mut x121: u32 = 0;
  let mut x122: u32 = 0;
  fiat_sm2_mulx_u32(&mut x121, &mut x122, x103, 0xffffffff);
  let mut x123: u32 = 0;
  let mut x124: u32 = 0;
  fiat_sm2_mulx_u32(&mut x123, &mut x124, x103, 0xffffffff);
  let mut x125: u32 = 0;
  let mut x126: u32 = 0;
  fiat_sm2_mulx_u32(&mut x125, &mut x126, x103, 0xffffffff);
  let mut x127: u32 = 0;
  let mut x128: u32 = 0;
  fiat_sm2_mulx_u32(&mut x127, &mut x128, x103, 0xffffffff);
  let mut x129: u32 = 0;
  let mut x130: u32 = 0;
  fiat_sm2_mulx_u32(&mut x129, &mut x130, x103, 0xffffffff);
  let mut x131: u32 = 0;
  let mut x132: u32 = 0;
  fiat_sm2_mulx_u32(&mut x131, &mut x132, x103, 0xffffffff);
  let mut x133: u32 = 0;
  let mut x134: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x133, &mut x134, 0x0, x132, x129);
  let mut x135: u32 = 0;
  let mut x136: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x135, &mut x136, 0x0, x128, x125);
  let mut x137: u32 = 0;
  let mut x138: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x137, &mut x138, x136, x126, x123);
  let mut x139: u32 = 0;
  let mut x140: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x139, &mut x140, x138, x124, x121);
  let mut x141: u32 = 0;
  let mut x142: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x141, &mut x142, x140, x122, x119);
  let mut x143: u32 = 0;
  let mut x144: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x143, &mut x144, 0x0, x103, x131);
  let mut x145: u32 = 0;
  let mut x146: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x145, &mut x146, x144, x105, x133);
  let mut x147: u32 = 0;
  let mut x148: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x147, &mut x148, x146, x107, ((x134 as u32) + x130));
  let mut x149: u32 = 0;
  let mut x150: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x149, &mut x150, x148, x109, x127);
  let mut x151: u32 = 0;
  let mut x152: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x151, &mut x152, x150, x111, x135);
  let mut x153: u32 = 0;
  let mut x154: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x153, &mut x154, x152, x113, x137);
  let mut x155: u32 = 0;
  let mut x156: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x155, &mut x156, x154, x115, x139);
  let mut x157: u32 = 0;
  let mut x158: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x157, &mut x158, x156, x117, x141);
  let mut x159: u32 = 0;
  let mut x160: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x159, &mut x160, x158, (((x118 as u32) + (x76 as u32)) + ((x102 as u32) + x78)), ((x142 as u32) + x120));
  let mut x161: u32 = 0;
  let mut x162: u32 = 0;
  fiat_sm2_mulx_u32(&mut x161, &mut x162, x2, 0x4);
  let mut x163: u32 = 0;
  let mut x164: u32 = 0;
  fiat_sm2_mulx_u32(&mut x163, &mut x164, x2, 0x2);
  let mut x165: u32 = 0;
  let mut x166: u32 = 0;
  fiat_sm2_mulx_u32(&mut x165, &mut x166, x2, 0x2);
  let mut x167: u32 = 0;
  let mut x168: u32 = 0;
  fiat_sm2_mulx_u32(&mut x167, &mut x168, x2, 0xffffffff);
  let mut x169: u32 = 0;
  let mut x170: u32 = 0;
  fiat_sm2_mulx_u32(&mut x169, &mut x170, x2, 0x2);
  let mut x171: u32 = 0;
  let mut x172: u32 = 0;
  fiat_sm2_mulx_u32(&mut x171, &mut x172, x2, 0x3);
  let mut x173: u32 = 0;
  let mut x174: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x173, &mut x174, 0x0, x172, x169);
  let mut x175: u32 = 0;
  let mut x176: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x175, &mut x176, x174, ((x170 as fiat_sm2_u1) as u32), x167);
  let mut x177: u32 = 0;
  let mut x178: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x177, &mut x178, x176, x168, x165);
  let mut x179: u32 = 0;
  let mut x180: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x179, &mut x180, x178, ((x166 as fiat_sm2_u1) as u32), x2);
  let mut x181: u32 = 0;
  let mut x182: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x181, &mut x182, x180, (0x0 as u32), x2);
  let mut x183: u32 = 0;
  let mut x184: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x183, &mut x184, x182, (0x0 as u32), x163);
  let mut x185: u32 = 0;
  let mut x186: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x185, &mut x186, x184, ((x164 as fiat_sm2_u1) as u32), x161);
  let mut x187: u32 = 0;
  let mut x188: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x187, &mut x188, 0x0, x145, x171);
  let mut x189: u32 = 0;
  let mut x190: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x189, &mut x190, x188, x147, x173);
  let mut x191: u32 = 0;
  let mut x192: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x191, &mut x192, x190, x149, x175);
  let mut x193: u32 = 0;
  let mut x194: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x193, &mut x194, x192, x151, x177);
  let mut x195: u32 = 0;
  let mut x196: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x195, &mut x196, x194, x153, x179);
  let mut x197: u32 = 0;
  let mut x198: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x197, &mut x198, x196, x155, x181);
  let mut x199: u32 = 0;
  let mut x200: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x199, &mut x200, x198, x157, x183);
  let mut x201: u32 = 0;
  let mut x202: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x201, &mut x202, x200, x159, x185);
  let mut x203: u32 = 0;
  let mut x204: u32 = 0;
  fiat_sm2_mulx_u32(&mut x203, &mut x204, x187, 0xfffffffe);
  let mut x205: u32 = 0;
  let mut x206: u32 = 0;
  fiat_sm2_mulx_u32(&mut x205, &mut x206, x187, 0xffffffff);
  let mut x207: u32 = 0;
  let mut x208: u32 = 0;
  fiat_sm2_mulx_u32(&mut x207, &mut x208, x187, 0xffffffff);
  let mut x209: u32 = 0;
  let mut x210: u32 = 0;
  fiat_sm2_mulx_u32(&mut x209, &mut x210, x187, 0xffffffff);
  let mut x211: u32 = 0;
  let mut x212: u32 = 0;
  fiat_sm2_mulx_u32(&mut x211, &mut x212, x187, 0xffffffff);
  let mut x213: u32 = 0;
  let mut x214: u32 = 0;
  fiat_sm2_mulx_u32(&mut x213, &mut x214, x187, 0xffffffff);
  let mut x215: u32 = 0;
  let mut x216: u32 = 0;
  fiat_sm2_mulx_u32(&mut x215, &mut x216, x187, 0xffffffff);
  let mut x217: u32 = 0;
  let mut x218: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x217, &mut x218, 0x0, x216, x213);
  let mut x219: u32 = 0;
  let mut x220: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x219, &mut x220, 0x0, x212, x209);
  let mut x221: u32 = 0;
  let mut x222: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x221, &mut x222, x220, x210, x207);
  let mut x223: u32 = 0;
  let mut x224: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x223, &mut x224, x222, x208, x205);
  let mut x225: u32 = 0;
  let mut x226: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x225, &mut x226, x224, x206, x203);
  let mut x227: u32 = 0;
  let mut x228: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x227, &mut x228, 0x0, x187, x215);
  let mut x229: u32 = 0;
  let mut x230: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x229, &mut x230, x228, x189, x217);
  let mut x231: u32 = 0;
  let mut x232: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x231, &mut x232, x230, x191, ((x218 as u32) + x214));
  let mut x233: u32 = 0;
  let mut x234: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x233, &mut x234, x232, x193, x211);
  let mut x235: u32 = 0;
  let mut x236: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x235, &mut x236, x234, x195, x219);
  let mut x237: u32 = 0;
  let mut x238: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x237, &mut x238, x236, x197, x221);
  let mut x239: u32 = 0;
  let mut x240: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x239, &mut x240, x238, x199, x223);
  let mut x241: u32 = 0;
  let mut x242: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x241, &mut x242, x240, x201, x225);
  let mut x243: u32 = 0;
  let mut x244: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x243, &mut x244, x242, (((x202 as u32) + (x160 as u32)) + ((x186 as u32) + x162)), ((x226 as u32) + x204));
  let mut x245: u32 = 0;
  let mut x246: u32 = 0;
  fiat_sm2_mulx_u32(&mut x245, &mut x246, x3, 0x4);
  let mut x247: u32 = 0;
  let mut x248: u32 = 0;
  fiat_sm2_mulx_u32(&mut x247, &mut x248, x3, 0x2);
  let mut x249: u32 = 0;
  let mut x250: u32 = 0;
  fiat_sm2_mulx_u32(&mut x249, &mut x250, x3, 0x2);
  let mut x251: u32 = 0;
  let mut x252: u32 = 0;
  fiat_sm2_mulx_u32(&mut x251, &mut x252, x3, 0xffffffff);
  let mut x253: u32 = 0;
  let mut x254: u32 = 0;
  fiat_sm2_mulx_u32(&mut x253, &mut x254, x3, 0x2);
  let mut x255: u32 = 0;
  let mut x256: u32 = 0;
  fiat_sm2_mulx_u32(&mut x255, &mut x256, x3, 0x3);
  let mut x257: u32 = 0;
  let mut x258: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x257, &mut x258, 0x0, x256, x253);
  let mut x259: u32 = 0;
  let mut x260: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x259, &mut x260, x258, ((x254 as fiat_sm2_u1) as u32), x251);
  let mut x261: u32 = 0;
  let mut x262: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x261, &mut x262, x260, x252, x249);
  let mut x263: u32 = 0;
  let mut x264: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x263, &mut x264, x262, ((x250 as fiat_sm2_u1) as u32), x3);
  let mut x265: u32 = 0;
  let mut x266: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x265, &mut x266, x264, (0x0 as u32), x3);
  let mut x267: u32 = 0;
  let mut x268: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x267, &mut x268, x266, (0x0 as u32), x247);
  let mut x269: u32 = 0;
  let mut x270: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x269, &mut x270, x268, ((x248 as fiat_sm2_u1) as u32), x245);
  let mut x271: u32 = 0;
  let mut x272: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x271, &mut x272, 0x0, x229, x255);
  let mut x273: u32 = 0;
  let mut x274: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x273, &mut x274, x272, x231, x257);
  let mut x275: u32 = 0;
  let mut x276: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x275, &mut x276, x274, x233, x259);
  let mut x277: u32 = 0;
  let mut x278: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x277, &mut x278, x276, x235, x261);
  let mut x279: u32 = 0;
  let mut x280: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x279, &mut x280, x278, x237, x263);
  let mut x281: u32 = 0;
  let mut x282: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x281, &mut x282, x280, x239, x265);
  let mut x283: u32 = 0;
  let mut x284: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x283, &mut x284, x282, x241, x267);
  let mut x285: u32 = 0;
  let mut x286: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x285, &mut x286, x284, x243, x269);
  let mut x287: u32 = 0;
  let mut x288: u32 = 0;
  fiat_sm2_mulx_u32(&mut x287, &mut x288, x271, 0xfffffffe);
  let mut x289: u32 = 0;
  let mut x290: u32 = 0;
  fiat_sm2_mulx_u32(&mut x289, &mut x290, x271, 0xffffffff);
  let mut x291: u32 = 0;
  let mut x292: u32 = 0;
  fiat_sm2_mulx_u32(&mut x291, &mut x292, x271, 0xffffffff);
  let mut x293: u32 = 0;
  let mut x294: u32 = 0;
  fiat_sm2_mulx_u32(&mut x293, &mut x294, x271, 0xffffffff);
  let mut x295: u32 = 0;
  let mut x296: u32 = 0;
  fiat_sm2_mulx_u32(&mut x295, &mut x296, x271, 0xffffffff);
  let mut x297: u32 = 0;
  let mut x298: u32 = 0;
  fiat_sm2_mulx_u32(&mut x297, &mut x298, x271, 0xffffffff);
  let mut x299: u32 = 0;
  let mut x300: u32 = 0;
  fiat_sm2_mulx_u32(&mut x299, &mut x300, x271, 0xffffffff);
  let mut x301: u32 = 0;
  let mut x302: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x301, &mut x302, 0x0, x300, x297);
  let mut x303: u32 = 0;
  let mut x304: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x303, &mut x304, 0x0, x296, x293);
  let mut x305: u32 = 0;
  let mut x306: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x305, &mut x306, x304, x294, x291);
  let mut x307: u32 = 0;
  let mut x308: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x307, &mut x308, x306, x292, x289);
  let mut x309: u32 = 0;
  let mut x310: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x309, &mut x310, x308, x290, x287);
  let mut x311: u32 = 0;
  let mut x312: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x311, &mut x312, 0x0, x271, x299);
  let mut x313: u32 = 0;
  let mut x314: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x313, &mut x314, x312, x273, x301);
  let mut x315: u32 = 0;
  let mut x316: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x315, &mut x316, x314, x275, ((x302 as u32) + x298));
  let mut x317: u32 = 0;
  let mut x318: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x317, &mut x318, x316, x277, x295);
  let mut x319: u32 = 0;
  let mut x320: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x319, &mut x320, x318, x279, x303);
  let mut x321: u32 = 0;
  let mut x322: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x321, &mut x322, x320, x281, x305);
  let mut x323: u32 = 0;
  let mut x324: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x323, &mut x324, x322, x283, x307);
  let mut x325: u32 = 0;
  let mut x326: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x325, &mut x326, x324, x285, x309);
  let mut x327: u32 = 0;
  let mut x328: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x327, &mut x328, x326, (((x286 as u32) + (x244 as u32)) + ((x270 as u32) + x246)), ((x310 as u32) + x288));
  let mut x329: u32 = 0;
  let mut x330: u32 = 0;
  fiat_sm2_mulx_u32(&mut x329, &mut x330, x4, 0x4);
  let mut x331: u32 = 0;
  let mut x332: u32 = 0;
  fiat_sm2_mulx_u32(&mut x331, &mut x332, x4, 0x2);
  let mut x333: u32 = 0;
  let mut x334: u32 = 0;
  fiat_sm2_mulx_u32(&mut x333, &mut x334, x4, 0x2);
  let mut x335: u32 = 0;
  let mut x336: u32 = 0;
  fiat_sm2_mulx_u32(&mut x335, &mut x336, x4, 0xffffffff);
  let mut x337: u32 = 0;
  let mut x338: u32 = 0;
  fiat_sm2_mulx_u32(&mut x337, &mut x338, x4, 0x2);
  let mut x339: u32 = 0;
  let mut x340: u32 = 0;
  fiat_sm2_mulx_u32(&mut x339, &mut x340, x4, 0x3);
  let mut x341: u32 = 0;
  let mut x342: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x341, &mut x342, 0x0, x340, x337);
  let mut x343: u32 = 0;
  let mut x344: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x343, &mut x344, x342, ((x338 as fiat_sm2_u1) as u32), x335);
  let mut x345: u32 = 0;
  let mut x346: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x345, &mut x346, x344, x336, x333);
  let mut x347: u32 = 0;
  let mut x348: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x347, &mut x348, x346, ((x334 as fiat_sm2_u1) as u32), x4);
  let mut x349: u32 = 0;
  let mut x350: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x349, &mut x350, x348, (0x0 as u32), x4);
  let mut x351: u32 = 0;
  let mut x352: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x351, &mut x352, x350, (0x0 as u32), x331);
  let mut x353: u32 = 0;
  let mut x354: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x353, &mut x354, x352, ((x332 as fiat_sm2_u1) as u32), x329);
  let mut x355: u32 = 0;
  let mut x356: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x355, &mut x356, 0x0, x313, x339);
  let mut x357: u32 = 0;
  let mut x358: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x357, &mut x358, x356, x315, x341);
  let mut x359: u32 = 0;
  let mut x360: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x359, &mut x360, x358, x317, x343);
  let mut x361: u32 = 0;
  let mut x362: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x361, &mut x362, x360, x319, x345);
  let mut x363: u32 = 0;
  let mut x364: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x363, &mut x364, x362, x321, x347);
  let mut x365: u32 = 0;
  let mut x366: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x365, &mut x366, x364, x323, x349);
  let mut x367: u32 = 0;
  let mut x368: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x367, &mut x368, x366, x325, x351);
  let mut x369: u32 = 0;
  let mut x370: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x369, &mut x370, x368, x327, x353);
  let mut x371: u32 = 0;
  let mut x372: u32 = 0;
  fiat_sm2_mulx_u32(&mut x371, &mut x372, x355, 0xfffffffe);
  let mut x373: u32 = 0;
  let mut x374: u32 = 0;
  fiat_sm2_mulx_u32(&mut x373, &mut x374, x355, 0xffffffff);
  let mut x375: u32 = 0;
  let mut x376: u32 = 0;
  fiat_sm2_mulx_u32(&mut x375, &mut x376, x355, 0xffffffff);
  let mut x377: u32 = 0;
  let mut x378: u32 = 0;
  fiat_sm2_mulx_u32(&mut x377, &mut x378, x355, 0xffffffff);
  let mut x379: u32 = 0;
  let mut x380: u32 = 0;
  fiat_sm2_mulx_u32(&mut x379, &mut x380, x355, 0xffffffff);
  let mut x381: u32 = 0;
  let mut x382: u32 = 0;
  fiat_sm2_mulx_u32(&mut x381, &mut x382, x355, 0xffffffff);
  let mut x383: u32 = 0;
  let mut x384: u32 = 0;
  fiat_sm2_mulx_u32(&mut x383, &mut x384, x355, 0xffffffff);
  let mut x385: u32 = 0;
  let mut x386: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x385, &mut x386, 0x0, x384, x381);
  let mut x387: u32 = 0;
  let mut x388: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x387, &mut x388, 0x0, x380, x377);
  let mut x389: u32 = 0;
  let mut x390: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x389, &mut x390, x388, x378, x375);
  let mut x391: u32 = 0;
  let mut x392: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x391, &mut x392, x390, x376, x373);
  let mut x393: u32 = 0;
  let mut x394: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x393, &mut x394, x392, x374, x371);
  let mut x395: u32 = 0;
  let mut x396: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x395, &mut x396, 0x0, x355, x383);
  let mut x397: u32 = 0;
  let mut x398: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x397, &mut x398, x396, x357, x385);
  let mut x399: u32 = 0;
  let mut x400: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x399, &mut x400, x398, x359, ((x386 as u32) + x382));
  let mut x401: u32 = 0;
  let mut x402: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x401, &mut x402, x400, x361, x379);
  let mut x403: u32 = 0;
  let mut x404: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x403, &mut x404, x402, x363, x387);
  let mut x405: u32 = 0;
  let mut x406: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x405, &mut x406, x404, x365, x389);
  let mut x407: u32 = 0;
  let mut x408: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x407, &mut x408, x406, x367, x391);
  let mut x409: u32 = 0;
  let mut x410: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x409, &mut x410, x408, x369, x393);
  let mut x411: u32 = 0;
  let mut x412: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x411, &mut x412, x410, (((x370 as u32) + (x328 as u32)) + ((x354 as u32) + x330)), ((x394 as u32) + x372));
  let mut x413: u32 = 0;
  let mut x414: u32 = 0;
  fiat_sm2_mulx_u32(&mut x413, &mut x414, x5, 0x4);
  let mut x415: u32 = 0;
  let mut x416: u32 = 0;
  fiat_sm2_mulx_u32(&mut x415, &mut x416, x5, 0x2);
  let mut x417: u32 = 0;
  let mut x418: u32 = 0;
  fiat_sm2_mulx_u32(&mut x417, &mut x418, x5, 0x2);
  let mut x419: u32 = 0;
  let mut x420: u32 = 0;
  fiat_sm2_mulx_u32(&mut x419, &mut x420, x5, 0xffffffff);
  let mut x421: u32 = 0;
  let mut x422: u32 = 0;
  fiat_sm2_mulx_u32(&mut x421, &mut x422, x5, 0x2);
  let mut x423: u32 = 0;
  let mut x424: u32 = 0;
  fiat_sm2_mulx_u32(&mut x423, &mut x424, x5, 0x3);
  let mut x425: u32 = 0;
  let mut x426: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x425, &mut x426, 0x0, x424, x421);
  let mut x427: u32 = 0;
  let mut x428: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x427, &mut x428, x426, ((x422 as fiat_sm2_u1) as u32), x419);
  let mut x429: u32 = 0;
  let mut x430: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x429, &mut x430, x428, x420, x417);
  let mut x431: u32 = 0;
  let mut x432: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x431, &mut x432, x430, ((x418 as fiat_sm2_u1) as u32), x5);
  let mut x433: u32 = 0;
  let mut x434: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x433, &mut x434, x432, (0x0 as u32), x5);
  let mut x435: u32 = 0;
  let mut x436: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x435, &mut x436, x434, (0x0 as u32), x415);
  let mut x437: u32 = 0;
  let mut x438: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x437, &mut x438, x436, ((x416 as fiat_sm2_u1) as u32), x413);
  let mut x439: u32 = 0;
  let mut x440: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x439, &mut x440, 0x0, x397, x423);
  let mut x441: u32 = 0;
  let mut x442: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x441, &mut x442, x440, x399, x425);
  let mut x443: u32 = 0;
  let mut x444: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x443, &mut x444, x442, x401, x427);
  let mut x445: u32 = 0;
  let mut x446: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x445, &mut x446, x444, x403, x429);
  let mut x447: u32 = 0;
  let mut x448: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x447, &mut x448, x446, x405, x431);
  let mut x449: u32 = 0;
  let mut x450: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x449, &mut x450, x448, x407, x433);
  let mut x451: u32 = 0;
  let mut x452: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x451, &mut x452, x450, x409, x435);
  let mut x453: u32 = 0;
  let mut x454: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x453, &mut x454, x452, x411, x437);
  let mut x455: u32 = 0;
  let mut x456: u32 = 0;
  fiat_sm2_mulx_u32(&mut x455, &mut x456, x439, 0xfffffffe);
  let mut x457: u32 = 0;
  let mut x458: u32 = 0;
  fiat_sm2_mulx_u32(&mut x457, &mut x458, x439, 0xffffffff);
  let mut x459: u32 = 0;
  let mut x460: u32 = 0;
  fiat_sm2_mulx_u32(&mut x459, &mut x460, x439, 0xffffffff);
  let mut x461: u32 = 0;
  let mut x462: u32 = 0;
  fiat_sm2_mulx_u32(&mut x461, &mut x462, x439, 0xffffffff);
  let mut x463: u32 = 0;
  let mut x464: u32 = 0;
  fiat_sm2_mulx_u32(&mut x463, &mut x464, x439, 0xffffffff);
  let mut x465: u32 = 0;
  let mut x466: u32 = 0;
  fiat_sm2_mulx_u32(&mut x465, &mut x466, x439, 0xffffffff);
  let mut x467: u32 = 0;
  let mut x468: u32 = 0;
  fiat_sm2_mulx_u32(&mut x467, &mut x468, x439, 0xffffffff);
  let mut x469: u32 = 0;
  let mut x470: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x469, &mut x470, 0x0, x468, x465);
  let mut x471: u32 = 0;
  let mut x472: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x471, &mut x472, 0x0, x464, x461);
  let mut x473: u32 = 0;
  let mut x474: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x473, &mut x474, x472, x462, x459);
  let mut x475: u32 = 0;
  let mut x476: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x475, &mut x476, x474, x460, x457);
  let mut x477: u32 = 0;
  let mut x478: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x477, &mut x478, x476, x458, x455);
  let mut x479: u32 = 0;
  let mut x480: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x479, &mut x480, 0x0, x439, x467);
  let mut x481: u32 = 0;
  let mut x482: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x481, &mut x482, x480, x441, x469);
  let mut x483: u32 = 0;
  let mut x484: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x483, &mut x484, x482, x443, ((x470 as u32) + x466));
  let mut x485: u32 = 0;
  let mut x486: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x485, &mut x486, x484, x445, x463);
  let mut x487: u32 = 0;
  let mut x488: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x487, &mut x488, x486, x447, x471);
  let mut x489: u32 = 0;
  let mut x490: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x489, &mut x490, x488, x449, x473);
  let mut x491: u32 = 0;
  let mut x492: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x491, &mut x492, x490, x451, x475);
  let mut x493: u32 = 0;
  let mut x494: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x493, &mut x494, x492, x453, x477);
  let mut x495: u32 = 0;
  let mut x496: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x495, &mut x496, x494, (((x454 as u32) + (x412 as u32)) + ((x438 as u32) + x414)), ((x478 as u32) + x456));
  let mut x497: u32 = 0;
  let mut x498: u32 = 0;
  fiat_sm2_mulx_u32(&mut x497, &mut x498, x6, 0x4);
  let mut x499: u32 = 0;
  let mut x500: u32 = 0;
  fiat_sm2_mulx_u32(&mut x499, &mut x500, x6, 0x2);
  let mut x501: u32 = 0;
  let mut x502: u32 = 0;
  fiat_sm2_mulx_u32(&mut x501, &mut x502, x6, 0x2);
  let mut x503: u32 = 0;
  let mut x504: u32 = 0;
  fiat_sm2_mulx_u32(&mut x503, &mut x504, x6, 0xffffffff);
  let mut x505: u32 = 0;
  let mut x506: u32 = 0;
  fiat_sm2_mulx_u32(&mut x505, &mut x506, x6, 0x2);
  let mut x507: u32 = 0;
  let mut x508: u32 = 0;
  fiat_sm2_mulx_u32(&mut x507, &mut x508, x6, 0x3);
  let mut x509: u32 = 0;
  let mut x510: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x509, &mut x510, 0x0, x508, x505);
  let mut x511: u32 = 0;
  let mut x512: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x511, &mut x512, x510, ((x506 as fiat_sm2_u1) as u32), x503);
  let mut x513: u32 = 0;
  let mut x514: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x513, &mut x514, x512, x504, x501);
  let mut x515: u32 = 0;
  let mut x516: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x515, &mut x516, x514, ((x502 as fiat_sm2_u1) as u32), x6);
  let mut x517: u32 = 0;
  let mut x518: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x517, &mut x518, x516, (0x0 as u32), x6);
  let mut x519: u32 = 0;
  let mut x520: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x519, &mut x520, x518, (0x0 as u32), x499);
  let mut x521: u32 = 0;
  let mut x522: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x521, &mut x522, x520, ((x500 as fiat_sm2_u1) as u32), x497);
  let mut x523: u32 = 0;
  let mut x524: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x523, &mut x524, 0x0, x481, x507);
  let mut x525: u32 = 0;
  let mut x526: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x525, &mut x526, x524, x483, x509);
  let mut x527: u32 = 0;
  let mut x528: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x527, &mut x528, x526, x485, x511);
  let mut x529: u32 = 0;
  let mut x530: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x529, &mut x530, x528, x487, x513);
  let mut x531: u32 = 0;
  let mut x532: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x531, &mut x532, x530, x489, x515);
  let mut x533: u32 = 0;
  let mut x534: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x533, &mut x534, x532, x491, x517);
  let mut x535: u32 = 0;
  let mut x536: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x535, &mut x536, x534, x493, x519);
  let mut x537: u32 = 0;
  let mut x538: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x537, &mut x538, x536, x495, x521);
  let mut x539: u32 = 0;
  let mut x540: u32 = 0;
  fiat_sm2_mulx_u32(&mut x539, &mut x540, x523, 0xfffffffe);
  let mut x541: u32 = 0;
  let mut x542: u32 = 0;
  fiat_sm2_mulx_u32(&mut x541, &mut x542, x523, 0xffffffff);
  let mut x543: u32 = 0;
  let mut x544: u32 = 0;
  fiat_sm2_mulx_u32(&mut x543, &mut x544, x523, 0xffffffff);
  let mut x545: u32 = 0;
  let mut x546: u32 = 0;
  fiat_sm2_mulx_u32(&mut x545, &mut x546, x523, 0xffffffff);
  let mut x547: u32 = 0;
  let mut x548: u32 = 0;
  fiat_sm2_mulx_u32(&mut x547, &mut x548, x523, 0xffffffff);
  let mut x549: u32 = 0;
  let mut x550: u32 = 0;
  fiat_sm2_mulx_u32(&mut x549, &mut x550, x523, 0xffffffff);
  let mut x551: u32 = 0;
  let mut x552: u32 = 0;
  fiat_sm2_mulx_u32(&mut x551, &mut x552, x523, 0xffffffff);
  let mut x553: u32 = 0;
  let mut x554: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x553, &mut x554, 0x0, x552, x549);
  let mut x555: u32 = 0;
  let mut x556: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x555, &mut x556, 0x0, x548, x545);
  let mut x557: u32 = 0;
  let mut x558: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x557, &mut x558, x556, x546, x543);
  let mut x559: u32 = 0;
  let mut x560: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x559, &mut x560, x558, x544, x541);
  let mut x561: u32 = 0;
  let mut x562: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x561, &mut x562, x560, x542, x539);
  let mut x563: u32 = 0;
  let mut x564: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x563, &mut x564, 0x0, x523, x551);
  let mut x565: u32 = 0;
  let mut x566: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x565, &mut x566, x564, x525, x553);
  let mut x567: u32 = 0;
  let mut x568: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x567, &mut x568, x566, x527, ((x554 as u32) + x550));
  let mut x569: u32 = 0;
  let mut x570: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x569, &mut x570, x568, x529, x547);
  let mut x571: u32 = 0;
  let mut x572: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x571, &mut x572, x570, x531, x555);
  let mut x573: u32 = 0;
  let mut x574: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x573, &mut x574, x572, x533, x557);
  let mut x575: u32 = 0;
  let mut x576: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x575, &mut x576, x574, x535, x559);
  let mut x577: u32 = 0;
  let mut x578: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x577, &mut x578, x576, x537, x561);
  let mut x579: u32 = 0;
  let mut x580: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x579, &mut x580, x578, (((x538 as u32) + (x496 as u32)) + ((x522 as u32) + x498)), ((x562 as u32) + x540));
  let mut x581: u32 = 0;
  let mut x582: u32 = 0;
  fiat_sm2_mulx_u32(&mut x581, &mut x582, x7, 0x4);
  let mut x583: u32 = 0;
  let mut x584: u32 = 0;
  fiat_sm2_mulx_u32(&mut x583, &mut x584, x7, 0x2);
  let mut x585: u32 = 0;
  let mut x586: u32 = 0;
  fiat_sm2_mulx_u32(&mut x585, &mut x586, x7, 0x2);
  let mut x587: u32 = 0;
  let mut x588: u32 = 0;
  fiat_sm2_mulx_u32(&mut x587, &mut x588, x7, 0xffffffff);
  let mut x589: u32 = 0;
  let mut x590: u32 = 0;
  fiat_sm2_mulx_u32(&mut x589, &mut x590, x7, 0x2);
  let mut x591: u32 = 0;
  let mut x592: u32 = 0;
  fiat_sm2_mulx_u32(&mut x591, &mut x592, x7, 0x3);
  let mut x593: u32 = 0;
  let mut x594: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x593, &mut x594, 0x0, x592, x589);
  let mut x595: u32 = 0;
  let mut x596: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x595, &mut x596, x594, ((x590 as fiat_sm2_u1) as u32), x587);
  let mut x597: u32 = 0;
  let mut x598: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x597, &mut x598, x596, x588, x585);
  let mut x599: u32 = 0;
  let mut x600: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x599, &mut x600, x598, ((x586 as fiat_sm2_u1) as u32), x7);
  let mut x601: u32 = 0;
  let mut x602: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x601, &mut x602, x600, (0x0 as u32), x7);
  let mut x603: u32 = 0;
  let mut x604: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x603, &mut x604, x602, (0x0 as u32), x583);
  let mut x605: u32 = 0;
  let mut x606: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x605, &mut x606, x604, ((x584 as fiat_sm2_u1) as u32), x581);
  let mut x607: u32 = 0;
  let mut x608: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x607, &mut x608, 0x0, x565, x591);
  let mut x609: u32 = 0;
  let mut x610: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x609, &mut x610, x608, x567, x593);
  let mut x611: u32 = 0;
  let mut x612: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x611, &mut x612, x610, x569, x595);
  let mut x613: u32 = 0;
  let mut x614: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x613, &mut x614, x612, x571, x597);
  let mut x615: u32 = 0;
  let mut x616: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x615, &mut x616, x614, x573, x599);
  let mut x617: u32 = 0;
  let mut x618: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x617, &mut x618, x616, x575, x601);
  let mut x619: u32 = 0;
  let mut x620: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x619, &mut x620, x618, x577, x603);
  let mut x621: u32 = 0;
  let mut x622: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x621, &mut x622, x620, x579, x605);
  let mut x623: u32 = 0;
  let mut x624: u32 = 0;
  fiat_sm2_mulx_u32(&mut x623, &mut x624, x607, 0xfffffffe);
  let mut x625: u32 = 0;
  let mut x626: u32 = 0;
  fiat_sm2_mulx_u32(&mut x625, &mut x626, x607, 0xffffffff);
  let mut x627: u32 = 0;
  let mut x628: u32 = 0;
  fiat_sm2_mulx_u32(&mut x627, &mut x628, x607, 0xffffffff);
  let mut x629: u32 = 0;
  let mut x630: u32 = 0;
  fiat_sm2_mulx_u32(&mut x629, &mut x630, x607, 0xffffffff);
  let mut x631: u32 = 0;
  let mut x632: u32 = 0;
  fiat_sm2_mulx_u32(&mut x631, &mut x632, x607, 0xffffffff);
  let mut x633: u32 = 0;
  let mut x634: u32 = 0;
  fiat_sm2_mulx_u32(&mut x633, &mut x634, x607, 0xffffffff);
  let mut x635: u32 = 0;
  let mut x636: u32 = 0;
  fiat_sm2_mulx_u32(&mut x635, &mut x636, x607, 0xffffffff);
  let mut x637: u32 = 0;
  let mut x638: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x637, &mut x638, 0x0, x636, x633);
  let mut x639: u32 = 0;
  let mut x640: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x639, &mut x640, 0x0, x632, x629);
  let mut x641: u32 = 0;
  let mut x642: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x641, &mut x642, x640, x630, x627);
  let mut x643: u32 = 0;
  let mut x644: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x643, &mut x644, x642, x628, x625);
  let mut x645: u32 = 0;
  let mut x646: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x645, &mut x646, x644, x626, x623);
  let mut x647: u32 = 0;
  let mut x648: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x647, &mut x648, 0x0, x607, x635);
  let mut x649: u32 = 0;
  let mut x650: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x649, &mut x650, x648, x609, x637);
  let mut x651: u32 = 0;
  let mut x652: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x651, &mut x652, x650, x611, ((x638 as u32) + x634));
  let mut x653: u32 = 0;
  let mut x654: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x653, &mut x654, x652, x613, x631);
  let mut x655: u32 = 0;
  let mut x656: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x655, &mut x656, x654, x615, x639);
  let mut x657: u32 = 0;
  let mut x658: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x657, &mut x658, x656, x617, x641);
  let mut x659: u32 = 0;
  let mut x660: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x659, &mut x660, x658, x619, x643);
  let mut x661: u32 = 0;
  let mut x662: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x661, &mut x662, x660, x621, x645);
  let mut x663: u32 = 0;
  let mut x664: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x663, &mut x664, x662, (((x622 as u32) + (x580 as u32)) + ((x606 as u32) + x582)), ((x646 as u32) + x624));
  let mut x665: u32 = 0;
  let mut x666: fiat_sm2_u1 = 0;
  fiat_sm2_subborrowx_u32(&mut x665, &mut x666, 0x0, x649, 0xffffffff);
  let mut x667: u32 = 0;
  let mut x668: fiat_sm2_u1 = 0;
  fiat_sm2_subborrowx_u32(&mut x667, &mut x668, x666, x651, 0xffffffff);
  let mut x669: u32 = 0;
  let mut x670: fiat_sm2_u1 = 0;
  fiat_sm2_subborrowx_u32(&mut x669, &mut x670, x668, x653, (0x0 as u32));
  let mut x671: u32 = 0;
  let mut x672: fiat_sm2_u1 = 0;
  fiat_sm2_subborrowx_u32(&mut x671, &mut x672, x670, x655, 0xffffffff);
  let mut x673: u32 = 0;
  let mut x674: fiat_sm2_u1 = 0;
  fiat_sm2_subborrowx_u32(&mut x673, &mut x674, x672, x657, 0xffffffff);
  let mut x675: u32 = 0;
  let mut x676: fiat_sm2_u1 = 0;
  fiat_sm2_subborrowx_u32(&mut x675, &mut x676, x674, x659, 0xffffffff);
  let mut x677: u32 = 0;
  let mut x678: fiat_sm2_u1 = 0;
  fiat_sm2_subborrowx_u32(&mut x677, &mut x678, x676, x661, 0xffffffff);
  let mut x679: u32 = 0;
  let mut x680: fiat_sm2_u1 = 0;
  fiat_sm2_subborrowx_u32(&mut x679, &mut x680, x678, x663, 0xfffffffe);
  let mut x681: u32 = 0;
  let mut x682: fiat_sm2_u1 = 0;
  fiat_sm2_subborrowx_u32(&mut x681, &mut x682, x680, (x664 as u32), (0x0 as u32));
  let mut x683: u32 = 0;
  fiat_sm2_cmovznz_u32(&mut x683, x682, x665, x649);
  let mut x684: u32 = 0;
  fiat_sm2_cmovznz_u32(&mut x684, x682, x667, x651);
  let mut x685: u32 = 0;
  fiat_sm2_cmovznz_u32(&mut x685, x682, x669, x653);
  let mut x686: u32 = 0;
  fiat_sm2_cmovznz_u32(&mut x686, x682, x671, x655);
  let mut x687: u32 = 0;
  fiat_sm2_cmovznz_u32(&mut x687, x682, x673, x657);
  let mut x688: u32 = 0;
  fiat_sm2_cmovznz_u32(&mut x688, x682, x675, x659);
  let mut x689: u32 = 0;
  fiat_sm2_cmovznz_u32(&mut x689, x682, x677, x661);
  let mut x690: u32 = 0;
  fiat_sm2_cmovznz_u32(&mut x690, x682, x679, x663);
  *IndexConst(&mut out1).index_mut(0) = x683;
  *IndexConst(&mut out1).index_mut(1) = x684;
  *IndexConst(&mut out1).index_mut(2) = x685;
  *IndexConst(&mut out1).index_mut(3) = x686;
  *IndexConst(&mut out1).index_mut(4) = x687;
  *IndexConst(&mut out1).index_mut(5) = x688;
  *IndexConst(&mut out1).index_mut(6) = x689;
  *IndexConst(&mut out1).index_mut(7) = x690;
}

/// The function fiat_sm2_nonzero outputs a single non-zero word if the input is non-zero and zero otherwise.
///
/// Preconditions:
///   0 ≤ eval arg1 < m
/// Postconditions:
///   out1 = 0 ↔ eval (from_montgomery arg1) mod m = 0
///
/// Input Bounds:
///   arg1: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
/// Output Bounds:
///   out1: [0x0 ~> 0xffffffff]
#[inline]
pub const fn fiat_sm2_nonzero(out1: &mut u32, arg1: &[u32; 8]) {
  let x1: u32 = ((*IndexConst(arg1).index(0)) | ((*IndexConst(arg1).index(1)) | ((*IndexConst(arg1).index(2)) | ((*IndexConst(arg1).index(3)) | ((*IndexConst(arg1).index(4)) | ((*IndexConst(arg1).index(5)) | ((*IndexConst(arg1).index(6)) | (*IndexConst(arg1).index(7)))))))));
  *out1 = x1;
}

/// The function fiat_sm2_selectznz is a multi-limb conditional select.
///
/// Postconditions:
///   out1 = (if arg1 = 0 then arg2 else arg3)
///
/// Input Bounds:
///   arg1: [0x0 ~> 0x1]
///   arg2: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
///   arg3: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
/// Output Bounds:
///   out1: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
#[inline]
pub const fn fiat_sm2_selectznz(mut out1: &mut [u32; 8], arg1: fiat_sm2_u1, arg2: &[u32; 8], arg3: &[u32; 8]) {
  let mut x1: u32 = 0;
  fiat_sm2_cmovznz_u32(&mut x1, arg1, (*IndexConst(arg2).index(0)), (*IndexConst(arg3).index(0)));
  let mut x2: u32 = 0;
  fiat_sm2_cmovznz_u32(&mut x2, arg1, (*IndexConst(arg2).index(1)), (*IndexConst(arg3).index(1)));
  let mut x3: u32 = 0;
  fiat_sm2_cmovznz_u32(&mut x3, arg1, (*IndexConst(arg2).index(2)), (*IndexConst(arg3).index(2)));
  let mut x4: u32 = 0;
  fiat_sm2_cmovznz_u32(&mut x4, arg1, (*IndexConst(arg2).index(3)), (*IndexConst(arg3).index(3)));
  let mut x5: u32 = 0;
  fiat_sm2_cmovznz_u32(&mut x5, arg1, (*IndexConst(arg2).index(4)), (*IndexConst(arg3).index(4)));
  let mut x6: u32 = 0;
  fiat_sm2_cmovznz_u32(&mut x6, arg1, (*IndexConst(arg2).index(5)), (*IndexConst(arg3).index(5)));
  let mut x7: u32 = 0;
  fiat_sm2_cmovznz_u32(&mut x7, arg1, (*IndexConst(arg2).index(6)), (*IndexConst(arg3).index(6)));
  let mut x8: u32 = 0;
  fiat_sm2_cmovznz_u32(&mut x8, arg1, (*IndexConst(arg2).index(7)), (*IndexConst(arg3).index(7)));
  *IndexConst(&mut out1).index_mut(0) = x1;
  *IndexConst(&mut out1).index_mut(1) = x2;
  *IndexConst(&mut out1).index_mut(2) = x3;
  *IndexConst(&mut out1).index_mut(3) = x4;
  *IndexConst(&mut out1).index_mut(4) = x5;
  *IndexConst(&mut out1).index_mut(5) = x6;
  *IndexConst(&mut out1).index_mut(6) = x7;
  *IndexConst(&mut out1).index_mut(7) = x8;
}

/// The function fiat_sm2_to_bytes serializes a field element NOT in the Montgomery domain to bytes in little-endian order.
///
/// Preconditions:
///   0 ≤ eval arg1 < m
/// Postconditions:
///   out1 = map (λ x, ⌊((eval arg1 mod m) mod 2^(8 * (x + 1))) / 2^(8 * x)⌋) [0..31]
///
/// Input Bounds:
///   arg1: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
/// Output Bounds:
///   out1: [[0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff]]
#[inline]
pub const fn fiat_sm2_to_bytes(mut out1: &mut [u8; 32], arg1: &[u32; 8]) {
  let x1: u32 = (*IndexConst(arg1).index(7));
  let x2: u32 = (*IndexConst(arg1).index(6));
  let x3: u32 = (*IndexConst(arg1).index(5));
  let x4: u32 = (*IndexConst(arg1).index(4));
  let x5: u32 = (*IndexConst(arg1).index(3));
  let x6: u32 = (*IndexConst(arg1).index(2));
  let x7: u32 = (*IndexConst(arg1).index(1));
  let x8: u32 = (*IndexConst(arg1).index(0));
  let x9: u8 = ((x8 & (0xff as u32)) as u8);
  let x10: u32 = (x8 >> 8);
  let x11: u8 = ((x10 & (0xff as u32)) as u8);
  let x12: u32 = (x10 >> 8);
  let x13: u8 = ((x12 & (0xff as u32)) as u8);
  let x14: u8 = ((x12 >> 8) as u8);
  let x15: u8 = ((x7 & (0xff as u32)) as u8);
  let x16: u32 = (x7 >> 8);
  let x17: u8 = ((x16 & (0xff as u32)) as u8);
  let x18: u32 = (x16 >> 8);
  let x19: u8 = ((x18 & (0xff as u32)) as u8);
  let x20: u8 = ((x18 >> 8) as u8);
  let x21: u8 = ((x6 & (0xff as u32)) as u8);
  let x22: u32 = (x6 >> 8);
  let x23: u8 = ((x22 & (0xff as u32)) as u8);
  let x24: u32 = (x22 >> 8);
  let x25: u8 = ((x24 & (0xff as u32)) as u8);
  let x26: u8 = ((x24 >> 8) as u8);
  let x27: u8 = ((x5 & (0xff as u32)) as u8);
  let x28: u32 = (x5 >> 8);
  let x29: u8 = ((x28 & (0xff as u32)) as u8);
  let x30: u32 = (x28 >> 8);
  let x31: u8 = ((x30 & (0xff as u32)) as u8);
  let x32: u8 = ((x30 >> 8) as u8);
  let x33: u8 = ((x4 & (0xff as u32)) as u8);
  let x34: u32 = (x4 >> 8);
  let x35: u8 = ((x34 & (0xff as u32)) as u8);
  let x36: u32 = (x34 >> 8);
  let x37: u8 = ((x36 & (0xff as u32)) as u8);
  let x38: u8 = ((x36 >> 8) as u8);
  let x39: u8 = ((x3 & (0xff as u32)) as u8);
  let x40: u32 = (x3 >> 8);
  let x41: u8 = ((x40 & (0xff as u32)) as u8);
  let x42: u32 = (x40 >> 8);
  let x43: u8 = ((x42 & (0xff as u32)) as u8);
  let x44: u8 = ((x42 >> 8) as u8);
  let x45: u8 = ((x2 & (0xff as u32)) as u8);
  let x46: u32 = (x2 >> 8);
  let x47: u8 = ((x46 & (0xff as u32)) as u8);
  let x48: u32 = (x46 >> 8);
  let x49: u8 = ((x48 & (0xff as u32)) as u8);
  let x50: u8 = ((x48 >> 8) as u8);
  let x51: u8 = ((x1 & (0xff as u32)) as u8);
  let x52: u32 = (x1 >> 8);
  let x53: u8 = ((x52 & (0xff as u32)) as u8);
  let x54: u32 = (x52 >> 8);
  let x55: u8 = ((x54 & (0xff as u32)) as u8);
  let x56: u8 = ((x54 >> 8) as u8);
  *IndexConst(&mut out1).index_mut(0) = x9;
  *IndexConst(&mut out1).index_mut(1) = x11;
  *IndexConst(&mut out1).index_mut(2) = x13;
  *IndexConst(&mut out1).index_mut(3) = x14;
  *IndexConst(&mut out1).index_mut(4) = x15;
  *IndexConst(&mut out1).index_mut(5) = x17;
  *IndexConst(&mut out1).index_mut(6) = x19;
  *IndexConst(&mut out1).index_mut(7) = x20;
  *IndexConst(&mut out1).index_mut(8) = x21;
  *IndexConst(&mut out1).index_mut(9) = x23;
  *IndexConst(&mut out1).index_mut(10) = x25;
  *IndexConst(&mut out1).index_mut(11) = x26;
  *IndexConst(&mut out1).index_mut(12) = x27;
  *IndexConst(&mut out1).index_mut(13) = x29;
  *IndexConst(&mut out1).index_mut(14) = x31;
  *IndexConst(&mut out1).index_mut(15) = x32;
  *IndexConst(&mut out1).index_mut(16) = x33;
  *IndexConst(&mut out1).index_mut(17) = x35;
  *IndexConst(&mut out1).index_mut(18) = x37;
  *IndexConst(&mut out1).index_mut(19) = x38;
  *IndexConst(&mut out1).index_mut(20) = x39;
  *IndexConst(&mut out1).index_mut(21) = x41;
  *IndexConst(&mut out1).index_mut(22) = x43;
  *IndexConst(&mut out1).index_mut(23) = x44;
  *IndexConst(&mut out1).index_mut(24) = x45;
  *IndexConst(&mut out1).index_mut(25) = x47;
  *IndexConst(&mut out1).index_mut(26) = x49;
  *IndexConst(&mut out1).index_mut(27) = x50;
  *IndexConst(&mut out1).index_mut(28) = x51;
  *IndexConst(&mut out1).index_mut(29) = x53;
  *IndexConst(&mut out1).index_mut(30) = x55;
  *IndexConst(&mut out1).index_mut(31) = x56;
}

/// The function fiat_sm2_from_bytes deserializes a field element NOT in the Montgomery domain from bytes in little-endian order.
///
/// Preconditions:
///   0 ≤ bytes_eval arg1 < m
/// Postconditions:
///   eval out1 mod m = bytes_eval arg1 mod m
///   0 ≤ eval out1 < m
///
/// Input Bounds:
///   arg1: [[0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff]]
/// Output Bounds:
///   out1: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
#[inline]
pub const fn fiat_sm2_from_bytes(mut out1: &mut [u32; 8], arg1: &[u8; 32]) {
  let x1: u32 = (((*IndexConst(arg1).index(31)) as u32) << 24);
  let x2: u32 = (((*IndexConst(arg1).index(30)) as u32) << 16);
  let x3: u32 = (((*IndexConst(arg1).index(29)) as u32) << 8);
  let x4: u8 = (*IndexConst(arg1).index(28));
  let x5: u32 = (((*IndexConst(arg1).index(27)) as u32) << 24);
  let x6: u32 = (((*IndexConst(arg1).index(26)) as u32) << 16);
  let x7: u32 = (((*IndexConst(arg1).index(25)) as u32) << 8);
  let x8: u8 = (*IndexConst(arg1).index(24));
  let x9: u32 = (((*IndexConst(arg1).index(23)) as u32) << 24);
  let x10: u32 = (((*IndexConst(arg1).index(22)) as u32) << 16);
  let x11: u32 = (((*IndexConst(arg1).index(21)) as u32) << 8);
  let x12: u8 = (*IndexConst(arg1).index(20));
  let x13: u32 = (((*IndexConst(arg1).index(19)) as u32) << 24);
  let x14: u32 = (((*IndexConst(arg1).index(18)) as u32) << 16);
  let x15: u32 = (((*IndexConst(arg1).index(17)) as u32) << 8);
  let x16: u8 = (*IndexConst(arg1).index(16));
  let x17: u32 = (((*IndexConst(arg1).index(15)) as u32) << 24);
  let x18: u32 = (((*IndexConst(arg1).index(14)) as u32) << 16);
  let x19: u32 = (((*IndexConst(arg1).index(13)) as u32) << 8);
  let x20: u8 = (*IndexConst(arg1).index(12));
  let x21: u32 = (((*IndexConst(arg1).index(11)) as u32) << 24);
  let x22: u32 = (((*IndexConst(arg1).index(10)) as u32) << 16);
  let x23: u32 = (((*IndexConst(arg1).index(9)) as u32) << 8);
  let x24: u8 = (*IndexConst(arg1).index(8));
  let x25: u32 = (((*IndexConst(arg1).index(7)) as u32) << 24);
  let x26: u32 = (((*IndexConst(arg1).index(6)) as u32) << 16);
  let x27: u32 = (((*IndexConst(arg1).index(5)) as u32) << 8);
  let x28: u8 = (*IndexConst(arg1).index(4));
  let x29: u32 = (((*IndexConst(arg1).index(3)) as u32) << 24);
  let x30: u32 = (((*IndexConst(arg1).index(2)) as u32) << 16);
  let x31: u32 = (((*IndexConst(arg1).index(1)) as u32) << 8);
  let x32: u8 = (*IndexConst(arg1).index(0));
  let x33: u32 = (x31 + (x32 as u32));
  let x34: u32 = (x30 + x33);
  let x35: u32 = (x29 + x34);
  let x36: u32 = (x27 + (x28 as u32));
  let x37: u32 = (x26 + x36);
  let x38: u32 = (x25 + x37);
  let x39: u32 = (x23 + (x24 as u32));
  let x40: u32 = (x22 + x39);
  let x41: u32 = (x21 + x40);
  let x42: u32 = (x19 + (x20 as u32));
  let x43: u32 = (x18 + x42);
  let x44: u32 = (x17 + x43);
  let x45: u32 = (x15 + (x16 as u32));
  let x46: u32 = (x14 + x45);
  let x47: u32 = (x13 + x46);
  let x48: u32 = (x11 + (x12 as u32));
  let x49: u32 = (x10 + x48);
  let x50: u32 = (x9 + x49);
  let x51: u32 = (x7 + (x8 as u32));
  let x52: u32 = (x6 + x51);
  let x53: u32 = (x5 + x52);
  let x54: u32 = (x3 + (x4 as u32));
  let x55: u32 = (x2 + x54);
  let x56: u32 = (x1 + x55);
  *IndexConst(&mut out1).index_mut(0) = x35;
  *IndexConst(&mut out1).index_mut(1) = x38;
  *IndexConst(&mut out1).index_mut(2) = x41;
  *IndexConst(&mut out1).index_mut(3) = x44;
  *IndexConst(&mut out1).index_mut(4) = x47;
  *IndexConst(&mut out1).index_mut(5) = x50;
  *IndexConst(&mut out1).index_mut(6) = x53;
  *IndexConst(&mut out1).index_mut(7) = x56;
}

/// The function fiat_sm2_set_one returns the field element one in the Montgomery domain.
///
/// Postconditions:
///   eval (from_montgomery out1) mod m = 1 mod m
///   0 ≤ eval out1 < m
///
#[inline]
pub const fn fiat_sm2_set_one(mut out1: &mut fiat_sm2_montgomery_domain_field_element) {
  *IndexConst(&mut out1).index_mut(0) = (0x1 as u32);
  *IndexConst(&mut out1).index_mut(1) = (0x0 as u32);
  *IndexConst(&mut out1).index_mut(2) = 0xffffffff;
  *IndexConst(&mut out1).index_mut(3) = (0x0 as u32);
  *IndexConst(&mut out1).index_mut(4) = (0x0 as u32);
  *IndexConst(&mut out1).index_mut(5) = (0x0 as u32);
  *IndexConst(&mut out1).index_mut(6) = (0x0 as u32);
  *IndexConst(&mut out1).index_mut(7) = (0x1 as u32);
}

/// The function fiat_sm2_msat returns the saturated representation of the prime modulus.
///
/// Postconditions:
///   twos_complement_eval out1 = m
///   0 ≤ eval out1 < m
///
/// Output Bounds:
///   out1: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
#[inline]
pub const fn fiat_sm2_msat(mut out1: &mut [u32; 9]) {
  *IndexConst(&mut out1).index_mut(0) = 0xffffffff;
  *IndexConst(&mut out1).index_mut(1) = 0xffffffff;
  *IndexConst(&mut out1).index_mut(2) = (0x0 as u32);
  *IndexConst(&mut out1).index_mut(3) = 0xffffffff;
  *IndexConst(&mut out1).index_mut(4) = 0xffffffff;
  *IndexConst(&mut out1).index_mut(5) = 0xffffffff;
  *IndexConst(&mut out1).index_mut(6) = 0xffffffff;
  *IndexConst(&mut out1).index_mut(7) = 0xfffffffe;
  *IndexConst(&mut out1).index_mut(8) = (0x0 as u32);
}

/// The function fiat_sm2_divstep computes a divstep.
///
/// Preconditions:
///   0 ≤ eval arg4 < m
///   0 ≤ eval arg5 < m
/// Postconditions:
///   out1 = (if 0 < arg1 ∧ (twos_complement_eval arg3) is odd then 1 - arg1 else 1 + arg1)
///   twos_complement_eval out2 = (if 0 < arg1 ∧ (twos_complement_eval arg3) is odd then twos_complement_eval arg3 else twos_complement_eval arg2)
///   twos_complement_eval out3 = (if 0 < arg1 ∧ (twos_complement_eval arg3) is odd then ⌊(twos_complement_eval arg3 - twos_complement_eval arg2) / 2⌋ else ⌊(twos_complement_eval arg3 + (twos_complement_eval arg3 mod 2) * twos_complement_eval arg2) / 2⌋)
///   eval (from_montgomery out4) mod m = (if 0 < arg1 ∧ (twos_complement_eval arg3) is odd then (2 * eval (from_montgomery arg5)) mod m else (2 * eval (from_montgomery arg4)) mod m)
///   eval (from_montgomery out5) mod m = (if 0 < arg1 ∧ (twos_complement_eval arg3) is odd then (eval (from_montgomery arg4) - eval (from_montgomery arg4)) mod m else (eval (from_montgomery arg5) + (twos_complement_eval arg3 mod 2) * eval (from_montgomery arg4)) mod m)
///   0 ≤ eval out5 < m
///   0 ≤ eval out5 < m
///   0 ≤ eval out2 < m
///   0 ≤ eval out3 < m
///
/// Input Bounds:
///   arg1: [0x0 ~> 0xffffffff]
///   arg2: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
///   arg3: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
///   arg4: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
///   arg5: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
/// Output Bounds:
///   out1: [0x0 ~> 0xffffffff]
///   out2: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
///   out3: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
///   out4: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
///   out5: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
#[inline]
pub const fn fiat_sm2_divstep(out1: &mut u32, mut out2: &mut [u32; 9], mut out3: &mut [u32; 9], mut out4: &mut [u32; 8], mut out5: &mut [u32; 8], arg1: u32, arg2: &[u32; 9], arg3: &[u32; 9], arg4: &[u32; 8], arg5: &[u32; 8]) {
  let mut x1: u32 = 0;
  let mut x2: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x1, &mut x2, 0x0, (!arg1), (0x1 as u32));
  let x3: fiat_sm2_u1 = (((x1 >> 31) as fiat_sm2_u1) & (((*IndexConst(arg3).index(0)) & (0x1 as u32)) as fiat_sm2_u1));
  let mut x4: u32 = 0;
  let mut x5: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x4, &mut x5, 0x0, (!arg1), (0x1 as u32));
  let mut x6: u32 = 0;
  fiat_sm2_cmovznz_u32(&mut x6, x3, arg1, x4);
  let mut x7: u32 = 0;
  fiat_sm2_cmovznz_u32(&mut x7, x3, (*IndexConst(arg2).index(0)), (*IndexConst(arg3).index(0)));
  let mut x8: u32 = 0;
  fiat_sm2_cmovznz_u32(&mut x8, x3, (*IndexConst(arg2).index(1)), (*IndexConst(arg3).index(1)));
  let mut x9: u32 = 0;
  fiat_sm2_cmovznz_u32(&mut x9, x3, (*IndexConst(arg2).index(2)), (*IndexConst(arg3).index(2)));
  let mut x10: u32 = 0;
  fiat_sm2_cmovznz_u32(&mut x10, x3, (*IndexConst(arg2).index(3)), (*IndexConst(arg3).index(3)));
  let mut x11: u32 = 0;
  fiat_sm2_cmovznz_u32(&mut x11, x3, (*IndexConst(arg2).index(4)), (*IndexConst(arg3).index(4)));
  let mut x12: u32 = 0;
  fiat_sm2_cmovznz_u32(&mut x12, x3, (*IndexConst(arg2).index(5)), (*IndexConst(arg3).index(5)));
  let mut x13: u32 = 0;
  fiat_sm2_cmovznz_u32(&mut x13, x3, (*IndexConst(arg2).index(6)), (*IndexConst(arg3).index(6)));
  let mut x14: u32 = 0;
  fiat_sm2_cmovznz_u32(&mut x14, x3, (*IndexConst(arg2).index(7)), (*IndexConst(arg3).index(7)));
  let mut x15: u32 = 0;
  fiat_sm2_cmovznz_u32(&mut x15, x3, (*IndexConst(arg2).index(8)), (*IndexConst(arg3).index(8)));
  let mut x16: u32 = 0;
  let mut x17: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x16, &mut x17, 0x0, (0x1 as u32), (!(*IndexConst(arg2).index(0))));
  let mut x18: u32 = 0;
  let mut x19: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x18, &mut x19, x17, (0x0 as u32), (!(*IndexConst(arg2).index(1))));
  let mut x20: u32 = 0;
  let mut x21: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x20, &mut x21, x19, (0x0 as u32), (!(*IndexConst(arg2).index(2))));
  let mut x22: u32 = 0;
  let mut x23: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x22, &mut x23, x21, (0x0 as u32), (!(*IndexConst(arg2).index(3))));
  let mut x24: u32 = 0;
  let mut x25: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x24, &mut x25, x23, (0x0 as u32), (!(*IndexConst(arg2).index(4))));
  let mut x26: u32 = 0;
  let mut x27: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x26, &mut x27, x25, (0x0 as u32), (!(*IndexConst(arg2).index(5))));
  let mut x28: u32 = 0;
  let mut x29: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x28, &mut x29, x27, (0x0 as u32), (!(*IndexConst(arg2).index(6))));
  let mut x30: u32 = 0;
  let mut x31: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x30, &mut x31, x29, (0x0 as u32), (!(*IndexConst(arg2).index(7))));
  let mut x32: u32 = 0;
  let mut x33: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x32, &mut x33, x31, (0x0 as u32), (!(*IndexConst(arg2).index(8))));
  let mut x34: u32 = 0;
  fiat_sm2_cmovznz_u32(&mut x34, x3, (*IndexConst(arg3).index(0)), x16);
  let mut x35: u32 = 0;
  fiat_sm2_cmovznz_u32(&mut x35, x3, (*IndexConst(arg3).index(1)), x18);
  let mut x36: u32 = 0;
  fiat_sm2_cmovznz_u32(&mut x36, x3, (*IndexConst(arg3).index(2)), x20);
  let mut x37: u32 = 0;
  fiat_sm2_cmovznz_u32(&mut x37, x3, (*IndexConst(arg3).index(3)), x22);
  let mut x38: u32 = 0;
  fiat_sm2_cmovznz_u32(&mut x38, x3, (*IndexConst(arg3).index(4)), x24);
  let mut x39: u32 = 0;
  fiat_sm2_cmovznz_u32(&mut x39, x3, (*IndexConst(arg3).index(5)), x26);
  let mut x40: u32 = 0;
  fiat_sm2_cmovznz_u32(&mut x40, x3, (*IndexConst(arg3).index(6)), x28);
  let mut x41: u32 = 0;
  fiat_sm2_cmovznz_u32(&mut x41, x3, (*IndexConst(arg3).index(7)), x30);
  let mut x42: u32 = 0;
  fiat_sm2_cmovznz_u32(&mut x42, x3, (*IndexConst(arg3).index(8)), x32);
  let mut x43: u32 = 0;
  fiat_sm2_cmovznz_u32(&mut x43, x3, (*IndexConst(arg4).index(0)), (*IndexConst(arg5).index(0)));
  let mut x44: u32 = 0;
  fiat_sm2_cmovznz_u32(&mut x44, x3, (*IndexConst(arg4).index(1)), (*IndexConst(arg5).index(1)));
  let mut x45: u32 = 0;
  fiat_sm2_cmovznz_u32(&mut x45, x3, (*IndexConst(arg4).index(2)), (*IndexConst(arg5).index(2)));
  let mut x46: u32 = 0;
  fiat_sm2_cmovznz_u32(&mut x46, x3, (*IndexConst(arg4).index(3)), (*IndexConst(arg5).index(3)));
  let mut x47: u32 = 0;
  fiat_sm2_cmovznz_u32(&mut x47, x3, (*IndexConst(arg4).index(4)), (*IndexConst(arg5).index(4)));
  let mut x48: u32 = 0;
  fiat_sm2_cmovznz_u32(&mut x48, x3, (*IndexConst(arg4).index(5)), (*IndexConst(arg5).index(5)));
  let mut x49: u32 = 0;
  fiat_sm2_cmovznz_u32(&mut x49, x3, (*IndexConst(arg4).index(6)), (*IndexConst(arg5).index(6)));
  let mut x50: u32 = 0;
  fiat_sm2_cmovznz_u32(&mut x50, x3, (*IndexConst(arg4).index(7)), (*IndexConst(arg5).index(7)));
  let mut x51: u32 = 0;
  let mut x52: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x51, &mut x52, 0x0, x43, x43);
  let mut x53: u32 = 0;
  let mut x54: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x53, &mut x54, x52, x44, x44);
  let mut x55: u32 = 0;
  let mut x56: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x55, &mut x56, x54, x45, x45);
  let mut x57: u32 = 0;
  let mut x58: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x57, &mut x58, x56, x46, x46);
  let mut x59: u32 = 0;
  let mut x60: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x59, &mut x60, x58, x47, x47);
  let mut x61: u32 = 0;
  let mut x62: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x61, &mut x62, x60, x48, x48);
  let mut x63: u32 = 0;
  let mut x64: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x63, &mut x64, x62, x49, x49);
  let mut x65: u32 = 0;
  let mut x66: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x65, &mut x66, x64, x50, x50);
  let mut x67: u32 = 0;
  let mut x68: fiat_sm2_u1 = 0;
  fiat_sm2_subborrowx_u32(&mut x67, &mut x68, 0x0, x51, 0xffffffff);
  let mut x69: u32 = 0;
  let mut x70: fiat_sm2_u1 = 0;
  fiat_sm2_subborrowx_u32(&mut x69, &mut x70, x68, x53, 0xffffffff);
  let mut x71: u32 = 0;
  let mut x72: fiat_sm2_u1 = 0;
  fiat_sm2_subborrowx_u32(&mut x71, &mut x72, x70, x55, (0x0 as u32));
  let mut x73: u32 = 0;
  let mut x74: fiat_sm2_u1 = 0;
  fiat_sm2_subborrowx_u32(&mut x73, &mut x74, x72, x57, 0xffffffff);
  let mut x75: u32 = 0;
  let mut x76: fiat_sm2_u1 = 0;
  fiat_sm2_subborrowx_u32(&mut x75, &mut x76, x74, x59, 0xffffffff);
  let mut x77: u32 = 0;
  let mut x78: fiat_sm2_u1 = 0;
  fiat_sm2_subborrowx_u32(&mut x77, &mut x78, x76, x61, 0xffffffff);
  let mut x79: u32 = 0;
  let mut x80: fiat_sm2_u1 = 0;
  fiat_sm2_subborrowx_u32(&mut x79, &mut x80, x78, x63, 0xffffffff);
  let mut x81: u32 = 0;
  let mut x82: fiat_sm2_u1 = 0;
  fiat_sm2_subborrowx_u32(&mut x81, &mut x82, x80, x65, 0xfffffffe);
  let mut x83: u32 = 0;
  let mut x84: fiat_sm2_u1 = 0;
  fiat_sm2_subborrowx_u32(&mut x83, &mut x84, x82, (x66 as u32), (0x0 as u32));
  let x85: u32 = (*IndexConst(arg4).index(7));
  let x86: u32 = (*IndexConst(arg4).index(6));
  let x87: u32 = (*IndexConst(arg4).index(5));
  let x88: u32 = (*IndexConst(arg4).index(4));
  let x89: u32 = (*IndexConst(arg4).index(3));
  let x90: u32 = (*IndexConst(arg4).index(2));
  let x91: u32 = (*IndexConst(arg4).index(1));
  let x92: u32 = (*IndexConst(arg4).index(0));
  let mut x93: u32 = 0;
  let mut x94: fiat_sm2_u1 = 0;
  fiat_sm2_subborrowx_u32(&mut x93, &mut x94, 0x0, (0x0 as u32), x92);
  let mut x95: u32 = 0;
  let mut x96: fiat_sm2_u1 = 0;
  fiat_sm2_subborrowx_u32(&mut x95, &mut x96, x94, (0x0 as u32), x91);
  let mut x97: u32 = 0;
  let mut x98: fiat_sm2_u1 = 0;
  fiat_sm2_subborrowx_u32(&mut x97, &mut x98, x96, (0x0 as u32), x90);
  let mut x99: u32 = 0;
  let mut x100: fiat_sm2_u1 = 0;
  fiat_sm2_subborrowx_u32(&mut x99, &mut x100, x98, (0x0 as u32), x89);
  let mut x101: u32 = 0;
  let mut x102: fiat_sm2_u1 = 0;
  fiat_sm2_subborrowx_u32(&mut x101, &mut x102, x100, (0x0 as u32), x88);
  let mut x103: u32 = 0;
  let mut x104: fiat_sm2_u1 = 0;
  fiat_sm2_subborrowx_u32(&mut x103, &mut x104, x102, (0x0 as u32), x87);
  let mut x105: u32 = 0;
  let mut x106: fiat_sm2_u1 = 0;
  fiat_sm2_subborrowx_u32(&mut x105, &mut x106, x104, (0x0 as u32), x86);
  let mut x107: u32 = 0;
  let mut x108: fiat_sm2_u1 = 0;
  fiat_sm2_subborrowx_u32(&mut x107, &mut x108, x106, (0x0 as u32), x85);
  let mut x109: u32 = 0;
  fiat_sm2_cmovznz_u32(&mut x109, x108, (0x0 as u32), 0xffffffff);
  let mut x110: u32 = 0;
  let mut x111: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x110, &mut x111, 0x0, x93, x109);
  let mut x112: u32 = 0;
  let mut x113: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x112, &mut x113, x111, x95, x109);
  let mut x114: u32 = 0;
  let mut x115: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x114, &mut x115, x113, x97, (0x0 as u32));
  let mut x116: u32 = 0;
  let mut x117: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x116, &mut x117, x115, x99, x109);
  let mut x118: u32 = 0;
  let mut x119: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x118, &mut x119, x117, x101, x109);
  let mut x120: u32 = 0;
  let mut x121: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x120, &mut x121, x119, x103, x109);
  let mut x122: u32 = 0;
  let mut x123: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x122, &mut x123, x121, x105, x109);
  let mut x124: u32 = 0;
  let mut x125: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x124, &mut x125, x123, x107, (x109 & 0xfffffffe));
  let mut x126: u32 = 0;
  fiat_sm2_cmovznz_u32(&mut x126, x3, (*IndexConst(arg5).index(0)), x110);
  let mut x127: u32 = 0;
  fiat_sm2_cmovznz_u32(&mut x127, x3, (*IndexConst(arg5).index(1)), x112);
  let mut x128: u32 = 0;
  fiat_sm2_cmovznz_u32(&mut x128, x3, (*IndexConst(arg5).index(2)), x114);
  let mut x129: u32 = 0;
  fiat_sm2_cmovznz_u32(&mut x129, x3, (*IndexConst(arg5).index(3)), x116);
  let mut x130: u32 = 0;
  fiat_sm2_cmovznz_u32(&mut x130, x3, (*IndexConst(arg5).index(4)), x118);
  let mut x131: u32 = 0;
  fiat_sm2_cmovznz_u32(&mut x131, x3, (*IndexConst(arg5).index(5)), x120);
  let mut x132: u32 = 0;
  fiat_sm2_cmovznz_u32(&mut x132, x3, (*IndexConst(arg5).index(6)), x122);
  let mut x133: u32 = 0;
  fiat_sm2_cmovznz_u32(&mut x133, x3, (*IndexConst(arg5).index(7)), x124);
  let x134: fiat_sm2_u1 = ((x34 & (0x1 as u32)) as fiat_sm2_u1);
  let mut x135: u32 = 0;
  fiat_sm2_cmovznz_u32(&mut x135, x134, (0x0 as u32), x7);
  let mut x136: u32 = 0;
  fiat_sm2_cmovznz_u32(&mut x136, x134, (0x0 as u32), x8);
  let mut x137: u32 = 0;
  fiat_sm2_cmovznz_u32(&mut x137, x134, (0x0 as u32), x9);
  let mut x138: u32 = 0;
  fiat_sm2_cmovznz_u32(&mut x138, x134, (0x0 as u32), x10);
  let mut x139: u32 = 0;
  fiat_sm2_cmovznz_u32(&mut x139, x134, (0x0 as u32), x11);
  let mut x140: u32 = 0;
  fiat_sm2_cmovznz_u32(&mut x140, x134, (0x0 as u32), x12);
  let mut x141: u32 = 0;
  fiat_sm2_cmovznz_u32(&mut x141, x134, (0x0 as u32), x13);
  let mut x142: u32 = 0;
  fiat_sm2_cmovznz_u32(&mut x142, x134, (0x0 as u32), x14);
  let mut x143: u32 = 0;
  fiat_sm2_cmovznz_u32(&mut x143, x134, (0x0 as u32), x15);
  let mut x144: u32 = 0;
  let mut x145: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x144, &mut x145, 0x0, x34, x135);
  let mut x146: u32 = 0;
  let mut x147: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x146, &mut x147, x145, x35, x136);
  let mut x148: u32 = 0;
  let mut x149: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x148, &mut x149, x147, x36, x137);
  let mut x150: u32 = 0;
  let mut x151: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x150, &mut x151, x149, x37, x138);
  let mut x152: u32 = 0;
  let mut x153: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x152, &mut x153, x151, x38, x139);
  let mut x154: u32 = 0;
  let mut x155: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x154, &mut x155, x153, x39, x140);
  let mut x156: u32 = 0;
  let mut x157: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x156, &mut x157, x155, x40, x141);
  let mut x158: u32 = 0;
  let mut x159: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x158, &mut x159, x157, x41, x142);
  let mut x160: u32 = 0;
  let mut x161: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x160, &mut x161, x159, x42, x143);
  let mut x162: u32 = 0;
  fiat_sm2_cmovznz_u32(&mut x162, x134, (0x0 as u32), x43);
  let mut x163: u32 = 0;
  fiat_sm2_cmovznz_u32(&mut x163, x134, (0x0 as u32), x44);
  let mut x164: u32 = 0;
  fiat_sm2_cmovznz_u32(&mut x164, x134, (0x0 as u32), x45);
  let mut x165: u32 = 0;
  fiat_sm2_cmovznz_u32(&mut x165, x134, (0x0 as u32), x46);
  let mut x166: u32 = 0;
  fiat_sm2_cmovznz_u32(&mut x166, x134, (0x0 as u32), x47);
  let mut x167: u32 = 0;
  fiat_sm2_cmovznz_u32(&mut x167, x134, (0x0 as u32), x48);
  let mut x168: u32 = 0;
  fiat_sm2_cmovznz_u32(&mut x168, x134, (0x0 as u32), x49);
  let mut x169: u32 = 0;
  fiat_sm2_cmovznz_u32(&mut x169, x134, (0x0 as u32), x50);
  let mut x170: u32 = 0;
  let mut x171: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x170, &mut x171, 0x0, x126, x162);
  let mut x172: u32 = 0;
  let mut x173: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x172, &mut x173, x171, x127, x163);
  let mut x174: u32 = 0;
  let mut x175: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x174, &mut x175, x173, x128, x164);
  let mut x176: u32 = 0;
  let mut x177: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x176, &mut x177, x175, x129, x165);
  let mut x178: u32 = 0;
  let mut x179: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x178, &mut x179, x177, x130, x166);
  let mut x180: u32 = 0;
  let mut x181: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x180, &mut x181, x179, x131, x167);
  let mut x182: u32 = 0;
  let mut x183: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x182, &mut x183, x181, x132, x168);
  let mut x184: u32 = 0;
  let mut x185: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x184, &mut x185, x183, x133, x169);
  let mut x186: u32 = 0;
  let mut x187: fiat_sm2_u1 = 0;
  fiat_sm2_subborrowx_u32(&mut x186, &mut x187, 0x0, x170, 0xffffffff);
  let mut x188: u32 = 0;
  let mut x189: fiat_sm2_u1 = 0;
  fiat_sm2_subborrowx_u32(&mut x188, &mut x189, x187, x172, 0xffffffff);
  let mut x190: u32 = 0;
  let mut x191: fiat_sm2_u1 = 0;
  fiat_sm2_subborrowx_u32(&mut x190, &mut x191, x189, x174, (0x0 as u32));
  let mut x192: u32 = 0;
  let mut x193: fiat_sm2_u1 = 0;
  fiat_sm2_subborrowx_u32(&mut x192, &mut x193, x191, x176, 0xffffffff);
  let mut x194: u32 = 0;
  let mut x195: fiat_sm2_u1 = 0;
  fiat_sm2_subborrowx_u32(&mut x194, &mut x195, x193, x178, 0xffffffff);
  let mut x196: u32 = 0;
  let mut x197: fiat_sm2_u1 = 0;
  fiat_sm2_subborrowx_u32(&mut x196, &mut x197, x195, x180, 0xffffffff);
  let mut x198: u32 = 0;
  let mut x199: fiat_sm2_u1 = 0;
  fiat_sm2_subborrowx_u32(&mut x198, &mut x199, x197, x182, 0xffffffff);
  let mut x200: u32 = 0;
  let mut x201: fiat_sm2_u1 = 0;
  fiat_sm2_subborrowx_u32(&mut x200, &mut x201, x199, x184, 0xfffffffe);
  let mut x202: u32 = 0;
  let mut x203: fiat_sm2_u1 = 0;
  fiat_sm2_subborrowx_u32(&mut x202, &mut x203, x201, (x185 as u32), (0x0 as u32));
  let mut x204: u32 = 0;
  let mut x205: fiat_sm2_u1 = 0;
  fiat_sm2_addcarryx_u32(&mut x204, &mut x205, 0x0, x6, (0x1 as u32));
  let x206: u32 = ((x144 >> 1) | ((x146 << 31) & 0xffffffff));
  let x207: u32 = ((x146 >> 1) | ((x148 << 31) & 0xffffffff));
  let x208: u32 = ((x148 >> 1) | ((x150 << 31) & 0xffffffff));
  let x209: u32 = ((x150 >> 1) | ((x152 << 31) & 0xffffffff));
  let x210: u32 = ((x152 >> 1) | ((x154 << 31) & 0xffffffff));
  let x211: u32 = ((x154 >> 1) | ((x156 << 31) & 0xffffffff));
  let x212: u32 = ((x156 >> 1) | ((x158 << 31) & 0xffffffff));
  let x213: u32 = ((x158 >> 1) | ((x160 << 31) & 0xffffffff));
  let x214: u32 = ((x160 & 0x80000000) | (x160 >> 1));
  let mut x215: u32 = 0;
  fiat_sm2_cmovznz_u32(&mut x215, x84, x67, x51);
  let mut x216: u32 = 0;
  fiat_sm2_cmovznz_u32(&mut x216, x84, x69, x53);
  let mut x217: u32 = 0;
  fiat_sm2_cmovznz_u32(&mut x217, x84, x71, x55);
  let mut x218: u32 = 0;
  fiat_sm2_cmovznz_u32(&mut x218, x84, x73, x57);
  let mut x219: u32 = 0;
  fiat_sm2_cmovznz_u32(&mut x219, x84, x75, x59);
  let mut x220: u32 = 0;
  fiat_sm2_cmovznz_u32(&mut x220, x84, x77, x61);
  let mut x221: u32 = 0;
  fiat_sm2_cmovznz_u32(&mut x221, x84, x79, x63);
  let mut x222: u32 = 0;
  fiat_sm2_cmovznz_u32(&mut x222, x84, x81, x65);
  let mut x223: u32 = 0;
  fiat_sm2_cmovznz_u32(&mut x223, x203, x186, x170);
  let mut x224: u32 = 0;
  fiat_sm2_cmovznz_u32(&mut x224, x203, x188, x172);
  let mut x225: u32 = 0;
  fiat_sm2_cmovznz_u32(&mut x225, x203, x190, x174);
  let mut x226: u32 = 0;
  fiat_sm2_cmovznz_u32(&mut x226, x203, x192, x176);
  let mut x227: u32 = 0;
  fiat_sm2_cmovznz_u32(&mut x227, x203, x194, x178);
  let mut x228: u32 = 0;
  fiat_sm2_cmovznz_u32(&mut x228, x203, x196, x180);
  let mut x229: u32 = 0;
  fiat_sm2_cmovznz_u32(&mut x229, x203, x198, x182);
  let mut x230: u32 = 0;
  fiat_sm2_cmovznz_u32(&mut x230, x203, x200, x184);
  *out1 = x204;
  *IndexConst(&mut out2).index_mut(0) = x7;
  *IndexConst(&mut out2).index_mut(1) = x8;
  *IndexConst(&mut out2).index_mut(2) = x9;
  *IndexConst(&mut out2).index_mut(3) = x10;
  *IndexConst(&mut out2).index_mut(4) = x11;
  *IndexConst(&mut out2).index_mut(5) = x12;
  *IndexConst(&mut out2).index_mut(6) = x13;
  *IndexConst(&mut out2).index_mut(7) = x14;
  *IndexConst(&mut out2).index_mut(8) = x15;
  *IndexConst(&mut out3).index_mut(0) = x206;
  *IndexConst(&mut out3).index_mut(1) = x207;
  *IndexConst(&mut out3).index_mut(2) = x208;
  *IndexConst(&mut out3).index_mut(3) = x209;
  *IndexConst(&mut out3).index_mut(4) = x210;
  *IndexConst(&mut out3).index_mut(5) = x211;
  *IndexConst(&mut out3).index_mut(6) = x212;
  *IndexConst(&mut out3).index_mut(7) = x213;
  *IndexConst(&mut out3).index_mut(8) = x214;
  *IndexConst(&mut out4).index_mut(0) = x215;
  *IndexConst(&mut out4).index_mut(1) = x216;
  *IndexConst(&mut out4).index_mut(2) = x217;
  *IndexConst(&mut out4).index_mut(3) = x218;
  *IndexConst(&mut out4).index_mut(4) = x219;
  *IndexConst(&mut out4).index_mut(5) = x220;
  *IndexConst(&mut out4).index_mut(6) = x221;
  *IndexConst(&mut out4).index_mut(7) = x222;
  *IndexConst(&mut out5).index_mut(0) = x223;
  *IndexConst(&mut out5).index_mut(1) = x224;
  *IndexConst(&mut out5).index_mut(2) = x225;
  *IndexConst(&mut out5).index_mut(3) = x226;
  *IndexConst(&mut out5).index_mut(4) = x227;
  *IndexConst(&mut out5).index_mut(5) = x228;
  *IndexConst(&mut out5).index_mut(6) = x229;
  *IndexConst(&mut out5).index_mut(7) = x230;
}

/// The function fiat_sm2_divstep_precomp returns the precomputed value for Bernstein-Yang-inversion (in montgomery form).
///
/// Postconditions:
///   eval (from_montgomery out1) = ⌊(m - 1) / 2⌋^(if ⌊log2 m⌋ + 1 < 46 then ⌊(49 * (⌊log2 m⌋ + 1) + 80) / 17⌋ else ⌊(49 * (⌊log2 m⌋ + 1) + 57) / 17⌋)
///   0 ≤ eval out1 < m
///
/// Output Bounds:
///   out1: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
#[inline]
pub const fn fiat_sm2_divstep_precomp(mut out1: &mut [u32; 8]) {
  *IndexConst(&mut out1).index_mut(0) = 0x8ffffffe;
  *IndexConst(&mut out1).index_mut(1) = 0x50000002;
  *IndexConst(&mut out1).index_mut(2) = 0x9ffffffe;
  *IndexConst(&mut out1).index_mut(3) = 0xe8000000;
  *IndexConst(&mut out1).index_mut(4) = 0x8ffffffe;
  *IndexConst(&mut out1).index_mut(5) = 0xd0000001;
  *IndexConst(&mut out1).index_mut(6) = 0x1ffffffd;
  *IndexConst(&mut out1).index_mut(7) = 0x28000001;
}
