The type of the field in a tuple struct isn't an array when using the `#[simd]`
attribute.

Erroneous code example:

```compile_fail,E0076
#![feature(repr_simd)]

#[repr(simd)]
struct Bad(u16); // error!
```

When using the `#[simd]` attribute to automatically use SIMD operations in tuple
structs, if you want a single-lane vector then the field must be a 1-element
array, or the compiler will trigger this error.

Fixed example:

```
#![feature(repr_simd)]

#[repr(simd)]
struct Good([u16; 1]); // ok!
```
