/*  Copyright (c) 2005 Romain BONDUE
    This file is part of RutilT.

    RutilT is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    RutilT is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with RutilT; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/
/** \file CLIOpt.cxx
    \author Romain BONDUE
    \date 29/10/2006 */
#include <cstring> // strcmp()

#include "CLIOpt.h"
#include "ErrorsCode.h"



nsCore::CCLIOpt::CCLIOpt (int argc, char* argv []) throw (nsErrors::CException)
    : m_Flags (None)
{
    if (argc > 1)
    {
        int I (1);
        if (argv [I] [0] != '-')
            m_IfaceName = argv [I++];
        for ( ; I < argc ; ++I)
        {
            if (argv [I] [0] != '-')
                throw nsErrors::CException (std::string ("Invalid argument : ")
                                        + argv [I], nsErrors::InvalidArguments);
            if (argv [I] [1] == '-')
            {
                if (ParseLongOption (argv [I] + 2) == ProfileFlag)
                {
                    if (++I < argc)
                        m_ProfileName = argv [I];
                    else
                        throw nsErrors::CException ("Missing profile name.",
                                                    nsErrors::InvalidArguments);
                }
            }
            else
            {
                if (ParseShortOption (argv [I] + 1) == ProfileFlag)
                {
                    if (++I < argc)
                        m_ProfileName = argv [I];
                    else
                        throw nsErrors::CException ("Missing profile name.",
                                                    nsErrors::InvalidArguments);
                }
            }
        }
    }

} // CCLIOpt()


int nsCore::CCLIOpt::ParseShortOption (const char* Options)
                                                    throw (nsErrors::CException)
{
    int LastFlag (None);
    for ( ; *Options ; ++Options)
        switch (*Options)
        {
          case 'h' :
            m_Flags |= HelpFlag;
            LastFlag = HelpFlag;
          break;

          case 'v' :
            m_Flags |= VersionFlag;
            LastFlag = VersionFlag;
          break;

          case 't' :
            m_Flags |= HiddenFlag;
            LastFlag = HiddenFlag;
          break;

          case 'e' :
            m_Flags |= ExitFlag;
            LastFlag = ExitFlag;
          break;

          case 'd' :
            m_Flags |= DhcpFlag;
            LastFlag = DhcpFlag;
          break;

          case 'p' :
            m_Flags |= ProfileFlag;
            LastFlag = ProfileFlag;
          break;
        }
    return LastFlag;

} // ParseShortOption()


int nsCore::CCLIOpt::ParseLongOption (const char* Options)
                                                    throw (nsErrors::CException)
{
    if (!std::strcmp (Options, "help"))
    {
        m_Flags |= HelpFlag;
        return HelpFlag;
    }
    if (!std::strcmp (Options, "version"))
    {
        m_Flags |= VersionFlag;
        return VersionFlag;
    }
    if (!std::strcmp (Options, "hide"))
    {
        m_Flags |= HiddenFlag;
        return HiddenFlag;
    }
    if (!std::strcmp (Options, "exit"))
    {
        m_Flags |= ExitFlag;
        return ExitFlag;
    }
    if (!std::strcmp (Options, "dhcp"))
    {
        m_Flags |= DhcpFlag;
        return DhcpFlag;
    }
    if (!std::strcmp (Options, "profile"))
    {
        m_Flags |= ProfileFlag;
        return ProfileFlag;
    }
    return None;

} // ParseLongOption()
