/* rygel-http-byte-seek.c generated by valac 0.20.1, the Vala compiler
 * generated from rygel-http-byte-seek.vala, do not modify */

/*
 * Copyright (C) 2009 Nokia Corporation.
 * Copyright (C) 2012 Intel Corporation.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                               <zeeshan.ali@nokia.com>
 *         Jens Georg <jensg@openismus.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <libsoup/soup.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>


#define RYGEL_TYPE_HTTP_SEEK (rygel_http_seek_get_type ())
#define RYGEL_HTTP_SEEK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_SEEK, RygelHTTPSeek))
#define RYGEL_HTTP_SEEK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_SEEK, RygelHTTPSeekClass))
#define RYGEL_IS_HTTP_SEEK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_SEEK))
#define RYGEL_IS_HTTP_SEEK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_SEEK))
#define RYGEL_HTTP_SEEK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_SEEK, RygelHTTPSeekClass))

typedef struct _RygelHTTPSeek RygelHTTPSeek;
typedef struct _RygelHTTPSeekClass RygelHTTPSeekClass;
typedef struct _RygelHTTPSeekPrivate RygelHTTPSeekPrivate;

#define RYGEL_TYPE_HTTP_BYTE_SEEK (rygel_http_byte_seek_get_type ())
#define RYGEL_HTTP_BYTE_SEEK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_BYTE_SEEK, RygelHTTPByteSeek))
#define RYGEL_HTTP_BYTE_SEEK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_BYTE_SEEK, RygelHTTPByteSeekClass))
#define RYGEL_IS_HTTP_BYTE_SEEK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_BYTE_SEEK))
#define RYGEL_IS_HTTP_BYTE_SEEK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_BYTE_SEEK))
#define RYGEL_HTTP_BYTE_SEEK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_BYTE_SEEK, RygelHTTPByteSeekClass))

typedef struct _RygelHTTPByteSeek RygelHTTPByteSeek;
typedef struct _RygelHTTPByteSeekClass RygelHTTPByteSeekClass;
typedef struct _RygelHTTPByteSeekPrivate RygelHTTPByteSeekPrivate;

#define RYGEL_TYPE_HTTP_GET (rygel_http_get_get_type ())
#define RYGEL_HTTP_GET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_GET, RygelHTTPGet))
#define RYGEL_HTTP_GET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_GET, RygelHTTPGetClass))
#define RYGEL_IS_HTTP_GET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_GET))
#define RYGEL_IS_HTTP_GET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_GET))
#define RYGEL_HTTP_GET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_GET, RygelHTTPGetClass))

typedef struct _RygelHTTPGet RygelHTTPGet;
typedef struct _RygelHTTPGetClass RygelHTTPGetClass;
typedef struct _RygelHTTPGetPrivate RygelHTTPGetPrivate;

#define RYGEL_TYPE_MEDIA_OBJECT (rygel_media_object_get_type ())
#define RYGEL_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObject))
#define RYGEL_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))
#define RYGEL_IS_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_IS_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_MEDIA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))

typedef struct _RygelMediaObject RygelMediaObject;
typedef struct _RygelMediaObjectClass RygelMediaObjectClass;

#define RYGEL_TYPE_THUMBNAIL (rygel_thumbnail_get_type ())
#define RYGEL_THUMBNAIL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_THUMBNAIL, RygelThumbnail))
#define RYGEL_THUMBNAIL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_THUMBNAIL, RygelThumbnailClass))
#define RYGEL_IS_THUMBNAIL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_THUMBNAIL))
#define RYGEL_IS_THUMBNAIL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_THUMBNAIL))
#define RYGEL_THUMBNAIL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_THUMBNAIL, RygelThumbnailClass))

typedef struct _RygelThumbnail RygelThumbnail;
typedef struct _RygelThumbnailClass RygelThumbnailClass;

#define RYGEL_TYPE_SUBTITLE (rygel_subtitle_get_type ())
#define RYGEL_SUBTITLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_SUBTITLE, RygelSubtitle))
#define RYGEL_SUBTITLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_SUBTITLE, RygelSubtitleClass))
#define RYGEL_IS_SUBTITLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_SUBTITLE))
#define RYGEL_IS_SUBTITLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_SUBTITLE))
#define RYGEL_SUBTITLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_SUBTITLE, RygelSubtitleClass))

typedef struct _RygelSubtitle RygelSubtitle;
typedef struct _RygelSubtitleClass RygelSubtitleClass;

#define RYGEL_TYPE_HTTP_IDENTITY_HANDLER (rygel_http_identity_handler_get_type ())
#define RYGEL_HTTP_IDENTITY_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_IDENTITY_HANDLER, RygelHTTPIdentityHandler))
#define RYGEL_HTTP_IDENTITY_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_IDENTITY_HANDLER, RygelHTTPIdentityHandlerClass))
#define RYGEL_IS_HTTP_IDENTITY_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_IDENTITY_HANDLER))
#define RYGEL_IS_HTTP_IDENTITY_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_IDENTITY_HANDLER))
#define RYGEL_HTTP_IDENTITY_HANDLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_IDENTITY_HANDLER, RygelHTTPIdentityHandlerClass))

typedef struct _RygelHTTPIdentityHandler RygelHTTPIdentityHandler;
typedef struct _RygelHTTPIdentityHandlerClass RygelHTTPIdentityHandlerClass;
typedef struct _RygelThumbnailPrivate RygelThumbnailPrivate;
typedef struct _RygelSubtitlePrivate RygelSubtitlePrivate;

#define RYGEL_TYPE_MEDIA_ITEM (rygel_media_item_get_type ())
#define RYGEL_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItem))
#define RYGEL_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))
#define RYGEL_IS_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_IS_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_MEDIA_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))

typedef struct _RygelMediaItem RygelMediaItem;
typedef struct _RygelMediaItemClass RygelMediaItemClass;
typedef struct _RygelMediaObjectPrivate RygelMediaObjectPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define RYGEL_TYPE_HTTP_SEEK_TYPE (rygel_http_seek_type_get_type ())

#define RYGEL_TYPE_CLIENT_HACKS (rygel_client_hacks_get_type ())
#define RYGEL_CLIENT_HACKS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_CLIENT_HACKS, RygelClientHacks))
#define RYGEL_CLIENT_HACKS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_CLIENT_HACKS, RygelClientHacksClass))
#define RYGEL_IS_CLIENT_HACKS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_CLIENT_HACKS))
#define RYGEL_IS_CLIENT_HACKS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_CLIENT_HACKS))
#define RYGEL_CLIENT_HACKS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_CLIENT_HACKS, RygelClientHacksClass))

typedef struct _RygelClientHacks RygelClientHacks;
typedef struct _RygelClientHacksClass RygelClientHacksClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define RYGEL_TYPE_MEDIA_CONTAINER (rygel_media_container_get_type ())
#define RYGEL_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainer))
#define RYGEL_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))
#define RYGEL_IS_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_IS_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_MEDIA_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))

typedef struct _RygelMediaContainer RygelMediaContainer;
typedef struct _RygelMediaContainerClass RygelMediaContainerClass;
#define _g_free0(var) (var = (g_free (var), NULL))

struct _RygelHTTPSeek {
	GObject parent_instance;
	RygelHTTPSeekPrivate * priv;
};

struct _RygelHTTPSeekClass {
	GObjectClass parent_class;
	void (*add_response_headers) (RygelHTTPSeek* self);
};

struct _RygelHTTPByteSeek {
	RygelHTTPSeek parent_instance;
	RygelHTTPByteSeekPrivate * priv;
};

struct _RygelHTTPByteSeekClass {
	RygelHTTPSeekClass parent_class;
};

typedef enum  {
	RYGEL_HTTP_SEEK_ERROR_INVALID_RANGE = SOUP_STATUS_BAD_REQUEST,
	RYGEL_HTTP_SEEK_ERROR_OUT_OF_RANGE = SOUP_STATUS_REQUESTED_RANGE_NOT_SATISFIABLE
} RygelHTTPSeekError;
#define RYGEL_HTTP_SEEK_ERROR rygel_http_seek_error_quark ()
struct _RygelHTTPGet {
	GObject parent_instance;
	RygelHTTPGetPrivate * priv;
	SoupMessage* msg;
	RygelMediaObject* object;
	RygelThumbnail* thumbnail;
	RygelSubtitle* subtitle;
	RygelHTTPIdentityHandler* handler;
};

struct _RygelHTTPGetClass {
	GObjectClass parent_class;
};

struct _RygelThumbnail {
	GObject parent_instance;
	RygelThumbnailPrivate * priv;
	gint64 size;
};

struct _RygelThumbnailClass {
	GObjectClass parent_class;
};

struct _RygelSubtitle {
	GObject parent_instance;
	RygelSubtitlePrivate * priv;
	gint64 size;
};

struct _RygelSubtitleClass {
	GObjectClass parent_class;
};

struct _RygelMediaObject {
	GObject parent_instance;
	RygelMediaObjectPrivate * priv;
	gint64 size;
};

struct _RygelMediaObjectClass {
	GObjectClass parent_class;
};

typedef enum  {
	RYGEL_HTTP_SEEK_TYPE_BYTE,
	RYGEL_HTTP_SEEK_TYPE_TIME
} RygelHTTPSeekType;


static gpointer rygel_http_byte_seek_parent_class = NULL;

GType rygel_http_seek_get_type (void) G_GNUC_CONST;
GType rygel_http_byte_seek_get_type (void) G_GNUC_CONST;
enum  {
	RYGEL_HTTP_BYTE_SEEK_DUMMY_PROPERTY
};
GType rygel_http_get_get_type (void) G_GNUC_CONST;
GQuark rygel_http_seek_error_quark (void);
RygelHTTPByteSeek* rygel_http_byte_seek_new (RygelHTTPGet* request, GError** error);
RygelHTTPByteSeek* rygel_http_byte_seek_construct (GType object_type, RygelHTTPGet* request, GError** error);
GType rygel_media_object_get_type (void) G_GNUC_CONST;
GType rygel_thumbnail_get_type (void) G_GNUC_CONST;
GType rygel_subtitle_get_type (void) G_GNUC_CONST;
GType rygel_http_identity_handler_get_type (void) G_GNUC_CONST;
GType rygel_media_item_get_type (void) G_GNUC_CONST;
RygelHTTPSeek* rygel_http_seek_construct (GType object_type, SoupMessage* msg, gint64 start, gint64 stop, gint64 step, gint64 total_length, GError** error);
GType rygel_http_seek_type_get_type (void) G_GNUC_CONST;
void rygel_http_seek_set_seek_type (RygelHTTPSeek* self, RygelHTTPSeekType value);
gboolean rygel_http_byte_seek_needed (RygelHTTPGet* request);
GType rygel_client_hacks_get_type (void) G_GNUC_CONST;
RygelClientHacks* rygel_client_hacks_create (SoupMessage* msg, GError** error);
gboolean rygel_client_hacks_force_seek (RygelClientHacks* self);
GType rygel_media_container_get_type (void) G_GNUC_CONST;
gboolean rygel_http_byte_seek_requested (RygelHTTPGet* request);
static void rygel_http_byte_seek_real_add_response_headers (RygelHTTPSeek* base);
SoupMessage* rygel_http_seek_get_msg (RygelHTTPSeek* self);
gint64 rygel_http_seek_get_start (RygelHTTPSeek* self);
gint64 rygel_http_seek_get_stop (RygelHTTPSeek* self);
gint64 rygel_http_seek_get_total_length (RygelHTTPSeek* self);
gint64 rygel_http_seek_get_length (RygelHTTPSeek* self);


RygelHTTPByteSeek* rygel_http_byte_seek_construct (GType object_type, RygelHTTPGet* request, GError** error) {
	RygelHTTPByteSeek * self = NULL;
	SoupRange* ranges = NULL;
	gint ranges_length1 = 0;
	gint _ranges_size_ = 0;
	gint64 start;
	gint64 total_length = 0LL;
	RygelHTTPGet* _tmp0_;
	SoupMessage* _tmp1_;
	SoupMessageHeaders* _tmp2_;
	const gchar* _tmp3_ = NULL;
	const gchar* range;
	RygelHTTPGet* _tmp4_;
	RygelThumbnail* _tmp5_;
	gint64 _tmp17_;
	gint64 stop;
	const gchar* _tmp18_;
	RygelHTTPGet* _tmp40_;
	SoupMessage* _tmp41_;
	gint64 _tmp42_;
	gint64 _tmp43_;
	gint64 _tmp44_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (request != NULL, NULL);
	start = (gint64) 0;
	_tmp0_ = request;
	_tmp1_ = _tmp0_->msg;
	_tmp2_ = _tmp1_->request_headers;
	_tmp3_ = soup_message_headers_get_one (_tmp2_, "Range");
	range = _tmp3_;
	_tmp4_ = request;
	_tmp5_ = _tmp4_->thumbnail;
	if (_tmp5_ != NULL) {
		RygelHTTPGet* _tmp6_;
		RygelThumbnail* _tmp7_;
		gint64 _tmp8_;
		_tmp6_ = request;
		_tmp7_ = _tmp6_->thumbnail;
		_tmp8_ = _tmp7_->size;
		total_length = _tmp8_;
	} else {
		RygelHTTPGet* _tmp9_;
		RygelSubtitle* _tmp10_;
		_tmp9_ = request;
		_tmp10_ = _tmp9_->subtitle;
		if (_tmp10_ != NULL) {
			RygelHTTPGet* _tmp11_;
			RygelSubtitle* _tmp12_;
			gint64 _tmp13_;
			_tmp11_ = request;
			_tmp12_ = _tmp11_->subtitle;
			_tmp13_ = _tmp12_->size;
			total_length = _tmp13_;
		} else {
			RygelHTTPGet* _tmp14_;
			RygelMediaObject* _tmp15_;
			gint64 _tmp16_;
			_tmp14_ = request;
			_tmp15_ = _tmp14_->object;
			_tmp16_ = ((RygelMediaObject*) (G_TYPE_CHECK_INSTANCE_TYPE (_tmp15_, RYGEL_TYPE_MEDIA_ITEM) ? ((RygelMediaItem*) _tmp15_) : NULL))->size;
			total_length = _tmp16_;
		}
	}
	_tmp17_ = total_length;
	stop = _tmp17_ - 1;
	_tmp18_ = range;
	if (_tmp18_ != NULL) {
		RygelHTTPGet* _tmp19_;
		SoupMessage* _tmp20_;
		SoupMessageHeaders* _tmp21_;
		gint64 _tmp22_;
		SoupRange* _tmp23_ = NULL;
		gint _tmp24_ = 0;
		gboolean _tmp25_ = FALSE;
		gint64 _tmp35_;
		gint64 _tmp36_;
		_tmp19_ = request;
		_tmp20_ = _tmp19_->msg;
		_tmp21_ = _tmp20_->request_headers;
		_tmp22_ = total_length;
		_tmp25_ = soup_message_headers_get_ranges (_tmp21_, _tmp22_, (SoupRange**) (&_tmp23_), &_tmp24_);
		ranges = (g_free (ranges), NULL);
		ranges = _tmp23_;
		ranges_length1 = _tmp24_;
		_ranges_size_ = ranges_length1;
		if (_tmp25_) {
			SoupRange* _tmp26_;
			gint _tmp26__length1;
			SoupRange _tmp27_;
			gint64 _tmp28_;
			SoupRange* _tmp29_;
			gint _tmp29__length1;
			SoupRange _tmp30_;
			gint64 _tmp31_;
			_tmp26_ = ranges;
			_tmp26__length1 = ranges_length1;
			_tmp27_ = _tmp26_[0];
			_tmp28_ = _tmp27_.start;
			start = _tmp28_;
			_tmp29_ = ranges;
			_tmp29__length1 = ranges_length1;
			_tmp30_ = _tmp29_[0];
			_tmp31_ = _tmp30_.end;
			stop = _tmp31_;
		} else {
			const gchar* _tmp32_ = NULL;
			const gchar* _tmp33_;
			GError* _tmp34_;
			_tmp32_ = _ ("Invalid Range '%s'");
			_tmp33_ = range;
			_tmp34_ = g_error_new (RYGEL_HTTP_SEEK_ERROR, RYGEL_HTTP_SEEK_ERROR_INVALID_RANGE, _tmp32_, _tmp33_);
			_inner_error_ = _tmp34_;
			if (_inner_error_->domain == RYGEL_HTTP_SEEK_ERROR) {
				g_propagate_error (error, _inner_error_);
				ranges = (g_free (ranges), NULL);
				_g_object_unref0 (self);
				return NULL;
			} else {
				ranges = (g_free (ranges), NULL);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
		_tmp35_ = start;
		_tmp36_ = stop;
		if (_tmp35_ > _tmp36_) {
			const gchar* _tmp37_ = NULL;
			const gchar* _tmp38_;
			GError* _tmp39_;
			_tmp37_ = _ ("Invalid Range '%s'");
			_tmp38_ = range;
			_tmp39_ = g_error_new (RYGEL_HTTP_SEEK_ERROR, RYGEL_HTTP_SEEK_ERROR_INVALID_RANGE, _tmp37_, _tmp38_);
			_inner_error_ = _tmp39_;
			if (_inner_error_->domain == RYGEL_HTTP_SEEK_ERROR) {
				g_propagate_error (error, _inner_error_);
				ranges = (g_free (ranges), NULL);
				_g_object_unref0 (self);
				return NULL;
			} else {
				ranges = (g_free (ranges), NULL);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
	}
	_tmp40_ = request;
	_tmp41_ = _tmp40_->msg;
	_tmp42_ = start;
	_tmp43_ = stop;
	_tmp44_ = total_length;
	self = (RygelHTTPByteSeek*) rygel_http_seek_construct (object_type, _tmp41_, _tmp42_, _tmp43_, (gint64) 1, _tmp44_, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == RYGEL_HTTP_SEEK_ERROR) {
			g_propagate_error (error, _inner_error_);
			ranges = (g_free (ranges), NULL);
			_g_object_unref0 (self);
			return NULL;
		} else {
			ranges = (g_free (ranges), NULL);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	rygel_http_seek_set_seek_type ((RygelHTTPSeek*) self, RYGEL_HTTP_SEEK_TYPE_BYTE);
	ranges = (g_free (ranges), NULL);
	return self;
}


RygelHTTPByteSeek* rygel_http_byte_seek_new (RygelHTTPGet* request, GError** error) {
	return rygel_http_byte_seek_construct (RYGEL_TYPE_HTTP_BYTE_SEEK, request, error);
}


gboolean rygel_http_byte_seek_needed (RygelHTTPGet* request) {
	gboolean result = FALSE;
	gboolean force_seek;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp5_;
	gboolean _tmp35_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (request != NULL, FALSE);
	force_seek = FALSE;
	{
		RygelHTTPGet* _tmp0_;
		SoupMessage* _tmp1_;
		RygelClientHacks* _tmp2_ = NULL;
		RygelClientHacks* hack;
		gboolean _tmp3_ = FALSE;
		_tmp0_ = request;
		_tmp1_ = _tmp0_->msg;
		_tmp2_ = rygel_client_hacks_create (_tmp1_, &_inner_error_);
		hack = _tmp2_;
		if (_inner_error_ != NULL) {
			goto __catch4_g_error;
		}
		_tmp3_ = rygel_client_hacks_force_seek (hack);
		force_seek = _tmp3_;
		_g_object_unref0 (hack);
	}
	goto __finally4;
	__catch4_g_error:
	{
		GError* _error_ = NULL;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		_g_error_free0 (_error_);
	}
	__finally4:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	_tmp5_ = force_seek;
	if (_tmp5_) {
		_tmp4_ = TRUE;
	} else {
		gboolean _tmp6_ = FALSE;
		gboolean _tmp7_ = FALSE;
		gboolean _tmp8_ = FALSE;
		RygelHTTPGet* _tmp9_;
		RygelMediaObject* _tmp10_;
		gboolean _tmp18_;
		gboolean _tmp26_;
		gboolean _tmp34_;
		_tmp9_ = request;
		_tmp10_ = _tmp9_->object;
		if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp10_, RYGEL_TYPE_MEDIA_CONTAINER)) {
			gboolean _tmp11_ = FALSE;
			RygelHTTPGet* _tmp12_;
			RygelMediaObject* _tmp13_;
			gint64 _tmp14_;
			gboolean _tmp17_;
			_tmp12_ = request;
			_tmp13_ = _tmp12_->object;
			_tmp14_ = ((RygelMediaObject*) (G_TYPE_CHECK_INSTANCE_TYPE (_tmp13_, RYGEL_TYPE_MEDIA_ITEM) ? ((RygelMediaItem*) _tmp13_) : NULL))->size;
			if (_tmp14_ > ((gint64) 0)) {
				RygelHTTPGet* _tmp15_;
				RygelHTTPIdentityHandler* _tmp16_;
				_tmp15_ = request;
				_tmp16_ = _tmp15_->handler;
				_tmp11_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp16_, RYGEL_TYPE_HTTP_IDENTITY_HANDLER);
			} else {
				_tmp11_ = FALSE;
			}
			_tmp17_ = _tmp11_;
			_tmp8_ = _tmp17_;
		} else {
			_tmp8_ = FALSE;
		}
		_tmp18_ = _tmp8_;
		if (_tmp18_) {
			_tmp7_ = TRUE;
		} else {
			gboolean _tmp19_ = FALSE;
			RygelHTTPGet* _tmp20_;
			RygelThumbnail* _tmp21_;
			gboolean _tmp25_;
			_tmp20_ = request;
			_tmp21_ = _tmp20_->thumbnail;
			if (_tmp21_ != NULL) {
				RygelHTTPGet* _tmp22_;
				RygelThumbnail* _tmp23_;
				gint64 _tmp24_;
				_tmp22_ = request;
				_tmp23_ = _tmp22_->thumbnail;
				_tmp24_ = _tmp23_->size;
				_tmp19_ = _tmp24_ > ((gint64) 0);
			} else {
				_tmp19_ = FALSE;
			}
			_tmp25_ = _tmp19_;
			_tmp7_ = _tmp25_;
		}
		_tmp26_ = _tmp7_;
		if (_tmp26_) {
			_tmp6_ = TRUE;
		} else {
			gboolean _tmp27_ = FALSE;
			RygelHTTPGet* _tmp28_;
			RygelSubtitle* _tmp29_;
			gboolean _tmp33_;
			_tmp28_ = request;
			_tmp29_ = _tmp28_->subtitle;
			if (_tmp29_ != NULL) {
				RygelHTTPGet* _tmp30_;
				RygelSubtitle* _tmp31_;
				gint64 _tmp32_;
				_tmp30_ = request;
				_tmp31_ = _tmp30_->subtitle;
				_tmp32_ = _tmp31_->size;
				_tmp27_ = _tmp32_ > ((gint64) 0);
			} else {
				_tmp27_ = FALSE;
			}
			_tmp33_ = _tmp27_;
			_tmp6_ = _tmp33_;
		}
		_tmp34_ = _tmp6_;
		_tmp4_ = _tmp34_;
	}
	_tmp35_ = _tmp4_;
	result = _tmp35_;
	return result;
}


gboolean rygel_http_byte_seek_requested (RygelHTTPGet* request) {
	gboolean result = FALSE;
	RygelHTTPGet* _tmp0_;
	SoupMessage* _tmp1_;
	SoupMessageHeaders* _tmp2_;
	const gchar* _tmp3_ = NULL;
	g_return_val_if_fail (request != NULL, FALSE);
	_tmp0_ = request;
	_tmp1_ = _tmp0_->msg;
	_tmp2_ = _tmp1_->request_headers;
	_tmp3_ = soup_message_headers_get_one (_tmp2_, "Range");
	result = _tmp3_ != NULL;
	return result;
}


static void rygel_http_byte_seek_real_add_response_headers (RygelHTTPSeek* base) {
	RygelHTTPByteSeek * self;
	gchar* _tmp0_;
	gchar* range;
	SoupMessage* _tmp1_;
	SoupMessage* _tmp2_;
	SoupMessageHeaders* _tmp3_;
	SoupMessageHeaders* headers;
	SoupMessage* _tmp4_;
	SoupMessage* _tmp5_;
	SoupMessageHeaders* _tmp6_;
	const gchar* _tmp7_ = NULL;
	SoupMessageHeaders* _tmp33_;
	gint64 _tmp34_;
	gint64 _tmp35_;
	self = (RygelHTTPByteSeek*) base;
	_tmp0_ = g_strdup ("bytes ");
	range = _tmp0_;
	_tmp1_ = rygel_http_seek_get_msg ((RygelHTTPSeek*) self);
	_tmp2_ = _tmp1_;
	_tmp3_ = _tmp2_->response_headers;
	headers = _tmp3_;
	_tmp4_ = rygel_http_seek_get_msg ((RygelHTTPSeek*) self);
	_tmp5_ = _tmp4_;
	_tmp6_ = _tmp5_->request_headers;
	_tmp7_ = soup_message_headers_get_one (_tmp6_, "Range");
	if (_tmp7_ != NULL) {
		SoupMessageHeaders* _tmp8_;
		const gchar* _tmp9_;
		gint64 _tmp10_;
		gint64 _tmp11_;
		gchar* _tmp12_ = NULL;
		gchar* _tmp13_;
		gchar* _tmp14_;
		gchar* _tmp15_;
		gint64 _tmp16_;
		gint64 _tmp17_;
		gchar* _tmp18_ = NULL;
		gchar* _tmp19_;
		gchar* _tmp20_;
		gchar* _tmp21_;
		gchar* _tmp22_;
		gchar* _tmp23_;
		gint64 _tmp24_;
		gint64 _tmp25_;
		gchar* _tmp26_ = NULL;
		gchar* _tmp27_;
		gchar* _tmp28_;
		gchar* _tmp29_;
		gchar* _tmp30_;
		SoupMessageHeaders* _tmp31_;
		const gchar* _tmp32_;
		_tmp8_ = headers;
		soup_message_headers_append (_tmp8_, "Accept-Ranges", "bytes");
		_tmp9_ = range;
		_tmp10_ = rygel_http_seek_get_start ((RygelHTTPSeek*) self);
		_tmp11_ = _tmp10_;
		_tmp12_ = g_strdup_printf ("%" G_GINT64_FORMAT, _tmp11_);
		_tmp13_ = _tmp12_;
		_tmp14_ = g_strconcat (_tmp13_, "-", NULL);
		_tmp15_ = _tmp14_;
		_tmp16_ = rygel_http_seek_get_stop ((RygelHTTPSeek*) self);
		_tmp17_ = _tmp16_;
		_tmp18_ = g_strdup_printf ("%" G_GINT64_FORMAT, _tmp17_);
		_tmp19_ = _tmp18_;
		_tmp20_ = g_strconcat (_tmp15_, _tmp19_, NULL);
		_tmp21_ = _tmp20_;
		_tmp22_ = g_strconcat (_tmp21_, "/", NULL);
		_tmp23_ = _tmp22_;
		_tmp24_ = rygel_http_seek_get_total_length ((RygelHTTPSeek*) self);
		_tmp25_ = _tmp24_;
		_tmp26_ = g_strdup_printf ("%" G_GINT64_FORMAT, _tmp25_);
		_tmp27_ = _tmp26_;
		_tmp28_ = g_strconcat (_tmp23_, _tmp27_, NULL);
		_tmp29_ = _tmp28_;
		_tmp30_ = g_strconcat (_tmp9_, _tmp29_, NULL);
		_g_free0 (range);
		range = _tmp30_;
		_g_free0 (_tmp29_);
		_g_free0 (_tmp27_);
		_g_free0 (_tmp23_);
		_g_free0 (_tmp21_);
		_g_free0 (_tmp19_);
		_g_free0 (_tmp15_);
		_g_free0 (_tmp13_);
		_tmp31_ = headers;
		_tmp32_ = range;
		soup_message_headers_append (_tmp31_, "Content-Range", _tmp32_);
	}
	_tmp33_ = headers;
	_tmp34_ = rygel_http_seek_get_length ((RygelHTTPSeek*) self);
	_tmp35_ = _tmp34_;
	soup_message_headers_set_content_length (_tmp33_, _tmp35_);
	_g_free0 (range);
}


static void rygel_http_byte_seek_class_init (RygelHTTPByteSeekClass * klass) {
	rygel_http_byte_seek_parent_class = g_type_class_peek_parent (klass);
	RYGEL_HTTP_SEEK_CLASS (klass)->add_response_headers = rygel_http_byte_seek_real_add_response_headers;
}


static void rygel_http_byte_seek_instance_init (RygelHTTPByteSeek * self) {
}


GType rygel_http_byte_seek_get_type (void) {
	static volatile gsize rygel_http_byte_seek_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_http_byte_seek_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelHTTPByteSeekClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_http_byte_seek_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelHTTPByteSeek), 0, (GInstanceInitFunc) rygel_http_byte_seek_instance_init, NULL };
		GType rygel_http_byte_seek_type_id;
		rygel_http_byte_seek_type_id = g_type_register_static (RYGEL_TYPE_HTTP_SEEK, "RygelHTTPByteSeek", &g_define_type_info, 0);
		g_once_init_leave (&rygel_http_byte_seek_type_id__volatile, rygel_http_byte_seek_type_id);
	}
	return rygel_http_byte_seek_type_id__volatile;
}



