/*
 * Decompiled with CFR 0.152.
 */
package org.sablecc.sablecc.lexer;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.PushbackReader;
import org.sablecc.sablecc.lexer.LexerException;
import org.sablecc.sablecc.node.EOF;
import org.sablecc.sablecc.node.TAbstract;
import org.sablecc.sablecc.node.TArrow;
import org.sablecc.sablecc.node.TBar;
import org.sablecc.sablecc.node.TBlank;
import org.sablecc.sablecc.node.TChar;
import org.sablecc.sablecc.node.TColon;
import org.sablecc.sablecc.node.TComma;
import org.sablecc.sablecc.node.TComment;
import org.sablecc.sablecc.node.TDDot;
import org.sablecc.sablecc.node.TDecChar;
import org.sablecc.sablecc.node.TDot;
import org.sablecc.sablecc.node.TEqual;
import org.sablecc.sablecc.node.THelpers;
import org.sablecc.sablecc.node.THexChar;
import org.sablecc.sablecc.node.TId;
import org.sablecc.sablecc.node.TIgnored;
import org.sablecc.sablecc.node.TLBkt;
import org.sablecc.sablecc.node.TLBrace;
import org.sablecc.sablecc.node.TLPar;
import org.sablecc.sablecc.node.TMinus;
import org.sablecc.sablecc.node.TNew;
import org.sablecc.sablecc.node.TNull;
import org.sablecc.sablecc.node.TPackage;
import org.sablecc.sablecc.node.TPkgId;
import org.sablecc.sablecc.node.TPlus;
import org.sablecc.sablecc.node.TProductionSpecifier;
import org.sablecc.sablecc.node.TProductions;
import org.sablecc.sablecc.node.TQMark;
import org.sablecc.sablecc.node.TRBkt;
import org.sablecc.sablecc.node.TRBrace;
import org.sablecc.sablecc.node.TRPar;
import org.sablecc.sablecc.node.TSemicolon;
import org.sablecc.sablecc.node.TSlash;
import org.sablecc.sablecc.node.TStar;
import org.sablecc.sablecc.node.TStates;
import org.sablecc.sablecc.node.TString;
import org.sablecc.sablecc.node.TSyntax;
import org.sablecc.sablecc.node.TTokenSpecifier;
import org.sablecc.sablecc.node.TTokens;
import org.sablecc.sablecc.node.TTree;
import org.sablecc.sablecc.node.Token;

public class Lexer {
    protected Token token;
    protected State state = State.NORMAL;
    private PushbackReader in;
    private int line;
    private int pos;
    private boolean cr;
    private boolean eof;
    private final StringBuffer text = new StringBuffer();
    private static int[][][][] gotoTable;
    private static int[][] accept;

    protected void filter() throws LexerException, IOException {
    }

    public Lexer(PushbackReader pushbackReader) {
        this.in = pushbackReader;
    }

    public Token peek() throws LexerException, IOException {
        while (this.token == null) {
            this.token = this.getToken();
            this.filter();
        }
        return this.token;
    }

    public Token next() throws LexerException, IOException {
        while (this.token == null) {
            this.token = this.getToken();
            this.filter();
        }
        Token token = this.token;
        this.token = null;
        return token;
    }

    protected Token getToken() throws IOException, LexerException {
        int n = 0;
        int n2 = this.pos;
        int n3 = this.line;
        int n4 = -1;
        int n5 = -1;
        int n6 = -1;
        int n7 = -1;
        int n8 = -1;
        int[][][] nArray = gotoTable[this.state.id()];
        int[] nArray2 = accept[this.state.id()];
        this.text.setLength(0);
        while (true) {
            int n9;
            if ((n9 = this.getChar()) != -1) {
                switch (n9) {
                    case 10: {
                        if (this.cr) {
                            this.cr = false;
                            break;
                        }
                        ++this.line;
                        this.pos = 0;
                        break;
                    }
                    case 13: {
                        ++this.line;
                        this.pos = 0;
                        this.cr = true;
                        break;
                    }
                    default: {
                        ++this.pos;
                        this.cr = false;
                    }
                }
                this.text.append((char)n9);
                block57: do {
                    int n10 = n < -1 ? -2 - n : n;
                    n = -1;
                    int[][] nArray3 = nArray[n10];
                    int n11 = 0;
                    int n12 = nArray3.length - 1;
                    while (n11 <= n12) {
                        int n13 = (n11 + n12) / 2;
                        int[] nArray4 = nArray3[n13];
                        if (n9 < nArray4[0]) {
                            n12 = n13 - 1;
                            continue;
                        }
                        if (n9 > nArray4[1]) {
                            n11 = n13 + 1;
                            continue;
                        }
                        n = nArray4[2];
                        continue block57;
                    }
                } while (n < -1);
            } else {
                n = -1;
            }
            if (n >= 0) {
                if (nArray2[n] == -1) continue;
                n4 = n;
                n5 = nArray2[n];
                n6 = this.text.length();
                n7 = this.pos;
                n8 = this.line;
                continue;
            }
            if (n4 == -1) break;
            switch (n5) {
                case 0: {
                    Token token = this.new0(this.getText(n6), n3 + 1, n2 + 1);
                    this.pushBack(n6);
                    this.pos = n7;
                    this.line = n8;
                    switch (this.state.id()) {
                        case 1: {
                            this.state = State.PACKAGE;
                        }
                    }
                    return token;
                }
                case 1: {
                    Token token = this.new1(n3 + 1, n2 + 1);
                    this.pushBack(n6);
                    this.pos = n7;
                    this.line = n8;
                    switch (this.state.id()) {
                        case 0: {
                            this.state = State.PACKAGE;
                        }
                    }
                    return token;
                }
                case 2: {
                    Token token = this.new2(n3 + 1, n2 + 1);
                    this.pushBack(n6);
                    this.pos = n7;
                    this.line = n8;
                    return token;
                }
                case 3: {
                    Token token = this.new3(n3 + 1, n2 + 1);
                    this.pushBack(n6);
                    this.pos = n7;
                    this.line = n8;
                    return token;
                }
                case 4: {
                    Token token = this.new4(n3 + 1, n2 + 1);
                    this.pushBack(n6);
                    this.pos = n7;
                    this.line = n8;
                    return token;
                }
                case 5: {
                    Token token = this.new5(n3 + 1, n2 + 1);
                    this.pushBack(n6);
                    this.pos = n7;
                    this.line = n8;
                    return token;
                }
                case 6: {
                    Token token = this.new6(n3 + 1, n2 + 1);
                    this.pushBack(n6);
                    this.pos = n7;
                    this.line = n8;
                    return token;
                }
                case 7: {
                    Token token = this.new7(n3 + 1, n2 + 1);
                    this.pushBack(n6);
                    this.pos = n7;
                    this.line = n8;
                    return token;
                }
                case 8: {
                    Token token = this.new8(n3 + 1, n2 + 1);
                    this.pushBack(n6);
                    this.pos = n7;
                    this.line = n8;
                    return token;
                }
                case 9: {
                    Token token = this.new9(n3 + 1, n2 + 1);
                    this.pushBack(n6);
                    this.pos = n7;
                    this.line = n8;
                    return token;
                }
                case 10: {
                    Token token = this.new10(n3 + 1, n2 + 1);
                    this.pushBack(n6);
                    this.pos = n7;
                    this.line = n8;
                    return token;
                }
                case 11: {
                    Token token = this.new11(n3 + 1, n2 + 1);
                    this.pushBack(n6);
                    this.pos = n7;
                    this.line = n8;
                    return token;
                }
                case 12: {
                    Token token = this.new12(n3 + 1, n2 + 1);
                    this.pushBack(n6);
                    this.pos = n7;
                    this.line = n8;
                    return token;
                }
                case 13: {
                    Token token = this.new13(n3 + 1, n2 + 1);
                    this.pushBack(n6);
                    this.pos = n7;
                    this.line = n8;
                    return token;
                }
                case 14: {
                    Token token = this.new14(n3 + 1, n2 + 1);
                    this.pushBack(n6);
                    this.pos = n7;
                    this.line = n8;
                    return token;
                }
                case 15: {
                    Token token = this.new15(n3 + 1, n2 + 1);
                    this.pushBack(n6);
                    this.pos = n7;
                    this.line = n8;
                    return token;
                }
                case 16: {
                    Token token = this.new16(n3 + 1, n2 + 1);
                    this.pushBack(n6);
                    this.pos = n7;
                    this.line = n8;
                    switch (this.state.id()) {
                        case 0: {
                            this.state = State.NORMAL;
                            break;
                        }
                        case 1: {
                            this.state = State.NORMAL;
                        }
                    }
                    return token;
                }
                case 17: {
                    Token token = this.new17(n3 + 1, n2 + 1);
                    this.pushBack(n6);
                    this.pos = n7;
                    this.line = n8;
                    return token;
                }
                case 18: {
                    Token token = this.new18(n3 + 1, n2 + 1);
                    this.pushBack(n6);
                    this.pos = n7;
                    this.line = n8;
                    return token;
                }
                case 19: {
                    Token token = this.new19(n3 + 1, n2 + 1);
                    this.pushBack(n6);
                    this.pos = n7;
                    this.line = n8;
                    return token;
                }
                case 20: {
                    Token token = this.new20(n3 + 1, n2 + 1);
                    this.pushBack(n6);
                    this.pos = n7;
                    this.line = n8;
                    return token;
                }
                case 21: {
                    Token token = this.new21(n3 + 1, n2 + 1);
                    this.pushBack(n6);
                    this.pos = n7;
                    this.line = n8;
                    return token;
                }
                case 22: {
                    Token token = this.new22(n3 + 1, n2 + 1);
                    this.pushBack(n6);
                    this.pos = n7;
                    this.line = n8;
                    return token;
                }
                case 23: {
                    Token token = this.new23(n3 + 1, n2 + 1);
                    this.pushBack(n6);
                    this.pos = n7;
                    this.line = n8;
                    return token;
                }
                case 24: {
                    Token token = this.new24(n3 + 1, n2 + 1);
                    this.pushBack(n6);
                    this.pos = n7;
                    this.line = n8;
                    return token;
                }
                case 25: {
                    Token token = this.new25(n3 + 1, n2 + 1);
                    this.pushBack(n6);
                    this.pos = n7;
                    this.line = n8;
                    return token;
                }
                case 26: {
                    Token token = this.new26(n3 + 1, n2 + 1);
                    this.pushBack(n6);
                    this.pos = n7;
                    this.line = n8;
                    return token;
                }
                case 27: {
                    Token token = this.new27(n3 + 1, n2 + 1);
                    this.pushBack(n6);
                    this.pos = n7;
                    this.line = n8;
                    return token;
                }
                case 28: {
                    Token token = this.new28(n3 + 1, n2 + 1);
                    this.pushBack(n6);
                    this.pos = n7;
                    this.line = n8;
                    return token;
                }
                case 29: {
                    Token token = this.new29(n3 + 1, n2 + 1);
                    this.pushBack(n6);
                    this.pos = n7;
                    this.line = n8;
                    return token;
                }
                case 30: {
                    Token token = this.new30(n3 + 1, n2 + 1);
                    this.pushBack(n6);
                    this.pos = n7;
                    this.line = n8;
                    return token;
                }
                case 31: {
                    Token token = this.new31(n3 + 1, n2 + 1);
                    this.pushBack(n6);
                    this.pos = n7;
                    this.line = n8;
                    return token;
                }
                case 32: {
                    Token token = this.new32(n3 + 1, n2 + 1);
                    this.pushBack(n6);
                    this.pos = n7;
                    this.line = n8;
                    return token;
                }
                case 33: {
                    Token token = this.new33(this.getText(n6), n3 + 1, n2 + 1);
                    this.pushBack(n6);
                    this.pos = n7;
                    this.line = n8;
                    return token;
                }
                case 34: {
                    Token token = this.new34(this.getText(n6), n3 + 1, n2 + 1);
                    this.pushBack(n6);
                    this.pos = n7;
                    this.line = n8;
                    return token;
                }
                case 35: {
                    Token token = this.new35(this.getText(n6), n3 + 1, n2 + 1);
                    this.pushBack(n6);
                    this.pos = n7;
                    this.line = n8;
                    return token;
                }
                case 36: {
                    Token token = this.new36(this.getText(n6), n3 + 1, n2 + 1);
                    this.pushBack(n6);
                    this.pos = n7;
                    this.line = n8;
                    return token;
                }
                case 37: {
                    Token token = this.new37(this.getText(n6), n3 + 1, n2 + 1);
                    this.pushBack(n6);
                    this.pos = n7;
                    this.line = n8;
                    return token;
                }
                case 38: {
                    Token token = this.new38(this.getText(n6), n3 + 1, n2 + 1);
                    this.pushBack(n6);
                    this.pos = n7;
                    this.line = n8;
                    return token;
                }
                case 39: {
                    Token token = this.new39(this.getText(n6), n3 + 1, n2 + 1);
                    this.pushBack(n6);
                    this.pos = n7;
                    this.line = n8;
                    return token;
                }
            }
        }
        if (this.text.length() > 0) {
            throw new LexerException("[" + (n3 + 1) + "," + (n2 + 1) + "]" + " Unknown token: " + this.text);
        }
        EOF eOF = new EOF(n3 + 1, n2 + 1);
        return eOF;
    }

    Token new0(String string, int n, int n2) {
        return new TPkgId(string, n, n2);
    }

    Token new1(int n, int n2) {
        return new TPackage(n, n2);
    }

    Token new2(int n, int n2) {
        return new TStates(n, n2);
    }

    Token new3(int n, int n2) {
        return new THelpers(n, n2);
    }

    Token new4(int n, int n2) {
        return new TTokens(n, n2);
    }

    Token new5(int n, int n2) {
        return new TIgnored(n, n2);
    }

    Token new6(int n, int n2) {
        return new TProductions(n, n2);
    }

    Token new7(int n, int n2) {
        return new TAbstract(n, n2);
    }

    Token new8(int n, int n2) {
        return new TSyntax(n, n2);
    }

    Token new9(int n, int n2) {
        return new TTree(n, n2);
    }

    Token new10(int n, int n2) {
        return new TNew(n, n2);
    }

    Token new11(int n, int n2) {
        return new TNull(n, n2);
    }

    Token new12(int n, int n2) {
        return new TTokenSpecifier(n, n2);
    }

    Token new13(int n, int n2) {
        return new TProductionSpecifier(n, n2);
    }

    Token new14(int n, int n2) {
        return new TDot(n, n2);
    }

    Token new15(int n, int n2) {
        return new TDDot(n, n2);
    }

    Token new16(int n, int n2) {
        return new TSemicolon(n, n2);
    }

    Token new17(int n, int n2) {
        return new TEqual(n, n2);
    }

    Token new18(int n, int n2) {
        return new TLBkt(n, n2);
    }

    Token new19(int n, int n2) {
        return new TRBkt(n, n2);
    }

    Token new20(int n, int n2) {
        return new TLPar(n, n2);
    }

    Token new21(int n, int n2) {
        return new TRPar(n, n2);
    }

    Token new22(int n, int n2) {
        return new TLBrace(n, n2);
    }

    Token new23(int n, int n2) {
        return new TRBrace(n, n2);
    }

    Token new24(int n, int n2) {
        return new TPlus(n, n2);
    }

    Token new25(int n, int n2) {
        return new TMinus(n, n2);
    }

    Token new26(int n, int n2) {
        return new TQMark(n, n2);
    }

    Token new27(int n, int n2) {
        return new TStar(n, n2);
    }

    Token new28(int n, int n2) {
        return new TBar(n, n2);
    }

    Token new29(int n, int n2) {
        return new TComma(n, n2);
    }

    Token new30(int n, int n2) {
        return new TSlash(n, n2);
    }

    Token new31(int n, int n2) {
        return new TArrow(n, n2);
    }

    Token new32(int n, int n2) {
        return new TColon(n, n2);
    }

    Token new33(String string, int n, int n2) {
        return new TId(string, n, n2);
    }

    Token new34(String string, int n, int n2) {
        return new TChar(string, n, n2);
    }

    Token new35(String string, int n, int n2) {
        return new TDecChar(string, n, n2);
    }

    Token new36(String string, int n, int n2) {
        return new THexChar(string, n, n2);
    }

    Token new37(String string, int n, int n2) {
        return new TString(string, n, n2);
    }

    Token new38(String string, int n, int n2) {
        return new TBlank(string, n, n2);
    }

    Token new39(String string, int n, int n2) {
        return new TComment(string, n, n2);
    }

    private int getChar() throws IOException {
        if (this.eof) {
            return -1;
        }
        int n = this.in.read();
        if (n == -1) {
            this.eof = true;
        }
        return n;
    }

    private void pushBack(int n) throws IOException {
        int n2 = this.text.length();
        for (int i = n2 - 1; i >= n; --i) {
            this.eof = false;
            this.in.unread(this.text.charAt(i));
        }
    }

    protected void unread(Token token) throws IOException {
        String string = token.getText();
        int n = string.length();
        for (int i = n - 1; i >= 0; --i) {
            this.eof = false;
            this.in.unread(string.charAt(i));
        }
        this.pos = token.getPos() - 1;
        this.line = token.getLine() - 1;
    }

    private String getText(int n) {
        StringBuffer stringBuffer = new StringBuffer(n);
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(this.text.charAt(i));
        }
        return stringBuffer.toString();
    }

    static {
        try {
            int n;
            int n2;
            DataInputStream dataInputStream = new DataInputStream(new BufferedInputStream(Lexer.class.getResourceAsStream("lexer.dat")));
            int n3 = dataInputStream.readInt();
            gotoTable = new int[n3][][][];
            for (n2 = 0; n2 < gotoTable.length; ++n2) {
                n3 = dataInputStream.readInt();
                Lexer.gotoTable[n2] = new int[n3][][];
                for (n = 0; n < gotoTable[n2].length; ++n) {
                    n3 = dataInputStream.readInt();
                    Lexer.gotoTable[n2][n] = new int[n3][3];
                    for (int i = 0; i < gotoTable[n2][n].length; ++i) {
                        for (int j = 0; j < 3; ++j) {
                            Lexer.gotoTable[n2][n][i][j] = dataInputStream.readInt();
                        }
                    }
                }
            }
            n3 = dataInputStream.readInt();
            accept = new int[n3][];
            for (n2 = 0; n2 < accept.length; ++n2) {
                n3 = dataInputStream.readInt();
                Lexer.accept[n2] = new int[n3];
                for (n = 0; n < accept[n2].length; ++n) {
                    Lexer.accept[n2][n] = dataInputStream.readInt();
                }
            }
            dataInputStream.close();
        }
        catch (Exception exception) {
            throw new RuntimeException("The file \"lexer.dat\" is either missing or corrupted.");
        }
    }

    public static class State {
        public static final State NORMAL = new State(0);
        public static final State PACKAGE = new State(1);
        private int id;

        private State(int n) {
            this.id = n;
        }

        public int id() {
            return this.id;
        }
    }
}

