/*
 * Decompiled with CFR 0.152.
 */
package info.monitorenter.gui.chart.io;

import info.monitorenter.gui.chart.ITrace2D;
import info.monitorenter.gui.chart.ITracePoint2D;

public abstract class ADataCollector
implements Runnable {
    private boolean m_isRunning = false;
    private long m_latency = 400L;
    private boolean m_stop = true;
    private Thread m_thread;
    private ITrace2D m_trace;

    public ADataCollector(ITrace2D trace, long latency) {
        this.m_latency = latency;
        this.m_trace = trace;
    }

    public abstract ITracePoint2D collectData();

    protected void finalize() throws Throwable {
        super.finalize();
        this.stop();
    }

    public long getLatency() {
        return this.m_latency;
    }

    public ITrace2D getTrace() {
        return this.m_trace;
    }

    public boolean isRunning() {
        return this.m_isRunning;
    }

    public void run() {
        if (Thread.currentThread() != this.m_thread) {
            throw new IllegalStateException("You cannot start an own thread for data collectors. Use collector.start()!");
        }
        this.m_isRunning = true;
        this.m_stop = false;
        while (!this.m_stop) {
            long lasttime = System.currentTimeMillis();
            ITracePoint2D point = this.collectData();
            this.m_trace.addPoint(point);
            try {
                Thread.sleep(Math.max(this.m_latency - System.currentTimeMillis() + lasttime, 0L));
            }
            catch (InterruptedException e) {
                this.stop();
            }
            if (!Thread.interrupted()) continue;
            this.stop();
        }
        this.m_isRunning = false;
    }

    public void setLatency(long latency) {
        this.m_latency = latency;
    }

    public void start() {
        if (this.m_stop) {
            this.m_thread = new Thread(this);
            this.m_thread.start();
        }
    }

    public void stop() {
        this.m_stop = true;
    }
}

