/* ScummVM - Graphic Adventure Engine
 *
 * ScummVM is the legal property of its developers, whose names
 * are too numerous to list here. Please refer to the COPYRIGHT
 * file distributed with this source distribution.
 *
 * Additional copyright for this file:
 * Copyright (C) 1999-2000 Revolution Software Ltd.
 * This code is based on source code created by Revolution Software,
 * used with permission.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#include "common/memstream.h"
#include "common/random.h"

#include "engines/icb/p4_generic.h"
#include "engines/icb/set.h"
#include "engines/icb/global_objects.h"
#include "engines/icb/global_switches.h"
#include "engines/icb/surface_manager.h"
#include "engines/icb/shake.h"
#include "engines/icb/res_man.h"
#include "engines/icb/mission.h"
#include "engines/icb/common/px_capri_maths.h"
#include "engines/icb/common/pc_props.h"
#include "engines/icb/sound/direct_sound.h"
#include "engines/icb/sound/fx_manager.h"
#include "engines/icb/icb.h"
#include "engines/icb/jpeg_decode.h"
#include "engines/icb/direct_input.h"

namespace ICB {

#define RAND_16BIT (g_icb->getRandomSource()->getRandomNumber(32767) + g_icb->getRandomSource()->getRandomNumber(32767) + g_icb->getRandomSource()->getRandomNumber(32767))
#define RAND_32BIT ((RAND_16BIT << 16) | (RAND_16BIT))
#define RAND_BIT(bit) ((rands[(bit) >> 5]) & (1 << ((bit)&31)))

// Need tempory access to the zbuffer
extern char *pZ;

// 640*480 global rect - SCREEN_WIDTH*SCREEN_DEPTH !!!!!!!
LRECT full_rect; // used for blting from safe to working buffer, etc

//-----------  Bookyakasha Rydem and Sparkles !!!!!
uint32 sparkle_bmp[6 * 32 * 32] = {
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x05050505, 0x3D3D3D3D, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x0E0E0E0E, 0x79797979, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x0C0C0C0C, 0xD2D2D2D2, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x3C3C3C3C, 0x77777777, 0xEDEDEDED, 0xFDFDFDFD, 0xD4D4D4D4, 0x99999999, 0x4B4B4B4B, 0x1D1D1D1D, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x1F1F1F1F, 0xC2C2C2C2, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x0F0F0F0F, 0x7D7D7D7D,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x06060606, 0x40404040, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x0F0F0F0F, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x3D3D3D3D, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x5E5E5E5E, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x91919191, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xAEAEAEAE, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xC9C9C9C9, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xE9E9E9E9,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x85858585, 0xDDDDDDDD, 0x7F7F7F7F, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x0C0C0C0C, 0x1C1C1C1C,
	0x36363636, 0x4F4F4F4F, 0x8A8A8A8A, 0xB2B2B2B2, 0xD1D1D1D1, 0xEFEFEFEF, 0xFDFDFDFD, 0xF9F9F9F9, 0xF9F9F9F9, 0xF0F0F0F0, 0xDADADADA, 0xC4C4C4C4, 0xA8A8A8A8, 0x82828282,
	0x54545454, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x8B8B8B8B, 0xF5F5F5F5, 0x90909090, 0x36363636,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0xF4F4F4F4, 0x06060606, 0x03030303, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xCCCCCCCC, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xAFAFAFAF, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x95959595,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x66666666, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x41414141, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x03030303, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x0A0A0A0A, 0x02020202, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x0A0A0A0A, 0x30303030, 0x02020202, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x37373737, 0x3C3C3C3C, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x55555555, 0x18181818, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x3A3A3A3A, 0x64646464, 0x04040404, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x9B9B9B9B, 0x4F4F4F4F, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x1B1B1B1B, 0xD3D3D3D3, 0x03030303,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x92929292, 0xA0A0A0A0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x27272727, 0x14141414, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x02020202, 0x11111111, 0xF3F3F3F3, 0x3A3A3A3A, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x1C1C1C1C, 0x53535353, 0x6B6B6B6B, 0x4A4A4A4A,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x16161616, 0x92929292, 0xE9E9E9E9, 0x08080808, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x29292929, 0x8D8D8D8D, 0xD1D1D1D1, 0x9B9B9B9B, 0x2A2A2A2A, 0x19191919, 0x16161616, 0x03030303, 0x00000000, 0x58585858, 0xE4E4E4E4, 0xA3A3A3A3,
	0x16161616, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x20202020, 0x8F8F8F8F, 0xF2F2F2F2, 0xDDDDDDDD, 0x98989898, 0x62626262,
	0x59595959, 0xCCCCCCCC, 0xFCFCFCFC, 0x7A7A7A7A, 0x0C0C0C0C, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x2C2C2C2C, 0xA4A4A4A4, 0xF3F3F3F3, 0xF4F4F4F4, 0xD8D8D8D8, 0xF2F2F2F2, 0xF1F1F1F1, 0x7E7E7E7E, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x02020202, 0x12121212, 0x40404040, 0xAEAEAEAE, 0xF9F9F9F9, 0xFDFDFDFD, 0xFDFDFDFD, 0xB5B5B5B5, 0x55555555, 0x1A1A1A1A,
	0x03030303, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x43434343, 0xDFDFDFDF, 0xF4F4F4F4,
	0xD8D8D8D8, 0xF4F4F4F4, 0xF7F7F7F7, 0xACACACAC, 0x38383838, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x4E4E4E4E, 0xF8F8F8F8, 0xD3D3D3D3, 0x3D3D3D3D, 0x58585858, 0x93939393, 0xD2D2D2D2, 0xF3F3F3F3, 0x99999999, 0x26262626, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x0E0E0E0E, 0x8E8E8E8E, 0xF6F6F6F6, 0x6A6A6A6A, 0x00000000, 0x00000000, 0x14141414, 0x17171717, 0x25252525, 0x88888888,
	0xC5C5C5C5, 0x9A9A9A9A, 0x3F3F3F3F, 0x07070707, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xD4D4D4D4, 0xAFAFAFAF, 0x26262626, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x36363636, 0x89898989, 0x67676767, 0x1F1F1F1F, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x18181818, 0xFBFBFBFB,
	0x35353535, 0x03030303, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x1B1B1B1B, 0x2A2A2A2A, 0x52525252, 0x34343434,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x89898989, 0xB4B4B4B4, 0x03030303, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x02020202, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x02020202, 0xDEDEDEDE, 0x31313131, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x3B3B3B3B, 0xABABABAB, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x01010101, 0x76767676,
	0x3B3B3B3B, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x15151515, 0x76767676, 0x03030303, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x46464646, 0x35353535, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x3D3D3D3D, 0x08080808, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x21212121, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x04040404, 0x12121212, 0x07070707, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x0F0F0F0F, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x18181818, 0x30303030, 0x2C2C2C2C, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x10101010, 0x53535353, 0x0E0E0E0E,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x07070707, 0x44444444,
	0x38383838, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x07070707,
	0x42424242, 0x70707070, 0x2D2D2D2D, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x23232323, 0x63636363, 0x57575757, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x2C2C2C2C, 0x73737373, 0x41414141, 0x07070707, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x10101010, 0xA6A6A6A6, 0x6E6E6E6E, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x06060606, 0x4F4F4F4F, 0x9B9B9B9B, 0x41414141, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x1A1A1A1A,
	0xD1D1D1D1, 0x75757575, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x5C5C5C5C, 0xD8D8D8D8, 0x80808080, 0x10101010, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x20202020, 0xEBEBEBEB, 0x88888888, 0x25252525, 0x00000000, 0x00000000, 0x00000000, 0x0C0C0C0C, 0x43434343, 0xB5B5B5B5,
	0x62626262, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x56565656, 0xFFFFFFFF, 0xAAAAAAAA, 0x42424242, 0x00000000,
	0x46464646, 0x8A8A8A8A, 0xEDEDEDED, 0xA4A4A4A4, 0x0C0C0C0C, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x09090909,
	0x7E7E7E7E, 0xFBFBFBFB, 0xB6B6B6B6, 0x7C7C7C7C, 0xC1C1C1C1, 0xF0F0F0F0, 0xBEBEBEBE, 0x2D2D2D2D, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x0C0C0C0C, 0x8E8E8E8E, 0xFAFAFAFA, 0xE7E7E7E7, 0xF4F4F4F4, 0xE7E7E7E7, 0x37373737, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x68686868, 0xE7E7E7E7, 0xFEFEFEFE, 0xFDFDFDFD, 0xA7A7A7A7,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x18181818, 0xA0A0A0A0,
	0xFEFEFEFE, 0xE9E9E9E9, 0xF1F1F1F1, 0xCCCCCCCC, 0x37373737, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x0D0D0D0D, 0x88888888, 0xFCFCFCFC, 0xC4C4C4C4, 0x54545454, 0x94949494, 0xF4F4F4F4, 0xC0C0C0C0, 0x1E1E1E1E, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x4B4B4B4B, 0xD4D4D4D4, 0xA5A5A5A5, 0x36363636, 0x00000000, 0x1B1B1B1B, 0x77777777, 0xF1F1F1F1, 0xA8A8A8A8,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x09090909, 0x73737373, 0xE9E9E9E9, 0x97979797, 0x30303030, 0x07070707, 0x00000000,
	0x00000000, 0x1B1B1B1B, 0x4E4E4E4E, 0xE5E5E5E5, 0x75757575, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x4B4B4B4B, 0xC3C3C3C3, 0x8C8C8C8C,
	0x1F1F1F1F, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x08080808, 0x22222222, 0xD6D6D6D6, 0x5F5F5F5F, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x2D2D2D2D, 0x80808080, 0x48484848, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x21212121, 0xB4B4B4B4,
	0x54545454, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x30303030, 0x83838383, 0x69696969, 0x0E0E0E0E, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x1C1C1C1C, 0xA0A0A0A0, 0x3A3A3A3A, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x0C0C0C0C, 0x78787878, 0x40404040, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x19191919, 0x86868686, 0x15151515, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x08080808, 0x58585858, 0x2C2C2C2C, 0x0B0B0B0B, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x25252525,
	0x58585858, 0x1C1C1C1C, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x1D1D1D1D,
	0x28282828, 0x08080808, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x06060606, 0x25252525, 0x08080808, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x0B0B0B0B, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x15151515, 0x0D0D0D0D, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x20202020, 0x2E2E2E2E, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x0C0C0C0C, 0x58585858, 0x03030303, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x7D7D7D7D, 0x31313131, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x58585858, 0x96969696, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xC9C9C9C9, 0x31313131, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x77777777, 0xACACACAC, 0x04040404, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x1C1C1C1C, 0xF3F3F3F3, 0x40404040, 0x03030303, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x1F1F1F1F, 0x5D5D5D5D, 0x12121212, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x0F0F0F0F, 0xD5D5D5D5, 0xAEAEAEAE, 0x1F1F1F1F, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x50505050, 0x81818181, 0x81818181, 0x2C2C2C2C, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x0E0E0E0E, 0x8E8E8E8E,
	0xF5F5F5F5, 0x60606060, 0x02020202, 0x0B0B0B0B, 0x18181818, 0x07070707, 0x27272727, 0xA2A2A2A2, 0xD2D2D2D2, 0x99999999, 0x33333333, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x45454545, 0xF5F5F5F5, 0xB9B9B9B9, 0x71717171, 0x76767676, 0x94949494, 0xD7D7D7D7, 0xFBFBFBFB, 0x9E9E9E9E, 0x1F1F1F1F, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x43434343, 0xDBDBDBDB, 0xF7F7F7F7, 0xE8E8E8E8, 0xF6F6F6F6, 0xF4F4F4F4, 0xA5A5A5A5,
	0x22222222, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x01010101, 0x13131313, 0x4E4E4E4E, 0xC3C3C3C3, 0xFAFAFAFA, 0xFDFDFDFD,
	0xFCFCFCFC, 0xD9D9D9D9, 0x60606060, 0x1B1B1B1B, 0x04040404, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x20202020, 0xAAAAAAAA,
	0xF8F8F8F8, 0xF8F8F8F8, 0xE4E4E4E4, 0xEAEAEAEA, 0xEBEBEBEB, 0x67676767, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x2A2A2A2A, 0xA7A7A7A7, 0xFDFDFDFD, 0xD2D2D2D2, 0x9B9B9B9B, 0x74747474, 0x38383838, 0xA7A7A7A7, 0xFBFBFBFB, 0x5F5F5F5F, 0x05050505, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x38383838, 0x9A9A9A9A, 0xDFDFDFDF, 0x95959595, 0x20202020, 0x13131313, 0x18181818, 0x00000000, 0x00000000, 0x3F3F3F3F, 0xE9E9E9E9, 0xA8A8A8A8,
	0x14141414, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x15151515, 0x59595959, 0x71717171, 0x45454545, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x14141414, 0x92929292, 0xECECECEC, 0x19191919, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x36363636, 0x2F2F2F2F, 0x0F0F0F0F, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x02020202, 0x25252525, 0xE9E9E9E9, 0x35353535, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x02020202, 0x83838383, 0x9D9D9D9D, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x18181818, 0xCACACACA, 0x07070707, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x90909090, 0x5A5A5A5A, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x2C2C2C2C, 0x96969696, 0x04040404, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x7B7B7B7B, 0x1D1D1D1D, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x43434343, 0x3B3B3B3B, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x04040404, 0x39393939, 0x03030303, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x02020202, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x42424242, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x79797979,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x8B8B8B8B, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xAEAEAEAE, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xC9C9C9C9, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0xE2E2E2E2, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xFAFAFAFA, 0x0D0D0D0D, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x13131313, 0xFDFDFDFD, 0x1F1F1F1F, 0x02020202, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x03030303, 0x4A4A4A4A, 0xFAFAFAFA,
	0x4B4B4B4B, 0x04040404, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x09090909, 0x63636363, 0xF9F9F9F9, 0x70707070, 0x08080808, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x10101010, 0xA4A4A4A4, 0xFDFDFDFD, 0xB0B0B0B0, 0x06060606, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x04040404, 0x2F2F2F2F, 0x4E4E4E4E, 0x66666666, 0x7F7F7F7F, 0xC5C5C5C5, 0xFDFDFDFD, 0xD0D0D0D0, 0x7F7F7F7F,
	0x66666666, 0x4E4E4E4E, 0x2F2F2F2F, 0x04040404, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x32323232, 0x52525252, 0x6D6D6D6D, 0x9D9D9D9D, 0xC6C6C6C6, 0xDFDFDFDF, 0xEBEBEBEB, 0xF9F9F9F9, 0xFDFDFDFD, 0xFCFCFCFC, 0xFAFAFAFA,
	0xFCFCFCFC, 0xFDFDFDFD, 0xFDFDFDFD, 0xFDFDFDFD, 0xFDFDFDFD, 0xFBFBFBFB, 0xF5F5F5F5, 0xECECECEC, 0xD9D9D9D9, 0xC0C0C0C0, 0xAFAFAFAF, 0x9C9C9C9C, 0x78787878, 0x3B3B3B3B,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x04040404,
	0x2F2F2F2F, 0x4E4E4E4E, 0x66666666, 0x7F7F7F7F, 0xC5C5C5C5, 0xFDFDFDFD, 0xBDBDBDBD, 0x7F7F7F7F, 0x66666666, 0x4E4E4E4E, 0x2F2F2F2F, 0x04040404, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x01010101, 0x01010101, 0x91919191, 0xFDFDFDFD, 0xA0A0A0A0, 0x01010101, 0x01010101, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x66666666, 0xFDFDFDFD,
	0x7B7B7B7B, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x48484848, 0xFDFDFDFD, 0x57575757, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x1D1D1D1D, 0xFDFDFDFD, 0x2C2C2C2C, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xFDFDFDFD, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0xF2F2F2F2, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xDADADADA, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xA7A7A7A7, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x8A8A8A8A,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x6B6B6B6B, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x3B3B3B3B, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
	0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000};

void ShakeRects(LRECT &sourceRect, LRECT &destRect) {
	int32 xShift = GetShakeX();
	int32 yShift = GetShakeY();

	if (yShift > 0) {
		destRect.top += yShift;
		sourceRect.bottom -= yShift;
	} else {
		destRect.bottom += yShift;
		sourceRect.top -= yShift;
	}

	if (xShift > 0) {
		destRect.left += xShift;
		sourceRect.right -= xShift;
	} else {
		destRect.right += xShift;
		sourceRect.left -= xShift;
	}
}

int32 ShakePropRects(LRECT &rect, LRECT &source) {
	int32 xShift = GetShakeX();
	int32 yShift = GetShakeY();

	rect.top += yShift;
	rect.bottom += yShift;
	rect.left += xShift;
	rect.right += xShift;

	int32 check = 0;
	if (rect.top < 0) {
		source.top -= rect.top;
		rect.top = 0;
		++check;
	}
	if (rect.left < 0) {
		source.left -= rect.left;
		rect.left = 0;
		++check;
	}
	if (rect.bottom > SCREEN_DEPTH) {
		source.bottom -= (rect.bottom - SCREEN_DEPTH);
		rect.bottom = SCREEN_DEPTH;
		++check;
	}
	if (rect.right > SCREEN_WIDTH) {
		source.right -= (rect.right - SCREEN_WIDTH);
		rect.right = SCREEN_WIDTH;
		++check;
	}

	if (check == 0)
		return 1;

	if ((rect.right - rect.left) <= 0)
		return 0;

	if ((rect.bottom - rect.top) <= 0)
		return 0;

	return 1;
}

_set::_set() {
	// set object constructor
	// setup all the data structures for a single set
	set_name[0] = '\0';
	set_cluster[0] = '\0';
	m_setOk = 0;
	m_TotalPropSurfaces = 0;
	m_props = nullptr;
	memset(m_propSurfaces, 0x00, sizeof(int32) * MAX_PROP_STATES);
	InitWeather(WEATHER_NONE, 0, 0, 0, 0, 0);
}

_set::~_set() { Reset(); }

void _set::ReInit() {
	// Free all the prop surface that have been created.
	if (m_setOk) {
		// Remove all the old surface
		for (int32 s = 0; s < m_TotalPropSurfaces; s++) {
			if (m_propSurfaces[s])
				surface_manager->Kill_surface(m_propSurfaces[s]);
		}
		m_TotalPropSurfaces = 0;

		surface_manager->Kill_surface(bg_buffer_id);
	}

	// Reload the backdrop and props
	Init_base_bitmap_buffers();
}

bool8 _set::Init(const char *camera_name, const char *clustered_camera_name) {
	// Check if this camera is already the current one
	if (strcmp(clustered_camera_name, set_cluster) == 0)
		return FALSE8;

	// Get rid of all the graphics for the last set
	Reset();

	// Create the new set cluster path
	Common::sprintf_s(set_cluster, SET_PATH, MS->Fetch_h_session_name(), clustered_camera_name);
	set_cluster_hash = HashString(set_cluster);

	// And the name of the set file within the cluster
	pxString p_rcvf = "p.rcvf";
	uint32 p_rcvf_hash = HashString(p_rcvf);

	// Keep the non clustered name of the camera ( not really needed but nicer for error messages)
	Common::strcpy_s(set_name, camera_name);

	// Load this camera
	m_currentCamera = (_pcSetHeader *)rs_bg->Res_open(p_rcvf, p_rcvf_hash, set_cluster, set_cluster_hash);
	if (FROM_LE_32(m_currentCamera->id) != PCSETFILE_ID_ICB && FROM_LE_32(m_currentCamera->id) != PCSETFILE_ID_ELDORADO)
		Fatal_error("Unsupported set files. Set id is %d.", FROM_LE_32(m_currentCamera->id));

	// Hack the camera into the format we want.
	HackMakeCamera();

	// Load the base bitmap into safe and working buffers.
	Init_base_bitmap_buffers();

	return TRUE8;
}

void _set::Reset() {
	// Free all the prop surface that have been created.
	if (m_setOk) {
		Common::strcpy_s(set_name, "None");

		// Remove all the old surface
		for (int32 s = 0; s < m_TotalPropSurfaces; s++) {
			if (m_propSurfaces[s])
				surface_manager->Kill_surface(m_propSurfaces[s]);
		}
		m_TotalPropSurfaces = 0;

		surface_manager->Kill_surface(bg_buffer_id);

		delete m_props;
		m_props = nullptr;
	}

	m_setOk = 0;
}

bool8 _set::DoesCameraExist(const char * /*camera_name*/, const char *camera_cluster_name) {
	// Compute the set_cluster name, which is:
	// <#mission>/<#session>/<#camera_name>.clu
	Common::sprintf_s(set_cluster, SET_PATH, MS->Fetch_h_session_name(), camera_cluster_name);
	set_cluster_hash = HashString(set_cluster);

	pxString rvcam = "p.rcvf";
	uint32 h_rvcam = HashString(rvcam);

	if (rs_bg->Test_file(rvcam, h_rvcam, set_cluster, set_cluster_hash) == 0) {
		rvcam = "p.rvcam";
		h_rvcam = HashString(rvcam);
		if (rs_bg->Test_file(rvcam, h_rvcam, set_cluster, set_cluster_hash) == 0)
			return FALSE8;
	}

	return TRUE8;
}

bool8 _set::DoesPropExist(const char *propName) {
	if (!OK())
		return FALSE8;

	for (uint32 i = 0; i < GetPropQty(); i++) {
		if (strcmp(propName, GetPropName(i)) == 0)
			return TRUE8;
	}

	return FALSE8;
}

void _set::Init_base_bitmap_buffers() {
	// Get the camera
	/*PXcamera camera = */ GetCamera();

	uint8 *bgPtr;

	// Look for the non z99 version first
	bgPtr = GetBackground();

	// Check this is a valid support set type
	if (READ_LE_UINT32(bgPtr) != 7)
		Fatal_error("Camera %s is out of date.", set_url);

	// Find the shadow table
	uint32 *shadowTable = ((uint32 *)bgPtr) + 1;

	// Create a safe buffer to store the backdrop in
	bg_buffer_id = surface_manager->Create_new_surface("Background", SCREEN_WIDTH, SCREEN_DEPTH, VIDEO);

	// Fill the buffer with solid pink so we can find hole in it more easily
	surface_manager->Fill_surface(bg_buffer_id, 0x008080ff);

	// Find the start of this shadow data
	uint8 *ptr = bgPtr + FROM_LE_32(shadowTable[0]);

	// Decode the jpeg background
	Graphics::Surface *jpegSurf = JpegDecode(ptr, 1024 * 1024);
	assert(jpegSurf);
	uint8 *surface_address = surface_manager->Lock_surface(bg_buffer_id);
	int32 pitch = surface_manager->Get_pitch(bg_buffer_id);
	uint32 height = surface_manager->Get_height(bg_buffer_id);
	for (int32 i = 0; i < jpegSurf->h; i++) {
		if (i >= (int32)height) {
			break;
		}
		memcpy(surface_address + i * pitch, jpegSurf->getBasePtr(0, i), MIN(jpegSurf->pitch, pitch));
	}
	surface_manager->Unlock_surface(bg_buffer_id);
	jpegSurf->free();
	delete jpegSurf;

	// find the start of the weather data
	int32 *weatherPtr = (int32 *)(bgPtr + FROM_LE_32(shadowTable[1]));

	InitWeather(READ_LE_INT32(weatherPtr), READ_LE_INT32(weatherPtr + 1), READ_LE_INT32(weatherPtr + 2), READ_LE_INT32(weatherPtr + 3), READ_LE_INT32(weatherPtr + 4), READ_LE_INT32(weatherPtr + 5));

	// Flush the actor z buffer
	if (pZ)
		memset(pZ, 0xff, 640 * 480 * 2);

	// Load all the props now
	Load_props();

	// Everythings ok with the set once we've got here
	m_setOk = 1;
}

void _set::Load_props() {
	uint32 p;
	uint32 s;

	// Check that we don't have any prop surfaces in memory
	if (m_TotalPropSurfaces != 0)
		Fatal_error("Set::Load_props called but there are still props using surfaces !");
	// Reset the surface array
	memset(m_propSurfaces, 0x00, sizeof(int32) * MAX_PROP_STATES);

	// Set up the props
	delete m_props;

	// Load the prop file
	m_props = new pcPropFile(((uint8 *)m_currentCamera) + FROM_LE_32(m_currentCamera->propOffset));

	pcPropFile *propFile = GetProps();
	// Which version are we using ?
	if (propFile->GetSchema() != PCPROP_SCHEMA)
		Fatal_error("[LOAD_PROPS] - Invalid prop file with schema %d, should have schema %d", propFile->GetSchema(), PCPROP_SCHEMA);
	// Get the prop quantity
	uint32 propQty = propFile->GetPropQty();
	// Go through each prop creating the surfaces for it. Load them all as low res first
	uint32 totalStates = 0;
	for (p = 0; p < propQty; p++) {
		// Keep track of where this props state surfaces start (2 surfaces per state)
		m_propSurfaceIds[p] = totalStates;
		// Get this prop
		pcPropRGB *pProp = propFile->GetProp(p);
		// How many states does it have ?
		uint32 stateQty = pProp->GetStateQty();
		// Loading them all in low res first
		m_propResolutions[p] = 0;
		// Create surfaces for each state
		for (s = 0; s < stateQty; s++) {
			// Get this prop state
			pcPropRGBState *pState = pProp->GetState(s);
			// Does it have any background tiles for this state ?
			if (pState->GetLRBgTileQty() > 0) {
				// Create a surface for bg prop state
				uint32 sid = surface_manager->Create_new_surface(pxVString("lb%s(%d)", pProp->GetName(), s), pState->GetLRBgSurfaceWidth(),
				                                                 pState->GetLRBgSurfaceHeight(), VIDEO);
				// Did it fit in video memory ?
				if (sid == 0)
					Fatal_error("Out of video memory trying to load %s frame %d", pProp->GetName(), s);
				m_propSurfaces[totalStates << 1] = sid;
				Tdebug("LoadProps.txt", "LowRes Background %s state %d in %d", pProp->GetName(), s, sid);
			}

			// Does it have any foreground tiles for this state ?
			if (pState->GetLRFgTileQty() > 0) {
				// Create a surface for fg prop state
				uint32 sid = surface_manager->Create_new_surface(pxVString("lf%s(%d)", pProp->GetName(), s), pState->GetLRFgSurfaceWidth(),
				                                                 pState->GetLRFgSurfaceHeight(), VIDEO);
				// Did it fit in video memory ?
				if (sid == 0)
					Fatal_error("Out of video memory trying to load %s frame %d", pProp->GetName(), s);
				m_propSurfaces[(totalStates << 1) + 1] = sid;
				Tdebug("LoadProps.txt", "LowRes Foreground %s state %d in %d", pProp->GetName(), s, sid);
			}
			totalStates++;
		}
	}

	m_TotalPropSurfaces = totalStates << 1;

	// Ok all the low res surfaces are created. Now try replacing each one with high res versions where possible.
	for (p = 0; p < propQty; p++) {
		// Get this prop
		pcPropRGB *pProp = propFile->GetProp(p);
		// How many states does it have ?
		uint32 stateQty = pProp->GetStateQty();
		// Delete all the surfaces for this prop
		uint32 propState = m_propSurfaceIds[p];
		for (s = 0; s < stateQty; s++) {
			if (m_propSurfaces[(propState << 1)]) {
				surface_manager->Kill_surface(m_propSurfaces[(propState << 1)]);
				Tdebug("LoadProps.txt", "Killing LowRes Background %s state %d in %d", pProp->GetName(), s, m_propSurfaces[(propState << 1)]);
				m_propSurfaces[(propState << 1)] = 0;
			}
			if (m_propSurfaces[(propState << 1) + 1]) {
				surface_manager->Kill_surface(m_propSurfaces[(propState << 1) + 1]);
				Tdebug("LoadProps.txt", "Killing LowRes Foreground %s state %d in %d", pProp->GetName(), s, m_propSurfaces[(propState << 1) + 1]);
				m_propSurfaces[(propState << 1) + 1] = 0;
			}
			propState++;
		}
		// Now try to creat it all at high res
		m_propResolutions[p] = 1;
		propState = m_propSurfaceIds[p];
		for (s = 0; s < stateQty; s++) {
			// Get this prop state
			pcPropRGBState *pState = pProp->GetState(s);
			// Does it have any background tiles for this state ?
			if (pState->GetHRBgTileQty() > 0) {
				// Create a surface for bg prop state
				uint32 sid = surface_manager->Create_new_surface(pxVString("hb%s(%d)", pProp->GetName(), s), pState->GetHRBgSurfaceWidth(),
				                                                 pState->GetHRBgSurfaceHeight(), VIDEO);
				// Did it fit in video memory ?
				if (sid == 0) {
					m_propResolutions[p] = 0;
					break;
				}
				Tdebug("LoadProps.txt", "HighRes Background %s state %d in %d", pProp->GetName(), s, sid);
				m_propSurfaces[propState << 1] = sid;
			}

			// Does it have any foreground tiles for this state ?
			if (pState->GetHRFgTileQty() > 0) {
				// Create a surface for fg prop state
				uint32 sid = surface_manager->Create_new_surface(pxVString("hf%s(%d)", pProp->GetName(), s), pState->GetHRFgSurfaceWidth(),
				                                                 pState->GetHRFgSurfaceHeight(), VIDEO);
				// Did it fit in video memory ?
				if (sid == 0) {
					m_propResolutions[p] = 0;
					break;
				}
				Tdebug("LoadProps.txt", "HighRes Foreground %s state %d in %d", pProp->GetName(), s, sid);
				m_propSurfaces[(propState << 1) + 1] = sid;
			}
			propState++;
		}
		// Did it all fit ok ?
		if (m_propResolutions[p] == 0) {
			// No.... back to low res then. Delete all the surfaces we did create
			propState = m_propSurfaceIds[p];
			for (s = 0; s < stateQty; s++) {
				if (m_propSurfaces[(propState << 1)]) {
					surface_manager->Kill_surface(m_propSurfaces[(propState << 1)]);
					Tdebug("LoadProps.txt", "Killing HighRes Background %s state %d in %d", pProp->GetName(), s, m_propSurfaces[(propState << 1)]);
					m_propSurfaces[(propState << 1)] = 0;
				}
				if (m_propSurfaces[(propState << 1) + 1]) {
					surface_manager->Kill_surface(m_propSurfaces[(propState << 1) + 1]);
					Tdebug("LoadProps.txt", "Killing HighRes Foreground %s state %d in %d", pProp->GetName(), s, m_propSurfaces[(propState << 1) + 1]);
					m_propSurfaces[(propState << 1) + 1] = 0;
				}
				propState++;
			}
			// No.... back to low res then. Delete all the surfaces we did create
			propState = m_propSurfaceIds[p];
			for (s = 0; s < stateQty; s++) {
				// Get this prop state
				pcPropRGBState *pState = pProp->GetState(s);
				// Does it have any background tiles for this state ?
				if (pState->GetLRBgTileQty() > 0) {
					// Create a surface for bg prop state
					uint32 sid = surface_manager->Create_new_surface(pxVString("lb%s(%d)", pProp->GetName(), s), pState->GetLRBgSurfaceWidth(),
					                                                 pState->GetLRBgSurfaceHeight(), VIDEO);
					// Did it fit in video memory ?
					if (sid == 0)
						Fatal_error("Out of video memory trying to load %s frame %d", pProp->GetName(), s);
					Tdebug("LoadProps.txt", "LowRes Background %s state %d in %d", pProp->GetName(), s, sid);
					m_propSurfaces[propState << 1] = sid;
				}

				// Does it have any foreground tiles for this state ?
				if (pState->GetLRFgTileQty() > 0) {
					// Create a surface for fg prop state
					uint32 sid = surface_manager->Create_new_surface(pxVString("lf%s(%d)", pProp->GetName(), s), pState->GetLRFgSurfaceWidth(),
					                                                 pState->GetLRFgSurfaceHeight(), VIDEO);
					// Did it fit in video memory ?
					if (sid == 0)
						Fatal_error("Out of video memory trying to load %s frame %d", pProp->GetName(), s);
					Tdebug("LoadProps.txt", "LowRes Foreground %s state %d in %d", pProp->GetName(), s, sid);
					m_propSurfaces[(propState << 1) + 1] = sid;
				}
				propState++;
			}
		}
	}

	// Now fill in all the prop surfaces
	for (p = 0; p < propQty; p++) {
		// Get this prop
		pcPropRGB *pProp = propFile->GetProp(p);
		// How many states does it have ?
		uint32 stateQty = pProp->GetStateQty();
		// Find the surfaces for this prop
		uint32 propState = m_propSurfaceIds[p];
		// Load them all
		for (s = 0; s < stateQty; s++) {
			pcPropRGBState *pState = pProp->GetState(s);
			// Get the palette for this prop state
			uint32 *palPtr = pState->GetPalette();
			// Which surface did we create for this prop state
			uint32 sid = m_propSurfaces[(propState << 1)];
			// Does this prop have a background ?
			if (sid) {
				// Set the colour key for the surface
				surface_manager->Set_transparent_colour_key(sid, 0x00ff00ff);
				// Fill the surface with the transparent colour
				surface_manager->Fill_surface(sid, 0x00ff00ff);
				// Lock the surface so we can decompress into it
				uint32 *safe_ad = (uint32 *)surface_manager->Lock_surface(sid);
				uint32 pitch = surface_manager->Get_pitch(sid) >> 2;
				// Now decode either 32 bit
				uint8 *pRle;
				uint32 y;
				uint32 xcount;
				if (m_propResolutions[p]) {
					pRle = pState->GetHRBgRlePtr();
					y = pState->GetHRBgSurfaceHeight();
					xcount = pState->GetHRBgSurfaceWidth();
				} else {
					pRle = pState->GetLRBgRlePtr();
					y = pState->GetLRBgSurfaceHeight();
					xcount = pState->GetLRBgSurfaceWidth();
				}

				for (; y; y--) {
					uint32 count = xcount;
					uint32 *rowAd = safe_ad;

					while (count) {
						count -= *pRle;
						rowAd += *pRle;
						pRle++;

						uint8 c2 = *pRle++;
						count -= c2;
						while (c2) {
							c2--;
							*rowAd++ = palPtr[*pRle++];
						}
					}

					safe_ad += pitch;
				}

				// unlock the surface
				surface_manager->Unlock_surface(sid);
			}
			// Which surface did we create for this prop state
			sid = m_propSurfaces[(propState << 1) + 1];
			// Does this prop have a background ?
			if (sid) {
				// Set the colour key for the surface
				surface_manager->Set_transparent_colour_key(sid, 0x00ff00ff);
				// Fill the surface with the transparent colour
				surface_manager->Fill_surface(sid, 0x00ff00ff);
				// Lock the surface so we can decompress into it
				uint32 *safe_ad = (uint32 *)surface_manager->Lock_surface(sid);
				uint32 pitch = surface_manager->Get_pitch(sid) >> 2;
				// Now decode either 32 bit
				uint8 *pRle;
				uint32 y;
				uint32 xcount;
				if (m_propResolutions[p]) {
					pRle = pState->GetHRFgRlePtr();
					y = pState->GetHRFgSurfaceHeight();
					xcount = pState->GetHRFgSurfaceWidth();
				} else {
					pRle = pState->GetLRFgRlePtr();
					y = pState->GetLRFgSurfaceHeight();
					xcount = pState->GetLRFgSurfaceWidth();
				}

				for (; y; y--) {
					uint32 count = xcount;
					uint32 *rowAd = safe_ad;

					while (count) {
						count -= *pRle;
						rowAd += *pRle;
						pRle++;

						uint8 c2 = *pRle++;
						count -= c2;
						while (c2) {
							c2--;
							*rowAd++ = palPtr[*pRle++];
						}
					}

					safe_ad += pitch;
				}

				// unlock the surface
				surface_manager->Unlock_surface(sid);
			}
			propState++;
		}
	}
}

void _set::RefreshBackdrop() {
	LRECT destRect = full_rect;
	LRECT sourceRect = full_rect;
	// Update the screen rects for shake screen
	ShakeRects(sourceRect, destRect);
	// And blit
	surface_manager->Blit_surface_to_surface(bg_buffer_id, working_buffer_id, &sourceRect, &destRect);
}

void _set::Set_draw(bool8 helper) {
	uint32 p;

	// Keep some space for the creation of hilite
	static uint32 hilite_palette[256];
	// Might need to create a surface for a hilited prop
	uint32 hilite_sid = 0;
	// Make sure the selected prop id thingy is up to date
	MS->GetSelectedPropId();
	// Rectangles
	LRECT sourceRect, destRect;
	// Load the prop file
	pcPropFile *propFile = GetProps();
	// Check if we are using the sexy new file format
	if (propFile->GetSchema() != PCPROP_SCHEMA)
		Fatal_error("[SET_DRAW] - Invalid prop file with schema %d, should have schema %d", propFile->GetSchema(), PCPROP_SCHEMA);
	// Get the prop quantity
	uint32 propQty = propFile->GetPropQty();
	// Draw each props background
	for (p = 0; p < propQty; p++) {
		// Get this prop
		pcPropRGB *pProp = propFile->GetProp(p);
		// Get the state for this prop
		uint32 state = g_mission->session->Fetch_prop_state(const_cast<char *>(pProp->GetName()));
		// Get the state
		pcPropRGBState *pState = pProp->GetState(state);
		// Find the surface id for this state
		uint32 sid = m_propSurfaces[(m_propSurfaceIds[p] + state) << 1];
		// Draw it in the appropriate resolution
		if (m_propResolutions[p]) {
			// How many tiles to draw ?
			uint32 tileQty = pState->GetHRBgTileQty();
			// Get a pointer to the tile rectangles
			LRECT *pTileRects = pState->GetTileRects() + ((pState->GetLRBgTileQty() + pState->GetLRFgTileQty()) << 1);
			// Draw the background tiles first
			for (uint32 t = 0; (sid != 0) && (t < tileQty); t++) {
				// Sort out transparent blit flag - no transparency if frag view is on
				uint32 flag = (helper) ? 0 : DDBLT_KEYSRC;
				// Sort out the source and destination rectangles
				sourceRect = *pTileRects++;
				destRect = *pTileRects++;
				// Update the screen rects for shake screen
				if (ShakePropRects(destRect, sourceRect)) {
					// Do the blit
					surface_manager->Blit_surface_to_surface(sid, working_buffer_id, &sourceRect, &destRect, flag);
				}
			}
		} else {
			// How many tiles to draw ?
			uint32 tileQty = pState->GetLRBgTileQty();
			// Get a pointer to the tile rectangles
			LRECT *pTileRects = pState->GetTileRects();
			// Draw the background tiles first
			for (uint32 t = 0; (sid != 0) && (t < tileQty); t++) {
				// Sort out transparent blit flag - no transparency if frag view is on
				uint32 flag = (helper) ? 0 : DDBLT_KEYSRC;
				// Sort out the source and destination rectangles
				sourceRect = *pTileRects++;
				destRect = *pTileRects++;
				// Update the screen rects for shake screen
				if (ShakePropRects(destRect, sourceRect)) {
					// Do the blit
					surface_manager->Blit_surface_to_surface(sid, working_buffer_id, &sourceRect, &destRect, flag);
				}
			}
		}
	}

	// Now draw each props foreground
	for (p = 0; p < propQty; p++) {
		// Get this prop
		pcPropRGB *pProp = propFile->GetProp(p);
		// Get the state for this prop
		uint32 state = g_mission->session->Fetch_prop_state(const_cast<char *>(pProp->GetName()));
		// Get the state
		pcPropRGBState *pState = pProp->GetState(state);
		// Which surface is it in ?
		uint32 sid = m_propSurfaces[((m_propSurfaceIds[p] + state) << 1) + 1];
		// Draw it in the appropriate resolution
		if (m_propResolutions[p]) {
			// How many tiles to draw ?
			uint32 tileQty = pState->GetHRFgTileQty();
			// Get a pointer to the foreground tile rectangles
			LRECT *pTileRects = pState->GetTileRects() + ((pState->GetHRBgTileQty() + pState->GetLRBgTileQty() + pState->GetLRFgTileQty()) << 1);
			// Is this prop selected
			if ((tileQty != 0) && MS->IsPropSelected(const_cast<char *>(pProp->GetName()))) {
				// Get the rgb highlite multipliers ready for mmx ing
				uint8 multiplier[8] = {0, 0, 0, 0, 0, 0, 0, 0};
				MS->GetSelectedPropRGB(multiplier[0], multiplier[2], multiplier[4]);
				// Hilite the palette
#if 1
				// 32-bit BGR pixel
				uint8 *pixel = (uint8 *)&hilite_palette;
				for (int32 c = 0; c < 256; c++) {
					// Multiply from RGB components
					for (int32 i = 0; i < 3; i++) {
						pixel[i] = (pixel[i] * multiplier[i * 2]) >> 7;
					}
					pixel += 4;
				}
#else
				// Get a pointer to the palettte
				uint32 *palPtr = pState->GetPalette();
				_asm {
					; // Load the counters and pointers
					mov  ecx, 256
					mov  esi, palPtr
					lea  edi, hilite_palette
					; // Load the MMX multiplier
					movq MM0, [multiplier]
					sub  esi, 4
					sub  edi, 4
					; // Clear an MMX register to use with the unpack instruction
					psrlw MM1, 16
					prop_palette_hilite_label1:
					movd MM2, [esi+ecx*4]
					; // unpack the colour
					punpcklbw MM2, MM1
					; // Multiply the colour by the multiplier
					pmullw MM2, MM0
					; // Scale it back
					psrlw MM2, 7
					; // Re pack the colour back to bytes
					packuswb MM2, MM1
					; // Now store this new colour
					movd [edi+ecx*4], MM2
					; // Decrement the counter an off again
					dec ecx
					; // Are we finished ?
					jne prop_palette_hilite_label1
					; // finshed !
					emms
				}
#endif
				// Create a surface for this hilited prop state
				sid = hilite_sid = surface_manager->Create_new_surface("hilite_prop", pState->GetHRFgSurfaceWidth(), pState->GetHRFgSurfaceHeight(), EITHER);
				// Set the colour key for the surface
				surface_manager->Set_transparent_colour_key(hilite_sid, 0x00ff00ff);
				// Fill the surface with the transparent colour
				surface_manager->Fill_surface(hilite_sid, 0x00ff00ff);
				// Lock the surface so we can decompress into it
				uint8 *safe_ad = (uint8 *)surface_manager->Lock_surface(hilite_sid);
				uint32 pitch = surface_manager->Get_pitch(hilite_sid);
				// Now decode 32 bit
				uint8 *pRle = pState->GetHRFgRlePtr();
				uint32 *ad = (uint32 *)safe_ad;

				for (int32 y = pState->GetHRFgSurfaceHeight(); y; y--) {
					uint32 count = pState->GetHRFgSurfaceWidth();
					uint32 *rowAd = ad;
					while (count) {
						count -= *pRle;
						rowAd += *pRle;
						pRle++;

						uint8 c2 = *pRle++;
						count -= c2;
						while (c2) {
							c2--;
							*rowAd++ = hilite_palette[*pRle++];
						}
					}

					ad += pitch / 4;
				}

				// unlock the surface
				surface_manager->Unlock_surface(hilite_sid);
			}

			// Now draw the foreground tiles
			for (uint32 t = 0; (sid != 0) && (t < tileQty); t++) {
				// Sort out transparent blit flag - no transparency if frag view is on
				uint32 flag = (helper) ? 0 : DDBLT_KEYSRC;
				// Sort out the source and destination rectangles
				sourceRect = *pTileRects++;
				destRect = *pTileRects++;
				// Update the screen rects for shake screen
				if (ShakePropRects(destRect, sourceRect)) {
					// Do the blit
					surface_manager->Blit_surface_to_surface(sid, working_buffer_id, &sourceRect, &destRect, flag);
				}
			}
		} else {
			// How many tiles to draw ?
			uint32 tileQty = pState->GetLRFgTileQty();
			// Get a pointer to the foreground tile rectangles
			LRECT *pTileRects = pState->GetTileRects() + (pState->GetLRBgTileQty() << 1);

			// Is this prop selected
			if ((tileQty != 0) && MS->IsPropSelected(const_cast<char *>(pProp->GetName()))) {
				// Get the rgb highlite multipliers ready for mmx ing
				uint8 multiplier[8] = {0, 0, 0, 0, 0, 0, 0, 0};
				MS->GetSelectedPropRGB(multiplier[0], multiplier[2], multiplier[4]);
				// Hilite the palette
#if 1
				// 32-bit BGR pixel
				uint8 *pixel = (uint8 *)&hilite_palette;
				for (int32 c = 0; c < 256; c++) {
					// Multiply from RGB components
					for (int32 i = 0; i < 3; i++) {
						pixel[i] = (pixel[i] * multiplier[i * 2]) >> 7;
					}
					pixel += 4;
				}
#else
				// Get a pointer to the palettte
				uint32 *palPtr = pState->GetPalette();
				_asm {
					; // Load the counters and pointers
					mov  ecx, 256
					mov  esi, palPtr
					lea  edi, hilite_palette
					; // Load the MMX multiplier
					movq MM0, [multiplier]
					sub  esi, 4
					sub  edi, 4
					; // Clear an MMX register to use with the unpack instruction
					psrlw MM1, 16
					prop_palette_hilite_label2:
					movd MM2, [esi+ecx*4]
					; // unpack the colour
					punpcklbw MM2, MM1
					; // Multiply the colour by the multiplier
					pmullw MM2, MM0
					; // Scale it back
					psrlw MM2, 7
					; // Re pack the colour back to bytes
					packuswb MM2, MM1
					; // Now store this new colour
					movd [edi+ecx*4], MM2
					; // Decrement the counter an off again
					dec ecx
					; // Are we finished ?
					jne prop_palette_hilite_label2
					; // finshed !
					emms
				}
#endif
				// Create a surface for this hilited prop state
				sid = hilite_sid = surface_manager->Create_new_surface("hilite_prop", pState->GetLRFgSurfaceWidth(), pState->GetLRFgSurfaceHeight(), EITHER);
				// Set the colour key for the surface
				surface_manager->Set_transparent_colour_key(hilite_sid, 0x00ff00ff);
				// Fill the surface with the transparent colour
				surface_manager->Fill_surface(hilite_sid, 0x00ff00ff);
				// Lock the surface so we can decompress into it
				uint8 *safe_ad = (uint8 *)surface_manager->Lock_surface(hilite_sid);
				uint32 pitch = surface_manager->Get_pitch(hilite_sid);
				// Now decode 32 bit
				uint8 *pRle = pState->GetLRFgRlePtr();
				uint32 *ad = (uint32 *)safe_ad;

				for (int32 y = pState->GetLRFgSurfaceHeight(); y; y--) {
					uint32 count = pState->GetLRFgSurfaceWidth();
					uint32 *rowAd = ad;
					while (count) {
						count -= *pRle;
						rowAd += *pRle;
						pRle++;

						uint8 c2 = *pRle++;
						count -= c2;
						while (c2) {
							c2--;
							*rowAd++ = hilite_palette[*pRle++];
						}
					}

					ad += pitch / 4;
				}

				// unlock the surface
				surface_manager->Unlock_surface(hilite_sid);
			}

			// Now draw the foreground tiles
			for (uint32 t = 0; (sid != 0) && (t < tileQty); t++) {
				// Sort out transparent blit flag - no transparency if frag view is on
				uint32 flag = (helper) ? 0 : DDBLT_KEYSRC;
				// Sort out the source and destination rectangles
				sourceRect = *pTileRects++;
				destRect = *pTileRects++;
				// Update the screen rects for shake screen
				if (ShakePropRects(destRect, sourceRect)) {
					// Do the blit
					surface_manager->Blit_surface_to_surface(sid, working_buffer_id, &sourceRect, &destRect, flag);
				}
			}
		}
	}

	if (hilite_sid)
		surface_manager->Kill_surface(hilite_sid);

	DrawSparkles();
}

void _set::InitWeather(int32 type, int32 particleQty, int32 lightning, int32 windX, int32 windY, int32 windZ) {
	m_wType = type;
	m_wLightningTimer = 0;
	m_wWindX = windX;
	m_wWindY = windY;
	m_wWindZ = windZ;
	m_wParticleQty = particleQty;
	m_wLightning = lightning;

	if (m_wParticleQty > WEATHER_MAX_PARTICLES)
		m_wParticleQty = WEATHER_MAX_PARTICLES;

	for (int32 i = WEATHER_MAX_PARTICLES - 1; i >= 0; i--) {
		m_wParticleX[i] = (int16)((g_icb->getRandomSource()->getRandomNumber(WEATHER_SCREEN_WIDTH - 1)) - WEATHER_HALF_SCREEN_WIDTH);
		m_wParticleY[i] = (int16)((g_icb->getRandomSource()->getRandomNumber(WEATHER_SCREEN_HEIGHT - 1)) - WEATHER_HALF_SCREEN_HEIGHT);
		m_wParticleZ[i] = (int16)((g_icb->getRandomSource()->getRandomNumber(WEATHER_SCREEN_DEPTH - 1)) - WEATHER_HALF_SCREEN_DEPTH);

		if (m_wType == WEATHER_RAIN) {
			m_wParticleDX[i] = (int8)0;
			m_wParticleDY[i] = (int8)((g_icb->getRandomSource()->getRandomNumber(50 - 1)) + 40);
			m_wParticleDZ[i] = (int8)0;
		} else if (m_wType == WEATHER_SNOW) {
			m_wParticleDX[i] = (int8)((g_icb->getRandomSource()->getRandomNumber(20 - 1)) - 10); // left/right   // -10 - 10
			m_wParticleDY[i] = (int8)((g_icb->getRandomSource()->getRandomNumber(10 - 1)));      // downwards    // 10 - 0
			m_wParticleDZ[i] = (int8)((g_icb->getRandomSource()->getRandomNumber(20 - 1)) - 10); // in out...    // -10 - 10
		}
	}
}

void _set::DrawSparkles() {
	static uint8 step = 0;
	static uint32 animation[] = {1024 * 0, 1024 * 1, 1024 * 2, 1024 * 3, 1024 * 4, 1024 * 5, 1024 * 2, 1024 * 3, 1024 * 4, 1024 * 5, 1024 * 1, 1024 * 0};

	step++;
	if (step > 32)
		step = 0;

	if (step > 11)
		return;

	for (uint32 i = 0; i < MS->total_objects; i++) {
		_logic *L = MS->logic_structs[i];

		// if object visible to camera
		if ((L->sparkleOn) && (MS->Object_visible_to_camera(i))) {
			PXvector screen;
			bool8 isShown;

			PXvector position;

			L->GetPosition(position.x, position.y, position.z);

			PXvector pos;
			L->GetPosition(pos.x, pos.y, pos.z);

			position.x += L->sparkleX;
			position.y += L->sparkleY;
			position.z += L->sparkleZ;

			// get screen position...
			PXWorldToFilm(position, GetCamera(), isShown, screen);

			// on screen, okay...
			if (isShown) {
				uint32 *pPixels = (uint32 *)surface_manager->Lock_surface(working_buffer_id);
				uint32 pitch = surface_manager->Get_pitch(working_buffer_id);

				uint32 offset = ((pitch >> 2) * (225 - (int32)screen.y)) + (int32)screen.x + 305;

				uint32 *colours = &sparkle_bmp[animation[step]];

				uint32 *sPtr = pPixels + offset;

#if 1
				uint8 *pixels = (uint8 *)&sPtr;
				uint8 *colors = (uint8 *)&colours;
				for (uint32 lines = 0; lines < 32; lines++) {
					for (int32 xPos = 0; xPos < 32; xPos++) {
						// 32-bit BGRA pixel
						uint8 *pixel = &pixels[xPos * 4];
						// Add BGRA components
						for (int32 p = 0; p < 4; p++) {
							pixel[p] = MIN(255, pixel[p] + colors[p]);
						}
					}
					// Next line
					pixels += pitch;
				}
#else
				__asm {
					mov edi, sPtr
					mov esi, colours
					pxor MM2, MM2
					mov edx, 32
					loopy_loops:
					mov ecx, 32
					mov ebx, edi
					loopx_loops:
					movd MM1, [edi]
					movd MM0, [esi]
					paddusb   MM0, MM1
					movd [edi], MM0
					add edi, 4
					add esi, 4
					dec ecx
					jne loopx_loops
					mov edi, ebx
					add edi, pitch
					dec edx
					jne loopy_loops
					emms
				}
#endif

				surface_manager->Unlock_surface(working_buffer_id);
			}
		}
	}

	return;
}

void _set::DrawWeather() {
	// Get the camera info that we need
	PXcamera &camera = GetCamera();

	float myCos = camera.view.m[1][1] / -4096.0f;
	float mySin = camera.view.m[2][1] / -4096.0f;
	int32 d = (camera.focLen) / 4;
	int32 a = 512;

	uint32 rands[WEATHER_MAX_PARTICLES / 32];

	int32 i;

	// initialise random bits (for movement)
	for (i = 0; i < (WEATHER_MAX_PARTICLES / 32); i++)
		rands[i] = RAND_32BIT;

	if (m_wType == WEATHER_RAIN) {
		for (i = m_wParticleQty; i--;) {
			// add velocity to position (+ extra wind)
			m_wParticleX[i] = (int16)(m_wParticleX[i] + m_wWindX);
			m_wParticleY[i] = (int16)(m_wParticleY[i] + m_wParticleDY[i] + m_wWindY);
			m_wParticleZ[i] = (int16)(m_wParticleZ[i] + m_wWindZ);

			// wrap around
			if (m_wParticleX[i] > WEATHER_HALF_SCREEN_WIDTH) {
				m_wParticleX[i] -= WEATHER_SCREEN_WIDTH;
			} else if (m_wParticleX[i] < -WEATHER_HALF_SCREEN_WIDTH) {
				m_wParticleX[i] += WEATHER_SCREEN_WIDTH;
			}

			if (m_wParticleY[i] > WEATHER_HALF_SCREEN_HEIGHT) {
				m_wParticleY[i] -= WEATHER_SCREEN_HEIGHT;
			} else if (m_wParticleY[i] < -WEATHER_HALF_SCREEN_HEIGHT) {
				m_wParticleY[i] += WEATHER_SCREEN_HEIGHT;
			}

			if (m_wParticleZ[i] > WEATHER_HALF_SCREEN_DEPTH) {
				m_wParticleZ[i] -= WEATHER_SCREEN_DEPTH;
			} else if (m_wParticleZ[i] < -WEATHER_HALF_SCREEN_DEPTH) {
				m_wParticleZ[i] += WEATHER_SCREEN_DEPTH;
			}

			int16 sx, sy, ss, sx2, sy2, ss2; // screen x, screen y, screen size,

			// rotate around camera ypan
			int32 pX = m_wParticleX[i];
			int32 pY = m_wParticleY[i];
			int32 pZ1 = m_wParticleZ[i];
			int32 pX2 = pX - m_wParticleDX[i] - m_wWindX;
			int32 pY2 = pY - m_wParticleDY[i] - m_wWindY;
			int32 pZ2 = pZ1 - m_wParticleDZ[i] - m_wWindZ;

			ss = (int16)(myCos * pZ1 + mySin * pY);
			ss2 = (int16)(myCos * pZ2 + mySin * pY2);

			if ((ss + a) != 0 && (ss2 + a) != 0) {
				sx = (int16)(WEATHER_HALF_SCREEN_WIDTH + (pX * d) / (ss + a)); //  + (((128+256+ss)*pX)>>9));
				sy = (int16)(WEATHER_HALF_SCREEN_HEIGHT + ((int32)(myCos * pY - mySin * pZ1) * d) / (ss + a));
				sx2 = (int16)(WEATHER_HALF_SCREEN_WIDTH + (pX2 * d) / (ss2 + a)); //  + (((128+256+ss)*pX)>>9));
				sy2 = (int16)(WEATHER_HALF_SCREEN_HEIGHT + ((int32)(myCos * pY2 - mySin * pZ2) * d) / (ss2 + a));

				// setup semi trans (possibly) polygon...
				// and draw
				int16 ssCol, ss2Col;
				ssCol = (int16)((-ss + 256) / 32); // 0-16

				// check for negative (should NEVER happen)
				if (ssCol < 0)
					ssCol = 0;

				ss2Col = (int16)((-ss2 + 256) / 32); // 0-16

				// check for negative (could happen...)
				if (ss2Col < 0)
					ss2Col = 0;

				ssCol += 6;  //  8-24
				ss2Col += 8; //  10-26

				_rgb c0, c1;
				c0.red = c0.green = c0.blue = c0.alpha = (uint8)ssCol;
				c1.red = c1.green = c1.blue = c1.alpha = (uint8)ss2Col;
				AdditiveGouraudLine(sx, sy, c0, sx2, sy2, c1, working_buffer_id);
			}
		}
	} else if (m_wType == WEATHER_SNOW) {
		uint32 *pPixels = (uint32 *)surface_manager->Lock_surface(working_buffer_id);
		uint32 pitch = surface_manager->Get_pitch(working_buffer_id) >> 2;

		// wind acceleration for this frame
		int32 dx = (g_icb->getRandomSource()->getRandomNumber(3 - 1)) - 1; // -1 - 1
		int32 dy = (g_icb->getRandomSource()->getRandomNumber(4 - 1)) - 1; // -1 - 2
		int32 dz = (g_icb->getRandomSource()->getRandomNumber(3 - 1)) - 1; // -1 - 1

		for (i = m_wParticleQty; i--;) {
			// adjust velocities (it is a random test as to weather any particular m_wParticle picks up this change
			if (RAND_BIT(i))
				m_wParticleDX[i] = (int8)(m_wParticleDX[i] + dx);

			if (RAND_BIT((i + 7) % WEATHER_MAX_PARTICLES))
				m_wParticleDY[i] = (int8)(m_wParticleDY[i] + dy);

			if (RAND_BIT((i + 17) % WEATHER_MAX_PARTICLES))
				m_wParticleDZ[i] = (int8)(m_wParticleDZ[i] + dz);

			// check limits on velocities
			if (m_wParticleDX[i] > 5) // -5 - 5
				m_wParticleDX[i] = 5;
			else if (m_wParticleDX[i] < -5)
				m_wParticleDX[i] = -5;

			if (m_wParticleDY[i] > 9) // -9 - 1
				m_wParticleDY[i] = 9;
			else if (m_wParticleDY[i] < -1)
				m_wParticleDY[i] = -1;

			if (m_wParticleDZ[i] > 5) // -5 - 5
				m_wParticleDZ[i] = 5;
			else if (m_wParticleDZ[i] < -5)
				m_wParticleDZ[i] = -5;

			// add velocity to position (+ extra wind)
			m_wParticleX[i] = (int16)(m_wParticleX[i] + m_wParticleDX[i] + m_wWindX);
			m_wParticleY[i] = (int16)(m_wParticleY[i] + m_wParticleDY[i] + m_wWindY);
			m_wParticleZ[i] = (int16)(m_wParticleZ[i] + m_wParticleDZ[i] + m_wWindZ);

			// wrap around
			if (m_wParticleX[i] >= WEATHER_HALF_SCREEN_WIDTH) {
				m_wParticleX[i] -= WEATHER_SCREEN_WIDTH;
			} else if (m_wParticleX[i] <= -WEATHER_HALF_SCREEN_WIDTH) {
				m_wParticleX[i] += WEATHER_SCREEN_WIDTH;
			}

			if (m_wParticleY[i] >= WEATHER_HALF_SCREEN_HEIGHT) {
				m_wParticleY[i] -= WEATHER_SCREEN_HEIGHT;
			} else if (m_wParticleY[i] <= -WEATHER_HALF_SCREEN_HEIGHT) {
				m_wParticleY[i] += WEATHER_SCREEN_HEIGHT;
			}

			if (m_wParticleZ[i] >= WEATHER_HALF_SCREEN_DEPTH) {
				m_wParticleZ[i] -= WEATHER_SCREEN_DEPTH;
			} else if (m_wParticleZ[i] <= -WEATHER_HALF_SCREEN_DEPTH) {
				m_wParticleZ[i] += WEATHER_SCREEN_DEPTH;
			}

			int32 sx, sy, ss; // screen x, screen y, screen size,

			int32 pX = m_wParticleX[i];
			int32 pY = m_wParticleY[i];
			int32 pZ1 = m_wParticleZ[i];

			ss = (int16)(myCos * pZ1 + mySin * pY);

			if ((ss + a) != 0) {
				sx = (int16)(WEATHER_HALF_SCREEN_WIDTH + (pX * d) / (ss + a)); //  + (((128+256+ss)*pX)>>9));
				sy = (int16)(WEATHER_HALF_SCREEN_HEIGHT + ((int32)(myCos * pY - mySin * pZ1) * d) / (ss + a));

				uint8 tCol = (uint8)(40 + (ss >> 1));
				uint32 offset = (pitch * sy) + sx;

				if ((sx >= 0) && (sy >= 0) && (sy < 478) && (sx < 638)) {
					if (ss < 0) {
						uint8 *sPtr = (uint8 *)(pPixels + offset);
						*sPtr = ((*sPtr + tCol) < 255) ? (uint8)((*sPtr) + tCol) : (uint8)255;
						sPtr++;
						*sPtr = ((*sPtr + tCol) < 255) ? (uint8)((*sPtr) + tCol) : (uint8)255;
						sPtr++;
						*sPtr = ((*sPtr + tCol) < 255) ? (uint8)((*sPtr) + tCol) : (uint8)255;
						sPtr++;
						*sPtr = ((*sPtr + tCol) < 255) ? (uint8)((*sPtr) + tCol) : (uint8)255;
						sPtr++;
					} else {
						uint8 *sPtr = (uint8 *)(pPixels + offset);
						*sPtr = ((*sPtr + tCol) < 255) ? (uint8)((*sPtr) + tCol) : (uint8)255;
						sPtr++;
						*sPtr = ((*sPtr + tCol) < 255) ? (uint8)((*sPtr) + tCol) : (uint8)255;
						sPtr++;
						*sPtr = ((*sPtr + tCol) < 255) ? (uint8)((*sPtr) + tCol) : (uint8)255;
						sPtr++;
						*sPtr = ((*sPtr + tCol) < 255) ? (uint8)((*sPtr) + tCol) : (uint8)255;
						sPtr++;
						*sPtr = ((*sPtr + tCol) < 255) ? (uint8)((*sPtr) + tCol) : (uint8)255;
						sPtr++;
						*sPtr = ((*sPtr + tCol) < 255) ? (uint8)((*sPtr) + tCol) : (uint8)255;
						sPtr++;
						*sPtr = ((*sPtr + tCol) < 255) ? (uint8)((*sPtr) + tCol) : (uint8)255;
						sPtr++;
						*sPtr = ((*sPtr + tCol) < 255) ? (uint8)((*sPtr) + tCol) : (uint8)255;
						sPtr++;
						sPtr = (uint8 *)(pPixels + offset + pitch);
						*sPtr = ((*sPtr + tCol) < 255) ? (uint8)((*sPtr) + tCol) : (uint8)255;
						sPtr++;
						*sPtr = ((*sPtr + tCol) < 255) ? (uint8)((*sPtr) + tCol) : (uint8)255;
						sPtr++;
						*sPtr = ((*sPtr + tCol) < 255) ? (uint8)((*sPtr) + tCol) : (uint8)255;
						sPtr++;
						*sPtr = ((*sPtr + tCol) < 255) ? (uint8)((*sPtr) + tCol) : (uint8)255;
						sPtr++;
						*sPtr = ((*sPtr + tCol) < 255) ? (uint8)((*sPtr) + tCol) : (uint8)255;
						sPtr++;
						*sPtr = ((*sPtr + tCol) < 255) ? (uint8)((*sPtr) + tCol) : (uint8)255;
						sPtr++;
						*sPtr = ((*sPtr + tCol) < 255) ? (uint8)((*sPtr) + tCol) : (uint8)255;
						sPtr++;
						*sPtr = ((*sPtr + tCol) < 255) ? (uint8)((*sPtr) + tCol) : (uint8)255;
						sPtr++;
					}
				}
			}
		}
		surface_manager->Unlock_surface(working_buffer_id);
	}

	// Add lightning
	if (m_wLightning) {
		if (m_wLightningTimer) {
			m_wLightningTimer--;

			if (m_wLightningTimer == 0) {
				surface_manager->FadeMode() = 0;
			} else {
				surface_manager->FadeAlpha() = (uint8)(surface_manager->FadeAlpha() - 0x20);
				surface_manager->FadeToRed() /= 2;
				surface_manager->FadeToGreen() /= 2;
				surface_manager->FadeToBlue() /= 2;
			}
		} else {
			if (g_icb->getRandomSource()->getRandomNumber(80 - 1) == 0) {
				if (surface_manager->FadeMode() == 0) {
					m_wLightningTimer = g_icb->getRandomSource()->getRandomNumber(10 - 1) + 2;
					surface_manager->FadeMode() = 1;
					surface_manager->FadeToRed() = 0xa0;
					surface_manager->FadeToGreen() = 0xb0;
					surface_manager->FadeToBlue() = 0xff;
					surface_manager->FadeFromRed() = 0xa0;
					surface_manager->FadeFromGreen() = 0xb0;
					surface_manager->FadeFromBlue() = 0xff;
					surface_manager->FadeAlpha() = 0xff;
				}
			}
		}
	}
}

void _set::HackMakeCamera() {
	float *oldCameraData;
	if (FROM_LE_32(m_currentCamera->id) != PCSETFILE_ID_ICB && FROM_LE_32(m_currentCamera->id) != PCSETFILE_ID_ELDORADO)
		Fatal_error("Illegal camera file.  SetID == %d", FROM_LE_32(m_currentCamera->id));

	oldCameraData = (float *)(((uint8 *)m_currentCamera) + FROM_LE_32(m_currentCamera->cameraOffset));
	/*   Old Camera Format
	    -------------------

	        int         is_shooting;    // flag: 0 means 'does not record an image', 1 means 'does'.
	        float       pos.x
	        float       pos.y
	        float       pos.z

	        float       orient.ex.x
	        float       orient.ex.y
	        float       orient.ex.z
	        float       orient.ey.x

	        float       orient.ey.y
	        float       orient.ey.z
	        float       orient.ez.x
	        float       orient.ez.y

	        float       orient.ez.z
	        float       film.foclen
	        int         film.pos.x
	        int         film.pos.y

	        int         film.size.x
	        int         film.size.y

	        ADimage *       imageptr;               // Address of pixelmap.
	*/
	const float SCALE_TOLERANCE = 1.0e-3f;
	const float UNIT_SCALE = 1.0f;

	// Find scalings in the input matrix
	float matrix[3][3];
	matrix[0][0] = READ_LE_FLOAT32(oldCameraData + 4);
	matrix[0][1] = READ_LE_FLOAT32(oldCameraData + 5);
	matrix[0][2] = READ_LE_FLOAT32(oldCameraData + 6);
	matrix[1][0] = READ_LE_FLOAT32(oldCameraData + 7);
	matrix[1][1] = READ_LE_FLOAT32(oldCameraData + 8);
	matrix[1][2] = READ_LE_FLOAT32(oldCameraData + 9);
	matrix[2][0] = READ_LE_FLOAT32(oldCameraData + 10);
	matrix[2][1] = READ_LE_FLOAT32(oldCameraData + 11);
	matrix[2][2] = READ_LE_FLOAT32(oldCameraData + 12);
	float scalex = (float)sqrt(matrix[0][0] * matrix[0][0] + matrix[1][0] * matrix[1][0] + matrix[2][0] * matrix[2][0]);
	float scaley = (float)sqrt(matrix[0][1] * matrix[0][1] + matrix[1][1] * matrix[1][1] + matrix[2][1] * matrix[2][1]);
	float scalez = (float)sqrt(matrix[0][2] * matrix[0][2] + matrix[1][2] * matrix[1][2] + matrix[2][2] * matrix[2][2]);

	if (fabs(scalex - scaley) > SCALE_TOLERANCE) {
		Fatal_error("ERROR : Camera scalex != scaley %f != %f", scalex, scaley);
	}
	if (fabs(scalex - scalez) > SCALE_TOLERANCE) {
		Fatal_error("ERROR : Camera scalex != scalez %f != %f", scalex, scalez);
	}
	if (fabs(scaley - scalez) > SCALE_TOLERANCE) {
		Fatal_error("ERROR : Camera scaley != scalez %f != %f", scaley, scalez);
	}

	// Remove the x-scaling
	if (fabs(scalex - UNIT_SCALE) > SCALE_TOLERANCE) {
		matrix[0][0] /= scalex;
		matrix[1][0] /= scalex;
		matrix[2][0] /= scalex;
	}
	// Remove the y-scaling
	if (fabs(scaley - UNIT_SCALE) > SCALE_TOLERANCE) {
		matrix[0][1] /= scaley;
		matrix[1][1] /= scaley;
		matrix[2][1] /= scaley;
	}
	// Remove the z-scaling
	if (fabs(scalez - UNIT_SCALE) > SCALE_TOLERANCE) {
		matrix[0][2] /= scalez;
		matrix[1][2] /= scalez;
		matrix[2][2] /= scalez;
	}

	// check the scalings in the input matrix
	scalex = (float)sqrt(matrix[0][0] * matrix[0][0] + matrix[1][0] * matrix[1][0] + matrix[2][0] * matrix[2][0]);
	scaley = (float)sqrt(matrix[0][1] * matrix[0][1] + matrix[1][1] * matrix[1][1] + matrix[2][1] * matrix[2][1]);
	scalez = (float)sqrt(matrix[0][2] * matrix[0][2] + matrix[1][2] * matrix[1][2] + matrix[2][2] * matrix[2][2]);

	if (fabs(scalex - scaley) > SCALE_TOLERANCE) {
		Fatal_error("ERROR : Camera scalex != scaley %f != %f", scalex, scaley);
	}
	if (fabs(scalex - scalez) > SCALE_TOLERANCE) {
		Fatal_error("ERROR : Camera scalex != scalez %f != %f", scalex, scalez);
	}
	if (fabs(scaley - scalez) > SCALE_TOLERANCE) {
		Fatal_error("ERROR : Camera scaley != scalez %f != %f", scaley, scalez);
	}

	m_camera.view.m[0][0] = (int16)(matrix[0][0] * ONE);
	m_camera.view.m[0][1] = (int16)(matrix[0][1] * ONE);
	m_camera.view.m[0][2] = (int16)(matrix[0][2] * ONE);
	m_camera.view.m[1][0] = (int16)(-matrix[1][0] * ONE);
	m_camera.view.m[1][1] = (int16)(-matrix[1][1] * ONE);
	m_camera.view.m[1][2] = (int16)(-matrix[1][2] * ONE);
	m_camera.view.m[2][0] = (int16)(-matrix[2][0] * 4 * ONE);
	m_camera.view.m[2][1] = (int16)(-matrix[2][1] * 4 * ONE);
	m_camera.view.m[2][2] = (int16)(-matrix[2][2] * 4 * ONE);

	int32 TR2vx = (int32)(-(READ_LE_FLOAT32(oldCameraData + 1)) * m_camera.view.m[0][0] - (READ_LE_FLOAT32(oldCameraData + 2)) * m_camera.view.m[0][1] - (READ_LE_FLOAT32(oldCameraData + 3)) * m_camera.view.m[0][2]);
	int32 TR2vy = (int32)(-(READ_LE_FLOAT32(oldCameraData + 1)) * m_camera.view.m[1][0] - (READ_LE_FLOAT32(oldCameraData + 2)) * m_camera.view.m[1][1] - (READ_LE_FLOAT32(oldCameraData + 3)) * m_camera.view.m[1][2]);
	int32 TR2vz = (int32)(-(READ_LE_FLOAT32(oldCameraData + 1)) * m_camera.view.m[2][0] - (READ_LE_FLOAT32(oldCameraData + 2)) * m_camera.view.m[2][1] - (READ_LE_FLOAT32(oldCameraData + 3)) * m_camera.view.m[2][2]);

	// Multiply the translation by rotation matrix
	// to get into how PSX does the projection
	// e.g. rotate by matrix then add translation
	m_camera.view.t[0] = TR2vx >> 12;
	m_camera.view.t[1] = TR2vy >> 12;
	m_camera.view.t[2] = TR2vz >> 12;

	m_camera.focLen = (uint16)((READ_LE_FLOAT32(oldCameraData + 13)) * -4.0);

	gte_SetRotMatrix(&m_camera.view);
	gte_SetTransMatrix(&m_camera.view);

	int32 stheta = m_camera.view.m[0][2];
	int32 ctheta = m_camera.view.m[0][0];

	float fpan;
	int32 scrnPan;
	if (ctheta != 0) {
		fpan = (float)atan((float)stheta / (float)ctheta) / (2.0f * (float)M_PI);
		scrnPan = (int32)(fpan * ONE);
		// second & third quadrant (90-270 degrees) : pan += 180 (pan is -ve(90-180), (180-270)+ve)
		if (ctheta < 0)
			scrnPan += ONE / 2;
	} else {
		// ctheta = 0
		fpan = 1.0f / 4.0f;
		scrnPan = (int32)(fpan * ONE);
		// -180 degrees
		if (stheta <= 0)
			scrnPan += (ONE / 2);
	}
	m_camera.pan = scrnPan;
}

} // End of namespace ICB
