#!/bin/sh

if ! gpgv --keyring /usr/share/keyrings/debian-keyring.gpg signify-openbsd-keys.sha256.asc; then
	echo "\033[0;31m"
	echo "GPG SIGNATURE VERIFICATION FAILED!"
	echo "\033[0m" 
	exit 1
else
	if ! sha256sum -c signify-openbsd-keys.sha256.asc; then
		echo "\033[0;31m"
		echo "SHA256 VERIFICATION FAILED!"
	        echo "\033[0m"
		exit 1
	else
		echo "\033[0;32m"
		echo "Verification successful!"
		echo "\033[0m"
		exit 0
	fi
fi
