/* ====================================================================
 * Copyright (c) 2003-2006, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _SC_SCCMD_H
#define _SC_SCCMD_H

// sc
class CmdProgressCallback;
class ScParam;
class Cancel;

namespace svn
{
class Client;
}


/**
 * Base class for the Commands.
 */
class ScCmd
{
public:
  /**
   * \param id the command id.
   */
  ScCmd( unsigned long id );
  virtual ~ScCmd();

  /**
   * run the command. The command takes ownership of the svn::Client
   * pointer.
   *
   * \param client  the subversion client.
   * \param cb      the progress callback.
   */
   void run( svn::Client* client, CmdProgressCallback* cb );

  /**
   * returns the command id for this command.
   *
   * \return the commands id.
   */
  unsigned long getId() const;

protected:
  /**
   * the command method.
   */
   virtual void run() = 0;

   /**
    * \return cancel callback.
    */
   Cancel* getCancel() const;

protected:
  svn::Client*         _client;
  CmdProgressCallback* _prgscb;

private:
  unsigned long _id;
};


#endif //_SC_SCCMD_H

