; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=aarch64-uknown-uknown -verify-machineinstrs -o - %s | FileCheck %s

declare void @call()

define i1 @cmp_i128_eq(i128 %a, i128 %b) {
; CHECK-LABEL: cmp_i128_eq:
; CHECK:       // %bb.0:
; CHECK-NEXT:    eor x8, x1, x3
; CHECK-NEXT:    eor x9, x0, x2
; CHECK-NEXT:    orr x8, x9, x8
; CHECK-NEXT:    cmp x8, #0
; CHECK-NEXT:    cset w0, eq
; CHECK-NEXT:    ret
    %cmp = icmp eq i128 %a, %b
    ret i1 %cmp
}

define i1 @cmp_i128_ne(i128 %a, i128 %b) {
; CHECK-LABEL: cmp_i128_ne:
; CHECK:       // %bb.0:
; CHECK-NEXT:    eor x8, x1, x3
; CHECK-NEXT:    eor x9, x0, x2
; CHECK-NEXT:    orr x8, x9, x8
; CHECK-NEXT:    cmp x8, #0
; CHECK-NEXT:    cset w0, ne
; CHECK-NEXT:    ret
    %cmp = icmp ne i128 %a, %b
    ret i1 %cmp
}

define i1 @cmp_i128_ugt(i128 %a, i128 %b) {
; CHECK-LABEL: cmp_i128_ugt:
; CHECK:       // %bb.0:
; CHECK-NEXT:    cmp x0, x2
; CHECK-NEXT:    cset w8, hi
; CHECK-NEXT:    cmp x1, x3
; CHECK-NEXT:    cset w9, hi
; CHECK-NEXT:    csel w0, w8, w9, eq
; CHECK-NEXT:    ret
    %cmp = icmp ugt i128 %a, %b
    ret i1 %cmp
}

define i1 @cmp_i128_uge(i128 %a, i128 %b) {
; CHECK-LABEL: cmp_i128_uge:
; CHECK:       // %bb.0:
; CHECK-NEXT:    cmp x0, x2
; CHECK-NEXT:    cset w8, hs
; CHECK-NEXT:    cmp x1, x3
; CHECK-NEXT:    cset w9, hs
; CHECK-NEXT:    csel w0, w8, w9, eq
; CHECK-NEXT:    ret
    %cmp = icmp uge i128 %a, %b
    ret i1 %cmp
}

define i1 @cmp_i128_ult(i128 %a, i128 %b) {
; CHECK-LABEL: cmp_i128_ult:
; CHECK:       // %bb.0:
; CHECK-NEXT:    cmp x0, x2
; CHECK-NEXT:    cset w8, lo
; CHECK-NEXT:    cmp x1, x3
; CHECK-NEXT:    cset w9, lo
; CHECK-NEXT:    csel w0, w8, w9, eq
; CHECK-NEXT:    ret
    %cmp = icmp ult i128 %a, %b
    ret i1 %cmp
}

define i1 @cmp_i128_ule(i128 %a, i128 %b) {
; CHECK-LABEL: cmp_i128_ule:
; CHECK:       // %bb.0:
; CHECK-NEXT:    cmp x0, x2
; CHECK-NEXT:    cset w8, ls
; CHECK-NEXT:    cmp x1, x3
; CHECK-NEXT:    cset w9, ls
; CHECK-NEXT:    csel w0, w8, w9, eq
; CHECK-NEXT:    ret
    %cmp = icmp ule i128 %a, %b
    ret i1 %cmp
}

define i1 @cmp_i128_sgt(i128 %a, i128 %b) {
; CHECK-LABEL: cmp_i128_sgt:
; CHECK:       // %bb.0:
; CHECK-NEXT:    cmp x0, x2
; CHECK-NEXT:    cset w8, hi
; CHECK-NEXT:    cmp x1, x3
; CHECK-NEXT:    cset w9, gt
; CHECK-NEXT:    csel w0, w8, w9, eq
; CHECK-NEXT:    ret
    %cmp = icmp sgt i128 %a, %b
    ret i1 %cmp
}

define i1 @cmp_i128_sge(i128 %a, i128 %b) {
; CHECK-LABEL: cmp_i128_sge:
; CHECK:       // %bb.0:
; CHECK-NEXT:    cmp x0, x2
; CHECK-NEXT:    cset w8, hs
; CHECK-NEXT:    cmp x1, x3
; CHECK-NEXT:    cset w9, ge
; CHECK-NEXT:    csel w0, w8, w9, eq
; CHECK-NEXT:    ret
    %cmp = icmp sge i128 %a, %b
    ret i1 %cmp
}

define i1 @cmp_i128_slt(i128 %a, i128 %b) {
; CHECK-LABEL: cmp_i128_slt:
; CHECK:       // %bb.0:
; CHECK-NEXT:    cmp x0, x2
; CHECK-NEXT:    cset w8, lo
; CHECK-NEXT:    cmp x1, x3
; CHECK-NEXT:    cset w9, lt
; CHECK-NEXT:    csel w0, w8, w9, eq
; CHECK-NEXT:    ret
    %cmp = icmp slt i128 %a, %b
    ret i1 %cmp
}

define i1 @cmp_i128_sle(i128 %a, i128 %b) {
; CHECK-LABEL: cmp_i128_sle:
; CHECK:       // %bb.0:
; CHECK-NEXT:    cmp x0, x2
; CHECK-NEXT:    cset w8, ls
; CHECK-NEXT:    cmp x1, x3
; CHECK-NEXT:    cset w9, le
; CHECK-NEXT:    csel w0, w8, w9, eq
; CHECK-NEXT:    ret
    %cmp = icmp sle i128 %a, %b
    ret i1 %cmp
}

define void @br_on_cmp_i128_eq(i128 %a, i128 %b) nounwind {
; CHECK-LABEL: br_on_cmp_i128_eq:
; CHECK:       // %bb.0:
; CHECK-NEXT:    eor x8, x1, x3
; CHECK-NEXT:    eor x9, x0, x2
; CHECK-NEXT:    orr x8, x9, x8
; CHECK-NEXT:    cbnz x8, .LBB10_2
; CHECK-NEXT:  // %bb.1: // %call
; CHECK-NEXT:    str x30, [sp, #-16]! // 8-byte Folded Spill
; CHECK-NEXT:    bl call
; CHECK-NEXT:    ldr x30, [sp], #16 // 8-byte Folded Reload
; CHECK-NEXT:  .LBB10_2: // %exit
; CHECK-NEXT:    ret
    %cmp = icmp eq i128 %a, %b
    br i1 %cmp, label %call, label %exit
call:
    call void @call()
    br label %exit
exit:
    ret void
}

define void @br_on_cmp_i128_ne(i128 %a, i128 %b) nounwind {
; CHECK-LABEL: br_on_cmp_i128_ne:
; CHECK:       // %bb.0:
; CHECK-NEXT:    eor x8, x1, x3
; CHECK-NEXT:    eor x9, x0, x2
; CHECK-NEXT:    orr x8, x9, x8
; CHECK-NEXT:    cbz x8, .LBB11_2
; CHECK-NEXT:  // %bb.1: // %call
; CHECK-NEXT:    str x30, [sp, #-16]! // 8-byte Folded Spill
; CHECK-NEXT:    bl call
; CHECK-NEXT:    ldr x30, [sp], #16 // 8-byte Folded Reload
; CHECK-NEXT:  .LBB11_2: // %exit
; CHECK-NEXT:    ret
    %cmp = icmp ne i128 %a, %b
    br i1 %cmp, label %call, label %exit
call:
    call void @call()
    br label %exit
exit:
    ret void
}

define void @br_on_cmp_i128_ugt(i128 %a, i128 %b) nounwind {
; CHECK-LABEL: br_on_cmp_i128_ugt:
; CHECK:       // %bb.0:
; CHECK-NEXT:    cmp x0, x2
; CHECK-NEXT:    cset w8, ls
; CHECK-NEXT:    cmp x1, x3
; CHECK-NEXT:    cset w9, ls
; CHECK-NEXT:    csel w8, w8, w9, eq
; CHECK-NEXT:    tbnz w8, #0, .LBB12_2
; CHECK-NEXT:  // %bb.1: // %call
; CHECK-NEXT:    str x30, [sp, #-16]! // 8-byte Folded Spill
; CHECK-NEXT:    bl call
; CHECK-NEXT:    ldr x30, [sp], #16 // 8-byte Folded Reload
; CHECK-NEXT:  .LBB12_2: // %exit
; CHECK-NEXT:    ret
    %cmp = icmp ugt i128 %a, %b
    br i1 %cmp, label %call, label %exit
call:
    call void @call()
    br label %exit
exit:
    ret void
}

define void @br_on_cmp_i128_uge(i128 %a, i128 %b) nounwind {
; CHECK-LABEL: br_on_cmp_i128_uge:
; CHECK:       // %bb.0:
; CHECK-NEXT:    cmp x0, x2
; CHECK-NEXT:    cset w8, lo
; CHECK-NEXT:    cmp x1, x3
; CHECK-NEXT:    cset w9, lo
; CHECK-NEXT:    csel w8, w8, w9, eq
; CHECK-NEXT:    tbnz w8, #0, .LBB13_2
; CHECK-NEXT:  // %bb.1: // %call
; CHECK-NEXT:    str x30, [sp, #-16]! // 8-byte Folded Spill
; CHECK-NEXT:    bl call
; CHECK-NEXT:    ldr x30, [sp], #16 // 8-byte Folded Reload
; CHECK-NEXT:  .LBB13_2: // %exit
; CHECK-NEXT:    ret
    %cmp = icmp uge i128 %a, %b
    br i1 %cmp, label %call, label %exit
call:
    call void @call()
    br label %exit
exit:
    ret void
}

define void @br_on_cmp_i128_ult(i128 %a, i128 %b) nounwind {
; CHECK-LABEL: br_on_cmp_i128_ult:
; CHECK:       // %bb.0:
; CHECK-NEXT:    cmp x0, x2
; CHECK-NEXT:    cset w8, hs
; CHECK-NEXT:    cmp x1, x3
; CHECK-NEXT:    cset w9, hs
; CHECK-NEXT:    csel w8, w8, w9, eq
; CHECK-NEXT:    tbnz w8, #0, .LBB14_2
; CHECK-NEXT:  // %bb.1: // %call
; CHECK-NEXT:    str x30, [sp, #-16]! // 8-byte Folded Spill
; CHECK-NEXT:    bl call
; CHECK-NEXT:    ldr x30, [sp], #16 // 8-byte Folded Reload
; CHECK-NEXT:  .LBB14_2: // %exit
; CHECK-NEXT:    ret
    %cmp = icmp ult i128 %a, %b
    br i1 %cmp, label %call, label %exit
call:
    call void @call()
    br label %exit
exit:
    ret void
}

define void @br_on_cmp_i128_ule(i128 %a, i128 %b) nounwind {
; CHECK-LABEL: br_on_cmp_i128_ule:
; CHECK:       // %bb.0:
; CHECK-NEXT:    cmp x0, x2
; CHECK-NEXT:    cset w8, hi
; CHECK-NEXT:    cmp x1, x3
; CHECK-NEXT:    cset w9, hi
; CHECK-NEXT:    csel w8, w8, w9, eq
; CHECK-NEXT:    tbnz w8, #0, .LBB15_2
; CHECK-NEXT:  // %bb.1: // %call
; CHECK-NEXT:    str x30, [sp, #-16]! // 8-byte Folded Spill
; CHECK-NEXT:    bl call
; CHECK-NEXT:    ldr x30, [sp], #16 // 8-byte Folded Reload
; CHECK-NEXT:  .LBB15_2: // %exit
; CHECK-NEXT:    ret
    %cmp = icmp ule i128 %a, %b
    br i1 %cmp, label %call, label %exit
call:
    call void @call()
    br label %exit
exit:
    ret void
}

define void @br_on_cmp_i128_sgt(i128 %a, i128 %b) nounwind {
; CHECK-LABEL: br_on_cmp_i128_sgt:
; CHECK:       // %bb.0:
; CHECK-NEXT:    cmp x0, x2
; CHECK-NEXT:    cset w8, ls
; CHECK-NEXT:    cmp x1, x3
; CHECK-NEXT:    cset w9, le
; CHECK-NEXT:    csel w8, w8, w9, eq
; CHECK-NEXT:    tbnz w8, #0, .LBB16_2
; CHECK-NEXT:  // %bb.1: // %call
; CHECK-NEXT:    str x30, [sp, #-16]! // 8-byte Folded Spill
; CHECK-NEXT:    bl call
; CHECK-NEXT:    ldr x30, [sp], #16 // 8-byte Folded Reload
; CHECK-NEXT:  .LBB16_2: // %exit
; CHECK-NEXT:    ret
    %cmp = icmp sgt i128 %a, %b
    br i1 %cmp, label %call, label %exit
call:
    call void @call()
    br label %exit
exit:
    ret void
}

define void @br_on_cmp_i128_sge(i128 %a, i128 %b) nounwind {
; CHECK-LABEL: br_on_cmp_i128_sge:
; CHECK:       // %bb.0:
; CHECK-NEXT:    cmp x0, x2
; CHECK-NEXT:    cset w8, lo
; CHECK-NEXT:    cmp x1, x3
; CHECK-NEXT:    cset w9, lt
; CHECK-NEXT:    csel w8, w8, w9, eq
; CHECK-NEXT:    tbnz w8, #0, .LBB17_2
; CHECK-NEXT:  // %bb.1: // %call
; CHECK-NEXT:    str x30, [sp, #-16]! // 8-byte Folded Spill
; CHECK-NEXT:    bl call
; CHECK-NEXT:    ldr x30, [sp], #16 // 8-byte Folded Reload
; CHECK-NEXT:  .LBB17_2: // %exit
; CHECK-NEXT:    ret
    %cmp = icmp sge i128 %a, %b
    br i1 %cmp, label %call, label %exit
call:
    call void @call()
    br label %exit
exit:
    ret void
}

define void @br_on_cmp_i128_slt(i128 %a, i128 %b) nounwind {
; CHECK-LABEL: br_on_cmp_i128_slt:
; CHECK:       // %bb.0:
; CHECK-NEXT:    cmp x0, x2
; CHECK-NEXT:    cset w8, hs
; CHECK-NEXT:    cmp x1, x3
; CHECK-NEXT:    cset w9, ge
; CHECK-NEXT:    csel w8, w8, w9, eq
; CHECK-NEXT:    tbnz w8, #0, .LBB18_2
; CHECK-NEXT:  // %bb.1: // %call
; CHECK-NEXT:    str x30, [sp, #-16]! // 8-byte Folded Spill
; CHECK-NEXT:    bl call
; CHECK-NEXT:    ldr x30, [sp], #16 // 8-byte Folded Reload
; CHECK-NEXT:  .LBB18_2: // %exit
; CHECK-NEXT:    ret
    %cmp = icmp slt i128 %a, %b
    br i1 %cmp, label %call, label %exit
call:
    call void @call()
    br label %exit
exit:
    ret void
}

define void @br_on_cmp_i128_sle(i128 %a, i128 %b) nounwind {
; CHECK-LABEL: br_on_cmp_i128_sle:
; CHECK:       // %bb.0:
; CHECK-NEXT:    cmp x0, x2
; CHECK-NEXT:    cset w8, hi
; CHECK-NEXT:    cmp x1, x3
; CHECK-NEXT:    cset w9, gt
; CHECK-NEXT:    csel w8, w8, w9, eq
; CHECK-NEXT:    tbnz w8, #0, .LBB19_2
; CHECK-NEXT:  // %bb.1: // %call
; CHECK-NEXT:    str x30, [sp, #-16]! // 8-byte Folded Spill
; CHECK-NEXT:    bl call
; CHECK-NEXT:    ldr x30, [sp], #16 // 8-byte Folded Reload
; CHECK-NEXT:  .LBB19_2: // %exit
; CHECK-NEXT:    ret
    %cmp = icmp sle i128 %a, %b
    br i1 %cmp, label %call, label %exit
call:
    call void @call()
    br label %exit
exit:
    ret void
}

