// Copyright (C) 2006-2009 Kent-Andre Mardal and Simula Research Laboratory
//
// This file is part of SyFi.
//
// SyFi is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 2 of the License, or
// (at your option) any later version.
//
// SyFi is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with SyFi. If not, see <http://www.gnu.org/licenses/>.

#ifndef CONTAINERS_IS_INCLUDED
#define CONTAINERS_IS_INCLUDED

#include <string>
#include <vector>
#include <list>
#include <set>
#include <map>

#include <ginac/ginac.h>

namespace SyFi
{

	// container typedefs
	typedef std::pair<GiNaC::symbol, GiNaC::ex>               symexpair;
	typedef std::list< std::pair<GiNaC::symbol, GiNaC::ex> >  symexlist;

	//typedef std::vector<GiNaC::ex>                            exvector;
	typedef std::list<GiNaC::ex>                              exlist;
	typedef std::set<GiNaC::ex, GiNaC::ex_is_less>            exset;
	//typedef std::map<GiNaC::ex, GiNaC::ex, GiNaC::ex_is_less> exmap;
	typedef std::map<GiNaC::ex, int, GiNaC::ex_is_less>       ex_int_map;

}								 // namespace SyFi
#endif
