C-----------------------------------------------------------------------
C
C                        SYRTHES version 3.4
C                        -------------------
C
C     This file is part of the SYRTHES Kernel, element of the
C     thermal code SYRTHES.
C
C     Copyright (C) 1988-2008 EDF S.A., France
C
C     contact: syrthes-support@edf.fr
C
C
C     The SYRTHES Kernel is free software; you can redistribute it
C     and/or modify it under the terms of the GNU General Public License
C     as published by the Free Software Foundation; either version 2 of
C     the License, or (at your option) any later version.
C
C     The SYRTHES Kernel is distributed in the hope that it will be
C     useful, but WITHOUT ANY WARRANTY; without even the implied warranty
C     of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
C     GNU General Public License for more details.
C
C
C     You should have received a copy of the GNU General Public License
C     along with the Code_Saturne Kernel; if not, write to the
C     Free Software Foundation, Inc.,
C     51 Franklin St, Fifth Floor,
C     Boston, MA  02110-1301  USA
C
C-----------------------------------------------------------------------
C                       *****************
                        SUBROUTINE INISF2
C                       *****************
C
C     -------------------------------------------------------------
     *(NDIM,NDIELE,NBCOUF,NELESF,NDMASF,
     * NBRAF,NELRAF,NBICOR,NBMOBS,
     * NBCOUS,NPOINS,NELEMS,NDMATS,NELESS,NDMASS,
     * COORDF,NODESF,NCOUPF,COORAF,NRAPF,
     * NCOUPS,NREFS,COORDS,NODES,NODESS,
     * NODRAF,NCBORS,NCBORF,BARYS,BARYF,
     * NELRAY,NRFRAY,NPOINR,NODRAY,COORAY,
     * NNFRAY,NCFRAY,NCFINF,NCGROF,BARYFR, BARYFF ,
     * ITRAV,IDTRAV,
     * TOTRAI,CALCIU,TRAV1,TRAV2)
C     -------------------------------------------------------------
C
C***********************************************************************
C* SYRTHES 3.4.3                                    COPYRIGHT EDF 2008 *
C***********************************************************************
C AUTEURS : C. PENIGUEL, I. RUPP                                       *
C***********************************************************************
C
C FONCTION :
C ----------
C     INITIALISATIONS POUR LA PRISE EN COMPTE DU COUPLAGE
C     THERMIQUE FLUIDE/SOLIDE 
C
C-----------------------------------------------------------------------
C                             ARGUMENTS
C .___________.____.____.______________________________________________.
C !    NOM    !TYPE!MODE!                   ROLE                       !
C !___________!____!____!______________________________________________!
C !  NDIM     !  E ! D  ! DIMENSION DU PROBLEME (2 OU 3)               !
C !  NDIELE   !  E ! D  ! DIMENSION DES ELTS DU PB (2 OU 3)            !
C !  NPOINF   !  E ! D  ! NOMBRE DE NOEUDS DU MAILLAGE FLUIDE          !
C !  NBCOUF   !  E ! D  ! NOMBRE DE NOEUDS FLUIDES COUPLES             !
C !  NELESF   !  E ! D  ! NOMBRE D'ELTS DU MAILLAGE SURF COUPLE FLUIDE !
C !  NBRAF    !  E ! D  ! NOMBRE DE NOEUDS FLUIDE NON COUPLE AVEC RAYT !
C !  NELRAF   !  E ! D  ! NBRE D'ELTS SURF FLUIDE NON COUPLE AVEC RAYT !
C !  NDMASF   !  E ! D  ! NOMBRE DE NOEUDS DES ELTS FLUIDES SURF       !
C !  NBCOUS   !  E ! D  ! NOMBRE DE NOEUDS SOLIDES COUPLES             !
C !  NPOINS   !  E ! D  ! NOMBRE DE NOEUDS DU MAILLAGE SOLIDE          !
C !  NELEMS   !  E ! D  ! NOMBRE D'ELTS DU MAILLAGE VOL SOLIDE         !
C !  NDMATS   !  E ! D  ! NOMBRE DE NOEUDS DES ELTS VOL SOLIDES        !
C !  NELESS   !  E ! D  ! NOMBRE D'ELTS DU MAILLAGE SURF SOLIDE        !
C !  NDMASS   !  E ! D  ! NOMBRE DE NOEUDS DES ELTS SURF SOLIDES       !
C !  NBICOR   !  E ! D  ! NOMBRE D'INFO SUR LES CORRSPONDANTS (1 ou 2) !
C !  NREFF    ! TE ! R  ! REFERENCES DES NOEUDS FLUIDES                !
C !  COORDF   ! TR ! R  ! COORDONNEES DES NOEUDS DU MAILLAGE FLUIDE    !
C !  NODESF   ! TE ! R  ! TABLEAU DE CONNECTIVITE MAILLAGE SURF FLUIDE !
C !  NCOUPF   ! TE ! R  ! NUMEROS GLOBAUX DES NOEUDS FLUIDES COUPLES   !
C !  NCOUPS   ! TE ! R  ! NUMEROS GLOBAUX DES NOEUDS SOLIDES COUPLES   !
C !  NFCOUS   ! TE ! R  ! NUM DANS NODEUS DES FACES COUPLEES           !
C !  VFRAYS   ! TR ! R  ! VAL DU RAYONNEMENT AUX NOEUDS DE LA FACETTE  !
C !  NREFS    ! TR ! R  ! REFERENCES DES NOEUDS SOLIDES                !
C !  COORDS   ! TR ! R  ! COORDONNEES DES NOEUDS DU MAILLAGE SOLIDE    !
C !  NODES    ! TE ! R  ! TABLEAU DE CONNECTIVITE MAILLAGE SOLIDE      !
C !  NODESS   ! TE ! R  ! TABLEAU DE CONNECTIVITE MAILLAGE SURF SOLIDE !
C !  NODRAF   ! TE ! R  ! CONNECTIVITE NOEUDS FLUIDE NON COUPLE + RAYT !
C !  NCBORS   ! TE ! R  ! NUMERO DE L'ELEMENT FLUIDE CORRESPONDANT     !
C !  NCBORF   ! TE ! R  ! NUMERO DE L'ELEMENT SOLIDE CORRESPONDANT     !
C !  BARYS    ! TR ! R  ! COORD BARY DES CORRESPONDANTS DES NOEUDS     !
C !           !    !    ! SOLIDES DANS LES ELEMENTS FLUIDES            !
C !  BARYF    ! TR ! R  ! COORD BARY DES CORRESPONDANTS DES NOEUDS     !
C !           !    !    ! FLUIDES DANS LES ELEMENTS SOLIDES            !
C !  COORAY   ! TR ! R  ! COORD MAILLAGE EXT RAYONNEMENT               !
C !  ITRAV    ! TE ! A  ! TABLEAUX DE TRAVAIL                          !
C !___________!____!____!______________________________________________!
C ! COMMONS                                                            !
C !___________!____!____!______________________________________________!
C ! /NLOFES/  !    ! D  !                                              !
C ! /NLOFCT/  !    ! D  !                                              !
C ! /OPTCT/   !    ! D  !                                              !
C !___________!____!____!______________________________________________!
C
C     TYPE : E (ENTIER), R (REEL), A (ALPHANUMERIQUE), T (TABLEAU)
C            L (LOGIQUE)   .. ET TYPES COMPOSES (EX : TR TABLEAU REEL)
C     MODE : D (DONNEE NON MODIFIEE), R (RESULTAT), M (DONNEE MODIFIEE)
C            A (AUXILIAIRE MODIFIE)
C-----------------------------------------------------------------------
C     SOUS PROGRAMME APPELANT     :  
C
C     SOUS PROGRAMME(S) APPELE(S) :
C***********************************************************************
C
      IMPLICIT NONE        
C
C***********************************************************************
C     DONNEES EN COMMON 
C **********************************************************************
C
#include "divct.h"
#include "optct.h"
#include "mobil.h"
#include "nlofes.h"
#include "nlofct.h"
#include "fichct.h"
#include "syrth.h"
#include "rayonn.h"
#include "xrefer.h"
C
C **********************************************************************
C
C.. Variables externes
      INTEGER NDIM,NDIELE,NBCOUF,NELESF,NDMASF
      INTEGER NBRAF,NELRAF,NBCOUS,NBICOR,NBMOBS
      INTEGER NPOINS,NELEMS,NDMATS,NELESS,NDMASS
      INTEGER NCOUPF(NBCOUF,2),NRAPF(NBRAF,2)
      INTEGER NODESF(NELESF,NDMASF)
      INTEGER NCOUPS(NBCOUS)
      INTEGER NREFS(NPOINS),NODES(NELEMS,NDMATS)
      INTEGER NODESS(NELESS,NDMASS)
      INTEGER NCBORS(NBCOUS,NBICOR),NCBORF(NBCOUF,NBICOR)
      INTEGER NELRAY,NPOINR,NNFRAY,NODRAY(NELRAY,NDIM)
      INTEGER NODRAF(NELRAF,NDMASF)
      INTEGER NCFINF(NBRAF),NCGROF(NNFRAY,2)
      INTEGER NRFRAY(NELRAY),NCFRAY(NNFRAY)
C
      DOUBLE PRECISION COORDF(NBCOUF,NDIM)
      DOUBLE PRECISION COORAF(NBRAF,NDIM)
      DOUBLE PRECISION COORDS(NPOINS,NDIM)
      DOUBLE PRECISION BARYF(NBCOUF,NDIM),BARYS(NBCOUS,NDIM)
      DOUBLE PRECISION BARYFF(NBRAF,NDIM),BARYFR(NNFRAY,NDIM)
      DOUBLE PRECISION COORAY(NPOINR,NDIM)
      INTEGER IDTRAV,ITRAV(IDTRAV),CALCIU
      DOUBLE PRECISION TOTRAI
      DOUBLE PRECISION TRAV1(NBCOUF),TRAV2(NPOINS)
C
C
C.. Variables internes
      LOGICAL LDEVDI
      PARAMETER(LDEVDI=.FALSE.)
      INTEGER N,INDGLO,I,NBSCAL
      LOGICAL LF
      INTEGER NBRE,IREF(NRFMAX)
      DOUBLE PRECISION T1,T2
C
C
C     1- ECRITURES SUR FICHIERS
C     =========================
C     ITRAV de dimension : NBCOUF
C
      DO I=1,NBCOUF
        ITRAV(I)=0
      ENDDO

      LF = .FALSE.
       
      IF (LGEOMF) THEN
         CALL ECRG1
     &        ( NFGFCT,LF,NDIM,NDIM-1,NBCOUF,NELESF,NDMASF,NDIELE+1,
     &          COORDF,NODESF,ITRAV,ITRAV,ITRAV)
C        Mise a jour du nombre de noeuds sommets
      ENDIF
C     
c???????????? pb car on ne connait pas les references
C         
C     Ecriture de l'entete du fichier resultat  
      IF (LRESUF) THEN
         NBSCAL = 2
         IF (LDEVDI) NBSCAL=NBSCAL+1
         CALL ECRG2E(NBSCAL,NFRFCT,NDIM,NDIM-1,NELESF,NBCOUF) 
      ENDIF
C
C     4- Recherche des correspondants (fluide/solide et inverse)
C     =========================================================
C
      DO 1 N=1,NBCOUS*NBICOR
        NCBORS(N,1) = 0
    1 CONTINUE
C
      DO 2 N=1,NBCOUF*NBICOR
        NCBORF(N,1) = 0
    2 CONTINUE
C
      CALL MOBDIF(NBMOBS,NDIM,NBCOUF,NELESF,NDMASF,NODESF,COORDF,CALCIU)
C
      IF (LCOIN) THEN
C
       IF (LECCOR) THEN
         READ (NFCOCT,*) NBRE
         READ (NFCOCT,*) NCBORF
         READ (NFCOCT,*) NBRE
         READ (NFCOCT,*) NCBORS
       ELSE
        CALL COCOIN (NDIM,NPOINS,NBCOUS,NBCOUF,NBICOR,
     *               COORDS,COORDF,NCBORF,NCBORS,NCOUPS)
       ENDIF
C
       IF (LSTOKC) THEN
         WRITE (NFCOCT,*) NBCOUF*NBICOR
         WRITE (NFCOCT,*) NCBORF
         WRITE (NFCOCT,*) NBCOUS*NBICOR
         WRITE (NFCOCT,*) NCBORS
       ENDIF

      ELSE
C
       IF (LECCOR) THEN
         READ (NFCOCT,*) NBRE
         READ (NFCOCT,*) NCBORF
         READ (NFCOCT,*) NBRE
         READ (NFCOCT,*) NCBORS
         READ (NFCOCT,*) NBRE
         READ (NFCOCT,*) BARYF
         READ (NFCOCT,*) NBRE
         READ (NFCOCT,*) BARYS
       ELSE
C
         IF (NCTHFS.EQ.2) THEN
c           CALL CORFS3 (NDIM,NPOINS,NELEMS,NDMATS,NELESF,NDMASF,
c     *                  NBCOUS,NBCOUF,COORDS,NODES,COORDF,NODESF,
c     *                  BARYF,NCBORF,BARYS,NCBORS,NCOUPS,NBICOR)
            PRINT*,'MODELE COQUE NON DISPONIBLE'
            STOP
         ELSEIF (NDIM .EQ. 2) THEN
           CALL CORFS2 (NDIM,NPOINS,NELESS,NDMASS,NELESF,NDMASF,
     *                  NBCOUS,NBCOUF,COORDS,NODESS,COORDF,NODESF,
     *                  BARYF,NCBORF,BARYS,NCBORS,NCOUPS,NBICOR)
         ELSE
           CALL COROCT (NDIM,NPOINS,NELESS,NDMASS,NELESF,NDMASF,
     *                  NBCOUS,NBCOUF,COORDS,NODESS,COORDF,NODESF,
     *                  BARYF,NCBORF,BARYS,NCBORS,NCOUPS,NBICOR,
     *                  NBLBLA,D2MAXF,DCORMX,TRAV1,TRAV2)
           IF (LDEVDI) THEN
              CALL ECRG2R(TRAV1,NBCOUF,'DIST_AU_SOL ','3',NFRFCT)
              CALL ECRG2R(TRAV2,NPOINS,'DIST_AU_FLUI','3',NFGRCT)
           ENDIF

         ENDIF
C
         IF (LSTOKC) THEN
      	   WRITE (NFCOCT,*) NBCOUF*NBICOR
           WRITE (NFCOCT,*) NCBORF
      	   WRITE (NFCOCT,*) NBCOUS*NBICOR
           WRITE (NFCOCT,*) NCBORS
      	   WRITE (NFCOCT,*) NBCOUF*NDIM
           WRITE (NFCOCT,*) BARYF
      	   WRITE (NFCOCT,*) NBCOUS*NDIM
           WRITE (NFCOCT,*) BARYS
         ENDIF
C
       ENDIF
C
      ENDIF
C
C     5- Recherche des correspondants (fluide/rayt et inverse)
C     =========================================================
      IF (LRAY .AND. NBRAF.GT.0 .AND. NNFRAY.GT.0) THEN
        CALL CPUSYR(T1)
        IF (LLCORA) THEN
          IF (NBRAF.GT.0) THEN
               READ (NFCORA,*) NBRE
               READ (NFCORA,*) NCFINF
               READ (NFCORA,*) NBRE
               READ (NFCORA,*) BARYFF
          ENDIF
          IF (NNFRAY.GT.0) THEN
               READ (NFCORA,*) NBRE
               READ (NFCORA,*) NCGROF
               READ (NFCORA,*) NBRE
               READ (NFCORA,*) BARYFR
          ENDIF
        ELSE
          DO 213 N=1,NRFMAX
           IREF(N) = IRERCF(N) + IRESTF(N)
  213     CONTINUE
          INDGLO = 0
          IF (NDIM.EQ.3) THEN
             CALL CRROCT (NDIM,NDMASF,NBRAF,COORAF,NELRAF,NODRAF,
     *                    NBRAF,NRAPF,NCFINF,BARYFF,
     *                    NDIM,  NPOINR,COORAY,NELRAY,NODRAY,NRFRAY,
     *                    NNFRAY,NCFRAY,NCGROF,BARYFR,
     *                    IREF,NRFMAX,INDGLO,NBLBLR,TRAV1,TRAV2)
          ELSE
             CALL CORAY2 (NDIM,NDMASF,NBRAF,COORAF,NELRAF,NODRAF,
     *                       NBRAF,NRAPF,NCFINF,BARYFF,
     *                       NDIM,  NPOINR,COORAY,NELRAY,NODRAY,NRFRAY,
     *                       NNFRAY,NCFRAY,NCGROF,BARYFR,
     *                       IREF,NRFMAX,INDGLO)
          ENDIF
        ENDIF
C
        IF (LSTORA) THEN
          IF (NBRAF.GT.0)  THEN
               WRITE (NFCORA,*) NBRAF
               WRITE (NFCORA,*) NCFINF
               WRITE (NFCORA,*) NBRAF*NDIM
               WRITE (NFCORA,*) BARYFF
          ENDIF
          IF (NNFRAY.GT.0) THEN
               WRITE (NFCORA,*) NNFRAY*2
               WRITE (NFCORA,*) NCGROF
               WRITE (NFCORA,*) NNFRAY,NDIM
               WRITE (NFCORA,*) BARYFR
          ENDIF
        ENDIF
C
        CALL CPUSYR(T2)
        TOTRAI=TOTRAI+T2-T1
      ENDIF
C
C
C
C--------
C FORMATS
C--------
C
C----
C FIN
C----
C
      END


