C-----------------------------------------------------------------------
C
C                        SYRTHES version 3.4
C                        -------------------
C
C     This file is part of the SYRTHES Kernel, element of the
C     thermal code SYRTHES.
C
C     Copyright (C) 1988-2008 EDF S.A., France
C
C     contact: syrthes-support@edf.fr
C
C
C     The SYRTHES Kernel is free software; you can redistribute it
C     and/or modify it under the terms of the GNU General Public License
C     as published by the Free Software Foundation; either version 2 of
C     the License, or (at your option) any later version.
C
C     The SYRTHES Kernel is distributed in the hope that it will be
C     useful, but WITHOUT ANY WARRANTY; without even the implied warranty
C     of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
C     GNU General Public License for more details.
C
C
C     You should have received a copy of the GNU General Public License
C     along with the Code_Saturne Kernel; if not, write to the
C     Free Software Foundation, Inc.,
C     51 Franklin St, Fifth Floor,
C     Boston, MA  02110-1301  USA
C
C-----------------------------------------------------------------------
C                    **************
                     SUBROUTINE OMV
C                    **************
C
C     -----------------------------------------------------
     *( OP,X,DMAT,XMAT,Y,C,NODES,WCT,
     *  NPOINS,NDMATS,NCOEMA,NDIELE,NELEMS,
     *  NODEPR,NELEPR,NPRIOS,NBPRIO,NBCOPR)
C      ----------------------------------------------------
C***********************************************************************
C* SYRTHES 3.4.3                                    COPYRIGHT EDF 2008 *
C***********************************************************************
C AUTEURS : C. PENIGUEL, I. RUPP                                       *
C***********************************************************************
C                                                                      *
C      FONCTION :                                                      *
C      ---------     OPERATION  MATRICE VECTEUR                        *
C                                                                      *
C                    Suivant la chaine de caractere OP une operation   *
C                    est effectuee, entre les matrices DMAT,MAT et le  *
C                    vecteur Y. Le resultat se trouve dans le          *
C                    vecteur X                                         *
C                                                                      *
C       Soit M la matrice:                                             *
C                                                                      *
C       OP = 'X=MY    '   ---->  X = MY                                *
C                                                                      *
C-----------------------------------------------------------------------
C		    (*)    (*)			ARGUMENTS
C   .___________.______._______________________________________________.
C   !    NOM    ! TYPE !MODE!                    ROLE                  !
C   !___________!______!____!__________________________________________!
C   !   OP      !  A   ! D  ! DEFINITION DU TYPE D'OPERATION           !
C   !   NODES   !  TE  ! D  ! NUMERO DES NOEUDS ( LOCALE --> GLOBALE ) !
C   !   X       !  TR  ! R  ! VECTEUR RESULTAT                         !
C   !   DMAT    !  TR  ! D  ! DIAGONALE DE LA MATRICE M                !
C   !   XMAT    !  TR  ! D  ! TERMES EXTRA DIAGONAUX DE LA MATRICE M   !
C   !   Y       !  TR  ! D  ! VECTEUR A MUTIPLIER PAR LA MATRICE M     !
C   !   C       !  R   ! D  ! CONSTANTE                                !
C   !   WCT     !  TR  ! M  ! TABLEAUX DE TRAVAIL (NELEMS*NDMATS)      !
C   !___________!______!____!__________________________________________!
C (*) TYPE : E (ENTIER), R (REEL), A (ALPHANUMERIQUE), T (TABLEAU)
C     ET TYPES COMPOSES
C (*) MODE : D (DONNEE NON MODIFIEE), R (RESULTAT), M (DONNEE MODIFIEE)
C            A (TABLEAU AUXILIAIRE)
C-----------------------------------------------------------------------
C    SOUS PROGRAMME(S) APPELE(S)    : ????
C                                     ????
C-----------------------------------------------------------------------
C    SOUS PROGRAMME(S) APPELANT(S)  : GRCONJ,
C
C***********************************************************************
C
	IMPLICIT NONE
C
C***********************************************************************
C	DONNEES EN COMMON
C***********************************************************************
C
#include "optct.h"
C
C***********************************************************************
C
C..Variables externes
      INTEGER NPOINS,NELEMS,NDMATS,NCOEMA,NELEPR,NBPRIO,NBCOPR,NDIELE
      CHARACTER*8 OP
      DOUBLE PRECISION DMAT(NPOINS)
      INTEGER NODES(NELEMS,NDMATS)
      DOUBLE PRECISION X(NPOINS),Y(NPOINS)
      DOUBLE PRECISION XMAT(NELEMS,NCOEMA)
      DOUBLE PRECISION WCT(NELEMS,NDMATS)
      INTEGER NODEPR(NELEPR,NDMATS+1),NPRIOS(NBPRIO,1+NBCOPR)

C      
C..Variables locales
      DOUBLE PRECISION C
      DOUBLE PRECISION Y1,Y2,Y3,Y4,Y5,Y6,Y7,Y8,Y9,Y10
      DOUBLE PRECISION XM14,XM16,XM24,XM25,XM35,XM36,XM45,XM46,XM56
      DOUBLE PRECISION XM15,XM17,XM18,XM26,XM29,XM37,XM310
      DOUBLE PRECISION XM48,XM49,XM410,XM57,XM58,XM59
      DOUBLE PRECISION XM67,XM68,XM69,XM610,XM78,XM710
      DOUBLE PRECISION XM89,XM810,XM910
C
C     pour le traitement periodique
      INTEGER I,J,K,NELG,NGC,NELLOG,NLC,NL
C
C***********************************************************************
C
C     1- CAS BIDIMENSIONNEL (triangle)
C     ================================
      IF ( NDIELE .EQ. 2 ) THEN
C   
C         1.1 CAS X = M Y
C         -------------
C 
          IF ( OP(1:8).EQ.'X=MY    ') THEN
C
C
              DO 110 I=1,NPOINS
                  X(I) = DMAT(I)*Y(I)
  110         CONTINUE
C
C                             
              DO 120 I=1,NELEMS
C
                Y1 = Y(NODES(I,1))
                Y2 = Y(NODES(I,2))
                Y3 = Y(NODES(I,3))
                Y4 = Y(NODES(I,4))
                Y5 = Y(NODES(I,5))
                Y6 = Y(NODES(I,6))
C
                XM14 = XMAT(I,1)
                XM16 = XMAT(I,2)
                XM24 = XMAT(I,3)
                XM25 = XMAT(I,4)
                XM35 = XMAT(I,5)
                XM36 = XMAT(I,6)
                XM45 = XMAT(I,7)
                XM46 = XMAT(I,8)
                XM56 = XMAT(I,9)
C
                WCT(I,1) = XM14 * Y4 + XM16 * Y6
                WCT(I,2) = XM24 * Y4 + XM25 * Y5
                WCT(I,3) = XM35 * Y5 + XM36 * Y6
                WCT(I,4) = XM14 * Y1 + XM24 * Y2 + XM45 * Y5 + XM46 * Y6
                WCT(I,5) = XM25 * Y2 + XM35 * Y3 + XM45 * Y4 + XM56 * Y6
                WCT(I,6) = XM16 * Y1 + XM36 * Y3 + XM46 * Y4 + XM56 * Y5
C
  120         CONTINUE
C
C             Assemblage du resultat dans le tableau X
              CALL ASSEMB ( X,NODES,NELEMS,NDIELE,NPOINS,NDMATS,WCT )
C             
C
C         Fin du cas X = MY
          ENDIF        
C      
C     2. CAS TRIDIMENSIONNEL (tetraedre)
C     ==================================
      ELSE
C
C   
C         2.1 CAS X = M Y
C         -------------
C 
          IF ( OP(1:8).EQ.'X=MY    ') THEN
C
C
              DO 210 I=1,NPOINS
                  X(I) = DMAT(I)*Y(I)
  210         CONTINUE
C
C                             
              DO 220 I=1,NELEMS
C
                Y1  = Y(NODES(I,1))
                Y2  = Y(NODES(I,2))
                Y3  = Y(NODES(I,3))
                Y4  = Y(NODES(I,4))
                Y5  = Y(NODES(I,5))
                Y6  = Y(NODES(I,6))
                Y7  = Y(NODES(I,7))
                Y8  = Y(NODES(I,8))
                Y9  = Y(NODES(I,9))
                Y10 = Y(NODES(I,10))
C
                XM15  = XMAT(I,1)
                XM17  = XMAT(I,2)
                XM18  = XMAT(I,3)
                XM25  = XMAT(I,4)
                XM26  = XMAT(I,5)
                XM29  = XMAT(I,6)
                XM36  = XMAT(I,7)
                XM37  = XMAT(I,8)
                XM310 = XMAT(I,9)
                XM48  = XMAT(I,10)
                XM49  = XMAT(I,11)
                XM410 = XMAT(I,12)
                XM56  = XMAT(I,13)
                XM57  = XMAT(I,14)
                XM58  = XMAT(I,15)
                XM59  = XMAT(I,16)
                XM67  = XMAT(I,17)
                XM68  = XMAT(I,18)
                XM69  = XMAT(I,19)
                XM610 = XMAT(I,20)
                XM78  = XMAT(I,21)
                XM710 = XMAT(I,22)
                XM89  = XMAT(I,23)
                XM810 = XMAT(I,24)
                XM910 = XMAT(I,25)
C
                WCT(I,1) = XM15 * Y5 + XM17 * Y7 + XM18 * Y8
                WCT(I,2) = XM25 * Y5 + XM26 * Y6 + XM29 * Y9 
                WCT(I,3) = XM36 * Y6 + XM37 * Y7 + XM310 * Y10 
                WCT(I,4) = XM48 * Y8 + XM49 * Y9 + XM410 * Y10 
                WCT(I,5) = XM15 * Y1 + XM25 * Y2 + XM56 * Y6 + XM57 * Y7
     &                     +XM58 * Y8 + XM59 * Y9 
                WCT(I,6) = XM26 * Y2 + XM36 * Y3 + XM56 * Y5 + XM67 * Y7
     &                     +XM68 * Y8 + XM69 * Y9 + XM610 * Y10
                WCT(I,7) = XM17 * Y1 + XM37 * Y3 + XM57 * Y5 + XM67 * Y6
     &                     +XM78 * Y8 + XM710 * Y10
                WCT(I,8) = XM18 * Y1 + XM48 * Y4 + XM58 * Y5 + XM68 * Y6
     &                     +XM78 * Y7 + XM89 * Y9 + XM810 * Y10
                WCT(I,9) = XM29 * Y2 + XM49 * Y4 + XM59 * Y5 + XM69 * Y6
     &                     +XM89 * Y8 + XM910 * Y10
                WCT(I,10) = XM310 * Y3 + XM410 * Y4 + XM610 * Y6 
     &                     +XM710 * Y7 + XM810 * Y8 + XM910 * Y9
  220         CONTINUE
C
C             Assemblage du resultat dans le tableau X
              CALL ASSEMB ( X,NODES,NELEMS,NDIELE,NPOINS,NDMATS,WCT )
C
C
C         Fin du cas 3D X = MY 
          ENDIF       
C
C     Fin du cas 3D
      ENDIF
C
C     3.- TRAITEMENT DES NOEUDS PERIODIQUES
C     =====================================
C
      IF (NBPRIO .GT. 0) THEN  
C
        NELLOG = NDMATS + 1 
C
        DO 300 K=1,NBCOPR
          DO 310 J=1,NDMATS
            DO 320 I=1,NELEPR
              NELG = NODEPR(I,NELLOG)
              NL   = NODEPR(I,J)
              IF (NL .GT. 0) THEN
                NLC = NPRIOS(NL,K+1)
                IF (NLC .GT. 0) THEN
                  NGC = NPRIOS(NLC,1)
                  X(NGC) = X(NGC) + WCT(NELG,J)
                ENDIF
              ENDIF
  320       CONTINUE
  310     CONTINUE
  300   CONTINUE
C 
      ENDIF
C
C
      END
