from __future__ import print_function



class _MockMeta(type):
    def __getattr__(self, name):
        return _Mock()

class _Mock(object):
    __metaclass__ = _MockMeta
    def __init__(self, *a, **kw):
        object.__init__(self)
        for k,v in kw.iteritems():
            setattr(self, k, v)
    def __getattr__(*a, **kw): return _Mock()
    def __call__(*a, **kw): return _Mock()
    def __getitem__(*a, **kw): return _Mock()
    def __int__(*a, **kw): return 1
    def __contains__(*a, **kw): return False
    def __len__(*a, **kw): return 1
    def __iter__(*a, **kw): return iter([])
    def __exit__(*a, **kw): return False
    def __complex__(*a, **kw): return 1j
    def __float__(*a, **kw): return 1.0
    def __bool__(*a, **kw): return True
    def __nonzero__(*a, **kw): return True
    def __oct__(*a, **kw): return 1
    def __hex__(*a, **kw): return 0x1
    def __long__(*a, **kw): return long(1)
    def __index__(*a, **kw): return 1       


ExceptionColors = _Mock()

exception_colors = _Mock()



class ColorScheme(_Mock):
  pass


class ColorSchemeTable(_Mock):
  pass


class TermColors(_Mock):
  pass
  Black = '\x1b[0;30m'
  BlinkBlack = '\x1b[5;30m'
  BlinkBlue = '\x1b[5;34m'
  BlinkCyan = '\x1b[5;36m'
  BlinkGreen = '\x1b[5;32m'
  BlinkLightGray = '\x1b[5;37m'
  BlinkPurple = '\x1b[5;35m'
  BlinkRed = '\x1b[5;31m'
  BlinkYellow = '\x1b[5;33m'
  Blue = '\x1b[0;34m'
  Brown = '\x1b[0;33m'
  Cyan = '\x1b[0;36m'
  DarkGray = '\x1b[1;30m'
  Green = '\x1b[0;32m'
  LightBlue = '\x1b[1;34m'
  LightCyan = '\x1b[1;36m'
  LightGray = '\x1b[0;37m'
  LightGreen = '\x1b[1;32m'
  LightPurple = '\x1b[1;35m'
  LightRed = '\x1b[1;31m'
  NoColor = ''
  Normal = '\x1b[0m'
  Purple = '\x1b[0;35m'
  Red = '\x1b[0;31m'
  White = '\x1b[1;37m'
  Yellow = '\x1b[1;33m'
  _base = '\x1b[%sm'

