'\"
'\" Generated from file 'nettool\&.man' by tcllib/doctools with format 'nroff'
'\" Copyright (c) 2015 Sean Woods <yoda@etoyoc\&.com>
'\"
.TH "nettool" n 0\&.1 tcllib "nettool"
.\" The -*- nroff -*- definitions below are for supplemental macros used
.\" in Tcl/Tk manual entries.
.\"
.\" .AP type name in/out ?indent?
.\"	Start paragraph describing an argument to a library procedure.
.\"	type is type of argument (int, etc.), in/out is either "in", "out",
.\"	or "in/out" to describe whether procedure reads or modifies arg,
.\"	and indent is equivalent to second arg of .IP (shouldn't ever be
.\"	needed;  use .AS below instead)
.\"
.\" .AS ?type? ?name?
.\"	Give maximum sizes of arguments for setting tab stops.  Type and
.\"	name are examples of largest possible arguments that will be passed
.\"	to .AP later.  If args are omitted, default tab stops are used.
.\"
.\" .BS
.\"	Start box enclosure.  From here until next .BE, everything will be
.\"	enclosed in one large box.
.\"
.\" .BE
.\"	End of box enclosure.
.\"
.\" .CS
.\"	Begin code excerpt.
.\"
.\" .CE
.\"	End code excerpt.
.\"
.\" .VS ?version? ?br?
.\"	Begin vertical sidebar, for use in marking newly-changed parts
.\"	of man pages.  The first argument is ignored and used for recording
.\"	the version when the .VS was added, so that the sidebars can be
.\"	found and removed when they reach a certain age.  If another argument
.\"	is present, then a line break is forced before starting the sidebar.
.\"
.\" .VE
.\"	End of vertical sidebar.
.\"
.\" .DS
.\"	Begin an indented unfilled display.
.\"
.\" .DE
.\"	End of indented unfilled display.
.\"
.\" .SO ?manpage?
.\"	Start of list of standard options for a Tk widget. The manpage
.\"	argument defines where to look up the standard options; if
.\"	omitted, defaults to "options". The options follow on successive
.\"	lines, in three columns separated by tabs.
.\"
.\" .SE
.\"	End of list of standard options for a Tk widget.
.\"
.\" .OP cmdName dbName dbClass
.\"	Start of description of a specific option.  cmdName gives the
.\"	option's name as specified in the class command, dbName gives
.\"	the option's name in the option database, and dbClass gives
.\"	the option's class in the option database.
.\"
.\" .UL arg1 arg2
.\"	Print arg1 underlined, then print arg2 normally.
.\"
.\" .QW arg1 ?arg2?
.\"	Print arg1 in quotes, then arg2 normally (for trailing punctuation).
.\"
.\" .PQ arg1 ?arg2?
.\"	Print an open parenthesis, arg1 in quotes, then arg2 normally
.\"	(for trailing punctuation) and then a closing parenthesis.
.\"
.\"	# Set up traps and other miscellaneous stuff for Tcl/Tk man pages.
.if t .wh -1.3i ^B
.nr ^l \n(.l
.ad b
.\"	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ta \\n()Au \\n()Bu
.ie !"\\$3"" \{\
\&\\$1 \\fI\\$2\\fP (\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
.\"	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
.AS Tcl_Interp Tcl_CreateInterp in/out
.\"	# BS - start boxed text
.\"	# ^y = starting y location
.\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
.\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
.\"	# VS - start vertical sidebar
.\"	# ^Y = starting y location
.\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.if !"\\$2"" .br
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
.\"	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
.\"	# Special macro to handle page bottom:  finish off current
.\"	# box/sidebar if in box/sidebar mode, then invoked standard
.\"	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
.\"	# DS - begin display
.de DS
.RS
.nf
.sp
..
.\"	# DE - end display
.de DE
.fi
.RE
.sp
..
.\"	# SO - start of list of standard options
.de SO
'ie '\\$1'' .ds So \\fBoptions\\fR
'el .ds So \\fB\\$1\\fR
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 5.5c 11c
.ft B
..
.\"	# SE - end of list of standard options
.de SE
.fi
.ft R
.LP
See the \\*(So manual entry for details on the standard options.
..
.\"	# OP - start of full description for a single option
.de OP
.LP
.nf
.ta 4c
Command-Line Name:	\\fB\\$1\\fR
Database Name:	\\fB\\$2\\fR
Database Class:	\\fB\\$3\\fR
.fi
.IP
..
.\"	# CS - begin code excerpt
.de CS
.RS
.nf
.ta .25i .5i .75i 1i
..
.\"	# CE - end code excerpt
.de CE
.fi
.RE
..
.\"	# UL - underline word
.de UL
\\$1\l'|0\(ul'\\$2
..
.\"	# QW - apply quotation marks to word
.de QW
.ie '\\*(lq'"' ``\\$1''\\$2
.\"" fix emacs highlighting
.el \\*(lq\\$1\\*(rq\\$2
..
.\"	# PQ - apply parens and quotation marks to word
.de PQ
.ie '\\*(lq'"' (``\\$1''\\$2)\\$3
.\"" fix emacs highlighting
.el (\\*(lq\\$1\\*(rq\\$2)\\$3
..
.\"	# QR - quoted range
.de QR
.ie '\\*(lq'"' ``\\$1''\\-``\\$2''\\$3
.\"" fix emacs highlighting
.el \\*(lq\\$1\\*(rq\\-\\*(lq\\$2\\*(rq\\$3
..
.\"	# MT - "empty" string
.de MT
.QW ""
..
.BS
.SH NAME
nettool \- Tools for networked applications
.SH SYNOPSIS
package require \fBTcl  8\&.5\fR
.sp
package require \fBnettool  ?0\&.1?\fR
.sp
package require \fBtwapi  3\&.1\fR
.sp
package require \fBip  0\&.1\fR
.sp
package require \fBplatform  0\&.1\fR
.sp
\fB::cat\fR \fIfilename\fR
.sp
\fB::nettool::allocate_port\fR \fIstartingport\fR
.sp
\fB::nettool::arp_table\fR
.sp
\fB::nettool::broadcast_list\fR
.sp
\fB::nettool::claim_port\fR \fIport\fR ?\fIprotocol\fR?
.sp
\fB::nettool::cpuinfo\fR \fIargs\fR
.sp
\fB::nettool::find_port\fR \fIstartingport\fR
.sp
\fB::nettool::hwid_list\fR
.sp
\fB::nettool::ip_list\fR
.sp
\fB::nettool::mac_list\fR
.sp
\fB::nettool::network_list\fR
.sp
\fB::nettool::port_busy\fR \fIport\fR
.sp
\fB::nettool::release_port\fR \fIport\fR ?\fIprotocol\fR?
.sp
\fB::nettool::status\fR
.sp
.BE
.SH DESCRIPTION
.PP
The \fBnettool\fR package consists of a Pure-tcl set of tools
to perform common network functions that would normally require
different packages or calls to exec, in a standard Tcl interface\&.
At present nettool has reference implementations for the following operating
systems: Windows, MacOSX, and Linux (debian)\&.
.SH COMMANDS
.TP
\fB::cat\fR \fIfilename\fR
Dump the contents of a file as a result\&.
.TP
\fB::nettool::allocate_port\fR \fIstartingport\fR
Attempt to allocate \fIstartingport\fR, or, if busy, advance the port
number sequentially until a free port is found, and claim that port\&.
This command uses a built-in database of known ports to avoid returning a
port which is in common use\&. (For example: http (80))
.TP
\fB::nettool::arp_table\fR
Dump the contents of this computer's Address Resolution Protocol (ARP) table\&.
The result will be a Tcl formatted list: \fImacid\fR \fIipaddrlist\fR \&.\&.\&.
.TP
\fB::nettool::broadcast_list\fR
Returns a list of broadcast addresses (suitable for UDP multicast)
that this computer is associated with\&.
.TP
\fB::nettool::claim_port\fR \fIport\fR ?\fIprotocol\fR?
Mark \fIport\fR as busy, optionally as either \fBtcp\fR (default) or \fBudp\fR\&.
.TP
\fB::nettool::cpuinfo\fR \fIargs\fR
If no arguments are given, return a key/value list describing the
CPU of the present machine\&. Included in the matrix is info on the number
of cores/processors that are available for parallel tasking, installed physical
RAM, and processor family\&.
.sp
The exact contents are platform specific\&.
.sp
For Linux, information is drawn from /proc/cpuinfo and /proc/meminfo\&.
.sp
For MacOSX, information is drawn from sysctl
.sp
For Windows, information is draw from TWAPI\&.
.sp
If arguments are given, the result with be a key/value list limited to the
fields requested\&.
.sp
Canonical fields for all platforms:
.RS
.TP
cpus
Count of CPUs/cores/execution units
.TP
speed
Clock speed of processor(s) in Mhz
.TP
memory
Installed RAM (in MB)
.TP
vendor
Manufacturer
.RE
.TP
\fB::nettool::find_port\fR \fIstartingport\fR
Return \fIstartingport\fR if it is available, or the next free port after
\fIstartingport\fR\&. Note: Unlike \fB::nettool::allocate_port\fR, this
command does not claim the port\&.
.sp
This command uses a built-in database of known ports to avoid returning a
port which is in common use\&. (For example: http (80))
.TP
\fB::nettool::hwid_list\fR
Return a list of hardware specific identifiers from this computer\&. The source
and content will vary by platform\&.
.sp
For MacOSX, the motherboard serial number and macids for all network devices is returned\&.
.sp
For Windows, the volume serial number of C and macids for all network devices is returned\&.
.sp
For Linux, macids for all network devices is returned\&.
.TP
\fB::nettool::ip_list\fR
Return a list of IP addresses associated with this computer\&.
.TP
\fB::nettool::mac_list\fR
Return a list of MACIDs for the network cards attached to this machine\&. The MACID of the
primary network card is returned first\&.
.TP
\fB::nettool::network_list\fR
Return a list of networks associated with this computer\&. Networks are formated with
\fBip::nativeToPrefix\fR\&.
.TP
\fB::nettool::port_busy\fR \fIport\fR
Return true if \fIport\fR is claimed, false otherwise\&.
.TP
\fB::nettool::release_port\fR \fIport\fR ?\fIprotocol\fR?
Mark \fIport\fR as not busy, optionally as either \fBtcp\fR (default) or \fBudp\fR\&.
.TP
\fB::nettool::status\fR
Return a key/value list describing the status of the computer\&. The output
is designed to be comparable to the output of \fBtop\fR for all platforms\&.
.sp
Common fields include:
.RS
.TP
load
Processes per processing unit
.TP
memory_total
Total physical RAM (MB)
.TP
memory_free
Total physical RAM unused (MB)
.RE
.PP
.PP
.SH "BUGS, IDEAS, FEEDBACK"
This document, and the package it describes, will undoubtedly contain
bugs and other problems\&.
Please report such in the category \fIodie\fR of the
\fITcllib Trackers\fR [http://core\&.tcl\&.tk/tcllib/reportlist]\&.
Please also report any ideas for enhancements you may have for either
package and/or documentation\&.
.SH KEYWORDS
nettool, odie
.SH CATEGORY
System
.SH COPYRIGHT
.nf
Copyright (c) 2015 Sean Woods <yoda@etoyoc\&.com>

.fi