/*
Copyright (c) 2014-2021 VMware, Inc. All Rights Reserved.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

package types

import (
	"reflect"
	"time"
)

type AbandonHciWorkflow AbandonHciWorkflowRequestType

func init() {
	t["AbandonHciWorkflow"] = reflect.TypeOf((*AbandonHciWorkflow)(nil)).Elem()
}

type AbandonHciWorkflowRequestType struct {
	This ManagedObjectReference `xml:"_this"`
}

func init() {
	t["AbandonHciWorkflowRequestType"] = reflect.TypeOf((*AbandonHciWorkflowRequestType)(nil)).Elem()
}

type AbandonHciWorkflowResponse struct {
}

type AbdicateDomOwnership AbdicateDomOwnershipRequestType

func init() {
	t["AbdicateDomOwnership"] = reflect.TypeOf((*AbdicateDomOwnership)(nil)).Elem()
}

type AbdicateDomOwnershipRequestType struct {
	This  ManagedObjectReference `xml:"_this"`
	Uuids []string               `xml:"uuids"`
}

func init() {
	t["AbdicateDomOwnershipRequestType"] = reflect.TypeOf((*AbdicateDomOwnershipRequestType)(nil)).Elem()
}

type AbdicateDomOwnershipResponse struct {
	Returnval []string `xml:"returnval,omitempty"`
}

type AbortCustomizationRequestType struct {
	This ManagedObjectReference  `xml:"_this"`
	Vm   ManagedObjectReference  `xml:"vm"`
	Auth BaseGuestAuthentication `xml:"auth,typeattr"`
}

func init() {
	t["AbortCustomizationRequestType"] = reflect.TypeOf((*AbortCustomizationRequestType)(nil)).Elem()
}

type AbortCustomization_Task AbortCustomizationRequestType

func init() {
	t["AbortCustomization_Task"] = reflect.TypeOf((*AbortCustomization_Task)(nil)).Elem()
}

type AbortCustomization_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval"`
}

type AboutInfo struct {
	DynamicData

	Name                  string `xml:"name"`
	FullName              string `xml:"fullName"`
	Vendor                string `xml:"vendor"`
	Version               string `xml:"version"`
	PatchLevel            string `xml:"patchLevel,omitempty"`
	Build                 string `xml:"build"`
	LocaleVersion         string `xml:"localeVersion,omitempty"`
	LocaleBuild           string `xml:"localeBuild,omitempty"`
	OsType                string `xml:"osType"`
	ProductLineId         string `xml:"productLineId"`
	ApiType               string `xml:"apiType"`
	ApiVersion            string `xml:"apiVersion"`
	InstanceUuid          string `xml:"instanceUuid,omitempty"`
	LicenseProductName    string `xml:"licenseProductName,omitempty"`
	LicenseProductVersion string `xml:"licenseProductVersion,omitempty"`
}

func init() {
	t["AboutInfo"] = reflect.TypeOf((*AboutInfo)(nil)).Elem()
}

type AccountCreatedEvent struct {
	HostEvent

	Spec  BaseHostAccountSpec `xml:"spec,typeattr"`
	Group bool                `xml:"group"`
}

func init() {
	t["AccountCreatedEvent"] = reflect.TypeOf((*AccountCreatedEvent)(nil)).Elem()
}

type AccountRemovedEvent struct {
	HostEvent

	Account string `xml:"account"`
	Group   bool   `xml:"group"`
}

func init() {
	t["AccountRemovedEvent"] = reflect.TypeOf((*AccountRemovedEvent)(nil)).Elem()
}

type AccountUpdatedEvent struct {
	HostEvent

	Spec            BaseHostAccountSpec `xml:"spec,typeattr"`
	Group           bool                `xml:"group"`
	PrevDescription string              `xml:"prevDescription,omitempty"`
}

func init() {
	t["AccountUpdatedEvent"] = reflect.TypeOf((*AccountUpdatedEvent)(nil)).Elem()
}

type AcknowledgeAlarm AcknowledgeAlarmRequestType

func init() {
	t["AcknowledgeAlarm"] = reflect.TypeOf((*AcknowledgeAlarm)(nil)).Elem()
}

type AcknowledgeAlarmRequestType struct {
	This   ManagedObjectReference `xml:"_this"`
	Alarm  ManagedObjectReference `xml:"alarm"`
	Entity ManagedObjectReference `xml:"entity"`
}

func init() {
	t["AcknowledgeAlarmRequestType"] = reflect.TypeOf((*AcknowledgeAlarmRequestType)(nil)).Elem()
}

type AcknowledgeAlarmResponse struct {
}

type AcquireCimServicesTicket AcquireCimServicesTicketRequestType

func init() {
	t["AcquireCimServicesTicket"] = reflect.TypeOf((*AcquireCimServicesTicket)(nil)).Elem()
}

type AcquireCimServicesTicketRequestType struct {
	This ManagedObjectReference `xml:"_this"`
}

func init() {
	t["AcquireCimServicesTicketRequestType"] = reflect.TypeOf((*AcquireCimServicesTicketRequestType)(nil)).Elem()
}

type AcquireCimServicesTicketResponse struct {
	Returnval HostServiceTicket `xml:"returnval"`
}

type AcquireCloneTicket AcquireCloneTicketRequestType

func init() {
	t["AcquireCloneTicket"] = reflect.TypeOf((*AcquireCloneTicket)(nil)).Elem()
}

type AcquireCloneTicketRequestType struct {
	This ManagedObjectReference `xml:"_this"`
}

func init() {
	t["AcquireCloneTicketRequestType"] = reflect.TypeOf((*AcquireCloneTicketRequestType)(nil)).Elem()
}

type AcquireCloneTicketResponse struct {
	Returnval string `xml:"returnval"`
}

type AcquireCredentialsInGuest AcquireCredentialsInGuestRequestType

func init() {
	t["AcquireCredentialsInGuest"] = reflect.TypeOf((*AcquireCredentialsInGuest)(nil)).Elem()
}

type AcquireCredentialsInGuestRequestType struct {
	This          ManagedObjectReference  `xml:"_this"`
	Vm            ManagedObjectReference  `xml:"vm"`
	RequestedAuth BaseGuestAuthentication `xml:"requestedAuth,typeattr"`
	SessionID     int64                   `xml:"sessionID,omitempty"`
}

func init() {
	t["AcquireCredentialsInGuestRequestType"] = reflect.TypeOf((*AcquireCredentialsInGuestRequestType)(nil)).Elem()
}

type AcquireCredentialsInGuestResponse struct {
	Returnval BaseGuestAuthentication `xml:"returnval,typeattr"`
}

type AcquireGenericServiceTicket AcquireGenericServiceTicketRequestType

func init() {
	t["AcquireGenericServiceTicket"] = reflect.TypeOf((*AcquireGenericServiceTicket)(nil)).Elem()
}

type AcquireGenericServiceTicketRequestType struct {
	This ManagedObjectReference               `xml:"_this"`
	Spec BaseSessionManagerServiceRequestSpec `xml:"spec,typeattr"`
}

func init() {
	t["AcquireGenericServiceTicketRequestType"] = reflect.TypeOf((*AcquireGenericServiceTicketRequestType)(nil)).Elem()
}

type AcquireGenericServiceTicketResponse struct {
	Returnval SessionManagerGenericServiceTicket `xml:"returnval"`
}

type AcquireLocalTicket AcquireLocalTicketRequestType

func init() {
	t["AcquireLocalTicket"] = reflect.TypeOf((*AcquireLocalTicket)(nil)).Elem()
}

type AcquireLocalTicketRequestType struct {
	This     ManagedObjectReference `xml:"_this"`
	UserName string                 `xml:"userName"`
}

func init() {
	t["AcquireLocalTicketRequestType"] = reflect.TypeOf((*AcquireLocalTicketRequestType)(nil)).Elem()
}

type AcquireLocalTicketResponse struct {
	Returnval SessionManagerLocalTicket `xml:"returnval"`
}

type AcquireMksTicket AcquireMksTicketRequestType

func init() {
	t["AcquireMksTicket"] = reflect.TypeOf((*AcquireMksTicket)(nil)).Elem()
}

type AcquireMksTicketRequestType struct {
	This ManagedObjectReference `xml:"_this"`
}

func init() {
	t["AcquireMksTicketRequestType"] = reflect.TypeOf((*AcquireMksTicketRequestType)(nil)).Elem()
}

type AcquireMksTicketResponse struct {
	Returnval VirtualMachineMksTicket `xml:"returnval"`
}

type AcquireTicket AcquireTicketRequestType

func init() {
	t["AcquireTicket"] = reflect.TypeOf((*AcquireTicket)(nil)).Elem()
}

type AcquireTicketRequestType struct {
	This       ManagedObjectReference `xml:"_this"`
	TicketType string                 `xml:"ticketType"`
}

func init() {
	t["AcquireTicketRequestType"] = reflect.TypeOf((*AcquireTicketRequestType)(nil)).Elem()
}

type AcquireTicketResponse struct {
	Returnval VirtualMachineTicket `xml:"returnval"`
}

type Action struct {
	DynamicData
}

func init() {
	t["Action"] = reflect.TypeOf((*Action)(nil)).Elem()
}

type ActiveDirectoryFault struct {
	VimFault

	ErrorCode int32 `xml:"errorCode,omitempty"`
}

func init() {
	t["ActiveDirectoryFault"] = reflect.TypeOf((*ActiveDirectoryFault)(nil)).Elem()
}

type ActiveDirectoryFaultFault BaseActiveDirectoryFault

func init() {
	t["ActiveDirectoryFaultFault"] = reflect.TypeOf((*ActiveDirectoryFaultFault)(nil)).Elem()
}

type ActiveDirectoryProfile struct {
	ApplyProfile
}

func init() {
	t["ActiveDirectoryProfile"] = reflect.TypeOf((*ActiveDirectoryProfile)(nil)).Elem()
}

type ActiveVMsBlockingEVC struct {
	EVCConfigFault

	EvcMode  string                   `xml:"evcMode,omitempty"`
	Host     []ManagedObjectReference `xml:"host,omitempty"`
	HostName []string                 `xml:"hostName,omitempty"`
}

func init() {
	t["ActiveVMsBlockingEVC"] = reflect.TypeOf((*ActiveVMsBlockingEVC)(nil)).Elem()
}

type ActiveVMsBlockingEVCFault ActiveVMsBlockingEVC

func init() {
	t["ActiveVMsBlockingEVCFault"] = reflect.TypeOf((*ActiveVMsBlockingEVCFault)(nil)).Elem()
}

type AddAuthorizationRole AddAuthorizationRoleRequestType

func init() {
	t["AddAuthorizationRole"] = reflect.TypeOf((*AddAuthorizationRole)(nil)).Elem()
}

type AddAuthorizationRoleRequestType struct {
	This    ManagedObjectReference `xml:"_this"`
	Name    string                 `xml:"name"`
	PrivIds []string               `xml:"privIds,omitempty"`
}

func init() {
	t["AddAuthorizationRoleRequestType"] = reflect.TypeOf((*AddAuthorizationRoleRequestType)(nil)).Elem()
}

type AddAuthorizationRoleResponse struct {
	Returnval int32 `xml:"returnval"`
}

type AddCustomFieldDef AddCustomFieldDefRequestType

func init() {
	t["AddCustomFieldDef"] = reflect.TypeOf((*AddCustomFieldDef)(nil)).Elem()
}

type AddCustomFieldDefRequestType struct {
	This           ManagedObjectReference `xml:"_this"`
	Name           string                 `xml:"name"`
	MoType         string                 `xml:"moType,omitempty"`
	FieldDefPolicy *PrivilegePolicyDef    `xml:"fieldDefPolicy,omitempty"`
	FieldPolicy    *PrivilegePolicyDef    `xml:"fieldPolicy,omitempty"`
}

func init() {
	t["AddCustomFieldDefRequestType"] = reflect.TypeOf((*AddCustomFieldDefRequestType)(nil)).Elem()
}

type AddCustomFieldDefResponse struct {
	Returnval CustomFieldDef `xml:"returnval"`
}

type AddDVPortgroupRequestType struct {
	This ManagedObjectReference  `xml:"_this"`
	Spec []DVPortgroupConfigSpec `xml:"spec"`
}

func init() {
	t["AddDVPortgroupRequestType"] = reflect.TypeOf((*AddDVPortgroupRequestType)(nil)).Elem()
}

type AddDVPortgroup_Task AddDVPortgroupRequestType

func init() {
	t["AddDVPortgroup_Task"] = reflect.TypeOf((*AddDVPortgroup_Task)(nil)).Elem()
}

type AddDVPortgroup_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval"`
}

type AddDisksRequestType struct {
	This ManagedObjectReference `xml:"_this"`
	Disk []HostScsiDisk         `xml:"disk"`
}

func init() {
	t["AddDisksRequestType"] = reflect.TypeOf((*AddDisksRequestType)(nil)).Elem()
}

type AddDisks_Task AddDisksRequestType

func init() {
	t["AddDisks_Task"] = reflect.TypeOf((*AddDisks_Task)(nil)).Elem()
}

type AddDisks_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval"`
}

type AddFilter AddFilterRequestType

func init() {
	t["AddFilter"] = reflect.TypeOf((*AddFilter)(nil)).Elem()
}

type AddFilterEntities AddFilterEntitiesRequestType

func init() {
	t["AddFilterEntities"] = reflect.TypeOf((*AddFilterEntities)(nil)).Elem()
}

type AddFilterEntitiesRequestType struct {
	This     ManagedObjectReference   `xml:"_this"`
	FilterId string                   `xml:"filterId"`
	Entities []ManagedObjectReference `xml:"entities,omitempty"`
}

func init() {
	t["AddFilterEntitiesRequestType"] = reflect.TypeOf((*AddFilterEntitiesRequestType)(nil)).Elem()
}

type AddFilterEntitiesResponse struct {
}

type AddFilterRequestType struct {
	This       ManagedObjectReference `xml:"_this"`
	ProviderId string                 `xml:"providerId"`
	FilterName string                 `xml:"filterName"`
	InfoIds    []string               `xml:"infoIds,omitempty"`
}

func init() {
	t["AddFilterRequestType"] = reflect.TypeOf((*AddFilterRequestType)(nil)).Elem()
}

type AddFilterResponse struct {
	Returnval string `xml:"returnval"`
}

type AddGuestAlias AddGuestAliasRequestType

func init() {
	t["AddGuestAlias"] = reflect.TypeOf((*AddGuestAlias)(nil)).Elem()
}

type AddGuestAliasRequestType struct {
	This       ManagedObjectReference  `xml:"_this"`
	Vm         ManagedObjectReference  `xml:"vm"`
	Auth       BaseGuestAuthentication `xml:"auth,typeattr"`
	Username   string                  `xml:"username"`
	MapCert    bool                    `xml:"mapCert"`
	Base64Cert string                  `xml:"base64Cert"`
	AliasInfo  GuestAuthAliasInfo      `xml:"aliasInfo"`
}

func init() {
	t["AddGuestAliasRequestType"] = reflect.TypeOf((*AddGuestAliasRequestType)(nil)).Elem()
}

type AddGuestAliasResponse struct {
}

type AddHostRequestType struct {
	This         ManagedObjectReference  `xml:"_this"`
	Spec         HostConnectSpec         `xml:"spec"`
	AsConnected  bool                    `xml:"asConnected"`
	ResourcePool *ManagedObjectReference `xml:"resourcePool,omitempty"`
	License      string                  `xml:"license,omitempty"`
}

func init() {
	t["AddHostRequestType"] = reflect.TypeOf((*AddHostRequestType)(nil)).Elem()
}

type AddHost_Task AddHostRequestType

func init() {
	t["AddHost_Task"] = reflect.TypeOf((*AddHost_Task)(nil)).Elem()
}

type AddHost_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval"`
}

type AddInternetScsiSendTargets AddInternetScsiSendTargetsRequestType

func init() {
	t["AddInternetScsiSendTargets"] = reflect.TypeOf((*AddInternetScsiSendTargets)(nil)).Elem()
}

type AddInternetScsiSendTargetsRequestType struct {
	This           ManagedObjectReference          `xml:"_this"`
	IScsiHbaDevice string                          `xml:"iScsiHbaDevice"`
	Targets        []HostInternetScsiHbaSendTarget `xml:"targets"`
}

func init() {
	t["AddInternetScsiSendTargetsRequestType"] = reflect.TypeOf((*AddInternetScsiSendTargetsRequestType)(nil)).Elem()
}

type AddInternetScsiSendTargetsResponse struct {
}

type AddInternetScsiStaticTargets AddInternetScsiStaticTargetsRequestType

func init() {
	t["AddInternetScsiStaticTargets"] = reflect.TypeOf((*AddInternetScsiStaticTargets)(nil)).Elem()
}

type AddInternetScsiStaticTargetsRequestType struct {
	This           ManagedObjectReference            `xml:"_this"`
	IScsiHbaDevice string                            `xml:"iScsiHbaDevice"`
	Targets        []HostInternetScsiHbaStaticTarget `xml:"targets"`
}

func init() {
	t["AddInternetScsiStaticTargetsRequestType"] = reflect.TypeOf((*AddInternetScsiStaticTargetsRequestType)(nil)).Elem()
}

type AddInternetScsiStaticTargetsResponse struct {
}

type AddKey AddKeyRequestType

func init() {
	t["AddKey"] = reflect.TypeOf((*AddKey)(nil)).Elem()
}

type AddKeyRequestType struct {
	This ManagedObjectReference `xml:"_this"`
	Key  CryptoKeyPlain         `xml:"key"`
}

func init() {
	t["AddKeyRequestType"] = reflect.TypeOf((*AddKeyRequestType)(nil)).Elem()
}

type AddKeyResponse struct {
}

type AddKeys AddKeysRequestType

func init() {
	t["AddKeys"] = reflect.TypeOf((*AddKeys)(nil)).Elem()
}

type AddKeysRequestType struct {
	This ManagedObjectReference `xml:"_this"`
	Keys []CryptoKeyPlain       `xml:"keys,omitempty"`
}

func init() {
	t["AddKeysRequestType"] = reflect.TypeOf((*AddKeysRequestType)(nil)).Elem()
}

type AddKeysResponse struct {
	Returnval []CryptoKeyResult `xml:"returnval,omitempty"`
}

type AddLicense AddLicenseRequestType

func init() {
	t["AddLicense"] = reflect.TypeOf((*AddLicense)(nil)).Elem()
}

type AddLicenseRequestType struct {
	This       ManagedObjectReference `xml:"_this"`
	LicenseKey string                 `xml:"licenseKey"`
	Labels     []KeyValue             `xml:"labels,omitempty"`
}

func init() {
	t["AddLicenseRequestType"] = reflect.TypeOf((*AddLicenseRequestType)(nil)).Elem()
}

type AddLicenseResponse struct {
	Returnval LicenseManagerLicenseInfo `xml:"returnval"`
}

type AddMonitoredEntities AddMonitoredEntitiesRequestType

func init() {
	t["AddMonitoredEntities"] = reflect.TypeOf((*AddMonitoredEntities)(nil)).Elem()
}

type AddMonitoredEntitiesRequestType struct {
	This       ManagedObjectReference   `xml:"_this"`
	ProviderId string                   `xml:"providerId"`
	Entities   []ManagedObjectReference `xml:"entities,omitempty"`
}

func init() {
	t["AddMonitoredEntitiesRequestType"] = reflect.TypeOf((*AddMonitoredEntitiesRequestType)(nil)).Elem()
}

type AddMonitoredEntitiesResponse struct {
}

type AddNetworkResourcePool AddNetworkResourcePoolRequestType

func init() {
	t["AddNetworkResourcePool"] = reflect.TypeOf((*AddNetworkResourcePool)(nil)).Elem()
}

type AddNetworkResourcePoolRequestType struct {
	This       ManagedObjectReference             `xml:"_this"`
	ConfigSpec []DVSNetworkResourcePoolConfigSpec `xml:"configSpec"`
}

func init() {
	t["AddNetworkResourcePoolRequestType"] = reflect.TypeOf((*AddNetworkResourcePoolRequestType)(nil)).Elem()
}

type AddNetworkResourcePoolResponse struct {
}

type AddPortGroup AddPortGroupRequestType

func init() {
	t["AddPortGroup"] = reflect.TypeOf((*AddPortGroup)(nil)).Elem()
}

type AddPortGroupRequestType struct {
	This    ManagedObjectReference `xml:"_this"`
	Portgrp HostPortGroupSpec      `xml:"portgrp"`
}

func init() {
	t["AddPortGroupRequestType"] = reflect.TypeOf((*AddPortGroupRequestType)(nil)).Elem()
}

type AddPortGroupResponse struct {
}

type AddServiceConsoleVirtualNic AddServiceConsoleVirtualNicRequestType

func init() {
	t["AddServiceConsoleVirtualNic"] = reflect.TypeOf((*AddServiceConsoleVirtualNic)(nil)).Elem()
}

type AddServiceConsoleVirtualNicRequestType struct {
	This      ManagedObjectReference `xml:"_this"`
	Portgroup string                 `xml:"portgroup"`
	Nic       HostVirtualNicSpec     `xml:"nic"`
}

func init() {
	t["AddServiceConsoleVirtualNicRequestType"] = reflect.TypeOf((*AddServiceConsoleVirtualNicRequestType)(nil)).Elem()
}

type AddServiceConsoleVirtualNicResponse struct {
	Returnval string `xml:"returnval"`
}

type AddStandaloneHostRequestType struct {
	This         ManagedObjectReference        `xml:"_this"`
	Spec         HostConnectSpec               `xml:"spec"`
	CompResSpec  BaseComputeResourceConfigSpec `xml:"compResSpec,omitempty,typeattr"`
	AddConnected bool                          `xml:"addConnected"`
	License      string                        `xml:"license,omitempty"`
}

func init() {
	t["AddStandaloneHostRequestType"] = reflect.TypeOf((*AddStandaloneHostRequestType)(nil)).Elem()
}

type AddStandaloneHost_Task AddStandaloneHostRequestType

func init() {
	t["AddStandaloneHost_Task"] = reflect.TypeOf((*AddStandaloneHost_Task)(nil)).Elem()
}

type AddStandaloneHost_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval"`
}

type AddVirtualNic AddVirtualNicRequestType

func init() {
	t["AddVirtualNic"] = reflect.TypeOf((*AddVirtualNic)(nil)).Elem()
}

type AddVirtualNicRequestType struct {
	This      ManagedObjectReference `xml:"_this"`
	Portgroup string                 `xml:"portgroup"`
	Nic       HostVirtualNicSpec     `xml:"nic"`
}

func init() {
	t["AddVirtualNicRequestType"] = reflect.TypeOf((*AddVirtualNicRequestType)(nil)).Elem()
}

type AddVirtualNicResponse struct {
	Returnval string `xml:"returnval"`
}

type AddVirtualSwitch AddVirtualSwitchRequestType

func init() {
	t["AddVirtualSwitch"] = reflect.TypeOf((*AddVirtualSwitch)(nil)).Elem()
}

type AddVirtualSwitchRequestType struct {
	This        ManagedObjectReference `xml:"_this"`
	VswitchName string                 `xml:"vswitchName"`
	Spec        *HostVirtualSwitchSpec `xml:"spec,omitempty"`
}

func init() {
	t["AddVirtualSwitchRequestType"] = reflect.TypeOf((*AddVirtualSwitchRequestType)(nil)).Elem()
}

type AddVirtualSwitchResponse struct {
}

type AdminDisabled struct {
	HostConfigFault
}

func init() {
	t["AdminDisabled"] = reflect.TypeOf((*AdminDisabled)(nil)).Elem()
}

type AdminDisabledFault AdminDisabled

func init() {
	t["AdminDisabledFault"] = reflect.TypeOf((*AdminDisabledFault)(nil)).Elem()
}

type AdminNotDisabled struct {
	HostConfigFault
}

func init() {
	t["AdminNotDisabled"] = reflect.TypeOf((*AdminNotDisabled)(nil)).Elem()
}

type AdminNotDisabledFault AdminNotDisabled

func init() {
	t["AdminNotDisabledFault"] = reflect.TypeOf((*AdminNotDisabledFault)(nil)).Elem()
}

type AdminPasswordNotChangedEvent struct {
	HostEvent
}

func init() {
	t["AdminPasswordNotChangedEvent"] = reflect.TypeOf((*AdminPasswordNotChangedEvent)(nil)).Elem()
}

type AffinityConfigured struct {
	MigrationFault

	ConfiguredAffinity []string `xml:"configuredAffinity"`
}

func init() {
	t["AffinityConfigured"] = reflect.TypeOf((*AffinityConfigured)(nil)).Elem()
}

type AffinityConfiguredFault AffinityConfigured

func init() {
	t["AffinityConfiguredFault"] = reflect.TypeOf((*AffinityConfiguredFault)(nil)).Elem()
}

type AfterStartupTaskScheduler struct {
	TaskScheduler

	Minute int32 `xml:"minute"`
}

func init() {
	t["AfterStartupTaskScheduler"] = reflect.TypeOf((*AfterStartupTaskScheduler)(nil)).Elem()
}

type AgentInstallFailed struct {
	HostConnectFault

	Reason          string `xml:"reason,omitempty"`
	StatusCode      int32  `xml:"statusCode,omitempty"`
	InstallerOutput string `xml:"installerOutput,omitempty"`
}

func init() {
	t["AgentInstallFailed"] = reflect.TypeOf((*AgentInstallFailed)(nil)).Elem()
}

type AgentInstallFailedFault AgentInstallFailed

func init() {
	t["AgentInstallFailedFault"] = reflect.TypeOf((*AgentInstallFailedFault)(nil)).Elem()
}

type AlarmAcknowledgedEvent struct {
	AlarmEvent

	Source ManagedEntityEventArgument `xml:"source"`
	Entity ManagedEntityEventArgument `xml:"entity"`
}

func init() {
	t["AlarmAcknowledgedEvent"] = reflect.TypeOf((*AlarmAcknowledgedEvent)(nil)).Elem()
}

type AlarmAction struct {
	DynamicData
}

func init() {
	t["AlarmAction"] = reflect.TypeOf((*AlarmAction)(nil)).Elem()
}

type AlarmActionTriggeredEvent struct {
	AlarmEvent

	Source ManagedEntityEventArgument `xml:"source"`
	Entity ManagedEntityEventArgument `xml:"entity"`
}

func init() {
	t["AlarmActionTriggeredEvent"] = reflect.TypeOf((*AlarmActionTriggeredEvent)(nil)).Elem()
}

type AlarmClearedEvent struct {
	AlarmEvent

	Source ManagedEntityEventArgument `xml:"source"`
	Entity ManagedEntityEventArgument `xml:"entity"`
	From   string                     `xml:"from"`
}

func init() {
	t["AlarmClearedEvent"] = reflect.TypeOf((*AlarmClearedEvent)(nil)).Elem()
}

type AlarmCreatedEvent struct {
	AlarmEvent

	Entity ManagedEntityEventArgument `xml:"entity"`
}

func init() {
	t["AlarmCreatedEvent"] = reflect.TypeOf((*AlarmCreatedEvent)(nil)).Elem()
}

type AlarmDescription struct {
	DynamicData

	Expr                               []BaseTypeDescription    `xml:"expr,typeattr"`
	StateOperator                      []BaseElementDescription `xml:"stateOperator,typeattr"`
	MetricOperator                     []BaseElementDescription `xml:"metricOperator,typeattr"`
	HostSystemConnectionState          []BaseElementDescription `xml:"hostSystemConnectionState,typeattr"`
	VirtualMachinePowerState           []BaseElementDescription `xml:"virtualMachinePowerState,typeattr"`
	DatastoreConnectionState           []BaseElementDescription `xml:"datastoreConnectionState,omitempty,typeattr"`
	HostSystemPowerState               []BaseElementDescription `xml:"hostSystemPowerState,omitempty,typeattr"`
	VirtualMachineGuestHeartbeatStatus []BaseElementDescription `xml:"virtualMachineGuestHeartbeatStatus,omitempty,typeattr"`
	EntityStatus                       []BaseElementDescription `xml:"entityStatus,typeattr"`
	Action                             []BaseTypeDescription    `xml:"action,typeattr"`
}

func init() {
	t["AlarmDescription"] = reflect.TypeOf((*AlarmDescription)(nil)).Elem()
}

type AlarmEmailCompletedEvent struct {
	AlarmEvent

	Entity ManagedEntityEventArgument `xml:"entity"`
	To     string                     `xml:"to"`
}

func init() {
	t["AlarmEmailCompletedEvent"] = reflect.TypeOf((*AlarmEmailCompletedEvent)(nil)).Elem()
}

type AlarmEmailFailedEvent struct {
	AlarmEvent

	Entity ManagedEntityEventArgument `xml:"entity"`
	To     string                     `xml:"to"`
	Reason LocalizedMethodFault       `xml:"reason"`
}

func init() {
	t["AlarmEmailFailedEvent"] = reflect.TypeOf((*AlarmEmailFailedEvent)(nil)).Elem()
}

type AlarmEvent struct {
	Event

	Alarm AlarmEventArgument `xml:"alarm"`
}

func init() {
	t["AlarmEvent"] = reflect.TypeOf((*AlarmEvent)(nil)).Elem()
}

type AlarmEventArgument struct {
	EntityEventArgument

	Alarm ManagedObjectReference `xml:"alarm"`
}

func init() {
	t["AlarmEventArgument"] = reflect.TypeOf((*AlarmEventArgument)(nil)).Elem()
}

type AlarmExpression struct {
	DynamicData
}

func init() {
	t["AlarmExpression"] = reflect.TypeOf((*AlarmExpression)(nil)).Elem()
}

type AlarmFilterSpec struct {
	DynamicData

	Status      []ManagedEntityStatus `xml:"status,omitempty"`
	TypeEntity  string                `xml:"typeEntity,omitempty"`
	TypeTrigger string                `xml:"typeTrigger,omitempty"`
}

func init() {
	t["AlarmFilterSpec"] = reflect.TypeOf((*AlarmFilterSpec)(nil)).Elem()
}

type AlarmInfo struct {
	AlarmSpec

	Key              string                 `xml:"key"`
	Alarm            ManagedObjectReference `xml:"alarm"`
	Entity           ManagedObjectReference `xml:"entity"`
	LastModifiedTime time.Time              `xml:"lastModifiedTime"`
	LastModifiedUser string                 `xml:"lastModifiedUser"`
	CreationEventId  int32                  `xml:"creationEventId"`
}

func init() {
	t["AlarmInfo"] = reflect.TypeOf((*AlarmInfo)(nil)).Elem()
}

type AlarmReconfiguredEvent struct {
	AlarmEvent

	Entity        ManagedEntityEventArgument `xml:"entity"`
	ConfigChanges *ChangesInfoEventArgument  `xml:"configChanges,omitempty"`
}

func init() {
	t["AlarmReconfiguredEvent"] = reflect.TypeOf((*AlarmReconfiguredEvent)(nil)).Elem()
}

type AlarmRemovedEvent struct {
	AlarmEvent

	Entity ManagedEntityEventArgument `xml:"entity"`
}

func init() {
	t["AlarmRemovedEvent"] = reflect.TypeOf((*AlarmRemovedEvent)(nil)).Elem()
}

type AlarmScriptCompleteEvent struct {
	AlarmEvent

	Entity ManagedEntityEventArgument `xml:"entity"`
	Script string                     `xml:"script"`
}

func init() {
	t["AlarmScriptCompleteEvent"] = reflect.TypeOf((*AlarmScriptCompleteEvent)(nil)).Elem()
}

type AlarmScriptFailedEvent struct {
	AlarmEvent

	Entity ManagedEntityEventArgument `xml:"entity"`
	Script string                     `xml:"script"`
	Reason LocalizedMethodFault       `xml:"reason"`
}

func init() {
	t["AlarmScriptFailedEvent"] = reflect.TypeOf((*AlarmScriptFailedEvent)(nil)).Elem()
}

type AlarmSetting struct {
	DynamicData

	ToleranceRange     int32 `xml:"toleranceRange"`
	ReportingFrequency int32 `xml:"reportingFrequency"`
}

func init() {
	t["AlarmSetting"] = reflect.TypeOf((*AlarmSetting)(nil)).Elem()
}

type AlarmSnmpCompletedEvent struct {
	AlarmEvent

	Entity ManagedEntityEventArgument `xml:"entity"`
}

func init() {
	t["AlarmSnmpCompletedEvent"] = reflect.TypeOf((*AlarmSnmpCompletedEvent)(nil)).Elem()
}

type AlarmSnmpFailedEvent struct {
	AlarmEvent

	Entity ManagedEntityEventArgument `xml:"entity"`
	Reason LocalizedMethodFault       `xml:"reason"`
}

func init() {
	t["AlarmSnmpFailedEvent"] = reflect.TypeOf((*AlarmSnmpFailedEvent)(nil)).Elem()
}

type AlarmSpec struct {
	DynamicData

	Name            string              `xml:"name"`
	SystemName      string              `xml:"systemName,omitempty"`
	Description     string              `xml:"description"`
	Enabled         bool                `xml:"enabled"`
	Expression      BaseAlarmExpression `xml:"expression,typeattr"`
	Action          BaseAlarmAction     `xml:"action,omitempty,typeattr"`
	ActionFrequency int32               `xml:"actionFrequency,omitempty"`
	Setting         *AlarmSetting       `xml:"setting,omitempty"`
}

func init() {
	t["AlarmSpec"] = reflect.TypeOf((*AlarmSpec)(nil)).Elem()
}

type AlarmState struct {
	DynamicData

	Key                string                 `xml:"key"`
	Entity             ManagedObjectReference `xml:"entity"`
	Alarm              ManagedObjectReference `xml:"alarm"`
	OverallStatus      ManagedEntityStatus    `xml:"overallStatus"`
	Time               time.Time              `xml:"time"`
	Acknowledged       *bool                  `xml:"acknowledged"`
	AcknowledgedByUser string                 `xml:"acknowledgedByUser,omitempty"`
	AcknowledgedTime   *time.Time             `xml:"acknowledgedTime"`
	EventKey           int32                  `xml:"eventKey,omitempty"`
	Disabled           *bool                  `xml:"disabled"`
}

func init() {
	t["AlarmState"] = reflect.TypeOf((*AlarmState)(nil)).Elem()
}

type AlarmStatusChangedEvent struct {
	AlarmEvent

	Source ManagedEntityEventArgument `xml:"source"`
	Entity ManagedEntityEventArgument `xml:"entity"`
	From   string                     `xml:"from"`
	To     string                     `xml:"to"`
}

func init() {
	t["AlarmStatusChangedEvent"] = reflect.TypeOf((*AlarmStatusChangedEvent)(nil)).Elem()
}

type AlarmTriggeringAction struct {
	AlarmAction

	Action          BaseAction                            `xml:"action,typeattr"`
	TransitionSpecs []AlarmTriggeringActionTransitionSpec `xml:"transitionSpecs,omitempty"`
	Green2yellow    bool                                  `xml:"green2yellow"`
	Yellow2red      bool                                  `xml:"yellow2red"`
	Red2yellow      bool                                  `xml:"red2yellow"`
	Yellow2green    bool                                  `xml:"yellow2green"`
}

func init() {
	t["AlarmTriggeringAction"] = reflect.TypeOf((*AlarmTriggeringAction)(nil)).Elem()
}

type AlarmTriggeringActionTransitionSpec struct {
	DynamicData

	StartState ManagedEntityStatus `xml:"startState"`
	FinalState ManagedEntityStatus `xml:"finalState"`
	Repeats    bool                `xml:"repeats"`
}

func init() {
	t["AlarmTriggeringActionTransitionSpec"] = reflect.TypeOf((*AlarmTriggeringActionTransitionSpec)(nil)).Elem()
}

type AllVirtualMachinesLicensedEvent struct {
	LicenseEvent
}

func init() {
	t["AllVirtualMachinesLicensedEvent"] = reflect.TypeOf((*AllVirtualMachinesLicensedEvent)(nil)).Elem()
}

type AllocateIpv4Address AllocateIpv4AddressRequestType

func init() {
	t["AllocateIpv4Address"] = reflect.TypeOf((*AllocateIpv4Address)(nil)).Elem()
}

type AllocateIpv4AddressRequestType struct {
	This         ManagedObjectReference `xml:"_this"`
	Dc           ManagedObjectReference `xml:"dc"`
	PoolId       int32                  `xml:"poolId"`
	AllocationId string                 `xml:"allocationId"`
}

func init() {
	t["AllocateIpv4AddressRequestType"] = reflect.TypeOf((*AllocateIpv4AddressRequestType)(nil)).Elem()
}

type AllocateIpv4AddressResponse struct {
	Returnval string `xml:"returnval"`
}

type AllocateIpv6Address AllocateIpv6AddressRequestType

func init() {
	t["AllocateIpv6Address"] = reflect.TypeOf((*AllocateIpv6Address)(nil)).Elem()
}

type AllocateIpv6AddressRequestType struct {
	This         ManagedObjectReference `xml:"_this"`
	Dc           ManagedObjectReference `xml:"dc"`
	PoolId       int32                  `xml:"poolId"`
	AllocationId string                 `xml:"allocationId"`
}

func init() {
	t["AllocateIpv6AddressRequestType"] = reflect.TypeOf((*AllocateIpv6AddressRequestType)(nil)).Elem()
}

type AllocateIpv6AddressResponse struct {
	Returnval string `xml:"returnval"`
}

type AlreadyAuthenticatedSessionEvent struct {
	SessionEvent
}

func init() {
	t["AlreadyAuthenticatedSessionEvent"] = reflect.TypeOf((*AlreadyAuthenticatedSessionEvent)(nil)).Elem()
}

type AlreadyBeingManaged struct {
	HostConnectFault

	IpAddress string `xml:"ipAddress"`
}

func init() {
	t["AlreadyBeingManaged"] = reflect.TypeOf((*AlreadyBeingManaged)(nil)).Elem()
}

type AlreadyBeingManagedFault AlreadyBeingManaged

func init() {
	t["AlreadyBeingManagedFault"] = reflect.TypeOf((*AlreadyBeingManagedFault)(nil)).Elem()
}

type AlreadyConnected struct {
	HostConnectFault

	Name string `xml:"name"`
}

func init() {
	t["AlreadyConnected"] = reflect.TypeOf((*AlreadyConnected)(nil)).Elem()
}

type AlreadyConnectedFault AlreadyConnected

func init() {
	t["AlreadyConnectedFault"] = reflect.TypeOf((*AlreadyConnectedFault)(nil)).Elem()
}

type AlreadyExists struct {
	VimFault

	Name string `xml:"name,omitempty"`
}

func init() {
	t["AlreadyExists"] = reflect.TypeOf((*AlreadyExists)(nil)).Elem()
}

type AlreadyExistsFault AlreadyExists

func init() {
	t["AlreadyExistsFault"] = reflect.TypeOf((*AlreadyExistsFault)(nil)).Elem()
}

type AlreadyUpgraded struct {
	VimFault
}

func init() {
	t["AlreadyUpgraded"] = reflect.TypeOf((*AlreadyUpgraded)(nil)).Elem()
}

type AlreadyUpgradedFault AlreadyUpgraded

func init() {
	t["AlreadyUpgradedFault"] = reflect.TypeOf((*AlreadyUpgradedFault)(nil)).Elem()
}

type AndAlarmExpression struct {
	AlarmExpression

	Expression []BaseAlarmExpression `xml:"expression,typeattr"`
}

func init() {
	t["AndAlarmExpression"] = reflect.TypeOf((*AndAlarmExpression)(nil)).Elem()
}

type AnswerFile struct {
	DynamicData

	UserInput    []ProfileDeferredPolicyOptionParameter `xml:"userInput,omitempty"`
	CreatedTime  time.Time                              `xml:"createdTime"`
	ModifiedTime time.Time                              `xml:"modifiedTime"`
}

func init() {
	t["AnswerFile"] = reflect.TypeOf((*AnswerFile)(nil)).Elem()
}

type AnswerFileCreateSpec struct {
	DynamicData

	Validating *bool `xml:"validating"`
}

func init() {
	t["AnswerFileCreateSpec"] = reflect.TypeOf((*AnswerFileCreateSpec)(nil)).Elem()
}

type AnswerFileOptionsCreateSpec struct {
	AnswerFileCreateSpec

	UserInput []ProfileDeferredPolicyOptionParameter `xml:"userInput,omitempty"`
}

func init() {
	t["AnswerFileOptionsCreateSpec"] = reflect.TypeOf((*AnswerFileOptionsCreateSpec)(nil)).Elem()
}

type AnswerFileSerializedCreateSpec struct {
	AnswerFileCreateSpec

	AnswerFileConfigString string `xml:"answerFileConfigString"`
}

func init() {
	t["AnswerFileSerializedCreateSpec"] = reflect.TypeOf((*AnswerFileSerializedCreateSpec)(nil)).Elem()
}

type AnswerFileStatusError struct {
	DynamicData

	UserInputPath ProfilePropertyPath `xml:"userInputPath"`
	ErrMsg        LocalizableMessage  `xml:"errMsg"`
}

func init() {
	t["AnswerFileStatusError"] = reflect.TypeOf((*AnswerFileStatusError)(nil)).Elem()
}

type AnswerFileStatusResult struct {
	DynamicData

	CheckedTime time.Time               `xml:"checkedTime"`
	Host        ManagedObjectReference  `xml:"host"`
	Status      string                  `xml:"status"`
	Error       []AnswerFileStatusError `xml:"error,omitempty"`
}

func init() {
	t["AnswerFileStatusResult"] = reflect.TypeOf((*AnswerFileStatusResult)(nil)).Elem()
}

type AnswerFileUpdateFailed struct {
	VimFault

	Failure []AnswerFileUpdateFailure `xml:"failure"`
}

func init() {
	t["AnswerFileUpdateFailed"] = reflect.TypeOf((*AnswerFileUpdateFailed)(nil)).Elem()
}

type AnswerFileUpdateFailedFault AnswerFileUpdateFailed

func init() {
	t["AnswerFileUpdateFailedFault"] = reflect.TypeOf((*AnswerFileUpdateFailedFault)(nil)).Elem()
}

type AnswerFileUpdateFailure struct {
	DynamicData

	UserInputPath ProfilePropertyPath `xml:"userInputPath"`
	ErrMsg        LocalizableMessage  `xml:"errMsg"`
}

func init() {
	t["AnswerFileUpdateFailure"] = reflect.TypeOf((*AnswerFileUpdateFailure)(nil)).Elem()
}

type AnswerVM AnswerVMRequestType

func init() {
	t["AnswerVM"] = reflect.TypeOf((*AnswerVM)(nil)).Elem()
}

type AnswerVMRequestType struct {
	This         ManagedObjectReference `xml:"_this"`
	QuestionId   string                 `xml:"questionId"`
	AnswerChoice string                 `xml:"answerChoice"`
}

func init() {
	t["AnswerVMRequestType"] = reflect.TypeOf((*AnswerVMRequestType)(nil)).Elem()
}

type AnswerVMResponse struct {
}

type ApplicationQuiesceFault struct {
	SnapshotFault
}

func init() {
	t["ApplicationQuiesceFault"] = reflect.TypeOf((*ApplicationQuiesceFault)(nil)).Elem()
}

type ApplicationQuiesceFaultFault ApplicationQuiesceFault

func init() {
	t["ApplicationQuiesceFaultFault"] = reflect.TypeOf((*ApplicationQuiesceFaultFault)(nil)).Elem()
}

type ApplyEntitiesConfigRequestType struct {
	This             ManagedObjectReference              `xml:"_this"`
	ApplyConfigSpecs []ApplyHostProfileConfigurationSpec `xml:"applyConfigSpecs,omitempty"`
}

func init() {
	t["ApplyEntitiesConfigRequestType"] = reflect.TypeOf((*ApplyEntitiesConfigRequestType)(nil)).Elem()
}

type ApplyEntitiesConfig_Task ApplyEntitiesConfigRequestType

func init() {
	t["ApplyEntitiesConfig_Task"] = reflect.TypeOf((*ApplyEntitiesConfig_Task)(nil)).Elem()
}

type ApplyEntitiesConfig_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval"`
}

type ApplyEvcModeVMRequestType struct {
	This          ManagedObjectReference `xml:"_this"`
	Mask          []HostFeatureMask      `xml:"mask,omitempty"`
	CompleteMasks *bool                  `xml:"completeMasks"`
}

func init() {
	t["ApplyEvcModeVMRequestType"] = reflect.TypeOf((*ApplyEvcModeVMRequestType)(nil)).Elem()
}

type ApplyEvcModeVM_Task ApplyEvcModeVMRequestType

func init() {
	t["ApplyEvcModeVM_Task"] = reflect.TypeOf((*ApplyEvcModeVM_Task)(nil)).Elem()
}

type ApplyEvcModeVM_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval"`
}

type ApplyHostConfigRequestType struct {
	This       ManagedObjectReference                 `xml:"_this"`
	Host       ManagedObjectReference                 `xml:"host"`
	ConfigSpec HostConfigSpec                         `xml:"configSpec"`
	UserInput  []ProfileDeferredPolicyOptionParameter `xml:"userInput,omitempty"`
}

func init() {
	t["ApplyHostConfigRequestType"] = reflect.TypeOf((*ApplyHostConfigRequestType)(nil)).Elem()
}

type ApplyHostConfig_Task ApplyHostConfigRequestType

func init() {
	t["ApplyHostConfig_Task"] = reflect.TypeOf((*ApplyHostConfig_Task)(nil)).Elem()
}

type ApplyHostConfig_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval"`
}

type ApplyHostProfileConfigurationResult struct {
	DynamicData

	StartTime    time.Time              `xml:"startTime"`
	CompleteTime time.Time              `xml:"completeTime"`
	Host         ManagedObjectReference `xml:"host"`
	Status       string                 `xml:"status"`
	Errors       []LocalizedMethodFault `xml:"errors,omitempty"`
}

func init() {
	t["ApplyHostProfileConfigurationResult"] = reflect.TypeOf((*ApplyHostProfileConfigurationResult)(nil)).Elem()
}

type ApplyHostProfileConfigurationSpec struct {
	ProfileExecuteResult

	Host                ManagedObjectReference `xml:"host"`
	TaskListRequirement []string               `xml:"taskListRequirement,omitempty"`
	TaskDescription     []LocalizableMessage   `xml:"taskDescription,omitempty"`
	RebootStateless     *bool                  `xml:"rebootStateless"`
	RebootHost          *bool                  `xml:"rebootHost"`
	FaultData           *LocalizedMethodFault  `xml:"faultData,omitempty"`
}

func init() {
	t["ApplyHostProfileConfigurationSpec"] = reflect.TypeOf((*ApplyHostProfileConfigurationSpec)(nil)).Elem()
}

type ApplyProfile struct {
	DynamicData

	Enabled          bool                          `xml:"enabled"`
	Policy           []ProfilePolicy               `xml:"policy,omitempty"`
	ProfileTypeName  string                        `xml:"profileTypeName,omitempty"`
	ProfileVersion   string                        `xml:"profileVersion,omitempty"`
	Property         []ProfileApplyProfileProperty `xml:"property,omitempty"`
	Favorite         *bool                         `xml:"favorite"`
	ToBeMerged       *bool                         `xml:"toBeMerged"`
	ToReplaceWith    *bool                         `xml:"toReplaceWith"`
	ToBeDeleted      *bool                         `xml:"toBeDeleted"`
	CopyEnableStatus *bool                         `xml:"copyEnableStatus"`
	Hidden           *bool                         `xml:"hidden"`
}

func init() {
	t["ApplyProfile"] = reflect.TypeOf((*ApplyProfile)(nil)).Elem()
}

type ApplyRecommendation ApplyRecommendationRequestType

func init() {
	t["ApplyRecommendation"] = reflect.TypeOf((*ApplyRecommendation)(nil)).Elem()
}

type ApplyRecommendationRequestType struct {
	This ManagedObjectReference `xml:"_this"`
	Key  string                 `xml:"key"`
}

func init() {
	t["ApplyRecommendationRequestType"] = reflect.TypeOf((*ApplyRecommendationRequestType)(nil)).Elem()
}

type ApplyRecommendationResponse struct {
}

type ApplyStorageDrsRecommendationRequestType struct {
	This ManagedObjectReference `xml:"_this"`
	Key  []string               `xml:"key"`
}

func init() {
	t["ApplyStorageDrsRecommendationRequestType"] = reflect.TypeOf((*ApplyStorageDrsRecommendationRequestType)(nil)).Elem()
}

type ApplyStorageDrsRecommendationToPodRequestType struct {
	This ManagedObjectReference `xml:"_this"`
	Pod  ManagedObjectReference `xml:"pod"`
	Key  string                 `xml:"key"`
}

func init() {
	t["ApplyStorageDrsRecommendationToPodRequestType"] = reflect.TypeOf((*ApplyStorageDrsRecommendationToPodRequestType)(nil)).Elem()
}

type ApplyStorageDrsRecommendationToPod_Task ApplyStorageDrsRecommendationToPodRequestType

func init() {
	t["ApplyStorageDrsRecommendationToPod_Task"] = reflect.TypeOf((*ApplyStorageDrsRecommendationToPod_Task)(nil)).Elem()
}

type ApplyStorageDrsRecommendationToPod_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval"`
}

type ApplyStorageDrsRecommendation_Task ApplyStorageDrsRecommendationRequestType

func init() {
	t["ApplyStorageDrsRecommendation_Task"] = reflect.TypeOf((*ApplyStorageDrsRecommendation_Task)(nil)).Elem()
}

type ApplyStorageDrsRecommendation_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval"`
}

type ApplyStorageRecommendationResult struct {
	DynamicData

	Vm *ManagedObjectReference `xml:"vm,omitempty"`
}

func init() {
	t["ApplyStorageRecommendationResult"] = reflect.TypeOf((*ApplyStorageRecommendationResult)(nil)).Elem()
}

type AreAlarmActionsEnabled AreAlarmActionsEnabledRequestType

func init() {
	t["AreAlarmActionsEnabled"] = reflect.TypeOf((*AreAlarmActionsEnabled)(nil)).Elem()
}

type AreAlarmActionsEnabledRequestType struct {
	This   ManagedObjectReference `xml:"_this"`
	Entity ManagedObjectReference `xml:"entity"`
}

func init() {
	t["AreAlarmActionsEnabledRequestType"] = reflect.TypeOf((*AreAlarmActionsEnabledRequestType)(nil)).Elem()
}

type AreAlarmActionsEnabledResponse struct {
	Returnval bool `xml:"returnval"`
}

type ArrayOfAlarmAction struct {
	AlarmAction []BaseAlarmAction `xml:"AlarmAction,omitempty,typeattr"`
}

func init() {
	t["ArrayOfAlarmAction"] = reflect.TypeOf((*ArrayOfAlarmAction)(nil)).Elem()
}

type ArrayOfAlarmExpression struct {
	AlarmExpression []BaseAlarmExpression `xml:"AlarmExpression,omitempty,typeattr"`
}

func init() {
	t["ArrayOfAlarmExpression"] = reflect.TypeOf((*ArrayOfAlarmExpression)(nil)).Elem()
}

type ArrayOfAlarmState struct {
	AlarmState []AlarmState `xml:"AlarmState,omitempty"`
}

func init() {
	t["ArrayOfAlarmState"] = reflect.TypeOf((*ArrayOfAlarmState)(nil)).Elem()
}

type ArrayOfAlarmTriggeringActionTransitionSpec struct {
	AlarmTriggeringActionTransitionSpec []AlarmTriggeringActionTransitionSpec `xml:"AlarmTriggeringActionTransitionSpec,omitempty"`
}

func init() {
	t["ArrayOfAlarmTriggeringActionTransitionSpec"] = reflect.TypeOf((*ArrayOfAlarmTriggeringActionTransitionSpec)(nil)).Elem()
}

type ArrayOfAnswerFileStatusError struct {
	AnswerFileStatusError []AnswerFileStatusError `xml:"AnswerFileStatusError,omitempty"`
}

func init() {
	t["ArrayOfAnswerFileStatusError"] = reflect.TypeOf((*ArrayOfAnswerFileStatusError)(nil)).Elem()
}

type ArrayOfAnswerFileStatusResult struct {
	AnswerFileStatusResult []AnswerFileStatusResult `xml:"AnswerFileStatusResult,omitempty"`
}

func init() {
	t["ArrayOfAnswerFileStatusResult"] = reflect.TypeOf((*ArrayOfAnswerFileStatusResult)(nil)).Elem()
}

type ArrayOfAnswerFileUpdateFailure struct {
	AnswerFileUpdateFailure []AnswerFileUpdateFailure `xml:"AnswerFileUpdateFailure,omitempty"`
}

func init() {
	t["ArrayOfAnswerFileUpdateFailure"] = reflect.TypeOf((*ArrayOfAnswerFileUpdateFailure)(nil)).Elem()
}

type ArrayOfAnyType struct {
	AnyType []AnyType `xml:"anyType,omitempty,typeattr"`
}

func init() {
	t["ArrayOfAnyType"] = reflect.TypeOf((*ArrayOfAnyType)(nil)).Elem()
}

type ArrayOfAnyURI struct {
	AnyURI []string `xml:"anyURI,omitempty"`
}

func init() {
	t["ArrayOfAnyURI"] = reflect.TypeOf((*ArrayOfAnyURI)(nil)).Elem()
}

type ArrayOfApplyHostProfileConfigurationResult struct {
	ApplyHostProfileConfigurationResult []ApplyHostProfileConfigurationResult `xml:"ApplyHostProfileConfigurationResult,omitempty"`
}

func init() {
	t["ArrayOfApplyHostProfileConfigurationResult"] = reflect.TypeOf((*ArrayOfApplyHostProfileConfigurationResult)(nil)).Elem()
}

type ArrayOfApplyHostProfileConfigurationSpec struct {
	ApplyHostProfileConfigurationSpec []ApplyHostProfileConfigurationSpec `xml:"ApplyHostProfileConfigurationSpec,omitempty"`
}

func init() {
	t["ArrayOfApplyHostProfileConfigurationSpec"] = reflect.TypeOf((*ArrayOfApplyHostProfileConfigurationSpec)(nil)).Elem()
}

type ArrayOfApplyProfile struct {
	ApplyProfile []BaseApplyProfile `xml:"ApplyProfile,omitempty,typeattr"`
}

func init() {
	t["ArrayOfApplyProfile"] = reflect.TypeOf((*ArrayOfApplyProfile)(nil)).Elem()
}

type ArrayOfAuthorizationPrivilege struct {
	AuthorizationPrivilege []AuthorizationPrivilege `xml:"AuthorizationPrivilege,omitempty"`
}

func init() {
	t["ArrayOfAuthorizationPrivilege"] = reflect.TypeOf((*ArrayOfAuthorizationPrivilege)(nil)).Elem()
}

type ArrayOfAuthorizationRole struct {
	AuthorizationRole []AuthorizationRole `xml:"AuthorizationRole,omitempty"`
}

func init() {
	t["ArrayOfAuthorizationRole"] = reflect.TypeOf((*ArrayOfAuthorizationRole)(nil)).Elem()
}

type ArrayOfAutoStartPowerInfo struct {
	AutoStartPowerInfo []AutoStartPowerInfo `xml:"AutoStartPowerInfo,omitempty"`
}

func init() {
	t["ArrayOfAutoStartPowerInfo"] = reflect.TypeOf((*ArrayOfAutoStartPowerInfo)(nil)).Elem()
}

type ArrayOfBase64Binary struct {
	Base64Binary [][]byte `xml:"base64Binary,omitempty"`
}

func init() {
	t["ArrayOfBase64Binary"] = reflect.TypeOf((*ArrayOfBase64Binary)(nil)).Elem()
}

type ArrayOfBoolean struct {
	Boolean []bool `xml:"boolean,omitempty"`
}

func init() {
	t["ArrayOfBoolean"] = reflect.TypeOf((*ArrayOfBoolean)(nil)).Elem()
}

type ArrayOfByte struct {
	Byte []byte `xml:"byte,omitempty"`
}

func init() {
	t["ArrayOfByte"] = reflect.TypeOf((*ArrayOfByte)(nil)).Elem()
}

type ArrayOfChangesInfoEventArgument struct {
	ChangesInfoEventArgument []ChangesInfoEventArgument `xml:"ChangesInfoEventArgument,omitempty"`
}

func init() {
	t["ArrayOfChangesInfoEventArgument"] = reflect.TypeOf((*ArrayOfChangesInfoEventArgument)(nil)).Elem()
}

type ArrayOfCheckResult struct {
	CheckResult []CheckResult `xml:"CheckResult,omitempty"`
}

func init() {
	t["ArrayOfCheckResult"] = reflect.TypeOf((*ArrayOfCheckResult)(nil)).Elem()
}

type ArrayOfClusterAction struct {
	ClusterAction []BaseClusterAction `xml:"ClusterAction,omitempty,typeattr"`
}

func init() {
	t["ArrayOfClusterAction"] = reflect.TypeOf((*ArrayOfClusterAction)(nil)).Elem()
}

type ArrayOfClusterActionHistory struct {
	ClusterActionHistory []ClusterActionHistory `xml:"ClusterActionHistory,omitempty"`
}

func init() {
	t["ArrayOfClusterActionHistory"] = reflect.TypeOf((*ArrayOfClusterActionHistory)(nil)).Elem()
}

type ArrayOfClusterAttemptedVmInfo struct {
	ClusterAttemptedVmInfo []ClusterAttemptedVmInfo `xml:"ClusterAttemptedVmInfo,omitempty"`
}

func init() {
	t["ArrayOfClusterAttemptedVmInfo"] = reflect.TypeOf((*ArrayOfClusterAttemptedVmInfo)(nil)).Elem()
}

type ArrayOfClusterComputeResourceDVSSetting struct {
	ClusterComputeResourceDVSSetting []ClusterComputeResourceDVSSetting `xml:"ClusterComputeResourceDVSSetting,omitempty"`
}

func init() {
	t["ArrayOfClusterComputeResourceDVSSetting"] = reflect.TypeOf((*ArrayOfClusterComputeResourceDVSSetting)(nil)).Elem()
}

type ArrayOfClusterComputeResourceDVSSettingDVPortgroupToServiceMapping struct {
	ClusterComputeResourceDVSSettingDVPortgroupToServiceMapping []ClusterComputeResourceDVSSettingDVPortgroupToServiceMapping `xml:"ClusterComputeResourceDVSSettingDVPortgroupToServiceMapping,omitempty"`
}

func init() {
	t["ArrayOfClusterComputeResourceDVSSettingDVPortgroupToServiceMapping"] = reflect.TypeOf((*ArrayOfClusterComputeResourceDVSSettingDVPortgroupToServiceMapping)(nil)).Elem()
}

type ArrayOfClusterComputeResourceDvsProfile struct {
	ClusterComputeResourceDvsProfile []ClusterComputeResourceDvsProfile `xml:"ClusterComputeResourceDvsProfile,omitempty"`
}

func init() {
	t["ArrayOfClusterComputeResourceDvsProfile"] = reflect.TypeOf((*ArrayOfClusterComputeResourceDvsProfile)(nil)).Elem()
}

type ArrayOfClusterComputeResourceDvsProfileDVPortgroupSpecToServiceMapping struct {
	ClusterComputeResourceDvsProfileDVPortgroupSpecToServiceMapping []ClusterComputeResourceDvsProfileDVPortgroupSpecToServiceMapping `xml:"ClusterComputeResourceDvsProfileDVPortgroupSpecToServiceMapping,omitempty"`
}

func init() {
	t["ArrayOfClusterComputeResourceDvsProfileDVPortgroupSpecToServiceMapping"] = reflect.TypeOf((*ArrayOfClusterComputeResourceDvsProfileDVPortgroupSpecToServiceMapping)(nil)).Elem()
}

type ArrayOfClusterComputeResourceHostConfigurationInput struct {
	ClusterComputeResourceHostConfigurationInput []ClusterComputeResourceHostConfigurationInput `xml:"ClusterComputeResourceHostConfigurationInput,omitempty"`
}

func init() {
	t["ArrayOfClusterComputeResourceHostConfigurationInput"] = reflect.TypeOf((*ArrayOfClusterComputeResourceHostConfigurationInput)(nil)).Elem()
}

type ArrayOfClusterComputeResourceHostVmkNicInfo struct {
	ClusterComputeResourceHostVmkNicInfo []ClusterComputeResourceHostVmkNicInfo `xml:"ClusterComputeResourceHostVmkNicInfo,omitempty"`
}

func init() {
	t["ArrayOfClusterComputeResourceHostVmkNicInfo"] = reflect.TypeOf((*ArrayOfClusterComputeResourceHostVmkNicInfo)(nil)).Elem()
}

type ArrayOfClusterComputeResourceValidationResultBase struct {
	ClusterComputeResourceValidationResultBase []BaseClusterComputeResourceValidationResultBase `xml:"ClusterComputeResourceValidationResultBase,omitempty,typeattr"`
}

func init() {
	t["ArrayOfClusterComputeResourceValidationResultBase"] = reflect.TypeOf((*ArrayOfClusterComputeResourceValidationResultBase)(nil)).Elem()
}

type ArrayOfClusterComputeResourceVcsSlots struct {
	ClusterComputeResourceVcsSlots []ClusterComputeResourceVcsSlots `xml:"ClusterComputeResourceVcsSlots,omitempty"`
}

func init() {
	t["ArrayOfClusterComputeResourceVcsSlots"] = reflect.TypeOf((*ArrayOfClusterComputeResourceVcsSlots)(nil)).Elem()
}

type ArrayOfClusterDasAamNodeState struct {
	ClusterDasAamNodeState []ClusterDasAamNodeState `xml:"ClusterDasAamNodeState,omitempty"`
}

func init() {
	t["ArrayOfClusterDasAamNodeState"] = reflect.TypeOf((*ArrayOfClusterDasAamNodeState)(nil)).Elem()
}

type ArrayOfClusterDasFailoverLevelAdvancedRuntimeInfoHostSlots struct {
	ClusterDasFailoverLevelAdvancedRuntimeInfoHostSlots []ClusterDasFailoverLevelAdvancedRuntimeInfoHostSlots `xml:"ClusterDasFailoverLevelAdvancedRuntimeInfoHostSlots,omitempty"`
}

func init() {
	t["ArrayOfClusterDasFailoverLevelAdvancedRuntimeInfoHostSlots"] = reflect.TypeOf((*ArrayOfClusterDasFailoverLevelAdvancedRuntimeInfoHostSlots)(nil)).Elem()
}

type ArrayOfClusterDasFailoverLevelAdvancedRuntimeInfoVmSlots struct {
	ClusterDasFailoverLevelAdvancedRuntimeInfoVmSlots []ClusterDasFailoverLevelAdvancedRuntimeInfoVmSlots `xml:"ClusterDasFailoverLevelAdvancedRuntimeInfoVmSlots,omitempty"`
}

func init() {
	t["ArrayOfClusterDasFailoverLevelAdvancedRuntimeInfoVmSlots"] = reflect.TypeOf((*ArrayOfClusterDasFailoverLevelAdvancedRuntimeInfoVmSlots)(nil)).Elem()
}

type ArrayOfClusterDasVmConfigInfo struct {
	ClusterDasVmConfigInfo []ClusterDasVmConfigInfo `xml:"ClusterDasVmConfigInfo,omitempty"`
}

func init() {
	t["ArrayOfClusterDasVmConfigInfo"] = reflect.TypeOf((*ArrayOfClusterDasVmConfigInfo)(nil)).Elem()
}

type ArrayOfClusterDasVmConfigSpec struct {
	ClusterDasVmConfigSpec []ClusterDasVmConfigSpec `xml:"ClusterDasVmConfigSpec,omitempty"`
}

func init() {
	t["ArrayOfClusterDasVmConfigSpec"] = reflect.TypeOf((*ArrayOfClusterDasVmConfigSpec)(nil)).Elem()
}

type ArrayOfClusterDatastoreUpdateSpec struct {
	ClusterDatastoreUpdateSpec []ClusterDatastoreUpdateSpec `xml:"ClusterDatastoreUpdateSpec,omitempty"`
}

func init() {
	t["ArrayOfClusterDatastoreUpdateSpec"] = reflect.TypeOf((*ArrayOfClusterDatastoreUpdateSpec)(nil)).Elem()
}

type ArrayOfClusterDpmHostConfigInfo struct {
	ClusterDpmHostConfigInfo []ClusterDpmHostConfigInfo `xml:"ClusterDpmHostConfigInfo,omitempty"`
}

func init() {
	t["ArrayOfClusterDpmHostConfigInfo"] = reflect.TypeOf((*ArrayOfClusterDpmHostConfigInfo)(nil)).Elem()
}

type ArrayOfClusterDpmHostConfigSpec struct {
	ClusterDpmHostConfigSpec []ClusterDpmHostConfigSpec `xml:"ClusterDpmHostConfigSpec,omitempty"`
}

func init() {
	t["ArrayOfClusterDpmHostConfigSpec"] = reflect.TypeOf((*ArrayOfClusterDpmHostConfigSpec)(nil)).Elem()
}

type ArrayOfClusterDrsFaults struct {
	ClusterDrsFaults []ClusterDrsFaults `xml:"ClusterDrsFaults,omitempty"`
}

func init() {
	t["ArrayOfClusterDrsFaults"] = reflect.TypeOf((*ArrayOfClusterDrsFaults)(nil)).Elem()
}

type ArrayOfClusterDrsFaultsFaultsByVm struct {
	ClusterDrsFaultsFaultsByVm []BaseClusterDrsFaultsFaultsByVm `xml:"ClusterDrsFaultsFaultsByVm,omitempty,typeattr"`
}

func init() {
	t["ArrayOfClusterDrsFaultsFaultsByVm"] = reflect.TypeOf((*ArrayOfClusterDrsFaultsFaultsByVm)(nil)).Elem()
}

type ArrayOfClusterDrsMigration struct {
	ClusterDrsMigration []ClusterDrsMigration `xml:"ClusterDrsMigration,omitempty"`
}

func init() {
	t["ArrayOfClusterDrsMigration"] = reflect.TypeOf((*ArrayOfClusterDrsMigration)(nil)).Elem()
}

type ArrayOfClusterDrsRecommendation struct {
	ClusterDrsRecommendation []ClusterDrsRecommendation `xml:"ClusterDrsRecommendation,omitempty"`
}

func init() {
	t["ArrayOfClusterDrsRecommendation"] = reflect.TypeOf((*ArrayOfClusterDrsRecommendation)(nil)).Elem()
}

type ArrayOfClusterDrsVmConfigInfo struct {
	ClusterDrsVmConfigInfo []ClusterDrsVmConfigInfo `xml:"ClusterDrsVmConfigInfo,omitempty"`
}

func init() {
	t["ArrayOfClusterDrsVmConfigInfo"] = reflect.TypeOf((*ArrayOfClusterDrsVmConfigInfo)(nil)).Elem()
}

type ArrayOfClusterDrsVmConfigSpec struct {
	ClusterDrsVmConfigSpec []ClusterDrsVmConfigSpec `xml:"ClusterDrsVmConfigSpec,omitempty"`
}

func init() {
	t["ArrayOfClusterDrsVmConfigSpec"] = reflect.TypeOf((*ArrayOfClusterDrsVmConfigSpec)(nil)).Elem()
}

type ArrayOfClusterEVCManagerCheckResult struct {
	ClusterEVCManagerCheckResult []ClusterEVCManagerCheckResult `xml:"ClusterEVCManagerCheckResult,omitempty"`
}

func init() {
	t["ArrayOfClusterEVCManagerCheckResult"] = reflect.TypeOf((*ArrayOfClusterEVCManagerCheckResult)(nil)).Elem()
}

type ArrayOfClusterFailoverHostAdmissionControlInfoHostStatus struct {
	ClusterFailoverHostAdmissionControlInfoHostStatus []ClusterFailoverHostAdmissionControlInfoHostStatus `xml:"ClusterFailoverHostAdmissionControlInfoHostStatus,omitempty"`
}

func init() {
	t["ArrayOfClusterFailoverHostAdmissionControlInfoHostStatus"] = reflect.TypeOf((*ArrayOfClusterFailoverHostAdmissionControlInfoHostStatus)(nil)).Elem()
}

type ArrayOfClusterGroupInfo struct {
	ClusterGroupInfo []BaseClusterGroupInfo `xml:"ClusterGroupInfo,omitempty,typeattr"`
}

func init() {
	t["ArrayOfClusterGroupInfo"] = reflect.TypeOf((*ArrayOfClusterGroupInfo)(nil)).Elem()
}

type ArrayOfClusterGroupSpec struct {
	ClusterGroupSpec []ClusterGroupSpec `xml:"ClusterGroupSpec,omitempty"`
}

func init() {
	t["ArrayOfClusterGroupSpec"] = reflect.TypeOf((*ArrayOfClusterGroupSpec)(nil)).Elem()
}

type ArrayOfClusterHostRecommendation struct {
	ClusterHostRecommendation []ClusterHostRecommendation `xml:"ClusterHostRecommendation,omitempty"`
}

func init() {
	t["ArrayOfClusterHostRecommendation"] = reflect.TypeOf((*ArrayOfClusterHostRecommendation)(nil)).Elem()
}

type ArrayOfClusterIoFilterInfo struct {
	ClusterIoFilterInfo []ClusterIoFilterInfo `xml:"ClusterIoFilterInfo,omitempty"`
}

func init() {
	t["ArrayOfClusterIoFilterInfo"] = reflect.TypeOf((*ArrayOfClusterIoFilterInfo)(nil)).Elem()
}

type ArrayOfClusterNotAttemptedVmInfo struct {
	ClusterNotAttemptedVmInfo []ClusterNotAttemptedVmInfo `xml:"ClusterNotAttemptedVmInfo,omitempty"`
}

func init() {
	t["ArrayOfClusterNotAttemptedVmInfo"] = reflect.TypeOf((*ArrayOfClusterNotAttemptedVmInfo)(nil)).Elem()
}

type ArrayOfClusterRecommendation struct {
	ClusterRecommendation []ClusterRecommendation `xml:"ClusterRecommendation,omitempty"`
}

func init() {
	t["ArrayOfClusterRecommendation"] = reflect.TypeOf((*ArrayOfClusterRecommendation)(nil)).Elem()
}

type ArrayOfClusterRuleInfo struct {
	ClusterRuleInfo []BaseClusterRuleInfo `xml:"ClusterRuleInfo,omitempty,typeattr"`
}

func init() {
	t["ArrayOfClusterRuleInfo"] = reflect.TypeOf((*ArrayOfClusterRuleInfo)(nil)).Elem()
}

type ArrayOfClusterRuleSpec struct {
	ClusterRuleSpec []ClusterRuleSpec `xml:"ClusterRuleSpec,omitempty"`
}

func init() {
	t["ArrayOfClusterRuleSpec"] = reflect.TypeOf((*ArrayOfClusterRuleSpec)(nil)).Elem()
}

type ArrayOfClusterTagCategoryUpdateSpec struct {
	ClusterTagCategoryUpdateSpec []ClusterTagCategoryUpdateSpec `xml:"ClusterTagCategoryUpdateSpec,omitempty"`
}

func init() {
	t["ArrayOfClusterTagCategoryUpdateSpec"] = reflect.TypeOf((*ArrayOfClusterTagCategoryUpdateSpec)(nil)).Elem()
}

type ArrayOfClusterVmOrchestrationInfo struct {
	ClusterVmOrchestrationInfo []ClusterVmOrchestrationInfo `xml:"ClusterVmOrchestrationInfo,omitempty"`
}

func init() {
	t["ArrayOfClusterVmOrchestrationInfo"] = reflect.TypeOf((*ArrayOfClusterVmOrchestrationInfo)(nil)).Elem()
}

type ArrayOfClusterVmOrchestrationSpec struct {
	ClusterVmOrchestrationSpec []ClusterVmOrchestrationSpec `xml:"ClusterVmOrchestrationSpec,omitempty"`
}

func init() {
	t["ArrayOfClusterVmOrchestrationSpec"] = reflect.TypeOf((*ArrayOfClusterVmOrchestrationSpec)(nil)).Elem()
}

type ArrayOfComplianceFailure struct {
	ComplianceFailure []ComplianceFailure `xml:"ComplianceFailure,omitempty"`
}

func init() {
	t["ArrayOfComplianceFailure"] = reflect.TypeOf((*ArrayOfComplianceFailure)(nil)).Elem()
}

type ArrayOfComplianceFailureComplianceFailureValues struct {
	ComplianceFailureComplianceFailureValues []ComplianceFailureComplianceFailureValues `xml:"ComplianceFailureComplianceFailureValues,omitempty"`
}

func init() {
	t["ArrayOfComplianceFailureComplianceFailureValues"] = reflect.TypeOf((*ArrayOfComplianceFailureComplianceFailureValues)(nil)).Elem()
}

type ArrayOfComplianceLocator struct {
	ComplianceLocator []ComplianceLocator `xml:"ComplianceLocator,omitempty"`
}

func init() {
	t["ArrayOfComplianceLocator"] = reflect.TypeOf((*ArrayOfComplianceLocator)(nil)).Elem()
}

type ArrayOfComplianceResult struct {
	ComplianceResult []ComplianceResult `xml:"ComplianceResult,omitempty"`
}

func init() {
	t["ArrayOfComplianceResult"] = reflect.TypeOf((*ArrayOfComplianceResult)(nil)).Elem()
}

type ArrayOfComputeResourceHostSPBMLicenseInfo struct {
	ComputeResourceHostSPBMLicenseInfo []ComputeResourceHostSPBMLicenseInfo `xml:"ComputeResourceHostSPBMLicenseInfo,omitempty"`
}

func init() {
	t["ArrayOfComputeResourceHostSPBMLicenseInfo"] = reflect.TypeOf((*ArrayOfComputeResourceHostSPBMLicenseInfo)(nil)).Elem()
}

type ArrayOfConflictingConfigurationConfig struct {
	ConflictingConfigurationConfig []ConflictingConfigurationConfig `xml:"ConflictingConfigurationConfig,omitempty"`
}

func init() {
	t["ArrayOfConflictingConfigurationConfig"] = reflect.TypeOf((*ArrayOfConflictingConfigurationConfig)(nil)).Elem()
}

type ArrayOfCryptoKeyId struct {
	CryptoKeyId []CryptoKeyId `xml:"CryptoKeyId,omitempty"`
}

func init() {
	t["ArrayOfCryptoKeyId"] = reflect.TypeOf((*ArrayOfCryptoKeyId)(nil)).Elem()
}

type ArrayOfCryptoKeyPlain struct {
	CryptoKeyPlain []CryptoKeyPlain `xml:"CryptoKeyPlain,omitempty"`
}

func init() {
	t["ArrayOfCryptoKeyPlain"] = reflect.TypeOf((*ArrayOfCryptoKeyPlain)(nil)).Elem()
}

type ArrayOfCryptoKeyResult struct {
	CryptoKeyResult []CryptoKeyResult `xml:"CryptoKeyResult,omitempty"`
}

func init() {
	t["ArrayOfCryptoKeyResult"] = reflect.TypeOf((*ArrayOfCryptoKeyResult)(nil)).Elem()
}

type ArrayOfCryptoManagerKmipClusterStatus struct {
	CryptoManagerKmipClusterStatus []CryptoManagerKmipClusterStatus `xml:"CryptoManagerKmipClusterStatus,omitempty"`
}

func init() {
	t["ArrayOfCryptoManagerKmipClusterStatus"] = reflect.TypeOf((*ArrayOfCryptoManagerKmipClusterStatus)(nil)).Elem()
}

type ArrayOfCryptoManagerKmipCryptoKeyStatus struct {
	CryptoManagerKmipCryptoKeyStatus []CryptoManagerKmipCryptoKeyStatus `xml:"CryptoManagerKmipCryptoKeyStatus,omitempty"`
}

func init() {
	t["ArrayOfCryptoManagerKmipCryptoKeyStatus"] = reflect.TypeOf((*ArrayOfCryptoManagerKmipCryptoKeyStatus)(nil)).Elem()
}

type ArrayOfCryptoManagerKmipServerStatus struct {
	CryptoManagerKmipServerStatus []CryptoManagerKmipServerStatus `xml:"CryptoManagerKmipServerStatus,omitempty"`
}

func init() {
	t["ArrayOfCryptoManagerKmipServerStatus"] = reflect.TypeOf((*ArrayOfCryptoManagerKmipServerStatus)(nil)).Elem()
}

type ArrayOfCustomFieldDef struct {
	CustomFieldDef []CustomFieldDef `xml:"CustomFieldDef,omitempty"`
}

func init() {
	t["ArrayOfCustomFieldDef"] = reflect.TypeOf((*ArrayOfCustomFieldDef)(nil)).Elem()
}

type ArrayOfCustomFieldValue struct {
	CustomFieldValue []BaseCustomFieldValue `xml:"CustomFieldValue,omitempty,typeattr"`
}

func init() {
	t["ArrayOfCustomFieldValue"] = reflect.TypeOf((*ArrayOfCustomFieldValue)(nil)).Elem()
}

type ArrayOfCustomizationAdapterMapping struct {
	CustomizationAdapterMapping []CustomizationAdapterMapping `xml:"CustomizationAdapterMapping,omitempty"`
}

func init() {
	t["ArrayOfCustomizationAdapterMapping"] = reflect.TypeOf((*ArrayOfCustomizationAdapterMapping)(nil)).Elem()
}

type ArrayOfCustomizationIpV6Generator struct {
	CustomizationIpV6Generator []BaseCustomizationIpV6Generator `xml:"CustomizationIpV6Generator,omitempty,typeattr"`
}

func init() {
	t["ArrayOfCustomizationIpV6Generator"] = reflect.TypeOf((*ArrayOfCustomizationIpV6Generator)(nil)).Elem()
}

type ArrayOfCustomizationSpecInfo struct {
	CustomizationSpecInfo []CustomizationSpecInfo `xml:"CustomizationSpecInfo,omitempty"`
}

func init() {
	t["ArrayOfCustomizationSpecInfo"] = reflect.TypeOf((*ArrayOfCustomizationSpecInfo)(nil)).Elem()
}

type ArrayOfDVPortConfigSpec struct {
	DVPortConfigSpec []DVPortConfigSpec `xml:"DVPortConfigSpec,omitempty"`
}

func init() {
	t["ArrayOfDVPortConfigSpec"] = reflect.TypeOf((*ArrayOfDVPortConfigSpec)(nil)).Elem()
}

type ArrayOfDVPortgroupConfigSpec struct {
	DVPortgroupConfigSpec []DVPortgroupConfigSpec `xml:"DVPortgroupConfigSpec,omitempty"`
}

func init() {
	t["ArrayOfDVPortgroupConfigSpec"] = reflect.TypeOf((*ArrayOfDVPortgroupConfigSpec)(nil)).Elem()
}

type ArrayOfDVSHealthCheckConfig struct {
	DVSHealthCheckConfig []BaseDVSHealthCheckConfig `xml:"DVSHealthCheckConfig,omitempty,typeattr"`
}

func init() {
	t["ArrayOfDVSHealthCheckConfig"] = reflect.TypeOf((*ArrayOfDVSHealthCheckConfig)(nil)).Elem()
}

type ArrayOfDVSNetworkResourcePool struct {
	DVSNetworkResourcePool []DVSNetworkResourcePool `xml:"DVSNetworkResourcePool,omitempty"`
}

func init() {
	t["ArrayOfDVSNetworkResourcePool"] = reflect.TypeOf((*ArrayOfDVSNetworkResourcePool)(nil)).Elem()
}

type ArrayOfDVSNetworkResourcePoolConfigSpec struct {
	DVSNetworkResourcePoolConfigSpec []DVSNetworkResourcePoolConfigSpec `xml:"DVSNetworkResourcePoolConfigSpec,omitempty"`
}

func init() {
	t["ArrayOfDVSNetworkResourcePoolConfigSpec"] = reflect.TypeOf((*ArrayOfDVSNetworkResourcePoolConfigSpec)(nil)).Elem()
}

type ArrayOfDVSVmVnicNetworkResourcePool struct {
	DVSVmVnicNetworkResourcePool []DVSVmVnicNetworkResourcePool `xml:"DVSVmVnicNetworkResourcePool,omitempty"`
}

func init() {
	t["ArrayOfDVSVmVnicNetworkResourcePool"] = reflect.TypeOf((*ArrayOfDVSVmVnicNetworkResourcePool)(nil)).Elem()
}

type ArrayOfDasHeartbeatDatastoreInfo struct {
	DasHeartbeatDatastoreInfo []DasHeartbeatDatastoreInfo `xml:"DasHeartbeatDatastoreInfo,omitempty"`
}

func init() {
	t["ArrayOfDasHeartbeatDatastoreInfo"] = reflect.TypeOf((*ArrayOfDasHeartbeatDatastoreInfo)(nil)).Elem()
}

type ArrayOfDatacenterBasicConnectInfo struct {
	DatacenterBasicConnectInfo []DatacenterBasicConnectInfo `xml:"DatacenterBasicConnectInfo,omitempty"`
}

func init() {
	t["ArrayOfDatacenterBasicConnectInfo"] = reflect.TypeOf((*ArrayOfDatacenterBasicConnectInfo)(nil)).Elem()
}

type ArrayOfDatacenterMismatchArgument struct {
	DatacenterMismatchArgument []DatacenterMismatchArgument `xml:"DatacenterMismatchArgument,omitempty"`
}

func init() {
	t["ArrayOfDatacenterMismatchArgument"] = reflect.TypeOf((*ArrayOfDatacenterMismatchArgument)(nil)).Elem()
}

type ArrayOfDatastoreHostMount struct {
	DatastoreHostMount []DatastoreHostMount `xml:"DatastoreHostMount,omitempty"`
}

func init() {
	t["ArrayOfDatastoreHostMount"] = reflect.TypeOf((*ArrayOfDatastoreHostMount)(nil)).Elem()
}

type ArrayOfDatastoreMountPathDatastorePair struct {
	DatastoreMountPathDatastorePair []DatastoreMountPathDatastorePair `xml:"DatastoreMountPathDatastorePair,omitempty"`
}

func init() {
	t["ArrayOfDatastoreMountPathDatastorePair"] = reflect.TypeOf((*ArrayOfDatastoreMountPathDatastorePair)(nil)).Elem()
}

type ArrayOfDatastoreVVolContainerFailoverPair struct {
	DatastoreVVolContainerFailoverPair []DatastoreVVolContainerFailoverPair `xml:"DatastoreVVolContainerFailoverPair,omitempty"`
}

func init() {
	t["ArrayOfDatastoreVVolContainerFailoverPair"] = reflect.TypeOf((*ArrayOfDatastoreVVolContainerFailoverPair)(nil)).Elem()
}

type ArrayOfDesiredSoftwareSpecComponentSpec struct {
	DesiredSoftwareSpecComponentSpec []DesiredSoftwareSpecComponentSpec `xml:"DesiredSoftwareSpecComponentSpec,omitempty"`
}

func init() {
	t["ArrayOfDesiredSoftwareSpecComponentSpec"] = reflect.TypeOf((*ArrayOfDesiredSoftwareSpecComponentSpec)(nil)).Elem()
}

type ArrayOfDiagnosticManagerBundleInfo struct {
	DiagnosticManagerBundleInfo []DiagnosticManagerBundleInfo `xml:"DiagnosticManagerBundleInfo,omitempty"`
}

func init() {
	t["ArrayOfDiagnosticManagerBundleInfo"] = reflect.TypeOf((*ArrayOfDiagnosticManagerBundleInfo)(nil)).Elem()
}

type ArrayOfDiagnosticManagerLogDescriptor struct {
	DiagnosticManagerLogDescriptor []DiagnosticManagerLogDescriptor `xml:"DiagnosticManagerLogDescriptor,omitempty"`
}

func init() {
	t["ArrayOfDiagnosticManagerLogDescriptor"] = reflect.TypeOf((*ArrayOfDiagnosticManagerLogDescriptor)(nil)).Elem()
}

type ArrayOfDiskChangeExtent struct {
	DiskChangeExtent []DiskChangeExtent `xml:"DiskChangeExtent,omitempty"`
}

func init() {
	t["ArrayOfDiskChangeExtent"] = reflect.TypeOf((*ArrayOfDiskChangeExtent)(nil)).Elem()
}

type ArrayOfDistributedVirtualPort struct {
	DistributedVirtualPort []DistributedVirtualPort `xml:"DistributedVirtualPort,omitempty"`
}

func init() {
	t["ArrayOfDistributedVirtualPort"] = reflect.TypeOf((*ArrayOfDistributedVirtualPort)(nil)).Elem()
}

type ArrayOfDistributedVirtualPortgroupInfo struct {
	DistributedVirtualPortgroupInfo []DistributedVirtualPortgroupInfo `xml:"DistributedVirtualPortgroupInfo,omitempty"`
}

func init() {
	t["ArrayOfDistributedVirtualPortgroupInfo"] = reflect.TypeOf((*ArrayOfDistributedVirtualPortgroupInfo)(nil)).Elem()
}

type ArrayOfDistributedVirtualPortgroupProblem struct {
	DistributedVirtualPortgroupProblem []DistributedVirtualPortgroupProblem `xml:"DistributedVirtualPortgroupProblem,omitempty"`
}

func init() {
	t["ArrayOfDistributedVirtualPortgroupProblem"] = reflect.TypeOf((*ArrayOfDistributedVirtualPortgroupProblem)(nil)).Elem()
}

type ArrayOfDistributedVirtualSwitchHostMember struct {
	DistributedVirtualSwitchHostMember []DistributedVirtualSwitchHostMember `xml:"DistributedVirtualSwitchHostMember,omitempty"`
}

func init() {
	t["ArrayOfDistributedVirtualSwitchHostMember"] = reflect.TypeOf((*ArrayOfDistributedVirtualSwitchHostMember)(nil)).Elem()
}

type ArrayOfDistributedVirtualSwitchHostMemberConfigSpec struct {
	DistributedVirtualSwitchHostMemberConfigSpec []DistributedVirtualSwitchHostMemberConfigSpec `xml:"DistributedVirtualSwitchHostMemberConfigSpec,omitempty"`
}

func init() {
	t["ArrayOfDistributedVirtualSwitchHostMemberConfigSpec"] = reflect.TypeOf((*ArrayOfDistributedVirtualSwitchHostMemberConfigSpec)(nil)).Elem()
}

type ArrayOfDistributedVirtualSwitchHostMemberPnicSpec struct {
	DistributedVirtualSwitchHostMemberPnicSpec []DistributedVirtualSwitchHostMemberPnicSpec `xml:"DistributedVirtualSwitchHostMemberPnicSpec,omitempty"`
}

func init() {
	t["ArrayOfDistributedVirtualSwitchHostMemberPnicSpec"] = reflect.TypeOf((*ArrayOfDistributedVirtualSwitchHostMemberPnicSpec)(nil)).Elem()
}

type ArrayOfDistributedVirtualSwitchHostMemberTransportZoneInfo struct {
	DistributedVirtualSwitchHostMemberTransportZoneInfo []DistributedVirtualSwitchHostMemberTransportZoneInfo `xml:"DistributedVirtualSwitchHostMemberTransportZoneInfo,omitempty"`
}

func init() {
	t["ArrayOfDistributedVirtualSwitchHostMemberTransportZoneInfo"] = reflect.TypeOf((*ArrayOfDistributedVirtualSwitchHostMemberTransportZoneInfo)(nil)).Elem()
}

type ArrayOfDistributedVirtualSwitchHostProductSpec struct {
	DistributedVirtualSwitchHostProductSpec []DistributedVirtualSwitchHostProductSpec `xml:"DistributedVirtualSwitchHostProductSpec,omitempty"`
}

func init() {
	t["ArrayOfDistributedVirtualSwitchHostProductSpec"] = reflect.TypeOf((*ArrayOfDistributedVirtualSwitchHostProductSpec)(nil)).Elem()
}

type ArrayOfDistributedVirtualSwitchInfo struct {
	DistributedVirtualSwitchInfo []DistributedVirtualSwitchInfo `xml:"DistributedVirtualSwitchInfo,omitempty"`
}

func init() {
	t["ArrayOfDistributedVirtualSwitchInfo"] = reflect.TypeOf((*ArrayOfDistributedVirtualSwitchInfo)(nil)).Elem()
}

type ArrayOfDistributedVirtualSwitchKeyedOpaqueBlob struct {
	DistributedVirtualSwitchKeyedOpaqueBlob []DistributedVirtualSwitchKeyedOpaqueBlob `xml:"DistributedVirtualSwitchKeyedOpaqueBlob,omitempty"`
}

func init() {
	t["ArrayOfDistributedVirtualSwitchKeyedOpaqueBlob"] = reflect.TypeOf((*ArrayOfDistributedVirtualSwitchKeyedOpaqueBlob)(nil)).Elem()
}

type ArrayOfDistributedVirtualSwitchManagerCompatibilityResult struct {
	DistributedVirtualSwitchManagerCompatibilityResult []DistributedVirtualSwitchManagerCompatibilityResult `xml:"DistributedVirtualSwitchManagerCompatibilityResult,omitempty"`
}

func init() {
	t["ArrayOfDistributedVirtualSwitchManagerCompatibilityResult"] = reflect.TypeOf((*ArrayOfDistributedVirtualSwitchManagerCompatibilityResult)(nil)).Elem()
}

type ArrayOfDistributedVirtualSwitchManagerHostDvsFilterSpec struct {
	DistributedVirtualSwitchManagerHostDvsFilterSpec []BaseDistributedVirtualSwitchManagerHostDvsFilterSpec `xml:"DistributedVirtualSwitchManagerHostDvsFilterSpec,omitempty,typeattr"`
}

func init() {
	t["ArrayOfDistributedVirtualSwitchManagerHostDvsFilterSpec"] = reflect.TypeOf((*ArrayOfDistributedVirtualSwitchManagerHostDvsFilterSpec)(nil)).Elem()
}

type ArrayOfDistributedVirtualSwitchProductSpec struct {
	DistributedVirtualSwitchProductSpec []DistributedVirtualSwitchProductSpec `xml:"DistributedVirtualSwitchProductSpec,omitempty"`
}

func init() {
	t["ArrayOfDistributedVirtualSwitchProductSpec"] = reflect.TypeOf((*ArrayOfDistributedVirtualSwitchProductSpec)(nil)).Elem()
}

type ArrayOfDouble struct {
	Double []float64 `xml:"double,omitempty"`
}

func init() {
	t["ArrayOfDouble"] = reflect.TypeOf((*ArrayOfDouble)(nil)).Elem()
}

type ArrayOfDvsApplyOperationFaultFaultOnObject struct {
	DvsApplyOperationFaultFaultOnObject []DvsApplyOperationFaultFaultOnObject `xml:"DvsApplyOperationFaultFaultOnObject,omitempty"`
}

func init() {
	t["ArrayOfDvsApplyOperationFaultFaultOnObject"] = reflect.TypeOf((*ArrayOfDvsApplyOperationFaultFaultOnObject)(nil)).Elem()
}

type ArrayOfDvsFilterConfig struct {
	DvsFilterConfig []BaseDvsFilterConfig `xml:"DvsFilterConfig,omitempty,typeattr"`
}

func init() {
	t["ArrayOfDvsFilterConfig"] = reflect.TypeOf((*ArrayOfDvsFilterConfig)(nil)).Elem()
}

type ArrayOfDvsHostInfrastructureTrafficResource struct {
	DvsHostInfrastructureTrafficResource []DvsHostInfrastructureTrafficResource `xml:"DvsHostInfrastructureTrafficResource,omitempty"`
}

func init() {
	t["ArrayOfDvsHostInfrastructureTrafficResource"] = reflect.TypeOf((*ArrayOfDvsHostInfrastructureTrafficResource)(nil)).Elem()
}

type ArrayOfDvsHostVNicProfile struct {
	DvsHostVNicProfile []DvsHostVNicProfile `xml:"DvsHostVNicProfile,omitempty"`
}

func init() {
	t["ArrayOfDvsHostVNicProfile"] = reflect.TypeOf((*ArrayOfDvsHostVNicProfile)(nil)).Elem()
}

type ArrayOfDvsNetworkRuleQualifier struct {
	DvsNetworkRuleQualifier []BaseDvsNetworkRuleQualifier `xml:"DvsNetworkRuleQualifier,omitempty,typeattr"`
}

func init() {
	t["ArrayOfDvsNetworkRuleQualifier"] = reflect.TypeOf((*ArrayOfDvsNetworkRuleQualifier)(nil)).Elem()
}

type ArrayOfDvsOperationBulkFaultFaultOnHost struct {
	DvsOperationBulkFaultFaultOnHost []DvsOperationBulkFaultFaultOnHost `xml:"DvsOperationBulkFaultFaultOnHost,omitempty"`
}

func init() {
	t["ArrayOfDvsOperationBulkFaultFaultOnHost"] = reflect.TypeOf((*ArrayOfDvsOperationBulkFaultFaultOnHost)(nil)).Elem()
}

type ArrayOfDvsOutOfSyncHostArgument struct {
	DvsOutOfSyncHostArgument []DvsOutOfSyncHostArgument `xml:"DvsOutOfSyncHostArgument,omitempty"`
}

func init() {
	t["ArrayOfDvsOutOfSyncHostArgument"] = reflect.TypeOf((*ArrayOfDvsOutOfSyncHostArgument)(nil)).Elem()
}

type ArrayOfDvsProfile struct {
	DvsProfile []DvsProfile `xml:"DvsProfile,omitempty"`
}

func init() {
	t["ArrayOfDvsProfile"] = reflect.TypeOf((*ArrayOfDvsProfile)(nil)).Elem()
}

type ArrayOfDvsServiceConsoleVNicProfile struct {
	DvsServiceConsoleVNicProfile []DvsServiceConsoleVNicProfile `xml:"DvsServiceConsoleVNicProfile,omitempty"`
}

func init() {
	t["ArrayOfDvsServiceConsoleVNicProfile"] = reflect.TypeOf((*ArrayOfDvsServiceConsoleVNicProfile)(nil)).Elem()
}

type ArrayOfDvsTrafficRule struct {
	DvsTrafficRule []DvsTrafficRule `xml:"DvsTrafficRule,omitempty"`
}

func init() {
	t["ArrayOfDvsTrafficRule"] = reflect.TypeOf((*ArrayOfDvsTrafficRule)(nil)).Elem()
}

type ArrayOfDvsVmVnicNetworkResourcePoolRuntimeInfo struct {
	DvsVmVnicNetworkResourcePoolRuntimeInfo []DvsVmVnicNetworkResourcePoolRuntimeInfo `xml:"DvsVmVnicNetworkResourcePoolRuntimeInfo,omitempty"`
}

func init() {
	t["ArrayOfDvsVmVnicNetworkResourcePoolRuntimeInfo"] = reflect.TypeOf((*ArrayOfDvsVmVnicNetworkResourcePoolRuntimeInfo)(nil)).Elem()
}

type ArrayOfDvsVmVnicResourcePoolConfigSpec struct {
	DvsVmVnicResourcePoolConfigSpec []DvsVmVnicResourcePoolConfigSpec `xml:"DvsVmVnicResourcePoolConfigSpec,omitempty"`
}

func init() {
	t["ArrayOfDvsVmVnicResourcePoolConfigSpec"] = reflect.TypeOf((*ArrayOfDvsVmVnicResourcePoolConfigSpec)(nil)).Elem()
}

type ArrayOfDvsVnicAllocatedResource struct {
	DvsVnicAllocatedResource []DvsVnicAllocatedResource `xml:"DvsVnicAllocatedResource,omitempty"`
}

func init() {
	t["ArrayOfDvsVnicAllocatedResource"] = reflect.TypeOf((*ArrayOfDvsVnicAllocatedResource)(nil)).Elem()
}

type ArrayOfDynamicProperty struct {
	DynamicProperty []DynamicProperty `xml:"DynamicProperty,omitempty"`
}

func init() {
	t["ArrayOfDynamicProperty"] = reflect.TypeOf((*ArrayOfDynamicProperty)(nil)).Elem()
}

type ArrayOfEVCMode struct {
	EVCMode []EVCMode `xml:"EVCMode,omitempty"`
}

func init() {
	t["ArrayOfEVCMode"] = reflect.TypeOf((*ArrayOfEVCMode)(nil)).Elem()
}

type ArrayOfElementDescription struct {
	ElementDescription []BaseElementDescription `xml:"ElementDescription,omitempty,typeattr"`
}

func init() {
	t["ArrayOfElementDescription"] = reflect.TypeOf((*ArrayOfElementDescription)(nil)).Elem()
}

type ArrayOfEntityBackupConfig struct {
	EntityBackupConfig []EntityBackupConfig `xml:"EntityBackupConfig,omitempty"`
}

func init() {
	t["ArrayOfEntityBackupConfig"] = reflect.TypeOf((*ArrayOfEntityBackupConfig)(nil)).Elem()
}

type ArrayOfEntityPrivilege struct {
	EntityPrivilege []EntityPrivilege `xml:"EntityPrivilege,omitempty"`
}

func init() {
	t["ArrayOfEntityPrivilege"] = reflect.TypeOf((*ArrayOfEntityPrivilege)(nil)).Elem()
}

type ArrayOfEnumDescription struct {
	EnumDescription []EnumDescription `xml:"EnumDescription,omitempty"`
}

func init() {
	t["ArrayOfEnumDescription"] = reflect.TypeOf((*ArrayOfEnumDescription)(nil)).Elem()
}

type ArrayOfEvent struct {
	Event []BaseEvent `xml:"Event,omitempty,typeattr"`
}

func init() {
	t["ArrayOfEvent"] = reflect.TypeOf((*ArrayOfEvent)(nil)).Elem()
}

type ArrayOfEventAlarmExpressionComparison struct {
	EventAlarmExpressionComparison []EventAlarmExpressionComparison `xml:"EventAlarmExpressionComparison,omitempty"`
}

func init() {
	t["ArrayOfEventAlarmExpressionComparison"] = reflect.TypeOf((*ArrayOfEventAlarmExpressionComparison)(nil)).Elem()
}

type ArrayOfEventArgDesc struct {
	EventArgDesc []EventArgDesc `xml:"EventArgDesc,omitempty"`
}

func init() {
	t["ArrayOfEventArgDesc"] = reflect.TypeOf((*ArrayOfEventArgDesc)(nil)).Elem()
}

type ArrayOfEventDescriptionEventDetail struct {
	EventDescriptionEventDetail []EventDescriptionEventDetail `xml:"EventDescriptionEventDetail,omitempty"`
}

func init() {
	t["ArrayOfEventDescriptionEventDetail"] = reflect.TypeOf((*ArrayOfEventDescriptionEventDetail)(nil)).Elem()
}

type ArrayOfExtManagedEntityInfo struct {
	ExtManagedEntityInfo []ExtManagedEntityInfo `xml:"ExtManagedEntityInfo,omitempty"`
}

func init() {
	t["ArrayOfExtManagedEntityInfo"] = reflect.TypeOf((*ArrayOfExtManagedEntityInfo)(nil)).Elem()
}

type ArrayOfExtSolutionManagerInfoTabInfo struct {
	ExtSolutionManagerInfoTabInfo []ExtSolutionManagerInfoTabInfo `xml:"ExtSolutionManagerInfoTabInfo,omitempty"`
}

func init() {
	t["ArrayOfExtSolutionManagerInfoTabInfo"] = reflect.TypeOf((*ArrayOfExtSolutionManagerInfoTabInfo)(nil)).Elem()
}

type ArrayOfExtendedEventPair struct {
	ExtendedEventPair []ExtendedEventPair `xml:"ExtendedEventPair,omitempty"`
}

func init() {
	t["ArrayOfExtendedEventPair"] = reflect.TypeOf((*ArrayOfExtendedEventPair)(nil)).Elem()
}

type ArrayOfExtension struct {
	Extension []Extension `xml:"Extension,omitempty"`
}

func init() {
	t["ArrayOfExtension"] = reflect.TypeOf((*ArrayOfExtension)(nil)).Elem()
}

type ArrayOfExtensionClientInfo struct {
	ExtensionClientInfo []ExtensionClientInfo `xml:"ExtensionClientInfo,omitempty"`
}

func init() {
	t["ArrayOfExtensionClientInfo"] = reflect.TypeOf((*ArrayOfExtensionClientInfo)(nil)).Elem()
}

type ArrayOfExtensionEventTypeInfo struct {
	ExtensionEventTypeInfo []ExtensionEventTypeInfo `xml:"ExtensionEventTypeInfo,omitempty"`
}

func init() {
	t["ArrayOfExtensionEventTypeInfo"] = reflect.TypeOf((*ArrayOfExtensionEventTypeInfo)(nil)).Elem()
}

type ArrayOfExtensionFaultTypeInfo struct {
	ExtensionFaultTypeInfo []ExtensionFaultTypeInfo `xml:"ExtensionFaultTypeInfo,omitempty"`
}

func init() {
	t["ArrayOfExtensionFaultTypeInfo"] = reflect.TypeOf((*ArrayOfExtensionFaultTypeInfo)(nil)).Elem()
}

type ArrayOfExtensionManagerIpAllocationUsage struct {
	ExtensionManagerIpAllocationUsage []ExtensionManagerIpAllocationUsage `xml:"ExtensionManagerIpAllocationUsage,omitempty"`
}

func init() {
	t["ArrayOfExtensionManagerIpAllocationUsage"] = reflect.TypeOf((*ArrayOfExtensionManagerIpAllocationUsage)(nil)).Elem()
}

type ArrayOfExtensionPrivilegeInfo struct {
	ExtensionPrivilegeInfo []ExtensionPrivilegeInfo `xml:"ExtensionPrivilegeInfo,omitempty"`
}

func init() {
	t["ArrayOfExtensionPrivilegeInfo"] = reflect.TypeOf((*ArrayOfExtensionPrivilegeInfo)(nil)).Elem()
}

type ArrayOfExtensionResourceInfo struct {
	ExtensionResourceInfo []ExtensionResourceInfo `xml:"ExtensionResourceInfo,omitempty"`
}

func init() {
	t["ArrayOfExtensionResourceInfo"] = reflect.TypeOf((*ArrayOfExtensionResourceInfo)(nil)).Elem()
}

type ArrayOfExtensionServerInfo struct {
	ExtensionServerInfo []ExtensionServerInfo `xml:"ExtensionServerInfo,omitempty"`
}

func init() {
	t["ArrayOfExtensionServerInfo"] = reflect.TypeOf((*ArrayOfExtensionServerInfo)(nil)).Elem()
}

type ArrayOfExtensionTaskTypeInfo struct {
	ExtensionTaskTypeInfo []ExtensionTaskTypeInfo `xml:"ExtensionTaskTypeInfo,omitempty"`
}

func init() {
	t["ArrayOfExtensionTaskTypeInfo"] = reflect.TypeOf((*ArrayOfExtensionTaskTypeInfo)(nil)).Elem()
}

type ArrayOfFaultToleranceDiskSpec struct {
	FaultToleranceDiskSpec []FaultToleranceDiskSpec `xml:"FaultToleranceDiskSpec,omitempty"`
}

func init() {
	t["ArrayOfFaultToleranceDiskSpec"] = reflect.TypeOf((*ArrayOfFaultToleranceDiskSpec)(nil)).Elem()
}

type ArrayOfFaultsByHost struct {
	FaultsByHost []FaultsByHost `xml:"FaultsByHost,omitempty"`
}

func init() {
	t["ArrayOfFaultsByHost"] = reflect.TypeOf((*ArrayOfFaultsByHost)(nil)).Elem()
}

type ArrayOfFaultsByVM struct {
	FaultsByVM []FaultsByVM `xml:"FaultsByVM,omitempty"`
}

func init() {
	t["ArrayOfFaultsByVM"] = reflect.TypeOf((*ArrayOfFaultsByVM)(nil)).Elem()
}

type ArrayOfFcoeConfigVlanRange struct {
	FcoeConfigVlanRange []FcoeConfigVlanRange `xml:"FcoeConfigVlanRange,omitempty"`
}

func init() {
	t["ArrayOfFcoeConfigVlanRange"] = reflect.TypeOf((*ArrayOfFcoeConfigVlanRange)(nil)).Elem()
}

type ArrayOfFeatureEVCMode struct {
	FeatureEVCMode []FeatureEVCMode `xml:"FeatureEVCMode,omitempty"`
}

func init() {
	t["ArrayOfFeatureEVCMode"] = reflect.TypeOf((*ArrayOfFeatureEVCMode)(nil)).Elem()
}

type ArrayOfFileInfo struct {
	FileInfo []BaseFileInfo `xml:"FileInfo,omitempty,typeattr"`
}

func init() {
	t["ArrayOfFileInfo"] = reflect.TypeOf((*ArrayOfFileInfo)(nil)).Elem()
}

type ArrayOfFileQuery struct {
	FileQuery []BaseFileQuery `xml:"FileQuery,omitempty,typeattr"`
}

func init() {
	t["ArrayOfFileQuery"] = reflect.TypeOf((*ArrayOfFileQuery)(nil)).Elem()
}

type ArrayOfFirewallProfileRulesetProfile struct {
	FirewallProfileRulesetProfile []FirewallProfileRulesetProfile `xml:"FirewallProfileRulesetProfile,omitempty"`
}

func init() {
	t["ArrayOfFirewallProfileRulesetProfile"] = reflect.TypeOf((*ArrayOfFirewallProfileRulesetProfile)(nil)).Elem()
}

type ArrayOfFolderFailedHostResult struct {
	FolderFailedHostResult []FolderFailedHostResult `xml:"FolderFailedHostResult,omitempty"`
}

func init() {
	t["ArrayOfFolderFailedHostResult"] = reflect.TypeOf((*ArrayOfFolderFailedHostResult)(nil)).Elem()
}

type ArrayOfFolderNewHostSpec struct {
	FolderNewHostSpec []FolderNewHostSpec `xml:"FolderNewHostSpec,omitempty"`
}

func init() {
	t["ArrayOfFolderNewHostSpec"] = reflect.TypeOf((*ArrayOfFolderNewHostSpec)(nil)).Elem()
}

type ArrayOfGuestAliases struct {
	GuestAliases []GuestAliases `xml:"GuestAliases,omitempty"`
}

func init() {
	t["ArrayOfGuestAliases"] = reflect.TypeOf((*ArrayOfGuestAliases)(nil)).Elem()
}

type ArrayOfGuestAuthAliasInfo struct {
	GuestAuthAliasInfo []GuestAuthAliasInfo `xml:"GuestAuthAliasInfo,omitempty"`
}

func init() {
	t["ArrayOfGuestAuthAliasInfo"] = reflect.TypeOf((*ArrayOfGuestAuthAliasInfo)(nil)).Elem()
}

type ArrayOfGuestAuthSubject struct {
	GuestAuthSubject []BaseGuestAuthSubject `xml:"GuestAuthSubject,omitempty,typeattr"`
}

func init() {
	t["ArrayOfGuestAuthSubject"] = reflect.TypeOf((*ArrayOfGuestAuthSubject)(nil)).Elem()
}

type ArrayOfGuestDiskInfo struct {
	GuestDiskInfo []GuestDiskInfo `xml:"GuestDiskInfo,omitempty"`
}

func init() {
	t["ArrayOfGuestDiskInfo"] = reflect.TypeOf((*ArrayOfGuestDiskInfo)(nil)).Elem()
}

type ArrayOfGuestFileInfo struct {
	GuestFileInfo []GuestFileInfo `xml:"GuestFileInfo,omitempty"`
}

func init() {
	t["ArrayOfGuestFileInfo"] = reflect.TypeOf((*ArrayOfGuestFileInfo)(nil)).Elem()
}

type ArrayOfGuestInfoNamespaceGenerationInfo struct {
	GuestInfoNamespaceGenerationInfo []GuestInfoNamespaceGenerationInfo `xml:"GuestInfoNamespaceGenerationInfo,omitempty"`
}

func init() {
	t["ArrayOfGuestInfoNamespaceGenerationInfo"] = reflect.TypeOf((*ArrayOfGuestInfoNamespaceGenerationInfo)(nil)).Elem()
}

type ArrayOfGuestInfoVirtualDiskMapping struct {
	GuestInfoVirtualDiskMapping []GuestInfoVirtualDiskMapping `xml:"GuestInfoVirtualDiskMapping,omitempty"`
}

func init() {
	t["ArrayOfGuestInfoVirtualDiskMapping"] = reflect.TypeOf((*ArrayOfGuestInfoVirtualDiskMapping)(nil)).Elem()
}

type ArrayOfGuestMappedAliases struct {
	GuestMappedAliases []GuestMappedAliases `xml:"GuestMappedAliases,omitempty"`
}

func init() {
	t["ArrayOfGuestMappedAliases"] = reflect.TypeOf((*ArrayOfGuestMappedAliases)(nil)).Elem()
}

type ArrayOfGuestNicInfo struct {
	GuestNicInfo []GuestNicInfo `xml:"GuestNicInfo,omitempty"`
}

func init() {
	t["ArrayOfGuestNicInfo"] = reflect.TypeOf((*ArrayOfGuestNicInfo)(nil)).Elem()
}

type ArrayOfGuestOsDescriptor struct {
	GuestOsDescriptor []GuestOsDescriptor `xml:"GuestOsDescriptor,omitempty"`
}

func init() {
	t["ArrayOfGuestOsDescriptor"] = reflect.TypeOf((*ArrayOfGuestOsDescriptor)(nil)).Elem()
}

type ArrayOfGuestProcessInfo struct {
	GuestProcessInfo []GuestProcessInfo `xml:"GuestProcessInfo,omitempty"`
}

func init() {
	t["ArrayOfGuestProcessInfo"] = reflect.TypeOf((*ArrayOfGuestProcessInfo)(nil)).Elem()
}

type ArrayOfGuestRegKeyRecordSpec struct {
	GuestRegKeyRecordSpec []GuestRegKeyRecordSpec `xml:"GuestRegKeyRecordSpec,omitempty"`
}

func init() {
	t["ArrayOfGuestRegKeyRecordSpec"] = reflect.TypeOf((*ArrayOfGuestRegKeyRecordSpec)(nil)).Elem()
}

type ArrayOfGuestRegValueSpec struct {
	GuestRegValueSpec []GuestRegValueSpec `xml:"GuestRegValueSpec,omitempty"`
}

func init() {
	t["ArrayOfGuestRegValueSpec"] = reflect.TypeOf((*ArrayOfGuestRegValueSpec)(nil)).Elem()
}

type ArrayOfGuestStackInfo struct {
	GuestStackInfo []GuestStackInfo `xml:"GuestStackInfo,omitempty"`
}

func init() {
	t["ArrayOfGuestStackInfo"] = reflect.TypeOf((*ArrayOfGuestStackInfo)(nil)).Elem()
}

type ArrayOfHbrManagerVmReplicationCapability struct {
	HbrManagerVmReplicationCapability []HbrManagerVmReplicationCapability `xml:"HbrManagerVmReplicationCapability,omitempty"`
}

func init() {
	t["ArrayOfHbrManagerVmReplicationCapability"] = reflect.TypeOf((*ArrayOfHbrManagerVmReplicationCapability)(nil)).Elem()
}

type ArrayOfHealthUpdate struct {
	HealthUpdate []HealthUpdate `xml:"HealthUpdate,omitempty"`
}

func init() {
	t["ArrayOfHealthUpdate"] = reflect.TypeOf((*ArrayOfHealthUpdate)(nil)).Elem()
}

type ArrayOfHealthUpdateInfo struct {
	HealthUpdateInfo []HealthUpdateInfo `xml:"HealthUpdateInfo,omitempty"`
}

func init() {
	t["ArrayOfHealthUpdateInfo"] = reflect.TypeOf((*ArrayOfHealthUpdateInfo)(nil)).Elem()
}

type ArrayOfHostAccessControlEntry struct {
	HostAccessControlEntry []HostAccessControlEntry `xml:"HostAccessControlEntry,omitempty"`
}

func init() {
	t["ArrayOfHostAccessControlEntry"] = reflect.TypeOf((*ArrayOfHostAccessControlEntry)(nil)).Elem()
}

type ArrayOfHostAccountSpec struct {
	HostAccountSpec []BaseHostAccountSpec `xml:"HostAccountSpec,omitempty,typeattr"`
}

func init() {
	t["ArrayOfHostAccountSpec"] = reflect.TypeOf((*ArrayOfHostAccountSpec)(nil)).Elem()
}

type ArrayOfHostActiveDirectory struct {
	HostActiveDirectory []HostActiveDirectory `xml:"HostActiveDirectory,omitempty"`
}

func init() {
	t["ArrayOfHostActiveDirectory"] = reflect.TypeOf((*ArrayOfHostActiveDirectory)(nil)).Elem()
}

type ArrayOfHostAssignableHardwareBinding struct {
	HostAssignableHardwareBinding []HostAssignableHardwareBinding `xml:"HostAssignableHardwareBinding,omitempty"`
}

func init() {
	t["ArrayOfHostAssignableHardwareBinding"] = reflect.TypeOf((*ArrayOfHostAssignableHardwareBinding)(nil)).Elem()
}

type ArrayOfHostAssignableHardwareConfigAttributeOverride struct {
	HostAssignableHardwareConfigAttributeOverride []HostAssignableHardwareConfigAttributeOverride `xml:"HostAssignableHardwareConfigAttributeOverride,omitempty"`
}

func init() {
	t["ArrayOfHostAssignableHardwareConfigAttributeOverride"] = reflect.TypeOf((*ArrayOfHostAssignableHardwareConfigAttributeOverride)(nil)).Elem()
}

type ArrayOfHostAuthenticationStoreInfo struct {
	HostAuthenticationStoreInfo []BaseHostAuthenticationStoreInfo `xml:"HostAuthenticationStoreInfo,omitempty,typeattr"`
}

func init() {
	t["ArrayOfHostAuthenticationStoreInfo"] = reflect.TypeOf((*ArrayOfHostAuthenticationStoreInfo)(nil)).Elem()
}

type ArrayOfHostBootDevice struct {
	HostBootDevice []HostBootDevice `xml:"HostBootDevice,omitempty"`
}

func init() {
	t["ArrayOfHostBootDevice"] = reflect.TypeOf((*ArrayOfHostBootDevice)(nil)).Elem()
}

type ArrayOfHostCacheConfigurationInfo struct {
	HostCacheConfigurationInfo []HostCacheConfigurationInfo `xml:"HostCacheConfigurationInfo,omitempty"`
}

func init() {
	t["ArrayOfHostCacheConfigurationInfo"] = reflect.TypeOf((*ArrayOfHostCacheConfigurationInfo)(nil)).Elem()
}

type ArrayOfHostConnectInfoNetworkInfo struct {
	HostConnectInfoNetworkInfo []BaseHostConnectInfoNetworkInfo `xml:"HostConnectInfoNetworkInfo,omitempty,typeattr"`
}

func init() {
	t["ArrayOfHostConnectInfoNetworkInfo"] = reflect.TypeOf((*ArrayOfHostConnectInfoNetworkInfo)(nil)).Elem()
}

type ArrayOfHostConnectSpec struct {
	HostConnectSpec []HostConnectSpec `xml:"HostConnectSpec,omitempty"`
}

func init() {
	t["ArrayOfHostConnectSpec"] = reflect.TypeOf((*ArrayOfHostConnectSpec)(nil)).Elem()
}

type ArrayOfHostCpuIdInfo struct {
	HostCpuIdInfo []HostCpuIdInfo `xml:"HostCpuIdInfo,omitempty"`
}

func init() {
	t["ArrayOfHostCpuIdInfo"] = reflect.TypeOf((*ArrayOfHostCpuIdInfo)(nil)).Elem()
}

type ArrayOfHostCpuPackage struct {
	HostCpuPackage []HostCpuPackage `xml:"HostCpuPackage,omitempty"`
}

func init() {
	t["ArrayOfHostCpuPackage"] = reflect.TypeOf((*ArrayOfHostCpuPackage)(nil)).Elem()
}

type ArrayOfHostDatastoreBrowserSearchResults struct {
	HostDatastoreBrowserSearchResults []HostDatastoreBrowserSearchResults `xml:"HostDatastoreBrowserSearchResults,omitempty"`
}

func init() {
	t["ArrayOfHostDatastoreBrowserSearchResults"] = reflect.TypeOf((*ArrayOfHostDatastoreBrowserSearchResults)(nil)).Elem()
}

type ArrayOfHostDatastoreConnectInfo struct {
	HostDatastoreConnectInfo []BaseHostDatastoreConnectInfo `xml:"HostDatastoreConnectInfo,omitempty,typeattr"`
}

func init() {
	t["ArrayOfHostDatastoreConnectInfo"] = reflect.TypeOf((*ArrayOfHostDatastoreConnectInfo)(nil)).Elem()
}

type ArrayOfHostDatastoreSystemDatastoreResult struct {
	HostDatastoreSystemDatastoreResult []HostDatastoreSystemDatastoreResult `xml:"HostDatastoreSystemDatastoreResult,omitempty"`
}

func init() {
	t["ArrayOfHostDatastoreSystemDatastoreResult"] = reflect.TypeOf((*ArrayOfHostDatastoreSystemDatastoreResult)(nil)).Elem()
}

type ArrayOfHostDateTimeSystemTimeZone struct {
	HostDateTimeSystemTimeZone []HostDateTimeSystemTimeZone `xml:"HostDateTimeSystemTimeZone,omitempty"`
}

func init() {
	t["ArrayOfHostDateTimeSystemTimeZone"] = reflect.TypeOf((*ArrayOfHostDateTimeSystemTimeZone)(nil)).Elem()
}

type ArrayOfHostDhcpService struct {
	HostDhcpService []HostDhcpService `xml:"HostDhcpService,omitempty"`
}

func init() {
	t["ArrayOfHostDhcpService"] = reflect.TypeOf((*ArrayOfHostDhcpService)(nil)).Elem()
}

type ArrayOfHostDhcpServiceConfig struct {
	HostDhcpServiceConfig []HostDhcpServiceConfig `xml:"HostDhcpServiceConfig,omitempty"`
}

func init() {
	t["ArrayOfHostDhcpServiceConfig"] = reflect.TypeOf((*ArrayOfHostDhcpServiceConfig)(nil)).Elem()
}

type ArrayOfHostDiagnosticPartition struct {
	HostDiagnosticPartition []HostDiagnosticPartition `xml:"HostDiagnosticPartition,omitempty"`
}

func init() {
	t["ArrayOfHostDiagnosticPartition"] = reflect.TypeOf((*ArrayOfHostDiagnosticPartition)(nil)).Elem()
}

type ArrayOfHostDiagnosticPartitionCreateOption struct {
	HostDiagnosticPartitionCreateOption []HostDiagnosticPartitionCreateOption `xml:"HostDiagnosticPartitionCreateOption,omitempty"`
}

func init() {
	t["ArrayOfHostDiagnosticPartitionCreateOption"] = reflect.TypeOf((*ArrayOfHostDiagnosticPartitionCreateOption)(nil)).Elem()
}

type ArrayOfHostDiskConfigurationResult struct {
	HostDiskConfigurationResult []HostDiskConfigurationResult `xml:"HostDiskConfigurationResult,omitempty"`
}

func init() {
	t["ArrayOfHostDiskConfigurationResult"] = reflect.TypeOf((*ArrayOfHostDiskConfigurationResult)(nil)).Elem()
}

type ArrayOfHostDiskMappingPartitionOption struct {
	HostDiskMappingPartitionOption []HostDiskMappingPartitionOption `xml:"HostDiskMappingPartitionOption,omitempty"`
}

func init() {
	t["ArrayOfHostDiskMappingPartitionOption"] = reflect.TypeOf((*ArrayOfHostDiskMappingPartitionOption)(nil)).Elem()
}

type ArrayOfHostDiskPartitionAttributes struct {
	HostDiskPartitionAttributes []HostDiskPartitionAttributes `xml:"HostDiskPartitionAttributes,omitempty"`
}

func init() {
	t["ArrayOfHostDiskPartitionAttributes"] = reflect.TypeOf((*ArrayOfHostDiskPartitionAttributes)(nil)).Elem()
}

type ArrayOfHostDiskPartitionBlockRange struct {
	HostDiskPartitionBlockRange []HostDiskPartitionBlockRange `xml:"HostDiskPartitionBlockRange,omitempty"`
}

func init() {
	t["ArrayOfHostDiskPartitionBlockRange"] = reflect.TypeOf((*ArrayOfHostDiskPartitionBlockRange)(nil)).Elem()
}

type ArrayOfHostDiskPartitionInfo struct {
	HostDiskPartitionInfo []HostDiskPartitionInfo `xml:"HostDiskPartitionInfo,omitempty"`
}

func init() {
	t["ArrayOfHostDiskPartitionInfo"] = reflect.TypeOf((*ArrayOfHostDiskPartitionInfo)(nil)).Elem()
}

type ArrayOfHostEventArgument struct {
	HostEventArgument []HostEventArgument `xml:"HostEventArgument,omitempty"`
}

func init() {
	t["ArrayOfHostEventArgument"] = reflect.TypeOf((*ArrayOfHostEventArgument)(nil)).Elem()
}

type ArrayOfHostFeatureCapability struct {
	HostFeatureCapability []HostFeatureCapability `xml:"HostFeatureCapability,omitempty"`
}

func init() {
	t["ArrayOfHostFeatureCapability"] = reflect.TypeOf((*ArrayOfHostFeatureCapability)(nil)).Elem()
}

type ArrayOfHostFeatureMask struct {
	HostFeatureMask []HostFeatureMask `xml:"HostFeatureMask,omitempty"`
}

func init() {
	t["ArrayOfHostFeatureMask"] = reflect.TypeOf((*ArrayOfHostFeatureMask)(nil)).Elem()
}

type ArrayOfHostFeatureVersionInfo struct {
	HostFeatureVersionInfo []HostFeatureVersionInfo `xml:"HostFeatureVersionInfo,omitempty"`
}

func init() {
	t["ArrayOfHostFeatureVersionInfo"] = reflect.TypeOf((*ArrayOfHostFeatureVersionInfo)(nil)).Elem()
}

type ArrayOfHostFileSystemMountInfo struct {
	HostFileSystemMountInfo []HostFileSystemMountInfo `xml:"HostFileSystemMountInfo,omitempty"`
}

func init() {
	t["ArrayOfHostFileSystemMountInfo"] = reflect.TypeOf((*ArrayOfHostFileSystemMountInfo)(nil)).Elem()
}

type ArrayOfHostFirewallConfigRuleSetConfig struct {
	HostFirewallConfigRuleSetConfig []HostFirewallConfigRuleSetConfig `xml:"HostFirewallConfigRuleSetConfig,omitempty"`
}

func init() {
	t["ArrayOfHostFirewallConfigRuleSetConfig"] = reflect.TypeOf((*ArrayOfHostFirewallConfigRuleSetConfig)(nil)).Elem()
}

type ArrayOfHostFirewallRule struct {
	HostFirewallRule []HostFirewallRule `xml:"HostFirewallRule,omitempty"`
}

func init() {
	t["ArrayOfHostFirewallRule"] = reflect.TypeOf((*ArrayOfHostFirewallRule)(nil)).Elem()
}

type ArrayOfHostFirewallRuleset struct {
	HostFirewallRuleset []HostFirewallRuleset `xml:"HostFirewallRuleset,omitempty"`
}

func init() {
	t["ArrayOfHostFirewallRuleset"] = reflect.TypeOf((*ArrayOfHostFirewallRuleset)(nil)).Elem()
}

type ArrayOfHostFirewallRulesetIpNetwork struct {
	HostFirewallRulesetIpNetwork []HostFirewallRulesetIpNetwork `xml:"HostFirewallRulesetIpNetwork,omitempty"`
}

func init() {
	t["ArrayOfHostFirewallRulesetIpNetwork"] = reflect.TypeOf((*ArrayOfHostFirewallRulesetIpNetwork)(nil)).Elem()
}

type ArrayOfHostGraphicsConfigDeviceType struct {
	HostGraphicsConfigDeviceType []HostGraphicsConfigDeviceType `xml:"HostGraphicsConfigDeviceType,omitempty"`
}

func init() {
	t["ArrayOfHostGraphicsConfigDeviceType"] = reflect.TypeOf((*ArrayOfHostGraphicsConfigDeviceType)(nil)).Elem()
}

type ArrayOfHostGraphicsInfo struct {
	HostGraphicsInfo []HostGraphicsInfo `xml:"HostGraphicsInfo,omitempty"`
}

func init() {
	t["ArrayOfHostGraphicsInfo"] = reflect.TypeOf((*ArrayOfHostGraphicsInfo)(nil)).Elem()
}

type ArrayOfHostHardwareElementInfo struct {
	HostHardwareElementInfo []BaseHostHardwareElementInfo `xml:"HostHardwareElementInfo,omitempty,typeattr"`
}

func init() {
	t["ArrayOfHostHardwareElementInfo"] = reflect.TypeOf((*ArrayOfHostHardwareElementInfo)(nil)).Elem()
}

type ArrayOfHostHostBusAdapter struct {
	HostHostBusAdapter []BaseHostHostBusAdapter `xml:"HostHostBusAdapter,omitempty,typeattr"`
}

func init() {
	t["ArrayOfHostHostBusAdapter"] = reflect.TypeOf((*ArrayOfHostHostBusAdapter)(nil)).Elem()
}

type ArrayOfHostInternetScsiHbaIscsiIpv6Address struct {
	HostInternetScsiHbaIscsiIpv6Address []HostInternetScsiHbaIscsiIpv6Address `xml:"HostInternetScsiHbaIscsiIpv6Address,omitempty"`
}

func init() {
	t["ArrayOfHostInternetScsiHbaIscsiIpv6Address"] = reflect.TypeOf((*ArrayOfHostInternetScsiHbaIscsiIpv6Address)(nil)).Elem()
}

type ArrayOfHostInternetScsiHbaParamValue struct {
	HostInternetScsiHbaParamValue []HostInternetScsiHbaParamValue `xml:"HostInternetScsiHbaParamValue,omitempty"`
}

func init() {
	t["ArrayOfHostInternetScsiHbaParamValue"] = reflect.TypeOf((*ArrayOfHostInternetScsiHbaParamValue)(nil)).Elem()
}

type ArrayOfHostInternetScsiHbaSendTarget struct {
	HostInternetScsiHbaSendTarget []HostInternetScsiHbaSendTarget `xml:"HostInternetScsiHbaSendTarget,omitempty"`
}

func init() {
	t["ArrayOfHostInternetScsiHbaSendTarget"] = reflect.TypeOf((*ArrayOfHostInternetScsiHbaSendTarget)(nil)).Elem()
}

type ArrayOfHostInternetScsiHbaStaticTarget struct {
	HostInternetScsiHbaStaticTarget []HostInternetScsiHbaStaticTarget `xml:"HostInternetScsiHbaStaticTarget,omitempty"`
}

func init() {
	t["ArrayOfHostInternetScsiHbaStaticTarget"] = reflect.TypeOf((*ArrayOfHostInternetScsiHbaStaticTarget)(nil)).Elem()
}

type ArrayOfHostIoFilterInfo struct {
	HostIoFilterInfo []HostIoFilterInfo `xml:"HostIoFilterInfo,omitempty"`
}

func init() {
	t["ArrayOfHostIoFilterInfo"] = reflect.TypeOf((*ArrayOfHostIoFilterInfo)(nil)).Elem()
}

type ArrayOfHostIpConfigIpV6Address struct {
	HostIpConfigIpV6Address []HostIpConfigIpV6Address `xml:"HostIpConfigIpV6Address,omitempty"`
}

func init() {
	t["ArrayOfHostIpConfigIpV6Address"] = reflect.TypeOf((*ArrayOfHostIpConfigIpV6Address)(nil)).Elem()
}

type ArrayOfHostIpRouteEntry struct {
	HostIpRouteEntry []HostIpRouteEntry `xml:"HostIpRouteEntry,omitempty"`
}

func init() {
	t["ArrayOfHostIpRouteEntry"] = reflect.TypeOf((*ArrayOfHostIpRouteEntry)(nil)).Elem()
}

type ArrayOfHostIpRouteOp struct {
	HostIpRouteOp []HostIpRouteOp `xml:"HostIpRouteOp,omitempty"`
}

func init() {
	t["ArrayOfHostIpRouteOp"] = reflect.TypeOf((*ArrayOfHostIpRouteOp)(nil)).Elem()
}

type ArrayOfHostLowLevelProvisioningManagerDiskLayoutSpec struct {
	HostLowLevelProvisioningManagerDiskLayoutSpec []HostLowLevelProvisioningManagerDiskLayoutSpec `xml:"HostLowLevelProvisioningManagerDiskLayoutSpec,omitempty"`
}

func init() {
	t["ArrayOfHostLowLevelProvisioningManagerDiskLayoutSpec"] = reflect.TypeOf((*ArrayOfHostLowLevelProvisioningManagerDiskLayoutSpec)(nil)).Elem()
}

type ArrayOfHostLowLevelProvisioningManagerFileDeleteResult struct {
	HostLowLevelProvisioningManagerFileDeleteResult []HostLowLevelProvisioningManagerFileDeleteResult `xml:"HostLowLevelProvisioningManagerFileDeleteResult,omitempty"`
}

func init() {
	t["ArrayOfHostLowLevelProvisioningManagerFileDeleteResult"] = reflect.TypeOf((*ArrayOfHostLowLevelProvisioningManagerFileDeleteResult)(nil)).Elem()
}

type ArrayOfHostLowLevelProvisioningManagerFileDeleteSpec struct {
	HostLowLevelProvisioningManagerFileDeleteSpec []HostLowLevelProvisioningManagerFileDeleteSpec `xml:"HostLowLevelProvisioningManagerFileDeleteSpec,omitempty"`
}

func init() {
	t["ArrayOfHostLowLevelProvisioningManagerFileDeleteSpec"] = reflect.TypeOf((*ArrayOfHostLowLevelProvisioningManagerFileDeleteSpec)(nil)).Elem()
}

type ArrayOfHostLowLevelProvisioningManagerFileReserveResult struct {
	HostLowLevelProvisioningManagerFileReserveResult []HostLowLevelProvisioningManagerFileReserveResult `xml:"HostLowLevelProvisioningManagerFileReserveResult,omitempty"`
}

func init() {
	t["ArrayOfHostLowLevelProvisioningManagerFileReserveResult"] = reflect.TypeOf((*ArrayOfHostLowLevelProvisioningManagerFileReserveResult)(nil)).Elem()
}

type ArrayOfHostLowLevelProvisioningManagerFileReserveSpec struct {
	HostLowLevelProvisioningManagerFileReserveSpec []HostLowLevelProvisioningManagerFileReserveSpec `xml:"HostLowLevelProvisioningManagerFileReserveSpec,omitempty"`
}

func init() {
	t["ArrayOfHostLowLevelProvisioningManagerFileReserveSpec"] = reflect.TypeOf((*ArrayOfHostLowLevelProvisioningManagerFileReserveSpec)(nil)).Elem()
}

type ArrayOfHostLowLevelProvisioningManagerSnapshotLayoutSpec struct {
	HostLowLevelProvisioningManagerSnapshotLayoutSpec []HostLowLevelProvisioningManagerSnapshotLayoutSpec `xml:"HostLowLevelProvisioningManagerSnapshotLayoutSpec,omitempty"`
}

func init() {
	t["ArrayOfHostLowLevelProvisioningManagerSnapshotLayoutSpec"] = reflect.TypeOf((*ArrayOfHostLowLevelProvisioningManagerSnapshotLayoutSpec)(nil)).Elem()
}

type ArrayOfHostMemberHealthCheckResult struct {
	HostMemberHealthCheckResult []BaseHostMemberHealthCheckResult `xml:"HostMemberHealthCheckResult,omitempty,typeattr"`
}

func init() {
	t["ArrayOfHostMemberHealthCheckResult"] = reflect.TypeOf((*ArrayOfHostMemberHealthCheckResult)(nil)).Elem()
}

type ArrayOfHostMemberRuntimeInfo struct {
	HostMemberRuntimeInfo []HostMemberRuntimeInfo `xml:"HostMemberRuntimeInfo,omitempty"`
}

func init() {
	t["ArrayOfHostMemberRuntimeInfo"] = reflect.TypeOf((*ArrayOfHostMemberRuntimeInfo)(nil)).Elem()
}

type ArrayOfHostMemoryTierInfo struct {
	HostMemoryTierInfo []HostMemoryTierInfo `xml:"HostMemoryTierInfo,omitempty"`
}

func init() {
	t["ArrayOfHostMemoryTierInfo"] = reflect.TypeOf((*ArrayOfHostMemoryTierInfo)(nil)).Elem()
}

type ArrayOfHostMultipathInfoLogicalUnit struct {
	HostMultipathInfoLogicalUnit []HostMultipathInfoLogicalUnit `xml:"HostMultipathInfoLogicalUnit,omitempty"`
}

func init() {
	t["ArrayOfHostMultipathInfoLogicalUnit"] = reflect.TypeOf((*ArrayOfHostMultipathInfoLogicalUnit)(nil)).Elem()
}

type ArrayOfHostMultipathInfoPath struct {
	HostMultipathInfoPath []HostMultipathInfoPath `xml:"HostMultipathInfoPath,omitempty"`
}

func init() {
	t["ArrayOfHostMultipathInfoPath"] = reflect.TypeOf((*ArrayOfHostMultipathInfoPath)(nil)).Elem()
}

type ArrayOfHostMultipathStateInfoPath struct {
	HostMultipathStateInfoPath []HostMultipathStateInfoPath `xml:"HostMultipathStateInfoPath,omitempty"`
}

func init() {
	t["ArrayOfHostMultipathStateInfoPath"] = reflect.TypeOf((*ArrayOfHostMultipathStateInfoPath)(nil)).Elem()
}

type ArrayOfHostNasVolumeConfig struct {
	HostNasVolumeConfig []HostNasVolumeConfig `xml:"HostNasVolumeConfig,omitempty"`
}

func init() {
	t["ArrayOfHostNasVolumeConfig"] = reflect.TypeOf((*ArrayOfHostNasVolumeConfig)(nil)).Elem()
}

type ArrayOfHostNatService struct {
	HostNatService []HostNatService `xml:"HostNatService,omitempty"`
}

func init() {
	t["ArrayOfHostNatService"] = reflect.TypeOf((*ArrayOfHostNatService)(nil)).Elem()
}

type ArrayOfHostNatServiceConfig struct {
	HostNatServiceConfig []HostNatServiceConfig `xml:"HostNatServiceConfig,omitempty"`
}

func init() {
	t["ArrayOfHostNatServiceConfig"] = reflect.TypeOf((*ArrayOfHostNatServiceConfig)(nil)).Elem()
}

type ArrayOfHostNatServicePortForwardSpec struct {
	HostNatServicePortForwardSpec []HostNatServicePortForwardSpec `xml:"HostNatServicePortForwardSpec,omitempty"`
}

func init() {
	t["ArrayOfHostNatServicePortForwardSpec"] = reflect.TypeOf((*ArrayOfHostNatServicePortForwardSpec)(nil)).Elem()
}

type ArrayOfHostNetStackInstance struct {
	HostNetStackInstance []HostNetStackInstance `xml:"HostNetStackInstance,omitempty"`
}

func init() {
	t["ArrayOfHostNetStackInstance"] = reflect.TypeOf((*ArrayOfHostNetStackInstance)(nil)).Elem()
}

type ArrayOfHostNetworkConfigNetStackSpec struct {
	HostNetworkConfigNetStackSpec []HostNetworkConfigNetStackSpec `xml:"HostNetworkConfigNetStackSpec,omitempty"`
}

func init() {
	t["ArrayOfHostNetworkConfigNetStackSpec"] = reflect.TypeOf((*ArrayOfHostNetworkConfigNetStackSpec)(nil)).Elem()
}

type ArrayOfHostNumaNode struct {
	HostNumaNode []HostNumaNode `xml:"HostNumaNode,omitempty"`
}

func init() {
	t["ArrayOfHostNumaNode"] = reflect.TypeOf((*ArrayOfHostNumaNode)(nil)).Elem()
}

type ArrayOfHostNumericSensorInfo struct {
	HostNumericSensorInfo []HostNumericSensorInfo `xml:"HostNumericSensorInfo,omitempty"`
}

func init() {
	t["ArrayOfHostNumericSensorInfo"] = reflect.TypeOf((*ArrayOfHostNumericSensorInfo)(nil)).Elem()
}

type ArrayOfHostNvmeConnectSpec struct {
	HostNvmeConnectSpec []HostNvmeConnectSpec `xml:"HostNvmeConnectSpec,omitempty"`
}

func init() {
	t["ArrayOfHostNvmeConnectSpec"] = reflect.TypeOf((*ArrayOfHostNvmeConnectSpec)(nil)).Elem()
}

type ArrayOfHostNvmeController struct {
	HostNvmeController []HostNvmeController `xml:"HostNvmeController,omitempty"`
}

func init() {
	t["ArrayOfHostNvmeController"] = reflect.TypeOf((*ArrayOfHostNvmeController)(nil)).Elem()
}

type ArrayOfHostNvmeDisconnectSpec struct {
	HostNvmeDisconnectSpec []HostNvmeDisconnectSpec `xml:"HostNvmeDisconnectSpec,omitempty"`
}

func init() {
	t["ArrayOfHostNvmeDisconnectSpec"] = reflect.TypeOf((*ArrayOfHostNvmeDisconnectSpec)(nil)).Elem()
}

type ArrayOfHostNvmeDiscoveryLogEntry struct {
	HostNvmeDiscoveryLogEntry []HostNvmeDiscoveryLogEntry `xml:"HostNvmeDiscoveryLogEntry,omitempty"`
}

func init() {
	t["ArrayOfHostNvmeDiscoveryLogEntry"] = reflect.TypeOf((*ArrayOfHostNvmeDiscoveryLogEntry)(nil)).Elem()
}

type ArrayOfHostNvmeNamespace struct {
	HostNvmeNamespace []HostNvmeNamespace `xml:"HostNvmeNamespace,omitempty"`
}

func init() {
	t["ArrayOfHostNvmeNamespace"] = reflect.TypeOf((*ArrayOfHostNvmeNamespace)(nil)).Elem()
}

type ArrayOfHostNvmeTopologyInterface struct {
	HostNvmeTopologyInterface []HostNvmeTopologyInterface `xml:"HostNvmeTopologyInterface,omitempty"`
}

func init() {
	t["ArrayOfHostNvmeTopologyInterface"] = reflect.TypeOf((*ArrayOfHostNvmeTopologyInterface)(nil)).Elem()
}

type ArrayOfHostOpaqueNetworkInfo struct {
	HostOpaqueNetworkInfo []HostOpaqueNetworkInfo `xml:"HostOpaqueNetworkInfo,omitempty"`
}

func init() {
	t["ArrayOfHostOpaqueNetworkInfo"] = reflect.TypeOf((*ArrayOfHostOpaqueNetworkInfo)(nil)).Elem()
}

type ArrayOfHostOpaqueSwitch struct {
	HostOpaqueSwitch []HostOpaqueSwitch `xml:"HostOpaqueSwitch,omitempty"`
}

func init() {
	t["ArrayOfHostOpaqueSwitch"] = reflect.TypeOf((*ArrayOfHostOpaqueSwitch)(nil)).Elem()
}

type ArrayOfHostOpaqueSwitchPhysicalNicZone struct {
	HostOpaqueSwitchPhysicalNicZone []HostOpaqueSwitchPhysicalNicZone `xml:"HostOpaqueSwitchPhysicalNicZone,omitempty"`
}

func init() {
	t["ArrayOfHostOpaqueSwitchPhysicalNicZone"] = reflect.TypeOf((*ArrayOfHostOpaqueSwitchPhysicalNicZone)(nil)).Elem()
}

type ArrayOfHostPatchManagerStatus struct {
	HostPatchManagerStatus []HostPatchManagerStatus `xml:"HostPatchManagerStatus,omitempty"`
}

func init() {
	t["ArrayOfHostPatchManagerStatus"] = reflect.TypeOf((*ArrayOfHostPatchManagerStatus)(nil)).Elem()
}

type ArrayOfHostPatchManagerStatusPrerequisitePatch struct {
	HostPatchManagerStatusPrerequisitePatch []HostPatchManagerStatusPrerequisitePatch `xml:"HostPatchManagerStatusPrerequisitePatch,omitempty"`
}

func init() {
	t["ArrayOfHostPatchManagerStatusPrerequisitePatch"] = reflect.TypeOf((*ArrayOfHostPatchManagerStatusPrerequisitePatch)(nil)).Elem()
}

type ArrayOfHostPathSelectionPolicyOption struct {
	HostPathSelectionPolicyOption []HostPathSelectionPolicyOption `xml:"HostPathSelectionPolicyOption,omitempty"`
}

func init() {
	t["ArrayOfHostPathSelectionPolicyOption"] = reflect.TypeOf((*ArrayOfHostPathSelectionPolicyOption)(nil)).Elem()
}

type ArrayOfHostPciDevice struct {
	HostPciDevice []HostPciDevice `xml:"HostPciDevice,omitempty"`
}

func init() {
	t["ArrayOfHostPciDevice"] = reflect.TypeOf((*ArrayOfHostPciDevice)(nil)).Elem()
}

type ArrayOfHostPciPassthruConfig struct {
	HostPciPassthruConfig []BaseHostPciPassthruConfig `xml:"HostPciPassthruConfig,omitempty,typeattr"`
}

func init() {
	t["ArrayOfHostPciPassthruConfig"] = reflect.TypeOf((*ArrayOfHostPciPassthruConfig)(nil)).Elem()
}

type ArrayOfHostPciPassthruInfo struct {
	HostPciPassthruInfo []BaseHostPciPassthruInfo `xml:"HostPciPassthruInfo,omitempty,typeattr"`
}

func init() {
	t["ArrayOfHostPciPassthruInfo"] = reflect.TypeOf((*ArrayOfHostPciPassthruInfo)(nil)).Elem()
}

type ArrayOfHostPlacedVirtualNicIdentifier struct {
	HostPlacedVirtualNicIdentifier []HostPlacedVirtualNicIdentifier `xml:"HostPlacedVirtualNicIdentifier,omitempty"`
}

func init() {
	t["ArrayOfHostPlacedVirtualNicIdentifier"] = reflect.TypeOf((*ArrayOfHostPlacedVirtualNicIdentifier)(nil)).Elem()
}

type ArrayOfHostPlugStoreTopologyAdapter struct {
	HostPlugStoreTopologyAdapter []HostPlugStoreTopologyAdapter `xml:"HostPlugStoreTopologyAdapter,omitempty"`
}

func init() {
	t["ArrayOfHostPlugStoreTopologyAdapter"] = reflect.TypeOf((*ArrayOfHostPlugStoreTopologyAdapter)(nil)).Elem()
}

type ArrayOfHostPlugStoreTopologyDevice struct {
	HostPlugStoreTopologyDevice []HostPlugStoreTopologyDevice `xml:"HostPlugStoreTopologyDevice,omitempty"`
}

func init() {
	t["ArrayOfHostPlugStoreTopologyDevice"] = reflect.TypeOf((*ArrayOfHostPlugStoreTopologyDevice)(nil)).Elem()
}

type ArrayOfHostPlugStoreTopologyPath struct {
	HostPlugStoreTopologyPath []HostPlugStoreTopologyPath `xml:"HostPlugStoreTopologyPath,omitempty"`
}

func init() {
	t["ArrayOfHostPlugStoreTopologyPath"] = reflect.TypeOf((*ArrayOfHostPlugStoreTopologyPath)(nil)).Elem()
}

type ArrayOfHostPlugStoreTopologyPlugin struct {
	HostPlugStoreTopologyPlugin []HostPlugStoreTopologyPlugin `xml:"HostPlugStoreTopologyPlugin,omitempty"`
}

func init() {
	t["ArrayOfHostPlugStoreTopologyPlugin"] = reflect.TypeOf((*ArrayOfHostPlugStoreTopologyPlugin)(nil)).Elem()
}

type ArrayOfHostPlugStoreTopologyTarget struct {
	HostPlugStoreTopologyTarget []HostPlugStoreTopologyTarget `xml:"HostPlugStoreTopologyTarget,omitempty"`
}

func init() {
	t["ArrayOfHostPlugStoreTopologyTarget"] = reflect.TypeOf((*ArrayOfHostPlugStoreTopologyTarget)(nil)).Elem()
}

type ArrayOfHostPnicNetworkResourceInfo struct {
	HostPnicNetworkResourceInfo []HostPnicNetworkResourceInfo `xml:"HostPnicNetworkResourceInfo,omitempty"`
}

func init() {
	t["ArrayOfHostPnicNetworkResourceInfo"] = reflect.TypeOf((*ArrayOfHostPnicNetworkResourceInfo)(nil)).Elem()
}

type ArrayOfHostPortGroup struct {
	HostPortGroup []HostPortGroup `xml:"HostPortGroup,omitempty"`
}

func init() {
	t["ArrayOfHostPortGroup"] = reflect.TypeOf((*ArrayOfHostPortGroup)(nil)).Elem()
}

type ArrayOfHostPortGroupConfig struct {
	HostPortGroupConfig []HostPortGroupConfig `xml:"HostPortGroupConfig,omitempty"`
}

func init() {
	t["ArrayOfHostPortGroupConfig"] = reflect.TypeOf((*ArrayOfHostPortGroupConfig)(nil)).Elem()
}

type ArrayOfHostPortGroupPort struct {
	HostPortGroupPort []HostPortGroupPort `xml:"HostPortGroupPort,omitempty"`
}

func init() {
	t["ArrayOfHostPortGroupPort"] = reflect.TypeOf((*ArrayOfHostPortGroupPort)(nil)).Elem()
}

type ArrayOfHostPortGroupProfile struct {
	HostPortGroupProfile []HostPortGroupProfile `xml:"HostPortGroupProfile,omitempty"`
}

func init() {
	t["ArrayOfHostPortGroupProfile"] = reflect.TypeOf((*ArrayOfHostPortGroupProfile)(nil)).Elem()
}

type ArrayOfHostPowerPolicy struct {
	HostPowerPolicy []HostPowerPolicy `xml:"HostPowerPolicy,omitempty"`
}

func init() {
	t["ArrayOfHostPowerPolicy"] = reflect.TypeOf((*ArrayOfHostPowerPolicy)(nil)).Elem()
}

type ArrayOfHostProfileManagerCompositionResultResultElement struct {
	HostProfileManagerCompositionResultResultElement []HostProfileManagerCompositionResultResultElement `xml:"HostProfileManagerCompositionResultResultElement,omitempty"`
}

func init() {
	t["ArrayOfHostProfileManagerCompositionResultResultElement"] = reflect.TypeOf((*ArrayOfHostProfileManagerCompositionResultResultElement)(nil)).Elem()
}

type ArrayOfHostProfileManagerCompositionValidationResultResultElement struct {
	HostProfileManagerCompositionValidationResultResultElement []HostProfileManagerCompositionValidationResultResultElement `xml:"HostProfileManagerCompositionValidationResultResultElement,omitempty"`
}

func init() {
	t["ArrayOfHostProfileManagerCompositionValidationResultResultElement"] = reflect.TypeOf((*ArrayOfHostProfileManagerCompositionValidationResultResultElement)(nil)).Elem()
}

type ArrayOfHostProfilesEntityCustomizations struct {
	HostProfilesEntityCustomizations []BaseHostProfilesEntityCustomizations `xml:"HostProfilesEntityCustomizations,omitempty,typeattr"`
}

func init() {
	t["ArrayOfHostProfilesEntityCustomizations"] = reflect.TypeOf((*ArrayOfHostProfilesEntityCustomizations)(nil)).Elem()
}

type ArrayOfHostProtocolEndpoint struct {
	HostProtocolEndpoint []HostProtocolEndpoint `xml:"HostProtocolEndpoint,omitempty"`
}

func init() {
	t["ArrayOfHostProtocolEndpoint"] = reflect.TypeOf((*ArrayOfHostProtocolEndpoint)(nil)).Elem()
}

type ArrayOfHostProxySwitch struct {
	HostProxySwitch []HostProxySwitch `xml:"HostProxySwitch,omitempty"`
}

func init() {
	t["ArrayOfHostProxySwitch"] = reflect.TypeOf((*ArrayOfHostProxySwitch)(nil)).Elem()
}

type ArrayOfHostProxySwitchConfig struct {
	HostProxySwitchConfig []HostProxySwitchConfig `xml:"HostProxySwitchConfig,omitempty"`
}

func init() {
	t["ArrayOfHostProxySwitchConfig"] = reflect.TypeOf((*ArrayOfHostProxySwitchConfig)(nil)).Elem()
}

type ArrayOfHostProxySwitchHostLagConfig struct {
	HostProxySwitchHostLagConfig []HostProxySwitchHostLagConfig `xml:"HostProxySwitchHostLagConfig,omitempty"`
}

func init() {
	t["ArrayOfHostProxySwitchHostLagConfig"] = reflect.TypeOf((*ArrayOfHostProxySwitchHostLagConfig)(nil)).Elem()
}

type ArrayOfHostPtpConfigPtpPort struct {
	HostPtpConfigPtpPort []HostPtpConfigPtpPort `xml:"HostPtpConfigPtpPort,omitempty"`
}

func init() {
	t["ArrayOfHostPtpConfigPtpPort"] = reflect.TypeOf((*ArrayOfHostPtpConfigPtpPort)(nil)).Elem()
}

type ArrayOfHostQualifiedName struct {
	HostQualifiedName []HostQualifiedName `xml:"HostQualifiedName,omitempty"`
}

func init() {
	t["ArrayOfHostQualifiedName"] = reflect.TypeOf((*ArrayOfHostQualifiedName)(nil)).Elem()
}

type ArrayOfHostRdmaDevice struct {
	HostRdmaDevice []HostRdmaDevice `xml:"HostRdmaDevice,omitempty"`
}

func init() {
	t["ArrayOfHostRdmaDevice"] = reflect.TypeOf((*ArrayOfHostRdmaDevice)(nil)).Elem()
}

type ArrayOfHostRuntimeInfoNetStackInstanceRuntimeInfo struct {
	HostRuntimeInfoNetStackInstanceRuntimeInfo []HostRuntimeInfoNetStackInstanceRuntimeInfo `xml:"HostRuntimeInfoNetStackInstanceRuntimeInfo,omitempty"`
}

func init() {
	t["ArrayOfHostRuntimeInfoNetStackInstanceRuntimeInfo"] = reflect.TypeOf((*ArrayOfHostRuntimeInfoNetStackInstanceRuntimeInfo)(nil)).Elem()
}

type ArrayOfHostScsiDisk struct {
	HostScsiDisk []HostScsiDisk `xml:"HostScsiDisk,omitempty"`
}

func init() {
	t["ArrayOfHostScsiDisk"] = reflect.TypeOf((*ArrayOfHostScsiDisk)(nil)).Elem()
}

type ArrayOfHostScsiDiskPartition struct {
	HostScsiDiskPartition []HostScsiDiskPartition `xml:"HostScsiDiskPartition,omitempty"`
}

func init() {
	t["ArrayOfHostScsiDiskPartition"] = reflect.TypeOf((*ArrayOfHostScsiDiskPartition)(nil)).Elem()
}

type ArrayOfHostScsiTopologyInterface struct {
	HostScsiTopologyInterface []HostScsiTopologyInterface `xml:"HostScsiTopologyInterface,omitempty"`
}

func init() {
	t["ArrayOfHostScsiTopologyInterface"] = reflect.TypeOf((*ArrayOfHostScsiTopologyInterface)(nil)).Elem()
}

type ArrayOfHostScsiTopologyLun struct {
	HostScsiTopologyLun []HostScsiTopologyLun `xml:"HostScsiTopologyLun,omitempty"`
}

func init() {
	t["ArrayOfHostScsiTopologyLun"] = reflect.TypeOf((*ArrayOfHostScsiTopologyLun)(nil)).Elem()
}

type ArrayOfHostScsiTopologyTarget struct {
	HostScsiTopologyTarget []HostScsiTopologyTarget `xml:"HostScsiTopologyTarget,omitempty"`
}

func init() {
	t["ArrayOfHostScsiTopologyTarget"] = reflect.TypeOf((*ArrayOfHostScsiTopologyTarget)(nil)).Elem()
}

type ArrayOfHostService struct {
	HostService []HostService `xml:"HostService,omitempty"`
}

func init() {
	t["ArrayOfHostService"] = reflect.TypeOf((*ArrayOfHostService)(nil)).Elem()
}

type ArrayOfHostServiceConfig struct {
	HostServiceConfig []HostServiceConfig `xml:"HostServiceConfig,omitempty"`
}

func init() {
	t["ArrayOfHostServiceConfig"] = reflect.TypeOf((*ArrayOfHostServiceConfig)(nil)).Elem()
}

type ArrayOfHostSharedGpuCapabilities struct {
	HostSharedGpuCapabilities []HostSharedGpuCapabilities `xml:"HostSharedGpuCapabilities,omitempty"`
}

func init() {
	t["ArrayOfHostSharedGpuCapabilities"] = reflect.TypeOf((*ArrayOfHostSharedGpuCapabilities)(nil)).Elem()
}

type ArrayOfHostSnmpDestination struct {
	HostSnmpDestination []HostSnmpDestination `xml:"HostSnmpDestination,omitempty"`
}

func init() {
	t["ArrayOfHostSnmpDestination"] = reflect.TypeOf((*ArrayOfHostSnmpDestination)(nil)).Elem()
}

type ArrayOfHostSriovDevicePoolInfo struct {
	HostSriovDevicePoolInfo []BaseHostSriovDevicePoolInfo `xml:"HostSriovDevicePoolInfo,omitempty,typeattr"`
}

func init() {
	t["ArrayOfHostSriovDevicePoolInfo"] = reflect.TypeOf((*ArrayOfHostSriovDevicePoolInfo)(nil)).Elem()
}

type ArrayOfHostSslThumbprintInfo struct {
	HostSslThumbprintInfo []HostSslThumbprintInfo `xml:"HostSslThumbprintInfo,omitempty"`
}

func init() {
	t["ArrayOfHostSslThumbprintInfo"] = reflect.TypeOf((*ArrayOfHostSslThumbprintInfo)(nil)).Elem()
}

type ArrayOfHostStorageArrayTypePolicyOption struct {
	HostStorageArrayTypePolicyOption []HostStorageArrayTypePolicyOption `xml:"HostStorageArrayTypePolicyOption,omitempty"`
}

func init() {
	t["ArrayOfHostStorageArrayTypePolicyOption"] = reflect.TypeOf((*ArrayOfHostStorageArrayTypePolicyOption)(nil)).Elem()
}

type ArrayOfHostStorageElementInfo struct {
	HostStorageElementInfo []HostStorageElementInfo `xml:"HostStorageElementInfo,omitempty"`
}

func init() {
	t["ArrayOfHostStorageElementInfo"] = reflect.TypeOf((*ArrayOfHostStorageElementInfo)(nil)).Elem()
}

type ArrayOfHostStorageOperationalInfo struct {
	HostStorageOperationalInfo []HostStorageOperationalInfo `xml:"HostStorageOperationalInfo,omitempty"`
}

func init() {
	t["ArrayOfHostStorageOperationalInfo"] = reflect.TypeOf((*ArrayOfHostStorageOperationalInfo)(nil)).Elem()
}

type ArrayOfHostStorageSystemDiskLocatorLedResult struct {
	HostStorageSystemDiskLocatorLedResult []HostStorageSystemDiskLocatorLedResult `xml:"HostStorageSystemDiskLocatorLedResult,omitempty"`
}

func init() {
	t["ArrayOfHostStorageSystemDiskLocatorLedResult"] = reflect.TypeOf((*ArrayOfHostStorageSystemDiskLocatorLedResult)(nil)).Elem()
}

type ArrayOfHostStorageSystemScsiLunResult struct {
	HostStorageSystemScsiLunResult []HostStorageSystemScsiLunResult `xml:"HostStorageSystemScsiLunResult,omitempty"`
}

func init() {
	t["ArrayOfHostStorageSystemScsiLunResult"] = reflect.TypeOf((*ArrayOfHostStorageSystemScsiLunResult)(nil)).Elem()
}

type ArrayOfHostStorageSystemVmfsVolumeResult struct {
	HostStorageSystemVmfsVolumeResult []HostStorageSystemVmfsVolumeResult `xml:"HostStorageSystemVmfsVolumeResult,omitempty"`
}

func init() {
	t["ArrayOfHostStorageSystemVmfsVolumeResult"] = reflect.TypeOf((*ArrayOfHostStorageSystemVmfsVolumeResult)(nil)).Elem()
}

type ArrayOfHostSubSpecification struct {
	HostSubSpecification []HostSubSpecification `xml:"HostSubSpecification,omitempty"`
}

func init() {
	t["ArrayOfHostSubSpecification"] = reflect.TypeOf((*ArrayOfHostSubSpecification)(nil)).Elem()
}

type ArrayOfHostSystemIdentificationInfo struct {
	HostSystemIdentificationInfo []HostSystemIdentificationInfo `xml:"HostSystemIdentificationInfo,omitempty"`
}

func init() {
	t["ArrayOfHostSystemIdentificationInfo"] = reflect.TypeOf((*ArrayOfHostSystemIdentificationInfo)(nil)).Elem()
}

type ArrayOfHostSystemResourceInfo struct {
	HostSystemResourceInfo []HostSystemResourceInfo `xml:"HostSystemResourceInfo,omitempty"`
}

func init() {
	t["ArrayOfHostSystemResourceInfo"] = reflect.TypeOf((*ArrayOfHostSystemResourceInfo)(nil)).Elem()
}

type ArrayOfHostSystemSwapConfigurationSystemSwapOption struct {
	HostSystemSwapConfigurationSystemSwapOption []BaseHostSystemSwapConfigurationSystemSwapOption `xml:"HostSystemSwapConfigurationSystemSwapOption,omitempty,typeattr"`
}

func init() {
	t["ArrayOfHostSystemSwapConfigurationSystemSwapOption"] = reflect.TypeOf((*ArrayOfHostSystemSwapConfigurationSystemSwapOption)(nil)).Elem()
}

type ArrayOfHostTpmDigestInfo struct {
	HostTpmDigestInfo []HostTpmDigestInfo `xml:"HostTpmDigestInfo,omitempty"`
}

func init() {
	t["ArrayOfHostTpmDigestInfo"] = reflect.TypeOf((*ArrayOfHostTpmDigestInfo)(nil)).Elem()
}

type ArrayOfHostTpmEventLogEntry struct {
	HostTpmEventLogEntry []HostTpmEventLogEntry `xml:"HostTpmEventLogEntry,omitempty"`
}

func init() {
	t["ArrayOfHostTpmEventLogEntry"] = reflect.TypeOf((*ArrayOfHostTpmEventLogEntry)(nil)).Elem()
}

type ArrayOfHostTrustAuthorityAttestationInfo struct {
	HostTrustAuthorityAttestationInfo []HostTrustAuthorityAttestationInfo `xml:"HostTrustAuthorityAttestationInfo,omitempty"`
}

func init() {
	t["ArrayOfHostTrustAuthorityAttestationInfo"] = reflect.TypeOf((*ArrayOfHostTrustAuthorityAttestationInfo)(nil)).Elem()
}

type ArrayOfHostUnresolvedVmfsExtent struct {
	HostUnresolvedVmfsExtent []HostUnresolvedVmfsExtent `xml:"HostUnresolvedVmfsExtent,omitempty"`
}

func init() {
	t["ArrayOfHostUnresolvedVmfsExtent"] = reflect.TypeOf((*ArrayOfHostUnresolvedVmfsExtent)(nil)).Elem()
}

type ArrayOfHostUnresolvedVmfsResolutionResult struct {
	HostUnresolvedVmfsResolutionResult []HostUnresolvedVmfsResolutionResult `xml:"HostUnresolvedVmfsResolutionResult,omitempty"`
}

func init() {
	t["ArrayOfHostUnresolvedVmfsResolutionResult"] = reflect.TypeOf((*ArrayOfHostUnresolvedVmfsResolutionResult)(nil)).Elem()
}

type ArrayOfHostUnresolvedVmfsResolutionSpec struct {
	HostUnresolvedVmfsResolutionSpec []HostUnresolvedVmfsResolutionSpec `xml:"HostUnresolvedVmfsResolutionSpec,omitempty"`
}

func init() {
	t["ArrayOfHostUnresolvedVmfsResolutionSpec"] = reflect.TypeOf((*ArrayOfHostUnresolvedVmfsResolutionSpec)(nil)).Elem()
}

type ArrayOfHostUnresolvedVmfsVolume struct {
	HostUnresolvedVmfsVolume []HostUnresolvedVmfsVolume `xml:"HostUnresolvedVmfsVolume,omitempty"`
}

func init() {
	t["ArrayOfHostUnresolvedVmfsVolume"] = reflect.TypeOf((*ArrayOfHostUnresolvedVmfsVolume)(nil)).Elem()
}

type ArrayOfHostVFlashManagerVFlashCacheConfigInfoVFlashModuleConfigOption struct {
	HostVFlashManagerVFlashCacheConfigInfoVFlashModuleConfigOption []HostVFlashManagerVFlashCacheConfigInfoVFlashModuleConfigOption `xml:"HostVFlashManagerVFlashCacheConfigInfoVFlashModuleConfigOption,omitempty"`
}

func init() {
	t["ArrayOfHostVFlashManagerVFlashCacheConfigInfoVFlashModuleConfigOption"] = reflect.TypeOf((*ArrayOfHostVFlashManagerVFlashCacheConfigInfoVFlashModuleConfigOption)(nil)).Elem()
}

type ArrayOfHostVMotionCompatibility struct {
	HostVMotionCompatibility []HostVMotionCompatibility `xml:"HostVMotionCompatibility,omitempty"`
}

func init() {
	t["ArrayOfHostVMotionCompatibility"] = reflect.TypeOf((*ArrayOfHostVMotionCompatibility)(nil)).Elem()
}

type ArrayOfHostVirtualNic struct {
	HostVirtualNic []HostVirtualNic `xml:"HostVirtualNic,omitempty"`
}

func init() {
	t["ArrayOfHostVirtualNic"] = reflect.TypeOf((*ArrayOfHostVirtualNic)(nil)).Elem()
}

type ArrayOfHostVirtualNicConfig struct {
	HostVirtualNicConfig []HostVirtualNicConfig `xml:"HostVirtualNicConfig,omitempty"`
}

func init() {
	t["ArrayOfHostVirtualNicConfig"] = reflect.TypeOf((*ArrayOfHostVirtualNicConfig)(nil)).Elem()
}

type ArrayOfHostVirtualNicManagerNicTypeSelection struct {
	HostVirtualNicManagerNicTypeSelection []HostVirtualNicManagerNicTypeSelection `xml:"HostVirtualNicManagerNicTypeSelection,omitempty"`
}

func init() {
	t["ArrayOfHostVirtualNicManagerNicTypeSelection"] = reflect.TypeOf((*ArrayOfHostVirtualNicManagerNicTypeSelection)(nil)).Elem()
}

type ArrayOfHostVirtualSwitch struct {
	HostVirtualSwitch []HostVirtualSwitch `xml:"HostVirtualSwitch,omitempty"`
}

func init() {
	t["ArrayOfHostVirtualSwitch"] = reflect.TypeOf((*ArrayOfHostVirtualSwitch)(nil)).Elem()
}

type ArrayOfHostVirtualSwitchConfig struct {
	HostVirtualSwitchConfig []HostVirtualSwitchConfig `xml:"HostVirtualSwitchConfig,omitempty"`
}

func init() {
	t["ArrayOfHostVirtualSwitchConfig"] = reflect.TypeOf((*ArrayOfHostVirtualSwitchConfig)(nil)).Elem()
}

type ArrayOfHostVmciAccessManagerAccessSpec struct {
	HostVmciAccessManagerAccessSpec []HostVmciAccessManagerAccessSpec `xml:"HostVmciAccessManagerAccessSpec,omitempty"`
}

func init() {
	t["ArrayOfHostVmciAccessManagerAccessSpec"] = reflect.TypeOf((*ArrayOfHostVmciAccessManagerAccessSpec)(nil)).Elem()
}

type ArrayOfHostVmfsRescanResult struct {
	HostVmfsRescanResult []HostVmfsRescanResult `xml:"HostVmfsRescanResult,omitempty"`
}

func init() {
	t["ArrayOfHostVmfsRescanResult"] = reflect.TypeOf((*ArrayOfHostVmfsRescanResult)(nil)).Elem()
}

type ArrayOfHostVsanInternalSystemCmmdsQuery struct {
	HostVsanInternalSystemCmmdsQuery []HostVsanInternalSystemCmmdsQuery `xml:"HostVsanInternalSystemCmmdsQuery,omitempty"`
}

func init() {
	t["ArrayOfHostVsanInternalSystemCmmdsQuery"] = reflect.TypeOf((*ArrayOfHostVsanInternalSystemCmmdsQuery)(nil)).Elem()
}

type ArrayOfHostVsanInternalSystemDeleteVsanObjectsResult struct {
	HostVsanInternalSystemDeleteVsanObjectsResult []HostVsanInternalSystemDeleteVsanObjectsResult `xml:"HostVsanInternalSystemDeleteVsanObjectsResult,omitempty"`
}

func init() {
	t["ArrayOfHostVsanInternalSystemDeleteVsanObjectsResult"] = reflect.TypeOf((*ArrayOfHostVsanInternalSystemDeleteVsanObjectsResult)(nil)).Elem()
}

type ArrayOfHostVsanInternalSystemVsanObjectOperationResult struct {
	HostVsanInternalSystemVsanObjectOperationResult []HostVsanInternalSystemVsanObjectOperationResult `xml:"HostVsanInternalSystemVsanObjectOperationResult,omitempty"`
}

func init() {
	t["ArrayOfHostVsanInternalSystemVsanObjectOperationResult"] = reflect.TypeOf((*ArrayOfHostVsanInternalSystemVsanObjectOperationResult)(nil)).Elem()
}

type ArrayOfHostVsanInternalSystemVsanPhysicalDiskDiagnosticsResult struct {
	HostVsanInternalSystemVsanPhysicalDiskDiagnosticsResult []HostVsanInternalSystemVsanPhysicalDiskDiagnosticsResult `xml:"HostVsanInternalSystemVsanPhysicalDiskDiagnosticsResult,omitempty"`
}

func init() {
	t["ArrayOfHostVsanInternalSystemVsanPhysicalDiskDiagnosticsResult"] = reflect.TypeOf((*ArrayOfHostVsanInternalSystemVsanPhysicalDiskDiagnosticsResult)(nil)).Elem()
}

type ArrayOfHttpNfcLeaseDatastoreLeaseInfo struct {
	HttpNfcLeaseDatastoreLeaseInfo []HttpNfcLeaseDatastoreLeaseInfo `xml:"HttpNfcLeaseDatastoreLeaseInfo,omitempty"`
}

func init() {
	t["ArrayOfHttpNfcLeaseDatastoreLeaseInfo"] = reflect.TypeOf((*ArrayOfHttpNfcLeaseDatastoreLeaseInfo)(nil)).Elem()
}

type ArrayOfHttpNfcLeaseDeviceUrl struct {
	HttpNfcLeaseDeviceUrl []HttpNfcLeaseDeviceUrl `xml:"HttpNfcLeaseDeviceUrl,omitempty"`
}

func init() {
	t["ArrayOfHttpNfcLeaseDeviceUrl"] = reflect.TypeOf((*ArrayOfHttpNfcLeaseDeviceUrl)(nil)).Elem()
}

type ArrayOfHttpNfcLeaseHostInfo struct {
	HttpNfcLeaseHostInfo []HttpNfcLeaseHostInfo `xml:"HttpNfcLeaseHostInfo,omitempty"`
}

func init() {
	t["ArrayOfHttpNfcLeaseHostInfo"] = reflect.TypeOf((*ArrayOfHttpNfcLeaseHostInfo)(nil)).Elem()
}

type ArrayOfHttpNfcLeaseManifestEntry struct {
	HttpNfcLeaseManifestEntry []HttpNfcLeaseManifestEntry `xml:"HttpNfcLeaseManifestEntry,omitempty"`
}

func init() {
	t["ArrayOfHttpNfcLeaseManifestEntry"] = reflect.TypeOf((*ArrayOfHttpNfcLeaseManifestEntry)(nil)).Elem()
}

type ArrayOfHttpNfcLeaseProbeResult struct {
	HttpNfcLeaseProbeResult []HttpNfcLeaseProbeResult `xml:"HttpNfcLeaseProbeResult,omitempty"`
}

func init() {
	t["ArrayOfHttpNfcLeaseProbeResult"] = reflect.TypeOf((*ArrayOfHttpNfcLeaseProbeResult)(nil)).Elem()
}

type ArrayOfHttpNfcLeaseSourceFile struct {
	HttpNfcLeaseSourceFile []HttpNfcLeaseSourceFile `xml:"HttpNfcLeaseSourceFile,omitempty"`
}

func init() {
	t["ArrayOfHttpNfcLeaseSourceFile"] = reflect.TypeOf((*ArrayOfHttpNfcLeaseSourceFile)(nil)).Elem()
}

type ArrayOfID struct {
	ID []ID `xml:"ID,omitempty"`
}

func init() {
	t["ArrayOfID"] = reflect.TypeOf((*ArrayOfID)(nil)).Elem()
}

type ArrayOfImportOperationBulkFaultFaultOnImport struct {
	ImportOperationBulkFaultFaultOnImport []ImportOperationBulkFaultFaultOnImport `xml:"ImportOperationBulkFaultFaultOnImport,omitempty"`
}

func init() {
	t["ArrayOfImportOperationBulkFaultFaultOnImport"] = reflect.TypeOf((*ArrayOfImportOperationBulkFaultFaultOnImport)(nil)).Elem()
}

type ArrayOfImportSpec struct {
	ImportSpec []BaseImportSpec `xml:"ImportSpec,omitempty,typeattr"`
}

func init() {
	t["ArrayOfImportSpec"] = reflect.TypeOf((*ArrayOfImportSpec)(nil)).Elem()
}

type ArrayOfInt struct {
	Int []int32 `xml:"int,omitempty"`
}

func init() {
	t["ArrayOfInt"] = reflect.TypeOf((*ArrayOfInt)(nil)).Elem()
}

type ArrayOfIoFilterHostIssue struct {
	IoFilterHostIssue []IoFilterHostIssue `xml:"IoFilterHostIssue,omitempty"`
}

func init() {
	t["ArrayOfIoFilterHostIssue"] = reflect.TypeOf((*ArrayOfIoFilterHostIssue)(nil)).Elem()
}

type ArrayOfIpPool struct {
	IpPool []IpPool `xml:"IpPool,omitempty"`
}

func init() {
	t["ArrayOfIpPool"] = reflect.TypeOf((*ArrayOfIpPool)(nil)).Elem()
}

type ArrayOfIpPoolAssociation struct {
	IpPoolAssociation []IpPoolAssociation `xml:"IpPoolAssociation,omitempty"`
}

func init() {
	t["ArrayOfIpPoolAssociation"] = reflect.TypeOf((*ArrayOfIpPoolAssociation)(nil)).Elem()
}

type ArrayOfIpPoolManagerIpAllocation struct {
	IpPoolManagerIpAllocation []IpPoolManagerIpAllocation `xml:"IpPoolManagerIpAllocation,omitempty"`
}

func init() {
	t["ArrayOfIpPoolManagerIpAllocation"] = reflect.TypeOf((*ArrayOfIpPoolManagerIpAllocation)(nil)).Elem()
}

type ArrayOfIscsiDependencyEntity struct {
	IscsiDependencyEntity []IscsiDependencyEntity `xml:"IscsiDependencyEntity,omitempty"`
}

func init() {
	t["ArrayOfIscsiDependencyEntity"] = reflect.TypeOf((*ArrayOfIscsiDependencyEntity)(nil)).Elem()
}

type ArrayOfIscsiPortInfo struct {
	IscsiPortInfo []IscsiPortInfo `xml:"IscsiPortInfo,omitempty"`
}

func init() {
	t["ArrayOfIscsiPortInfo"] = reflect.TypeOf((*ArrayOfIscsiPortInfo)(nil)).Elem()
}

type ArrayOfKernelModuleInfo struct {
	KernelModuleInfo []KernelModuleInfo `xml:"KernelModuleInfo,omitempty"`
}

func init() {
	t["ArrayOfKernelModuleInfo"] = reflect.TypeOf((*ArrayOfKernelModuleInfo)(nil)).Elem()
}

type ArrayOfKeyAnyValue struct {
	KeyAnyValue []KeyAnyValue `xml:"KeyAnyValue,omitempty"`
}

func init() {
	t["ArrayOfKeyAnyValue"] = reflect.TypeOf((*ArrayOfKeyAnyValue)(nil)).Elem()
}

type ArrayOfKeyValue struct {
	KeyValue []KeyValue `xml:"KeyValue,omitempty"`
}

func init() {
	t["ArrayOfKeyValue"] = reflect.TypeOf((*ArrayOfKeyValue)(nil)).Elem()
}

type ArrayOfKmipClusterInfo struct {
	KmipClusterInfo []KmipClusterInfo `xml:"KmipClusterInfo,omitempty"`
}

func init() {
	t["ArrayOfKmipClusterInfo"] = reflect.TypeOf((*ArrayOfKmipClusterInfo)(nil)).Elem()
}

type ArrayOfKmipServerInfo struct {
	KmipServerInfo []KmipServerInfo `xml:"KmipServerInfo,omitempty"`
}

func init() {
	t["ArrayOfKmipServerInfo"] = reflect.TypeOf((*ArrayOfKmipServerInfo)(nil)).Elem()
}

type ArrayOfLicenseAssignmentManagerLicenseAssignment struct {
	LicenseAssignmentManagerLicenseAssignment []LicenseAssignmentManagerLicenseAssignment `xml:"LicenseAssignmentManagerLicenseAssignment,omitempty"`
}

func init() {
	t["ArrayOfLicenseAssignmentManagerLicenseAssignment"] = reflect.TypeOf((*ArrayOfLicenseAssignmentManagerLicenseAssignment)(nil)).Elem()
}

type ArrayOfLicenseAvailabilityInfo struct {
	LicenseAvailabilityInfo []LicenseAvailabilityInfo `xml:"LicenseAvailabilityInfo,omitempty"`
}

func init() {
	t["ArrayOfLicenseAvailabilityInfo"] = reflect.TypeOf((*ArrayOfLicenseAvailabilityInfo)(nil)).Elem()
}

type ArrayOfLicenseFeatureInfo struct {
	LicenseFeatureInfo []LicenseFeatureInfo `xml:"LicenseFeatureInfo,omitempty"`
}

func init() {
	t["ArrayOfLicenseFeatureInfo"] = reflect.TypeOf((*ArrayOfLicenseFeatureInfo)(nil)).Elem()
}

type ArrayOfLicenseManagerLicenseInfo struct {
	LicenseManagerLicenseInfo []LicenseManagerLicenseInfo `xml:"LicenseManagerLicenseInfo,omitempty"`
}

func init() {
	t["ArrayOfLicenseManagerLicenseInfo"] = reflect.TypeOf((*ArrayOfLicenseManagerLicenseInfo)(nil)).Elem()
}

type ArrayOfLicenseReservationInfo struct {
	LicenseReservationInfo []LicenseReservationInfo `xml:"LicenseReservationInfo,omitempty"`
}

func init() {
	t["ArrayOfLicenseReservationInfo"] = reflect.TypeOf((*ArrayOfLicenseReservationInfo)(nil)).Elem()
}

type ArrayOfLocalizableMessage struct {
	LocalizableMessage []LocalizableMessage `xml:"LocalizableMessage,omitempty"`
}

func init() {
	t["ArrayOfLocalizableMessage"] = reflect.TypeOf((*ArrayOfLocalizableMessage)(nil)).Elem()
}

type ArrayOfLocalizationManagerMessageCatalog struct {
	LocalizationManagerMessageCatalog []LocalizationManagerMessageCatalog `xml:"LocalizationManagerMessageCatalog,omitempty"`
}

func init() {
	t["ArrayOfLocalizationManagerMessageCatalog"] = reflect.TypeOf((*ArrayOfLocalizationManagerMessageCatalog)(nil)).Elem()
}

type ArrayOfLong struct {
	Long []int64 `xml:"long,omitempty"`
}

func init() {
	t["ArrayOfLong"] = reflect.TypeOf((*ArrayOfLong)(nil)).Elem()
}

type ArrayOfManagedEntityStatus struct {
	ManagedEntityStatus []ManagedEntityStatus `xml:"ManagedEntityStatus,omitempty"`
}

func init() {
	t["ArrayOfManagedEntityStatus"] = reflect.TypeOf((*ArrayOfManagedEntityStatus)(nil)).Elem()
}

type ArrayOfManagedObjectReference struct {
	ManagedObjectReference []ManagedObjectReference `xml:"ManagedObjectReference,omitempty"`
}

func init() {
	t["ArrayOfManagedObjectReference"] = reflect.TypeOf((*ArrayOfManagedObjectReference)(nil)).Elem()
}

type ArrayOfMethodActionArgument struct {
	MethodActionArgument []MethodActionArgument `xml:"MethodActionArgument,omitempty"`
}

func init() {
	t["ArrayOfMethodActionArgument"] = reflect.TypeOf((*ArrayOfMethodActionArgument)(nil)).Elem()
}

type ArrayOfMethodFault struct {
	MethodFault []BaseMethodFault `xml:"MethodFault,omitempty,typeattr"`
}

func init() {
	t["ArrayOfMethodFault"] = reflect.TypeOf((*ArrayOfMethodFault)(nil)).Elem()
}

type ArrayOfMissingObject struct {
	MissingObject []MissingObject `xml:"MissingObject,omitempty"`
}

func init() {
	t["ArrayOfMissingObject"] = reflect.TypeOf((*ArrayOfMissingObject)(nil)).Elem()
}

type ArrayOfMissingProperty struct {
	MissingProperty []MissingProperty `xml:"MissingProperty,omitempty"`
}

func init() {
	t["ArrayOfMissingProperty"] = reflect.TypeOf((*ArrayOfMissingProperty)(nil)).Elem()
}

type ArrayOfMultipleCertificatesVerifyFaultThumbprintData struct {
	MultipleCertificatesVerifyFaultThumbprintData []MultipleCertificatesVerifyFaultThumbprintData `xml:"MultipleCertificatesVerifyFaultThumbprintData,omitempty"`
}

func init() {
	t["ArrayOfMultipleCertificatesVerifyFaultThumbprintData"] = reflect.TypeOf((*ArrayOfMultipleCertificatesVerifyFaultThumbprintData)(nil)).Elem()
}

type ArrayOfNasStorageProfile struct {
	NasStorageProfile []NasStorageProfile `xml:"NasStorageProfile,omitempty"`
}

func init() {
	t["ArrayOfNasStorageProfile"] = reflect.TypeOf((*ArrayOfNasStorageProfile)(nil)).Elem()
}

type ArrayOfNetIpConfigInfoIpAddress struct {
	NetIpConfigInfoIpAddress []NetIpConfigInfoIpAddress `xml:"NetIpConfigInfoIpAddress,omitempty"`
}

func init() {
	t["ArrayOfNetIpConfigInfoIpAddress"] = reflect.TypeOf((*ArrayOfNetIpConfigInfoIpAddress)(nil)).Elem()
}

type ArrayOfNetIpConfigSpecIpAddressSpec struct {
	NetIpConfigSpecIpAddressSpec []NetIpConfigSpecIpAddressSpec `xml:"NetIpConfigSpecIpAddressSpec,omitempty"`
}

func init() {
	t["ArrayOfNetIpConfigSpecIpAddressSpec"] = reflect.TypeOf((*ArrayOfNetIpConfigSpecIpAddressSpec)(nil)).Elem()
}

type ArrayOfNetIpRouteConfigInfoIpRoute struct {
	NetIpRouteConfigInfoIpRoute []NetIpRouteConfigInfoIpRoute `xml:"NetIpRouteConfigInfoIpRoute,omitempty"`
}

func init() {
	t["ArrayOfNetIpRouteConfigInfoIpRoute"] = reflect.TypeOf((*ArrayOfNetIpRouteConfigInfoIpRoute)(nil)).Elem()
}

type ArrayOfNetIpRouteConfigSpecIpRouteSpec struct {
	NetIpRouteConfigSpecIpRouteSpec []NetIpRouteConfigSpecIpRouteSpec `xml:"NetIpRouteConfigSpecIpRouteSpec,omitempty"`
}

func init() {
	t["ArrayOfNetIpRouteConfigSpecIpRouteSpec"] = reflect.TypeOf((*ArrayOfNetIpRouteConfigSpecIpRouteSpec)(nil)).Elem()
}

type ArrayOfNetIpStackInfoDefaultRouter struct {
	NetIpStackInfoDefaultRouter []NetIpStackInfoDefaultRouter `xml:"NetIpStackInfoDefaultRouter,omitempty"`
}

func init() {
	t["ArrayOfNetIpStackInfoDefaultRouter"] = reflect.TypeOf((*ArrayOfNetIpStackInfoDefaultRouter)(nil)).Elem()
}

type ArrayOfNetIpStackInfoNetToMedia struct {
	NetIpStackInfoNetToMedia []NetIpStackInfoNetToMedia `xml:"NetIpStackInfoNetToMedia,omitempty"`
}

func init() {
	t["ArrayOfNetIpStackInfoNetToMedia"] = reflect.TypeOf((*ArrayOfNetIpStackInfoNetToMedia)(nil)).Elem()
}

type ArrayOfNetStackInstanceProfile struct {
	NetStackInstanceProfile []NetStackInstanceProfile `xml:"NetStackInstanceProfile,omitempty"`
}

func init() {
	t["ArrayOfNetStackInstanceProfile"] = reflect.TypeOf((*ArrayOfNetStackInstanceProfile)(nil)).Elem()
}

type ArrayOfNsxHostVNicProfile struct {
	NsxHostVNicProfile []NsxHostVNicProfile `xml:"NsxHostVNicProfile,omitempty"`
}

func init() {
	t["ArrayOfNsxHostVNicProfile"] = reflect.TypeOf((*ArrayOfNsxHostVNicProfile)(nil)).Elem()
}

type ArrayOfNumericRange struct {
	NumericRange []NumericRange `xml:"NumericRange,omitempty"`
}

func init() {
	t["ArrayOfNumericRange"] = reflect.TypeOf((*ArrayOfNumericRange)(nil)).Elem()
}

type ArrayOfNvdimmDimmInfo struct {
	NvdimmDimmInfo []NvdimmDimmInfo `xml:"NvdimmDimmInfo,omitempty"`
}

func init() {
	t["ArrayOfNvdimmDimmInfo"] = reflect.TypeOf((*ArrayOfNvdimmDimmInfo)(nil)).Elem()
}

type ArrayOfNvdimmGuid struct {
	NvdimmGuid []NvdimmGuid `xml:"NvdimmGuid,omitempty"`
}

func init() {
	t["ArrayOfNvdimmGuid"] = reflect.TypeOf((*ArrayOfNvdimmGuid)(nil)).Elem()
}

type ArrayOfNvdimmInterleaveSetInfo struct {
	NvdimmInterleaveSetInfo []NvdimmInterleaveSetInfo `xml:"NvdimmInterleaveSetInfo,omitempty"`
}

func init() {
	t["ArrayOfNvdimmInterleaveSetInfo"] = reflect.TypeOf((*ArrayOfNvdimmInterleaveSetInfo)(nil)).Elem()
}

type ArrayOfNvdimmNamespaceDetails struct {
	NvdimmNamespaceDetails []NvdimmNamespaceDetails `xml:"NvdimmNamespaceDetails,omitempty"`
}

func init() {
	t["ArrayOfNvdimmNamespaceDetails"] = reflect.TypeOf((*ArrayOfNvdimmNamespaceDetails)(nil)).Elem()
}

type ArrayOfNvdimmNamespaceInfo struct {
	NvdimmNamespaceInfo []NvdimmNamespaceInfo `xml:"NvdimmNamespaceInfo,omitempty"`
}

func init() {
	t["ArrayOfNvdimmNamespaceInfo"] = reflect.TypeOf((*ArrayOfNvdimmNamespaceInfo)(nil)).Elem()
}

type ArrayOfNvdimmRegionInfo struct {
	NvdimmRegionInfo []NvdimmRegionInfo `xml:"NvdimmRegionInfo,omitempty"`
}

func init() {
	t["ArrayOfNvdimmRegionInfo"] = reflect.TypeOf((*ArrayOfNvdimmRegionInfo)(nil)).Elem()
}

type ArrayOfObjectContent struct {
	ObjectContent []ObjectContent `xml:"ObjectContent,omitempty"`
}

func init() {
	t["ArrayOfObjectContent"] = reflect.TypeOf((*ArrayOfObjectContent)(nil)).Elem()
}

type ArrayOfObjectSpec struct {
	ObjectSpec []ObjectSpec `xml:"ObjectSpec,omitempty"`
}

func init() {
	t["ArrayOfObjectSpec"] = reflect.TypeOf((*ArrayOfObjectSpec)(nil)).Elem()
}

type ArrayOfObjectUpdate struct {
	ObjectUpdate []ObjectUpdate `xml:"ObjectUpdate,omitempty"`
}

func init() {
	t["ArrayOfObjectUpdate"] = reflect.TypeOf((*ArrayOfObjectUpdate)(nil)).Elem()
}

type ArrayOfOpaqueNetworkTargetInfo struct {
	OpaqueNetworkTargetInfo []OpaqueNetworkTargetInfo `xml:"OpaqueNetworkTargetInfo,omitempty"`
}

func init() {
	t["ArrayOfOpaqueNetworkTargetInfo"] = reflect.TypeOf((*ArrayOfOpaqueNetworkTargetInfo)(nil)).Elem()
}

type ArrayOfOptionDef struct {
	OptionDef []OptionDef `xml:"OptionDef,omitempty"`
}

func init() {
	t["ArrayOfOptionDef"] = reflect.TypeOf((*ArrayOfOptionDef)(nil)).Elem()
}

type ArrayOfOptionProfile struct {
	OptionProfile []OptionProfile `xml:"OptionProfile,omitempty"`
}

func init() {
	t["ArrayOfOptionProfile"] = reflect.TypeOf((*ArrayOfOptionProfile)(nil)).Elem()
}

type ArrayOfOptionValue struct {
	OptionValue []BaseOptionValue `xml:"OptionValue,omitempty,typeattr"`
}

func init() {
	t["ArrayOfOptionValue"] = reflect.TypeOf((*ArrayOfOptionValue)(nil)).Elem()
}

type ArrayOfOvfConsumerOstNode struct {
	OvfConsumerOstNode []OvfConsumerOstNode `xml:"OvfConsumerOstNode,omitempty"`
}

func init() {
	t["ArrayOfOvfConsumerOstNode"] = reflect.TypeOf((*ArrayOfOvfConsumerOstNode)(nil)).Elem()
}

type ArrayOfOvfConsumerOvfSection struct {
	OvfConsumerOvfSection []OvfConsumerOvfSection `xml:"OvfConsumerOvfSection,omitempty"`
}

func init() {
	t["ArrayOfOvfConsumerOvfSection"] = reflect.TypeOf((*ArrayOfOvfConsumerOvfSection)(nil)).Elem()
}

type ArrayOfOvfDeploymentOption struct {
	OvfDeploymentOption []OvfDeploymentOption `xml:"OvfDeploymentOption,omitempty"`
}

func init() {
	t["ArrayOfOvfDeploymentOption"] = reflect.TypeOf((*ArrayOfOvfDeploymentOption)(nil)).Elem()
}

type ArrayOfOvfFile struct {
	OvfFile []OvfFile `xml:"OvfFile,omitempty"`
}

func init() {
	t["ArrayOfOvfFile"] = reflect.TypeOf((*ArrayOfOvfFile)(nil)).Elem()
}

type ArrayOfOvfFileItem struct {
	OvfFileItem []OvfFileItem `xml:"OvfFileItem,omitempty"`
}

func init() {
	t["ArrayOfOvfFileItem"] = reflect.TypeOf((*ArrayOfOvfFileItem)(nil)).Elem()
}

type ArrayOfOvfNetworkInfo struct {
	OvfNetworkInfo []OvfNetworkInfo `xml:"OvfNetworkInfo,omitempty"`
}

func init() {
	t["ArrayOfOvfNetworkInfo"] = reflect.TypeOf((*ArrayOfOvfNetworkInfo)(nil)).Elem()
}

type ArrayOfOvfNetworkMapping struct {
	OvfNetworkMapping []OvfNetworkMapping `xml:"OvfNetworkMapping,omitempty"`
}

func init() {
	t["ArrayOfOvfNetworkMapping"] = reflect.TypeOf((*ArrayOfOvfNetworkMapping)(nil)).Elem()
}

type ArrayOfOvfOptionInfo struct {
	OvfOptionInfo []OvfOptionInfo `xml:"OvfOptionInfo,omitempty"`
}

func init() {
	t["ArrayOfOvfOptionInfo"] = reflect.TypeOf((*ArrayOfOvfOptionInfo)(nil)).Elem()
}

type ArrayOfOvfResourceMap struct {
	OvfResourceMap []OvfResourceMap `xml:"OvfResourceMap,omitempty"`
}

func init() {
	t["ArrayOfOvfResourceMap"] = reflect.TypeOf((*ArrayOfOvfResourceMap)(nil)).Elem()
}

type ArrayOfPerfCounterInfo struct {
	PerfCounterInfo []PerfCounterInfo `xml:"PerfCounterInfo,omitempty"`
}

func init() {
	t["ArrayOfPerfCounterInfo"] = reflect.TypeOf((*ArrayOfPerfCounterInfo)(nil)).Elem()
}

type ArrayOfPerfEntityMetricBase struct {
	PerfEntityMetricBase []BasePerfEntityMetricBase `xml:"PerfEntityMetricBase,omitempty,typeattr"`
}

func init() {
	t["ArrayOfPerfEntityMetricBase"] = reflect.TypeOf((*ArrayOfPerfEntityMetricBase)(nil)).Elem()
}

type ArrayOfPerfInterval struct {
	PerfInterval []PerfInterval `xml:"PerfInterval,omitempty"`
}

func init() {
	t["ArrayOfPerfInterval"] = reflect.TypeOf((*ArrayOfPerfInterval)(nil)).Elem()
}

type ArrayOfPerfMetricId struct {
	PerfMetricId []PerfMetricId `xml:"PerfMetricId,omitempty"`
}

func init() {
	t["ArrayOfPerfMetricId"] = reflect.TypeOf((*ArrayOfPerfMetricId)(nil)).Elem()
}

type ArrayOfPerfMetricSeries struct {
	PerfMetricSeries []BasePerfMetricSeries `xml:"PerfMetricSeries,omitempty,typeattr"`
}

func init() {
	t["ArrayOfPerfMetricSeries"] = reflect.TypeOf((*ArrayOfPerfMetricSeries)(nil)).Elem()
}

type ArrayOfPerfMetricSeriesCSV struct {
	PerfMetricSeriesCSV []PerfMetricSeriesCSV `xml:"PerfMetricSeriesCSV,omitempty"`
}

func init() {
	t["ArrayOfPerfMetricSeriesCSV"] = reflect.TypeOf((*ArrayOfPerfMetricSeriesCSV)(nil)).Elem()
}

type ArrayOfPerfQuerySpec struct {
	PerfQuerySpec []PerfQuerySpec `xml:"PerfQuerySpec,omitempty"`
}

func init() {
	t["ArrayOfPerfQuerySpec"] = reflect.TypeOf((*ArrayOfPerfQuerySpec)(nil)).Elem()
}

type ArrayOfPerfSampleInfo struct {
	PerfSampleInfo []PerfSampleInfo `xml:"PerfSampleInfo,omitempty"`
}

func init() {
	t["ArrayOfPerfSampleInfo"] = reflect.TypeOf((*ArrayOfPerfSampleInfo)(nil)).Elem()
}

type ArrayOfPerformanceManagerCounterLevelMapping struct {
	PerformanceManagerCounterLevelMapping []PerformanceManagerCounterLevelMapping `xml:"PerformanceManagerCounterLevelMapping,omitempty"`
}

func init() {
	t["ArrayOfPerformanceManagerCounterLevelMapping"] = reflect.TypeOf((*ArrayOfPerformanceManagerCounterLevelMapping)(nil)).Elem()
}

type ArrayOfPermission struct {
	Permission []Permission `xml:"Permission,omitempty"`
}

func init() {
	t["ArrayOfPermission"] = reflect.TypeOf((*ArrayOfPermission)(nil)).Elem()
}

type ArrayOfPermissionProfile struct {
	PermissionProfile []PermissionProfile `xml:"PermissionProfile,omitempty"`
}

func init() {
	t["ArrayOfPermissionProfile"] = reflect.TypeOf((*ArrayOfPermissionProfile)(nil)).Elem()
}

type ArrayOfPhysicalNic struct {
	PhysicalNic []PhysicalNic `xml:"PhysicalNic,omitempty"`
}

func init() {
	t["ArrayOfPhysicalNic"] = reflect.TypeOf((*ArrayOfPhysicalNic)(nil)).Elem()
}

type ArrayOfPhysicalNicConfig struct {
	PhysicalNicConfig []PhysicalNicConfig `xml:"PhysicalNicConfig,omitempty"`
}

func init() {
	t["ArrayOfPhysicalNicConfig"] = reflect.TypeOf((*ArrayOfPhysicalNicConfig)(nil)).Elem()
}

type ArrayOfPhysicalNicHintInfo struct {
	PhysicalNicHintInfo []PhysicalNicHintInfo `xml:"PhysicalNicHintInfo,omitempty"`
}

func init() {
	t["ArrayOfPhysicalNicHintInfo"] = reflect.TypeOf((*ArrayOfPhysicalNicHintInfo)(nil)).Elem()
}

type ArrayOfPhysicalNicIpHint struct {
	PhysicalNicIpHint []PhysicalNicIpHint `xml:"PhysicalNicIpHint,omitempty"`
}

func init() {
	t["ArrayOfPhysicalNicIpHint"] = reflect.TypeOf((*ArrayOfPhysicalNicIpHint)(nil)).Elem()
}

type ArrayOfPhysicalNicLinkInfo struct {
	PhysicalNicLinkInfo []PhysicalNicLinkInfo `xml:"PhysicalNicLinkInfo,omitempty"`
}

func init() {
	t["ArrayOfPhysicalNicLinkInfo"] = reflect.TypeOf((*ArrayOfPhysicalNicLinkInfo)(nil)).Elem()
}

type ArrayOfPhysicalNicNameHint struct {
	PhysicalNicNameHint []PhysicalNicNameHint `xml:"PhysicalNicNameHint,omitempty"`
}

func init() {
	t["ArrayOfPhysicalNicNameHint"] = reflect.TypeOf((*ArrayOfPhysicalNicNameHint)(nil)).Elem()
}

type ArrayOfPhysicalNicProfile struct {
	PhysicalNicProfile []PhysicalNicProfile `xml:"PhysicalNicProfile,omitempty"`
}

func init() {
	t["ArrayOfPhysicalNicProfile"] = reflect.TypeOf((*ArrayOfPhysicalNicProfile)(nil)).Elem()
}

type ArrayOfPlacementAffinityRule struct {
	PlacementAffinityRule []PlacementAffinityRule `xml:"PlacementAffinityRule,omitempty"`
}

func init() {
	t["ArrayOfPlacementAffinityRule"] = reflect.TypeOf((*ArrayOfPlacementAffinityRule)(nil)).Elem()
}

type ArrayOfPlacementSpec struct {
	PlacementSpec []PlacementSpec `xml:"PlacementSpec,omitempty"`
}

func init() {
	t["ArrayOfPlacementSpec"] = reflect.TypeOf((*ArrayOfPlacementSpec)(nil)).Elem()
}

type ArrayOfPnicUplinkProfile struct {
	PnicUplinkProfile []PnicUplinkProfile `xml:"PnicUplinkProfile,omitempty"`
}

func init() {
	t["ArrayOfPnicUplinkProfile"] = reflect.TypeOf((*ArrayOfPnicUplinkProfile)(nil)).Elem()
}

type ArrayOfPodDiskLocator struct {
	PodDiskLocator []PodDiskLocator `xml:"PodDiskLocator,omitempty"`
}

func init() {
	t["ArrayOfPodDiskLocator"] = reflect.TypeOf((*ArrayOfPodDiskLocator)(nil)).Elem()
}

type ArrayOfPolicyOption struct {
	PolicyOption []BasePolicyOption `xml:"PolicyOption,omitempty,typeattr"`
}

func init() {
	t["ArrayOfPolicyOption"] = reflect.TypeOf((*ArrayOfPolicyOption)(nil)).Elem()
}

type ArrayOfPrivilegeAvailability struct {
	PrivilegeAvailability []PrivilegeAvailability `xml:"PrivilegeAvailability,omitempty"`
}

func init() {
	t["ArrayOfPrivilegeAvailability"] = reflect.TypeOf((*ArrayOfPrivilegeAvailability)(nil)).Elem()
}

type ArrayOfProductComponentInfo struct {
	ProductComponentInfo []ProductComponentInfo `xml:"ProductComponentInfo,omitempty"`
}

func init() {
	t["ArrayOfProductComponentInfo"] = reflect.TypeOf((*ArrayOfProductComponentInfo)(nil)).Elem()
}

type ArrayOfProfileApplyProfileProperty struct {
	ProfileApplyProfileProperty []ProfileApplyProfileProperty `xml:"ProfileApplyProfileProperty,omitempty"`
}

func init() {
	t["ArrayOfProfileApplyProfileProperty"] = reflect.TypeOf((*ArrayOfProfileApplyProfileProperty)(nil)).Elem()
}

type ArrayOfProfileDeferredPolicyOptionParameter struct {
	ProfileDeferredPolicyOptionParameter []ProfileDeferredPolicyOptionParameter `xml:"ProfileDeferredPolicyOptionParameter,omitempty"`
}

func init() {
	t["ArrayOfProfileDeferredPolicyOptionParameter"] = reflect.TypeOf((*ArrayOfProfileDeferredPolicyOptionParameter)(nil)).Elem()
}

type ArrayOfProfileDescriptionSection struct {
	ProfileDescriptionSection []ProfileDescriptionSection `xml:"ProfileDescriptionSection,omitempty"`
}

func init() {
	t["ArrayOfProfileDescriptionSection"] = reflect.TypeOf((*ArrayOfProfileDescriptionSection)(nil)).Elem()
}

type ArrayOfProfileExecuteError struct {
	ProfileExecuteError []ProfileExecuteError `xml:"ProfileExecuteError,omitempty"`
}

func init() {
	t["ArrayOfProfileExecuteError"] = reflect.TypeOf((*ArrayOfProfileExecuteError)(nil)).Elem()
}

type ArrayOfProfileExpression struct {
	ProfileExpression []BaseProfileExpression `xml:"ProfileExpression,omitempty,typeattr"`
}

func init() {
	t["ArrayOfProfileExpression"] = reflect.TypeOf((*ArrayOfProfileExpression)(nil)).Elem()
}

type ArrayOfProfileExpressionMetadata struct {
	ProfileExpressionMetadata []ProfileExpressionMetadata `xml:"ProfileExpressionMetadata,omitempty"`
}

func init() {
	t["ArrayOfProfileExpressionMetadata"] = reflect.TypeOf((*ArrayOfProfileExpressionMetadata)(nil)).Elem()
}

type ArrayOfProfileMetadata struct {
	ProfileMetadata []ProfileMetadata `xml:"ProfileMetadata,omitempty"`
}

func init() {
	t["ArrayOfProfileMetadata"] = reflect.TypeOf((*ArrayOfProfileMetadata)(nil)).Elem()
}

type ArrayOfProfileMetadataProfileOperationMessage struct {
	ProfileMetadataProfileOperationMessage []ProfileMetadataProfileOperationMessage `xml:"ProfileMetadataProfileOperationMessage,omitempty"`
}

func init() {
	t["ArrayOfProfileMetadataProfileOperationMessage"] = reflect.TypeOf((*ArrayOfProfileMetadataProfileOperationMessage)(nil)).Elem()
}

type ArrayOfProfileMetadataProfileSortSpec struct {
	ProfileMetadataProfileSortSpec []ProfileMetadataProfileSortSpec `xml:"ProfileMetadataProfileSortSpec,omitempty"`
}

func init() {
	t["ArrayOfProfileMetadataProfileSortSpec"] = reflect.TypeOf((*ArrayOfProfileMetadataProfileSortSpec)(nil)).Elem()
}

type ArrayOfProfileParameterMetadata struct {
	ProfileParameterMetadata []ProfileParameterMetadata `xml:"ProfileParameterMetadata,omitempty"`
}

func init() {
	t["ArrayOfProfileParameterMetadata"] = reflect.TypeOf((*ArrayOfProfileParameterMetadata)(nil)).Elem()
}

type ArrayOfProfileParameterMetadataParameterRelationMetadata struct {
	ProfileParameterMetadataParameterRelationMetadata []ProfileParameterMetadataParameterRelationMetadata `xml:"ProfileParameterMetadataParameterRelationMetadata,omitempty"`
}

func init() {
	t["ArrayOfProfileParameterMetadataParameterRelationMetadata"] = reflect.TypeOf((*ArrayOfProfileParameterMetadataParameterRelationMetadata)(nil)).Elem()
}

type ArrayOfProfilePolicy struct {
	ProfilePolicy []ProfilePolicy `xml:"ProfilePolicy,omitempty"`
}

func init() {
	t["ArrayOfProfilePolicy"] = reflect.TypeOf((*ArrayOfProfilePolicy)(nil)).Elem()
}

type ArrayOfProfilePolicyMetadata struct {
	ProfilePolicyMetadata []ProfilePolicyMetadata `xml:"ProfilePolicyMetadata,omitempty"`
}

func init() {
	t["ArrayOfProfilePolicyMetadata"] = reflect.TypeOf((*ArrayOfProfilePolicyMetadata)(nil)).Elem()
}

type ArrayOfProfilePolicyOptionMetadata struct {
	ProfilePolicyOptionMetadata []BaseProfilePolicyOptionMetadata `xml:"ProfilePolicyOptionMetadata,omitempty,typeattr"`
}

func init() {
	t["ArrayOfProfilePolicyOptionMetadata"] = reflect.TypeOf((*ArrayOfProfilePolicyOptionMetadata)(nil)).Elem()
}

type ArrayOfProfileProfileStructureProperty struct {
	ProfileProfileStructureProperty []ProfileProfileStructureProperty `xml:"ProfileProfileStructureProperty,omitempty"`
}

func init() {
	t["ArrayOfProfileProfileStructureProperty"] = reflect.TypeOf((*ArrayOfProfileProfileStructureProperty)(nil)).Elem()
}

type ArrayOfProfilePropertyPath struct {
	ProfilePropertyPath []ProfilePropertyPath `xml:"ProfilePropertyPath,omitempty"`
}

func init() {
	t["ArrayOfProfilePropertyPath"] = reflect.TypeOf((*ArrayOfProfilePropertyPath)(nil)).Elem()
}

type ArrayOfProfileUpdateFailedUpdateFailure struct {
	ProfileUpdateFailedUpdateFailure []ProfileUpdateFailedUpdateFailure `xml:"ProfileUpdateFailedUpdateFailure,omitempty"`
}

func init() {
	t["ArrayOfProfileUpdateFailedUpdateFailure"] = reflect.TypeOf((*ArrayOfProfileUpdateFailedUpdateFailure)(nil)).Elem()
}

type ArrayOfPropertyChange struct {
	PropertyChange []PropertyChange `xml:"PropertyChange,omitempty"`
}

func init() {
	t["ArrayOfPropertyChange"] = reflect.TypeOf((*ArrayOfPropertyChange)(nil)).Elem()
}

type ArrayOfPropertyFilterSpec struct {
	PropertyFilterSpec []PropertyFilterSpec `xml:"PropertyFilterSpec,omitempty"`
}

func init() {
	t["ArrayOfPropertyFilterSpec"] = reflect.TypeOf((*ArrayOfPropertyFilterSpec)(nil)).Elem()
}

type ArrayOfPropertyFilterUpdate struct {
	PropertyFilterUpdate []PropertyFilterUpdate `xml:"PropertyFilterUpdate,omitempty"`
}

func init() {
	t["ArrayOfPropertyFilterUpdate"] = reflect.TypeOf((*ArrayOfPropertyFilterUpdate)(nil)).Elem()
}

type ArrayOfPropertySpec struct {
	PropertySpec []PropertySpec `xml:"PropertySpec,omitempty"`
}

func init() {
	t["ArrayOfPropertySpec"] = reflect.TypeOf((*ArrayOfPropertySpec)(nil)).Elem()
}

type ArrayOfRelation struct {
	Relation []Relation `xml:"Relation,omitempty"`
}

func init() {
	t["ArrayOfRelation"] = reflect.TypeOf((*ArrayOfRelation)(nil)).Elem()
}

type ArrayOfReplicationInfoDiskSettings struct {
	ReplicationInfoDiskSettings []ReplicationInfoDiskSettings `xml:"ReplicationInfoDiskSettings,omitempty"`
}

func init() {
	t["ArrayOfReplicationInfoDiskSettings"] = reflect.TypeOf((*ArrayOfReplicationInfoDiskSettings)(nil)).Elem()
}

type ArrayOfResourceConfigSpec struct {
	ResourceConfigSpec []ResourceConfigSpec `xml:"ResourceConfigSpec,omitempty"`
}

func init() {
	t["ArrayOfResourceConfigSpec"] = reflect.TypeOf((*ArrayOfResourceConfigSpec)(nil)).Elem()
}

type ArrayOfRetrieveVStorageObjSpec struct {
	RetrieveVStorageObjSpec []RetrieveVStorageObjSpec `xml:"RetrieveVStorageObjSpec,omitempty"`
}

func init() {
	t["ArrayOfRetrieveVStorageObjSpec"] = reflect.TypeOf((*ArrayOfRetrieveVStorageObjSpec)(nil)).Elem()
}

type ArrayOfScheduledTaskDetail struct {
	ScheduledTaskDetail []ScheduledTaskDetail `xml:"ScheduledTaskDetail,omitempty"`
}

func init() {
	t["ArrayOfScheduledTaskDetail"] = reflect.TypeOf((*ArrayOfScheduledTaskDetail)(nil)).Elem()
}

type ArrayOfScsiLun struct {
	ScsiLun []BaseScsiLun `xml:"ScsiLun,omitempty,typeattr"`
}

func init() {
	t["ArrayOfScsiLun"] = reflect.TypeOf((*ArrayOfScsiLun)(nil)).Elem()
}

type ArrayOfScsiLunDescriptor struct {
	ScsiLunDescriptor []ScsiLunDescriptor `xml:"ScsiLunDescriptor,omitempty"`
}

func init() {
	t["ArrayOfScsiLunDescriptor"] = reflect.TypeOf((*ArrayOfScsiLunDescriptor)(nil)).Elem()
}

type ArrayOfScsiLunDurableName struct {
	ScsiLunDurableName []ScsiLunDurableName `xml:"ScsiLunDurableName,omitempty"`
}

func init() {
	t["ArrayOfScsiLunDurableName"] = reflect.TypeOf((*ArrayOfScsiLunDurableName)(nil)).Elem()
}

type ArrayOfSelectionSet struct {
	SelectionSet []BaseSelectionSet `xml:"SelectionSet,omitempty,typeattr"`
}

func init() {
	t["ArrayOfSelectionSet"] = reflect.TypeOf((*ArrayOfSelectionSet)(nil)).Elem()
}

type ArrayOfSelectionSpec struct {
	SelectionSpec []BaseSelectionSpec `xml:"SelectionSpec,omitempty,typeattr"`
}

func init() {
	t["ArrayOfSelectionSpec"] = reflect.TypeOf((*ArrayOfSelectionSpec)(nil)).Elem()
}

type ArrayOfServiceConsolePortGroupProfile struct {
	ServiceConsolePortGroupProfile []ServiceConsolePortGroupProfile `xml:"ServiceConsolePortGroupProfile,omitempty"`
}

func init() {
	t["ArrayOfServiceConsolePortGroupProfile"] = reflect.TypeOf((*ArrayOfServiceConsolePortGroupProfile)(nil)).Elem()
}

type ArrayOfServiceLocator struct {
	ServiceLocator []ServiceLocator `xml:"ServiceLocator,omitempty"`
}

func init() {
	t["ArrayOfServiceLocator"] = reflect.TypeOf((*ArrayOfServiceLocator)(nil)).Elem()
}

type ArrayOfServiceManagerServiceInfo struct {
	ServiceManagerServiceInfo []ServiceManagerServiceInfo `xml:"ServiceManagerServiceInfo,omitempty"`
}

func init() {
	t["ArrayOfServiceManagerServiceInfo"] = reflect.TypeOf((*ArrayOfServiceManagerServiceInfo)(nil)).Elem()
}

type ArrayOfServiceProfile struct {
	ServiceProfile []ServiceProfile `xml:"ServiceProfile,omitempty"`
}

func init() {
	t["ArrayOfServiceProfile"] = reflect.TypeOf((*ArrayOfServiceProfile)(nil)).Elem()
}

type ArrayOfShort struct {
	Short []int16 `xml:"short,omitempty"`
}

func init() {
	t["ArrayOfShort"] = reflect.TypeOf((*ArrayOfShort)(nil)).Elem()
}

type ArrayOfSoftwarePackage struct {
	SoftwarePackage []SoftwarePackage `xml:"SoftwarePackage,omitempty"`
}

func init() {
	t["ArrayOfSoftwarePackage"] = reflect.TypeOf((*ArrayOfSoftwarePackage)(nil)).Elem()
}

type ArrayOfStaticRouteProfile struct {
	StaticRouteProfile []StaticRouteProfile `xml:"StaticRouteProfile,omitempty"`
}

func init() {
	t["ArrayOfStaticRouteProfile"] = reflect.TypeOf((*ArrayOfStaticRouteProfile)(nil)).Elem()
}

type ArrayOfStorageDrsOptionSpec struct {
	StorageDrsOptionSpec []StorageDrsOptionSpec `xml:"StorageDrsOptionSpec,omitempty"`
}

func init() {
	t["ArrayOfStorageDrsOptionSpec"] = reflect.TypeOf((*ArrayOfStorageDrsOptionSpec)(nil)).Elem()
}

type ArrayOfStorageDrsPlacementRankVmSpec struct {
	StorageDrsPlacementRankVmSpec []StorageDrsPlacementRankVmSpec `xml:"StorageDrsPlacementRankVmSpec,omitempty"`
}

func init() {
	t["ArrayOfStorageDrsPlacementRankVmSpec"] = reflect.TypeOf((*ArrayOfStorageDrsPlacementRankVmSpec)(nil)).Elem()
}

type ArrayOfStorageDrsVmConfigInfo struct {
	StorageDrsVmConfigInfo []StorageDrsVmConfigInfo `xml:"StorageDrsVmConfigInfo,omitempty"`
}

func init() {
	t["ArrayOfStorageDrsVmConfigInfo"] = reflect.TypeOf((*ArrayOfStorageDrsVmConfigInfo)(nil)).Elem()
}

type ArrayOfStorageDrsVmConfigSpec struct {
	StorageDrsVmConfigSpec []StorageDrsVmConfigSpec `xml:"StorageDrsVmConfigSpec,omitempty"`
}

func init() {
	t["ArrayOfStorageDrsVmConfigSpec"] = reflect.TypeOf((*ArrayOfStorageDrsVmConfigSpec)(nil)).Elem()
}

type ArrayOfStoragePerformanceSummary struct {
	StoragePerformanceSummary []StoragePerformanceSummary `xml:"StoragePerformanceSummary,omitempty"`
}

func init() {
	t["ArrayOfStoragePerformanceSummary"] = reflect.TypeOf((*ArrayOfStoragePerformanceSummary)(nil)).Elem()
}

type ArrayOfStorageRequirement struct {
	StorageRequirement []StorageRequirement `xml:"StorageRequirement,omitempty"`
}

func init() {
	t["ArrayOfStorageRequirement"] = reflect.TypeOf((*ArrayOfStorageRequirement)(nil)).Elem()
}

type ArrayOfString struct {
	String []string `xml:"string,omitempty"`
}

func init() {
	t["ArrayOfString"] = reflect.TypeOf((*ArrayOfString)(nil)).Elem()
}

type ArrayOfStructuredCustomizations struct {
	StructuredCustomizations []StructuredCustomizations `xml:"StructuredCustomizations,omitempty"`
}

func init() {
	t["ArrayOfStructuredCustomizations"] = reflect.TypeOf((*ArrayOfStructuredCustomizations)(nil)).Elem()
}

type ArrayOfSystemEventInfo struct {
	SystemEventInfo []SystemEventInfo `xml:"SystemEventInfo,omitempty"`
}

func init() {
	t["ArrayOfSystemEventInfo"] = reflect.TypeOf((*ArrayOfSystemEventInfo)(nil)).Elem()
}

type ArrayOfTag struct {
	Tag []Tag `xml:"Tag,omitempty"`
}

func init() {
	t["ArrayOfTag"] = reflect.TypeOf((*ArrayOfTag)(nil)).Elem()
}

type ArrayOfTaskInfo struct {
	TaskInfo []TaskInfo `xml:"TaskInfo,omitempty"`
}

func init() {
	t["ArrayOfTaskInfo"] = reflect.TypeOf((*ArrayOfTaskInfo)(nil)).Elem()
}

type ArrayOfTaskInfoState struct {
	TaskInfoState []TaskInfoState `xml:"TaskInfoState,omitempty"`
}

func init() {
	t["ArrayOfTaskInfoState"] = reflect.TypeOf((*ArrayOfTaskInfoState)(nil)).Elem()
}

type ArrayOfTypeDescription struct {
	TypeDescription []BaseTypeDescription `xml:"TypeDescription,omitempty,typeattr"`
}

func init() {
	t["ArrayOfTypeDescription"] = reflect.TypeOf((*ArrayOfTypeDescription)(nil)).Elem()
}

type ArrayOfUpdateVirtualMachineFilesResultFailedVmFileInfo struct {
	UpdateVirtualMachineFilesResultFailedVmFileInfo []UpdateVirtualMachineFilesResultFailedVmFileInfo `xml:"UpdateVirtualMachineFilesResultFailedVmFileInfo,omitempty"`
}

func init() {
	t["ArrayOfUpdateVirtualMachineFilesResultFailedVmFileInfo"] = reflect.TypeOf((*ArrayOfUpdateVirtualMachineFilesResultFailedVmFileInfo)(nil)).Elem()
}

type ArrayOfUri struct {
	Uri []string `xml:"uri,omitempty"`
}

func init() {
	t["ArrayOfUri"] = reflect.TypeOf((*ArrayOfUri)(nil)).Elem()
}

type ArrayOfUsbScanCodeSpecKeyEvent struct {
	UsbScanCodeSpecKeyEvent []UsbScanCodeSpecKeyEvent `xml:"UsbScanCodeSpecKeyEvent,omitempty"`
}

func init() {
	t["ArrayOfUsbScanCodeSpecKeyEvent"] = reflect.TypeOf((*ArrayOfUsbScanCodeSpecKeyEvent)(nil)).Elem()
}

type ArrayOfUserGroupProfile struct {
	UserGroupProfile []UserGroupProfile `xml:"UserGroupProfile,omitempty"`
}

func init() {
	t["ArrayOfUserGroupProfile"] = reflect.TypeOf((*ArrayOfUserGroupProfile)(nil)).Elem()
}

type ArrayOfUserPrivilegeResult struct {
	UserPrivilegeResult []UserPrivilegeResult `xml:"UserPrivilegeResult,omitempty"`
}

func init() {
	t["ArrayOfUserPrivilegeResult"] = reflect.TypeOf((*ArrayOfUserPrivilegeResult)(nil)).Elem()
}

type ArrayOfUserProfile struct {
	UserProfile []UserProfile `xml:"UserProfile,omitempty"`
}

func init() {
	t["ArrayOfUserProfile"] = reflect.TypeOf((*ArrayOfUserProfile)(nil)).Elem()
}

type ArrayOfUserSearchResult struct {
	UserSearchResult []BaseUserSearchResult `xml:"UserSearchResult,omitempty,typeattr"`
}

func init() {
	t["ArrayOfUserSearchResult"] = reflect.TypeOf((*ArrayOfUserSearchResult)(nil)).Elem()
}

type ArrayOfUserSession struct {
	UserSession []UserSession `xml:"UserSession,omitempty"`
}

func init() {
	t["ArrayOfUserSession"] = reflect.TypeOf((*ArrayOfUserSession)(nil)).Elem()
}

type ArrayOfVASAStorageArray struct {
	VASAStorageArray []VASAStorageArray `xml:"VASAStorageArray,omitempty"`
}

func init() {
	t["ArrayOfVASAStorageArray"] = reflect.TypeOf((*ArrayOfVASAStorageArray)(nil)).Elem()
}

type ArrayOfVAppCloneSpecNetworkMappingPair struct {
	VAppCloneSpecNetworkMappingPair []VAppCloneSpecNetworkMappingPair `xml:"VAppCloneSpecNetworkMappingPair,omitempty"`
}

func init() {
	t["ArrayOfVAppCloneSpecNetworkMappingPair"] = reflect.TypeOf((*ArrayOfVAppCloneSpecNetworkMappingPair)(nil)).Elem()
}

type ArrayOfVAppCloneSpecResourceMap struct {
	VAppCloneSpecResourceMap []VAppCloneSpecResourceMap `xml:"VAppCloneSpecResourceMap,omitempty"`
}

func init() {
	t["ArrayOfVAppCloneSpecResourceMap"] = reflect.TypeOf((*ArrayOfVAppCloneSpecResourceMap)(nil)).Elem()
}

type ArrayOfVAppEntityConfigInfo struct {
	VAppEntityConfigInfo []VAppEntityConfigInfo `xml:"VAppEntityConfigInfo,omitempty"`
}

func init() {
	t["ArrayOfVAppEntityConfigInfo"] = reflect.TypeOf((*ArrayOfVAppEntityConfigInfo)(nil)).Elem()
}

type ArrayOfVAppOvfSectionInfo struct {
	VAppOvfSectionInfo []VAppOvfSectionInfo `xml:"VAppOvfSectionInfo,omitempty"`
}

func init() {
	t["ArrayOfVAppOvfSectionInfo"] = reflect.TypeOf((*ArrayOfVAppOvfSectionInfo)(nil)).Elem()
}

type ArrayOfVAppOvfSectionSpec struct {
	VAppOvfSectionSpec []VAppOvfSectionSpec `xml:"VAppOvfSectionSpec,omitempty"`
}

func init() {
	t["ArrayOfVAppOvfSectionSpec"] = reflect.TypeOf((*ArrayOfVAppOvfSectionSpec)(nil)).Elem()
}

type ArrayOfVAppProductInfo struct {
	VAppProductInfo []VAppProductInfo `xml:"VAppProductInfo,omitempty"`
}

func init() {
	t["ArrayOfVAppProductInfo"] = reflect.TypeOf((*ArrayOfVAppProductInfo)(nil)).Elem()
}

type ArrayOfVAppProductSpec struct {
	VAppProductSpec []VAppProductSpec `xml:"VAppProductSpec,omitempty"`
}

func init() {
	t["ArrayOfVAppProductSpec"] = reflect.TypeOf((*ArrayOfVAppProductSpec)(nil)).Elem()
}

type ArrayOfVAppPropertyInfo struct {
	VAppPropertyInfo []VAppPropertyInfo `xml:"VAppPropertyInfo,omitempty"`
}

func init() {
	t["ArrayOfVAppPropertyInfo"] = reflect.TypeOf((*ArrayOfVAppPropertyInfo)(nil)).Elem()
}

type ArrayOfVAppPropertySpec struct {
	VAppPropertySpec []VAppPropertySpec `xml:"VAppPropertySpec,omitempty"`
}

func init() {
	t["ArrayOfVAppPropertySpec"] = reflect.TypeOf((*ArrayOfVAppPropertySpec)(nil)).Elem()
}

type ArrayOfVMwareDVSPvlanConfigSpec struct {
	VMwareDVSPvlanConfigSpec []VMwareDVSPvlanConfigSpec `xml:"VMwareDVSPvlanConfigSpec,omitempty"`
}

func init() {
	t["ArrayOfVMwareDVSPvlanConfigSpec"] = reflect.TypeOf((*ArrayOfVMwareDVSPvlanConfigSpec)(nil)).Elem()
}

type ArrayOfVMwareDVSPvlanMapEntry struct {
	VMwareDVSPvlanMapEntry []VMwareDVSPvlanMapEntry `xml:"VMwareDVSPvlanMapEntry,omitempty"`
}

func init() {
	t["ArrayOfVMwareDVSPvlanMapEntry"] = reflect.TypeOf((*ArrayOfVMwareDVSPvlanMapEntry)(nil)).Elem()
}

type ArrayOfVMwareDVSVspanConfigSpec struct {
	VMwareDVSVspanConfigSpec []VMwareDVSVspanConfigSpec `xml:"VMwareDVSVspanConfigSpec,omitempty"`
}

func init() {
	t["ArrayOfVMwareDVSVspanConfigSpec"] = reflect.TypeOf((*ArrayOfVMwareDVSVspanConfigSpec)(nil)).Elem()
}

type ArrayOfVMwareDvsLacpGroupConfig struct {
	VMwareDvsLacpGroupConfig []VMwareDvsLacpGroupConfig `xml:"VMwareDvsLacpGroupConfig,omitempty"`
}

func init() {
	t["ArrayOfVMwareDvsLacpGroupConfig"] = reflect.TypeOf((*ArrayOfVMwareDvsLacpGroupConfig)(nil)).Elem()
}

type ArrayOfVMwareDvsLacpGroupSpec struct {
	VMwareDvsLacpGroupSpec []VMwareDvsLacpGroupSpec `xml:"VMwareDvsLacpGroupSpec,omitempty"`
}

func init() {
	t["ArrayOfVMwareDvsLacpGroupSpec"] = reflect.TypeOf((*ArrayOfVMwareDvsLacpGroupSpec)(nil)).Elem()
}

type ArrayOfVMwareVspanSession struct {
	VMwareVspanSession []VMwareVspanSession `xml:"VMwareVspanSession,omitempty"`
}

func init() {
	t["ArrayOfVMwareVspanSession"] = reflect.TypeOf((*ArrayOfVMwareVspanSession)(nil)).Elem()
}

type ArrayOfVStorageObjectAssociations struct {
	VStorageObjectAssociations []VStorageObjectAssociations `xml:"VStorageObjectAssociations,omitempty"`
}

func init() {
	t["ArrayOfVStorageObjectAssociations"] = reflect.TypeOf((*ArrayOfVStorageObjectAssociations)(nil)).Elem()
}

type ArrayOfVStorageObjectAssociationsVmDiskAssociations struct {
	VStorageObjectAssociationsVmDiskAssociations []VStorageObjectAssociationsVmDiskAssociations `xml:"VStorageObjectAssociationsVmDiskAssociations,omitempty"`
}

func init() {
	t["ArrayOfVStorageObjectAssociationsVmDiskAssociations"] = reflect.TypeOf((*ArrayOfVStorageObjectAssociationsVmDiskAssociations)(nil)).Elem()
}

type ArrayOfVStorageObjectSnapshotInfoVStorageObjectSnapshot struct {
	VStorageObjectSnapshotInfoVStorageObjectSnapshot []VStorageObjectSnapshotInfoVStorageObjectSnapshot `xml:"VStorageObjectSnapshotInfoVStorageObjectSnapshot,omitempty"`
}

func init() {
	t["ArrayOfVStorageObjectSnapshotInfoVStorageObjectSnapshot"] = reflect.TypeOf((*ArrayOfVStorageObjectSnapshotInfoVStorageObjectSnapshot)(nil)).Elem()
}

type ArrayOfVVolHostPE struct {
	VVolHostPE []VVolHostPE `xml:"VVolHostPE,omitempty"`
}

func init() {
	t["ArrayOfVVolHostPE"] = reflect.TypeOf((*ArrayOfVVolHostPE)(nil)).Elem()
}

type ArrayOfVVolVmConfigFileUpdateResultFailedVmConfigFileInfo struct {
	VVolVmConfigFileUpdateResultFailedVmConfigFileInfo []VVolVmConfigFileUpdateResultFailedVmConfigFileInfo `xml:"VVolVmConfigFileUpdateResultFailedVmConfigFileInfo,omitempty"`
}

func init() {
	t["ArrayOfVVolVmConfigFileUpdateResultFailedVmConfigFileInfo"] = reflect.TypeOf((*ArrayOfVVolVmConfigFileUpdateResultFailedVmConfigFileInfo)(nil)).Elem()
}

type ArrayOfVchaNodeRuntimeInfo struct {
	VchaNodeRuntimeInfo []VchaNodeRuntimeInfo `xml:"VchaNodeRuntimeInfo,omitempty"`
}

func init() {
	t["ArrayOfVchaNodeRuntimeInfo"] = reflect.TypeOf((*ArrayOfVchaNodeRuntimeInfo)(nil)).Elem()
}

type ArrayOfVimVasaProviderInfo struct {
	VimVasaProviderInfo []VimVasaProviderInfo `xml:"VimVasaProviderInfo,omitempty"`
}

func init() {
	t["ArrayOfVimVasaProviderInfo"] = reflect.TypeOf((*ArrayOfVimVasaProviderInfo)(nil)).Elem()
}

type ArrayOfVimVasaProviderStatePerArray struct {
	VimVasaProviderStatePerArray []VimVasaProviderStatePerArray `xml:"VimVasaProviderStatePerArray,omitempty"`
}

func init() {
	t["ArrayOfVimVasaProviderStatePerArray"] = reflect.TypeOf((*ArrayOfVimVasaProviderStatePerArray)(nil)).Elem()
}

type ArrayOfVirtualAppLinkInfo struct {
	VirtualAppLinkInfo []VirtualAppLinkInfo `xml:"VirtualAppLinkInfo,omitempty"`
}

func init() {
	t["ArrayOfVirtualAppLinkInfo"] = reflect.TypeOf((*ArrayOfVirtualAppLinkInfo)(nil)).Elem()
}

type ArrayOfVirtualDevice struct {
	VirtualDevice []BaseVirtualDevice `xml:"VirtualDevice,omitempty,typeattr"`
}

func init() {
	t["ArrayOfVirtualDevice"] = reflect.TypeOf((*ArrayOfVirtualDevice)(nil)).Elem()
}

type ArrayOfVirtualDeviceBackingOption struct {
	VirtualDeviceBackingOption []BaseVirtualDeviceBackingOption `xml:"VirtualDeviceBackingOption,omitempty,typeattr"`
}

func init() {
	t["ArrayOfVirtualDeviceBackingOption"] = reflect.TypeOf((*ArrayOfVirtualDeviceBackingOption)(nil)).Elem()
}

type ArrayOfVirtualDeviceConfigSpec struct {
	VirtualDeviceConfigSpec []BaseVirtualDeviceConfigSpec `xml:"VirtualDeviceConfigSpec,omitempty,typeattr"`
}

func init() {
	t["ArrayOfVirtualDeviceConfigSpec"] = reflect.TypeOf((*ArrayOfVirtualDeviceConfigSpec)(nil)).Elem()
}

type ArrayOfVirtualDeviceOption struct {
	VirtualDeviceOption []BaseVirtualDeviceOption `xml:"VirtualDeviceOption,omitempty,typeattr"`
}

func init() {
	t["ArrayOfVirtualDeviceOption"] = reflect.TypeOf((*ArrayOfVirtualDeviceOption)(nil)).Elem()
}

type ArrayOfVirtualDisk struct {
	VirtualDisk []VirtualDisk `xml:"VirtualDisk,omitempty"`
}

func init() {
	t["ArrayOfVirtualDisk"] = reflect.TypeOf((*ArrayOfVirtualDisk)(nil)).Elem()
}

type ArrayOfVirtualDiskDeltaDiskFormatsSupported struct {
	VirtualDiskDeltaDiskFormatsSupported []VirtualDiskDeltaDiskFormatsSupported `xml:"VirtualDiskDeltaDiskFormatsSupported,omitempty"`
}

func init() {
	t["ArrayOfVirtualDiskDeltaDiskFormatsSupported"] = reflect.TypeOf((*ArrayOfVirtualDiskDeltaDiskFormatsSupported)(nil)).Elem()
}

type ArrayOfVirtualDiskId struct {
	VirtualDiskId []VirtualDiskId `xml:"VirtualDiskId,omitempty"`
}

func init() {
	t["ArrayOfVirtualDiskId"] = reflect.TypeOf((*ArrayOfVirtualDiskId)(nil)).Elem()
}

type ArrayOfVirtualDiskRuleSpec struct {
	VirtualDiskRuleSpec []VirtualDiskRuleSpec `xml:"VirtualDiskRuleSpec,omitempty"`
}

func init() {
	t["ArrayOfVirtualDiskRuleSpec"] = reflect.TypeOf((*ArrayOfVirtualDiskRuleSpec)(nil)).Elem()
}

type ArrayOfVirtualMachineBaseIndependentFilterSpec struct {
	VirtualMachineBaseIndependentFilterSpec []BaseVirtualMachineBaseIndependentFilterSpec `xml:"VirtualMachineBaseIndependentFilterSpec,omitempty,typeattr"`
}

func init() {
	t["ArrayOfVirtualMachineBaseIndependentFilterSpec"] = reflect.TypeOf((*ArrayOfVirtualMachineBaseIndependentFilterSpec)(nil)).Elem()
}

type ArrayOfVirtualMachineBootOptionsBootableDevice struct {
	VirtualMachineBootOptionsBootableDevice []BaseVirtualMachineBootOptionsBootableDevice `xml:"VirtualMachineBootOptionsBootableDevice,omitempty,typeattr"`
}

func init() {
	t["ArrayOfVirtualMachineBootOptionsBootableDevice"] = reflect.TypeOf((*ArrayOfVirtualMachineBootOptionsBootableDevice)(nil)).Elem()
}

type ArrayOfVirtualMachineCdromInfo struct {
	VirtualMachineCdromInfo []VirtualMachineCdromInfo `xml:"VirtualMachineCdromInfo,omitempty"`
}

func init() {
	t["ArrayOfVirtualMachineCdromInfo"] = reflect.TypeOf((*ArrayOfVirtualMachineCdromInfo)(nil)).Elem()
}

type ArrayOfVirtualMachineConfigInfoDatastoreUrlPair struct {
	VirtualMachineConfigInfoDatastoreUrlPair []VirtualMachineConfigInfoDatastoreUrlPair `xml:"VirtualMachineConfigInfoDatastoreUrlPair,omitempty"`
}

func init() {
	t["ArrayOfVirtualMachineConfigInfoDatastoreUrlPair"] = reflect.TypeOf((*ArrayOfVirtualMachineConfigInfoDatastoreUrlPair)(nil)).Elem()
}

type ArrayOfVirtualMachineConfigOptionDescriptor struct {
	VirtualMachineConfigOptionDescriptor []VirtualMachineConfigOptionDescriptor `xml:"VirtualMachineConfigOptionDescriptor,omitempty"`
}

func init() {
	t["ArrayOfVirtualMachineConfigOptionDescriptor"] = reflect.TypeOf((*ArrayOfVirtualMachineConfigOptionDescriptor)(nil)).Elem()
}

type ArrayOfVirtualMachineConfigSpec struct {
	VirtualMachineConfigSpec []VirtualMachineConfigSpec `xml:"VirtualMachineConfigSpec,omitempty"`
}

func init() {
	t["ArrayOfVirtualMachineConfigSpec"] = reflect.TypeOf((*ArrayOfVirtualMachineConfigSpec)(nil)).Elem()
}

type ArrayOfVirtualMachineConnection struct {
	VirtualMachineConnection []BaseVirtualMachineConnection `xml:"VirtualMachineConnection,omitempty,typeattr"`
}

func init() {
	t["ArrayOfVirtualMachineConnection"] = reflect.TypeOf((*ArrayOfVirtualMachineConnection)(nil)).Elem()
}

type ArrayOfVirtualMachineCpuIdInfoSpec struct {
	VirtualMachineCpuIdInfoSpec []VirtualMachineCpuIdInfoSpec `xml:"VirtualMachineCpuIdInfoSpec,omitempty"`
}

func init() {
	t["ArrayOfVirtualMachineCpuIdInfoSpec"] = reflect.TypeOf((*ArrayOfVirtualMachineCpuIdInfoSpec)(nil)).Elem()
}

type ArrayOfVirtualMachineDatastoreInfo struct {
	VirtualMachineDatastoreInfo []VirtualMachineDatastoreInfo `xml:"VirtualMachineDatastoreInfo,omitempty"`
}

func init() {
	t["ArrayOfVirtualMachineDatastoreInfo"] = reflect.TypeOf((*ArrayOfVirtualMachineDatastoreInfo)(nil)).Elem()
}

type ArrayOfVirtualMachineDatastoreVolumeOption struct {
	VirtualMachineDatastoreVolumeOption []VirtualMachineDatastoreVolumeOption `xml:"VirtualMachineDatastoreVolumeOption,omitempty"`
}

func init() {
	t["ArrayOfVirtualMachineDatastoreVolumeOption"] = reflect.TypeOf((*ArrayOfVirtualMachineDatastoreVolumeOption)(nil)).Elem()
}

type ArrayOfVirtualMachineDeviceRuntimeInfo struct {
	VirtualMachineDeviceRuntimeInfo []VirtualMachineDeviceRuntimeInfo `xml:"VirtualMachineDeviceRuntimeInfo,omitempty"`
}

func init() {
	t["ArrayOfVirtualMachineDeviceRuntimeInfo"] = reflect.TypeOf((*ArrayOfVirtualMachineDeviceRuntimeInfo)(nil)).Elem()
}

type ArrayOfVirtualMachineDisplayTopology struct {
	VirtualMachineDisplayTopology []VirtualMachineDisplayTopology `xml:"VirtualMachineDisplayTopology,omitempty"`
}

func init() {
	t["ArrayOfVirtualMachineDisplayTopology"] = reflect.TypeOf((*ArrayOfVirtualMachineDisplayTopology)(nil)).Elem()
}

type ArrayOfVirtualMachineDynamicPassthroughInfo struct {
	VirtualMachineDynamicPassthroughInfo []VirtualMachineDynamicPassthroughInfo `xml:"VirtualMachineDynamicPassthroughInfo,omitempty"`
}

func init() {
	t["ArrayOfVirtualMachineDynamicPassthroughInfo"] = reflect.TypeOf((*ArrayOfVirtualMachineDynamicPassthroughInfo)(nil)).Elem()
}

type ArrayOfVirtualMachineFeatureRequirement struct {
	VirtualMachineFeatureRequirement []VirtualMachineFeatureRequirement `xml:"VirtualMachineFeatureRequirement,omitempty"`
}

func init() {
	t["ArrayOfVirtualMachineFeatureRequirement"] = reflect.TypeOf((*ArrayOfVirtualMachineFeatureRequirement)(nil)).Elem()
}

type ArrayOfVirtualMachineFileLayoutDiskLayout struct {
	VirtualMachineFileLayoutDiskLayout []VirtualMachineFileLayoutDiskLayout `xml:"VirtualMachineFileLayoutDiskLayout,omitempty"`
}

func init() {
	t["ArrayOfVirtualMachineFileLayoutDiskLayout"] = reflect.TypeOf((*ArrayOfVirtualMachineFileLayoutDiskLayout)(nil)).Elem()
}

type ArrayOfVirtualMachineFileLayoutExDiskLayout struct {
	VirtualMachineFileLayoutExDiskLayout []VirtualMachineFileLayoutExDiskLayout `xml:"VirtualMachineFileLayoutExDiskLayout,omitempty"`
}

func init() {
	t["ArrayOfVirtualMachineFileLayoutExDiskLayout"] = reflect.TypeOf((*ArrayOfVirtualMachineFileLayoutExDiskLayout)(nil)).Elem()
}

type ArrayOfVirtualMachineFileLayoutExDiskUnit struct {
	VirtualMachineFileLayoutExDiskUnit []VirtualMachineFileLayoutExDiskUnit `xml:"VirtualMachineFileLayoutExDiskUnit,omitempty"`
}

func init() {
	t["ArrayOfVirtualMachineFileLayoutExDiskUnit"] = reflect.TypeOf((*ArrayOfVirtualMachineFileLayoutExDiskUnit)(nil)).Elem()
}

type ArrayOfVirtualMachineFileLayoutExFileInfo struct {
	VirtualMachineFileLayoutExFileInfo []VirtualMachineFileLayoutExFileInfo `xml:"VirtualMachineFileLayoutExFileInfo,omitempty"`
}

func init() {
	t["ArrayOfVirtualMachineFileLayoutExFileInfo"] = reflect.TypeOf((*ArrayOfVirtualMachineFileLayoutExFileInfo)(nil)).Elem()
}

type ArrayOfVirtualMachineFileLayoutExSnapshotLayout struct {
	VirtualMachineFileLayoutExSnapshotLayout []VirtualMachineFileLayoutExSnapshotLayout `xml:"VirtualMachineFileLayoutExSnapshotLayout,omitempty"`
}

func init() {
	t["ArrayOfVirtualMachineFileLayoutExSnapshotLayout"] = reflect.TypeOf((*ArrayOfVirtualMachineFileLayoutExSnapshotLayout)(nil)).Elem()
}

type ArrayOfVirtualMachineFileLayoutSnapshotLayout struct {
	VirtualMachineFileLayoutSnapshotLayout []VirtualMachineFileLayoutSnapshotLayout `xml:"VirtualMachineFileLayoutSnapshotLayout,omitempty"`
}

func init() {
	t["ArrayOfVirtualMachineFileLayoutSnapshotLayout"] = reflect.TypeOf((*ArrayOfVirtualMachineFileLayoutSnapshotLayout)(nil)).Elem()
}

type ArrayOfVirtualMachineFloppyInfo struct {
	VirtualMachineFloppyInfo []VirtualMachineFloppyInfo `xml:"VirtualMachineFloppyInfo,omitempty"`
}

func init() {
	t["ArrayOfVirtualMachineFloppyInfo"] = reflect.TypeOf((*ArrayOfVirtualMachineFloppyInfo)(nil)).Elem()
}

type ArrayOfVirtualMachineIdeDiskDeviceInfo struct {
	VirtualMachineIdeDiskDeviceInfo []VirtualMachineIdeDiskDeviceInfo `xml:"VirtualMachineIdeDiskDeviceInfo,omitempty"`
}

func init() {
	t["ArrayOfVirtualMachineIdeDiskDeviceInfo"] = reflect.TypeOf((*ArrayOfVirtualMachineIdeDiskDeviceInfo)(nil)).Elem()
}

type ArrayOfVirtualMachineIdeDiskDevicePartitionInfo struct {
	VirtualMachineIdeDiskDevicePartitionInfo []VirtualMachineIdeDiskDevicePartitionInfo `xml:"VirtualMachineIdeDiskDevicePartitionInfo,omitempty"`
}

func init() {
	t["ArrayOfVirtualMachineIdeDiskDevicePartitionInfo"] = reflect.TypeOf((*ArrayOfVirtualMachineIdeDiskDevicePartitionInfo)(nil)).Elem()
}

type ArrayOfVirtualMachineLegacyNetworkSwitchInfo struct {
	VirtualMachineLegacyNetworkSwitchInfo []VirtualMachineLegacyNetworkSwitchInfo `xml:"VirtualMachineLegacyNetworkSwitchInfo,omitempty"`
}

func init() {
	t["ArrayOfVirtualMachineLegacyNetworkSwitchInfo"] = reflect.TypeOf((*ArrayOfVirtualMachineLegacyNetworkSwitchInfo)(nil)).Elem()
}

type ArrayOfVirtualMachineMessage struct {
	VirtualMachineMessage []VirtualMachineMessage `xml:"VirtualMachineMessage,omitempty"`
}

func init() {
	t["ArrayOfVirtualMachineMessage"] = reflect.TypeOf((*ArrayOfVirtualMachineMessage)(nil)).Elem()
}

type ArrayOfVirtualMachineMetadataManagerVmMetadataInput struct {
	VirtualMachineMetadataManagerVmMetadataInput []VirtualMachineMetadataManagerVmMetadataInput `xml:"VirtualMachineMetadataManagerVmMetadataInput,omitempty"`
}

func init() {
	t["ArrayOfVirtualMachineMetadataManagerVmMetadataInput"] = reflect.TypeOf((*ArrayOfVirtualMachineMetadataManagerVmMetadataInput)(nil)).Elem()
}

type ArrayOfVirtualMachineMetadataManagerVmMetadataResult struct {
	VirtualMachineMetadataManagerVmMetadataResult []VirtualMachineMetadataManagerVmMetadataResult `xml:"VirtualMachineMetadataManagerVmMetadataResult,omitempty"`
}

func init() {
	t["ArrayOfVirtualMachineMetadataManagerVmMetadataResult"] = reflect.TypeOf((*ArrayOfVirtualMachineMetadataManagerVmMetadataResult)(nil)).Elem()
}

type ArrayOfVirtualMachineNetworkInfo struct {
	VirtualMachineNetworkInfo []VirtualMachineNetworkInfo `xml:"VirtualMachineNetworkInfo,omitempty"`
}

func init() {
	t["ArrayOfVirtualMachineNetworkInfo"] = reflect.TypeOf((*ArrayOfVirtualMachineNetworkInfo)(nil)).Elem()
}

type ArrayOfVirtualMachineParallelInfo struct {
	VirtualMachineParallelInfo []VirtualMachineParallelInfo `xml:"VirtualMachineParallelInfo,omitempty"`
}

func init() {
	t["ArrayOfVirtualMachineParallelInfo"] = reflect.TypeOf((*ArrayOfVirtualMachineParallelInfo)(nil)).Elem()
}

type ArrayOfVirtualMachinePciPassthroughInfo struct {
	VirtualMachinePciPassthroughInfo []BaseVirtualMachinePciPassthroughInfo `xml:"VirtualMachinePciPassthroughInfo,omitempty,typeattr"`
}

func init() {
	t["ArrayOfVirtualMachinePciPassthroughInfo"] = reflect.TypeOf((*ArrayOfVirtualMachinePciPassthroughInfo)(nil)).Elem()
}

type ArrayOfVirtualMachinePciSharedGpuPassthroughInfo struct {
	VirtualMachinePciSharedGpuPassthroughInfo []VirtualMachinePciSharedGpuPassthroughInfo `xml:"VirtualMachinePciSharedGpuPassthroughInfo,omitempty"`
}

func init() {
	t["ArrayOfVirtualMachinePciSharedGpuPassthroughInfo"] = reflect.TypeOf((*ArrayOfVirtualMachinePciSharedGpuPassthroughInfo)(nil)).Elem()
}

type ArrayOfVirtualMachinePrecisionClockInfo struct {
	VirtualMachinePrecisionClockInfo []VirtualMachinePrecisionClockInfo `xml:"VirtualMachinePrecisionClockInfo,omitempty"`
}

func init() {
	t["ArrayOfVirtualMachinePrecisionClockInfo"] = reflect.TypeOf((*ArrayOfVirtualMachinePrecisionClockInfo)(nil)).Elem()
}

type ArrayOfVirtualMachineProfileDetailsDiskProfileDetails struct {
	VirtualMachineProfileDetailsDiskProfileDetails []VirtualMachineProfileDetailsDiskProfileDetails `xml:"VirtualMachineProfileDetailsDiskProfileDetails,omitempty"`
}

func init() {
	t["ArrayOfVirtualMachineProfileDetailsDiskProfileDetails"] = reflect.TypeOf((*ArrayOfVirtualMachineProfileDetailsDiskProfileDetails)(nil)).Elem()
}

type ArrayOfVirtualMachineProfileSpec struct {
	VirtualMachineProfileSpec []BaseVirtualMachineProfileSpec `xml:"VirtualMachineProfileSpec,omitempty,typeattr"`
}

func init() {
	t["ArrayOfVirtualMachineProfileSpec"] = reflect.TypeOf((*ArrayOfVirtualMachineProfileSpec)(nil)).Elem()
}

type ArrayOfVirtualMachinePropertyRelation struct {
	VirtualMachinePropertyRelation []VirtualMachinePropertyRelation `xml:"VirtualMachinePropertyRelation,omitempty"`
}

func init() {
	t["ArrayOfVirtualMachinePropertyRelation"] = reflect.TypeOf((*ArrayOfVirtualMachinePropertyRelation)(nil)).Elem()
}

type ArrayOfVirtualMachineQuickStatsMemoryTierStats struct {
	VirtualMachineQuickStatsMemoryTierStats []VirtualMachineQuickStatsMemoryTierStats `xml:"VirtualMachineQuickStatsMemoryTierStats,omitempty"`
}

func init() {
	t["ArrayOfVirtualMachineQuickStatsMemoryTierStats"] = reflect.TypeOf((*ArrayOfVirtualMachineQuickStatsMemoryTierStats)(nil)).Elem()
}

type ArrayOfVirtualMachineRelocateSpecDiskLocator struct {
	VirtualMachineRelocateSpecDiskLocator []VirtualMachineRelocateSpecDiskLocator `xml:"VirtualMachineRelocateSpecDiskLocator,omitempty"`
}

func init() {
	t["ArrayOfVirtualMachineRelocateSpecDiskLocator"] = reflect.TypeOf((*ArrayOfVirtualMachineRelocateSpecDiskLocator)(nil)).Elem()
}

type ArrayOfVirtualMachineScsiDiskDeviceInfo struct {
	VirtualMachineScsiDiskDeviceInfo []VirtualMachineScsiDiskDeviceInfo `xml:"VirtualMachineScsiDiskDeviceInfo,omitempty"`
}

func init() {
	t["ArrayOfVirtualMachineScsiDiskDeviceInfo"] = reflect.TypeOf((*ArrayOfVirtualMachineScsiDiskDeviceInfo)(nil)).Elem()
}

type ArrayOfVirtualMachineScsiPassthroughInfo struct {
	VirtualMachineScsiPassthroughInfo []VirtualMachineScsiPassthroughInfo `xml:"VirtualMachineScsiPassthroughInfo,omitempty"`
}

func init() {
	t["ArrayOfVirtualMachineScsiPassthroughInfo"] = reflect.TypeOf((*ArrayOfVirtualMachineScsiPassthroughInfo)(nil)).Elem()
}

type ArrayOfVirtualMachineSerialInfo struct {
	VirtualMachineSerialInfo []VirtualMachineSerialInfo `xml:"VirtualMachineSerialInfo,omitempty"`
}

func init() {
	t["ArrayOfVirtualMachineSerialInfo"] = reflect.TypeOf((*ArrayOfVirtualMachineSerialInfo)(nil)).Elem()
}

type ArrayOfVirtualMachineSnapshotTree struct {
	VirtualMachineSnapshotTree []VirtualMachineSnapshotTree `xml:"VirtualMachineSnapshotTree,omitempty"`
}

func init() {
	t["ArrayOfVirtualMachineSnapshotTree"] = reflect.TypeOf((*ArrayOfVirtualMachineSnapshotTree)(nil)).Elem()
}

type ArrayOfVirtualMachineSoundInfo struct {
	VirtualMachineSoundInfo []VirtualMachineSoundInfo `xml:"VirtualMachineSoundInfo,omitempty"`
}

func init() {
	t["ArrayOfVirtualMachineSoundInfo"] = reflect.TypeOf((*ArrayOfVirtualMachineSoundInfo)(nil)).Elem()
}

type ArrayOfVirtualMachineSriovInfo struct {
	VirtualMachineSriovInfo []VirtualMachineSriovInfo `xml:"VirtualMachineSriovInfo,omitempty"`
}

func init() {
	t["ArrayOfVirtualMachineSriovInfo"] = reflect.TypeOf((*ArrayOfVirtualMachineSriovInfo)(nil)).Elem()
}

type ArrayOfVirtualMachineSummary struct {
	VirtualMachineSummary []VirtualMachineSummary `xml:"VirtualMachineSummary,omitempty"`
}

func init() {
	t["ArrayOfVirtualMachineSummary"] = reflect.TypeOf((*ArrayOfVirtualMachineSummary)(nil)).Elem()
}

type ArrayOfVirtualMachineUsageOnDatastore struct {
	VirtualMachineUsageOnDatastore []VirtualMachineUsageOnDatastore `xml:"VirtualMachineUsageOnDatastore,omitempty"`
}

func init() {
	t["ArrayOfVirtualMachineUsageOnDatastore"] = reflect.TypeOf((*ArrayOfVirtualMachineUsageOnDatastore)(nil)).Elem()
}

type ArrayOfVirtualMachineUsbInfo struct {
	VirtualMachineUsbInfo []VirtualMachineUsbInfo `xml:"VirtualMachineUsbInfo,omitempty"`
}

func init() {
	t["ArrayOfVirtualMachineUsbInfo"] = reflect.TypeOf((*ArrayOfVirtualMachineUsbInfo)(nil)).Elem()
}

type ArrayOfVirtualMachineVFlashModuleInfo struct {
	VirtualMachineVFlashModuleInfo []VirtualMachineVFlashModuleInfo `xml:"VirtualMachineVFlashModuleInfo,omitempty"`
}

func init() {
	t["ArrayOfVirtualMachineVFlashModuleInfo"] = reflect.TypeOf((*ArrayOfVirtualMachineVFlashModuleInfo)(nil)).Elem()
}

type ArrayOfVirtualMachineVMCIDeviceFilterSpec struct {
	VirtualMachineVMCIDeviceFilterSpec []VirtualMachineVMCIDeviceFilterSpec `xml:"VirtualMachineVMCIDeviceFilterSpec,omitempty"`
}

func init() {
	t["ArrayOfVirtualMachineVMCIDeviceFilterSpec"] = reflect.TypeOf((*ArrayOfVirtualMachineVMCIDeviceFilterSpec)(nil)).Elem()
}

type ArrayOfVirtualMachineVcpuConfig struct {
	VirtualMachineVcpuConfig []VirtualMachineVcpuConfig `xml:"VirtualMachineVcpuConfig,omitempty"`
}

func init() {
	t["ArrayOfVirtualMachineVcpuConfig"] = reflect.TypeOf((*ArrayOfVirtualMachineVcpuConfig)(nil)).Elem()
}

type ArrayOfVirtualNicManagerNetConfig struct {
	VirtualNicManagerNetConfig []VirtualNicManagerNetConfig `xml:"VirtualNicManagerNetConfig,omitempty"`
}

func init() {
	t["ArrayOfVirtualNicManagerNetConfig"] = reflect.TypeOf((*ArrayOfVirtualNicManagerNetConfig)(nil)).Elem()
}

type ArrayOfVirtualPCIPassthroughAllowedDevice struct {
	VirtualPCIPassthroughAllowedDevice []VirtualPCIPassthroughAllowedDevice `xml:"VirtualPCIPassthroughAllowedDevice,omitempty"`
}

func init() {
	t["ArrayOfVirtualPCIPassthroughAllowedDevice"] = reflect.TypeOf((*ArrayOfVirtualPCIPassthroughAllowedDevice)(nil)).Elem()
}

type ArrayOfVirtualSCSISharing struct {
	VirtualSCSISharing []VirtualSCSISharing `xml:"VirtualSCSISharing,omitempty"`
}

func init() {
	t["ArrayOfVirtualSCSISharing"] = reflect.TypeOf((*ArrayOfVirtualSCSISharing)(nil)).Elem()
}

type ArrayOfVirtualSwitchProfile struct {
	VirtualSwitchProfile []VirtualSwitchProfile `xml:"VirtualSwitchProfile,omitempty"`
}

func init() {
	t["ArrayOfVirtualSwitchProfile"] = reflect.TypeOf((*ArrayOfVirtualSwitchProfile)(nil)).Elem()
}

type ArrayOfVmEventArgument struct {
	VmEventArgument []VmEventArgument `xml:"VmEventArgument,omitempty"`
}

func init() {
	t["ArrayOfVmEventArgument"] = reflect.TypeOf((*ArrayOfVmEventArgument)(nil)).Elem()
}

type ArrayOfVmPodConfigForPlacement struct {
	VmPodConfigForPlacement []VmPodConfigForPlacement `xml:"VmPodConfigForPlacement,omitempty"`
}

func init() {
	t["ArrayOfVmPodConfigForPlacement"] = reflect.TypeOf((*ArrayOfVmPodConfigForPlacement)(nil)).Elem()
}

type ArrayOfVmPortGroupProfile struct {
	VmPortGroupProfile []VmPortGroupProfile `xml:"VmPortGroupProfile,omitempty"`
}

func init() {
	t["ArrayOfVmPortGroupProfile"] = reflect.TypeOf((*ArrayOfVmPortGroupProfile)(nil)).Elem()
}

type ArrayOfVmfsConfigOption struct {
	VmfsConfigOption []VmfsConfigOption `xml:"VmfsConfigOption,omitempty"`
}

func init() {
	t["ArrayOfVmfsConfigOption"] = reflect.TypeOf((*ArrayOfVmfsConfigOption)(nil)).Elem()
}

type ArrayOfVmfsDatastoreOption struct {
	VmfsDatastoreOption []VmfsDatastoreOption `xml:"VmfsDatastoreOption,omitempty"`
}

func init() {
	t["ArrayOfVmfsDatastoreOption"] = reflect.TypeOf((*ArrayOfVmfsDatastoreOption)(nil)).Elem()
}

type ArrayOfVnicPortArgument struct {
	VnicPortArgument []VnicPortArgument `xml:"VnicPortArgument,omitempty"`
}

func init() {
	t["ArrayOfVnicPortArgument"] = reflect.TypeOf((*ArrayOfVnicPortArgument)(nil)).Elem()
}

type ArrayOfVsanHostConfigInfo struct {
	VsanHostConfigInfo []VsanHostConfigInfo `xml:"VsanHostConfigInfo,omitempty"`
}

func init() {
	t["ArrayOfVsanHostConfigInfo"] = reflect.TypeOf((*ArrayOfVsanHostConfigInfo)(nil)).Elem()
}

type ArrayOfVsanHostConfigInfoNetworkInfoPortConfig struct {
	VsanHostConfigInfoNetworkInfoPortConfig []VsanHostConfigInfoNetworkInfoPortConfig `xml:"VsanHostConfigInfoNetworkInfoPortConfig,omitempty"`
}

func init() {
	t["ArrayOfVsanHostConfigInfoNetworkInfoPortConfig"] = reflect.TypeOf((*ArrayOfVsanHostConfigInfoNetworkInfoPortConfig)(nil)).Elem()
}

type ArrayOfVsanHostDiskMapInfo struct {
	VsanHostDiskMapInfo []VsanHostDiskMapInfo `xml:"VsanHostDiskMapInfo,omitempty"`
}

func init() {
	t["ArrayOfVsanHostDiskMapInfo"] = reflect.TypeOf((*ArrayOfVsanHostDiskMapInfo)(nil)).Elem()
}

type ArrayOfVsanHostDiskMapResult struct {
	VsanHostDiskMapResult []VsanHostDiskMapResult `xml:"VsanHostDiskMapResult,omitempty"`
}

func init() {
	t["ArrayOfVsanHostDiskMapResult"] = reflect.TypeOf((*ArrayOfVsanHostDiskMapResult)(nil)).Elem()
}

type ArrayOfVsanHostDiskMapping struct {
	VsanHostDiskMapping []VsanHostDiskMapping `xml:"VsanHostDiskMapping,omitempty"`
}

func init() {
	t["ArrayOfVsanHostDiskMapping"] = reflect.TypeOf((*ArrayOfVsanHostDiskMapping)(nil)).Elem()
}

type ArrayOfVsanHostDiskResult struct {
	VsanHostDiskResult []VsanHostDiskResult `xml:"VsanHostDiskResult,omitempty"`
}

func init() {
	t["ArrayOfVsanHostDiskResult"] = reflect.TypeOf((*ArrayOfVsanHostDiskResult)(nil)).Elem()
}

type ArrayOfVsanHostMembershipInfo struct {
	VsanHostMembershipInfo []VsanHostMembershipInfo `xml:"VsanHostMembershipInfo,omitempty"`
}

func init() {
	t["ArrayOfVsanHostMembershipInfo"] = reflect.TypeOf((*ArrayOfVsanHostMembershipInfo)(nil)).Elem()
}

type ArrayOfVsanHostRuntimeInfoDiskIssue struct {
	VsanHostRuntimeInfoDiskIssue []VsanHostRuntimeInfoDiskIssue `xml:"VsanHostRuntimeInfoDiskIssue,omitempty"`
}

func init() {
	t["ArrayOfVsanHostRuntimeInfoDiskIssue"] = reflect.TypeOf((*ArrayOfVsanHostRuntimeInfoDiskIssue)(nil)).Elem()
}

type ArrayOfVsanNewPolicyBatch struct {
	VsanNewPolicyBatch []VsanNewPolicyBatch `xml:"VsanNewPolicyBatch,omitempty"`
}

func init() {
	t["ArrayOfVsanNewPolicyBatch"] = reflect.TypeOf((*ArrayOfVsanNewPolicyBatch)(nil)).Elem()
}

type ArrayOfVsanPolicyChangeBatch struct {
	VsanPolicyChangeBatch []VsanPolicyChangeBatch `xml:"VsanPolicyChangeBatch,omitempty"`
}

func init() {
	t["ArrayOfVsanPolicyChangeBatch"] = reflect.TypeOf((*ArrayOfVsanPolicyChangeBatch)(nil)).Elem()
}

type ArrayOfVsanPolicySatisfiability struct {
	VsanPolicySatisfiability []VsanPolicySatisfiability `xml:"VsanPolicySatisfiability,omitempty"`
}

func init() {
	t["ArrayOfVsanPolicySatisfiability"] = reflect.TypeOf((*ArrayOfVsanPolicySatisfiability)(nil)).Elem()
}

type ArrayOfVsanUpgradeSystemNetworkPartitionInfo struct {
	VsanUpgradeSystemNetworkPartitionInfo []VsanUpgradeSystemNetworkPartitionInfo `xml:"VsanUpgradeSystemNetworkPartitionInfo,omitempty"`
}

func init() {
	t["ArrayOfVsanUpgradeSystemNetworkPartitionInfo"] = reflect.TypeOf((*ArrayOfVsanUpgradeSystemNetworkPartitionInfo)(nil)).Elem()
}

type ArrayOfVsanUpgradeSystemPreflightCheckIssue struct {
	VsanUpgradeSystemPreflightCheckIssue []BaseVsanUpgradeSystemPreflightCheckIssue `xml:"VsanUpgradeSystemPreflightCheckIssue,omitempty,typeattr"`
}

func init() {
	t["ArrayOfVsanUpgradeSystemPreflightCheckIssue"] = reflect.TypeOf((*ArrayOfVsanUpgradeSystemPreflightCheckIssue)(nil)).Elem()
}

type ArrayOfVsanUpgradeSystemUpgradeHistoryItem struct {
	VsanUpgradeSystemUpgradeHistoryItem []BaseVsanUpgradeSystemUpgradeHistoryItem `xml:"VsanUpgradeSystemUpgradeHistoryItem,omitempty,typeattr"`
}

func init() {
	t["ArrayOfVsanUpgradeSystemUpgradeHistoryItem"] = reflect.TypeOf((*ArrayOfVsanUpgradeSystemUpgradeHistoryItem)(nil)).Elem()
}

type ArrayOfVslmTagEntry struct {
	VslmTagEntry []VslmTagEntry `xml:"VslmTagEntry,omitempty"`
}

func init() {
	t["ArrayOfVslmTagEntry"] = reflect.TypeOf((*ArrayOfVslmTagEntry)(nil)).Elem()
}

type ArrayOfVslmInfrastructureObjectPolicy struct {
	VslmInfrastructureObjectPolicy []VslmInfrastructureObjectPolicy `xml:"vslmInfrastructureObjectPolicy,omitempty"`
}

func init() {
	t["ArrayOfvslmInfrastructureObjectPolicy"] = reflect.TypeOf((*ArrayOfVslmInfrastructureObjectPolicy)(nil)).Elem()
}

type ArrayUpdateSpec struct {
	DynamicData

	Operation ArrayUpdateOperation `xml:"operation"`
	RemoveKey AnyType              `xml:"removeKey,omitempty,typeattr"`
}

func init() {
	t["ArrayUpdateSpec"] = reflect.TypeOf((*ArrayUpdateSpec)(nil)).Elem()
}

type AssignUserToGroup AssignUserToGroupRequestType

func init() {
	t["AssignUserToGroup"] = reflect.TypeOf((*AssignUserToGroup)(nil)).Elem()
}

type AssignUserToGroupRequestType struct {
	This  ManagedObjectReference `xml:"_this"`
	User  string                 `xml:"user"`
	Group string                 `xml:"group"`
}

func init() {
	t["AssignUserToGroupRequestType"] = reflect.TypeOf((*AssignUserToGroupRequestType)(nil)).Elem()
}

type AssignUserToGroupResponse struct {
}

type AssociateProfile AssociateProfileRequestType

func init() {
	t["AssociateProfile"] = reflect.TypeOf((*AssociateProfile)(nil)).Elem()
}

type AssociateProfileRequestType struct {
	This   ManagedObjectReference   `xml:"_this"`
	Entity []ManagedObjectReference `xml:"entity"`
}

func init() {
	t["AssociateProfileRequestType"] = reflect.TypeOf((*AssociateProfileRequestType)(nil)).Elem()
}

type AssociateProfileResponse struct {
}

type AttachDiskRequestType struct {
	This          ManagedObjectReference `xml:"_this"`
	DiskId        ID                     `xml:"diskId"`
	Datastore     ManagedObjectReference `xml:"datastore"`
	ControllerKey int32                  `xml:"controllerKey,omitempty"`
	UnitNumber    *int32                 `xml:"unitNumber"`
}

func init() {
	t["AttachDiskRequestType"] = reflect.TypeOf((*AttachDiskRequestType)(nil)).Elem()
}

type AttachDisk_Task AttachDiskRequestType

func init() {
	t["AttachDisk_Task"] = reflect.TypeOf((*AttachDisk_Task)(nil)).Elem()
}

type AttachDisk_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval"`
}

type AttachScsiLun AttachScsiLunRequestType

func init() {
	t["AttachScsiLun"] = reflect.TypeOf((*AttachScsiLun)(nil)).Elem()
}

type AttachScsiLunExRequestType struct {
	This    ManagedObjectReference `xml:"_this"`
	LunUuid []string               `xml:"lunUuid"`
}

func init() {
	t["AttachScsiLunExRequestType"] = reflect.TypeOf((*AttachScsiLunExRequestType)(nil)).Elem()
}

type AttachScsiLunEx_Task AttachScsiLunExRequestType

func init() {
	t["AttachScsiLunEx_Task"] = reflect.TypeOf((*AttachScsiLunEx_Task)(nil)).Elem()
}

type AttachScsiLunEx_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval"`
}

type AttachScsiLunRequestType struct {
	This    ManagedObjectReference `xml:"_this"`
	LunUuid string                 `xml:"lunUuid"`
}

func init() {
	t["AttachScsiLunRequestType"] = reflect.TypeOf((*AttachScsiLunRequestType)(nil)).Elem()
}

type AttachScsiLunResponse struct {
}

type AttachTagToVStorageObject AttachTagToVStorageObjectRequestType

func init() {
	t["AttachTagToVStorageObject"] = reflect.TypeOf((*AttachTagToVStorageObject)(nil)).Elem()
}

type AttachTagToVStorageObjectRequestType struct {
	This     ManagedObjectReference `xml:"_this"`
	Id       ID                     `xml:"id"`
	Category string                 `xml:"category"`
	Tag      string                 `xml:"tag"`
}

func init() {
	t["AttachTagToVStorageObjectRequestType"] = reflect.TypeOf((*AttachTagToVStorageObjectRequestType)(nil)).Elem()
}

type AttachTagToVStorageObjectResponse struct {
}

type AttachVmfsExtent AttachVmfsExtentRequestType

func init() {
	t["AttachVmfsExtent"] = reflect.TypeOf((*AttachVmfsExtent)(nil)).Elem()
}

type AttachVmfsExtentRequestType struct {
	This     ManagedObjectReference `xml:"_this"`
	VmfsPath string                 `xml:"vmfsPath"`
	Extent   HostScsiDiskPartition  `xml:"extent"`
}

func init() {
	t["AttachVmfsExtentRequestType"] = reflect.TypeOf((*AttachVmfsExtentRequestType)(nil)).Elem()
}

type AttachVmfsExtentResponse struct {
}

type AuthMinimumAdminPermission struct {
	VimFault
}

func init() {
	t["AuthMinimumAdminPermission"] = reflect.TypeOf((*AuthMinimumAdminPermission)(nil)).Elem()
}

type AuthMinimumAdminPermissionFault AuthMinimumAdminPermission

func init() {
	t["AuthMinimumAdminPermissionFault"] = reflect.TypeOf((*AuthMinimumAdminPermissionFault)(nil)).Elem()
}

type AuthenticationProfile struct {
	ApplyProfile

	ActiveDirectory *ActiveDirectoryProfile `xml:"activeDirectory,omitempty"`
}

func init() {
	t["AuthenticationProfile"] = reflect.TypeOf((*AuthenticationProfile)(nil)).Elem()
}

type AuthorizationDescription struct {
	DynamicData

	Privilege      []BaseElementDescription `xml:"privilege,typeattr"`
	PrivilegeGroup []BaseElementDescription `xml:"privilegeGroup,typeattr"`
}

func init() {
	t["AuthorizationDescription"] = reflect.TypeOf((*AuthorizationDescription)(nil)).Elem()
}

type AuthorizationEvent struct {
	Event
}

func init() {
	t["AuthorizationEvent"] = reflect.TypeOf((*AuthorizationEvent)(nil)).Elem()
}

type AuthorizationPrivilege struct {
	DynamicData

	PrivId        string `xml:"privId"`
	OnParent      bool   `xml:"onParent"`
	Name          string `xml:"name"`
	PrivGroupName string `xml:"privGroupName"`
}

func init() {
	t["AuthorizationPrivilege"] = reflect.TypeOf((*AuthorizationPrivilege)(nil)).Elem()
}

type AuthorizationRole struct {
	DynamicData

	RoleId    int32           `xml:"roleId"`
	System    bool            `xml:"system"`
	Name      string          `xml:"name"`
	Info      BaseDescription `xml:"info,typeattr"`
	Privilege []string        `xml:"privilege,omitempty"`
}

func init() {
	t["AuthorizationRole"] = reflect.TypeOf((*AuthorizationRole)(nil)).Elem()
}

type AutoStartDefaults struct {
	DynamicData

	Enabled          *bool  `xml:"enabled"`
	StartDelay       int32  `xml:"startDelay,omitempty"`
	StopDelay        int32  `xml:"stopDelay,omitempty"`
	WaitForHeartbeat *bool  `xml:"waitForHeartbeat"`
	StopAction       string `xml:"stopAction,omitempty"`
}

func init() {
	t["AutoStartDefaults"] = reflect.TypeOf((*AutoStartDefaults)(nil)).Elem()
}

type AutoStartPowerInfo struct {
	DynamicData

	Key              ManagedObjectReference        `xml:"key"`
	StartOrder       int32                         `xml:"startOrder"`
	StartDelay       int32                         `xml:"startDelay"`
	WaitForHeartbeat AutoStartWaitHeartbeatSetting `xml:"waitForHeartbeat"`
	StartAction      string                        `xml:"startAction"`
	StopDelay        int32                         `xml:"stopDelay"`
	StopAction       string                        `xml:"stopAction"`
}

func init() {
	t["AutoStartPowerInfo"] = reflect.TypeOf((*AutoStartPowerInfo)(nil)).Elem()
}

type AutoStartPowerOff AutoStartPowerOffRequestType

func init() {
	t["AutoStartPowerOff"] = reflect.TypeOf((*AutoStartPowerOff)(nil)).Elem()
}

type AutoStartPowerOffRequestType struct {
	This ManagedObjectReference `xml:"_this"`
}

func init() {
	t["AutoStartPowerOffRequestType"] = reflect.TypeOf((*AutoStartPowerOffRequestType)(nil)).Elem()
}

type AutoStartPowerOffResponse struct {
}

type AutoStartPowerOn AutoStartPowerOnRequestType

func init() {
	t["AutoStartPowerOn"] = reflect.TypeOf((*AutoStartPowerOn)(nil)).Elem()
}

type AutoStartPowerOnRequestType struct {
	This ManagedObjectReference `xml:"_this"`
}

func init() {
	t["AutoStartPowerOnRequestType"] = reflect.TypeOf((*AutoStartPowerOnRequestType)(nil)).Elem()
}

type AutoStartPowerOnResponse struct {
}

type BackupBlobReadFailure struct {
	DvsFault

	EntityName string               `xml:"entityName"`
	EntityType string               `xml:"entityType"`
	Fault      LocalizedMethodFault `xml:"fault"`
}

func init() {
	t["BackupBlobReadFailure"] = reflect.TypeOf((*BackupBlobReadFailure)(nil)).Elem()
}

type BackupBlobReadFailureFault BackupBlobReadFailure

func init() {
	t["BackupBlobReadFailureFault"] = reflect.TypeOf((*BackupBlobReadFailureFault)(nil)).Elem()
}

type BackupBlobWriteFailure struct {
	DvsFault

	EntityName string               `xml:"entityName"`
	EntityType string               `xml:"entityType"`
	Fault      LocalizedMethodFault `xml:"fault"`
}

func init() {
	t["BackupBlobWriteFailure"] = reflect.TypeOf((*BackupBlobWriteFailure)(nil)).Elem()
}

type BackupBlobWriteFailureFault BackupBlobWriteFailure

func init() {
	t["BackupBlobWriteFailureFault"] = reflect.TypeOf((*BackupBlobWriteFailureFault)(nil)).Elem()
}

type BackupFirmwareConfiguration BackupFirmwareConfigurationRequestType

func init() {
	t["BackupFirmwareConfiguration"] = reflect.TypeOf((*BackupFirmwareConfiguration)(nil)).Elem()
}

type BackupFirmwareConfigurationRequestType struct {
	This ManagedObjectReference `xml:"_this"`
}

func init() {
	t["BackupFirmwareConfigurationRequestType"] = reflect.TypeOf((*BackupFirmwareConfigurationRequestType)(nil)).Elem()
}

type BackupFirmwareConfigurationResponse struct {
	Returnval string `xml:"returnval"`
}

type BadUsernameSessionEvent struct {
	SessionEvent

	IpAddress string `xml:"ipAddress"`
}

func init() {
	t["BadUsernameSessionEvent"] = reflect.TypeOf((*BadUsernameSessionEvent)(nil)).Elem()
}

type BaseConfigInfo struct {
	DynamicData

	Id                          ID                            `xml:"id"`
	Name                        string                        `xml:"name"`
	CreateTime                  time.Time                     `xml:"createTime"`
	KeepAfterDeleteVm           *bool                         `xml:"keepAfterDeleteVm"`
	RelocationDisabled          *bool                         `xml:"relocationDisabled"`
	NativeSnapshotSupported     *bool                         `xml:"nativeSnapshotSupported"`
	ChangedBlockTrackingEnabled *bool                         `xml:"changedBlockTrackingEnabled"`
	Backing                     BaseBaseConfigInfoBackingInfo `xml:"backing,typeattr"`
	Metadata                    []KeyValue                    `xml:"metadata,omitempty"`
	Vclock                      *VslmVClockInfo               `xml:"vclock,omitempty"`
	Iofilter                    []string                      `xml:"iofilter,omitempty"`
}

func init() {
	t["BaseConfigInfo"] = reflect.TypeOf((*BaseConfigInfo)(nil)).Elem()
}

type BaseConfigInfoBackingInfo struct {
	DynamicData

	Datastore ManagedObjectReference `xml:"datastore"`
}

func init() {
	t["BaseConfigInfoBackingInfo"] = reflect.TypeOf((*BaseConfigInfoBackingInfo)(nil)).Elem()
}

type BaseConfigInfoDiskFileBackingInfo struct {
	BaseConfigInfoFileBackingInfo

	ProvisioningType string `xml:"provisioningType"`
}

func init() {
	t["BaseConfigInfoDiskFileBackingInfo"] = reflect.TypeOf((*BaseConfigInfoDiskFileBackingInfo)(nil)).Elem()
}

type BaseConfigInfoFileBackingInfo struct {
	BaseConfigInfoBackingInfo

	FilePath        string                            `xml:"filePath"`
	BackingObjectId string                            `xml:"backingObjectId,omitempty"`
	Parent          BaseBaseConfigInfoFileBackingInfo `xml:"parent,omitempty,typeattr"`
	DeltaSizeInMB   int64                             `xml:"deltaSizeInMB,omitempty"`
	KeyId           *CryptoKeyId                      `xml:"keyId,omitempty"`
}

func init() {
	t["BaseConfigInfoFileBackingInfo"] = reflect.TypeOf((*BaseConfigInfoFileBackingInfo)(nil)).Elem()
}

type BaseConfigInfoRawDiskMappingBackingInfo struct {
	BaseConfigInfoFileBackingInfo

	LunUuid           string `xml:"lunUuid"`
	CompatibilityMode string `xml:"compatibilityMode"`
}

func init() {
	t["BaseConfigInfoRawDiskMappingBackingInfo"] = reflect.TypeOf((*BaseConfigInfoRawDiskMappingBackingInfo)(nil)).Elem()
}

type BatchAddHostsToClusterRequestType struct {
	This          ManagedObjectReference        `xml:"_this"`
	Cluster       ManagedObjectReference        `xml:"cluster"`
	NewHosts      []FolderNewHostSpec           `xml:"newHosts,omitempty"`
	ExistingHosts []ManagedObjectReference      `xml:"existingHosts,omitempty"`
	CompResSpec   BaseComputeResourceConfigSpec `xml:"compResSpec,omitempty,typeattr"`
	DesiredState  string                        `xml:"desiredState,omitempty"`
}

func init() {
	t["BatchAddHostsToClusterRequestType"] = reflect.TypeOf((*BatchAddHostsToClusterRequestType)(nil)).Elem()
}

type BatchAddHostsToCluster_Task BatchAddHostsToClusterRequestType

func init() {
	t["BatchAddHostsToCluster_Task"] = reflect.TypeOf((*BatchAddHostsToCluster_Task)(nil)).Elem()
}

type BatchAddHostsToCluster_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval"`
}

type BatchAddStandaloneHostsRequestType struct {
	This         ManagedObjectReference        `xml:"_this"`
	NewHosts     []FolderNewHostSpec           `xml:"newHosts,omitempty"`
	CompResSpec  BaseComputeResourceConfigSpec `xml:"compResSpec,omitempty,typeattr"`
	AddConnected bool                          `xml:"addConnected"`
}

func init() {
	t["BatchAddStandaloneHostsRequestType"] = reflect.TypeOf((*BatchAddStandaloneHostsRequestType)(nil)).Elem()
}

type BatchAddStandaloneHosts_Task BatchAddStandaloneHostsRequestType

func init() {
	t["BatchAddStandaloneHosts_Task"] = reflect.TypeOf((*BatchAddStandaloneHosts_Task)(nil)).Elem()
}

type BatchAddStandaloneHosts_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval"`
}

type BatchQueryConnectInfo BatchQueryConnectInfoRequestType

func init() {
	t["BatchQueryConnectInfo"] = reflect.TypeOf((*BatchQueryConnectInfo)(nil)).Elem()
}

type BatchQueryConnectInfoRequestType struct {
	This      ManagedObjectReference `xml:"_this"`
	HostSpecs []HostConnectSpec      `xml:"hostSpecs,omitempty"`
}

func init() {
	t["BatchQueryConnectInfoRequestType"] = reflect.TypeOf((*BatchQueryConnectInfoRequestType)(nil)).Elem()
}

type BatchQueryConnectInfoResponse struct {
	Returnval []DatacenterBasicConnectInfo `xml:"returnval,omitempty"`
}

type BatchResult struct {
	DynamicData

	Result  string                  `xml:"result"`
	HostKey string                  `xml:"hostKey"`
	Ds      *ManagedObjectReference `xml:"ds,omitempty"`
	Fault   *LocalizedMethodFault   `xml:"fault,omitempty"`
}

func init() {
	t["BatchResult"] = reflect.TypeOf((*BatchResult)(nil)).Elem()
}

type BindVnic BindVnicRequestType

func init() {
	t["BindVnic"] = reflect.TypeOf((*BindVnic)(nil)).Elem()
}

type BindVnicRequestType struct {
	This         ManagedObjectReference `xml:"_this"`
	IScsiHbaName string                 `xml:"iScsiHbaName"`
	VnicDevice   string                 `xml:"vnicDevice"`
}

func init() {
	t["BindVnicRequestType"] = reflect.TypeOf((*BindVnicRequestType)(nil)).Elem()
}

type BindVnicResponse struct {
}

type BlockedByFirewall struct {
	HostConfigFault
}

func init() {
	t["BlockedByFirewall"] = reflect.TypeOf((*BlockedByFirewall)(nil)).Elem()
}

type BlockedByFirewallFault BlockedByFirewall

func init() {
	t["BlockedByFirewallFault"] = reflect.TypeOf((*BlockedByFirewallFault)(nil)).Elem()
}

type BoolOption struct {
	OptionType

	Supported    bool `xml:"supported"`
	DefaultValue bool `xml:"defaultValue"`
}

func init() {
	t["BoolOption"] = reflect.TypeOf((*BoolOption)(nil)).Elem()
}

type BoolPolicy struct {
	InheritablePolicy

	Value *bool `xml:"value"`
}

func init() {
	t["BoolPolicy"] = reflect.TypeOf((*BoolPolicy)(nil)).Elem()
}

type BrowseDiagnosticLog BrowseDiagnosticLogRequestType

func init() {
	t["BrowseDiagnosticLog"] = reflect.TypeOf((*BrowseDiagnosticLog)(nil)).Elem()
}

type BrowseDiagnosticLogRequestType struct {
	This  ManagedObjectReference  `xml:"_this"`
	Host  *ManagedObjectReference `xml:"host,omitempty"`
	Key   string                  `xml:"key"`
	Start int32                   `xml:"start,omitempty"`
	Lines int32                   `xml:"lines,omitempty"`
}

func init() {
	t["BrowseDiagnosticLogRequestType"] = reflect.TypeOf((*BrowseDiagnosticLogRequestType)(nil)).Elem()
}

type BrowseDiagnosticLogResponse struct {
	Returnval DiagnosticManagerLogHeader `xml:"returnval"`
}

type CAMServerRefusedConnection struct {
	InvalidCAMServer
}

func init() {
	t["CAMServerRefusedConnection"] = reflect.TypeOf((*CAMServerRefusedConnection)(nil)).Elem()
}

type CAMServerRefusedConnectionFault CAMServerRefusedConnection

func init() {
	t["CAMServerRefusedConnectionFault"] = reflect.TypeOf((*CAMServerRefusedConnectionFault)(nil)).Elem()
}

type CanProvisionObjects CanProvisionObjectsRequestType

func init() {
	t["CanProvisionObjects"] = reflect.TypeOf((*CanProvisionObjects)(nil)).Elem()
}

type CanProvisionObjectsRequestType struct {
	This                 ManagedObjectReference `xml:"_this"`
	Npbs                 []VsanNewPolicyBatch   `xml:"npbs"`
	IgnoreSatisfiability *bool                  `xml:"ignoreSatisfiability"`
}

func init() {
	t["CanProvisionObjectsRequestType"] = reflect.TypeOf((*CanProvisionObjectsRequestType)(nil)).Elem()
}

type CanProvisionObjectsResponse struct {
	Returnval []VsanPolicySatisfiability `xml:"returnval"`
}

type CancelRecommendation CancelRecommendationRequestType

func init() {
	t["CancelRecommendation"] = reflect.TypeOf((*CancelRecommendation)(nil)).Elem()
}

type CancelRecommendationRequestType struct {
	This ManagedObjectReference `xml:"_this"`
	Key  string                 `xml:"key"`
}

func init() {
	t["CancelRecommendationRequestType"] = reflect.TypeOf((*CancelRecommendationRequestType)(nil)).Elem()
}

type CancelRecommendationResponse struct {
}

type CancelRetrievePropertiesEx CancelRetrievePropertiesExRequestType

func init() {
	t["CancelRetrievePropertiesEx"] = reflect.TypeOf((*CancelRetrievePropertiesEx)(nil)).Elem()
}

type CancelRetrievePropertiesExRequestType struct {
	This  ManagedObjectReference `xml:"_this"`
	Token string                 `xml:"token"`
}

func init() {
	t["CancelRetrievePropertiesExRequestType"] = reflect.TypeOf((*CancelRetrievePropertiesExRequestType)(nil)).Elem()
}

type CancelRetrievePropertiesExResponse struct {
}

type CancelStorageDrsRecommendation CancelStorageDrsRecommendationRequestType

func init() {
	t["CancelStorageDrsRecommendation"] = reflect.TypeOf((*CancelStorageDrsRecommendation)(nil)).Elem()
}

type CancelStorageDrsRecommendationRequestType struct {
	This ManagedObjectReference `xml:"_this"`
	Key  []string               `xml:"key"`
}

func init() {
	t["CancelStorageDrsRecommendationRequestType"] = reflect.TypeOf((*CancelStorageDrsRecommendationRequestType)(nil)).Elem()
}

type CancelStorageDrsRecommendationResponse struct {
}

type CancelTask CancelTaskRequestType

func init() {
	t["CancelTask"] = reflect.TypeOf((*CancelTask)(nil)).Elem()
}

type CancelTaskRequestType struct {
	This ManagedObjectReference `xml:"_this"`
}

func init() {
	t["CancelTaskRequestType"] = reflect.TypeOf((*CancelTaskRequestType)(nil)).Elem()
}

type CancelTaskResponse struct {
}

type CancelWaitForUpdates CancelWaitForUpdatesRequestType

func init() {
	t["CancelWaitForUpdates"] = reflect.TypeOf((*CancelWaitForUpdates)(nil)).Elem()
}

type CancelWaitForUpdatesRequestType struct {
	This ManagedObjectReference `xml:"_this"`
}

func init() {
	t["CancelWaitForUpdatesRequestType"] = reflect.TypeOf((*CancelWaitForUpdatesRequestType)(nil)).Elem()
}

type CancelWaitForUpdatesResponse struct {
}

type CanceledHostOperationEvent struct {
	HostEvent
}

func init() {
	t["CanceledHostOperationEvent"] = reflect.TypeOf((*CanceledHostOperationEvent)(nil)).Elem()
}

type CannotAccessFile struct {
	FileFault
}

func init() {
	t["CannotAccessFile"] = reflect.TypeOf((*CannotAccessFile)(nil)).Elem()
}

type CannotAccessFileFault CannotAccessFile

func init() {
	t["CannotAccessFileFault"] = reflect.TypeOf((*CannotAccessFileFault)(nil)).Elem()
}

type CannotAccessLocalSource struct {
	VimFault
}

func init() {
	t["CannotAccessLocalSource"] = reflect.TypeOf((*CannotAccessLocalSource)(nil)).Elem()
}

type CannotAccessLocalSourceFault CannotAccessLocalSource

func init() {
	t["CannotAccessLocalSourceFault"] = reflect.TypeOf((*CannotAccessLocalSourceFault)(nil)).Elem()
}

type CannotAccessNetwork struct {
	CannotAccessVmDevice

	Network *ManagedObjectReference `xml:"network,omitempty"`
}

func init() {
	t["CannotAccessNetwork"] = reflect.TypeOf((*CannotAccessNetwork)(nil)).Elem()
}

type CannotAccessNetworkFault BaseCannotAccessNetwork

func init() {
	t["CannotAccessNetworkFault"] = reflect.TypeOf((*CannotAccessNetworkFault)(nil)).Elem()
}

type CannotAccessVmComponent struct {
	VmConfigFault
}

func init() {
	t["CannotAccessVmComponent"] = reflect.TypeOf((*CannotAccessVmComponent)(nil)).Elem()
}

type CannotAccessVmComponentFault BaseCannotAccessVmComponent

func init() {
	t["CannotAccessVmComponentFault"] = reflect.TypeOf((*CannotAccessVmComponentFault)(nil)).Elem()
}

type CannotAccessVmConfig struct {
	CannotAccessVmComponent

	Reason LocalizedMethodFault `xml:"reason"`
}

func init() {
	t["CannotAccessVmConfig"] = reflect.TypeOf((*CannotAccessVmConfig)(nil)).Elem()
}

type CannotAccessVmConfigFault CannotAccessVmConfig

func init() {
	t["CannotAccessVmConfigFault"] = reflect.TypeOf((*CannotAccessVmConfigFault)(nil)).Elem()
}

type CannotAccessVmDevice struct {
	CannotAccessVmComponent

	Device    string `xml:"device"`
	Backing   string `xml:"backing"`
	Connected bool   `xml:"connected"`
}

func init() {
	t["CannotAccessVmDevice"] = reflect.TypeOf((*CannotAccessVmDevice)(nil)).Elem()
}

type CannotAccessVmDeviceFault BaseCannotAccessVmDevice

func init() {
	t["CannotAccessVmDeviceFault"] = reflect.TypeOf((*CannotAccessVmDeviceFault)(nil)).Elem()
}

type CannotAccessVmDisk struct {
	CannotAccessVmDevice

	Fault LocalizedMethodFault `xml:"fault"`
}

func init() {
	t["CannotAccessVmDisk"] = reflect.TypeOf((*CannotAccessVmDisk)(nil)).Elem()
}

type CannotAccessVmDiskFault BaseCannotAccessVmDisk

func init() {
	t["CannotAccessVmDiskFault"] = reflect.TypeOf((*CannotAccessVmDiskFault)(nil)).Elem()
}

type CannotAddHostWithFTVmAsStandalone struct {
	HostConnectFault
}

func init() {
	t["CannotAddHostWithFTVmAsStandalone"] = reflect.TypeOf((*CannotAddHostWithFTVmAsStandalone)(nil)).Elem()
}

type CannotAddHostWithFTVmAsStandaloneFault CannotAddHostWithFTVmAsStandalone

func init() {
	t["CannotAddHostWithFTVmAsStandaloneFault"] = reflect.TypeOf((*CannotAddHostWithFTVmAsStandaloneFault)(nil)).Elem()
}

type CannotAddHostWithFTVmToDifferentCluster struct {
	HostConnectFault
}

func init() {
	t["CannotAddHostWithFTVmToDifferentCluster"] = reflect.TypeOf((*CannotAddHostWithFTVmToDifferentCluster)(nil)).Elem()
}

type CannotAddHostWithFTVmToDifferentClusterFault CannotAddHostWithFTVmToDifferentCluster

func init() {
	t["CannotAddHostWithFTVmToDifferentClusterFault"] = reflect.TypeOf((*CannotAddHostWithFTVmToDifferentClusterFault)(nil)).Elem()
}

type CannotAddHostWithFTVmToNonHACluster struct {
	HostConnectFault
}

func init() {
	t["CannotAddHostWithFTVmToNonHACluster"] = reflect.TypeOf((*CannotAddHostWithFTVmToNonHACluster)(nil)).Elem()
}

type CannotAddHostWithFTVmToNonHAClusterFault CannotAddHostWithFTVmToNonHACluster

func init() {
	t["CannotAddHostWithFTVmToNonHAClusterFault"] = reflect.TypeOf((*CannotAddHostWithFTVmToNonHAClusterFault)(nil)).Elem()
}

type CannotChangeDrsBehaviorForFtSecondary struct {
	VmFaultToleranceIssue

	Vm     ManagedObjectReference `xml:"vm"`
	VmName string                 `xml:"vmName"`
}

func init() {
	t["CannotChangeDrsBehaviorForFtSecondary"] = reflect.TypeOf((*CannotChangeDrsBehaviorForFtSecondary)(nil)).Elem()
}

type CannotChangeDrsBehaviorForFtSecondaryFault CannotChangeDrsBehaviorForFtSecondary

func init() {
	t["CannotChangeDrsBehaviorForFtSecondaryFault"] = reflect.TypeOf((*CannotChangeDrsBehaviorForFtSecondaryFault)(nil)).Elem()
}

type CannotChangeHaSettingsForFtSecondary struct {
	VmFaultToleranceIssue

	Vm     ManagedObjectReference `xml:"vm"`
	VmName string                 `xml:"vmName"`
}

func init() {
	t["CannotChangeHaSettingsForFtSecondary"] = reflect.TypeOf((*CannotChangeHaSettingsForFtSecondary)(nil)).Elem()
}

type CannotChangeHaSettingsForFtSecondaryFault CannotChangeHaSettingsForFtSecondary

func init() {
	t["CannotChangeHaSettingsForFtSecondaryFault"] = reflect.TypeOf((*CannotChangeHaSettingsForFtSecondaryFault)(nil)).Elem()
}

type CannotChangeVsanClusterUuid struct {
	VsanFault
}

func init() {
	t["CannotChangeVsanClusterUuid"] = reflect.TypeOf((*CannotChangeVsanClusterUuid)(nil)).Elem()
}

type CannotChangeVsanClusterUuidFault CannotChangeVsanClusterUuid

func init() {
	t["CannotChangeVsanClusterUuidFault"] = reflect.TypeOf((*CannotChangeVsanClusterUuidFault)(nil)).Elem()
}

type CannotChangeVsanNodeUuid struct {
	VsanFault
}

func init() {
	t["CannotChangeVsanNodeUuid"] = reflect.TypeOf((*CannotChangeVsanNodeUuid)(nil)).Elem()
}

type CannotChangeVsanNodeUuidFault CannotChangeVsanNodeUuid

func init() {
	t["CannotChangeVsanNodeUuidFault"] = reflect.TypeOf((*CannotChangeVsanNodeUuidFault)(nil)).Elem()
}

type CannotComputeFTCompatibleHosts struct {
	VmFaultToleranceIssue

	Vm     ManagedObjectReference `xml:"vm"`
	VmName string                 `xml:"vmName"`
}

func init() {
	t["CannotComputeFTCompatibleHosts"] = reflect.TypeOf((*CannotComputeFTCompatibleHosts)(nil)).Elem()
}

type CannotComputeFTCompatibleHostsFault CannotComputeFTCompatibleHosts

func init() {
	t["CannotComputeFTCompatibleHostsFault"] = reflect.TypeOf((*CannotComputeFTCompatibleHostsFault)(nil)).Elem()
}

type CannotCreateFile struct {
	FileFault
}

func init() {
	t["CannotCreateFile"] = reflect.TypeOf((*CannotCreateFile)(nil)).Elem()
}

type CannotCreateFileFault CannotCreateFile

func init() {
	t["CannotCreateFileFault"] = reflect.TypeOf((*CannotCreateFileFault)(nil)).Elem()
}

type CannotDecryptPasswords struct {
	CustomizationFault
}

func init() {
	t["CannotDecryptPasswords"] = reflect.TypeOf((*CannotDecryptPasswords)(nil)).Elem()
}

type CannotDecryptPasswordsFault CannotDecryptPasswords

func init() {
	t["CannotDecryptPasswordsFault"] = reflect.TypeOf((*CannotDecryptPasswordsFault)(nil)).Elem()
}

type CannotDeleteFile struct {
	FileFault
}

func init() {
	t["CannotDeleteFile"] = reflect.TypeOf((*CannotDeleteFile)(nil)).Elem()
}

type CannotDeleteFileFault CannotDeleteFile

func init() {
	t["CannotDeleteFileFault"] = reflect.TypeOf((*CannotDeleteFileFault)(nil)).Elem()
}

type CannotDisableDrsOnClustersWithVApps struct {
	RuntimeFault
}

func init() {
	t["CannotDisableDrsOnClustersWithVApps"] = reflect.TypeOf((*CannotDisableDrsOnClustersWithVApps)(nil)).Elem()
}

type CannotDisableDrsOnClustersWithVAppsFault CannotDisableDrsOnClustersWithVApps

func init() {
	t["CannotDisableDrsOnClustersWithVAppsFault"] = reflect.TypeOf((*CannotDisableDrsOnClustersWithVAppsFault)(nil)).Elem()
}

type CannotDisableSnapshot struct {
	VmConfigFault
}

func init() {
	t["CannotDisableSnapshot"] = reflect.TypeOf((*CannotDisableSnapshot)(nil)).Elem()
}

type CannotDisableSnapshotFault CannotDisableSnapshot

func init() {
	t["CannotDisableSnapshotFault"] = reflect.TypeOf((*CannotDisableSnapshotFault)(nil)).Elem()
}

type CannotDisconnectHostWithFaultToleranceVm struct {
	VimFault

	HostName string `xml:"hostName"`
}

func init() {
	t["CannotDisconnectHostWithFaultToleranceVm"] = reflect.TypeOf((*CannotDisconnectHostWithFaultToleranceVm)(nil)).Elem()
}

type CannotDisconnectHostWithFaultToleranceVmFault CannotDisconnectHostWithFaultToleranceVm

func init() {
	t["CannotDisconnectHostWithFaultToleranceVmFault"] = reflect.TypeOf((*CannotDisconnectHostWithFaultToleranceVmFault)(nil)).Elem()
}

type CannotEnableVmcpForCluster struct {
	VimFault

	Host     *ManagedObjectReference `xml:"host,omitempty"`
	HostName string                  `xml:"hostName,omitempty"`
	Reason   string                  `xml:"reason,omitempty"`
}

func init() {
	t["CannotEnableVmcpForCluster"] = reflect.TypeOf((*CannotEnableVmcpForCluster)(nil)).Elem()
}

type CannotEnableVmcpForClusterFault CannotEnableVmcpForCluster

func init() {
	t["CannotEnableVmcpForClusterFault"] = reflect.TypeOf((*CannotEnableVmcpForClusterFault)(nil)).Elem()
}

type CannotModifyConfigCpuRequirements struct {
	MigrationFault
}

func init() {
	t["CannotModifyConfigCpuRequirements"] = reflect.TypeOf((*CannotModifyConfigCpuRequirements)(nil)).Elem()
}

type CannotModifyConfigCpuRequirementsFault CannotModifyConfigCpuRequirements

func init() {
	t["CannotModifyConfigCpuRequirementsFault"] = reflect.TypeOf((*CannotModifyConfigCpuRequirementsFault)(nil)).Elem()
}

type CannotMoveFaultToleranceVm struct {
	VimFault

	MoveType string `xml:"moveType"`
	VmName   string `xml:"vmName"`
}

func init() {
	t["CannotMoveFaultToleranceVm"] = reflect.TypeOf((*CannotMoveFaultToleranceVm)(nil)).Elem()
}

type CannotMoveFaultToleranceVmFault CannotMoveFaultToleranceVm

func init() {
	t["CannotMoveFaultToleranceVmFault"] = reflect.TypeOf((*CannotMoveFaultToleranceVmFault)(nil)).Elem()
}

type CannotMoveHostWithFaultToleranceVm struct {
	VimFault
}

func init() {
	t["CannotMoveHostWithFaultToleranceVm"] = reflect.TypeOf((*CannotMoveHostWithFaultToleranceVm)(nil)).Elem()
}

type CannotMoveHostWithFaultToleranceVmFault CannotMoveHostWithFaultToleranceVm

func init() {
	t["CannotMoveHostWithFaultToleranceVmFault"] = reflect.TypeOf((*CannotMoveHostWithFaultToleranceVmFault)(nil)).Elem()
}

type CannotMoveVmWithDeltaDisk struct {
	MigrationFault

	Device string `xml:"device"`
}

func init() {
	t["CannotMoveVmWithDeltaDisk"] = reflect.TypeOf((*CannotMoveVmWithDeltaDisk)(nil)).Elem()
}

type CannotMoveVmWithDeltaDiskFault CannotMoveVmWithDeltaDisk

func init() {
	t["CannotMoveVmWithDeltaDiskFault"] = reflect.TypeOf((*CannotMoveVmWithDeltaDiskFault)(nil)).Elem()
}

type CannotMoveVmWithNativeDeltaDisk struct {
	MigrationFault
}

func init() {
	t["CannotMoveVmWithNativeDeltaDisk"] = reflect.TypeOf((*CannotMoveVmWithNativeDeltaDisk)(nil)).Elem()
}

type CannotMoveVmWithNativeDeltaDiskFault CannotMoveVmWithNativeDeltaDisk

func init() {
	t["CannotMoveVmWithNativeDeltaDiskFault"] = reflect.TypeOf((*CannotMoveVmWithNativeDeltaDiskFault)(nil)).Elem()
}

type CannotMoveVsanEnabledHost struct {
	VsanFault
}

func init() {
	t["CannotMoveVsanEnabledHost"] = reflect.TypeOf((*CannotMoveVsanEnabledHost)(nil)).Elem()
}

type CannotMoveVsanEnabledHostFault BaseCannotMoveVsanEnabledHost

func init() {
	t["CannotMoveVsanEnabledHostFault"] = reflect.TypeOf((*CannotMoveVsanEnabledHostFault)(nil)).Elem()
}

type CannotPlaceWithoutPrerequisiteMoves struct {
	VimFault
}

func init() {
	t["CannotPlaceWithoutPrerequisiteMoves"] = reflect.TypeOf((*CannotPlaceWithoutPrerequisiteMoves)(nil)).Elem()
}

type CannotPlaceWithoutPrerequisiteMovesFault CannotPlaceWithoutPrerequisiteMoves

func init() {
	t["CannotPlaceWithoutPrerequisiteMovesFault"] = reflect.TypeOf((*CannotPlaceWithoutPrerequisiteMovesFault)(nil)).Elem()
}

type CannotPowerOffVmInCluster struct {
	InvalidState

	Operation string                 `xml:"operation"`
	Vm        ManagedObjectReference `xml:"vm"`
	VmName    string                 `xml:"vmName"`
}

func init() {
	t["CannotPowerOffVmInCluster"] = reflect.TypeOf((*CannotPowerOffVmInCluster)(nil)).Elem()
}

type CannotPowerOffVmInClusterFault CannotPowerOffVmInCluster

func init() {
	t["CannotPowerOffVmInClusterFault"] = reflect.TypeOf((*CannotPowerOffVmInClusterFault)(nil)).Elem()
}

type CannotReconfigureVsanWhenHaEnabled struct {
	VsanFault
}

func init() {
	t["CannotReconfigureVsanWhenHaEnabled"] = reflect.TypeOf((*CannotReconfigureVsanWhenHaEnabled)(nil)).Elem()
}

type CannotReconfigureVsanWhenHaEnabledFault CannotReconfigureVsanWhenHaEnabled

func init() {
	t["CannotReconfigureVsanWhenHaEnabledFault"] = reflect.TypeOf((*CannotReconfigureVsanWhenHaEnabledFault)(nil)).Elem()
}

type CannotUseNetwork struct {
	VmConfigFault

	Device    string                  `xml:"device"`
	Backing   string                  `xml:"backing"`
	Connected bool                    `xml:"connected"`
	Reason    string                  `xml:"reason"`
	Network   *ManagedObjectReference `xml:"network,omitempty"`
}

func init() {
	t["CannotUseNetwork"] = reflect.TypeOf((*CannotUseNetwork)(nil)).Elem()
}

type CannotUseNetworkFault CannotUseNetwork

func init() {
	t["CannotUseNetworkFault"] = reflect.TypeOf((*CannotUseNetworkFault)(nil)).Elem()
}

type Capability struct {
	DynamicData

	ProvisioningSupported            bool             `xml:"provisioningSupported"`
	MultiHostSupported               bool             `xml:"multiHostSupported"`
	UserShellAccessSupported         bool             `xml:"userShellAccessSupported"`
	SupportedEVCMode                 []EVCMode        `xml:"supportedEVCMode,omitempty"`
	SupportedEVCGraphicsMode         []FeatureEVCMode `xml:"supportedEVCGraphicsMode,omitempty"`
	NetworkBackupAndRestoreSupported *bool            `xml:"networkBackupAndRestoreSupported"`
	FtDrsWithoutEvcSupported         *bool            `xml:"ftDrsWithoutEvcSupported"`
	HciWorkflowSupported             *bool            `xml:"hciWorkflowSupported"`
	ComputePolicyVersion             int32            `xml:"computePolicyVersion,omitempty"`
	ClusterPlacementSupported        *bool            `xml:"clusterPlacementSupported"`
	LifecycleManagementSupported     *bool            `xml:"lifecycleManagementSupported"`
	HostSeedingSupported             *bool            `xml:"hostSeedingSupported"`
	ScalableSharesSupported          *bool            `xml:"scalableSharesSupported"`
	HadcsSupported                   *bool            `xml:"hadcsSupported"`
}

func init() {
	t["Capability"] = reflect.TypeOf((*Capability)(nil)).Elem()
}

type CertMgrRefreshCACertificatesAndCRLsRequestType struct {
	This ManagedObjectReference   `xml:"_this"`
	Host []ManagedObjectReference `xml:"host"`
}

func init() {
	t["CertMgrRefreshCACertificatesAndCRLsRequestType"] = reflect.TypeOf((*CertMgrRefreshCACertificatesAndCRLsRequestType)(nil)).Elem()
}

type CertMgrRefreshCACertificatesAndCRLs_Task CertMgrRefreshCACertificatesAndCRLsRequestType

func init() {
	t["CertMgrRefreshCACertificatesAndCRLs_Task"] = reflect.TypeOf((*CertMgrRefreshCACertificatesAndCRLs_Task)(nil)).Elem()
}

type CertMgrRefreshCACertificatesAndCRLs_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval"`
}

type CertMgrRefreshCertificatesRequestType struct {
	This ManagedObjectReference   `xml:"_this"`
	Host []ManagedObjectReference `xml:"host"`
}

func init() {
	t["CertMgrRefreshCertificatesRequestType"] = reflect.TypeOf((*CertMgrRefreshCertificatesRequestType)(nil)).Elem()
}

type CertMgrRefreshCertificates_Task CertMgrRefreshCertificatesRequestType

func init() {
	t["CertMgrRefreshCertificates_Task"] = reflect.TypeOf((*CertMgrRefreshCertificates_Task)(nil)).Elem()
}

type CertMgrRefreshCertificates_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval"`
}

type CertMgrRevokeCertificatesRequestType struct {
	This ManagedObjectReference   `xml:"_this"`
	Host []ManagedObjectReference `xml:"host"`
}

func init() {
	t["CertMgrRevokeCertificatesRequestType"] = reflect.TypeOf((*CertMgrRevokeCertificatesRequestType)(nil)).Elem()
}

type CertMgrRevokeCertificates_Task CertMgrRevokeCertificatesRequestType

func init() {
	t["CertMgrRevokeCertificates_Task"] = reflect.TypeOf((*CertMgrRevokeCertificates_Task)(nil)).Elem()
}

type CertMgrRevokeCertificates_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval"`
}

type ChangeAccessMode ChangeAccessModeRequestType

func init() {
	t["ChangeAccessMode"] = reflect.TypeOf((*ChangeAccessMode)(nil)).Elem()
}

type ChangeAccessModeRequestType struct {
	This       ManagedObjectReference `xml:"_this"`
	Principal  string                 `xml:"principal"`
	IsGroup    bool                   `xml:"isGroup"`
	AccessMode HostAccessMode         `xml:"accessMode"`
}

func init() {
	t["ChangeAccessModeRequestType"] = reflect.TypeOf((*ChangeAccessModeRequestType)(nil)).Elem()
}

type ChangeAccessModeResponse struct {
}

type ChangeFileAttributesInGuest ChangeFileAttributesInGuestRequestType

func init() {
	t["ChangeFileAttributesInGuest"] = reflect.TypeOf((*ChangeFileAttributesInGuest)(nil)).Elem()
}

type ChangeFileAttributesInGuestRequestType struct {
	This           ManagedObjectReference  `xml:"_this"`
	Vm             ManagedObjectReference  `xml:"vm"`
	Auth           BaseGuestAuthentication `xml:"auth,typeattr"`
	GuestFilePath  string                  `xml:"guestFilePath"`
	FileAttributes BaseGuestFileAttributes `xml:"fileAttributes,typeattr"`
}

func init() {
	t["ChangeFileAttributesInGuestRequestType"] = reflect.TypeOf((*ChangeFileAttributesInGuestRequestType)(nil)).Elem()
}

type ChangeFileAttributesInGuestResponse struct {
}

type ChangeKeyRequestType struct {
	This   ManagedObjectReference `xml:"_this"`
	NewKey CryptoKeyPlain         `xml:"newKey"`
}

func init() {
	t["ChangeKeyRequestType"] = reflect.TypeOf((*ChangeKeyRequestType)(nil)).Elem()
}

type ChangeKey_Task ChangeKeyRequestType

func init() {
	t["ChangeKey_Task"] = reflect.TypeOf((*ChangeKey_Task)(nil)).Elem()
}

type ChangeKey_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval"`
}

type ChangeLockdownMode ChangeLockdownModeRequestType

func init() {
	t["ChangeLockdownMode"] = reflect.TypeOf((*ChangeLockdownMode)(nil)).Elem()
}

type ChangeLockdownModeRequestType struct {
	This ManagedObjectReference `xml:"_this"`
	Mode HostLockdownMode       `xml:"mode"`
}

func init() {
	t["ChangeLockdownModeRequestType"] = reflect.TypeOf((*ChangeLockdownModeRequestType)(nil)).Elem()
}

type ChangeLockdownModeResponse struct {
}

type ChangeNFSUserPassword ChangeNFSUserPasswordRequestType

func init() {
	t["ChangeNFSUserPassword"] = reflect.TypeOf((*ChangeNFSUserPassword)(nil)).Elem()
}

type ChangeNFSUserPasswordRequestType struct {
	This     ManagedObjectReference `xml:"_this"`
	Password string                 `xml:"password"`
}

func init() {
	t["ChangeNFSUserPasswordRequestType"] = reflect.TypeOf((*ChangeNFSUserPasswordRequestType)(nil)).Elem()
}

type ChangeNFSUserPasswordResponse struct {
}

type ChangeOwner ChangeOwnerRequestType

func init() {
	t["ChangeOwner"] = reflect.TypeOf((*ChangeOwner)(nil)).Elem()
}

type ChangeOwnerRequestType struct {
	This       ManagedObjectReference  `xml:"_this"`
	Name       string                  `xml:"name"`
	Datacenter *ManagedObjectReference `xml:"datacenter,omitempty"`
	Owner      string                  `xml:"owner"`
}

func init() {
	t["ChangeOwnerRequestType"] = reflect.TypeOf((*ChangeOwnerRequestType)(nil)).Elem()
}

type ChangeOwnerResponse struct {
}

type ChangePassword ChangePasswordRequestType

func init() {
	t["ChangePassword"] = reflect.TypeOf((*ChangePassword)(nil)).Elem()
}

type ChangePasswordRequestType struct {
	This        ManagedObjectReference `xml:"_this"`
	User        string                 `xml:"user"`
	OldPassword string                 `xml:"oldPassword"`
	NewPassword string                 `xml:"newPassword"`
}

func init() {
	t["ChangePasswordRequestType"] = reflect.TypeOf((*ChangePasswordRequestType)(nil)).Elem()
}

type ChangePasswordResponse struct {
}

type ChangesInfoEventArgument struct {
	DynamicData

	Modified string `xml:"modified,omitempty"`
	Added    string `xml:"added,omitempty"`
	Deleted  string `xml:"deleted,omitempty"`
}

func init() {
	t["ChangesInfoEventArgument"] = reflect.TypeOf((*ChangesInfoEventArgument)(nil)).Elem()
}

type CheckAddHostEvcRequestType struct {
	This    ManagedObjectReference `xml:"_this"`
	CnxSpec HostConnectSpec        `xml:"cnxSpec"`
}

func init() {
	t["CheckAddHostEvcRequestType"] = reflect.TypeOf((*CheckAddHostEvcRequestType)(nil)).Elem()
}

type CheckAddHostEvc_Task CheckAddHostEvcRequestType

func init() {
	t["CheckAddHostEvc_Task"] = reflect.TypeOf((*CheckAddHostEvc_Task)(nil)).Elem()
}

type CheckAddHostEvc_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval"`
}

type CheckAnswerFileStatusRequestType struct {
	This ManagedObjectReference   `xml:"_this"`
	Host []ManagedObjectReference `xml:"host"`
}

func init() {
	t["CheckAnswerFileStatusRequestType"] = reflect.TypeOf((*CheckAnswerFileStatusRequestType)(nil)).Elem()
}

type CheckAnswerFileStatus_Task CheckAnswerFileStatusRequestType

func init() {
	t["CheckAnswerFileStatus_Task"] = reflect.TypeOf((*CheckAnswerFileStatus_Task)(nil)).Elem()
}

type CheckAnswerFileStatus_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval"`
}

type CheckCloneRequestType struct {
	This     ManagedObjectReference  `xml:"_this"`
	Vm       ManagedObjectReference  `xml:"vm"`
	Folder   ManagedObjectReference  `xml:"folder"`
	Name     string                  `xml:"name"`
	Spec     VirtualMachineCloneSpec `xml:"spec"`
	TestType []string                `xml:"testType,omitempty"`
}

func init() {
	t["CheckCloneRequestType"] = reflect.TypeOf((*CheckCloneRequestType)(nil)).Elem()
}

type CheckClone_Task CheckCloneRequestType

func init() {
	t["CheckClone_Task"] = reflect.TypeOf((*CheckClone_Task)(nil)).Elem()
}

type CheckClone_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval"`
}

type CheckCompatibilityRequestType struct {
	This     ManagedObjectReference  `xml:"_this"`
	Vm       ManagedObjectReference  `xml:"vm"`
	Host     *ManagedObjectReference `xml:"host,omitempty"`
	Pool     *ManagedObjectReference `xml:"pool,omitempty"`
	TestType []string                `xml:"testType,omitempty"`
}

func init() {
	t["CheckCompatibilityRequestType"] = reflect.TypeOf((*CheckCompatibilityRequestType)(nil)).Elem()
}

type CheckCompatibility_Task CheckCompatibilityRequestType

func init() {
	t["CheckCompatibility_Task"] = reflect.TypeOf((*CheckCompatibility_Task)(nil)).Elem()
}

type CheckCompatibility_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval"`
}

type CheckComplianceRequestType struct {
	This    ManagedObjectReference   `xml:"_this"`
	Profile []ManagedObjectReference `xml:"profile,omitempty"`
	Entity  []ManagedObjectReference `xml:"entity,omitempty"`
}

func init() {
	t["CheckComplianceRequestType"] = reflect.TypeOf((*CheckComplianceRequestType)(nil)).Elem()
}

type CheckCompliance_Task CheckComplianceRequestType

func init() {
	t["CheckCompliance_Task"] = reflect.TypeOf((*CheckCompliance_Task)(nil)).Elem()
}

type CheckCompliance_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval"`
}

type CheckConfigureEvcModeRequestType struct {
	This               ManagedObjectReference `xml:"_this"`
	EvcModeKey         string                 `xml:"evcModeKey"`
	EvcGraphicsModeKey string                 `xml:"evcGraphicsModeKey,omitempty"`
}

func init() {
	t["CheckConfigureEvcModeRequestType"] = reflect.TypeOf((*CheckConfigureEvcModeRequestType)(nil)).Elem()
}

type CheckConfigureEvcMode_Task CheckConfigureEvcModeRequestType

func init() {
	t["CheckConfigureEvcMode_Task"] = reflect.TypeOf((*CheckConfigureEvcMode_Task)(nil)).Elem()
}

type CheckConfigureEvcMode_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval"`
}

type CheckCustomizationResources CheckCustomizationResourcesRequestType

func init() {
	t["CheckCustomizationResources"] = reflect.TypeOf((*CheckCustomizationResources)(nil)).Elem()
}

type CheckCustomizationResourcesRequestType struct {
	This    ManagedObjectReference `xml:"_this"`
	GuestOs string                 `xml:"guestOs"`
}

func init() {
	t["CheckCustomizationResourcesRequestType"] = reflect.TypeOf((*CheckCustomizationResourcesRequestType)(nil)).Elem()
}

type CheckCustomizationResourcesResponse struct {
}

type CheckCustomizationSpec CheckCustomizationSpecRequestType

func init() {
	t["CheckCustomizationSpec"] = reflect.TypeOf((*CheckCustomizationSpec)(nil)).Elem()
}

type CheckCustomizationSpecRequestType struct {
	This ManagedObjectReference `xml:"_this"`
	Spec CustomizationSpec      `xml:"spec"`
}

func init() {
	t["CheckCustomizationSpecRequestType"] = reflect.TypeOf((*CheckCustomizationSpecRequestType)(nil)).Elem()
}

type CheckCustomizationSpecResponse struct {
}

type CheckForUpdates CheckForUpdatesRequestType

func init() {
	t["CheckForUpdates"] = reflect.TypeOf((*CheckForUpdates)(nil)).Elem()
}

type CheckForUpdatesRequestType struct {
	This    ManagedObjectReference `xml:"_this"`
	Version string                 `xml:"version,omitempty"`
}

func init() {
	t["CheckForUpdatesRequestType"] = reflect.TypeOf((*CheckForUpdatesRequestType)(nil)).Elem()
}

type CheckForUpdatesResponse struct {
	Returnval *UpdateSet `xml:"returnval,omitempty"`
}

type CheckHostPatchRequestType struct {
	This       ManagedObjectReference                     `xml:"_this"`
	MetaUrls   []string                                   `xml:"metaUrls,omitempty"`
	BundleUrls []string                                   `xml:"bundleUrls,omitempty"`
	Spec       *HostPatchManagerPatchManagerOperationSpec `xml:"spec,omitempty"`
}

func init() {
	t["CheckHostPatchRequestType"] = reflect.TypeOf((*CheckHostPatchRequestType)(nil)).Elem()
}

type CheckHostPatch_Task CheckHostPatchRequestType

func init() {
	t["CheckHostPatch_Task"] = reflect.TypeOf((*CheckHostPatch_Task)(nil)).Elem()
}

type CheckHostPatch_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval"`
}

type CheckInstantCloneRequestType struct {
	This     ManagedObjectReference         `xml:"_this"`
	Vm       ManagedObjectReference         `xml:"vm"`
	Spec     VirtualMachineInstantCloneSpec `xml:"spec"`
	TestType []string                       `xml:"testType,omitempty"`
}

func init() {
	t["CheckInstantCloneRequestType"] = reflect.TypeOf((*CheckInstantCloneRequestType)(nil)).Elem()
}

type CheckInstantClone_Task CheckInstantCloneRequestType

func init() {
	t["CheckInstantClone_Task"] = reflect.TypeOf((*CheckInstantClone_Task)(nil)).Elem()
}

type CheckInstantClone_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval"`
}

type CheckLicenseFeature CheckLicenseFeatureRequestType

func init() {
	t["CheckLicenseFeature"] = reflect.TypeOf((*CheckLicenseFeature)(nil)).Elem()
}

type CheckLicenseFeatureRequestType struct {
	This       ManagedObjectReference  `xml:"_this"`
	Host       *ManagedObjectReference `xml:"host,omitempty"`
	FeatureKey string                  `xml:"featureKey"`
}

func init() {
	t["CheckLicenseFeatureRequestType"] = reflect.TypeOf((*CheckLicenseFeatureRequestType)(nil)).Elem()
}

type CheckLicenseFeatureResponse struct {
	Returnval bool `xml:"returnval"`
}

type CheckMigrateRequestType struct {
	This     ManagedObjectReference   `xml:"_this"`
	Vm       ManagedObjectReference   `xml:"vm"`
	Host     *ManagedObjectReference  `xml:"host,omitempty"`
	Pool     *ManagedObjectReference  `xml:"pool,omitempty"`
	State    VirtualMachinePowerState `xml:"state,omitempty"`
	TestType []string                 `xml:"testType,omitempty"`
}

func init() {
	t["CheckMigrateRequestType"] = reflect.TypeOf((*CheckMigrateRequestType)(nil)).Elem()
}

type CheckMigrate_Task CheckMigrateRequestType

func init() {
	t["CheckMigrate_Task"] = reflect.TypeOf((*CheckMigrate_Task)(nil)).Elem()
}

type CheckMigrate_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval"`
}

type CheckPowerOnRequestType struct {
	This     ManagedObjectReference  `xml:"_this"`
	Vm       ManagedObjectReference  `xml:"vm"`
	Host     *ManagedObjectReference `xml:"host,omitempty"`
	Pool     *ManagedObjectReference `xml:"pool,omitempty"`
	TestType []string                `xml:"testType,omitempty"`
}

func init() {
	t["CheckPowerOnRequestType"] = reflect.TypeOf((*CheckPowerOnRequestType)(nil)).Elem()
}

type CheckPowerOn_Task CheckPowerOnRequestType

func init() {
	t["CheckPowerOn_Task"] = reflect.TypeOf((*CheckPowerOn_Task)(nil)).Elem()
}

type CheckPowerOn_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval"`
}

type CheckProfileComplianceRequestType struct {
	This   ManagedObjectReference   `xml:"_this"`
	Entity []ManagedObjectReference `xml:"entity,omitempty"`
}

func init() {
	t["CheckProfileComplianceRequestType"] = reflect.TypeOf((*CheckProfileComplianceRequestType)(nil)).Elem()
}

type CheckProfileCompliance_Task CheckProfileComplianceRequestType

func init() {
	t["CheckProfileCompliance_Task"] = reflect.TypeOf((*CheckProfileCompliance_Task)(nil)).Elem()
}

type CheckProfileCompliance_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval"`
}

type CheckRelocateRequestType struct {
	This     ManagedObjectReference     `xml:"_this"`
	Vm       ManagedObjectReference     `xml:"vm"`
	Spec     VirtualMachineRelocateSpec `xml:"spec"`
	TestType []string                   `xml:"testType,omitempty"`
}

func init() {
	t["CheckRelocateRequestType"] = reflect.TypeOf((*CheckRelocateRequestType)(nil)).Elem()
}

type CheckRelocate_Task CheckRelocateRequestType

func init() {
	t["CheckRelocate_Task"] = reflect.TypeOf((*CheckRelocate_Task)(nil)).Elem()
}

type CheckRelocate_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval"`
}

type CheckResult struct {
	DynamicData

	Vm      *ManagedObjectReference `xml:"vm,omitempty"`
	Host    *ManagedObjectReference `xml:"host,omitempty"`
	Warning []LocalizedMethodFault  `xml:"warning,omitempty"`
	Error   []LocalizedMethodFault  `xml:"error,omitempty"`
}

func init() {
	t["CheckResult"] = reflect.TypeOf((*CheckResult)(nil)).Elem()
}

type CheckVmConfigRequestType struct {
	This     ManagedObjectReference   `xml:"_this"`
	Spec     VirtualMachineConfigSpec `xml:"spec"`
	Vm       *ManagedObjectReference  `xml:"vm,omitempty"`
	Host     *ManagedObjectReference  `xml:"host,omitempty"`
	Pool     *ManagedObjectReference  `xml:"pool,omitempty"`
	TestType []string                 `xml:"testType,omitempty"`
}

func init() {
	t["CheckVmConfigRequestType"] = reflect.TypeOf((*CheckVmConfigRequestType)(nil)).Elem()
}

type CheckVmConfig_Task CheckVmConfigRequestType

func init() {
	t["CheckVmConfig_Task"] = reflect.TypeOf((*CheckVmConfig_Task)(nil)).Elem()
}

type CheckVmConfig_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval"`
}

type ChoiceOption struct {
	OptionType

	ChoiceInfo   []BaseElementDescription `xml:"choiceInfo,typeattr"`
	DefaultIndex int32                    `xml:"defaultIndex,omitempty"`
}

func init() {
	t["ChoiceOption"] = reflect.TypeOf((*ChoiceOption)(nil)).Elem()
}

type ClearComplianceStatus ClearComplianceStatusRequestType

func init() {
	t["ClearComplianceStatus"] = reflect.TypeOf((*ClearComplianceStatus)(nil)).Elem()
}

type ClearComplianceStatusRequestType struct {
	This    ManagedObjectReference   `xml:"_this"`
	Profile []ManagedObjectReference `xml:"profile,omitempty"`
	Entity  []ManagedObjectReference `xml:"entity,omitempty"`
}

func init() {
	t["ClearComplianceStatusRequestType"] = reflect.TypeOf((*ClearComplianceStatusRequestType)(nil)).Elem()
}

type ClearComplianceStatusResponse struct {
}

type ClearNFSUser ClearNFSUserRequestType

func init() {
	t["ClearNFSUser"] = reflect.TypeOf((*ClearNFSUser)(nil)).Elem()
}

type ClearNFSUserRequestType struct {
	This ManagedObjectReference `xml:"_this"`
}

func init() {
	t["ClearNFSUserRequestType"] = reflect.TypeOf((*ClearNFSUserRequestType)(nil)).Elem()
}

type ClearNFSUserResponse struct {
}

type ClearSystemEventLog ClearSystemEventLogRequestType

func init() {
	t["ClearSystemEventLog"] = reflect.TypeOf((*ClearSystemEventLog)(nil)).Elem()
}

type ClearSystemEventLogRequestType struct {
	This ManagedObjectReference `xml:"_this"`
}

func init() {
	t["ClearSystemEventLogRequestType"] = reflect.TypeOf((*ClearSystemEventLogRequestType)(nil)).Elem()
}

type ClearSystemEventLogResponse struct {
}

type ClearTriggeredAlarms ClearTriggeredAlarmsRequestType

func init() {
	t["ClearTriggeredAlarms"] = reflect.TypeOf((*ClearTriggeredAlarms)(nil)).Elem()
}

type ClearTriggeredAlarmsRequestType struct {
	This   ManagedObjectReference `xml:"_this"`
	Filter AlarmFilterSpec        `xml:"filter"`
}

func init() {
	t["ClearTriggeredAlarmsRequestType"] = reflect.TypeOf((*ClearTriggeredAlarmsRequestType)(nil)).Elem()
}

type ClearTriggeredAlarmsResponse struct {
}

type ClearVStorageObjectControlFlags ClearVStorageObjectControlFlagsRequestType

func init() {
	t["ClearVStorageObjectControlFlags"] = reflect.TypeOf((*ClearVStorageObjectControlFlags)(nil)).Elem()
}

type ClearVStorageObjectControlFlagsRequestType struct {
	This         ManagedObjectReference `xml:"_this"`
	Id           ID                     `xml:"id"`
	Datastore    ManagedObjectReference `xml:"datastore"`
	ControlFlags []string               `xml:"controlFlags,omitempty"`
}

func init() {
	t["ClearVStorageObjectControlFlagsRequestType"] = reflect.TypeOf((*ClearVStorageObjectControlFlagsRequestType)(nil)).Elem()
}

type ClearVStorageObjectControlFlagsResponse struct {
}

type ClockSkew struct {
	HostConfigFault
}

func init() {
	t["ClockSkew"] = reflect.TypeOf((*ClockSkew)(nil)).Elem()
}

type ClockSkewFault ClockSkew

func init() {
	t["ClockSkewFault"] = reflect.TypeOf((*ClockSkewFault)(nil)).Elem()
}

type CloneFromSnapshotNotSupported struct {
	MigrationFault
}

func init() {
	t["CloneFromSnapshotNotSupported"] = reflect.TypeOf((*CloneFromSnapshotNotSupported)(nil)).Elem()
}

type CloneFromSnapshotNotSupportedFault CloneFromSnapshotNotSupported

func init() {
	t["CloneFromSnapshotNotSupportedFault"] = reflect.TypeOf((*CloneFromSnapshotNotSupportedFault)(nil)).Elem()
}

type CloneSession CloneSessionRequestType

func init() {
	t["CloneSession"] = reflect.TypeOf((*CloneSession)(nil)).Elem()
}

type CloneSessionRequestType struct {
	This        ManagedObjectReference `xml:"_this"`
	CloneTicket string                 `xml:"cloneTicket"`
}

func init() {
	t["CloneSessionRequestType"] = reflect.TypeOf((*CloneSessionRequestType)(nil)).Elem()
}

type CloneSessionResponse struct {
	Returnval UserSession `xml:"returnval"`
}

type CloneVAppRequestType struct {
	This   ManagedObjectReference `xml:"_this"`
	Name   string                 `xml:"name"`
	Target ManagedObjectReference `xml:"target"`
	Spec   VAppCloneSpec          `xml:"spec"`
}

func init() {
	t["CloneVAppRequestType"] = reflect.TypeOf((*CloneVAppRequestType)(nil)).Elem()
}

type CloneVApp_Task CloneVAppRequestType

func init() {
	t["CloneVApp_Task"] = reflect.TypeOf((*CloneVApp_Task)(nil)).Elem()
}

type CloneVApp_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval"`
}

type CloneVMRequestType struct {
	This   ManagedObjectReference  `xml:"_this"`
	Folder ManagedObjectReference  `xml:"folder"`
	Name   string                  `xml:"name"`
	Spec   VirtualMachineCloneSpec `xml:"spec"`
}

func init() {
	t["CloneVMRequestType"] = reflect.TypeOf((*CloneVMRequestType)(nil)).Elem()
}

type CloneVM_Task CloneVMRequestType

func init() {
	t["CloneVM_Task"] = reflect.TypeOf((*CloneVM_Task)(nil)).Elem()
}

type CloneVM_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval"`
}

type CloneVStorageObjectRequestType struct {
	This      ManagedObjectReference `xml:"_this"`
	Id        ID                     `xml:"id"`
	Datastore ManagedObjectReference `xml:"datastore"`
	Spec      VslmCloneSpec          `xml:"spec"`
}

func init() {
	t["CloneVStorageObjectRequestType"] = reflect.TypeOf((*CloneVStorageObjectRequestType)(nil)).Elem()
}

type CloneVStorageObject_Task CloneVStorageObjectRequestType

func init() {
	t["CloneVStorageObject_Task"] = reflect.TypeOf((*CloneVStorageObject_Task)(nil)).Elem()
}

type CloneVStorageObject_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval"`
}

type CloseInventoryViewFolder CloseInventoryViewFolderRequestType

func init() {
	t["CloseInventoryViewFolder"] = reflect.TypeOf((*CloseInventoryViewFolder)(nil)).Elem()
}

type CloseInventoryViewFolderRequestType struct {
	This   ManagedObjectReference   `xml:"_this"`
	Entity []ManagedObjectReference `xml:"entity"`
}

func init() {
	t["CloseInventoryViewFolderRequestType"] = reflect.TypeOf((*CloseInventoryViewFolderRequestType)(nil)).Elem()
}

type CloseInventoryViewFolderResponse struct {
	Returnval []ManagedObjectReference `xml:"returnval,omitempty"`
}

type ClusterAction struct {
	DynamicData

	Type   string                  `xml:"type"`
	Target *ManagedObjectReference `xml:"target,omitempty"`
}

func init() {
	t["ClusterAction"] = reflect.TypeOf((*ClusterAction)(nil)).Elem()
}

type ClusterActionHistory struct {
	DynamicData

	Action BaseClusterAction `xml:"action,typeattr"`
	Time   time.Time         `xml:"time"`
}

func init() {
	t["ClusterActionHistory"] = reflect.TypeOf((*ClusterActionHistory)(nil)).Elem()
}

type ClusterAffinityRuleSpec struct {
	ClusterRuleInfo

	Vm []ManagedObjectReference `xml:"vm"`
}

func init() {
	t["ClusterAffinityRuleSpec"] = reflect.TypeOf((*ClusterAffinityRuleSpec)(nil)).Elem()
}

type ClusterAntiAffinityRuleSpec struct {
	ClusterRuleInfo

	Vm []ManagedObjectReference `xml:"vm"`
}

func init() {
	t["ClusterAntiAffinityRuleSpec"] = reflect.TypeOf((*ClusterAntiAffinityRuleSpec)(nil)).Elem()
}

type ClusterAttemptedVmInfo struct {
	DynamicData

	Vm   ManagedObjectReference  `xml:"vm"`
	Task *ManagedObjectReference `xml:"task,omitempty"`
}

func init() {
	t["ClusterAttemptedVmInfo"] = reflect.TypeOf((*ClusterAttemptedVmInfo)(nil)).Elem()
}

type ClusterComplianceCheckedEvent struct {
	ClusterEvent

	Profile ProfileEventArgument `xml:"profile"`
}

func init() {
	t["ClusterComplianceCheckedEvent"] = reflect.TypeOf((*ClusterComplianceCheckedEvent)(nil)).Elem()
}

type ClusterComputeResourceClusterConfigResult struct {
	DynamicData

	FailedHosts     []FolderFailedHostResult `xml:"failedHosts,omitempty"`
	ConfiguredHosts []ManagedObjectReference `xml:"configuredHosts,omitempty"`
}

func init() {
	t["ClusterComputeResourceClusterConfigResult"] = reflect.TypeOf((*ClusterComputeResourceClusterConfigResult)(nil)).Elem()
}

type ClusterComputeResourceDVSConfigurationValidation struct {
	ClusterComputeResourceValidationResultBase

	IsDvsValid  bool `xml:"isDvsValid"`
	IsDvpgValid bool `xml:"isDvpgValid"`
}

func init() {
	t["ClusterComputeResourceDVSConfigurationValidation"] = reflect.TypeOf((*ClusterComputeResourceDVSConfigurationValidation)(nil)).Elem()
}

type ClusterComputeResourceDVSSetting struct {
	DynamicData

	DvSwitch           ManagedObjectReference                                        `xml:"dvSwitch"`
	PnicDevices        []string                                                      `xml:"pnicDevices,omitempty"`
	DvPortgroupSetting []ClusterComputeResourceDVSSettingDVPortgroupToServiceMapping `xml:"dvPortgroupSetting,omitempty"`
}

func init() {
	t["ClusterComputeResourceDVSSetting"] = reflect.TypeOf((*ClusterComputeResourceDVSSetting)(nil)).Elem()
}

type ClusterComputeResourceDVSSettingDVPortgroupToServiceMapping struct {
	DynamicData

	DvPortgroup ManagedObjectReference `xml:"dvPortgroup"`
	Service     string                 `xml:"service"`
}

func init() {
	t["ClusterComputeResourceDVSSettingDVPortgroupToServiceMapping"] = reflect.TypeOf((*ClusterComputeResourceDVSSettingDVPortgroupToServiceMapping)(nil)).Elem()
}

type ClusterComputeResourceDvsProfile struct {
	DynamicData

	DvsName            string                                                            `xml:"dvsName,omitempty"`
	DvSwitch           *ManagedObjectReference                                           `xml:"dvSwitch,omitempty"`
	PnicDevices        []string                                                          `xml:"pnicDevices,omitempty"`
	DvPortgroupMapping []ClusterComputeResourceDvsProfileDVPortgroupSpecToServiceMapping `xml:"dvPortgroupMapping,omitempty"`
}

func init() {
	t["ClusterComputeResourceDvsProfile"] = reflect.TypeOf((*ClusterComputeResourceDvsProfile)(nil)).Elem()
}

type ClusterComputeResourceDvsProfileDVPortgroupSpecToServiceMapping struct {
	DynamicData

	DvPortgroupSpec *DVPortgroupConfigSpec  `xml:"dvPortgroupSpec,omitempty"`
	DvPortgroup     *ManagedObjectReference `xml:"dvPortgroup,omitempty"`
	Service         string                  `xml:"service"`
}

func init() {
	t["ClusterComputeResourceDvsProfileDVPortgroupSpecToServiceMapping"] = reflect.TypeOf((*ClusterComputeResourceDvsProfileDVPortgroupSpecToServiceMapping)(nil)).Elem()
}

type ClusterComputeResourceHCIConfigInfo struct {
	DynamicData

	WorkflowState     string                                          `xml:"workflowState"`
	DvsSetting        []ClusterComputeResourceDVSSetting              `xml:"dvsSetting,omitempty"`
	ConfiguredHosts   []ManagedObjectReference                        `xml:"configuredHosts,omitempty"`
	HostConfigProfile *ClusterComputeResourceHostConfigurationProfile `xml:"hostConfigProfile,omitempty"`
}

func init() {
	t["ClusterComputeResourceHCIConfigInfo"] = reflect.TypeOf((*ClusterComputeResourceHCIConfigInfo)(nil)).Elem()
}

type ClusterComputeResourceHCIConfigSpec struct {
	DynamicData

	DvsProf           []ClusterComputeResourceDvsProfile              `xml:"dvsProf,omitempty"`
	HostConfigProfile *ClusterComputeResourceHostConfigurationProfile `xml:"hostConfigProfile,omitempty"`
	VSanConfigSpec    *SDDCBase                                       `xml:"vSanConfigSpec,omitempty"`
	VcProf            *ClusterComputeResourceVCProfile                `xml:"vcProf,omitempty"`
}

func init() {
	t["ClusterComputeResourceHCIConfigSpec"] = reflect.TypeOf((*ClusterComputeResourceHCIConfigSpec)(nil)).Elem()
}

type ClusterComputeResourceHostConfigurationInput struct {
	DynamicData

	Host                        ManagedObjectReference                 `xml:"host"`
	HostVmkNics                 []ClusterComputeResourceHostVmkNicInfo `xml:"hostVmkNics,omitempty"`
	AllowedInNonMaintenanceMode *bool                                  `xml:"allowedInNonMaintenanceMode"`
}

func init() {
	t["ClusterComputeResourceHostConfigurationInput"] = reflect.TypeOf((*ClusterComputeResourceHostConfigurationInput)(nil)).Elem()
}

type ClusterComputeResourceHostConfigurationProfile struct {
	DynamicData

	DateTimeConfig *HostDateTimeConfig `xml:"dateTimeConfig,omitempty"`
	LockdownMode   HostLockdownMode    `xml:"lockdownMode,omitempty"`
}

func init() {
	t["ClusterComputeResourceHostConfigurationProfile"] = reflect.TypeOf((*ClusterComputeResourceHostConfigurationProfile)(nil)).Elem()
}

type ClusterComputeResourceHostConfigurationValidation struct {
	ClusterComputeResourceValidationResultBase

	Host                 ManagedObjectReference `xml:"host"`
	IsDvsSettingValid    *bool                  `xml:"isDvsSettingValid"`
	IsVmknicSettingValid *bool                  `xml:"isVmknicSettingValid"`
	IsNtpSettingValid    *bool                  `xml:"isNtpSettingValid"`
	IsLockdownModeValid  *bool                  `xml:"isLockdownModeValid"`
}

func init() {
	t["ClusterComputeResourceHostConfigurationValidation"] = reflect.TypeOf((*ClusterComputeResourceHostConfigurationValidation)(nil)).Elem()
}

type ClusterComputeResourceHostVmkNicInfo struct {
	DynamicData

	NicSpec HostVirtualNicSpec `xml:"nicSpec"`
	Service string             `xml:"service"`
}

func init() {
	t["ClusterComputeResourceHostVmkNicInfo"] = reflect.TypeOf((*ClusterComputeResourceHostVmkNicInfo)(nil)).Elem()
}

type ClusterComputeResourceSummary struct {
	ComputeResourceSummary

	CurrentFailoverLevel         int32                              `xml:"currentFailoverLevel"`
	AdmissionControlInfo         BaseClusterDasAdmissionControlInfo `xml:"admissionControlInfo,omitempty,typeattr"`
	NumVmotions                  int32                              `xml:"numVmotions"`
	TargetBalance                int32                              `xml:"targetBalance,omitempty"`
	CurrentBalance               int32                              `xml:"currentBalance,omitempty"`
	DrsScore                     int32                              `xml:"drsScore,omitempty"`
	NumVmsPerDrsScoreBucket      []int32                            `xml:"numVmsPerDrsScoreBucket,omitempty"`
	UsageSummary                 *ClusterUsageSummary               `xml:"usageSummary,omitempty"`
	CurrentEVCModeKey            string                             `xml:"currentEVCModeKey,omitempty"`
	CurrentEVCGraphicsModeKey    string                             `xml:"currentEVCGraphicsModeKey,omitempty"`
	DasData                      BaseClusterDasData                 `xml:"dasData,omitempty,typeattr"`
	ClusterMaintenanceModeStatus string                             `xml:"clusterMaintenanceModeStatus,omitempty"`
	VcsHealthStatus              string                             `xml:"vcsHealthStatus,omitempty"`
	VcsSlots                     []ClusterComputeResourceVcsSlots   `xml:"vcsSlots,omitempty"`
}

func init() {
	t["ClusterComputeResourceSummary"] = reflect.TypeOf((*ClusterComputeResourceSummary)(nil)).Elem()
}

type ClusterComputeResourceVCProfile struct {
	DynamicData

	ClusterSpec        *ClusterConfigSpecEx `xml:"clusterSpec,omitempty"`
	EvcModeKey         string               `xml:"evcModeKey,omitempty"`
	EvcGraphicsModeKey string               `xml:"evcGraphicsModeKey,omitempty"`
}

func init() {
	t["ClusterComputeResourceVCProfile"] = reflect.TypeOf((*ClusterComputeResourceVCProfile)(nil)).Elem()
}

type ClusterComputeResourceValidationResultBase struct {
	DynamicData

	Info []LocalizableMessage `xml:"info,omitempty"`
}

func init() {
	t["ClusterComputeResourceValidationResultBase"] = reflect.TypeOf((*ClusterComputeResourceValidationResultBase)(nil)).Elem()
}

type ClusterComputeResourceVcsSlots struct {
	DynamicData

	SystemId   string                   `xml:"systemId,omitempty"`
	Host       ManagedObjectReference   `xml:"host"`
	Datastore  []ManagedObjectReference `xml:"datastore,omitempty"`
	TotalSlots int32                    `xml:"totalSlots"`
}

func init() {
	t["ClusterComputeResourceVcsSlots"] = reflect.TypeOf((*ClusterComputeResourceVcsSlots)(nil)).Elem()
}

type ClusterConfigInfo struct {
	DynamicData

	DasConfig   ClusterDasConfigInfo     `xml:"dasConfig"`
	DasVmConfig []ClusterDasVmConfigInfo `xml:"dasVmConfig,omitempty"`
	DrsConfig   ClusterDrsConfigInfo     `xml:"drsConfig"`
	DrsVmConfig []ClusterDrsVmConfigInfo `xml:"drsVmConfig,omitempty"`
	Rule        []BaseClusterRuleInfo    `xml:"rule,omitempty,typeattr"`
}

func init() {
	t["ClusterConfigInfo"] = reflect.TypeOf((*ClusterConfigInfo)(nil)).Elem()
}

type ClusterConfigInfoEx struct {
	ComputeResourceConfigInfo

	SystemVMsConfig     *ClusterSystemVMsConfigInfo     `xml:"systemVMsConfig,omitempty"`
	DasConfig           ClusterDasConfigInfo            `xml:"dasConfig"`
	DasVmConfig         []ClusterDasVmConfigInfo        `xml:"dasVmConfig,omitempty"`
	DrsConfig           ClusterDrsConfigInfo            `xml:"drsConfig"`
	DrsVmConfig         []ClusterDrsVmConfigInfo        `xml:"drsVmConfig,omitempty"`
	Rule                []BaseClusterRuleInfo           `xml:"rule,omitempty,typeattr"`
	Orchestration       *ClusterOrchestrationInfo       `xml:"orchestration,omitempty"`
	VmOrchestration     []ClusterVmOrchestrationInfo    `xml:"vmOrchestration,omitempty"`
	DpmConfigInfo       *ClusterDpmConfigInfo           `xml:"dpmConfigInfo,omitempty"`
	DpmHostConfig       []ClusterDpmHostConfigInfo      `xml:"dpmHostConfig,omitempty"`
	VsanConfigInfo      *VsanClusterConfigInfo          `xml:"vsanConfigInfo,omitempty"`
	VsanHostConfig      []VsanHostConfigInfo            `xml:"vsanHostConfig,omitempty"`
	Group               []BaseClusterGroupInfo          `xml:"group,omitempty,typeattr"`
	InfraUpdateHaConfig *ClusterInfraUpdateHaConfigInfo `xml:"infraUpdateHaConfig,omitempty"`
	ProactiveDrsConfig  *ClusterProactiveDrsConfigInfo  `xml:"proactiveDrsConfig,omitempty"`
	CryptoConfig        *ClusterCryptoConfigInfo        `xml:"cryptoConfig,omitempty"`
}

func init() {
	t["ClusterConfigInfoEx"] = reflect.TypeOf((*ClusterConfigInfoEx)(nil)).Elem()
}

type ClusterConfigSpec struct {
	DynamicData

	DasConfig       *ClusterDasConfigInfo    `xml:"dasConfig,omitempty"`
	DasVmConfigSpec []ClusterDasVmConfigSpec `xml:"dasVmConfigSpec,omitempty"`
	DrsConfig       *ClusterDrsConfigInfo    `xml:"drsConfig,omitempty"`
	DrsVmConfigSpec []ClusterDrsVmConfigSpec `xml:"drsVmConfigSpec,omitempty"`
	RulesSpec       []ClusterRuleSpec        `xml:"rulesSpec,omitempty"`
}

func init() {
	t["ClusterConfigSpec"] = reflect.TypeOf((*ClusterConfigSpec)(nil)).Elem()
}

type ClusterConfigSpecEx struct {
	ComputeResourceConfigSpec

	SystemVMsConfig     *ClusterSystemVMsConfigSpec     `xml:"systemVMsConfig,omitempty"`
	DasConfig           *ClusterDasConfigInfo           `xml:"dasConfig,omitempty"`
	DasVmConfigSpec     []ClusterDasVmConfigSpec        `xml:"dasVmConfigSpec,omitempty"`
	DrsConfig           *ClusterDrsConfigInfo           `xml:"drsConfig,omitempty"`
	DrsVmConfigSpec     []ClusterDrsVmConfigSpec        `xml:"drsVmConfigSpec,omitempty"`
	RulesSpec           []ClusterRuleSpec               `xml:"rulesSpec,omitempty"`
	Orchestration       *ClusterOrchestrationInfo       `xml:"orchestration,omitempty"`
	VmOrchestrationSpec []ClusterVmOrchestrationSpec    `xml:"vmOrchestrationSpec,omitempty"`
	DpmConfig           *ClusterDpmConfigInfo           `xml:"dpmConfig,omitempty"`
	DpmHostConfigSpec   []ClusterDpmHostConfigSpec      `xml:"dpmHostConfigSpec,omitempty"`
	VsanConfig          *VsanClusterConfigInfo          `xml:"vsanConfig,omitempty"`
	VsanHostConfigSpec  []VsanHostConfigInfo            `xml:"vsanHostConfigSpec,omitempty"`
	GroupSpec           []ClusterGroupSpec              `xml:"groupSpec,omitempty"`
	InfraUpdateHaConfig *ClusterInfraUpdateHaConfigInfo `xml:"infraUpdateHaConfig,omitempty"`
	ProactiveDrsConfig  *ClusterProactiveDrsConfigInfo  `xml:"proactiveDrsConfig,omitempty"`
	InHciWorkflow       *bool                           `xml:"inHciWorkflow"`
	CryptoConfig        *ClusterCryptoConfigInfo        `xml:"cryptoConfig,omitempty"`
}

func init() {
	t["ClusterConfigSpecEx"] = reflect.TypeOf((*ClusterConfigSpecEx)(nil)).Elem()
}

type ClusterCreatedEvent struct {
	ClusterEvent

	Parent FolderEventArgument `xml:"parent"`
}

func init() {
	t["ClusterCreatedEvent"] = reflect.TypeOf((*ClusterCreatedEvent)(nil)).Elem()
}

type ClusterCryptoConfigInfo struct {
	DynamicData

	CryptoMode string `xml:"cryptoMode,omitempty"`
}

func init() {
	t["ClusterCryptoConfigInfo"] = reflect.TypeOf((*ClusterCryptoConfigInfo)(nil)).Elem()
}

type ClusterDasAamHostInfo struct {
	ClusterDasHostInfo

	HostDasState []ClusterDasAamNodeState `xml:"hostDasState,omitempty"`
	PrimaryHosts []string                 `xml:"primaryHosts,omitempty"`
}

func init() {
	t["ClusterDasAamHostInfo"] = reflect.TypeOf((*ClusterDasAamHostInfo)(nil)).Elem()
}

type ClusterDasAamNodeState struct {
	DynamicData

	Host         ManagedObjectReference `xml:"host"`
	Name         string                 `xml:"name"`
	ConfigState  string                 `xml:"configState"`
	RuntimeState string                 `xml:"runtimeState"`
}

func init() {
	t["ClusterDasAamNodeState"] = reflect.TypeOf((*ClusterDasAamNodeState)(nil)).Elem()
}

type ClusterDasAdmissionControlInfo struct {
	DynamicData
}

func init() {
	t["ClusterDasAdmissionControlInfo"] = reflect.TypeOf((*ClusterDasAdmissionControlInfo)(nil)).Elem()
}

type ClusterDasAdmissionControlPolicy struct {
	DynamicData

	ResourceReductionToToleratePercent *int32 `xml:"resourceReductionToToleratePercent"`
	PMemAdmissionControlEnabled        *bool  `xml:"pMemAdmissionControlEnabled"`
}

func init() {
	t["ClusterDasAdmissionControlPolicy"] = reflect.TypeOf((*ClusterDasAdmissionControlPolicy)(nil)).Elem()
}

type ClusterDasAdvancedRuntimeInfo struct {
	DynamicData

	DasHostInfo            BaseClusterDasHostInfo                           `xml:"dasHostInfo,omitempty,typeattr"`
	VmcpSupported          *ClusterDasAdvancedRuntimeInfoVmcpCapabilityInfo `xml:"vmcpSupported,omitempty"`
	HeartbeatDatastoreInfo []DasHeartbeatDatastoreInfo                      `xml:"heartbeatDatastoreInfo,omitempty"`
}

func init() {
	t["ClusterDasAdvancedRuntimeInfo"] = reflect.TypeOf((*ClusterDasAdvancedRuntimeInfo)(nil)).Elem()
}

type ClusterDasAdvancedRuntimeInfoVmcpCapabilityInfo struct {
	DynamicData

	StorageAPDSupported bool `xml:"storageAPDSupported"`
	StoragePDLSupported bool `xml:"storagePDLSupported"`
}

func init() {
	t["ClusterDasAdvancedRuntimeInfoVmcpCapabilityInfo"] = reflect.TypeOf((*ClusterDasAdvancedRuntimeInfoVmcpCapabilityInfo)(nil)).Elem()
}

type ClusterDasConfigInfo struct {
	DynamicData

	Enabled                    *bool                                `xml:"enabled"`
	VmMonitoring               string                               `xml:"vmMonitoring,omitempty"`
	HostMonitoring             string                               `xml:"hostMonitoring,omitempty"`
	VmComponentProtecting      string                               `xml:"vmComponentProtecting,omitempty"`
	FailoverLevel              int32                                `xml:"failoverLevel,omitempty"`
	AdmissionControlPolicy     BaseClusterDasAdmissionControlPolicy `xml:"admissionControlPolicy,omitempty,typeattr"`
	AdmissionControlEnabled    *bool                                `xml:"admissionControlEnabled"`
	DefaultVmSettings          *ClusterDasVmSettings                `xml:"defaultVmSettings,omitempty"`
	Option                     []BaseOptionValue                    `xml:"option,omitempty,typeattr"`
	HeartbeatDatastore         []ManagedObjectReference             `xml:"heartbeatDatastore,omitempty"`
	HBDatastoreCandidatePolicy string                               `xml:"hBDatastoreCandidatePolicy,omitempty"`
}

func init() {
	t["ClusterDasConfigInfo"] = reflect.TypeOf((*ClusterDasConfigInfo)(nil)).Elem()
}

type ClusterDasData struct {
	DynamicData
}

func init() {
	t["ClusterDasData"] = reflect.TypeOf((*ClusterDasData)(nil)).Elem()
}

type ClusterDasDataSummary struct {
	ClusterDasData

	HostListVersion      int64 `xml:"hostListVersion"`
	ClusterConfigVersion int64 `xml:"clusterConfigVersion"`
	CompatListVersion    int64 `xml:"compatListVersion"`
}

func init() {
	t["ClusterDasDataSummary"] = reflect.TypeOf((*ClusterDasDataSummary)(nil)).Elem()
}

type ClusterDasFailoverLevelAdvancedRuntimeInfo struct {
	ClusterDasAdvancedRuntimeInfo

	SlotInfo                  ClusterDasFailoverLevelAdvancedRuntimeInfoSlotInfo    `xml:"slotInfo"`
	TotalSlots                int32                                                 `xml:"totalSlots"`
	UsedSlots                 int32                                                 `xml:"usedSlots"`
	UnreservedSlots           int32                                                 `xml:"unreservedSlots"`
	TotalVms                  int32                                                 `xml:"totalVms"`
	TotalHosts                int32                                                 `xml:"totalHosts"`
	TotalGoodHosts            int32                                                 `xml:"totalGoodHosts"`
	HostSlots                 []ClusterDasFailoverLevelAdvancedRuntimeInfoHostSlots `xml:"hostSlots,omitempty"`
	VmsRequiringMultipleSlots []ClusterDasFailoverLevelAdvancedRuntimeInfoVmSlots   `xml:"vmsRequiringMultipleSlots,omitempty"`
}

func init() {
	t["ClusterDasFailoverLevelAdvancedRuntimeInfo"] = reflect.TypeOf((*ClusterDasFailoverLevelAdvancedRuntimeInfo)(nil)).Elem()
}

type ClusterDasFailoverLevelAdvancedRuntimeInfoHostSlots struct {
	DynamicData

	Host  ManagedObjectReference `xml:"host"`
	Slots int32                  `xml:"slots"`
}

func init() {
	t["ClusterDasFailoverLevelAdvancedRuntimeInfoHostSlots"] = reflect.TypeOf((*ClusterDasFailoverLevelAdvancedRuntimeInfoHostSlots)(nil)).Elem()
}

type ClusterDasFailoverLevelAdvancedRuntimeInfoSlotInfo struct {
	DynamicData

	NumVcpus int32 `xml:"numVcpus"`
	CpuMHz   int32 `xml:"cpuMHz"`
	MemoryMB int32 `xml:"memoryMB"`
}

func init() {
	t["ClusterDasFailoverLevelAdvancedRuntimeInfoSlotInfo"] = reflect.TypeOf((*ClusterDasFailoverLevelAdvancedRuntimeInfoSlotInfo)(nil)).Elem()
}

type ClusterDasFailoverLevelAdvancedRuntimeInfoVmSlots struct {
	DynamicData

	Vm    ManagedObjectReference `xml:"vm"`
	Slots int32                  `xml:"slots"`
}

func init() {
	t["ClusterDasFailoverLevelAdvancedRuntimeInfoVmSlots"] = reflect.TypeOf((*ClusterDasFailoverLevelAdvancedRuntimeInfoVmSlots)(nil)).Elem()
}

type ClusterDasFdmHostState struct {
	DynamicData

	State         string                  `xml:"state"`
	StateReporter *ManagedObjectReference `xml:"stateReporter,omitempty"`
}

func init() {
	t["ClusterDasFdmHostState"] = reflect.TypeOf((*ClusterDasFdmHostState)(nil)).Elem()
}

type ClusterDasHostInfo struct {
	DynamicData
}

func init() {
	t["ClusterDasHostInfo"] = reflect.TypeOf((*ClusterDasHostInfo)(nil)).Elem()
}

type ClusterDasHostRecommendation struct {
	DynamicData

	Host      ManagedObjectReference `xml:"host"`
	DrsRating int32                  `xml:"drsRating,omitempty"`
}

func init() {
	t["ClusterDasHostRecommendation"] = reflect.TypeOf((*ClusterDasHostRecommendation)(nil)).Elem()
}

type ClusterDasVmConfigInfo struct {
	DynamicData

	Key                 ManagedObjectReference `xml:"key"`
	RestartPriority     DasVmPriority          `xml:"restartPriority,omitempty"`
	PowerOffOnIsolation *bool                  `xml:"powerOffOnIsolation"`
	DasSettings         *ClusterDasVmSettings  `xml:"dasSettings,omitempty"`
}

func init() {
	t["ClusterDasVmConfigInfo"] = reflect.TypeOf((*ClusterDasVmConfigInfo)(nil)).Elem()
}

type ClusterDasVmConfigSpec struct {
	ArrayUpdateSpec

	Info *ClusterDasVmConfigInfo `xml:"info,omitempty"`
}

func init() {
	t["ClusterDasVmConfigSpec"] = reflect.TypeOf((*ClusterDasVmConfigSpec)(nil)).Elem()
}

type ClusterDasVmSettings struct {
	DynamicData

	RestartPriority               string                                `xml:"restartPriority,omitempty"`
	RestartPriorityTimeout        int32                                 `xml:"restartPriorityTimeout,omitempty"`
	IsolationResponse             string                                `xml:"isolationResponse,omitempty"`
	VmToolsMonitoringSettings     *ClusterVmToolsMonitoringSettings     `xml:"vmToolsMonitoringSettings,omitempty"`
	VmComponentProtectionSettings *ClusterVmComponentProtectionSettings `xml:"vmComponentProtectionSettings,omitempty"`
}

func init() {
	t["ClusterDasVmSettings"] = reflect.TypeOf((*ClusterDasVmSettings)(nil)).Elem()
}

type ClusterDatastoreUpdateSpec struct {
	ArrayUpdateSpec

	Datastore *ManagedObjectReference `xml:"datastore,omitempty"`
}

func init() {
	t["ClusterDatastoreUpdateSpec"] = reflect.TypeOf((*ClusterDatastoreUpdateSpec)(nil)).Elem()
}

type ClusterDependencyRuleInfo struct {
	ClusterRuleInfo

	VmGroup          string `xml:"vmGroup"`
	DependsOnVmGroup string `xml:"dependsOnVmGroup"`
}

func init() {
	t["ClusterDependencyRuleInfo"] = reflect.TypeOf((*ClusterDependencyRuleInfo)(nil)).Elem()
}

type ClusterDestroyedEvent struct {
	ClusterEvent
}

func init() {
	t["ClusterDestroyedEvent"] = reflect.TypeOf((*ClusterDestroyedEvent)(nil)).Elem()
}

type ClusterDpmConfigInfo struct {
	DynamicData

	Enabled             *bool             `xml:"enabled"`
	DefaultDpmBehavior  DpmBehavior       `xml:"defaultDpmBehavior,omitempty"`
	HostPowerActionRate int32             `xml:"hostPowerActionRate,omitempty"`
	Option              []BaseOptionValue `xml:"option,omitempty,typeattr"`
}

func init() {
	t["ClusterDpmConfigInfo"] = reflect.TypeOf((*ClusterDpmConfigInfo)(nil)).Elem()
}

type ClusterDpmHostConfigInfo struct {
	DynamicData

	Key      ManagedObjectReference `xml:"key"`
	Enabled  *bool                  `xml:"enabled"`
	Behavior DpmBehavior            `xml:"behavior,omitempty"`
}

func init() {
	t["ClusterDpmHostConfigInfo"] = reflect.TypeOf((*ClusterDpmHostConfigInfo)(nil)).Elem()
}

type ClusterDpmHostConfigSpec struct {
	ArrayUpdateSpec

	Info *ClusterDpmHostConfigInfo `xml:"info,omitempty"`
}

func init() {
	t["ClusterDpmHostConfigSpec"] = reflect.TypeOf((*ClusterDpmHostConfigSpec)(nil)).Elem()
}

type ClusterDrsConfigInfo struct {
	DynamicData

	Enabled                   *bool             `xml:"enabled"`
	EnableVmBehaviorOverrides *bool             `xml:"enableVmBehaviorOverrides"`
	DefaultVmBehavior         DrsBehavior       `xml:"defaultVmBehavior,omitempty"`
	VmotionRate               int32             `xml:"vmotionRate,omitempty"`
	ScaleDescendantsShares    string            `xml:"scaleDescendantsShares,omitempty"`
	Option                    []BaseOptionValue `xml:"option,omitempty,typeattr"`
}

func init() {
	t["ClusterDrsConfigInfo"] = reflect.TypeOf((*ClusterDrsConfigInfo)(nil)).Elem()
}

type ClusterDrsFaults struct {
	DynamicData

	Reason     string                           `xml:"reason"`
	FaultsByVm []BaseClusterDrsFaultsFaultsByVm `xml:"faultsByVm,typeattr"`
}

func init() {
	t["ClusterDrsFaults"] = reflect.TypeOf((*ClusterDrsFaults)(nil)).Elem()
}

type ClusterDrsFaultsFaultsByVirtualDisk struct {
	ClusterDrsFaultsFaultsByVm

	Disk *VirtualDiskId `xml:"disk,omitempty"`
}

func init() {
	t["ClusterDrsFaultsFaultsByVirtualDisk"] = reflect.TypeOf((*ClusterDrsFaultsFaultsByVirtualDisk)(nil)).Elem()
}

type ClusterDrsFaultsFaultsByVm struct {
	DynamicData

	Vm    *ManagedObjectReference `xml:"vm,omitempty"`
	Fault []LocalizedMethodFault  `xml:"fault"`
}

func init() {
	t["ClusterDrsFaultsFaultsByVm"] = reflect.TypeOf((*ClusterDrsFaultsFaultsByVm)(nil)).Elem()
}

type ClusterDrsMigration struct {
	DynamicData

	Key                   string                 `xml:"key"`
	Time                  time.Time              `xml:"time"`
	Vm                    ManagedObjectReference `xml:"vm"`
	CpuLoad               int32                  `xml:"cpuLoad,omitempty"`
	MemoryLoad            int64                  `xml:"memoryLoad,omitempty"`
	Source                ManagedObjectReference `xml:"source"`
	SourceCpuLoad         int32                  `xml:"sourceCpuLoad,omitempty"`
	SourceMemoryLoad      int64                  `xml:"sourceMemoryLoad,omitempty"`
	Destination           ManagedObjectReference `xml:"destination"`
	DestinationCpuLoad    int32                  `xml:"destinationCpuLoad,omitempty"`
	DestinationMemoryLoad int64                  `xml:"destinationMemoryLoad,omitempty"`
}

func init() {
	t["ClusterDrsMigration"] = reflect.TypeOf((*ClusterDrsMigration)(nil)).Elem()
}

type ClusterDrsRecommendation struct {
	DynamicData

	Key           string                `xml:"key"`
	Rating        int32                 `xml:"rating"`
	Reason        string                `xml:"reason"`
	ReasonText    string                `xml:"reasonText"`
	MigrationList []ClusterDrsMigration `xml:"migrationList"`
}

func init() {
	t["ClusterDrsRecommendation"] = reflect.TypeOf((*ClusterDrsRecommendation)(nil)).Elem()
}

type ClusterDrsVmConfigInfo struct {
	DynamicData

	Key      ManagedObjectReference `xml:"key"`
	Enabled  *bool                  `xml:"enabled"`
	Behavior DrsBehavior            `xml:"behavior,omitempty"`
}

func init() {
	t["ClusterDrsVmConfigInfo"] = reflect.TypeOf((*ClusterDrsVmConfigInfo)(nil)).Elem()
}

type ClusterDrsVmConfigSpec struct {
	ArrayUpdateSpec

	Info *ClusterDrsVmConfigInfo `xml:"info,omitempty"`
}

func init() {
	t["ClusterDrsVmConfigSpec"] = reflect.TypeOf((*ClusterDrsVmConfigSpec)(nil)).Elem()
}

type ClusterEVCManagerCheckResult struct {
	DynamicData

	EvcModeKey string                   `xml:"evcModeKey"`
	Error      LocalizedMethodFault     `xml:"error"`
	Host       []ManagedObjectReference `xml:"host,omitempty"`
}

func init() {
	t["ClusterEVCManagerCheckResult"] = reflect.TypeOf((*ClusterEVCManagerCheckResult)(nil)).Elem()
}

type ClusterEVCManagerEVCState struct {
	DynamicData

	SupportedEVCMode      []EVCMode                          `xml:"supportedEVCMode"`
	CurrentEVCModeKey     string                             `xml:"currentEVCModeKey,omitempty"`
	GuaranteedCPUFeatures []HostCpuIdInfo                    `xml:"guaranteedCPUFeatures,omitempty"`
	FeatureCapability     []HostFeatureCapability            `xml:"featureCapability,omitempty"`
	FeatureMask           []HostFeatureMask                  `xml:"featureMask,omitempty"`
	FeatureRequirement    []VirtualMachineFeatureRequirement `xml:"featureRequirement,omitempty"`
}

func init() {
	t["ClusterEVCManagerEVCState"] = reflect.TypeOf((*ClusterEVCManagerEVCState)(nil)).Elem()
}

type ClusterEnterMaintenanceMode ClusterEnterMaintenanceModeRequestType

func init() {
	t["ClusterEnterMaintenanceMode"] = reflect.TypeOf((*ClusterEnterMaintenanceMode)(nil)).Elem()
}

type ClusterEnterMaintenanceModeRequestType struct {
	This   ManagedObjectReference   `xml:"_this"`
	Host   []ManagedObjectReference `xml:"host"`
	Option []BaseOptionValue        `xml:"option,omitempty,typeattr"`
}

func init() {
	t["ClusterEnterMaintenanceModeRequestType"] = reflect.TypeOf((*ClusterEnterMaintenanceModeRequestType)(nil)).Elem()
}

type ClusterEnterMaintenanceModeResponse struct {
	Returnval ClusterEnterMaintenanceResult `xml:"returnval"`
}

type ClusterEnterMaintenanceResult struct {
	DynamicData

	Recommendations []ClusterRecommendation `xml:"recommendations,omitempty"`
	Fault           *ClusterDrsFaults       `xml:"fault,omitempty"`
}

func init() {
	t["ClusterEnterMaintenanceResult"] = reflect.TypeOf((*ClusterEnterMaintenanceResult)(nil)).Elem()
}

type ClusterEvent struct {
	Event
}

func init() {
	t["ClusterEvent"] = reflect.TypeOf((*ClusterEvent)(nil)).Elem()
}

type ClusterFailoverHostAdmissionControlInfo struct {
	ClusterDasAdmissionControlInfo

	HostStatus []ClusterFailoverHostAdmissionControlInfoHostStatus `xml:"hostStatus,omitempty"`
}

func init() {
	t["ClusterFailoverHostAdmissionControlInfo"] = reflect.TypeOf((*ClusterFailoverHostAdmissionControlInfo)(nil)).Elem()
}

type ClusterFailoverHostAdmissionControlInfoHostStatus struct {
	DynamicData

	Host   ManagedObjectReference `xml:"host"`
	Status ManagedEntityStatus    `xml:"status"`
}

func init() {
	t["ClusterFailoverHostAdmissionControlInfoHostStatus"] = reflect.TypeOf((*ClusterFailoverHostAdmissionControlInfoHostStatus)(nil)).Elem()
}

type ClusterFailoverHostAdmissionControlPolicy struct {
	ClusterDasAdmissionControlPolicy

	FailoverHosts []ManagedObjectReference `xml:"failoverHosts,omitempty"`
	FailoverLevel int32                    `xml:"failoverLevel,omitempty"`
}

func init() {
	t["ClusterFailoverHostAdmissionControlPolicy"] = reflect.TypeOf((*ClusterFailoverHostAdmissionControlPolicy)(nil)).Elem()
}

type ClusterFailoverLevelAdmissionControlInfo struct {
	ClusterDasAdmissionControlInfo

	CurrentFailoverLevel int32 `xml:"currentFailoverLevel"`
}

func init() {
	t["ClusterFailoverLevelAdmissionControlInfo"] = reflect.TypeOf((*ClusterFailoverLevelAdmissionControlInfo)(nil)).Elem()
}

type ClusterFailoverLevelAdmissionControlPolicy struct {
	ClusterDasAdmissionControlPolicy

	FailoverLevel int32                 `xml:"failoverLevel"`
	SlotPolicy    BaseClusterSlotPolicy `xml:"slotPolicy,omitempty,typeattr"`
}

func init() {
	t["ClusterFailoverLevelAdmissionControlPolicy"] = reflect.TypeOf((*ClusterFailoverLevelAdmissionControlPolicy)(nil)).Elem()
}

type ClusterFailoverResourcesAdmissionControlInfo struct {
	ClusterDasAdmissionControlInfo

	CurrentCpuFailoverResourcesPercent    int32 `xml:"currentCpuFailoverResourcesPercent"`
	CurrentMemoryFailoverResourcesPercent int32 `xml:"currentMemoryFailoverResourcesPercent"`
	CurrentPMemFailoverResourcesPercent   int32 `xml:"currentPMemFailoverResourcesPercent,omitempty"`
}

func init() {
	t["ClusterFailoverResourcesAdmissionControlInfo"] = reflect.TypeOf((*ClusterFailoverResourcesAdmissionControlInfo)(nil)).Elem()
}

type ClusterFailoverResourcesAdmissionControlPolicy struct {
	ClusterDasAdmissionControlPolicy

	CpuFailoverResourcesPercent             int32 `xml:"cpuFailoverResourcesPercent"`
	MemoryFailoverResourcesPercent          int32 `xml:"memoryFailoverResourcesPercent"`
	FailoverLevel                           int32 `xml:"failoverLevel,omitempty"`
	AutoComputePercentages                  *bool `xml:"autoComputePercentages"`
	PMemFailoverResourcesPercent            int32 `xml:"pMemFailoverResourcesPercent,omitempty"`
	AutoComputePMemFailoverResourcesPercent *bool `xml:"autoComputePMemFailoverResourcesPercent"`
}

func init() {
	t["ClusterFailoverResourcesAdmissionControlPolicy"] = reflect.TypeOf((*ClusterFailoverResourcesAdmissionControlPolicy)(nil)).Elem()
}

type ClusterFixedSizeSlotPolicy struct {
	ClusterSlotPolicy

	Cpu    int32 `xml:"cpu"`
	Memory int32 `xml:"memory"`
}

func init() {
	t["ClusterFixedSizeSlotPolicy"] = reflect.TypeOf((*ClusterFixedSizeSlotPolicy)(nil)).Elem()
}

type ClusterGroupInfo struct {
	DynamicData

	Name        string `xml:"name"`
	UserCreated *bool  `xml:"userCreated"`
	UniqueID    string `xml:"uniqueID,omitempty"`
}

func init() {
	t["ClusterGroupInfo"] = reflect.TypeOf((*ClusterGroupInfo)(nil)).Elem()
}

type ClusterGroupSpec struct {
	ArrayUpdateSpec

	Info BaseClusterGroupInfo `xml:"info,omitempty,typeattr"`
}

func init() {
	t["ClusterGroupSpec"] = reflect.TypeOf((*ClusterGroupSpec)(nil)).Elem()
}

type ClusterHostGroup struct {
	ClusterGroupInfo

	Host []ManagedObjectReference `xml:"host,omitempty"`
}

func init() {
	t["ClusterHostGroup"] = reflect.TypeOf((*ClusterHostGroup)(nil)).Elem()
}

type ClusterHostInfraUpdateHaModeAction struct {
	ClusterAction

	OperationType string `xml:"operationType"`
}

func init() {
	t["ClusterHostInfraUpdateHaModeAction"] = reflect.TypeOf((*ClusterHostInfraUpdateHaModeAction)(nil)).Elem()
}

type ClusterHostPowerAction struct {
	ClusterAction

	OperationType        HostPowerOperationType `xml:"operationType"`
	PowerConsumptionWatt int32                  `xml:"powerConsumptionWatt,omitempty"`
	CpuCapacityMHz       int32                  `xml:"cpuCapacityMHz,omitempty"`
	MemCapacityMB        int32                  `xml:"memCapacityMB,omitempty"`
}

func init() {
	t["ClusterHostPowerAction"] = reflect.TypeOf((*ClusterHostPowerAction)(nil)).Elem()
}

type ClusterHostRecommendation struct {
	DynamicData

	Host   ManagedObjectReference `xml:"host"`
	Rating int32                  `xml:"rating"`
}

func init() {
	t["ClusterHostRecommendation"] = reflect.TypeOf((*ClusterHostRecommendation)(nil)).Elem()
}

type ClusterInfraUpdateHaConfigInfo struct {
	DynamicData

	Enabled             *bool    `xml:"enabled"`
	Behavior            string   `xml:"behavior,omitempty"`
	ModerateRemediation string   `xml:"moderateRemediation,omitempty"`
	SevereRemediation   string   `xml:"severeRemediation,omitempty"`
	Providers           []string `xml:"providers,omitempty"`
}

func init() {
	t["ClusterInfraUpdateHaConfigInfo"] = reflect.TypeOf((*ClusterInfraUpdateHaConfigInfo)(nil)).Elem()
}

type ClusterInitialPlacementAction struct {
	ClusterAction

	TargetHost ManagedObjectReference  `xml:"targetHost"`
	Pool       *ManagedObjectReference `xml:"pool,omitempty"`
}

func init() {
	t["ClusterInitialPlacementAction"] = reflect.TypeOf((*ClusterInitialPlacementAction)(nil)).Elem()
}

type ClusterIoFilterInfo struct {
	IoFilterInfo

	OpType string `xml:"opType"`
	VibUrl string `xml:"vibUrl,omitempty"`
}

func init() {
	t["ClusterIoFilterInfo"] = reflect.TypeOf((*ClusterIoFilterInfo)(nil)).Elem()
}

type ClusterMigrationAction struct {
	ClusterAction

	DrsMigration *ClusterDrsMigration `xml:"drsMigration,omitempty"`
}

func init() {
	t["ClusterMigrationAction"] = reflect.TypeOf((*ClusterMigrationAction)(nil)).Elem()
}

type ClusterNetworkConfigSpec struct {
	DynamicData

	NetworkPortGroup ManagedObjectReference  `xml:"networkPortGroup"`
	IpSettings       CustomizationIPSettings `xml:"ipSettings"`
}

func init() {
	t["ClusterNetworkConfigSpec"] = reflect.TypeOf((*ClusterNetworkConfigSpec)(nil)).Elem()
}

type ClusterNotAttemptedVmInfo struct {
	DynamicData

	Vm    ManagedObjectReference `xml:"vm"`
	Fault LocalizedMethodFault   `xml:"fault"`
}

func init() {
	t["ClusterNotAttemptedVmInfo"] = reflect.TypeOf((*ClusterNotAttemptedVmInfo)(nil)).Elem()
}

type ClusterOrchestrationInfo struct {
	DynamicData

	DefaultVmReadiness *ClusterVmReadiness `xml:"defaultVmReadiness,omitempty"`
}

func init() {
	t["ClusterOrchestrationInfo"] = reflect.TypeOf((*ClusterOrchestrationInfo)(nil)).Elem()
}

type ClusterOvercommittedEvent struct {
	ClusterEvent
}

func init() {
	t["ClusterOvercommittedEvent"] = reflect.TypeOf((*ClusterOvercommittedEvent)(nil)).Elem()
}

type ClusterPowerOnVmResult struct {
	DynamicData

	Attempted       []ClusterAttemptedVmInfo    `xml:"attempted,omitempty"`
	NotAttempted    []ClusterNotAttemptedVmInfo `xml:"notAttempted,omitempty"`
	Recommendations []ClusterRecommendation     `xml:"recommendations,omitempty"`
}

func init() {
	t["ClusterPowerOnVmResult"] = reflect.TypeOf((*ClusterPowerOnVmResult)(nil)).Elem()
}

type ClusterProactiveDrsConfigInfo struct {
	DynamicData

	Enabled *bool `xml:"enabled"`
}

func init() {
	t["ClusterProactiveDrsConfigInfo"] = reflect.TypeOf((*ClusterProactiveDrsConfigInfo)(nil)).Elem()
}

type ClusterProfileCompleteConfigSpec struct {
	ClusterProfileConfigSpec

	ComplyProfile *ComplianceProfile `xml:"complyProfile,omitempty"`
}

func init() {
	t["ClusterProfileCompleteConfigSpec"] = reflect.TypeOf((*ClusterProfileCompleteConfigSpec)(nil)).Elem()
}

type ClusterProfileConfigInfo struct {
	ProfileConfigInfo

	ComplyProfile *ComplianceProfile `xml:"complyProfile,omitempty"`
}

func init() {
	t["ClusterProfileConfigInfo"] = reflect.TypeOf((*ClusterProfileConfigInfo)(nil)).Elem()
}

type ClusterProfileConfigServiceCreateSpec struct {
	ClusterProfileConfigSpec

	ServiceType []string `xml:"serviceType,omitempty"`
}

func init() {
	t["ClusterProfileConfigServiceCreateSpec"] = reflect.TypeOf((*ClusterProfileConfigServiceCreateSpec)(nil)).Elem()
}

type ClusterProfileConfigSpec struct {
	ClusterProfileCreateSpec
}

func init() {
	t["ClusterProfileConfigSpec"] = reflect.TypeOf((*ClusterProfileConfigSpec)(nil)).Elem()
}

type ClusterProfileCreateSpec struct {
	ProfileCreateSpec
}

func init() {
	t["ClusterProfileCreateSpec"] = reflect.TypeOf((*ClusterProfileCreateSpec)(nil)).Elem()
}

type ClusterRecommendation struct {
	DynamicData

	Key            string                  `xml:"key"`
	Type           string                  `xml:"type"`
	Time           time.Time               `xml:"time"`
	Rating         int32                   `xml:"rating"`
	Reason         string                  `xml:"reason"`
	ReasonText     string                  `xml:"reasonText"`
	WarningText    string                  `xml:"warningText,omitempty"`
	WarningDetails *LocalizableMessage     `xml:"warningDetails,omitempty"`
	Prerequisite   []string                `xml:"prerequisite,omitempty"`
	Action         []BaseClusterAction     `xml:"action,omitempty,typeattr"`
	Target         *ManagedObjectReference `xml:"target,omitempty"`
}

func init() {
	t["ClusterRecommendation"] = reflect.TypeOf((*ClusterRecommendation)(nil)).Elem()
}

type ClusterReconfiguredEvent struct {
	ClusterEvent

	ConfigChanges *ChangesInfoEventArgument `xml:"configChanges,omitempty"`
}

func init() {
	t["ClusterReconfiguredEvent"] = reflect.TypeOf((*ClusterReconfiguredEvent)(nil)).Elem()
}

type ClusterResourceUsageSummary struct {
	DynamicData

	CpuUsedMHz        int32 `xml:"cpuUsedMHz"`
	CpuCapacityMHz    int32 `xml:"cpuCapacityMHz"`
	MemUsedMB         int32 `xml:"memUsedMB"`
	MemCapacityMB     int32 `xml:"memCapacityMB"`
	PMemAvailableMB   int64 `xml:"pMemAvailableMB,omitempty"`
	PMemCapacityMB    int64 `xml:"pMemCapacityMB,omitempty"`
	StorageUsedMB     int64 `xml:"storageUsedMB"`
	StorageCapacityMB int64 `xml:"storageCapacityMB"`
}

func init() {
	t["ClusterResourceUsageSummary"] = reflect.TypeOf((*ClusterResourceUsageSummary)(nil)).Elem()
}

type ClusterRuleInfo struct {
	DynamicData

	Key          int32               `xml:"key,omitempty"`
	Status       ManagedEntityStatus `xml:"status,omitempty"`
	Enabled      *bool               `xml:"enabled"`
	Name         string              `xml:"name,omitempty"`
	Mandatory    *bool               `xml:"mandatory"`
	UserCreated  *bool               `xml:"userCreated"`
	InCompliance *bool               `xml:"inCompliance"`
	RuleUuid     string              `xml:"ruleUuid,omitempty"`
}

func init() {
	t["ClusterRuleInfo"] = reflect.TypeOf((*ClusterRuleInfo)(nil)).Elem()
}

type ClusterRuleSpec struct {
	ArrayUpdateSpec

	Info BaseClusterRuleInfo `xml:"info,omitempty,typeattr"`
}

func init() {
	t["ClusterRuleSpec"] = reflect.TypeOf((*ClusterRuleSpec)(nil)).Elem()
}

type ClusterSlotPolicy struct {
	DynamicData
}

func init() {
	t["ClusterSlotPolicy"] = reflect.TypeOf((*ClusterSlotPolicy)(nil)).Elem()
}

type ClusterStatusChangedEvent struct {
	ClusterEvent

	OldStatus string `xml:"oldStatus"`
	NewStatus string `xml:"newStatus"`
}

func init() {
	t["ClusterStatusChangedEvent"] = reflect.TypeOf((*ClusterStatusChangedEvent)(nil)).Elem()
}

type ClusterSystemVMsConfigInfo struct {
	DynamicData

	AllowedDatastores        []ManagedObjectReference `xml:"allowedDatastores,omitempty"`
	NotAllowedDatastores     []ManagedObjectReference `xml:"notAllowedDatastores,omitempty"`
	DsTagCategoriesToExclude []string                 `xml:"dsTagCategoriesToExclude,omitempty"`
}

func init() {
	t["ClusterSystemVMsConfigInfo"] = reflect.TypeOf((*ClusterSystemVMsConfigInfo)(nil)).Elem()
}

type ClusterSystemVMsConfigSpec struct {
	DynamicData

	AllowedDatastores        []ClusterDatastoreUpdateSpec   `xml:"allowedDatastores,omitempty"`
	NotAllowedDatastores     []ClusterDatastoreUpdateSpec   `xml:"notAllowedDatastores,omitempty"`
	DsTagCategoriesToExclude []ClusterTagCategoryUpdateSpec `xml:"dsTagCategoriesToExclude,omitempty"`
}

func init() {
	t["ClusterSystemVMsConfigSpec"] = reflect.TypeOf((*ClusterSystemVMsConfigSpec)(nil)).Elem()
}

type ClusterTagCategoryUpdateSpec struct {
	ArrayUpdateSpec

	Category string `xml:"category,omitempty"`
}

func init() {
	t["ClusterTagCategoryUpdateSpec"] = reflect.TypeOf((*ClusterTagCategoryUpdateSpec)(nil)).Elem()
}

type ClusterUsageSummary struct {
	DynamicData

	TotalCpuCapacityMhz         int32 `xml:"totalCpuCapacityMhz"`
	TotalMemCapacityMB          int32 `xml:"totalMemCapacityMB"`
	CpuReservationMhz           int32 `xml:"cpuReservationMhz"`
	MemReservationMB            int32 `xml:"memReservationMB"`
	PoweredOffCpuReservationMhz int32 `xml:"poweredOffCpuReservationMhz,omitempty"`
	PoweredOffMemReservationMB  int32 `xml:"poweredOffMemReservationMB,omitempty"`
	CpuDemandMhz                int32 `xml:"cpuDemandMhz"`
	MemDemandMB                 int32 `xml:"memDemandMB"`
	StatsGenNumber              int64 `xml:"statsGenNumber"`
	CpuEntitledMhz              int32 `xml:"cpuEntitledMhz"`
	MemEntitledMB               int32 `xml:"memEntitledMB"`
	PoweredOffVmCount           int32 `xml:"poweredOffVmCount"`
	TotalVmCount                int32 `xml:"totalVmCount"`
}

func init() {
	t["ClusterUsageSummary"] = reflect.TypeOf((*ClusterUsageSummary)(nil)).Elem()
}

type ClusterVmComponentProtectionSettings struct {
	DynamicData

	VmStorageProtectionForAPD string `xml:"vmStorageProtectionForAPD,omitempty"`
	EnableAPDTimeoutForHosts  *bool  `xml:"enableAPDTimeoutForHosts"`
	VmTerminateDelayForAPDSec int32  `xml:"vmTerminateDelayForAPDSec,omitempty"`
	VmReactionOnAPDCleared    string `xml:"vmReactionOnAPDCleared,omitempty"`
	VmStorageProtectionForPDL string `xml:"vmStorageProtectionForPDL,omitempty"`
}

func init() {
	t["ClusterVmComponentProtectionSettings"] = reflect.TypeOf((*ClusterVmComponentProtectionSettings)(nil)).Elem()
}

type ClusterVmGroup struct {
	ClusterGroupInfo

	Vm []ManagedObjectReference `xml:"vm,omitempty"`
}

func init() {
	t["ClusterVmGroup"] = reflect.TypeOf((*ClusterVmGroup)(nil)).Elem()
}

type ClusterVmHostRuleInfo struct {
	ClusterRuleInfo

	VmGroupName             string `xml:"vmGroupName,omitempty"`
	AffineHostGroupName     string `xml:"affineHostGroupName,omitempty"`
	AntiAffineHostGroupName string `xml:"antiAffineHostGroupName,omitempty"`
}

func init() {
	t["ClusterVmHostRuleInfo"] = reflect.TypeOf((*ClusterVmHostRuleInfo)(nil)).Elem()
}

type ClusterVmOrchestrationInfo struct {
	DynamicData

	Vm          ManagedObjectReference `xml:"vm"`
	VmReadiness ClusterVmReadiness     `xml:"vmReadiness"`
}

func init() {
	t["ClusterVmOrchestrationInfo"] = reflect.TypeOf((*ClusterVmOrchestrationInfo)(nil)).Elem()
}

type ClusterVmOrchestrationSpec struct {
	ArrayUpdateSpec

	Info *ClusterVmOrchestrationInfo `xml:"info,omitempty"`
}

func init() {
	t["ClusterVmOrchestrationSpec"] = reflect.TypeOf((*ClusterVmOrchestrationSpec)(nil)).Elem()
}

type ClusterVmReadiness struct {
	DynamicData

	ReadyCondition string `xml:"readyCondition,omitempty"`
	PostReadyDelay int32  `xml:"postReadyDelay,omitempty"`
}

func init() {
	t["ClusterVmReadiness"] = reflect.TypeOf((*ClusterVmReadiness)(nil)).Elem()
}

type ClusterVmToolsMonitoringSettings struct {
	DynamicData

	Enabled          *bool  `xml:"enabled"`
	VmMonitoring     string `xml:"vmMonitoring,omitempty"`
	ClusterSettings  *bool  `xml:"clusterSettings"`
	FailureInterval  int32  `xml:"failureInterval,omitempty"`
	MinUpTime        int32  `xml:"minUpTime,omitempty"`
	MaxFailures      int32  `xml:"maxFailures,omitempty"`
	MaxFailureWindow int32  `xml:"maxFailureWindow,omitempty"`
}

func init() {
	t["ClusterVmToolsMonitoringSettings"] = reflect.TypeOf((*ClusterVmToolsMonitoringSettings)(nil)).Elem()
}

type CollectorAddressUnset struct {
	DvsFault
}

func init() {
	t["CollectorAddressUnset"] = reflect.TypeOf((*CollectorAddressUnset)(nil)).Elem()
}

type CollectorAddressUnsetFault CollectorAddressUnset

func init() {
	t["CollectorAddressUnsetFault"] = reflect.TypeOf((*CollectorAddressUnsetFault)(nil)).Elem()
}

type ComplianceFailure struct {
	DynamicData

	FailureType    string                                     `xml:"failureType"`
	Message        LocalizableMessage                         `xml:"message"`
	ExpressionName string                                     `xml:"expressionName,omitempty"`
	FailureValues  []ComplianceFailureComplianceFailureValues `xml:"failureValues,omitempty"`
}

func init() {
	t["ComplianceFailure"] = reflect.TypeOf((*ComplianceFailure)(nil)).Elem()
}

type ComplianceFailureComplianceFailureValues struct {
	DynamicData

	ComparisonIdentifier string  `xml:"comparisonIdentifier"`
	ProfileInstance      string  `xml:"profileInstance,omitempty"`
	HostValue            AnyType `xml:"hostValue,omitempty,typeattr"`
	ProfileValue         AnyType `xml:"profileValue,omitempty,typeattr"`
}

func init() {
	t["ComplianceFailureComplianceFailureValues"] = reflect.TypeOf((*ComplianceFailureComplianceFailureValues)(nil)).Elem()
}

type ComplianceLocator struct {
	DynamicData

	ExpressionName string              `xml:"expressionName"`
	ApplyPath      ProfilePropertyPath `xml:"applyPath"`
}

func init() {
	t["ComplianceLocator"] = reflect.TypeOf((*ComplianceLocator)(nil)).Elem()
}

type ComplianceProfile struct {
	DynamicData

	Expression     []BaseProfileExpression `xml:"expression,typeattr"`
	RootExpression string                  `xml:"rootExpression"`
}

func init() {
	t["ComplianceProfile"] = reflect.TypeOf((*ComplianceProfile)(nil)).Elem()
}

type ComplianceResult struct {
	DynamicData

	Profile          *ManagedObjectReference `xml:"profile,omitempty"`
	ComplianceStatus string                  `xml:"complianceStatus"`
	Entity           *ManagedObjectReference `xml:"entity,omitempty"`
	CheckTime        *time.Time              `xml:"checkTime"`
	Failure          []ComplianceFailure     `xml:"failure,omitempty"`
}

func init() {
	t["ComplianceResult"] = reflect.TypeOf((*ComplianceResult)(nil)).Elem()
}

type CompositeHostProfileRequestType struct {
	This                   ManagedObjectReference   `xml:"_this"`
	Source                 ManagedObjectReference   `xml:"source"`
	Targets                []ManagedObjectReference `xml:"targets,omitempty"`
	ToBeMerged             *HostApplyProfile        `xml:"toBeMerged,omitempty"`
	ToBeReplacedWith       *HostApplyProfile        `xml:"toBeReplacedWith,omitempty"`
	ToBeDeleted            *HostApplyProfile        `xml:"toBeDeleted,omitempty"`
	EnableStatusToBeCopied *HostApplyProfile        `xml:"enableStatusToBeCopied,omitempty"`
}

func init() {
	t["CompositeHostProfileRequestType"] = reflect.TypeOf((*CompositeHostProfileRequestType)(nil)).Elem()
}

type CompositeHostProfile_Task CompositeHostProfileRequestType

func init() {
	t["CompositeHostProfile_Task"] = reflect.TypeOf((*CompositeHostProfile_Task)(nil)).Elem()
}

type CompositeHostProfile_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval"`
}

type CompositePolicyOption struct {
	PolicyOption

	Option []BasePolicyOption `xml:"option,omitempty,typeattr"`
}

func init() {
	t["CompositePolicyOption"] = reflect.TypeOf((*CompositePolicyOption)(nil)).Elem()
}

type ComputeDiskPartitionInfo ComputeDiskPartitionInfoRequestType

func init() {
	t["ComputeDiskPartitionInfo"] = reflect.TypeOf((*ComputeDiskPartitionInfo)(nil)).Elem()
}

type ComputeDiskPartitionInfoForResize ComputeDiskPartitionInfoForResizeRequestType

func init() {
	t["ComputeDiskPartitionInfoForResize"] = reflect.TypeOf((*ComputeDiskPartitionInfoForResize)(nil)).Elem()
}

type ComputeDiskPartitionInfoForResizeRequestType struct {
	This            ManagedObjectReference      `xml:"_this"`
	Partition       HostScsiDiskPartition       `xml:"partition"`
	BlockRange      HostDiskPartitionBlockRange `xml:"blockRange"`
	PartitionFormat string                      `xml:"partitionFormat,omitempty"`
}

func init() {
	t["ComputeDiskPartitionInfoForResizeRequestType"] = reflect.TypeOf((*ComputeDiskPartitionInfoForResizeRequestType)(nil)).Elem()
}

type ComputeDiskPartitionInfoForResizeResponse struct {
	Returnval HostDiskPartitionInfo `xml:"returnval"`
}

type ComputeDiskPartitionInfoRequestType struct {
	This            ManagedObjectReference  `xml:"_this"`
	DevicePath      string                  `xml:"devicePath"`
	Layout          HostDiskPartitionLayout `xml:"layout"`
	PartitionFormat string                  `xml:"partitionFormat,omitempty"`
}

func init() {
	t["ComputeDiskPartitionInfoRequestType"] = reflect.TypeOf((*ComputeDiskPartitionInfoRequestType)(nil)).Elem()
}

type ComputeDiskPartitionInfoResponse struct {
	Returnval HostDiskPartitionInfo `xml:"returnval"`
}

type ComputeResourceConfigInfo struct {
	DynamicData

	VmSwapPlacement           string `xml:"vmSwapPlacement"`
	SpbmEnabled               *bool  `xml:"spbmEnabled"`
	DefaultHardwareVersionKey string `xml:"defaultHardwareVersionKey,omitempty"`
	MaximumHardwareVersionKey string `xml:"maximumHardwareVersionKey,omitempty"`
}

func init() {
	t["ComputeResourceConfigInfo"] = reflect.TypeOf((*ComputeResourceConfigInfo)(nil)).Elem()
}

type ComputeResourceConfigSpec struct {
	DynamicData

	VmSwapPlacement           string               `xml:"vmSwapPlacement,omitempty"`
	SpbmEnabled               *bool                `xml:"spbmEnabled"`
	DefaultHardwareVersionKey string               `xml:"defaultHardwareVersionKey,omitempty"`
	DesiredSoftwareSpec       *DesiredSoftwareSpec `xml:"desiredSoftwareSpec,omitempty"`
	MaximumHardwareVersionKey string               `xml:"maximumHardwareVersionKey,omitempty"`
}

func init() {
	t["ComputeResourceConfigSpec"] = reflect.TypeOf((*ComputeResourceConfigSpec)(nil)).Elem()
}

type ComputeResourceEventArgument struct {
	EntityEventArgument

	ComputeResource ManagedObjectReference `xml:"computeResource"`
}

func init() {
	t["ComputeResourceEventArgument"] = reflect.TypeOf((*ComputeResourceEventArgument)(nil)).Elem()
}

type ComputeResourceHostSPBMLicenseInfo struct {
	DynamicData

	Host         ManagedObjectReference                                 `xml:"host"`
	LicenseState ComputeResourceHostSPBMLicenseInfoHostSPBMLicenseState `xml:"licenseState"`
}

func init() {
	t["ComputeResourceHostSPBMLicenseInfo"] = reflect.TypeOf((*ComputeResourceHostSPBMLicenseInfo)(nil)).Elem()
}

type ComputeResourceSummary struct {
	DynamicData

	TotalCpu          int32               `xml:"totalCpu"`
	TotalMemory       int64               `xml:"totalMemory"`
	NumCpuCores       int16               `xml:"numCpuCores"`
	NumCpuThreads     int16               `xml:"numCpuThreads"`
	EffectiveCpu      int32               `xml:"effectiveCpu"`
	EffectiveMemory   int64               `xml:"effectiveMemory"`
	NumHosts          int32               `xml:"numHosts"`
	NumEffectiveHosts int32               `xml:"numEffectiveHosts"`
	OverallStatus     ManagedEntityStatus `xml:"overallStatus"`
}

func init() {
	t["ComputeResourceSummary"] = reflect.TypeOf((*ComputeResourceSummary)(nil)).Elem()
}

type ConcurrentAccess struct {
	VimFault
}

func init() {
	t["ConcurrentAccess"] = reflect.TypeOf((*ConcurrentAccess)(nil)).Elem()
}

type ConcurrentAccessFault ConcurrentAccess

func init() {
	t["ConcurrentAccessFault"] = reflect.TypeOf((*ConcurrentAccessFault)(nil)).Elem()
}

type ConfigTarget struct {
	DynamicData

	NumCpus                                int32                                       `xml:"numCpus"`
	NumCpuCores                            int32                                       `xml:"numCpuCores"`
	NumNumaNodes                           int32                                       `xml:"numNumaNodes"`
	MaxCpusPerHost                         int32                                       `xml:"maxCpusPerHost,omitempty"`
	SmcPresent                             *bool                                       `xml:"smcPresent"`
	Datastore                              []VirtualMachineDatastoreInfo               `xml:"datastore,omitempty"`
	Network                                []VirtualMachineNetworkInfo                 `xml:"network,omitempty"`
	OpaqueNetwork                          []OpaqueNetworkTargetInfo                   `xml:"opaqueNetwork,omitempty"`
	DistributedVirtualPortgroup            []DistributedVirtualPortgroupInfo           `xml:"distributedVirtualPortgroup,omitempty"`
	DistributedVirtualSwitch               []DistributedVirtualSwitchInfo              `xml:"distributedVirtualSwitch,omitempty"`
	CdRom                                  []VirtualMachineCdromInfo                   `xml:"cdRom,omitempty"`
	Serial                                 []VirtualMachineSerialInfo                  `xml:"serial,omitempty"`
	Parallel                               []VirtualMachineParallelInfo                `xml:"parallel,omitempty"`
	Sound                                  []VirtualMachineSoundInfo                   `xml:"sound,omitempty"`
	Usb                                    []VirtualMachineUsbInfo                     `xml:"usb,omitempty"`
	Floppy                                 []VirtualMachineFloppyInfo                  `xml:"floppy,omitempty"`
	LegacyNetworkInfo                      []VirtualMachineLegacyNetworkSwitchInfo     `xml:"legacyNetworkInfo,omitempty"`
	ScsiPassthrough                        []VirtualMachineScsiPassthroughInfo         `xml:"scsiPassthrough,omitempty"`
	ScsiDisk                               []VirtualMachineScsiDiskDeviceInfo          `xml:"scsiDisk,omitempty"`
	IdeDisk                                []VirtualMachineIdeDiskDeviceInfo           `xml:"ideDisk,omitempty"`
	MaxMemMBOptimalPerf                    int32                                       `xml:"maxMemMBOptimalPerf"`
	SupportedMaxMemMB                      int32                                       `xml:"supportedMaxMemMB,omitempty"`
	ResourcePool                           *ResourcePoolRuntimeInfo                    `xml:"resourcePool,omitempty"`
	AutoVmotion                            *bool                                       `xml:"autoVmotion"`
	PciPassthrough                         []BaseVirtualMachinePciPassthroughInfo      `xml:"pciPassthrough,omitempty,typeattr"`
	Sriov                                  []VirtualMachineSriovInfo                   `xml:"sriov,omitempty"`
	VFlashModule                           []VirtualMachineVFlashModuleInfo            `xml:"vFlashModule,omitempty"`
	SharedGpuPassthroughTypes              []VirtualMachinePciSharedGpuPassthroughInfo `xml:"sharedGpuPassthroughTypes,omitempty"`
	AvailablePersistentMemoryReservationMB int64                                       `xml:"availablePersistentMemoryReservationMB,omitempty"`
	DynamicPassthrough                     []VirtualMachineDynamicPassthroughInfo      `xml:"dynamicPassthrough,omitempty"`
	SgxTargetInfo                          *VirtualMachineSgxTargetInfo                `xml:"sgxTargetInfo,omitempty"`
	PrecisionClockInfo                     []VirtualMachinePrecisionClockInfo          `xml:"precisionClockInfo,omitempty"`
	SevSupported                           *bool                                       `xml:"sevSupported"`
}

func init() {
	t["ConfigTarget"] = reflect.TypeOf((*ConfigTarget)(nil)).Elem()
}

type ConfigureCryptoKey ConfigureCryptoKeyRequestType

func init() {
	t["ConfigureCryptoKey"] = reflect.TypeOf((*ConfigureCryptoKey)(nil)).Elem()
}

type ConfigureCryptoKeyRequestType struct {
	This  ManagedObjectReference `xml:"_this"`
	KeyId *CryptoKeyId           `xml:"keyId,omitempty"`
}

func init() {
	t["ConfigureCryptoKeyRequestType"] = reflect.TypeOf((*ConfigureCryptoKeyRequestType)(nil)).Elem()
}

type ConfigureCryptoKeyResponse struct {
}

type ConfigureDatastoreIORMRequestType struct {
	This      ManagedObjectReference `xml:"_this"`
	Datastore ManagedObjectReference `xml:"datastore"`
	Spec      StorageIORMConfigSpec  `xml:"spec"`
}

func init() {
	t["ConfigureDatastoreIORMRequestType"] = reflect.TypeOf((*ConfigureDatastoreIORMRequestType)(nil)).Elem()
}

type ConfigureDatastoreIORM_Task ConfigureDatastoreIORMRequestType

func init() {
	t["ConfigureDatastoreIORM_Task"] = reflect.TypeOf((*ConfigureDatastoreIORM_Task)(nil)).Elem()
}

type ConfigureDatastoreIORM_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval"`
}

type ConfigureDatastorePrincipal ConfigureDatastorePrincipalRequestType

func init() {
	t["ConfigureDatastorePrincipal"] = reflect.TypeOf((*ConfigureDatastorePrincipal)(nil)).Elem()
}

type ConfigureDatastorePrincipalRequestType struct {
	This     ManagedObjectReference `xml:"_this"`
	UserName string                 `xml:"userName"`
	Password string                 `xml:"password,omitempty"`
}

func init() {
	t["ConfigureDatastorePrincipalRequestType"] = reflect.TypeOf((*ConfigureDatastorePrincipalRequestType)(nil)).Elem()
}

type ConfigureDatastorePrincipalResponse struct {
}

type ConfigureEvcModeRequestType struct {
	This               ManagedObjectReference `xml:"_this"`
	EvcModeKey         string                 `xml:"evcModeKey"`
	EvcGraphicsModeKey string                 `xml:"evcGraphicsModeKey,omitempty"`
}

func init() {
	t["ConfigureEvcModeRequestType"] = reflect.TypeOf((*ConfigureEvcModeRequestType)(nil)).Elem()
}

type ConfigureEvcMode_Task ConfigureEvcModeRequestType

func init() {
	t["ConfigureEvcMode_Task"] = reflect.TypeOf((*ConfigureEvcMode_Task)(nil)).Elem()
}

type ConfigureEvcMode_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval"`
}

type ConfigureHCIRequestType struct {
	This        ManagedObjectReference                         `xml:"_this"`
	ClusterSpec ClusterComputeResourceHCIConfigSpec            `xml:"clusterSpec"`
	HostInputs  []ClusterComputeResourceHostConfigurationInput `xml:"hostInputs,omitempty"`
}

func init() {
	t["ConfigureHCIRequestType"] = reflect.TypeOf((*ConfigureHCIRequestType)(nil)).Elem()
}

type ConfigureHCI_Task ConfigureHCIRequestType

func init() {
	t["ConfigureHCI_Task"] = reflect.TypeOf((*ConfigureHCI_Task)(nil)).Elem()
}

type ConfigureHCI_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval"`
}

type ConfigureHostCacheRequestType struct {
	This ManagedObjectReference     `xml:"_this"`
	Spec HostCacheConfigurationSpec `xml:"spec"`
}

func init() {
	t["ConfigureHostCacheRequestType"] = reflect.TypeOf((*ConfigureHostCacheRequestType)(nil)).Elem()
}

type ConfigureHostCache_Task ConfigureHostCacheRequestType

func init() {
	t["ConfigureHostCache_Task"] = reflect.TypeOf((*ConfigureHostCache_Task)(nil)).Elem()
}

type ConfigureHostCache_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval"`
}

type ConfigureLicenseSource ConfigureLicenseSourceRequestType

func init() {
	t["ConfigureLicenseSource"] = reflect.TypeOf((*ConfigureLicenseSource)(nil)).Elem()
}

type ConfigureLicenseSourceRequestType struct {
	This          ManagedObjectReference  `xml:"_this"`
	Host          *ManagedObjectReference `xml:"host,omitempty"`
	LicenseSource BaseLicenseSource       `xml:"licenseSource,typeattr"`
}

func init() {
	t["ConfigureLicenseSourceRequestType"] = reflect.TypeOf((*ConfigureLicenseSourceRequestType)(nil)).Elem()
}

type ConfigureLicenseSourceResponse struct {
}

type ConfigurePowerPolicy ConfigurePowerPolicyRequestType

func init() {
	t["ConfigurePowerPolicy"] = reflect.TypeOf((*ConfigurePowerPolicy)(nil)).Elem()
}

type ConfigurePowerPolicyRequestType struct {
	This ManagedObjectReference `xml:"_this"`
	Key  int32                  `xml:"key"`
}

func init() {
	t["ConfigurePowerPolicyRequestType"] = reflect.TypeOf((*ConfigurePowerPolicyRequestType)(nil)).Elem()
}

type ConfigurePowerPolicyResponse struct {
}

type ConfigureStorageDrsForPodRequestType struct {
	This   ManagedObjectReference `xml:"_this"`
	Pod    ManagedObjectReference `xml:"pod"`
	Spec   StorageDrsConfigSpec   `xml:"spec"`
	Modify bool                   `xml:"modify"`
}

func init() {
	t["ConfigureStorageDrsForPodRequestType"] = reflect.TypeOf((*ConfigureStorageDrsForPodRequestType)(nil)).Elem()
}

type ConfigureStorageDrsForPod_Task ConfigureStorageDrsForPodRequestType

func init() {
	t["ConfigureStorageDrsForPod_Task"] = reflect.TypeOf((*ConfigureStorageDrsForPod_Task)(nil)).Elem()
}

type ConfigureStorageDrsForPod_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval"`
}

type ConfigureVFlashResourceExRequestType struct {
	This       ManagedObjectReference `xml:"_this"`
	DevicePath []string               `xml:"devicePath,omitempty"`
}

func init() {
	t["ConfigureVFlashResourceExRequestType"] = reflect.TypeOf((*ConfigureVFlashResourceExRequestType)(nil)).Elem()
}

type ConfigureVFlashResourceEx_Task ConfigureVFlashResourceExRequestType

func init() {
	t["ConfigureVFlashResourceEx_Task"] = reflect.TypeOf((*ConfigureVFlashResourceEx_Task)(nil)).Elem()
}

type ConfigureVFlashResourceEx_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval"`
}

type ConflictingConfiguration struct {
	DvsFault

	ConfigInConflict []ConflictingConfigurationConfig `xml:"configInConflict"`
}

func init() {
	t["ConflictingConfiguration"] = reflect.TypeOf((*ConflictingConfiguration)(nil)).Elem()
}

type ConflictingConfigurationConfig struct {
	DynamicData

	Entity       *ManagedObjectReference `xml:"entity,omitempty"`
	PropertyPath string                  `xml:"propertyPath"`
}

func init() {
	t["ConflictingConfigurationConfig"] = reflect.TypeOf((*ConflictingConfigurationConfig)(nil)).Elem()
}

type ConflictingConfigurationFault ConflictingConfiguration

func init() {
	t["ConflictingConfigurationFault"] = reflect.TypeOf((*ConflictingConfigurationFault)(nil)).Elem()
}

type ConflictingDatastoreFound struct {
	RuntimeFault

	Name string `xml:"name"`
	Url  string `xml:"url"`
}

func init() {
	t["ConflictingDatastoreFound"] = reflect.TypeOf((*ConflictingDatastoreFound)(nil)).Elem()
}

type ConflictingDatastoreFoundFault ConflictingDatastoreFound

func init() {
	t["ConflictingDatastoreFoundFault"] = reflect.TypeOf((*ConflictingDatastoreFoundFault)(nil)).Elem()
}

type ConnectNvmeController ConnectNvmeControllerRequestType

func init() {
	t["ConnectNvmeController"] = reflect.TypeOf((*ConnectNvmeController)(nil)).Elem()
}

type ConnectNvmeControllerExRequestType struct {
	This        ManagedObjectReference `xml:"_this"`
	ConnectSpec []HostNvmeConnectSpec  `xml:"connectSpec,omitempty"`
}

func init() {
	t["ConnectNvmeControllerExRequestType"] = reflect.TypeOf((*ConnectNvmeControllerExRequestType)(nil)).Elem()
}

type ConnectNvmeControllerEx_Task ConnectNvmeControllerExRequestType

func init() {
	t["ConnectNvmeControllerEx_Task"] = reflect.TypeOf((*ConnectNvmeControllerEx_Task)(nil)).Elem()
}

type ConnectNvmeControllerEx_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval"`
}

type ConnectNvmeControllerRequestType struct {
	This        ManagedObjectReference `xml:"_this"`
	ConnectSpec HostNvmeConnectSpec    `xml:"connectSpec"`
}

func init() {
	t["ConnectNvmeControllerRequestType"] = reflect.TypeOf((*ConnectNvmeControllerRequestType)(nil)).Elem()
}

type ConnectNvmeControllerResponse struct {
}

type ConnectedIso struct {
	OvfExport

	Cdrom    VirtualCdrom `xml:"cdrom"`
	Filename string       `xml:"filename"`
}

func init() {
	t["ConnectedIso"] = reflect.TypeOf((*ConnectedIso)(nil)).Elem()
}

type ConnectedIsoFault ConnectedIso

func init() {
	t["ConnectedIsoFault"] = reflect.TypeOf((*ConnectedIsoFault)(nil)).Elem()
}

type ConsolidateVMDisksRequestType struct {
	This ManagedObjectReference `xml:"_this"`
}

func init() {
	t["ConsolidateVMDisksRequestType"] = reflect.TypeOf((*ConsolidateVMDisksRequestType)(nil)).Elem()
}

type ConsolidateVMDisks_Task ConsolidateVMDisksRequestType

func init() {
	t["ConsolidateVMDisks_Task"] = reflect.TypeOf((*ConsolidateVMDisks_Task)(nil)).Elem()
}

type ConsolidateVMDisks_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval"`
}

type ContinueRetrievePropertiesEx ContinueRetrievePropertiesExRequestType

func init() {
	t["ContinueRetrievePropertiesEx"] = reflect.TypeOf((*ContinueRetrievePropertiesEx)(nil)).Elem()
}

type ContinueRetrievePropertiesExRequestType struct {
	This  ManagedObjectReference `xml:"_this"`
	Token string                 `xml:"token"`
}

func init() {
	t["ContinueRetrievePropertiesExRequestType"] = reflect.TypeOf((*ContinueRetrievePropertiesExRequestType)(nil)).Elem()
}

type ContinueRetrievePropertiesExResponse struct {
	Returnval RetrieveResult `xml:"returnval"`
}

type ConvertNamespacePathToUuidPath ConvertNamespacePathToUuidPathRequestType

func init() {
	t["ConvertNamespacePathToUuidPath"] = reflect.TypeOf((*ConvertNamespacePathToUuidPath)(nil)).Elem()
}

type ConvertNamespacePathToUuidPathRequestType struct {
	This         ManagedObjectReference  `xml:"_this"`
	Datacenter   *ManagedObjectReference `xml:"datacenter,omitempty"`
	NamespaceUrl string                  `xml:"namespaceUrl"`
}

func init() {
	t["ConvertNamespacePathToUuidPathRequestType"] = reflect.TypeOf((*ConvertNamespacePathToUuidPathRequestType)(nil)).Elem()
}

type ConvertNamespacePathToUuidPathResponse struct {
	Returnval string `xml:"returnval"`
}

type CopyDatastoreFileRequestType struct {
	This                  ManagedObjectReference  `xml:"_this"`
	SourceName            string                  `xml:"sourceName"`
	SourceDatacenter      *ManagedObjectReference `xml:"sourceDatacenter,omitempty"`
	DestinationName       string                  `xml:"destinationName"`
	DestinationDatacenter *ManagedObjectReference `xml:"destinationDatacenter,omitempty"`
	Force                 *bool                   `xml:"force"`
}

func init() {
	t["CopyDatastoreFileRequestType"] = reflect.TypeOf((*CopyDatastoreFileRequestType)(nil)).Elem()
}

type CopyDatastoreFile_Task CopyDatastoreFileRequestType

func init() {
	t["CopyDatastoreFile_Task"] = reflect.TypeOf((*CopyDatastoreFile_Task)(nil)).Elem()
}

type CopyDatastoreFile_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval"`
}

type CopyVirtualDiskRequestType struct {
	This             ManagedObjectReference  `xml:"_this"`
	SourceName       string                  `xml:"sourceName"`
	SourceDatacenter *ManagedObjectReference `xml:"sourceDatacenter,omitempty"`
	DestName         string                  `xml:"destName"`
	DestDatacenter   *ManagedObjectReference `xml:"destDatacenter,omitempty"`
	DestSpec         BaseVirtualDiskSpec     `xml:"destSpec,omitempty,typeattr"`
	Force            *bool                   `xml:"force"`
}

func init() {
	t["CopyVirtualDiskRequestType"] = reflect.TypeOf((*CopyVirtualDiskRequestType)(nil)).Elem()
}

type CopyVirtualDisk_Task CopyVirtualDiskRequestType

func init() {
	t["CopyVirtualDisk_Task"] = reflect.TypeOf((*CopyVirtualDisk_Task)(nil)).Elem()
}

type CopyVirtualDisk_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval"`
}

type CpuCompatibilityUnknown struct {
	CpuIncompatible
}

func init() {
	t["CpuCompatibilityUnknown"] = reflect.TypeOf((*CpuCompatibilityUnknown)(nil)).Elem()
}

type CpuCompatibilityUnknownFault CpuCompatibilityUnknown

func init() {
	t["CpuCompatibilityUnknownFault"] = reflect.TypeOf((*CpuCompatibilityUnknownFault)(nil)).Elem()
}

type CpuHotPlugNotSupported struct {
	VmConfigFault
}

func init() {
	t["CpuHotPlugNotSupported"] = reflect.TypeOf((*CpuHotPlugNotSupported)(nil)).Elem()
}

type CpuHotPlugNotSupportedFault CpuHotPlugNotSupported

func init() {
	t["CpuHotPlugNotSupportedFault"] = reflect.TypeOf((*CpuHotPlugNotSupportedFault)(nil)).Elem()
}

type CpuIncompatible struct {
	VirtualHardwareCompatibilityIssue

	Level        int32                   `xml:"level"`
	RegisterName string                  `xml:"registerName"`
	RegisterBits string                  `xml:"registerBits,omitempty"`
	DesiredBits  string                  `xml:"desiredBits,omitempty"`
	Host         *ManagedObjectReference `xml:"host,omitempty"`
}

func init() {
	t["CpuIncompatible"] = reflect.TypeOf((*CpuIncompatible)(nil)).Elem()
}

type CpuIncompatible1ECX struct {
	CpuIncompatible

	Sse3      bool  `xml:"sse3"`
	Pclmulqdq *bool `xml:"pclmulqdq"`
	Ssse3     bool  `xml:"ssse3"`
	Sse41     bool  `xml:"sse41"`
	Sse42     bool  `xml:"sse42"`
	Aes       *bool `xml:"aes"`
	Other     bool  `xml:"other"`
	OtherOnly bool  `xml:"otherOnly"`
}

func init() {
	t["CpuIncompatible1ECX"] = reflect.TypeOf((*CpuIncompatible1ECX)(nil)).Elem()
}

type CpuIncompatible1ECXFault CpuIncompatible1ECX

func init() {
	t["CpuIncompatible1ECXFault"] = reflect.TypeOf((*CpuIncompatible1ECXFault)(nil)).Elem()
}

type CpuIncompatible81EDX struct {
	CpuIncompatible

	Nx        bool `xml:"nx"`
	Ffxsr     bool `xml:"ffxsr"`
	Rdtscp    bool `xml:"rdtscp"`
	Lm        bool `xml:"lm"`
	Other     bool `xml:"other"`
	OtherOnly bool `xml:"otherOnly"`
}

func init() {
	t["CpuIncompatible81EDX"] = reflect.TypeOf((*CpuIncompatible81EDX)(nil)).Elem()
}

type CpuIncompatible81EDXFault CpuIncompatible81EDX

func init() {
	t["CpuIncompatible81EDXFault"] = reflect.TypeOf((*CpuIncompatible81EDXFault)(nil)).Elem()
}

type CpuIncompatibleFault BaseCpuIncompatible

func init() {
	t["CpuIncompatibleFault"] = reflect.TypeOf((*CpuIncompatibleFault)(nil)).Elem()
}

type CreateAlarm CreateAlarmRequestType

func init() {
	t["CreateAlarm"] = reflect.TypeOf((*CreateAlarm)(nil)).Elem()
}

type CreateAlarmRequestType struct {
	This   ManagedObjectReference `xml:"_this"`
	Entity ManagedObjectReference `xml:"entity"`
	Spec   BaseAlarmSpec          `xml:"spec,typeattr"`
}

func init() {
	t["CreateAlarmRequestType"] = reflect.TypeOf((*CreateAlarmRequestType)(nil)).Elem()
}

type CreateAlarmResponse struct {
	Returnval ManagedObjectReference `xml:"returnval"`
}

type CreateChildVMRequestType struct {
	This   ManagedObjectReference   `xml:"_this"`
	Config VirtualMachineConfigSpec `xml:"config"`
	Host   *ManagedObjectReference  `xml:"host,omitempty"`
}

func init() {
	t["CreateChildVMRequestType"] = reflect.TypeOf((*CreateChildVMRequestType)(nil)).Elem()
}

type CreateChildVM_Task CreateChildVMRequestType

func init() {
	t["CreateChildVM_Task"] = reflect.TypeOf((*CreateChildVM_Task)(nil)).Elem()
}

type CreateChildVM_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval"`
}

type CreateCluster CreateClusterRequestType

func init() {
	t["CreateCluster"] = reflect.TypeOf((*CreateCluster)(nil)).Elem()
}

type CreateClusterEx CreateClusterExRequestType

func init() {
	t["CreateClusterEx"] = reflect.TypeOf((*CreateClusterEx)(nil)).Elem()
}

type CreateClusterExRequestType struct {
	This ManagedObjectReference `xml:"_this"`
	Name string                 `xml:"name"`
	Spec ClusterConfigSpecEx    `xml:"spec"`
}

func init() {
	t["CreateClusterExRequestType"] = reflect.TypeOf((*CreateClusterExRequestType)(nil)).Elem()
}

type CreateClusterExResponse struct {
	Returnval ManagedObjectReference `xml:"returnval"`
}

type CreateClusterRequestType struct {
	This ManagedObjectReference `xml:"_this"`
	Name string                 `xml:"name"`
	Spec ClusterConfigSpec      `xml:"spec"`
}

func init() {
	t["CreateClusterRequestType"] = reflect.TypeOf((*CreateClusterRequestType)(nil)).Elem()
}

type CreateClusterResponse struct {
	Returnval ManagedObjectReference `xml:"returnval"`
}

type CreateCollectorForEvents CreateCollectorForEventsRequestType

func init() {
	t["CreateCollectorForEvents"] = reflect.TypeOf((*CreateCollectorForEvents)(nil)).Elem()
}

type CreateCollectorForEventsRequestType struct {
	This   ManagedObjectReference `xml:"_this"`
	Filter EventFilterSpec        `xml:"filter"`
}

func init() {
	t["CreateCollectorForEventsRequestType"] = reflect.TypeOf((*CreateCollectorForEventsRequestType)(nil)).Elem()
}

type CreateCollectorForEventsResponse struct {
	Returnval ManagedObjectReference `xml:"returnval"`
}

type CreateCollectorForTasks CreateCollectorForTasksRequestType

func init() {
	t["CreateCollectorForTasks"] = reflect.TypeOf((*CreateCollectorForTasks)(nil)).Elem()
}

type CreateCollectorForTasksRequestType struct {
	This   ManagedObjectReference `xml:"_this"`
	Filter TaskFilterSpec         `xml:"filter"`
}

func init() {
	t["CreateCollectorForTasksRequestType"] = reflect.TypeOf((*CreateCollectorForTasksRequestType)(nil)).Elem()
}

type CreateCollectorForTasksResponse struct {
	Returnval ManagedObjectReference `xml:"returnval"`
}

type CreateContainerView CreateContainerViewRequestType

func init() {
	t["CreateContainerView"] = reflect.TypeOf((*CreateContainerView)(nil)).Elem()
}

type CreateContainerViewRequestType struct {
	This      ManagedObjectReference `xml:"_this"`
	Container ManagedObjectReference `xml:"container"`
	Type      []string               `xml:"type,omitempty"`
	Recursive bool                   `xml:"recursive"`
}

func init() {
	t["CreateContainerViewRequestType"] = reflect.TypeOf((*CreateContainerViewRequestType)(nil)).Elem()
}

type CreateContainerViewResponse struct {
	Returnval ManagedObjectReference `xml:"returnval"`
}

type CreateCustomizationSpec CreateCustomizationSpecRequestType

func init() {
	t["CreateCustomizationSpec"] = reflect.TypeOf((*CreateCustomizationSpec)(nil)).Elem()
}

type CreateCustomizationSpecRequestType struct {
	This ManagedObjectReference `xml:"_this"`
	Item CustomizationSpecItem  `xml:"item"`
}

func init() {
	t["CreateCustomizationSpecRequestType"] = reflect.TypeOf((*CreateCustomizationSpecRequestType)(nil)).Elem()
}

type CreateCustomizationSpecResponse struct {
}

type CreateDVPortgroupRequestType struct {
	This ManagedObjectReference `xml:"_this"`
	Spec DVPortgroupConfigSpec  `xml:"spec"`
}

func init() {
	t["CreateDVPortgroupRequestType"] = reflect.TypeOf((*CreateDVPortgroupRequestType)(nil)).Elem()
}

type CreateDVPortgroup_Task CreateDVPortgroupRequestType

func init() {
	t["CreateDVPortgroup_Task"] = reflect.TypeOf((*CreateDVPortgroup_Task)(nil)).Elem()
}

type CreateDVPortgroup_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval"`
}

type CreateDVSRequestType struct {
	This ManagedObjectReference `xml:"_this"`
	Spec DVSCreateSpec          `xml:"spec"`
}

func init() {
	t["CreateDVSRequestType"] = reflect.TypeOf((*CreateDVSRequestType)(nil)).Elem()
}

type CreateDVS_Task CreateDVSRequestType

func init() {
	t["CreateDVS_Task"] = reflect.TypeOf((*CreateDVS_Task)(nil)).Elem()
}

type CreateDVS_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval"`
}

type CreateDatacenter CreateDatacenterRequestType

func init() {
	t["CreateDatacenter"] = reflect.TypeOf((*CreateDatacenter)(nil)).Elem()
}

type CreateDatacenterRequestType struct {
	This ManagedObjectReference `xml:"_this"`
	Name string                 `xml:"name"`
}

func init() {
	t["CreateDatacenterRequestType"] = reflect.TypeOf((*CreateDatacenterRequestType)(nil)).Elem()
}

type CreateDatacenterResponse struct {
	Returnval ManagedObjectReference `xml:"returnval"`
}

type CreateDefaultProfile CreateDefaultProfileRequestType

func init() {
	t["CreateDefaultProfile"] = reflect.TypeOf((*CreateDefaultProfile)(nil)).Elem()
}

type CreateDefaultProfileRequestType struct {
	This            ManagedObjectReference  `xml:"_this"`
	ProfileType     string                  `xml:"profileType"`
	ProfileTypeName string                  `xml:"profileTypeName,omitempty"`
	Profile         *ManagedObjectReference `xml:"profile,omitempty"`
}

func init() {
	t["CreateDefaultProfileRequestType"] = reflect.TypeOf((*CreateDefaultProfileRequestType)(nil)).Elem()
}

type CreateDefaultProfileResponse struct {
	Returnval BaseApplyProfile `xml:"returnval,typeattr"`
}

type CreateDescriptor CreateDescriptorRequestType

func init() {
	t["CreateDescriptor"] = reflect.TypeOf((*CreateDescriptor)(nil)).Elem()
}

type CreateDescriptorRequestType struct {
	This ManagedObjectReference    `xml:"_this"`
	Obj  ManagedObjectReference    `xml:"obj"`
	Cdp  OvfCreateDescriptorParams `xml:"cdp"`
}

func init() {
	t["CreateDescriptorRequestType"] = reflect.TypeOf((*CreateDescriptorRequestType)(nil)).Elem()
}

type CreateDescriptorResponse struct {
	Returnval OvfCreateDescriptorResult `xml:"returnval"`
}

type CreateDiagnosticPartition CreateDiagnosticPartitionRequestType

func init() {
	t["CreateDiagnosticPartition"] = reflect.TypeOf((*CreateDiagnosticPartition)(nil)).Elem()
}

type CreateDiagnosticPartitionRequestType struct {
	This ManagedObjectReference            `xml:"_this"`
	Spec HostDiagnosticPartitionCreateSpec `xml:"spec"`
}

func init() {
	t["CreateDiagnosticPartitionRequestType"] = reflect.TypeOf((*CreateDiagnosticPartitionRequestType)(nil)).Elem()
}

type CreateDiagnosticPartitionResponse struct {
}

type CreateDirectory CreateDirectoryRequestType

func init() {
	t["CreateDirectory"] = reflect.TypeOf((*CreateDirectory)(nil)).Elem()
}

type CreateDirectoryRequestType struct {
	This        ManagedObjectReference `xml:"_this"`
	Datastore   ManagedObjectReference `xml:"datastore"`
	DisplayName string                 `xml:"displayName,omitempty"`
	Policy      string                 `xml:"policy,omitempty"`
	Size        int64                  `xml:"size,omitempty"`
}

func init() {
	t["CreateDirectoryRequestType"] = reflect.TypeOf((*CreateDirectoryRequestType)(nil)).Elem()
}

type CreateDirectoryResponse struct {
	Returnval string `xml:"returnval"`
}

type CreateDiskFromSnapshotRequestType struct {
	This       ManagedObjectReference          `xml:"_this"`
	Id         ID                              `xml:"id"`
	Datastore  ManagedObjectReference          `xml:"datastore"`
	SnapshotId ID                              `xml:"snapshotId"`
	Name       string                          `xml:"name"`
	Profile    []BaseVirtualMachineProfileSpec `xml:"profile,omitempty,typeattr"`
	Crypto     BaseCryptoSpec                  `xml:"crypto,omitempty,typeattr"`
	Path       string                          `xml:"path,omitempty"`
}

func init() {
	t["CreateDiskFromSnapshotRequestType"] = reflect.TypeOf((*CreateDiskFromSnapshotRequestType)(nil)).Elem()
}

type CreateDiskFromSnapshot_Task CreateDiskFromSnapshotRequestType

func init() {
	t["CreateDiskFromSnapshot_Task"] = reflect.TypeOf((*CreateDiskFromSnapshot_Task)(nil)).Elem()
}

type CreateDiskFromSnapshot_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval"`
}

type CreateDiskRequestType struct {
	This ManagedObjectReference `xml:"_this"`
	Spec VslmCreateSpec         `xml:"spec"`
}

func init() {
	t["CreateDiskRequestType"] = reflect.TypeOf((*CreateDiskRequestType)(nil)).Elem()
}

type CreateDisk_Task CreateDiskRequestType

func init() {
	t["CreateDisk_Task"] = reflect.TypeOf((*CreateDisk_Task)(nil)).Elem()
}

type CreateDisk_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval"`
}

type CreateFilter CreateFilterRequestType

func init() {
	t["CreateFilter"] = reflect.TypeOf((*CreateFilter)(nil)).Elem()
}

type CreateFilterRequestType struct {
	This           ManagedObjectReference `xml:"_this"`
	Spec           PropertyFilterSpec     `xml:"spec"`
	PartialUpdates bool                   `xml:"partialUpdates"`
}

func init() {
	t["CreateFilterRequestType"] = reflect.TypeOf((*CreateFilterRequestType)(nil)).Elem()
}

type CreateFilterResponse struct {
	Returnval ManagedObjectReference `xml:"returnval"`
}

type CreateFolder CreateFolderRequestType

func init() {
	t["CreateFolder"] = reflect.TypeOf((*CreateFolder)(nil)).Elem()
}

type CreateFolderRequestType struct {
	This ManagedObjectReference `xml:"_this"`
	Name string                 `xml:"name"`
}

func init() {
	t["CreateFolderRequestType"] = reflect.TypeOf((*CreateFolderRequestType)(nil)).Elem()
}

type CreateFolderResponse struct {
	Returnval ManagedObjectReference `xml:"returnval"`
}

type CreateGroup CreateGroupRequestType

func init() {
	t["CreateGroup"] = reflect.TypeOf((*CreateGroup)(nil)).Elem()
}

type CreateGroupRequestType struct {
	This  ManagedObjectReference `xml:"_this"`
	Group BaseHostAccountSpec    `xml:"group,typeattr"`
}

func init() {
	t["CreateGroupRequestType"] = reflect.TypeOf((*CreateGroupRequestType)(nil)).Elem()
}

type CreateGroupResponse struct {
}

type CreateImportSpec CreateImportSpecRequestType

func init() {
	t["CreateImportSpec"] = reflect.TypeOf((*CreateImportSpec)(nil)).Elem()
}

type CreateImportSpecRequestType struct {
	This          ManagedObjectReference    `xml:"_this"`
	OvfDescriptor string                    `xml:"ovfDescriptor"`
	ResourcePool  ManagedObjectReference    `xml:"resourcePool"`
	Datastore     ManagedObjectReference    `xml:"datastore"`
	Cisp          OvfCreateImportSpecParams `xml:"cisp"`
}

func init() {
	t["CreateImportSpecRequestType"] = reflect.TypeOf((*CreateImportSpecRequestType)(nil)).Elem()
}

type CreateImportSpecResponse struct {
	Returnval OvfCreateImportSpecResult `xml:"returnval"`
}

type CreateInventoryView CreateInventoryViewRequestType

func init() {
	t["CreateInventoryView"] = reflect.TypeOf((*CreateInventoryView)(nil)).Elem()
}

type CreateInventoryViewRequestType struct {
	This ManagedObjectReference `xml:"_this"`
}

func init() {
	t["CreateInventoryViewRequestType"] = reflect.TypeOf((*CreateInventoryViewRequestType)(nil)).Elem()
}

type CreateInventoryViewResponse struct {
	Returnval ManagedObjectReference `xml:"returnval"`
}

type CreateIpPool CreateIpPoolRequestType

func init() {
	t["CreateIpPool"] = reflect.TypeOf((*CreateIpPool)(nil)).Elem()
}

type CreateIpPoolRequestType struct {
	This ManagedObjectReference `xml:"_this"`
	Dc   ManagedObjectReference `xml:"dc"`
	Pool IpPool                 `xml:"pool"`
}

func init() {
	t["CreateIpPoolRequestType"] = reflect.TypeOf((*CreateIpPoolRequestType)(nil)).Elem()
}

type CreateIpPoolResponse struct {
	Returnval int32 `xml:"returnval"`
}

type CreateListView CreateListViewRequestType

func init() {
	t["CreateListView"] = reflect.TypeOf((*CreateListView)(nil)).Elem()
}

type CreateListViewFromView CreateListViewFromViewRequestType

func init() {
	t["CreateListViewFromView"] = reflect.TypeOf((*CreateListViewFromView)(nil)).Elem()
}

type CreateListViewFromViewRequestType struct {
	This ManagedObjectReference `xml:"_this"`
	View ManagedObjectReference `xml:"view"`
}

func init() {
	t["CreateListViewFromViewRequestType"] = reflect.TypeOf((*CreateListViewFromViewRequestType)(nil)).Elem()
}

type CreateListViewFromViewResponse struct {
	Returnval ManagedObjectReference `xml:"returnval"`
}

type CreateListViewRequestType struct {
	This ManagedObjectReference   `xml:"_this"`
	Obj  []ManagedObjectReference `xml:"obj,omitempty"`
}

func init() {
	t["CreateListViewRequestType"] = reflect.TypeOf((*CreateListViewRequestType)(nil)).Elem()
}

type CreateListViewResponse struct {
	Returnval ManagedObjectReference `xml:"returnval"`
}

type CreateLocalDatastore CreateLocalDatastoreRequestType

func init() {
	t["CreateLocalDatastore"] = reflect.TypeOf((*CreateLocalDatastore)(nil)).Elem()
}

type CreateLocalDatastoreRequestType struct {
	This ManagedObjectReference `xml:"_this"`
	Name string                 `xml:"name"`
	Path string                 `xml:"path"`
}

func init() {
	t["CreateLocalDatastoreRequestType"] = reflect.TypeOf((*CreateLocalDatastoreRequestType)(nil)).Elem()
}

type CreateLocalDatastoreResponse struct {
	Returnval ManagedObjectReference `xml:"returnval"`
}

type CreateNasDatastore CreateNasDatastoreRequestType

func init() {
	t["CreateNasDatastore"] = reflect.TypeOf((*CreateNasDatastore)(nil)).Elem()
}

type CreateNasDatastoreRequestType struct {
	This ManagedObjectReference `xml:"_this"`
	Spec HostNasVolumeSpec      `xml:"spec"`
}

func init() {
	t["CreateNasDatastoreRequestType"] = reflect.TypeOf((*CreateNasDatastoreRequestType)(nil)).Elem()
}

type CreateNasDatastoreResponse struct {
	Returnval ManagedObjectReference `xml:"returnval"`
}

type CreateNvdimmNamespaceRequestType struct {
	This       ManagedObjectReference    `xml:"_this"`
	CreateSpec NvdimmNamespaceCreateSpec `xml:"createSpec"`
}

func init() {
	t["CreateNvdimmNamespaceRequestType"] = reflect.TypeOf((*CreateNvdimmNamespaceRequestType)(nil)).Elem()
}

type CreateNvdimmNamespace_Task CreateNvdimmNamespaceRequestType

func init() {
	t["CreateNvdimmNamespace_Task"] = reflect.TypeOf((*CreateNvdimmNamespace_Task)(nil)).Elem()
}

type CreateNvdimmNamespace_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval"`
}

type CreateNvdimmPMemNamespaceRequestType struct {
	This       ManagedObjectReference        `xml:"_this"`
	CreateSpec NvdimmPMemNamespaceCreateSpec `xml:"createSpec"`
}

func init() {
	t["CreateNvdimmPMemNamespaceRequestType"] = reflect.TypeOf((*CreateNvdimmPMemNamespaceRequestType)(nil)).Elem()
}

type CreateNvdimmPMemNamespace_Task CreateNvdimmPMemNamespaceRequestType

func init() {
	t["CreateNvdimmPMemNamespace_Task"] = reflect.TypeOf((*CreateNvdimmPMemNamespace_Task)(nil)).Elem()
}

type CreateNvdimmPMemNamespace_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval"`
}

type CreateNvmeOverRdmaAdapter CreateNvmeOverRdmaAdapterRequestType

func init() {
	t["CreateNvmeOverRdmaAdapter"] = reflect.TypeOf((*CreateNvmeOverRdmaAdapter)(nil)).Elem()
}

type CreateNvmeOverRdmaAdapterRequestType struct {
	This           ManagedObjectReference `xml:"_this"`
	RdmaDeviceName string                 `xml:"rdmaDeviceName"`
}

func init() {
	t["CreateNvmeOverRdmaAdapterRequestType"] = reflect.TypeOf((*CreateNvmeOverRdmaAdapterRequestType)(nil)).Elem()
}

type CreateNvmeOverRdmaAdapterResponse struct {
}

type CreateObjectScheduledTask CreateObjectScheduledTaskRequestType

func init() {
	t["CreateObjectScheduledTask"] = reflect.TypeOf((*CreateObjectScheduledTask)(nil)).Elem()
}

type CreateObjectScheduledTaskRequestType struct {
	This ManagedObjectReference `xml:"_this"`
	Obj  ManagedObjectReference `xml:"obj"`
	Spec BaseScheduledTaskSpec  `xml:"spec,typeattr"`
}

func init() {
	t["CreateObjectScheduledTaskRequestType"] = reflect.TypeOf((*CreateObjectScheduledTaskRequestType)(nil)).Elem()
}

type CreateObjectScheduledTaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval"`
}

type CreatePerfInterval CreatePerfIntervalRequestType

func init() {
	t["CreatePerfInterval"] = reflect.TypeOf((*CreatePerfInterval)(nil)).Elem()
}

type CreatePerfIntervalRequestType struct {
	This       ManagedObjectReference `xml:"_this"`
	IntervalId PerfInterval           `xml:"intervalId"`
}

func init() {
	t["CreatePerfIntervalRequestType"] = reflect.TypeOf((*CreatePerfIntervalRequestType)(nil)).Elem()
}

type CreatePerfIntervalResponse struct {
}

type CreateProfile CreateProfileRequestType

func init() {
	t["CreateProfile"] = reflect.TypeOf((*CreateProfile)(nil)).Elem()
}

type CreateProfileRequestType struct {
	This       ManagedObjectReference `xml:"_this"`
	CreateSpec BaseProfileCreateSpec  `xml:"createSpec,typeattr"`
}

func init() {
	t["CreateProfileRequestType"] = reflect.TypeOf((*CreateProfileRequestType)(nil)).Elem()
}

type CreateProfileResponse struct {
	Returnval ManagedObjectReference `xml:"returnval"`
}

type CreatePropertyCollector CreatePropertyCollectorRequestType

func init() {
	t["CreatePropertyCollector"] = reflect.TypeOf((*CreatePropertyCollector)(nil)).Elem()
}

type CreatePropertyCollectorRequestType struct {
	This ManagedObjectReference `xml:"_this"`
}

func init() {
	t["CreatePropertyCollectorRequestType"] = reflect.TypeOf((*CreatePropertyCollectorRequestType)(nil)).Elem()
}

type CreatePropertyCollectorResponse struct {
	Returnval ManagedObjectReference `xml:"returnval"`
}

type CreateRegistryKeyInGuest CreateRegistryKeyInGuestRequestType

func init() {
	t["CreateRegistryKeyInGuest"] = reflect.TypeOf((*CreateRegistryKeyInGuest)(nil)).Elem()
}

type CreateRegistryKeyInGuestRequestType struct {
	This       ManagedObjectReference  `xml:"_this"`
	Vm         ManagedObjectReference  `xml:"vm"`
	Auth       BaseGuestAuthentication `xml:"auth,typeattr"`
	KeyName    GuestRegKeyNameSpec     `xml:"keyName"`
	IsVolatile bool                    `xml:"isVolatile"`
	ClassType  string                  `xml:"classType,omitempty"`
}

func init() {
	t["CreateRegistryKeyInGuestRequestType"] = reflect.TypeOf((*CreateRegistryKeyInGuestRequestType)(nil)).Elem()
}

type CreateRegistryKeyInGuestResponse struct {
}

type CreateResourcePool CreateResourcePoolRequestType

func init() {
	t["CreateResourcePool"] = reflect.TypeOf((*CreateResourcePool)(nil)).Elem()
}

type CreateResourcePoolRequestType struct {
	This ManagedObjectReference `xml:"_this"`
	Name string                 `xml:"name"`
	Spec ResourceConfigSpec     `xml:"spec"`
}

func init() {
	t["CreateResourcePoolRequestType"] = reflect.TypeOf((*CreateResourcePoolRequestType)(nil)).Elem()
}

type CreateResourcePoolResponse struct {
	Returnval ManagedObjectReference `xml:"returnval"`
}

type CreateScheduledTask CreateScheduledTaskRequestType

func init() {
	t["CreateScheduledTask"] = reflect.TypeOf((*CreateScheduledTask)(nil)).Elem()
}

type CreateScheduledTaskRequestType struct {
	This   ManagedObjectReference `xml:"_this"`
	Entity ManagedObjectReference `xml:"entity"`
	Spec   BaseScheduledTaskSpec  `xml:"spec,typeattr"`
}

func init() {
	t["CreateScheduledTaskRequestType"] = reflect.TypeOf((*CreateScheduledTaskRequestType)(nil)).Elem()
}

type CreateScheduledTaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval"`
}

type CreateScreenshotRequestType struct {
	This ManagedObjectReference `xml:"_this"`
}

func init() {
	t["CreateScreenshotRequestType"] = reflect.TypeOf((*CreateScreenshotRequestType)(nil)).Elem()
}

type CreateScreenshot_Task CreateScreenshotRequestType

func init() {
	t["CreateScreenshot_Task"] = reflect.TypeOf((*CreateScreenshot_Task)(nil)).Elem()
}

type CreateScreenshot_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval"`
}

type CreateSecondaryVMExRequestType struct {
	This ManagedObjectReference    `xml:"_this"`
	Host *ManagedObjectReference   `xml:"host,omitempty"`
	Spec *FaultToleranceConfigSpec `xml:"spec,omitempty"`
}

func init() {
	t["CreateSecondaryVMExRequestType"] = reflect.TypeOf((*CreateSecondaryVMExRequestType)(nil)).Elem()
}

type CreateSecondaryVMEx_Task CreateSecondaryVMExRequestType

func init() {
	t["CreateSecondaryVMEx_Task"] = reflect.TypeOf((*CreateSecondaryVMEx_Task)(nil)).Elem()
}

type CreateSecondaryVMEx_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval"`
}

type CreateSecondaryVMRequestType struct {
	This ManagedObjectReference  `xml:"_this"`
	Host *ManagedObjectReference `xml:"host,omitempty"`
}

func init() {
	t["CreateSecondaryVMRequestType"] = reflect.TypeOf((*CreateSecondaryVMRequestType)(nil)).Elem()
}

type CreateSecondaryVM_Task CreateSecondaryVMRequestType

func init() {
	t["CreateSecondaryVM_Task"] = reflect.TypeOf((*CreateSecondaryVM_Task)(nil)).Elem()
}

type CreateSecondaryVM_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval"`
}

type CreateSnapshotExRequestType struct {
	This        ManagedObjectReference             `xml:"_this"`
	Name        string                             `xml:"name"`
	Description string                             `xml:"description,omitempty"`
	Memory      bool                               `xml:"memory"`
	QuiesceSpec BaseVirtualMachineGuestQuiesceSpec `xml:"quiesceSpec,omitempty,typeattr"`
}

func init() {
	t["CreateSnapshotExRequestType"] = reflect.TypeOf((*CreateSnapshotExRequestType)(nil)).Elem()
}

type CreateSnapshotEx_Task CreateSnapshotExRequestType

func init() {
	t["CreateSnapshotEx_Task"] = reflect.TypeOf((*CreateSnapshotEx_Task)(nil)).Elem()
}

type CreateSnapshotEx_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval"`
}

type CreateSnapshotRequestType struct {
	This        ManagedObjectReference `xml:"_this"`
	Name        string                 `xml:"name"`
	Description string                 `xml:"description,omitempty"`
	Memory      bool                   `xml:"memory"`
	Quiesce     bool                   `xml:"quiesce"`
}

func init() {
	t["CreateSnapshotRequestType"] = reflect.TypeOf((*CreateSnapshotRequestType)(nil)).Elem()
}

type CreateSnapshot_Task CreateSnapshotRequestType

func init() {
	t["CreateSnapshot_Task"] = reflect.TypeOf((*CreateSnapshot_Task)(nil)).Elem()
}

type CreateSnapshot_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval"`
}

type CreateSoftwareAdapter CreateSoftwareAdapterRequestType

func init() {
	t["CreateSoftwareAdapter"] = reflect.TypeOf((*CreateSoftwareAdapter)(nil)).Elem()
}

type CreateSoftwareAdapterRequestType struct {
	This ManagedObjectReference `xml:"_this"`
	Spec BaseHostHbaCreateSpec  `xml:"spec,typeattr"`
}

func init() {
	t["CreateSoftwareAdapterRequestType"] = reflect.TypeOf((*CreateSoftwareAdapterRequestType)(nil)).Elem()
}

type CreateSoftwareAdapterResponse struct {
}

type CreateStoragePod CreateStoragePodRequestType

func init() {
	t["CreateStoragePod"] = reflect.TypeOf((*CreateStoragePod)(nil)).Elem()
}

type CreateStoragePodRequestType struct {
	This ManagedObjectReference `xml:"_this"`
	Name string                 `xml:"name"`
}

func init() {
	t["CreateStoragePodRequestType"] = reflect.TypeOf((*CreateStoragePodRequestType)(nil)).Elem()
}

type CreateStoragePodResponse struct {
	Returnval ManagedObjectReference `xml:"returnval"`
}

type CreateTask CreateTaskRequestType

func init() {
	t["CreateTask"] = reflect.TypeOf((*CreateTask)(nil)).Elem()
}

type CreateTaskAction struct {
	Action

	TaskTypeId string `xml:"taskTypeId"`
	Cancelable bool   `xml:"cancelable"`
}

func init() {
	t["CreateTaskAction"] = reflect.TypeOf((*CreateTaskAction)(nil)).Elem()
}

type CreateTaskRequestType struct {
	This          ManagedObjectReference `xml:"_this"`
	Obj           ManagedObjectReference `xml:"obj"`
	TaskTypeId    string                 `xml:"taskTypeId"`
	InitiatedBy   string                 `xml:"initiatedBy,omitempty"`
	Cancelable    bool                   `xml:"cancelable"`
	ParentTaskKey string                 `xml:"parentTaskKey,omitempty"`
	ActivationId  string                 `xml:"activationId,omitempty"`
}

func init() {
	t["CreateTaskRequestType"] = reflect.TypeOf((*CreateTaskRequestType)(nil)).Elem()
}

type CreateTaskResponse struct {
	Returnval TaskInfo `xml:"returnval"`
}

type CreateTemporaryDirectoryInGuest CreateTemporaryDirectoryInGuestRequestType

func init() {
	t["CreateTemporaryDirectoryInGuest"] = reflect.TypeOf((*CreateTemporaryDirectoryInGuest)(nil)).Elem()
}

type CreateTemporaryDirectoryInGuestRequestType struct {
	This          ManagedObjectReference  `xml:"_this"`
	Vm            ManagedObjectReference  `xml:"vm"`
	Auth          BaseGuestAuthentication `xml:"auth,typeattr"`
	Prefix        string                  `xml:"prefix"`
	Suffix        string                  `xml:"suffix"`
	DirectoryPath string                  `xml:"directoryPath,omitempty"`
}

func init() {
	t["CreateTemporaryDirectoryInGuestRequestType"] = reflect.TypeOf((*CreateTemporaryDirectoryInGuestRequestType)(nil)).Elem()
}

type CreateTemporaryDirectoryInGuestResponse struct {
	Returnval string `xml:"returnval"`
}

type CreateTemporaryFileInGuest CreateTemporaryFileInGuestRequestType

func init() {
	t["CreateTemporaryFileInGuest"] = reflect.TypeOf((*CreateTemporaryFileInGuest)(nil)).Elem()
}

type CreateTemporaryFileInGuestRequestType struct {
	This          ManagedObjectReference  `xml:"_this"`
	Vm            ManagedObjectReference  `xml:"vm"`
	Auth          BaseGuestAuthentication `xml:"auth,typeattr"`
	Prefix        string                  `xml:"prefix"`
	Suffix        string                  `xml:"suffix"`
	DirectoryPath string                  `xml:"directoryPath,omitempty"`
}

func init() {
	t["CreateTemporaryFileInGuestRequestType"] = reflect.TypeOf((*CreateTemporaryFileInGuestRequestType)(nil)).Elem()
}

type CreateTemporaryFileInGuestResponse struct {
	Returnval string `xml:"returnval"`
}

type CreateUser CreateUserRequestType

func init() {
	t["CreateUser"] = reflect.TypeOf((*CreateUser)(nil)).Elem()
}

type CreateUserRequestType struct {
	This ManagedObjectReference `xml:"_this"`
	User BaseHostAccountSpec    `xml:"user,typeattr"`
}

func init() {
	t["CreateUserRequestType"] = reflect.TypeOf((*CreateUserRequestType)(nil)).Elem()
}

type CreateUserResponse struct {
}

type CreateVApp CreateVAppRequestType

func init() {
	t["CreateVApp"] = reflect.TypeOf((*CreateVApp)(nil)).Elem()
}

type CreateVAppRequestType struct {
	This       ManagedObjectReference  `xml:"_this"`
	Name       string                  `xml:"name"`
	ResSpec    ResourceConfigSpec      `xml:"resSpec"`
	ConfigSpec VAppConfigSpec          `xml:"configSpec"`
	VmFolder   *ManagedObjectReference `xml:"vmFolder,omitempty"`
}

func init() {
	t["CreateVAppRequestType"] = reflect.TypeOf((*CreateVAppRequestType)(nil)).Elem()
}

type CreateVAppResponse struct {
	Returnval ManagedObjectReference `xml:"returnval"`
}

type CreateVMRequestType struct {
	This   ManagedObjectReference   `xml:"_this"`
	Config VirtualMachineConfigSpec `xml:"config"`
	Pool   ManagedObjectReference   `xml:"pool"`
	Host   *ManagedObjectReference  `xml:"host,omitempty"`
}

func init() {
	t["CreateVMRequestType"] = reflect.TypeOf((*CreateVMRequestType)(nil)).Elem()
}

type CreateVM_Task CreateVMRequestType

func init() {
	t["CreateVM_Task"] = reflect.TypeOf((*CreateVM_Task)(nil)).Elem()
}

type CreateVM_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval"`
}

type CreateVirtualDiskRequestType struct {
	This       ManagedObjectReference  `xml:"_this"`
	Name       string                  `xml:"name"`
	Datacenter *ManagedObjectReference `xml:"datacenter,omitempty"`
	Spec       BaseVirtualDiskSpec     `xml:"spec,typeattr"`
}

func init() {
	t["CreateVirtualDiskRequestType"] = reflect.TypeOf((*CreateVirtualDiskRequestType)(nil)).Elem()
}

type CreateVirtualDisk_Task CreateVirtualDiskRequestType

func init() {
	t["CreateVirtualDisk_Task"] = reflect.TypeOf((*CreateVirtualDisk_Task)(nil)).Elem()
}

type CreateVirtualDisk_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval"`
}

type CreateVmfsDatastore CreateVmfsDatastoreRequestType

func init() {
	t["CreateVmfsDatastore"] = reflect.TypeOf((*CreateVmfsDatastore)(nil)).Elem()
}

type CreateVmfsDatastoreRequestType struct {
	This ManagedObjectReference  `xml:"_this"`
	Spec VmfsDatastoreCreateSpec `xml:"spec"`
}

func init() {
	t["CreateVmfsDatastoreRequestType"] = reflect.TypeOf((*CreateVmfsDatastoreRequestType)(nil)).Elem()
}

type CreateVmfsDatastoreResponse struct {
	Returnval ManagedObjectReference `xml:"returnval"`
}

type CreateVvolDatastore CreateVvolDatastoreRequestType

func init() {
	t["CreateVvolDatastore"] = reflect.TypeOf((*CreateVvolDatastore)(nil)).Elem()
}

type CreateVvolDatastoreRequestType struct {
	This ManagedObjectReference               `xml:"_this"`
	Spec HostDatastoreSystemVvolDatastoreSpec `xml:"spec"`
}

func init() {
	t["CreateVvolDatastoreRequestType"] = reflect.TypeOf((*CreateVvolDatastoreRequestType)(nil)).Elem()
}

type CreateVvolDatastoreResponse struct {
	Returnval ManagedObjectReference `xml:"returnval"`
}

type CryptoKeyId struct {
	DynamicData

	KeyId      string         `xml:"keyId"`
	ProviderId *KeyProviderId `xml:"providerId,omitempty"`
}

func init() {
	t["CryptoKeyId"] = reflect.TypeOf((*CryptoKeyId)(nil)).Elem()
}

type CryptoKeyPlain struct {
	DynamicData

	KeyId     CryptoKeyId `xml:"keyId"`
	Algorithm string      `xml:"algorithm"`
	KeyData   string      `xml:"keyData"`
}

func init() {
	t["CryptoKeyPlain"] = reflect.TypeOf((*CryptoKeyPlain)(nil)).Elem()
}

type CryptoKeyResult struct {
	DynamicData

	KeyId   CryptoKeyId           `xml:"keyId"`
	Success bool                  `xml:"success"`
	Reason  string                `xml:"reason,omitempty"`
	Fault   *LocalizedMethodFault `xml:"fault,omitempty"`
}

func init() {
	t["CryptoKeyResult"] = reflect.TypeOf((*CryptoKeyResult)(nil)).Elem()
}

type CryptoManagerHostDisable CryptoManagerHostDisableRequestType

func init() {
	t["CryptoManagerHostDisable"] = reflect.TypeOf((*CryptoManagerHostDisable)(nil)).Elem()
}

type CryptoManagerHostDisableRequestType struct {
	This ManagedObjectReference `xml:"_this"`
}

func init() {
	t["CryptoManagerHostDisableRequestType"] = reflect.TypeOf((*CryptoManagerHostDisableRequestType)(nil)).Elem()
}

type CryptoManagerHostDisableResponse struct {
}

type CryptoManagerHostEnable CryptoManagerHostEnableRequestType

func init() {
	t["CryptoManagerHostEnable"] = reflect.TypeOf((*CryptoManagerHostEnable)(nil)).Elem()
}

type CryptoManagerHostEnableRequestType struct {
	This       ManagedObjectReference `xml:"_this"`
	InitialKey CryptoKeyPlain         `xml:"initialKey"`
}

func init() {
	t["CryptoManagerHostEnableRequestType"] = reflect.TypeOf((*CryptoManagerHostEnableRequestType)(nil)).Elem()
}

type CryptoManagerHostEnableResponse struct {
}

type CryptoManagerHostPrepare CryptoManagerHostPrepareRequestType

func init() {
	t["CryptoManagerHostPrepare"] = reflect.TypeOf((*CryptoManagerHostPrepare)(nil)).Elem()
}

type CryptoManagerHostPrepareRequestType struct {
	This ManagedObjectReference `xml:"_this"`
}

func init() {
	t["CryptoManagerHostPrepareRequestType"] = reflect.TypeOf((*CryptoManagerHostPrepareRequestType)(nil)).Elem()
}

type CryptoManagerHostPrepareResponse struct {
}

type CryptoManagerKmipCertificateInfo struct {
	DynamicData

	Subject             string    `xml:"subject"`
	Issuer              string    `xml:"issuer"`
	SerialNumber        string    `xml:"serialNumber"`
	NotBefore           time.Time `xml:"notBefore"`
	NotAfter            time.Time `xml:"notAfter"`
	Fingerprint         string    `xml:"fingerprint"`
	CheckTime           time.Time `xml:"checkTime"`
	SecondsSinceValid   int32     `xml:"secondsSinceValid,omitempty"`
	SecondsBeforeExpire int32     `xml:"secondsBeforeExpire,omitempty"`
}

func init() {
	t["CryptoManagerKmipCertificateInfo"] = reflect.TypeOf((*CryptoManagerKmipCertificateInfo)(nil)).Elem()
}

type CryptoManagerKmipClusterStatus struct {
	DynamicData

	ClusterId      KeyProviderId                     `xml:"clusterId"`
	OverallStatus  ManagedEntityStatus               `xml:"overallStatus,omitempty"`
	ManagementType string                            `xml:"managementType,omitempty"`
	Servers        []CryptoManagerKmipServerStatus   `xml:"servers"`
	ClientCertInfo *CryptoManagerKmipCertificateInfo `xml:"clientCertInfo,omitempty"`
}

func init() {
	t["CryptoManagerKmipClusterStatus"] = reflect.TypeOf((*CryptoManagerKmipClusterStatus)(nil)).Elem()
}

type CryptoManagerKmipCryptoKeyStatus struct {
	DynamicData

	KeyId            CryptoKeyId              `xml:"keyId"`
	KeyAvailable     *bool                    `xml:"keyAvailable"`
	Reason           string                   `xml:"reason,omitempty"`
	EncryptedVMs     []ManagedObjectReference `xml:"encryptedVMs,omitempty"`
	AffectedHosts    []ManagedObjectReference `xml:"affectedHosts,omitempty"`
	ReferencedByTags []string                 `xml:"referencedByTags,omitempty"`
}

func init() {
	t["CryptoManagerKmipCryptoKeyStatus"] = reflect.TypeOf((*CryptoManagerKmipCryptoKeyStatus)(nil)).Elem()
}

type CryptoManagerKmipServerCertInfo struct {
	DynamicData

	Certificate       string                            `xml:"certificate"`
	CertInfo          *CryptoManagerKmipCertificateInfo `xml:"certInfo,omitempty"`
	ClientTrustServer *bool                             `xml:"clientTrustServer"`
}

func init() {
	t["CryptoManagerKmipServerCertInfo"] = reflect.TypeOf((*CryptoManagerKmipServerCertInfo)(nil)).Elem()
}

type CryptoManagerKmipServerStatus struct {
	DynamicData

	Name              string                            `xml:"name"`
	Status            ManagedEntityStatus               `xml:"status"`
	ConnectionStatus  string                            `xml:"connectionStatus"`
	CertInfo          *CryptoManagerKmipCertificateInfo `xml:"certInfo,omitempty"`
	ClientTrustServer *bool                             `xml:"clientTrustServer"`
	ServerTrustClient *bool                             `xml:"serverTrustClient"`
}

func init() {
	t["CryptoManagerKmipServerStatus"] = reflect.TypeOf((*CryptoManagerKmipServerStatus)(nil)).Elem()
}

type CryptoSpec struct {
	DynamicData
}

func init() {
	t["CryptoSpec"] = reflect.TypeOf((*CryptoSpec)(nil)).Elem()
}

type CryptoSpecDecrypt struct {
	CryptoSpec
}

func init() {
	t["CryptoSpecDecrypt"] = reflect.TypeOf((*CryptoSpecDecrypt)(nil)).Elem()
}

type CryptoSpecDeepRecrypt struct {
	CryptoSpec

	NewKeyId CryptoKeyId `xml:"newKeyId"`
}

func init() {
	t["CryptoSpecDeepRecrypt"] = reflect.TypeOf((*CryptoSpecDeepRecrypt)(nil)).Elem()
}

type CryptoSpecEncrypt struct {
	CryptoSpec

	CryptoKeyId CryptoKeyId `xml:"cryptoKeyId"`
}

func init() {
	t["CryptoSpecEncrypt"] = reflect.TypeOf((*CryptoSpecEncrypt)(nil)).Elem()
}

type CryptoSpecNoOp struct {
	CryptoSpec
}

func init() {
	t["CryptoSpecNoOp"] = reflect.TypeOf((*CryptoSpecNoOp)(nil)).Elem()
}

type CryptoSpecRegister struct {
	CryptoSpecNoOp

	CryptoKeyId CryptoKeyId `xml:"cryptoKeyId"`
}

func init() {
	t["CryptoSpecRegister"] = reflect.TypeOf((*CryptoSpecRegister)(nil)).Elem()
}

type CryptoSpecShallowRecrypt struct {
	CryptoSpec

	NewKeyId CryptoKeyId `xml:"newKeyId"`
}

func init() {
	t["CryptoSpecShallowRecrypt"] = reflect.TypeOf((*CryptoSpecShallowRecrypt)(nil)).Elem()
}

type CryptoUnlockRequestType struct {
	This ManagedObjectReference `xml:"_this"`
}

func init() {
	t["CryptoUnlockRequestType"] = reflect.TypeOf((*CryptoUnlockRequestType)(nil)).Elem()
}

type CryptoUnlock_Task CryptoUnlockRequestType

func init() {
	t["CryptoUnlock_Task"] = reflect.TypeOf((*CryptoUnlock_Task)(nil)).Elem()
}

type CryptoUnlock_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval"`
}

type CurrentTime CurrentTimeRequestType

func init() {
	t["CurrentTime"] = reflect.TypeOf((*CurrentTime)(nil)).Elem()
}

type CurrentTimeRequestType struct {
	This ManagedObjectReference `xml:"_this"`
}

func init() {
	t["CurrentTimeRequestType"] = reflect.TypeOf((*CurrentTimeRequestType)(nil)).Elem()
}

type CurrentTimeResponse struct {
	Returnval time.Time `xml:"returnval"`
}

type CustomFieldDef struct {
	DynamicData

	Key                     int32               `xml:"key"`
	Name                    string              `xml:"name"`
	Type                    string              `xml:"type"`
	ManagedObjectType       string              `xml:"managedObjectType,omitempty"`
	FieldDefPrivileges      *PrivilegePolicyDef `xml:"fieldDefPrivileges,omitempty"`
	FieldInstancePrivileges *PrivilegePolicyDef `xml:"fieldInstancePrivileges,omitempty"`
}

func init() {
	t["CustomFieldDef"] = reflect.TypeOf((*CustomFieldDef)(nil)).Elem()
}

type CustomFieldDefAddedEvent struct {
	CustomFieldDefEvent
}

func init() {
	t["CustomFieldDefAddedEvent"] = reflect.TypeOf((*CustomFieldDefAddedEvent)(nil)).Elem()
}

type CustomFieldDefEvent struct {
	CustomFieldEvent

	FieldKey int32  `xml:"fieldKey"`
	Name     string `xml:"name"`
}

func init() {
	t["CustomFieldDefEvent"] = reflect.TypeOf((*CustomFieldDefEvent)(nil)).Elem()
}

type CustomFieldDefRemovedEvent struct {
	CustomFieldDefEvent
}

func init() {
	t["CustomFieldDefRemovedEvent"] = reflect.TypeOf((*CustomFieldDefRemovedEvent)(nil)).Elem()
}

type CustomFieldDefRenamedEvent struct {
	CustomFieldDefEvent

	NewName string `xml:"newName"`
}

func init() {
	t["CustomFieldDefRenamedEvent"] = reflect.TypeOf((*CustomFieldDefRenamedEvent)(nil)).Elem()
}

type CustomFieldEvent struct {
	Event
}

func init() {
	t["CustomFieldEvent"] = reflect.TypeOf((*CustomFieldEvent)(nil)).Elem()
}

type CustomFieldStringValue struct {
	CustomFieldValue

	Value string `xml:"value"`
}

func init() {
	t["CustomFieldStringValue"] = reflect.TypeOf((*CustomFieldStringValue)(nil)).Elem()
}

type CustomFieldValue struct {
	DynamicData

	Key int32 `xml:"key"`
}

func init() {
	t["CustomFieldValue"] = reflect.TypeOf((*CustomFieldValue)(nil)).Elem()
}

type CustomFieldValueChangedEvent struct {
	CustomFieldEvent

	Entity    ManagedEntityEventArgument `xml:"entity"`
	FieldKey  int32                      `xml:"fieldKey"`
	Name      string                     `xml:"name"`
	Value     string                     `xml:"value"`
	PrevState string                     `xml:"prevState,omitempty"`
}

func init() {
	t["CustomFieldValueChangedEvent"] = reflect.TypeOf((*CustomFieldValueChangedEvent)(nil)).Elem()
}

type CustomizationAdapterMapping struct {
	DynamicData

	MacAddress string                  `xml:"macAddress,omitempty"`
	Adapter    CustomizationIPSettings `xml:"adapter"`
}

func init() {
	t["CustomizationAdapterMapping"] = reflect.TypeOf((*CustomizationAdapterMapping)(nil)).Elem()
}

type CustomizationAutoIpV6Generator struct {
	CustomizationIpV6Generator
}

func init() {
	t["CustomizationAutoIpV6Generator"] = reflect.TypeOf((*CustomizationAutoIpV6Generator)(nil)).Elem()
}

type CustomizationCloudinitPrep struct {
	CustomizationIdentitySettings

	Metadata string `xml:"metadata"`
	Userdata string `xml:"userdata,omitempty"`
}

func init() {
	t["CustomizationCloudinitPrep"] = reflect.TypeOf((*CustomizationCloudinitPrep)(nil)).Elem()
}

type CustomizationCustomIpGenerator struct {
	CustomizationIpGenerator

	Argument string `xml:"argument,omitempty"`
}

func init() {
	t["CustomizationCustomIpGenerator"] = reflect.TypeOf((*CustomizationCustomIpGenerator)(nil)).Elem()
}

type CustomizationCustomIpV6Generator struct {
	CustomizationIpV6Generator

	Argument string `xml:"argument,omitempty"`
}

func init() {
	t["CustomizationCustomIpV6Generator"] = reflect.TypeOf((*CustomizationCustomIpV6Generator)(nil)).Elem()
}

type CustomizationCustomName struct {
	CustomizationName

	Argument string `xml:"argument,omitempty"`
}

func init() {
	t["CustomizationCustomName"] = reflect.TypeOf((*CustomizationCustomName)(nil)).Elem()
}

type CustomizationDhcpIpGenerator struct {
	CustomizationIpGenerator
}

func init() {
	t["CustomizationDhcpIpGenerator"] = reflect.TypeOf((*CustomizationDhcpIpGenerator)(nil)).Elem()
}

type CustomizationDhcpIpV6Generator struct {
	CustomizationIpV6Generator
}

func init() {
	t["CustomizationDhcpIpV6Generator"] = reflect.TypeOf((*CustomizationDhcpIpV6Generator)(nil)).Elem()
}

type CustomizationEvent struct {
	VmEvent

	LogLocation string `xml:"logLocation,omitempty"`
}

func init() {
	t["CustomizationEvent"] = reflect.TypeOf((*CustomizationEvent)(nil)).Elem()
}

type CustomizationFailed struct {
	CustomizationEvent

	Reason string `xml:"reason,omitempty"`
}

func init() {
	t["CustomizationFailed"] = reflect.TypeOf((*CustomizationFailed)(nil)).Elem()
}

type CustomizationFault struct {
	VimFault
}

func init() {
	t["CustomizationFault"] = reflect.TypeOf((*CustomizationFault)(nil)).Elem()
}

type CustomizationFaultFault BaseCustomizationFault

func init() {
	t["CustomizationFaultFault"] = reflect.TypeOf((*CustomizationFaultFault)(nil)).Elem()
}

type CustomizationFixedIp struct {
	CustomizationIpGenerator

	IpAddress string `xml:"ipAddress"`
}

func init() {
	t["CustomizationFixedIp"] = reflect.TypeOf((*CustomizationFixedIp)(nil)).Elem()
}

type CustomizationFixedIpV6 struct {
	CustomizationIpV6Generator

	IpAddress  string `xml:"ipAddress"`
	SubnetMask int32  `xml:"subnetMask"`
}

func init() {
	t["CustomizationFixedIpV6"] = reflect.TypeOf((*CustomizationFixedIpV6)(nil)).Elem()
}

type CustomizationFixedName struct {
	CustomizationName

	Name string `xml:"name"`
}

func init() {
	t["CustomizationFixedName"] = reflect.TypeOf((*CustomizationFixedName)(nil)).Elem()
}

type CustomizationGlobalIPSettings struct {
	DynamicData

	DnsSuffixList []string `xml:"dnsSuffixList,omitempty"`
	DnsServerList []string `xml:"dnsServerList,omitempty"`
}

func init() {
	t["CustomizationGlobalIPSettings"] = reflect.TypeOf((*CustomizationGlobalIPSettings)(nil)).Elem()
}

type CustomizationGuiRunOnce struct {
	DynamicData

	CommandList []string `xml:"commandList"`
}

func init() {
	t["CustomizationGuiRunOnce"] = reflect.TypeOf((*CustomizationGuiRunOnce)(nil)).Elem()
}

type CustomizationGuiUnattended struct {
	DynamicData

	Password       *CustomizationPassword `xml:"password,omitempty"`
	TimeZone       int32                  `xml:"timeZone"`
	AutoLogon      bool                   `xml:"autoLogon"`
	AutoLogonCount int32                  `xml:"autoLogonCount"`
}

func init() {
	t["CustomizationGuiUnattended"] = reflect.TypeOf((*CustomizationGuiUnattended)(nil)).Elem()
}

type CustomizationIPSettings struct {
	DynamicData

	Ip            BaseCustomizationIpGenerator            `xml:"ip,typeattr"`
	SubnetMask    string                                  `xml:"subnetMask,omitempty"`
	Gateway       []string                                `xml:"gateway,omitempty"`
	IpV6Spec      *CustomizationIPSettingsIpV6AddressSpec `xml:"ipV6Spec,omitempty"`
	DnsServerList []string                                `xml:"dnsServerList,omitempty"`
	DnsDomain     string                                  `xml:"dnsDomain,omitempty"`
	PrimaryWINS   string                                  `xml:"primaryWINS,omitempty"`
	SecondaryWINS string                                  `xml:"secondaryWINS,omitempty"`
	NetBIOS       CustomizationNetBIOSMode                `xml:"netBIOS,omitempty"`
}

func init() {
	t["CustomizationIPSettings"] = reflect.TypeOf((*CustomizationIPSettings)(nil)).Elem()
}

type CustomizationIPSettingsIpV6AddressSpec struct {
	DynamicData

	Ip      []BaseCustomizationIpV6Generator `xml:"ip,typeattr"`
	Gateway []string                         `xml:"gateway,omitempty"`
}

func init() {
	t["CustomizationIPSettingsIpV6AddressSpec"] = reflect.TypeOf((*CustomizationIPSettingsIpV6AddressSpec)(nil)).Elem()
}

type CustomizationIdentification struct {
	DynamicData

	JoinWorkgroup       string                 `xml:"joinWorkgroup,omitempty"`
	JoinDomain          string                 `xml:"joinDomain,omitempty"`
	DomainAdmin         string                 `xml:"domainAdmin,omitempty"`
	DomainAdminPassword *CustomizationPassword `xml:"domainAdminPassword,omitempty"`
}

func init() {
	t["CustomizationIdentification"] = reflect.TypeOf((*CustomizationIdentification)(nil)).Elem()
}

type CustomizationIdentitySettings struct {
	DynamicData
}

func init() {
	t["CustomizationIdentitySettings"] = reflect.TypeOf((*CustomizationIdentitySettings)(nil)).Elem()
}

type CustomizationIpGenerator struct {
	DynamicData
}

func init() {
	t["CustomizationIpGenerator"] = reflect.TypeOf((*CustomizationIpGenerator)(nil)).Elem()
}

type CustomizationIpV6Generator struct {
	DynamicData
}

func init() {
	t["CustomizationIpV6Generator"] = reflect.TypeOf((*CustomizationIpV6Generator)(nil)).Elem()
}

type CustomizationLicenseFilePrintData struct {
	DynamicData

	AutoMode  CustomizationLicenseDataMode `xml:"autoMode"`
	AutoUsers int32                        `xml:"autoUsers,omitempty"`
}

func init() {
	t["CustomizationLicenseFilePrintData"] = reflect.TypeOf((*CustomizationLicenseFilePrintData)(nil)).Elem()
}

type CustomizationLinuxIdentityFailed struct {
	CustomizationFailed
}

func init() {
	t["CustomizationLinuxIdentityFailed"] = reflect.TypeOf((*CustomizationLinuxIdentityFailed)(nil)).Elem()
}

type CustomizationLinuxOptions struct {
	CustomizationOptions
}

func init() {
	t["CustomizationLinuxOptions"] = reflect.TypeOf((*CustomizationLinuxOptions)(nil)).Elem()
}

type CustomizationLinuxPrep struct {
	CustomizationIdentitySettings

	HostName   BaseCustomizationName `xml:"hostName,typeattr"`
	Domain     string                `xml:"domain"`
	TimeZone   string                `xml:"timeZone,omitempty"`
	HwClockUTC *bool                 `xml:"hwClockUTC"`
	ScriptText string                `xml:"scriptText,omitempty"`
}

func init() {
	t["CustomizationLinuxPrep"] = reflect.TypeOf((*CustomizationLinuxPrep)(nil)).Elem()
}

type CustomizationName struct {
	DynamicData
}

func init() {
	t["CustomizationName"] = reflect.TypeOf((*CustomizationName)(nil)).Elem()
}

type CustomizationNetworkSetupFailed struct {
	CustomizationFailed
}

func init() {
	t["CustomizationNetworkSetupFailed"] = reflect.TypeOf((*CustomizationNetworkSetupFailed)(nil)).Elem()
}

type CustomizationOptions struct {
	DynamicData
}

func init() {
	t["CustomizationOptions"] = reflect.TypeOf((*CustomizationOptions)(nil)).Elem()
}

type CustomizationPassword struct {
	DynamicData

	Value     string `xml:"value"`
	PlainText bool   `xml:"plainText"`
}

func init() {
	t["CustomizationPassword"] = reflect.TypeOf((*CustomizationPassword)(nil)).Elem()
}

type CustomizationPending struct {
	CustomizationFault
}

func init() {
	t["CustomizationPending"] = reflect.TypeOf((*CustomizationPending)(nil)).Elem()
}

type CustomizationPendingFault CustomizationPending

func init() {
	t["CustomizationPendingFault"] = reflect.TypeOf((*CustomizationPendingFault)(nil)).Elem()
}

type CustomizationPrefixName struct {
	CustomizationName

	Base string `xml:"base"`
}

func init() {
	t["CustomizationPrefixName"] = reflect.TypeOf((*CustomizationPrefixName)(nil)).Elem()
}

type CustomizationSpec struct {
	DynamicData

	Options          BaseCustomizationOptions          `xml:"options,omitempty,typeattr"`
	Identity         BaseCustomizationIdentitySettings `xml:"identity,typeattr"`
	GlobalIPSettings CustomizationGlobalIPSettings     `xml:"globalIPSettings"`
	NicSettingMap    []CustomizationAdapterMapping     `xml:"nicSettingMap,omitempty"`
	EncryptionKey    []byte                            `xml:"encryptionKey,omitempty"`
}

func init() {
	t["CustomizationSpec"] = reflect.TypeOf((*CustomizationSpec)(nil)).Elem()
}

type CustomizationSpecInfo struct {
	DynamicData

	Name           string     `xml:"name"`
	Description    string     `xml:"description"`
	Type           string     `xml:"type"`
	ChangeVersion  string     `xml:"changeVersion,omitempty"`
	LastUpdateTime *time.Time `xml:"lastUpdateTime"`
}

func init() {
	t["CustomizationSpecInfo"] = reflect.TypeOf((*CustomizationSpecInfo)(nil)).Elem()
}

type CustomizationSpecItem struct {
	DynamicData

	Info CustomizationSpecInfo `xml:"info"`
	Spec CustomizationSpec     `xml:"spec"`
}

func init() {
	t["CustomizationSpecItem"] = reflect.TypeOf((*CustomizationSpecItem)(nil)).Elem()
}

type CustomizationSpecItemToXml CustomizationSpecItemToXmlRequestType

func init() {
	t["CustomizationSpecItemToXml"] = reflect.TypeOf((*CustomizationSpecItemToXml)(nil)).Elem()
}

type CustomizationSpecItemToXmlRequestType struct {
	This ManagedObjectReference `xml:"_this"`
	Item CustomizationSpecItem  `xml:"item"`
}

func init() {
	t["CustomizationSpecItemToXmlRequestType"] = reflect.TypeOf((*CustomizationSpecItemToXmlRequestType)(nil)).Elem()
}

type CustomizationSpecItemToXmlResponse struct {
	Returnval string `xml:"returnval"`
}

type CustomizationStartedEvent struct {
	CustomizationEvent
}

func init() {
	t["CustomizationStartedEvent"] = reflect.TypeOf((*CustomizationStartedEvent)(nil)).Elem()
}

type CustomizationStatelessIpV6Generator struct {
	CustomizationIpV6Generator
}

func init() {
	t["CustomizationStatelessIpV6Generator"] = reflect.TypeOf((*CustomizationStatelessIpV6Generator)(nil)).Elem()
}

type CustomizationSucceeded struct {
	CustomizationEvent
}

func init() {
	t["CustomizationSucceeded"] = reflect.TypeOf((*CustomizationSucceeded)(nil)).Elem()
}

type CustomizationSysprep struct {
	CustomizationIdentitySettings

	GuiUnattended        CustomizationGuiUnattended         `xml:"guiUnattended"`
	UserData             CustomizationUserData              `xml:"userData"`
	GuiRunOnce           *CustomizationGuiRunOnce           `xml:"guiRunOnce,omitempty"`
	Identification       CustomizationIdentification        `xml:"identification"`
	LicenseFilePrintData *CustomizationLicenseFilePrintData `xml:"licenseFilePrintData,omitempty"`
}

func init() {
	t["CustomizationSysprep"] = reflect.TypeOf((*CustomizationSysprep)(nil)).Elem()
}

type CustomizationSysprepFailed struct {
	CustomizationFailed

	SysprepVersion string `xml:"sysprepVersion"`
	SystemVersion  string `xml:"systemVersion"`
}

func init() {
	t["CustomizationSysprepFailed"] = reflect.TypeOf((*CustomizationSysprepFailed)(nil)).Elem()
}

type CustomizationSysprepText struct {
	CustomizationIdentitySettings

	Value string `xml:"value"`
}

func init() {
	t["CustomizationSysprepText"] = reflect.TypeOf((*CustomizationSysprepText)(nil)).Elem()
}

type CustomizationUnknownFailure struct {
	CustomizationFailed
}

func init() {
	t["CustomizationUnknownFailure"] = reflect.TypeOf((*CustomizationUnknownFailure)(nil)).Elem()
}

type CustomizationUnknownIpGenerator struct {
	CustomizationIpGenerator
}

func init() {
	t["CustomizationUnknownIpGenerator"] = reflect.TypeOf((*CustomizationUnknownIpGenerator)(nil)).Elem()
}

type CustomizationUnknownIpV6Generator struct {
	CustomizationIpV6Generator
}

func init() {
	t["CustomizationUnknownIpV6Generator"] = reflect.TypeOf((*CustomizationUnknownIpV6Generator)(nil)).Elem()
}

type CustomizationUnknownName struct {
	CustomizationName
}

func init() {
	t["CustomizationUnknownName"] = reflect.TypeOf((*CustomizationUnknownName)(nil)).Elem()
}

type CustomizationUserData struct {
	DynamicData

	FullName     string                `xml:"fullName"`
	OrgName      string                `xml:"orgName"`
	ComputerName BaseCustomizationName `xml:"computerName,typeattr"`
	ProductId    string                `xml:"productId"`
}

func init() {
	t["CustomizationUserData"] = reflect.TypeOf((*CustomizationUserData)(nil)).Elem()
}

type CustomizationVirtualMachineName struct {
	CustomizationName
}

func init() {
	t["CustomizationVirtualMachineName"] = reflect.TypeOf((*CustomizationVirtualMachineName)(nil)).Elem()
}

type CustomizationWinOptions struct {
	CustomizationOptions

	ChangeSID      bool                             `xml:"changeSID"`
	DeleteAccounts bool                             `xml:"deleteAccounts"`
	Reboot         CustomizationSysprepRebootOption `xml:"reboot,omitempty"`
}

func init() {
	t["CustomizationWinOptions"] = reflect.TypeOf((*CustomizationWinOptions)(nil)).Elem()
}

type CustomizeGuestRequestType struct {
	This         ManagedObjectReference  `xml:"_this"`
	Vm           ManagedObjectReference  `xml:"vm"`
	Auth         BaseGuestAuthentication `xml:"auth,typeattr"`
	Spec         CustomizationSpec       `xml:"spec"`
	ConfigParams []BaseOptionValue       `xml:"configParams,omitempty,typeattr"`
}

func init() {
	t["CustomizeGuestRequestType"] = reflect.TypeOf((*CustomizeGuestRequestType)(nil)).Elem()
}

type CustomizeGuest_Task CustomizeGuestRequestType

func init() {
	t["CustomizeGuest_Task"] = reflect.TypeOf((*CustomizeGuest_Task)(nil)).Elem()
}

type CustomizeGuest_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval"`
}

type CustomizeVMRequestType struct {
	This ManagedObjectReference `xml:"_this"`
	Spec CustomizationSpec      `xml:"spec"`
}

func init() {
	t["CustomizeVMRequestType"] = reflect.TypeOf((*CustomizeVMRequestType)(nil)).Elem()
}

type CustomizeVM_Task CustomizeVMRequestType

func init() {
	t["CustomizeVM_Task"] = reflect.TypeOf((*CustomizeVM_Task)(nil)).Elem()
}

type CustomizeVM_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval"`
}

type DVPortConfigInfo struct {
	DynamicData

	Name          string                   `xml:"name,omitempty"`
	Scope         []ManagedObjectReference `xml:"scope,omitempty"`
	Description   string                   `xml:"description,omitempty"`
	Setting       BaseDVPortSetting        `xml:"setting,omitempty,typeattr"`
	ConfigVersion string                   `xml:"configVersion"`
}

func init() {
	t["DVPortConfigInfo"] = reflect.TypeOf((*DVPortConfigInfo)(nil)).Elem()
}

type DVPortConfigSpec struct {
	DynamicData

	Operation     string                   `xml:"operation"`
	Key           string                   `xml:"key,omitempty"`
	Name          string                   `xml:"name,omitempty"`
	Scope         []ManagedObjectReference `xml:"scope,omitempty"`
	Description   string                   `xml:"description,omitempty"`
	Setting       BaseDVPortSetting        `xml:"setting,omitempty,typeattr"`
	ConfigVersion string                   `xml:"configVersion,omitempty"`
}

func init() {
	t["DVPortConfigSpec"] = reflect.TypeOf((*DVPortConfigSpec)(nil)).Elem()
}

type DVPortNotSupported struct {
	DeviceBackingNotSupported
}

func init() {
	t["DVPortNotSupported"] = reflect.TypeOf((*DVPortNotSupported)(nil)).Elem()
}

type DVPortNotSupportedFault DVPortNotSupported

func init() {
	t["DVPortNotSupportedFault"] = reflect.TypeOf((*DVPortNotSupportedFault)(nil)).Elem()
}

type DVPortSetting struct {
	DynamicData

	Blocked                 *BoolPolicy              `xml:"blocked,omitempty"`
	VmDirectPathGen2Allowed *BoolPolicy              `xml:"vmDirectPathGen2Allowed,omitempty"`
	InShapingPolicy         *DVSTrafficShapingPolicy `xml:"inShapingPolicy,omitempty"`
	OutShapingPolicy        *DVSTrafficShapingPolicy `xml:"outShapingPolicy,omitempty"`
	VendorSpecificConfig    *DVSVendorSpecificConfig `xml:"vendorSpecificConfig,omitempty"`
	NetworkResourcePoolKey  *StringPolicy            `xml:"networkResourcePoolKey,omitempty"`
	FilterPolicy            *DvsFilterPolicy         `xml:"filterPolicy,omitempty"`
}

func init() {
	t["DVPortSetting"] = reflect.TypeOf((*DVPortSetting)(nil)).Elem()
}

type DVPortState struct {
	DynamicData

	RuntimeInfo         *DVPortStatus                             `xml:"runtimeInfo,omitempty"`
	Stats               DistributedVirtualSwitchPortStatistics    `xml:"stats"`
	VendorSpecificState []DistributedVirtualSwitchKeyedOpaqueBlob `xml:"vendorSpecificState,omitempty"`
}

func init() {
	t["DVPortState"] = reflect.TypeOf((*DVPortState)(nil)).Elem()
}

type DVPortStatus struct {
	DynamicData

	LinkUp                                 bool           `xml:"linkUp"`
	Blocked                                bool           `xml:"blocked"`
	VlanIds                                []NumericRange `xml:"vlanIds,omitempty"`
	TrunkingMode                           *bool          `xml:"trunkingMode"`
	Mtu                                    int32          `xml:"mtu,omitempty"`
	LinkPeer                               string         `xml:"linkPeer,omitempty"`
	MacAddress                             string         `xml:"macAddress,omitempty"`
	StatusDetail                           string         `xml:"statusDetail,omitempty"`
	VmDirectPathGen2Active                 *bool          `xml:"vmDirectPathGen2Active"`
	VmDirectPathGen2InactiveReasonNetwork  []string       `xml:"vmDirectPathGen2InactiveReasonNetwork,omitempty"`
	VmDirectPathGen2InactiveReasonOther    []string       `xml:"vmDirectPathGen2InactiveReasonOther,omitempty"`
	VmDirectPathGen2InactiveReasonExtended string         `xml:"vmDirectPathGen2InactiveReasonExtended,omitempty"`
}

func init() {
	t["DVPortStatus"] = reflect.TypeOf((*DVPortStatus)(nil)).Elem()
}

type DVPortgroupConfigInfo struct {
	DynamicData

	Key                          string                                    `xml:"key"`
	Name                         string                                    `xml:"name"`
	NumPorts                     int32                                     `xml:"numPorts"`
	DistributedVirtualSwitch     *ManagedObjectReference                   `xml:"distributedVirtualSwitch,omitempty"`
	DefaultPortConfig            BaseDVPortSetting                         `xml:"defaultPortConfig,omitempty,typeattr"`
	Description                  string                                    `xml:"description,omitempty"`
	Type                         string                                    `xml:"type"`
	BackingType                  string                                    `xml:"backingType,omitempty"`
	Policy                       BaseDVPortgroupPolicy                     `xml:"policy,typeattr"`
	PortNameFormat               string                                    `xml:"portNameFormat,omitempty"`
	Scope                        []ManagedObjectReference                  `xml:"scope,omitempty"`
	VendorSpecificConfig         []DistributedVirtualSwitchKeyedOpaqueBlob `xml:"vendorSpecificConfig,omitempty"`
	ConfigVersion                string                                    `xml:"configVersion,omitempty"`
	AutoExpand                   *bool                                     `xml:"autoExpand"`
	VmVnicNetworkResourcePoolKey string                                    `xml:"vmVnicNetworkResourcePoolKey,omitempty"`
	Uplink                       *bool                                     `xml:"uplink"`
	TransportZoneUuid            string                                    `xml:"transportZoneUuid,omitempty"`
	TransportZoneName            string                                    `xml:"transportZoneName,omitempty"`
	LogicalSwitchUuid            string                                    `xml:"logicalSwitchUuid,omitempty"`
	SegmentId                    string                                    `xml:"segmentId,omitempty"`
}

func init() {
	t["DVPortgroupConfigInfo"] = reflect.TypeOf((*DVPortgroupConfigInfo)(nil)).Elem()
}

type DVPortgroupConfigSpec struct {
	DynamicData

	ConfigVersion                string                                    `xml:"configVersion,omitempty"`
	Name                         string                                    `xml:"name,omitempty"`
	NumPorts                     int32                                     `xml:"numPorts,omitempty"`
	PortNameFormat               string                                    `xml:"portNameFormat,omitempty"`
	DefaultPortConfig            BaseDVPortSetting                         `xml:"defaultPortConfig,omitempty,typeattr"`
	Description                  string                                    `xml:"description,omitempty"`
	Type                         string                                    `xml:"type,omitempty"`
	BackingType                  string                                    `xml:"backingType,omitempty"`
	Scope                        []ManagedObjectReference                  `xml:"scope,omitempty"`
	Policy                       BaseDVPortgroupPolicy                     `xml:"policy,omitempty,typeattr"`
	VendorSpecificConfig         []DistributedVirtualSwitchKeyedOpaqueBlob `xml:"vendorSpecificConfig,omitempty"`
	AutoExpand                   *bool                                     `xml:"autoExpand"`
	VmVnicNetworkResourcePoolKey string                                    `xml:"vmVnicNetworkResourcePoolKey,omitempty"`
	TransportZoneUuid            string                                    `xml:"transportZoneUuid,omitempty"`
	TransportZoneName            string                                    `xml:"transportZoneName,omitempty"`
	LogicalSwitchUuid            string                                    `xml:"logicalSwitchUuid,omitempty"`
	SegmentId                    string                                    `xml:"segmentId,omitempty"`
}

func init() {
	t["DVPortgroupConfigSpec"] = reflect.TypeOf((*DVPortgroupConfigSpec)(nil)).Elem()
}

type DVPortgroupCreatedEvent struct {
	DVPortgroupEvent
}

func init() {
	t["DVPortgroupCreatedEvent"] = reflect.TypeOf((*DVPortgroupCreatedEvent)(nil)).Elem()
}

type DVPortgroupDestroyedEvent struct {
	DVPortgroupEvent
}

func init() {
	t["DVPortgroupDestroyedEvent"] = reflect.TypeOf((*DVPortgroupDestroyedEvent)(nil)).Elem()
}

type DVPortgroupEvent struct {
	Event
}

func init() {
	t["DVPortgroupEvent"] = reflect.TypeOf((*DVPortgroupEvent)(nil)).Elem()
}

type DVPortgroupPolicy struct {
	DynamicData

	BlockOverrideAllowed               bool  `xml:"blockOverrideAllowed"`
	ShapingOverrideAllowed             bool  `xml:"shapingOverrideAllowed"`
	VendorConfigOverrideAllowed        bool  `xml:"vendorConfigOverrideAllowed"`
	LivePortMovingAllowed              bool  `xml:"livePortMovingAllowed"`
	PortConfigResetAtDisconnect        bool  `xml:"portConfigResetAtDisconnect"`
	NetworkResourcePoolOverrideAllowed *bool `xml:"networkResourcePoolOverrideAllowed"`
	TrafficFilterOverrideAllowed       *bool `xml:"trafficFilterOverrideAllowed"`
}

func init() {
	t["DVPortgroupPolicy"] = reflect.TypeOf((*DVPortgroupPolicy)(nil)).Elem()
}

type DVPortgroupReconfiguredEvent struct {
	DVPortgroupEvent

	ConfigSpec    DVPortgroupConfigSpec     `xml:"configSpec"`
	ConfigChanges *ChangesInfoEventArgument `xml:"configChanges,omitempty"`
}

func init() {
	t["DVPortgroupReconfiguredEvent"] = reflect.TypeOf((*DVPortgroupReconfiguredEvent)(nil)).Elem()
}

type DVPortgroupRenamedEvent struct {
	DVPortgroupEvent

	OldName string `xml:"oldName"`
	NewName string `xml:"newName"`
}

func init() {
	t["DVPortgroupRenamedEvent"] = reflect.TypeOf((*DVPortgroupRenamedEvent)(nil)).Elem()
}

type DVPortgroupRollbackRequestType struct {
	This         ManagedObjectReference `xml:"_this"`
	EntityBackup *EntityBackupConfig    `xml:"entityBackup,omitempty"`
}

func init() {
	t["DVPortgroupRollbackRequestType"] = reflect.TypeOf((*DVPortgroupRollbackRequestType)(nil)).Elem()
}

type DVPortgroupRollback_Task DVPortgroupRollbackRequestType

func init() {
	t["DVPortgroupRollback_Task"] = reflect.TypeOf((*DVPortgroupRollback_Task)(nil)).Elem()
}

type DVPortgroupRollback_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval"`
}

type DVPortgroupSelection struct {
	SelectionSet

	DvsUuid      string   `xml:"dvsUuid"`
	PortgroupKey []string `xml:"portgroupKey"`
}

func init() {
	t["DVPortgroupSelection"] = reflect.TypeOf((*DVPortgroupSelection)(nil)).Elem()
}

type DVSBackupRestoreCapability struct {
	DynamicData

	BackupRestoreSupported bool `xml:"backupRestoreSupported"`
}

func init() {
	t["DVSBackupRestoreCapability"] = reflect.TypeOf((*DVSBackupRestoreCapability)(nil)).Elem()
}

type DVSCapability struct {
	DynamicData

	DvsOperationSupported              *bool                                     `xml:"dvsOperationSupported"`
	DvPortGroupOperationSupported      *bool                                     `xml:"dvPortGroupOperationSupported"`
	DvPortOperationSupported           *bool                                     `xml:"dvPortOperationSupported"`
	CompatibleHostComponentProductInfo []DistributedVirtualSwitchHostProductSpec `xml:"compatibleHostComponentProductInfo,omitempty"`
	FeaturesSupported                  BaseDVSFeatureCapability                  `xml:"featuresSupported,omitempty,typeattr"`
}

func init() {
	t["DVSCapability"] = reflect.TypeOf((*DVSCapability)(nil)).Elem()
}

type DVSConfigInfo struct {
	DynamicData

	Uuid                                 string                                    `xml:"uuid"`
	Name                                 string                                    `xml:"name"`
	NumStandalonePorts                   int32                                     `xml:"numStandalonePorts"`
	NumPorts                             int32                                     `xml:"numPorts"`
	MaxPorts                             int32                                     `xml:"maxPorts"`
	UplinkPortPolicy                     BaseDVSUplinkPortPolicy                   `xml:"uplinkPortPolicy,typeattr"`
	UplinkPortgroup                      []ManagedObjectReference                  `xml:"uplinkPortgroup,omitempty"`
	DefaultPortConfig                    BaseDVPortSetting                         `xml:"defaultPortConfig,typeattr"`
	Host                                 []DistributedVirtualSwitchHostMember      `xml:"host,omitempty"`
	ProductInfo                          DistributedVirtualSwitchProductSpec       `xml:"productInfo"`
	TargetInfo                           *DistributedVirtualSwitchProductSpec      `xml:"targetInfo,omitempty"`
	ExtensionKey                         string                                    `xml:"extensionKey,omitempty"`
	VendorSpecificConfig                 []DistributedVirtualSwitchKeyedOpaqueBlob `xml:"vendorSpecificConfig,omitempty"`
	Policy                               *DVSPolicy                                `xml:"policy,omitempty"`
	Description                          string                                    `xml:"description,omitempty"`
	ConfigVersion                        string                                    `xml:"configVersion"`
	Contact                              DVSContactInfo                            `xml:"contact"`
	SwitchIpAddress                      string                                    `xml:"switchIpAddress,omitempty"`
	CreateTime                           time.Time                                 `xml:"createTime"`
	NetworkResourceManagementEnabled     *bool                                     `xml:"networkResourceManagementEnabled"`
	DefaultProxySwitchMaxNumPorts        int32                                     `xml:"defaultProxySwitchMaxNumPorts,omitempty"`
	HealthCheckConfig                    []BaseDVSHealthCheckConfig                `xml:"healthCheckConfig,omitempty,typeattr"`
	InfrastructureTrafficResourceConfig  []DvsHostInfrastructureTrafficResource    `xml:"infrastructureTrafficResourceConfig,omitempty"`
	NetResourcePoolTrafficResourceConfig []DvsHostInfrastructureTrafficResource    `xml:"netResourcePoolTrafficResourceConfig,omitempty"`
	NetworkResourceControlVersion        string                                    `xml:"networkResourceControlVersion,omitempty"`
	VmVnicNetworkResourcePool            []DVSVmVnicNetworkResourcePool            `xml:"vmVnicNetworkResourcePool,omitempty"`
	PnicCapacityRatioForReservation      int32                                     `xml:"pnicCapacityRatioForReservation,omitempty"`
}

func init() {
	t["DVSConfigInfo"] = reflect.TypeOf((*DVSConfigInfo)(nil)).Elem()
}

type DVSConfigSpec struct {
	DynamicData

	ConfigVersion                        string                                         `xml:"configVersion,omitempty"`
	Name                                 string                                         `xml:"name,omitempty"`
	NumStandalonePorts                   int32                                          `xml:"numStandalonePorts,omitempty"`
	MaxPorts                             int32                                          `xml:"maxPorts,omitempty"`
	UplinkPortPolicy                     BaseDVSUplinkPortPolicy                        `xml:"uplinkPortPolicy,omitempty,typeattr"`
	UplinkPortgroup                      []ManagedObjectReference                       `xml:"uplinkPortgroup,omitempty"`
	DefaultPortConfig                    BaseDVPortSetting                              `xml:"defaultPortConfig,omitempty,typeattr"`
	Host                                 []DistributedVirtualSwitchHostMemberConfigSpec `xml:"host,omitempty"`
	ExtensionKey                         string                                         `xml:"extensionKey,omitempty"`
	Description                          string                                         `xml:"description,omitempty"`
	Policy                               *DVSPolicy                                     `xml:"policy,omitempty"`
	VendorSpecificConfig                 []DistributedVirtualSwitchKeyedOpaqueBlob      `xml:"vendorSpecificConfig,omitempty"`
	Contact                              *DVSContactInfo                                `xml:"contact,omitempty"`
	SwitchIpAddress                      string                                         `xml:"switchIpAddress,omitempty"`
	DefaultProxySwitchMaxNumPorts        int32                                          `xml:"defaultProxySwitchMaxNumPorts,omitempty"`
	InfrastructureTrafficResourceConfig  []DvsHostInfrastructureTrafficResource         `xml:"infrastructureTrafficResourceConfig,omitempty"`
	NetResourcePoolTrafficResourceConfig []DvsHostInfrastructureTrafficResource         `xml:"netResourcePoolTrafficResourceConfig,omitempty"`
	NetworkResourceControlVersion        string                                         `xml:"networkResourceControlVersion,omitempty"`
}

func init() {
	t["DVSConfigSpec"] = reflect.TypeOf((*DVSConfigSpec)(nil)).Elem()
}

type DVSContactInfo struct {
	DynamicData

	Name    string `xml:"name,omitempty"`
	Contact string `xml:"contact,omitempty"`
}

func init() {
	t["DVSContactInfo"] = reflect.TypeOf((*DVSContactInfo)(nil)).Elem()
}

type DVSCreateSpec struct {
	DynamicData

	ConfigSpec  BaseDVSConfigSpec                    `xml:"configSpec,typeattr"`
	ProductInfo *DistributedVirtualSwitchProductSpec `xml:"productInfo,omitempty"`
	Capability  *DVSCapability                       `xml:"capability,omitempty"`
}

func init() {
	t["DVSCreateSpec"] = reflect.TypeOf((*DVSCreateSpec)(nil)).Elem()
}

type DVSFailureCriteria struct {
	InheritablePolicy

	CheckSpeed        *StringPolicy `xml:"checkSpeed,omitempty"`
	Speed             *IntPolicy    `xml:"speed,omitempty"`
	CheckDuplex       *BoolPolicy   `xml:"checkDuplex,omitempty"`
	FullDuplex        *BoolPolicy   `xml:"fullDuplex,omitempty"`
	CheckErrorPercent *BoolPolicy   `xml:"checkErrorPercent,omitempty"`
	Percentage        *IntPolicy    `xml:"percentage,omitempty"`
	CheckBeacon       *BoolPolicy   `xml:"checkBeacon,omitempty"`
}

func init() {
	t["DVSFailureCriteria"] = reflect.TypeOf((*DVSFailureCriteria)(nil)).Elem()
}

type DVSFeatureCapability struct {
	DynamicData

	NetworkResourceManagementSupported  bool                                    `xml:"networkResourceManagementSupported"`
	VmDirectPathGen2Supported           bool                                    `xml:"vmDirectPathGen2Supported"`
	NicTeamingPolicy                    []string                                `xml:"nicTeamingPolicy,omitempty"`
	NetworkResourcePoolHighShareValue   int32                                   `xml:"networkResourcePoolHighShareValue,omitempty"`
	NetworkResourceManagementCapability *DVSNetworkResourceManagementCapability `xml:"networkResourceManagementCapability,omitempty"`
	HealthCheckCapability               BaseDVSHealthCheckCapability            `xml:"healthCheckCapability,omitempty,typeattr"`
	RollbackCapability                  *DVSRollbackCapability                  `xml:"rollbackCapability,omitempty"`
	BackupRestoreCapability             *DVSBackupRestoreCapability             `xml:"backupRestoreCapability,omitempty"`
	NetworkFilterSupported              *bool                                   `xml:"networkFilterSupported"`
	MacLearningSupported                *bool                                   `xml:"macLearningSupported"`
}

func init() {
	t["DVSFeatureCapability"] = reflect.TypeOf((*DVSFeatureCapability)(nil)).Elem()
}

type DVSHealthCheckCapability struct {
	DynamicData
}

func init() {
	t["DVSHealthCheckCapability"] = reflect.TypeOf((*DVSHealthCheckCapability)(nil)).Elem()
}

type DVSHealthCheckConfig struct {
	DynamicData

	Enable   *bool `xml:"enable"`
	Interval int32 `xml:"interval,omitempty"`
}

func init() {
	t["DVSHealthCheckConfig"] = reflect.TypeOf((*DVSHealthCheckConfig)(nil)).Elem()
}

type DVSHostLocalPortInfo struct {
	DynamicData

	SwitchUuid string            `xml:"switchUuid"`
	PortKey    string            `xml:"portKey"`
	Setting    BaseDVPortSetting `xml:"setting,typeattr"`
	Vnic       string            `xml:"vnic"`
}

func init() {
	t["DVSHostLocalPortInfo"] = reflect.TypeOf((*DVSHostLocalPortInfo)(nil)).Elem()
}

type DVSMacLearningPolicy struct {
	InheritablePolicy

	Enabled              bool   `xml:"enabled"`
	AllowUnicastFlooding *bool  `xml:"allowUnicastFlooding"`
	Limit                *int32 `xml:"limit"`
	LimitPolicy          string `xml:"limitPolicy,omitempty"`
}

func init() {
	t["DVSMacLearningPolicy"] = reflect.TypeOf((*DVSMacLearningPolicy)(nil)).Elem()
}

type DVSMacManagementPolicy struct {
	InheritablePolicy

	AllowPromiscuous  *bool                 `xml:"allowPromiscuous"`
	MacChanges        *bool                 `xml:"macChanges"`
	ForgedTransmits   *bool                 `xml:"forgedTransmits"`
	MacLearningPolicy *DVSMacLearningPolicy `xml:"macLearningPolicy,omitempty"`
}

func init() {
	t["DVSMacManagementPolicy"] = reflect.TypeOf((*DVSMacManagementPolicy)(nil)).Elem()
}

type DVSManagerDvsConfigTarget struct {
	DynamicData

	DistributedVirtualPortgroup []DistributedVirtualPortgroupInfo `xml:"distributedVirtualPortgroup,omitempty"`
	DistributedVirtualSwitch    []DistributedVirtualSwitchInfo    `xml:"distributedVirtualSwitch,omitempty"`
}

func init() {
	t["DVSManagerDvsConfigTarget"] = reflect.TypeOf((*DVSManagerDvsConfigTarget)(nil)).Elem()
}

type DVSManagerExportEntityRequestType struct {
	This         ManagedObjectReference `xml:"_this"`
	SelectionSet []BaseSelectionSet     `xml:"selectionSet,typeattr"`
}

func init() {
	t["DVSManagerExportEntityRequestType"] = reflect.TypeOf((*DVSManagerExportEntityRequestType)(nil)).Elem()
}

type DVSManagerExportEntity_Task DVSManagerExportEntityRequestType

func init() {
	t["DVSManagerExportEntity_Task"] = reflect.TypeOf((*DVSManagerExportEntity_Task)(nil)).Elem()
}

type DVSManagerExportEntity_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval"`
}

type DVSManagerImportEntityRequestType struct {
	This         ManagedObjectReference `xml:"_this"`
	EntityBackup []EntityBackupConfig   `xml:"entityBackup"`
	ImportType   string                 `xml:"importType"`
}

func init() {
	t["DVSManagerImportEntityRequestType"] = reflect.TypeOf((*DVSManagerImportEntityRequestType)(nil)).Elem()
}

type DVSManagerImportEntity_Task DVSManagerImportEntityRequestType

func init() {
	t["DVSManagerImportEntity_Task"] = reflect.TypeOf((*DVSManagerImportEntity_Task)(nil)).Elem()
}

type DVSManagerImportEntity_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval"`
}

type DVSManagerLookupDvPortGroup DVSManagerLookupDvPortGroupRequestType

func init() {
	t["DVSManagerLookupDvPortGroup"] = reflect.TypeOf((*DVSManagerLookupDvPortGroup)(nil)).Elem()
}

type DVSManagerLookupDvPortGroupRequestType struct {
	This         ManagedObjectReference `xml:"_this"`
	SwitchUuid   string                 `xml:"switchUuid"`
	PortgroupKey string                 `xml:"portgroupKey"`
}

func init() {
	t["DVSManagerLookupDvPortGroupRequestType"] = reflect.TypeOf((*DVSManagerLookupDvPortGroupRequestType)(nil)).Elem()
}

type DVSManagerLookupDvPortGroupResponse struct {
	Returnval *ManagedObjectReference `xml:"returnval,omitempty"`
}

type DVSNameArrayUplinkPortPolicy struct {
	DVSUplinkPortPolicy

	UplinkPortName []string `xml:"uplinkPortName"`
}

func init() {
	t["DVSNameArrayUplinkPortPolicy"] = reflect.TypeOf((*DVSNameArrayUplinkPortPolicy)(nil)).Elem()
}

type DVSNetworkResourceManagementCapability struct {
	DynamicData

	NetworkResourceManagementSupported       bool  `xml:"networkResourceManagementSupported"`
	NetworkResourcePoolHighShareValue        int32 `xml:"networkResourcePoolHighShareValue"`
	QosSupported                             bool  `xml:"qosSupported"`
	UserDefinedNetworkResourcePoolsSupported bool  `xml:"userDefinedNetworkResourcePoolsSupported"`
	NetworkResourceControlVersion3Supported  *bool `xml:"networkResourceControlVersion3Supported"`
	UserDefinedInfraTrafficPoolSupported     *bool `xml:"userDefinedInfraTrafficPoolSupported"`
}

func init() {
	t["DVSNetworkResourceManagementCapability"] = reflect.TypeOf((*DVSNetworkResourceManagementCapability)(nil)).Elem()
}

type DVSNetworkResourcePool struct {
	DynamicData

	Key            string                               `xml:"key"`
	Name           string                               `xml:"name,omitempty"`
	Description    string                               `xml:"description,omitempty"`
	ConfigVersion  string                               `xml:"configVersion"`
	AllocationInfo DVSNetworkResourcePoolAllocationInfo `xml:"allocationInfo"`
}

func init() {
	t["DVSNetworkResourcePool"] = reflect.TypeOf((*DVSNetworkResourcePool)(nil)).Elem()
}

type DVSNetworkResourcePoolAllocationInfo struct {
	DynamicData

	Limit       *int64      `xml:"limit"`
	Shares      *SharesInfo `xml:"shares,omitempty"`
	PriorityTag int32       `xml:"priorityTag,omitempty"`
}

func init() {
	t["DVSNetworkResourcePoolAllocationInfo"] = reflect.TypeOf((*DVSNetworkResourcePoolAllocationInfo)(nil)).Elem()
}

type DVSNetworkResourcePoolConfigSpec struct {
	DynamicData

	Key            string                                `xml:"key"`
	ConfigVersion  string                                `xml:"configVersion,omitempty"`
	AllocationInfo *DVSNetworkResourcePoolAllocationInfo `xml:"allocationInfo,omitempty"`
	Name           string                                `xml:"name,omitempty"`
	Description    string                                `xml:"description,omitempty"`
}

func init() {
	t["DVSNetworkResourcePoolConfigSpec"] = reflect.TypeOf((*DVSNetworkResourcePoolConfigSpec)(nil)).Elem()
}

type DVSPolicy struct {
	DynamicData

	AutoPreInstallAllowed *bool `xml:"autoPreInstallAllowed"`
	AutoUpgradeAllowed    *bool `xml:"autoUpgradeAllowed"`
	PartialUpgradeAllowed *bool `xml:"partialUpgradeAllowed"`
}

func init() {
	t["DVSPolicy"] = reflect.TypeOf((*DVSPolicy)(nil)).Elem()
}

type DVSRollbackCapability struct {
	DynamicData

	RollbackSupported bool `xml:"rollbackSupported"`
}

func init() {
	t["DVSRollbackCapability"] = reflect.TypeOf((*DVSRollbackCapability)(nil)).Elem()
}

type DVSRollbackRequestType struct {
	This         ManagedObjectReference `xml:"_this"`
	EntityBackup *EntityBackupConfig    `xml:"entityBackup,omitempty"`
}

func init() {
	t["DVSRollbackRequestType"] = reflect.TypeOf((*DVSRollbackRequestType)(nil)).Elem()
}

type DVSRollback_Task DVSRollbackRequestType

func init() {
	t["DVSRollback_Task"] = reflect.TypeOf((*DVSRollback_Task)(nil)).Elem()
}

type DVSRollback_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval"`
}

type DVSRuntimeInfo struct {
	DynamicData

	HostMemberRuntime   []HostMemberRuntimeInfo `xml:"hostMemberRuntime,omitempty"`
	ResourceRuntimeInfo *DvsResourceRuntimeInfo `xml:"resourceRuntimeInfo,omitempty"`
}

func init() {
	t["DVSRuntimeInfo"] = reflect.TypeOf((*DVSRuntimeInfo)(nil)).Elem()
}

type DVSSecurityPolicy struct {
	InheritablePolicy

	AllowPromiscuous *BoolPolicy `xml:"allowPromiscuous,omitempty"`
	MacChanges       *BoolPolicy `xml:"macChanges,omitempty"`
	ForgedTransmits  *BoolPolicy `xml:"forgedTransmits,omitempty"`
}

func init() {
	t["DVSSecurityPolicy"] = reflect.TypeOf((*DVSSecurityPolicy)(nil)).Elem()
}

type DVSSelection struct {
	SelectionSet

	DvsUuid string `xml:"dvsUuid"`
}

func init() {
	t["DVSSelection"] = reflect.TypeOf((*DVSSelection)(nil)).Elem()
}

type DVSSummary struct {
	DynamicData

	Name          string                               `xml:"name"`
	Uuid          string                               `xml:"uuid"`
	NumPorts      int32                                `xml:"numPorts"`
	ProductInfo   *DistributedVirtualSwitchProductSpec `xml:"productInfo,omitempty"`
	HostMember    []ManagedObjectReference             `xml:"hostMember,omitempty"`
	Vm            []ManagedObjectReference             `xml:"vm,omitempty"`
	Host          []ManagedObjectReference             `xml:"host,omitempty"`
	PortgroupName []string                             `xml:"portgroupName,omitempty"`
	Description   string                               `xml:"description,omitempty"`
	Contact       *DVSContactInfo                      `xml:"contact,omitempty"`
	NumHosts      int32                                `xml:"numHosts,omitempty"`
}

func init() {
	t["DVSSummary"] = reflect.TypeOf((*DVSSummary)(nil)).Elem()
}

type DVSTrafficShapingPolicy struct {
	InheritablePolicy

	Enabled          *BoolPolicy `xml:"enabled,omitempty"`
	AverageBandwidth *LongPolicy `xml:"averageBandwidth,omitempty"`
	PeakBandwidth    *LongPolicy `xml:"peakBandwidth,omitempty"`
	BurstSize        *LongPolicy `xml:"burstSize,omitempty"`
}

func init() {
	t["DVSTrafficShapingPolicy"] = reflect.TypeOf((*DVSTrafficShapingPolicy)(nil)).Elem()
}

type DVSUplinkPortPolicy struct {
	DynamicData
}

func init() {
	t["DVSUplinkPortPolicy"] = reflect.TypeOf((*DVSUplinkPortPolicy)(nil)).Elem()
}

type DVSVendorSpecificConfig struct {
	InheritablePolicy

	KeyValue []DistributedVirtualSwitchKeyedOpaqueBlob `xml:"keyValue,omitempty"`
}

func init() {
	t["DVSVendorSpecificConfig"] = reflect.TypeOf((*DVSVendorSpecificConfig)(nil)).Elem()
}

type DVSVmVnicNetworkResourcePool struct {
	DynamicData

	Key            string                       `xml:"key"`
	Name           string                       `xml:"name,omitempty"`
	Description    string                       `xml:"description,omitempty"`
	ConfigVersion  string                       `xml:"configVersion"`
	AllocationInfo *DvsVmVnicResourceAllocation `xml:"allocationInfo,omitempty"`
}

func init() {
	t["DVSVmVnicNetworkResourcePool"] = reflect.TypeOf((*DVSVmVnicNetworkResourcePool)(nil)).Elem()
}

type DailyTaskScheduler struct {
	HourlyTaskScheduler

	Hour int32 `xml:"hour"`
}

func init() {
	t["DailyTaskScheduler"] = reflect.TypeOf((*DailyTaskScheduler)(nil)).Elem()
}

type DasAdmissionControlDisabledEvent struct {
	ClusterEvent
}

func init() {
	t["DasAdmissionControlDisabledEvent"] = reflect.TypeOf((*DasAdmissionControlDisabledEvent)(nil)).Elem()
}

type DasAdmissionControlEnabledEvent struct {
	ClusterEvent
}

func init() {
	t["DasAdmissionControlEnabledEvent"] = reflect.TypeOf((*DasAdmissionControlEnabledEvent)(nil)).Elem()
}

type DasAgentFoundEvent struct {
	ClusterEvent
}

func init() {
	t["DasAgentFoundEvent"] = reflect.TypeOf((*DasAgentFoundEvent)(nil)).Elem()
}

type DasAgentUnavailableEvent struct {
	ClusterEvent
}

func init() {
	t["DasAgentUnavailableEvent"] = reflect.TypeOf((*DasAgentUnavailableEvent)(nil)).Elem()
}

type DasClusterIsolatedEvent struct {
	ClusterEvent
}

func init() {
	t["DasClusterIsolatedEvent"] = reflect.TypeOf((*DasClusterIsolatedEvent)(nil)).Elem()
}

type DasConfigFault struct {
	VimFault

	Reason string      `xml:"reason,omitempty"`
	Output string      `xml:"output,omitempty"`
	Event  []BaseEvent `xml:"event,omitempty,typeattr"`
}

func init() {
	t["DasConfigFault"] = reflect.TypeOf((*DasConfigFault)(nil)).Elem()
}

type DasConfigFaultFault DasConfigFault

func init() {
	t["DasConfigFaultFault"] = reflect.TypeOf((*DasConfigFaultFault)(nil)).Elem()
}

type DasDisabledEvent struct {
	ClusterEvent
}

func init() {
	t["DasDisabledEvent"] = reflect.TypeOf((*DasDisabledEvent)(nil)).Elem()
}

type DasEnabledEvent struct {
	ClusterEvent
}

func init() {
	t["DasEnabledEvent"] = reflect.TypeOf((*DasEnabledEvent)(nil)).Elem()
}

type DasHeartbeatDatastoreInfo struct {
	DynamicData

	Datastore ManagedObjectReference   `xml:"datastore"`
	Hosts     []ManagedObjectReference `xml:"hosts"`
}

func init() {
	t["DasHeartbeatDatastoreInfo"] = reflect.TypeOf((*DasHeartbeatDatastoreInfo)(nil)).Elem()
}

type DasHostFailedEvent struct {
	ClusterEvent

	FailedHost HostEventArgument `xml:"failedHost"`
}

func init() {
	t["DasHostFailedEvent"] = reflect.TypeOf((*DasHostFailedEvent)(nil)).Elem()
}

type DasHostIsolatedEvent struct {
	ClusterEvent

	IsolatedHost HostEventArgument `xml:"isolatedHost"`
}

func init() {
	t["DasHostIsolatedEvent"] = reflect.TypeOf((*DasHostIsolatedEvent)(nil)).Elem()
}

type DatabaseError struct {
	RuntimeFault
}

func init() {
	t["DatabaseError"] = reflect.TypeOf((*DatabaseError)(nil)).Elem()
}

type DatabaseErrorFault DatabaseError

func init() {
	t["DatabaseErrorFault"] = reflect.TypeOf((*DatabaseErrorFault)(nil)).Elem()
}

type DatabaseSizeEstimate struct {
	DynamicData

	Size int64 `xml:"size"`
}

func init() {
	t["DatabaseSizeEstimate"] = reflect.TypeOf((*DatabaseSizeEstimate)(nil)).Elem()
}

type DatabaseSizeParam struct {
	DynamicData

	InventoryDesc InventoryDescription              `xml:"inventoryDesc"`
	PerfStatsDesc *PerformanceStatisticsDescription `xml:"perfStatsDesc,omitempty"`
}

func init() {
	t["DatabaseSizeParam"] = reflect.TypeOf((*DatabaseSizeParam)(nil)).Elem()
}

type DatacenterBasicConnectInfo struct {
	DynamicData

	Hostname        string                `xml:"hostname,omitempty"`
	Error           *LocalizedMethodFault `xml:"error,omitempty"`
	ServerIp        string                `xml:"serverIp,omitempty"`
	NumVm           int32                 `xml:"numVm,omitempty"`
	NumPoweredOnVm  int32                 `xml:"numPoweredOnVm,omitempty"`
	HostProductInfo *AboutInfo            `xml:"hostProductInfo,omitempty"`
	HardwareVendor  string                `xml:"hardwareVendor,omitempty"`
	HardwareModel   string                `xml:"hardwareModel,omitempty"`
}

func init() {
	t["DatacenterBasicConnectInfo"] = reflect.TypeOf((*DatacenterBasicConnectInfo)(nil)).Elem()
}

type DatacenterConfigInfo struct {
	DynamicData

	DefaultHardwareVersionKey string `xml:"defaultHardwareVersionKey,omitempty"`
	MaximumHardwareVersionKey string `xml:"maximumHardwareVersionKey,omitempty"`
}

func init() {
	t["DatacenterConfigInfo"] = reflect.TypeOf((*DatacenterConfigInfo)(nil)).Elem()
}

type DatacenterConfigSpec struct {
	DynamicData

	DefaultHardwareVersionKey string `xml:"defaultHardwareVersionKey,omitempty"`
	MaximumHardwareVersionKey string `xml:"maximumHardwareVersionKey,omitempty"`
}

func init() {
	t["DatacenterConfigSpec"] = reflect.TypeOf((*DatacenterConfigSpec)(nil)).Elem()
}

type DatacenterCreatedEvent struct {
	DatacenterEvent

	Parent FolderEventArgument `xml:"parent"`
}

func init() {
	t["DatacenterCreatedEvent"] = reflect.TypeOf((*DatacenterCreatedEvent)(nil)).Elem()
}

type DatacenterEvent struct {
	Event
}

func init() {
	t["DatacenterEvent"] = reflect.TypeOf((*DatacenterEvent)(nil)).Elem()
}

type DatacenterEventArgument struct {
	EntityEventArgument

	Datacenter ManagedObjectReference `xml:"datacenter"`
}

func init() {
	t["DatacenterEventArgument"] = reflect.TypeOf((*DatacenterEventArgument)(nil)).Elem()
}

type DatacenterMismatch struct {
	MigrationFault

	InvalidArgument    []DatacenterMismatchArgument `xml:"invalidArgument"`
	ExpectedDatacenter ManagedObjectReference       `xml:"expectedDatacenter"`
}

func init() {
	t["DatacenterMismatch"] = reflect.TypeOf((*DatacenterMismatch)(nil)).Elem()
}

type DatacenterMismatchArgument struct {
	DynamicData

	Entity          ManagedObjectReference  `xml:"entity"`
	InputDatacenter *ManagedObjectReference `xml:"inputDatacenter,omitempty"`
}

func init() {
	t["DatacenterMismatchArgument"] = reflect.TypeOf((*DatacenterMismatchArgument)(nil)).Elem()
}

type DatacenterMismatchFault DatacenterMismatch

func init() {
	t["DatacenterMismatchFault"] = reflect.TypeOf((*DatacenterMismatchFault)(nil)).Elem()
}

type DatacenterRenamedEvent struct {
	DatacenterEvent

	OldName string `xml:"oldName"`
	NewName string `xml:"newName"`
}

func init() {
	t["DatacenterRenamedEvent"] = reflect.TypeOf((*DatacenterRenamedEvent)(nil)).Elem()
}

type DatastoreCapability struct {
	DynamicData

	DirectoryHierarchySupported      bool  `xml:"directoryHierarchySupported"`
	RawDiskMappingsSupported         bool  `xml:"rawDiskMappingsSupported"`
	PerFileThinProvisioningSupported bool  `xml:"perFileThinProvisioningSupported"`
	StorageIORMSupported             *bool `xml:"storageIORMSupported"`
	NativeSnapshotSupported          *bool `xml:"nativeSnapshotSupported"`
	TopLevelDirectoryCreateSupported *bool `xml:"topLevelDirectoryCreateSupported"`
	SeSparseSupported                *bool `xml:"seSparseSupported"`
	VmfsSparseSupported              *bool `xml:"vmfsSparseSupported"`
	VsanSparseSupported              *bool `xml:"vsanSparseSupported"`
	UpitSupported                    *bool `xml:"upitSupported"`
	VmdkExpandSupported              *bool `xml:"vmdkExpandSupported"`
	ClusteredVmdkSupported           *bool `xml:"clusteredVmdkSupported"`
}

func init() {
	t["DatastoreCapability"] = reflect.TypeOf((*DatastoreCapability)(nil)).Elem()
}

type DatastoreCapacityIncreasedEvent struct {
	DatastoreEvent

	OldCapacity int64 `xml:"oldCapacity"`
	NewCapacity int64 `xml:"newCapacity"`
}

func init() {
	t["DatastoreCapacityIncreasedEvent"] = reflect.TypeOf((*DatastoreCapacityIncreasedEvent)(nil)).Elem()
}

type DatastoreDestroyedEvent struct {
	DatastoreEvent
}

func init() {
	t["DatastoreDestroyedEvent"] = reflect.TypeOf((*DatastoreDestroyedEvent)(nil)).Elem()
}

type DatastoreDiscoveredEvent struct {
	HostEvent

	Datastore DatastoreEventArgument `xml:"datastore"`
}

func init() {
	t["DatastoreDiscoveredEvent"] = reflect.TypeOf((*DatastoreDiscoveredEvent)(nil)).Elem()
}

type DatastoreDuplicatedEvent struct {
	DatastoreEvent
}

func init() {
	t["DatastoreDuplicatedEvent"] = reflect.TypeOf((*DatastoreDuplicatedEvent)(nil)).Elem()
}

type DatastoreEnterMaintenanceMode DatastoreEnterMaintenanceModeRequestType

func init() {
	t["DatastoreEnterMaintenanceMode"] = reflect.TypeOf((*DatastoreEnterMaintenanceMode)(nil)).Elem()
}

type DatastoreEnterMaintenanceModeRequestType struct {
	This ManagedObjectReference `xml:"_this"`
}

func init() {
	t["DatastoreEnterMaintenanceModeRequestType"] = reflect.TypeOf((*DatastoreEnterMaintenanceModeRequestType)(nil)).Elem()
}

type DatastoreEnterMaintenanceModeResponse struct {
	Returnval StoragePlacementResult `xml:"returnval"`
}

type DatastoreEvent struct {
	Event

	Datastore *DatastoreEventArgument `xml:"datastore,omitempty"`
}

func init() {
	t["DatastoreEvent"] = reflect.TypeOf((*DatastoreEvent)(nil)).Elem()
}

type DatastoreEventArgument struct {
	EntityEventArgument

	Datastore ManagedObjectReference `xml:"datastore"`
}

func init() {
	t["DatastoreEventArgument"] = reflect.TypeOf((*DatastoreEventArgument)(nil)).Elem()
}

type DatastoreExitMaintenanceModeRequestType struct {
	This ManagedObjectReference `xml:"_this"`
}

func init() {
	t["DatastoreExitMaintenanceModeRequestType"] = reflect.TypeOf((*DatastoreExitMaintenanceModeRequestType)(nil)).Elem()
}

type DatastoreExitMaintenanceMode_Task DatastoreExitMaintenanceModeRequestType

func init() {
	t["DatastoreExitMaintenanceMode_Task"] = reflect.TypeOf((*DatastoreExitMaintenanceMode_Task)(nil)).Elem()
}

type DatastoreExitMaintenanceMode_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval"`
}

type DatastoreFileCopiedEvent struct {
	DatastoreFileEvent

	SourceDatastore DatastoreEventArgument `xml:"sourceDatastore"`
	SourceFile      string                 `xml:"sourceFile"`
}

func init() {
	t["DatastoreFileCopiedEvent"] = reflect.TypeOf((*DatastoreFileCopiedEvent)(nil)).Elem()
}

type DatastoreFileDeletedEvent struct {
	DatastoreFileEvent
}

func init() {
	t["DatastoreFileDeletedEvent"] = reflect.TypeOf((*DatastoreFileDeletedEvent)(nil)).Elem()
}

type DatastoreFileEvent struct {
	DatastoreEvent

	TargetFile        string `xml:"targetFile"`
	SourceOfOperation string `xml:"sourceOfOperation,omitempty"`
	Succeeded         *bool  `xml:"succeeded"`
}

func init() {
	t["DatastoreFileEvent"] = reflect.TypeOf((*DatastoreFileEvent)(nil)).Elem()
}

type DatastoreFileMovedEvent struct {
	DatastoreFileEvent

	SourceDatastore DatastoreEventArgument `xml:"sourceDatastore"`
	SourceFile      string                 `xml:"sourceFile"`
}

func init() {
	t["DatastoreFileMovedEvent"] = reflect.TypeOf((*DatastoreFileMovedEvent)(nil)).Elem()
}

type DatastoreHostMount struct {
	DynamicData

	Key       ManagedObjectReference `xml:"key"`
	MountInfo HostMountInfo          `xml:"mountInfo"`
}

func init() {
	t["DatastoreHostMount"] = reflect.TypeOf((*DatastoreHostMount)(nil)).Elem()
}

type DatastoreIORMReconfiguredEvent struct {
	DatastoreEvent
}

func init() {
	t["DatastoreIORMReconfiguredEvent"] = reflect.TypeOf((*DatastoreIORMReconfiguredEvent)(nil)).Elem()
}

type DatastoreInfo struct {
	DynamicData

	Name                   string     `xml:"name"`
	Url                    string     `xml:"url"`
	FreeSpace              int64      `xml:"freeSpace"`
	MaxFileSize            int64      `xml:"maxFileSize"`
	MaxVirtualDiskCapacity int64      `xml:"maxVirtualDiskCapacity,omitempty"`
	MaxMemoryFileSize      int64      `xml:"maxMemoryFileSize,omitempty"`
	Timestamp              *time.Time `xml:"timestamp"`
	ContainerId            string     `xml:"containerId,omitempty"`
	AliasOf                string     `xml:"aliasOf,omitempty"`
}

func init() {
	t["DatastoreInfo"] = reflect.TypeOf((*DatastoreInfo)(nil)).Elem()
}

type DatastoreMountPathDatastorePair struct {
	DynamicData

	OldMountPath string                 `xml:"oldMountPath"`
	Datastore    ManagedObjectReference `xml:"datastore"`
}

func init() {
	t["DatastoreMountPathDatastorePair"] = reflect.TypeOf((*DatastoreMountPathDatastorePair)(nil)).Elem()
}

type DatastoreNotWritableOnHost struct {
	InvalidDatastore

	Host ManagedObjectReference `xml:"host"`
}

func init() {
	t["DatastoreNotWritableOnHost"] = reflect.TypeOf((*DatastoreNotWritableOnHost)(nil)).Elem()
}

type DatastoreNotWritableOnHostFault BaseDatastoreNotWritableOnHost

func init() {
	t["DatastoreNotWritableOnHostFault"] = reflect.TypeOf((*DatastoreNotWritableOnHostFault)(nil)).Elem()
}

type DatastoreOption struct {
	DynamicData

	UnsupportedVolumes []VirtualMachineDatastoreVolumeOption `xml:"unsupportedVolumes,omitempty"`
}

func init() {
	t["DatastoreOption"] = reflect.TypeOf((*DatastoreOption)(nil)).Elem()
}

type DatastorePrincipalConfigured struct {
	HostEvent

	DatastorePrincipal string `xml:"datastorePrincipal"`
}

func init() {
	t["DatastorePrincipalConfigured"] = reflect.TypeOf((*DatastorePrincipalConfigured)(nil)).Elem()
}

type DatastoreRemovedOnHostEvent struct {
	HostEvent

	Datastore DatastoreEventArgument `xml:"datastore"`
}

func init() {
	t["DatastoreRemovedOnHostEvent"] = reflect.TypeOf((*DatastoreRemovedOnHostEvent)(nil)).Elem()
}

type DatastoreRenamedEvent struct {
	DatastoreEvent

	OldName string `xml:"oldName"`
	NewName string `xml:"newName"`
}

func init() {
	t["DatastoreRenamedEvent"] = reflect.TypeOf((*DatastoreRenamedEvent)(nil)).Elem()
}

type DatastoreRenamedOnHostEvent struct {
	HostEvent

	OldName string `xml:"oldName"`
	NewName string `xml:"newName"`
}

func init() {
	t["DatastoreRenamedOnHostEvent"] = reflect.TypeOf((*DatastoreRenamedOnHostEvent)(nil)).Elem()
}

type DatastoreSummary struct {
	DynamicData

	Datastore          *ManagedObjectReference `xml:"datastore,omitempty"`
	Name               string                  `xml:"name"`
	Url                string                  `xml:"url"`
	Capacity           int64                   `xml:"capacity"`
	FreeSpace          int64                   `xml:"freeSpace"`
	Uncommitted        int64                   `xml:"uncommitted,omitempty"`
	Accessible         bool                    `xml:"accessible"`
	MultipleHostAccess *bool                   `xml:"multipleHostAccess"`
	Type               string                  `xml:"type"`
	MaintenanceMode    string                  `xml:"maintenanceMode,omitempty"`
}

func init() {
	t["DatastoreSummary"] = reflect.TypeOf((*DatastoreSummary)(nil)).Elem()
}

type DatastoreVVolContainerFailoverPair struct {
	DynamicData

	SrcContainer string     `xml:"srcContainer,omitempty"`
	TgtContainer string     `xml:"tgtContainer"`
	VvolMapping  []KeyValue `xml:"vvolMapping,omitempty"`
}

func init() {
	t["DatastoreVVolContainerFailoverPair"] = reflect.TypeOf((*DatastoreVVolContainerFailoverPair)(nil)).Elem()
}

type DateTimeProfile struct {
	ApplyProfile
}

func init() {
	t["DateTimeProfile"] = reflect.TypeOf((*DateTimeProfile)(nil)).Elem()
}

type DecodeLicense DecodeLicenseRequestType

func init() {
	t["DecodeLicense"] = reflect.TypeOf((*DecodeLicense)(nil)).Elem()
}

type DecodeLicenseRequestType struct {
	This       ManagedObjectReference `xml:"_this"`
	LicenseKey string                 `xml:"licenseKey"`
}

func init() {
	t["DecodeLicenseRequestType"] = reflect.TypeOf((*DecodeLicenseRequestType)(nil)).Elem()
}

type DecodeLicenseResponse struct {
	Returnval LicenseManagerLicenseInfo `xml:"returnval"`
}

type DefragmentAllDisks DefragmentAllDisksRequestType

func init() {
	t["DefragmentAllDisks"] = reflect.TypeOf((*DefragmentAllDisks)(nil)).Elem()
}

type DefragmentAllDisksRequestType struct {
	This ManagedObjectReference `xml:"_this"`
}

func init() {
	t["DefragmentAllDisksRequestType"] = reflect.TypeOf((*DefragmentAllDisksRequestType)(nil)).Elem()
}

type DefragmentAllDisksResponse struct {
}

type DefragmentVirtualDiskRequestType struct {
	This       ManagedObjectReference  `xml:"_this"`
	Name       string                  `xml:"name"`
	Datacenter *ManagedObjectReference `xml:"datacenter,omitempty"`
}

func init() {
	t["DefragmentVirtualDiskRequestType"] = reflect.TypeOf((*DefragmentVirtualDiskRequestType)(nil)).Elem()
}

type DefragmentVirtualDisk_Task DefragmentVirtualDiskRequestType

func init() {
	t["DefragmentVirtualDisk_Task"] = reflect.TypeOf((*DefragmentVirtualDisk_Task)(nil)).Elem()
}

type DefragmentVirtualDisk_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval"`
}

type DeleteCustomizationSpec DeleteCustomizationSpecRequestType

func init() {
	t["DeleteCustomizationSpec"] = reflect.TypeOf((*DeleteCustomizationSpec)(nil)).Elem()
}

type DeleteCustomizationSpecRequestType struct {
	This ManagedObjectReference `xml:"_this"`
	Name string                 `xml:"name"`
}

func init() {
	t["DeleteCustomizationSpecRequestType"] = reflect.TypeOf((*DeleteCustomizationSpecRequestType)(nil)).Elem()
}

type DeleteCustomizationSpecResponse struct {
}

type DeleteDatastoreFileRequestType struct {
	This       ManagedObjectReference  `xml:"_this"`
	Name       string                  `xml:"name"`
	Datacenter *ManagedObjectReference `xml:"datacenter,omitempty"`
}

func init() {
	t["DeleteDatastoreFileRequestType"] = reflect.TypeOf((*DeleteDatastoreFileRequestType)(nil)).Elem()
}

type DeleteDatastoreFile_Task DeleteDatastoreFileRequestType

func init() {
	t["DeleteDatastoreFile_Task"] = reflect.TypeOf((*DeleteDatastoreFile_Task)(nil)).Elem()
}

type DeleteDatastoreFile_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval"`
}

type DeleteDirectory DeleteDirectoryRequestType

func init() {
	t["DeleteDirectory"] = reflect.TypeOf((*DeleteDirectory)(nil)).Elem()
}

type DeleteDirectoryInGuest DeleteDirectoryInGuestRequestType

func init() {
	t["DeleteDirectoryInGuest"] = reflect.TypeOf((*DeleteDirectoryInGuest)(nil)).Elem()
}

type DeleteDirectoryInGuestRequestType struct {
	This          ManagedObjectReference  `xml:"_this"`
	Vm            ManagedObjectReference  `xml:"vm"`
	Auth          BaseGuestAuthentication `xml:"auth,typeattr"`
	DirectoryPath string                  `xml:"directoryPath"`
	Recursive     bool                    `xml:"recursive"`
}

func init() {
	t["DeleteDirectoryInGuestRequestType"] = reflect.TypeOf((*DeleteDirectoryInGuestRequestType)(nil)).Elem()
}

type DeleteDirectoryInGuestResponse struct {
}

type DeleteDirectoryRequestType struct {
	This          ManagedObjectReference  `xml:"_this"`
	Datacenter    *ManagedObjectReference `xml:"datacenter,omitempty"`
	DatastorePath string                  `xml:"datastorePath"`
}

func init() {
	t["DeleteDirectoryRequestType"] = reflect.TypeOf((*DeleteDirectoryRequestType)(nil)).Elem()
}

type DeleteDirectoryResponse struct {
}

type DeleteFile DeleteFileRequestType

func init() {
	t["DeleteFile"] = reflect.TypeOf((*DeleteFile)(nil)).Elem()
}

type DeleteFileInGuest DeleteFileInGuestRequestType

func init() {
	t["DeleteFileInGuest"] = reflect.TypeOf((*DeleteFileInGuest)(nil)).Elem()
}

type DeleteFileInGuestRequestType struct {
	This     ManagedObjectReference  `xml:"_this"`
	Vm       ManagedObjectReference  `xml:"vm"`
	Auth     BaseGuestAuthentication `xml:"auth,typeattr"`
	FilePath string                  `xml:"filePath"`
}

func init() {
	t["DeleteFileInGuestRequestType"] = reflect.TypeOf((*DeleteFileInGuestRequestType)(nil)).Elem()
}

type DeleteFileInGuestResponse struct {
}

type DeleteFileRequestType struct {
	This          ManagedObjectReference `xml:"_this"`
	DatastorePath string                 `xml:"datastorePath"`
}

func init() {
	t["DeleteFileRequestType"] = reflect.TypeOf((*DeleteFileRequestType)(nil)).Elem()
}

type DeleteFileResponse struct {
}

type DeleteHostSpecification DeleteHostSpecificationRequestType

func init() {
	t["DeleteHostSpecification"] = reflect.TypeOf((*DeleteHostSpecification)(nil)).Elem()
}

type DeleteHostSpecificationRequestType struct {
	This ManagedObjectReference `xml:"_this"`
	Host ManagedObjectReference `xml:"host"`
}

func init() {
	t["DeleteHostSpecificationRequestType"] = reflect.TypeOf((*DeleteHostSpecificationRequestType)(nil)).Elem()
}

type DeleteHostSpecificationResponse struct {
}

type DeleteHostSubSpecification DeleteHostSubSpecificationRequestType

func init() {
	t["DeleteHostSubSpecification"] = reflect.TypeOf((*DeleteHostSubSpecification)(nil)).Elem()
}

type DeleteHostSubSpecificationRequestType struct {
	This        ManagedObjectReference `xml:"_this"`
	Host        ManagedObjectReference `xml:"host"`
	SubSpecName string                 `xml:"subSpecName"`
}

func init() {
	t["DeleteHostSubSpecificationRequestType"] = reflect.TypeOf((*DeleteHostSubSpecificationRequestType)(nil)).Elem()
}

type DeleteHostSubSpecificationResponse struct {
}

type DeleteNvdimmBlockNamespacesRequestType struct {
	This ManagedObjectReference `xml:"_this"`
}

func init() {
	t["DeleteNvdimmBlockNamespacesRequestType"] = reflect.TypeOf((*DeleteNvdimmBlockNamespacesRequestType)(nil)).Elem()
}

type DeleteNvdimmBlockNamespaces_Task DeleteNvdimmBlockNamespacesRequestType

func init() {
	t["DeleteNvdimmBlockNamespaces_Task"] = reflect.TypeOf((*DeleteNvdimmBlockNamespaces_Task)(nil)).Elem()
}

type DeleteNvdimmBlockNamespaces_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval"`
}

type DeleteNvdimmNamespaceRequestType struct {
	This       ManagedObjectReference    `xml:"_this"`
	DeleteSpec NvdimmNamespaceDeleteSpec `xml:"deleteSpec"`
}

func init() {
	t["DeleteNvdimmNamespaceRequestType"] = reflect.TypeOf((*DeleteNvdimmNamespaceRequestType)(nil)).Elem()
}

type DeleteNvdimmNamespace_Task DeleteNvdimmNamespaceRequestType

func init() {
	t["DeleteNvdimmNamespace_Task"] = reflect.TypeOf((*DeleteNvdimmNamespace_Task)(nil)).Elem()
}

type DeleteNvdimmNamespace_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval"`
}

type DeleteRegistryKeyInGuest DeleteRegistryKeyInGuestRequestType

func init() {
	t["DeleteRegistryKeyInGuest"] = reflect.TypeOf((*DeleteRegistryKeyInGuest)(nil)).Elem()
}

type DeleteRegistryKeyInGuestRequestType struct {
	This      ManagedObjectReference  `xml:"_this"`
	Vm        ManagedObjectReference  `xml:"vm"`
	Auth      BaseGuestAuthentication `xml:"auth,typeattr"`
	KeyName   GuestRegKeyNameSpec     `xml:"keyName"`
	Recursive bool                    `xml:"recursive"`
}

func init() {
	t["DeleteRegistryKeyInGuestRequestType"] = reflect.TypeOf((*DeleteRegistryKeyInGuestRequestType)(nil)).Elem()
}

type DeleteRegistryKeyInGuestResponse struct {
}

type DeleteRegistryValueInGuest DeleteRegistryValueInGuestRequestType

func init() {
	t["DeleteRegistryValueInGuest"] = reflect.TypeOf((*DeleteRegistryValueInGuest)(nil)).Elem()
}

type DeleteRegistryValueInGuestRequestType struct {
	This      ManagedObjectReference  `xml:"_this"`
	Vm        ManagedObjectReference  `xml:"vm"`
	Auth      BaseGuestAuthentication `xml:"auth,typeattr"`
	ValueName GuestRegValueNameSpec   `xml:"valueName"`
}

func init() {
	t["DeleteRegistryValueInGuestRequestType"] = reflect.TypeOf((*DeleteRegistryValueInGuestRequestType)(nil)).Elem()
}

type DeleteRegistryValueInGuestResponse struct {
}

type DeleteScsiLunState DeleteScsiLunStateRequestType

func init() {
	t["DeleteScsiLunState"] = reflect.TypeOf((*DeleteScsiLunState)(nil)).Elem()
}

type DeleteScsiLunStateRequestType struct {
	This             ManagedObjectReference `xml:"_this"`
	LunCanonicalName string                 `xml:"lunCanonicalName"`
}

func init() {
	t["DeleteScsiLunStateRequestType"] = reflect.TypeOf((*DeleteScsiLunStateRequestType)(nil)).Elem()
}

type DeleteScsiLunStateResponse struct {
}

type DeleteSnapshotRequestType struct {
	This       ManagedObjectReference `xml:"_this"`
	Id         ID                     `xml:"id"`
	Datastore  ManagedObjectReference `xml:"datastore"`
	SnapshotId ID                     `xml:"snapshotId"`
}

func init() {
	t["DeleteSnapshotRequestType"] = reflect.TypeOf((*DeleteSnapshotRequestType)(nil)).Elem()
}

type DeleteSnapshot_Task DeleteSnapshotRequestType

func init() {
	t["DeleteSnapshot_Task"] = reflect.TypeOf((*DeleteSnapshot_Task)(nil)).Elem()
}

type DeleteSnapshot_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval"`
}

type DeleteVStorageObjectExRequestType struct {
	This      ManagedObjectReference `xml:"_this"`
	Id        ID                     `xml:"id"`
	Datastore ManagedObjectReference `xml:"datastore"`
}

func init() {
	t["DeleteVStorageObjectExRequestType"] = reflect.TypeOf((*DeleteVStorageObjectExRequestType)(nil)).Elem()
}

type DeleteVStorageObjectEx_Task DeleteVStorageObjectExRequestType

func init() {
	t["DeleteVStorageObjectEx_Task"] = reflect.TypeOf((*DeleteVStorageObjectEx_Task)(nil)).Elem()
}

type DeleteVStorageObjectEx_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval"`
}

type DeleteVStorageObjectRequestType struct {
	This      ManagedObjectReference `xml:"_this"`
	Id        ID                     `xml:"id"`
	Datastore ManagedObjectReference `xml:"datastore"`
}

func init() {
	t["DeleteVStorageObjectRequestType"] = reflect.TypeOf((*DeleteVStorageObjectRequestType)(nil)).Elem()
}

type DeleteVStorageObject_Task DeleteVStorageObjectRequestType

func init() {
	t["DeleteVStorageObject_Task"] = reflect.TypeOf((*DeleteVStorageObject_Task)(nil)).Elem()
}

type DeleteVStorageObject_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval"`
}

type DeleteVffsVolumeState DeleteVffsVolumeStateRequestType

func init() {
	t["DeleteVffsVolumeState"] = reflect.TypeOf((*DeleteVffsVolumeState)(nil)).Elem()
}

type DeleteVffsVolumeStateRequestType struct {
	This     ManagedObjectReference `xml:"_this"`
	VffsUuid string                 `xml:"vffsUuid"`
}

func init() {
	t["DeleteVffsVolumeStateRequestType"] = reflect.TypeOf((*DeleteVffsVolumeStateRequestType)(nil)).Elem()
}

type DeleteVffsVolumeStateResponse struct {
}

type DeleteVirtualDiskRequestType struct {
	This       ManagedObjectReference  `xml:"_this"`
	Name       string                  `xml:"name"`
	Datacenter *ManagedObjectReference `xml:"datacenter,omitempty"`
}

func init() {
	t["DeleteVirtualDiskRequestType"] = reflect.TypeOf((*DeleteVirtualDiskRequestType)(nil)).Elem()
}

type DeleteVirtualDisk_Task DeleteVirtualDiskRequestType

func init() {
	t["DeleteVirtualDisk_Task"] = reflect.TypeOf((*DeleteVirtualDisk_Task)(nil)).Elem()
}

type DeleteVirtualDisk_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval"`
}

type DeleteVmfsVolumeState DeleteVmfsVolumeStateRequestType

func init() {
	t["DeleteVmfsVolumeState"] = reflect.TypeOf((*DeleteVmfsVolumeState)(nil)).Elem()
}

type DeleteVmfsVolumeStateRequestType struct {
	This     ManagedObjectReference `xml:"_this"`
	VmfsUuid string                 `xml:"vmfsUuid"`
}

func init() {
	t["DeleteVmfsVolumeStateRequestType"] = reflect.TypeOf((*DeleteVmfsVolumeStateRequestType)(nil)).Elem()
}

type DeleteVmfsVolumeStateResponse struct {
}

type DeleteVsanObjects DeleteVsanObjectsRequestType

func init() {
	t["DeleteVsanObjects"] = reflect.TypeOf((*DeleteVsanObjects)(nil)).Elem()
}

type DeleteVsanObjectsRequestType struct {
	This  ManagedObjectReference `xml:"_this"`
	Uuids []string               `xml:"uuids"`
	Force *bool                  `xml:"force"`
}

func init() {
	t["DeleteVsanObjectsRequestType"] = reflect.TypeOf((*DeleteVsanObjectsRequestType)(nil)).Elem()
}

type DeleteVsanObjectsResponse struct {
	Returnval []HostVsanInternalSystemDeleteVsanObjectsResult `xml:"returnval"`
}

type DeltaDiskFormatNotSupported struct {
	VmConfigFault

	Datastore       []ManagedObjectReference `xml:"datastore,omitempty"`
	DeltaDiskFormat string                   `xml:"deltaDiskFormat"`
}

func init() {
	t["DeltaDiskFormatNotSupported"] = reflect.TypeOf((*DeltaDiskFormatNotSupported)(nil)).Elem()
}

type DeltaDiskFormatNotSupportedFault DeltaDiskFormatNotSupported

func init() {
	t["DeltaDiskFormatNotSupportedFault"] = reflect.TypeOf((*DeltaDiskFormatNotSupportedFault)(nil)).Elem()
}

type Description struct {
	DynamicData

	Label   string `xml:"label"`
	Summary string `xml:"summary"`
}

func init() {
	t["Description"] = reflect.TypeOf((*Description)(nil)).Elem()
}

type DeselectVnic DeselectVnicRequestType

func init() {
	t["DeselectVnic"] = reflect.TypeOf((*DeselectVnic)(nil)).Elem()
}

type DeselectVnicForNicType DeselectVnicForNicTypeRequestType

func init() {
	t["DeselectVnicForNicType"] = reflect.TypeOf((*DeselectVnicForNicType)(nil)).Elem()
}

type DeselectVnicForNicTypeRequestType struct {
	This    ManagedObjectReference `xml:"_this"`
	NicType string                 `xml:"nicType"`
	Device  string                 `xml:"device"`
}

func init() {
	t["DeselectVnicForNicTypeRequestType"] = reflect.TypeOf((*DeselectVnicForNicTypeRequestType)(nil)).Elem()
}

type DeselectVnicForNicTypeResponse struct {
}

type DeselectVnicRequestType struct {
	This ManagedObjectReference `xml:"_this"`
}

func init() {
	t["DeselectVnicRequestType"] = reflect.TypeOf((*DeselectVnicRequestType)(nil)).Elem()
}

type DeselectVnicResponse struct {
}

type DesiredSoftwareSpec struct {
	DynamicData

	BaseImageSpec   DesiredSoftwareSpecBaseImageSpec    `xml:"baseImageSpec"`
	VendorAddOnSpec *DesiredSoftwareSpecVendorAddOnSpec `xml:"vendorAddOnSpec,omitempty"`
	Components      []DesiredSoftwareSpecComponentSpec  `xml:"components,omitempty"`
}

func init() {
	t["DesiredSoftwareSpec"] = reflect.TypeOf((*DesiredSoftwareSpec)(nil)).Elem()
}

type DesiredSoftwareSpecBaseImageSpec struct {
	DynamicData

	Version string `xml:"version"`
}

func init() {
	t["DesiredSoftwareSpecBaseImageSpec"] = reflect.TypeOf((*DesiredSoftwareSpecBaseImageSpec)(nil)).Elem()
}

type DesiredSoftwareSpecComponentSpec struct {
	DynamicData

	Name    string `xml:"name"`
	Version string `xml:"version,omitempty"`
}

func init() {
	t["DesiredSoftwareSpecComponentSpec"] = reflect.TypeOf((*DesiredSoftwareSpecComponentSpec)(nil)).Elem()
}

type DesiredSoftwareSpecVendorAddOnSpec struct {
	DynamicData

	Name    string `xml:"name"`
	Version string `xml:"version"`
}

func init() {
	t["DesiredSoftwareSpecVendorAddOnSpec"] = reflect.TypeOf((*DesiredSoftwareSpecVendorAddOnSpec)(nil)).Elem()
}

type DestinationSwitchFull struct {
	CannotAccessNetwork
}

func init() {
	t["DestinationSwitchFull"] = reflect.TypeOf((*DestinationSwitchFull)(nil)).Elem()
}

type DestinationSwitchFullFault DestinationSwitchFull

func init() {
	t["DestinationSwitchFullFault"] = reflect.TypeOf((*DestinationSwitchFullFault)(nil)).Elem()
}

type DestinationVsanDisabled struct {
	CannotMoveVsanEnabledHost

	DestinationCluster string `xml:"destinationCluster"`
}

func init() {
	t["DestinationVsanDisabled"] = reflect.TypeOf((*DestinationVsanDisabled)(nil)).Elem()
}

type DestinationVsanDisabledFault DestinationVsanDisabled

func init() {
	t["DestinationVsanDisabledFault"] = reflect.TypeOf((*DestinationVsanDisabledFault)(nil)).Elem()
}

type DestroyChildren DestroyChildrenRequestType

func init() {
	t["DestroyChildren"] = reflect.TypeOf((*DestroyChildren)(nil)).Elem()
}

type DestroyChildrenRequestType struct {
	This ManagedObjectReference `xml:"_this"`
}

func init() {
	t["DestroyChildrenRequestType"] = reflect.TypeOf((*DestroyChildrenRequestType)(nil)).Elem()
}

type DestroyChildrenResponse struct {
}

type DestroyCollector DestroyCollectorRequestType

func init() {
	t["DestroyCollector"] = reflect.TypeOf((*DestroyCollector)(nil)).Elem()
}

type DestroyCollectorRequestType struct {
	This ManagedObjectReference `xml:"_this"`
}

func init() {
	t["DestroyCollectorRequestType"] = reflect.TypeOf((*DestroyCollectorRequestType)(nil)).Elem()
}

type DestroyCollectorResponse struct {
}

type DestroyDatastore DestroyDatastoreRequestType

func init() {
	t["DestroyDatastore"] = reflect.TypeOf((*DestroyDatastore)(nil)).Elem()
}

type DestroyDatastoreRequestType struct {
	This ManagedObjectReference `xml:"_this"`
}

func init() {
	t["DestroyDatastoreRequestType"] = reflect.TypeOf((*DestroyDatastoreRequestType)(nil)).Elem()
}

type DestroyDatastoreResponse struct {
}

type DestroyIpPool DestroyIpPoolRequestType

func init() {
	t["DestroyIpPool"] = reflect.TypeOf((*DestroyIpPool)(nil)).Elem()
}

type DestroyIpPoolRequestType struct {
	This  ManagedObjectReference `xml:"_this"`
	Dc    ManagedObjectReference `xml:"dc"`
	Id    int32                  `xml:"id"`
	Force bool                   `xml:"force"`
}

func init() {
	t["DestroyIpPoolRequestType"] = reflect.TypeOf((*DestroyIpPoolRequestType)(nil)).Elem()
}

type DestroyIpPoolResponse struct {
}

type DestroyNetwork DestroyNetworkRequestType

func init() {
	t["DestroyNetwork"] = reflect.TypeOf((*DestroyNetwork)(nil)).Elem()
}

type DestroyNetworkRequestType struct {
	This ManagedObjectReference `xml:"_this"`
}

func init() {
	t["DestroyNetworkRequestType"] = reflect.TypeOf((*DestroyNetworkRequestType)(nil)).Elem()
}

type DestroyNetworkResponse struct {
}

type DestroyProfile DestroyProfileRequestType

func init() {
	t["DestroyProfile"] = reflect.TypeOf((*DestroyProfile)(nil)).Elem()
}

type DestroyProfileRequestType struct {
	This ManagedObjectReference `xml:"_this"`
}

func init() {
	t["DestroyProfileRequestType"] = reflect.TypeOf((*DestroyProfileRequestType)(nil)).Elem()
}

type DestroyProfileResponse struct {
}

type DestroyPropertyCollector DestroyPropertyCollectorRequestType

func init() {
	t["DestroyPropertyCollector"] = reflect.TypeOf((*DestroyPropertyCollector)(nil)).Elem()
}

type DestroyPropertyCollectorRequestType struct {
	This ManagedObjectReference `xml:"_this"`
}

func init() {
	t["DestroyPropertyCollectorRequestType"] = reflect.TypeOf((*DestroyPropertyCollectorRequestType)(nil)).Elem()
}

type DestroyPropertyCollectorResponse struct {
}

type DestroyPropertyFilter DestroyPropertyFilterRequestType

func init() {
	t["DestroyPropertyFilter"] = reflect.TypeOf((*DestroyPropertyFilter)(nil)).Elem()
}

type DestroyPropertyFilterRequestType struct {
	This ManagedObjectReference `xml:"_this"`
}

func init() {
	t["DestroyPropertyFilterRequestType"] = reflect.TypeOf((*DestroyPropertyFilterRequestType)(nil)).Elem()
}

type DestroyPropertyFilterResponse struct {
}

type DestroyRequestType struct {
	This ManagedObjectReference `xml:"_this"`
}

func init() {
	t["DestroyRequestType"] = reflect.TypeOf((*DestroyRequestType)(nil)).Elem()
}

type DestroyVffs DestroyVffsRequestType

func init() {
	t["DestroyVffs"] = reflect.TypeOf((*DestroyVffs)(nil)).Elem()
}

type DestroyVffsRequestType struct {
	This     ManagedObjectReference `xml:"_this"`
	VffsPath string                 `xml:"vffsPath"`
}

func init() {
	t["DestroyVffsRequestType"] = reflect.TypeOf((*DestroyVffsRequestType)(nil)).Elem()
}

type DestroyVffsResponse struct {
}

type DestroyView DestroyViewRequestType

func init() {
	t["DestroyView"] = reflect.TypeOf((*DestroyView)(nil)).Elem()
}

type DestroyViewRequestType struct {
	This ManagedObjectReference `xml:"_this"`
}

func init() {
	t["DestroyViewRequestType"] = reflect.TypeOf((*DestroyViewRequestType)(nil)).Elem()
}

type DestroyViewResponse struct {
}

type Destroy_Task DestroyRequestType

func init() {
	t["Destroy_Task"] = reflect.TypeOf((*Destroy_Task)(nil)).Elem()
}

type Destroy_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval"`
}

type DetachDiskRequestType struct {
	This   ManagedObjectReference `xml:"_this"`
	DiskId ID                     `xml:"diskId"`
}

func init() {
	t["DetachDiskRequestType"] = reflect.TypeOf((*DetachDiskRequestType)(nil)).Elem()
}

type DetachDisk_Task DetachDiskRequestType

func init() {
	t["DetachDisk_Task"] = reflect.TypeOf((*DetachDisk_Task)(nil)).Elem()
}

type DetachDisk_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval"`
}

type DetachScsiLun DetachScsiLunRequestType

func init() {
	t["DetachScsiLun"] = reflect.TypeOf((*DetachScsiLun)(nil)).Elem()
}

type DetachScsiLunExRequestType struct {
	This    ManagedObjectReference `xml:"_this"`
	LunUuid []string               `xml:"lunUuid"`
}

func init() {
	t["DetachScsiLunExRequestType"] = reflect.TypeOf((*DetachScsiLunExRequestType)(nil)).Elem()
}

type DetachScsiLunEx_Task DetachScsiLunExRequestType

func init() {
	t["DetachScsiLunEx_Task"] = reflect.TypeOf((*DetachScsiLunEx_Task)(nil)).Elem()
}

type DetachScsiLunEx_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval"`
}

type DetachScsiLunRequestType struct {
	This    ManagedObjectReference `xml:"_this"`
	LunUuid string                 `xml:"lunUuid"`
}

func init() {
	t["DetachScsiLunRequestType"] = reflect.TypeOf((*DetachScsiLunRequestType)(nil)).Elem()
}

type DetachScsiLunResponse struct {
}

type DetachTagFromVStorageObject DetachTagFromVStorageObjectRequestType

func init() {
	t["DetachTagFromVStorageObject"] = reflect.TypeOf((*DetachTagFromVStorageObject)(nil)).Elem()
}

type DetachTagFromVStorageObjectRequestType struct {
	This     ManagedObjectReference `xml:"_this"`
	Id       ID                     `xml:"id"`
	Category string                 `xml:"category"`
	Tag      string                 `xml:"tag"`
}

func init() {
	t["DetachTagFromVStorageObjectRequestType"] = reflect.TypeOf((*DetachTagFromVStorageObjectRequestType)(nil)).Elem()
}

type DetachTagFromVStorageObjectResponse struct {
}

type DeviceBackedVirtualDiskSpec struct {
	VirtualDiskSpec

	Device string `xml:"device"`
}

func init() {
	t["DeviceBackedVirtualDiskSpec"] = reflect.TypeOf((*DeviceBackedVirtualDiskSpec)(nil)).Elem()
}

type DeviceBackingNotSupported struct {
	DeviceNotSupported

	Backing string `xml:"backing"`
}

func init() {
	t["DeviceBackingNotSupported"] = reflect.TypeOf((*DeviceBackingNotSupported)(nil)).Elem()
}

type DeviceBackingNotSupportedFault BaseDeviceBackingNotSupported

func init() {
	t["DeviceBackingNotSupportedFault"] = reflect.TypeOf((*DeviceBackingNotSupportedFault)(nil)).Elem()
}

type DeviceControllerNotSupported struct {
	DeviceNotSupported

	Controller string `xml:"controller"`
}

func init() {
	t["DeviceControllerNotSupported"] = reflect.TypeOf((*DeviceControllerNotSupported)(nil)).Elem()
}

type DeviceControllerNotSupportedFault DeviceControllerNotSupported

func init() {
	t["DeviceControllerNotSupportedFault"] = reflect.TypeOf((*DeviceControllerNotSupportedFault)(nil)).Elem()
}

type DeviceGroupId struct {
	DynamicData

	Id string `xml:"id"`
}

func init() {
	t["DeviceGroupId"] = reflect.TypeOf((*DeviceGroupId)(nil)).Elem()
}

type DeviceHotPlugNotSupported struct {
	InvalidDeviceSpec
}

func init() {
	t["DeviceHotPlugNotSupported"] = reflect.TypeOf((*DeviceHotPlugNotSupported)(nil)).Elem()
}

type DeviceHotPlugNotSupportedFault DeviceHotPlugNotSupported

func init() {
	t["DeviceHotPlugNotSupportedFault"] = reflect.TypeOf((*DeviceHotPlugNotSupportedFault)(nil)).Elem()
}

type DeviceNotFound struct {
	InvalidDeviceSpec
}

func init() {
	t["DeviceNotFound"] = reflect.TypeOf((*DeviceNotFound)(nil)).Elem()
}

type DeviceNotFoundFault DeviceNotFound

func init() {
	t["DeviceNotFoundFault"] = reflect.TypeOf((*DeviceNotFoundFault)(nil)).Elem()
}

type DeviceNotSupported struct {
	VirtualHardwareCompatibilityIssue

	Device string `xml:"device"`
	Reason string `xml:"reason,omitempty"`
}

func init() {
	t["DeviceNotSupported"] = reflect.TypeOf((*DeviceNotSupported)(nil)).Elem()
}

type DeviceNotSupportedFault BaseDeviceNotSupported

func init() {
	t["DeviceNotSupportedFault"] = reflect.TypeOf((*DeviceNotSupportedFault)(nil)).Elem()
}

type DeviceUnsupportedForVmPlatform struct {
	InvalidDeviceSpec
}

func init() {
	t["DeviceUnsupportedForVmPlatform"] = reflect.TypeOf((*DeviceUnsupportedForVmPlatform)(nil)).Elem()
}

type DeviceUnsupportedForVmPlatformFault DeviceUnsupportedForVmPlatform

func init() {
	t["DeviceUnsupportedForVmPlatformFault"] = reflect.TypeOf((*DeviceUnsupportedForVmPlatformFault)(nil)).Elem()
}

type DeviceUnsupportedForVmVersion struct {
	InvalidDeviceSpec

	CurrentVersion  string `xml:"currentVersion"`
	ExpectedVersion string `xml:"expectedVersion"`
}

func init() {
	t["DeviceUnsupportedForVmVersion"] = reflect.TypeOf((*DeviceUnsupportedForVmVersion)(nil)).Elem()
}

type DeviceUnsupportedForVmVersionFault DeviceUnsupportedForVmVersion

func init() {
	t["DeviceUnsupportedForVmVersionFault"] = reflect.TypeOf((*DeviceUnsupportedForVmVersionFault)(nil)).Elem()
}

type DiagnosticManagerAuditRecordResult struct {
	DynamicData

	Records   []string `xml:"records,omitempty"`
	NextToken string   `xml:"nextToken"`
}

func init() {
	t["DiagnosticManagerAuditRecordResult"] = reflect.TypeOf((*DiagnosticManagerAuditRecordResult)(nil)).Elem()
}

type DiagnosticManagerBundleInfo struct {
	DynamicData

	System *ManagedObjectReference `xml:"system,omitempty"`
	Url    string                  `xml:"url"`
}

func init() {
	t["DiagnosticManagerBundleInfo"] = reflect.TypeOf((*DiagnosticManagerBundleInfo)(nil)).Elem()
}

type DiagnosticManagerLogDescriptor struct {
	DynamicData

	Key      string          `xml:"key"`
	FileName string          `xml:"fileName"`
	Creator  string          `xml:"creator"`
	Format   string          `xml:"format"`
	MimeType string          `xml:"mimeType"`
	Info     BaseDescription `xml:"info,typeattr"`
}

func init() {
	t["DiagnosticManagerLogDescriptor"] = reflect.TypeOf((*DiagnosticManagerLogDescriptor)(nil)).Elem()
}

type DiagnosticManagerLogHeader struct {
	DynamicData

	LineStart int32    `xml:"lineStart"`
	LineEnd   int32    `xml:"lineEnd"`
	LineText  []string `xml:"lineText,omitempty"`
}

func init() {
	t["DiagnosticManagerLogHeader"] = reflect.TypeOf((*DiagnosticManagerLogHeader)(nil)).Elem()
}

type DigestNotSupported struct {
	DeviceNotSupported
}

func init() {
	t["DigestNotSupported"] = reflect.TypeOf((*DigestNotSupported)(nil)).Elem()
}

type DigestNotSupportedFault DigestNotSupported

func init() {
	t["DigestNotSupportedFault"] = reflect.TypeOf((*DigestNotSupportedFault)(nil)).Elem()
}

type DirectoryNotEmpty struct {
	FileFault
}

func init() {
	t["DirectoryNotEmpty"] = reflect.TypeOf((*DirectoryNotEmpty)(nil)).Elem()
}

type DirectoryNotEmptyFault DirectoryNotEmpty

func init() {
	t["DirectoryNotEmptyFault"] = reflect.TypeOf((*DirectoryNotEmptyFault)(nil)).Elem()
}

type DisableAdminNotSupported struct {
	HostConfigFault
}

func init() {
	t["DisableAdminNotSupported"] = reflect.TypeOf((*DisableAdminNotSupported)(nil)).Elem()
}

type DisableAdminNotSupportedFault DisableAdminNotSupported

func init() {
	t["DisableAdminNotSupportedFault"] = reflect.TypeOf((*DisableAdminNotSupportedFault)(nil)).Elem()
}

type DisableAlarm DisableAlarmRequestType

func init() {
	t["DisableAlarm"] = reflect.TypeOf((*DisableAlarm)(nil)).Elem()
}

type DisableAlarmRequestType struct {
	This   ManagedObjectReference `xml:"_this"`
	Alarm  ManagedObjectReference `xml:"alarm"`
	Entity ManagedObjectReference `xml:"entity"`
}

func init() {
	t["DisableAlarmRequestType"] = reflect.TypeOf((*DisableAlarmRequestType)(nil)).Elem()
}

type DisableAlarmResponse struct {
}

type DisableClusteredVmdkSupport DisableClusteredVmdkSupportRequestType

func init() {
	t["DisableClusteredVmdkSupport"] = reflect.TypeOf((*DisableClusteredVmdkSupport)(nil)).Elem()
}

type DisableClusteredVmdkSupportRequestType struct {
	This      ManagedObjectReference `xml:"_this"`
	Datastore ManagedObjectReference `xml:"datastore"`
}

func init() {
	t["DisableClusteredVmdkSupportRequestType"] = reflect.TypeOf((*DisableClusteredVmdkSupportRequestType)(nil)).Elem()
}

type DisableClusteredVmdkSupportResponse struct {
}

type DisableEvcModeRequestType struct {
	This ManagedObjectReference `xml:"_this"`
}

func init() {
	t["DisableEvcModeRequestType"] = reflect.TypeOf((*DisableEvcModeRequestType)(nil)).Elem()
}

type DisableEvcMode_Task DisableEvcModeRequestType

func init() {
	t["DisableEvcMode_Task"] = reflect.TypeOf((*DisableEvcMode_Task)(nil)).Elem()
}

type DisableEvcMode_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval"`
}

type DisableFeature DisableFeatureRequestType

func init() {
	t["DisableFeature"] = reflect.TypeOf((*DisableFeature)(nil)).Elem()
}

type DisableFeatureRequestType struct {
	This       ManagedObjectReference  `xml:"_this"`
	Host       *ManagedObjectReference `xml:"host,omitempty"`
	FeatureKey string                  `xml:"featureKey"`
}

func init() {
	t["DisableFeatureRequestType"] = reflect.TypeOf((*DisableFeatureRequestType)(nil)).Elem()
}

type DisableFeatureResponse struct {
	Returnval bool `xml:"returnval"`
}

type DisableHyperThreading DisableHyperThreadingRequestType

func init() {
	t["DisableHyperThreading"] = reflect.TypeOf((*DisableHyperThreading)(nil)).Elem()
}

type DisableHyperThreadingRequestType struct {
	This ManagedObjectReference `xml:"_this"`
}

func init() {
	t["DisableHyperThreadingRequestType"] = reflect.TypeOf((*DisableHyperThreadingRequestType)(nil)).Elem()
}

type DisableHyperThreadingResponse struct {
}

type DisableMultipathPath DisableMultipathPathRequestType

func init() {
	t["DisableMultipathPath"] = reflect.TypeOf((*DisableMultipathPath)(nil)).Elem()
}

type DisableMultipathPathRequestType struct {
	This     ManagedObjectReference `xml:"_this"`
	PathName string                 `xml:"pathName"`
}

func init() {
	t["DisableMultipathPathRequestType"] = reflect.TypeOf((*DisableMultipathPathRequestType)(nil)).Elem()
}

type DisableMultipathPathResponse struct {
}

type DisableRuleset DisableRulesetRequestType

func init() {
	t["DisableRuleset"] = reflect.TypeOf((*DisableRuleset)(nil)).Elem()
}

type DisableRulesetRequestType struct {
	This ManagedObjectReference `xml:"_this"`
	Id   string                 `xml:"id"`
}

func init() {
	t["DisableRulesetRequestType"] = reflect.TypeOf((*DisableRulesetRequestType)(nil)).Elem()
}

type DisableRulesetResponse struct {
}

type DisableSecondaryVMRequestType struct {
	This ManagedObjectReference `xml:"_this"`
	Vm   ManagedObjectReference `xml:"vm"`
}

func init() {
	t["DisableSecondaryVMRequestType"] = reflect.TypeOf((*DisableSecondaryVMRequestType)(nil)).Elem()
}

type DisableSecondaryVM_Task DisableSecondaryVMRequestType

func init() {
	t["DisableSecondaryVM_Task"] = reflect.TypeOf((*DisableSecondaryVM_Task)(nil)).Elem()
}

type DisableSecondaryVM_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval"`
}

type DisableSmartCardAuthentication DisableSmartCardAuthenticationRequestType

func init() {
	t["DisableSmartCardAuthentication"] = reflect.TypeOf((*DisableSmartCardAuthentication)(nil)).Elem()
}

type DisableSmartCardAuthenticationRequestType struct {
	This ManagedObjectReference `xml:"_this"`
}

func init() {
	t["DisableSmartCardAuthenticationRequestType"] = reflect.TypeOf((*DisableSmartCardAuthenticationRequestType)(nil)).Elem()
}

type DisableSmartCardAuthenticationResponse struct {
}

type DisallowedChangeByService struct {
	RuntimeFault

	ServiceName      string `xml:"serviceName"`
	DisallowedChange string `xml:"disallowedChange,omitempty"`
}

func init() {
	t["DisallowedChangeByService"] = reflect.TypeOf((*DisallowedChangeByService)(nil)).Elem()
}

type DisallowedChangeByServiceFault DisallowedChangeByService

func init() {
	t["DisallowedChangeByServiceFault"] = reflect.TypeOf((*DisallowedChangeByServiceFault)(nil)).Elem()
}

type DisallowedDiskModeChange struct {
	InvalidDeviceSpec
}

func init() {
	t["DisallowedDiskModeChange"] = reflect.TypeOf((*DisallowedDiskModeChange)(nil)).Elem()
}

type DisallowedDiskModeChangeFault DisallowedDiskModeChange

func init() {
	t["DisallowedDiskModeChangeFault"] = reflect.TypeOf((*DisallowedDiskModeChangeFault)(nil)).Elem()
}

type DisallowedMigrationDeviceAttached struct {
	MigrationFault

	Fault LocalizedMethodFault `xml:"fault"`
}

func init() {
	t["DisallowedMigrationDeviceAttached"] = reflect.TypeOf((*DisallowedMigrationDeviceAttached)(nil)).Elem()
}

type DisallowedMigrationDeviceAttachedFault DisallowedMigrationDeviceAttached

func init() {
	t["DisallowedMigrationDeviceAttachedFault"] = reflect.TypeOf((*DisallowedMigrationDeviceAttachedFault)(nil)).Elem()
}

type DisallowedOperationOnFailoverHost struct {
	RuntimeFault

	Host     ManagedObjectReference `xml:"host"`
	Hostname string                 `xml:"hostname"`
}

func init() {
	t["DisallowedOperationOnFailoverHost"] = reflect.TypeOf((*DisallowedOperationOnFailoverHost)(nil)).Elem()
}

type DisallowedOperationOnFailoverHostFault DisallowedOperationOnFailoverHost

func init() {
	t["DisallowedOperationOnFailoverHostFault"] = reflect.TypeOf((*DisallowedOperationOnFailoverHostFault)(nil)).Elem()
}

type DisconnectHostRequestType struct {
	This ManagedObjectReference `xml:"_this"`
}

func init() {
	t["DisconnectHostRequestType"] = reflect.TypeOf((*DisconnectHostRequestType)(nil)).Elem()
}

type DisconnectHost_Task DisconnectHostRequestType

func init() {
	t["DisconnectHost_Task"] = reflect.TypeOf((*DisconnectHost_Task)(nil)).Elem()
}

type DisconnectHost_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval"`
}

type DisconnectNvmeController DisconnectNvmeControllerRequestType

func init() {
	t["DisconnectNvmeController"] = reflect.TypeOf((*DisconnectNvmeController)(nil)).Elem()
}

type DisconnectNvmeControllerExRequestType struct {
	This           ManagedObjectReference   `xml:"_this"`
	DisconnectSpec []HostNvmeDisconnectSpec `xml:"disconnectSpec,omitempty"`
}

func init() {
	t["DisconnectNvmeControllerExRequestType"] = reflect.TypeOf((*DisconnectNvmeControllerExRequestType)(nil)).Elem()
}

type DisconnectNvmeControllerEx_Task DisconnectNvmeControllerExRequestType

func init() {
	t["DisconnectNvmeControllerEx_Task"] = reflect.TypeOf((*DisconnectNvmeControllerEx_Task)(nil)).Elem()
}

type DisconnectNvmeControllerEx_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval"`
}

type DisconnectNvmeControllerRequestType struct {
	This           ManagedObjectReference `xml:"_this"`
	DisconnectSpec HostNvmeDisconnectSpec `xml:"disconnectSpec"`
}

func init() {
	t["DisconnectNvmeControllerRequestType"] = reflect.TypeOf((*DisconnectNvmeControllerRequestType)(nil)).Elem()
}

type DisconnectNvmeControllerResponse struct {
}

type DisconnectedHostsBlockingEVC struct {
	EVCConfigFault
}

func init() {
	t["DisconnectedHostsBlockingEVC"] = reflect.TypeOf((*DisconnectedHostsBlockingEVC)(nil)).Elem()
}

type DisconnectedHostsBlockingEVCFault DisconnectedHostsBlockingEVC

func init() {
	t["DisconnectedHostsBlockingEVCFault"] = reflect.TypeOf((*DisconnectedHostsBlockingEVCFault)(nil)).Elem()
}

type DiscoverFcoeHbas DiscoverFcoeHbasRequestType

func init() {
	t["DiscoverFcoeHbas"] = reflect.TypeOf((*DiscoverFcoeHbas)(nil)).Elem()
}

type DiscoverFcoeHbasRequestType struct {
	This     ManagedObjectReference      `xml:"_this"`
	FcoeSpec FcoeConfigFcoeSpecification `xml:"fcoeSpec"`
}

func init() {
	t["DiscoverFcoeHbasRequestType"] = reflect.TypeOf((*DiscoverFcoeHbasRequestType)(nil)).Elem()
}

type DiscoverFcoeHbasResponse struct {
}

type DiscoverNvmeControllers DiscoverNvmeControllersRequestType

func init() {
	t["DiscoverNvmeControllers"] = reflect.TypeOf((*DiscoverNvmeControllers)(nil)).Elem()
}

type DiscoverNvmeControllersRequestType struct {
	This         ManagedObjectReference `xml:"_this"`
	DiscoverSpec HostNvmeDiscoverSpec   `xml:"discoverSpec"`
}

func init() {
	t["DiscoverNvmeControllersRequestType"] = reflect.TypeOf((*DiscoverNvmeControllersRequestType)(nil)).Elem()
}

type DiscoverNvmeControllersResponse struct {
	Returnval HostNvmeDiscoveryLog `xml:"returnval"`
}

type DiskChangeExtent struct {
	DynamicData

	Start  int64 `xml:"start"`
	Length int64 `xml:"length"`
}

func init() {
	t["DiskChangeExtent"] = reflect.TypeOf((*DiskChangeExtent)(nil)).Elem()
}

type DiskChangeInfo struct {
	DynamicData

	StartOffset int64              `xml:"startOffset"`
	Length      int64              `xml:"length"`
	ChangedArea []DiskChangeExtent `xml:"changedArea,omitempty"`
}

func init() {
	t["DiskChangeInfo"] = reflect.TypeOf((*DiskChangeInfo)(nil)).Elem()
}

type DiskCryptoSpec struct {
	DynamicData

	Parent *DiskCryptoSpec `xml:"parent,omitempty"`
	Crypto BaseCryptoSpec  `xml:"crypto,typeattr"`
}

func init() {
	t["DiskCryptoSpec"] = reflect.TypeOf((*DiskCryptoSpec)(nil)).Elem()
}

type DiskHasPartitions struct {
	VsanDiskFault
}

func init() {
	t["DiskHasPartitions"] = reflect.TypeOf((*DiskHasPartitions)(nil)).Elem()
}

type DiskHasPartitionsFault DiskHasPartitions

func init() {
	t["DiskHasPartitionsFault"] = reflect.TypeOf((*DiskHasPartitionsFault)(nil)).Elem()
}

type DiskIsLastRemainingNonSSD struct {
	VsanDiskFault
}

func init() {
	t["DiskIsLastRemainingNonSSD"] = reflect.TypeOf((*DiskIsLastRemainingNonSSD)(nil)).Elem()
}

type DiskIsLastRemainingNonSSDFault DiskIsLastRemainingNonSSD

func init() {
	t["DiskIsLastRemainingNonSSDFault"] = reflect.TypeOf((*DiskIsLastRemainingNonSSDFault)(nil)).Elem()
}

type DiskIsNonLocal struct {
	VsanDiskFault
}

func init() {
	t["DiskIsNonLocal"] = reflect.TypeOf((*DiskIsNonLocal)(nil)).Elem()
}

type DiskIsNonLocalFault DiskIsNonLocal

func init() {
	t["DiskIsNonLocalFault"] = reflect.TypeOf((*DiskIsNonLocalFault)(nil)).Elem()
}

type DiskIsUSB struct {
	VsanDiskFault
}

func init() {
	t["DiskIsUSB"] = reflect.TypeOf((*DiskIsUSB)(nil)).Elem()
}

type DiskIsUSBFault DiskIsUSB

func init() {
	t["DiskIsUSBFault"] = reflect.TypeOf((*DiskIsUSBFault)(nil)).Elem()
}

type DiskMoveTypeNotSupported struct {
	MigrationFault
}

func init() {
	t["DiskMoveTypeNotSupported"] = reflect.TypeOf((*DiskMoveTypeNotSupported)(nil)).Elem()
}

type DiskMoveTypeNotSupportedFault DiskMoveTypeNotSupported

func init() {
	t["DiskMoveTypeNotSupportedFault"] = reflect.TypeOf((*DiskMoveTypeNotSupportedFault)(nil)).Elem()
}

type DiskNotSupported struct {
	VirtualHardwareCompatibilityIssue

	Disk int32 `xml:"disk"`
}

func init() {
	t["DiskNotSupported"] = reflect.TypeOf((*DiskNotSupported)(nil)).Elem()
}

type DiskNotSupportedFault BaseDiskNotSupported

func init() {
	t["DiskNotSupportedFault"] = reflect.TypeOf((*DiskNotSupportedFault)(nil)).Elem()
}

type DiskTooSmall struct {
	VsanDiskFault
}

func init() {
	t["DiskTooSmall"] = reflect.TypeOf((*DiskTooSmall)(nil)).Elem()
}

type DiskTooSmallFault DiskTooSmall

func init() {
	t["DiskTooSmallFault"] = reflect.TypeOf((*DiskTooSmallFault)(nil)).Elem()
}

type DissociateProfile DissociateProfileRequestType

func init() {
	t["DissociateProfile"] = reflect.TypeOf((*DissociateProfile)(nil)).Elem()
}

type DissociateProfileRequestType struct {
	This   ManagedObjectReference   `xml:"_this"`
	Entity []ManagedObjectReference `xml:"entity,omitempty"`
}

func init() {
	t["DissociateProfileRequestType"] = reflect.TypeOf((*DissociateProfileRequestType)(nil)).Elem()
}

type DissociateProfileResponse struct {
}

type DistributedVirtualPort struct {
	DynamicData

	Key              string                                 `xml:"key"`
	Config           DVPortConfigInfo                       `xml:"config"`
	DvsUuid          string                                 `xml:"dvsUuid"`
	PortgroupKey     string                                 `xml:"portgroupKey,omitempty"`
	ProxyHost        *ManagedObjectReference                `xml:"proxyHost,omitempty"`
	Connectee        *DistributedVirtualSwitchPortConnectee `xml:"connectee,omitempty"`
	Conflict         bool                                   `xml:"conflict"`
	ConflictPortKey  string                                 `xml:"conflictPortKey,omitempty"`
	State            *DVPortState                           `xml:"state,omitempty"`
	ConnectionCookie int32                                  `xml:"connectionCookie,omitempty"`
	LastStatusChange time.Time                              `xml:"lastStatusChange"`
	HostLocalPort    *bool                                  `xml:"hostLocalPort"`
	ExternalId       string                                 `xml:"externalId,omitempty"`
	SegmentPortId    string                                 `xml:"segmentPortId,omitempty"`
}

func init() {
	t["DistributedVirtualPort"] = reflect.TypeOf((*DistributedVirtualPort)(nil)).Elem()
}

type DistributedVirtualPortgroupInfo struct {
	DynamicData

	SwitchName                  string                 `xml:"switchName"`
	SwitchUuid                  string                 `xml:"switchUuid"`
	PortgroupName               string                 `xml:"portgroupName"`
	PortgroupKey                string                 `xml:"portgroupKey"`
	PortgroupType               string                 `xml:"portgroupType"`
	UplinkPortgroup             bool                   `xml:"uplinkPortgroup"`
	Portgroup                   ManagedObjectReference `xml:"portgroup"`
	NetworkReservationSupported *bool                  `xml:"networkReservationSupported"`
	BackingType                 string                 `xml:"backingType,omitempty"`
	LogicalSwitchUuid           string                 `xml:"logicalSwitchUuid,omitempty"`
	SegmentId                   string                 `xml:"segmentId,omitempty"`
}

func init() {
	t["DistributedVirtualPortgroupInfo"] = reflect.TypeOf((*DistributedVirtualPortgroupInfo)(nil)).Elem()
}

type DistributedVirtualPortgroupNsxPortgroupOperationResult struct {
	DynamicData

	Portgroups []ManagedObjectReference             `xml:"portgroups,omitempty"`
	Problems   []DistributedVirtualPortgroupProblem `xml:"problems,omitempty"`
}

func init() {
	t["DistributedVirtualPortgroupNsxPortgroupOperationResult"] = reflect.TypeOf((*DistributedVirtualPortgroupNsxPortgroupOperationResult)(nil)).Elem()
}

type DistributedVirtualPortgroupProblem struct {
	DynamicData

	LogicalSwitchUuid string               `xml:"logicalSwitchUuid"`
	Fault             LocalizedMethodFault `xml:"fault"`
}

func init() {
	t["DistributedVirtualPortgroupProblem"] = reflect.TypeOf((*DistributedVirtualPortgroupProblem)(nil)).Elem()
}

type DistributedVirtualSwitchHostMember struct {
	DynamicData

	RuntimeState  *DistributedVirtualSwitchHostMemberRuntimeState `xml:"runtimeState,omitempty"`
	Config        DistributedVirtualSwitchHostMemberConfigInfo    `xml:"config"`
	ProductInfo   *DistributedVirtualSwitchProductSpec            `xml:"productInfo,omitempty"`
	UplinkPortKey []string                                        `xml:"uplinkPortKey,omitempty"`
	Status        string                                          `xml:"status"`
	StatusDetail  string                                          `xml:"statusDetail,omitempty"`
}

func init() {
	t["DistributedVirtualSwitchHostMember"] = reflect.TypeOf((*DistributedVirtualSwitchHostMember)(nil)).Elem()
}

type DistributedVirtualSwitchHostMemberBacking struct {
	DynamicData
}

func init() {
	t["DistributedVirtualSwitchHostMemberBacking"] = reflect.TypeOf((*DistributedVirtualSwitchHostMemberBacking)(nil)).Elem()
}

type DistributedVirtualSwitchHostMemberConfigInfo struct {
	DynamicData

	Host                 *ManagedObjectReference                               `xml:"host,omitempty"`
	MaxProxySwitchPorts  int32                                                 `xml:"maxProxySwitchPorts"`
	VendorSpecificConfig []DistributedVirtualSwitchKeyedOpaqueBlob             `xml:"vendorSpecificConfig,omitempty"`
	Backing              BaseDistributedVirtualSwitchHostMemberBacking         `xml:"backing,typeattr"`
	NsxSwitch            *bool                                                 `xml:"nsxSwitch"`
	EnsEnabled           *bool                                                 `xml:"ensEnabled"`
	EnsInterruptEnabled  *bool                                                 `xml:"ensInterruptEnabled"`
	TransportZones       []DistributedVirtualSwitchHostMemberTransportZoneInfo `xml:"transportZones,omitempty"`
	NsxtUsedUplinkNames  []string                                              `xml:"nsxtUsedUplinkNames,omitempty"`
}

func init() {
	t["DistributedVirtualSwitchHostMemberConfigInfo"] = reflect.TypeOf((*DistributedVirtualSwitchHostMemberConfigInfo)(nil)).Elem()
}

type DistributedVirtualSwitchHostMemberConfigSpec struct {
	DynamicData

	Operation            string                                        `xml:"operation"`
	Host                 ManagedObjectReference                        `xml:"host"`
	Backing              BaseDistributedVirtualSwitchHostMemberBacking `xml:"backing,omitempty,typeattr"`
	MaxProxySwitchPorts  int32                                         `xml:"maxProxySwitchPorts,omitempty"`
	VendorSpecificConfig []DistributedVirtualSwitchKeyedOpaqueBlob     `xml:"vendorSpecificConfig,omitempty"`
}

func init() {
	t["DistributedVirtualSwitchHostMemberConfigSpec"] = reflect.TypeOf((*DistributedVirtualSwitchHostMemberConfigSpec)(nil)).Elem()
}

type DistributedVirtualSwitchHostMemberPnicBacking struct {
	DistributedVirtualSwitchHostMemberBacking

	PnicSpec []DistributedVirtualSwitchHostMemberPnicSpec `xml:"pnicSpec,omitempty"`
}

func init() {
	t["DistributedVirtualSwitchHostMemberPnicBacking"] = reflect.TypeOf((*DistributedVirtualSwitchHostMemberPnicBacking)(nil)).Elem()
}

type DistributedVirtualSwitchHostMemberPnicSpec struct {
	DynamicData

	PnicDevice         string `xml:"pnicDevice"`
	UplinkPortKey      string `xml:"uplinkPortKey,omitempty"`
	UplinkPortgroupKey string `xml:"uplinkPortgroupKey,omitempty"`
	ConnectionCookie   int32  `xml:"connectionCookie,omitempty"`
}

func init() {
	t["DistributedVirtualSwitchHostMemberPnicSpec"] = reflect.TypeOf((*DistributedVirtualSwitchHostMemberPnicSpec)(nil)).Elem()
}

type DistributedVirtualSwitchHostMemberRuntimeState struct {
	DynamicData

	CurrentMaxProxySwitchPorts int32 `xml:"currentMaxProxySwitchPorts"`
}

func init() {
	t["DistributedVirtualSwitchHostMemberRuntimeState"] = reflect.TypeOf((*DistributedVirtualSwitchHostMemberRuntimeState)(nil)).Elem()
}

type DistributedVirtualSwitchHostMemberTransportZoneInfo struct {
	DynamicData

	Uuid string `xml:"uuid"`
	Type string `xml:"type"`
}

func init() {
	t["DistributedVirtualSwitchHostMemberTransportZoneInfo"] = reflect.TypeOf((*DistributedVirtualSwitchHostMemberTransportZoneInfo)(nil)).Elem()
}

type DistributedVirtualSwitchHostProductSpec struct {
	DynamicData

	ProductLineId string `xml:"productLineId,omitempty"`
	Version       string `xml:"version,omitempty"`
}

func init() {
	t["DistributedVirtualSwitchHostProductSpec"] = reflect.TypeOf((*DistributedVirtualSwitchHostProductSpec)(nil)).Elem()
}

type DistributedVirtualSwitchInfo struct {
	DynamicData

	SwitchName                  string                 `xml:"switchName"`
	SwitchUuid                  string                 `xml:"switchUuid"`
	DistributedVirtualSwitch    ManagedObjectReference `xml:"distributedVirtualSwitch"`
	NetworkReservationSupported *bool                  `xml:"networkReservationSupported"`
}

func init() {
	t["DistributedVirtualSwitchInfo"] = reflect.TypeOf((*DistributedVirtualSwitchInfo)(nil)).Elem()
}

type DistributedVirtualSwitchKeyedOpaqueBlob struct {
	DynamicData

	Key        string `xml:"key"`
	OpaqueData string `xml:"opaqueData"`
}

func init() {
	t["DistributedVirtualSwitchKeyedOpaqueBlob"] = reflect.TypeOf((*DistributedVirtualSwitchKeyedOpaqueBlob)(nil)).Elem()
}

type DistributedVirtualSwitchManagerCompatibilityResult struct {
	DynamicData

	Host  ManagedObjectReference `xml:"host"`
	Error []LocalizedMethodFault `xml:"error,omitempty"`
}

func init() {
	t["DistributedVirtualSwitchManagerCompatibilityResult"] = reflect.TypeOf((*DistributedVirtualSwitchManagerCompatibilityResult)(nil)).Elem()
}

type DistributedVirtualSwitchManagerDvsProductSpec struct {
	DynamicData

	NewSwitchProductSpec     *DistributedVirtualSwitchProductSpec `xml:"newSwitchProductSpec,omitempty"`
	DistributedVirtualSwitch *ManagedObjectReference              `xml:"distributedVirtualSwitch,omitempty"`
}

func init() {
	t["DistributedVirtualSwitchManagerDvsProductSpec"] = reflect.TypeOf((*DistributedVirtualSwitchManagerDvsProductSpec)(nil)).Elem()
}

type DistributedVirtualSwitchManagerHostArrayFilter struct {
	DistributedVirtualSwitchManagerHostDvsFilterSpec

	Host []ManagedObjectReference `xml:"host"`
}

func init() {
	t["DistributedVirtualSwitchManagerHostArrayFilter"] = reflect.TypeOf((*DistributedVirtualSwitchManagerHostArrayFilter)(nil)).Elem()
}

type DistributedVirtualSwitchManagerHostContainer struct {
	DynamicData

	Container ManagedObjectReference `xml:"container"`
	Recursive bool                   `xml:"recursive"`
}

func init() {
	t["DistributedVirtualSwitchManagerHostContainer"] = reflect.TypeOf((*DistributedVirtualSwitchManagerHostContainer)(nil)).Elem()
}

type DistributedVirtualSwitchManagerHostContainerFilter struct {
	DistributedVirtualSwitchManagerHostDvsFilterSpec

	HostContainer DistributedVirtualSwitchManagerHostContainer `xml:"hostContainer"`
}

func init() {
	t["DistributedVirtualSwitchManagerHostContainerFilter"] = reflect.TypeOf((*DistributedVirtualSwitchManagerHostContainerFilter)(nil)).Elem()
}

type DistributedVirtualSwitchManagerHostDvsFilterSpec struct {
	DynamicData

	Inclusive bool `xml:"inclusive"`
}

func init() {
	t["DistributedVirtualSwitchManagerHostDvsFilterSpec"] = reflect.TypeOf((*DistributedVirtualSwitchManagerHostDvsFilterSpec)(nil)).Elem()
}

type DistributedVirtualSwitchManagerHostDvsMembershipFilter struct {
	DistributedVirtualSwitchManagerHostDvsFilterSpec

	DistributedVirtualSwitch ManagedObjectReference `xml:"distributedVirtualSwitch"`
}

func init() {
	t["DistributedVirtualSwitchManagerHostDvsMembershipFilter"] = reflect.TypeOf((*DistributedVirtualSwitchManagerHostDvsMembershipFilter)(nil)).Elem()
}

type DistributedVirtualSwitchManagerImportResult struct {
	DynamicData

	DistributedVirtualSwitch    []ManagedObjectReference                `xml:"distributedVirtualSwitch,omitempty"`
	DistributedVirtualPortgroup []ManagedObjectReference                `xml:"distributedVirtualPortgroup,omitempty"`
	ImportFault                 []ImportOperationBulkFaultFaultOnImport `xml:"importFault,omitempty"`
}

func init() {
	t["DistributedVirtualSwitchManagerImportResult"] = reflect.TypeOf((*DistributedVirtualSwitchManagerImportResult)(nil)).Elem()
}

type DistributedVirtualSwitchPortConnectee struct {
	DynamicData

	ConnectedEntity *ManagedObjectReference `xml:"connectedEntity,omitempty"`
	NicKey          string                  `xml:"nicKey,omitempty"`
	Type            string                  `xml:"type,omitempty"`
	AddressHint     string                  `xml:"addressHint,omitempty"`
}

func init() {
	t["DistributedVirtualSwitchPortConnectee"] = reflect.TypeOf((*DistributedVirtualSwitchPortConnectee)(nil)).Elem()
}

type DistributedVirtualSwitchPortConnection struct {
	DynamicData

	SwitchUuid       string `xml:"switchUuid"`
	PortgroupKey     string `xml:"portgroupKey,omitempty"`
	PortKey          string `xml:"portKey,omitempty"`
	ConnectionCookie int32  `xml:"connectionCookie,omitempty"`
}

func init() {
	t["DistributedVirtualSwitchPortConnection"] = reflect.TypeOf((*DistributedVirtualSwitchPortConnection)(nil)).Elem()
}

type DistributedVirtualSwitchPortCriteria struct {
	DynamicData

	Connected    *bool                    `xml:"connected"`
	Active       *bool                    `xml:"active"`
	UplinkPort   *bool                    `xml:"uplinkPort"`
	NsxPort      *bool                    `xml:"nsxPort"`
	Scope        *ManagedObjectReference  `xml:"scope,omitempty"`
	PortgroupKey []string                 `xml:"portgroupKey,omitempty"`
	Inside       *bool                    `xml:"inside"`
	PortKey      []string                 `xml:"portKey,omitempty"`
	Host         []ManagedObjectReference `xml:"host,omitempty"`
}

func init() {
	t["DistributedVirtualSwitchPortCriteria"] = reflect.TypeOf((*DistributedVirtualSwitchPortCriteria)(nil)).Elem()
}

type DistributedVirtualSwitchPortStatistics struct {
	DynamicData

	PacketsInMulticast  int64 `xml:"packetsInMulticast"`
	PacketsOutMulticast int64 `xml:"packetsOutMulticast"`
	BytesInMulticast    int64 `xml:"bytesInMulticast"`
	BytesOutMulticast   int64 `xml:"bytesOutMulticast"`
	PacketsInUnicast    int64 `xml:"packetsInUnicast"`
	PacketsOutUnicast   int64 `xml:"packetsOutUnicast"`
	BytesInUnicast      int64 `xml:"bytesInUnicast"`
	BytesOutUnicast     int64 `xml:"bytesOutUnicast"`
	PacketsInBroadcast  int64 `xml:"packetsInBroadcast"`
	PacketsOutBroadcast int64 `xml:"packetsOutBroadcast"`
	BytesInBroadcast    int64 `xml:"bytesInBroadcast"`
	BytesOutBroadcast   int64 `xml:"bytesOutBroadcast"`
	PacketsInDropped    int64 `xml:"packetsInDropped"`
	PacketsOutDropped   int64 `xml:"packetsOutDropped"`
	PacketsInException  int64 `xml:"packetsInException"`
	PacketsOutException int64 `xml:"packetsOutException"`
	BytesInFromPnic     int64 `xml:"bytesInFromPnic,omitempty"`
	BytesOutToPnic      int64 `xml:"bytesOutToPnic,omitempty"`
}

func init() {
	t["DistributedVirtualSwitchPortStatistics"] = reflect.TypeOf((*DistributedVirtualSwitchPortStatistics)(nil)).Elem()
}

type DistributedVirtualSwitchProductSpec struct {
	DynamicData

	Name            string `xml:"name,omitempty"`
	Vendor          string `xml:"vendor,omitempty"`
	Version         string `xml:"version,omitempty"`
	Build           string `xml:"build,omitempty"`
	ForwardingClass string `xml:"forwardingClass,omitempty"`
	BundleId        string `xml:"bundleId,omitempty"`
	BundleUrl       string `xml:"bundleUrl,omitempty"`
}

func init() {
	t["DistributedVirtualSwitchProductSpec"] = reflect.TypeOf((*DistributedVirtualSwitchProductSpec)(nil)).Elem()
}

type DoesCustomizationSpecExist DoesCustomizationSpecExistRequestType

func init() {
	t["DoesCustomizationSpecExist"] = reflect.TypeOf((*DoesCustomizationSpecExist)(nil)).Elem()
}

type DoesCustomizationSpecExistRequestType struct {
	This ManagedObjectReference `xml:"_this"`
	Name string                 `xml:"name"`
}

func init() {
	t["DoesCustomizationSpecExistRequestType"] = reflect.TypeOf((*DoesCustomizationSpecExistRequestType)(nil)).Elem()
}

type DoesCustomizationSpecExistResponse struct {
	Returnval bool `xml:"returnval"`
}

type DomainNotFound struct {
	ActiveDirectoryFault

	DomainName string `xml:"domainName"`
}

func init() {
	t["DomainNotFound"] = reflect.TypeOf((*DomainNotFound)(nil)).Elem()
}

type DomainNotFoundFault DomainNotFound

func init() {
	t["DomainNotFoundFault"] = reflect.TypeOf((*DomainNotFoundFault)(nil)).Elem()
}

type DownloadDescriptionTree DownloadDescriptionTreeRequestType

func init() {
	t["DownloadDescriptionTree"] = reflect.TypeOf((*DownloadDescriptionTree)(nil)).Elem()
}

type DownloadDescriptionTreeRequestType struct {
	This ManagedObjectReference `xml:"_this"`
}

func init() {
	t["DownloadDescriptionTreeRequestType"] = reflect.TypeOf((*DownloadDescriptionTreeRequestType)(nil)).Elem()
}

type DownloadDescriptionTreeResponse struct {
	Returnval []byte `xml:"returnval"`
}

type DropConnections DropConnectionsRequestType

func init() {
	t["DropConnections"] = reflect.TypeOf((*DropConnections)(nil)).Elem()
}

type DropConnectionsRequestType struct {
	This              ManagedObjectReference         `xml:"_this"`
	ListOfConnections []BaseVirtualMachineConnection `xml:"listOfConnections,omitempty,typeattr"`
}

func init() {
	t["DropConnectionsRequestType"] = reflect.TypeOf((*DropConnectionsRequestType)(nil)).Elem()
}

type DropConnectionsResponse struct {
	Returnval bool `xml:"returnval"`
}

type DrsDisabledEvent struct {
	ClusterEvent
}

func init() {
	t["DrsDisabledEvent"] = reflect.TypeOf((*DrsDisabledEvent)(nil)).Elem()
}

type DrsDisabledOnVm struct {
	VimFault
}

func init() {
	t["DrsDisabledOnVm"] = reflect.TypeOf((*DrsDisabledOnVm)(nil)).Elem()
}

type DrsDisabledOnVmFault DrsDisabledOnVm

func init() {
	t["DrsDisabledOnVmFault"] = reflect.TypeOf((*DrsDisabledOnVmFault)(nil)).Elem()
}

type DrsEnabledEvent struct {
	ClusterEvent

	Behavior string `xml:"behavior"`
}

func init() {
	t["DrsEnabledEvent"] = reflect.TypeOf((*DrsEnabledEvent)(nil)).Elem()
}

type DrsEnteredStandbyModeEvent struct {
	EnteredStandbyModeEvent
}

func init() {
	t["DrsEnteredStandbyModeEvent"] = reflect.TypeOf((*DrsEnteredStandbyModeEvent)(nil)).Elem()
}

type DrsEnteringStandbyModeEvent struct {
	EnteringStandbyModeEvent
}

func init() {
	t["DrsEnteringStandbyModeEvent"] = reflect.TypeOf((*DrsEnteringStandbyModeEvent)(nil)).Elem()
}

type DrsExitStandbyModeFailedEvent struct {
	ExitStandbyModeFailedEvent
}

func init() {
	t["DrsExitStandbyModeFailedEvent"] = reflect.TypeOf((*DrsExitStandbyModeFailedEvent)(nil)).Elem()
}

type DrsExitedStandbyModeEvent struct {
	ExitedStandbyModeEvent
}

func init() {
	t["DrsExitedStandbyModeEvent"] = reflect.TypeOf((*DrsExitedStandbyModeEvent)(nil)).Elem()
}

type DrsExitingStandbyModeEvent struct {
	ExitingStandbyModeEvent
}

func init() {
	t["DrsExitingStandbyModeEvent"] = reflect.TypeOf((*DrsExitingStandbyModeEvent)(nil)).Elem()
}

type DrsInvocationFailedEvent struct {
	ClusterEvent
}

func init() {
	t["DrsInvocationFailedEvent"] = reflect.TypeOf((*DrsInvocationFailedEvent)(nil)).Elem()
}

type DrsRecoveredFromFailureEvent struct {
	ClusterEvent
}

func init() {
	t["DrsRecoveredFromFailureEvent"] = reflect.TypeOf((*DrsRecoveredFromFailureEvent)(nil)).Elem()
}

type DrsResourceConfigureFailedEvent struct {
	HostEvent

	Reason LocalizedMethodFault `xml:"reason"`
}

func init() {
	t["DrsResourceConfigureFailedEvent"] = reflect.TypeOf((*DrsResourceConfigureFailedEvent)(nil)).Elem()
}

type DrsResourceConfigureSyncedEvent struct {
	HostEvent
}

func init() {
	t["DrsResourceConfigureSyncedEvent"] = reflect.TypeOf((*DrsResourceConfigureSyncedEvent)(nil)).Elem()
}

type DrsRuleComplianceEvent struct {
	VmEvent
}

func init() {
	t["DrsRuleComplianceEvent"] = reflect.TypeOf((*DrsRuleComplianceEvent)(nil)).Elem()
}

type DrsRuleViolationEvent struct {
	VmEvent
}

func init() {
	t["DrsRuleViolationEvent"] = reflect.TypeOf((*DrsRuleViolationEvent)(nil)).Elem()
}

type DrsSoftRuleViolationEvent struct {
	VmEvent
}

func init() {
	t["DrsSoftRuleViolationEvent"] = reflect.TypeOf((*DrsSoftRuleViolationEvent)(nil)).Elem()
}

type DrsVmMigratedEvent struct {
	VmMigratedEvent
}

func init() {
	t["DrsVmMigratedEvent"] = reflect.TypeOf((*DrsVmMigratedEvent)(nil)).Elem()
}

type DrsVmPoweredOnEvent struct {
	VmPoweredOnEvent
}

func init() {
	t["DrsVmPoweredOnEvent"] = reflect.TypeOf((*DrsVmPoweredOnEvent)(nil)).Elem()
}

type DrsVmotionIncompatibleFault struct {
	VirtualHardwareCompatibilityIssue

	Host ManagedObjectReference `xml:"host"`
}

func init() {
	t["DrsVmotionIncompatibleFault"] = reflect.TypeOf((*DrsVmotionIncompatibleFault)(nil)).Elem()
}

type DrsVmotionIncompatibleFaultFault DrsVmotionIncompatibleFault

func init() {
	t["DrsVmotionIncompatibleFaultFault"] = reflect.TypeOf((*DrsVmotionIncompatibleFaultFault)(nil)).Elem()
}

type DuplicateCustomizationSpec DuplicateCustomizationSpecRequestType

func init() {
	t["DuplicateCustomizationSpec"] = reflect.TypeOf((*DuplicateCustomizationSpec)(nil)).Elem()
}

type DuplicateCustomizationSpecRequestType struct {
	This    ManagedObjectReference `xml:"_this"`
	Name    string                 `xml:"name"`
	NewName string                 `xml:"newName"`
}

func init() {
	t["DuplicateCustomizationSpecRequestType"] = reflect.TypeOf((*DuplicateCustomizationSpecRequestType)(nil)).Elem()
}

type DuplicateCustomizationSpecResponse struct {
}

type DuplicateDisks struct {
	VsanDiskFault
}

func init() {
	t["DuplicateDisks"] = reflect.TypeOf((*DuplicateDisks)(nil)).Elem()
}

type DuplicateDisksFault DuplicateDisks

func init() {
	t["DuplicateDisksFault"] = reflect.TypeOf((*DuplicateDisksFault)(nil)).Elem()
}

type DuplicateIpDetectedEvent struct {
	HostEvent

	DuplicateIP string `xml:"duplicateIP"`
	MacAddress  string `xml:"macAddress"`
}

func init() {
	t["DuplicateIpDetectedEvent"] = reflect.TypeOf((*DuplicateIpDetectedEvent)(nil)).Elem()
}

type DuplicateName struct {
	VimFault

	Name   string                 `xml:"name"`
	Object ManagedObjectReference `xml:"object"`
}

func init() {
	t["DuplicateName"] = reflect.TypeOf((*DuplicateName)(nil)).Elem()
}

type DuplicateNameFault DuplicateName

func init() {
	t["DuplicateNameFault"] = reflect.TypeOf((*DuplicateNameFault)(nil)).Elem()
}

type DuplicateVsanNetworkInterface struct {
	VsanFault

	Device string `xml:"device"`
}

func init() {
	t["DuplicateVsanNetworkInterface"] = reflect.TypeOf((*DuplicateVsanNetworkInterface)(nil)).Elem()
}

type DuplicateVsanNetworkInterfaceFault DuplicateVsanNetworkInterface

func init() {
	t["DuplicateVsanNetworkInterfaceFault"] = reflect.TypeOf((*DuplicateVsanNetworkInterfaceFault)(nil)).Elem()
}

type DvpgImportEvent struct {
	DVPortgroupEvent

	ImportType string `xml:"importType"`
}

func init() {
	t["DvpgImportEvent"] = reflect.TypeOf((*DvpgImportEvent)(nil)).Elem()
}

type DvpgRestoreEvent struct {
	DVPortgroupEvent
}

func init() {
	t["DvpgRestoreEvent"] = reflect.TypeOf((*DvpgRestoreEvent)(nil)).Elem()
}

type DvsAcceptNetworkRuleAction struct {
	DvsNetworkRuleAction
}

func init() {
	t["DvsAcceptNetworkRuleAction"] = reflect.TypeOf((*DvsAcceptNetworkRuleAction)(nil)).Elem()
}

type DvsApplyOperationFault struct {
	DvsFault

	ObjectFault []DvsApplyOperationFaultFaultOnObject `xml:"objectFault"`
}

func init() {
	t["DvsApplyOperationFault"] = reflect.TypeOf((*DvsApplyOperationFault)(nil)).Elem()
}

type DvsApplyOperationFaultFault DvsApplyOperationFault

func init() {
	t["DvsApplyOperationFaultFault"] = reflect.TypeOf((*DvsApplyOperationFaultFault)(nil)).Elem()
}

type DvsApplyOperationFaultFaultOnObject struct {
	DynamicData

	ObjectId string               `xml:"objectId"`
	Type     string               `xml:"type"`
	Fault    LocalizedMethodFault `xml:"fault"`
}

func init() {
	t["DvsApplyOperationFaultFaultOnObject"] = reflect.TypeOf((*DvsApplyOperationFaultFaultOnObject)(nil)).Elem()
}

type DvsCopyNetworkRuleAction struct {
	DvsNetworkRuleAction
}

func init() {
	t["DvsCopyNetworkRuleAction"] = reflect.TypeOf((*DvsCopyNetworkRuleAction)(nil)).Elem()
}

type DvsCreatedEvent struct {
	DvsEvent

	Parent FolderEventArgument `xml:"parent"`
}

func init() {
	t["DvsCreatedEvent"] = reflect.TypeOf((*DvsCreatedEvent)(nil)).Elem()
}

type DvsDestroyedEvent struct {
	DvsEvent
}

func init() {
	t["DvsDestroyedEvent"] = reflect.TypeOf((*DvsDestroyedEvent)(nil)).Elem()
}

type DvsDropNetworkRuleAction struct {
	DvsNetworkRuleAction
}

func init() {
	t["DvsDropNetworkRuleAction"] = reflect.TypeOf((*DvsDropNetworkRuleAction)(nil)).Elem()
}

type DvsEvent struct {
	Event
}

func init() {
	t["DvsEvent"] = reflect.TypeOf((*DvsEvent)(nil)).Elem()
}

type DvsEventArgument struct {
	EntityEventArgument

	Dvs ManagedObjectReference `xml:"dvs"`
}

func init() {
	t["DvsEventArgument"] = reflect.TypeOf((*DvsEventArgument)(nil)).Elem()
}

type DvsFault struct {
	VimFault
}

func init() {
	t["DvsFault"] = reflect.TypeOf((*DvsFault)(nil)).Elem()
}

type DvsFaultFault BaseDvsFault

func init() {
	t["DvsFaultFault"] = reflect.TypeOf((*DvsFaultFault)(nil)).Elem()
}

type DvsFilterConfig struct {
	InheritablePolicy

	Key        string              `xml:"key,omitempty"`
	AgentName  string              `xml:"agentName,omitempty"`
	SlotNumber string              `xml:"slotNumber,omitempty"`
	Parameters *DvsFilterParameter `xml:"parameters,omitempty"`
	OnFailure  string              `xml:"onFailure,omitempty"`
}

func init() {
	t["DvsFilterConfig"] = reflect.TypeOf((*DvsFilterConfig)(nil)).Elem()
}

type DvsFilterConfigSpec struct {
	DvsFilterConfig

	Operation string `xml:"operation"`
}

func init() {
	t["DvsFilterConfigSpec"] = reflect.TypeOf((*DvsFilterConfigSpec)(nil)).Elem()
}

type DvsFilterParameter struct {
	DynamicData

	Parameters []string `xml:"parameters,omitempty"`
}

func init() {
	t["DvsFilterParameter"] = reflect.TypeOf((*DvsFilterParameter)(nil)).Elem()
}

type DvsFilterPolicy struct {
	InheritablePolicy

	FilterConfig []BaseDvsFilterConfig `xml:"filterConfig,omitempty,typeattr"`
}

func init() {
	t["DvsFilterPolicy"] = reflect.TypeOf((*DvsFilterPolicy)(nil)).Elem()
}

type DvsGreEncapNetworkRuleAction struct {
	DvsNetworkRuleAction

	EncapsulationIp SingleIp `xml:"encapsulationIp"`
}

func init() {
	t["DvsGreEncapNetworkRuleAction"] = reflect.TypeOf((*DvsGreEncapNetworkRuleAction)(nil)).Elem()
}

type DvsHealthStatusChangeEvent struct {
	HostEvent

	SwitchUuid   string                          `xml:"switchUuid"`
	HealthResult BaseHostMemberHealthCheckResult `xml:"healthResult,omitempty,typeattr"`
}

func init() {
	t["DvsHealthStatusChangeEvent"] = reflect.TypeOf((*DvsHealthStatusChangeEvent)(nil)).Elem()
}

type DvsHostBackInSyncEvent struct {
	DvsEvent

	HostBackInSync HostEventArgument `xml:"hostBackInSync"`
}

func init() {
	t["DvsHostBackInSyncEvent"] = reflect.TypeOf((*DvsHostBackInSyncEvent)(nil)).Elem()
}

type DvsHostInfrastructureTrafficResource struct {
	DynamicData

	Key            string                                         `xml:"key"`
	Description    string                                         `xml:"description,omitempty"`
	AllocationInfo DvsHostInfrastructureTrafficResourceAllocation `xml:"allocationInfo"`
}

func init() {
	t["DvsHostInfrastructureTrafficResource"] = reflect.TypeOf((*DvsHostInfrastructureTrafficResource)(nil)).Elem()
}

type DvsHostInfrastructureTrafficResourceAllocation struct {
	DynamicData

	Limit       *int64      `xml:"limit"`
	Shares      *SharesInfo `xml:"shares,omitempty"`
	Reservation *int64      `xml:"reservation"`
}

func init() {
	t["DvsHostInfrastructureTrafficResourceAllocation"] = reflect.TypeOf((*DvsHostInfrastructureTrafficResourceAllocation)(nil)).Elem()
}

type DvsHostJoinedEvent struct {
	DvsEvent

	HostJoined HostEventArgument `xml:"hostJoined"`
}

func init() {
	t["DvsHostJoinedEvent"] = reflect.TypeOf((*DvsHostJoinedEvent)(nil)).Elem()
}

type DvsHostLeftEvent struct {
	DvsEvent

	HostLeft HostEventArgument `xml:"hostLeft"`
}

func init() {
	t["DvsHostLeftEvent"] = reflect.TypeOf((*DvsHostLeftEvent)(nil)).Elem()
}

type DvsHostStatusUpdated struct {
	DvsEvent

	HostMember      HostEventArgument `xml:"hostMember"`
	OldStatus       string            `xml:"oldStatus,omitempty"`
	NewStatus       string            `xml:"newStatus,omitempty"`
	OldStatusDetail string            `xml:"oldStatusDetail,omitempty"`
	NewStatusDetail string            `xml:"newStatusDetail,omitempty"`
}

func init() {
	t["DvsHostStatusUpdated"] = reflect.TypeOf((*DvsHostStatusUpdated)(nil)).Elem()
}

type DvsHostVNicProfile struct {
	DvsVNicProfile
}

func init() {
	t["DvsHostVNicProfile"] = reflect.TypeOf((*DvsHostVNicProfile)(nil)).Elem()
}

type DvsHostWentOutOfSyncEvent struct {
	DvsEvent

	HostOutOfSync DvsOutOfSyncHostArgument `xml:"hostOutOfSync"`
}

func init() {
	t["DvsHostWentOutOfSyncEvent"] = reflect.TypeOf((*DvsHostWentOutOfSyncEvent)(nil)).Elem()
}

type DvsImportEvent struct {
	DvsEvent

	ImportType string `xml:"importType"`
}

func init() {
	t["DvsImportEvent"] = reflect.TypeOf((*DvsImportEvent)(nil)).Elem()
}

type DvsIpNetworkRuleQualifier struct {
	DvsNetworkRuleQualifier

	SourceAddress      BaseIpAddress  `xml:"sourceAddress,omitempty,typeattr"`
	DestinationAddress BaseIpAddress  `xml:"destinationAddress,omitempty,typeattr"`
	Protocol           *IntExpression `xml:"protocol,omitempty"`
	SourceIpPort       BaseDvsIpPort  `xml:"sourceIpPort,omitempty,typeattr"`
	DestinationIpPort  BaseDvsIpPort  `xml:"destinationIpPort,omitempty,typeattr"`
	TcpFlags           *IntExpression `xml:"tcpFlags,omitempty"`
}

func init() {
	t["DvsIpNetworkRuleQualifier"] = reflect.TypeOf((*DvsIpNetworkRuleQualifier)(nil)).Elem()
}

type DvsIpPort struct {
	NegatableExpression
}

func init() {
	t["DvsIpPort"] = reflect.TypeOf((*DvsIpPort)(nil)).Elem()
}

type DvsIpPortRange struct {
	DvsIpPort

	StartPortNumber int32 `xml:"startPortNumber"`
	EndPortNumber   int32 `xml:"endPortNumber"`
}

func init() {
	t["DvsIpPortRange"] = reflect.TypeOf((*DvsIpPortRange)(nil)).Elem()
}

type DvsLogNetworkRuleAction struct {
	DvsNetworkRuleAction
}

func init() {
	t["DvsLogNetworkRuleAction"] = reflect.TypeOf((*DvsLogNetworkRuleAction)(nil)).Elem()
}

type DvsMacNetworkRuleQualifier struct {
	DvsNetworkRuleQualifier

	SourceAddress      BaseMacAddress `xml:"sourceAddress,omitempty,typeattr"`
	DestinationAddress BaseMacAddress `xml:"destinationAddress,omitempty,typeattr"`
	Protocol           *IntExpression `xml:"protocol,omitempty"`
	VlanId             *IntExpression `xml:"vlanId,omitempty"`
}

func init() {
	t["DvsMacNetworkRuleQualifier"] = reflect.TypeOf((*DvsMacNetworkRuleQualifier)(nil)).Elem()
}

type DvsMacRewriteNetworkRuleAction struct {
	DvsNetworkRuleAction

	RewriteMac string `xml:"rewriteMac"`
}

func init() {
	t["DvsMacRewriteNetworkRuleAction"] = reflect.TypeOf((*DvsMacRewriteNetworkRuleAction)(nil)).Elem()
}

type DvsMergedEvent struct {
	DvsEvent

	SourceDvs      DvsEventArgument `xml:"sourceDvs"`
	DestinationDvs DvsEventArgument `xml:"destinationDvs"`
}

func init() {
	t["DvsMergedEvent"] = reflect.TypeOf((*DvsMergedEvent)(nil)).Elem()
}

type DvsNetworkRuleAction struct {
	DynamicData
}

func init() {
	t["DvsNetworkRuleAction"] = reflect.TypeOf((*DvsNetworkRuleAction)(nil)).Elem()
}

type DvsNetworkRuleQualifier struct {
	DynamicData

	Key string `xml:"key,omitempty"`
}

func init() {
	t["DvsNetworkRuleQualifier"] = reflect.TypeOf((*DvsNetworkRuleQualifier)(nil)).Elem()
}

type DvsNotAuthorized struct {
	DvsFault

	SessionExtensionKey string `xml:"sessionExtensionKey,omitempty"`
	DvsExtensionKey     string `xml:"dvsExtensionKey,omitempty"`
}

func init() {
	t["DvsNotAuthorized"] = reflect.TypeOf((*DvsNotAuthorized)(nil)).Elem()
}

type DvsNotAuthorizedFault DvsNotAuthorized

func init() {
	t["DvsNotAuthorizedFault"] = reflect.TypeOf((*DvsNotAuthorizedFault)(nil)).Elem()
}

type DvsOperationBulkFault struct {
	DvsFault

	HostFault []DvsOperationBulkFaultFaultOnHost `xml:"hostFault"`
}

func init() {
	t["DvsOperationBulkFault"] = reflect.TypeOf((*DvsOperationBulkFault)(nil)).Elem()
}

type DvsOperationBulkFaultFault DvsOperationBulkFault

func init() {
	t["DvsOperationBulkFaultFault"] = reflect.TypeOf((*DvsOperationBulkFaultFault)(nil)).Elem()
}

type DvsOperationBulkFaultFaultOnHost struct {
	DynamicData

	Host  ManagedObjectReference `xml:"host"`
	Fault LocalizedMethodFault   `xml:"fault"`
}

func init() {
	t["DvsOperationBulkFaultFaultOnHost"] = reflect.TypeOf((*DvsOperationBulkFaultFaultOnHost)(nil)).Elem()
}

type DvsOutOfSyncHostArgument struct {
	DynamicData

	OutOfSyncHost   HostEventArgument `xml:"outOfSyncHost"`
	ConfigParamters []string          `xml:"configParamters"`
}

func init() {
	t["DvsOutOfSyncHostArgument"] = reflect.TypeOf((*DvsOutOfSyncHostArgument)(nil)).Elem()
}

type DvsPortBlockedEvent struct {
	DvsEvent

	PortKey        string        `xml:"portKey"`
	StatusDetail   string        `xml:"statusDetail,omitempty"`
	RuntimeInfo    *DVPortStatus `xml:"runtimeInfo,omitempty"`
	PrevBlockState string        `xml:"prevBlockState,omitempty"`
}

func init() {
	t["DvsPortBlockedEvent"] = reflect.TypeOf((*DvsPortBlockedEvent)(nil)).Elem()
}

type DvsPortConnectedEvent struct {
	DvsEvent

	PortKey   string                                 `xml:"portKey"`
	Connectee *DistributedVirtualSwitchPortConnectee `xml:"connectee,omitempty"`
}

func init() {
	t["DvsPortConnectedEvent"] = reflect.TypeOf((*DvsPortConnectedEvent)(nil)).Elem()
}

type DvsPortCreatedEvent struct {
	DvsEvent

	PortKey []string `xml:"portKey"`
}

func init() {
	t["DvsPortCreatedEvent"] = reflect.TypeOf((*DvsPortCreatedEvent)(nil)).Elem()
}

type DvsPortDeletedEvent struct {
	DvsEvent

	PortKey []string `xml:"portKey"`
}

func init() {
	t["DvsPortDeletedEvent"] = reflect.TypeOf((*DvsPortDeletedEvent)(nil)).Elem()
}

type DvsPortDisconnectedEvent struct {
	DvsEvent

	PortKey   string                                 `xml:"portKey"`
	Connectee *DistributedVirtualSwitchPortConnectee `xml:"connectee,omitempty"`
}

func init() {
	t["DvsPortDisconnectedEvent"] = reflect.TypeOf((*DvsPortDisconnectedEvent)(nil)).Elem()
}

type DvsPortEnteredPassthruEvent struct {
	DvsEvent

	PortKey     string        `xml:"portKey"`
	RuntimeInfo *DVPortStatus `xml:"runtimeInfo,omitempty"`
}

func init() {
	t["DvsPortEnteredPassthruEvent"] = reflect.TypeOf((*DvsPortEnteredPassthruEvent)(nil)).Elem()
}

type DvsPortExitedPassthruEvent struct {
	DvsEvent

	PortKey     string        `xml:"portKey"`
	RuntimeInfo *DVPortStatus `xml:"runtimeInfo,omitempty"`
}

func init() {
	t["DvsPortExitedPassthruEvent"] = reflect.TypeOf((*DvsPortExitedPassthruEvent)(nil)).Elem()
}

type DvsPortJoinPortgroupEvent struct {
	DvsEvent

	PortKey       string `xml:"portKey"`
	PortgroupKey  string `xml:"portgroupKey"`
	PortgroupName string `xml:"portgroupName"`
}

func init() {
	t["DvsPortJoinPortgroupEvent"] = reflect.TypeOf((*DvsPortJoinPortgroupEvent)(nil)).Elem()
}

type DvsPortLeavePortgroupEvent struct {
	DvsEvent

	PortKey       string `xml:"portKey"`
	PortgroupKey  string `xml:"portgroupKey"`
	PortgroupName string `xml:"portgroupName"`
}

func init() {
	t["DvsPortLeavePortgroupEvent"] = reflect.TypeOf((*DvsPortLeavePortgroupEvent)(nil)).Elem()
}

type DvsPortLinkDownEvent struct {
	DvsEvent

	PortKey     string        `xml:"portKey"`
	RuntimeInfo *DVPortStatus `xml:"runtimeInfo,omitempty"`
}

func init() {
	t["DvsPortLinkDownEvent"] = reflect.TypeOf((*DvsPortLinkDownEvent)(nil)).Elem()
}

type DvsPortLinkUpEvent struct {
	DvsEvent

	PortKey     string        `xml:"portKey"`
	RuntimeInfo *DVPortStatus `xml:"runtimeInfo,omitempty"`
}

func init() {
	t["DvsPortLinkUpEvent"] = reflect.TypeOf((*DvsPortLinkUpEvent)(nil)).Elem()
}

type DvsPortReconfiguredEvent struct {
	DvsEvent

	PortKey       []string                   `xml:"portKey"`
	ConfigChanges []ChangesInfoEventArgument `xml:"configChanges,omitempty"`
}

func init() {
	t["DvsPortReconfiguredEvent"] = reflect.TypeOf((*DvsPortReconfiguredEvent)(nil)).Elem()
}

type DvsPortRuntimeChangeEvent struct {
	DvsEvent

	PortKey     string       `xml:"portKey"`
	RuntimeInfo DVPortStatus `xml:"runtimeInfo"`
}

func init() {
	t["DvsPortRuntimeChangeEvent"] = reflect.TypeOf((*DvsPortRuntimeChangeEvent)(nil)).Elem()
}

type DvsPortUnblockedEvent struct {
	DvsEvent

	PortKey        string        `xml:"portKey"`
	RuntimeInfo    *DVPortStatus `xml:"runtimeInfo,omitempty"`
	PrevBlockState string        `xml:"prevBlockState,omitempty"`
}

func init() {
	t["DvsPortUnblockedEvent"] = reflect.TypeOf((*DvsPortUnblockedEvent)(nil)).Elem()
}

type DvsPortVendorSpecificStateChangeEvent struct {
	DvsEvent

	PortKey string `xml:"portKey"`
}

func init() {
	t["DvsPortVendorSpecificStateChangeEvent"] = reflect.TypeOf((*DvsPortVendorSpecificStateChangeEvent)(nil)).Elem()
}

type DvsProfile struct {
	ApplyProfile

	Key    string              `xml:"key"`
	Name   string              `xml:"name"`
	Uplink []PnicUplinkProfile `xml:"uplink,omitempty"`
}

func init() {
	t["DvsProfile"] = reflect.TypeOf((*DvsProfile)(nil)).Elem()
}

type DvsPuntNetworkRuleAction struct {
	DvsNetworkRuleAction
}

func init() {
	t["DvsPuntNetworkRuleAction"] = reflect.TypeOf((*DvsPuntNetworkRuleAction)(nil)).Elem()
}

type DvsRateLimitNetworkRuleAction struct {
	DvsNetworkRuleAction

	PacketsPerSecond int32 `xml:"packetsPerSecond"`
}

func init() {
	t["DvsRateLimitNetworkRuleAction"] = reflect.TypeOf((*DvsRateLimitNetworkRuleAction)(nil)).Elem()
}

type DvsReconfigureVmVnicNetworkResourcePoolRequestType struct {
	This       ManagedObjectReference            `xml:"_this"`
	ConfigSpec []DvsVmVnicResourcePoolConfigSpec `xml:"configSpec"`
}

func init() {
	t["DvsReconfigureVmVnicNetworkResourcePoolRequestType"] = reflect.TypeOf((*DvsReconfigureVmVnicNetworkResourcePoolRequestType)(nil)).Elem()
}

type DvsReconfigureVmVnicNetworkResourcePool_Task DvsReconfigureVmVnicNetworkResourcePoolRequestType

func init() {
	t["DvsReconfigureVmVnicNetworkResourcePool_Task"] = reflect.TypeOf((*DvsReconfigureVmVnicNetworkResourcePool_Task)(nil)).Elem()
}

type DvsReconfigureVmVnicNetworkResourcePool_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval"`
}

type DvsReconfiguredEvent struct {
	DvsEvent

	ConfigSpec    BaseDVSConfigSpec         `xml:"configSpec,typeattr"`
	ConfigChanges *ChangesInfoEventArgument `xml:"configChanges,omitempty"`
}

func init() {
	t["DvsReconfiguredEvent"] = reflect.TypeOf((*DvsReconfiguredEvent)(nil)).Elem()
}

type DvsRenamedEvent struct {
	DvsEvent

	OldName string `xml:"oldName"`
	NewName string `xml:"newName"`
}

func init() {
	t["DvsRenamedEvent"] = reflect.TypeOf((*DvsRenamedEvent)(nil)).Elem()
}

type DvsResourceRuntimeInfo struct {
	DynamicData

	Capacity                         int32                                     `xml:"capacity,omitempty"`
	Usage                            int32                                     `xml:"usage,omitempty"`
	Available                        int32                                     `xml:"available,omitempty"`
	AllocatedResource                []DvsVnicAllocatedResource                `xml:"allocatedResource,omitempty"`
	VmVnicNetworkResourcePoolRuntime []DvsVmVnicNetworkResourcePoolRuntimeInfo `xml:"vmVnicNetworkResourcePoolRuntime,omitempty"`
}

func init() {
	t["DvsResourceRuntimeInfo"] = reflect.TypeOf((*DvsResourceRuntimeInfo)(nil)).Elem()
}

type DvsRestoreEvent struct {
	DvsEvent
}

func init() {
	t["DvsRestoreEvent"] = reflect.TypeOf((*DvsRestoreEvent)(nil)).Elem()
}

type DvsScopeViolated struct {
	DvsFault

	Scope  []ManagedObjectReference `xml:"scope"`
	Entity ManagedObjectReference   `xml:"entity"`
}

func init() {
	t["DvsScopeViolated"] = reflect.TypeOf((*DvsScopeViolated)(nil)).Elem()
}

type DvsScopeViolatedFault DvsScopeViolated

func init() {
	t["DvsScopeViolatedFault"] = reflect.TypeOf((*DvsScopeViolatedFault)(nil)).Elem()
}

type DvsServiceConsoleVNicProfile struct {
	DvsVNicProfile
}

func init() {
	t["DvsServiceConsoleVNicProfile"] = reflect.TypeOf((*DvsServiceConsoleVNicProfile)(nil)).Elem()
}

type DvsSingleIpPort struct {
	DvsIpPort

	PortNumber int32 `xml:"portNumber"`
}

func init() {
	t["DvsSingleIpPort"] = reflect.TypeOf((*DvsSingleIpPort)(nil)).Elem()
}

type DvsSystemTrafficNetworkRuleQualifier struct {
	DvsNetworkRuleQualifier

	TypeOfSystemTraffic *StringExpression `xml:"typeOfSystemTraffic,omitempty"`
}

func init() {
	t["DvsSystemTrafficNetworkRuleQualifier"] = reflect.TypeOf((*DvsSystemTrafficNetworkRuleQualifier)(nil)).Elem()
}

type DvsTrafficFilterConfig struct {
	DvsFilterConfig

	TrafficRuleset *DvsTrafficRuleset `xml:"trafficRuleset,omitempty"`
}

func init() {
	t["DvsTrafficFilterConfig"] = reflect.TypeOf((*DvsTrafficFilterConfig)(nil)).Elem()
}

type DvsTrafficFilterConfigSpec struct {
	DvsTrafficFilterConfig

	Operation string `xml:"operation"`
}

func init() {
	t["DvsTrafficFilterConfigSpec"] = reflect.TypeOf((*DvsTrafficFilterConfigSpec)(nil)).Elem()
}

type DvsTrafficRule struct {
	DynamicData

	Key         string                        `xml:"key,omitempty"`
	Description string                        `xml:"description,omitempty"`
	Sequence    int32                         `xml:"sequence,omitempty"`
	Qualifier   []BaseDvsNetworkRuleQualifier `xml:"qualifier,omitempty,typeattr"`
	Action      BaseDvsNetworkRuleAction      `xml:"action,omitempty,typeattr"`
	Direction   string                        `xml:"direction,omitempty"`
}

func init() {
	t["DvsTrafficRule"] = reflect.TypeOf((*DvsTrafficRule)(nil)).Elem()
}

type DvsTrafficRuleset struct {
	DynamicData

	Key        string           `xml:"key,omitempty"`
	Enabled    *bool            `xml:"enabled"`
	Precedence int32            `xml:"precedence,omitempty"`
	Rules      []DvsTrafficRule `xml:"rules,omitempty"`
}

func init() {
	t["DvsTrafficRuleset"] = reflect.TypeOf((*DvsTrafficRuleset)(nil)).Elem()
}

type DvsUpdateTagNetworkRuleAction struct {
	DvsNetworkRuleAction

	QosTag  int32 `xml:"qosTag,omitempty"`
	DscpTag int32 `xml:"dscpTag,omitempty"`
}

func init() {
	t["DvsUpdateTagNetworkRuleAction"] = reflect.TypeOf((*DvsUpdateTagNetworkRuleAction)(nil)).Elem()
}

type DvsUpgradeAvailableEvent struct {
	DvsEvent

	ProductInfo DistributedVirtualSwitchProductSpec `xml:"productInfo"`
}

func init() {
	t["DvsUpgradeAvailableEvent"] = reflect.TypeOf((*DvsUpgradeAvailableEvent)(nil)).Elem()
}

type DvsUpgradeInProgressEvent struct {
	DvsEvent

	ProductInfo DistributedVirtualSwitchProductSpec `xml:"productInfo"`
}

func init() {
	t["DvsUpgradeInProgressEvent"] = reflect.TypeOf((*DvsUpgradeInProgressEvent)(nil)).Elem()
}

type DvsUpgradeRejectedEvent struct {
	DvsEvent

	ProductInfo DistributedVirtualSwitchProductSpec `xml:"productInfo"`
}

func init() {
	t["DvsUpgradeRejectedEvent"] = reflect.TypeOf((*DvsUpgradeRejectedEvent)(nil)).Elem()
}

type DvsUpgradedEvent struct {
	DvsEvent

	ProductInfo DistributedVirtualSwitchProductSpec `xml:"productInfo"`
}

func init() {
	t["DvsUpgradedEvent"] = reflect.TypeOf((*DvsUpgradedEvent)(nil)).Elem()
}

type DvsVNicProfile struct {
	ApplyProfile

	Key      string           `xml:"key"`
	IpConfig IpAddressProfile `xml:"ipConfig"`
}

func init() {
	t["DvsVNicProfile"] = reflect.TypeOf((*DvsVNicProfile)(nil)).Elem()
}

type DvsVmVnicNetworkResourcePoolRuntimeInfo struct {
	DynamicData

	Key               string                     `xml:"key"`
	Name              string                     `xml:"name,omitempty"`
	Capacity          int32                      `xml:"capacity,omitempty"`
	Usage             int32                      `xml:"usage,omitempty"`
	Available         int32                      `xml:"available,omitempty"`
	Status            string                     `xml:"status"`
	AllocatedResource []DvsVnicAllocatedResource `xml:"allocatedResource,omitempty"`
}

func init() {
	t["DvsVmVnicNetworkResourcePoolRuntimeInfo"] = reflect.TypeOf((*DvsVmVnicNetworkResourcePoolRuntimeInfo)(nil)).Elem()
}

type DvsVmVnicResourceAllocation struct {
	DynamicData

	ReservationQuota int64 `xml:"reservationQuota,omitempty"`
}

func init() {
	t["DvsVmVnicResourceAllocation"] = reflect.TypeOf((*DvsVmVnicResourceAllocation)(nil)).Elem()
}

type DvsVmVnicResourcePoolConfigSpec struct {
	DynamicData

	Operation      string                       `xml:"operation"`
	Key            string                       `xml:"key,omitempty"`
	ConfigVersion  string                       `xml:"configVersion,omitempty"`
	AllocationInfo *DvsVmVnicResourceAllocation `xml:"allocationInfo,omitempty"`
	Name           string                       `xml:"name,omitempty"`
	Description    string                       `xml:"description,omitempty"`
}

func init() {
	t["DvsVmVnicResourcePoolConfigSpec"] = reflect.TypeOf((*DvsVmVnicResourcePoolConfigSpec)(nil)).Elem()
}

type DvsVnicAllocatedResource struct {
	DynamicData

	Vm          ManagedObjectReference `xml:"vm"`
	VnicKey     string                 `xml:"vnicKey"`
	Reservation *int64                 `xml:"reservation"`
}

func init() {
	t["DvsVnicAllocatedResource"] = reflect.TypeOf((*DvsVnicAllocatedResource)(nil)).Elem()
}

type DynamicArray struct {
	Val []AnyType `xml:"val,typeattr"`
}

func init() {
	t["DynamicArray"] = reflect.TypeOf((*DynamicArray)(nil)).Elem()
}

type DynamicData struct {
}

func init() {
	t["DynamicData"] = reflect.TypeOf((*DynamicData)(nil)).Elem()
}

type DynamicProperty struct {
	Name string  `xml:"name"`
	Val  AnyType `xml:"val,typeattr"`
}

func init() {
	t["DynamicProperty"] = reflect.TypeOf((*DynamicProperty)(nil)).Elem()
}

type EVCAdmissionFailed struct {
	NotSupportedHostInCluster

	Faults []LocalizedMethodFault `xml:"faults,omitempty"`
}

func init() {
	t["EVCAdmissionFailed"] = reflect.TypeOf((*EVCAdmissionFailed)(nil)).Elem()
}

type EVCAdmissionFailedCPUFeaturesForMode struct {
	EVCAdmissionFailed

	CurrentEVCModeKey string `xml:"currentEVCModeKey"`
}

func init() {
	t["EVCAdmissionFailedCPUFeaturesForMode"] = reflect.TypeOf((*EVCAdmissionFailedCPUFeaturesForMode)(nil)).Elem()
}

type EVCAdmissionFailedCPUFeaturesForModeFault EVCAdmissionFailedCPUFeaturesForMode

func init() {
	t["EVCAdmissionFailedCPUFeaturesForModeFault"] = reflect.TypeOf((*EVCAdmissionFailedCPUFeaturesForModeFault)(nil)).Elem()
}

type EVCAdmissionFailedCPUModel struct {
	EVCAdmissionFailed
}

func init() {
	t["EVCAdmissionFailedCPUModel"] = reflect.TypeOf((*EVCAdmissionFailedCPUModel)(nil)).Elem()
}

type EVCAdmissionFailedCPUModelFault EVCAdmissionFailedCPUModel

func init() {
	t["EVCAdmissionFailedCPUModelFault"] = reflect.TypeOf((*EVCAdmissionFailedCPUModelFault)(nil)).Elem()
}

type EVCAdmissionFailedCPUModelForMode struct {
	EVCAdmissionFailed

	CurrentEVCModeKey string `xml:"currentEVCModeKey"`
}

func init() {
	t["EVCAdmissionFailedCPUModelForMode"] = reflect.TypeOf((*EVCAdmissionFailedCPUModelForMode)(nil)).Elem()
}

type EVCAdmissionFailedCPUModelForModeFault EVCAdmissionFailedCPUModelForMode

func init() {
	t["EVCAdmissionFailedCPUModelForModeFault"] = reflect.TypeOf((*EVCAdmissionFailedCPUModelForModeFault)(nil)).Elem()
}

type EVCAdmissionFailedCPUVendor struct {
	EVCAdmissionFailed

	ClusterCPUVendor string `xml:"clusterCPUVendor"`
	HostCPUVendor    string `xml:"hostCPUVendor"`
}

func init() {
	t["EVCAdmissionFailedCPUVendor"] = reflect.TypeOf((*EVCAdmissionFailedCPUVendor)(nil)).Elem()
}

type EVCAdmissionFailedCPUVendorFault EVCAdmissionFailedCPUVendor

func init() {
	t["EVCAdmissionFailedCPUVendorFault"] = reflect.TypeOf((*EVCAdmissionFailedCPUVendorFault)(nil)).Elem()
}

type EVCAdmissionFailedCPUVendorUnknown struct {
	EVCAdmissionFailed
}

func init() {
	t["EVCAdmissionFailedCPUVendorUnknown"] = reflect.TypeOf((*EVCAdmissionFailedCPUVendorUnknown)(nil)).Elem()
}

type EVCAdmissionFailedCPUVendorUnknownFault EVCAdmissionFailedCPUVendorUnknown

func init() {
	t["EVCAdmissionFailedCPUVendorUnknownFault"] = reflect.TypeOf((*EVCAdmissionFailedCPUVendorUnknownFault)(nil)).Elem()
}

type EVCAdmissionFailedFault BaseEVCAdmissionFailed

func init() {
	t["EVCAdmissionFailedFault"] = reflect.TypeOf((*EVCAdmissionFailedFault)(nil)).Elem()
}

type EVCAdmissionFailedHostDisconnected struct {
	EVCAdmissionFailed
}

func init() {
	t["EVCAdmissionFailedHostDisconnected"] = reflect.TypeOf((*EVCAdmissionFailedHostDisconnected)(nil)).Elem()
}

type EVCAdmissionFailedHostDisconnectedFault EVCAdmissionFailedHostDisconnected

func init() {
	t["EVCAdmissionFailedHostDisconnectedFault"] = reflect.TypeOf((*EVCAdmissionFailedHostDisconnectedFault)(nil)).Elem()
}

type EVCAdmissionFailedHostSoftware struct {
	EVCAdmissionFailed
}

func init() {
	t["EVCAdmissionFailedHostSoftware"] = reflect.TypeOf((*EVCAdmissionFailedHostSoftware)(nil)).Elem()
}

type EVCAdmissionFailedHostSoftwareFault EVCAdmissionFailedHostSoftware

func init() {
	t["EVCAdmissionFailedHostSoftwareFault"] = reflect.TypeOf((*EVCAdmissionFailedHostSoftwareFault)(nil)).Elem()
}

type EVCAdmissionFailedHostSoftwareForMode struct {
	EVCAdmissionFailed
}

func init() {
	t["EVCAdmissionFailedHostSoftwareForMode"] = reflect.TypeOf((*EVCAdmissionFailedHostSoftwareForMode)(nil)).Elem()
}

type EVCAdmissionFailedHostSoftwareForModeFault EVCAdmissionFailedHostSoftwareForMode

func init() {
	t["EVCAdmissionFailedHostSoftwareForModeFault"] = reflect.TypeOf((*EVCAdmissionFailedHostSoftwareForModeFault)(nil)).Elem()
}

type EVCAdmissionFailedVmActive struct {
	EVCAdmissionFailed
}

func init() {
	t["EVCAdmissionFailedVmActive"] = reflect.TypeOf((*EVCAdmissionFailedVmActive)(nil)).Elem()
}

type EVCAdmissionFailedVmActiveFault EVCAdmissionFailedVmActive

func init() {
	t["EVCAdmissionFailedVmActiveFault"] = reflect.TypeOf((*EVCAdmissionFailedVmActiveFault)(nil)).Elem()
}

type EVCConfigFault struct {
	VimFault

	Faults []LocalizedMethodFault `xml:"faults,omitempty"`
}

func init() {
	t["EVCConfigFault"] = reflect.TypeOf((*EVCConfigFault)(nil)).Elem()
}

type EVCConfigFaultFault BaseEVCConfigFault

func init() {
	t["EVCConfigFaultFault"] = reflect.TypeOf((*EVCConfigFaultFault)(nil)).Elem()
}

type EVCMode struct {
	ElementDescription

	GuaranteedCPUFeatures []HostCpuIdInfo                    `xml:"guaranteedCPUFeatures,omitempty"`
	FeatureCapability     []HostFeatureCapability            `xml:"featureCapability,omitempty"`
	FeatureMask           []HostFeatureMask                  `xml:"featureMask,omitempty"`
	FeatureRequirement    []VirtualMachineFeatureRequirement `xml:"featureRequirement,omitempty"`
	Vendor                string                             `xml:"vendor"`
	Track                 []string                           `xml:"track,omitempty"`
	VendorTier            int32                              `xml:"vendorTier"`
}

func init() {
	t["EVCMode"] = reflect.TypeOf((*EVCMode)(nil)).Elem()
}

type EVCModeIllegalByVendor struct {
	EVCConfigFault

	ClusterCPUVendor string `xml:"clusterCPUVendor"`
	ModeCPUVendor    string `xml:"modeCPUVendor"`
}

func init() {
	t["EVCModeIllegalByVendor"] = reflect.TypeOf((*EVCModeIllegalByVendor)(nil)).Elem()
}

type EVCModeIllegalByVendorFault EVCModeIllegalByVendor

func init() {
	t["EVCModeIllegalByVendorFault"] = reflect.TypeOf((*EVCModeIllegalByVendorFault)(nil)).Elem()
}

type EVCModeUnsupportedByHosts struct {
	EVCConfigFault

	EvcMode  string                   `xml:"evcMode,omitempty"`
	Host     []ManagedObjectReference `xml:"host,omitempty"`
	HostName []string                 `xml:"hostName,omitempty"`
}

func init() {
	t["EVCModeUnsupportedByHosts"] = reflect.TypeOf((*EVCModeUnsupportedByHosts)(nil)).Elem()
}

type EVCModeUnsupportedByHostsFault EVCModeUnsupportedByHosts

func init() {
	t["EVCModeUnsupportedByHostsFault"] = reflect.TypeOf((*EVCModeUnsupportedByHostsFault)(nil)).Elem()
}

type EVCUnsupportedByHostHardware struct {
	EVCConfigFault

	Host     []ManagedObjectReference `xml:"host"`
	HostName []string                 `xml:"hostName"`
}

func init() {
	t["EVCUnsupportedByHostHardware"] = reflect.TypeOf((*EVCUnsupportedByHostHardware)(nil)).Elem()
}

type EVCUnsupportedByHostHardwareFault EVCUnsupportedByHostHardware

func init() {
	t["EVCUnsupportedByHostHardwareFault"] = reflect.TypeOf((*EVCUnsupportedByHostHardwareFault)(nil)).Elem()
}

type EVCUnsupportedByHostSoftware struct {
	EVCConfigFault

	Host     []ManagedObjectReference `xml:"host"`
	HostName []string                 `xml:"hostName"`
}

func init() {
	t["EVCUnsupportedByHostSoftware"] = reflect.TypeOf((*EVCUnsupportedByHostSoftware)(nil)).Elem()
}

type EVCUnsupportedByHostSoftwareFault EVCUnsupportedByHostSoftware

func init() {
	t["EVCUnsupportedByHostSoftwareFault"] = reflect.TypeOf((*EVCUnsupportedByHostSoftwareFault)(nil)).Elem()
}

type EagerZeroVirtualDiskRequestType struct {
	This       ManagedObjectReference  `xml:"_this"`
	Name       string                  `xml:"name"`
	Datacenter *ManagedObjectReference `xml:"datacenter,omitempty"`
}

func init() {
	t["EagerZeroVirtualDiskRequestType"] = reflect.TypeOf((*EagerZeroVirtualDiskRequestType)(nil)).Elem()
}

type EagerZeroVirtualDisk_Task EagerZeroVirtualDiskRequestType

func init() {
	t["EagerZeroVirtualDisk_Task"] = reflect.TypeOf((*EagerZeroVirtualDisk_Task)(nil)).Elem()
}

type EagerZeroVirtualDisk_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval"`
}

type EightHostLimitViolated struct {
	VmConfigFault
}

func init() {
	t["EightHostLimitViolated"] = reflect.TypeOf((*EightHostLimitViolated)(nil)).Elem()
}

type EightHostLimitViolatedFault EightHostLimitViolated

func init() {
	t["EightHostLimitViolatedFault"] = reflect.TypeOf((*EightHostLimitViolatedFault)(nil)).Elem()
}

type ElementDescription struct {
	Description

	Key string `xml:"key"`
}

func init() {
	t["ElementDescription"] = reflect.TypeOf((*ElementDescription)(nil)).Elem()
}

type EnableAlarm EnableAlarmRequestType

func init() {
	t["EnableAlarm"] = reflect.TypeOf((*EnableAlarm)(nil)).Elem()
}

type EnableAlarmActions EnableAlarmActionsRequestType

func init() {
	t["EnableAlarmActions"] = reflect.TypeOf((*EnableAlarmActions)(nil)).Elem()
}

type EnableAlarmActionsRequestType struct {
	This    ManagedObjectReference `xml:"_this"`
	Entity  ManagedObjectReference `xml:"entity"`
	Enabled bool                   `xml:"enabled"`
}

func init() {
	t["EnableAlarmActionsRequestType"] = reflect.TypeOf((*EnableAlarmActionsRequestType)(nil)).Elem()
}

type EnableAlarmActionsResponse struct {
}

type EnableAlarmRequestType struct {
	This   ManagedObjectReference `xml:"_this"`
	Alarm  ManagedObjectReference `xml:"alarm"`
	Entity ManagedObjectReference `xml:"entity"`
}

func init() {
	t["EnableAlarmRequestType"] = reflect.TypeOf((*EnableAlarmRequestType)(nil)).Elem()
}

type EnableAlarmResponse struct {
}

type EnableClusteredVmdkSupport EnableClusteredVmdkSupportRequestType

func init() {
	t["EnableClusteredVmdkSupport"] = reflect.TypeOf((*EnableClusteredVmdkSupport)(nil)).Elem()
}

type EnableClusteredVmdkSupportRequestType struct {
	This      ManagedObjectReference `xml:"_this"`
	Datastore ManagedObjectReference `xml:"datastore"`
}

func init() {
	t["EnableClusteredVmdkSupportRequestType"] = reflect.TypeOf((*EnableClusteredVmdkSupportRequestType)(nil)).Elem()
}

type EnableClusteredVmdkSupportResponse struct {
}

type EnableCrypto EnableCryptoRequestType

func init() {
	t["EnableCrypto"] = reflect.TypeOf((*EnableCrypto)(nil)).Elem()
}

type EnableCryptoRequestType struct {
	This     ManagedObjectReference `xml:"_this"`
	KeyPlain CryptoKeyPlain         `xml:"keyPlain"`
}

func init() {
	t["EnableCryptoRequestType"] = reflect.TypeOf((*EnableCryptoRequestType)(nil)).Elem()
}

type EnableCryptoResponse struct {
}

type EnableFeature EnableFeatureRequestType

func init() {
	t["EnableFeature"] = reflect.TypeOf((*EnableFeature)(nil)).Elem()
}

type EnableFeatureRequestType struct {
	This       ManagedObjectReference  `xml:"_this"`
	Host       *ManagedObjectReference `xml:"host,omitempty"`
	FeatureKey string                  `xml:"featureKey"`
}

func init() {
	t["EnableFeatureRequestType"] = reflect.TypeOf((*EnableFeatureRequestType)(nil)).Elem()
}

type EnableFeatureResponse struct {
	Returnval bool `xml:"returnval"`
}

type EnableHyperThreading EnableHyperThreadingRequestType

func init() {
	t["EnableHyperThreading"] = reflect.TypeOf((*EnableHyperThreading)(nil)).Elem()
}

type EnableHyperThreadingRequestType struct {
	This ManagedObjectReference `xml:"_this"`
}

func init() {
	t["EnableHyperThreadingRequestType"] = reflect.TypeOf((*EnableHyperThreadingRequestType)(nil)).Elem()
}

type EnableHyperThreadingResponse struct {
}

type EnableMultipathPath EnableMultipathPathRequestType

func init() {
	t["EnableMultipathPath"] = reflect.TypeOf((*EnableMultipathPath)(nil)).Elem()
}

type EnableMultipathPathRequestType struct {
	This     ManagedObjectReference `xml:"_this"`
	PathName string                 `xml:"pathName"`
}

func init() {
	t["EnableMultipathPathRequestType"] = reflect.TypeOf((*EnableMultipathPathRequestType)(nil)).Elem()
}

type EnableMultipathPathResponse struct {
}

type EnableNetworkResourceManagement EnableNetworkResourceManagementRequestType

func init() {
	t["EnableNetworkResourceManagement"] = reflect.TypeOf((*EnableNetworkResourceManagement)(nil)).Elem()
}

type EnableNetworkResourceManagementRequestType struct {
	This   ManagedObjectReference `xml:"_this"`
	Enable bool                   `xml:"enable"`
}

func init() {
	t["EnableNetworkResourceManagementRequestType"] = reflect.TypeOf((*EnableNetworkResourceManagementRequestType)(nil)).Elem()
}

type EnableNetworkResourceManagementResponse struct {
}

type EnableRuleset EnableRulesetRequestType

func init() {
	t["EnableRuleset"] = reflect.TypeOf((*EnableRuleset)(nil)).Elem()
}

type EnableRulesetRequestType struct {
	This ManagedObjectReference `xml:"_this"`
	Id   string                 `xml:"id"`
}

func init() {
	t["EnableRulesetRequestType"] = reflect.TypeOf((*EnableRulesetRequestType)(nil)).Elem()
}

type EnableRulesetResponse struct {
}

type EnableSecondaryVMRequestType struct {
	This ManagedObjectReference  `xml:"_this"`
	Vm   ManagedObjectReference  `xml:"vm"`
	Host *ManagedObjectReference `xml:"host,omitempty"`
}

func init() {
	t["EnableSecondaryVMRequestType"] = reflect.TypeOf((*EnableSecondaryVMRequestType)(nil)).Elem()
}

type EnableSecondaryVM_Task EnableSecondaryVMRequestType

func init() {
	t["EnableSecondaryVM_Task"] = reflect.TypeOf((*EnableSecondaryVM_Task)(nil)).Elem()
}

type EnableSecondaryVM_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval"`
}

type EnableSmartCardAuthentication EnableSmartCardAuthenticationRequestType

func init() {
	t["EnableSmartCardAuthentication"] = reflect.TypeOf((*EnableSmartCardAuthentication)(nil)).Elem()
}

type EnableSmartCardAuthenticationRequestType struct {
	This ManagedObjectReference `xml:"_this"`
}

func init() {
	t["EnableSmartCardAuthenticationRequestType"] = reflect.TypeOf((*EnableSmartCardAuthenticationRequestType)(nil)).Elem()
}

type EnableSmartCardAuthenticationResponse struct {
}

type EncryptionKeyRequired struct {
	InvalidState

	RequiredKey []CryptoKeyId `xml:"requiredKey,omitempty"`
}

func init() {
	t["EncryptionKeyRequired"] = reflect.TypeOf((*EncryptionKeyRequired)(nil)).Elem()
}

type EncryptionKeyRequiredFault EncryptionKeyRequired

func init() {
	t["EncryptionKeyRequiredFault"] = reflect.TypeOf((*EncryptionKeyRequiredFault)(nil)).Elem()
}

type EnterLockdownMode EnterLockdownModeRequestType

func init() {
	t["EnterLockdownMode"] = reflect.TypeOf((*EnterLockdownMode)(nil)).Elem()
}

type EnterLockdownModeRequestType struct {
	This ManagedObjectReference `xml:"_this"`
}

func init() {
	t["EnterLockdownModeRequestType"] = reflect.TypeOf((*EnterLockdownModeRequestType)(nil)).Elem()
}

type EnterLockdownModeResponse struct {
}

type EnterMaintenanceModeRequestType struct {
	This                  ManagedObjectReference `xml:"_this"`
	Timeout               int32                  `xml:"timeout"`
	EvacuatePoweredOffVms *bool                  `xml:"evacuatePoweredOffVms"`
	MaintenanceSpec       *HostMaintenanceSpec   `xml:"maintenanceSpec,omitempty"`
}

func init() {
	t["EnterMaintenanceModeRequestType"] = reflect.TypeOf((*EnterMaintenanceModeRequestType)(nil)).Elem()
}

type EnterMaintenanceMode_Task EnterMaintenanceModeRequestType

func init() {
	t["EnterMaintenanceMode_Task"] = reflect.TypeOf((*EnterMaintenanceMode_Task)(nil)).Elem()
}

type EnterMaintenanceMode_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval"`
}

type EnteredMaintenanceModeEvent struct {
	HostEvent
}

func init() {
	t["EnteredMaintenanceModeEvent"] = reflect.TypeOf((*EnteredMaintenanceModeEvent)(nil)).Elem()
}

type EnteredStandbyModeEvent struct {
	HostEvent
}

func init() {
	t["EnteredStandbyModeEvent"] = reflect.TypeOf((*EnteredStandbyModeEvent)(nil)).Elem()
}

type EnteringMaintenanceModeEvent struct {
	HostEvent
}

func init() {
	t["EnteringMaintenanceModeEvent"] = reflect.TypeOf((*EnteringMaintenanceModeEvent)(nil)).Elem()
}

type EnteringStandbyModeEvent struct {
	HostEvent
}

func init() {
	t["EnteringStandbyModeEvent"] = reflect.TypeOf((*EnteringStandbyModeEvent)(nil)).Elem()
}

type EntityBackup struct {
	DynamicData
}

func init() {
	t["EntityBackup"] = reflect.TypeOf((*EntityBackup)(nil)).Elem()
}

type EntityBackupConfig struct {
	DynamicData

	EntityType    string                  `xml:"entityType"`
	ConfigBlob    []byte                  `xml:"configBlob"`
	Key           string                  `xml:"key,omitempty"`
	Name          string                  `xml:"name,omitempty"`
	Container     *ManagedObjectReference `xml:"container,omitempty"`
	ConfigVersion string                  `xml:"configVersion,omitempty"`
}

func init() {
	t["EntityBackupConfig"] = reflect.TypeOf((*EntityBackupConfig)(nil)).Elem()
}

type EntityEventArgument struct {
	EventArgument

	Name string `xml:"name"`
}

func init() {
	t["EntityEventArgument"] = reflect.TypeOf((*EntityEventArgument)(nil)).Elem()
}

type EntityPrivilege struct {
	DynamicData

	Entity           ManagedObjectReference  `xml:"entity"`
	PrivAvailability []PrivilegeAvailability `xml:"privAvailability"`
}

func init() {
	t["EntityPrivilege"] = reflect.TypeOf((*EntityPrivilege)(nil)).Elem()
}

type EnumDescription struct {
	DynamicData

	Key  string                   `xml:"key"`
	Tags []BaseElementDescription `xml:"tags,typeattr"`
}

func init() {
	t["EnumDescription"] = reflect.TypeOf((*EnumDescription)(nil)).Elem()
}

type EnvironmentBrowserConfigOptionQuerySpec struct {
	DynamicData

	Key     string                  `xml:"key,omitempty"`
	Host    *ManagedObjectReference `xml:"host,omitempty"`
	GuestId []string                `xml:"guestId,omitempty"`
}

func init() {
	t["EnvironmentBrowserConfigOptionQuerySpec"] = reflect.TypeOf((*EnvironmentBrowserConfigOptionQuerySpec)(nil)).Elem()
}

type ErrorUpgradeEvent struct {
	UpgradeEvent
}

func init() {
	t["ErrorUpgradeEvent"] = reflect.TypeOf((*ErrorUpgradeEvent)(nil)).Elem()
}

type EstimateDatabaseSize EstimateDatabaseSizeRequestType

func init() {
	t["EstimateDatabaseSize"] = reflect.TypeOf((*EstimateDatabaseSize)(nil)).Elem()
}

type EstimateDatabaseSizeRequestType struct {
	This        ManagedObjectReference `xml:"_this"`
	DbSizeParam DatabaseSizeParam      `xml:"dbSizeParam"`
}

func init() {
	t["EstimateDatabaseSizeRequestType"] = reflect.TypeOf((*EstimateDatabaseSizeRequestType)(nil)).Elem()
}

type EstimateDatabaseSizeResponse struct {
	Returnval DatabaseSizeEstimate `xml:"returnval"`
}

type EstimateStorageForConsolidateSnapshotsRequestType struct {
	This ManagedObjectReference `xml:"_this"`
}

func init() {
	t["EstimateStorageForConsolidateSnapshotsRequestType"] = reflect.TypeOf((*EstimateStorageForConsolidateSnapshotsRequestType)(nil)).Elem()
}

type EstimateStorageForConsolidateSnapshots_Task EstimateStorageForConsolidateSnapshotsRequestType

func init() {
	t["EstimateStorageForConsolidateSnapshots_Task"] = reflect.TypeOf((*EstimateStorageForConsolidateSnapshots_Task)(nil)).Elem()
}

type EstimateStorageForConsolidateSnapshots_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval"`
}

type EsxAgentHostManagerUpdateConfig EsxAgentHostManagerUpdateConfigRequestType

func init() {
	t["EsxAgentHostManagerUpdateConfig"] = reflect.TypeOf((*EsxAgentHostManagerUpdateConfig)(nil)).Elem()
}

type EsxAgentHostManagerUpdateConfigRequestType struct {
	This       ManagedObjectReference            `xml:"_this"`
	ConfigInfo HostEsxAgentHostManagerConfigInfo `xml:"configInfo"`
}

func init() {
	t["EsxAgentHostManagerUpdateConfigRequestType"] = reflect.TypeOf((*EsxAgentHostManagerUpdateConfigRequestType)(nil)).Elem()
}

type EsxAgentHostManagerUpdateConfigResponse struct {
}

type EvacuateVsanNodeRequestType struct {
	This            ManagedObjectReference `xml:"_this"`
	MaintenanceSpec HostMaintenanceSpec    `xml:"maintenanceSpec"`
	Timeout         int32                  `xml:"timeout"`
}

func init() {
	t["EvacuateVsanNodeRequestType"] = reflect.TypeOf((*EvacuateVsanNodeRequestType)(nil)).Elem()
}

type EvacuateVsanNode_Task EvacuateVsanNodeRequestType

func init() {
	t["EvacuateVsanNode_Task"] = reflect.TypeOf((*EvacuateVsanNode_Task)(nil)).Elem()
}

type EvacuateVsanNode_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval"`
}

type EvaluationLicenseSource struct {
	LicenseSource

	RemainingHours int64 `xml:"remainingHours,omitempty"`
}

func init() {
	t["EvaluationLicenseSource"] = reflect.TypeOf((*EvaluationLicenseSource)(nil)).Elem()
}

type EvcManager EvcManagerRequestType

func init() {
	t["EvcManager"] = reflect.TypeOf((*EvcManager)(nil)).Elem()
}

type EvcManagerRequestType struct {
	This ManagedObjectReference `xml:"_this"`
}

func init() {
	t["EvcManagerRequestType"] = reflect.TypeOf((*EvcManagerRequestType)(nil)).Elem()
}

type EvcManagerResponse struct {
	Returnval *ManagedObjectReference `xml:"returnval,omitempty"`
}

type Event struct {
	DynamicData

	Key                  int32                         `xml:"key"`
	ChainId              int32                         `xml:"chainId"`
	CreatedTime          time.Time                     `xml:"createdTime"`
	UserName             string                        `xml:"userName"`
	Datacenter           *DatacenterEventArgument      `xml:"datacenter,omitempty"`
	ComputeResource      *ComputeResourceEventArgument `xml:"computeResource,omitempty"`
	Host                 *HostEventArgument            `xml:"host,omitempty"`
	Vm                   *VmEventArgument              `xml:"vm,omitempty"`
	Ds                   *DatastoreEventArgument       `xml:"ds,omitempty"`
	Net                  *NetworkEventArgument         `xml:"net,omitempty"`
	Dvs                  *DvsEventArgument             `xml:"dvs,omitempty"`
	FullFormattedMessage string                        `xml:"fullFormattedMessage,omitempty"`
	ChangeTag            string                        `xml:"changeTag,omitempty"`
}

func init() {
	t["Event"] = reflect.TypeOf((*Event)(nil)).Elem()
}

type EventAlarmExpression struct {
	AlarmExpression

	Comparisons []EventAlarmExpressionComparison `xml:"comparisons,omitempty"`
	EventType   string                           `xml:"eventType"`
	EventTypeId string                           `xml:"eventTypeId,omitempty"`
	ObjectType  string                           `xml:"objectType,omitempty"`
	Status      ManagedEntityStatus              `xml:"status,omitempty"`
}

func init() {
	t["EventAlarmExpression"] = reflect.TypeOf((*EventAlarmExpression)(nil)).Elem()
}

type EventAlarmExpressionComparison struct {
	DynamicData

	AttributeName string `xml:"attributeName"`
	Operator      string `xml:"operator"`
	Value         string `xml:"value"`
}

func init() {
	t["EventAlarmExpressionComparison"] = reflect.TypeOf((*EventAlarmExpressionComparison)(nil)).Elem()
}

type EventArgDesc struct {
	DynamicData

	Name        string                 `xml:"name"`
	Type        string                 `xml:"type"`
	Description BaseElementDescription `xml:"description,omitempty,typeattr"`
}

func init() {
	t["EventArgDesc"] = reflect.TypeOf((*EventArgDesc)(nil)).Elem()
}

type EventArgument struct {
	DynamicData
}

func init() {
	t["EventArgument"] = reflect.TypeOf((*EventArgument)(nil)).Elem()
}

type EventDescription struct {
	DynamicData

	Category        []BaseElementDescription      `xml:"category,typeattr"`
	EventInfo       []EventDescriptionEventDetail `xml:"eventInfo"`
	EnumeratedTypes []EnumDescription             `xml:"enumeratedTypes,omitempty"`
}

func init() {
	t["EventDescription"] = reflect.TypeOf((*EventDescription)(nil)).Elem()
}

type EventDescriptionEventDetail struct {
	DynamicData

	Key                     string `xml:"key"`
	Description             string `xml:"description,omitempty"`
	Category                string `xml:"category"`
	FormatOnDatacenter      string `xml:"formatOnDatacenter"`
	FormatOnComputeResource string `xml:"formatOnComputeResource"`
	FormatOnHost            string `xml:"formatOnHost"`
	FormatOnVm              string `xml:"formatOnVm"`
	FullFormat              string `xml:"fullFormat"`
	LongDescription         string `xml:"longDescription,omitempty"`
}

func init() {
	t["EventDescriptionEventDetail"] = reflect.TypeOf((*EventDescriptionEventDetail)(nil)).Elem()
}

type EventEx struct {
	Event

	EventTypeId string                `xml:"eventTypeId"`
	Severity    string                `xml:"severity,omitempty"`
	Message     string                `xml:"message,omitempty"`
	Arguments   []KeyAnyValue         `xml:"arguments,omitempty"`
	ObjectId    string                `xml:"objectId,omitempty"`
	ObjectType  string                `xml:"objectType,omitempty"`
	ObjectName  string                `xml:"objectName,omitempty"`
	Fault       *LocalizedMethodFault `xml:"fault,omitempty"`
}

func init() {
	t["EventEx"] = reflect.TypeOf((*EventEx)(nil)).Elem()
}

type EventFilterSpec struct {
	DynamicData

	Entity             *EventFilterSpecByEntity   `xml:"entity,omitempty"`
	Time               *EventFilterSpecByTime     `xml:"time,omitempty"`
	UserName           *EventFilterSpecByUsername `xml:"userName,omitempty"`
	EventChainId       int32                      `xml:"eventChainId,omitempty"`
	Alarm              *ManagedObjectReference    `xml:"alarm,omitempty"`
	ScheduledTask      *ManagedObjectReference    `xml:"scheduledTask,omitempty"`
	DisableFullMessage *bool                      `xml:"disableFullMessage"`
	Category           []string                   `xml:"category,omitempty"`
	Type               []string                   `xml:"type,omitempty"`
	Tag                []string                   `xml:"tag,omitempty"`
	EventTypeId        []string                   `xml:"eventTypeId,omitempty"`
	MaxCount           int32                      `xml:"maxCount,omitempty"`
}

func init() {
	t["EventFilterSpec"] = reflect.TypeOf((*EventFilterSpec)(nil)).Elem()
}

type EventFilterSpecByEntity struct {
	DynamicData

	Entity    ManagedObjectReference         `xml:"entity"`
	Recursion EventFilterSpecRecursionOption `xml:"recursion"`
}

func init() {
	t["EventFilterSpecByEntity"] = reflect.TypeOf((*EventFilterSpecByEntity)(nil)).Elem()
}

type EventFilterSpecByTime struct {
	DynamicData

	BeginTime *time.Time `xml:"beginTime"`
	EndTime   *time.Time `xml:"endTime"`
}

func init() {
	t["EventFilterSpecByTime"] = reflect.TypeOf((*EventFilterSpecByTime)(nil)).Elem()
}

type EventFilterSpecByUsername struct {
	DynamicData

	SystemUser bool     `xml:"systemUser"`
	UserList   []string `xml:"userList,omitempty"`
}

func init() {
	t["EventFilterSpecByUsername"] = reflect.TypeOf((*EventFilterSpecByUsername)(nil)).Elem()
}

type ExecuteHostProfile ExecuteHostProfileRequestType

func init() {
	t["ExecuteHostProfile"] = reflect.TypeOf((*ExecuteHostProfile)(nil)).Elem()
}

type ExecuteHostProfileRequestType struct {
	This          ManagedObjectReference                 `xml:"_this"`
	Host          ManagedObjectReference                 `xml:"host"`
	DeferredParam []ProfileDeferredPolicyOptionParameter `xml:"deferredParam,omitempty"`
}

func init() {
	t["ExecuteHostProfileRequestType"] = reflect.TypeOf((*ExecuteHostProfileRequestType)(nil)).Elem()
}

type ExecuteHostProfileResponse struct {
	Returnval BaseProfileExecuteResult `xml:"returnval,typeattr"`
}

type ExecuteSimpleCommand ExecuteSimpleCommandRequestType

func init() {
	t["ExecuteSimpleCommand"] = reflect.TypeOf((*ExecuteSimpleCommand)(nil)).Elem()
}

type ExecuteSimpleCommandRequestType struct {
	This      ManagedObjectReference `xml:"_this"`
	Arguments []string               `xml:"arguments,omitempty"`
}

func init() {
	t["ExecuteSimpleCommandRequestType"] = reflect.TypeOf((*ExecuteSimpleCommandRequestType)(nil)).Elem()
}

type ExecuteSimpleCommandResponse struct {
	Returnval string `xml:"returnval"`
}

type ExitLockdownMode ExitLockdownModeRequestType

func init() {
	t["ExitLockdownMode"] = reflect.TypeOf((*ExitLockdownMode)(nil)).Elem()
}

type ExitLockdownModeRequestType struct {
	This ManagedObjectReference `xml:"_this"`
}

func init() {
	t["ExitLockdownModeRequestType"] = reflect.TypeOf((*ExitLockdownModeRequestType)(nil)).Elem()
}

type ExitLockdownModeResponse struct {
}

type ExitMaintenanceModeEvent struct {
	HostEvent
}

func init() {
	t["ExitMaintenanceModeEvent"] = reflect.TypeOf((*ExitMaintenanceModeEvent)(nil)).Elem()
}

type ExitMaintenanceModeRequestType struct {
	This    ManagedObjectReference `xml:"_this"`
	Timeout int32                  `xml:"timeout"`
}

func init() {
	t["ExitMaintenanceModeRequestType"] = reflect.TypeOf((*ExitMaintenanceModeRequestType)(nil)).Elem()
}

type ExitMaintenanceMode_Task ExitMaintenanceModeRequestType

func init() {
	t["ExitMaintenanceMode_Task"] = reflect.TypeOf((*ExitMaintenanceMode_Task)(nil)).Elem()
}

type ExitMaintenanceMode_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval"`
}

type ExitStandbyModeFailedEvent struct {
	HostEvent
}

func init() {
	t["ExitStandbyModeFailedEvent"] = reflect.TypeOf((*ExitStandbyModeFailedEvent)(nil)).Elem()
}

type ExitedStandbyModeEvent struct {
	HostEvent
}

func init() {
	t["ExitedStandbyModeEvent"] = reflect.TypeOf((*ExitedStandbyModeEvent)(nil)).Elem()
}

type ExitingStandbyModeEvent struct {
	HostEvent
}

func init() {
	t["ExitingStandbyModeEvent"] = reflect.TypeOf((*ExitingStandbyModeEvent)(nil)).Elem()
}

type ExpandVmfsDatastore ExpandVmfsDatastoreRequestType

func init() {
	t["ExpandVmfsDatastore"] = reflect.TypeOf((*ExpandVmfsDatastore)(nil)).Elem()
}

type ExpandVmfsDatastoreRequestType struct {
	This      ManagedObjectReference  `xml:"_this"`
	Datastore ManagedObjectReference  `xml:"datastore"`
	Spec      VmfsDatastoreExpandSpec `xml:"spec"`
}

func init() {
	t["ExpandVmfsDatastoreRequestType"] = reflect.TypeOf((*ExpandVmfsDatastoreRequestType)(nil)).Elem()
}

type ExpandVmfsDatastoreResponse struct {
	Returnval ManagedObjectReference `xml:"returnval"`
}

type ExpandVmfsExtent ExpandVmfsExtentRequestType

func init() {
	t["ExpandVmfsExtent"] = reflect.TypeOf((*ExpandVmfsExtent)(nil)).Elem()
}

type ExpandVmfsExtentRequestType struct {
	This     ManagedObjectReference `xml:"_this"`
	VmfsPath string                 `xml:"vmfsPath"`
	Extent   HostScsiDiskPartition  `xml:"extent"`
}

func init() {
	t["ExpandVmfsExtentRequestType"] = reflect.TypeOf((*ExpandVmfsExtentRequestType)(nil)).Elem()
}

type ExpandVmfsExtentResponse struct {
}

type ExpiredAddonLicense struct {
	ExpiredFeatureLicense
}

func init() {
	t["ExpiredAddonLicense"] = reflect.TypeOf((*ExpiredAddonLicense)(nil)).Elem()
}

type ExpiredAddonLicenseFault ExpiredAddonLicense

func init() {
	t["ExpiredAddonLicenseFault"] = reflect.TypeOf((*ExpiredAddonLicenseFault)(nil)).Elem()
}

type ExpiredEditionLicense struct {
	ExpiredFeatureLicense
}

func init() {
	t["ExpiredEditionLicense"] = reflect.TypeOf((*ExpiredEditionLicense)(nil)).Elem()
}

type ExpiredEditionLicenseFault ExpiredEditionLicense

func init() {
	t["ExpiredEditionLicenseFault"] = reflect.TypeOf((*ExpiredEditionLicenseFault)(nil)).Elem()
}

type ExpiredFeatureLicense struct {
	NotEnoughLicenses

	Feature        string    `xml:"feature"`
	Count          int32     `xml:"count"`
	ExpirationDate time.Time `xml:"expirationDate"`
}

func init() {
	t["ExpiredFeatureLicense"] = reflect.TypeOf((*ExpiredFeatureLicense)(nil)).Elem()
}

type ExpiredFeatureLicenseFault BaseExpiredFeatureLicense

func init() {
	t["ExpiredFeatureLicenseFault"] = reflect.TypeOf((*ExpiredFeatureLicenseFault)(nil)).Elem()
}

type ExportAnswerFileRequestType struct {
	This ManagedObjectReference `xml:"_this"`
	Host ManagedObjectReference `xml:"host"`
}

func init() {
	t["ExportAnswerFileRequestType"] = reflect.TypeOf((*ExportAnswerFileRequestType)(nil)).Elem()
}

type ExportAnswerFile_Task ExportAnswerFileRequestType

func init() {
	t["ExportAnswerFile_Task"] = reflect.TypeOf((*ExportAnswerFile_Task)(nil)).Elem()
}

type ExportAnswerFile_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval"`
}

type ExportProfile ExportProfileRequestType

func init() {
	t["ExportProfile"] = reflect.TypeOf((*ExportProfile)(nil)).Elem()
}

type ExportProfileRequestType struct {
	This ManagedObjectReference `xml:"_this"`
}

func init() {
	t["ExportProfileRequestType"] = reflect.TypeOf((*ExportProfileRequestType)(nil)).Elem()
}

type ExportProfileResponse struct {
	Returnval string `xml:"returnval"`
}

type ExportSnapshot ExportSnapshotRequestType

func init() {
	t["ExportSnapshot"] = reflect.TypeOf((*ExportSnapshot)(nil)).Elem()
}

type ExportSnapshotRequestType struct {
	This ManagedObjectReference `xml:"_this"`
}

func init() {
	t["ExportSnapshotRequestType"] = reflect.TypeOf((*ExportSnapshotRequestType)(nil)).Elem()
}

type ExportSnapshotResponse struct {
	Returnval ManagedObjectReference `xml:"returnval"`
}

type ExportVApp ExportVAppRequestType

func init() {
	t["ExportVApp"] = reflect.TypeOf((*ExportVApp)(nil)).Elem()
}

type ExportVAppRequestType struct {
	This ManagedObjectReference `xml:"_this"`
}

func init() {
	t["ExportVAppRequestType"] = reflect.TypeOf((*ExportVAppRequestType)(nil)).Elem()
}

type ExportVAppResponse struct {
	Returnval ManagedObjectReference `xml:"returnval"`
}

type ExportVm ExportVmRequestType

func init() {
	t["ExportVm"] = reflect.TypeOf((*ExportVm)(nil)).Elem()
}

type ExportVmRequestType struct {
	This ManagedObjectReference `xml:"_this"`
}

func init() {
	t["ExportVmRequestType"] = reflect.TypeOf((*ExportVmRequestType)(nil)).Elem()
}

type ExportVmResponse struct {
	Returnval ManagedObjectReference `xml:"returnval"`
}

type ExtExtendedProductInfo struct {
	DynamicData

	CompanyUrl    string                  `xml:"companyUrl,omitempty"`
	ProductUrl    string                  `xml:"productUrl,omitempty"`
	ManagementUrl string                  `xml:"managementUrl,omitempty"`
	Self          *ManagedObjectReference `xml:"self,omitempty"`
}

func init() {
	t["ExtExtendedProductInfo"] = reflect.TypeOf((*ExtExtendedProductInfo)(nil)).Elem()
}

type ExtManagedEntityInfo struct {
	DynamicData

	Type         string `xml:"type"`
	SmallIconUrl string `xml:"smallIconUrl,omitempty"`
	IconUrl      string `xml:"iconUrl,omitempty"`
	Description  string `xml:"description,omitempty"`
}

func init() {
	t["ExtManagedEntityInfo"] = reflect.TypeOf((*ExtManagedEntityInfo)(nil)).Elem()
}

type ExtSolutionManagerInfo struct {
	DynamicData

	Tab          []ExtSolutionManagerInfoTabInfo `xml:"tab,omitempty"`
	SmallIconUrl string                          `xml:"smallIconUrl,omitempty"`
}

func init() {
	t["ExtSolutionManagerInfo"] = reflect.TypeOf((*ExtSolutionManagerInfo)(nil)).Elem()
}

type ExtSolutionManagerInfoTabInfo struct {
	DynamicData

	Label string `xml:"label"`
	Url   string `xml:"url"`
}

func init() {
	t["ExtSolutionManagerInfoTabInfo"] = reflect.TypeOf((*ExtSolutionManagerInfoTabInfo)(nil)).Elem()
}

type ExtendDiskRequestType struct {
	This            ManagedObjectReference `xml:"_this"`
	Id              ID                     `xml:"id"`
	Datastore       ManagedObjectReference `xml:"datastore"`
	NewCapacityInMB int64                  `xml:"newCapacityInMB"`
}

func init() {
	t["ExtendDiskRequestType"] = reflect.TypeOf((*ExtendDiskRequestType)(nil)).Elem()
}

type ExtendDisk_Task ExtendDiskRequestType

func init() {
	t["ExtendDisk_Task"] = reflect.TypeOf((*ExtendDisk_Task)(nil)).Elem()
}

type ExtendDisk_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval"`
}

type ExtendHCIRequestType struct {
	This           ManagedObjectReference                         `xml:"_this"`
	HostInputs     []ClusterComputeResourceHostConfigurationInput `xml:"hostInputs,omitempty"`
	VSanConfigSpec *SDDCBase                                      `xml:"vSanConfigSpec,omitempty"`
}

func init() {
	t["ExtendHCIRequestType"] = reflect.TypeOf((*ExtendHCIRequestType)(nil)).Elem()
}

type ExtendHCI_Task ExtendHCIRequestType

func init() {
	t["ExtendHCI_Task"] = reflect.TypeOf((*ExtendHCI_Task)(nil)).Elem()
}

type ExtendHCI_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval"`
}

type ExtendVffs ExtendVffsRequestType

func init() {
	t["ExtendVffs"] = reflect.TypeOf((*ExtendVffs)(nil)).Elem()
}

type ExtendVffsRequestType struct {
	This       ManagedObjectReference `xml:"_this"`
	VffsPath   string                 `xml:"vffsPath"`
	DevicePath string                 `xml:"devicePath"`
	Spec       *HostDiskPartitionSpec `xml:"spec,omitempty"`
}

func init() {
	t["ExtendVffsRequestType"] = reflect.TypeOf((*ExtendVffsRequestType)(nil)).Elem()
}

type ExtendVffsResponse struct {
}

type ExtendVirtualDiskRequestType struct {
	This          ManagedObjectReference  `xml:"_this"`
	Name          string                  `xml:"name"`
	Datacenter    *ManagedObjectReference `xml:"datacenter,omitempty"`
	NewCapacityKb int64                   `xml:"newCapacityKb"`
	EagerZero     *bool                   `xml:"eagerZero"`
}

func init() {
	t["ExtendVirtualDiskRequestType"] = reflect.TypeOf((*ExtendVirtualDiskRequestType)(nil)).Elem()
}

type ExtendVirtualDisk_Task ExtendVirtualDiskRequestType

func init() {
	t["ExtendVirtualDisk_Task"] = reflect.TypeOf((*ExtendVirtualDisk_Task)(nil)).Elem()
}

type ExtendVirtualDisk_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval"`
}

type ExtendVmfsDatastore ExtendVmfsDatastoreRequestType

func init() {
	t["ExtendVmfsDatastore"] = reflect.TypeOf((*ExtendVmfsDatastore)(nil)).Elem()
}

type ExtendVmfsDatastoreRequestType struct {
	This      ManagedObjectReference  `xml:"_this"`
	Datastore ManagedObjectReference  `xml:"datastore"`
	Spec      VmfsDatastoreExtendSpec `xml:"spec"`
}

func init() {
	t["ExtendVmfsDatastoreRequestType"] = reflect.TypeOf((*ExtendVmfsDatastoreRequestType)(nil)).Elem()
}

type ExtendVmfsDatastoreResponse struct {
	Returnval ManagedObjectReference `xml:"returnval"`
}

type ExtendedDescription struct {
	Description

	MessageCatalogKeyPrefix string        `xml:"messageCatalogKeyPrefix"`
	MessageArg              []KeyAnyValue `xml:"messageArg,omitempty"`
}

func init() {
	t["ExtendedDescription"] = reflect.TypeOf((*ExtendedDescription)(nil)).Elem()
}

type ExtendedElementDescription struct {
	ElementDescription

	MessageCatalogKeyPrefix string        `xml:"messageCatalogKeyPrefix"`
	MessageArg              []KeyAnyValue `xml:"messageArg,omitempty"`
}

func init() {
	t["ExtendedElementDescription"] = reflect.TypeOf((*ExtendedElementDescription)(nil)).Elem()
}

type ExtendedEvent struct {
	GeneralEvent

	EventTypeId   string                 `xml:"eventTypeId"`
	ManagedObject ManagedObjectReference `xml:"managedObject"`
	Data          []ExtendedEventPair    `xml:"data,omitempty"`
}

func init() {
	t["ExtendedEvent"] = reflect.TypeOf((*ExtendedEvent)(nil)).Elem()
}

type ExtendedEventPair struct {
	DynamicData

	Key   string `xml:"key"`
	Value string `xml:"value"`
}

func init() {
	t["ExtendedEventPair"] = reflect.TypeOf((*ExtendedEventPair)(nil)).Elem()
}

type ExtendedFault struct {
	VimFault

	FaultTypeId string     `xml:"faultTypeId"`
	Data        []KeyValue `xml:"data,omitempty"`
}

func init() {
	t["ExtendedFault"] = reflect.TypeOf((*ExtendedFault)(nil)).Elem()
}

type ExtendedFaultFault ExtendedFault

func init() {
	t["ExtendedFaultFault"] = reflect.TypeOf((*ExtendedFaultFault)(nil)).Elem()
}

type Extension struct {
	DynamicData

	Description            BaseDescription           `xml:"description,typeattr"`
	Key                    string                    `xml:"key"`
	Company                string                    `xml:"company,omitempty"`
	Type                   string                    `xml:"type,omitempty"`
	Version                string                    `xml:"version"`
	SubjectName            string                    `xml:"subjectName,omitempty"`
	Server                 []ExtensionServerInfo     `xml:"server,omitempty"`
	Client                 []ExtensionClientInfo     `xml:"client,omitempty"`
	TaskList               []ExtensionTaskTypeInfo   `xml:"taskList,omitempty"`
	EventList              []ExtensionEventTypeInfo  `xml:"eventList,omitempty"`
	FaultList              []ExtensionFaultTypeInfo  `xml:"faultList,omitempty"`
	PrivilegeList          []ExtensionPrivilegeInfo  `xml:"privilegeList,omitempty"`
	ResourceList           []ExtensionResourceInfo   `xml:"resourceList,omitempty"`
	LastHeartbeatTime      time.Time                 `xml:"lastHeartbeatTime"`
	HealthInfo             *ExtensionHealthInfo      `xml:"healthInfo,omitempty"`
	OvfConsumerInfo        *ExtensionOvfConsumerInfo `xml:"ovfConsumerInfo,omitempty"`
	ExtendedProductInfo    *ExtExtendedProductInfo   `xml:"extendedProductInfo,omitempty"`
	ManagedEntityInfo      []ExtManagedEntityInfo    `xml:"managedEntityInfo,omitempty"`
	ShownInSolutionManager *bool                     `xml:"shownInSolutionManager"`
	SolutionManagerInfo    *ExtSolutionManagerInfo   `xml:"solutionManagerInfo,omitempty"`
}

func init() {
	t["Extension"] = reflect.TypeOf((*Extension)(nil)).Elem()
}

type ExtensionClientInfo struct {
	DynamicData

	Version     string          `xml:"version"`
	Description BaseDescription `xml:"description,typeattr"`
	Company     string          `xml:"company"`
	Type        string          `xml:"type"`
	Url         string          `xml:"url"`
}

func init() {
	t["ExtensionClientInfo"] = reflect.TypeOf((*ExtensionClientInfo)(nil)).Elem()
}

type ExtensionEventTypeInfo struct {
	DynamicData

	EventID         string `xml:"eventID"`
	EventTypeSchema string `xml:"eventTypeSchema,omitempty"`
}

func init() {
	t["ExtensionEventTypeInfo"] = reflect.TypeOf((*ExtensionEventTypeInfo)(nil)).Elem()
}

type ExtensionFaultTypeInfo struct {
	DynamicData

	FaultID string `xml:"faultID"`
}

func init() {
	t["ExtensionFaultTypeInfo"] = reflect.TypeOf((*ExtensionFaultTypeInfo)(nil)).Elem()
}

type ExtensionHealthInfo struct {
	DynamicData

	Url string `xml:"url"`
}

func init() {
	t["ExtensionHealthInfo"] = reflect.TypeOf((*ExtensionHealthInfo)(nil)).Elem()
}

type ExtensionManagerIpAllocationUsage struct {
	DynamicData

	ExtensionKey string `xml:"extensionKey"`
	NumAddresses int32  `xml:"numAddresses"`
}

func init() {
	t["ExtensionManagerIpAllocationUsage"] = reflect.TypeOf((*ExtensionManagerIpAllocationUsage)(nil)).Elem()
}

type ExtensionOvfConsumerInfo struct {
	DynamicData

	CallbackUrl string   `xml:"callbackUrl"`
	SectionType []string `xml:"sectionType"`
}

func init() {
	t["ExtensionOvfConsumerInfo"] = reflect.TypeOf((*ExtensionOvfConsumerInfo)(nil)).Elem()
}

type ExtensionPrivilegeInfo struct {
	DynamicData

	PrivID        string `xml:"privID"`
	PrivGroupName string `xml:"privGroupName"`
}

func init() {
	t["ExtensionPrivilegeInfo"] = reflect.TypeOf((*ExtensionPrivilegeInfo)(nil)).Elem()
}

type ExtensionResourceInfo struct {
	DynamicData

	Locale string     `xml:"locale"`
	Module string     `xml:"module"`
	Data   []KeyValue `xml:"data"`
}

func init() {
	t["ExtensionResourceInfo"] = reflect.TypeOf((*ExtensionResourceInfo)(nil)).Elem()
}

type ExtensionServerInfo struct {
	DynamicData

	Url              string          `xml:"url"`
	Description      BaseDescription `xml:"description,typeattr"`
	Company          string          `xml:"company"`
	Type             string          `xml:"type"`
	AdminEmail       []string        `xml:"adminEmail"`
	ServerThumbprint string          `xml:"serverThumbprint,omitempty"`
}

func init() {
	t["ExtensionServerInfo"] = reflect.TypeOf((*ExtensionServerInfo)(nil)).Elem()
}

type ExtensionTaskTypeInfo struct {
	DynamicData

	TaskID string `xml:"taskID"`
}

func init() {
	t["ExtensionTaskTypeInfo"] = reflect.TypeOf((*ExtensionTaskTypeInfo)(nil)).Elem()
}

type ExtractOvfEnvironment ExtractOvfEnvironmentRequestType

func init() {
	t["ExtractOvfEnvironment"] = reflect.TypeOf((*ExtractOvfEnvironment)(nil)).Elem()
}

type ExtractOvfEnvironmentRequestType struct {
	This ManagedObjectReference `xml:"_this"`
}

func init() {
	t["ExtractOvfEnvironmentRequestType"] = reflect.TypeOf((*ExtractOvfEnvironmentRequestType)(nil)).Elem()
}

type ExtractOvfEnvironmentResponse struct {
	Returnval string `xml:"returnval"`
}

type FailToEnableSPBM struct {
	NotEnoughLicenses

	Cs                ManagedObjectReference               `xml:"cs"`
	CsName            string                               `xml:"csName"`
	HostLicenseStates []ComputeResourceHostSPBMLicenseInfo `xml:"hostLicenseStates"`
}

func init() {
	t["FailToEnableSPBM"] = reflect.TypeOf((*FailToEnableSPBM)(nil)).Elem()
}

type FailToEnableSPBMFault FailToEnableSPBM

func init() {
	t["FailToEnableSPBMFault"] = reflect.TypeOf((*FailToEnableSPBMFault)(nil)).Elem()
}

type FailToLockFaultToleranceVMs struct {
	RuntimeFault

	VmName          string                 `xml:"vmName"`
	Vm              ManagedObjectReference `xml:"vm"`
	AlreadyLockedVm ManagedObjectReference `xml:"alreadyLockedVm"`
}

func init() {
	t["FailToLockFaultToleranceVMs"] = reflect.TypeOf((*FailToLockFaultToleranceVMs)(nil)).Elem()
}

type FailToLockFaultToleranceVMsFault FailToLockFaultToleranceVMs

func init() {
	t["FailToLockFaultToleranceVMsFault"] = reflect.TypeOf((*FailToLockFaultToleranceVMsFault)(nil)).Elem()
}

type FailoverLevelRestored struct {
	ClusterEvent
}

func init() {
	t["FailoverLevelRestored"] = reflect.TypeOf((*FailoverLevelRestored)(nil)).Elem()
}

type FailoverNodeInfo struct {
	DynamicData

	ClusterIpSettings CustomizationIPSettings  `xml:"clusterIpSettings"`
	FailoverIp        *CustomizationIPSettings `xml:"failoverIp,omitempty"`
	BiosUuid          string                   `xml:"biosUuid,omitempty"`
}

func init() {
	t["FailoverNodeInfo"] = reflect.TypeOf((*FailoverNodeInfo)(nil)).Elem()
}

type FaultDomainId struct {
	DynamicData

	Id string `xml:"id"`
}

func init() {
	t["FaultDomainId"] = reflect.TypeOf((*FaultDomainId)(nil)).Elem()
}

type FaultToleranceAntiAffinityViolated struct {
	MigrationFault

	HostName string                 `xml:"hostName"`
	Host     ManagedObjectReference `xml:"host"`
}

func init() {
	t["FaultToleranceAntiAffinityViolated"] = reflect.TypeOf((*FaultToleranceAntiAffinityViolated)(nil)).Elem()
}

type FaultToleranceAntiAffinityViolatedFault FaultToleranceAntiAffinityViolated

func init() {
	t["FaultToleranceAntiAffinityViolatedFault"] = reflect.TypeOf((*FaultToleranceAntiAffinityViolatedFault)(nil)).Elem()
}

type FaultToleranceCannotEditMem struct {
	VmConfigFault

	VmName string                 `xml:"vmName"`
	Vm     ManagedObjectReference `xml:"vm"`
}

func init() {
	t["FaultToleranceCannotEditMem"] = reflect.TypeOf((*FaultToleranceCannotEditMem)(nil)).Elem()
}

type FaultToleranceCannotEditMemFault FaultToleranceCannotEditMem

func init() {
	t["FaultToleranceCannotEditMemFault"] = reflect.TypeOf((*FaultToleranceCannotEditMemFault)(nil)).Elem()
}

type FaultToleranceConfigInfo struct {
	DynamicData

	Role          int32    `xml:"role"`
	InstanceUuids []string `xml:"instanceUuids"`
	ConfigPaths   []string `xml:"configPaths"`
	Orphaned      *bool    `xml:"orphaned"`
}

func init() {
	t["FaultToleranceConfigInfo"] = reflect.TypeOf((*FaultToleranceConfigInfo)(nil)).Elem()
}

type FaultToleranceConfigSpec struct {
	DynamicData

	MetaDataPath    *FaultToleranceMetaSpec     `xml:"metaDataPath,omitempty"`
	SecondaryVmSpec *FaultToleranceVMConfigSpec `xml:"secondaryVmSpec,omitempty"`
}

func init() {
	t["FaultToleranceConfigSpec"] = reflect.TypeOf((*FaultToleranceConfigSpec)(nil)).Elem()
}

type FaultToleranceCpuIncompatible struct {
	CpuIncompatible

	Model    bool `xml:"model"`
	Family   bool `xml:"family"`
	Stepping bool `xml:"stepping"`
}

func init() {
	t["FaultToleranceCpuIncompatible"] = reflect.TypeOf((*FaultToleranceCpuIncompatible)(nil)).Elem()
}

type FaultToleranceCpuIncompatibleFault FaultToleranceCpuIncompatible

func init() {
	t["FaultToleranceCpuIncompatibleFault"] = reflect.TypeOf((*FaultToleranceCpuIncompatibleFault)(nil)).Elem()
}

type FaultToleranceDiskSpec struct {
	DynamicData

	Disk      BaseVirtualDevice      `xml:"disk,typeattr"`
	Datastore ManagedObjectReference `xml:"datastore"`
}

func init() {
	t["FaultToleranceDiskSpec"] = reflect.TypeOf((*FaultToleranceDiskSpec)(nil)).Elem()
}

type FaultToleranceMetaSpec struct {
	DynamicData

	MetaDataDatastore ManagedObjectReference `xml:"metaDataDatastore"`
}

func init() {
	t["FaultToleranceMetaSpec"] = reflect.TypeOf((*FaultToleranceMetaSpec)(nil)).Elem()
}

type FaultToleranceNeedsThickDisk struct {
	MigrationFault

	VmName string `xml:"vmName"`
}

func init() {
	t["FaultToleranceNeedsThickDisk"] = reflect.TypeOf((*FaultToleranceNeedsThickDisk)(nil)).Elem()
}

type FaultToleranceNeedsThickDiskFault FaultToleranceNeedsThickDisk

func init() {
	t["FaultToleranceNeedsThickDiskFault"] = reflect.TypeOf((*FaultToleranceNeedsThickDiskFault)(nil)).Elem()
}

type FaultToleranceNotLicensed struct {
	VmFaultToleranceIssue

	HostName string `xml:"hostName,omitempty"`
}

func init() {
	t["FaultToleranceNotLicensed"] = reflect.TypeOf((*FaultToleranceNotLicensed)(nil)).Elem()
}

type FaultToleranceNotLicensedFault FaultToleranceNotLicensed

func init() {
	t["FaultToleranceNotLicensedFault"] = reflect.TypeOf((*FaultToleranceNotLicensedFault)(nil)).Elem()
}

type FaultToleranceNotSameBuild struct {
	MigrationFault

	Build string `xml:"build"`
}

func init() {
	t["FaultToleranceNotSameBuild"] = reflect.TypeOf((*FaultToleranceNotSameBuild)(nil)).Elem()
}

type FaultToleranceNotSameBuildFault FaultToleranceNotSameBuild

func init() {
	t["FaultToleranceNotSameBuildFault"] = reflect.TypeOf((*FaultToleranceNotSameBuildFault)(nil)).Elem()
}

type FaultTolerancePrimaryConfigInfo struct {
	FaultToleranceConfigInfo

	Secondaries []ManagedObjectReference `xml:"secondaries"`
}

func init() {
	t["FaultTolerancePrimaryConfigInfo"] = reflect.TypeOf((*FaultTolerancePrimaryConfigInfo)(nil)).Elem()
}

type FaultTolerancePrimaryPowerOnNotAttempted struct {
	VmFaultToleranceIssue

	SecondaryVm ManagedObjectReference `xml:"secondaryVm"`
	PrimaryVm   ManagedObjectReference `xml:"primaryVm"`
}

func init() {
	t["FaultTolerancePrimaryPowerOnNotAttempted"] = reflect.TypeOf((*FaultTolerancePrimaryPowerOnNotAttempted)(nil)).Elem()
}

type FaultTolerancePrimaryPowerOnNotAttemptedFault FaultTolerancePrimaryPowerOnNotAttempted

func init() {
	t["FaultTolerancePrimaryPowerOnNotAttemptedFault"] = reflect.TypeOf((*FaultTolerancePrimaryPowerOnNotAttemptedFault)(nil)).Elem()
}

type FaultToleranceSecondaryConfigInfo struct {
	FaultToleranceConfigInfo

	PrimaryVM ManagedObjectReference `xml:"primaryVM"`
}

func init() {
	t["FaultToleranceSecondaryConfigInfo"] = reflect.TypeOf((*FaultToleranceSecondaryConfigInfo)(nil)).Elem()
}

type FaultToleranceSecondaryOpResult struct {
	DynamicData

	Vm               ManagedObjectReference  `xml:"vm"`
	PowerOnAttempted bool                    `xml:"powerOnAttempted"`
	PowerOnResult    *ClusterPowerOnVmResult `xml:"powerOnResult,omitempty"`
}

func init() {
	t["FaultToleranceSecondaryOpResult"] = reflect.TypeOf((*FaultToleranceSecondaryOpResult)(nil)).Elem()
}

type FaultToleranceVMConfigSpec struct {
	DynamicData

	VmConfig *ManagedObjectReference  `xml:"vmConfig,omitempty"`
	Disks    []FaultToleranceDiskSpec `xml:"disks,omitempty"`
}

func init() {
	t["FaultToleranceVMConfigSpec"] = reflect.TypeOf((*FaultToleranceVMConfigSpec)(nil)).Elem()
}

type FaultToleranceVmNotDasProtected struct {
	VimFault

	Vm     ManagedObjectReference `xml:"vm"`
	VmName string                 `xml:"vmName"`
}

func init() {
	t["FaultToleranceVmNotDasProtected"] = reflect.TypeOf((*FaultToleranceVmNotDasProtected)(nil)).Elem()
}

type FaultToleranceVmNotDasProtectedFault FaultToleranceVmNotDasProtected

func init() {
	t["FaultToleranceVmNotDasProtectedFault"] = reflect.TypeOf((*FaultToleranceVmNotDasProtectedFault)(nil)).Elem()
}

type FaultsByHost struct {
	DynamicData

	Host   ManagedObjectReference `xml:"host"`
	Faults []LocalizedMethodFault `xml:"faults,omitempty"`
}

func init() {
	t["FaultsByHost"] = reflect.TypeOf((*FaultsByHost)(nil)).Elem()
}

type FaultsByVM struct {
	DynamicData

	Vm     ManagedObjectReference `xml:"vm"`
	Faults []LocalizedMethodFault `xml:"faults,omitempty"`
}

func init() {
	t["FaultsByVM"] = reflect.TypeOf((*FaultsByVM)(nil)).Elem()
}

type FcoeConfig struct {
	DynamicData

	PriorityClass int32                      `xml:"priorityClass"`
	SourceMac     string                     `xml:"sourceMac"`
	VlanRange     []FcoeConfigVlanRange      `xml:"vlanRange"`
	Capabilities  FcoeConfigFcoeCapabilities `xml:"capabilities"`
	FcoeActive    bool                       `xml:"fcoeActive"`
}

func init() {
	t["FcoeConfig"] = reflect.TypeOf((*FcoeConfig)(nil)).Elem()
}

type FcoeConfigFcoeCapabilities struct {
	DynamicData

	PriorityClass    bool `xml:"priorityClass"`
	SourceMacAddress bool `xml:"sourceMacAddress"`
	VlanRange        bool `xml:"vlanRange"`
}

func init() {
	t["FcoeConfigFcoeCapabilities"] = reflect.TypeOf((*FcoeConfigFcoeCapabilities)(nil)).Elem()
}

type FcoeConfigFcoeSpecification struct {
	DynamicData

	UnderlyingPnic string                `xml:"underlyingPnic"`
	PriorityClass  int32                 `xml:"priorityClass,omitempty"`
	SourceMac      string                `xml:"sourceMac,omitempty"`
	VlanRange      []FcoeConfigVlanRange `xml:"vlanRange,omitempty"`
}

func init() {
	t["FcoeConfigFcoeSpecification"] = reflect.TypeOf((*FcoeConfigFcoeSpecification)(nil)).Elem()
}

type FcoeConfigVlanRange struct {
	DynamicData

	VlanLow  int32 `xml:"vlanLow"`
	VlanHigh int32 `xml:"vlanHigh"`
}

func init() {
	t["FcoeConfigVlanRange"] = reflect.TypeOf((*FcoeConfigVlanRange)(nil)).Elem()
}

type FcoeFault struct {
	VimFault
}

func init() {
	t["FcoeFault"] = reflect.TypeOf((*FcoeFault)(nil)).Elem()
}

type FcoeFaultFault BaseFcoeFault

func init() {
	t["FcoeFaultFault"] = reflect.TypeOf((*FcoeFaultFault)(nil)).Elem()
}

type FcoeFaultPnicHasNoPortSet struct {
	FcoeFault

	NicDevice string `xml:"nicDevice"`
}

func init() {
	t["FcoeFaultPnicHasNoPortSet"] = reflect.TypeOf((*FcoeFaultPnicHasNoPortSet)(nil)).Elem()
}

type FcoeFaultPnicHasNoPortSetFault FcoeFaultPnicHasNoPortSet

func init() {
	t["FcoeFaultPnicHasNoPortSetFault"] = reflect.TypeOf((*FcoeFaultPnicHasNoPortSetFault)(nil)).Elem()
}

type FeatureEVCMode struct {
	ElementDescription

	Mask        []HostFeatureMask                  `xml:"mask,omitempty"`
	Capability  []HostFeatureCapability            `xml:"capability,omitempty"`
	Requirement []VirtualMachineFeatureRequirement `xml:"requirement,omitempty"`
}

func init() {
	t["FeatureEVCMode"] = reflect.TypeOf((*FeatureEVCMode)(nil)).Elem()
}

type FeatureRequirementsNotMet struct {
	VirtualHardwareCompatibilityIssue

	FeatureRequirement []VirtualMachineFeatureRequirement `xml:"featureRequirement,omitempty"`
	Vm                 *ManagedObjectReference            `xml:"vm,omitempty"`
	Host               *ManagedObjectReference            `xml:"host,omitempty"`
}

func init() {
	t["FeatureRequirementsNotMet"] = reflect.TypeOf((*FeatureRequirementsNotMet)(nil)).Elem()
}

type FeatureRequirementsNotMetFault FeatureRequirementsNotMet

func init() {
	t["FeatureRequirementsNotMetFault"] = reflect.TypeOf((*FeatureRequirementsNotMetFault)(nil)).Elem()
}

type FetchAuditRecords FetchAuditRecordsRequestType

func init() {
	t["FetchAuditRecords"] = reflect.TypeOf((*FetchAuditRecords)(nil)).Elem()
}

type FetchAuditRecordsRequestType struct {
	This  ManagedObjectReference `xml:"_this"`
	Token string                 `xml:"token,omitempty"`
}

func init() {
	t["FetchAuditRecordsRequestType"] = reflect.TypeOf((*FetchAuditRecordsRequestType)(nil)).Elem()
}

type FetchAuditRecordsResponse struct {
	Returnval DiagnosticManagerAuditRecordResult `xml:"returnval"`
}

type FetchDVPortKeys FetchDVPortKeysRequestType

func init() {
	t["FetchDVPortKeys"] = reflect.TypeOf((*FetchDVPortKeys)(nil)).Elem()
}

type FetchDVPortKeysRequestType struct {
	This     ManagedObjectReference                `xml:"_this"`
	Criteria *DistributedVirtualSwitchPortCriteria `xml:"criteria,omitempty"`
}

func init() {
	t["FetchDVPortKeysRequestType"] = reflect.TypeOf((*FetchDVPortKeysRequestType)(nil)).Elem()
}

type FetchDVPortKeysResponse struct {
	Returnval []string `xml:"returnval,omitempty"`
}

type FetchDVPorts FetchDVPortsRequestType

func init() {
	t["FetchDVPorts"] = reflect.TypeOf((*FetchDVPorts)(nil)).Elem()
}

type FetchDVPortsRequestType struct {
	This     ManagedObjectReference                `xml:"_this"`
	Criteria *DistributedVirtualSwitchPortCriteria `xml:"criteria,omitempty"`
}

func init() {
	t["FetchDVPortsRequestType"] = reflect.TypeOf((*FetchDVPortsRequestType)(nil)).Elem()
}

type FetchDVPortsResponse struct {
	Returnval []DistributedVirtualPort `xml:"returnval,omitempty"`
}

type FetchSystemEventLog FetchSystemEventLogRequestType

func init() {
	t["FetchSystemEventLog"] = reflect.TypeOf((*FetchSystemEventLog)(nil)).Elem()
}

type FetchSystemEventLogRequestType struct {
	This ManagedObjectReference `xml:"_this"`
}

func init() {
	t["FetchSystemEventLogRequestType"] = reflect.TypeOf((*FetchSystemEventLogRequestType)(nil)).Elem()
}

type FetchSystemEventLogResponse struct {
	Returnval []SystemEventInfo `xml:"returnval,omitempty"`
}

type FetchUserPrivilegeOnEntities FetchUserPrivilegeOnEntitiesRequestType

func init() {
	t["FetchUserPrivilegeOnEntities"] = reflect.TypeOf((*FetchUserPrivilegeOnEntities)(nil)).Elem()
}

type FetchUserPrivilegeOnEntitiesRequestType struct {
	This     ManagedObjectReference   `xml:"_this"`
	Entities []ManagedObjectReference `xml:"entities"`
	UserName string                   `xml:"userName"`
}

func init() {
	t["FetchUserPrivilegeOnEntitiesRequestType"] = reflect.TypeOf((*FetchUserPrivilegeOnEntitiesRequestType)(nil)).Elem()
}

type FetchUserPrivilegeOnEntitiesResponse struct {
	Returnval []UserPrivilegeResult `xml:"returnval,omitempty"`
}

type FileAlreadyExists struct {
	FileFault
}

func init() {
	t["FileAlreadyExists"] = reflect.TypeOf((*FileAlreadyExists)(nil)).Elem()
}

type FileAlreadyExistsFault FileAlreadyExists

func init() {
	t["FileAlreadyExistsFault"] = reflect.TypeOf((*FileAlreadyExistsFault)(nil)).Elem()
}

type FileBackedPortNotSupported struct {
	DeviceNotSupported
}

func init() {
	t["FileBackedPortNotSupported"] = reflect.TypeOf((*FileBackedPortNotSupported)(nil)).Elem()
}

type FileBackedPortNotSupportedFault FileBackedPortNotSupported

func init() {
	t["FileBackedPortNotSupportedFault"] = reflect.TypeOf((*FileBackedPortNotSupportedFault)(nil)).Elem()
}

type FileBackedVirtualDiskSpec struct {
	VirtualDiskSpec

	CapacityKb int64                           `xml:"capacityKb"`
	Profile    []BaseVirtualMachineProfileSpec `xml:"profile,omitempty,typeattr"`
	Crypto     BaseCryptoSpec                  `xml:"crypto,omitempty,typeattr"`
}

func init() {
	t["FileBackedVirtualDiskSpec"] = reflect.TypeOf((*FileBackedVirtualDiskSpec)(nil)).Elem()
}

type FileFault struct {
	VimFault

	File string `xml:"file"`
}

func init() {
	t["FileFault"] = reflect.TypeOf((*FileFault)(nil)).Elem()
}

type FileFaultFault BaseFileFault

func init() {
	t["FileFaultFault"] = reflect.TypeOf((*FileFaultFault)(nil)).Elem()
}

type FileInfo struct {
	DynamicData

	Path         string     `xml:"path"`
	FriendlyName string     `xml:"friendlyName,omitempty"`
	FileSize     int64      `xml:"fileSize,omitempty"`
	Modification *time.Time `xml:"modification"`
	Owner        string     `xml:"owner,omitempty"`
}

func init() {
	t["FileInfo"] = reflect.TypeOf((*FileInfo)(nil)).Elem()
}

type FileLocked struct {
	FileFault
}

func init() {
	t["FileLocked"] = reflect.TypeOf((*FileLocked)(nil)).Elem()
}

type FileLockedFault FileLocked

func init() {
	t["FileLockedFault"] = reflect.TypeOf((*FileLockedFault)(nil)).Elem()
}

type FileNameTooLong struct {
	FileFault
}

func init() {
	t["FileNameTooLong"] = reflect.TypeOf((*FileNameTooLong)(nil)).Elem()
}

type FileNameTooLongFault FileNameTooLong

func init() {
	t["FileNameTooLongFault"] = reflect.TypeOf((*FileNameTooLongFault)(nil)).Elem()
}

type FileNotFound struct {
	FileFault
}

func init() {
	t["FileNotFound"] = reflect.TypeOf((*FileNotFound)(nil)).Elem()
}

type FileNotFoundFault FileNotFound

func init() {
	t["FileNotFoundFault"] = reflect.TypeOf((*FileNotFoundFault)(nil)).Elem()
}

type FileNotWritable struct {
	FileFault
}

func init() {
	t["FileNotWritable"] = reflect.TypeOf((*FileNotWritable)(nil)).Elem()
}

type FileNotWritableFault FileNotWritable

func init() {
	t["FileNotWritableFault"] = reflect.TypeOf((*FileNotWritableFault)(nil)).Elem()
}

type FileQuery struct {
	DynamicData
}

func init() {
	t["FileQuery"] = reflect.TypeOf((*FileQuery)(nil)).Elem()
}

type FileQueryFlags struct {
	DynamicData

	FileType     bool  `xml:"fileType"`
	FileSize     bool  `xml:"fileSize"`
	Modification bool  `xml:"modification"`
	FileOwner    *bool `xml:"fileOwner"`
}

func init() {
	t["FileQueryFlags"] = reflect.TypeOf((*FileQueryFlags)(nil)).Elem()
}

type FileTooLarge struct {
	FileFault

	Datastore   string `xml:"datastore"`
	FileSize    int64  `xml:"fileSize"`
	MaxFileSize int64  `xml:"maxFileSize,omitempty"`
}

func init() {
	t["FileTooLarge"] = reflect.TypeOf((*FileTooLarge)(nil)).Elem()
}

type FileTooLargeFault FileTooLarge

func init() {
	t["FileTooLargeFault"] = reflect.TypeOf((*FileTooLargeFault)(nil)).Elem()
}

type FileTransferInformation struct {
	DynamicData

	Attributes BaseGuestFileAttributes `xml:"attributes,typeattr"`
	Size       int64                   `xml:"size"`
	Url        string                  `xml:"url"`
}

func init() {
	t["FileTransferInformation"] = reflect.TypeOf((*FileTransferInformation)(nil)).Elem()
}

type FilesystemQuiesceFault struct {
	SnapshotFault
}

func init() {
	t["FilesystemQuiesceFault"] = reflect.TypeOf((*FilesystemQuiesceFault)(nil)).Elem()
}

type FilesystemQuiesceFaultFault FilesystemQuiesceFault

func init() {
	t["FilesystemQuiesceFaultFault"] = reflect.TypeOf((*FilesystemQuiesceFaultFault)(nil)).Elem()
}

type FilterInUse struct {
	ResourceInUse

	Disk []VirtualDiskId `xml:"disk,omitempty"`
}

func init() {
	t["FilterInUse"] = reflect.TypeOf((*FilterInUse)(nil)).Elem()
}

type FilterInUseFault FilterInUse

func init() {
	t["FilterInUseFault"] = reflect.TypeOf((*FilterInUseFault)(nil)).Elem()
}

type FindAllByDnsName FindAllByDnsNameRequestType

func init() {
	t["FindAllByDnsName"] = reflect.TypeOf((*FindAllByDnsName)(nil)).Elem()
}

type FindAllByDnsNameRequestType struct {
	This       ManagedObjectReference  `xml:"_this"`
	Datacenter *ManagedObjectReference `xml:"datacenter,omitempty"`
	DnsName    string                  `xml:"dnsName"`
	VmSearch   bool                    `xml:"vmSearch"`
}

func init() {
	t["FindAllByDnsNameRequestType"] = reflect.TypeOf((*FindAllByDnsNameRequestType)(nil)).Elem()
}

type FindAllByDnsNameResponse struct {
	Returnval []ManagedObjectReference `xml:"returnval"`
}

type FindAllByIp FindAllByIpRequestType

func init() {
	t["FindAllByIp"] = reflect.TypeOf((*FindAllByIp)(nil)).Elem()
}

type FindAllByIpRequestType struct {
	This       ManagedObjectReference  `xml:"_this"`
	Datacenter *ManagedObjectReference `xml:"datacenter,omitempty"`
	Ip         string                  `xml:"ip"`
	VmSearch   bool                    `xml:"vmSearch"`
}

func init() {
	t["FindAllByIpRequestType"] = reflect.TypeOf((*FindAllByIpRequestType)(nil)).Elem()
}

type FindAllByIpResponse struct {
	Returnval []ManagedObjectReference `xml:"returnval"`
}

type FindAllByUuid FindAllByUuidRequestType

func init() {
	t["FindAllByUuid"] = reflect.TypeOf((*FindAllByUuid)(nil)).Elem()
}

type FindAllByUuidRequestType struct {
	This         ManagedObjectReference  `xml:"_this"`
	Datacenter   *ManagedObjectReference `xml:"datacenter,omitempty"`
	Uuid         string                  `xml:"uuid"`
	VmSearch     bool                    `xml:"vmSearch"`
	InstanceUuid *bool                   `xml:"instanceUuid"`
}

func init() {
	t["FindAllByUuidRequestType"] = reflect.TypeOf((*FindAllByUuidRequestType)(nil)).Elem()
}

type FindAllByUuidResponse struct {
	Returnval []ManagedObjectReference `xml:"returnval"`
}

type FindAssociatedProfile FindAssociatedProfileRequestType

func init() {
	t["FindAssociatedProfile"] = reflect.TypeOf((*FindAssociatedProfile)(nil)).Elem()
}

type FindAssociatedProfileRequestType struct {
	This   ManagedObjectReference `xml:"_this"`
	Entity ManagedObjectReference `xml:"entity"`
}

func init() {
	t["FindAssociatedProfileRequestType"] = reflect.TypeOf((*FindAssociatedProfileRequestType)(nil)).Elem()
}

type FindAssociatedProfileResponse struct {
	Returnval []ManagedObjectReference `xml:"returnval,omitempty"`
}

type FindByDatastorePath FindByDatastorePathRequestType

func init() {
	t["FindByDatastorePath"] = reflect.TypeOf((*FindByDatastorePath)(nil)).Elem()
}

type FindByDatastorePathRequestType struct {
	This       ManagedObjectReference `xml:"_this"`
	Datacenter ManagedObjectReference `xml:"datacenter"`
	Path       string                 `xml:"path"`
}

func init() {
	t["FindByDatastorePathRequestType"] = reflect.TypeOf((*FindByDatastorePathRequestType)(nil)).Elem()
}

type FindByDatastorePathResponse struct {
	Returnval *ManagedObjectReference `xml:"returnval,omitempty"`
}

type FindByDnsName FindByDnsNameRequestType

func init() {
	t["FindByDnsName"] = reflect.TypeOf((*FindByDnsName)(nil)).Elem()
}

type FindByDnsNameRequestType struct {
	This       ManagedObjectReference  `xml:"_this"`
	Datacenter *ManagedObjectReference `xml:"datacenter,omitempty"`
	DnsName    string                  `xml:"dnsName"`
	VmSearch   bool                    `xml:"vmSearch"`
}

func init() {
	t["FindByDnsNameRequestType"] = reflect.TypeOf((*FindByDnsNameRequestType)(nil)).Elem()
}

type FindByDnsNameResponse struct {
	Returnval *ManagedObjectReference `xml:"returnval,omitempty"`
}

type FindByInventoryPath FindByInventoryPathRequestType

func init() {
	t["FindByInventoryPath"] = reflect.TypeOf((*FindByInventoryPath)(nil)).Elem()
}

type FindByInventoryPathRequestType struct {
	This          ManagedObjectReference `xml:"_this"`
	InventoryPath string                 `xml:"inventoryPath"`
}

func init() {
	t["FindByInventoryPathRequestType"] = reflect.TypeOf((*FindByInventoryPathRequestType)(nil)).Elem()
}

type FindByInventoryPathResponse struct {
	Returnval *ManagedObjectReference `xml:"returnval,omitempty"`
}

type FindByIp FindByIpRequestType

func init() {
	t["FindByIp"] = reflect.TypeOf((*FindByIp)(nil)).Elem()
}

type FindByIpRequestType struct {
	This       ManagedObjectReference  `xml:"_this"`
	Datacenter *ManagedObjectReference `xml:"datacenter,omitempty"`
	Ip         string                  `xml:"ip"`
	VmSearch   bool                    `xml:"vmSearch"`
}

func init() {
	t["FindByIpRequestType"] = reflect.TypeOf((*FindByIpRequestType)(nil)).Elem()
}

type FindByIpResponse struct {
	Returnval *ManagedObjectReference `xml:"returnval,omitempty"`
}

type FindByUuid FindByUuidRequestType

func init() {
	t["FindByUuid"] = reflect.TypeOf((*FindByUuid)(nil)).Elem()
}

type FindByUuidRequestType struct {
	This         ManagedObjectReference  `xml:"_this"`
	Datacenter   *ManagedObjectReference `xml:"datacenter,omitempty"`
	Uuid         string                  `xml:"uuid"`
	VmSearch     bool                    `xml:"vmSearch"`
	InstanceUuid *bool                   `xml:"instanceUuid"`
}

func init() {
	t["FindByUuidRequestType"] = reflect.TypeOf((*FindByUuidRequestType)(nil)).Elem()
}

type FindByUuidResponse struct {
	Returnval *ManagedObjectReference `xml:"returnval,omitempty"`
}

type FindChild FindChildRequestType

func init() {
	t["FindChild"] = reflect.TypeOf((*FindChild)(nil)).Elem()
}

type FindChildRequestType struct {
	This   ManagedObjectReference `xml:"_this"`
	Entity ManagedObjectReference `xml:"entity"`
	Name   string                 `xml:"name"`
}

func init() {
	t["FindChildRequestType"] = reflect.TypeOf((*FindChildRequestType)(nil)).Elem()
}

type FindChildResponse struct {
	Returnval *ManagedObjectReference `xml:"returnval,omitempty"`
}

type FindExtension FindExtensionRequestType

func init() {
	t["FindExtension"] = reflect.TypeOf((*FindExtension)(nil)).Elem()
}

type FindExtensionRequestType struct {
	This         ManagedObjectReference `xml:"_this"`
	ExtensionKey string                 `xml:"extensionKey"`
}

func init() {
	t["FindExtensionRequestType"] = reflect.TypeOf((*FindExtensionRequestType)(nil)).Elem()
}

type FindExtensionResponse struct {
	Returnval *Extension `xml:"returnval,omitempty"`
}

type FindRulesForVm FindRulesForVmRequestType

func init() {
	t["FindRulesForVm"] = reflect.TypeOf((*FindRulesForVm)(nil)).Elem()
}

type FindRulesForVmRequestType struct {
	This ManagedObjectReference `xml:"_this"`
	Vm   ManagedObjectReference `xml:"vm"`
}

func init() {
	t["FindRulesForVmRequestType"] = reflect.TypeOf((*FindRulesForVmRequestType)(nil)).Elem()
}

type FindRulesForVmResponse struct {
	Returnval []BaseClusterRuleInfo `xml:"returnval,omitempty,typeattr"`
}

type FirewallProfile struct {
	ApplyProfile

	Ruleset []FirewallProfileRulesetProfile `xml:"ruleset,omitempty"`
}

func init() {
	t["FirewallProfile"] = reflect.TypeOf((*FirewallProfile)(nil)).Elem()
}

type FirewallProfileRulesetProfile struct {
	ApplyProfile

	Key string `xml:"key"`
}

func init() {
	t["FirewallProfileRulesetProfile"] = reflect.TypeOf((*FirewallProfileRulesetProfile)(nil)).Elem()
}

type FloatOption struct {
	OptionType

	Min          float32 `xml:"min"`
	Max          float32 `xml:"max"`
	DefaultValue float32 `xml:"defaultValue"`
}

func init() {
	t["FloatOption"] = reflect.TypeOf((*FloatOption)(nil)).Elem()
}

type FloppyImageFileInfo struct {
	FileInfo
}

func init() {
	t["FloppyImageFileInfo"] = reflect.TypeOf((*FloppyImageFileInfo)(nil)).Elem()
}

type FloppyImageFileQuery struct {
	FileQuery
}

func init() {
	t["FloppyImageFileQuery"] = reflect.TypeOf((*FloppyImageFileQuery)(nil)).Elem()
}

type FolderBatchAddHostsToClusterResult struct {
	DynamicData

	HostsAddedToCluster      []ManagedObjectReference `xml:"hostsAddedToCluster,omitempty"`
	HostsFailedInventoryAdd  []FolderFailedHostResult `xml:"hostsFailedInventoryAdd,omitempty"`
	HostsFailedMoveToCluster []FolderFailedHostResult `xml:"hostsFailedMoveToCluster,omitempty"`
}

func init() {
	t["FolderBatchAddHostsToClusterResult"] = reflect.TypeOf((*FolderBatchAddHostsToClusterResult)(nil)).Elem()
}

type FolderBatchAddStandaloneHostsResult struct {
	DynamicData

	AddedHosts              []ManagedObjectReference `xml:"addedHosts,omitempty"`
	HostsFailedInventoryAdd []FolderFailedHostResult `xml:"hostsFailedInventoryAdd,omitempty"`
}

func init() {
	t["FolderBatchAddStandaloneHostsResult"] = reflect.TypeOf((*FolderBatchAddStandaloneHostsResult)(nil)).Elem()
}

type FolderEventArgument struct {
	EntityEventArgument

	Folder ManagedObjectReference `xml:"folder"`
}

func init() {
	t["FolderEventArgument"] = reflect.TypeOf((*FolderEventArgument)(nil)).Elem()
}

type FolderFailedHostResult struct {
	DynamicData

	HostName string                  `xml:"hostName,omitempty"`
	Host     *ManagedObjectReference `xml:"host,omitempty"`
	Context  LocalizableMessage      `xml:"context"`
	Fault    LocalizedMethodFault    `xml:"fault"`
}

func init() {
	t["FolderFailedHostResult"] = reflect.TypeOf((*FolderFailedHostResult)(nil)).Elem()
}

type FolderFileInfo struct {
	FileInfo
}

func init() {
	t["FolderFileInfo"] = reflect.TypeOf((*FolderFileInfo)(nil)).Elem()
}

type FolderFileQuery struct {
	FileQuery
}

func init() {
	t["FolderFileQuery"] = reflect.TypeOf((*FolderFileQuery)(nil)).Elem()
}

type FolderNewHostSpec struct {
	DynamicData

	HostCnxSpec HostConnectSpec `xml:"hostCnxSpec"`
	EsxLicense  string          `xml:"esxLicense,omitempty"`
}

func init() {
	t["FolderNewHostSpec"] = reflect.TypeOf((*FolderNewHostSpec)(nil)).Elem()
}

type FormatVffs FormatVffsRequestType

func init() {
	t["FormatVffs"] = reflect.TypeOf((*FormatVffs)(nil)).Elem()
}

type FormatVffsRequestType struct {
	This       ManagedObjectReference `xml:"_this"`
	CreateSpec HostVffsSpec           `xml:"createSpec"`
}

func init() {
	t["FormatVffsRequestType"] = reflect.TypeOf((*FormatVffsRequestType)(nil)).Elem()
}

type FormatVffsResponse struct {
	Returnval HostVffsVolume `xml:"returnval"`
}

type FormatVmfs FormatVmfsRequestType

func init() {
	t["FormatVmfs"] = reflect.TypeOf((*FormatVmfs)(nil)).Elem()
}

type FormatVmfsRequestType struct {
	This       ManagedObjectReference `xml:"_this"`
	CreateSpec HostVmfsSpec           `xml:"createSpec"`
}

func init() {
	t["FormatVmfsRequestType"] = reflect.TypeOf((*FormatVmfsRequestType)(nil)).Elem()
}

type FormatVmfsResponse struct {
	Returnval HostVmfsVolume `xml:"returnval"`
}

type FtIssuesOnHost struct {
	VmFaultToleranceIssue

	Host     ManagedObjectReference `xml:"host"`
	HostName string                 `xml:"hostName"`
	Errors   []LocalizedMethodFault `xml:"errors,omitempty"`
}

func init() {
	t["FtIssuesOnHost"] = reflect.TypeOf((*FtIssuesOnHost)(nil)).Elem()
}

type FtIssuesOnHostFault FtIssuesOnHost

func init() {
	t["FtIssuesOnHostFault"] = reflect.TypeOf((*FtIssuesOnHostFault)(nil)).Elem()
}

type FullStorageVMotionNotSupported struct {
	MigrationFeatureNotSupported
}

func init() {
	t["FullStorageVMotionNotSupported"] = reflect.TypeOf((*FullStorageVMotionNotSupported)(nil)).Elem()
}

type FullStorageVMotionNotSupportedFault FullStorageVMotionNotSupported

func init() {
	t["FullStorageVMotionNotSupportedFault"] = reflect.TypeOf((*FullStorageVMotionNotSupportedFault)(nil)).Elem()
}

type GatewayConnectFault struct {
	HostConnectFault

	GatewayType string              `xml:"gatewayType"`
	GatewayId   string              `xml:"gatewayId"`
	GatewayInfo string              `xml:"gatewayInfo"`
	Details     *LocalizableMessage `xml:"details,omitempty"`
}

func init() {
	t["GatewayConnectFault"] = reflect.TypeOf((*GatewayConnectFault)(nil)).Elem()
}

type GatewayConnectFaultFault BaseGatewayConnectFault

func init() {
	t["GatewayConnectFaultFault"] = reflect.TypeOf((*GatewayConnectFaultFault)(nil)).Elem()
}

type GatewayHostNotReachable struct {
	GatewayToHostConnectFault
}

func init() {
	t["GatewayHostNotReachable"] = reflect.TypeOf((*GatewayHostNotReachable)(nil)).Elem()
}

type GatewayHostNotReachableFault GatewayHostNotReachable

func init() {
	t["GatewayHostNotReachableFault"] = reflect.TypeOf((*GatewayHostNotReachableFault)(nil)).Elem()
}

type GatewayNotFound struct {
	GatewayConnectFault
}

func init() {
	t["GatewayNotFound"] = reflect.TypeOf((*GatewayNotFound)(nil)).Elem()
}

type GatewayNotFoundFault GatewayNotFound

func init() {
	t["GatewayNotFoundFault"] = reflect.TypeOf((*GatewayNotFoundFault)(nil)).Elem()
}

type GatewayNotReachable struct {
	GatewayConnectFault
}

func init() {
	t["GatewayNotReachable"] = reflect.TypeOf((*GatewayNotReachable)(nil)).Elem()
}

type GatewayNotReachableFault GatewayNotReachable

func init() {
	t["GatewayNotReachableFault"] = reflect.TypeOf((*GatewayNotReachableFault)(nil)).Elem()
}

type GatewayOperationRefused struct {
	GatewayConnectFault
}

func init() {
	t["GatewayOperationRefused"] = reflect.TypeOf((*GatewayOperationRefused)(nil)).Elem()
}

type GatewayOperationRefusedFault GatewayOperationRefused

func init() {
	t["GatewayOperationRefusedFault"] = reflect.TypeOf((*GatewayOperationRefusedFault)(nil)).Elem()
}

type GatewayToHostAuthFault struct {
	GatewayToHostConnectFault

	InvalidProperties []string `xml:"invalidProperties"`
	MissingProperties []string `xml:"missingProperties"`
}

func init() {
	t["GatewayToHostAuthFault"] = reflect.TypeOf((*GatewayToHostAuthFault)(nil)).Elem()
}

type GatewayToHostAuthFaultFault GatewayToHostAuthFault

func init() {
	t["GatewayToHostAuthFaultFault"] = reflect.TypeOf((*GatewayToHostAuthFaultFault)(nil)).Elem()
}

type GatewayToHostConnectFault struct {
	GatewayConnectFault

	Hostname string `xml:"hostname"`
	Port     int32  `xml:"port,omitempty"`
}

func init() {
	t["GatewayToHostConnectFault"] = reflect.TypeOf((*GatewayToHostConnectFault)(nil)).Elem()
}

type GatewayToHostConnectFaultFault BaseGatewayToHostConnectFault

func init() {
	t["GatewayToHostConnectFaultFault"] = reflect.TypeOf((*GatewayToHostConnectFaultFault)(nil)).Elem()
}

type GatewayToHostTrustVerifyFault struct {
	GatewayToHostConnectFault

	VerificationToken  string     `xml:"verificationToken"`
	PropertiesToVerify []KeyValue `xml:"propertiesToVerify"`
}

func init() {
	t["GatewayToHostTrustVerifyFault"] = reflect.TypeOf((*GatewayToHostTrustVerifyFault)(nil)).Elem()
}

type GatewayToHostTrustVerifyFaultFault GatewayToHostTrustVerifyFault

func init() {
	t["GatewayToHostTrustVerifyFaultFault"] = reflect.TypeOf((*GatewayToHostTrustVerifyFaultFault)(nil)).Elem()
}

type GeneralEvent struct {
	Event

	Message string `xml:"message"`
}

func init() {
	t["GeneralEvent"] = reflect.TypeOf((*GeneralEvent)(nil)).Elem()
}

type GeneralHostErrorEvent struct {
	GeneralEvent
}

func init() {
	t["GeneralHostErrorEvent"] = reflect.TypeOf((*GeneralHostErrorEvent)(nil)).Elem()
}

type GeneralHostInfoEvent struct {
	GeneralEvent
}

func init() {
	t["GeneralHostInfoEvent"] = reflect.TypeOf((*GeneralHostInfoEvent)(nil)).Elem()
}

type GeneralHostWarningEvent struct {
	GeneralEvent
}

func init() {
	t["GeneralHostWarningEvent"] = reflect.TypeOf((*GeneralHostWarningEvent)(nil)).Elem()
}

type GeneralUserEvent struct {
	GeneralEvent

	Entity *ManagedEntityEventArgument `xml:"entity,omitempty"`
}

func init() {
	t["GeneralUserEvent"] = reflect.TypeOf((*GeneralUserEvent)(nil)).Elem()
}

type GeneralVmErrorEvent struct {
	GeneralEvent
}

func init() {
	t["GeneralVmErrorEvent"] = reflect.TypeOf((*GeneralVmErrorEvent)(nil)).Elem()
}

type GeneralVmInfoEvent struct {
	GeneralEvent
}

func init() {
	t["GeneralVmInfoEvent"] = reflect.TypeOf((*GeneralVmInfoEvent)(nil)).Elem()
}

type GeneralVmWarningEvent struct {
	GeneralEvent
}

func init() {
	t["GeneralVmWarningEvent"] = reflect.TypeOf((*GeneralVmWarningEvent)(nil)).Elem()
}

type GenerateCertificateSigningRequest GenerateCertificateSigningRequestRequestType

func init() {
	t["GenerateCertificateSigningRequest"] = reflect.TypeOf((*GenerateCertificateSigningRequest)(nil)).Elem()
}

type GenerateCertificateSigningRequestByDn GenerateCertificateSigningRequestByDnRequestType

func init() {
	t["GenerateCertificateSigningRequestByDn"] = reflect.TypeOf((*GenerateCertificateSigningRequestByDn)(nil)).Elem()
}

type GenerateCertificateSigningRequestByDnRequestType struct {
	This              ManagedObjectReference `xml:"_this"`
	DistinguishedName string                 `xml:"distinguishedName"`
}

func init() {
	t["GenerateCertificateSigningRequestByDnRequestType"] = reflect.TypeOf((*GenerateCertificateSigningRequestByDnRequestType)(nil)).Elem()
}

type GenerateCertificateSigningRequestByDnResponse struct {
	Returnval string `xml:"returnval"`
}

type GenerateCertificateSigningRequestRequestType struct {
	This                     ManagedObjectReference `xml:"_this"`
	UseIpAddressAsCommonName bool                   `xml:"useIpAddressAsCommonName"`
}

func init() {
	t["GenerateCertificateSigningRequestRequestType"] = reflect.TypeOf((*GenerateCertificateSigningRequestRequestType)(nil)).Elem()
}

type GenerateCertificateSigningRequestResponse struct {
	Returnval string `xml:"returnval"`
}

type GenerateClientCsr GenerateClientCsrRequestType

func init() {
	t["GenerateClientCsr"] = reflect.TypeOf((*GenerateClientCsr)(nil)).Elem()
}

type GenerateClientCsrRequestType struct {
	This    ManagedObjectReference `xml:"_this"`
	Cluster KeyProviderId          `xml:"cluster"`
}

func init() {
	t["GenerateClientCsrRequestType"] = reflect.TypeOf((*GenerateClientCsrRequestType)(nil)).Elem()
}

type GenerateClientCsrResponse struct {
	Returnval string `xml:"returnval"`
}

type GenerateConfigTaskList GenerateConfigTaskListRequestType

func init() {
	t["GenerateConfigTaskList"] = reflect.TypeOf((*GenerateConfigTaskList)(nil)).Elem()
}

type GenerateConfigTaskListRequestType struct {
	This       ManagedObjectReference `xml:"_this"`
	ConfigSpec HostConfigSpec         `xml:"configSpec"`
	Host       ManagedObjectReference `xml:"host"`
}

func init() {
	t["GenerateConfigTaskListRequestType"] = reflect.TypeOf((*GenerateConfigTaskListRequestType)(nil)).Elem()
}

type GenerateConfigTaskListResponse struct {
	Returnval HostProfileManagerConfigTaskList `xml:"returnval"`
}

type GenerateHostConfigTaskSpecRequestType struct {
	This      ManagedObjectReference     `xml:"_this"`
	HostsInfo []StructuredCustomizations `xml:"hostsInfo,omitempty"`
}

func init() {
	t["GenerateHostConfigTaskSpecRequestType"] = reflect.TypeOf((*GenerateHostConfigTaskSpecRequestType)(nil)).Elem()
}

type GenerateHostConfigTaskSpec_Task GenerateHostConfigTaskSpecRequestType

func init() {
	t["GenerateHostConfigTaskSpec_Task"] = reflect.TypeOf((*GenerateHostConfigTaskSpec_Task)(nil)).Elem()
}

type GenerateHostConfigTaskSpec_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval"`
}

type GenerateHostProfileTaskListRequestType struct {
	This       ManagedObjectReference `xml:"_this"`
	ConfigSpec HostConfigSpec         `xml:"configSpec"`
	Host       ManagedObjectReference `xml:"host"`
}

func init() {
	t["GenerateHostProfileTaskListRequestType"] = reflect.TypeOf((*GenerateHostProfileTaskListRequestType)(nil)).Elem()
}

type GenerateHostProfileTaskList_Task GenerateHostProfileTaskListRequestType

func init() {
	t["GenerateHostProfileTaskList_Task"] = reflect.TypeOf((*GenerateHostProfileTaskList_Task)(nil)).Elem()
}

type GenerateHostProfileTaskList_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval"`
}

type GenerateKey GenerateKeyRequestType

func init() {
	t["GenerateKey"] = reflect.TypeOf((*GenerateKey)(nil)).Elem()
}

type GenerateKeyRequestType struct {
	This        ManagedObjectReference `xml:"_this"`
	KeyProvider *KeyProviderId         `xml:"keyProvider,omitempty"`
}

func init() {
	t["GenerateKeyRequestType"] = reflect.TypeOf((*GenerateKeyRequestType)(nil)).Elem()
}

type GenerateKeyResponse struct {
	Returnval CryptoKeyResult `xml:"returnval"`
}

type GenerateLogBundlesRequestType struct {
	This           ManagedObjectReference   `xml:"_this"`
	IncludeDefault bool                     `xml:"includeDefault"`
	Host           []ManagedObjectReference `xml:"host,omitempty"`
}

func init() {
	t["GenerateLogBundlesRequestType"] = reflect.TypeOf((*GenerateLogBundlesRequestType)(nil)).Elem()
}

type GenerateLogBundles_Task GenerateLogBundlesRequestType

func init() {
	t["GenerateLogBundles_Task"] = reflect.TypeOf((*GenerateLogBundles_Task)(nil)).Elem()
}

type GenerateLogBundles_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval"`
}

type GenerateSelfSignedClientCert GenerateSelfSignedClientCertRequestType

func init() {
	t["GenerateSelfSignedClientCert"] = reflect.TypeOf((*GenerateSelfSignedClientCert)(nil)).Elem()
}

type GenerateSelfSignedClientCertRequestType struct {
	This    ManagedObjectReference `xml:"_this"`
	Cluster KeyProviderId          `xml:"cluster"`
}

func init() {
	t["GenerateSelfSignedClientCertRequestType"] = reflect.TypeOf((*GenerateSelfSignedClientCertRequestType)(nil)).Elem()
}

type GenerateSelfSignedClientCertResponse struct {
	Returnval string `xml:"returnval"`
}

type GenericDrsFault struct {
	VimFault

	HostFaults []LocalizedMethodFault `xml:"hostFaults,omitempty"`
}

func init() {
	t["GenericDrsFault"] = reflect.TypeOf((*GenericDrsFault)(nil)).Elem()
}

type GenericDrsFaultFault GenericDrsFault

func init() {
	t["GenericDrsFaultFault"] = reflect.TypeOf((*GenericDrsFaultFault)(nil)).Elem()
}

type GenericVmConfigFault struct {
	VmConfigFault

	Reason string `xml:"reason"`
}

func init() {
	t["GenericVmConfigFault"] = reflect.TypeOf((*GenericVmConfigFault)(nil)).Elem()
}

type GenericVmConfigFaultFault GenericVmConfigFault

func init() {
	t["GenericVmConfigFaultFault"] = reflect.TypeOf((*GenericVmConfigFaultFault)(nil)).Elem()
}

type GetAlarm GetAlarmRequestType

func init() {
	t["GetAlarm"] = reflect.TypeOf((*GetAlarm)(nil)).Elem()
}

type GetAlarmRequestType struct {
	This   ManagedObjectReference  `xml:"_this"`
	Entity *ManagedObjectReference `xml:"entity,omitempty"`
}

func init() {
	t["GetAlarmRequestType"] = reflect.TypeOf((*GetAlarmRequestType)(nil)).Elem()
}

type GetAlarmResponse struct {
	Returnval []ManagedObjectReference `xml:"returnval,omitempty"`
}

type GetAlarmState GetAlarmStateRequestType

func init() {
	t["GetAlarmState"] = reflect.TypeOf((*GetAlarmState)(nil)).Elem()
}

type GetAlarmStateRequestType struct {
	This   ManagedObjectReference `xml:"_this"`
	Entity ManagedObjectReference `xml:"entity"`
}

func init() {
	t["GetAlarmStateRequestType"] = reflect.TypeOf((*GetAlarmStateRequestType)(nil)).Elem()
}

type GetAlarmStateResponse struct {
	Returnval []AlarmState `xml:"returnval,omitempty"`
}

type GetCustomizationSpec GetCustomizationSpecRequestType

func init() {
	t["GetCustomizationSpec"] = reflect.TypeOf((*GetCustomizationSpec)(nil)).Elem()
}

type GetCustomizationSpecRequestType struct {
	This ManagedObjectReference `xml:"_this"`
	Name string                 `xml:"name"`
}

func init() {
	t["GetCustomizationSpecRequestType"] = reflect.TypeOf((*GetCustomizationSpecRequestType)(nil)).Elem()
}

type GetCustomizationSpecResponse struct {
	Returnval CustomizationSpecItem `xml:"returnval"`
}

type GetDefaultKmsCluster GetDefaultKmsClusterRequestType

func init() {
	t["GetDefaultKmsCluster"] = reflect.TypeOf((*GetDefaultKmsCluster)(nil)).Elem()
}

type GetDefaultKmsClusterRequestType struct {
	This             ManagedObjectReference  `xml:"_this"`
	Entity           *ManagedObjectReference `xml:"entity,omitempty"`
	DefaultsToParent *bool                   `xml:"defaultsToParent"`
}

func init() {
	t["GetDefaultKmsClusterRequestType"] = reflect.TypeOf((*GetDefaultKmsClusterRequestType)(nil)).Elem()
}

type GetDefaultKmsClusterResponse struct {
	Returnval *KeyProviderId `xml:"returnval,omitempty"`
}

type GetPublicKey GetPublicKeyRequestType

func init() {
	t["GetPublicKey"] = reflect.TypeOf((*GetPublicKey)(nil)).Elem()
}

type GetPublicKeyRequestType struct {
	This ManagedObjectReference `xml:"_this"`
}

func init() {
	t["GetPublicKeyRequestType"] = reflect.TypeOf((*GetPublicKeyRequestType)(nil)).Elem()
}

type GetPublicKeyResponse struct {
	Returnval string `xml:"returnval"`
}

type GetResourceUsage GetResourceUsageRequestType

func init() {
	t["GetResourceUsage"] = reflect.TypeOf((*GetResourceUsage)(nil)).Elem()
}

type GetResourceUsageRequestType struct {
	This ManagedObjectReference `xml:"_this"`
}

func init() {
	t["GetResourceUsageRequestType"] = reflect.TypeOf((*GetResourceUsageRequestType)(nil)).Elem()
}

type GetResourceUsageResponse struct {
	Returnval ClusterResourceUsageSummary `xml:"returnval"`
}

type GetSiteInfo GetSiteInfoRequestType

func init() {
	t["GetSiteInfo"] = reflect.TypeOf((*GetSiteInfo)(nil)).Elem()
}

type GetSiteInfoRequestType struct {
	This ManagedObjectReference `xml:"_this"`
}

func init() {
	t["GetSiteInfoRequestType"] = reflect.TypeOf((*GetSiteInfoRequestType)(nil)).Elem()
}

type GetSiteInfoResponse struct {
	Returnval SiteInfo `xml:"returnval"`
}

type GetSystemVMsRestrictedDatastores GetSystemVMsRestrictedDatastoresRequestType

func init() {
	t["GetSystemVMsRestrictedDatastores"] = reflect.TypeOf((*GetSystemVMsRestrictedDatastores)(nil)).Elem()
}

type GetSystemVMsRestrictedDatastoresRequestType struct {
	This ManagedObjectReference `xml:"_this"`
}

func init() {
	t["GetSystemVMsRestrictedDatastoresRequestType"] = reflect.TypeOf((*GetSystemVMsRestrictedDatastoresRequestType)(nil)).Elem()
}

type GetSystemVMsRestrictedDatastoresResponse struct {
	Returnval []ManagedObjectReference `xml:"returnval,omitempty"`
}

type GetVchaClusterHealth GetVchaClusterHealthRequestType

func init() {
	t["GetVchaClusterHealth"] = reflect.TypeOf((*GetVchaClusterHealth)(nil)).Elem()
}

type GetVchaClusterHealthRequestType struct {
	This ManagedObjectReference `xml:"_this"`
}

func init() {
	t["GetVchaClusterHealthRequestType"] = reflect.TypeOf((*GetVchaClusterHealthRequestType)(nil)).Elem()
}

type GetVchaClusterHealthResponse struct {
	Returnval VchaClusterHealth `xml:"returnval"`
}

type GetVsanObjExtAttrs GetVsanObjExtAttrsRequestType

func init() {
	t["GetVsanObjExtAttrs"] = reflect.TypeOf((*GetVsanObjExtAttrs)(nil)).Elem()
}

type GetVsanObjExtAttrsRequestType struct {
	This  ManagedObjectReference `xml:"_this"`
	Uuids []string               `xml:"uuids"`
}

func init() {
	t["GetVsanObjExtAttrsRequestType"] = reflect.TypeOf((*GetVsanObjExtAttrsRequestType)(nil)).Elem()
}

type GetVsanObjExtAttrsResponse struct {
	Returnval string `xml:"returnval"`
}

type GhostDvsProxySwitchDetectedEvent struct {
	HostEvent

	SwitchUuid []string `xml:"switchUuid"`
}

func init() {
	t["GhostDvsProxySwitchDetectedEvent"] = reflect.TypeOf((*GhostDvsProxySwitchDetectedEvent)(nil)).Elem()
}

type GhostDvsProxySwitchRemovedEvent struct {
	HostEvent

	SwitchUuid []string `xml:"switchUuid"`
}

func init() {
	t["GhostDvsProxySwitchRemovedEvent"] = reflect.TypeOf((*GhostDvsProxySwitchRemovedEvent)(nil)).Elem()
}

type GlobalMessageChangedEvent struct {
	SessionEvent

	Message     string `xml:"message"`
	PrevMessage string `xml:"prevMessage,omitempty"`
}

func init() {
	t["GlobalMessageChangedEvent"] = reflect.TypeOf((*GlobalMessageChangedEvent)(nil)).Elem()
}

type GroupAlarmAction struct {
	AlarmAction

	Action []BaseAlarmAction `xml:"action,typeattr"`
}

func init() {
	t["GroupAlarmAction"] = reflect.TypeOf((*GroupAlarmAction)(nil)).Elem()
}

type GuestAliases struct {
	DynamicData

	Base64Cert string               `xml:"base64Cert"`
	Aliases    []GuestAuthAliasInfo `xml:"aliases"`
}

func init() {
	t["GuestAliases"] = reflect.TypeOf((*GuestAliases)(nil)).Elem()
}

type GuestAuthAliasInfo struct {
	DynamicData

	Subject BaseGuestAuthSubject `xml:"subject,typeattr"`
	Comment string               `xml:"comment"`
}

func init() {
	t["GuestAuthAliasInfo"] = reflect.TypeOf((*GuestAuthAliasInfo)(nil)).Elem()
}

type GuestAuthAnySubject struct {
	GuestAuthSubject
}

func init() {
	t["GuestAuthAnySubject"] = reflect.TypeOf((*GuestAuthAnySubject)(nil)).Elem()
}

type GuestAuthNamedSubject struct {
	GuestAuthSubject

	Name string `xml:"name"`
}

func init() {
	t["GuestAuthNamedSubject"] = reflect.TypeOf((*GuestAuthNamedSubject)(nil)).Elem()
}

type GuestAuthSubject struct {
	DynamicData
}

func init() {
	t["GuestAuthSubject"] = reflect.TypeOf((*GuestAuthSubject)(nil)).Elem()
}

type GuestAuthentication struct {
	DynamicData

	InteractiveSession bool `xml:"interactiveSession"`
}

func init() {
	t["GuestAuthentication"] = reflect.TypeOf((*GuestAuthentication)(nil)).Elem()
}

type GuestAuthenticationChallenge struct {
	GuestOperationsFault

	ServerChallenge BaseGuestAuthentication `xml:"serverChallenge,typeattr"`
	SessionID       int64                   `xml:"sessionID"`
}

func init() {
	t["GuestAuthenticationChallenge"] = reflect.TypeOf((*GuestAuthenticationChallenge)(nil)).Elem()
}

type GuestAuthenticationChallengeFault GuestAuthenticationChallenge

func init() {
	t["GuestAuthenticationChallengeFault"] = reflect.TypeOf((*GuestAuthenticationChallengeFault)(nil)).Elem()
}

type GuestComponentsOutOfDate struct {
	GuestOperationsFault
}

func init() {
	t["GuestComponentsOutOfDate"] = reflect.TypeOf((*GuestComponentsOutOfDate)(nil)).Elem()
}

type GuestComponentsOutOfDateFault GuestComponentsOutOfDate

func init() {
	t["GuestComponentsOutOfDateFault"] = reflect.TypeOf((*GuestComponentsOutOfDateFault)(nil)).Elem()
}

type GuestDiskInfo struct {
	DynamicData

	DiskPath       string                        `xml:"diskPath,omitempty"`
	Capacity       int64                         `xml:"capacity,omitempty"`
	FreeSpace      int64                         `xml:"freeSpace,omitempty"`
	FilesystemType string                        `xml:"filesystemType,omitempty"`
	Mappings       []GuestInfoVirtualDiskMapping `xml:"mappings,omitempty"`
}

func init() {
	t["GuestDiskInfo"] = reflect.TypeOf((*GuestDiskInfo)(nil)).Elem()
}

type GuestFileAttributes struct {
	DynamicData

	ModificationTime *time.Time `xml:"modificationTime"`
	AccessTime       *time.Time `xml:"accessTime"`
	SymlinkTarget    string     `xml:"symlinkTarget,omitempty"`
}

func init() {
	t["GuestFileAttributes"] = reflect.TypeOf((*GuestFileAttributes)(nil)).Elem()
}

type GuestFileInfo struct {
	DynamicData

	Path       string                  `xml:"path"`
	Type       string                  `xml:"type"`
	Size       int64                   `xml:"size"`
	Attributes BaseGuestFileAttributes `xml:"attributes,typeattr"`
}

func init() {
	t["GuestFileInfo"] = reflect.TypeOf((*GuestFileInfo)(nil)).Elem()
}

type GuestInfo struct {
	DynamicData

	ToolsStatus                     VirtualMachineToolsStatus          `xml:"toolsStatus,omitempty"`
	ToolsVersionStatus              string                             `xml:"toolsVersionStatus,omitempty"`
	ToolsVersionStatus2             string                             `xml:"toolsVersionStatus2,omitempty"`
	ToolsRunningStatus              string                             `xml:"toolsRunningStatus,omitempty"`
	ToolsVersion                    string                             `xml:"toolsVersion,omitempty"`
	ToolsInstallType                string                             `xml:"toolsInstallType,omitempty"`
	GuestId                         string                             `xml:"guestId,omitempty"`
	GuestFamily                     string                             `xml:"guestFamily,omitempty"`
	GuestFullName                   string                             `xml:"guestFullName,omitempty"`
	HostName                        string                             `xml:"hostName,omitempty"`
	IpAddress                       string                             `xml:"ipAddress,omitempty"`
	Net                             []GuestNicInfo                     `xml:"net,omitempty"`
	IpStack                         []GuestStackInfo                   `xml:"ipStack,omitempty"`
	Disk                            []GuestDiskInfo                    `xml:"disk,omitempty"`
	Screen                          *GuestScreenInfo                   `xml:"screen,omitempty"`
	GuestState                      string                             `xml:"guestState"`
	AppHeartbeatStatus              string                             `xml:"appHeartbeatStatus,omitempty"`
	GuestKernelCrashed              *bool                              `xml:"guestKernelCrashed"`
	AppState                        string                             `xml:"appState,omitempty"`
	GuestOperationsReady            *bool                              `xml:"guestOperationsReady"`
	InteractiveGuestOperationsReady *bool                              `xml:"interactiveGuestOperationsReady"`
	GuestStateChangeSupported       *bool                              `xml:"guestStateChangeSupported"`
	GenerationInfo                  []GuestInfoNamespaceGenerationInfo `xml:"generationInfo,omitempty"`
	HwVersion                       string                             `xml:"hwVersion,omitempty"`
	CustomizationInfo               *GuestInfoCustomizationInfo        `xml:"customizationInfo,omitempty"`
}

func init() {
	t["GuestInfo"] = reflect.TypeOf((*GuestInfo)(nil)).Elem()
}

type GuestInfoCustomizationInfo struct {
	DynamicData

	CustomizationStatus string     `xml:"customizationStatus"`
	StartTime           *time.Time `xml:"startTime"`
	EndTime             *time.Time `xml:"endTime"`
	ErrorMsg            string     `xml:"errorMsg,omitempty"`
}

func init() {
	t["GuestInfoCustomizationInfo"] = reflect.TypeOf((*GuestInfoCustomizationInfo)(nil)).Elem()
}

type GuestInfoNamespaceGenerationInfo struct {
	DynamicData

	Key          string `xml:"key"`
	GenerationNo int32  `xml:"generationNo"`
}

func init() {
	t["GuestInfoNamespaceGenerationInfo"] = reflect.TypeOf((*GuestInfoNamespaceGenerationInfo)(nil)).Elem()
}

type GuestInfoVirtualDiskMapping struct {
	DynamicData

	Key int32 `xml:"key"`
}

func init() {
	t["GuestInfoVirtualDiskMapping"] = reflect.TypeOf((*GuestInfoVirtualDiskMapping)(nil)).Elem()
}

type GuestListFileInfo struct {
	DynamicData

	Files     []GuestFileInfo `xml:"files,omitempty"`
	Remaining int32           `xml:"remaining"`
}

func init() {
	t["GuestListFileInfo"] = reflect.TypeOf((*GuestListFileInfo)(nil)).Elem()
}

type GuestMappedAliases struct {
	DynamicData

	Base64Cert string                 `xml:"base64Cert"`
	Username   string                 `xml:"username"`
	Subjects   []BaseGuestAuthSubject `xml:"subjects,typeattr"`
}

func init() {
	t["GuestMappedAliases"] = reflect.TypeOf((*GuestMappedAliases)(nil)).Elem()
}

type GuestMultipleMappings struct {
	GuestOperationsFault
}

func init() {
	t["GuestMultipleMappings"] = reflect.TypeOf((*GuestMultipleMappings)(nil)).Elem()
}

type GuestMultipleMappingsFault GuestMultipleMappings

func init() {
	t["GuestMultipleMappingsFault"] = reflect.TypeOf((*GuestMultipleMappingsFault)(nil)).Elem()
}

type GuestNicInfo struct {
	DynamicData

	Network        string                `xml:"network,omitempty"`
	IpAddress      []string              `xml:"ipAddress,omitempty"`
	MacAddress     string                `xml:"macAddress,omitempty"`
	Connected      bool                  `xml:"connected"`
	DeviceConfigId int32                 `xml:"deviceConfigId"`
	DnsConfig      *NetDnsConfigInfo     `xml:"dnsConfig,omitempty"`
	IpConfig       *NetIpConfigInfo      `xml:"ipConfig,omitempty"`
	NetBIOSConfig  BaseNetBIOSConfigInfo `xml:"netBIOSConfig,omitempty,typeattr"`
}

func init() {
	t["GuestNicInfo"] = reflect.TypeOf((*GuestNicInfo)(nil)).Elem()
}

type GuestOperationsFault struct {
	VimFault
}

func init() {
	t["GuestOperationsFault"] = reflect.TypeOf((*GuestOperationsFault)(nil)).Elem()
}

type GuestOperationsFaultFault BaseGuestOperationsFault

func init() {
	t["GuestOperationsFaultFault"] = reflect.TypeOf((*GuestOperationsFaultFault)(nil)).Elem()
}

type GuestOperationsUnavailable struct {
	GuestOperationsFault
}

func init() {
	t["GuestOperationsUnavailable"] = reflect.TypeOf((*GuestOperationsUnavailable)(nil)).Elem()
}

type GuestOperationsUnavailableFault GuestOperationsUnavailable

func init() {
	t["GuestOperationsUnavailableFault"] = reflect.TypeOf((*GuestOperationsUnavailableFault)(nil)).Elem()
}

type GuestOsDescriptor struct {
	DynamicData

	Id                                      string          `xml:"id"`
	Family                                  string          `xml:"family"`
	FullName                                string          `xml:"fullName"`
	SupportedMaxCPUs                        int32           `xml:"supportedMaxCPUs"`
	NumSupportedPhysicalSockets             int32           `xml:"numSupportedPhysicalSockets,omitempty"`
	NumSupportedCoresPerSocket              int32           `xml:"numSupportedCoresPerSocket,omitempty"`
	SupportedMinMemMB                       int32           `xml:"supportedMinMemMB"`
	SupportedMaxMemMB                       int32           `xml:"supportedMaxMemMB"`
	RecommendedMemMB                        int32           `xml:"recommendedMemMB"`
	RecommendedColorDepth                   int32           `xml:"recommendedColorDepth"`
	SupportedDiskControllerList             []string        `xml:"supportedDiskControllerList"`
	RecommendedSCSIController               string          `xml:"recommendedSCSIController,omitempty"`
	RecommendedDiskController               string          `xml:"recommendedDiskController"`
	SupportedNumDisks                       int32           `xml:"supportedNumDisks"`
	RecommendedDiskSizeMB                   int32           `xml:"recommendedDiskSizeMB"`
	RecommendedCdromController              string          `xml:"recommendedCdromController,omitempty"`
	SupportedEthernetCard                   []string        `xml:"supportedEthernetCard"`
	RecommendedEthernetCard                 string          `xml:"recommendedEthernetCard,omitempty"`
	SupportsSlaveDisk                       *bool           `xml:"supportsSlaveDisk"`
	CpuFeatureMask                          []HostCpuIdInfo `xml:"cpuFeatureMask,omitempty"`
	SmcRequired                             *bool           `xml:"smcRequired"`
	SupportsWakeOnLan                       bool            `xml:"supportsWakeOnLan"`
	SupportsVMI                             *bool           `xml:"supportsVMI"`
	SupportsMemoryHotAdd                    *bool           `xml:"supportsMemoryHotAdd"`
	SupportsCpuHotAdd                       *bool           `xml:"supportsCpuHotAdd"`
	SupportsCpuHotRemove                    *bool           `xml:"supportsCpuHotRemove"`
	SupportedFirmware                       []string        `xml:"supportedFirmware,omitempty"`
	RecommendedFirmware                     string          `xml:"recommendedFirmware,omitempty"`
	SupportedUSBControllerList              []string        `xml:"supportedUSBControllerList,omitempty"`
	RecommendedUSBController                string          `xml:"recommendedUSBController,omitempty"`
	Supports3D                              *bool           `xml:"supports3D"`
	Recommended3D                           *bool           `xml:"recommended3D"`
	SmcRecommended                          *bool           `xml:"smcRecommended"`
	Ich7mRecommended                        *bool           `xml:"ich7mRecommended"`
	UsbRecommended                          *bool           `xml:"usbRecommended"`
	SupportLevel                            string          `xml:"supportLevel,omitempty"`
	SupportedForCreate                      *bool           `xml:"supportedForCreate"`
	VRAMSizeInKB                            *IntOption      `xml:"vRAMSizeInKB,omitempty"`
	NumSupportedFloppyDevices               int32           `xml:"numSupportedFloppyDevices,omitempty"`
	WakeOnLanEthernetCard                   []string        `xml:"wakeOnLanEthernetCard,omitempty"`
	SupportsPvscsiControllerForBoot         *bool           `xml:"supportsPvscsiControllerForBoot"`
	DiskUuidEnabled                         *bool           `xml:"diskUuidEnabled"`
	SupportsHotPlugPCI                      *bool           `xml:"supportsHotPlugPCI"`
	SupportsSecureBoot                      *bool           `xml:"supportsSecureBoot"`
	DefaultSecureBoot                       *bool           `xml:"defaultSecureBoot"`
	PersistentMemorySupported               *bool           `xml:"persistentMemorySupported"`
	SupportedMinPersistentMemoryMB          int64           `xml:"supportedMinPersistentMemoryMB,omitempty"`
	SupportedMaxPersistentMemoryMB          int64           `xml:"supportedMaxPersistentMemoryMB,omitempty"`
	RecommendedPersistentMemoryMB           int64           `xml:"recommendedPersistentMemoryMB,omitempty"`
	PersistentMemoryHotAddSupported         *bool           `xml:"persistentMemoryHotAddSupported"`
	PersistentMemoryHotRemoveSupported      *bool           `xml:"persistentMemoryHotRemoveSupported"`
	PersistentMemoryColdGrowthSupported     *bool           `xml:"persistentMemoryColdGrowthSupported"`
	PersistentMemoryColdGrowthGranularityMB int64           `xml:"persistentMemoryColdGrowthGranularityMB,omitempty"`
	PersistentMemoryHotGrowthSupported      *bool           `xml:"persistentMemoryHotGrowthSupported"`
	PersistentMemoryHotGrowthGranularityMB  int64           `xml:"persistentMemoryHotGrowthGranularityMB,omitempty"`
	NumRecommendedPhysicalSockets           int32           `xml:"numRecommendedPhysicalSockets,omitempty"`
	NumRecommendedCoresPerSocket            int32           `xml:"numRecommendedCoresPerSocket,omitempty"`
	VvtdSupported                           *BoolOption     `xml:"vvtdSupported,omitempty"`
	VbsSupported                            *BoolOption     `xml:"vbsSupported,omitempty"`
	VsgxSupported                           *BoolOption     `xml:"vsgxSupported,omitempty"`
	SupportsTPM20                           *bool           `xml:"supportsTPM20"`
	VwdtSupported                           *bool           `xml:"vwdtSupported"`
}

func init() {
	t["GuestOsDescriptor"] = reflect.TypeOf((*GuestOsDescriptor)(nil)).Elem()
}

type GuestPermissionDenied struct {
	GuestOperationsFault
}

func init() {
	t["GuestPermissionDenied"] = reflect.TypeOf((*GuestPermissionDenied)(nil)).Elem()
}

type GuestPermissionDeniedFault GuestPermissionDenied

func init() {
	t["GuestPermissionDeniedFault"] = reflect.TypeOf((*GuestPermissionDeniedFault)(nil)).Elem()
}

type GuestPosixFileAttributes struct {
	GuestFileAttributes

	OwnerId     *int32 `xml:"ownerId"`
	GroupId     *int32 `xml:"groupId"`
	Permissions int64  `xml:"permissions,omitempty"`
}

func init() {
	t["GuestPosixFileAttributes"] = reflect.TypeOf((*GuestPosixFileAttributes)(nil)).Elem()
}

type GuestProcessInfo struct {
	DynamicData

	Name      string     `xml:"name"`
	Pid       int64      `xml:"pid"`
	Owner     string     `xml:"owner"`
	CmdLine   string     `xml:"cmdLine"`
	StartTime time.Time  `xml:"startTime"`
	EndTime   *time.Time `xml:"endTime"`
	ExitCode  int32      `xml:"exitCode,omitempty"`
}

func init() {
	t["GuestProcessInfo"] = reflect.TypeOf((*GuestProcessInfo)(nil)).Elem()
}

type GuestProcessNotFound struct {
	GuestOperationsFault

	Pid int64 `xml:"pid"`
}

func init() {
	t["GuestProcessNotFound"] = reflect.TypeOf((*GuestProcessNotFound)(nil)).Elem()
}

type GuestProcessNotFoundFault GuestProcessNotFound

func init() {
	t["GuestProcessNotFoundFault"] = reflect.TypeOf((*GuestProcessNotFoundFault)(nil)).Elem()
}

type GuestProgramSpec struct {
	DynamicData

	ProgramPath      string   `xml:"programPath"`
	Arguments        string   `xml:"arguments"`
	WorkingDirectory string   `xml:"workingDirectory,omitempty"`
	EnvVariables     []string `xml:"envVariables,omitempty"`
}

func init() {
	t["GuestProgramSpec"] = reflect.TypeOf((*GuestProgramSpec)(nil)).Elem()
}

type GuestRegKeyNameSpec struct {
	DynamicData

	RegistryPath string `xml:"registryPath"`
	WowBitness   string `xml:"wowBitness"`
}

func init() {
	t["GuestRegKeyNameSpec"] = reflect.TypeOf((*GuestRegKeyNameSpec)(nil)).Elem()
}

type GuestRegKeyRecordSpec struct {
	DynamicData

	Key   GuestRegKeySpec       `xml:"key"`
	Fault *LocalizedMethodFault `xml:"fault,omitempty"`
}

func init() {
	t["GuestRegKeyRecordSpec"] = reflect.TypeOf((*GuestRegKeyRecordSpec)(nil)).Elem()
}

type GuestRegKeySpec struct {
	DynamicData

	KeyName     GuestRegKeyNameSpec `xml:"keyName"`
	ClassType   string              `xml:"classType"`
	LastWritten time.Time           `xml:"lastWritten"`
}

func init() {
	t["GuestRegKeySpec"] = reflect.TypeOf((*GuestRegKeySpec)(nil)).Elem()
}

type GuestRegValueBinarySpec struct {
	GuestRegValueDataSpec

	Value []byte `xml:"value,omitempty"`
}

func init() {
	t["GuestRegValueBinarySpec"] = reflect.TypeOf((*GuestRegValueBinarySpec)(nil)).Elem()
}

type GuestRegValueDataSpec struct {
	DynamicData
}

func init() {
	t["GuestRegValueDataSpec"] = reflect.TypeOf((*GuestRegValueDataSpec)(nil)).Elem()
}

type GuestRegValueDwordSpec struct {
	GuestRegValueDataSpec

	Value int32 `xml:"value"`
}

func init() {
	t["GuestRegValueDwordSpec"] = reflect.TypeOf((*GuestRegValueDwordSpec)(nil)).Elem()
}

type GuestRegValueExpandStringSpec struct {
	GuestRegValueDataSpec

	Value string `xml:"value,omitempty"`
}

func init() {
	t["GuestRegValueExpandStringSpec"] = reflect.TypeOf((*GuestRegValueExpandStringSpec)(nil)).Elem()
}

type GuestRegValueMultiStringSpec struct {
	GuestRegValueDataSpec

	Value []string `xml:"value,omitempty"`
}

func init() {
	t["GuestRegValueMultiStringSpec"] = reflect.TypeOf((*GuestRegValueMultiStringSpec)(nil)).Elem()
}

type GuestRegValueNameSpec struct {
	DynamicData

	KeyName GuestRegKeyNameSpec `xml:"keyName"`
	Name    string              `xml:"name"`
}

func init() {
	t["GuestRegValueNameSpec"] = reflect.TypeOf((*GuestRegValueNameSpec)(nil)).Elem()
}

type GuestRegValueQwordSpec struct {
	GuestRegValueDataSpec

	Value int64 `xml:"value"`
}

func init() {
	t["GuestRegValueQwordSpec"] = reflect.TypeOf((*GuestRegValueQwordSpec)(nil)).Elem()
}

type GuestRegValueSpec struct {
	DynamicData

	Name GuestRegValueNameSpec     `xml:"name"`
	Data BaseGuestRegValueDataSpec `xml:"data,typeattr"`
}

func init() {
	t["GuestRegValueSpec"] = reflect.TypeOf((*GuestRegValueSpec)(nil)).Elem()
}

type GuestRegValueStringSpec struct {
	GuestRegValueDataSpec

	Value string `xml:"value,omitempty"`
}

func init() {
	t["GuestRegValueStringSpec"] = reflect.TypeOf((*GuestRegValueStringSpec)(nil)).Elem()
}

type GuestRegistryFault struct {
	GuestOperationsFault

	WindowsSystemErrorCode int64 `xml:"windowsSystemErrorCode"`
}

func init() {
	t["GuestRegistryFault"] = reflect.TypeOf((*GuestRegistryFault)(nil)).Elem()
}

type GuestRegistryFaultFault BaseGuestRegistryFault

func init() {
	t["GuestRegistryFaultFault"] = reflect.TypeOf((*GuestRegistryFaultFault)(nil)).Elem()
}

type GuestRegistryKeyAlreadyExists struct {
	GuestRegistryKeyFault
}

func init() {
	t["GuestRegistryKeyAlreadyExists"] = reflect.TypeOf((*GuestRegistryKeyAlreadyExists)(nil)).Elem()
}

type GuestRegistryKeyAlreadyExistsFault GuestRegistryKeyAlreadyExists

func init() {
	t["GuestRegistryKeyAlreadyExistsFault"] = reflect.TypeOf((*GuestRegistryKeyAlreadyExistsFault)(nil)).Elem()
}

type GuestRegistryKeyFault struct {
	GuestRegistryFault

	KeyName string `xml:"keyName"`
}

func init() {
	t["GuestRegistryKeyFault"] = reflect.TypeOf((*GuestRegistryKeyFault)(nil)).Elem()
}

type GuestRegistryKeyFaultFault BaseGuestRegistryKeyFault

func init() {
	t["GuestRegistryKeyFaultFault"] = reflect.TypeOf((*GuestRegistryKeyFaultFault)(nil)).Elem()
}

type GuestRegistryKeyHasSubkeys struct {
	GuestRegistryKeyFault
}

func init() {
	t["GuestRegistryKeyHasSubkeys"] = reflect.TypeOf((*GuestRegistryKeyHasSubkeys)(nil)).Elem()
}

type GuestRegistryKeyHasSubkeysFault GuestRegistryKeyHasSubkeys

func init() {
	t["GuestRegistryKeyHasSubkeysFault"] = reflect.TypeOf((*GuestRegistryKeyHasSubkeysFault)(nil)).Elem()
}

type GuestRegistryKeyInvalid struct {
	GuestRegistryKeyFault
}

func init() {
	t["GuestRegistryKeyInvalid"] = reflect.TypeOf((*GuestRegistryKeyInvalid)(nil)).Elem()
}

type GuestRegistryKeyInvalidFault GuestRegistryKeyInvalid

func init() {
	t["GuestRegistryKeyInvalidFault"] = reflect.TypeOf((*GuestRegistryKeyInvalidFault)(nil)).Elem()
}

type GuestRegistryKeyParentVolatile struct {
	GuestRegistryKeyFault
}

func init() {
	t["GuestRegistryKeyParentVolatile"] = reflect.TypeOf((*GuestRegistryKeyParentVolatile)(nil)).Elem()
}

type GuestRegistryKeyParentVolatileFault GuestRegistryKeyParentVolatile

func init() {
	t["GuestRegistryKeyParentVolatileFault"] = reflect.TypeOf((*GuestRegistryKeyParentVolatileFault)(nil)).Elem()
}

type GuestRegistryValueFault struct {
	GuestRegistryFault

	KeyName   string `xml:"keyName"`
	ValueName string `xml:"valueName"`
}

func init() {
	t["GuestRegistryValueFault"] = reflect.TypeOf((*GuestRegistryValueFault)(nil)).Elem()
}

type GuestRegistryValueFaultFault BaseGuestRegistryValueFault

func init() {
	t["GuestRegistryValueFaultFault"] = reflect.TypeOf((*GuestRegistryValueFaultFault)(nil)).Elem()
}

type GuestRegistryValueNotFound struct {
	GuestRegistryValueFault
}

func init() {
	t["GuestRegistryValueNotFound"] = reflect.TypeOf((*GuestRegistryValueNotFound)(nil)).Elem()
}

type GuestRegistryValueNotFoundFault GuestRegistryValueNotFound

func init() {
	t["GuestRegistryValueNotFoundFault"] = reflect.TypeOf((*GuestRegistryValueNotFoundFault)(nil)).Elem()
}

type GuestScreenInfo struct {
	DynamicData

	Width  int32 `xml:"width"`
	Height int32 `xml:"height"`
}

func init() {
	t["GuestScreenInfo"] = reflect.TypeOf((*GuestScreenInfo)(nil)).Elem()
}

type GuestStackInfo struct {
	DynamicData

	DnsConfig     *NetDnsConfigInfo     `xml:"dnsConfig,omitempty"`
	IpRouteConfig *NetIpRouteConfigInfo `xml:"ipRouteConfig,omitempty"`
	IpStackConfig []KeyValue            `xml:"ipStackConfig,omitempty"`
	DhcpConfig    *NetDhcpConfigInfo    `xml:"dhcpConfig,omitempty"`
}

func init() {
	t["GuestStackInfo"] = reflect.TypeOf((*GuestStackInfo)(nil)).Elem()
}

type GuestWindowsFileAttributes struct {
	GuestFileAttributes

	Hidden     *bool      `xml:"hidden"`
	ReadOnly   *bool      `xml:"readOnly"`
	CreateTime *time.Time `xml:"createTime"`
}

func init() {
	t["GuestWindowsFileAttributes"] = reflect.TypeOf((*GuestWindowsFileAttributes)(nil)).Elem()
}

type GuestWindowsProgramSpec struct {
	GuestProgramSpec

	StartMinimized bool `xml:"startMinimized"`
}

func init() {
	t["GuestWindowsProgramSpec"] = reflect.TypeOf((*GuestWindowsProgramSpec)(nil)).Elem()
}

type HAErrorsAtDest struct {
	MigrationFault
}

func init() {
	t["HAErrorsAtDest"] = reflect.TypeOf((*HAErrorsAtDest)(nil)).Elem()
}

type HAErrorsAtDestFault HAErrorsAtDest

func init() {
	t["HAErrorsAtDestFault"] = reflect.TypeOf((*HAErrorsAtDestFault)(nil)).Elem()
}

type HasMonitoredEntity HasMonitoredEntityRequestType

func init() {
	t["HasMonitoredEntity"] = reflect.TypeOf((*HasMonitoredEntity)(nil)).Elem()
}

type HasMonitoredEntityRequestType struct {
	This       ManagedObjectReference `xml:"_this"`
	ProviderId string                 `xml:"providerId"`
	Entity     ManagedObjectReference `xml:"entity"`
}

func init() {
	t["HasMonitoredEntityRequestType"] = reflect.TypeOf((*HasMonitoredEntityRequestType)(nil)).Elem()
}

type HasMonitoredEntityResponse struct {
	Returnval bool `xml:"returnval"`
}

type HasPrivilegeOnEntities HasPrivilegeOnEntitiesRequestType

func init() {
	t["HasPrivilegeOnEntities"] = reflect.TypeOf((*HasPrivilegeOnEntities)(nil)).Elem()
}

type HasPrivilegeOnEntitiesRequestType struct {
	This      ManagedObjectReference   `xml:"_this"`
	Entity    []ManagedObjectReference `xml:"entity"`
	SessionId string                   `xml:"sessionId"`
	PrivId    []string                 `xml:"privId,omitempty"`
}

func init() {
	t["HasPrivilegeOnEntitiesRequestType"] = reflect.TypeOf((*HasPrivilegeOnEntitiesRequestType)(nil)).Elem()
}

type HasPrivilegeOnEntitiesResponse struct {
	Returnval []EntityPrivilege `xml:"returnval,omitempty"`
}

type HasPrivilegeOnEntity HasPrivilegeOnEntityRequestType

func init() {
	t["HasPrivilegeOnEntity"] = reflect.TypeOf((*HasPrivilegeOnEntity)(nil)).Elem()
}

type HasPrivilegeOnEntityRequestType struct {
	This      ManagedObjectReference `xml:"_this"`
	Entity    ManagedObjectReference `xml:"entity"`
	SessionId string                 `xml:"sessionId"`
	PrivId    []string               `xml:"privId,omitempty"`
}

func init() {
	t["HasPrivilegeOnEntityRequestType"] = reflect.TypeOf((*HasPrivilegeOnEntityRequestType)(nil)).Elem()
}

type HasPrivilegeOnEntityResponse struct {
	Returnval []bool `xml:"returnval,omitempty"`
}

type HasProvider HasProviderRequestType

func init() {
	t["HasProvider"] = reflect.TypeOf((*HasProvider)(nil)).Elem()
}

type HasProviderRequestType struct {
	This ManagedObjectReference `xml:"_this"`
	Id   string                 `xml:"id"`
}

func init() {
	t["HasProviderRequestType"] = reflect.TypeOf((*HasProviderRequestType)(nil)).Elem()
}

type HasProviderResponse struct {
	Returnval bool `xml:"returnval"`
}

type HasUserPrivilegeOnEntities HasUserPrivilegeOnEntitiesRequestType

func init() {
	t["HasUserPrivilegeOnEntities"] = reflect.TypeOf((*HasUserPrivilegeOnEntities)(nil)).Elem()
}

type HasUserPrivilegeOnEntitiesRequestType struct {
	This     ManagedObjectReference   `xml:"_this"`
	Entities []ManagedObjectReference `xml:"entities"`
	UserName string                   `xml:"userName"`
	PrivId   []string                 `xml:"privId,omitempty"`
}

func init() {
	t["HasUserPrivilegeOnEntitiesRequestType"] = reflect.TypeOf((*HasUserPrivilegeOnEntitiesRequestType)(nil)).Elem()
}

type HasUserPrivilegeOnEntitiesResponse struct {
	Returnval []EntityPrivilege `xml:"returnval,omitempty"`
}

type HbrDiskMigrationAction struct {
	ClusterAction

	CollectionId       string                 `xml:"collectionId"`
	CollectionName     string                 `xml:"collectionName"`
	DiskIds            []string               `xml:"diskIds"`
	Source             ManagedObjectReference `xml:"source"`
	Destination        ManagedObjectReference `xml:"destination"`
	SizeTransferred    int64                  `xml:"sizeTransferred"`
	SpaceUtilSrcBefore float32                `xml:"spaceUtilSrcBefore,omitempty"`
	SpaceUtilDstBefore float32                `xml:"spaceUtilDstBefore,omitempty"`
	SpaceUtilSrcAfter  float32                `xml:"spaceUtilSrcAfter,omitempty"`
	SpaceUtilDstAfter  float32                `xml:"spaceUtilDstAfter,omitempty"`
	IoLatencySrcBefore float32                `xml:"ioLatencySrcBefore,omitempty"`
	IoLatencyDstBefore float32                `xml:"ioLatencyDstBefore,omitempty"`
}

func init() {
	t["HbrDiskMigrationAction"] = reflect.TypeOf((*HbrDiskMigrationAction)(nil)).Elem()
}

type HbrManagerReplicationVmInfo struct {
	DynamicData

	State        string                     `xml:"state"`
	ProgressInfo *ReplicationVmProgressInfo `xml:"progressInfo,omitempty"`
	ImageId      string                     `xml:"imageId,omitempty"`
	LastError    *LocalizedMethodFault      `xml:"lastError,omitempty"`
}

func init() {
	t["HbrManagerReplicationVmInfo"] = reflect.TypeOf((*HbrManagerReplicationVmInfo)(nil)).Elem()
}

type HbrManagerVmReplicationCapability struct {
	DynamicData

	Vm                             ManagedObjectReference `xml:"vm"`
	SupportedQuiesceMode           string                 `xml:"supportedQuiesceMode"`
	CompressionSupported           bool                   `xml:"compressionSupported"`
	MaxSupportedSourceDiskCapacity int64                  `xml:"maxSupportedSourceDiskCapacity"`
	MinRpo                         int64                  `xml:"minRpo,omitempty"`
	Fault                          *LocalizedMethodFault  `xml:"fault,omitempty"`
}

func init() {
	t["HbrManagerVmReplicationCapability"] = reflect.TypeOf((*HbrManagerVmReplicationCapability)(nil)).Elem()
}

type HealthStatusChangedEvent struct {
	Event

	ComponentId   string `xml:"componentId"`
	OldStatus     string `xml:"oldStatus"`
	NewStatus     string `xml:"newStatus"`
	ComponentName string `xml:"componentName"`
	ServiceId     string `xml:"serviceId,omitempty"`
}

func init() {
	t["HealthStatusChangedEvent"] = reflect.TypeOf((*HealthStatusChangedEvent)(nil)).Elem()
}

type HealthSystemRuntime struct {
	DynamicData

	SystemHealthInfo   *HostSystemHealthInfo   `xml:"systemHealthInfo,omitempty"`
	HardwareStatusInfo *HostHardwareStatusInfo `xml:"hardwareStatusInfo,omitempty"`
}

func init() {
	t["HealthSystemRuntime"] = reflect.TypeOf((*HealthSystemRuntime)(nil)).Elem()
}

type HealthUpdate struct {
	DynamicData

	Entity             ManagedObjectReference `xml:"entity"`
	HealthUpdateInfoId string                 `xml:"healthUpdateInfoId"`
	Id                 string                 `xml:"id"`
	Status             ManagedEntityStatus    `xml:"status"`
	Remediation        string                 `xml:"remediation"`
}

func init() {
	t["HealthUpdate"] = reflect.TypeOf((*HealthUpdate)(nil)).Elem()
}

type HealthUpdateInfo struct {
	DynamicData

	Id            string `xml:"id"`
	ComponentType string `xml:"componentType"`
	Description   string `xml:"description"`
}

func init() {
	t["HealthUpdateInfo"] = reflect.TypeOf((*HealthUpdateInfo)(nil)).Elem()
}

type HeterogenousHostsBlockingEVC struct {
	EVCConfigFault
}

func init() {
	t["HeterogenousHostsBlockingEVC"] = reflect.TypeOf((*HeterogenousHostsBlockingEVC)(nil)).Elem()
}

type HeterogenousHostsBlockingEVCFault HeterogenousHostsBlockingEVC

func init() {
	t["HeterogenousHostsBlockingEVCFault"] = reflect.TypeOf((*HeterogenousHostsBlockingEVCFault)(nil)).Elem()
}

type HostAccessControlEntry struct {
	DynamicData

	Principal  string         `xml:"principal"`
	Group      bool           `xml:"group"`
	AccessMode HostAccessMode `xml:"accessMode"`
}

func init() {
	t["HostAccessControlEntry"] = reflect.TypeOf((*HostAccessControlEntry)(nil)).Elem()
}

type HostAccessRestrictedToManagementServer struct {
	NotSupported

	ManagementServer string `xml:"managementServer"`
}

func init() {
	t["HostAccessRestrictedToManagementServer"] = reflect.TypeOf((*HostAccessRestrictedToManagementServer)(nil)).Elem()
}

type HostAccessRestrictedToManagementServerFault HostAccessRestrictedToManagementServer

func init() {
	t["HostAccessRestrictedToManagementServerFault"] = reflect.TypeOf((*HostAccessRestrictedToManagementServerFault)(nil)).Elem()
}

type HostAccountSpec struct {
	DynamicData

	Id          string `xml:"id"`
	Password    string `xml:"password,omitempty"`
	Description string `xml:"description,omitempty"`
}

func init() {
	t["HostAccountSpec"] = reflect.TypeOf((*HostAccountSpec)(nil)).Elem()
}

type HostActiveDirectory struct {
	DynamicData

	ChangeOperation string                   `xml:"changeOperation"`
	Spec            *HostActiveDirectorySpec `xml:"spec,omitempty"`
}

func init() {
	t["HostActiveDirectory"] = reflect.TypeOf((*HostActiveDirectory)(nil)).Elem()
}

type HostActiveDirectoryInfo struct {
	HostDirectoryStoreInfo

	JoinedDomain                   string   `xml:"joinedDomain,omitempty"`
	TrustedDomain                  []string `xml:"trustedDomain,omitempty"`
	DomainMembershipStatus         string   `xml:"domainMembershipStatus,omitempty"`
	SmartCardAuthenticationEnabled *bool    `xml:"smartCardAuthenticationEnabled"`
}

func init() {
	t["HostActiveDirectoryInfo"] = reflect.TypeOf((*HostActiveDirectoryInfo)(nil)).Elem()
}

type HostActiveDirectorySpec struct {
	DynamicData

	DomainName                     string   `xml:"domainName,omitempty"`
	UserName                       string   `xml:"userName,omitempty"`
	Password                       string   `xml:"password,omitempty"`
	CamServer                      string   `xml:"camServer,omitempty"`
	Thumbprint                     string   `xml:"thumbprint,omitempty"`
	SmartCardAuthenticationEnabled *bool    `xml:"smartCardAuthenticationEnabled"`
	SmartCardTrustAnchors          []string `xml:"smartCardTrustAnchors,omitempty"`
}

func init() {
	t["HostActiveDirectorySpec"] = reflect.TypeOf((*HostActiveDirectorySpec)(nil)).Elem()
}

type HostAddFailedEvent struct {
	HostEvent

	Hostname string `xml:"hostname"`
}

func init() {
	t["HostAddFailedEvent"] = reflect.TypeOf((*HostAddFailedEvent)(nil)).Elem()
}

type HostAddedEvent struct {
	HostEvent
}

func init() {
	t["HostAddedEvent"] = reflect.TypeOf((*HostAddedEvent)(nil)).Elem()
}

type HostAdminDisableEvent struct {
	HostEvent
}

func init() {
	t["HostAdminDisableEvent"] = reflect.TypeOf((*HostAdminDisableEvent)(nil)).Elem()
}

type HostAdminEnableEvent struct {
	HostEvent
}

func init() {
	t["HostAdminEnableEvent"] = reflect.TypeOf((*HostAdminEnableEvent)(nil)).Elem()
}

type HostApplyProfile struct {
	ApplyProfile

	Memory           *HostMemoryProfile     `xml:"memory,omitempty"`
	Storage          *StorageProfile        `xml:"storage,omitempty"`
	Network          *NetworkProfile        `xml:"network,omitempty"`
	Datetime         *DateTimeProfile       `xml:"datetime,omitempty"`
	Firewall         *FirewallProfile       `xml:"firewall,omitempty"`
	Security         *SecurityProfile       `xml:"security,omitempty"`
	Service          []ServiceProfile       `xml:"service,omitempty"`
	Option           []OptionProfile        `xml:"option,omitempty"`
	UserAccount      []UserProfile          `xml:"userAccount,omitempty"`
	UsergroupAccount []UserGroupProfile     `xml:"usergroupAccount,omitempty"`
	Authentication   *AuthenticationProfile `xml:"authentication,omitempty"`
}

func init() {
	t["HostApplyProfile"] = reflect.TypeOf((*HostApplyProfile)(nil)).Elem()
}

type HostAssignableHardwareBinding struct {
	DynamicData

	InstanceId string                 `xml:"instanceId"`
	Vm         ManagedObjectReference `xml:"vm"`
}

func init() {
	t["HostAssignableHardwareBinding"] = reflect.TypeOf((*HostAssignableHardwareBinding)(nil)).Elem()
}

type HostAssignableHardwareConfig struct {
	DynamicData

	AttributeOverride []HostAssignableHardwareConfigAttributeOverride `xml:"attributeOverride,omitempty"`
}

func init() {
	t["HostAssignableHardwareConfig"] = reflect.TypeOf((*HostAssignableHardwareConfig)(nil)).Elem()
}

type HostAssignableHardwareConfigAttributeOverride struct {
	DynamicData

	InstanceId string  `xml:"instanceId"`
	Name       string  `xml:"name"`
	Value      AnyType `xml:"value,typeattr"`
}

func init() {
	t["HostAssignableHardwareConfigAttributeOverride"] = reflect.TypeOf((*HostAssignableHardwareConfigAttributeOverride)(nil)).Elem()
}

type HostAuthenticationManagerInfo struct {
	DynamicData

	AuthConfig []BaseHostAuthenticationStoreInfo `xml:"authConfig,typeattr"`
}

func init() {
	t["HostAuthenticationManagerInfo"] = reflect.TypeOf((*HostAuthenticationManagerInfo)(nil)).Elem()
}

type HostAuthenticationStoreInfo struct {
	DynamicData

	Enabled bool `xml:"enabled"`
}

func init() {
	t["HostAuthenticationStoreInfo"] = reflect.TypeOf((*HostAuthenticationStoreInfo)(nil)).Elem()
}

type HostAutoStartManagerConfig struct {
	DynamicData

	Defaults  *AutoStartDefaults   `xml:"defaults,omitempty"`
	PowerInfo []AutoStartPowerInfo `xml:"powerInfo,omitempty"`
}

func init() {
	t["HostAutoStartManagerConfig"] = reflect.TypeOf((*HostAutoStartManagerConfig)(nil)).Elem()
}

type HostBIOSInfo struct {
	DynamicData

	BiosVersion          string     `xml:"biosVersion,omitempty"`
	ReleaseDate          *time.Time `xml:"releaseDate"`
	Vendor               string     `xml:"vendor,omitempty"`
	MajorRelease         int32      `xml:"majorRelease,omitempty"`
	MinorRelease         int32      `xml:"minorRelease,omitempty"`
	FirmwareMajorRelease int32      `xml:"firmwareMajorRelease,omitempty"`
	FirmwareMinorRelease int32      `xml:"firmwareMinorRelease,omitempty"`
}

func init() {
	t["HostBIOSInfo"] = reflect.TypeOf((*HostBIOSInfo)(nil)).Elem()
}

type HostBlockAdapterTargetTransport struct {
	HostTargetTransport
}

func init() {
	t["HostBlockAdapterTargetTransport"] = reflect.TypeOf((*HostBlockAdapterTargetTransport)(nil)).Elem()
}

type HostBlockHba struct {
	HostHostBusAdapter
}

func init() {
	t["HostBlockHba"] = reflect.TypeOf((*HostBlockHba)(nil)).Elem()
}

type HostBootDevice struct {
	DynamicData

	Key         string `xml:"key"`
	Description string `xml:"description"`
}

func init() {
	t["HostBootDevice"] = reflect.TypeOf((*HostBootDevice)(nil)).Elem()
}

type HostBootDeviceInfo struct {
	DynamicData

	BootDevices          []HostBootDevice `xml:"bootDevices,omitempty"`
	CurrentBootDeviceKey string           `xml:"currentBootDeviceKey,omitempty"`
}

func init() {
	t["HostBootDeviceInfo"] = reflect.TypeOf((*HostBootDeviceInfo)(nil)).Elem()
}

type HostCacheConfigurationInfo struct {
	DynamicData

	Key      ManagedObjectReference `xml:"key"`
	SwapSize int64                  `xml:"swapSize"`
}

func init() {
	t["HostCacheConfigurationInfo"] = reflect.TypeOf((*HostCacheConfigurationInfo)(nil)).Elem()
}

type HostCacheConfigurationSpec struct {
	DynamicData

	Datastore ManagedObjectReference `xml:"datastore"`
	SwapSize  int64                  `xml:"swapSize"`
}

func init() {
	t["HostCacheConfigurationSpec"] = reflect.TypeOf((*HostCacheConfigurationSpec)(nil)).Elem()
}

type HostCapability struct {
	DynamicData

	RecursiveResourcePoolsSupported           bool            `xml:"recursiveResourcePoolsSupported"`
	CpuMemoryResourceConfigurationSupported   bool            `xml:"cpuMemoryResourceConfigurationSupported"`
	RebootSupported                           bool            `xml:"rebootSupported"`
	ShutdownSupported                         bool            `xml:"shutdownSupported"`
	VmotionSupported                          bool            `xml:"vmotionSupported"`
	StandbySupported                          bool            `xml:"standbySupported"`
	IpmiSupported                             *bool           `xml:"ipmiSupported"`
	MaxSupportedVMs                           int32           `xml:"maxSupportedVMs,omitempty"`
	MaxRunningVMs                             int32           `xml:"maxRunningVMs,omitempty"`
	MaxSupportedVcpus                         int32           `xml:"maxSupportedVcpus,omitempty"`
	MaxRegisteredVMs                          int32           `xml:"maxRegisteredVMs,omitempty"`
	DatastorePrincipalSupported               bool            `xml:"datastorePrincipalSupported"`
	SanSupported                              bool            `xml:"sanSupported"`
	NfsSupported                              bool            `xml:"nfsSupported"`
	IscsiSupported                            bool            `xml:"iscsiSupported"`
	VlanTaggingSupported                      bool            `xml:"vlanTaggingSupported"`
	NicTeamingSupported                       bool            `xml:"nicTeamingSupported"`
	HighGuestMemSupported                     bool            `xml:"highGuestMemSupported"`
	MaintenanceModeSupported                  bool            `xml:"maintenanceModeSupported"`
	SuspendedRelocateSupported                bool            `xml:"suspendedRelocateSupported"`
	RestrictedSnapshotRelocateSupported       bool            `xml:"restrictedSnapshotRelocateSupported"`
	PerVmSwapFiles                            bool            `xml:"perVmSwapFiles"`
	LocalSwapDatastoreSupported               bool            `xml:"localSwapDatastoreSupported"`
	UnsharedSwapVMotionSupported              bool            `xml:"unsharedSwapVMotionSupported"`
	BackgroundSnapshotsSupported              bool            `xml:"backgroundSnapshotsSupported"`
	PreAssignedPCIUnitNumbersSupported        bool            `xml:"preAssignedPCIUnitNumbersSupported"`
	ScreenshotSupported                       bool            `xml:"screenshotSupported"`
	ScaledScreenshotSupported                 bool            `xml:"scaledScreenshotSupported"`
	StorageVMotionSupported                   *bool           `xml:"storageVMotionSupported"`
	VmotionWithStorageVMotionSupported        *bool           `xml:"vmotionWithStorageVMotionSupported"`
	VmotionAcrossNetworkSupported             *bool           `xml:"vmotionAcrossNetworkSupported"`
	MaxNumDisksSVMotion                       int32           `xml:"maxNumDisksSVMotion,omitempty"`
	HbrNicSelectionSupported                  *bool           `xml:"hbrNicSelectionSupported"`
	VrNfcNicSelectionSupported                *bool           `xml:"vrNfcNicSelectionSupported"`
	RecordReplaySupported                     *bool           `xml:"recordReplaySupported"`
	FtSupported                               *bool           `xml:"ftSupported"`
	ReplayUnsupportedReason                   string          `xml:"replayUnsupportedReason,omitempty"`
	ReplayCompatibilityIssues                 []string        `xml:"replayCompatibilityIssues,omitempty"`
	SmpFtSupported                            *bool           `xml:"smpFtSupported"`
	FtCompatibilityIssues                     []string        `xml:"ftCompatibilityIssues,omitempty"`
	SmpFtCompatibilityIssues                  []string        `xml:"smpFtCompatibilityIssues,omitempty"`
	MaxVcpusPerFtVm                           int32           `xml:"maxVcpusPerFtVm,omitempty"`
	LoginBySSLThumbprintSupported             *bool           `xml:"loginBySSLThumbprintSupported"`
	CloneFromSnapshotSupported                *bool           `xml:"cloneFromSnapshotSupported"`
	DeltaDiskBackingsSupported                *bool           `xml:"deltaDiskBackingsSupported"`
	PerVMNetworkTrafficShapingSupported       *bool           `xml:"perVMNetworkTrafficShapingSupported"`
	TpmSupported                              *bool           `xml:"tpmSupported"`
	TpmVersion                                string          `xml:"tpmVersion,omitempty"`
	TxtEnabled                                *bool           `xml:"txtEnabled"`
	SupportedCpuFeature                       []HostCpuIdInfo `xml:"supportedCpuFeature,omitempty"`
	VirtualExecUsageSupported                 *bool           `xml:"virtualExecUsageSupported"`
	StorageIORMSupported                      *bool           `xml:"storageIORMSupported"`
	VmDirectPathGen2Supported                 *bool           `xml:"vmDirectPathGen2Supported"`
	VmDirectPathGen2UnsupportedReason         []string        `xml:"vmDirectPathGen2UnsupportedReason,omitempty"`
	VmDirectPathGen2UnsupportedReasonExtended string          `xml:"vmDirectPathGen2UnsupportedReasonExtended,omitempty"`
	SupportedVmfsMajorVersion                 []int32         `xml:"supportedVmfsMajorVersion,omitempty"`
	VStorageCapable                           *bool           `xml:"vStorageCapable"`
	SnapshotRelayoutSupported                 *bool           `xml:"snapshotRelayoutSupported"`
	FirewallIpRulesSupported                  *bool           `xml:"firewallIpRulesSupported"`
	ServicePackageInfoSupported               *bool           `xml:"servicePackageInfoSupported"`
	MaxHostRunningVms                         int32           `xml:"maxHostRunningVms,omitempty"`
	MaxHostSupportedVcpus                     int32           `xml:"maxHostSupportedVcpus,omitempty"`
	VmfsDatastoreMountCapable                 *bool           `xml:"vmfsDatastoreMountCapable"`
	EightPlusHostVmfsSharedAccessSupported    *bool           `xml:"eightPlusHostVmfsSharedAccessSupported"`
	NestedHVSupported                         *bool           `xml:"nestedHVSupported"`
	VPMCSupported                             *bool           `xml:"vPMCSupported"`
	InterVMCommunicationThroughVMCISupported  *bool           `xml:"interVMCommunicationThroughVMCISupported"`
	ScheduledHardwareUpgradeSupported         *bool           `xml:"scheduledHardwareUpgradeSupported"`
	FeatureCapabilitiesSupported              *bool           `xml:"featureCapabilitiesSupported"`
	LatencySensitivitySupported               *bool           `xml:"latencySensitivitySupported"`
	StoragePolicySupported                    *bool           `xml:"storagePolicySupported"`
	Accel3dSupported                          *bool           `xml:"accel3dSupported"`
	ReliableMemoryAware                       *bool           `xml:"reliableMemoryAware"`
	MultipleNetworkStackInstanceSupported     *bool           `xml:"multipleNetworkStackInstanceSupported"`
	MessageBusProxySupported                  *bool           `xml:"messageBusProxySupported"`
	VsanSupported                             *bool           `xml:"vsanSupported"`
	VFlashSupported                           *bool           `xml:"vFlashSupported"`
	HostAccessManagerSupported                *bool           `xml:"hostAccessManagerSupported"`
	ProvisioningNicSelectionSupported         *bool           `xml:"provisioningNicSelectionSupported"`
	Nfs41Supported                            *bool           `xml:"nfs41Supported"`
	Nfs41Krb5iSupported                       *bool           `xml:"nfs41Krb5iSupported"`
	TurnDiskLocatorLedSupported               *bool           `xml:"turnDiskLocatorLedSupported"`
	VirtualVolumeDatastoreSupported           *bool           `xml:"virtualVolumeDatastoreSupported"`
	MarkAsSsdSupported                        *bool           `xml:"markAsSsdSupported"`
	MarkAsLocalSupported                      *bool           `xml:"markAsLocalSupported"`
	SmartCardAuthenticationSupported          *bool           `xml:"smartCardAuthenticationSupported"`
	PMemSupported                             *bool           `xml:"pMemSupported"`
	PMemSnapshotSupported                     *bool           `xml:"pMemSnapshotSupported"`
	CryptoSupported                           *bool           `xml:"cryptoSupported"`
	OneKVolumeAPIsSupported                   *bool           `xml:"oneKVolumeAPIsSupported"`
	GatewayOnNicSupported                     *bool           `xml:"gatewayOnNicSupported"`
	UpitSupported                             *bool           `xml:"upitSupported"`
	CpuHwMmuSupported                         *bool           `xml:"cpuHwMmuSupported"`
	EncryptedVMotionSupported                 *bool           `xml:"encryptedVMotionSupported"`
	EncryptionChangeOnAddRemoveSupported      *bool           `xml:"encryptionChangeOnAddRemoveSupported"`
	EncryptionHotOperationSupported           *bool           `xml:"encryptionHotOperationSupported"`
	EncryptionWithSnapshotsSupported          *bool           `xml:"encryptionWithSnapshotsSupported"`
	EncryptionFaultToleranceSupported         *bool           `xml:"encryptionFaultToleranceSupported"`
	EncryptionMemorySaveSupported             *bool           `xml:"encryptionMemorySaveSupported"`
	EncryptionRDMSupported                    *bool           `xml:"encryptionRDMSupported"`
	EncryptionVFlashSupported                 *bool           `xml:"encryptionVFlashSupported"`
	EncryptionCBRCSupported                   *bool           `xml:"encryptionCBRCSupported"`
	EncryptionHBRSupported                    *bool           `xml:"encryptionHBRSupported"`
	FtEfiSupported                            *bool           `xml:"ftEfiSupported"`
	UnmapMethodSupported                      string          `xml:"unmapMethodSupported,omitempty"`
	MaxMemMBPerFtVm                           int32           `xml:"maxMemMBPerFtVm,omitempty"`
	VirtualMmuUsageIgnored                    *bool           `xml:"virtualMmuUsageIgnored"`
	VirtualExecUsageIgnored                   *bool           `xml:"virtualExecUsageIgnored"`
	VmCreateDateSupported                     *bool           `xml:"vmCreateDateSupported"`
	Vmfs3EOLSupported                         *bool           `xml:"vmfs3EOLSupported"`
	FtVmcpSupported                           *bool           `xml:"ftVmcpSupported"`
	QuickBootSupported                        *bool           `xml:"quickBootSupported"`
	EncryptedFtSupported                      *bool           `xml:"encryptedFtSupported"`
	AssignableHardwareSupported               *bool           `xml:"assignableHardwareSupported"`
	SuspendToMemorySupported                  *bool           `xml:"suspendToMemorySupported"`
	UseFeatureReqsForOldHWv                   *bool           `xml:"useFeatureReqsForOldHWv"`
	MarkPerenniallyReservedSupported          *bool           `xml:"markPerenniallyReservedSupported"`
	HppPspSupported                           *bool           `xml:"hppPspSupported"`
	DeviceRebindWithoutRebootSupported        *bool           `xml:"deviceRebindWithoutRebootSupported"`
	StoragePolicyChangeSupported              *bool           `xml:"storagePolicyChangeSupported"`
	PrecisionTimeProtocolSupported            *bool           `xml:"precisionTimeProtocolSupported"`
	RemoteDeviceVMotionSupported              *bool           `xml:"remoteDeviceVMotionSupported"`
	MaxSupportedVmMemory                      int32           `xml:"maxSupportedVmMemory,omitempty"`
	AhDeviceHintsSupported                    *bool           `xml:"ahDeviceHintsSupported"`
	NvmeOverTcpSupported                      *bool           `xml:"nvmeOverTcpSupported"`
	NvmeStorageFabricServicesSupported        *bool           `xml:"nvmeStorageFabricServicesSupported"`
	AssignHwPciConfigSupported                *bool           `xml:"assignHwPciConfigSupported"`
	TimeConfigSupported                       *bool           `xml:"timeConfigSupported"`
	NvmeBatchOperationsSupported              *bool           `xml:"nvmeBatchOperationsSupported"`
	PMemFailoverSupported                     *bool           `xml:"pMemFailoverSupported"`
	HostConfigEncryptionSupported             *bool           `xml:"hostConfigEncryptionSupported"`
	PtpConfigSupported                        *bool           `xml:"ptpConfigSupported"`
	MaxSupportedPtpPorts                      int32           `xml:"maxSupportedPtpPorts,omitempty"`
	PMemIndependentSnapshotSupported          *bool           `xml:"pMemIndependentSnapshotSupported"`
}

func init() {
	t["HostCapability"] = reflect.TypeOf((*HostCapability)(nil)).Elem()
}

type HostCertificateManagerCertificateInfo struct {
	DynamicData

	Issuer    string     `xml:"issuer,omitempty"`
	NotBefore *time.Time `xml:"notBefore"`
	NotAfter  *time.Time `xml:"notAfter"`
	Subject   string     `xml:"subject,omitempty"`
	Status    string     `xml:"status"`
}

func init() {
	t["HostCertificateManagerCertificateInfo"] = reflect.TypeOf((*HostCertificateManagerCertificateInfo)(nil)).Elem()
}

type HostClearVStorageObjectControlFlags HostClearVStorageObjectControlFlagsRequestType

func init() {
	t["HostClearVStorageObjectControlFlags"] = reflect.TypeOf((*HostClearVStorageObjectControlFlags)(nil)).Elem()
}

type HostClearVStorageObjectControlFlagsRequestType struct {
	This         ManagedObjectReference `xml:"_this"`
	Id           ID                     `xml:"id"`
	Datastore    ManagedObjectReference `xml:"datastore"`
	ControlFlags []string               `xml:"controlFlags,omitempty"`
}

func init() {
	t["HostClearVStorageObjectControlFlagsRequestType"] = reflect.TypeOf((*HostClearVStorageObjectControlFlagsRequestType)(nil)).Elem()
}

type HostClearVStorageObjectControlFlagsResponse struct {
}

type HostCloneVStorageObjectRequestType struct {
	This      ManagedObjectReference `xml:"_this"`
	Id        ID                     `xml:"id"`
	Datastore ManagedObjectReference `xml:"datastore"`
	Spec      VslmCloneSpec          `xml:"spec"`
}

func init() {
	t["HostCloneVStorageObjectRequestType"] = reflect.TypeOf((*HostCloneVStorageObjectRequestType)(nil)).Elem()
}

type HostCloneVStorageObject_Task HostCloneVStorageObjectRequestType

func init() {
	t["HostCloneVStorageObject_Task"] = reflect.TypeOf((*HostCloneVStorageObject_Task)(nil)).Elem()
}

type HostCloneVStorageObject_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval"`
}

type HostCnxFailedAccountFailedEvent struct {
	HostEvent
}

func init() {
	t["HostCnxFailedAccountFailedEvent"] = reflect.TypeOf((*HostCnxFailedAccountFailedEvent)(nil)).Elem()
}

type HostCnxFailedAlreadyManagedEvent struct {
	HostEvent

	ServerName string `xml:"serverName"`
}

func init() {
	t["HostCnxFailedAlreadyManagedEvent"] = reflect.TypeOf((*HostCnxFailedAlreadyManagedEvent)(nil)).Elem()
}

type HostCnxFailedBadCcagentEvent struct {
	HostEvent
}

func init() {
	t["HostCnxFailedBadCcagentEvent"] = reflect.TypeOf((*HostCnxFailedBadCcagentEvent)(nil)).Elem()
}

type HostCnxFailedBadUsernameEvent struct {
	HostEvent
}

func init() {
	t["HostCnxFailedBadUsernameEvent"] = reflect.TypeOf((*HostCnxFailedBadUsernameEvent)(nil)).Elem()
}

type HostCnxFailedBadVersionEvent struct {
	HostEvent
}

func init() {
	t["HostCnxFailedBadVersionEvent"] = reflect.TypeOf((*HostCnxFailedBadVersionEvent)(nil)).Elem()
}

type HostCnxFailedCcagentUpgradeEvent struct {
	HostEvent
}

func init() {
	t["HostCnxFailedCcagentUpgradeEvent"] = reflect.TypeOf((*HostCnxFailedCcagentUpgradeEvent)(nil)).Elem()
}

type HostCnxFailedEvent struct {
	HostEvent
}

func init() {
	t["HostCnxFailedEvent"] = reflect.TypeOf((*HostCnxFailedEvent)(nil)).Elem()
}

type HostCnxFailedNetworkErrorEvent struct {
	HostEvent
}

func init() {
	t["HostCnxFailedNetworkErrorEvent"] = reflect.TypeOf((*HostCnxFailedNetworkErrorEvent)(nil)).Elem()
}

type HostCnxFailedNoAccessEvent struct {
	HostEvent
}

func init() {
	t["HostCnxFailedNoAccessEvent"] = reflect.TypeOf((*HostCnxFailedNoAccessEvent)(nil)).Elem()
}

type HostCnxFailedNoConnectionEvent struct {
	HostEvent
}

func init() {
	t["HostCnxFailedNoConnectionEvent"] = reflect.TypeOf((*HostCnxFailedNoConnectionEvent)(nil)).Elem()
}

type HostCnxFailedNoLicenseEvent struct {
	HostEvent
}

func init() {
	t["HostCnxFailedNoLicenseEvent"] = reflect.TypeOf((*HostCnxFailedNoLicenseEvent)(nil)).Elem()
}

type HostCnxFailedNotFoundEvent struct {
	HostEvent
}

func init() {
	t["HostCnxFailedNotFoundEvent"] = reflect.TypeOf((*HostCnxFailedNotFoundEvent)(nil)).Elem()
}

type HostCnxFailedTimeoutEvent struct {
	HostEvent
}

func init() {
	t["HostCnxFailedTimeoutEvent"] = reflect.TypeOf((*HostCnxFailedTimeoutEvent)(nil)).Elem()
}

type HostCommunication struct {
	RuntimeFault
}

func init() {
	t["HostCommunication"] = reflect.TypeOf((*HostCommunication)(nil)).Elem()
}

type HostCommunicationFault BaseHostCommunication

func init() {
	t["HostCommunicationFault"] = reflect.TypeOf((*HostCommunicationFault)(nil)).Elem()
}

type HostComplianceCheckedEvent struct {
	HostEvent

	Profile ProfileEventArgument `xml:"profile"`
}

func init() {
	t["HostComplianceCheckedEvent"] = reflect.TypeOf((*HostComplianceCheckedEvent)(nil)).Elem()
}

type HostCompliantEvent struct {
	HostEvent
}

func init() {
	t["HostCompliantEvent"] = reflect.TypeOf((*HostCompliantEvent)(nil)).Elem()
}

type HostConfigAppliedEvent struct {
	HostEvent
}

func init() {
	t["HostConfigAppliedEvent"] = reflect.TypeOf((*HostConfigAppliedEvent)(nil)).Elem()
}

type HostConfigChange struct {
	DynamicData
}

func init() {
	t["HostConfigChange"] = reflect.TypeOf((*HostConfigChange)(nil)).Elem()
}

type HostConfigFailed struct {
	HostConfigFault

	Failure []LocalizedMethodFault `xml:"failure"`
}

func init() {
	t["HostConfigFailed"] = reflect.TypeOf((*HostConfigFailed)(nil)).Elem()
}

type HostConfigFailedFault HostConfigFailed

func init() {
	t["HostConfigFailedFault"] = reflect.TypeOf((*HostConfigFailedFault)(nil)).Elem()
}

type HostConfigFault struct {
	VimFault
}

func init() {
	t["HostConfigFault"] = reflect.TypeOf((*HostConfigFault)(nil)).Elem()
}

type HostConfigFaultFault BaseHostConfigFault

func init() {
	t["HostConfigFaultFault"] = reflect.TypeOf((*HostConfigFaultFault)(nil)).Elem()
}

type HostConfigInfo struct {
	DynamicData

	Host                      ManagedObjectReference               `xml:"host"`
	Product                   AboutInfo                            `xml:"product"`
	DeploymentInfo            *HostDeploymentInfo                  `xml:"deploymentInfo,omitempty"`
	HyperThread               *HostHyperThreadScheduleInfo         `xml:"hyperThread,omitempty"`
	ConsoleReservation        *ServiceConsoleReservationInfo       `xml:"consoleReservation,omitempty"`
	VirtualMachineReservation *VirtualMachineMemoryReservationInfo `xml:"virtualMachineReservation,omitempty"`
	StorageDevice             *HostStorageDeviceInfo               `xml:"storageDevice,omitempty"`
	MultipathState            *HostMultipathStateInfo              `xml:"multipathState,omitempty"`
	FileSystemVolume          *HostFileSystemVolumeInfo            `xml:"fileSystemVolume,omitempty"`
	SystemFile                []string                             `xml:"systemFile,omitempty"`
	Network                   *HostNetworkInfo                     `xml:"network,omitempty"`
	Vmotion                   *HostVMotionInfo                     `xml:"vmotion,omitempty"`
	VirtualNicManagerInfo     *HostVirtualNicManagerInfo           `xml:"virtualNicManagerInfo,omitempty"`
	Capabilities              *HostNetCapabilities                 `xml:"capabilities,omitempty"`
	DatastoreCapabilities     *HostDatastoreSystemCapabilities     `xml:"datastoreCapabilities,omitempty"`
	OffloadCapabilities       *HostNetOffloadCapabilities          `xml:"offloadCapabilities,omitempty"`
	Service                   *HostServiceInfo                     `xml:"service,omitempty"`
	Firewall                  *HostFirewallInfo                    `xml:"firewall,omitempty"`
	AutoStart                 *HostAutoStartManagerConfig          `xml:"autoStart,omitempty"`
	ActiveDiagnosticPartition *HostDiagnosticPartition             `xml:"activeDiagnosticPartition,omitempty"`
	Option                    []BaseOptionValue                    `xml:"option,omitempty,typeattr"`
	OptionDef                 []OptionDef                          `xml:"optionDef,omitempty"`
	DatastorePrincipal        string                               `xml:"datastorePrincipal,omitempty"`
	LocalSwapDatastore        *ManagedObjectReference              `xml:"localSwapDatastore,omitempty"`
	SystemSwapConfiguration   *HostSystemSwapConfiguration         `xml:"systemSwapConfiguration,omitempty"`
	SystemResources           *HostSystemResourceInfo              `xml:"systemResources,omitempty"`
	DateTimeInfo              *HostDateTimeInfo                    `xml:"dateTimeInfo,omitempty"`
	Flags                     *HostFlagInfo                        `xml:"flags,omitempty"`
	AdminDisabled             *bool                                `xml:"adminDisabled"`
	LockdownMode              HostLockdownMode                     `xml:"lockdownMode,omitempty"`
	Ipmi                      *HostIpmiInfo                        `xml:"ipmi,omitempty"`
	SslThumbprintInfo         *HostSslThumbprintInfo               `xml:"sslThumbprintInfo,omitempty"`
	SslThumbprintData         []HostSslThumbprintInfo              `xml:"sslThumbprintData,omitempty"`
	Certificate               []byte                               `xml:"certificate,omitempty"`
	PciPassthruInfo           []BaseHostPciPassthruInfo            `xml:"pciPassthruInfo,omitempty,typeattr"`
	AuthenticationManagerInfo *HostAuthenticationManagerInfo       `xml:"authenticationManagerInfo,omitempty"`
	FeatureVersion            []HostFeatureVersionInfo             `xml:"featureVersion,omitempty"`
	PowerSystemCapability     *PowerSystemCapability               `xml:"powerSystemCapability,omitempty"`
	PowerSystemInfo           *PowerSystemInfo                     `xml:"powerSystemInfo,omitempty"`
	CacheConfigurationInfo    []HostCacheConfigurationInfo         `xml:"cacheConfigurationInfo,omitempty"`
	WakeOnLanCapable          *bool                                `xml:"wakeOnLanCapable"`
	FeatureCapability         []HostFeatureCapability              `xml:"featureCapability,omitempty"`
	MaskedFeatureCapability   []HostFeatureCapability              `xml:"maskedFeatureCapability,omitempty"`
	VFlashConfigInfo          *HostVFlashManagerVFlashConfigInfo   `xml:"vFlashConfigInfo,omitempty"`
	VsanHostConfig            *VsanHostConfigInfo                  `xml:"vsanHostConfig,omitempty"`
	DomainList                []string                             `xml:"domainList,omitempty"`
	ScriptCheckSum            []byte                               `xml:"scriptCheckSum,omitempty"`
	HostConfigCheckSum        []byte                               `xml:"hostConfigCheckSum,omitempty"`
	DescriptionTreeCheckSum   []byte                               `xml:"descriptionTreeCheckSum,omitempty"`
	GraphicsInfo              []HostGraphicsInfo                   `xml:"graphicsInfo,omitempty"`
	SharedPassthruGpuTypes    []string                             `xml:"sharedPassthruGpuTypes,omitempty"`
	GraphicsConfig            *HostGraphicsConfig                  `xml:"graphicsConfig,omitempty"`
	SharedGpuCapabilities     []HostSharedGpuCapabilities          `xml:"sharedGpuCapabilities,omitempty"`
	IoFilterInfo              []HostIoFilterInfo                   `xml:"ioFilterInfo,omitempty"`
	SriovDevicePool           []BaseHostSriovDevicePoolInfo        `xml:"sriovDevicePool,omitempty,typeattr"`
	AssignableHardwareBinding []HostAssignableHardwareBinding      `xml:"assignableHardwareBinding,omitempty"`
	AssignableHardwareConfig  *HostAssignableHardwareConfig        `xml:"assignableHardwareConfig,omitempty"`
}

func init() {
	t["HostConfigInfo"] = reflect.TypeOf((*HostConfigInfo)(nil)).Elem()
}

type HostConfigManager struct {
	DynamicData

	CpuScheduler              *ManagedObjectReference `xml:"cpuScheduler,omitempty"`
	DatastoreSystem           *ManagedObjectReference `xml:"datastoreSystem,omitempty"`
	MemoryManager             *ManagedObjectReference `xml:"memoryManager,omitempty"`
	StorageSystem             *ManagedObjectReference `xml:"storageSystem,omitempty"`
	NetworkSystem             *ManagedObjectReference `xml:"networkSystem,omitempty"`
	VmotionSystem             *ManagedObjectReference `xml:"vmotionSystem,omitempty"`
	VirtualNicManager         *ManagedObjectReference `xml:"virtualNicManager,omitempty"`
	ServiceSystem             *ManagedObjectReference `xml:"serviceSystem,omitempty"`
	FirewallSystem            *ManagedObjectReference `xml:"firewallSystem,omitempty"`
	AdvancedOption            *ManagedObjectReference `xml:"advancedOption,omitempty"`
	DiagnosticSystem          *ManagedObjectReference `xml:"diagnosticSystem,omitempty"`
	AutoStartManager          *ManagedObjectReference `xml:"autoStartManager,omitempty"`
	SnmpSystem                *ManagedObjectReference `xml:"snmpSystem,omitempty"`
	DateTimeSystem            *ManagedObjectReference `xml:"dateTimeSystem,omitempty"`
	PatchManager              *ManagedObjectReference `xml:"patchManager,omitempty"`
	ImageConfigManager        *ManagedObjectReference `xml:"imageConfigManager,omitempty"`
	BootDeviceSystem          *ManagedObjectReference `xml:"bootDeviceSystem,omitempty"`
	FirmwareSystem            *ManagedObjectReference `xml:"firmwareSystem,omitempty"`
	HealthStatusSystem        *ManagedObjectReference `xml:"healthStatusSystem,omitempty"`
	PciPassthruSystem         *ManagedObjectReference `xml:"pciPassthruSystem,omitempty"`
	LicenseManager            *ManagedObjectReference `xml:"licenseManager,omitempty"`
	KernelModuleSystem        *ManagedObjectReference `xml:"kernelModuleSystem,omitempty"`
	AuthenticationManager     *ManagedObjectReference `xml:"authenticationManager,omitempty"`
	PowerSystem               *ManagedObjectReference `xml:"powerSystem,omitempty"`
	CacheConfigurationManager *ManagedObjectReference `xml:"cacheConfigurationManager,omitempty"`
	EsxAgentHostManager       *ManagedObjectReference `xml:"esxAgentHostManager,omitempty"`
	IscsiManager              *ManagedObjectReference `xml:"iscsiManager,omitempty"`
	VFlashManager             *ManagedObjectReference `xml:"vFlashManager,omitempty"`
	VsanSystem                *ManagedObjectReference `xml:"vsanSystem,omitempty"`
	MessageBusProxy           *ManagedObjectReference `xml:"messageBusProxy,omitempty"`
	UserDirectory             *ManagedObjectReference `xml:"userDirectory,omitempty"`
	AccountManager            *ManagedObjectReference `xml:"accountManager,omitempty"`
	HostAccessManager         *ManagedObjectReference `xml:"hostAccessManager,omitempty"`
	GraphicsManager           *ManagedObjectReference `xml:"graphicsManager,omitempty"`
	VsanInternalSystem        *ManagedObjectReference `xml:"vsanInternalSystem,omitempty"`
	CertificateManager        *ManagedObjectReference `xml:"certificateManager,omitempty"`
	CryptoManager             *ManagedObjectReference `xml:"cryptoManager,omitempty"`
	NvdimmSystem              *ManagedObjectReference `xml:"nvdimmSystem,omitempty"`
	AssignableHardwareManager *ManagedObjectReference `xml:"assignableHardwareManager,omitempty"`
}

func init() {
	t["HostConfigManager"] = reflect.TypeOf((*HostConfigManager)(nil)).Elem()
}

type HostConfigSpec struct {
	DynamicData

	NasDatastore             []HostNasVolumeConfig                   `xml:"nasDatastore,omitempty"`
	Network                  *HostNetworkConfig                      `xml:"network,omitempty"`
	NicTypeSelection         []HostVirtualNicManagerNicTypeSelection `xml:"nicTypeSelection,omitempty"`
	Service                  []HostServiceConfig                     `xml:"service,omitempty"`
	Firewall                 *HostFirewallConfig                     `xml:"firewall,omitempty"`
	Option                   []BaseOptionValue                       `xml:"option,omitempty,typeattr"`
	DatastorePrincipal       string                                  `xml:"datastorePrincipal,omitempty"`
	DatastorePrincipalPasswd string                                  `xml:"datastorePrincipalPasswd,omitempty"`
	Datetime                 *HostDateTimeConfig                     `xml:"datetime,omitempty"`
	StorageDevice            *HostStorageDeviceInfo                  `xml:"storageDevice,omitempty"`
	License                  *HostLicenseSpec                        `xml:"license,omitempty"`
	Security                 *HostSecuritySpec                       `xml:"security,omitempty"`
	UserAccount              []BaseHostAccountSpec                   `xml:"userAccount,omitempty,typeattr"`
	UsergroupAccount         []BaseHostAccountSpec                   `xml:"usergroupAccount,omitempty,typeattr"`
	Memory                   *HostMemorySpec                         `xml:"memory,omitempty"`
	ActiveDirectory          []HostActiveDirectory                   `xml:"activeDirectory,omitempty"`
	GenericConfig            []KeyAnyValue                           `xml:"genericConfig,omitempty"`
	GraphicsConfig           *HostGraphicsConfig                     `xml:"graphicsConfig,omitempty"`
	AssignableHardwareConfig *HostAssignableHardwareConfig           `xml:"assignableHardwareConfig,omitempty"`
}

func init() {
	t["HostConfigSpec"] = reflect.TypeOf((*HostConfigSpec)(nil)).Elem()
}

type HostConfigSummary struct {
	DynamicData

	Name                  string                   `xml:"name"`
	Port                  int32                    `xml:"port"`
	SslThumbprint         string                   `xml:"sslThumbprint,omitempty"`
	Product               *AboutInfo               `xml:"product,omitempty"`
	VmotionEnabled        bool                     `xml:"vmotionEnabled"`
	FaultToleranceEnabled *bool                    `xml:"faultToleranceEnabled"`
	FeatureVersion        []HostFeatureVersionInfo `xml:"featureVersion,omitempty"`
	AgentVmDatastore      *ManagedObjectReference  `xml:"agentVmDatastore,omitempty"`
	AgentVmNetwork        *ManagedObjectReference  `xml:"agentVmNetwork,omitempty"`
}

func init() {
	t["HostConfigSummary"] = reflect.TypeOf((*HostConfigSummary)(nil)).Elem()
}

type HostConfigVFlashCache HostConfigVFlashCacheRequestType

func init() {
	t["HostConfigVFlashCache"] = reflect.TypeOf((*HostConfigVFlashCache)(nil)).Elem()
}

type HostConfigVFlashCacheRequestType struct {
	This ManagedObjectReference                 `xml:"_this"`
	Spec HostVFlashManagerVFlashCacheConfigSpec `xml:"spec"`
}

func init() {
	t["HostConfigVFlashCacheRequestType"] = reflect.TypeOf((*HostConfigVFlashCacheRequestType)(nil)).Elem()
}

type HostConfigVFlashCacheResponse struct {
}

type HostConfigureVFlashResource HostConfigureVFlashResourceRequestType

func init() {
	t["HostConfigureVFlashResource"] = reflect.TypeOf((*HostConfigureVFlashResource)(nil)).Elem()
}

type HostConfigureVFlashResourceRequestType struct {
	This ManagedObjectReference                    `xml:"_this"`
	Spec HostVFlashManagerVFlashResourceConfigSpec `xml:"spec"`
}

func init() {
	t["HostConfigureVFlashResourceRequestType"] = reflect.TypeOf((*HostConfigureVFlashResourceRequestType)(nil)).Elem()
}

type HostConfigureVFlashResourceResponse struct {
}

type HostConnectFault struct {
	VimFault
}

func init() {
	t["HostConnectFault"] = reflect.TypeOf((*HostConnectFault)(nil)).Elem()
}

type HostConnectFaultFault BaseHostConnectFault

func init() {
	t["HostConnectFaultFault"] = reflect.TypeOf((*HostConnectFaultFault)(nil)).Elem()
}

type HostConnectInfo struct {
	DynamicData

	ServerIp               string                           `xml:"serverIp,omitempty"`
	InDasCluster           *bool                            `xml:"inDasCluster"`
	Host                   HostListSummary                  `xml:"host"`
	Vm                     []VirtualMachineSummary          `xml:"vm,omitempty"`
	VimAccountNameRequired *bool                            `xml:"vimAccountNameRequired"`
	ClusterSupported       *bool                            `xml:"clusterSupported"`
	Network                []BaseHostConnectInfoNetworkInfo `xml:"network,omitempty,typeattr"`
	Datastore              []BaseHostDatastoreConnectInfo   `xml:"datastore,omitempty,typeattr"`
	License                *HostLicenseConnectInfo          `xml:"license,omitempty"`
	Capability             *HostCapability                  `xml:"capability,omitempty"`
}

func init() {
	t["HostConnectInfo"] = reflect.TypeOf((*HostConnectInfo)(nil)).Elem()
}

type HostConnectInfoNetworkInfo struct {
	DynamicData

	Summary BaseNetworkSummary `xml:"summary,typeattr"`
}

func init() {
	t["HostConnectInfoNetworkInfo"] = reflect.TypeOf((*HostConnectInfoNetworkInfo)(nil)).Elem()
}

type HostConnectSpec struct {
	DynamicData

	HostName           string                  `xml:"hostName,omitempty"`
	Port               int32                   `xml:"port,omitempty"`
	SslThumbprint      string                  `xml:"sslThumbprint,omitempty"`
	UserName           string                  `xml:"userName,omitempty"`
	Password           string                  `xml:"password,omitempty"`
	VmFolder           *ManagedObjectReference `xml:"vmFolder,omitempty"`
	Force              bool                    `xml:"force"`
	VimAccountName     string                  `xml:"vimAccountName,omitempty"`
	VimAccountPassword string                  `xml:"vimAccountPassword,omitempty"`
	ManagementIp       string                  `xml:"managementIp,omitempty"`
	LockdownMode       HostLockdownMode        `xml:"lockdownMode,omitempty"`
	HostGateway        *HostGatewaySpec        `xml:"hostGateway,omitempty"`
}

func init() {
	t["HostConnectSpec"] = reflect.TypeOf((*HostConnectSpec)(nil)).Elem()
}

type HostConnectedEvent struct {
	HostEvent
}

func init() {
	t["HostConnectedEvent"] = reflect.TypeOf((*HostConnectedEvent)(nil)).Elem()
}

type HostConnectionLostEvent struct {
	HostEvent
}

func init() {
	t["HostConnectionLostEvent"] = reflect.TypeOf((*HostConnectionLostEvent)(nil)).Elem()
}

type HostCpuIdInfo struct {
	DynamicData

	Level  int32  `xml:"level"`
	Vendor string `xml:"vendor,omitempty"`
	Eax    string `xml:"eax,omitempty"`
	Ebx    string `xml:"ebx,omitempty"`
	Ecx    string `xml:"ecx,omitempty"`
	Edx    string `xml:"edx,omitempty"`
}

func init() {
	t["HostCpuIdInfo"] = reflect.TypeOf((*HostCpuIdInfo)(nil)).Elem()
}

type HostCpuInfo struct {
	DynamicData

	NumCpuPackages int16 `xml:"numCpuPackages"`
	NumCpuCores    int16 `xml:"numCpuCores"`
	NumCpuThreads  int16 `xml:"numCpuThreads"`
	Hz             int64 `xml:"hz"`
}

func init() {
	t["HostCpuInfo"] = reflect.TypeOf((*HostCpuInfo)(nil)).Elem()
}

type HostCpuPackage struct {
	DynamicData

	Index       int16           `xml:"index"`
	Vendor      string          `xml:"vendor"`
	Hz          int64           `xml:"hz"`
	BusHz       int64           `xml:"busHz"`
	Description string          `xml:"description"`
	ThreadId    []int16         `xml:"threadId"`
	CpuFeature  []HostCpuIdInfo `xml:"cpuFeature,omitempty"`
}

func init() {
	t["HostCpuPackage"] = reflect.TypeOf((*HostCpuPackage)(nil)).Elem()
}

type HostCpuPowerManagementInfo struct {
	DynamicData

	CurrentPolicy   string `xml:"currentPolicy,omitempty"`
	HardwareSupport string `xml:"hardwareSupport,omitempty"`
}

func init() {
	t["HostCpuPowerManagementInfo"] = reflect.TypeOf((*HostCpuPowerManagementInfo)(nil)).Elem()
}

type HostCreateDiskRequestType struct {
	This ManagedObjectReference `xml:"_this"`
	Spec VslmCreateSpec         `xml:"spec"`
}

func init() {
	t["HostCreateDiskRequestType"] = reflect.TypeOf((*HostCreateDiskRequestType)(nil)).Elem()
}

type HostCreateDisk_Task HostCreateDiskRequestType

func init() {
	t["HostCreateDisk_Task"] = reflect.TypeOf((*HostCreateDisk_Task)(nil)).Elem()
}

type HostCreateDisk_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval"`
}

type HostDasDisabledEvent struct {
	HostEvent
}

func init() {
	t["HostDasDisabledEvent"] = reflect.TypeOf((*HostDasDisabledEvent)(nil)).Elem()
}

type HostDasDisablingEvent struct {
	HostEvent
}

func init() {
	t["HostDasDisablingEvent"] = reflect.TypeOf((*HostDasDisablingEvent)(nil)).Elem()
}

type HostDasEnabledEvent struct {
	HostEvent
}

func init() {
	t["HostDasEnabledEvent"] = reflect.TypeOf((*HostDasEnabledEvent)(nil)).Elem()
}

type HostDasEnablingEvent struct {
	HostEvent
}

func init() {
	t["HostDasEnablingEvent"] = reflect.TypeOf((*HostDasEnablingEvent)(nil)).Elem()
}

type HostDasErrorEvent struct {
	HostEvent

	Message string `xml:"message,omitempty"`
	Reason  string `xml:"reason,omitempty"`
}

func init() {
	t["HostDasErrorEvent"] = reflect.TypeOf((*HostDasErrorEvent)(nil)).Elem()
}

type HostDasEvent struct {
	HostEvent
}

func init() {
	t["HostDasEvent"] = reflect.TypeOf((*HostDasEvent)(nil)).Elem()
}

type HostDasOkEvent struct {
	HostEvent
}

func init() {
	t["HostDasOkEvent"] = reflect.TypeOf((*HostDasOkEvent)(nil)).Elem()
}

type HostDataTransportConnectionInfo struct {
	DynamicData

	StaticMemoryConsumed int64 `xml:"staticMemoryConsumed"`
}

func init() {
	t["HostDataTransportConnectionInfo"] = reflect.TypeOf((*HostDataTransportConnectionInfo)(nil)).Elem()
}

type HostDatastoreBrowserSearchResults struct {
	DynamicData

	Datastore  *ManagedObjectReference `xml:"datastore,omitempty"`
	FolderPath string                  `xml:"folderPath,omitempty"`
	File       []BaseFileInfo          `xml:"file,omitempty,typeattr"`
}

func init() {
	t["HostDatastoreBrowserSearchResults"] = reflect.TypeOf((*HostDatastoreBrowserSearchResults)(nil)).Elem()
}

type HostDatastoreBrowserSearchSpec struct {
	DynamicData

	Query                 []BaseFileQuery `xml:"query,omitempty,typeattr"`
	Details               *FileQueryFlags `xml:"details,omitempty"`
	SearchCaseInsensitive *bool           `xml:"searchCaseInsensitive"`
	MatchPattern          []string        `xml:"matchPattern,omitempty"`
	SortFoldersFirst      *bool           `xml:"sortFoldersFirst"`
}

func init() {
	t["HostDatastoreBrowserSearchSpec"] = reflect.TypeOf((*HostDatastoreBrowserSearchSpec)(nil)).Elem()
}

type HostDatastoreConnectInfo struct {
	DynamicData

	Summary DatastoreSummary `xml:"summary"`
}

func init() {
	t["HostDatastoreConnectInfo"] = reflect.TypeOf((*HostDatastoreConnectInfo)(nil)).Elem()
}

type HostDatastoreExistsConnectInfo struct {
	HostDatastoreConnectInfo

	NewDatastoreName string `xml:"newDatastoreName"`
}

func init() {
	t["HostDatastoreExistsConnectInfo"] = reflect.TypeOf((*HostDatastoreExistsConnectInfo)(nil)).Elem()
}

type HostDatastoreNameConflictConnectInfo struct {
	HostDatastoreConnectInfo

	NewDatastoreName string `xml:"newDatastoreName"`
}

func init() {
	t["HostDatastoreNameConflictConnectInfo"] = reflect.TypeOf((*HostDatastoreNameConflictConnectInfo)(nil)).Elem()
}

type HostDatastoreSystemCapabilities struct {
	DynamicData

	NfsMountCreationRequired     bool  `xml:"nfsMountCreationRequired"`
	NfsMountCreationSupported    bool  `xml:"nfsMountCreationSupported"`
	LocalDatastoreSupported      bool  `xml:"localDatastoreSupported"`
	VmfsExtentExpansionSupported *bool `xml:"vmfsExtentExpansionSupported"`
}

func init() {
	t["HostDatastoreSystemCapabilities"] = reflect.TypeOf((*HostDatastoreSystemCapabilities)(nil)).Elem()
}

type HostDatastoreSystemDatastoreResult struct {
	DynamicData

	Key   ManagedObjectReference `xml:"key"`
	Fault *LocalizedMethodFault  `xml:"fault,omitempty"`
}

func init() {
	t["HostDatastoreSystemDatastoreResult"] = reflect.TypeOf((*HostDatastoreSystemDatastoreResult)(nil)).Elem()
}

type HostDatastoreSystemVvolDatastoreSpec struct {
	DynamicData

	Name string `xml:"name"`
	ScId string `xml:"scId"`
}

func init() {
	t["HostDatastoreSystemVvolDatastoreSpec"] = reflect.TypeOf((*HostDatastoreSystemVvolDatastoreSpec)(nil)).Elem()
}

type HostDateTimeConfig struct {
	DynamicData

	TimeZone               string         `xml:"timeZone,omitempty"`
	NtpConfig              *HostNtpConfig `xml:"ntpConfig,omitempty"`
	PtpConfig              *HostPtpConfig `xml:"ptpConfig,omitempty"`
	Protocol               string         `xml:"protocol,omitempty"`
	Enabled                *bool          `xml:"enabled"`
	DisableEvents          *bool          `xml:"disableEvents"`
	DisableFallback        *bool          `xml:"disableFallback"`
	ResetToFactoryDefaults *bool          `xml:"resetToFactoryDefaults"`
}

func init() {
	t["HostDateTimeConfig"] = reflect.TypeOf((*HostDateTimeConfig)(nil)).Elem()
}

type HostDateTimeInfo struct {
	DynamicData

	TimeZone            HostDateTimeSystemTimeZone `xml:"timeZone"`
	SystemClockProtocol string                     `xml:"systemClockProtocol,omitempty"`
	NtpConfig           *HostNtpConfig             `xml:"ntpConfig,omitempty"`
	PtpConfig           *HostPtpConfig             `xml:"ptpConfig,omitempty"`
	Enabled             *bool                      `xml:"enabled"`
	DisableEvents       *bool                      `xml:"disableEvents"`
	DisableFallback     *bool                      `xml:"disableFallback"`
	InFallbackState     *bool                      `xml:"inFallbackState"`
	ServiceSync         *bool                      `xml:"serviceSync"`
	LastSyncTime        *time.Time                 `xml:"lastSyncTime"`
	RemoteNtpServer     string                     `xml:"remoteNtpServer,omitempty"`
	NtpRunTime          int64                      `xml:"ntpRunTime,omitempty"`
	PtpRunTime          int64                      `xml:"ptpRunTime,omitempty"`
	NtpDuration         string                     `xml:"ntpDuration,omitempty"`
	PtpDuration         string                     `xml:"ptpDuration,omitempty"`
}

func init() {
	t["HostDateTimeInfo"] = reflect.TypeOf((*HostDateTimeInfo)(nil)).Elem()
}

type HostDateTimeSystemServiceTestResult struct {
	DynamicData

	WorkingNormally bool     `xml:"workingNormally"`
	Report          []string `xml:"report,omitempty"`
}

func init() {
	t["HostDateTimeSystemServiceTestResult"] = reflect.TypeOf((*HostDateTimeSystemServiceTestResult)(nil)).Elem()
}

type HostDateTimeSystemTimeZone struct {
	DynamicData

	Key         string `xml:"key"`
	Name        string `xml:"name"`
	Description string `xml:"description"`
	GmtOffset   int32  `xml:"gmtOffset"`
}

func init() {
	t["HostDateTimeSystemTimeZone"] = reflect.TypeOf((*HostDateTimeSystemTimeZone)(nil)).Elem()
}

type HostDeleteVStorageObjectExRequestType struct {
	This      ManagedObjectReference `xml:"_this"`
	Id        ID                     `xml:"id"`
	Datastore ManagedObjectReference `xml:"datastore"`
}

func init() {
	t["HostDeleteVStorageObjectExRequestType"] = reflect.TypeOf((*HostDeleteVStorageObjectExRequestType)(nil)).Elem()
}

type HostDeleteVStorageObjectEx_Task HostDeleteVStorageObjectExRequestType

func init() {
	t["HostDeleteVStorageObjectEx_Task"] = reflect.TypeOf((*HostDeleteVStorageObjectEx_Task)(nil)).Elem()
}

type HostDeleteVStorageObjectEx_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval"`
}

type HostDeleteVStorageObjectRequestType struct {
	This      ManagedObjectReference `xml:"_this"`
	Id        ID                     `xml:"id"`
	Datastore ManagedObjectReference `xml:"datastore"`
}

func init() {
	t["HostDeleteVStorageObjectRequestType"] = reflect.TypeOf((*HostDeleteVStorageObjectRequestType)(nil)).Elem()
}

type HostDeleteVStorageObject_Task HostDeleteVStorageObjectRequestType

func init() {
	t["HostDeleteVStorageObject_Task"] = reflect.TypeOf((*HostDeleteVStorageObject_Task)(nil)).Elem()
}

type HostDeleteVStorageObject_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval"`
}

type HostDeploymentInfo struct {
	DynamicData

	BootedFromStatelessCache *bool `xml:"bootedFromStatelessCache"`
}

func init() {
	t["HostDeploymentInfo"] = reflect.TypeOf((*HostDeploymentInfo)(nil)).Elem()
}

type HostDevice struct {
	DynamicData

	DeviceName string `xml:"deviceName"`
	DeviceType string `xml:"deviceType"`
}

func init() {
	t["HostDevice"] = reflect.TypeOf((*HostDevice)(nil)).Elem()
}

type HostDhcpService struct {
	DynamicData

	Key  string              `xml:"key"`
	Spec HostDhcpServiceSpec `xml:"spec"`
}

func init() {
	t["HostDhcpService"] = reflect.TypeOf((*HostDhcpService)(nil)).Elem()
}

type HostDhcpServiceConfig struct {
	DynamicData

	ChangeOperation string              `xml:"changeOperation,omitempty"`
	Key             string              `xml:"key"`
	Spec            HostDhcpServiceSpec `xml:"spec"`
}

func init() {
	t["HostDhcpServiceConfig"] = reflect.TypeOf((*HostDhcpServiceConfig)(nil)).Elem()
}

type HostDhcpServiceSpec struct {
	DynamicData

	VirtualSwitch        string `xml:"virtualSwitch"`
	DefaultLeaseDuration int32  `xml:"defaultLeaseDuration"`
	LeaseBeginIp         string `xml:"leaseBeginIp"`
	LeaseEndIp           string `xml:"leaseEndIp"`
	MaxLeaseDuration     int32  `xml:"maxLeaseDuration"`
	UnlimitedLease       bool   `xml:"unlimitedLease"`
	IpSubnetAddr         string `xml:"ipSubnetAddr"`
	IpSubnetMask         string `xml:"ipSubnetMask"`
}

func init() {
	t["HostDhcpServiceSpec"] = reflect.TypeOf((*HostDhcpServiceSpec)(nil)).Elem()
}

type HostDiagnosticPartition struct {
	DynamicData

	StorageType    string                `xml:"storageType"`
	DiagnosticType string                `xml:"diagnosticType"`
	Slots          int32                 `xml:"slots"`
	Id             HostScsiDiskPartition `xml:"id"`
}

func init() {
	t["HostDiagnosticPartition"] = reflect.TypeOf((*HostDiagnosticPartition)(nil)).Elem()
}

type HostDiagnosticPartitionCreateDescription struct {
	DynamicData

	Layout   HostDiskPartitionLayout           `xml:"layout"`
	DiskUuid string                            `xml:"diskUuid"`
	Spec     HostDiagnosticPartitionCreateSpec `xml:"spec"`
}

func init() {
	t["HostDiagnosticPartitionCreateDescription"] = reflect.TypeOf((*HostDiagnosticPartitionCreateDescription)(nil)).Elem()
}

type HostDiagnosticPartitionCreateOption struct {
	DynamicData

	StorageType    string       `xml:"storageType"`
	DiagnosticType string       `xml:"diagnosticType"`
	Disk           HostScsiDisk `xml:"disk"`
}

func init() {
	t["HostDiagnosticPartitionCreateOption"] = reflect.TypeOf((*HostDiagnosticPartitionCreateOption)(nil)).Elem()
}

type HostDiagnosticPartitionCreateSpec struct {
	DynamicData

	StorageType    string                `xml:"storageType"`
	DiagnosticType string                `xml:"diagnosticType"`
	Id             HostScsiDiskPartition `xml:"id"`
	Partition      HostDiskPartitionSpec `xml:"partition"`
	Active         *bool                 `xml:"active"`
}

func init() {
	t["HostDiagnosticPartitionCreateSpec"] = reflect.TypeOf((*HostDiagnosticPartitionCreateSpec)(nil)).Elem()
}

type HostDigestInfo struct {
	DynamicData

	DigestMethod string `xml:"digestMethod"`
	DigestValue  []byte `xml:"digestValue"`
	ObjectName   string `xml:"objectName,omitempty"`
}

func init() {
	t["HostDigestInfo"] = reflect.TypeOf((*HostDigestInfo)(nil)).Elem()
}

type HostDirectoryStoreInfo struct {
	HostAuthenticationStoreInfo
}

func init() {
	t["HostDirectoryStoreInfo"] = reflect.TypeOf((*HostDirectoryStoreInfo)(nil)).Elem()
}

type HostDisconnectedEvent struct {
	HostEvent

	Reason string `xml:"reason,omitempty"`
}

func init() {
	t["HostDisconnectedEvent"] = reflect.TypeOf((*HostDisconnectedEvent)(nil)).Elem()
}

type HostDiskConfigurationResult struct {
	DynamicData

	DevicePath string                `xml:"devicePath,omitempty"`
	Success    *bool                 `xml:"success"`
	Fault      *LocalizedMethodFault `xml:"fault,omitempty"`
}

func init() {
	t["HostDiskConfigurationResult"] = reflect.TypeOf((*HostDiskConfigurationResult)(nil)).Elem()
}

type HostDiskDimensions struct {
	DynamicData
}

func init() {
	t["HostDiskDimensions"] = reflect.TypeOf((*HostDiskDimensions)(nil)).Elem()
}

type HostDiskDimensionsChs struct {
	DynamicData

	Cylinder int64 `xml:"cylinder"`
	Head     int32 `xml:"head"`
	Sector   int32 `xml:"sector"`
}

func init() {
	t["HostDiskDimensionsChs"] = reflect.TypeOf((*HostDiskDimensionsChs)(nil)).Elem()
}

type HostDiskDimensionsLba struct {
	DynamicData

	BlockSize int32 `xml:"blockSize"`
	Block     int64 `xml:"block"`
}

func init() {
	t["HostDiskDimensionsLba"] = reflect.TypeOf((*HostDiskDimensionsLba)(nil)).Elem()
}

type HostDiskMappingInfo struct {
	DynamicData

	PhysicalPartition *HostDiskMappingPartitionInfo `xml:"physicalPartition,omitempty"`
	Name              string                        `xml:"name"`
	Exclusive         *bool                         `xml:"exclusive"`
}

func init() {
	t["HostDiskMappingInfo"] = reflect.TypeOf((*HostDiskMappingInfo)(nil)).Elem()
}

type HostDiskMappingOption struct {
	DynamicData

	PhysicalPartition []HostDiskMappingPartitionOption `xml:"physicalPartition,omitempty"`
	Name              string                           `xml:"name"`
}

func init() {
	t["HostDiskMappingOption"] = reflect.TypeOf((*HostDiskMappingOption)(nil)).Elem()
}

type HostDiskMappingPartitionInfo struct {
	DynamicData

	Name         string `xml:"name"`
	FileSystem   string `xml:"fileSystem"`
	CapacityInKb int64  `xml:"capacityInKb"`
}

func init() {
	t["HostDiskMappingPartitionInfo"] = reflect.TypeOf((*HostDiskMappingPartitionInfo)(nil)).Elem()
}

type HostDiskMappingPartitionOption struct {
	DynamicData

	Name         string `xml:"name"`
	FileSystem   string `xml:"fileSystem"`
	CapacityInKb int64  `xml:"capacityInKb"`
}

func init() {
	t["HostDiskMappingPartitionOption"] = reflect.TypeOf((*HostDiskMappingPartitionOption)(nil)).Elem()
}

type HostDiskPartitionAttributes struct {
	DynamicData

	Partition          int32  `xml:"partition"`
	StartSector        int64  `xml:"startSector"`
	EndSector          int64  `xml:"endSector"`
	Type               string `xml:"type"`
	Guid               string `xml:"guid,omitempty"`
	Logical            bool   `xml:"logical"`
	Attributes         byte   `xml:"attributes"`
	PartitionAlignment int64  `xml:"partitionAlignment,omitempty"`
}

func init() {
	t["HostDiskPartitionAttributes"] = reflect.TypeOf((*HostDiskPartitionAttributes)(nil)).Elem()
}

type HostDiskPartitionBlockRange struct {
	DynamicData

	Partition int32                 `xml:"partition,omitempty"`
	Type      string                `xml:"type"`
	Start     HostDiskDimensionsLba `xml:"start"`
	End       HostDiskDimensionsLba `xml:"end"`
}

func init() {
	t["HostDiskPartitionBlockRange"] = reflect.TypeOf((*HostDiskPartitionBlockRange)(nil)).Elem()
}

type HostDiskPartitionInfo struct {
	DynamicData

	DeviceName string                  `xml:"deviceName"`
	Spec       HostDiskPartitionSpec   `xml:"spec"`
	Layout     HostDiskPartitionLayout `xml:"layout"`
}

func init() {
	t["HostDiskPartitionInfo"] = reflect.TypeOf((*HostDiskPartitionInfo)(nil)).Elem()
}

type HostDiskPartitionLayout struct {
	DynamicData

	Total     *HostDiskDimensionsLba        `xml:"total,omitempty"`
	Partition []HostDiskPartitionBlockRange `xml:"partition"`
}

func init() {
	t["HostDiskPartitionLayout"] = reflect.TypeOf((*HostDiskPartitionLayout)(nil)).Elem()
}

type HostDiskPartitionSpec struct {
	DynamicData

	PartitionFormat string                        `xml:"partitionFormat,omitempty"`
	Chs             *HostDiskDimensionsChs        `xml:"chs,omitempty"`
	TotalSectors    int64                         `xml:"totalSectors,omitempty"`
	Partition       []HostDiskPartitionAttributes `xml:"partition,omitempty"`
}

func init() {
	t["HostDiskPartitionSpec"] = reflect.TypeOf((*HostDiskPartitionSpec)(nil)).Elem()
}

type HostDnsConfig struct {
	DynamicData

	Dhcp                 bool     `xml:"dhcp"`
	VirtualNicDevice     string   `xml:"virtualNicDevice,omitempty"`
	Ipv6VirtualNicDevice string   `xml:"ipv6VirtualNicDevice,omitempty"`
	HostName             string   `xml:"hostName"`
	DomainName           string   `xml:"domainName"`
	Address              []string `xml:"address,omitempty"`
	SearchDomain         []string `xml:"searchDomain,omitempty"`
}

func init() {
	t["HostDnsConfig"] = reflect.TypeOf((*HostDnsConfig)(nil)).Elem()
}

type HostDnsConfigSpec struct {
	HostDnsConfig

	VirtualNicConnection   *HostVirtualNicConnection `xml:"virtualNicConnection,omitempty"`
	VirtualNicConnectionV6 *HostVirtualNicConnection `xml:"virtualNicConnectionV6,omitempty"`
}

func init() {
	t["HostDnsConfigSpec"] = reflect.TypeOf((*HostDnsConfigSpec)(nil)).Elem()
}

type HostEnableAdminFailedEvent struct {
	HostEvent

	Permissions []Permission `xml:"permissions"`
}

func init() {
	t["HostEnableAdminFailedEvent"] = reflect.TypeOf((*HostEnableAdminFailedEvent)(nil)).Elem()
}

type HostEnterMaintenanceResult struct {
	DynamicData

	VmFaults   []FaultsByVM   `xml:"vmFaults,omitempty"`
	HostFaults []FaultsByHost `xml:"hostFaults,omitempty"`
}

func init() {
	t["HostEnterMaintenanceResult"] = reflect.TypeOf((*HostEnterMaintenanceResult)(nil)).Elem()
}

type HostEsxAgentHostManagerConfigInfo struct {
	DynamicData

	AgentVmDatastore *ManagedObjectReference `xml:"agentVmDatastore,omitempty"`
	AgentVmNetwork   *ManagedObjectReference `xml:"agentVmNetwork,omitempty"`
}

func init() {
	t["HostEsxAgentHostManagerConfigInfo"] = reflect.TypeOf((*HostEsxAgentHostManagerConfigInfo)(nil)).Elem()
}

type HostEvent struct {
	Event
}

func init() {
	t["HostEvent"] = reflect.TypeOf((*HostEvent)(nil)).Elem()
}

type HostEventArgument struct {
	EntityEventArgument

	Host ManagedObjectReference `xml:"host"`
}

func init() {
	t["HostEventArgument"] = reflect.TypeOf((*HostEventArgument)(nil)).Elem()
}

type HostExtendDiskRequestType struct {
	This            ManagedObjectReference `xml:"_this"`
	Id              ID                     `xml:"id"`
	Datastore       ManagedObjectReference `xml:"datastore"`
	NewCapacityInMB int64                  `xml:"newCapacityInMB"`
}

func init() {
	t["HostExtendDiskRequestType"] = reflect.TypeOf((*HostExtendDiskRequestType)(nil)).Elem()
}

type HostExtendDisk_Task HostExtendDiskRequestType

func init() {
	t["HostExtendDisk_Task"] = reflect.TypeOf((*HostExtendDisk_Task)(nil)).Elem()
}

type HostExtendDisk_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval"`
}

type HostExtraNetworksEvent struct {
	HostDasEvent

	Ips string `xml:"ips,omitempty"`
}

func init() {
	t["HostExtraNetworksEvent"] = reflect.TypeOf((*HostExtraNetworksEvent)(nil)).Elem()
}

type HostFaultToleranceManagerComponentHealthInfo struct {
	DynamicData

	IsStorageHealthy bool `xml:"isStorageHealthy"`
	IsNetworkHealthy bool `xml:"isNetworkHealthy"`
}

func init() {
	t["HostFaultToleranceManagerComponentHealthInfo"] = reflect.TypeOf((*HostFaultToleranceManagerComponentHealthInfo)(nil)).Elem()
}

type HostFeatureCapability struct {
	DynamicData

	Key         string `xml:"key"`
	FeatureName string `xml:"featureName"`
	Value       string `xml:"value"`
}

func init() {
	t["HostFeatureCapability"] = reflect.TypeOf((*HostFeatureCapability)(nil)).Elem()
}

type HostFeatureMask struct {
	DynamicData

	Key         string `xml:"key"`
	FeatureName string `xml:"featureName"`
	Value       string `xml:"value"`
}

func init() {
	t["HostFeatureMask"] = reflect.TypeOf((*HostFeatureMask)(nil)).Elem()
}

type HostFeatureVersionInfo struct {
	DynamicData

	Key   string `xml:"key"`
	Value string `xml:"value"`
}

func init() {
	t["HostFeatureVersionInfo"] = reflect.TypeOf((*HostFeatureVersionInfo)(nil)).Elem()
}

type HostFibreChannelHba struct {
	HostHostBusAdapter

	PortWorldWideName int64                `xml:"portWorldWideName"`
	NodeWorldWideName int64                `xml:"nodeWorldWideName"`
	PortType          FibreChannelPortType `xml:"portType"`
	Speed             int64                `xml:"speed"`
}

func init() {
	t["HostFibreChannelHba"] = reflect.TypeOf((*HostFibreChannelHba)(nil)).Elem()
}

type HostFibreChannelOverEthernetHba struct {
	HostFibreChannelHba

	UnderlyingNic    string                                  `xml:"underlyingNic"`
	LinkInfo         HostFibreChannelOverEthernetHbaLinkInfo `xml:"linkInfo"`
	IsSoftwareFcoe   bool                                    `xml:"isSoftwareFcoe"`
	MarkedForRemoval bool                                    `xml:"markedForRemoval"`
}

func init() {
	t["HostFibreChannelOverEthernetHba"] = reflect.TypeOf((*HostFibreChannelOverEthernetHba)(nil)).Elem()
}

type HostFibreChannelOverEthernetHbaLinkInfo struct {
	DynamicData

	VnportMac string `xml:"vnportMac"`
	FcfMac    string `xml:"fcfMac"`
	VlanId    int32  `xml:"vlanId"`
}

func init() {
	t["HostFibreChannelOverEthernetHbaLinkInfo"] = reflect.TypeOf((*HostFibreChannelOverEthernetHbaLinkInfo)(nil)).Elem()
}

type HostFibreChannelOverEthernetTargetTransport struct {
	HostFibreChannelTargetTransport

	VnportMac string `xml:"vnportMac"`
	FcfMac    string `xml:"fcfMac"`
	VlanId    int32  `xml:"vlanId"`
}

func init() {
	t["HostFibreChannelOverEthernetTargetTransport"] = reflect.TypeOf((*HostFibreChannelOverEthernetTargetTransport)(nil)).Elem()
}

type HostFibreChannelTargetTransport struct {
	HostTargetTransport

	PortWorldWideName int64 `xml:"portWorldWideName"`
	NodeWorldWideName int64 `xml:"nodeWorldWideName"`
}

func init() {
	t["HostFibreChannelTargetTransport"] = reflect.TypeOf((*HostFibreChannelTargetTransport)(nil)).Elem()
}

type HostFileAccess struct {
	DynamicData

	Who  string `xml:"who"`
	What string `xml:"what"`
}

func init() {
	t["HostFileAccess"] = reflect.TypeOf((*HostFileAccess)(nil)).Elem()
}

type HostFileSystemMountInfo struct {
	DynamicData

	MountInfo       HostMountInfo            `xml:"mountInfo"`
	Volume          BaseHostFileSystemVolume `xml:"volume,typeattr"`
	VStorageSupport string                   `xml:"vStorageSupport,omitempty"`
}

func init() {
	t["HostFileSystemMountInfo"] = reflect.TypeOf((*HostFileSystemMountInfo)(nil)).Elem()
}

type HostFileSystemVolume struct {
	DynamicData

	Type     string `xml:"type"`
	Name     string `xml:"name"`
	Capacity int64  `xml:"capacity"`
}

func init() {
	t["HostFileSystemVolume"] = reflect.TypeOf((*HostFileSystemVolume)(nil)).Elem()
}

type HostFileSystemVolumeInfo struct {
	DynamicData

	VolumeTypeList []string                  `xml:"volumeTypeList,omitempty"`
	MountInfo      []HostFileSystemMountInfo `xml:"mountInfo,omitempty"`
}

func init() {
	t["HostFileSystemVolumeInfo"] = reflect.TypeOf((*HostFileSystemVolumeInfo)(nil)).Elem()
}

type HostFirewallConfig struct {
	DynamicData

	Rule                  []HostFirewallConfigRuleSetConfig `xml:"rule,omitempty"`
	DefaultBlockingPolicy HostFirewallDefaultPolicy         `xml:"defaultBlockingPolicy"`
}

func init() {
	t["HostFirewallConfig"] = reflect.TypeOf((*HostFirewallConfig)(nil)).Elem()
}

type HostFirewallConfigRuleSetConfig struct {
	DynamicData

	RulesetId    string                     `xml:"rulesetId"`
	Enabled      bool                       `xml:"enabled"`
	AllowedHosts *HostFirewallRulesetIpList `xml:"allowedHosts,omitempty"`
}

func init() {
	t["HostFirewallConfigRuleSetConfig"] = reflect.TypeOf((*HostFirewallConfigRuleSetConfig)(nil)).Elem()
}

type HostFirewallDefaultPolicy struct {
	DynamicData

	IncomingBlocked *bool `xml:"incomingBlocked"`
	OutgoingBlocked *bool `xml:"outgoingBlocked"`
}

func init() {
	t["HostFirewallDefaultPolicy"] = reflect.TypeOf((*HostFirewallDefaultPolicy)(nil)).Elem()
}

type HostFirewallInfo struct {
	DynamicData

	DefaultPolicy HostFirewallDefaultPolicy `xml:"defaultPolicy"`
	Ruleset       []HostFirewallRuleset     `xml:"ruleset,omitempty"`
}

func init() {
	t["HostFirewallInfo"] = reflect.TypeOf((*HostFirewallInfo)(nil)).Elem()
}

type HostFirewallRule struct {
	DynamicData

	Port      int32                     `xml:"port"`
	EndPort   int32                     `xml:"endPort,omitempty"`
	Direction HostFirewallRuleDirection `xml:"direction"`
	PortType  HostFirewallRulePortType  `xml:"portType,omitempty"`
	Protocol  string                    `xml:"protocol"`
}

func init() {
	t["HostFirewallRule"] = reflect.TypeOf((*HostFirewallRule)(nil)).Elem()
}

type HostFirewallRuleset struct {
	DynamicData

	Key          string                     `xml:"key"`
	Label        string                     `xml:"label"`
	Required     bool                       `xml:"required"`
	Rule         []HostFirewallRule         `xml:"rule"`
	Service      string                     `xml:"service,omitempty"`
	Enabled      bool                       `xml:"enabled"`
	AllowedHosts *HostFirewallRulesetIpList `xml:"allowedHosts,omitempty"`
}

func init() {
	t["HostFirewallRuleset"] = reflect.TypeOf((*HostFirewallRuleset)(nil)).Elem()
}

type HostFirewallRulesetIpList struct {
	DynamicData

	IpAddress []string                       `xml:"ipAddress,omitempty"`
	IpNetwork []HostFirewallRulesetIpNetwork `xml:"ipNetwork,omitempty"`
	AllIp     bool                           `xml:"allIp"`
}

func init() {
	t["HostFirewallRulesetIpList"] = reflect.TypeOf((*HostFirewallRulesetIpList)(nil)).Elem()
}

type HostFirewallRulesetIpNetwork struct {
	DynamicData

	Network      string `xml:"network"`
	PrefixLength int32  `xml:"prefixLength"`
}

func init() {
	t["HostFirewallRulesetIpNetwork"] = reflect.TypeOf((*HostFirewallRulesetIpNetwork)(nil)).Elem()
}

type HostFirewallRulesetRulesetSpec struct {
	DynamicData

	AllowedHosts HostFirewallRulesetIpList `xml:"allowedHosts"`
}

func init() {
	t["HostFirewallRulesetRulesetSpec"] = reflect.TypeOf((*HostFirewallRulesetRulesetSpec)(nil)).Elem()
}

type HostFlagInfo struct {
	DynamicData

	BackgroundSnapshotsEnabled *bool `xml:"backgroundSnapshotsEnabled"`
}

func init() {
	t["HostFlagInfo"] = reflect.TypeOf((*HostFlagInfo)(nil)).Elem()
}

type HostForceMountedInfo struct {
	DynamicData

	Persist bool `xml:"persist"`
	Mounted bool `xml:"mounted"`
}

func init() {
	t["HostForceMountedInfo"] = reflect.TypeOf((*HostForceMountedInfo)(nil)).Elem()
}

type HostGatewaySpec struct {
	DynamicData

	GatewayType            string     `xml:"gatewayType"`
	GatewayId              string     `xml:"gatewayId,omitempty"`
	TrustVerificationToken string     `xml:"trustVerificationToken,omitempty"`
	HostAuthParams         []KeyValue `xml:"hostAuthParams,omitempty"`
}

func init() {
	t["HostGatewaySpec"] = reflect.TypeOf((*HostGatewaySpec)(nil)).Elem()
}

type HostGetShortNameFailedEvent struct {
	HostEvent
}

func init() {
	t["HostGetShortNameFailedEvent"] = reflect.TypeOf((*HostGetShortNameFailedEvent)(nil)).Elem()
}

type HostGetVFlashModuleDefaultConfig HostGetVFlashModuleDefaultConfigRequestType

func init() {
	t["HostGetVFlashModuleDefaultConfig"] = reflect.TypeOf((*HostGetVFlashModuleDefaultConfig)(nil)).Elem()
}

type HostGetVFlashModuleDefaultConfigRequestType struct {
	This         ManagedObjectReference `xml:"_this"`
	VFlashModule string                 `xml:"vFlashModule"`
}

func init() {
	t["HostGetVFlashModuleDefaultConfigRequestType"] = reflect.TypeOf((*HostGetVFlashModuleDefaultConfigRequestType)(nil)).Elem()
}

type HostGetVFlashModuleDefaultConfigResponse struct {
	Returnval VirtualDiskVFlashCacheConfigInfo `xml:"returnval"`
}

type HostGraphicsConfig struct {
	DynamicData

	HostDefaultGraphicsType        string                         `xml:"hostDefaultGraphicsType"`
	SharedPassthruAssignmentPolicy string                         `xml:"sharedPassthruAssignmentPolicy"`
	DeviceType                     []HostGraphicsConfigDeviceType `xml:"deviceType,omitempty"`
}

func init() {
	t["HostGraphicsConfig"] = reflect.TypeOf((*HostGraphicsConfig)(nil)).Elem()
}

type HostGraphicsConfigDeviceType struct {
	DynamicData

	DeviceId     string `xml:"deviceId"`
	GraphicsType string `xml:"graphicsType"`
}

func init() {
	t["HostGraphicsConfigDeviceType"] = reflect.TypeOf((*HostGraphicsConfigDeviceType)(nil)).Elem()
}

type HostGraphicsInfo struct {
	DynamicData

	DeviceName     string                   `xml:"deviceName"`
	VendorName     string                   `xml:"vendorName"`
	PciId          string                   `xml:"pciId"`
	GraphicsType   string                   `xml:"graphicsType"`
	MemorySizeInKB int64                    `xml:"memorySizeInKB"`
	Vm             []ManagedObjectReference `xml:"vm,omitempty"`
}

func init() {
	t["HostGraphicsInfo"] = reflect.TypeOf((*HostGraphicsInfo)(nil)).Elem()
}

type HostHardwareElementInfo struct {
	DynamicData

	Name   string                 `xml:"name"`
	Status BaseElementDescription `xml:"status,typeattr"`
}

func init() {
	t["HostHardwareElementInfo"] = reflect.TypeOf((*HostHardwareElementInfo)(nil)).Elem()
}

type HostHardwareInfo struct {
	DynamicData

	SystemInfo             HostSystemInfo              `xml:"systemInfo"`
	CpuPowerManagementInfo *HostCpuPowerManagementInfo `xml:"cpuPowerManagementInfo,omitempty"`
	CpuInfo                HostCpuInfo                 `xml:"cpuInfo"`
	CpuPkg                 []HostCpuPackage            `xml:"cpuPkg"`
	MemorySize             int64                       `xml:"memorySize"`
	NumaInfo               *HostNumaInfo               `xml:"numaInfo,omitempty"`
	SmcPresent             *bool                       `xml:"smcPresent"`
	PciDevice              []HostPciDevice             `xml:"pciDevice,omitempty"`
	CpuFeature             []HostCpuIdInfo             `xml:"cpuFeature,omitempty"`
	BiosInfo               *HostBIOSInfo               `xml:"biosInfo,omitempty"`
	ReliableMemoryInfo     *HostReliableMemoryInfo     `xml:"reliableMemoryInfo,omitempty"`
	PersistentMemoryInfo   *HostPersistentMemoryInfo   `xml:"persistentMemoryInfo,omitempty"`
	SgxInfo                *HostSgxInfo                `xml:"sgxInfo,omitempty"`
	SevInfo                *HostSevInfo                `xml:"sevInfo,omitempty"`
	MemoryTieringType      string                      `xml:"memoryTieringType,omitempty"`
	MemoryTierInfo         []HostMemoryTierInfo        `xml:"memoryTierInfo,omitempty"`
}

func init() {
	t["HostHardwareInfo"] = reflect.TypeOf((*HostHardwareInfo)(nil)).Elem()
}

type HostHardwareStatusInfo struct {
	DynamicData

	MemoryStatusInfo  []BaseHostHardwareElementInfo `xml:"memoryStatusInfo,omitempty,typeattr"`
	CpuStatusInfo     []BaseHostHardwareElementInfo `xml:"cpuStatusInfo,omitempty,typeattr"`
	StorageStatusInfo []HostStorageElementInfo      `xml:"storageStatusInfo,omitempty"`
}

func init() {
	t["HostHardwareStatusInfo"] = reflect.TypeOf((*HostHardwareStatusInfo)(nil)).Elem()
}

type HostHardwareSummary struct {
	DynamicData

	Vendor               string                         `xml:"vendor"`
	Model                string                         `xml:"model"`
	Uuid                 string                         `xml:"uuid"`
	OtherIdentifyingInfo []HostSystemIdentificationInfo `xml:"otherIdentifyingInfo,omitempty"`
	MemorySize           int64                          `xml:"memorySize"`
	CpuModel             string                         `xml:"cpuModel"`
	CpuMhz               int32                          `xml:"cpuMhz"`
	NumCpuPkgs           int16                          `xml:"numCpuPkgs"`
	NumCpuCores          int16                          `xml:"numCpuCores"`
	NumCpuThreads        int16                          `xml:"numCpuThreads"`
	NumNics              int32                          `xml:"numNics"`
	NumHBAs              int32                          `xml:"numHBAs"`
}

func init() {
	t["HostHardwareSummary"] = reflect.TypeOf((*HostHardwareSummary)(nil)).Elem()
}

type HostHasComponentFailure struct {
	VimFault

	HostName      string `xml:"hostName"`
	ComponentType string `xml:"componentType"`
	ComponentName string `xml:"componentName"`
}

func init() {
	t["HostHasComponentFailure"] = reflect.TypeOf((*HostHasComponentFailure)(nil)).Elem()
}

type HostHasComponentFailureFault HostHasComponentFailure

func init() {
	t["HostHasComponentFailureFault"] = reflect.TypeOf((*HostHasComponentFailureFault)(nil)).Elem()
}

type HostHbaCreateSpec struct {
	DynamicData
}

func init() {
	t["HostHbaCreateSpec"] = reflect.TypeOf((*HostHbaCreateSpec)(nil)).Elem()
}

type HostHostBusAdapter struct {
	DynamicData

	Key             string `xml:"key,omitempty"`
	Device          string `xml:"device"`
	Bus             int32  `xml:"bus"`
	Status          string `xml:"status"`
	Model           string `xml:"model"`
	Driver          string `xml:"driver,omitempty"`
	Pci             string `xml:"pci,omitempty"`
	StorageProtocol string `xml:"storageProtocol,omitempty"`
}

func init() {
	t["HostHostBusAdapter"] = reflect.TypeOf((*HostHostBusAdapter)(nil)).Elem()
}

type HostHyperThreadScheduleInfo struct {
	DynamicData

	Available bool `xml:"available"`
	Active    bool `xml:"active"`
	Config    bool `xml:"config"`
}

func init() {
	t["HostHyperThreadScheduleInfo"] = reflect.TypeOf((*HostHyperThreadScheduleInfo)(nil)).Elem()
}

type HostImageConfigGetAcceptance HostImageConfigGetAcceptanceRequestType

func init() {
	t["HostImageConfigGetAcceptance"] = reflect.TypeOf((*HostImageConfigGetAcceptance)(nil)).Elem()
}

type HostImageConfigGetAcceptanceRequestType struct {
	This ManagedObjectReference `xml:"_this"`
}

func init() {
	t["HostImageConfigGetAcceptanceRequestType"] = reflect.TypeOf((*HostImageConfigGetAcceptanceRequestType)(nil)).Elem()
}

type HostImageConfigGetAcceptanceResponse struct {
	Returnval string `xml:"returnval"`
}

type HostImageConfigGetProfile HostImageConfigGetProfileRequestType

func init() {
	t["HostImageConfigGetProfile"] = reflect.TypeOf((*HostImageConfigGetProfile)(nil)).Elem()
}

type HostImageConfigGetProfileRequestType struct {
	This ManagedObjectReference `xml:"_this"`
}

func init() {
	t["HostImageConfigGetProfileRequestType"] = reflect.TypeOf((*HostImageConfigGetProfileRequestType)(nil)).Elem()
}

type HostImageConfigGetProfileResponse struct {
	Returnval HostImageProfileSummary `xml:"returnval"`
}

type HostImageProfileSummary struct {
	DynamicData

	Name   string `xml:"name"`
	Vendor string `xml:"vendor"`
}

func init() {
	t["HostImageProfileSummary"] = reflect.TypeOf((*HostImageProfileSummary)(nil)).Elem()
}

type HostInAuditModeEvent struct {
	HostEvent
}

func init() {
	t["HostInAuditModeEvent"] = reflect.TypeOf((*HostInAuditModeEvent)(nil)).Elem()
}

type HostInDomain struct {
	HostConfigFault
}

func init() {
	t["HostInDomain"] = reflect.TypeOf((*HostInDomain)(nil)).Elem()
}

type HostInDomainFault HostInDomain

func init() {
	t["HostInDomainFault"] = reflect.TypeOf((*HostInDomainFault)(nil)).Elem()
}

type HostIncompatibleForFaultTolerance struct {
	VmFaultToleranceIssue

	HostName string `xml:"hostName,omitempty"`
	Reason   string `xml:"reason,omitempty"`
}

func init() {
	t["HostIncompatibleForFaultTolerance"] = reflect.TypeOf((*HostIncompatibleForFaultTolerance)(nil)).Elem()
}

type HostIncompatibleForFaultToleranceFault HostIncompatibleForFaultTolerance

func init() {
	t["HostIncompatibleForFaultToleranceFault"] = reflect.TypeOf((*HostIncompatibleForFaultToleranceFault)(nil)).Elem()
}

type HostIncompatibleForRecordReplay struct {
	VimFault

	HostName string `xml:"hostName,omitempty"`
	Reason   string `xml:"reason,omitempty"`
}

func init() {
	t["HostIncompatibleForRecordReplay"] = reflect.TypeOf((*HostIncompatibleForRecordReplay)(nil)).Elem()
}

type HostIncompatibleForRecordReplayFault HostIncompatibleForRecordReplay

func init() {
	t["HostIncompatibleForRecordReplayFault"] = reflect.TypeOf((*HostIncompatibleForRecordReplayFault)(nil)).Elem()
}

type HostInflateDiskRequestType struct {
	This      ManagedObjectReference `xml:"_this"`
	Id        ID                     `xml:"id"`
	Datastore ManagedObjectReference `xml:"datastore"`
}

func init() {
	t["HostInflateDiskRequestType"] = reflect.TypeOf((*HostInflateDiskRequestType)(nil)).Elem()
}

type HostInflateDisk_Task HostInflateDiskRequestType

func init() {
	t["HostInflateDisk_Task"] = reflect.TypeOf((*HostInflateDisk_Task)(nil)).Elem()
}

type HostInflateDisk_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval"`
}

type HostInternetScsiHba struct {
	HostHostBusAdapter

	IsSoftwareBased            bool                                          `xml:"isSoftwareBased"`
	CanBeDisabled              *bool                                         `xml:"canBeDisabled"`
	NetworkBindingSupport      HostInternetScsiHbaNetworkBindingSupportType  `xml:"networkBindingSupport,omitempty"`
	DiscoveryCapabilities      HostInternetScsiHbaDiscoveryCapabilities      `xml:"discoveryCapabilities"`
	DiscoveryProperties        HostInternetScsiHbaDiscoveryProperties        `xml:"discoveryProperties"`
	AuthenticationCapabilities HostInternetScsiHbaAuthenticationCapabilities `xml:"authenticationCapabilities"`
	AuthenticationProperties   HostInternetScsiHbaAuthenticationProperties   `xml:"authenticationProperties"`
	DigestCapabilities         *HostInternetScsiHbaDigestCapabilities        `xml:"digestCapabilities,omitempty"`
	DigestProperties           *HostInternetScsiHbaDigestProperties          `xml:"digestProperties,omitempty"`
	IpCapabilities             HostInternetScsiHbaIPCapabilities             `xml:"ipCapabilities"`
	IpProperties               HostInternetScsiHbaIPProperties               `xml:"ipProperties"`
	SupportedAdvancedOptions   []OptionDef                                   `xml:"supportedAdvancedOptions,omitempty"`
	AdvancedOptions            []HostInternetScsiHbaParamValue               `xml:"advancedOptions,omitempty"`
	IScsiName                  string                                        `xml:"iScsiName"`
	IScsiAlias                 string                                        `xml:"iScsiAlias,omitempty"`
	ConfiguredSendTarget       []HostInternetScsiHbaSendTarget               `xml:"configuredSendTarget,omitempty"`
	ConfiguredStaticTarget     []HostInternetScsiHbaStaticTarget             `xml:"configuredStaticTarget,omitempty"`
	MaxSpeedMb                 int32                                         `xml:"maxSpeedMb,omitempty"`
	CurrentSpeedMb             int32                                         `xml:"currentSpeedMb,omitempty"`
}

func init() {
	t["HostInternetScsiHba"] = reflect.TypeOf((*HostInternetScsiHba)(nil)).Elem()
}

type HostInternetScsiHbaAuthenticationCapabilities struct {
	DynamicData

	ChapAuthSettable         bool  `xml:"chapAuthSettable"`
	Krb5AuthSettable         bool  `xml:"krb5AuthSettable"`
	SrpAuthSettable          bool  `xml:"srpAuthSettable"`
	SpkmAuthSettable         bool  `xml:"spkmAuthSettable"`
	MutualChapSettable       *bool `xml:"mutualChapSettable"`
	TargetChapSettable       *bool `xml:"targetChapSettable"`
	TargetMutualChapSettable *bool `xml:"targetMutualChapSettable"`
}

func init() {
	t["HostInternetScsiHbaAuthenticationCapabilities"] = reflect.TypeOf((*HostInternetScsiHbaAuthenticationCapabilities)(nil)).Elem()
}

type HostInternetScsiHbaAuthenticationProperties struct {
	DynamicData

	ChapAuthEnabled              bool   `xml:"chapAuthEnabled"`
	ChapName                     string `xml:"chapName,omitempty"`
	ChapSecret                   string `xml:"chapSecret,omitempty"`
	ChapAuthenticationType       string `xml:"chapAuthenticationType,omitempty"`
	ChapInherited                *bool  `xml:"chapInherited"`
	MutualChapName               string `xml:"mutualChapName,omitempty"`
	MutualChapSecret             string `xml:"mutualChapSecret,omitempty"`
	MutualChapAuthenticationType string `xml:"mutualChapAuthenticationType,omitempty"`
	MutualChapInherited          *bool  `xml:"mutualChapInherited"`
}

func init() {
	t["HostInternetScsiHbaAuthenticationProperties"] = reflect.TypeOf((*HostInternetScsiHbaAuthenticationProperties)(nil)).Elem()
}

type HostInternetScsiHbaDigestCapabilities struct {
	DynamicData

	HeaderDigestSettable       *bool `xml:"headerDigestSettable"`
	DataDigestSettable         *bool `xml:"dataDigestSettable"`
	TargetHeaderDigestSettable *bool `xml:"targetHeaderDigestSettable"`
	TargetDataDigestSettable   *bool `xml:"targetDataDigestSettable"`
}

func init() {
	t["HostInternetScsiHbaDigestCapabilities"] = reflect.TypeOf((*HostInternetScsiHbaDigestCapabilities)(nil)).Elem()
}

type HostInternetScsiHbaDigestProperties struct {
	DynamicData

	HeaderDigestType      string `xml:"headerDigestType,omitempty"`
	HeaderDigestInherited *bool  `xml:"headerDigestInherited"`
	DataDigestType        string `xml:"dataDigestType,omitempty"`
	DataDigestInherited   *bool  `xml:"dataDigestInherited"`
}

func init() {
	t["HostInternetScsiHbaDigestProperties"] = reflect.TypeOf((*HostInternetScsiHbaDigestProperties)(nil)).Elem()
}

type HostInternetScsiHbaDiscoveryCapabilities struct {
	DynamicData

	ISnsDiscoverySettable         bool `xml:"iSnsDiscoverySettable"`
	SlpDiscoverySettable          bool `xml:"slpDiscoverySettable"`
	StaticTargetDiscoverySettable bool `xml:"staticTargetDiscoverySettable"`
	SendTargetsDiscoverySettable  bool `xml:"sendTargetsDiscoverySettable"`
}

func init() {
	t["HostInternetScsiHbaDiscoveryCapabilities"] = reflect.TypeOf((*HostInternetScsiHbaDiscoveryCapabilities)(nil)).Elem()
}

type HostInternetScsiHbaDiscoveryProperties struct {
	DynamicData

	ISnsDiscoveryEnabled         bool   `xml:"iSnsDiscoveryEnabled"`
	ISnsDiscoveryMethod          string `xml:"iSnsDiscoveryMethod,omitempty"`
	ISnsHost                     string `xml:"iSnsHost,omitempty"`
	SlpDiscoveryEnabled          bool   `xml:"slpDiscoveryEnabled"`
	SlpDiscoveryMethod           string `xml:"slpDiscoveryMethod,omitempty"`
	SlpHost                      string `xml:"slpHost,omitempty"`
	StaticTargetDiscoveryEnabled bool   `xml:"staticTargetDiscoveryEnabled"`
	SendTargetsDiscoveryEnabled  bool   `xml:"sendTargetsDiscoveryEnabled"`
}

func init() {
	t["HostInternetScsiHbaDiscoveryProperties"] = reflect.TypeOf((*HostInternetScsiHbaDiscoveryProperties)(nil)).Elem()
}

type HostInternetScsiHbaIPCapabilities struct {
	DynamicData

	AddressSettable                              bool  `xml:"addressSettable"`
	IpConfigurationMethodSettable                bool  `xml:"ipConfigurationMethodSettable"`
	SubnetMaskSettable                           bool  `xml:"subnetMaskSettable"`
	DefaultGatewaySettable                       bool  `xml:"defaultGatewaySettable"`
	PrimaryDnsServerAddressSettable              bool  `xml:"primaryDnsServerAddressSettable"`
	AlternateDnsServerAddressSettable            bool  `xml:"alternateDnsServerAddressSettable"`
	Ipv6Supported                                *bool `xml:"ipv6Supported"`
	ArpRedirectSettable                          *bool `xml:"arpRedirectSettable"`
	MtuSettable                                  *bool `xml:"mtuSettable"`
	HostNameAsTargetAddress                      *bool `xml:"hostNameAsTargetAddress"`
	NameAliasSettable                            *bool `xml:"nameAliasSettable"`
	Ipv4EnableSettable                           *bool `xml:"ipv4EnableSettable"`
	Ipv6EnableSettable                           *bool `xml:"ipv6EnableSettable"`
	Ipv6PrefixLengthSettable                     *bool `xml:"ipv6PrefixLengthSettable"`
	Ipv6PrefixLength                             int32 `xml:"ipv6PrefixLength,omitempty"`
	Ipv6DhcpConfigurationSettable                *bool `xml:"ipv6DhcpConfigurationSettable"`
	Ipv6LinkLocalAutoConfigurationSettable       *bool `xml:"ipv6LinkLocalAutoConfigurationSettable"`
	Ipv6RouterAdvertisementConfigurationSettable *bool `xml:"ipv6RouterAdvertisementConfigurationSettable"`
	Ipv6DefaultGatewaySettable                   *bool `xml:"ipv6DefaultGatewaySettable"`
	Ipv6MaxStaticAddressesSupported              int32 `xml:"ipv6MaxStaticAddressesSupported,omitempty"`
}

func init() {
	t["HostInternetScsiHbaIPCapabilities"] = reflect.TypeOf((*HostInternetScsiHbaIPCapabilities)(nil)).Elem()
}

type HostInternetScsiHbaIPProperties struct {
	DynamicData

	Mac                       string                             `xml:"mac,omitempty"`
	Address                   string                             `xml:"address,omitempty"`
	DhcpConfigurationEnabled  bool                               `xml:"dhcpConfigurationEnabled"`
	SubnetMask                string                             `xml:"subnetMask,omitempty"`
	DefaultGateway            string                             `xml:"defaultGateway,omitempty"`
	PrimaryDnsServerAddress   string                             `xml:"primaryDnsServerAddress,omitempty"`
	AlternateDnsServerAddress string                             `xml:"alternateDnsServerAddress,omitempty"`
	Ipv6Address               string                             `xml:"ipv6Address,omitempty"`
	Ipv6SubnetMask            string                             `xml:"ipv6SubnetMask,omitempty"`
	Ipv6DefaultGateway        string                             `xml:"ipv6DefaultGateway,omitempty"`
	ArpRedirectEnabled        *bool                              `xml:"arpRedirectEnabled"`
	Mtu                       int32                              `xml:"mtu,omitempty"`
	JumboFramesEnabled        *bool                              `xml:"jumboFramesEnabled"`
	Ipv4Enabled               *bool                              `xml:"ipv4Enabled"`
	Ipv6Enabled               *bool                              `xml:"ipv6Enabled"`
	Ipv6properties            *HostInternetScsiHbaIPv6Properties `xml:"ipv6properties,omitempty"`
}

func init() {
	t["HostInternetScsiHbaIPProperties"] = reflect.TypeOf((*HostInternetScsiHbaIPProperties)(nil)).Elem()
}

type HostInternetScsiHbaIPv6Properties struct {
	DynamicData

	IscsiIpv6Address                            []HostInternetScsiHbaIscsiIpv6Address `xml:"iscsiIpv6Address,omitempty"`
	Ipv6DhcpConfigurationEnabled                *bool                                 `xml:"ipv6DhcpConfigurationEnabled"`
	Ipv6LinkLocalAutoConfigurationEnabled       *bool                                 `xml:"ipv6LinkLocalAutoConfigurationEnabled"`
	Ipv6RouterAdvertisementConfigurationEnabled *bool                                 `xml:"ipv6RouterAdvertisementConfigurationEnabled"`
	Ipv6DefaultGateway                          string                                `xml:"ipv6DefaultGateway,omitempty"`
}

func init() {
	t["HostInternetScsiHbaIPv6Properties"] = reflect.TypeOf((*HostInternetScsiHbaIPv6Properties)(nil)).Elem()
}

type HostInternetScsiHbaIscsiIpv6Address struct {
	DynamicData

	Address      string `xml:"address"`
	PrefixLength int32  `xml:"prefixLength"`
	Origin       string `xml:"origin"`
	Operation    string `xml:"operation,omitempty"`
}

func init() {
	t["HostInternetScsiHbaIscsiIpv6Address"] = reflect.TypeOf((*HostInternetScsiHbaIscsiIpv6Address)(nil)).Elem()
}

type HostInternetScsiHbaParamValue struct {
	OptionValue

	IsInherited *bool `xml:"isInherited"`
}

func init() {
	t["HostInternetScsiHbaParamValue"] = reflect.TypeOf((*HostInternetScsiHbaParamValue)(nil)).Elem()
}

type HostInternetScsiHbaSendTarget struct {
	DynamicData

	Address                  string                                       `xml:"address"`
	Port                     int32                                        `xml:"port,omitempty"`
	AuthenticationProperties *HostInternetScsiHbaAuthenticationProperties `xml:"authenticationProperties,omitempty"`
	DigestProperties         *HostInternetScsiHbaDigestProperties         `xml:"digestProperties,omitempty"`
	SupportedAdvancedOptions []OptionDef                                  `xml:"supportedAdvancedOptions,omitempty"`
	AdvancedOptions          []HostInternetScsiHbaParamValue              `xml:"advancedOptions,omitempty"`
	Parent                   string                                       `xml:"parent,omitempty"`
}

func init() {
	t["HostInternetScsiHbaSendTarget"] = reflect.TypeOf((*HostInternetScsiHbaSendTarget)(nil)).Elem()
}

type HostInternetScsiHbaStaticTarget struct {
	DynamicData

	Address                  string                                       `xml:"address"`
	Port                     int32                                        `xml:"port,omitempty"`
	IScsiName                string                                       `xml:"iScsiName"`
	DiscoveryMethod          string                                       `xml:"discoveryMethod,omitempty"`
	AuthenticationProperties *HostInternetScsiHbaAuthenticationProperties `xml:"authenticationProperties,omitempty"`
	DigestProperties         *HostInternetScsiHbaDigestProperties         `xml:"digestProperties,omitempty"`
	SupportedAdvancedOptions []OptionDef                                  `xml:"supportedAdvancedOptions,omitempty"`
	AdvancedOptions          []HostInternetScsiHbaParamValue              `xml:"advancedOptions,omitempty"`
	Parent                   string                                       `xml:"parent,omitempty"`
}

func init() {
	t["HostInternetScsiHbaStaticTarget"] = reflect.TypeOf((*HostInternetScsiHbaStaticTarget)(nil)).Elem()
}

type HostInternetScsiHbaTargetSet struct {
	DynamicData

	StaticTargets []HostInternetScsiHbaStaticTarget `xml:"staticTargets,omitempty"`
	SendTargets   []HostInternetScsiHbaSendTarget   `xml:"sendTargets,omitempty"`
}

func init() {
	t["HostInternetScsiHbaTargetSet"] = reflect.TypeOf((*HostInternetScsiHbaTargetSet)(nil)).Elem()
}

type HostInternetScsiTargetTransport struct {
	HostTargetTransport

	IScsiName  string   `xml:"iScsiName"`
	IScsiAlias string   `xml:"iScsiAlias"`
	Address    []string `xml:"address,omitempty"`
}

func init() {
	t["HostInternetScsiTargetTransport"] = reflect.TypeOf((*HostInternetScsiTargetTransport)(nil)).Elem()
}

type HostInventoryFull struct {
	NotEnoughLicenses

	Capacity int32 `xml:"capacity"`
}

func init() {
	t["HostInventoryFull"] = reflect.TypeOf((*HostInventoryFull)(nil)).Elem()
}

type HostInventoryFullEvent struct {
	LicenseEvent

	Capacity int32 `xml:"capacity"`
}

func init() {
	t["HostInventoryFullEvent"] = reflect.TypeOf((*HostInventoryFullEvent)(nil)).Elem()
}

type HostInventoryFullFault HostInventoryFull

func init() {
	t["HostInventoryFullFault"] = reflect.TypeOf((*HostInventoryFullFault)(nil)).Elem()
}

type HostInventoryUnreadableEvent struct {
	Event
}

func init() {
	t["HostInventoryUnreadableEvent"] = reflect.TypeOf((*HostInventoryUnreadableEvent)(nil)).Elem()
}

type HostIoFilterInfo struct {
	IoFilterInfo

	Available bool `xml:"available"`
}

func init() {
	t["HostIoFilterInfo"] = reflect.TypeOf((*HostIoFilterInfo)(nil)).Elem()
}

type HostIpChangedEvent struct {
	HostEvent

	OldIP string `xml:"oldIP"`
	NewIP string `xml:"newIP"`
}

func init() {
	t["HostIpChangedEvent"] = reflect.TypeOf((*HostIpChangedEvent)(nil)).Elem()
}

type HostIpConfig struct {
	DynamicData

	Dhcp       bool                                  `xml:"dhcp"`
	IpAddress  string                                `xml:"ipAddress,omitempty"`
	SubnetMask string                                `xml:"subnetMask,omitempty"`
	IpV6Config *HostIpConfigIpV6AddressConfiguration `xml:"ipV6Config,omitempty"`
}

func init() {
	t["HostIpConfig"] = reflect.TypeOf((*HostIpConfig)(nil)).Elem()
}

type HostIpConfigIpV6Address struct {
	DynamicData

	IpAddress    string     `xml:"ipAddress"`
	PrefixLength int32      `xml:"prefixLength"`
	Origin       string     `xml:"origin,omitempty"`
	DadState     string     `xml:"dadState,omitempty"`
	Lifetime     *time.Time `xml:"lifetime"`
	Operation    string     `xml:"operation,omitempty"`
}

func init() {
	t["HostIpConfigIpV6Address"] = reflect.TypeOf((*HostIpConfigIpV6Address)(nil)).Elem()
}

type HostIpConfigIpV6AddressConfiguration struct {
	DynamicData

	IpV6Address              []HostIpConfigIpV6Address `xml:"ipV6Address,omitempty"`
	AutoConfigurationEnabled *bool                     `xml:"autoConfigurationEnabled"`
	DhcpV6Enabled            *bool                     `xml:"dhcpV6Enabled"`
}

func init() {
	t["HostIpConfigIpV6AddressConfiguration"] = reflect.TypeOf((*HostIpConfigIpV6AddressConfiguration)(nil)).Elem()
}

type HostIpInconsistentEvent struct {
	HostEvent

	IpAddress  string `xml:"ipAddress"`
	IpAddress2 string `xml:"ipAddress2"`
}

func init() {
	t["HostIpInconsistentEvent"] = reflect.TypeOf((*HostIpInconsistentEvent)(nil)).Elem()
}

type HostIpRouteConfig struct {
	DynamicData

	DefaultGateway     string `xml:"defaultGateway,omitempty"`
	GatewayDevice      string `xml:"gatewayDevice,omitempty"`
	IpV6DefaultGateway string `xml:"ipV6DefaultGateway,omitempty"`
	IpV6GatewayDevice  string `xml:"ipV6GatewayDevice,omitempty"`
}

func init() {
	t["HostIpRouteConfig"] = reflect.TypeOf((*HostIpRouteConfig)(nil)).Elem()
}

type HostIpRouteConfigSpec struct {
	HostIpRouteConfig

	GatewayDeviceConnection     *HostVirtualNicConnection `xml:"gatewayDeviceConnection,omitempty"`
	IpV6GatewayDeviceConnection *HostVirtualNicConnection `xml:"ipV6GatewayDeviceConnection,omitempty"`
}

func init() {
	t["HostIpRouteConfigSpec"] = reflect.TypeOf((*HostIpRouteConfigSpec)(nil)).Elem()
}

type HostIpRouteEntry struct {
	DynamicData

	Network      string `xml:"network"`
	PrefixLength int32  `xml:"prefixLength"`
	Gateway      string `xml:"gateway"`
	DeviceName   string `xml:"deviceName,omitempty"`
}

func init() {
	t["HostIpRouteEntry"] = reflect.TypeOf((*HostIpRouteEntry)(nil)).Elem()
}

type HostIpRouteOp struct {
	DynamicData

	ChangeOperation string           `xml:"changeOperation"`
	Route           HostIpRouteEntry `xml:"route"`
}

func init() {
	t["HostIpRouteOp"] = reflect.TypeOf((*HostIpRouteOp)(nil)).Elem()
}

type HostIpRouteTableConfig struct {
	DynamicData

	IpRoute   []HostIpRouteOp `xml:"ipRoute,omitempty"`
	Ipv6Route []HostIpRouteOp `xml:"ipv6Route,omitempty"`
}

func init() {
	t["HostIpRouteTableConfig"] = reflect.TypeOf((*HostIpRouteTableConfig)(nil)).Elem()
}

type HostIpRouteTableInfo struct {
	DynamicData

	IpRoute   []HostIpRouteEntry `xml:"ipRoute,omitempty"`
	Ipv6Route []HostIpRouteEntry `xml:"ipv6Route,omitempty"`
}

func init() {
	t["HostIpRouteTableInfo"] = reflect.TypeOf((*HostIpRouteTableInfo)(nil)).Elem()
}

type HostIpToShortNameFailedEvent struct {
	HostEvent
}

func init() {
	t["HostIpToShortNameFailedEvent"] = reflect.TypeOf((*HostIpToShortNameFailedEvent)(nil)).Elem()
}

type HostIpmiInfo struct {
	DynamicData

	BmcIpAddress  string `xml:"bmcIpAddress,omitempty"`
	BmcMacAddress string `xml:"bmcMacAddress,omitempty"`
	Login         string `xml:"login,omitempty"`
	Password      string `xml:"password,omitempty"`
}

func init() {
	t["HostIpmiInfo"] = reflect.TypeOf((*HostIpmiInfo)(nil)).Elem()
}

type HostIsolationIpPingFailedEvent struct {
	HostDasEvent

	IsolationIp string `xml:"isolationIp"`
}

func init() {
	t["HostIsolationIpPingFailedEvent"] = reflect.TypeOf((*HostIsolationIpPingFailedEvent)(nil)).Elem()
}

type HostLicensableResourceInfo struct {
	DynamicData

	Resource []KeyAnyValue `xml:"resource"`
}

func init() {
	t["HostLicensableResourceInfo"] = reflect.TypeOf((*HostLicensableResourceInfo)(nil)).Elem()
}

type HostLicenseConnectInfo struct {
	DynamicData

	License    LicenseManagerLicenseInfo    `xml:"license"`
	Evaluation LicenseManagerEvaluationInfo `xml:"evaluation"`
	Resource   *HostLicensableResourceInfo  `xml:"resource,omitempty"`
}

func init() {
	t["HostLicenseConnectInfo"] = reflect.TypeOf((*HostLicenseConnectInfo)(nil)).Elem()
}

type HostLicenseExpiredEvent struct {
	LicenseEvent
}

func init() {
	t["HostLicenseExpiredEvent"] = reflect.TypeOf((*HostLicenseExpiredEvent)(nil)).Elem()
}

type HostLicenseSpec struct {
	DynamicData

	Source             BaseLicenseSource `xml:"source,omitempty,typeattr"`
	EditionKey         string            `xml:"editionKey,omitempty"`
	DisabledFeatureKey []string          `xml:"disabledFeatureKey,omitempty"`
	EnabledFeatureKey  []string          `xml:"enabledFeatureKey,omitempty"`
}

func init() {
	t["HostLicenseSpec"] = reflect.TypeOf((*HostLicenseSpec)(nil)).Elem()
}

type HostListSummary struct {
	DynamicData

	Host                           *ManagedObjectReference             `xml:"host,omitempty"`
	Hardware                       *HostHardwareSummary                `xml:"hardware,omitempty"`
	Runtime                        *HostRuntimeInfo                    `xml:"runtime,omitempty"`
	Config                         HostConfigSummary                   `xml:"config"`
	QuickStats                     HostListSummaryQuickStats           `xml:"quickStats"`
	OverallStatus                  ManagedEntityStatus                 `xml:"overallStatus"`
	RebootRequired                 bool                                `xml:"rebootRequired"`
	CustomValue                    []BaseCustomFieldValue              `xml:"customValue,omitempty,typeattr"`
	ManagementServerIp             string                              `xml:"managementServerIp,omitempty"`
	MaxEVCModeKey                  string                              `xml:"maxEVCModeKey,omitempty"`
	CurrentEVCModeKey              string                              `xml:"currentEVCModeKey,omitempty"`
	CurrentEVCGraphicsModeKey      string                              `xml:"currentEVCGraphicsModeKey,omitempty"`
	Gateway                        *HostListSummaryGatewaySummary      `xml:"gateway,omitempty"`
	TpmAttestation                 *HostTpmAttestationInfo             `xml:"tpmAttestation,omitempty"`
	TrustAuthorityAttestationInfos []HostTrustAuthorityAttestationInfo `xml:"trustAuthorityAttestationInfos,omitempty"`
}

func init() {
	t["HostListSummary"] = reflect.TypeOf((*HostListSummary)(nil)).Elem()
}

type HostListSummaryGatewaySummary struct {
	DynamicData

	GatewayType string `xml:"gatewayType"`
	GatewayId   string `xml:"gatewayId"`
}

func init() {
	t["HostListSummaryGatewaySummary"] = reflect.TypeOf((*HostListSummaryGatewaySummary)(nil)).Elem()
}

type HostListSummaryQuickStats struct {
	DynamicData

	OverallCpuUsage           int32 `xml:"overallCpuUsage,omitempty"`
	OverallMemoryUsage        int32 `xml:"overallMemoryUsage,omitempty"`
	DistributedCpuFairness    int32 `xml:"distributedCpuFairness,omitempty"`
	DistributedMemoryFairness int32 `xml:"distributedMemoryFairness,omitempty"`
	AvailablePMemCapacity     int32 `xml:"availablePMemCapacity,omitempty"`
	Uptime                    int32 `xml:"uptime,omitempty"`
}

func init() {
	t["HostListSummaryQuickStats"] = reflect.TypeOf((*HostListSummaryQuickStats)(nil)).Elem()
}

type HostListVStorageObject HostListVStorageObjectRequestType

func init() {
	t["HostListVStorageObject"] = reflect.TypeOf((*HostListVStorageObject)(nil)).Elem()
}

type HostListVStorageObjectRequestType struct {
	This      ManagedObjectReference `xml:"_this"`
	Datastore ManagedObjectReference `xml:"datastore"`
}

func init() {
	t["HostListVStorageObjectRequestType"] = reflect.TypeOf((*HostListVStorageObjectRequestType)(nil)).Elem()
}

type HostListVStorageObjectResponse struct {
	Returnval []ID `xml:"returnval,omitempty"`
}

type HostLocalAuthenticationInfo struct {
	HostAuthenticationStoreInfo
}

func init() {
	t["HostLocalAuthenticationInfo"] = reflect.TypeOf((*HostLocalAuthenticationInfo)(nil)).Elem()
}

type HostLocalFileSystemVolume struct {
	HostFileSystemVolume

	Device string `xml:"device"`
}

func init() {
	t["HostLocalFileSystemVolume"] = reflect.TypeOf((*HostLocalFileSystemVolume)(nil)).Elem()
}

type HostLocalFileSystemVolumeSpec struct {
	DynamicData

	Device    string `xml:"device"`
	LocalPath string `xml:"localPath"`
}

func init() {
	t["HostLocalFileSystemVolumeSpec"] = reflect.TypeOf((*HostLocalFileSystemVolumeSpec)(nil)).Elem()
}

type HostLocalPortCreatedEvent struct {
	DvsEvent

	HostLocalPort DVSHostLocalPortInfo `xml:"hostLocalPort"`
}

func init() {
	t["HostLocalPortCreatedEvent"] = reflect.TypeOf((*HostLocalPortCreatedEvent)(nil)).Elem()
}

type HostLowLevelProvisioningManagerDiskLayoutSpec struct {
	DynamicData

	ControllerType string `xml:"controllerType"`
	BusNumber      int32  `xml:"busNumber"`
	UnitNumber     *int32 `xml:"unitNumber"`
	SrcFilename    string `xml:"srcFilename"`
	DstFilename    string `xml:"dstFilename"`
}

func init() {
	t["HostLowLevelProvisioningManagerDiskLayoutSpec"] = reflect.TypeOf((*HostLowLevelProvisioningManagerDiskLayoutSpec)(nil)).Elem()
}

type HostLowLevelProvisioningManagerFileDeleteResult struct {
	DynamicData

	FileName string               `xml:"fileName"`
	Fault    LocalizedMethodFault `xml:"fault"`
}

func init() {
	t["HostLowLevelProvisioningManagerFileDeleteResult"] = reflect.TypeOf((*HostLowLevelProvisioningManagerFileDeleteResult)(nil)).Elem()
}

type HostLowLevelProvisioningManagerFileDeleteSpec struct {
	DynamicData

	FileName string `xml:"fileName"`
	FileType string `xml:"fileType"`
}

func init() {
	t["HostLowLevelProvisioningManagerFileDeleteSpec"] = reflect.TypeOf((*HostLowLevelProvisioningManagerFileDeleteSpec)(nil)).Elem()
}

type HostLowLevelProvisioningManagerFileReserveResult struct {
	DynamicData

	BaseName     string `xml:"baseName"`
	ParentDir    string `xml:"parentDir"`
	ReservedName string `xml:"reservedName"`
}

func init() {
	t["HostLowLevelProvisioningManagerFileReserveResult"] = reflect.TypeOf((*HostLowLevelProvisioningManagerFileReserveResult)(nil)).Elem()
}

type HostLowLevelProvisioningManagerFileReserveSpec struct {
	DynamicData

	BaseName       string `xml:"baseName"`
	ParentDir      string `xml:"parentDir"`
	FileType       string `xml:"fileType"`
	StorageProfile string `xml:"storageProfile"`
}

func init() {
	t["HostLowLevelProvisioningManagerFileReserveSpec"] = reflect.TypeOf((*HostLowLevelProvisioningManagerFileReserveSpec)(nil)).Elem()
}

type HostLowLevelProvisioningManagerSnapshotLayoutSpec struct {
	DynamicData

	Id          int32                                           `xml:"id"`
	SrcFilename string                                          `xml:"srcFilename"`
	DstFilename string                                          `xml:"dstFilename"`
	Disk        []HostLowLevelProvisioningManagerDiskLayoutSpec `xml:"disk,omitempty"`
}

func init() {
	t["HostLowLevelProvisioningManagerSnapshotLayoutSpec"] = reflect.TypeOf((*HostLowLevelProvisioningManagerSnapshotLayoutSpec)(nil)).Elem()
}

type HostLowLevelProvisioningManagerVmMigrationStatus struct {
	DynamicData

	MigrationId          int64  `xml:"migrationId"`
	Type                 string `xml:"type"`
	Source               bool   `xml:"source"`
	ConsideredSuccessful bool   `xml:"consideredSuccessful"`
}

func init() {
	t["HostLowLevelProvisioningManagerVmMigrationStatus"] = reflect.TypeOf((*HostLowLevelProvisioningManagerVmMigrationStatus)(nil)).Elem()
}

type HostLowLevelProvisioningManagerVmRecoveryInfo struct {
	DynamicData

	Version      string                       `xml:"version"`
	BiosUUID     string                       `xml:"biosUUID"`
	InstanceUUID string                       `xml:"instanceUUID"`
	FtInfo       BaseFaultToleranceConfigInfo `xml:"ftInfo,omitempty,typeattr"`
}

func init() {
	t["HostLowLevelProvisioningManagerVmRecoveryInfo"] = reflect.TypeOf((*HostLowLevelProvisioningManagerVmRecoveryInfo)(nil)).Elem()
}

type HostMaintenanceSpec struct {
	DynamicData

	VsanMode *VsanHostDecommissionMode `xml:"vsanMode,omitempty"`
	Purpose  string                    `xml:"purpose,omitempty"`
}

func init() {
	t["HostMaintenanceSpec"] = reflect.TypeOf((*HostMaintenanceSpec)(nil)).Elem()
}

type HostMemberHealthCheckResult struct {
	DynamicData

	Summary string `xml:"summary,omitempty"`
}

func init() {
	t["HostMemberHealthCheckResult"] = reflect.TypeOf((*HostMemberHealthCheckResult)(nil)).Elem()
}

type HostMemberRuntimeInfo struct {
	DynamicData

	Host              ManagedObjectReference            `xml:"host"`
	Status            string                            `xml:"status,omitempty"`
	StatusDetail      string                            `xml:"statusDetail,omitempty"`
	NsxtStatus        string                            `xml:"nsxtStatus,omitempty"`
	NsxtStatusDetail  string                            `xml:"nsxtStatusDetail,omitempty"`
	HealthCheckResult []BaseHostMemberHealthCheckResult `xml:"healthCheckResult,omitempty,typeattr"`
}

func init() {
	t["HostMemberRuntimeInfo"] = reflect.TypeOf((*HostMemberRuntimeInfo)(nil)).Elem()
}

type HostMemberUplinkHealthCheckResult struct {
	HostMemberHealthCheckResult

	UplinkPortKey string `xml:"uplinkPortKey"`
}

func init() {
	t["HostMemberUplinkHealthCheckResult"] = reflect.TypeOf((*HostMemberUplinkHealthCheckResult)(nil)).Elem()
}

type HostMemoryProfile struct {
	ApplyProfile
}

func init() {
	t["HostMemoryProfile"] = reflect.TypeOf((*HostMemoryProfile)(nil)).Elem()
}

type HostMemorySpec struct {
	DynamicData

	ServiceConsoleReservation int64 `xml:"serviceConsoleReservation,omitempty"`
}

func init() {
	t["HostMemorySpec"] = reflect.TypeOf((*HostMemorySpec)(nil)).Elem()
}

type HostMemoryTierInfo struct {
	DynamicData

	Name  string   `xml:"name"`
	Type  string   `xml:"type"`
	Flags []string `xml:"flags,omitempty"`
	Size  int64    `xml:"size"`
}

func init() {
	t["HostMemoryTierInfo"] = reflect.TypeOf((*HostMemoryTierInfo)(nil)).Elem()
}

type HostMissingNetworksEvent struct {
	HostDasEvent

	Ips string `xml:"ips,omitempty"`
}

func init() {
	t["HostMissingNetworksEvent"] = reflect.TypeOf((*HostMissingNetworksEvent)(nil)).Elem()
}

type HostMonitoringStateChangedEvent struct {
	ClusterEvent

	State     string `xml:"state"`
	PrevState string `xml:"prevState,omitempty"`
}

func init() {
	t["HostMonitoringStateChangedEvent"] = reflect.TypeOf((*HostMonitoringStateChangedEvent)(nil)).Elem()
}

type HostMountInfo struct {
	DynamicData

	Path               string `xml:"path,omitempty"`
	AccessMode         string `xml:"accessMode"`
	Mounted            *bool  `xml:"mounted"`
	Accessible         *bool  `xml:"accessible"`
	InaccessibleReason string `xml:"inaccessibleReason,omitempty"`
}

func init() {
	t["HostMountInfo"] = reflect.TypeOf((*HostMountInfo)(nil)).Elem()
}

type HostMultipathInfo struct {
	DynamicData

	Lun []HostMultipathInfoLogicalUnit `xml:"lun,omitempty"`
}

func init() {
	t["HostMultipathInfo"] = reflect.TypeOf((*HostMultipathInfo)(nil)).Elem()
}

type HostMultipathInfoFixedLogicalUnitPolicy struct {
	HostMultipathInfoLogicalUnitPolicy

	Prefer string `xml:"prefer"`
}

func init() {
	t["HostMultipathInfoFixedLogicalUnitPolicy"] = reflect.TypeOf((*HostMultipathInfoFixedLogicalUnitPolicy)(nil)).Elem()
}

type HostMultipathInfoHppLogicalUnitPolicy struct {
	HostMultipathInfoLogicalUnitPolicy

	Bytes              int64  `xml:"bytes,omitempty"`
	Iops               int64  `xml:"iops,omitempty"`
	Path               string `xml:"path,omitempty"`
	LatencyEvalTime    int64  `xml:"latencyEvalTime,omitempty"`
	SamplingIosPerPath int64  `xml:"samplingIosPerPath,omitempty"`
}

func init() {
	t["HostMultipathInfoHppLogicalUnitPolicy"] = reflect.TypeOf((*HostMultipathInfoHppLogicalUnitPolicy)(nil)).Elem()
}

type HostMultipathInfoLogicalUnit struct {
	DynamicData

	Key                    string                                              `xml:"key"`
	Id                     string                                              `xml:"id"`
	Lun                    string                                              `xml:"lun"`
	Path                   []HostMultipathInfoPath                             `xml:"path"`
	Policy                 BaseHostMultipathInfoLogicalUnitPolicy              `xml:"policy,typeattr"`
	StorageArrayTypePolicy *HostMultipathInfoLogicalUnitStorageArrayTypePolicy `xml:"storageArrayTypePolicy,omitempty"`
}

func init() {
	t["HostMultipathInfoLogicalUnit"] = reflect.TypeOf((*HostMultipathInfoLogicalUnit)(nil)).Elem()
}

type HostMultipathInfoLogicalUnitPolicy struct {
	DynamicData

	Policy string `xml:"policy"`
}

func init() {
	t["HostMultipathInfoLogicalUnitPolicy"] = reflect.TypeOf((*HostMultipathInfoLogicalUnitPolicy)(nil)).Elem()
}

type HostMultipathInfoLogicalUnitStorageArrayTypePolicy struct {
	DynamicData

	Policy string `xml:"policy"`
}

func init() {
	t["HostMultipathInfoLogicalUnitStorageArrayTypePolicy"] = reflect.TypeOf((*HostMultipathInfoLogicalUnitStorageArrayTypePolicy)(nil)).Elem()
}

type HostMultipathInfoPath struct {
	DynamicData

	Key           string                  `xml:"key"`
	Name          string                  `xml:"name"`
	PathState     string                  `xml:"pathState"`
	State         string                  `xml:"state,omitempty"`
	IsWorkingPath *bool                   `xml:"isWorkingPath"`
	Adapter       string                  `xml:"adapter"`
	Lun           string                  `xml:"lun"`
	Transport     BaseHostTargetTransport `xml:"transport,omitempty,typeattr"`
}

func init() {
	t["HostMultipathInfoPath"] = reflect.TypeOf((*HostMultipathInfoPath)(nil)).Elem()
}

type HostMultipathStateInfo struct {
	DynamicData

	Path []HostMultipathStateInfoPath `xml:"path,omitempty"`
}

func init() {
	t["HostMultipathStateInfo"] = reflect.TypeOf((*HostMultipathStateInfo)(nil)).Elem()
}

type HostMultipathStateInfoPath struct {
	DynamicData

	Name      string `xml:"name"`
	PathState string `xml:"pathState"`
}

func init() {
	t["HostMultipathStateInfoPath"] = reflect.TypeOf((*HostMultipathStateInfoPath)(nil)).Elem()
}

type HostNasVolume struct {
	HostFileSystemVolume

	RemoteHost       string   `xml:"remoteHost"`
	RemotePath       string   `xml:"remotePath"`
	UserName         string   `xml:"userName,omitempty"`
	RemoteHostNames  []string `xml:"remoteHostNames,omitempty"`
	SecurityType     string   `xml:"securityType,omitempty"`
	ProtocolEndpoint *bool    `xml:"protocolEndpoint"`
}

func init() {
	t["HostNasVolume"] = reflect.TypeOf((*HostNasVolume)(nil)).Elem()
}

type HostNasVolumeConfig struct {
	DynamicData

	ChangeOperation string             `xml:"changeOperation,omitempty"`
	Spec            *HostNasVolumeSpec `xml:"spec,omitempty"`
}

func init() {
	t["HostNasVolumeConfig"] = reflect.TypeOf((*HostNasVolumeConfig)(nil)).Elem()
}

type HostNasVolumeSpec struct {
	DynamicData

	RemoteHost      string   `xml:"remoteHost"`
	RemotePath      string   `xml:"remotePath"`
	LocalPath       string   `xml:"localPath"`
	AccessMode      string   `xml:"accessMode"`
	Type            string   `xml:"type,omitempty"`
	UserName        string   `xml:"userName,omitempty"`
	Password        string   `xml:"password,omitempty"`
	RemoteHostNames []string `xml:"remoteHostNames,omitempty"`
	SecurityType    string   `xml:"securityType,omitempty"`
}

func init() {
	t["HostNasVolumeSpec"] = reflect.TypeOf((*HostNasVolumeSpec)(nil)).Elem()
}

type HostNasVolumeUserInfo struct {
	DynamicData

	User string `xml:"user"`
}

func init() {
	t["HostNasVolumeUserInfo"] = reflect.TypeOf((*HostNasVolumeUserInfo)(nil)).Elem()
}

type HostNatService struct {
	DynamicData

	Key  string             `xml:"key"`
	Spec HostNatServiceSpec `xml:"spec"`
}

func init() {
	t["HostNatService"] = reflect.TypeOf((*HostNatService)(nil)).Elem()
}

type HostNatServiceConfig struct {
	DynamicData

	ChangeOperation string             `xml:"changeOperation,omitempty"`
	Key             string             `xml:"key"`
	Spec            HostNatServiceSpec `xml:"spec"`
}

func init() {
	t["HostNatServiceConfig"] = reflect.TypeOf((*HostNatServiceConfig)(nil)).Elem()
}

type HostNatServiceNameServiceSpec struct {
	DynamicData

	DnsAutoDetect bool     `xml:"dnsAutoDetect"`
	DnsPolicy     string   `xml:"dnsPolicy"`
	DnsRetries    int32    `xml:"dnsRetries"`
	DnsTimeout    int32    `xml:"dnsTimeout"`
	DnsNameServer []string `xml:"dnsNameServer,omitempty"`
	NbdsTimeout   int32    `xml:"nbdsTimeout"`
	NbnsRetries   int32    `xml:"nbnsRetries"`
	NbnsTimeout   int32    `xml:"nbnsTimeout"`
}

func init() {
	t["HostNatServiceNameServiceSpec"] = reflect.TypeOf((*HostNatServiceNameServiceSpec)(nil)).Elem()
}

type HostNatServicePortForwardSpec struct {
	DynamicData

	Type           string `xml:"type"`
	Name           string `xml:"name"`
	HostPort       int32  `xml:"hostPort"`
	GuestPort      int32  `xml:"guestPort"`
	GuestIpAddress string `xml:"guestIpAddress"`
}

func init() {
	t["HostNatServicePortForwardSpec"] = reflect.TypeOf((*HostNatServicePortForwardSpec)(nil)).Elem()
}

type HostNatServiceSpec struct {
	DynamicData

	VirtualSwitch    string                          `xml:"virtualSwitch"`
	ActiveFtp        bool                            `xml:"activeFtp"`
	AllowAnyOui      bool                            `xml:"allowAnyOui"`
	ConfigPort       bool                            `xml:"configPort"`
	IpGatewayAddress string                          `xml:"ipGatewayAddress"`
	UdpTimeout       int32                           `xml:"udpTimeout"`
	PortForward      []HostNatServicePortForwardSpec `xml:"portForward,omitempty"`
	NameService      *HostNatServiceNameServiceSpec  `xml:"nameService,omitempty"`
}

func init() {
	t["HostNatServiceSpec"] = reflect.TypeOf((*HostNatServiceSpec)(nil)).Elem()
}

type HostNetCapabilities struct {
	DynamicData

	CanSetPhysicalNicLinkSpeed bool     `xml:"canSetPhysicalNicLinkSpeed"`
	SupportsNicTeaming         bool     `xml:"supportsNicTeaming"`
	NicTeamingPolicy           []string `xml:"nicTeamingPolicy,omitempty"`
	SupportsVlan               bool     `xml:"supportsVlan"`
	UsesServiceConsoleNic      bool     `xml:"usesServiceConsoleNic"`
	SupportsNetworkHints       bool     `xml:"supportsNetworkHints"`
	MaxPortGroupsPerVswitch    int32    `xml:"maxPortGroupsPerVswitch,omitempty"`
	VswitchConfigSupported     bool     `xml:"vswitchConfigSupported"`
	VnicConfigSupported        bool     `xml:"vnicConfigSupported"`
	IpRouteConfigSupported     bool     `xml:"ipRouteConfigSupported"`
	DnsConfigSupported         bool     `xml:"dnsConfigSupported"`
	DhcpOnVnicSupported        bool     `xml:"dhcpOnVnicSupported"`
	IpV6Supported              *bool    `xml:"ipV6Supported"`
	BackupNfcNiocSupported     *bool    `xml:"backupNfcNiocSupported"`
}

func init() {
	t["HostNetCapabilities"] = reflect.TypeOf((*HostNetCapabilities)(nil)).Elem()
}

type HostNetOffloadCapabilities struct {
	DynamicData

	CsumOffload     *bool `xml:"csumOffload"`
	TcpSegmentation *bool `xml:"tcpSegmentation"`
	ZeroCopyXmit    *bool `xml:"zeroCopyXmit"`
}

func init() {
	t["HostNetOffloadCapabilities"] = reflect.TypeOf((*HostNetOffloadCapabilities)(nil)).Elem()
}

type HostNetStackInstance struct {
	DynamicData

	Key                             string                  `xml:"key,omitempty"`
	Name                            string                  `xml:"name,omitempty"`
	DnsConfig                       BaseHostDnsConfig       `xml:"dnsConfig,omitempty,typeattr"`
	IpRouteConfig                   BaseHostIpRouteConfig   `xml:"ipRouteConfig,omitempty,typeattr"`
	RequestedMaxNumberOfConnections int32                   `xml:"requestedMaxNumberOfConnections,omitempty"`
	CongestionControlAlgorithm      string                  `xml:"congestionControlAlgorithm,omitempty"`
	IpV6Enabled                     *bool                   `xml:"ipV6Enabled"`
	RouteTableConfig                *HostIpRouteTableConfig `xml:"routeTableConfig,omitempty"`
}

func init() {
	t["HostNetStackInstance"] = reflect.TypeOf((*HostNetStackInstance)(nil)).Elem()
}

type HostNetworkConfig struct {
	DynamicData

	Vswitch              []HostVirtualSwitchConfig       `xml:"vswitch,omitempty"`
	ProxySwitch          []HostProxySwitchConfig         `xml:"proxySwitch,omitempty"`
	Portgroup            []HostPortGroupConfig           `xml:"portgroup,omitempty"`
	Pnic                 []PhysicalNicConfig             `xml:"pnic,omitempty"`
	Vnic                 []HostVirtualNicConfig          `xml:"vnic,omitempty"`
	ConsoleVnic          []HostVirtualNicConfig          `xml:"consoleVnic,omitempty"`
	DnsConfig            BaseHostDnsConfig               `xml:"dnsConfig,omitempty,typeattr"`
	IpRouteConfig        BaseHostIpRouteConfig           `xml:"ipRouteConfig,omitempty,typeattr"`
	ConsoleIpRouteConfig BaseHostIpRouteConfig           `xml:"consoleIpRouteConfig,omitempty,typeattr"`
	RouteTableConfig     *HostIpRouteTableConfig         `xml:"routeTableConfig,omitempty"`
	Dhcp                 []HostDhcpServiceConfig         `xml:"dhcp,omitempty"`
	Nat                  []HostNatServiceConfig          `xml:"nat,omitempty"`
	IpV6Enabled          *bool                           `xml:"ipV6Enabled"`
	NetStackSpec         []HostNetworkConfigNetStackSpec `xml:"netStackSpec,omitempty"`
	MigrationStatus      string                          `xml:"migrationStatus,omitempty"`
}

func init() {
	t["HostNetworkConfig"] = reflect.TypeOf((*HostNetworkConfig)(nil)).Elem()
}

type HostNetworkConfigNetStackSpec struct {
	DynamicData

	NetStackInstance HostNetStackInstance `xml:"netStackInstance"`
	Operation        string               `xml:"operation,omitempty"`
}

func init() {
	t["HostNetworkConfigNetStackSpec"] = reflect.TypeOf((*HostNetworkConfigNetStackSpec)(nil)).Elem()
}

type HostNetworkConfigResult struct {
	DynamicData

	VnicDevice        []string `xml:"vnicDevice,omitempty"`
	ConsoleVnicDevice []string `xml:"consoleVnicDevice,omitempty"`
}

func init() {
	t["HostNetworkConfigResult"] = reflect.TypeOf((*HostNetworkConfigResult)(nil)).Elem()
}

type HostNetworkInfo struct {
	DynamicData

	Vswitch                    []HostVirtualSwitch     `xml:"vswitch,omitempty"`
	ProxySwitch                []HostProxySwitch       `xml:"proxySwitch,omitempty"`
	Portgroup                  []HostPortGroup         `xml:"portgroup,omitempty"`
	Pnic                       []PhysicalNic           `xml:"pnic,omitempty"`
	RdmaDevice                 []HostRdmaDevice        `xml:"rdmaDevice,omitempty"`
	Vnic                       []HostVirtualNic        `xml:"vnic,omitempty"`
	ConsoleVnic                []HostVirtualNic        `xml:"consoleVnic,omitempty"`
	DnsConfig                  BaseHostDnsConfig       `xml:"dnsConfig,omitempty,typeattr"`
	IpRouteConfig              BaseHostIpRouteConfig   `xml:"ipRouteConfig,omitempty,typeattr"`
	ConsoleIpRouteConfig       BaseHostIpRouteConfig   `xml:"consoleIpRouteConfig,omitempty,typeattr"`
	RouteTableInfo             *HostIpRouteTableInfo   `xml:"routeTableInfo,omitempty"`
	Dhcp                       []HostDhcpService       `xml:"dhcp,omitempty"`
	Nat                        []HostNatService        `xml:"nat,omitempty"`
	IpV6Enabled                *bool                   `xml:"ipV6Enabled"`
	AtBootIpV6Enabled          *bool                   `xml:"atBootIpV6Enabled"`
	NetStackInstance           []HostNetStackInstance  `xml:"netStackInstance,omitempty"`
	OpaqueSwitch               []HostOpaqueSwitch      `xml:"opaqueSwitch,omitempty"`
	OpaqueNetwork              []HostOpaqueNetworkInfo `xml:"opaqueNetwork,omitempty"`
	NsxTransportNodeId         string                  `xml:"nsxTransportNodeId,omitempty"`
	NvdsToVdsMigrationRequired *bool                   `xml:"nvdsToVdsMigrationRequired"`
	MigrationStatus            string                  `xml:"migrationStatus,omitempty"`
}

func init() {
	t["HostNetworkInfo"] = reflect.TypeOf((*HostNetworkInfo)(nil)).Elem()
}

type HostNetworkPolicy struct {
	DynamicData

	Security      *HostNetworkSecurityPolicy       `xml:"security,omitempty"`
	NicTeaming    *HostNicTeamingPolicy            `xml:"nicTeaming,omitempty"`
	OffloadPolicy *HostNetOffloadCapabilities      `xml:"offloadPolicy,omitempty"`
	ShapingPolicy *HostNetworkTrafficShapingPolicy `xml:"shapingPolicy,omitempty"`
}

func init() {
	t["HostNetworkPolicy"] = reflect.TypeOf((*HostNetworkPolicy)(nil)).Elem()
}

type HostNetworkResourceRuntime struct {
	DynamicData

	PnicResourceInfo []HostPnicNetworkResourceInfo `xml:"pnicResourceInfo"`
}

func init() {
	t["HostNetworkResourceRuntime"] = reflect.TypeOf((*HostNetworkResourceRuntime)(nil)).Elem()
}

type HostNetworkSecurityPolicy struct {
	DynamicData

	AllowPromiscuous *bool `xml:"allowPromiscuous"`
	MacChanges       *bool `xml:"macChanges"`
	ForgedTransmits  *bool `xml:"forgedTransmits"`
}

func init() {
	t["HostNetworkSecurityPolicy"] = reflect.TypeOf((*HostNetworkSecurityPolicy)(nil)).Elem()
}

type HostNetworkTrafficShapingPolicy struct {
	DynamicData

	Enabled          *bool `xml:"enabled"`
	AverageBandwidth int64 `xml:"averageBandwidth,omitempty"`
	PeakBandwidth    int64 `xml:"peakBandwidth,omitempty"`
	BurstSize        int64 `xml:"burstSize,omitempty"`
}

func init() {
	t["HostNetworkTrafficShapingPolicy"] = reflect.TypeOf((*HostNetworkTrafficShapingPolicy)(nil)).Elem()
}

type HostNewNetworkConnectInfo struct {
	HostConnectInfoNetworkInfo
}

func init() {
	t["HostNewNetworkConnectInfo"] = reflect.TypeOf((*HostNewNetworkConnectInfo)(nil)).Elem()
}

type HostNfcConnectionInfo struct {
	HostDataTransportConnectionInfo

	StreamingMemoryConsumed int64 `xml:"streamingMemoryConsumed,omitempty"`
}

func init() {
	t["HostNfcConnectionInfo"] = reflect.TypeOf((*HostNfcConnectionInfo)(nil)).Elem()
}

type HostNicFailureCriteria struct {
	DynamicData

	CheckSpeed        string `xml:"checkSpeed,omitempty"`
	Speed             int32  `xml:"speed,omitempty"`
	CheckDuplex       *bool  `xml:"checkDuplex"`
	FullDuplex        *bool  `xml:"fullDuplex"`
	CheckErrorPercent *bool  `xml:"checkErrorPercent"`
	Percentage        int32  `xml:"percentage,omitempty"`
	CheckBeacon       *bool  `xml:"checkBeacon"`
}

func init() {
	t["HostNicFailureCriteria"] = reflect.TypeOf((*HostNicFailureCriteria)(nil)).Elem()
}

type HostNicOrderPolicy struct {
	DynamicData

	ActiveNic  []string `xml:"activeNic,omitempty"`
	StandbyNic []string `xml:"standbyNic,omitempty"`
}

func init() {
	t["HostNicOrderPolicy"] = reflect.TypeOf((*HostNicOrderPolicy)(nil)).Elem()
}

type HostNicTeamingPolicy struct {
	DynamicData

	Policy          string                  `xml:"policy,omitempty"`
	ReversePolicy   *bool                   `xml:"reversePolicy"`
	NotifySwitches  *bool                   `xml:"notifySwitches"`
	RollingOrder    *bool                   `xml:"rollingOrder"`
	FailureCriteria *HostNicFailureCriteria `xml:"failureCriteria,omitempty"`
	NicOrder        *HostNicOrderPolicy     `xml:"nicOrder,omitempty"`
}

func init() {
	t["HostNicTeamingPolicy"] = reflect.TypeOf((*HostNicTeamingPolicy)(nil)).Elem()
}

type HostNoAvailableNetworksEvent struct {
	HostDasEvent

	Ips string `xml:"ips,omitempty"`
}

func init() {
	t["HostNoAvailableNetworksEvent"] = reflect.TypeOf((*HostNoAvailableNetworksEvent)(nil)).Elem()
}

type HostNoHAEnabledPortGroupsEvent struct {
	HostDasEvent
}

func init() {
	t["HostNoHAEnabledPortGroupsEvent"] = reflect.TypeOf((*HostNoHAEnabledPortGroupsEvent)(nil)).Elem()
}

type HostNoRedundantManagementNetworkEvent struct {
	HostDasEvent
}

func init() {
	t["HostNoRedundantManagementNetworkEvent"] = reflect.TypeOf((*HostNoRedundantManagementNetworkEvent)(nil)).Elem()
}

type HostNonCompliantEvent struct {
	HostEvent
}

func init() {
	t["HostNonCompliantEvent"] = reflect.TypeOf((*HostNonCompliantEvent)(nil)).Elem()
}

type HostNotConnected struct {
	HostCommunication
}

func init() {
	t["HostNotConnected"] = reflect.TypeOf((*HostNotConnected)(nil)).Elem()
}

type HostNotConnectedFault HostNotConnected

func init() {
	t["HostNotConnectedFault"] = reflect.TypeOf((*HostNotConnectedFault)(nil)).Elem()
}

type HostNotInClusterEvent struct {
	HostDasEvent
}

func init() {
	t["HostNotInClusterEvent"] = reflect.TypeOf((*HostNotInClusterEvent)(nil)).Elem()
}

type HostNotReachable struct {
	HostCommunication
}

func init() {
	t["HostNotReachable"] = reflect.TypeOf((*HostNotReachable)(nil)).Elem()
}

type HostNotReachableFault HostNotReachable

func init() {
	t["HostNotReachableFault"] = reflect.TypeOf((*HostNotReachableFault)(nil)).Elem()
}

type HostNtpConfig struct {
	DynamicData

	Server     []string `xml:"server,omitempty"`
	ConfigFile []string `xml:"configFile,omitempty"`
}

func init() {
	t["HostNtpConfig"] = reflect.TypeOf((*HostNtpConfig)(nil)).Elem()
}

type HostNumaInfo struct {
	DynamicData

	Type     string         `xml:"type"`
	NumNodes int32          `xml:"numNodes"`
	NumaNode []HostNumaNode `xml:"numaNode,omitempty"`
}

func init() {
	t["HostNumaInfo"] = reflect.TypeOf((*HostNumaInfo)(nil)).Elem()
}

type HostNumaNode struct {
	DynamicData

	TypeId            byte     `xml:"typeId"`
	CpuID             []int16  `xml:"cpuID"`
	MemoryRangeBegin  int64    `xml:"memoryRangeBegin"`
	MemoryRangeLength int64    `xml:"memoryRangeLength"`
	PciId             []string `xml:"pciId,omitempty"`
}

func init() {
	t["HostNumaNode"] = reflect.TypeOf((*HostNumaNode)(nil)).Elem()
}

type HostNumericSensorInfo struct {
	DynamicData

	Name           string                 `xml:"name"`
	HealthState    BaseElementDescription `xml:"healthState,omitempty,typeattr"`
	CurrentReading int64                  `xml:"currentReading"`
	UnitModifier   int32                  `xml:"unitModifier"`
	BaseUnits      string                 `xml:"baseUnits"`
	RateUnits      string                 `xml:"rateUnits,omitempty"`
	SensorType     string                 `xml:"sensorType"`
	Id             string                 `xml:"id,omitempty"`
	TimeStamp      string                 `xml:"timeStamp,omitempty"`
}

func init() {
	t["HostNumericSensorInfo"] = reflect.TypeOf((*HostNumericSensorInfo)(nil)).Elem()
}

type HostNvmeConnectSpec struct {
	HostNvmeSpec

	Subnqn           string `xml:"subnqn"`
	ControllerId     int32  `xml:"controllerId,omitempty"`
	AdminQueueSize   int32  `xml:"adminQueueSize,omitempty"`
	KeepAliveTimeout int32  `xml:"keepAliveTimeout,omitempty"`
}

func init() {
	t["HostNvmeConnectSpec"] = reflect.TypeOf((*HostNvmeConnectSpec)(nil)).Elem()
}

type HostNvmeController struct {
	DynamicData

	Key                     string              `xml:"key"`
	ControllerNumber        int32               `xml:"controllerNumber"`
	Subnqn                  string              `xml:"subnqn"`
	Name                    string              `xml:"name"`
	AssociatedAdapter       string              `xml:"associatedAdapter"`
	TransportType           string              `xml:"transportType"`
	FusedOperationSupported bool                `xml:"fusedOperationSupported"`
	NumberOfQueues          int32               `xml:"numberOfQueues"`
	QueueSize               int32               `xml:"queueSize"`
	AttachedNamespace       []HostNvmeNamespace `xml:"attachedNamespace,omitempty"`
	VendorId                string              `xml:"vendorId,omitempty"`
	Model                   string              `xml:"model,omitempty"`
	SerialNumber            string              `xml:"serialNumber,omitempty"`
	FirmwareVersion         string              `xml:"firmwareVersion,omitempty"`
}

func init() {
	t["HostNvmeController"] = reflect.TypeOf((*HostNvmeController)(nil)).Elem()
}

type HostNvmeDisconnectSpec struct {
	DynamicData

	HbaName          string `xml:"hbaName"`
	Subnqn           string `xml:"subnqn,omitempty"`
	ControllerNumber int32  `xml:"controllerNumber,omitempty"`
}

func init() {
	t["HostNvmeDisconnectSpec"] = reflect.TypeOf((*HostNvmeDisconnectSpec)(nil)).Elem()
}

type HostNvmeDiscoverSpec struct {
	HostNvmeSpec

	AutoConnect             *bool `xml:"autoConnect"`
	RootDiscoveryController *bool `xml:"rootDiscoveryController"`
}

func init() {
	t["HostNvmeDiscoverSpec"] = reflect.TypeOf((*HostNvmeDiscoverSpec)(nil)).Elem()
}

type HostNvmeDiscoveryLog struct {
	DynamicData

	Entry    []HostNvmeDiscoveryLogEntry `xml:"entry,omitempty"`
	Complete bool                        `xml:"complete"`
}

func init() {
	t["HostNvmeDiscoveryLog"] = reflect.TypeOf((*HostNvmeDiscoveryLog)(nil)).Elem()
}

type HostNvmeDiscoveryLogEntry struct {
	DynamicData

	Subnqn                string                          `xml:"subnqn"`
	SubsystemType         string                          `xml:"subsystemType"`
	SubsystemPortId       int32                           `xml:"subsystemPortId"`
	ControllerId          int32                           `xml:"controllerId"`
	AdminQueueMaxSize     int32                           `xml:"adminQueueMaxSize"`
	TransportParameters   BaseHostNvmeTransportParameters `xml:"transportParameters,typeattr"`
	TransportRequirements string                          `xml:"transportRequirements"`
	Connected             bool                            `xml:"connected"`
}

func init() {
	t["HostNvmeDiscoveryLogEntry"] = reflect.TypeOf((*HostNvmeDiscoveryLogEntry)(nil)).Elem()
}

type HostNvmeNamespace struct {
	DynamicData

	Key              string `xml:"key"`
	Name             string `xml:"name"`
	Id               int32  `xml:"id"`
	BlockSize        int32  `xml:"blockSize"`
	CapacityInBlocks int64  `xml:"capacityInBlocks"`
}

func init() {
	t["HostNvmeNamespace"] = reflect.TypeOf((*HostNvmeNamespace)(nil)).Elem()
}

type HostNvmeOpaqueTransportParameters struct {
	HostNvmeTransportParameters

	Trtype  string `xml:"trtype"`
	Traddr  string `xml:"traddr"`
	Adrfam  string `xml:"adrfam"`
	Trsvcid string `xml:"trsvcid"`
	Tsas    []byte `xml:"tsas"`
}

func init() {
	t["HostNvmeOpaqueTransportParameters"] = reflect.TypeOf((*HostNvmeOpaqueTransportParameters)(nil)).Elem()
}

type HostNvmeOverFibreChannelParameters struct {
	HostNvmeTransportParameters

	NodeWorldWideName int64 `xml:"nodeWorldWideName"`
	PortWorldWideName int64 `xml:"portWorldWideName"`
}

func init() {
	t["HostNvmeOverFibreChannelParameters"] = reflect.TypeOf((*HostNvmeOverFibreChannelParameters)(nil)).Elem()
}

type HostNvmeOverRdmaParameters struct {
	HostNvmeTransportParameters

	Address       string `xml:"address"`
	AddressFamily string `xml:"addressFamily,omitempty"`
	PortNumber    int32  `xml:"portNumber,omitempty"`
}

func init() {
	t["HostNvmeOverRdmaParameters"] = reflect.TypeOf((*HostNvmeOverRdmaParameters)(nil)).Elem()
}

type HostNvmeOverTcpParameters struct {
	HostNvmeTransportParameters

	Address            string `xml:"address"`
	PortNumber         int32  `xml:"portNumber,omitempty"`
	DigestVerification string `xml:"digestVerification,omitempty"`
}

func init() {
	t["HostNvmeOverTcpParameters"] = reflect.TypeOf((*HostNvmeOverTcpParameters)(nil)).Elem()
}

type HostNvmeSpec struct {
	DynamicData

	HbaName             string                          `xml:"hbaName"`
	TransportParameters BaseHostNvmeTransportParameters `xml:"transportParameters,typeattr"`
}

func init() {
	t["HostNvmeSpec"] = reflect.TypeOf((*HostNvmeSpec)(nil)).Elem()
}

type HostNvmeTopology struct {
	DynamicData

	Adapter []HostNvmeTopologyInterface `xml:"adapter,omitempty"`
}

func init() {
	t["HostNvmeTopology"] = reflect.TypeOf((*HostNvmeTopology)(nil)).Elem()
}

type HostNvmeTopologyInterface struct {
	DynamicData

	Key                 string               `xml:"key"`
	Adapter             string               `xml:"adapter"`
	ConnectedController []HostNvmeController `xml:"connectedController,omitempty"`
}

func init() {
	t["HostNvmeTopologyInterface"] = reflect.TypeOf((*HostNvmeTopologyInterface)(nil)).Elem()
}

type HostNvmeTransportParameters struct {
	DynamicData
}

func init() {
	t["HostNvmeTransportParameters"] = reflect.TypeOf((*HostNvmeTransportParameters)(nil)).Elem()
}

type HostOpaqueNetworkInfo struct {
	DynamicData

	OpaqueNetworkId   string                   `xml:"opaqueNetworkId"`
	OpaqueNetworkName string                   `xml:"opaqueNetworkName"`
	OpaqueNetworkType string                   `xml:"opaqueNetworkType"`
	PnicZone          []string                 `xml:"pnicZone,omitempty"`
	Capability        *OpaqueNetworkCapability `xml:"capability,omitempty"`
	ExtraConfig       []BaseOptionValue        `xml:"extraConfig,omitempty,typeattr"`
}

func init() {
	t["HostOpaqueNetworkInfo"] = reflect.TypeOf((*HostOpaqueNetworkInfo)(nil)).Elem()
}

type HostOpaqueSwitch struct {
	DynamicData

	Key               string                            `xml:"key"`
	Name              string                            `xml:"name,omitempty"`
	Pnic              []string                          `xml:"pnic,omitempty"`
	PnicZone          []HostOpaqueSwitchPhysicalNicZone `xml:"pnicZone,omitempty"`
	Status            string                            `xml:"status,omitempty"`
	Vtep              []HostVirtualNic                  `xml:"vtep,omitempty"`
	ExtraConfig       []BaseOptionValue                 `xml:"extraConfig,omitempty,typeattr"`
	FeatureCapability []HostFeatureCapability           `xml:"featureCapability,omitempty"`
}

func init() {
	t["HostOpaqueSwitch"] = reflect.TypeOf((*HostOpaqueSwitch)(nil)).Elem()
}

type HostOpaqueSwitchPhysicalNicZone struct {
	DynamicData

	Key        string   `xml:"key"`
	PnicDevice []string `xml:"pnicDevice,omitempty"`
}

func init() {
	t["HostOpaqueSwitchPhysicalNicZone"] = reflect.TypeOf((*HostOpaqueSwitchPhysicalNicZone)(nil)).Elem()
}

type HostOvercommittedEvent struct {
	ClusterOvercommittedEvent
}

func init() {
	t["HostOvercommittedEvent"] = reflect.TypeOf((*HostOvercommittedEvent)(nil)).Elem()
}

type HostPMemVolume struct {
	HostFileSystemVolume

	Uuid    string `xml:"uuid"`
	Version string `xml:"version"`
}

func init() {
	t["HostPMemVolume"] = reflect.TypeOf((*HostPMemVolume)(nil)).Elem()
}

type HostParallelScsiHba struct {
	HostHostBusAdapter
}

func init() {
	t["HostParallelScsiHba"] = reflect.TypeOf((*HostParallelScsiHba)(nil)).Elem()
}

type HostParallelScsiTargetTransport struct {
	HostTargetTransport
}

func init() {
	t["HostParallelScsiTargetTransport"] = reflect.TypeOf((*HostParallelScsiTargetTransport)(nil)).Elem()
}

type HostPatchManagerLocator struct {
	DynamicData

	Url   string `xml:"url"`
	Proxy string `xml:"proxy,omitempty"`
}

func init() {
	t["HostPatchManagerLocator"] = reflect.TypeOf((*HostPatchManagerLocator)(nil)).Elem()
}

type HostPatchManagerPatchManagerOperationSpec struct {
	DynamicData

	Proxy     string `xml:"proxy,omitempty"`
	Port      int32  `xml:"port,omitempty"`
	UserName  string `xml:"userName,omitempty"`
	Password  string `xml:"password,omitempty"`
	CmdOption string `xml:"cmdOption,omitempty"`
}

func init() {
	t["HostPatchManagerPatchManagerOperationSpec"] = reflect.TypeOf((*HostPatchManagerPatchManagerOperationSpec)(nil)).Elem()
}

type HostPatchManagerResult struct {
	DynamicData

	Version   string                   `xml:"version"`
	Status    []HostPatchManagerStatus `xml:"status,omitempty"`
	XmlResult string                   `xml:"xmlResult,omitempty"`
}

func init() {
	t["HostPatchManagerResult"] = reflect.TypeOf((*HostPatchManagerResult)(nil)).Elem()
}

type HostPatchManagerStatus struct {
	DynamicData

	Id                 string                                    `xml:"id"`
	Applicable         bool                                      `xml:"applicable"`
	Reason             []string                                  `xml:"reason,omitempty"`
	Integrity          string                                    `xml:"integrity,omitempty"`
	Installed          bool                                      `xml:"installed"`
	InstallState       []string                                  `xml:"installState,omitempty"`
	PrerequisitePatch  []HostPatchManagerStatusPrerequisitePatch `xml:"prerequisitePatch,omitempty"`
	RestartRequired    bool                                      `xml:"restartRequired"`
	ReconnectRequired  bool                                      `xml:"reconnectRequired"`
	VmOffRequired      bool                                      `xml:"vmOffRequired"`
	SupersededPatchIds []string                                  `xml:"supersededPatchIds,omitempty"`
}

func init() {
	t["HostPatchManagerStatus"] = reflect.TypeOf((*HostPatchManagerStatus)(nil)).Elem()
}

type HostPatchManagerStatusPrerequisitePatch struct {
	DynamicData

	Id           string   `xml:"id"`
	InstallState []string `xml:"installState,omitempty"`
}

func init() {
	t["HostPatchManagerStatusPrerequisitePatch"] = reflect.TypeOf((*HostPatchManagerStatusPrerequisitePatch)(nil)).Elem()
}

type HostPathSelectionPolicyOption struct {
	DynamicData

	Policy BaseElementDescription `xml:"policy,typeattr"`
}

func init() {
	t["HostPathSelectionPolicyOption"] = reflect.TypeOf((*HostPathSelectionPolicyOption)(nil)).Elem()
}

type HostPciDevice struct {
	DynamicData

	Id           string `xml:"id"`
	ClassId      int16  `xml:"classId"`
	Bus          byte   `xml:"bus"`
	Slot         byte   `xml:"slot"`
	Function     byte   `xml:"function"`
	VendorId     int16  `xml:"vendorId"`
	SubVendorId  int16  `xml:"subVendorId"`
	VendorName   string `xml:"vendorName"`
	DeviceId     int16  `xml:"deviceId"`
	SubDeviceId  int16  `xml:"subDeviceId"`
	ParentBridge string `xml:"parentBridge,omitempty"`
	DeviceName   string `xml:"deviceName"`
}

func init() {
	t["HostPciDevice"] = reflect.TypeOf((*HostPciDevice)(nil)).Elem()
}

type HostPciPassthruConfig struct {
	DynamicData

	Id              string `xml:"id"`
	PassthruEnabled bool   `xml:"passthruEnabled"`
	ApplyNow        *bool  `xml:"applyNow"`
	HardwareLabel   string `xml:"hardwareLabel,omitempty"`
}

func init() {
	t["HostPciPassthruConfig"] = reflect.TypeOf((*HostPciPassthruConfig)(nil)).Elem()
}

type HostPciPassthruInfo struct {
	DynamicData

	Id              string `xml:"id"`
	DependentDevice string `xml:"dependentDevice"`
	PassthruEnabled bool   `xml:"passthruEnabled"`
	PassthruCapable bool   `xml:"passthruCapable"`
	PassthruActive  bool   `xml:"passthruActive"`
	HardwareLabel   string `xml:"hardwareLabel,omitempty"`
}

func init() {
	t["HostPciPassthruInfo"] = reflect.TypeOf((*HostPciPassthruInfo)(nil)).Elem()
}

type HostPcieHba struct {
	HostHostBusAdapter
}

func init() {
	t["HostPcieHba"] = reflect.TypeOf((*HostPcieHba)(nil)).Elem()
}

type HostPcieTargetTransport struct {
	HostTargetTransport
}

func init() {
	t["HostPcieTargetTransport"] = reflect.TypeOf((*HostPcieTargetTransport)(nil)).Elem()
}

type HostPersistentMemoryInfo struct {
	DynamicData

	CapacityInMB int64  `xml:"capacityInMB,omitempty"`
	VolumeUUID   string `xml:"volumeUUID,omitempty"`
}

func init() {
	t["HostPersistentMemoryInfo"] = reflect.TypeOf((*HostPersistentMemoryInfo)(nil)).Elem()
}

type HostPlacedVirtualNicIdentifier struct {
	DynamicData

	Vm          ManagedObjectReference `xml:"vm"`
	VnicKey     string                 `xml:"vnicKey"`
	Reservation *int32                 `xml:"reservation"`
}

func init() {
	t["HostPlacedVirtualNicIdentifier"] = reflect.TypeOf((*HostPlacedVirtualNicIdentifier)(nil)).Elem()
}

type HostPlugStoreTopology struct {
	DynamicData

	Adapter []HostPlugStoreTopologyAdapter `xml:"adapter,omitempty"`
	Path    []HostPlugStoreTopologyPath    `xml:"path,omitempty"`
	Target  []HostPlugStoreTopologyTarget  `xml:"target,omitempty"`
	Device  []HostPlugStoreTopologyDevice  `xml:"device,omitempty"`
	Plugin  []HostPlugStoreTopologyPlugin  `xml:"plugin,omitempty"`
}

func init() {
	t["HostPlugStoreTopology"] = reflect.TypeOf((*HostPlugStoreTopology)(nil)).Elem()
}

type HostPlugStoreTopologyAdapter struct {
	DynamicData

	Key     string   `xml:"key"`
	Adapter string   `xml:"adapter"`
	Path    []string `xml:"path,omitempty"`
}

func init() {
	t["HostPlugStoreTopologyAdapter"] = reflect.TypeOf((*HostPlugStoreTopologyAdapter)(nil)).Elem()
}

type HostPlugStoreTopologyDevice struct {
	DynamicData

	Key  string   `xml:"key"`
	Lun  string   `xml:"lun"`
	Path []string `xml:"path,omitempty"`
}

func init() {
	t["HostPlugStoreTopologyDevice"] = reflect.TypeOf((*HostPlugStoreTopologyDevice)(nil)).Elem()
}

type HostPlugStoreTopologyPath struct {
	DynamicData

	Key           string `xml:"key"`
	Name          string `xml:"name"`
	ChannelNumber int32  `xml:"channelNumber,omitempty"`
	TargetNumber  int32  `xml:"targetNumber,omitempty"`
	LunNumber     int32  `xml:"lunNumber,omitempty"`
	Adapter       string `xml:"adapter,omitempty"`
	Target        string `xml:"target,omitempty"`
	Device        string `xml:"device,omitempty"`
}

func init() {
	t["HostPlugStoreTopologyPath"] = reflect.TypeOf((*HostPlugStoreTopologyPath)(nil)).Elem()
}

type HostPlugStoreTopologyPlugin struct {
	DynamicData

	Key         string   `xml:"key"`
	Name        string   `xml:"name"`
	Device      []string `xml:"device,omitempty"`
	ClaimedPath []string `xml:"claimedPath,omitempty"`
}

func init() {
	t["HostPlugStoreTopologyPlugin"] = reflect.TypeOf((*HostPlugStoreTopologyPlugin)(nil)).Elem()
}

type HostPlugStoreTopologyTarget struct {
	DynamicData

	Key       string                  `xml:"key"`
	Transport BaseHostTargetTransport `xml:"transport,omitempty,typeattr"`
}

func init() {
	t["HostPlugStoreTopologyTarget"] = reflect.TypeOf((*HostPlugStoreTopologyTarget)(nil)).Elem()
}

type HostPnicNetworkResourceInfo struct {
	DynamicData

	PnicDevice                     string                           `xml:"pnicDevice"`
	AvailableBandwidthForVMTraffic int64                            `xml:"availableBandwidthForVMTraffic,omitempty"`
	UnusedBandwidthForVMTraffic    int64                            `xml:"unusedBandwidthForVMTraffic,omitempty"`
	PlacedVirtualNics              []HostPlacedVirtualNicIdentifier `xml:"placedVirtualNics,omitempty"`
}

func init() {
	t["HostPnicNetworkResourceInfo"] = reflect.TypeOf((*HostPnicNetworkResourceInfo)(nil)).Elem()
}

type HostPortGroup struct {
	DynamicData

	Key            string              `xml:"key,omitempty"`
	Port           []HostPortGroupPort `xml:"port,omitempty"`
	Vswitch        string              `xml:"vswitch,omitempty"`
	ComputedPolicy HostNetworkPolicy   `xml:"computedPolicy"`
	Spec           HostPortGroupSpec   `xml:"spec"`
}

func init() {
	t["HostPortGroup"] = reflect.TypeOf((*HostPortGroup)(nil)).Elem()
}

type HostPortGroupConfig struct {
	DynamicData

	ChangeOperation string             `xml:"changeOperation,omitempty"`
	Spec            *HostPortGroupSpec `xml:"spec,omitempty"`
}

func init() {
	t["HostPortGroupConfig"] = reflect.TypeOf((*HostPortGroupConfig)(nil)).Elem()
}

type HostPortGroupPort struct {
	DynamicData

	Key  string   `xml:"key,omitempty"`
	Mac  []string `xml:"mac,omitempty"`
	Type string   `xml:"type"`
}

func init() {
	t["HostPortGroupPort"] = reflect.TypeOf((*HostPortGroupPort)(nil)).Elem()
}

type HostPortGroupProfile struct {
	PortGroupProfile

	IpConfig IpAddressProfile `xml:"ipConfig"`
}

func init() {
	t["HostPortGroupProfile"] = reflect.TypeOf((*HostPortGroupProfile)(nil)).Elem()
}

type HostPortGroupSpec struct {
	DynamicData

	Name        string            `xml:"name"`
	VlanId      int32             `xml:"vlanId"`
	VswitchName string            `xml:"vswitchName"`
	Policy      HostNetworkPolicy `xml:"policy"`
}

func init() {
	t["HostPortGroupSpec"] = reflect.TypeOf((*HostPortGroupSpec)(nil)).Elem()
}

type HostPosixAccountSpec struct {
	HostAccountSpec

	PosixId     int32 `xml:"posixId,omitempty"`
	ShellAccess *bool `xml:"shellAccess"`
}

func init() {
	t["HostPosixAccountSpec"] = reflect.TypeOf((*HostPosixAccountSpec)(nil)).Elem()
}

type HostPowerOpFailed struct {
	VimFault
}

func init() {
	t["HostPowerOpFailed"] = reflect.TypeOf((*HostPowerOpFailed)(nil)).Elem()
}

type HostPowerOpFailedFault BaseHostPowerOpFailed

func init() {
	t["HostPowerOpFailedFault"] = reflect.TypeOf((*HostPowerOpFailedFault)(nil)).Elem()
}

type HostPowerPolicy struct {
	DynamicData

	Key         int32  `xml:"key"`
	Name        string `xml:"name"`
	ShortName   string `xml:"shortName"`
	Description string `xml:"description"`
}

func init() {
	t["HostPowerPolicy"] = reflect.TypeOf((*HostPowerPolicy)(nil)).Elem()
}

type HostPrimaryAgentNotShortNameEvent struct {
	HostDasEvent

	PrimaryAgent string `xml:"primaryAgent"`
}

func init() {
	t["HostPrimaryAgentNotShortNameEvent"] = reflect.TypeOf((*HostPrimaryAgentNotShortNameEvent)(nil)).Elem()
}

type HostProfileAppliedEvent struct {
	HostEvent

	Profile ProfileEventArgument `xml:"profile"`
}

func init() {
	t["HostProfileAppliedEvent"] = reflect.TypeOf((*HostProfileAppliedEvent)(nil)).Elem()
}

type HostProfileCompleteConfigSpec struct {
	HostProfileConfigSpec

	ApplyProfile                  *HostApplyProfile       `xml:"applyProfile,omitempty"`
	CustomComplyProfile           *ComplianceProfile      `xml:"customComplyProfile,omitempty"`
	DisabledExpressionListChanged bool                    `xml:"disabledExpressionListChanged"`
	DisabledExpressionList        []string                `xml:"disabledExpressionList,omitempty"`
	ValidatorHost                 *ManagedObjectReference `xml:"validatorHost,omitempty"`
	Validating                    *bool                   `xml:"validating"`
	HostConfig                    *HostProfileConfigInfo  `xml:"hostConfig,omitempty"`
}

func init() {
	t["HostProfileCompleteConfigSpec"] = reflect.TypeOf((*HostProfileCompleteConfigSpec)(nil)).Elem()
}

type HostProfileConfigInfo struct {
	ProfileConfigInfo

	ApplyProfile           *HostApplyProfile   `xml:"applyProfile,omitempty"`
	DefaultComplyProfile   *ComplianceProfile  `xml:"defaultComplyProfile,omitempty"`
	DefaultComplyLocator   []ComplianceLocator `xml:"defaultComplyLocator,omitempty"`
	CustomComplyProfile    *ComplianceProfile  `xml:"customComplyProfile,omitempty"`
	DisabledExpressionList []string            `xml:"disabledExpressionList,omitempty"`
	Description            *ProfileDescription `xml:"description,omitempty"`
}

func init() {
	t["HostProfileConfigInfo"] = reflect.TypeOf((*HostProfileConfigInfo)(nil)).Elem()
}

type HostProfileConfigSpec struct {
	ProfileCreateSpec
}

func init() {
	t["HostProfileConfigSpec"] = reflect.TypeOf((*HostProfileConfigSpec)(nil)).Elem()
}

type HostProfileHostBasedConfigSpec struct {
	HostProfileConfigSpec

	Host                 ManagedObjectReference `xml:"host"`
	UseHostProfileEngine *bool                  `xml:"useHostProfileEngine"`
}

func init() {
	t["HostProfileHostBasedConfigSpec"] = reflect.TypeOf((*HostProfileHostBasedConfigSpec)(nil)).Elem()
}

type HostProfileManagerCompositionResult struct {
	DynamicData

	Errors  []LocalizableMessage                               `xml:"errors,omitempty"`
	Results []HostProfileManagerCompositionResultResultElement `xml:"results,omitempty"`
}

func init() {
	t["HostProfileManagerCompositionResult"] = reflect.TypeOf((*HostProfileManagerCompositionResult)(nil)).Elem()
}

type HostProfileManagerCompositionResultResultElement struct {
	DynamicData

	Target ManagedObjectReference `xml:"target"`
	Status string                 `xml:"status"`
	Errors []LocalizableMessage   `xml:"errors,omitempty"`
}

func init() {
	t["HostProfileManagerCompositionResultResultElement"] = reflect.TypeOf((*HostProfileManagerCompositionResultResultElement)(nil)).Elem()
}

type HostProfileManagerCompositionValidationResult struct {
	DynamicData

	Results []HostProfileManagerCompositionValidationResultResultElement `xml:"results,omitempty"`
	Errors  []LocalizableMessage                                         `xml:"errors,omitempty"`
}

func init() {
	t["HostProfileManagerCompositionValidationResult"] = reflect.TypeOf((*HostProfileManagerCompositionValidationResult)(nil)).Elem()
}

type HostProfileManagerCompositionValidationResultResultElement struct {
	DynamicData

	Target                  ManagedObjectReference `xml:"target"`
	Status                  string                 `xml:"status"`
	Errors                  []LocalizableMessage   `xml:"errors,omitempty"`
	SourceDiffForToBeMerged *HostApplyProfile      `xml:"sourceDiffForToBeMerged,omitempty"`
	TargetDiffForToBeMerged *HostApplyProfile      `xml:"targetDiffForToBeMerged,omitempty"`
	ToBeAdded               *HostApplyProfile      `xml:"toBeAdded,omitempty"`
	ToBeDeleted             *HostApplyProfile      `xml:"toBeDeleted,omitempty"`
	ToBeDisabled            *HostApplyProfile      `xml:"toBeDisabled,omitempty"`
	ToBeEnabled             *HostApplyProfile      `xml:"toBeEnabled,omitempty"`
	ToBeReenableCC          *HostApplyProfile      `xml:"toBeReenableCC,omitempty"`
}

func init() {
	t["HostProfileManagerCompositionValidationResultResultElement"] = reflect.TypeOf((*HostProfileManagerCompositionValidationResultResultElement)(nil)).Elem()
}

type HostProfileManagerConfigTaskList struct {
	DynamicData

	ConfigSpec          *HostConfigSpec      `xml:"configSpec,omitempty"`
	TaskDescription     []LocalizableMessage `xml:"taskDescription,omitempty"`
	TaskListRequirement []string             `xml:"taskListRequirement,omitempty"`
}

func init() {
	t["HostProfileManagerConfigTaskList"] = reflect.TypeOf((*HostProfileManagerConfigTaskList)(nil)).Elem()
}

type HostProfileManagerHostToConfigSpecMap struct {
	DynamicData

	Host       ManagedObjectReference   `xml:"host"`
	ConfigSpec BaseAnswerFileCreateSpec `xml:"configSpec,typeattr"`
}

func init() {
	t["HostProfileManagerHostToConfigSpecMap"] = reflect.TypeOf((*HostProfileManagerHostToConfigSpecMap)(nil)).Elem()
}

type HostProfileResetValidationState HostProfileResetValidationStateRequestType

func init() {
	t["HostProfileResetValidationState"] = reflect.TypeOf((*HostProfileResetValidationState)(nil)).Elem()
}

type HostProfileResetValidationStateRequestType struct {
	This ManagedObjectReference `xml:"_this"`
}

func init() {
	t["HostProfileResetValidationStateRequestType"] = reflect.TypeOf((*HostProfileResetValidationStateRequestType)(nil)).Elem()
}

type HostProfileResetValidationStateResponse struct {
}

type HostProfileSerializedHostProfileSpec struct {
	ProfileSerializedCreateSpec

	ValidatorHost *ManagedObjectReference `xml:"validatorHost,omitempty"`
	Validating    *bool                   `xml:"validating"`
}

func init() {
	t["HostProfileSerializedHostProfileSpec"] = reflect.TypeOf((*HostProfileSerializedHostProfileSpec)(nil)).Elem()
}

type HostProfileValidationFailureInfo struct {
	DynamicData

	Name         string                             `xml:"name"`
	Annotation   string                             `xml:"annotation"`
	UpdateType   string                             `xml:"updateType"`
	Host         *ManagedObjectReference            `xml:"host,omitempty"`
	ApplyProfile *HostApplyProfile                  `xml:"applyProfile,omitempty"`
	Failures     []ProfileUpdateFailedUpdateFailure `xml:"failures,omitempty"`
	Faults       []LocalizedMethodFault             `xml:"faults,omitempty"`
}

func init() {
	t["HostProfileValidationFailureInfo"] = reflect.TypeOf((*HostProfileValidationFailureInfo)(nil)).Elem()
}

type HostProfilesEntityCustomizations struct {
	DynamicData
}

func init() {
	t["HostProfilesEntityCustomizations"] = reflect.TypeOf((*HostProfilesEntityCustomizations)(nil)).Elem()
}

type HostProtocolEndpoint struct {
	DynamicData

	PeType            string                   `xml:"peType"`
	Type              string                   `xml:"type,omitempty"`
	Uuid              string                   `xml:"uuid"`
	HostKey           []ManagedObjectReference `xml:"hostKey,omitempty"`
	StorageArray      string                   `xml:"storageArray,omitempty"`
	NfsServer         string                   `xml:"nfsServer,omitempty"`
	NfsDir            string                   `xml:"nfsDir,omitempty"`
	NfsServerScope    string                   `xml:"nfsServerScope,omitempty"`
	NfsServerMajor    string                   `xml:"nfsServerMajor,omitempty"`
	NfsServerAuthType string                   `xml:"nfsServerAuthType,omitempty"`
	NfsServerUser     string                   `xml:"nfsServerUser,omitempty"`
	DeviceId          string                   `xml:"deviceId,omitempty"`
}

func init() {
	t["HostProtocolEndpoint"] = reflect.TypeOf((*HostProtocolEndpoint)(nil)).Elem()
}

type HostProxySwitch struct {
	DynamicData

	DvsUuid                     string                                                `xml:"dvsUuid"`
	DvsName                     string                                                `xml:"dvsName"`
	Key                         string                                                `xml:"key"`
	NumPorts                    int32                                                 `xml:"numPorts"`
	ConfigNumPorts              int32                                                 `xml:"configNumPorts,omitempty"`
	NumPortsAvailable           int32                                                 `xml:"numPortsAvailable"`
	UplinkPort                  []KeyValue                                            `xml:"uplinkPort,omitempty"`
	Mtu                         int32                                                 `xml:"mtu,omitempty"`
	Pnic                        []string                                              `xml:"pnic,omitempty"`
	Spec                        HostProxySwitchSpec                                   `xml:"spec"`
	HostLag                     []HostProxySwitchHostLagConfig                        `xml:"hostLag,omitempty"`
	NetworkReservationSupported *bool                                                 `xml:"networkReservationSupported"`
	NsxtEnabled                 *bool                                                 `xml:"nsxtEnabled"`
	EnsEnabled                  *bool                                                 `xml:"ensEnabled"`
	EnsInterruptEnabled         *bool                                                 `xml:"ensInterruptEnabled"`
	TransportZones              []DistributedVirtualSwitchHostMemberTransportZoneInfo `xml:"transportZones,omitempty"`
	NsxUsedUplinkPort           []string                                              `xml:"nsxUsedUplinkPort,omitempty"`
	NsxtStatus                  string                                                `xml:"nsxtStatus,omitempty"`
	NsxtStatusDetail            string                                                `xml:"nsxtStatusDetail,omitempty"`
}

func init() {
	t["HostProxySwitch"] = reflect.TypeOf((*HostProxySwitch)(nil)).Elem()
}

type HostProxySwitchConfig struct {
	DynamicData

	ChangeOperation string               `xml:"changeOperation,omitempty"`
	Uuid            string               `xml:"uuid"`
	Spec            *HostProxySwitchSpec `xml:"spec,omitempty"`
}

func init() {
	t["HostProxySwitchConfig"] = reflect.TypeOf((*HostProxySwitchConfig)(nil)).Elem()
}

type HostProxySwitchHostLagConfig struct {
	DynamicData

	LagKey     string     `xml:"lagKey"`
	LagName    string     `xml:"lagName,omitempty"`
	UplinkPort []KeyValue `xml:"uplinkPort,omitempty"`
}

func init() {
	t["HostProxySwitchHostLagConfig"] = reflect.TypeOf((*HostProxySwitchHostLagConfig)(nil)).Elem()
}

type HostProxySwitchSpec struct {
	DynamicData

	Backing BaseDistributedVirtualSwitchHostMemberBacking `xml:"backing,omitempty,typeattr"`
}

func init() {
	t["HostProxySwitchSpec"] = reflect.TypeOf((*HostProxySwitchSpec)(nil)).Elem()
}

type HostPtpConfig struct {
	DynamicData

	Domain int32                  `xml:"domain,omitempty"`
	Port   []HostPtpConfigPtpPort `xml:"port,omitempty"`
}

func init() {
	t["HostPtpConfig"] = reflect.TypeOf((*HostPtpConfig)(nil)).Elem()
}

type HostPtpConfigPtpPort struct {
	DynamicData

	Index      int32         `xml:"index"`
	DeviceType string        `xml:"deviceType,omitempty"`
	Device     string        `xml:"device,omitempty"`
	IpConfig   *HostIpConfig `xml:"ipConfig,omitempty"`
}

func init() {
	t["HostPtpConfigPtpPort"] = reflect.TypeOf((*HostPtpConfigPtpPort)(nil)).Elem()
}

type HostQualifiedName struct {
	DynamicData

	Value string `xml:"value"`
	Type  string `xml:"type"`
}

func init() {
	t["HostQualifiedName"] = reflect.TypeOf((*HostQualifiedName)(nil)).Elem()
}

type HostRdmaDevice struct {
	DynamicData

	Key            string                       `xml:"key"`
	Device         string                       `xml:"device"`
	Driver         string                       `xml:"driver,omitempty"`
	Description    string                       `xml:"description,omitempty"`
	Backing        BaseHostRdmaDeviceBacking    `xml:"backing,omitempty,typeattr"`
	ConnectionInfo HostRdmaDeviceConnectionInfo `xml:"connectionInfo"`
	Capability     HostRdmaDeviceCapability     `xml:"capability"`
}

func init() {
	t["HostRdmaDevice"] = reflect.TypeOf((*HostRdmaDevice)(nil)).Elem()
}

type HostRdmaDeviceBacking struct {
	DynamicData
}

func init() {
	t["HostRdmaDeviceBacking"] = reflect.TypeOf((*HostRdmaDeviceBacking)(nil)).Elem()
}

type HostRdmaDeviceCapability struct {
	DynamicData

	RoceV1Capable bool `xml:"roceV1Capable"`
	RoceV2Capable bool `xml:"roceV2Capable"`
	IWarpCapable  bool `xml:"iWarpCapable"`
}

func init() {
	t["HostRdmaDeviceCapability"] = reflect.TypeOf((*HostRdmaDeviceCapability)(nil)).Elem()
}

type HostRdmaDeviceConnectionInfo struct {
	DynamicData

	State       string `xml:"state"`
	Mtu         int32  `xml:"mtu"`
	SpeedInMbps int32  `xml:"speedInMbps"`
}

func init() {
	t["HostRdmaDeviceConnectionInfo"] = reflect.TypeOf((*HostRdmaDeviceConnectionInfo)(nil)).Elem()
}

type HostRdmaDevicePnicBacking struct {
	HostRdmaDeviceBacking

	PairedUplink string `xml:"pairedUplink"`
}

func init() {
	t["HostRdmaDevicePnicBacking"] = reflect.TypeOf((*HostRdmaDevicePnicBacking)(nil)).Elem()
}

type HostRdmaHba struct {
	HostHostBusAdapter

	AssociatedRdmaDevice string `xml:"associatedRdmaDevice,omitempty"`
}

func init() {
	t["HostRdmaHba"] = reflect.TypeOf((*HostRdmaHba)(nil)).Elem()
}

type HostRdmaTargetTransport struct {
	HostTargetTransport
}

func init() {
	t["HostRdmaTargetTransport"] = reflect.TypeOf((*HostRdmaTargetTransport)(nil)).Elem()
}

type HostReconcileDatastoreInventoryRequestType struct {
	This      ManagedObjectReference `xml:"_this"`
	Datastore ManagedObjectReference `xml:"datastore"`
}

func init() {
	t["HostReconcileDatastoreInventoryRequestType"] = reflect.TypeOf((*HostReconcileDatastoreInventoryRequestType)(nil)).Elem()
}

type HostReconcileDatastoreInventory_Task HostReconcileDatastoreInventoryRequestType

func init() {
	t["HostReconcileDatastoreInventory_Task"] = reflect.TypeOf((*HostReconcileDatastoreInventory_Task)(nil)).Elem()
}

type HostReconcileDatastoreInventory_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval"`
}

type HostReconnectionFailedEvent struct {
	HostEvent
}

func init() {
	t["HostReconnectionFailedEvent"] = reflect.TypeOf((*HostReconnectionFailedEvent)(nil)).Elem()
}

type HostRegisterDisk HostRegisterDiskRequestType

func init() {
	t["HostRegisterDisk"] = reflect.TypeOf((*HostRegisterDisk)(nil)).Elem()
}

type HostRegisterDiskRequestType struct {
	This ManagedObjectReference `xml:"_this"`
	Path string                 `xml:"path"`
	Name string                 `xml:"name,omitempty"`
}

func init() {
	t["HostRegisterDiskRequestType"] = reflect.TypeOf((*HostRegisterDiskRequestType)(nil)).Elem()
}

type HostRegisterDiskResponse struct {
	Returnval VStorageObject `xml:"returnval"`
}

type HostReliableMemoryInfo struct {
	DynamicData

	MemorySize int64 `xml:"memorySize"`
}

func init() {
	t["HostReliableMemoryInfo"] = reflect.TypeOf((*HostReliableMemoryInfo)(nil)).Elem()
}

type HostRelocateVStorageObjectRequestType struct {
	This      ManagedObjectReference `xml:"_this"`
	Id        ID                     `xml:"id"`
	Datastore ManagedObjectReference `xml:"datastore"`
	Spec      VslmRelocateSpec       `xml:"spec"`
}

func init() {
	t["HostRelocateVStorageObjectRequestType"] = reflect.TypeOf((*HostRelocateVStorageObjectRequestType)(nil)).Elem()
}

type HostRelocateVStorageObject_Task HostRelocateVStorageObjectRequestType

func init() {
	t["HostRelocateVStorageObject_Task"] = reflect.TypeOf((*HostRelocateVStorageObject_Task)(nil)).Elem()
}

type HostRelocateVStorageObject_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval"`
}

type HostRemoveVFlashResource HostRemoveVFlashResourceRequestType

func init() {
	t["HostRemoveVFlashResource"] = reflect.TypeOf((*HostRemoveVFlashResource)(nil)).Elem()
}

type HostRemoveVFlashResourceRequestType struct {
	This ManagedObjectReference `xml:"_this"`
}

func init() {
	t["HostRemoveVFlashResourceRequestType"] = reflect.TypeOf((*HostRemoveVFlashResourceRequestType)(nil)).Elem()
}

type HostRemoveVFlashResourceResponse struct {
}

type HostRemovedEvent struct {
	HostEvent
}

func init() {
	t["HostRemovedEvent"] = reflect.TypeOf((*HostRemovedEvent)(nil)).Elem()
}

type HostRenameVStorageObject HostRenameVStorageObjectRequestType

func init() {
	t["HostRenameVStorageObject"] = reflect.TypeOf((*HostRenameVStorageObject)(nil)).Elem()
}

type HostRenameVStorageObjectRequestType struct {
	This      ManagedObjectReference `xml:"_this"`
	Id        ID                     `xml:"id"`
	Datastore ManagedObjectReference `xml:"datastore"`
	Name      string                 `xml:"name"`
}

func init() {
	t["HostRenameVStorageObjectRequestType"] = reflect.TypeOf((*HostRenameVStorageObjectRequestType)(nil)).Elem()
}

type HostRenameVStorageObjectResponse struct {
}

type HostResignatureRescanResult struct {
	DynamicData

	Rescan []HostVmfsRescanResult `xml:"rescan,omitempty"`
	Result ManagedObjectReference `xml:"result"`
}

func init() {
	t["HostResignatureRescanResult"] = reflect.TypeOf((*HostResignatureRescanResult)(nil)).Elem()
}

type HostRetrieveVStorageInfrastructureObjectPolicy HostRetrieveVStorageInfrastructureObjectPolicyRequestType

func init() {
	t["HostRetrieveVStorageInfrastructureObjectPolicy"] = reflect.TypeOf((*HostRetrieveVStorageInfrastructureObjectPolicy)(nil)).Elem()
}

type HostRetrieveVStorageInfrastructureObjectPolicyRequestType struct {
	This      ManagedObjectReference `xml:"_this"`
	Datastore ManagedObjectReference `xml:"datastore"`
}

func init() {
	t["HostRetrieveVStorageInfrastructureObjectPolicyRequestType"] = reflect.TypeOf((*HostRetrieveVStorageInfrastructureObjectPolicyRequestType)(nil)).Elem()
}

type HostRetrieveVStorageInfrastructureObjectPolicyResponse struct {
	Returnval []VslmInfrastructureObjectPolicy `xml:"returnval,omitempty"`
}

type HostRetrieveVStorageObject HostRetrieveVStorageObjectRequestType

func init() {
	t["HostRetrieveVStorageObject"] = reflect.TypeOf((*HostRetrieveVStorageObject)(nil)).Elem()
}

type HostRetrieveVStorageObjectMetadata HostRetrieveVStorageObjectMetadataRequestType

func init() {
	t["HostRetrieveVStorageObjectMetadata"] = reflect.TypeOf((*HostRetrieveVStorageObjectMetadata)(nil)).Elem()
}

type HostRetrieveVStorageObjectMetadataRequestType struct {
	This       ManagedObjectReference `xml:"_this"`
	Id         ID                     `xml:"id"`
	Datastore  ManagedObjectReference `xml:"datastore"`
	SnapshotId *ID                    `xml:"snapshotId,omitempty"`
	Prefix     string                 `xml:"prefix,omitempty"`
}

func init() {
	t["HostRetrieveVStorageObjectMetadataRequestType"] = reflect.TypeOf((*HostRetrieveVStorageObjectMetadataRequestType)(nil)).Elem()
}

type HostRetrieveVStorageObjectMetadataResponse struct {
	Returnval []KeyValue `xml:"returnval,omitempty"`
}

type HostRetrieveVStorageObjectMetadataValue HostRetrieveVStorageObjectMetadataValueRequestType

func init() {
	t["HostRetrieveVStorageObjectMetadataValue"] = reflect.TypeOf((*HostRetrieveVStorageObjectMetadataValue)(nil)).Elem()
}

type HostRetrieveVStorageObjectMetadataValueRequestType struct {
	This       ManagedObjectReference `xml:"_this"`
	Id         ID                     `xml:"id"`
	Datastore  ManagedObjectReference `xml:"datastore"`
	SnapshotId *ID                    `xml:"snapshotId,omitempty"`
	Key        string                 `xml:"key"`
}

func init() {
	t["HostRetrieveVStorageObjectMetadataValueRequestType"] = reflect.TypeOf((*HostRetrieveVStorageObjectMetadataValueRequestType)(nil)).Elem()
}

type HostRetrieveVStorageObjectMetadataValueResponse struct {
	Returnval string `xml:"returnval"`
}

type HostRetrieveVStorageObjectRequestType struct {
	This      ManagedObjectReference `xml:"_this"`
	Id        ID                     `xml:"id"`
	Datastore ManagedObjectReference `xml:"datastore"`
}

func init() {
	t["HostRetrieveVStorageObjectRequestType"] = reflect.TypeOf((*HostRetrieveVStorageObjectRequestType)(nil)).Elem()
}

type HostRetrieveVStorageObjectResponse struct {
	Returnval VStorageObject `xml:"returnval"`
}

type HostRetrieveVStorageObjectState HostRetrieveVStorageObjectStateRequestType

func init() {
	t["HostRetrieveVStorageObjectState"] = reflect.TypeOf((*HostRetrieveVStorageObjectState)(nil)).Elem()
}

type HostRetrieveVStorageObjectStateRequestType struct {
	This      ManagedObjectReference `xml:"_this"`
	Id        ID                     `xml:"id"`
	Datastore ManagedObjectReference `xml:"datastore"`
}

func init() {
	t["HostRetrieveVStorageObjectStateRequestType"] = reflect.TypeOf((*HostRetrieveVStorageObjectStateRequestType)(nil)).Elem()
}

type HostRetrieveVStorageObjectStateResponse struct {
	Returnval VStorageObjectStateInfo `xml:"returnval"`
}

type HostRuntimeInfo struct {
	DynamicData

	ConnectionState             HostSystemConnectionState                   `xml:"connectionState"`
	PowerState                  HostSystemPowerState                        `xml:"powerState"`
	StandbyMode                 string                                      `xml:"standbyMode,omitempty"`
	InMaintenanceMode           bool                                        `xml:"inMaintenanceMode"`
	InQuarantineMode            *bool                                       `xml:"inQuarantineMode"`
	BootTime                    *time.Time                                  `xml:"bootTime"`
	HealthSystemRuntime         *HealthSystemRuntime                        `xml:"healthSystemRuntime,omitempty"`
	DasHostState                *ClusterDasFdmHostState                     `xml:"dasHostState,omitempty"`
	TpmPcrValues                []HostTpmDigestInfo                         `xml:"tpmPcrValues,omitempty"`
	VsanRuntimeInfo             *VsanHostRuntimeInfo                        `xml:"vsanRuntimeInfo,omitempty"`
	NetworkRuntimeInfo          *HostRuntimeInfoNetworkRuntimeInfo          `xml:"networkRuntimeInfo,omitempty"`
	VFlashResourceRuntimeInfo   *HostVFlashManagerVFlashResourceRunTimeInfo `xml:"vFlashResourceRuntimeInfo,omitempty"`
	HostMaxVirtualDiskCapacity  int64                                       `xml:"hostMaxVirtualDiskCapacity,omitempty"`
	CryptoState                 string                                      `xml:"cryptoState,omitempty"`
	CryptoKeyId                 *CryptoKeyId                                `xml:"cryptoKeyId,omitempty"`
	StatelessNvdsMigrationReady string                                      `xml:"statelessNvdsMigrationReady,omitempty"`
	StateEncryption             *HostRuntimeInfoStateEncryptionInfo         `xml:"stateEncryption,omitempty"`
}

func init() {
	t["HostRuntimeInfo"] = reflect.TypeOf((*HostRuntimeInfo)(nil)).Elem()
}

type HostRuntimeInfoNetStackInstanceRuntimeInfo struct {
	DynamicData

	NetStackInstanceKey    string   `xml:"netStackInstanceKey"`
	State                  string   `xml:"state,omitempty"`
	VmknicKeys             []string `xml:"vmknicKeys,omitempty"`
	MaxNumberOfConnections int32    `xml:"maxNumberOfConnections,omitempty"`
	CurrentIpV6Enabled     *bool    `xml:"currentIpV6Enabled"`
}

func init() {
	t["HostRuntimeInfoNetStackInstanceRuntimeInfo"] = reflect.TypeOf((*HostRuntimeInfoNetStackInstanceRuntimeInfo)(nil)).Elem()
}

type HostRuntimeInfoNetworkRuntimeInfo struct {
	DynamicData

	NetStackInstanceRuntimeInfo []HostRuntimeInfoNetStackInstanceRuntimeInfo `xml:"netStackInstanceRuntimeInfo,omitempty"`
	NetworkResourceRuntime      *HostNetworkResourceRuntime                  `xml:"networkResourceRuntime,omitempty"`
}

func init() {
	t["HostRuntimeInfoNetworkRuntimeInfo"] = reflect.TypeOf((*HostRuntimeInfoNetworkRuntimeInfo)(nil)).Elem()
}

type HostRuntimeInfoStateEncryptionInfo struct {
	DynamicData

	ProtectionMode           string `xml:"protectionMode"`
	RequireSecureBoot        *bool  `xml:"requireSecureBoot"`
	RequireExecInstalledOnly *bool  `xml:"requireExecInstalledOnly"`
}

func init() {
	t["HostRuntimeInfoStateEncryptionInfo"] = reflect.TypeOf((*HostRuntimeInfoStateEncryptionInfo)(nil)).Elem()
}

type HostScheduleReconcileDatastoreInventory HostScheduleReconcileDatastoreInventoryRequestType

func init() {
	t["HostScheduleReconcileDatastoreInventory"] = reflect.TypeOf((*HostScheduleReconcileDatastoreInventory)(nil)).Elem()
}

type HostScheduleReconcileDatastoreInventoryRequestType struct {
	This      ManagedObjectReference `xml:"_this"`
	Datastore ManagedObjectReference `xml:"datastore"`
}

func init() {
	t["HostScheduleReconcileDatastoreInventoryRequestType"] = reflect.TypeOf((*HostScheduleReconcileDatastoreInventoryRequestType)(nil)).Elem()
}

type HostScheduleReconcileDatastoreInventoryResponse struct {
}

type HostScsiDisk struct {
	ScsiLun

	Capacity              HostDiskDimensionsLba `xml:"capacity"`
	DevicePath            string                `xml:"devicePath"`
	Ssd                   *bool                 `xml:"ssd"`
	LocalDisk             *bool                 `xml:"localDisk"`
	PhysicalLocation      []string              `xml:"physicalLocation,omitempty"`
	EmulatedDIXDIFEnabled *bool                 `xml:"emulatedDIXDIFEnabled"`
	VsanDiskInfo          *VsanHostVsanDiskInfo `xml:"vsanDiskInfo,omitempty"`
	ScsiDiskType          string                `xml:"scsiDiskType,omitempty"`
}

func init() {
	t["HostScsiDisk"] = reflect.TypeOf((*HostScsiDisk)(nil)).Elem()
}

type HostScsiDiskPartition struct {
	DynamicData

	DiskName  string `xml:"diskName"`
	Partition int32  `xml:"partition"`
}

func init() {
	t["HostScsiDiskPartition"] = reflect.TypeOf((*HostScsiDiskPartition)(nil)).Elem()
}

type HostScsiTopology struct {
	DynamicData

	Adapter []HostScsiTopologyInterface `xml:"adapter,omitempty"`
}

func init() {
	t["HostScsiTopology"] = reflect.TypeOf((*HostScsiTopology)(nil)).Elem()
}

type HostScsiTopologyInterface struct {
	DynamicData

	Key     string                   `xml:"key"`
	Adapter string                   `xml:"adapter"`
	Target  []HostScsiTopologyTarget `xml:"target,omitempty"`
}

func init() {
	t["HostScsiTopologyInterface"] = reflect.TypeOf((*HostScsiTopologyInterface)(nil)).Elem()
}

type HostScsiTopologyLun struct {
	DynamicData

	Key     string `xml:"key"`
	Lun     int32  `xml:"lun"`
	ScsiLun string `xml:"scsiLun"`
}

func init() {
	t["HostScsiTopologyLun"] = reflect.TypeOf((*HostScsiTopologyLun)(nil)).Elem()
}

type HostScsiTopologyTarget struct {
	DynamicData

	Key       string                  `xml:"key"`
	Target    int32                   `xml:"target"`
	Lun       []HostScsiTopologyLun   `xml:"lun,omitempty"`
	Transport BaseHostTargetTransport `xml:"transport,omitempty,typeattr"`
}

func init() {
	t["HostScsiTopologyTarget"] = reflect.TypeOf((*HostScsiTopologyTarget)(nil)).Elem()
}

type HostSecuritySpec struct {
	DynamicData

	AdminPassword    string       `xml:"adminPassword,omitempty"`
	RemovePermission []Permission `xml:"removePermission,omitempty"`
	AddPermission    []Permission `xml:"addPermission,omitempty"`
}

func init() {
	t["HostSecuritySpec"] = reflect.TypeOf((*HostSecuritySpec)(nil)).Elem()
}

type HostSerialAttachedHba struct {
	HostHostBusAdapter

	NodeWorldWideName string `xml:"nodeWorldWideName"`
}

func init() {
	t["HostSerialAttachedHba"] = reflect.TypeOf((*HostSerialAttachedHba)(nil)).Elem()
}

type HostSerialAttachedTargetTransport struct {
	HostTargetTransport
}

func init() {
	t["HostSerialAttachedTargetTransport"] = reflect.TypeOf((*HostSerialAttachedTargetTransport)(nil)).Elem()
}

type HostService struct {
	DynamicData

	Key           string                    `xml:"key"`
	Label         string                    `xml:"label"`
	Required      bool                      `xml:"required"`
	Uninstallable bool                      `xml:"uninstallable"`
	Running       bool                      `xml:"running"`
	Ruleset       []string                  `xml:"ruleset,omitempty"`
	Policy        string                    `xml:"policy"`
	SourcePackage *HostServiceSourcePackage `xml:"sourcePackage,omitempty"`
}

func init() {
	t["HostService"] = reflect.TypeOf((*HostService)(nil)).Elem()
}

type HostServiceConfig struct {
	DynamicData

	ServiceId     string `xml:"serviceId"`
	StartupPolicy string `xml:"startupPolicy"`
}

func init() {
	t["HostServiceConfig"] = reflect.TypeOf((*HostServiceConfig)(nil)).Elem()
}

type HostServiceInfo struct {
	DynamicData

	Service []HostService `xml:"service,omitempty"`
}

func init() {
	t["HostServiceInfo"] = reflect.TypeOf((*HostServiceInfo)(nil)).Elem()
}

type HostServiceSourcePackage struct {
	DynamicData

	SourcePackageName string `xml:"sourcePackageName"`
	Description       string `xml:"description"`
}

func init() {
	t["HostServiceSourcePackage"] = reflect.TypeOf((*HostServiceSourcePackage)(nil)).Elem()
}

type HostServiceTicket struct {
	DynamicData

	Host           string `xml:"host,omitempty"`
	Port           int32  `xml:"port,omitempty"`
	SslThumbprint  string `xml:"sslThumbprint,omitempty"`
	Service        string `xml:"service"`
	ServiceVersion string `xml:"serviceVersion"`
	SessionId      string `xml:"sessionId"`
}

func init() {
	t["HostServiceTicket"] = reflect.TypeOf((*HostServiceTicket)(nil)).Elem()
}

type HostSetVStorageObjectControlFlags HostSetVStorageObjectControlFlagsRequestType

func init() {
	t["HostSetVStorageObjectControlFlags"] = reflect.TypeOf((*HostSetVStorageObjectControlFlags)(nil)).Elem()
}

type HostSetVStorageObjectControlFlagsRequestType struct {
	This         ManagedObjectReference `xml:"_this"`
	Id           ID                     `xml:"id"`
	Datastore    ManagedObjectReference `xml:"datastore"`
	ControlFlags []string               `xml:"controlFlags,omitempty"`
}

func init() {
	t["HostSetVStorageObjectControlFlagsRequestType"] = reflect.TypeOf((*HostSetVStorageObjectControlFlagsRequestType)(nil)).Elem()
}

type HostSetVStorageObjectControlFlagsResponse struct {
}

type HostSevInfo struct {
	DynamicData

	SevState       string `xml:"sevState"`
	MaxSevEsGuests int64  `xml:"maxSevEsGuests"`
}

func init() {
	t["HostSevInfo"] = reflect.TypeOf((*HostSevInfo)(nil)).Elem()
}

type HostSgxInfo struct {
	DynamicData

	SgxState       string `xml:"sgxState"`
	TotalEpcMemory int64  `xml:"totalEpcMemory"`
	FlcMode        string `xml:"flcMode"`
	LePubKeyHash   string `xml:"lePubKeyHash,omitempty"`
}

func init() {
	t["HostSgxInfo"] = reflect.TypeOf((*HostSgxInfo)(nil)).Elem()
}

type HostSharedGpuCapabilities struct {
	DynamicData

	Vgpu                    string `xml:"vgpu"`
	DiskSnapshotSupported   bool   `xml:"diskSnapshotSupported"`
	MemorySnapshotSupported bool   `xml:"memorySnapshotSupported"`
	SuspendSupported        bool   `xml:"suspendSupported"`
	MigrateSupported        bool   `xml:"migrateSupported"`
}

func init() {
	t["HostSharedGpuCapabilities"] = reflect.TypeOf((*HostSharedGpuCapabilities)(nil)).Elem()
}

type HostShortNameInconsistentEvent struct {
	HostDasEvent

	ShortName  string `xml:"shortName"`
	ShortName2 string `xml:"shortName2"`
}

func init() {
	t["HostShortNameInconsistentEvent"] = reflect.TypeOf((*HostShortNameInconsistentEvent)(nil)).Elem()
}

type HostShortNameToIpFailedEvent struct {
	HostEvent

	ShortName string `xml:"shortName"`
}

func init() {
	t["HostShortNameToIpFailedEvent"] = reflect.TypeOf((*HostShortNameToIpFailedEvent)(nil)).Elem()
}

type HostShutdownEvent struct {
	HostEvent

	Reason string `xml:"reason"`
}

func init() {
	t["HostShutdownEvent"] = reflect.TypeOf((*HostShutdownEvent)(nil)).Elem()
}

type HostSnmpConfigSpec struct {
	DynamicData

	Enabled             *bool                 `xml:"enabled"`
	Port                int32                 `xml:"port,omitempty"`
	ReadOnlyCommunities []string              `xml:"readOnlyCommunities,omitempty"`
	TrapTargets         []HostSnmpDestination `xml:"trapTargets,omitempty"`
	Option              []KeyValue            `xml:"option,omitempty"`
}

func init() {
	t["HostSnmpConfigSpec"] = reflect.TypeOf((*HostSnmpConfigSpec)(nil)).Elem()
}

type HostSnmpDestination struct {
	DynamicData

	HostName  string `xml:"hostName"`
	Port      int32  `xml:"port"`
	Community string `xml:"community"`
}

func init() {
	t["HostSnmpDestination"] = reflect.TypeOf((*HostSnmpDestination)(nil)).Elem()
}

type HostSnmpSystemAgentLimits struct {
	DynamicData

	MaxReadOnlyCommunities int32                   `xml:"maxReadOnlyCommunities"`
	MaxTrapDestinations    int32                   `xml:"maxTrapDestinations"`
	MaxCommunityLength     int32                   `xml:"maxCommunityLength"`
	MaxBufferSize          int32                   `xml:"maxBufferSize"`
	Capability             HostSnmpAgentCapability `xml:"capability,omitempty"`
}

func init() {
	t["HostSnmpSystemAgentLimits"] = reflect.TypeOf((*HostSnmpSystemAgentLimits)(nil)).Elem()
}

type HostSpecGetUpdatedHosts HostSpecGetUpdatedHostsRequestType

func init() {
	t["HostSpecGetUpdatedHosts"] = reflect.TypeOf((*HostSpecGetUpdatedHosts)(nil)).Elem()
}

type HostSpecGetUpdatedHostsRequestType struct {
	This          ManagedObjectReference `xml:"_this"`
	StartChangeID string                 `xml:"startChangeID,omitempty"`
	EndChangeID   string                 `xml:"endChangeID,omitempty"`
}

func init() {
	t["HostSpecGetUpdatedHostsRequestType"] = reflect.TypeOf((*HostSpecGetUpdatedHostsRequestType)(nil)).Elem()
}

type HostSpecGetUpdatedHostsResponse struct {
	Returnval []ManagedObjectReference `xml:"returnval,omitempty"`
}

type HostSpecification struct {
	DynamicData

	CreatedTime  time.Time              `xml:"createdTime"`
	LastModified *time.Time             `xml:"lastModified"`
	Host         ManagedObjectReference `xml:"host"`
	SubSpecs     []HostSubSpecification `xml:"subSpecs,omitempty"`
	ChangeID     string                 `xml:"changeID,omitempty"`
}

func init() {
	t["HostSpecification"] = reflect.TypeOf((*HostSpecification)(nil)).Elem()
}

type HostSpecificationChangedEvent struct {
	HostEvent
}

func init() {
	t["HostSpecificationChangedEvent"] = reflect.TypeOf((*HostSpecificationChangedEvent)(nil)).Elem()
}

type HostSpecificationOperationFailed struct {
	VimFault

	Host ManagedObjectReference `xml:"host"`
}

func init() {
	t["HostSpecificationOperationFailed"] = reflect.TypeOf((*HostSpecificationOperationFailed)(nil)).Elem()
}

type HostSpecificationOperationFailedFault HostSpecificationOperationFailed

func init() {
	t["HostSpecificationOperationFailedFault"] = reflect.TypeOf((*HostSpecificationOperationFailedFault)(nil)).Elem()
}

type HostSpecificationRequireEvent struct {
	HostEvent
}

func init() {
	t["HostSpecificationRequireEvent"] = reflect.TypeOf((*HostSpecificationRequireEvent)(nil)).Elem()
}

type HostSpecificationUpdateEvent struct {
	HostEvent

	HostSpec HostSpecification `xml:"hostSpec"`
}

func init() {
	t["HostSpecificationUpdateEvent"] = reflect.TypeOf((*HostSpecificationUpdateEvent)(nil)).Elem()
}

type HostSriovConfig struct {
	HostPciPassthruConfig

	SriovEnabled       bool  `xml:"sriovEnabled"`
	NumVirtualFunction int32 `xml:"numVirtualFunction"`
}

func init() {
	t["HostSriovConfig"] = reflect.TypeOf((*HostSriovConfig)(nil)).Elem()
}

type HostSriovDevicePoolInfo struct {
	DynamicData

	Key string `xml:"key"`
}

func init() {
	t["HostSriovDevicePoolInfo"] = reflect.TypeOf((*HostSriovDevicePoolInfo)(nil)).Elem()
}

type HostSriovInfo struct {
	HostPciPassthruInfo

	SriovEnabled                bool  `xml:"sriovEnabled"`
	SriovCapable                bool  `xml:"sriovCapable"`
	SriovActive                 bool  `xml:"sriovActive"`
	NumVirtualFunctionRequested int32 `xml:"numVirtualFunctionRequested"`
	NumVirtualFunction          int32 `xml:"numVirtualFunction"`
	MaxVirtualFunctionSupported int32 `xml:"maxVirtualFunctionSupported"`
}

func init() {
	t["HostSriovInfo"] = reflect.TypeOf((*HostSriovInfo)(nil)).Elem()
}

type HostSriovNetworkDevicePoolInfo struct {
	HostSriovDevicePoolInfo

	SwitchKey  string        `xml:"switchKey,omitempty"`
	SwitchUuid string        `xml:"switchUuid,omitempty"`
	Pnic       []PhysicalNic `xml:"pnic,omitempty"`
}

func init() {
	t["HostSriovNetworkDevicePoolInfo"] = reflect.TypeOf((*HostSriovNetworkDevicePoolInfo)(nil)).Elem()
}

type HostSslThumbprintInfo struct {
	DynamicData

	Principal      string   `xml:"principal"`
	OwnerTag       string   `xml:"ownerTag,omitempty"`
	SslThumbprints []string `xml:"sslThumbprints,omitempty"`
}

func init() {
	t["HostSslThumbprintInfo"] = reflect.TypeOf((*HostSslThumbprintInfo)(nil)).Elem()
}

type HostStatusChangedEvent struct {
	ClusterStatusChangedEvent
}

func init() {
	t["HostStatusChangedEvent"] = reflect.TypeOf((*HostStatusChangedEvent)(nil)).Elem()
}

type HostStorageArrayTypePolicyOption struct {
	DynamicData

	Policy BaseElementDescription `xml:"policy,typeattr"`
}

func init() {
	t["HostStorageArrayTypePolicyOption"] = reflect.TypeOf((*HostStorageArrayTypePolicyOption)(nil)).Elem()
}

type HostStorageDeviceInfo struct {
	DynamicData

	HostBusAdapter              []BaseHostHostBusAdapter `xml:"hostBusAdapter,omitempty,typeattr"`
	ScsiLun                     []BaseScsiLun            `xml:"scsiLun,omitempty,typeattr"`
	ScsiTopology                *HostScsiTopology        `xml:"scsiTopology,omitempty"`
	NvmeTopology                *HostNvmeTopology        `xml:"nvmeTopology,omitempty"`
	MultipathInfo               *HostMultipathInfo       `xml:"multipathInfo,omitempty"`
	PlugStoreTopology           *HostPlugStoreTopology   `xml:"plugStoreTopology,omitempty"`
	SoftwareInternetScsiEnabled bool                     `xml:"softwareInternetScsiEnabled"`
}

func init() {
	t["HostStorageDeviceInfo"] = reflect.TypeOf((*HostStorageDeviceInfo)(nil)).Elem()
}

type HostStorageElementInfo struct {
	HostHardwareElementInfo

	OperationalInfo []HostStorageOperationalInfo `xml:"operationalInfo,omitempty"`
}

func init() {
	t["HostStorageElementInfo"] = reflect.TypeOf((*HostStorageElementInfo)(nil)).Elem()
}

type HostStorageOperationalInfo struct {
	DynamicData

	Property string `xml:"property"`
	Value    string `xml:"value"`
}

func init() {
	t["HostStorageOperationalInfo"] = reflect.TypeOf((*HostStorageOperationalInfo)(nil)).Elem()
}

type HostStorageSystemDiskLocatorLedResult struct {
	DynamicData

	Key   string               `xml:"key"`
	Fault LocalizedMethodFault `xml:"fault"`
}

func init() {
	t["HostStorageSystemDiskLocatorLedResult"] = reflect.TypeOf((*HostStorageSystemDiskLocatorLedResult)(nil)).Elem()
}

type HostStorageSystemScsiLunResult struct {
	DynamicData

	Key   string                `xml:"key"`
	Fault *LocalizedMethodFault `xml:"fault,omitempty"`
}

func init() {
	t["HostStorageSystemScsiLunResult"] = reflect.TypeOf((*HostStorageSystemScsiLunResult)(nil)).Elem()
}

type HostStorageSystemVmfsVolumeResult struct {
	DynamicData

	Key   string                `xml:"key"`
	Fault *LocalizedMethodFault `xml:"fault,omitempty"`
}

func init() {
	t["HostStorageSystemVmfsVolumeResult"] = reflect.TypeOf((*HostStorageSystemVmfsVolumeResult)(nil)).Elem()
}

type HostSubSpecification struct {
	DynamicData

	Name        string    `xml:"name"`
	CreatedTime time.Time `xml:"createdTime"`
	Data        []byte    `xml:"data,omitempty"`
	BinaryData  []byte    `xml:"binaryData,omitempty"`
}

func init() {
	t["HostSubSpecification"] = reflect.TypeOf((*HostSubSpecification)(nil)).Elem()
}

type HostSubSpecificationDeleteEvent struct {
	HostEvent

	SubSpecName string `xml:"subSpecName"`
}

func init() {
	t["HostSubSpecificationDeleteEvent"] = reflect.TypeOf((*HostSubSpecificationDeleteEvent)(nil)).Elem()
}

type HostSubSpecificationUpdateEvent struct {
	HostEvent

	HostSubSpec HostSubSpecification `xml:"hostSubSpec"`
}

func init() {
	t["HostSubSpecificationUpdateEvent"] = reflect.TypeOf((*HostSubSpecificationUpdateEvent)(nil)).Elem()
}

type HostSyncFailedEvent struct {
	HostEvent

	Reason LocalizedMethodFault `xml:"reason"`
}

func init() {
	t["HostSyncFailedEvent"] = reflect.TypeOf((*HostSyncFailedEvent)(nil)).Elem()
}

type HostSystemComplianceCheckState struct {
	DynamicData

	State     string    `xml:"state"`
	CheckTime time.Time `xml:"checkTime"`
}

func init() {
	t["HostSystemComplianceCheckState"] = reflect.TypeOf((*HostSystemComplianceCheckState)(nil)).Elem()
}

type HostSystemHealthInfo struct {
	DynamicData

	NumericSensorInfo []HostNumericSensorInfo `xml:"numericSensorInfo,omitempty"`
}

func init() {
	t["HostSystemHealthInfo"] = reflect.TypeOf((*HostSystemHealthInfo)(nil)).Elem()
}

type HostSystemIdentificationInfo struct {
	DynamicData

	IdentifierValue string                 `xml:"identifierValue"`
	IdentifierType  BaseElementDescription `xml:"identifierType,typeattr"`
}

func init() {
	t["HostSystemIdentificationInfo"] = reflect.TypeOf((*HostSystemIdentificationInfo)(nil)).Elem()
}

type HostSystemInfo struct {
	DynamicData

	Vendor               string                         `xml:"vendor"`
	Model                string                         `xml:"model"`
	Uuid                 string                         `xml:"uuid"`
	OtherIdentifyingInfo []HostSystemIdentificationInfo `xml:"otherIdentifyingInfo,omitempty"`
	SerialNumber         string                         `xml:"serialNumber,omitempty"`
	QualifiedName        []HostQualifiedName            `xml:"qualifiedName,omitempty"`
}

func init() {
	t["HostSystemInfo"] = reflect.TypeOf((*HostSystemInfo)(nil)).Elem()
}

type HostSystemReconnectSpec struct {
	DynamicData

	SyncState *bool `xml:"syncState"`
}

func init() {
	t["HostSystemReconnectSpec"] = reflect.TypeOf((*HostSystemReconnectSpec)(nil)).Elem()
}

type HostSystemRemediationState struct {
	DynamicData

	State         string    `xml:"state"`
	OperationTime time.Time `xml:"operationTime"`
}

func init() {
	t["HostSystemRemediationState"] = reflect.TypeOf((*HostSystemRemediationState)(nil)).Elem()
}

type HostSystemResourceInfo struct {
	DynamicData

	Key    string                   `xml:"key"`
	Config *ResourceConfigSpec      `xml:"config,omitempty"`
	Child  []HostSystemResourceInfo `xml:"child,omitempty"`
}

func init() {
	t["HostSystemResourceInfo"] = reflect.TypeOf((*HostSystemResourceInfo)(nil)).Elem()
}

type HostSystemSwapConfiguration struct {
	DynamicData

	Option []BaseHostSystemSwapConfigurationSystemSwapOption `xml:"option,omitempty,typeattr"`
}

func init() {
	t["HostSystemSwapConfiguration"] = reflect.TypeOf((*HostSystemSwapConfiguration)(nil)).Elem()
}

type HostSystemSwapConfigurationDatastoreOption struct {
	HostSystemSwapConfigurationSystemSwapOption

	Datastore string `xml:"datastore"`
}

func init() {
	t["HostSystemSwapConfigurationDatastoreOption"] = reflect.TypeOf((*HostSystemSwapConfigurationDatastoreOption)(nil)).Elem()
}

type HostSystemSwapConfigurationDisabledOption struct {
	HostSystemSwapConfigurationSystemSwapOption
}

func init() {
	t["HostSystemSwapConfigurationDisabledOption"] = reflect.TypeOf((*HostSystemSwapConfigurationDisabledOption)(nil)).Elem()
}

type HostSystemSwapConfigurationHostCacheOption struct {
	HostSystemSwapConfigurationSystemSwapOption
}

func init() {
	t["HostSystemSwapConfigurationHostCacheOption"] = reflect.TypeOf((*HostSystemSwapConfigurationHostCacheOption)(nil)).Elem()
}

type HostSystemSwapConfigurationHostLocalSwapOption struct {
	HostSystemSwapConfigurationSystemSwapOption
}

func init() {
	t["HostSystemSwapConfigurationHostLocalSwapOption"] = reflect.TypeOf((*HostSystemSwapConfigurationHostLocalSwapOption)(nil)).Elem()
}

type HostSystemSwapConfigurationSystemSwapOption struct {
	DynamicData

	Key int32 `xml:"key"`
}

func init() {
	t["HostSystemSwapConfigurationSystemSwapOption"] = reflect.TypeOf((*HostSystemSwapConfigurationSystemSwapOption)(nil)).Elem()
}

type HostTargetTransport struct {
	DynamicData
}

func init() {
	t["HostTargetTransport"] = reflect.TypeOf((*HostTargetTransport)(nil)).Elem()
}

type HostTcpHba struct {
	HostHostBusAdapter

	AssociatedPnic string `xml:"associatedPnic,omitempty"`
}

func init() {
	t["HostTcpHba"] = reflect.TypeOf((*HostTcpHba)(nil)).Elem()
}

type HostTcpHbaCreateSpec struct {
	HostHbaCreateSpec

	Pnic string `xml:"pnic"`
}

func init() {
	t["HostTcpHbaCreateSpec"] = reflect.TypeOf((*HostTcpHbaCreateSpec)(nil)).Elem()
}

type HostTcpTargetTransport struct {
	HostTargetTransport
}

func init() {
	t["HostTcpTargetTransport"] = reflect.TypeOf((*HostTcpTargetTransport)(nil)).Elem()
}

type HostTpmAttestationInfo struct {
	DynamicData

	Time    time.Time                              `xml:"time"`
	Status  HostTpmAttestationInfoAcceptanceStatus `xml:"status"`
	Message *LocalizableMessage                    `xml:"message,omitempty"`
}

func init() {
	t["HostTpmAttestationInfo"] = reflect.TypeOf((*HostTpmAttestationInfo)(nil)).Elem()
}

type HostTpmAttestationReport struct {
	DynamicData

	TpmPcrValues   []HostTpmDigestInfo    `xml:"tpmPcrValues"`
	TpmEvents      []HostTpmEventLogEntry `xml:"tpmEvents"`
	TpmLogReliable bool                   `xml:"tpmLogReliable"`
}

func init() {
	t["HostTpmAttestationReport"] = reflect.TypeOf((*HostTpmAttestationReport)(nil)).Elem()
}

type HostTpmBootSecurityOptionEventDetails struct {
	HostTpmEventDetails

	BootSecurityOption string `xml:"bootSecurityOption"`
}

func init() {
	t["HostTpmBootSecurityOptionEventDetails"] = reflect.TypeOf((*HostTpmBootSecurityOptionEventDetails)(nil)).Elem()
}

type HostTpmCommandEventDetails struct {
	HostTpmEventDetails

	CommandLine string `xml:"commandLine"`
}

func init() {
	t["HostTpmCommandEventDetails"] = reflect.TypeOf((*HostTpmCommandEventDetails)(nil)).Elem()
}

type HostTpmDigestInfo struct {
	HostDigestInfo

	PcrNumber int32 `xml:"pcrNumber"`
}

func init() {
	t["HostTpmDigestInfo"] = reflect.TypeOf((*HostTpmDigestInfo)(nil)).Elem()
}

type HostTpmEventDetails struct {
	DynamicData

	DataHash       []byte `xml:"dataHash"`
	DataHashMethod string `xml:"dataHashMethod,omitempty"`
}

func init() {
	t["HostTpmEventDetails"] = reflect.TypeOf((*HostTpmEventDetails)(nil)).Elem()
}

type HostTpmEventLogEntry struct {
	DynamicData

	PcrIndex     int32                   `xml:"pcrIndex"`
	EventDetails BaseHostTpmEventDetails `xml:"eventDetails,typeattr"`
}

func init() {
	t["HostTpmEventLogEntry"] = reflect.TypeOf((*HostTpmEventLogEntry)(nil)).Elem()
}

type HostTpmNvTagEventDetails struct {
	HostTpmBootSecurityOptionEventDetails
}

func init() {
	t["HostTpmNvTagEventDetails"] = reflect.TypeOf((*HostTpmNvTagEventDetails)(nil)).Elem()
}

type HostTpmOptionEventDetails struct {
	HostTpmEventDetails

	OptionsFileName string `xml:"optionsFileName"`
	BootOptions     []byte `xml:"bootOptions,omitempty"`
}

func init() {
	t["HostTpmOptionEventDetails"] = reflect.TypeOf((*HostTpmOptionEventDetails)(nil)).Elem()
}

type HostTpmSoftwareComponentEventDetails struct {
	HostTpmEventDetails

	ComponentName string `xml:"componentName"`
	VibName       string `xml:"vibName"`
	VibVersion    string `xml:"vibVersion"`
	VibVendor     string `xml:"vibVendor"`
}

func init() {
	t["HostTpmSoftwareComponentEventDetails"] = reflect.TypeOf((*HostTpmSoftwareComponentEventDetails)(nil)).Elem()
}

type HostTrustAuthorityAttestationInfo struct {
	DynamicData

	AttestationStatus string               `xml:"attestationStatus"`
	ServiceId         string               `xml:"serviceId,omitempty"`
	AttestedAt        *time.Time           `xml:"attestedAt"`
	AttestedUntil     *time.Time           `xml:"attestedUntil"`
	Messages          []LocalizableMessage `xml:"messages,omitempty"`
}

func init() {
	t["HostTrustAuthorityAttestationInfo"] = reflect.TypeOf((*HostTrustAuthorityAttestationInfo)(nil)).Elem()
}

type HostUnresolvedVmfsExtent struct {
	DynamicData

	Device       HostScsiDiskPartition `xml:"device"`
	DevicePath   string                `xml:"devicePath"`
	VmfsUuid     string                `xml:"vmfsUuid"`
	IsHeadExtent bool                  `xml:"isHeadExtent"`
	Ordinal      int32                 `xml:"ordinal"`
	StartBlock   int32                 `xml:"startBlock"`
	EndBlock     int32                 `xml:"endBlock"`
	Reason       string                `xml:"reason"`
}

func init() {
	t["HostUnresolvedVmfsExtent"] = reflect.TypeOf((*HostUnresolvedVmfsExtent)(nil)).Elem()
}

type HostUnresolvedVmfsResignatureSpec struct {
	DynamicData

	ExtentDevicePath []string `xml:"extentDevicePath"`
}

func init() {
	t["HostUnresolvedVmfsResignatureSpec"] = reflect.TypeOf((*HostUnresolvedVmfsResignatureSpec)(nil)).Elem()
}

type HostUnresolvedVmfsResolutionResult struct {
	DynamicData

	Spec  HostUnresolvedVmfsResolutionSpec `xml:"spec"`
	Vmfs  *HostVmfsVolume                  `xml:"vmfs,omitempty"`
	Fault *LocalizedMethodFault            `xml:"fault,omitempty"`
}

func init() {
	t["HostUnresolvedVmfsResolutionResult"] = reflect.TypeOf((*HostUnresolvedVmfsResolutionResult)(nil)).Elem()
}

type HostUnresolvedVmfsResolutionSpec struct {
	DynamicData

	ExtentDevicePath []string `xml:"extentDevicePath"`
	UuidResolution   string   `xml:"uuidResolution"`
}

func init() {
	t["HostUnresolvedVmfsResolutionSpec"] = reflect.TypeOf((*HostUnresolvedVmfsResolutionSpec)(nil)).Elem()
}

type HostUnresolvedVmfsVolume struct {
	DynamicData

	Extent        []HostUnresolvedVmfsExtent            `xml:"extent"`
	VmfsLabel     string                                `xml:"vmfsLabel"`
	VmfsUuid      string                                `xml:"vmfsUuid"`
	TotalBlocks   int32                                 `xml:"totalBlocks"`
	ResolveStatus HostUnresolvedVmfsVolumeResolveStatus `xml:"resolveStatus"`
}

func init() {
	t["HostUnresolvedVmfsVolume"] = reflect.TypeOf((*HostUnresolvedVmfsVolume)(nil)).Elem()
}

type HostUnresolvedVmfsVolumeResolveStatus struct {
	DynamicData

	Resolvable        bool  `xml:"resolvable"`
	IncompleteExtents *bool `xml:"incompleteExtents"`
	MultipleCopies    *bool `xml:"multipleCopies"`
}

func init() {
	t["HostUnresolvedVmfsVolumeResolveStatus"] = reflect.TypeOf((*HostUnresolvedVmfsVolumeResolveStatus)(nil)).Elem()
}

type HostUpdateVStorageObjectMetadataExRequestType struct {
	This       ManagedObjectReference `xml:"_this"`
	Id         ID                     `xml:"id"`
	Datastore  ManagedObjectReference `xml:"datastore"`
	Metadata   []KeyValue             `xml:"metadata,omitempty"`
	DeleteKeys []string               `xml:"deleteKeys,omitempty"`
}

func init() {
	t["HostUpdateVStorageObjectMetadataExRequestType"] = reflect.TypeOf((*HostUpdateVStorageObjectMetadataExRequestType)(nil)).Elem()
}

type HostUpdateVStorageObjectMetadataEx_Task HostUpdateVStorageObjectMetadataExRequestType

func init() {
	t["HostUpdateVStorageObjectMetadataEx_Task"] = reflect.TypeOf((*HostUpdateVStorageObjectMetadataEx_Task)(nil)).Elem()
}

type HostUpdateVStorageObjectMetadataEx_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval"`
}

type HostUpdateVStorageObjectMetadataRequestType struct {
	This       ManagedObjectReference `xml:"_this"`
	Id         ID                     `xml:"id"`
	Datastore  ManagedObjectReference `xml:"datastore"`
	Metadata   []KeyValue             `xml:"metadata,omitempty"`
	DeleteKeys []string               `xml:"deleteKeys,omitempty"`
}

func init() {
	t["HostUpdateVStorageObjectMetadataRequestType"] = reflect.TypeOf((*HostUpdateVStorageObjectMetadataRequestType)(nil)).Elem()
}

type HostUpdateVStorageObjectMetadata_Task HostUpdateVStorageObjectMetadataRequestType

func init() {
	t["HostUpdateVStorageObjectMetadata_Task"] = reflect.TypeOf((*HostUpdateVStorageObjectMetadata_Task)(nil)).Elem()
}

type HostUpdateVStorageObjectMetadata_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval"`
}

type HostUpgradeFailedEvent struct {
	HostEvent
}

func init() {
	t["HostUpgradeFailedEvent"] = reflect.TypeOf((*HostUpgradeFailedEvent)(nil)).Elem()
}

type HostUserWorldSwapNotEnabledEvent struct {
	HostEvent
}

func init() {
	t["HostUserWorldSwapNotEnabledEvent"] = reflect.TypeOf((*HostUserWorldSwapNotEnabledEvent)(nil)).Elem()
}

type HostVFlashManagerVFlashCacheConfigInfo struct {
	DynamicData

	VFlashModuleConfigOption []HostVFlashManagerVFlashCacheConfigInfoVFlashModuleConfigOption `xml:"vFlashModuleConfigOption,omitempty"`
	DefaultVFlashModule      string                                                           `xml:"defaultVFlashModule,omitempty"`
	SwapCacheReservationInGB int64                                                            `xml:"swapCacheReservationInGB,omitempty"`
}

func init() {
	t["HostVFlashManagerVFlashCacheConfigInfo"] = reflect.TypeOf((*HostVFlashManagerVFlashCacheConfigInfo)(nil)).Elem()
}

type HostVFlashManagerVFlashCacheConfigInfoVFlashModuleConfigOption struct {
	DynamicData

	VFlashModule              string       `xml:"vFlashModule"`
	VFlashModuleVersion       string       `xml:"vFlashModuleVersion"`
	MinSupportedModuleVersion string       `xml:"minSupportedModuleVersion"`
	CacheConsistencyType      ChoiceOption `xml:"cacheConsistencyType"`
	CacheMode                 ChoiceOption `xml:"cacheMode"`
	BlockSizeInKBOption       LongOption   `xml:"blockSizeInKBOption"`
	ReservationInMBOption     LongOption   `xml:"reservationInMBOption"`
	MaxDiskSizeInKB           int64        `xml:"maxDiskSizeInKB"`
}

func init() {
	t["HostVFlashManagerVFlashCacheConfigInfoVFlashModuleConfigOption"] = reflect.TypeOf((*HostVFlashManagerVFlashCacheConfigInfoVFlashModuleConfigOption)(nil)).Elem()
}

type HostVFlashManagerVFlashCacheConfigSpec struct {
	DynamicData

	DefaultVFlashModule      string `xml:"defaultVFlashModule"`
	SwapCacheReservationInGB int64  `xml:"swapCacheReservationInGB"`
}

func init() {
	t["HostVFlashManagerVFlashCacheConfigSpec"] = reflect.TypeOf((*HostVFlashManagerVFlashCacheConfigSpec)(nil)).Elem()
}

type HostVFlashManagerVFlashConfigInfo struct {
	DynamicData

	VFlashResourceConfigInfo *HostVFlashManagerVFlashResourceConfigInfo `xml:"vFlashResourceConfigInfo,omitempty"`
	VFlashCacheConfigInfo    *HostVFlashManagerVFlashCacheConfigInfo    `xml:"vFlashCacheConfigInfo,omitempty"`
}

func init() {
	t["HostVFlashManagerVFlashConfigInfo"] = reflect.TypeOf((*HostVFlashManagerVFlashConfigInfo)(nil)).Elem()
}

type HostVFlashManagerVFlashResourceConfigInfo struct {
	DynamicData

	Vffs     *HostVffsVolume `xml:"vffs,omitempty"`
	Capacity int64           `xml:"capacity"`
}

func init() {
	t["HostVFlashManagerVFlashResourceConfigInfo"] = reflect.TypeOf((*HostVFlashManagerVFlashResourceConfigInfo)(nil)).Elem()
}

type HostVFlashManagerVFlashResourceConfigSpec struct {
	DynamicData

	VffsUuid string `xml:"vffsUuid"`
}

func init() {
	t["HostVFlashManagerVFlashResourceConfigSpec"] = reflect.TypeOf((*HostVFlashManagerVFlashResourceConfigSpec)(nil)).Elem()
}

type HostVFlashManagerVFlashResourceRunTimeInfo struct {
	DynamicData

	Usage              int64 `xml:"usage"`
	Capacity           int64 `xml:"capacity"`
	Accessible         bool  `xml:"accessible"`
	CapacityForVmCache int64 `xml:"capacityForVmCache"`
	FreeForVmCache     int64 `xml:"freeForVmCache"`
}

func init() {
	t["HostVFlashManagerVFlashResourceRunTimeInfo"] = reflect.TypeOf((*HostVFlashManagerVFlashResourceRunTimeInfo)(nil)).Elem()
}

type HostVFlashResourceConfigurationResult struct {
	DynamicData

	DevicePath              []string                      `xml:"devicePath,omitempty"`
	Vffs                    *HostVffsVolume               `xml:"vffs,omitempty"`
	DiskConfigurationResult []HostDiskConfigurationResult `xml:"diskConfigurationResult,omitempty"`
}

func init() {
	t["HostVFlashResourceConfigurationResult"] = reflect.TypeOf((*HostVFlashResourceConfigurationResult)(nil)).Elem()
}

type HostVMotionCompatibility struct {
	DynamicData

	Host          ManagedObjectReference `xml:"host"`
	Compatibility []string               `xml:"compatibility,omitempty"`
}

func init() {
	t["HostVMotionCompatibility"] = reflect.TypeOf((*HostVMotionCompatibility)(nil)).Elem()
}

type HostVMotionConfig struct {
	DynamicData

	VmotionNicKey string `xml:"vmotionNicKey,omitempty"`
	Enabled       bool   `xml:"enabled"`
}

func init() {
	t["HostVMotionConfig"] = reflect.TypeOf((*HostVMotionConfig)(nil)).Elem()
}

type HostVMotionInfo struct {
	DynamicData

	NetConfig *HostVMotionNetConfig `xml:"netConfig,omitempty"`
	IpConfig  *HostIpConfig         `xml:"ipConfig,omitempty"`
}

func init() {
	t["HostVMotionInfo"] = reflect.TypeOf((*HostVMotionInfo)(nil)).Elem()
}

type HostVMotionManagerDstInstantCloneResult struct {
	DynamicData

	DstVmId              int32 `xml:"dstVmId,omitempty"`
	StartTime            int64 `xml:"startTime,omitempty"`
	CptLoadTime          int64 `xml:"cptLoadTime,omitempty"`
	CptLoadDoneTime      int64 `xml:"cptLoadDoneTime,omitempty"`
	ReplicateMemDoneTime int64 `xml:"replicateMemDoneTime,omitempty"`
	EndTime              int64 `xml:"endTime,omitempty"`
	CptXferTime          int64 `xml:"cptXferTime,omitempty"`
	CptCacheUsed         int64 `xml:"cptCacheUsed,omitempty"`
	DevCptStreamSize     int64 `xml:"devCptStreamSize,omitempty"`
	DevCptStreamTime     int64 `xml:"devCptStreamTime,omitempty"`
}

func init() {
	t["HostVMotionManagerDstInstantCloneResult"] = reflect.TypeOf((*HostVMotionManagerDstInstantCloneResult)(nil)).Elem()
}

type HostVMotionManagerSrcInstantCloneResult struct {
	DynamicData

	StartTime       int64 `xml:"startTime,omitempty"`
	QuiesceTime     int64 `xml:"quiesceTime,omitempty"`
	QuiesceDoneTime int64 `xml:"quiesceDoneTime,omitempty"`
	ResumeDoneTime  int64 `xml:"resumeDoneTime,omitempty"`
	EndTime         int64 `xml:"endTime,omitempty"`
}

func init() {
	t["HostVMotionManagerSrcInstantCloneResult"] = reflect.TypeOf((*HostVMotionManagerSrcInstantCloneResult)(nil)).Elem()
}

type HostVMotionNetConfig struct {
	DynamicData

	CandidateVnic []HostVirtualNic `xml:"candidateVnic,omitempty"`
	SelectedVnic  string           `xml:"selectedVnic,omitempty"`
}

func init() {
	t["HostVMotionNetConfig"] = reflect.TypeOf((*HostVMotionNetConfig)(nil)).Elem()
}

type HostVStorageObjectCreateDiskFromSnapshotRequestType struct {
	This       ManagedObjectReference          `xml:"_this"`
	Id         ID                              `xml:"id"`
	Datastore  ManagedObjectReference          `xml:"datastore"`
	SnapshotId ID                              `xml:"snapshotId"`
	Name       string                          `xml:"name"`
	Profile    []BaseVirtualMachineProfileSpec `xml:"profile,omitempty,typeattr"`
	Crypto     BaseCryptoSpec                  `xml:"crypto,omitempty,typeattr"`
	Path       string                          `xml:"path,omitempty"`
}

func init() {
	t["HostVStorageObjectCreateDiskFromSnapshotRequestType"] = reflect.TypeOf((*HostVStorageObjectCreateDiskFromSnapshotRequestType)(nil)).Elem()
}

type HostVStorageObjectCreateDiskFromSnapshot_Task HostVStorageObjectCreateDiskFromSnapshotRequestType

func init() {
	t["HostVStorageObjectCreateDiskFromSnapshot_Task"] = reflect.TypeOf((*HostVStorageObjectCreateDiskFromSnapshot_Task)(nil)).Elem()
}

type HostVStorageObjectCreateDiskFromSnapshot_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval"`
}

type HostVStorageObjectCreateSnapshotRequestType struct {
	This        ManagedObjectReference `xml:"_this"`
	Id          ID                     `xml:"id"`
	Datastore   ManagedObjectReference `xml:"datastore"`
	Description string                 `xml:"description"`
}

func init() {
	t["HostVStorageObjectCreateSnapshotRequestType"] = reflect.TypeOf((*HostVStorageObjectCreateSnapshotRequestType)(nil)).Elem()
}

type HostVStorageObjectCreateSnapshot_Task HostVStorageObjectCreateSnapshotRequestType

func init() {
	t["HostVStorageObjectCreateSnapshot_Task"] = reflect.TypeOf((*HostVStorageObjectCreateSnapshot_Task)(nil)).Elem()
}

type HostVStorageObjectCreateSnapshot_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval"`
}

type HostVStorageObjectDeleteSnapshotRequestType struct {
	This       ManagedObjectReference `xml:"_this"`
	Id         ID                     `xml:"id"`
	Datastore  ManagedObjectReference `xml:"datastore"`
	SnapshotId ID                     `xml:"snapshotId"`
}

func init() {
	t["HostVStorageObjectDeleteSnapshotRequestType"] = reflect.TypeOf((*HostVStorageObjectDeleteSnapshotRequestType)(nil)).Elem()
}

type HostVStorageObjectDeleteSnapshot_Task HostVStorageObjectDeleteSnapshotRequestType

func init() {
	t["HostVStorageObjectDeleteSnapshot_Task"] = reflect.TypeOf((*HostVStorageObjectDeleteSnapshot_Task)(nil)).Elem()
}

type HostVStorageObjectDeleteSnapshot_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval"`
}

type HostVStorageObjectRetrieveSnapshotInfo HostVStorageObjectRetrieveSnapshotInfoRequestType

func init() {
	t["HostVStorageObjectRetrieveSnapshotInfo"] = reflect.TypeOf((*HostVStorageObjectRetrieveSnapshotInfo)(nil)).Elem()
}

type HostVStorageObjectRetrieveSnapshotInfoRequestType struct {
	This      ManagedObjectReference `xml:"_this"`
	Id        ID                     `xml:"id"`
	Datastore ManagedObjectReference `xml:"datastore"`
}

func init() {
	t["HostVStorageObjectRetrieveSnapshotInfoRequestType"] = reflect.TypeOf((*HostVStorageObjectRetrieveSnapshotInfoRequestType)(nil)).Elem()
}

type HostVStorageObjectRetrieveSnapshotInfoResponse struct {
	Returnval VStorageObjectSnapshotInfo `xml:"returnval"`
}

type HostVStorageObjectRevertRequestType struct {
	This       ManagedObjectReference `xml:"_this"`
	Id         ID                     `xml:"id"`
	Datastore  ManagedObjectReference `xml:"datastore"`
	SnapshotId ID                     `xml:"snapshotId"`
}

func init() {
	t["HostVStorageObjectRevertRequestType"] = reflect.TypeOf((*HostVStorageObjectRevertRequestType)(nil)).Elem()
}

type HostVStorageObjectRevert_Task HostVStorageObjectRevertRequestType

func init() {
	t["HostVStorageObjectRevert_Task"] = reflect.TypeOf((*HostVStorageObjectRevert_Task)(nil)).Elem()
}

type HostVStorageObjectRevert_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval"`
}

type HostVfatVolume struct {
	HostFileSystemVolume
}

func init() {
	t["HostVfatVolume"] = reflect.TypeOf((*HostVfatVolume)(nil)).Elem()
}

type HostVffsSpec struct {
	DynamicData

	DevicePath   string                 `xml:"devicePath"`
	Partition    *HostDiskPartitionSpec `xml:"partition,omitempty"`
	MajorVersion int32                  `xml:"majorVersion"`
	VolumeName   string                 `xml:"volumeName"`
}

func init() {
	t["HostVffsSpec"] = reflect.TypeOf((*HostVffsSpec)(nil)).Elem()
}

type HostVffsVolume struct {
	HostFileSystemVolume

	MajorVersion int32                   `xml:"majorVersion"`
	Version      string                  `xml:"version"`
	Uuid         string                  `xml:"uuid"`
	Extent       []HostScsiDiskPartition `xml:"extent"`
}

func init() {
	t["HostVffsVolume"] = reflect.TypeOf((*HostVffsVolume)(nil)).Elem()
}

type HostVirtualNic struct {
	DynamicData

	Device    string             `xml:"device"`
	Key       string             `xml:"key"`
	Portgroup string             `xml:"portgroup"`
	Spec      HostVirtualNicSpec `xml:"spec"`
	Port      string             `xml:"port,omitempty"`
}

func init() {
	t["HostVirtualNic"] = reflect.TypeOf((*HostVirtualNic)(nil)).Elem()
}

type HostVirtualNicConfig struct {
	DynamicData

	ChangeOperation string              `xml:"changeOperation,omitempty"`
	Device          string              `xml:"device,omitempty"`
	Portgroup       string              `xml:"portgroup"`
	Spec            *HostVirtualNicSpec `xml:"spec,omitempty"`
}

func init() {
	t["HostVirtualNicConfig"] = reflect.TypeOf((*HostVirtualNicConfig)(nil)).Elem()
}

type HostVirtualNicConnection struct {
	DynamicData

	Portgroup string                                  `xml:"portgroup,omitempty"`
	DvPort    *DistributedVirtualSwitchPortConnection `xml:"dvPort,omitempty"`
	OpNetwork *HostVirtualNicOpaqueNetworkSpec        `xml:"opNetwork,omitempty"`
}

func init() {
	t["HostVirtualNicConnection"] = reflect.TypeOf((*HostVirtualNicConnection)(nil)).Elem()
}

type HostVirtualNicIpRouteSpec struct {
	DynamicData

	IpRouteConfig BaseHostIpRouteConfig `xml:"ipRouteConfig,omitempty,typeattr"`
}

func init() {
	t["HostVirtualNicIpRouteSpec"] = reflect.TypeOf((*HostVirtualNicIpRouteSpec)(nil)).Elem()
}

type HostVirtualNicManagerInfo struct {
	DynamicData

	NetConfig []VirtualNicManagerNetConfig `xml:"netConfig,omitempty"`
}

func init() {
	t["HostVirtualNicManagerInfo"] = reflect.TypeOf((*HostVirtualNicManagerInfo)(nil)).Elem()
}

type HostVirtualNicManagerNicTypeSelection struct {
	DynamicData

	Vnic    HostVirtualNicConnection `xml:"vnic"`
	NicType []string                 `xml:"nicType,omitempty"`
}

func init() {
	t["HostVirtualNicManagerNicTypeSelection"] = reflect.TypeOf((*HostVirtualNicManagerNicTypeSelection)(nil)).Elem()
}

type HostVirtualNicOpaqueNetworkSpec struct {
	DynamicData

	OpaqueNetworkId   string `xml:"opaqueNetworkId"`
	OpaqueNetworkType string `xml:"opaqueNetworkType"`
}

func init() {
	t["HostVirtualNicOpaqueNetworkSpec"] = reflect.TypeOf((*HostVirtualNicOpaqueNetworkSpec)(nil)).Elem()
}

type HostVirtualNicSpec struct {
	DynamicData

	Ip                     *HostIpConfig                           `xml:"ip,omitempty"`
	Mac                    string                                  `xml:"mac,omitempty"`
	DistributedVirtualPort *DistributedVirtualSwitchPortConnection `xml:"distributedVirtualPort,omitempty"`
	Portgroup              string                                  `xml:"portgroup,omitempty"`
	Mtu                    int32                                   `xml:"mtu,omitempty"`
	TsoEnabled             *bool                                   `xml:"tsoEnabled"`
	NetStackInstanceKey    string                                  `xml:"netStackInstanceKey,omitempty"`
	OpaqueNetwork          *HostVirtualNicOpaqueNetworkSpec        `xml:"opaqueNetwork,omitempty"`
	ExternalId             string                                  `xml:"externalId,omitempty"`
	PinnedPnic             string                                  `xml:"pinnedPnic,omitempty"`
	IpRouteSpec            *HostVirtualNicIpRouteSpec              `xml:"ipRouteSpec,omitempty"`
	SystemOwned            *bool                                   `xml:"systemOwned"`
}

func init() {
	t["HostVirtualNicSpec"] = reflect.TypeOf((*HostVirtualNicSpec)(nil)).Elem()
}

type HostVirtualSwitch struct {
	DynamicData

	Name              string                `xml:"name"`
	Key               string                `xml:"key"`
	NumPorts          int32                 `xml:"numPorts"`
	NumPortsAvailable int32                 `xml:"numPortsAvailable"`
	Mtu               int32                 `xml:"mtu,omitempty"`
	Portgroup         []string              `xml:"portgroup,omitempty"`
	Pnic              []string              `xml:"pnic,omitempty"`
	Spec              HostVirtualSwitchSpec `xml:"spec"`
}

func init() {
	t["HostVirtualSwitch"] = reflect.TypeOf((*HostVirtualSwitch)(nil)).Elem()
}

type HostVirtualSwitchAutoBridge struct {
	HostVirtualSwitchBridge

	ExcludedNicDevice []string `xml:"excludedNicDevice,omitempty"`
}

func init() {
	t["HostVirtualSwitchAutoBridge"] = reflect.TypeOf((*HostVirtualSwitchAutoBridge)(nil)).Elem()
}

type HostVirtualSwitchBeaconConfig struct {
	DynamicData

	Interval int32 `xml:"interval"`
}

func init() {
	t["HostVirtualSwitchBeaconConfig"] = reflect.TypeOf((*HostVirtualSwitchBeaconConfig)(nil)).Elem()
}

type HostVirtualSwitchBondBridge struct {
	HostVirtualSwitchBridge

	NicDevice                   []string                       `xml:"nicDevice"`
	Beacon                      *HostVirtualSwitchBeaconConfig `xml:"beacon,omitempty"`
	LinkDiscoveryProtocolConfig *LinkDiscoveryProtocolConfig   `xml:"linkDiscoveryProtocolConfig,omitempty"`
}

func init() {
	t["HostVirtualSwitchBondBridge"] = reflect.TypeOf((*HostVirtualSwitchBondBridge)(nil)).Elem()
}

type HostVirtualSwitchBridge struct {
	DynamicData
}

func init() {
	t["HostVirtualSwitchBridge"] = reflect.TypeOf((*HostVirtualSwitchBridge)(nil)).Elem()
}

type HostVirtualSwitchConfig struct {
	DynamicData

	ChangeOperation string                 `xml:"changeOperation,omitempty"`
	Name            string                 `xml:"name"`
	Spec            *HostVirtualSwitchSpec `xml:"spec,omitempty"`
}

func init() {
	t["HostVirtualSwitchConfig"] = reflect.TypeOf((*HostVirtualSwitchConfig)(nil)).Elem()
}

type HostVirtualSwitchSimpleBridge struct {
	HostVirtualSwitchBridge

	NicDevice string `xml:"nicDevice"`
}

func init() {
	t["HostVirtualSwitchSimpleBridge"] = reflect.TypeOf((*HostVirtualSwitchSimpleBridge)(nil)).Elem()
}

type HostVirtualSwitchSpec struct {
	DynamicData

	NumPorts int32                       `xml:"numPorts"`
	Bridge   BaseHostVirtualSwitchBridge `xml:"bridge,omitempty,typeattr"`
	Policy   *HostNetworkPolicy          `xml:"policy,omitempty"`
	Mtu      int32                       `xml:"mtu,omitempty"`
}

func init() {
	t["HostVirtualSwitchSpec"] = reflect.TypeOf((*HostVirtualSwitchSpec)(nil)).Elem()
}

type HostVmciAccessManagerAccessSpec struct {
	DynamicData

	Vm       ManagedObjectReference `xml:"vm"`
	Services []string               `xml:"services,omitempty"`
	Mode     string                 `xml:"mode"`
}

func init() {
	t["HostVmciAccessManagerAccessSpec"] = reflect.TypeOf((*HostVmciAccessManagerAccessSpec)(nil)).Elem()
}

type HostVmfsRescanResult struct {
	DynamicData

	Host  ManagedObjectReference `xml:"host"`
	Fault *LocalizedMethodFault  `xml:"fault,omitempty"`
}

func init() {
	t["HostVmfsRescanResult"] = reflect.TypeOf((*HostVmfsRescanResult)(nil)).Elem()
}

type HostVmfsSpec struct {
	DynamicData

	Extent             HostScsiDiskPartition   `xml:"extent"`
	BlockSizeMb        int32                   `xml:"blockSizeMb,omitempty"`
	MajorVersion       int32                   `xml:"majorVersion"`
	VolumeName         string                  `xml:"volumeName"`
	BlockSize          int32                   `xml:"blockSize,omitempty"`
	UnmapGranularity   int32                   `xml:"unmapGranularity,omitempty"`
	UnmapPriority      string                  `xml:"unmapPriority,omitempty"`
	UnmapBandwidthSpec *VmfsUnmapBandwidthSpec `xml:"unmapBandwidthSpec,omitempty"`
}

func init() {
	t["HostVmfsSpec"] = reflect.TypeOf((*HostVmfsSpec)(nil)).Elem()
}

type HostVmfsVolume struct {
	HostFileSystemVolume

	BlockSizeMb        int32                   `xml:"blockSizeMb"`
	BlockSize          int32                   `xml:"blockSize,omitempty"`
	UnmapGranularity   int32                   `xml:"unmapGranularity,omitempty"`
	UnmapPriority      string                  `xml:"unmapPriority,omitempty"`
	UnmapBandwidthSpec *VmfsUnmapBandwidthSpec `xml:"unmapBandwidthSpec,omitempty"`
	MaxBlocks          int32                   `xml:"maxBlocks"`
	MajorVersion       int32                   `xml:"majorVersion"`
	Version            string                  `xml:"version"`
	Uuid               string                  `xml:"uuid"`
	Extent             []HostScsiDiskPartition `xml:"extent"`
	VmfsUpgradable     bool                    `xml:"vmfsUpgradable"`
	ForceMountedInfo   *HostForceMountedInfo   `xml:"forceMountedInfo,omitempty"`
	Ssd                *bool                   `xml:"ssd"`
	Local              *bool                   `xml:"local"`
	ScsiDiskType       string                  `xml:"scsiDiskType,omitempty"`
}

func init() {
	t["HostVmfsVolume"] = reflect.TypeOf((*HostVmfsVolume)(nil)).Elem()
}

type HostVnicConnectedToCustomizedDVPortEvent struct {
	HostEvent

	Vnic        VnicPortArgument `xml:"vnic"`
	PrevPortKey string           `xml:"prevPortKey,omitempty"`
}

func init() {
	t["HostVnicConnectedToCustomizedDVPortEvent"] = reflect.TypeOf((*HostVnicConnectedToCustomizedDVPortEvent)(nil)).Elem()
}

type HostVsanInternalSystemCmmdsQuery struct {
	DynamicData

	Type  string `xml:"type,omitempty"`
	Uuid  string `xml:"uuid,omitempty"`
	Owner string `xml:"owner,omitempty"`
}

func init() {
	t["HostVsanInternalSystemCmmdsQuery"] = reflect.TypeOf((*HostVsanInternalSystemCmmdsQuery)(nil)).Elem()
}

type HostVsanInternalSystemDeleteVsanObjectsResult struct {
	DynamicData

	Uuid          string               `xml:"uuid"`
	Success       bool                 `xml:"success"`
	FailureReason []LocalizableMessage `xml:"failureReason,omitempty"`
}

func init() {
	t["HostVsanInternalSystemDeleteVsanObjectsResult"] = reflect.TypeOf((*HostVsanInternalSystemDeleteVsanObjectsResult)(nil)).Elem()
}

type HostVsanInternalSystemVsanObjectOperationResult struct {
	DynamicData

	Uuid          string               `xml:"uuid"`
	FailureReason []LocalizableMessage `xml:"failureReason,omitempty"`
}

func init() {
	t["HostVsanInternalSystemVsanObjectOperationResult"] = reflect.TypeOf((*HostVsanInternalSystemVsanObjectOperationResult)(nil)).Elem()
}

type HostVsanInternalSystemVsanPhysicalDiskDiagnosticsResult struct {
	DynamicData

	DiskUuid      string `xml:"diskUuid"`
	Success       bool   `xml:"success"`
	FailureReason string `xml:"failureReason,omitempty"`
}

func init() {
	t["HostVsanInternalSystemVsanPhysicalDiskDiagnosticsResult"] = reflect.TypeOf((*HostVsanInternalSystemVsanPhysicalDiskDiagnosticsResult)(nil)).Elem()
}

type HostVvolVolume struct {
	HostFileSystemVolume

	ScId             string                `xml:"scId"`
	HostPE           []VVolHostPE          `xml:"hostPE,omitempty"`
	VasaProviderInfo []VimVasaProviderInfo `xml:"vasaProviderInfo,omitempty"`
	StorageArray     []VASAStorageArray    `xml:"storageArray,omitempty"`
}

func init() {
	t["HostVvolVolume"] = reflect.TypeOf((*HostVvolVolume)(nil)).Elem()
}

type HostVvolVolumeSpecification struct {
	DynamicData

	MaxSizeInMB      int64                 `xml:"maxSizeInMB"`
	VolumeName       string                `xml:"volumeName"`
	VasaProviderInfo []VimVasaProviderInfo `xml:"vasaProviderInfo,omitempty"`
	StorageArray     []VASAStorageArray    `xml:"storageArray,omitempty"`
	Uuid             string                `xml:"uuid"`
}

func init() {
	t["HostVvolVolumeSpecification"] = reflect.TypeOf((*HostVvolVolumeSpecification)(nil)).Elem()
}

type HostWwnChangedEvent struct {
	HostEvent

	OldNodeWwns []int64 `xml:"oldNodeWwns,omitempty"`
	OldPortWwns []int64 `xml:"oldPortWwns,omitempty"`
	NewNodeWwns []int64 `xml:"newNodeWwns,omitempty"`
	NewPortWwns []int64 `xml:"newPortWwns,omitempty"`
}

func init() {
	t["HostWwnChangedEvent"] = reflect.TypeOf((*HostWwnChangedEvent)(nil)).Elem()
}

type HostWwnConflictEvent struct {
	HostEvent

	ConflictedVms   []VmEventArgument   `xml:"conflictedVms,omitempty"`
	ConflictedHosts []HostEventArgument `xml:"conflictedHosts,omitempty"`
	Wwn             int64               `xml:"wwn"`
}

func init() {
	t["HostWwnConflictEvent"] = reflect.TypeOf((*HostWwnConflictEvent)(nil)).Elem()
}

type HotSnapshotMoveNotSupported struct {
	SnapshotCopyNotSupported
}

func init() {
	t["HotSnapshotMoveNotSupported"] = reflect.TypeOf((*HotSnapshotMoveNotSupported)(nil)).Elem()
}

type HotSnapshotMoveNotSupportedFault HotSnapshotMoveNotSupported

func init() {
	t["HotSnapshotMoveNotSupportedFault"] = reflect.TypeOf((*HotSnapshotMoveNotSupportedFault)(nil)).Elem()
}

type HourlyTaskScheduler struct {
	RecurrentTaskScheduler

	Minute int32 `xml:"minute"`
}

func init() {
	t["HourlyTaskScheduler"] = reflect.TypeOf((*HourlyTaskScheduler)(nil)).Elem()
}

type HttpFault struct {
	VimFault

	StatusCode    int32  `xml:"statusCode"`
	StatusMessage string `xml:"statusMessage"`
}

func init() {
	t["HttpFault"] = reflect.TypeOf((*HttpFault)(nil)).Elem()
}

type HttpFaultFault HttpFault

func init() {
	t["HttpFaultFault"] = reflect.TypeOf((*HttpFaultFault)(nil)).Elem()
}

type HttpNfcLeaseAbort HttpNfcLeaseAbortRequestType

func init() {
	t["HttpNfcLeaseAbort"] = reflect.TypeOf((*HttpNfcLeaseAbort)(nil)).Elem()
}

type HttpNfcLeaseAbortRequestType struct {
	This  ManagedObjectReference `xml:"_this"`
	Fault *LocalizedMethodFault  `xml:"fault,omitempty"`
}

func init() {
	t["HttpNfcLeaseAbortRequestType"] = reflect.TypeOf((*HttpNfcLeaseAbortRequestType)(nil)).Elem()
}

type HttpNfcLeaseAbortResponse struct {
}

type HttpNfcLeaseCapabilities struct {
	DynamicData

	PullModeSupported bool `xml:"pullModeSupported"`
	CorsSupported     bool `xml:"corsSupported"`
}

func init() {
	t["HttpNfcLeaseCapabilities"] = reflect.TypeOf((*HttpNfcLeaseCapabilities)(nil)).Elem()
}

type HttpNfcLeaseComplete HttpNfcLeaseCompleteRequestType

func init() {
	t["HttpNfcLeaseComplete"] = reflect.TypeOf((*HttpNfcLeaseComplete)(nil)).Elem()
}

type HttpNfcLeaseCompleteRequestType struct {
	This ManagedObjectReference `xml:"_this"`
}

func init() {
	t["HttpNfcLeaseCompleteRequestType"] = reflect.TypeOf((*HttpNfcLeaseCompleteRequestType)(nil)).Elem()
}

type HttpNfcLeaseCompleteResponse struct {
}

type HttpNfcLeaseDatastoreLeaseInfo struct {
	DynamicData

	DatastoreKey string                 `xml:"datastoreKey"`
	Hosts        []HttpNfcLeaseHostInfo `xml:"hosts"`
}

func init() {
	t["HttpNfcLeaseDatastoreLeaseInfo"] = reflect.TypeOf((*HttpNfcLeaseDatastoreLeaseInfo)(nil)).Elem()
}

type HttpNfcLeaseDeviceUrl struct {
	DynamicData

	Key           string `xml:"key"`
	ImportKey     string `xml:"importKey"`
	Url           string `xml:"url"`
	SslThumbprint string `xml:"sslThumbprint"`
	Disk          *bool  `xml:"disk"`
	TargetId      string `xml:"targetId,omitempty"`
	DatastoreKey  string `xml:"datastoreKey,omitempty"`
	FileSize      int64  `xml:"fileSize,omitempty"`
}

func init() {
	t["HttpNfcLeaseDeviceUrl"] = reflect.TypeOf((*HttpNfcLeaseDeviceUrl)(nil)).Elem()
}

type HttpNfcLeaseGetManifest HttpNfcLeaseGetManifestRequestType

func init() {
	t["HttpNfcLeaseGetManifest"] = reflect.TypeOf((*HttpNfcLeaseGetManifest)(nil)).Elem()
}

type HttpNfcLeaseGetManifestRequestType struct {
	This ManagedObjectReference `xml:"_this"`
}

func init() {
	t["HttpNfcLeaseGetManifestRequestType"] = reflect.TypeOf((*HttpNfcLeaseGetManifestRequestType)(nil)).Elem()
}

type HttpNfcLeaseGetManifestResponse struct {
	Returnval []HttpNfcLeaseManifestEntry `xml:"returnval,omitempty"`
}

type HttpNfcLeaseHostInfo struct {
	DynamicData

	Url           string `xml:"url"`
	SslThumbprint string `xml:"sslThumbprint"`
}

func init() {
	t["HttpNfcLeaseHostInfo"] = reflect.TypeOf((*HttpNfcLeaseHostInfo)(nil)).Elem()
}

type HttpNfcLeaseInfo struct {
	DynamicData

	Lease                 ManagedObjectReference           `xml:"lease"`
	Entity                ManagedObjectReference           `xml:"entity"`
	DeviceUrl             []HttpNfcLeaseDeviceUrl          `xml:"deviceUrl,omitempty"`
	TotalDiskCapacityInKB int64                            `xml:"totalDiskCapacityInKB"`
	LeaseTimeout          int32                            `xml:"leaseTimeout"`
	HostMap               []HttpNfcLeaseDatastoreLeaseInfo `xml:"hostMap,omitempty"`
}

func init() {
	t["HttpNfcLeaseInfo"] = reflect.TypeOf((*HttpNfcLeaseInfo)(nil)).Elem()
}

type HttpNfcLeaseManifestEntry struct {
	DynamicData

	Key           string `xml:"key"`
	Sha1          string `xml:"sha1"`
	Checksum      string `xml:"checksum,omitempty"`
	ChecksumType  string `xml:"checksumType,omitempty"`
	Size          int64  `xml:"size"`
	Disk          bool   `xml:"disk"`
	Capacity      int64  `xml:"capacity,omitempty"`
	PopulatedSize int64  `xml:"populatedSize,omitempty"`
}

func init() {
	t["HttpNfcLeaseManifestEntry"] = reflect.TypeOf((*HttpNfcLeaseManifestEntry)(nil)).Elem()
}

type HttpNfcLeaseProbeResult struct {
	DynamicData

	ServerAccessible bool `xml:"serverAccessible"`
}

func init() {
	t["HttpNfcLeaseProbeResult"] = reflect.TypeOf((*HttpNfcLeaseProbeResult)(nil)).Elem()
}

type HttpNfcLeaseProbeUrls HttpNfcLeaseProbeUrlsRequestType

func init() {
	t["HttpNfcLeaseProbeUrls"] = reflect.TypeOf((*HttpNfcLeaseProbeUrls)(nil)).Elem()
}

type HttpNfcLeaseProbeUrlsRequestType struct {
	This    ManagedObjectReference   `xml:"_this"`
	Files   []HttpNfcLeaseSourceFile `xml:"files,omitempty"`
	Timeout int32                    `xml:"timeout,omitempty"`
}

func init() {
	t["HttpNfcLeaseProbeUrlsRequestType"] = reflect.TypeOf((*HttpNfcLeaseProbeUrlsRequestType)(nil)).Elem()
}

type HttpNfcLeaseProbeUrlsResponse struct {
	Returnval []HttpNfcLeaseProbeResult `xml:"returnval,omitempty"`
}

type HttpNfcLeaseProgress HttpNfcLeaseProgressRequestType

func init() {
	t["HttpNfcLeaseProgress"] = reflect.TypeOf((*HttpNfcLeaseProgress)(nil)).Elem()
}

type HttpNfcLeaseProgressRequestType struct {
	This    ManagedObjectReference `xml:"_this"`
	Percent int32                  `xml:"percent"`
}

func init() {
	t["HttpNfcLeaseProgressRequestType"] = reflect.TypeOf((*HttpNfcLeaseProgressRequestType)(nil)).Elem()
}

type HttpNfcLeaseProgressResponse struct {
}

type HttpNfcLeasePullFromUrlsRequestType struct {
	This  ManagedObjectReference   `xml:"_this"`
	Files []HttpNfcLeaseSourceFile `xml:"files,omitempty"`
}

func init() {
	t["HttpNfcLeasePullFromUrlsRequestType"] = reflect.TypeOf((*HttpNfcLeasePullFromUrlsRequestType)(nil)).Elem()
}

type HttpNfcLeasePullFromUrls_Task HttpNfcLeasePullFromUrlsRequestType

func init() {
	t["HttpNfcLeasePullFromUrls_Task"] = reflect.TypeOf((*HttpNfcLeasePullFromUrls_Task)(nil)).Elem()
}

type HttpNfcLeasePullFromUrls_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval"`
}

type HttpNfcLeaseSetManifestChecksumType HttpNfcLeaseSetManifestChecksumTypeRequestType

func init() {
	t["HttpNfcLeaseSetManifestChecksumType"] = reflect.TypeOf((*HttpNfcLeaseSetManifestChecksumType)(nil)).Elem()
}

type HttpNfcLeaseSetManifestChecksumTypeRequestType struct {
	This                      ManagedObjectReference `xml:"_this"`
	DeviceUrlsToChecksumTypes []KeyValue             `xml:"deviceUrlsToChecksumTypes,omitempty"`
}

func init() {
	t["HttpNfcLeaseSetManifestChecksumTypeRequestType"] = reflect.TypeOf((*HttpNfcLeaseSetManifestChecksumTypeRequestType)(nil)).Elem()
}

type HttpNfcLeaseSetManifestChecksumTypeResponse struct {
}

type HttpNfcLeaseSourceFile struct {
	DynamicData

	TargetDeviceId string     `xml:"targetDeviceId"`
	Url            string     `xml:"url"`
	MemberName     string     `xml:"memberName,omitempty"`
	Create         bool       `xml:"create"`
	SslThumbprint  string     `xml:"sslThumbprint,omitempty"`
	HttpHeaders    []KeyValue `xml:"httpHeaders,omitempty"`
	Size           int64      `xml:"size,omitempty"`
}

func init() {
	t["HttpNfcLeaseSourceFile"] = reflect.TypeOf((*HttpNfcLeaseSourceFile)(nil)).Elem()
}

type ID struct {
	DynamicData

	Id string `xml:"id"`
}

func init() {
	t["ID"] = reflect.TypeOf((*ID)(nil)).Elem()
}

type IDEDiskNotSupported struct {
	DiskNotSupported
}

func init() {
	t["IDEDiskNotSupported"] = reflect.TypeOf((*IDEDiskNotSupported)(nil)).Elem()
}

type IDEDiskNotSupportedFault IDEDiskNotSupported

func init() {
	t["IDEDiskNotSupportedFault"] = reflect.TypeOf((*IDEDiskNotSupportedFault)(nil)).Elem()
}

type IORMNotSupportedHostOnDatastore struct {
	VimFault

	Datastore     ManagedObjectReference   `xml:"datastore"`
	DatastoreName string                   `xml:"datastoreName"`
	Host          []ManagedObjectReference `xml:"host,omitempty"`
}

func init() {
	t["IORMNotSupportedHostOnDatastore"] = reflect.TypeOf((*IORMNotSupportedHostOnDatastore)(nil)).Elem()
}

type IORMNotSupportedHostOnDatastoreFault IORMNotSupportedHostOnDatastore

func init() {
	t["IORMNotSupportedHostOnDatastoreFault"] = reflect.TypeOf((*IORMNotSupportedHostOnDatastoreFault)(nil)).Elem()
}

type IScsiBootFailureEvent struct {
	HostEvent
}

func init() {
	t["IScsiBootFailureEvent"] = reflect.TypeOf((*IScsiBootFailureEvent)(nil)).Elem()
}

type ImpersonateUser ImpersonateUserRequestType

func init() {
	t["ImpersonateUser"] = reflect.TypeOf((*ImpersonateUser)(nil)).Elem()
}

type ImpersonateUserRequestType struct {
	This     ManagedObjectReference `xml:"_this"`
	UserName string                 `xml:"userName"`
	Locale   string                 `xml:"locale,omitempty"`
}

func init() {
	t["ImpersonateUserRequestType"] = reflect.TypeOf((*ImpersonateUserRequestType)(nil)).Elem()
}

type ImpersonateUserResponse struct {
	Returnval UserSession `xml:"returnval"`
}

type ImportCertificateForCAMRequestType struct {
	This      ManagedObjectReference `xml:"_this"`
	CertPath  string                 `xml:"certPath"`
	CamServer string                 `xml:"camServer"`
}

func init() {
	t["ImportCertificateForCAMRequestType"] = reflect.TypeOf((*ImportCertificateForCAMRequestType)(nil)).Elem()
}

type ImportCertificateForCAM_Task ImportCertificateForCAMRequestType

func init() {
	t["ImportCertificateForCAM_Task"] = reflect.TypeOf((*ImportCertificateForCAM_Task)(nil)).Elem()
}

type ImportCertificateForCAM_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval"`
}

type ImportHostAddFailure struct {
	DvsFault

	HostIp []string `xml:"hostIp"`
}

func init() {
	t["ImportHostAddFailure"] = reflect.TypeOf((*ImportHostAddFailure)(nil)).Elem()
}

type ImportHostAddFailureFault ImportHostAddFailure

func init() {
	t["ImportHostAddFailureFault"] = reflect.TypeOf((*ImportHostAddFailureFault)(nil)).Elem()
}

type ImportOperationBulkFault struct {
	DvsFault

	ImportFaults []ImportOperationBulkFaultFaultOnImport `xml:"importFaults"`
}

func init() {
	t["ImportOperationBulkFault"] = reflect.TypeOf((*ImportOperationBulkFault)(nil)).Elem()
}

type ImportOperationBulkFaultFault ImportOperationBulkFault

func init() {
	t["ImportOperationBulkFaultFault"] = reflect.TypeOf((*ImportOperationBulkFaultFault)(nil)).Elem()
}

type ImportOperationBulkFaultFaultOnImport struct {
	DynamicData

	EntityType string               `xml:"entityType,omitempty"`
	Key        string               `xml:"key,omitempty"`
	Fault      LocalizedMethodFault `xml:"fault"`
}

func init() {
	t["ImportOperationBulkFaultFaultOnImport"] = reflect.TypeOf((*ImportOperationBulkFaultFaultOnImport)(nil)).Elem()
}

type ImportSpec struct {
	DynamicData

	EntityConfig     *VAppEntityConfigInfo `xml:"entityConfig,omitempty"`
	InstantiationOst *OvfConsumerOstNode   `xml:"instantiationOst,omitempty"`
}

func init() {
	t["ImportSpec"] = reflect.TypeOf((*ImportSpec)(nil)).Elem()
}

type ImportUnmanagedSnapshot ImportUnmanagedSnapshotRequestType

func init() {
	t["ImportUnmanagedSnapshot"] = reflect.TypeOf((*ImportUnmanagedSnapshot)(nil)).Elem()
}

type ImportUnmanagedSnapshotRequestType struct {
	This       ManagedObjectReference  `xml:"_this"`
	Vdisk      string                  `xml:"vdisk"`
	Datacenter *ManagedObjectReference `xml:"datacenter,omitempty"`
	VvolId     string                  `xml:"vvolId"`
}

func init() {
	t["ImportUnmanagedSnapshotRequestType"] = reflect.TypeOf((*ImportUnmanagedSnapshotRequestType)(nil)).Elem()
}

type ImportUnmanagedSnapshotResponse struct {
}

type ImportVApp ImportVAppRequestType

func init() {
	t["ImportVApp"] = reflect.TypeOf((*ImportVApp)(nil)).Elem()
}

type ImportVAppRequestType struct {
	This   ManagedObjectReference  `xml:"_this"`
	Spec   BaseImportSpec          `xml:"spec,typeattr"`
	Folder *ManagedObjectReference `xml:"folder,omitempty"`
	Host   *ManagedObjectReference `xml:"host,omitempty"`
}

func init() {
	t["ImportVAppRequestType"] = reflect.TypeOf((*ImportVAppRequestType)(nil)).Elem()
}

type ImportVAppResponse struct {
	Returnval ManagedObjectReference `xml:"returnval"`
}

type InUseFeatureManipulationDisallowed struct {
	NotEnoughLicenses
}

func init() {
	t["InUseFeatureManipulationDisallowed"] = reflect.TypeOf((*InUseFeatureManipulationDisallowed)(nil)).Elem()
}

type InUseFeatureManipulationDisallowedFault InUseFeatureManipulationDisallowed

func init() {
	t["InUseFeatureManipulationDisallowedFault"] = reflect.TypeOf((*InUseFeatureManipulationDisallowedFault)(nil)).Elem()
}

type InaccessibleDatastore struct {
	InvalidDatastore

	Detail string `xml:"detail,omitempty"`
}

func init() {
	t["InaccessibleDatastore"] = reflect.TypeOf((*InaccessibleDatastore)(nil)).Elem()
}

type InaccessibleDatastoreFault BaseInaccessibleDatastore

func init() {
	t["InaccessibleDatastoreFault"] = reflect.TypeOf((*InaccessibleDatastoreFault)(nil)).Elem()
}

type InaccessibleFTMetadataDatastore struct {
	InaccessibleDatastore
}

func init() {
	t["InaccessibleFTMetadataDatastore"] = reflect.TypeOf((*InaccessibleFTMetadataDatastore)(nil)).Elem()
}

type InaccessibleFTMetadataDatastoreFault InaccessibleFTMetadataDatastore

func init() {
	t["InaccessibleFTMetadataDatastoreFault"] = reflect.TypeOf((*InaccessibleFTMetadataDatastoreFault)(nil)).Elem()
}

type InaccessibleVFlashSource struct {
	VimFault

	HostName string `xml:"hostName"`
}

func init() {
	t["InaccessibleVFlashSource"] = reflect.TypeOf((*InaccessibleVFlashSource)(nil)).Elem()
}

type InaccessibleVFlashSourceFault InaccessibleVFlashSource

func init() {
	t["InaccessibleVFlashSourceFault"] = reflect.TypeOf((*InaccessibleVFlashSourceFault)(nil)).Elem()
}

type IncompatibleDefaultDevice struct {
	MigrationFault

	Device string `xml:"device"`
}

func init() {
	t["IncompatibleDefaultDevice"] = reflect.TypeOf((*IncompatibleDefaultDevice)(nil)).Elem()
}

type IncompatibleDefaultDeviceFault IncompatibleDefaultDevice

func init() {
	t["IncompatibleDefaultDeviceFault"] = reflect.TypeOf((*IncompatibleDefaultDeviceFault)(nil)).Elem()
}

type IncompatibleHostForFtSecondary struct {
	VmFaultToleranceIssue

	Host  ManagedObjectReference `xml:"host"`
	Error []LocalizedMethodFault `xml:"error,omitempty"`
}

func init() {
	t["IncompatibleHostForFtSecondary"] = reflect.TypeOf((*IncompatibleHostForFtSecondary)(nil)).Elem()
}

type IncompatibleHostForFtSecondaryFault IncompatibleHostForFtSecondary

func init() {
	t["IncompatibleHostForFtSecondaryFault"] = reflect.TypeOf((*IncompatibleHostForFtSecondaryFault)(nil)).Elem()
}

type IncompatibleHostForVmReplication struct {
	ReplicationFault

	VmName   string `xml:"vmName"`
	HostName string `xml:"hostName"`
	Reason   string `xml:"reason"`
}

func init() {
	t["IncompatibleHostForVmReplication"] = reflect.TypeOf((*IncompatibleHostForVmReplication)(nil)).Elem()
}

type IncompatibleHostForVmReplicationFault IncompatibleHostForVmReplication

func init() {
	t["IncompatibleHostForVmReplicationFault"] = reflect.TypeOf((*IncompatibleHostForVmReplicationFault)(nil)).Elem()
}

type IncompatibleSetting struct {
	InvalidArgument

	ConflictingProperty string `xml:"conflictingProperty"`
}

func init() {
	t["IncompatibleSetting"] = reflect.TypeOf((*IncompatibleSetting)(nil)).Elem()
}

type IncompatibleSettingFault IncompatibleSetting

func init() {
	t["IncompatibleSettingFault"] = reflect.TypeOf((*IncompatibleSettingFault)(nil)).Elem()
}

type IncorrectFileType struct {
	FileFault
}

func init() {
	t["IncorrectFileType"] = reflect.TypeOf((*IncorrectFileType)(nil)).Elem()
}

type IncorrectFileTypeFault IncorrectFileType

func init() {
	t["IncorrectFileTypeFault"] = reflect.TypeOf((*IncorrectFileTypeFault)(nil)).Elem()
}

type IncorrectHostInformation struct {
	NotEnoughLicenses
}

func init() {
	t["IncorrectHostInformation"] = reflect.TypeOf((*IncorrectHostInformation)(nil)).Elem()
}

type IncorrectHostInformationEvent struct {
	LicenseEvent
}

func init() {
	t["IncorrectHostInformationEvent"] = reflect.TypeOf((*IncorrectHostInformationEvent)(nil)).Elem()
}

type IncorrectHostInformationFault IncorrectHostInformation

func init() {
	t["IncorrectHostInformationFault"] = reflect.TypeOf((*IncorrectHostInformationFault)(nil)).Elem()
}

type IndependentDiskVMotionNotSupported struct {
	MigrationFeatureNotSupported
}

func init() {
	t["IndependentDiskVMotionNotSupported"] = reflect.TypeOf((*IndependentDiskVMotionNotSupported)(nil)).Elem()
}

type IndependentDiskVMotionNotSupportedFault IndependentDiskVMotionNotSupported

func init() {
	t["IndependentDiskVMotionNotSupportedFault"] = reflect.TypeOf((*IndependentDiskVMotionNotSupportedFault)(nil)).Elem()
}

type InflateDiskRequestType struct {
	This      ManagedObjectReference `xml:"_this"`
	Id        ID                     `xml:"id"`
	Datastore ManagedObjectReference `xml:"datastore"`
}

func init() {
	t["InflateDiskRequestType"] = reflect.TypeOf((*InflateDiskRequestType)(nil)).Elem()
}

type InflateDisk_Task InflateDiskRequestType

func init() {
	t["InflateDisk_Task"] = reflect.TypeOf((*InflateDisk_Task)(nil)).Elem()
}

type InflateDisk_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval"`
}

type InflateVirtualDiskRequestType struct {
	This       ManagedObjectReference  `xml:"_this"`
	Name       string                  `xml:"name"`
	Datacenter *ManagedObjectReference `xml:"datacenter,omitempty"`
}

func init() {
	t["InflateVirtualDiskRequestType"] = reflect.TypeOf((*InflateVirtualDiskRequestType)(nil)).Elem()
}

type InflateVirtualDisk_Task InflateVirtualDiskRequestType

func init() {
	t["InflateVirtualDisk_Task"] = reflect.TypeOf((*InflateVirtualDisk_Task)(nil)).Elem()
}

type InflateVirtualDisk_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval"`
}

type InfoUpgradeEvent struct {
	UpgradeEvent
}

func init() {
	t["InfoUpgradeEvent"] = reflect.TypeOf((*InfoUpgradeEvent)(nil)).Elem()
}

type InheritablePolicy struct {
	DynamicData

	Inherited bool `xml:"inherited"`
}

func init() {
	t["InheritablePolicy"] = reflect.TypeOf((*InheritablePolicy)(nil)).Elem()
}

type InitializeDisksRequestType struct {
	This    ManagedObjectReference `xml:"_this"`
	Mapping []VsanHostDiskMapping  `xml:"mapping"`
}

func init() {
	t["InitializeDisksRequestType"] = reflect.TypeOf((*InitializeDisksRequestType)(nil)).Elem()
}

type InitializeDisks_Task InitializeDisksRequestType

func init() {
	t["InitializeDisks_Task"] = reflect.TypeOf((*InitializeDisks_Task)(nil)).Elem()
}

type InitializeDisks_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval"`
}

type InitiateFileTransferFromGuest InitiateFileTransferFromGuestRequestType

func init() {
	t["InitiateFileTransferFromGuest"] = reflect.TypeOf((*InitiateFileTransferFromGuest)(nil)).Elem()
}

type InitiateFileTransferFromGuestRequestType struct {
	This          ManagedObjectReference  `xml:"_this"`
	Vm            ManagedObjectReference  `xml:"vm"`
	Auth          BaseGuestAuthentication `xml:"auth,typeattr"`
	GuestFilePath string                  `xml:"guestFilePath"`
}

func init() {
	t["InitiateFileTransferFromGuestRequestType"] = reflect.TypeOf((*InitiateFileTransferFromGuestRequestType)(nil)).Elem()
}

type InitiateFileTransferFromGuestResponse struct {
	Returnval FileTransferInformation `xml:"returnval"`
}

type InitiateFileTransferToGuest InitiateFileTransferToGuestRequestType

func init() {
	t["InitiateFileTransferToGuest"] = reflect.TypeOf((*InitiateFileTransferToGuest)(nil)).Elem()
}

type InitiateFileTransferToGuestRequestType struct {
	This           ManagedObjectReference  `xml:"_this"`
	Vm             ManagedObjectReference  `xml:"vm"`
	Auth           BaseGuestAuthentication `xml:"auth,typeattr"`
	GuestFilePath  string                  `xml:"guestFilePath"`
	FileAttributes BaseGuestFileAttributes `xml:"fileAttributes,typeattr"`
	FileSize       int64                   `xml:"fileSize"`
	Overwrite      bool                    `xml:"overwrite"`
}

func init() {
	t["InitiateFileTransferToGuestRequestType"] = reflect.TypeOf((*InitiateFileTransferToGuestRequestType)(nil)).Elem()
}

type InitiateFileTransferToGuestResponse struct {
	Returnval string `xml:"returnval"`
}

type InstallHostPatchRequestType struct {
	This       ManagedObjectReference  `xml:"_this"`
	Repository HostPatchManagerLocator `xml:"repository"`
	UpdateID   string                  `xml:"updateID"`
	Force      *bool                   `xml:"force"`
}

func init() {
	t["InstallHostPatchRequestType"] = reflect.TypeOf((*InstallHostPatchRequestType)(nil)).Elem()
}

type InstallHostPatchV2RequestType struct {
	This       ManagedObjectReference                     `xml:"_this"`
	MetaUrls   []string                                   `xml:"metaUrls,omitempty"`
	BundleUrls []string                                   `xml:"bundleUrls,omitempty"`
	VibUrls    []string                                   `xml:"vibUrls,omitempty"`
	Spec       *HostPatchManagerPatchManagerOperationSpec `xml:"spec,omitempty"`
}

func init() {
	t["InstallHostPatchV2RequestType"] = reflect.TypeOf((*InstallHostPatchV2RequestType)(nil)).Elem()
}

type InstallHostPatchV2_Task InstallHostPatchV2RequestType

func init() {
	t["InstallHostPatchV2_Task"] = reflect.TypeOf((*InstallHostPatchV2_Task)(nil)).Elem()
}

type InstallHostPatchV2_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval"`
}

type InstallHostPatch_Task InstallHostPatchRequestType

func init() {
	t["InstallHostPatch_Task"] = reflect.TypeOf((*InstallHostPatch_Task)(nil)).Elem()
}

type InstallHostPatch_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval"`
}

type InstallIoFilterRequestType struct {
	This    ManagedObjectReference `xml:"_this"`
	VibUrl  string                 `xml:"vibUrl"`
	CompRes ManagedObjectReference `xml:"compRes"`
}

func init() {
	t["InstallIoFilterRequestType"] = reflect.TypeOf((*InstallIoFilterRequestType)(nil)).Elem()
}

type InstallIoFilter_Task InstallIoFilterRequestType

func init() {
	t["InstallIoFilter_Task"] = reflect.TypeOf((*InstallIoFilter_Task)(nil)).Elem()
}

type InstallIoFilter_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval"`
}

type InstallServerCertificate InstallServerCertificateRequestType

func init() {
	t["InstallServerCertificate"] = reflect.TypeOf((*InstallServerCertificate)(nil)).Elem()
}

type InstallServerCertificateRequestType struct {
	This ManagedObjectReference `xml:"_this"`
	Cert string                 `xml:"cert"`
}

func init() {
	t["InstallServerCertificateRequestType"] = reflect.TypeOf((*InstallServerCertificateRequestType)(nil)).Elem()
}

type InstallServerCertificateResponse struct {
}

type InstallSmartCardTrustAnchor InstallSmartCardTrustAnchorRequestType

func init() {
	t["InstallSmartCardTrustAnchor"] = reflect.TypeOf((*InstallSmartCardTrustAnchor)(nil)).Elem()
}

type InstallSmartCardTrustAnchorRequestType struct {
	This ManagedObjectReference `xml:"_this"`
	Cert string                 `xml:"cert"`
}

func init() {
	t["InstallSmartCardTrustAnchorRequestType"] = reflect.TypeOf((*InstallSmartCardTrustAnchorRequestType)(nil)).Elem()
}

type InstallSmartCardTrustAnchorResponse struct {
}

type InstantCloneRequestType struct {
	This ManagedObjectReference         `xml:"_this"`
	Spec VirtualMachineInstantCloneSpec `xml:"spec"`
}

func init() {
	t["InstantCloneRequestType"] = reflect.TypeOf((*InstantCloneRequestType)(nil)).Elem()
}

type InstantClone_Task InstantCloneRequestType

func init() {
	t["InstantClone_Task"] = reflect.TypeOf((*InstantClone_Task)(nil)).Elem()
}

type InstantClone_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval"`
}

type InsufficientAgentVmsDeployed struct {
	InsufficientResourcesFault

	HostName            string `xml:"hostName"`
	RequiredNumAgentVms int32  `xml:"requiredNumAgentVms"`
	CurrentNumAgentVms  int32  `xml:"currentNumAgentVms"`
}

func init() {
	t["InsufficientAgentVmsDeployed"] = reflect.TypeOf((*InsufficientAgentVmsDeployed)(nil)).Elem()
}

type InsufficientAgentVmsDeployedFault InsufficientAgentVmsDeployed

func init() {
	t["InsufficientAgentVmsDeployedFault"] = reflect.TypeOf((*InsufficientAgentVmsDeployedFault)(nil)).Elem()
}

type InsufficientCpuResourcesFault struct {
	InsufficientResourcesFault

	Unreserved int64 `xml:"unreserved"`
	Requested  int64 `xml:"requested"`
}

func init() {
	t["InsufficientCpuResourcesFault"] = reflect.TypeOf((*InsufficientCpuResourcesFault)(nil)).Elem()
}

type InsufficientCpuResourcesFaultFault InsufficientCpuResourcesFault

func init() {
	t["InsufficientCpuResourcesFaultFault"] = reflect.TypeOf((*InsufficientCpuResourcesFaultFault)(nil)).Elem()
}

type InsufficientDisks struct {
	VsanDiskFault
}

func init() {
	t["InsufficientDisks"] = reflect.TypeOf((*InsufficientDisks)(nil)).Elem()
}

type InsufficientDisksFault InsufficientDisks

func init() {
	t["InsufficientDisksFault"] = reflect.TypeOf((*InsufficientDisksFault)(nil)).Elem()
}

type InsufficientFailoverResourcesEvent struct {
	ClusterEvent
}

func init() {
	t["InsufficientFailoverResourcesEvent"] = reflect.TypeOf((*InsufficientFailoverResourcesEvent)(nil)).Elem()
}

type InsufficientFailoverResourcesFault struct {
	InsufficientResourcesFault
}

func init() {
	t["InsufficientFailoverResourcesFault"] = reflect.TypeOf((*InsufficientFailoverResourcesFault)(nil)).Elem()
}

type InsufficientFailoverResourcesFaultFault InsufficientFailoverResourcesFault

func init() {
	t["InsufficientFailoverResourcesFaultFault"] = reflect.TypeOf((*InsufficientFailoverResourcesFaultFault)(nil)).Elem()
}

type InsufficientGraphicsResourcesFault struct {
	InsufficientResourcesFault
}

func init() {
	t["InsufficientGraphicsResourcesFault"] = reflect.TypeOf((*InsufficientGraphicsResourcesFault)(nil)).Elem()
}

type InsufficientGraphicsResourcesFaultFault InsufficientGraphicsResourcesFault

func init() {
	t["InsufficientGraphicsResourcesFaultFault"] = reflect.TypeOf((*InsufficientGraphicsResourcesFaultFault)(nil)).Elem()
}

type InsufficientHostCapacityFault struct {
	InsufficientResourcesFault

	Host *ManagedObjectReference `xml:"host,omitempty"`
}

func init() {
	t["InsufficientHostCapacityFault"] = reflect.TypeOf((*InsufficientHostCapacityFault)(nil)).Elem()
}

type InsufficientHostCapacityFaultFault BaseInsufficientHostCapacityFault

func init() {
	t["InsufficientHostCapacityFaultFault"] = reflect.TypeOf((*InsufficientHostCapacityFaultFault)(nil)).Elem()
}

type InsufficientHostCpuCapacityFault struct {
	InsufficientHostCapacityFault

	Unreserved int64 `xml:"unreserved"`
	Requested  int64 `xml:"requested"`
}

func init() {
	t["InsufficientHostCpuCapacityFault"] = reflect.TypeOf((*InsufficientHostCpuCapacityFault)(nil)).Elem()
}

type InsufficientHostCpuCapacityFaultFault InsufficientHostCpuCapacityFault

func init() {
	t["InsufficientHostCpuCapacityFaultFault"] = reflect.TypeOf((*InsufficientHostCpuCapacityFaultFault)(nil)).Elem()
}

type InsufficientHostMemoryCapacityFault struct {
	InsufficientHostCapacityFault

	Unreserved int64 `xml:"unreserved"`
	Requested  int64 `xml:"requested"`
}

func init() {
	t["InsufficientHostMemoryCapacityFault"] = reflect.TypeOf((*InsufficientHostMemoryCapacityFault)(nil)).Elem()
}

type InsufficientHostMemoryCapacityFaultFault InsufficientHostMemoryCapacityFault

func init() {
	t["InsufficientHostMemoryCapacityFaultFault"] = reflect.TypeOf((*InsufficientHostMemoryCapacityFaultFault)(nil)).Elem()
}

type InsufficientMemoryResourcesFault struct {
	InsufficientResourcesFault

	Unreserved int64 `xml:"unreserved"`
	Requested  int64 `xml:"requested"`
}

func init() {
	t["InsufficientMemoryResourcesFault"] = reflect.TypeOf((*InsufficientMemoryResourcesFault)(nil)).Elem()
}

type InsufficientMemoryResourcesFaultFault InsufficientMemoryResourcesFault

func init() {
	t["InsufficientMemoryResourcesFaultFault"] = reflect.TypeOf((*InsufficientMemoryResourcesFaultFault)(nil)).Elem()
}

type InsufficientNetworkCapacity struct {
	InsufficientResourcesFault
}

func init() {
	t["InsufficientNetworkCapacity"] = reflect.TypeOf((*InsufficientNetworkCapacity)(nil)).Elem()
}

type InsufficientNetworkCapacityFault InsufficientNetworkCapacity

func init() {
	t["InsufficientNetworkCapacityFault"] = reflect.TypeOf((*InsufficientNetworkCapacityFault)(nil)).Elem()
}

type InsufficientNetworkResourcePoolCapacity struct {
	InsufficientResourcesFault

	DvsName         string   `xml:"dvsName"`
	DvsUuid         string   `xml:"dvsUuid"`
	ResourcePoolKey string   `xml:"resourcePoolKey"`
	Available       int64    `xml:"available"`
	Requested       int64    `xml:"requested"`
	Device          []string `xml:"device"`
}

func init() {
	t["InsufficientNetworkResourcePoolCapacity"] = reflect.TypeOf((*InsufficientNetworkResourcePoolCapacity)(nil)).Elem()
}

type InsufficientNetworkResourcePoolCapacityFault InsufficientNetworkResourcePoolCapacity

func init() {
	t["InsufficientNetworkResourcePoolCapacityFault"] = reflect.TypeOf((*InsufficientNetworkResourcePoolCapacityFault)(nil)).Elem()
}

type InsufficientPerCpuCapacity struct {
	InsufficientHostCapacityFault
}

func init() {
	t["InsufficientPerCpuCapacity"] = reflect.TypeOf((*InsufficientPerCpuCapacity)(nil)).Elem()
}

type InsufficientPerCpuCapacityFault InsufficientPerCpuCapacity

func init() {
	t["InsufficientPerCpuCapacityFault"] = reflect.TypeOf((*InsufficientPerCpuCapacityFault)(nil)).Elem()
}

type InsufficientResourcesFault struct {
	VimFault
}

func init() {
	t["InsufficientResourcesFault"] = reflect.TypeOf((*InsufficientResourcesFault)(nil)).Elem()
}

type InsufficientResourcesFaultFault BaseInsufficientResourcesFault

func init() {
	t["InsufficientResourcesFaultFault"] = reflect.TypeOf((*InsufficientResourcesFaultFault)(nil)).Elem()
}

type InsufficientStandbyCpuResource struct {
	InsufficientStandbyResource

	Available int64 `xml:"available"`
	Requested int64 `xml:"requested"`
}

func init() {
	t["InsufficientStandbyCpuResource"] = reflect.TypeOf((*InsufficientStandbyCpuResource)(nil)).Elem()
}

type InsufficientStandbyCpuResourceFault InsufficientStandbyCpuResource

func init() {
	t["InsufficientStandbyCpuResourceFault"] = reflect.TypeOf((*InsufficientStandbyCpuResourceFault)(nil)).Elem()
}

type InsufficientStandbyMemoryResource struct {
	InsufficientStandbyResource

	Available int64 `xml:"available"`
	Requested int64 `xml:"requested"`
}

func init() {
	t["InsufficientStandbyMemoryResource"] = reflect.TypeOf((*InsufficientStandbyMemoryResource)(nil)).Elem()
}

type InsufficientStandbyMemoryResourceFault InsufficientStandbyMemoryResource

func init() {
	t["InsufficientStandbyMemoryResourceFault"] = reflect.TypeOf((*InsufficientStandbyMemoryResourceFault)(nil)).Elem()
}

type InsufficientStandbyResource struct {
	InsufficientResourcesFault
}

func init() {
	t["InsufficientStandbyResource"] = reflect.TypeOf((*InsufficientStandbyResource)(nil)).Elem()
}

type InsufficientStandbyResourceFault BaseInsufficientStandbyResource

func init() {
	t["InsufficientStandbyResourceFault"] = reflect.TypeOf((*InsufficientStandbyResourceFault)(nil)).Elem()
}

type InsufficientStorageIops struct {
	VimFault

	UnreservedIops int64  `xml:"unreservedIops"`
	RequestedIops  int64  `xml:"requestedIops"`
	DatastoreName  string `xml:"datastoreName"`
}

func init() {
	t["InsufficientStorageIops"] = reflect.TypeOf((*InsufficientStorageIops)(nil)).Elem()
}

type InsufficientStorageIopsFault InsufficientStorageIops

func init() {
	t["InsufficientStorageIopsFault"] = reflect.TypeOf((*InsufficientStorageIopsFault)(nil)).Elem()
}

type InsufficientStorageSpace struct {
	InsufficientResourcesFault
}

func init() {
	t["InsufficientStorageSpace"] = reflect.TypeOf((*InsufficientStorageSpace)(nil)).Elem()
}

type InsufficientStorageSpaceFault InsufficientStorageSpace

func init() {
	t["InsufficientStorageSpaceFault"] = reflect.TypeOf((*InsufficientStorageSpaceFault)(nil)).Elem()
}

type InsufficientVFlashResourcesFault struct {
	InsufficientResourcesFault

	FreeSpaceInMB      int64 `xml:"freeSpaceInMB,omitempty"`
	FreeSpace          int64 `xml:"freeSpace"`
	RequestedSpaceInMB int64 `xml:"requestedSpaceInMB,omitempty"`
	RequestedSpace     int64 `xml:"requestedSpace"`
}

func init() {
	t["InsufficientVFlashResourcesFault"] = reflect.TypeOf((*InsufficientVFlashResourcesFault)(nil)).Elem()
}

type InsufficientVFlashResourcesFaultFault InsufficientVFlashResourcesFault

func init() {
	t["InsufficientVFlashResourcesFaultFault"] = reflect.TypeOf((*InsufficientVFlashResourcesFaultFault)(nil)).Elem()
}

type IntExpression struct {
	NegatableExpression

	Value int32 `xml:"value,omitempty"`
}

func init() {
	t["IntExpression"] = reflect.TypeOf((*IntExpression)(nil)).Elem()
}

type IntOption struct {
	OptionType

	Min          int32 `xml:"min"`
	Max          int32 `xml:"max"`
	DefaultValue int32 `xml:"defaultValue"`
}

func init() {
	t["IntOption"] = reflect.TypeOf((*IntOption)(nil)).Elem()
}

type IntPolicy struct {
	InheritablePolicy

	Value int32 `xml:"value,omitempty"`
}

func init() {
	t["IntPolicy"] = reflect.TypeOf((*IntPolicy)(nil)).Elem()
}

type InvalidAffinitySettingFault struct {
	VimFault
}

func init() {
	t["InvalidAffinitySettingFault"] = reflect.TypeOf((*InvalidAffinitySettingFault)(nil)).Elem()
}

type InvalidAffinitySettingFaultFault InvalidAffinitySettingFault

func init() {
	t["InvalidAffinitySettingFaultFault"] = reflect.TypeOf((*InvalidAffinitySettingFaultFault)(nil)).Elem()
}

type InvalidArgument struct {
	RuntimeFault

	InvalidProperty string `xml:"invalidProperty,omitempty"`
}

func init() {
	t["InvalidArgument"] = reflect.TypeOf((*InvalidArgument)(nil)).Elem()
}

type InvalidArgumentFault BaseInvalidArgument

func init() {
	t["InvalidArgumentFault"] = reflect.TypeOf((*InvalidArgumentFault)(nil)).Elem()
}

type InvalidBmcRole struct {
	VimFault
}

func init() {
	t["InvalidBmcRole"] = reflect.TypeOf((*InvalidBmcRole)(nil)).Elem()
}

type InvalidBmcRoleFault InvalidBmcRole

func init() {
	t["InvalidBmcRoleFault"] = reflect.TypeOf((*InvalidBmcRoleFault)(nil)).Elem()
}

type InvalidBundle struct {
	PlatformConfigFault
}

func init() {
	t["InvalidBundle"] = reflect.TypeOf((*InvalidBundle)(nil)).Elem()
}

type InvalidBundleFault InvalidBundle

func init() {
	t["InvalidBundleFault"] = reflect.TypeOf((*InvalidBundleFault)(nil)).Elem()
}

type InvalidCAMCertificate struct {
	InvalidCAMServer
}

func init() {
	t["InvalidCAMCertificate"] = reflect.TypeOf((*InvalidCAMCertificate)(nil)).Elem()
}

type InvalidCAMCertificateFault InvalidCAMCertificate

func init() {
	t["InvalidCAMCertificateFault"] = reflect.TypeOf((*InvalidCAMCertificateFault)(nil)).Elem()
}

type InvalidCAMServer struct {
	ActiveDirectoryFault

	CamServer string `xml:"camServer"`
}

func init() {
	t["InvalidCAMServer"] = reflect.TypeOf((*InvalidCAMServer)(nil)).Elem()
}

type InvalidCAMServerFault BaseInvalidCAMServer

func init() {
	t["InvalidCAMServerFault"] = reflect.TypeOf((*InvalidCAMServerFault)(nil)).Elem()
}

type InvalidClientCertificate struct {
	InvalidLogin
}

func init() {
	t["InvalidClientCertificate"] = reflect.TypeOf((*InvalidClientCertificate)(nil)).Elem()
}

type InvalidClientCertificateFault InvalidClientCertificate

func init() {
	t["InvalidClientCertificateFault"] = reflect.TypeOf((*InvalidClientCertificateFault)(nil)).Elem()
}

type InvalidCollectorVersion struct {
	MethodFault
}

func init() {
	t["InvalidCollectorVersion"] = reflect.TypeOf((*InvalidCollectorVersion)(nil)).Elem()
}

type InvalidCollectorVersionFault InvalidCollectorVersion

func init() {
	t["InvalidCollectorVersionFault"] = reflect.TypeOf((*InvalidCollectorVersionFault)(nil)).Elem()
}

type InvalidController struct {
	InvalidDeviceSpec

	ControllerKey int32 `xml:"controllerKey"`
}

func init() {
	t["InvalidController"] = reflect.TypeOf((*InvalidController)(nil)).Elem()
}

type InvalidControllerFault InvalidController

func init() {
	t["InvalidControllerFault"] = reflect.TypeOf((*InvalidControllerFault)(nil)).Elem()
}

type InvalidDasConfigArgument struct {
	InvalidArgument

	Entry       string `xml:"entry,omitempty"`
	ClusterName string `xml:"clusterName,omitempty"`
}

func init() {
	t["InvalidDasConfigArgument"] = reflect.TypeOf((*InvalidDasConfigArgument)(nil)).Elem()
}

type InvalidDasConfigArgumentFault InvalidDasConfigArgument

func init() {
	t["InvalidDasConfigArgumentFault"] = reflect.TypeOf((*InvalidDasConfigArgumentFault)(nil)).Elem()
}

type InvalidDasRestartPriorityForFtVm struct {
	InvalidArgument

	Vm     ManagedObjectReference `xml:"vm"`
	VmName string                 `xml:"vmName"`
}

func init() {
	t["InvalidDasRestartPriorityForFtVm"] = reflect.TypeOf((*InvalidDasRestartPriorityForFtVm)(nil)).Elem()
}

type InvalidDasRestartPriorityForFtVmFault InvalidDasRestartPriorityForFtVm

func init() {
	t["InvalidDasRestartPriorityForFtVmFault"] = reflect.TypeOf((*InvalidDasRestartPriorityForFtVmFault)(nil)).Elem()
}

type InvalidDatastore struct {
	VimFault

	Datastore *ManagedObjectReference `xml:"datastore,omitempty"`
	Name      string                  `xml:"name,omitempty"`
}

func init() {
	t["InvalidDatastore"] = reflect.TypeOf((*InvalidDatastore)(nil)).Elem()
}

type InvalidDatastoreFault BaseInvalidDatastore

func init() {
	t["InvalidDatastoreFault"] = reflect.TypeOf((*InvalidDatastoreFault)(nil)).Elem()
}

type InvalidDatastorePath struct {
	InvalidDatastore

	DatastorePath string `xml:"datastorePath"`
}

func init() {
	t["InvalidDatastorePath"] = reflect.TypeOf((*InvalidDatastorePath)(nil)).Elem()
}

type InvalidDatastorePathFault InvalidDatastorePath

func init() {
	t["InvalidDatastorePathFault"] = reflect.TypeOf((*InvalidDatastorePathFault)(nil)).Elem()
}

type InvalidDatastoreState struct {
	InvalidState

	DatastoreName string `xml:"datastoreName,omitempty"`
}

func init() {
	t["InvalidDatastoreState"] = reflect.TypeOf((*InvalidDatastoreState)(nil)).Elem()
}

type InvalidDatastoreStateFault InvalidDatastoreState

func init() {
	t["InvalidDatastoreStateFault"] = reflect.TypeOf((*InvalidDatastoreStateFault)(nil)).Elem()
}

type InvalidDeviceBacking struct {
	InvalidDeviceSpec
}

func init() {
	t["InvalidDeviceBacking"] = reflect.TypeOf((*InvalidDeviceBacking)(nil)).Elem()
}

type InvalidDeviceBackingFault InvalidDeviceBacking

func init() {
	t["InvalidDeviceBackingFault"] = reflect.TypeOf((*InvalidDeviceBackingFault)(nil)).Elem()
}

type InvalidDeviceOperation struct {
	InvalidDeviceSpec

	BadOp     VirtualDeviceConfigSpecOperation     `xml:"badOp,omitempty"`
	BadFileOp VirtualDeviceConfigSpecFileOperation `xml:"badFileOp,omitempty"`
}

func init() {
	t["InvalidDeviceOperation"] = reflect.TypeOf((*InvalidDeviceOperation)(nil)).Elem()
}

type InvalidDeviceOperationFault InvalidDeviceOperation

func init() {
	t["InvalidDeviceOperationFault"] = reflect.TypeOf((*InvalidDeviceOperationFault)(nil)).Elem()
}

type InvalidDeviceSpec struct {
	InvalidVmConfig

	DeviceIndex int32 `xml:"deviceIndex"`
}

func init() {
	t["InvalidDeviceSpec"] = reflect.TypeOf((*InvalidDeviceSpec)(nil)).Elem()
}

type InvalidDeviceSpecFault BaseInvalidDeviceSpec

func init() {
	t["InvalidDeviceSpecFault"] = reflect.TypeOf((*InvalidDeviceSpecFault)(nil)).Elem()
}

type InvalidDiskFormat struct {
	InvalidFormat
}

func init() {
	t["InvalidDiskFormat"] = reflect.TypeOf((*InvalidDiskFormat)(nil)).Elem()
}

type InvalidDiskFormatFault InvalidDiskFormat

func init() {
	t["InvalidDiskFormatFault"] = reflect.TypeOf((*InvalidDiskFormatFault)(nil)).Elem()
}

type InvalidDrsBehaviorForFtVm struct {
	InvalidArgument

	Vm     ManagedObjectReference `xml:"vm"`
	VmName string                 `xml:"vmName"`
}

func init() {
	t["InvalidDrsBehaviorForFtVm"] = reflect.TypeOf((*InvalidDrsBehaviorForFtVm)(nil)).Elem()
}

type InvalidDrsBehaviorForFtVmFault InvalidDrsBehaviorForFtVm

func init() {
	t["InvalidDrsBehaviorForFtVmFault"] = reflect.TypeOf((*InvalidDrsBehaviorForFtVmFault)(nil)).Elem()
}

type InvalidEditionEvent struct {
	LicenseEvent

	Feature string `xml:"feature"`
}

func init() {
	t["InvalidEditionEvent"] = reflect.TypeOf((*InvalidEditionEvent)(nil)).Elem()
}

type InvalidEditionLicense struct {
	NotEnoughLicenses

	Feature string `xml:"feature"`
}

func init() {
	t["InvalidEditionLicense"] = reflect.TypeOf((*InvalidEditionLicense)(nil)).Elem()
}

type InvalidEditionLicenseFault InvalidEditionLicense

func init() {
	t["InvalidEditionLicenseFault"] = reflect.TypeOf((*InvalidEditionLicenseFault)(nil)).Elem()
}

type InvalidEvent struct {
	VimFault
}

func init() {
	t["InvalidEvent"] = reflect.TypeOf((*InvalidEvent)(nil)).Elem()
}

type InvalidEventFault InvalidEvent

func init() {
	t["InvalidEventFault"] = reflect.TypeOf((*InvalidEventFault)(nil)).Elem()
}

type InvalidFolder struct {
	VimFault

	Target ManagedObjectReference `xml:"target"`
}

func init() {
	t["InvalidFolder"] = reflect.TypeOf((*InvalidFolder)(nil)).Elem()
}

type InvalidFolderFault BaseInvalidFolder

func init() {
	t["InvalidFolderFault"] = reflect.TypeOf((*InvalidFolderFault)(nil)).Elem()
}

type InvalidFormat struct {
	VmConfigFault
}

func init() {
	t["InvalidFormat"] = reflect.TypeOf((*InvalidFormat)(nil)).Elem()
}

type InvalidFormatFault BaseInvalidFormat

func init() {
	t["InvalidFormatFault"] = reflect.TypeOf((*InvalidFormatFault)(nil)).Elem()
}

type InvalidGuestLogin struct {
	GuestOperationsFault
}

func init() {
	t["InvalidGuestLogin"] = reflect.TypeOf((*InvalidGuestLogin)(nil)).Elem()
}

type InvalidGuestLoginFault InvalidGuestLogin

func init() {
	t["InvalidGuestLoginFault"] = reflect.TypeOf((*InvalidGuestLoginFault)(nil)).Elem()
}

type InvalidHostConnectionState struct {
	InvalidHostState
}

func init() {
	t["InvalidHostConnectionState"] = reflect.TypeOf((*InvalidHostConnectionState)(nil)).Elem()
}

type InvalidHostConnectionStateFault InvalidHostConnectionState

func init() {
	t["InvalidHostConnectionStateFault"] = reflect.TypeOf((*InvalidHostConnectionStateFault)(nil)).Elem()
}

type InvalidHostName struct {
	HostConfigFault
}

func init() {
	t["InvalidHostName"] = reflect.TypeOf((*InvalidHostName)(nil)).Elem()
}

type InvalidHostNameFault InvalidHostName

func init() {
	t["InvalidHostNameFault"] = reflect.TypeOf((*InvalidHostNameFault)(nil)).Elem()
}

type InvalidHostState struct {
	InvalidState

	Host *ManagedObjectReference `xml:"host,omitempty"`
}

func init() {
	t["InvalidHostState"] = reflect.TypeOf((*InvalidHostState)(nil)).Elem()
}

type InvalidHostStateFault BaseInvalidHostState

func init() {
	t["InvalidHostStateFault"] = reflect.TypeOf((*InvalidHostStateFault)(nil)).Elem()
}

type InvalidIndexArgument struct {
	InvalidArgument

	Key string `xml:"key"`
}

func init() {
	t["InvalidIndexArgument"] = reflect.TypeOf((*InvalidIndexArgument)(nil)).Elem()
}

type InvalidIndexArgumentFault InvalidIndexArgument

func init() {
	t["InvalidIndexArgumentFault"] = reflect.TypeOf((*InvalidIndexArgumentFault)(nil)).Elem()
}

type InvalidIpfixConfig struct {
	DvsFault

	Property string `xml:"property,omitempty"`
}

func init() {
	t["InvalidIpfixConfig"] = reflect.TypeOf((*InvalidIpfixConfig)(nil)).Elem()
}

type InvalidIpfixConfigFault InvalidIpfixConfig

func init() {
	t["InvalidIpfixConfigFault"] = reflect.TypeOf((*InvalidIpfixConfigFault)(nil)).Elem()
}

type InvalidIpmiLoginInfo struct {
	VimFault
}

func init() {
	t["InvalidIpmiLoginInfo"] = reflect.TypeOf((*InvalidIpmiLoginInfo)(nil)).Elem()
}

type InvalidIpmiLoginInfoFault InvalidIpmiLoginInfo

func init() {
	t["InvalidIpmiLoginInfoFault"] = reflect.TypeOf((*InvalidIpmiLoginInfoFault)(nil)).Elem()
}

type InvalidIpmiMacAddress struct {
	VimFault

	UserProvidedMacAddress string `xml:"userProvidedMacAddress"`
	ObservedMacAddress     string `xml:"observedMacAddress"`
}

func init() {
	t["InvalidIpmiMacAddress"] = reflect.TypeOf((*InvalidIpmiMacAddress)(nil)).Elem()
}

type InvalidIpmiMacAddressFault InvalidIpmiMacAddress

func init() {
	t["InvalidIpmiMacAddressFault"] = reflect.TypeOf((*InvalidIpmiMacAddressFault)(nil)).Elem()
}

type InvalidLicense struct {
	VimFault

	LicenseContent string `xml:"licenseContent"`
}

func init() {
	t["InvalidLicense"] = reflect.TypeOf((*InvalidLicense)(nil)).Elem()
}

type InvalidLicenseFault InvalidLicense

func init() {
	t["InvalidLicenseFault"] = reflect.TypeOf((*InvalidLicenseFault)(nil)).Elem()
}

type InvalidLocale struct {
	VimFault
}

func init() {
	t["InvalidLocale"] = reflect.TypeOf((*InvalidLocale)(nil)).Elem()
}

type InvalidLocaleFault InvalidLocale

func init() {
	t["InvalidLocaleFault"] = reflect.TypeOf((*InvalidLocaleFault)(nil)).Elem()
}

type InvalidLogin struct {
	VimFault
}

func init() {
	t["InvalidLogin"] = reflect.TypeOf((*InvalidLogin)(nil)).Elem()
}

type InvalidLoginFault BaseInvalidLogin

func init() {
	t["InvalidLoginFault"] = reflect.TypeOf((*InvalidLoginFault)(nil)).Elem()
}

type InvalidName struct {
	VimFault

	Name   string                  `xml:"name"`
	Entity *ManagedObjectReference `xml:"entity,omitempty"`
}

func init() {
	t["InvalidName"] = reflect.TypeOf((*InvalidName)(nil)).Elem()
}

type InvalidNameFault InvalidName

func init() {
	t["InvalidNameFault"] = reflect.TypeOf((*InvalidNameFault)(nil)).Elem()
}

type InvalidNasCredentials struct {
	NasConfigFault

	UserName string `xml:"userName"`
}

func init() {
	t["InvalidNasCredentials"] = reflect.TypeOf((*InvalidNasCredentials)(nil)).Elem()
}

type InvalidNasCredentialsFault InvalidNasCredentials

func init() {
	t["InvalidNasCredentialsFault"] = reflect.TypeOf((*InvalidNasCredentialsFault)(nil)).Elem()
}

type InvalidNetworkInType struct {
	VAppPropertyFault
}

func init() {
	t["InvalidNetworkInType"] = reflect.TypeOf((*InvalidNetworkInType)(nil)).Elem()
}

type InvalidNetworkInTypeFault InvalidNetworkInType

func init() {
	t["InvalidNetworkInTypeFault"] = reflect.TypeOf((*InvalidNetworkInTypeFault)(nil)).Elem()
}

type InvalidNetworkResource struct {
	NasConfigFault

	RemoteHost string `xml:"remoteHost"`
	RemotePath string `xml:"remotePath"`
}

func init() {
	t["InvalidNetworkResource"] = reflect.TypeOf((*InvalidNetworkResource)(nil)).Elem()
}

type InvalidNetworkResourceFault InvalidNetworkResource

func init() {
	t["InvalidNetworkResourceFault"] = reflect.TypeOf((*InvalidNetworkResourceFault)(nil)).Elem()
}

type InvalidOperationOnSecondaryVm struct {
	VmFaultToleranceIssue

	InstanceUuid string `xml:"instanceUuid"`
}

func init() {
	t["InvalidOperationOnSecondaryVm"] = reflect.TypeOf((*InvalidOperationOnSecondaryVm)(nil)).Elem()
}

type InvalidOperationOnSecondaryVmFault InvalidOperationOnSecondaryVm

func init() {
	t["InvalidOperationOnSecondaryVmFault"] = reflect.TypeOf((*InvalidOperationOnSecondaryVmFault)(nil)).Elem()
}

type InvalidPowerState struct {
	InvalidState

	RequestedState VirtualMachinePowerState `xml:"requestedState,omitempty"`
	ExistingState  VirtualMachinePowerState `xml:"existingState"`
}

func init() {
	t["InvalidPowerState"] = reflect.TypeOf((*InvalidPowerState)(nil)).Elem()
}

type InvalidPowerStateFault InvalidPowerState

func init() {
	t["InvalidPowerStateFault"] = reflect.TypeOf((*InvalidPowerStateFault)(nil)).Elem()
}

type InvalidPrivilege struct {
	VimFault

	Privilege string `xml:"privilege"`
}

func init() {
	t["InvalidPrivilege"] = reflect.TypeOf((*InvalidPrivilege)(nil)).Elem()
}

type InvalidPrivilegeFault InvalidPrivilege

func init() {
	t["InvalidPrivilegeFault"] = reflect.TypeOf((*InvalidPrivilegeFault)(nil)).Elem()
}

type InvalidProfileReferenceHost struct {
	RuntimeFault

	Reason      string                  `xml:"reason,omitempty"`
	Host        *ManagedObjectReference `xml:"host,omitempty"`
	Profile     *ManagedObjectReference `xml:"profile,omitempty"`
	ProfileName string                  `xml:"profileName,omitempty"`
}

func init() {
	t["InvalidProfileReferenceHost"] = reflect.TypeOf((*InvalidProfileReferenceHost)(nil)).Elem()
}

type InvalidProfileReferenceHostFault InvalidProfileReferenceHost

func init() {
	t["InvalidProfileReferenceHostFault"] = reflect.TypeOf((*InvalidProfileReferenceHostFault)(nil)).Elem()
}

type InvalidProperty struct {
	MethodFault

	Name string `xml:"name"`
}

func init() {
	t["InvalidProperty"] = reflect.TypeOf((*InvalidProperty)(nil)).Elem()
}

type InvalidPropertyFault InvalidProperty

func init() {
	t["InvalidPropertyFault"] = reflect.TypeOf((*InvalidPropertyFault)(nil)).Elem()
}

type InvalidPropertyType struct {
	VAppPropertyFault
}

func init() {
	t["InvalidPropertyType"] = reflect.TypeOf((*InvalidPropertyType)(nil)).Elem()
}

type InvalidPropertyTypeFault InvalidPropertyType

func init() {
	t["InvalidPropertyTypeFault"] = reflect.TypeOf((*InvalidPropertyTypeFault)(nil)).Elem()
}

type InvalidPropertyValue struct {
	VAppPropertyFault
}

func init() {
	t["InvalidPropertyValue"] = reflect.TypeOf((*InvalidPropertyValue)(nil)).Elem()
}

type InvalidPropertyValueFault BaseInvalidPropertyValue

func init() {
	t["InvalidPropertyValueFault"] = reflect.TypeOf((*InvalidPropertyValueFault)(nil)).Elem()
}

type InvalidRequest struct {
	RuntimeFault
}

func init() {
	t["InvalidRequest"] = reflect.TypeOf((*InvalidRequest)(nil)).Elem()
}

type InvalidRequestFault BaseInvalidRequest

func init() {
	t["InvalidRequestFault"] = reflect.TypeOf((*InvalidRequestFault)(nil)).Elem()
}

type InvalidResourcePoolStructureFault struct {
	InsufficientResourcesFault
}

func init() {
	t["InvalidResourcePoolStructureFault"] = reflect.TypeOf((*InvalidResourcePoolStructureFault)(nil)).Elem()
}

type InvalidResourcePoolStructureFaultFault InvalidResourcePoolStructureFault

func init() {
	t["InvalidResourcePoolStructureFaultFault"] = reflect.TypeOf((*InvalidResourcePoolStructureFaultFault)(nil)).Elem()
}

type InvalidSnapshotFormat struct {
	InvalidFormat
}

func init() {
	t["InvalidSnapshotFormat"] = reflect.TypeOf((*InvalidSnapshotFormat)(nil)).Elem()
}

type InvalidSnapshotFormatFault InvalidSnapshotFormat

func init() {
	t["InvalidSnapshotFormatFault"] = reflect.TypeOf((*InvalidSnapshotFormatFault)(nil)).Elem()
}

type InvalidState struct {
	VimFault
}

func init() {
	t["InvalidState"] = reflect.TypeOf((*InvalidState)(nil)).Elem()
}

type InvalidStateFault BaseInvalidState

func init() {
	t["InvalidStateFault"] = reflect.TypeOf((*InvalidStateFault)(nil)).Elem()
}

type InvalidType struct {
	InvalidRequest

	Argument string `xml:"argument,omitempty"`
}

func init() {
	t["InvalidType"] = reflect.TypeOf((*InvalidType)(nil)).Elem()
}

type InvalidTypeFault InvalidType

func init() {
	t["InvalidTypeFault"] = reflect.TypeOf((*InvalidTypeFault)(nil)).Elem()
}

type InvalidVmConfig struct {
	VmConfigFault

	Property string `xml:"property,omitempty"`
}

func init() {
	t["InvalidVmConfig"] = reflect.TypeOf((*InvalidVmConfig)(nil)).Elem()
}

type InvalidVmConfigFault BaseInvalidVmConfig

func init() {
	t["InvalidVmConfigFault"] = reflect.TypeOf((*InvalidVmConfigFault)(nil)).Elem()
}

type InvalidVmState struct {
	InvalidState

	Vm ManagedObjectReference `xml:"vm"`
}

func init() {
	t["InvalidVmState"] = reflect.TypeOf((*InvalidVmState)(nil)).Elem()
}

type InvalidVmStateFault InvalidVmState

func init() {
	t["InvalidVmStateFault"] = reflect.TypeOf((*InvalidVmStateFault)(nil)).Elem()
}

type InventoryDescription struct {
	DynamicData

	NumHosts           int32 `xml:"numHosts"`
	NumVirtualMachines int32 `xml:"numVirtualMachines"`
	NumResourcePools   int32 `xml:"numResourcePools,omitempty"`
	NumClusters        int32 `xml:"numClusters,omitempty"`
	NumCpuDev          int32 `xml:"numCpuDev,omitempty"`
	NumNetDev          int32 `xml:"numNetDev,omitempty"`
	NumDiskDev         int32 `xml:"numDiskDev,omitempty"`
	NumvCpuDev         int32 `xml:"numvCpuDev,omitempty"`
	NumvNetDev         int32 `xml:"numvNetDev,omitempty"`
	NumvDiskDev        int32 `xml:"numvDiskDev,omitempty"`
}

func init() {
	t["InventoryDescription"] = reflect.TypeOf((*InventoryDescription)(nil)).Elem()
}

type InventoryHasStandardAloneHosts struct {
	NotEnoughLicenses

	Hosts []string `xml:"hosts"`
}

func init() {
	t["InventoryHasStandardAloneHosts"] = reflect.TypeOf((*InventoryHasStandardAloneHosts)(nil)).Elem()
}

type InventoryHasStandardAloneHostsFault InventoryHasStandardAloneHosts

func init() {
	t["InventoryHasStandardAloneHostsFault"] = reflect.TypeOf((*InventoryHasStandardAloneHostsFault)(nil)).Elem()
}

type IoFilterHostIssue struct {
	DynamicData

	Host  ManagedObjectReference `xml:"host"`
	Issue []LocalizedMethodFault `xml:"issue"`
}

func init() {
	t["IoFilterHostIssue"] = reflect.TypeOf((*IoFilterHostIssue)(nil)).Elem()
}

type IoFilterInfo struct {
	DynamicData

	Id          string `xml:"id"`
	Name        string `xml:"name"`
	Vendor      string `xml:"vendor"`
	Version     string `xml:"version"`
	Type        string `xml:"type,omitempty"`
	Summary     string `xml:"summary,omitempty"`
	ReleaseDate string `xml:"releaseDate,omitempty"`
}

func init() {
	t["IoFilterInfo"] = reflect.TypeOf((*IoFilterInfo)(nil)).Elem()
}

type IoFilterQueryIssueResult struct {
	DynamicData

	OpType    string              `xml:"opType"`
	HostIssue []IoFilterHostIssue `xml:"hostIssue,omitempty"`
}

func init() {
	t["IoFilterQueryIssueResult"] = reflect.TypeOf((*IoFilterQueryIssueResult)(nil)).Elem()
}

type IpAddress struct {
	NegatableExpression
}

func init() {
	t["IpAddress"] = reflect.TypeOf((*IpAddress)(nil)).Elem()
}

type IpAddressProfile struct {
	ApplyProfile
}

func init() {
	t["IpAddressProfile"] = reflect.TypeOf((*IpAddressProfile)(nil)).Elem()
}

type IpHostnameGeneratorError struct {
	CustomizationFault
}

func init() {
	t["IpHostnameGeneratorError"] = reflect.TypeOf((*IpHostnameGeneratorError)(nil)).Elem()
}

type IpHostnameGeneratorErrorFault IpHostnameGeneratorError

func init() {
	t["IpHostnameGeneratorErrorFault"] = reflect.TypeOf((*IpHostnameGeneratorErrorFault)(nil)).Elem()
}

type IpPool struct {
	DynamicData

	Id                     int32                   `xml:"id,omitempty"`
	Name                   string                  `xml:"name,omitempty"`
	Ipv4Config             *IpPoolIpPoolConfigInfo `xml:"ipv4Config,omitempty"`
	Ipv6Config             *IpPoolIpPoolConfigInfo `xml:"ipv6Config,omitempty"`
	DnsDomain              string                  `xml:"dnsDomain,omitempty"`
	DnsSearchPath          string                  `xml:"dnsSearchPath,omitempty"`
	HostPrefix             string                  `xml:"hostPrefix,omitempty"`
	HttpProxy              string                  `xml:"httpProxy,omitempty"`
	NetworkAssociation     []IpPoolAssociation     `xml:"networkAssociation,omitempty"`
	AvailableIpv4Addresses int32                   `xml:"availableIpv4Addresses,omitempty"`
	AvailableIpv6Addresses int32                   `xml:"availableIpv6Addresses,omitempty"`
	AllocatedIpv4Addresses int32                   `xml:"allocatedIpv4Addresses,omitempty"`
	AllocatedIpv6Addresses int32                   `xml:"allocatedIpv6Addresses,omitempty"`
}

func init() {
	t["IpPool"] = reflect.TypeOf((*IpPool)(nil)).Elem()
}

type IpPoolAssociation struct {
	DynamicData

	Network     *ManagedObjectReference `xml:"network,omitempty"`
	NetworkName string                  `xml:"networkName"`
}

func init() {
	t["IpPoolAssociation"] = reflect.TypeOf((*IpPoolAssociation)(nil)).Elem()
}

type IpPoolIpPoolConfigInfo struct {
	DynamicData

	SubnetAddress       string   `xml:"subnetAddress,omitempty"`
	Netmask             string   `xml:"netmask,omitempty"`
	Gateway             string   `xml:"gateway,omitempty"`
	Range               string   `xml:"range,omitempty"`
	Dns                 []string `xml:"dns,omitempty"`
	DhcpServerAvailable *bool    `xml:"dhcpServerAvailable"`
	IpPoolEnabled       *bool    `xml:"ipPoolEnabled"`
}

func init() {
	t["IpPoolIpPoolConfigInfo"] = reflect.TypeOf((*IpPoolIpPoolConfigInfo)(nil)).Elem()
}

type IpPoolManagerIpAllocation struct {
	DynamicData

	IpAddress    string `xml:"ipAddress"`
	AllocationId string `xml:"allocationId"`
}

func init() {
	t["IpPoolManagerIpAllocation"] = reflect.TypeOf((*IpPoolManagerIpAllocation)(nil)).Elem()
}

type IpRange struct {
	IpAddress

	AddressPrefix string `xml:"addressPrefix"`
	PrefixLength  int32  `xml:"prefixLength,omitempty"`
}

func init() {
	t["IpRange"] = reflect.TypeOf((*IpRange)(nil)).Elem()
}

type IpRouteProfile struct {
	ApplyProfile

	StaticRoute []StaticRouteProfile `xml:"staticRoute,omitempty"`
}

func init() {
	t["IpRouteProfile"] = reflect.TypeOf((*IpRouteProfile)(nil)).Elem()
}

type IsKmsClusterActive IsKmsClusterActiveRequestType

func init() {
	t["IsKmsClusterActive"] = reflect.TypeOf((*IsKmsClusterActive)(nil)).Elem()
}

type IsKmsClusterActiveRequestType struct {
	This    ManagedObjectReference `xml:"_this"`
	Cluster *KeyProviderId         `xml:"cluster,omitempty"`
}

func init() {
	t["IsKmsClusterActiveRequestType"] = reflect.TypeOf((*IsKmsClusterActiveRequestType)(nil)).Elem()
}

type IsKmsClusterActiveResponse struct {
	Returnval bool `xml:"returnval"`
}

type IsSharedGraphicsActive IsSharedGraphicsActiveRequestType

func init() {
	t["IsSharedGraphicsActive"] = reflect.TypeOf((*IsSharedGraphicsActive)(nil)).Elem()
}

type IsSharedGraphicsActiveRequestType struct {
	This ManagedObjectReference `xml:"_this"`
}

func init() {
	t["IsSharedGraphicsActiveRequestType"] = reflect.TypeOf((*IsSharedGraphicsActiveRequestType)(nil)).Elem()
}

type IsSharedGraphicsActiveResponse struct {
	Returnval bool `xml:"returnval"`
}

type IscsiDependencyEntity struct {
	DynamicData

	PnicDevice string `xml:"pnicDevice"`
	VnicDevice string `xml:"vnicDevice"`
	VmhbaName  string `xml:"vmhbaName"`
}

func init() {
	t["IscsiDependencyEntity"] = reflect.TypeOf((*IscsiDependencyEntity)(nil)).Elem()
}

type IscsiFault struct {
	VimFault
}

func init() {
	t["IscsiFault"] = reflect.TypeOf((*IscsiFault)(nil)).Elem()
}

type IscsiFaultFault BaseIscsiFault

func init() {
	t["IscsiFaultFault"] = reflect.TypeOf((*IscsiFaultFault)(nil)).Elem()
}

type IscsiFaultInvalidVnic struct {
	IscsiFault

	VnicDevice string `xml:"vnicDevice"`
}

func init() {
	t["IscsiFaultInvalidVnic"] = reflect.TypeOf((*IscsiFaultInvalidVnic)(nil)).Elem()
}

type IscsiFaultInvalidVnicFault IscsiFaultInvalidVnic

func init() {
	t["IscsiFaultInvalidVnicFault"] = reflect.TypeOf((*IscsiFaultInvalidVnicFault)(nil)).Elem()
}

type IscsiFaultPnicInUse struct {
	IscsiFault

	PnicDevice string `xml:"pnicDevice"`
}

func init() {
	t["IscsiFaultPnicInUse"] = reflect.TypeOf((*IscsiFaultPnicInUse)(nil)).Elem()
}

type IscsiFaultPnicInUseFault IscsiFaultPnicInUse

func init() {
	t["IscsiFaultPnicInUseFault"] = reflect.TypeOf((*IscsiFaultPnicInUseFault)(nil)).Elem()
}

type IscsiFaultVnicAlreadyBound struct {
	IscsiFault

	VnicDevice string `xml:"vnicDevice"`
}

func init() {
	t["IscsiFaultVnicAlreadyBound"] = reflect.TypeOf((*IscsiFaultVnicAlreadyBound)(nil)).Elem()
}

type IscsiFaultVnicAlreadyBoundFault IscsiFaultVnicAlreadyBound

func init() {
	t["IscsiFaultVnicAlreadyBoundFault"] = reflect.TypeOf((*IscsiFaultVnicAlreadyBoundFault)(nil)).Elem()
}

type IscsiFaultVnicHasActivePaths struct {
	IscsiFault

	VnicDevice string `xml:"vnicDevice"`
}

func init() {
	t["IscsiFaultVnicHasActivePaths"] = reflect.TypeOf((*IscsiFaultVnicHasActivePaths)(nil)).Elem()
}

type IscsiFaultVnicHasActivePathsFault IscsiFaultVnicHasActivePaths

func init() {
	t["IscsiFaultVnicHasActivePathsFault"] = reflect.TypeOf((*IscsiFaultVnicHasActivePathsFault)(nil)).Elem()
}

type IscsiFaultVnicHasMultipleUplinks struct {
	IscsiFault

	VnicDevice string `xml:"vnicDevice"`
}

func init() {
	t["IscsiFaultVnicHasMultipleUplinks"] = reflect.TypeOf((*IscsiFaultVnicHasMultipleUplinks)(nil)).Elem()
}

type IscsiFaultVnicHasMultipleUplinksFault IscsiFaultVnicHasMultipleUplinks

func init() {
	t["IscsiFaultVnicHasMultipleUplinksFault"] = reflect.TypeOf((*IscsiFaultVnicHasMultipleUplinksFault)(nil)).Elem()
}

type IscsiFaultVnicHasNoUplinks struct {
	IscsiFault

	VnicDevice string `xml:"vnicDevice"`
}

func init() {
	t["IscsiFaultVnicHasNoUplinks"] = reflect.TypeOf((*IscsiFaultVnicHasNoUplinks)(nil)).Elem()
}

type IscsiFaultVnicHasNoUplinksFault IscsiFaultVnicHasNoUplinks

func init() {
	t["IscsiFaultVnicHasNoUplinksFault"] = reflect.TypeOf((*IscsiFaultVnicHasNoUplinksFault)(nil)).Elem()
}

type IscsiFaultVnicHasWrongUplink struct {
	IscsiFault

	VnicDevice string `xml:"vnicDevice"`
}

func init() {
	t["IscsiFaultVnicHasWrongUplink"] = reflect.TypeOf((*IscsiFaultVnicHasWrongUplink)(nil)).Elem()
}

type IscsiFaultVnicHasWrongUplinkFault IscsiFaultVnicHasWrongUplink

func init() {
	t["IscsiFaultVnicHasWrongUplinkFault"] = reflect.TypeOf((*IscsiFaultVnicHasWrongUplinkFault)(nil)).Elem()
}

type IscsiFaultVnicInUse struct {
	IscsiFault

	VnicDevice string `xml:"vnicDevice"`
}

func init() {
	t["IscsiFaultVnicInUse"] = reflect.TypeOf((*IscsiFaultVnicInUse)(nil)).Elem()
}

type IscsiFaultVnicInUseFault IscsiFaultVnicInUse

func init() {
	t["IscsiFaultVnicInUseFault"] = reflect.TypeOf((*IscsiFaultVnicInUseFault)(nil)).Elem()
}

type IscsiFaultVnicIsLastPath struct {
	IscsiFault

	VnicDevice string `xml:"vnicDevice"`
}

func init() {
	t["IscsiFaultVnicIsLastPath"] = reflect.TypeOf((*IscsiFaultVnicIsLastPath)(nil)).Elem()
}

type IscsiFaultVnicIsLastPathFault IscsiFaultVnicIsLastPath

func init() {
	t["IscsiFaultVnicIsLastPathFault"] = reflect.TypeOf((*IscsiFaultVnicIsLastPathFault)(nil)).Elem()
}

type IscsiFaultVnicNotBound struct {
	IscsiFault

	VnicDevice string `xml:"vnicDevice"`
}

func init() {
	t["IscsiFaultVnicNotBound"] = reflect.TypeOf((*IscsiFaultVnicNotBound)(nil)).Elem()
}

type IscsiFaultVnicNotBoundFault IscsiFaultVnicNotBound

func init() {
	t["IscsiFaultVnicNotBoundFault"] = reflect.TypeOf((*IscsiFaultVnicNotBoundFault)(nil)).Elem()
}

type IscsiFaultVnicNotFound struct {
	IscsiFault

	VnicDevice string `xml:"vnicDevice"`
}

func init() {
	t["IscsiFaultVnicNotFound"] = reflect.TypeOf((*IscsiFaultVnicNotFound)(nil)).Elem()
}

type IscsiFaultVnicNotFoundFault IscsiFaultVnicNotFound

func init() {
	t["IscsiFaultVnicNotFoundFault"] = reflect.TypeOf((*IscsiFaultVnicNotFoundFault)(nil)).Elem()
}

type IscsiMigrationDependency struct {
	DynamicData

	MigrationAllowed bool                    `xml:"migrationAllowed"`
	DisallowReason   *IscsiStatus            `xml:"disallowReason,omitempty"`
	Dependency       []IscsiDependencyEntity `xml:"dependency,omitempty"`
}

func init() {
	t["IscsiMigrationDependency"] = reflect.TypeOf((*IscsiMigrationDependency)(nil)).Elem()
}

type IscsiPortInfo struct {
	DynamicData

	VnicDevice        string          `xml:"vnicDevice,omitempty"`
	Vnic              *HostVirtualNic `xml:"vnic,omitempty"`
	PnicDevice        string          `xml:"pnicDevice,omitempty"`
	Pnic              *PhysicalNic    `xml:"pnic,omitempty"`
	SwitchName        string          `xml:"switchName,omitempty"`
	SwitchUuid        string          `xml:"switchUuid,omitempty"`
	PortgroupName     string          `xml:"portgroupName,omitempty"`
	PortgroupKey      string          `xml:"portgroupKey,omitempty"`
	PortKey           string          `xml:"portKey,omitempty"`
	OpaqueNetworkId   string          `xml:"opaqueNetworkId,omitempty"`
	OpaqueNetworkType string          `xml:"opaqueNetworkType,omitempty"`
	OpaqueNetworkName string          `xml:"opaqueNetworkName,omitempty"`
	ExternalId        string          `xml:"externalId,omitempty"`
	ComplianceStatus  *IscsiStatus    `xml:"complianceStatus,omitempty"`
	PathStatus        string          `xml:"pathStatus,omitempty"`
}

func init() {
	t["IscsiPortInfo"] = reflect.TypeOf((*IscsiPortInfo)(nil)).Elem()
}

type IscsiStatus struct {
	DynamicData

	Reason []LocalizedMethodFault `xml:"reason,omitempty"`
}

func init() {
	t["IscsiStatus"] = reflect.TypeOf((*IscsiStatus)(nil)).Elem()
}

type IsoImageFileInfo struct {
	FileInfo
}

func init() {
	t["IsoImageFileInfo"] = reflect.TypeOf((*IsoImageFileInfo)(nil)).Elem()
}

type IsoImageFileQuery struct {
	FileQuery
}

func init() {
	t["IsoImageFileQuery"] = reflect.TypeOf((*IsoImageFileQuery)(nil)).Elem()
}

type JoinDomainRequestType struct {
	This       ManagedObjectReference `xml:"_this"`
	DomainName string                 `xml:"domainName"`
	UserName   string                 `xml:"userName"`
	Password   string                 `xml:"password"`
}

func init() {
	t["JoinDomainRequestType"] = reflect.TypeOf((*JoinDomainRequestType)(nil)).Elem()
}

type JoinDomainWithCAMRequestType struct {
	This       ManagedObjectReference `xml:"_this"`
	DomainName string                 `xml:"domainName"`
	CamServer  string                 `xml:"camServer"`
}

func init() {
	t["JoinDomainWithCAMRequestType"] = reflect.TypeOf((*JoinDomainWithCAMRequestType)(nil)).Elem()
}

type JoinDomainWithCAM_Task JoinDomainWithCAMRequestType

func init() {
	t["JoinDomainWithCAM_Task"] = reflect.TypeOf((*JoinDomainWithCAM_Task)(nil)).Elem()
}

type JoinDomainWithCAM_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval"`
}

type JoinDomain_Task JoinDomainRequestType

func init() {
	t["JoinDomain_Task"] = reflect.TypeOf((*JoinDomain_Task)(nil)).Elem()
}

type JoinDomain_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval"`
}

type KernelModuleInfo struct {
	DynamicData

	Id              int32                   `xml:"id"`
	Name            string                  `xml:"name"`
	Version         string                  `xml:"version"`
	Filename        string                  `xml:"filename"`
	OptionString    string                  `xml:"optionString"`
	Loaded          bool                    `xml:"loaded"`
	Enabled         bool                    `xml:"enabled"`
	UseCount        int32                   `xml:"useCount"`
	ReadOnlySection KernelModuleSectionInfo `xml:"readOnlySection"`
	WritableSection KernelModuleSectionInfo `xml:"writableSection"`
	TextSection     KernelModuleSectionInfo `xml:"textSection"`
	DataSection     KernelModuleSectionInfo `xml:"dataSection"`
	BssSection      KernelModuleSectionInfo `xml:"bssSection"`
}

func init() {
	t["KernelModuleInfo"] = reflect.TypeOf((*KernelModuleInfo)(nil)).Elem()
}

type KernelModuleSectionInfo struct {
	DynamicData

	Address int64 `xml:"address"`
	Length  int32 `xml:"length,omitempty"`
}

func init() {
	t["KernelModuleSectionInfo"] = reflect.TypeOf((*KernelModuleSectionInfo)(nil)).Elem()
}

type KeyAnyValue struct {
	DynamicData

	Key   string  `xml:"key"`
	Value AnyType `xml:"value,typeattr"`
}

func init() {
	t["KeyAnyValue"] = reflect.TypeOf((*KeyAnyValue)(nil)).Elem()
}

type KeyNotFound struct {
	VimFault

	Key string `xml:"key"`
}

func init() {
	t["KeyNotFound"] = reflect.TypeOf((*KeyNotFound)(nil)).Elem()
}

type KeyNotFoundFault KeyNotFound

func init() {
	t["KeyNotFoundFault"] = reflect.TypeOf((*KeyNotFoundFault)(nil)).Elem()
}

type KeyProviderId struct {
	DynamicData

	Id string `xml:"id"`
}

func init() {
	t["KeyProviderId"] = reflect.TypeOf((*KeyProviderId)(nil)).Elem()
}

type KeyValue struct {
	DynamicData

	Key   string `xml:"key"`
	Value string `xml:"value"`
}

func init() {
	t["KeyValue"] = reflect.TypeOf((*KeyValue)(nil)).Elem()
}

type KmipClusterInfo struct {
	DynamicData

	ClusterId          KeyProviderId            `xml:"clusterId"`
	Servers            []KmipServerInfo         `xml:"servers,omitempty"`
	UseAsDefault       bool                     `xml:"useAsDefault"`
	ManagementType     string                   `xml:"managementType,omitempty"`
	UseAsEntityDefault []ManagedObjectReference `xml:"useAsEntityDefault,omitempty"`
	HasBackup          *bool                    `xml:"hasBackup"`
	TpmRequired        *bool                    `xml:"tpmRequired"`
	KeyId              string                   `xml:"keyId,omitempty"`
}

func init() {
	t["KmipClusterInfo"] = reflect.TypeOf((*KmipClusterInfo)(nil)).Elem()
}

type KmipServerInfo struct {
	DynamicData

	Name         string `xml:"name"`
	Address      string `xml:"address"`
	Port         int32  `xml:"port"`
	ProxyAddress string `xml:"proxyAddress,omitempty"`
	ProxyPort    int32  `xml:"proxyPort,omitempty"`
	Reconnect    int32  `xml:"reconnect,omitempty"`
	Protocol     string `xml:"protocol,omitempty"`
	Nbio         int32  `xml:"nbio,omitempty"`
	Timeout      int32  `xml:"timeout,omitempty"`
	UserName     string `xml:"userName,omitempty"`
}

func init() {
	t["KmipServerInfo"] = reflect.TypeOf((*KmipServerInfo)(nil)).Elem()
}

type KmipServerSpec struct {
	DynamicData

	ClusterId KeyProviderId  `xml:"clusterId"`
	Info      KmipServerInfo `xml:"info"`
	Password  string         `xml:"password,omitempty"`
}

func init() {
	t["KmipServerSpec"] = reflect.TypeOf((*KmipServerSpec)(nil)).Elem()
}

type KmipServerStatus struct {
	DynamicData

	ClusterId   KeyProviderId       `xml:"clusterId"`
	Name        string              `xml:"name"`
	Status      ManagedEntityStatus `xml:"status"`
	Description string              `xml:"description"`
}

func init() {
	t["KmipServerStatus"] = reflect.TypeOf((*KmipServerStatus)(nil)).Elem()
}

type LargeRDMConversionNotSupported struct {
	MigrationFault

	Device string `xml:"device"`
}

func init() {
	t["LargeRDMConversionNotSupported"] = reflect.TypeOf((*LargeRDMConversionNotSupported)(nil)).Elem()
}

type LargeRDMConversionNotSupportedFault LargeRDMConversionNotSupported

func init() {
	t["LargeRDMConversionNotSupportedFault"] = reflect.TypeOf((*LargeRDMConversionNotSupportedFault)(nil)).Elem()
}

type LargeRDMNotSupportedOnDatastore struct {
	VmConfigFault

	Device        string                 `xml:"device"`
	Datastore     ManagedObjectReference `xml:"datastore"`
	DatastoreName string                 `xml:"datastoreName"`
}

func init() {
	t["LargeRDMNotSupportedOnDatastore"] = reflect.TypeOf((*LargeRDMNotSupportedOnDatastore)(nil)).Elem()
}

type LargeRDMNotSupportedOnDatastoreFault LargeRDMNotSupportedOnDatastore

func init() {
	t["LargeRDMNotSupportedOnDatastoreFault"] = reflect.TypeOf((*LargeRDMNotSupportedOnDatastoreFault)(nil)).Elem()
}

type LatencySensitivity struct {
	DynamicData

	Level       LatencySensitivitySensitivityLevel `xml:"level"`
	Sensitivity int32                              `xml:"sensitivity,omitempty"`
}

func init() {
	t["LatencySensitivity"] = reflect.TypeOf((*LatencySensitivity)(nil)).Elem()
}

type LeaveCurrentDomainRequestType struct {
	This  ManagedObjectReference `xml:"_this"`
	Force bool                   `xml:"force"`
}

func init() {
	t["LeaveCurrentDomainRequestType"] = reflect.TypeOf((*LeaveCurrentDomainRequestType)(nil)).Elem()
}

type LeaveCurrentDomain_Task LeaveCurrentDomainRequestType

func init() {
	t["LeaveCurrentDomain_Task"] = reflect.TypeOf((*LeaveCurrentDomain_Task)(nil)).Elem()
}

type LeaveCurrentDomain_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval"`
}

type LegacyNetworkInterfaceInUse struct {
	CannotAccessNetwork
}

func init() {
	t["LegacyNetworkInterfaceInUse"] = reflect.TypeOf((*LegacyNetworkInterfaceInUse)(nil)).Elem()
}

type LegacyNetworkInterfaceInUseFault LegacyNetworkInterfaceInUse

func init() {
	t["LegacyNetworkInterfaceInUseFault"] = reflect.TypeOf((*LegacyNetworkInterfaceInUseFault)(nil)).Elem()
}

type LicenseAssignmentFailed struct {
	RuntimeFault

	Reason string `xml:"reason,omitempty"`
}

func init() {
	t["LicenseAssignmentFailed"] = reflect.TypeOf((*LicenseAssignmentFailed)(nil)).Elem()
}

type LicenseAssignmentFailedFault LicenseAssignmentFailed

func init() {
	t["LicenseAssignmentFailedFault"] = reflect.TypeOf((*LicenseAssignmentFailedFault)(nil)).Elem()
}

type LicenseAssignmentManagerLicenseAssignment struct {
	DynamicData

	EntityId          string                    `xml:"entityId"`
	Scope             string                    `xml:"scope,omitempty"`
	EntityDisplayName string                    `xml:"entityDisplayName,omitempty"`
	AssignedLicense   LicenseManagerLicenseInfo `xml:"assignedLicense"`
	Properties        []KeyAnyValue             `xml:"properties,omitempty"`
}

func init() {
	t["LicenseAssignmentManagerLicenseAssignment"] = reflect.TypeOf((*LicenseAssignmentManagerLicenseAssignment)(nil)).Elem()
}

type LicenseAvailabilityInfo struct {
	DynamicData

	Feature   LicenseFeatureInfo `xml:"feature"`
	Total     int32              `xml:"total"`
	Available int32              `xml:"available"`
}

func init() {
	t["LicenseAvailabilityInfo"] = reflect.TypeOf((*LicenseAvailabilityInfo)(nil)).Elem()
}

type LicenseDiagnostics struct {
	DynamicData

	SourceLastChanged      time.Time           `xml:"sourceLastChanged"`
	SourceLost             string              `xml:"sourceLost"`
	SourceLatency          float32             `xml:"sourceLatency"`
	LicenseRequests        string              `xml:"licenseRequests"`
	LicenseRequestFailures string              `xml:"licenseRequestFailures"`
	LicenseFeatureUnknowns string              `xml:"licenseFeatureUnknowns"`
	OpState                LicenseManagerState `xml:"opState"`
	LastStatusUpdate       time.Time           `xml:"lastStatusUpdate"`
	OpFailureMessage       string              `xml:"opFailureMessage"`
}

func init() {
	t["LicenseDiagnostics"] = reflect.TypeOf((*LicenseDiagnostics)(nil)).Elem()
}

type LicenseDowngradeDisallowed struct {
	NotEnoughLicenses

	Edition  string        `xml:"edition"`
	EntityId string        `xml:"entityId"`
	Features []KeyAnyValue `xml:"features"`
}

func init() {
	t["LicenseDowngradeDisallowed"] = reflect.TypeOf((*LicenseDowngradeDisallowed)(nil)).Elem()
}

type LicenseDowngradeDisallowedFault LicenseDowngradeDisallowed

func init() {
	t["LicenseDowngradeDisallowedFault"] = reflect.TypeOf((*LicenseDowngradeDisallowedFault)(nil)).Elem()
}

type LicenseEntityNotFound struct {
	VimFault

	EntityId string `xml:"entityId"`
}

func init() {
	t["LicenseEntityNotFound"] = reflect.TypeOf((*LicenseEntityNotFound)(nil)).Elem()
}

type LicenseEntityNotFoundFault LicenseEntityNotFound

func init() {
	t["LicenseEntityNotFoundFault"] = reflect.TypeOf((*LicenseEntityNotFoundFault)(nil)).Elem()
}

type LicenseEvent struct {
	Event
}

func init() {
	t["LicenseEvent"] = reflect.TypeOf((*LicenseEvent)(nil)).Elem()
}

type LicenseExpired struct {
	NotEnoughLicenses

	LicenseKey string `xml:"licenseKey"`
}

func init() {
	t["LicenseExpired"] = reflect.TypeOf((*LicenseExpired)(nil)).Elem()
}

type LicenseExpiredEvent struct {
	Event

	Feature LicenseFeatureInfo `xml:"feature"`
}

func init() {
	t["LicenseExpiredEvent"] = reflect.TypeOf((*LicenseExpiredEvent)(nil)).Elem()
}

type LicenseExpiredFault LicenseExpired

func init() {
	t["LicenseExpiredFault"] = reflect.TypeOf((*LicenseExpiredFault)(nil)).Elem()
}

type LicenseFeatureInfo struct {
	DynamicData

	Key                string                  `xml:"key"`
	FeatureName        string                  `xml:"featureName"`
	FeatureDescription string                  `xml:"featureDescription,omitempty"`
	State              LicenseFeatureInfoState `xml:"state,omitempty"`
	CostUnit           string                  `xml:"costUnit"`
	SourceRestriction  string                  `xml:"sourceRestriction,omitempty"`
	DependentKey       []string                `xml:"dependentKey,omitempty"`
	Edition            *bool                   `xml:"edition"`
	ExpiresOn          *time.Time              `xml:"expiresOn"`
}

func init() {
	t["LicenseFeatureInfo"] = reflect.TypeOf((*LicenseFeatureInfo)(nil)).Elem()
}

type LicenseKeyEntityMismatch struct {
	NotEnoughLicenses
}

func init() {
	t["LicenseKeyEntityMismatch"] = reflect.TypeOf((*LicenseKeyEntityMismatch)(nil)).Elem()
}

type LicenseKeyEntityMismatchFault LicenseKeyEntityMismatch

func init() {
	t["LicenseKeyEntityMismatchFault"] = reflect.TypeOf((*LicenseKeyEntityMismatchFault)(nil)).Elem()
}

type LicenseManagerEvaluationInfo struct {
	DynamicData

	Properties []KeyAnyValue `xml:"properties"`
}

func init() {
	t["LicenseManagerEvaluationInfo"] = reflect.TypeOf((*LicenseManagerEvaluationInfo)(nil)).Elem()
}

type LicenseManagerLicenseInfo struct {
	DynamicData

	LicenseKey string        `xml:"licenseKey"`
	EditionKey string        `xml:"editionKey"`
	Name       string        `xml:"name"`
	Total      int32         `xml:"total"`
	Used       int32         `xml:"used,omitempty"`
	CostUnit   string        `xml:"costUnit"`
	Properties []KeyAnyValue `xml:"properties,omitempty"`
	Labels     []KeyValue    `xml:"labels,omitempty"`
}

func init() {
	t["LicenseManagerLicenseInfo"] = reflect.TypeOf((*LicenseManagerLicenseInfo)(nil)).Elem()
}

type LicenseNonComplianceEvent struct {
	LicenseEvent

	Url string `xml:"url"`
}

func init() {
	t["LicenseNonComplianceEvent"] = reflect.TypeOf((*LicenseNonComplianceEvent)(nil)).Elem()
}

type LicenseReservationInfo struct {
	DynamicData

	Key      string                      `xml:"key"`
	State    LicenseReservationInfoState `xml:"state"`
	Required int32                       `xml:"required"`
}

func init() {
	t["LicenseReservationInfo"] = reflect.TypeOf((*LicenseReservationInfo)(nil)).Elem()
}

type LicenseRestricted struct {
	NotEnoughLicenses
}

func init() {
	t["LicenseRestricted"] = reflect.TypeOf((*LicenseRestricted)(nil)).Elem()
}

type LicenseRestrictedEvent struct {
	LicenseEvent
}

func init() {
	t["LicenseRestrictedEvent"] = reflect.TypeOf((*LicenseRestrictedEvent)(nil)).Elem()
}

type LicenseRestrictedFault LicenseRestricted

func init() {
	t["LicenseRestrictedFault"] = reflect.TypeOf((*LicenseRestrictedFault)(nil)).Elem()
}

type LicenseServerAvailableEvent struct {
	LicenseEvent

	LicenseServer string `xml:"licenseServer"`
}

func init() {
	t["LicenseServerAvailableEvent"] = reflect.TypeOf((*LicenseServerAvailableEvent)(nil)).Elem()
}

type LicenseServerSource struct {
	LicenseSource

	LicenseServer string `xml:"licenseServer"`
}

func init() {
	t["LicenseServerSource"] = reflect.TypeOf((*LicenseServerSource)(nil)).Elem()
}

type LicenseServerUnavailable struct {
	VimFault

	LicenseServer string `xml:"licenseServer"`
}

func init() {
	t["LicenseServerUnavailable"] = reflect.TypeOf((*LicenseServerUnavailable)(nil)).Elem()
}

type LicenseServerUnavailableEvent struct {
	LicenseEvent

	LicenseServer string `xml:"licenseServer"`
}

func init() {
	t["LicenseServerUnavailableEvent"] = reflect.TypeOf((*LicenseServerUnavailableEvent)(nil)).Elem()
}

type LicenseServerUnavailableFault LicenseServerUnavailable

func init() {
	t["LicenseServerUnavailableFault"] = reflect.TypeOf((*LicenseServerUnavailableFault)(nil)).Elem()
}

type LicenseSource struct {
	DynamicData
}

func init() {
	t["LicenseSource"] = reflect.TypeOf((*LicenseSource)(nil)).Elem()
}

type LicenseSourceUnavailable struct {
	NotEnoughLicenses

	LicenseSource BaseLicenseSource `xml:"licenseSource,typeattr"`
}

func init() {
	t["LicenseSourceUnavailable"] = reflect.TypeOf((*LicenseSourceUnavailable)(nil)).Elem()
}

type LicenseSourceUnavailableFault LicenseSourceUnavailable

func init() {
	t["LicenseSourceUnavailableFault"] = reflect.TypeOf((*LicenseSourceUnavailableFault)(nil)).Elem()
}

type LicenseUsageInfo struct {
	DynamicData

	Source          BaseLicenseSource        `xml:"source,typeattr"`
	SourceAvailable bool                     `xml:"sourceAvailable"`
	ReservationInfo []LicenseReservationInfo `xml:"reservationInfo,omitempty"`
	FeatureInfo     []LicenseFeatureInfo     `xml:"featureInfo,omitempty"`
}

func init() {
	t["LicenseUsageInfo"] = reflect.TypeOf((*LicenseUsageInfo)(nil)).Elem()
}

type LimitExceeded struct {
	VimFault

	Property string `xml:"property,omitempty"`
	Limit    *int32 `xml:"limit"`
}

func init() {
	t["LimitExceeded"] = reflect.TypeOf((*LimitExceeded)(nil)).Elem()
}

type LimitExceededFault LimitExceeded

func init() {
	t["LimitExceededFault"] = reflect.TypeOf((*LimitExceededFault)(nil)).Elem()
}

type LinkDiscoveryProtocolConfig struct {
	DynamicData

	Protocol  string `xml:"protocol"`
	Operation string `xml:"operation"`
}

func init() {
	t["LinkDiscoveryProtocolConfig"] = reflect.TypeOf((*LinkDiscoveryProtocolConfig)(nil)).Elem()
}

type LinkLayerDiscoveryProtocolInfo struct {
	DynamicData

	ChassisId  string        `xml:"chassisId"`
	PortId     string        `xml:"portId"`
	TimeToLive int32         `xml:"timeToLive"`
	Parameter  []KeyAnyValue `xml:"parameter,omitempty"`
}

func init() {
	t["LinkLayerDiscoveryProtocolInfo"] = reflect.TypeOf((*LinkLayerDiscoveryProtocolInfo)(nil)).Elem()
}

type LinkProfile struct {
	ApplyProfile
}

func init() {
	t["LinkProfile"] = reflect.TypeOf((*LinkProfile)(nil)).Elem()
}

type LinuxVolumeNotClean struct {
	CustomizationFault
}

func init() {
	t["LinuxVolumeNotClean"] = reflect.TypeOf((*LinuxVolumeNotClean)(nil)).Elem()
}

type LinuxVolumeNotCleanFault LinuxVolumeNotClean

func init() {
	t["LinuxVolumeNotCleanFault"] = reflect.TypeOf((*LinuxVolumeNotCleanFault)(nil)).Elem()
}

type ListCACertificateRevocationLists ListCACertificateRevocationListsRequestType

func init() {
	t["ListCACertificateRevocationLists"] = reflect.TypeOf((*ListCACertificateRevocationLists)(nil)).Elem()
}

type ListCACertificateRevocationListsRequestType struct {
	This ManagedObjectReference `xml:"_this"`
}

func init() {
	t["ListCACertificateRevocationListsRequestType"] = reflect.TypeOf((*ListCACertificateRevocationListsRequestType)(nil)).Elem()
}

type ListCACertificateRevocationListsResponse struct {
	Returnval []string `xml:"returnval,omitempty"`
}

type ListCACertificates ListCACertificatesRequestType

func init() {
	t["ListCACertificates"] = reflect.TypeOf((*ListCACertificates)(nil)).Elem()
}

type ListCACertificatesRequestType struct {
	This ManagedObjectReference `xml:"_this"`
}

func init() {
	t["ListCACertificatesRequestType"] = reflect.TypeOf((*ListCACertificatesRequestType)(nil)).Elem()
}

type ListCACertificatesResponse struct {
	Returnval []string `xml:"returnval,omitempty"`
}

type ListFilesInGuest ListFilesInGuestRequestType

func init() {
	t["ListFilesInGuest"] = reflect.TypeOf((*ListFilesInGuest)(nil)).Elem()
}

type ListFilesInGuestRequestType struct {
	This         ManagedObjectReference  `xml:"_this"`
	Vm           ManagedObjectReference  `xml:"vm"`
	Auth         BaseGuestAuthentication `xml:"auth,typeattr"`
	FilePath     string                  `xml:"filePath"`
	Index        int32                   `xml:"index,omitempty"`
	MaxResults   int32                   `xml:"maxResults,omitempty"`
	MatchPattern string                  `xml:"matchPattern,omitempty"`
}

func init() {
	t["ListFilesInGuestRequestType"] = reflect.TypeOf((*ListFilesInGuestRequestType)(nil)).Elem()
}

type ListFilesInGuestResponse struct {
	Returnval GuestListFileInfo `xml:"returnval"`
}

type ListGuestAliases ListGuestAliasesRequestType

func init() {
	t["ListGuestAliases"] = reflect.TypeOf((*ListGuestAliases)(nil)).Elem()
}

type ListGuestAliasesRequestType struct {
	This     ManagedObjectReference  `xml:"_this"`
	Vm       ManagedObjectReference  `xml:"vm"`
	Auth     BaseGuestAuthentication `xml:"auth,typeattr"`
	Username string                  `xml:"username"`
}

func init() {
	t["ListGuestAliasesRequestType"] = reflect.TypeOf((*ListGuestAliasesRequestType)(nil)).Elem()
}

type ListGuestAliasesResponse struct {
	Returnval []GuestAliases `xml:"returnval,omitempty"`
}

type ListGuestMappedAliases ListGuestMappedAliasesRequestType

func init() {
	t["ListGuestMappedAliases"] = reflect.TypeOf((*ListGuestMappedAliases)(nil)).Elem()
}

type ListGuestMappedAliasesRequestType struct {
	This ManagedObjectReference  `xml:"_this"`
	Vm   ManagedObjectReference  `xml:"vm"`
	Auth BaseGuestAuthentication `xml:"auth,typeattr"`
}

func init() {
	t["ListGuestMappedAliasesRequestType"] = reflect.TypeOf((*ListGuestMappedAliasesRequestType)(nil)).Elem()
}

type ListGuestMappedAliasesResponse struct {
	Returnval []GuestMappedAliases `xml:"returnval,omitempty"`
}

type ListKeys ListKeysRequestType

func init() {
	t["ListKeys"] = reflect.TypeOf((*ListKeys)(nil)).Elem()
}

type ListKeysRequestType struct {
	This  ManagedObjectReference `xml:"_this"`
	Limit *int32                 `xml:"limit"`
}

func init() {
	t["ListKeysRequestType"] = reflect.TypeOf((*ListKeysRequestType)(nil)).Elem()
}

type ListKeysResponse struct {
	Returnval []CryptoKeyId `xml:"returnval,omitempty"`
}

type ListKmipServers ListKmipServersRequestType

func init() {
	t["ListKmipServers"] = reflect.TypeOf((*ListKmipServers)(nil)).Elem()
}

type ListKmipServersRequestType struct {
	This  ManagedObjectReference `xml:"_this"`
	Limit *int32                 `xml:"limit"`
}

func init() {
	t["ListKmipServersRequestType"] = reflect.TypeOf((*ListKmipServersRequestType)(nil)).Elem()
}

type ListKmipServersResponse struct {
	Returnval []KmipClusterInfo `xml:"returnval,omitempty"`
}

type ListKmsClusters ListKmsClustersRequestType

func init() {
	t["ListKmsClusters"] = reflect.TypeOf((*ListKmsClusters)(nil)).Elem()
}

type ListKmsClustersRequestType struct {
	This                 ManagedObjectReference `xml:"_this"`
	IncludeKmsServers    *bool                  `xml:"includeKmsServers"`
	ManagementTypeFilter int32                  `xml:"managementTypeFilter,omitempty"`
	StatusFilter         int32                  `xml:"statusFilter,omitempty"`
}

func init() {
	t["ListKmsClustersRequestType"] = reflect.TypeOf((*ListKmsClustersRequestType)(nil)).Elem()
}

type ListKmsClustersResponse struct {
	Returnval []KmipClusterInfo `xml:"returnval,omitempty"`
}

type ListProcessesInGuest ListProcessesInGuestRequestType

func init() {
	t["ListProcessesInGuest"] = reflect.TypeOf((*ListProcessesInGuest)(nil)).Elem()
}

type ListProcessesInGuestRequestType struct {
	This ManagedObjectReference  `xml:"_this"`
	Vm   ManagedObjectReference  `xml:"vm"`
	Auth BaseGuestAuthentication `xml:"auth,typeattr"`
	Pids []int64                 `xml:"pids,omitempty"`
}

func init() {
	t["ListProcessesInGuestRequestType"] = reflect.TypeOf((*ListProcessesInGuestRequestType)(nil)).Elem()
}

type ListProcessesInGuestResponse struct {
	Returnval []GuestProcessInfo `xml:"returnval,omitempty"`
}

type ListRegistryKeysInGuest ListRegistryKeysInGuestRequestType

func init() {
	t["ListRegistryKeysInGuest"] = reflect.TypeOf((*ListRegistryKeysInGuest)(nil)).Elem()
}

type ListRegistryKeysInGuestRequestType struct {
	This         ManagedObjectReference  `xml:"_this"`
	Vm           ManagedObjectReference  `xml:"vm"`
	Auth         BaseGuestAuthentication `xml:"auth,typeattr"`
	KeyName      GuestRegKeyNameSpec     `xml:"keyName"`
	Recursive    bool                    `xml:"recursive"`
	MatchPattern string                  `xml:"matchPattern,omitempty"`
}

func init() {
	t["ListRegistryKeysInGuestRequestType"] = reflect.TypeOf((*ListRegistryKeysInGuestRequestType)(nil)).Elem()
}

type ListRegistryKeysInGuestResponse struct {
	Returnval []GuestRegKeyRecordSpec `xml:"returnval,omitempty"`
}

type ListRegistryValuesInGuest ListRegistryValuesInGuestRequestType

func init() {
	t["ListRegistryValuesInGuest"] = reflect.TypeOf((*ListRegistryValuesInGuest)(nil)).Elem()
}

type ListRegistryValuesInGuestRequestType struct {
	This          ManagedObjectReference  `xml:"_this"`
	Vm            ManagedObjectReference  `xml:"vm"`
	Auth          BaseGuestAuthentication `xml:"auth,typeattr"`
	KeyName       GuestRegKeyNameSpec     `xml:"keyName"`
	ExpandStrings bool                    `xml:"expandStrings"`
	MatchPattern  string                  `xml:"matchPattern,omitempty"`
}

func init() {
	t["ListRegistryValuesInGuestRequestType"] = reflect.TypeOf((*ListRegistryValuesInGuestRequestType)(nil)).Elem()
}

type ListRegistryValuesInGuestResponse struct {
	Returnval []GuestRegValueSpec `xml:"returnval,omitempty"`
}

type ListSmartCardTrustAnchors ListSmartCardTrustAnchorsRequestType

func init() {
	t["ListSmartCardTrustAnchors"] = reflect.TypeOf((*ListSmartCardTrustAnchors)(nil)).Elem()
}

type ListSmartCardTrustAnchorsRequestType struct {
	This ManagedObjectReference `xml:"_this"`
}

func init() {
	t["ListSmartCardTrustAnchorsRequestType"] = reflect.TypeOf((*ListSmartCardTrustAnchorsRequestType)(nil)).Elem()
}

type ListSmartCardTrustAnchorsResponse struct {
	Returnval []string `xml:"returnval,omitempty"`
}

type ListTagsAttachedToVStorageObject ListTagsAttachedToVStorageObjectRequestType

func init() {
	t["ListTagsAttachedToVStorageObject"] = reflect.TypeOf((*ListTagsAttachedToVStorageObject)(nil)).Elem()
}

type ListTagsAttachedToVStorageObjectRequestType struct {
	This ManagedObjectReference `xml:"_this"`
	Id   ID                     `xml:"id"`
}

func init() {
	t["ListTagsAttachedToVStorageObjectRequestType"] = reflect.TypeOf((*ListTagsAttachedToVStorageObjectRequestType)(nil)).Elem()
}

type ListTagsAttachedToVStorageObjectResponse struct {
	Returnval []VslmTagEntry `xml:"returnval,omitempty"`
}

type ListVStorageObject ListVStorageObjectRequestType

func init() {
	t["ListVStorageObject"] = reflect.TypeOf((*ListVStorageObject)(nil)).Elem()
}

type ListVStorageObjectRequestType struct {
	This      ManagedObjectReference `xml:"_this"`
	Datastore ManagedObjectReference `xml:"datastore"`
}

func init() {
	t["ListVStorageObjectRequestType"] = reflect.TypeOf((*ListVStorageObjectRequestType)(nil)).Elem()
}

type ListVStorageObjectResponse struct {
	Returnval []ID `xml:"returnval,omitempty"`
}

type ListVStorageObjectsAttachedToTag ListVStorageObjectsAttachedToTagRequestType

func init() {
	t["ListVStorageObjectsAttachedToTag"] = reflect.TypeOf((*ListVStorageObjectsAttachedToTag)(nil)).Elem()
}

type ListVStorageObjectsAttachedToTagRequestType struct {
	This     ManagedObjectReference `xml:"_this"`
	Category string                 `xml:"category"`
	Tag      string                 `xml:"tag"`
}

func init() {
	t["ListVStorageObjectsAttachedToTagRequestType"] = reflect.TypeOf((*ListVStorageObjectsAttachedToTagRequestType)(nil)).Elem()
}

type ListVStorageObjectsAttachedToTagResponse struct {
	Returnval []ID `xml:"returnval,omitempty"`
}

type LocalDatastoreCreatedEvent struct {
	HostEvent

	Datastore    DatastoreEventArgument `xml:"datastore"`
	DatastoreUrl string                 `xml:"datastoreUrl,omitempty"`
}

func init() {
	t["LocalDatastoreCreatedEvent"] = reflect.TypeOf((*LocalDatastoreCreatedEvent)(nil)).Elem()
}

type LocalDatastoreInfo struct {
	DatastoreInfo

	Path string `xml:"path,omitempty"`
}

func init() {
	t["LocalDatastoreInfo"] = reflect.TypeOf((*LocalDatastoreInfo)(nil)).Elem()
}

type LocalLicenseSource struct {
	LicenseSource

	LicenseKeys string `xml:"licenseKeys"`
}

func init() {
	t["LocalLicenseSource"] = reflect.TypeOf((*LocalLicenseSource)(nil)).Elem()
}

type LocalTSMEnabledEvent struct {
	HostEvent
}

func init() {
	t["LocalTSMEnabledEvent"] = reflect.TypeOf((*LocalTSMEnabledEvent)(nil)).Elem()
}

type LocalizableMessage struct {
	DynamicData

	Key     string        `xml:"key"`
	Arg     []KeyAnyValue `xml:"arg,omitempty"`
	Message string        `xml:"message,omitempty"`
}

func init() {
	t["LocalizableMessage"] = reflect.TypeOf((*LocalizableMessage)(nil)).Elem()
}

type LocalizationManagerMessageCatalog struct {
	DynamicData

	ModuleName   string     `xml:"moduleName"`
	CatalogName  string     `xml:"catalogName"`
	Locale       string     `xml:"locale"`
	CatalogUri   string     `xml:"catalogUri"`
	LastModified *time.Time `xml:"lastModified"`
	Md5sum       string     `xml:"md5sum,omitempty"`
	Version      string     `xml:"version,omitempty"`
}

func init() {
	t["LocalizationManagerMessageCatalog"] = reflect.TypeOf((*LocalizationManagerMessageCatalog)(nil)).Elem()
}

type LocalizedMethodFault struct {
	DynamicData

	Fault            BaseMethodFault `xml:"fault,typeattr"`
	LocalizedMessage string          `xml:"localizedMessage,omitempty"`
}

func init() {
	t["LocalizedMethodFault"] = reflect.TypeOf((*LocalizedMethodFault)(nil)).Elem()
}

type LockerMisconfiguredEvent struct {
	Event

	Datastore DatastoreEventArgument `xml:"datastore"`
}

func init() {
	t["LockerMisconfiguredEvent"] = reflect.TypeOf((*LockerMisconfiguredEvent)(nil)).Elem()
}

type LockerReconfiguredEvent struct {
	Event

	OldDatastore *DatastoreEventArgument `xml:"oldDatastore,omitempty"`
	NewDatastore *DatastoreEventArgument `xml:"newDatastore,omitempty"`
}

func init() {
	t["LockerReconfiguredEvent"] = reflect.TypeOf((*LockerReconfiguredEvent)(nil)).Elem()
}

type LogBundlingFailed struct {
	VimFault
}

func init() {
	t["LogBundlingFailed"] = reflect.TypeOf((*LogBundlingFailed)(nil)).Elem()
}

type LogBundlingFailedFault LogBundlingFailed

func init() {
	t["LogBundlingFailedFault"] = reflect.TypeOf((*LogBundlingFailedFault)(nil)).Elem()
}

type LogUserEvent LogUserEventRequestType

func init() {
	t["LogUserEvent"] = reflect.TypeOf((*LogUserEvent)(nil)).Elem()
}

type LogUserEventRequestType struct {
	This   ManagedObjectReference `xml:"_this"`
	Entity ManagedObjectReference `xml:"entity"`
	Msg    string                 `xml:"msg"`
}

func init() {
	t["LogUserEventRequestType"] = reflect.TypeOf((*LogUserEventRequestType)(nil)).Elem()
}

type LogUserEventResponse struct {
}

type Login LoginRequestType

func init() {
	t["Login"] = reflect.TypeOf((*Login)(nil)).Elem()
}

type LoginBySSPI LoginBySSPIRequestType

func init() {
	t["LoginBySSPI"] = reflect.TypeOf((*LoginBySSPI)(nil)).Elem()
}

type LoginBySSPIRequestType struct {
	This        ManagedObjectReference `xml:"_this"`
	Base64Token string                 `xml:"base64Token"`
	Locale      string                 `xml:"locale,omitempty"`
}

func init() {
	t["LoginBySSPIRequestType"] = reflect.TypeOf((*LoginBySSPIRequestType)(nil)).Elem()
}

type LoginBySSPIResponse struct {
	Returnval UserSession `xml:"returnval"`
}

type LoginByToken LoginByTokenRequestType

func init() {
	t["LoginByToken"] = reflect.TypeOf((*LoginByToken)(nil)).Elem()
}

type LoginByTokenRequestType struct {
	This   ManagedObjectReference `xml:"_this"`
	Locale string                 `xml:"locale,omitempty"`
}

func init() {
	t["LoginByTokenRequestType"] = reflect.TypeOf((*LoginByTokenRequestType)(nil)).Elem()
}

type LoginByTokenResponse struct {
	Returnval UserSession `xml:"returnval"`
}

type LoginExtensionByCertificate LoginExtensionByCertificateRequestType

func init() {
	t["LoginExtensionByCertificate"] = reflect.TypeOf((*LoginExtensionByCertificate)(nil)).Elem()
}

type LoginExtensionByCertificateRequestType struct {
	This         ManagedObjectReference `xml:"_this"`
	ExtensionKey string                 `xml:"extensionKey"`
	Locale       string                 `xml:"locale,omitempty"`
}

func init() {
	t["LoginExtensionByCertificateRequestType"] = reflect.TypeOf((*LoginExtensionByCertificateRequestType)(nil)).Elem()
}

type LoginExtensionByCertificateResponse struct {
	Returnval UserSession `xml:"returnval"`
}

type LoginExtensionBySubjectName LoginExtensionBySubjectNameRequestType

func init() {
	t["LoginExtensionBySubjectName"] = reflect.TypeOf((*LoginExtensionBySubjectName)(nil)).Elem()
}

type LoginExtensionBySubjectNameRequestType struct {
	This         ManagedObjectReference `xml:"_this"`
	ExtensionKey string                 `xml:"extensionKey"`
	Locale       string                 `xml:"locale,omitempty"`
}

func init() {
	t["LoginExtensionBySubjectNameRequestType"] = reflect.TypeOf((*LoginExtensionBySubjectNameRequestType)(nil)).Elem()
}

type LoginExtensionBySubjectNameResponse struct {
	Returnval UserSession `xml:"returnval"`
}

type LoginRequestType struct {
	This     ManagedObjectReference `xml:"_this"`
	UserName string                 `xml:"userName"`
	Password string                 `xml:"password"`
	Locale   string                 `xml:"locale,omitempty"`
}

func init() {
	t["LoginRequestType"] = reflect.TypeOf((*LoginRequestType)(nil)).Elem()
}

type LoginResponse struct {
	Returnval UserSession `xml:"returnval"`
}

type Logout LogoutRequestType

func init() {
	t["Logout"] = reflect.TypeOf((*Logout)(nil)).Elem()
}

type LogoutRequestType struct {
	This ManagedObjectReference `xml:"_this"`
}

func init() {
	t["LogoutRequestType"] = reflect.TypeOf((*LogoutRequestType)(nil)).Elem()
}

type LogoutResponse struct {
}

type LongOption struct {
	OptionType

	Min          int64 `xml:"min"`
	Max          int64 `xml:"max"`
	DefaultValue int64 `xml:"defaultValue"`
}

func init() {
	t["LongOption"] = reflect.TypeOf((*LongOption)(nil)).Elem()
}

type LongPolicy struct {
	InheritablePolicy

	Value int64 `xml:"value,omitempty"`
}

func init() {
	t["LongPolicy"] = reflect.TypeOf((*LongPolicy)(nil)).Elem()
}

type LookupDvPortGroup LookupDvPortGroupRequestType

func init() {
	t["LookupDvPortGroup"] = reflect.TypeOf((*LookupDvPortGroup)(nil)).Elem()
}

type LookupDvPortGroupRequestType struct {
	This         ManagedObjectReference `xml:"_this"`
	PortgroupKey string                 `xml:"portgroupKey"`
}

func init() {
	t["LookupDvPortGroupRequestType"] = reflect.TypeOf((*LookupDvPortGroupRequestType)(nil)).Elem()
}

type LookupDvPortGroupResponse struct {
	Returnval *ManagedObjectReference `xml:"returnval,omitempty"`
}

type LookupVmOverheadMemory LookupVmOverheadMemoryRequestType

func init() {
	t["LookupVmOverheadMemory"] = reflect.TypeOf((*LookupVmOverheadMemory)(nil)).Elem()
}

type LookupVmOverheadMemoryRequestType struct {
	This ManagedObjectReference `xml:"_this"`
	Vm   ManagedObjectReference `xml:"vm"`
	Host ManagedObjectReference `xml:"host"`
}

func init() {
	t["LookupVmOverheadMemoryRequestType"] = reflect.TypeOf((*LookupVmOverheadMemoryRequestType)(nil)).Elem()
}

type LookupVmOverheadMemoryResponse struct {
	Returnval int64 `xml:"returnval"`
}

type MacAddress struct {
	NegatableExpression
}

func init() {
	t["MacAddress"] = reflect.TypeOf((*MacAddress)(nil)).Elem()
}

type MacRange struct {
	MacAddress

	Address string `xml:"address"`
	Mask    string `xml:"mask"`
}

func init() {
	t["MacRange"] = reflect.TypeOf((*MacRange)(nil)).Elem()
}

type MaintenanceModeFileMove struct {
	MigrationFault
}

func init() {
	t["MaintenanceModeFileMove"] = reflect.TypeOf((*MaintenanceModeFileMove)(nil)).Elem()
}

type MaintenanceModeFileMoveFault MaintenanceModeFileMove

func init() {
	t["MaintenanceModeFileMoveFault"] = reflect.TypeOf((*MaintenanceModeFileMoveFault)(nil)).Elem()
}

type MakeDirectory MakeDirectoryRequestType

func init() {
	t["MakeDirectory"] = reflect.TypeOf((*MakeDirectory)(nil)).Elem()
}

type MakeDirectoryInGuest MakeDirectoryInGuestRequestType

func init() {
	t["MakeDirectoryInGuest"] = reflect.TypeOf((*MakeDirectoryInGuest)(nil)).Elem()
}

type MakeDirectoryInGuestRequestType struct {
	This                    ManagedObjectReference  `xml:"_this"`
	Vm                      ManagedObjectReference  `xml:"vm"`
	Auth                    BaseGuestAuthentication `xml:"auth,typeattr"`
	DirectoryPath           string                  `xml:"directoryPath"`
	CreateParentDirectories bool                    `xml:"createParentDirectories"`
}

func init() {
	t["MakeDirectoryInGuestRequestType"] = reflect.TypeOf((*MakeDirectoryInGuestRequestType)(nil)).Elem()
}

type MakeDirectoryInGuestResponse struct {
}

type MakeDirectoryRequestType struct {
	This                    ManagedObjectReference  `xml:"_this"`
	Name                    string                  `xml:"name"`
	Datacenter              *ManagedObjectReference `xml:"datacenter,omitempty"`
	CreateParentDirectories *bool                   `xml:"createParentDirectories"`
}

func init() {
	t["MakeDirectoryRequestType"] = reflect.TypeOf((*MakeDirectoryRequestType)(nil)).Elem()
}

type MakeDirectoryResponse struct {
}

type MakePrimaryVMRequestType struct {
	This ManagedObjectReference `xml:"_this"`
	Vm   ManagedObjectReference `xml:"vm"`
}

func init() {
	t["MakePrimaryVMRequestType"] = reflect.TypeOf((*MakePrimaryVMRequestType)(nil)).Elem()
}

type MakePrimaryVM_Task MakePrimaryVMRequestType

func init() {
	t["MakePrimaryVM_Task"] = reflect.TypeOf((*MakePrimaryVM_Task)(nil)).Elem()
}

type MakePrimaryVM_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval"`
}

type ManagedByInfo struct {
	DynamicData

	ExtensionKey string `xml:"extensionKey"`
	Type         string `xml:"type"`
}

func init() {
	t["ManagedByInfo"] = reflect.TypeOf((*ManagedByInfo)(nil)).Elem()
}

type ManagedEntityEventArgument struct {
	EntityEventArgument

	Entity ManagedObjectReference `xml:"entity"`
}

func init() {
	t["ManagedEntityEventArgument"] = reflect.TypeOf((*ManagedEntityEventArgument)(nil)).Elem()
}

type ManagedObjectNotFound struct {
	RuntimeFault

	Obj ManagedObjectReference `xml:"obj"`
}

func init() {
	t["ManagedObjectNotFound"] = reflect.TypeOf((*ManagedObjectNotFound)(nil)).Elem()
}

type ManagedObjectNotFoundFault ManagedObjectNotFound

func init() {
	t["ManagedObjectNotFoundFault"] = reflect.TypeOf((*ManagedObjectNotFoundFault)(nil)).Elem()
}

type ManagedObjectReference struct {
	Type  string `xml:"type,attr"`
	Value string `xml:",chardata"`
}

func init() {
	t["ManagedObjectReference"] = reflect.TypeOf((*ManagedObjectReference)(nil)).Elem()
}

type MarkAsLocalRequestType struct {
	This         ManagedObjectReference `xml:"_this"`
	ScsiDiskUuid string                 `xml:"scsiDiskUuid"`
}

func init() {
	t["MarkAsLocalRequestType"] = reflect.TypeOf((*MarkAsLocalRequestType)(nil)).Elem()
}

type MarkAsLocal_Task MarkAsLocalRequestType

func init() {
	t["MarkAsLocal_Task"] = reflect.TypeOf((*MarkAsLocal_Task)(nil)).Elem()
}

type MarkAsLocal_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval"`
}

type MarkAsNonLocalRequestType struct {
	This         ManagedObjectReference `xml:"_this"`
	ScsiDiskUuid string                 `xml:"scsiDiskUuid"`
}

func init() {
	t["MarkAsNonLocalRequestType"] = reflect.TypeOf((*MarkAsNonLocalRequestType)(nil)).Elem()
}

type MarkAsNonLocal_Task MarkAsNonLocalRequestType

func init() {
	t["MarkAsNonLocal_Task"] = reflect.TypeOf((*MarkAsNonLocal_Task)(nil)).Elem()
}

type MarkAsNonLocal_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval"`
}

type MarkAsNonSsdRequestType struct {
	This         ManagedObjectReference `xml:"_this"`
	ScsiDiskUuid string                 `xml:"scsiDiskUuid"`
}

func init() {
	t["MarkAsNonSsdRequestType"] = reflect.TypeOf((*MarkAsNonSsdRequestType)(nil)).Elem()
}

type MarkAsNonSsd_Task MarkAsNonSsdRequestType

func init() {
	t["MarkAsNonSsd_Task"] = reflect.TypeOf((*MarkAsNonSsd_Task)(nil)).Elem()
}

type MarkAsNonSsd_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval"`
}

type MarkAsSsdRequestType struct {
	This         ManagedObjectReference `xml:"_this"`
	ScsiDiskUuid string                 `xml:"scsiDiskUuid"`
}

func init() {
	t["MarkAsSsdRequestType"] = reflect.TypeOf((*MarkAsSsdRequestType)(nil)).Elem()
}

type MarkAsSsd_Task MarkAsSsdRequestType

func init() {
	t["MarkAsSsd_Task"] = reflect.TypeOf((*MarkAsSsd_Task)(nil)).Elem()
}

type MarkAsSsd_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval"`
}

type MarkAsTemplate MarkAsTemplateRequestType

func init() {
	t["MarkAsTemplate"] = reflect.TypeOf((*MarkAsTemplate)(nil)).Elem()
}

type MarkAsTemplateRequestType struct {
	This ManagedObjectReference `xml:"_this"`
}

func init() {
	t["MarkAsTemplateRequestType"] = reflect.TypeOf((*MarkAsTemplateRequestType)(nil)).Elem()
}

type MarkAsTemplateResponse struct {
}

type MarkAsVirtualMachine MarkAsVirtualMachineRequestType

func init() {
	t["MarkAsVirtualMachine"] = reflect.TypeOf((*MarkAsVirtualMachine)(nil)).Elem()
}

type MarkAsVirtualMachineRequestType struct {
	This ManagedObjectReference  `xml:"_this"`
	Pool ManagedObjectReference  `xml:"pool"`
	Host *ManagedObjectReference `xml:"host,omitempty"`
}

func init() {
	t["MarkAsVirtualMachineRequestType"] = reflect.TypeOf((*MarkAsVirtualMachineRequestType)(nil)).Elem()
}

type MarkAsVirtualMachineResponse struct {
}

type MarkDefault MarkDefaultRequestType

func init() {
	t["MarkDefault"] = reflect.TypeOf((*MarkDefault)(nil)).Elem()
}

type MarkDefaultRequestType struct {
	This      ManagedObjectReference `xml:"_this"`
	ClusterId KeyProviderId          `xml:"clusterId"`
}

func init() {
	t["MarkDefaultRequestType"] = reflect.TypeOf((*MarkDefaultRequestType)(nil)).Elem()
}

type MarkDefaultResponse struct {
}

type MarkForRemoval MarkForRemovalRequestType

func init() {
	t["MarkForRemoval"] = reflect.TypeOf((*MarkForRemoval)(nil)).Elem()
}

type MarkForRemovalRequestType struct {
	This    ManagedObjectReference `xml:"_this"`
	HbaName string                 `xml:"hbaName"`
	Remove  bool                   `xml:"remove"`
}

func init() {
	t["MarkForRemovalRequestType"] = reflect.TypeOf((*MarkForRemovalRequestType)(nil)).Elem()
}

type MarkForRemovalResponse struct {
}

type MarkPerenniallyReserved MarkPerenniallyReservedRequestType

func init() {
	t["MarkPerenniallyReserved"] = reflect.TypeOf((*MarkPerenniallyReserved)(nil)).Elem()
}

type MarkPerenniallyReservedExRequestType struct {
	This    ManagedObjectReference `xml:"_this"`
	LunUuid []string               `xml:"lunUuid,omitempty"`
	State   bool                   `xml:"state"`
}

func init() {
	t["MarkPerenniallyReservedExRequestType"] = reflect.TypeOf((*MarkPerenniallyReservedExRequestType)(nil)).Elem()
}

type MarkPerenniallyReservedEx_Task MarkPerenniallyReservedExRequestType

func init() {
	t["MarkPerenniallyReservedEx_Task"] = reflect.TypeOf((*MarkPerenniallyReservedEx_Task)(nil)).Elem()
}

type MarkPerenniallyReservedEx_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval"`
}

type MarkPerenniallyReservedRequestType struct {
	This    ManagedObjectReference `xml:"_this"`
	LunUuid string                 `xml:"lunUuid"`
	State   bool                   `xml:"state"`
}

func init() {
	t["MarkPerenniallyReservedRequestType"] = reflect.TypeOf((*MarkPerenniallyReservedRequestType)(nil)).Elem()
}

type MarkPerenniallyReservedResponse struct {
}

type MarkServiceProviderEntities MarkServiceProviderEntitiesRequestType

func init() {
	t["MarkServiceProviderEntities"] = reflect.TypeOf((*MarkServiceProviderEntities)(nil)).Elem()
}

type MarkServiceProviderEntitiesRequestType struct {
	This   ManagedObjectReference   `xml:"_this"`
	Entity []ManagedObjectReference `xml:"entity,omitempty"`
}

func init() {
	t["MarkServiceProviderEntitiesRequestType"] = reflect.TypeOf((*MarkServiceProviderEntitiesRequestType)(nil)).Elem()
}

type MarkServiceProviderEntitiesResponse struct {
}

type MemoryFileFormatNotSupportedByDatastore struct {
	UnsupportedDatastore

	DatastoreName string `xml:"datastoreName"`
	Type          string `xml:"type"`
}

func init() {
	t["MemoryFileFormatNotSupportedByDatastore"] = reflect.TypeOf((*MemoryFileFormatNotSupportedByDatastore)(nil)).Elem()
}

type MemoryFileFormatNotSupportedByDatastoreFault MemoryFileFormatNotSupportedByDatastore

func init() {
	t["MemoryFileFormatNotSupportedByDatastoreFault"] = reflect.TypeOf((*MemoryFileFormatNotSupportedByDatastoreFault)(nil)).Elem()
}

type MemoryHotPlugNotSupported struct {
	VmConfigFault
}

func init() {
	t["MemoryHotPlugNotSupported"] = reflect.TypeOf((*MemoryHotPlugNotSupported)(nil)).Elem()
}

type MemoryHotPlugNotSupportedFault MemoryHotPlugNotSupported

func init() {
	t["MemoryHotPlugNotSupportedFault"] = reflect.TypeOf((*MemoryHotPlugNotSupportedFault)(nil)).Elem()
}

type MemorySizeNotRecommended struct {
	VirtualHardwareCompatibilityIssue

	MemorySizeMB    int32 `xml:"memorySizeMB"`
	MinMemorySizeMB int32 `xml:"minMemorySizeMB"`
	MaxMemorySizeMB int32 `xml:"maxMemorySizeMB"`
}

func init() {
	t["MemorySizeNotRecommended"] = reflect.TypeOf((*MemorySizeNotRecommended)(nil)).Elem()
}

type MemorySizeNotRecommendedFault MemorySizeNotRecommended

func init() {
	t["MemorySizeNotRecommendedFault"] = reflect.TypeOf((*MemorySizeNotRecommendedFault)(nil)).Elem()
}

type MemorySizeNotSupported struct {
	VirtualHardwareCompatibilityIssue

	MemorySizeMB    int32 `xml:"memorySizeMB"`
	MinMemorySizeMB int32 `xml:"minMemorySizeMB"`
	MaxMemorySizeMB int32 `xml:"maxMemorySizeMB"`
}

func init() {
	t["MemorySizeNotSupported"] = reflect.TypeOf((*MemorySizeNotSupported)(nil)).Elem()
}

type MemorySizeNotSupportedByDatastore struct {
	VirtualHardwareCompatibilityIssue

	Datastore       ManagedObjectReference `xml:"datastore"`
	MemorySizeMB    int32                  `xml:"memorySizeMB"`
	MaxMemorySizeMB int32                  `xml:"maxMemorySizeMB"`
}

func init() {
	t["MemorySizeNotSupportedByDatastore"] = reflect.TypeOf((*MemorySizeNotSupportedByDatastore)(nil)).Elem()
}

type MemorySizeNotSupportedByDatastoreFault MemorySizeNotSupportedByDatastore

func init() {
	t["MemorySizeNotSupportedByDatastoreFault"] = reflect.TypeOf((*MemorySizeNotSupportedByDatastoreFault)(nil)).Elem()
}

type MemorySizeNotSupportedFault MemorySizeNotSupported

func init() {
	t["MemorySizeNotSupportedFault"] = reflect.TypeOf((*MemorySizeNotSupportedFault)(nil)).Elem()
}

type MemorySnapshotOnIndependentDisk struct {
	SnapshotFault
}

func init() {
	t["MemorySnapshotOnIndependentDisk"] = reflect.TypeOf((*MemorySnapshotOnIndependentDisk)(nil)).Elem()
}

type MemorySnapshotOnIndependentDiskFault MemorySnapshotOnIndependentDisk

func init() {
	t["MemorySnapshotOnIndependentDiskFault"] = reflect.TypeOf((*MemorySnapshotOnIndependentDiskFault)(nil)).Elem()
}

type MergeDvsRequestType struct {
	This ManagedObjectReference `xml:"_this"`
	Dvs  ManagedObjectReference `xml:"dvs"`
}

func init() {
	t["MergeDvsRequestType"] = reflect.TypeOf((*MergeDvsRequestType)(nil)).Elem()
}

type MergeDvs_Task MergeDvsRequestType

func init() {
	t["MergeDvs_Task"] = reflect.TypeOf((*MergeDvs_Task)(nil)).Elem()
}

type MergeDvs_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval"`
}

type MergePermissions MergePermissionsRequestType

func init() {
	t["MergePermissions"] = reflect.TypeOf((*MergePermissions)(nil)).Elem()
}

type MergePermissionsRequestType struct {
	This      ManagedObjectReference `xml:"_this"`
	SrcRoleId int32                  `xml:"srcRoleId"`
	DstRoleId int32                  `xml:"dstRoleId"`
}

func init() {
	t["MergePermissionsRequestType"] = reflect.TypeOf((*MergePermissionsRequestType)(nil)).Elem()
}

type MergePermissionsResponse struct {
}

type MethodAction struct {
	Action

	Name     string                 `xml:"name"`
	Argument []MethodActionArgument `xml:"argument,omitempty"`
}

func init() {
	t["MethodAction"] = reflect.TypeOf((*MethodAction)(nil)).Elem()
}

type MethodActionArgument struct {
	DynamicData

	Value AnyType `xml:"value,typeattr"`
}

func init() {
	t["MethodActionArgument"] = reflect.TypeOf((*MethodActionArgument)(nil)).Elem()
}

type MethodAlreadyDisabledFault struct {
	RuntimeFault

	SourceId string `xml:"sourceId"`
}

func init() {
	t["MethodAlreadyDisabledFault"] = reflect.TypeOf((*MethodAlreadyDisabledFault)(nil)).Elem()
}

type MethodAlreadyDisabledFaultFault MethodAlreadyDisabledFault

func init() {
	t["MethodAlreadyDisabledFaultFault"] = reflect.TypeOf((*MethodAlreadyDisabledFaultFault)(nil)).Elem()
}

type MethodDescription struct {
	Description

	Key string `xml:"key"`
}

func init() {
	t["MethodDescription"] = reflect.TypeOf((*MethodDescription)(nil)).Elem()
}

type MethodDisabled struct {
	RuntimeFault

	Source string `xml:"source,omitempty"`
}

func init() {
	t["MethodDisabled"] = reflect.TypeOf((*MethodDisabled)(nil)).Elem()
}

type MethodDisabledFault MethodDisabled

func init() {
	t["MethodDisabledFault"] = reflect.TypeOf((*MethodDisabledFault)(nil)).Elem()
}

type MethodFault struct {
	FaultCause   *LocalizedMethodFault `xml:"faultCause,omitempty"`
	FaultMessage []LocalizableMessage  `xml:"faultMessage,omitempty"`
}

func init() {
	t["MethodFault"] = reflect.TypeOf((*MethodFault)(nil)).Elem()
}

type MethodFaultFault BaseMethodFault

func init() {
	t["MethodFaultFault"] = reflect.TypeOf((*MethodFaultFault)(nil)).Elem()
}

type MethodNotFound struct {
	InvalidRequest

	Receiver ManagedObjectReference `xml:"receiver"`
	Method   string                 `xml:"method"`
}

func init() {
	t["MethodNotFound"] = reflect.TypeOf((*MethodNotFound)(nil)).Elem()
}

type MethodNotFoundFault MethodNotFound

func init() {
	t["MethodNotFoundFault"] = reflect.TypeOf((*MethodNotFoundFault)(nil)).Elem()
}

type MetricAlarmExpression struct {
	AlarmExpression

	Operator       MetricAlarmOperator `xml:"operator"`
	Type           string              `xml:"type"`
	Metric         PerfMetricId        `xml:"metric"`
	Yellow         int32               `xml:"yellow,omitempty"`
	YellowInterval int32               `xml:"yellowInterval,omitempty"`
	Red            int32               `xml:"red,omitempty"`
	RedInterval    int32               `xml:"redInterval,omitempty"`
}

func init() {
	t["MetricAlarmExpression"] = reflect.TypeOf((*MetricAlarmExpression)(nil)).Elem()
}

type MigrateVMRequestType struct {
	This     ManagedObjectReference     `xml:"_this"`
	Pool     *ManagedObjectReference    `xml:"pool,omitempty"`
	Host     *ManagedObjectReference    `xml:"host,omitempty"`
	Priority VirtualMachineMovePriority `xml:"priority"`
	State    VirtualMachinePowerState   `xml:"state,omitempty"`
}

func init() {
	t["MigrateVMRequestType"] = reflect.TypeOf((*MigrateVMRequestType)(nil)).Elem()
}

type MigrateVM_Task MigrateVMRequestType

func init() {
	t["MigrateVM_Task"] = reflect.TypeOf((*MigrateVM_Task)(nil)).Elem()
}

type MigrateVM_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval"`
}

type MigrationDisabled struct {
	MigrationFault
}

func init() {
	t["MigrationDisabled"] = reflect.TypeOf((*MigrationDisabled)(nil)).Elem()
}

type MigrationDisabledFault MigrationDisabled

func init() {
	t["MigrationDisabledFault"] = reflect.TypeOf((*MigrationDisabledFault)(nil)).Elem()
}

type MigrationErrorEvent struct {
	MigrationEvent
}

func init() {
	t["MigrationErrorEvent"] = reflect.TypeOf((*MigrationErrorEvent)(nil)).Elem()
}

type MigrationEvent struct {
	VmEvent

	Fault LocalizedMethodFault `xml:"fault"`
}

func init() {
	t["MigrationEvent"] = reflect.TypeOf((*MigrationEvent)(nil)).Elem()
}

type MigrationFault struct {
	VimFault
}

func init() {
	t["MigrationFault"] = reflect.TypeOf((*MigrationFault)(nil)).Elem()
}

type MigrationFaultFault BaseMigrationFault

func init() {
	t["MigrationFaultFault"] = reflect.TypeOf((*MigrationFaultFault)(nil)).Elem()
}

type MigrationFeatureNotSupported struct {
	MigrationFault

	AtSourceHost   bool                   `xml:"atSourceHost"`
	FailedHostName string                 `xml:"failedHostName"`
	FailedHost     ManagedObjectReference `xml:"failedHost"`
}

func init() {
	t["MigrationFeatureNotSupported"] = reflect.TypeOf((*MigrationFeatureNotSupported)(nil)).Elem()
}

type MigrationFeatureNotSupportedFault BaseMigrationFeatureNotSupported

func init() {
	t["MigrationFeatureNotSupportedFault"] = reflect.TypeOf((*MigrationFeatureNotSupportedFault)(nil)).Elem()
}

type MigrationHostErrorEvent struct {
	MigrationEvent

	DstHost HostEventArgument `xml:"dstHost"`
}

func init() {
	t["MigrationHostErrorEvent"] = reflect.TypeOf((*MigrationHostErrorEvent)(nil)).Elem()
}

type MigrationHostWarningEvent struct {
	MigrationEvent

	DstHost HostEventArgument `xml:"dstHost"`
}

func init() {
	t["MigrationHostWarningEvent"] = reflect.TypeOf((*MigrationHostWarningEvent)(nil)).Elem()
}

type MigrationNotReady struct {
	MigrationFault

	Reason string `xml:"reason"`
}

func init() {
	t["MigrationNotReady"] = reflect.TypeOf((*MigrationNotReady)(nil)).Elem()
}

type MigrationNotReadyFault MigrationNotReady

func init() {
	t["MigrationNotReadyFault"] = reflect.TypeOf((*MigrationNotReadyFault)(nil)).Elem()
}

type MigrationResourceErrorEvent struct {
	MigrationEvent

	DstPool ResourcePoolEventArgument `xml:"dstPool"`
	DstHost HostEventArgument         `xml:"dstHost"`
}

func init() {
	t["MigrationResourceErrorEvent"] = reflect.TypeOf((*MigrationResourceErrorEvent)(nil)).Elem()
}

type MigrationResourceWarningEvent struct {
	MigrationEvent

	DstPool ResourcePoolEventArgument `xml:"dstPool"`
	DstHost HostEventArgument         `xml:"dstHost"`
}

func init() {
	t["MigrationResourceWarningEvent"] = reflect.TypeOf((*MigrationResourceWarningEvent)(nil)).Elem()
}

type MigrationWarningEvent struct {
	MigrationEvent
}

func init() {
	t["MigrationWarningEvent"] = reflect.TypeOf((*MigrationWarningEvent)(nil)).Elem()
}

type MismatchedBundle struct {
	VimFault

	BundleUuid        string `xml:"bundleUuid"`
	HostUuid          string `xml:"hostUuid"`
	BundleBuildNumber int32  `xml:"bundleBuildNumber"`
	HostBuildNumber   int32  `xml:"hostBuildNumber"`
}

func init() {
	t["MismatchedBundle"] = reflect.TypeOf((*MismatchedBundle)(nil)).Elem()
}

type MismatchedBundleFault MismatchedBundle

func init() {
	t["MismatchedBundleFault"] = reflect.TypeOf((*MismatchedBundleFault)(nil)).Elem()
}

type MismatchedNetworkPolicies struct {
	MigrationFault

	Device    string `xml:"device"`
	Backing   string `xml:"backing"`
	Connected bool   `xml:"connected"`
}

func init() {
	t["MismatchedNetworkPolicies"] = reflect.TypeOf((*MismatchedNetworkPolicies)(nil)).Elem()
}

type MismatchedNetworkPoliciesFault MismatchedNetworkPolicies

func init() {
	t["MismatchedNetworkPoliciesFault"] = reflect.TypeOf((*MismatchedNetworkPoliciesFault)(nil)).Elem()
}

type MismatchedVMotionNetworkNames struct {
	MigrationFault

	SourceNetwork string `xml:"sourceNetwork"`
	DestNetwork   string `xml:"destNetwork"`
}

func init() {
	t["MismatchedVMotionNetworkNames"] = reflect.TypeOf((*MismatchedVMotionNetworkNames)(nil)).Elem()
}

type MismatchedVMotionNetworkNamesFault MismatchedVMotionNetworkNames

func init() {
	t["MismatchedVMotionNetworkNamesFault"] = reflect.TypeOf((*MismatchedVMotionNetworkNamesFault)(nil)).Elem()
}

type MissingBmcSupport struct {
	VimFault
}

func init() {
	t["MissingBmcSupport"] = reflect.TypeOf((*MissingBmcSupport)(nil)).Elem()
}

type MissingBmcSupportFault MissingBmcSupport

func init() {
	t["MissingBmcSupportFault"] = reflect.TypeOf((*MissingBmcSupportFault)(nil)).Elem()
}

type MissingController struct {
	InvalidDeviceSpec
}

func init() {
	t["MissingController"] = reflect.TypeOf((*MissingController)(nil)).Elem()
}

type MissingControllerFault MissingController

func init() {
	t["MissingControllerFault"] = reflect.TypeOf((*MissingControllerFault)(nil)).Elem()
}

type MissingIpPool struct {
	VAppPropertyFault
}

func init() {
	t["MissingIpPool"] = reflect.TypeOf((*MissingIpPool)(nil)).Elem()
}

type MissingIpPoolFault MissingIpPool

func init() {
	t["MissingIpPoolFault"] = reflect.TypeOf((*MissingIpPoolFault)(nil)).Elem()
}

type MissingLinuxCustResources struct {
	CustomizationFault
}

func init() {
	t["MissingLinuxCustResources"] = reflect.TypeOf((*MissingLinuxCustResources)(nil)).Elem()
}

type MissingLinuxCustResourcesFault MissingLinuxCustResources

func init() {
	t["MissingLinuxCustResourcesFault"] = reflect.TypeOf((*MissingLinuxCustResourcesFault)(nil)).Elem()
}

type MissingNetworkIpConfig struct {
	VAppPropertyFault
}

func init() {
	t["MissingNetworkIpConfig"] = reflect.TypeOf((*MissingNetworkIpConfig)(nil)).Elem()
}

type MissingNetworkIpConfigFault MissingNetworkIpConfig

func init() {
	t["MissingNetworkIpConfigFault"] = reflect.TypeOf((*MissingNetworkIpConfigFault)(nil)).Elem()
}

type MissingObject struct {
	DynamicData

	Obj   ManagedObjectReference `xml:"obj"`
	Fault LocalizedMethodFault   `xml:"fault"`
}

func init() {
	t["MissingObject"] = reflect.TypeOf((*MissingObject)(nil)).Elem()
}

type MissingPowerOffConfiguration struct {
	VAppConfigFault
}

func init() {
	t["MissingPowerOffConfiguration"] = reflect.TypeOf((*MissingPowerOffConfiguration)(nil)).Elem()
}

type MissingPowerOffConfigurationFault MissingPowerOffConfiguration

func init() {
	t["MissingPowerOffConfigurationFault"] = reflect.TypeOf((*MissingPowerOffConfigurationFault)(nil)).Elem()
}

type MissingPowerOnConfiguration struct {
	VAppConfigFault
}

func init() {
	t["MissingPowerOnConfiguration"] = reflect.TypeOf((*MissingPowerOnConfiguration)(nil)).Elem()
}

type MissingPowerOnConfigurationFault MissingPowerOnConfiguration

func init() {
	t["MissingPowerOnConfigurationFault"] = reflect.TypeOf((*MissingPowerOnConfigurationFault)(nil)).Elem()
}

type MissingProperty struct {
	DynamicData

	Path  string               `xml:"path"`
	Fault LocalizedMethodFault `xml:"fault"`
}

func init() {
	t["MissingProperty"] = reflect.TypeOf((*MissingProperty)(nil)).Elem()
}

type MissingWindowsCustResources struct {
	CustomizationFault
}

func init() {
	t["MissingWindowsCustResources"] = reflect.TypeOf((*MissingWindowsCustResources)(nil)).Elem()
}

type MissingWindowsCustResourcesFault MissingWindowsCustResources

func init() {
	t["MissingWindowsCustResourcesFault"] = reflect.TypeOf((*MissingWindowsCustResourcesFault)(nil)).Elem()
}

type MksConnectionLimitReached struct {
	InvalidState

	ConnectionLimit int32 `xml:"connectionLimit"`
}

func init() {
	t["MksConnectionLimitReached"] = reflect.TypeOf((*MksConnectionLimitReached)(nil)).Elem()
}

type MksConnectionLimitReachedFault MksConnectionLimitReached

func init() {
	t["MksConnectionLimitReachedFault"] = reflect.TypeOf((*MksConnectionLimitReachedFault)(nil)).Elem()
}

type ModeInfo struct {
	DynamicData

	Browse string `xml:"browse,omitempty"`
	Read   string `xml:"read"`
	Modify string `xml:"modify"`
	Use    string `xml:"use"`
	Admin  string `xml:"admin,omitempty"`
	Full   string `xml:"full"`
}

func init() {
	t["ModeInfo"] = reflect.TypeOf((*ModeInfo)(nil)).Elem()
}

type ModifyListView ModifyListViewRequestType

func init() {
	t["ModifyListView"] = reflect.TypeOf((*ModifyListView)(nil)).Elem()
}

type ModifyListViewRequestType struct {
	This   ManagedObjectReference   `xml:"_this"`
	Add    []ManagedObjectReference `xml:"add,omitempty"`
	Remove []ManagedObjectReference `xml:"remove,omitempty"`
}

func init() {
	t["ModifyListViewRequestType"] = reflect.TypeOf((*ModifyListViewRequestType)(nil)).Elem()
}

type ModifyListViewResponse struct {
	Returnval []ManagedObjectReference `xml:"returnval,omitempty"`
}

type MonthlyByDayTaskScheduler struct {
	MonthlyTaskScheduler

	Day int32 `xml:"day"`
}

func init() {
	t["MonthlyByDayTaskScheduler"] = reflect.TypeOf((*MonthlyByDayTaskScheduler)(nil)).Elem()
}

type MonthlyByWeekdayTaskScheduler struct {
	MonthlyTaskScheduler

	Offset  WeekOfMonth `xml:"offset"`
	Weekday DayOfWeek   `xml:"weekday"`
}

func init() {
	t["MonthlyByWeekdayTaskScheduler"] = reflect.TypeOf((*MonthlyByWeekdayTaskScheduler)(nil)).Elem()
}

type MonthlyTaskScheduler struct {
	DailyTaskScheduler
}

func init() {
	t["MonthlyTaskScheduler"] = reflect.TypeOf((*MonthlyTaskScheduler)(nil)).Elem()
}

type MountError struct {
	CustomizationFault

	Vm        ManagedObjectReference `xml:"vm"`
	DiskIndex int32                  `xml:"diskIndex"`
}

func init() {
	t["MountError"] = reflect.TypeOf((*MountError)(nil)).Elem()
}

type MountErrorFault MountError

func init() {
	t["MountErrorFault"] = reflect.TypeOf((*MountErrorFault)(nil)).Elem()
}

type MountToolsInstaller MountToolsInstallerRequestType

func init() {
	t["MountToolsInstaller"] = reflect.TypeOf((*MountToolsInstaller)(nil)).Elem()
}

type MountToolsInstallerRequestType struct {
	This ManagedObjectReference `xml:"_this"`
}

func init() {
	t["MountToolsInstallerRequestType"] = reflect.TypeOf((*MountToolsInstallerRequestType)(nil)).Elem()
}

type MountToolsInstallerResponse struct {
}

type MountVffsVolume MountVffsVolumeRequestType

func init() {
	t["MountVffsVolume"] = reflect.TypeOf((*MountVffsVolume)(nil)).Elem()
}

type MountVffsVolumeRequestType struct {
	This     ManagedObjectReference `xml:"_this"`
	VffsUuid string                 `xml:"vffsUuid"`
}

func init() {
	t["MountVffsVolumeRequestType"] = reflect.TypeOf((*MountVffsVolumeRequestType)(nil)).Elem()
}

type MountVffsVolumeResponse struct {
}

type MountVmfsVolume MountVmfsVolumeRequestType

func init() {
	t["MountVmfsVolume"] = reflect.TypeOf((*MountVmfsVolume)(nil)).Elem()
}

type MountVmfsVolumeExRequestType struct {
	This     ManagedObjectReference `xml:"_this"`
	VmfsUuid []string               `xml:"vmfsUuid"`
}

func init() {
	t["MountVmfsVolumeExRequestType"] = reflect.TypeOf((*MountVmfsVolumeExRequestType)(nil)).Elem()
}

type MountVmfsVolumeEx_Task MountVmfsVolumeExRequestType

func init() {
	t["MountVmfsVolumeEx_Task"] = reflect.TypeOf((*MountVmfsVolumeEx_Task)(nil)).Elem()
}

type MountVmfsVolumeEx_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval"`
}

type MountVmfsVolumeRequestType struct {
	This     ManagedObjectReference `xml:"_this"`
	VmfsUuid string                 `xml:"vmfsUuid"`
}

func init() {
	t["MountVmfsVolumeRequestType"] = reflect.TypeOf((*MountVmfsVolumeRequestType)(nil)).Elem()
}

type MountVmfsVolumeResponse struct {
}

type MoveDVPortRequestType struct {
	This                    ManagedObjectReference `xml:"_this"`
	PortKey                 []string               `xml:"portKey"`
	DestinationPortgroupKey string                 `xml:"destinationPortgroupKey,omitempty"`
}

func init() {
	t["MoveDVPortRequestType"] = reflect.TypeOf((*MoveDVPortRequestType)(nil)).Elem()
}

type MoveDVPort_Task MoveDVPortRequestType

func init() {
	t["MoveDVPort_Task"] = reflect.TypeOf((*MoveDVPort_Task)(nil)).Elem()
}

type MoveDVPort_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval"`
}

type MoveDatastoreFileRequestType struct {
	This                  ManagedObjectReference  `xml:"_this"`
	SourceName            string                  `xml:"sourceName"`
	SourceDatacenter      *ManagedObjectReference `xml:"sourceDatacenter,omitempty"`
	DestinationName       string                  `xml:"destinationName"`
	DestinationDatacenter *ManagedObjectReference `xml:"destinationDatacenter,omitempty"`
	Force                 *bool                   `xml:"force"`
}

func init() {
	t["MoveDatastoreFileRequestType"] = reflect.TypeOf((*MoveDatastoreFileRequestType)(nil)).Elem()
}

type MoveDatastoreFile_Task MoveDatastoreFileRequestType

func init() {
	t["MoveDatastoreFile_Task"] = reflect.TypeOf((*MoveDatastoreFile_Task)(nil)).Elem()
}

type MoveDatastoreFile_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval"`
}

type MoveDirectoryInGuest MoveDirectoryInGuestRequestType

func init() {
	t["MoveDirectoryInGuest"] = reflect.TypeOf((*MoveDirectoryInGuest)(nil)).Elem()
}

type MoveDirectoryInGuestRequestType struct {
	This             ManagedObjectReference  `xml:"_this"`
	Vm               ManagedObjectReference  `xml:"vm"`
	Auth             BaseGuestAuthentication `xml:"auth,typeattr"`
	SrcDirectoryPath string                  `xml:"srcDirectoryPath"`
	DstDirectoryPath string                  `xml:"dstDirectoryPath"`
}

func init() {
	t["MoveDirectoryInGuestRequestType"] = reflect.TypeOf((*MoveDirectoryInGuestRequestType)(nil)).Elem()
}

type MoveDirectoryInGuestResponse struct {
}

type MoveFileInGuest MoveFileInGuestRequestType

func init() {
	t["MoveFileInGuest"] = reflect.TypeOf((*MoveFileInGuest)(nil)).Elem()
}

type MoveFileInGuestRequestType struct {
	This        ManagedObjectReference  `xml:"_this"`
	Vm          ManagedObjectReference  `xml:"vm"`
	Auth        BaseGuestAuthentication `xml:"auth,typeattr"`
	SrcFilePath string                  `xml:"srcFilePath"`
	DstFilePath string                  `xml:"dstFilePath"`
	Overwrite   bool                    `xml:"overwrite"`
}

func init() {
	t["MoveFileInGuestRequestType"] = reflect.TypeOf((*MoveFileInGuestRequestType)(nil)).Elem()
}

type MoveFileInGuestResponse struct {
}

type MoveHostIntoRequestType struct {
	This         ManagedObjectReference  `xml:"_this"`
	Host         ManagedObjectReference  `xml:"host"`
	ResourcePool *ManagedObjectReference `xml:"resourcePool,omitempty"`
}

func init() {
	t["MoveHostIntoRequestType"] = reflect.TypeOf((*MoveHostIntoRequestType)(nil)).Elem()
}

type MoveHostInto_Task MoveHostIntoRequestType

func init() {
	t["MoveHostInto_Task"] = reflect.TypeOf((*MoveHostInto_Task)(nil)).Elem()
}

type MoveHostInto_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval"`
}

type MoveIntoFolderRequestType struct {
	This ManagedObjectReference   `xml:"_this"`
	List []ManagedObjectReference `xml:"list"`
}

func init() {
	t["MoveIntoFolderRequestType"] = reflect.TypeOf((*MoveIntoFolderRequestType)(nil)).Elem()
}

type MoveIntoFolder_Task MoveIntoFolderRequestType

func init() {
	t["MoveIntoFolder_Task"] = reflect.TypeOf((*MoveIntoFolder_Task)(nil)).Elem()
}

type MoveIntoFolder_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval"`
}

type MoveIntoRequestType struct {
	This ManagedObjectReference   `xml:"_this"`
	Host []ManagedObjectReference `xml:"host"`
}

func init() {
	t["MoveIntoRequestType"] = reflect.TypeOf((*MoveIntoRequestType)(nil)).Elem()
}

type MoveIntoResourcePool MoveIntoResourcePoolRequestType

func init() {
	t["MoveIntoResourcePool"] = reflect.TypeOf((*MoveIntoResourcePool)(nil)).Elem()
}

type MoveIntoResourcePoolRequestType struct {
	This ManagedObjectReference   `xml:"_this"`
	List []ManagedObjectReference `xml:"list"`
}

func init() {
	t["MoveIntoResourcePoolRequestType"] = reflect.TypeOf((*MoveIntoResourcePoolRequestType)(nil)).Elem()
}

type MoveIntoResourcePoolResponse struct {
}

type MoveInto_Task MoveIntoRequestType

func init() {
	t["MoveInto_Task"] = reflect.TypeOf((*MoveInto_Task)(nil)).Elem()
}

type MoveInto_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval"`
}

type MoveVirtualDiskRequestType struct {
	This             ManagedObjectReference          `xml:"_this"`
	SourceName       string                          `xml:"sourceName"`
	SourceDatacenter *ManagedObjectReference         `xml:"sourceDatacenter,omitempty"`
	DestName         string                          `xml:"destName"`
	DestDatacenter   *ManagedObjectReference         `xml:"destDatacenter,omitempty"`
	Force            *bool                           `xml:"force"`
	Profile          []BaseVirtualMachineProfileSpec `xml:"profile,omitempty,typeattr"`
}

func init() {
	t["MoveVirtualDiskRequestType"] = reflect.TypeOf((*MoveVirtualDiskRequestType)(nil)).Elem()
}

type MoveVirtualDisk_Task MoveVirtualDiskRequestType

func init() {
	t["MoveVirtualDisk_Task"] = reflect.TypeOf((*MoveVirtualDisk_Task)(nil)).Elem()
}

type MoveVirtualDisk_TaskResponse struct {
	Returnval ManagedObjectReference `xml:"returnval"`
}

type MtuMatchEvent struct {
	DvsHealthStatusChangeEvent
}

func init() {
	t["MtuMatchEvent"] = reflect.TypeOf((*MtuMatchEvent)(nil)).Elem()
}

type MtuMismatchEvent struct {
	DvsHealthStatusChangeEvent
}

func init() {
	t["MtuMismatchEvent"] = reflect.TypeOf((*MtuMismatchEvent)(nil)).Elem()
}

type MultiWriterNotSupported struct {
	DeviceNotSupported
}

func init() {
	t["MultiWriterNotSupported"] = reflect.TypeOf((*MultiWriterNotSupported)(nil)).Elem()
}

type MultiWriterNotSupportedFault MultiWriterNotSupported

func init() {
	t["MultiWriterNotSupportedFault"] = reflect.TypeOf((*MultiWriterNotSupportedFault)(nil)).Elem()
}

type MultipleCertificatesVerifyFault struct {
	HostConnectFault

	ThumbprintData []MultipleCertificatesVerifyFaultThumbprintData `xml:"thumbprintData"`
}

func init() {
	t["MultipleCertificatesVerifyFault"] = reflect.TypeOf((*MultipleCertificatesVerifyFault)(nil)).Elem()
}

type MultipleCertificatesVerifyFaultFault MultipleCertificatesVerifyFault

func init() {
	t["MultipleCertificatesVerifyFaultFault"] = reflect.TypeOf((*MultipleCertificatesVerifyFaultFault)(nil)).Elem()
}

type MultipleCertificatesVerifyFaultThumbprintData struct {
	DynamicData

	Port       int32  `xml:"port"`
	Thumbprint string `xml:"thumbprint"`
}

func init() {
	t["MultipleCertificatesVerifyFaultThumbprintData"] = reflect.TypeOf((*MultipleCertificatesVerifyFaultThumbprintData)(nil)).Elem()
}

type MultipleSnapshotsNotSupported struct {
	SnapshotFault
}

func init() {
	t["MultipleSnapshotsNotSupported"] = reflect.TypeOf((*MultipleSnapshotsNotSupported)(nil)).Elem()
}

type MultipleSnapshotsNotSupportedFault MultipleSnapshotsNotSupported

func init() {
	t["MultipleSnapshotsNotSupportedFault"] = reflect.TypeOf((*MultipleSnapshotsNotSupportedFault)(nil)).Elem()
}

type NASDatastoreCreatedEvent struct {
	HostEvent

	Datastore    DatastoreEventArgument `xml:"datastore"`
	DatastoreUrl string                 `xml:"datastoreUrl,omitempty"`
}

func init() {
	t["NASDatastoreCreatedEvent"] = reflect.TypeOf((*NASDatastoreCreatedEvent)(nil)).Elem()
}

type NamePasswordAuthentication struct {
	GuestAuthentication

	Username string `xml:"username"`
	Password string `xml:"password"`
}

func init() {
	t["NamePasswordAuthentication"] = reflect.TypeOf((*NamePasswordAuthentication)(nil)).Elem()
}

type NamespaceFull struct {
	VimFault

	Name           string `xml:"name"`
	CurrentMaxSize int64  `xml:"currentMaxSize"`
	RequiredSize   int64  `xml:"requiredSize,omitempty"`
}

func init() {
	t["NamespaceFull"] = reflect.TypeOf((*NamespaceFull)(nil)).Elem()
}

type NamespaceFullFault NamespaceFull

func init() {
	t["NamespaceFullFault"] = reflect.TypeOf((*NamespaceFullFault)(nil)).Elem()
}

type NamespaceLimitReached struct {
	VimFault

	Limit *int32 `xml:"limit"`
}

func init() {
	t["NamespaceLimitReached"] = reflect.TypeOf((*NamespaceLimitReached)(nil)).Elem()
}

type NamespaceLimitReachedFault NamespaceLimitReached

func init() {
	t["NamespaceLimitReachedFault"] = reflect.TypeOf((*NamespaceLimitReachedFault)(nil)).Elem()
}

type NamespaceWriteProtected struct {
	VimFault

	Name string `xml:"name"`
}

func init() {
	t["NamespaceWriteProtected"] = reflect.TypeOf((*NamespaceWriteProtected)(nil)).Elem()
}

type NamespaceWriteProtectedFault NamespaceWriteProtected

func init() {
	t["NamespaceWriteProtectedFault"] = reflect.TypeOf((*NamespaceWriteProtectedFault)(nil)).Elem()
}

type NasConfigFault struct {
	HostConfigFault

	Name string `xml:"name"`
}

func init() {
	t["NasConfigFault"] = reflect.TypeOf((*NasConfigFault)(nil)).Elem()
}

type NasConfigFaultFault BaseNasConfigFault

func init() {
	t["NasConfigFaultFault"] = reflect.TypeOf((*NasConfigFaultFault)(nil)).Elem()
}

type NasConnectionLimitReached struct {
	NasConfigFault

	RemoteHost string `xml:"remoteHost"`
	RemotePath string `xml:"remotePath"`
}

func init() {
	t["NasConnectionLimitReached"] = reflect.TypeOf((*NasConnectionLimitReached)(nil)).Elem()
}

type NasConnectionLimitReachedFault NasConnectionLimitReached

func init() {
	t["NasConnectionLimitReachedFault"] = reflect.TypeOf((*NasConnectionLimitReachedFault)(nil)).Elem()
}

type NasDatastoreInfo struct {
	DatastoreInfo

	Nas *HostNasVolume `xml:"nas,omitempty"`
}

func init() {
	t["NasDatastoreInfo"] = reflect.TypeOf((*NasDatastoreInfo)(nil)).Elem()
}

type NasSessionCredentialConflict struct {
	NasConfigFault

	RemoteHost string `xml:"remoteHost"`
	RemotePath string `xml:"remotePath"`
	UserName   string `xml:"userName"`
}

func init() {
	t["NasSessionCredentialConflict"] = reflect.TypeOf((*NasSessionCredentialConflict)(nil)).Elem()
}

type NasSessionCredentialConflictFault NasSessionCredentialConflict

func init() {
	t["NasSessionCredentialConflictFault"] = reflect.TypeOf((*NasSessionCredentialConflictFault)(nil)).Elem()
}

type NasStorageProfile struct {
	ApplyProfile

	Key string `xml:"key"`
}

func init() {
	t["NasStorageProfile"] = reflect.TypeOf((*NasStorageProfile)(nil)).Elem()
}

type NasVolumeNotMounted struct {
	NasConfigFault

	RemoteHost string `xml:"remoteHost"`
	RemotePath string `xml:"remotePath"`
}

func init() {
	t["NasVolumeNotMounted"] = reflect.TypeOf((*NasVolumeNotMounted)(nil)).Elem()
}

type NasVolumeNotMountedFault NasVolumeNotMounted

func init() {
	t["NasVolumeNotMountedFault"] = reflect.TypeOf((*NasVolumeNotMountedFault)(nil)).Elem()
}

type NegatableExpression struct {
	DynamicData

	Negate *bool `xml:"negate"`
}

func init() {
	t["NegatableExpression"] = reflect.TypeOf((*NegatableExpression)(nil)).Elem()
}

type NetBIOSConfigInfo struct {
	DynamicData

	Mode string `xml:"mode"`
}

func init() {
	t["NetBIOSConfigInfo"] = reflect.TypeOf((*NetBIOSConfigInfo)(nil)).Elem()
}

type NetDhcpConfigInfo struct {
	DynamicData

	Ipv6 *NetDhcpConfigInfoDhcpOptions `xml:"ipv6,omitempty"`
	Ipv4 *NetDhcpConfigInfoDhcpOptions `xml:"ipv4,omitempty"`
}

func init() {
	t["NetDhcpConfigInfo"] = reflect.TypeOf((*NetDhcpConfigInfo)(nil)).Elem()
}

type NetDhcpConfigInfoDhcpOptions struct {
	DynamicData

	Enable bool       `xml:"enable"`
	Config []KeyValue `xml:"config,omitempty"`
}

func init() {
	t["NetDhcpConfigInfoDhcpOptions"] = reflect.TypeOf((*NetDhcpConfigInfoDhcpOptions)(nil)).Elem()
}

type NetDhcpConfigSpec struct {
	DynamicData

	Ipv6 *NetDhcpConfigSpecDhcpOptionsSpec `xml:"ipv6,omitempty"`
	Ipv4 *NetDhcpConfigSpecDhcpOptionsSpec `xml:"ipv4,omitempty"`
}

func init() {
	t["NetDhcpConfigSpec"] = reflect.TypeOf((*NetDhcpConfigSpec)(nil)).Elem()
}

type NetDhcpConfigSpecDhcpOptionsSpec struct {
	DynamicData

	Enable    *bool      `xml:"enable"`
	Config    []KeyValue `xml:"config"`
	Operation string     `xml:"operation"`
}

func init() {
	t["NetDhcpConfigSpecDhcpOptionsSpec"] = reflect.TypeOf((*NetDhcpConfigSpecDhcpOptionsSpec)(nil)).Elem()
}

type NetDnsConfigInfo struct {
	DynamicData

	Dhcp         bool     `xml:"dhcp"`
	HostName     string   `xml:"hostName"`
	DomainName   string   `xml:"domainName"`
	IpAddress    []string `xml:"ipAddress,omitempty"`
	SearchDomain []string `xml:"searchDomain,omitempty"`
}

func init() {
	t["NetDnsConfigInfo"] = reflect.TypeOf((*NetDnsConfigInfo)(nil)).Elem()
}

type NetDnsConfigSpec struct {
	DynamicData

	Dhcp         *bool    `xml:"dhcp"`
	HostName     string   `xml:"hostName,omitempty"`
	DomainName   string   `xml:"domainName,omitempty"`
	IpAddress    []string `xml:"ipAddress,omitempty"`
	SearchDomain []string `xml:"searchDomain,omitempty"`
}

func init() {
	t["NetDnsConfigSpec"] = reflect.TypeOf((*NetDnsConfigSpec)(nil)).Elem()
}

type NetIpConfigInfo struct {
	DynamicData

	IpAddress                []NetIpConfigInfoIpAddress `xml:"ipAddress,omitempty"`
	Dhcp                     *NetDhcpConfigInfo         `xml:"dhcp,omitempty"`
	AutoConfigurationEnabled *bool                      `xml:"autoConfigurationEnabled"`
}

func init() {
	t["NetIpConfigInfo"] = reflect.TypeOf((*NetIpConfigInfo)(nil)).Elem()
}

type NetIpConfigInfoIpAddress struct {
	DynamicData

	IpAddress    string     `xml:"ipAddress"`
	PrefixLength int32      `xml:"prefixLength"`
	Origin       string     `xml:"origin,omitempty"`
	State        string     `xml:"state,omitempty"`
	Lifetime     *time.Time `xml:"lifetime"`
}

func init() {
	t["NetIpConfigInfoIpAddress"] = reflect.TypeOf((*NetIpConfigInfoIpAddress)(nil)).Elem()
}

type NetIpConfigSpec struct {
	DynamicData

	IpAddress                []NetIpConfigSpecIpAddressSpec `xml:"ipAddress,omitempty"`
	Dhcp                     *NetDhcpConfigSpec             `xml:"dhcp,omitempty"`
	AutoConfigurationEnabled *bool                          `xml:"autoConfigurationEnabled"`
}

func init() {
	t["NetIpConfigSpec"] = reflect.TypeOf((*NetIpConfigSpec)(nil)).Elem()
}

type NetIpConfigSpecIpAddressSpec struct {
	DynamicData

	IpAddress    string `xml:"ipAddress"`
	PrefixLength int32  `xml:"prefixLength"`
	Operation    string `xml:"operation"`
}

func init() {
	t["NetIpConfigSpecIpAddressSpec"] = reflect.TypeOf((*NetIpConfigSpecIpAddressSpec)(nil)).Elem()
}

type NetIpRouteConfigInfo struct {
	DynamicData

	IpRoute []NetIpRouteConfigInfoIpRoute `xml:"ipRoute,omitempty"`
}

func init() {
	t["NetIpRouteConfigInfo"] = reflect.TypeOf((*NetIpRouteConfigInfo)(nil)).Elem()
}

type NetIpRouteConfigInfoGateway struct {
	DynamicData

	IpAddress string `xml:"ipAddress,omitempty"`
	Device    string `xml:"device,omitempty"`
}

func init() {
	t["NetIpRouteConfigInfoGateway"] = reflect.TypeOf((*NetIpRouteConfigInfoGateway)(nil)).Elem()
}

type NetIpRouteConfigInfoIpRoute struct {
	DynamicData

	Network      string                      `xml:"network"`
	PrefixLength int32                       `xml:"prefixLength"`
	Gateway      NetIpRouteConfigInfoGateway `xml:"gateway"`
}

func init() {
	t["NetIpRouteConfigInfoIpRoute"] = reflect.TypeOf((*NetIpRouteConfigInfoIpRoute)(nil)).Elem()
}

type NetIpRouteConfigSpec struct {
	DynamicData

	IpRoute []NetIpRouteConfigSpecIpRouteSpec `xml:"ipRoute,omitempty"`
}

func init() {
	t["NetIpRouteConfigSpec"] = reflect.TypeOf((*NetIpRouteConfigSpec)(nil)).Elem()
}

type NetIpRouteConfigSpecGatewaySpec struct {
	DynamicData

	IpAddress string `xml:"ipAddress,omitempty"`
	Device    string `xml:"device,omitempty"`
}

func init() {
	t["NetIpRouteConfigSpecGatewaySpec"] = reflect.TypeOf((*NetIpRouteConfigSpecGatewaySpec)(nil)).Elem()
}

type NetIpRouteConfigSpecIpRouteSpec struct {
	DynamicData

	Network      string                          `xml:"network"`
	PrefixLength int32                           `xml:"prefixLength"`
	Gateway      NetIpRouteConfigSpecGatewaySpec `xml:"gateway"`
	Operation    string                          `xml:"operation"`
}

func init() {
	t["NetIpRouteConfigSpecIpRouteSpec"] = reflect.TypeOf((*NetIpRouteConfigSpecIpRouteSpec)(nil)).Elem()
}

type NetIpStackInfo struct {
	DynamicData

	Neighbor      []NetIpStackInfoNetToMedia    `xml:"neighbor,omitempty"`
	DefaultRouter []NetIpStackInfoDefaultRouter `xml:"defaultRouter,omitempty"`
}

func init() {
	t["NetIpStackInfo"] = reflect.TypeOf((*NetIpStackInfo)(nil)).Elem()
}

type NetIpStackInfoDefaultRouter struct {
	DynamicData

	IpAddress  string    `xml:"ipAddress"`
	Device     string    `xml:"device"`
	Lifetime   time.Time `xml:"lifetime"`
	Preference string    `xml:"preference"`
}

func init() {
	t["NetIpStackInfoDefaultRouter"] = reflect.TypeOf((*NetIpStackInfoDefaultRouter)(nil)).Elem()
}

type NetIpStackInfoNetToMedia struct {
	DynamicData

	IpAddress       string `xml:"ipAddress"`
	PhysicalAddress string `xml:"physicalAddress"`
	Device          string `xml:"device"`
	Type            string `xml:"type"`
}

func init() {
	t["NetIpStackInfoNetToMedia"] = reflect.TypeOf((*NetIpStackInfoNetToMedia)(nil)).Elem()
}

type NetStackInstanceProfile struct {
	ApplyProfile

	Key           string                         `xml:"key"`
	DnsConfig     NetworkProfileDnsConfigProfile `xml:"dnsConfig"`
	IpRouteConfig IpRouteProfile                 `xml:"ipRouteConfig"`
}

func init() {
	t["NetStackInstanceProfile"] = reflect.TypeOf((*NetStackInstanceProfile)(nil)).Elem()
}

type NetworkCopyFault struct {
	FileFault
}

func init() {
	t["NetworkCopyFault"] = reflect.TypeOf((*NetworkCopyFault)(nil)).Elem()
}

type NetworkCopyFaultFault NetworkCopyFault

func init() {
	t["NetworkCopyFaultFault"] = reflect.TypeOf((*NetworkCopyFaultFault)(nil)).Elem()
}

type NetworkDisruptedAndConfigRolledBack struct {
	VimFault

	Host string `xml:"host"`
}

func init() {
	t["NetworkDisruptedAndConfigRolledBack"] = reflect.TypeOf((*NetworkDisruptedAndConfigRolledBack)(nil)).Elem()
}

type NetworkDisruptedAndConfigRolledBackFault NetworkDisruptedAndConfigRolledBack

func init() {
	t["NetworkDisruptedAndConfigRolledBackFault"] = reflect.TypeOf((*NetworkDisruptedAndConfigRolledBackFault)(nil)).Elem()
}

type NetworkEventArgument struct {
	EntityEventArgument

	Network ManagedObjectReference `xml:"network"`
}

func init() {
	t["NetworkEventArgument"] = reflect.TypeOf((*NetworkEventArgument)(nil)).Elem()
}

type NetworkInaccessible struct {
	NasConfigFault
}

func init() {
	t["NetworkInaccessible"] = reflect.TypeOf((*NetworkInaccessible)(nil)).Elem()
}

type NetworkInaccessibleFault NetworkInaccessible

func init() {
	t["NetworkInaccessibleFault"] = reflect.TypeOf((*NetworkInaccessibleFault)(nil)).Elem()
}

type NetworkPolicyProfile struct {
	ApplyProfile
}

func init() {
	t["NetworkPolicyProfile"] = reflect.TypeOf((*NetworkPolicyProfile)(nil)).Elem()
}

type NetworkProfile struct {
	ApplyProfile

	Vswitch                 []VirtualSwitchProfile           `xml:"vswitch,omitempty"`
	VmPortGroup             []VmPortGroupProfile             `xml:"vmPortGroup,omitempty"`
	HostPortGroup           []HostPortGroupProfile           `xml:"hostPortGroup,omitempty"`
	ServiceConsolePortGroup []ServiceConsolePortGroupProfile `xml:"serviceConsolePortGroup,omitempty"`
	DnsConfig               *NetworkProfileDnsConfigProfile  `xml:"dnsConfig,omitempty"`
	IpRouteConfig           *IpRouteProfile                  `xml:"ipRouteConfig,omitempty"`
	ConsoleIpRouteConfig    *IpRouteProfile                  `xml:"consoleIpRouteConfig,omitempty"`
	Pnic                    []PhysicalNicProfile             `xml:"pnic,omitempty"`
	Dvswitch                []DvsProfile                     `xml:"dvswitch,omitempty"`
	DvsServiceConsoleNic    []DvsServiceConsoleVNicProfile   `xml:"dvsServiceConsoleNic,omitempty"`
	DvsHostNic              []DvsHostVNicProfile             `xml:"dvsHostNic,omitempty"`
	NsxHostNic              []NsxHostVNicProfile             `xml:"nsxHostNic,omitempty"`
	NetStackInstance        []NetStackInstanceProfile        `xml:"netStackInstance,omitempty"`
	OpaqueSwitch            *OpaqueSwitchProfile             `xml:"opaqueSwitch,omitempty"`
}

func init() {
	t["NetworkProfile"] = reflect.TypeOf((*NetworkProfile)(nil)).Elem()
}

type NetworkProfileDnsConfigProfile struct {
	ApplyProfile
}

func init() {
	t["NetworkProfileDnsConfigProfile"] = reflect.TypeOf((*NetworkProfileDnsConfigProfile)(nil)).Elem()
}

type NetworkRollbackEvent struct {
	Event

	MethodName    string `xml:"methodName"`
	TransactionId string `xml:"transactionId"`
}

func init() {
	t["NetworkRollbackEvent"] = reflect.TypeOf((*NetworkRollbackEvent)(nil)).Elem()
}

type NetworkSummary struct {
	DynamicData

	Network    *ManagedObjectReference `xml:"network,omitempty"`
	Name       string                  `xml:"name"`
	Accessible bool                    `xml:"accessible"`
	IpPoolName string                  `xml:"ipPoolName"`
	IpPoolId   *int32                  `xml:"ipPoolId"`
}

func init() {
	t["NetworkSummary"] = reflect.TypeOf((*NetworkSummary)(nil)).Elem()
}

type NetworksMayNotBeTheSame struct {
	MigrationFault

	Name string `xml:"name,omitempty"`
}

func init() {
	t["NetworksMayNotBeTheSame"] = reflect.TypeOf((*NetworksMayNotBeTheSame)(nil)).Elem()
}

type NetworksMayNotBeTheSameFault NetworksMayNotBeTheSame

func init() {
	t["NetworksMayNotBeTheSameFault"] = reflect.TypeOf((*NetworksMayNotBeTheSameFault)(nil)).Elem()
}

type NicSettingMismatch struct {
	CustomizationFault

	NumberOfNicsInSpec int32 `xml:"numberOfNicsInSpec"`
	NumberOfNicsInVM   int32 `xml:"numberOfNicsInVM"`
}

func init() {
	t["NicSettingMismatch"] = reflect.TypeOf((*NicSettingMismatch)(nil)).Elem()
}

type NicSettingMismatchFault NicSettingMismatch

func init() {
	t["NicSettingMismatchFault"] = reflect.TypeOf((*NicSettingMismatchFault)(nil)).Elem()
}

type NoAccessUserEvent struct {
	SessionEvent

	IpAddress string `xml:"ipAddress"`
}

func init() {
	t["NoAccessUserEvent"] = reflect.TypeOf((*NoAccessUserEvent)(nil)).Elem()
}

type NoActiveHostInCluster struct {
	InvalidState

	ComputeResource ManagedObjectReference `xml:"computeResource"`
}

func init() {
	t["NoActiveHostInCluster"] = reflect.TypeOf((*NoActiveHostInCluster)(nil)).Elem()
}

type NoActiveHostInClusterFault NoActiveHostInCluster

func init() {
	t["NoActiveHostInClusterFault"] = reflect.TypeOf((*NoActiveHostInClusterFault)(nil)).Elem()
}

type NoAvailableIp struct {
	VAppPropertyFault

	Network ManagedObjectReference `xml:"network"`
}

func init() {
	t["NoAvailableIp"] = reflect.TypeOf((*NoAvailableIp)(nil)).Elem()
}

type NoAvailableIpFault NoAvailableIp

func init() {
	t["NoAvailableIpFault"] = reflect.TypeOf((*NoAvailableIpFault)(nil)).Elem()
}

type NoClientCertificate struct {
	VimFault
}

func init() {
	t["NoClientCertificate"] = reflect.TypeOf((*NoClientCertificate)(nil)).Elem()
}

type NoClientCertificateFault NoClientCertificate

func init() {
	t["NoClientCertificateFault"] = reflect.TypeOf((*NoClientCertificateFault)(nil)).Elem()
}

type NoCompatibleDatastore struct {
	VimFault
}

func init() {
	t["NoCompatibleDatastore"] = reflect.TypeOf((*NoCompatibleDatastore)(nil)).Elem()
}

type NoCompatibleDatastoreFault NoCompatibleDatastore

func init() {
	t["NoCompatibleDatastoreFault"] = reflect.TypeOf((*NoCompatibleDatastoreFault)(nil)).Elem()
}

type NoCompatibleHardAffinityHost struct {
	VmConfigFault

	VmName string `xml:"vmName"`
}

func init() {
	t["NoCompatibleHardAffinityHost"] = reflect.TypeOf((*NoCompatibleHardAffinityHost)(nil)).Elem()
}

type NoCompatibleHardAffinityHostFault NoCompatibleHardAffinityHost

func init() {
	t["NoCompatibleHardAffinityHostFault"] = reflect.TypeOf((*NoCompatibleHardAffinityHostFault)(nil)).Elem()
}

type NoCompatibleHost struct {
	VimFault

	Host  []ManagedObjectReference `xml:"host,omitempty"`
	Error []LocalizedMethodFault   `xml:"error,omitempty"`
}

func init() {
	t["NoCompatibleHost"] = reflect.TypeOf((*NoCompatibleHost)(nil)).Elem()
}

type NoCompatibleHostFault BaseNoCompatibleHost

func init() {
	t["NoCompatibleHostFault"] = reflect.TypeOf((*NoCompatibleHostFault)(nil)).Elem()
}

type NoCompatibleHostWithAccessToDevice struct {
	NoCompatibleHost
}

func init() {
	t["NoCompatibleHostWithAccessToDevice"] = reflect.TypeOf((*NoCompatibleHostWithAccessToDevice)(nil)).Elem()
}

type NoCompatibleHostWithAccessToDeviceFault NoCompatibleHostWithAccessToDevice

func init() {
	t["NoCompatibleHostWithAccessToDeviceFault"] = reflect.TypeOf((*NoCompatibleHostWithAccessToDeviceFault)(nil)).Elem()
}

type NoCompatibleSoftAffinityHost struct {
	VmConfigFault

	VmName string `xml:"vmName"`
}

func init() {
	t["NoCompatibleSoftAffinityHost"] = reflect.TypeOf((*NoCompatibleSoftAffinityHost)(nil)).Elem()
}

type NoCompatibleSoftAffinityHostFault NoCompatibleSoftAffinityHost

func init() {
	t["NoCompatibleSoftAffinityHostFault"] = reflect.TypeOf((*NoCompatibleSoftAffinityHostFault)(nil)).Elem()
}

type NoConnectedDatastore struct {
	VimFault
}

func init() {
	t["NoConnectedDatastore"] = reflect.TypeOf((*NoConnectedDatastore)(nil)).Elem()
}

type NoConnectedDatastoreFault NoConnectedDatastore

func init() {
	t["NoConnectedDatastoreFault"] = reflect.TypeOf((*NoConnectedDatastoreFault)(nil)).Elem()
}

type NoDatastoresConfiguredEvent struct {
	HostEvent
}

func init() {
	t["NoDatastoresConfiguredEvent"] = reflect.TypeOf((*NoDatastoresConfiguredEvent)(nil)).Elem()
}

type NoDiskFound struct {
	VimFault
}

func init() {
	t["NoDiskFound"] = reflect.TypeOf((*NoDiskFound)(nil)).Elem()
}

type NoDiskFoundFault NoDiskFound

func init() {
	t["NoDiskFoundFault"] = reflect.TypeOf((*NoDiskFoundFault)(nil)).Elem()
}

type NoDiskSpace struct {
	FileFault

	Datastore string `xml:"datastore"`
}

func init() {
	t["NoDiskSpace"] = reflect.TypeOf((*NoDiskSpace)(nil)).Elem()
}

type NoDiskSpaceFault NoDiskSpace

func init() {
	t["NoDiskSpaceFault"] = reflect.TypeOf((*NoDiskSpaceFault)(nil)).Elem()
}

type NoDisksToCustomize struct {
	CustomizationFault
}

func init() {
	t["NoDisksToCustomize"] = reflect.TypeOf((*NoDisksToCustomize)(nil)).Elem()
}

type NoDisksToCustomizeFault NoDisksToCustomize

func init() {
	t["NoDisksToCustomizeFault"] = reflect.TypeOf((*NoDisksToCustomizeFault)(nil)).Elem()
}

type NoGateway struct {
	HostConfigFault
}

func init() {
	t["NoGateway"] = reflect.TypeOf((*NoGateway)(nil)).Elem()
}

type NoGatewayFault NoGateway

func init() {
	t["NoGatewayFault"] = reflect.TypeOf((*NoGatewayFault)(nil)).Elem()
}

type NoGuestHeartbeat struct {
	MigrationFault
}

func init() {
	t["NoGuestHeartbeat"] = reflect.TypeOf((*NoGuestHeartbeat)(nil)).Elem()
}

type NoGuestHeartbeatFault NoGuestHeartbeat

func init() {
	t["NoGuestHeartbeatFault"] = reflect.TypeOf((*NoGuestHeartbeatFault)(nil)).Elem()
}

type NoHost struct {
	HostConnectFault

	Name string `xml:"name,omitempty"`
}

func init() {
	t["NoHost"] = reflect.TypeOf((*NoHost)(nil)).Elem()
}

type NoHostFault NoHost

func init() {
	t["NoHostFault"] = reflect.TypeOf((*NoHostFault)(nil)).Elem()
}

type NoHostSuitableForFtSecondary struct {
	VmFaultToleranceIssue

	Vm     ManagedObjectReference `xml:"vm"`
	VmName string                 `xml:"vmName"`
}

func init() {
	t["NoHostSuitableForFtSecondary"] = reflect.TypeOf((*NoHostSuitableForFtSecondary)(nil)).Elem()
}

type NoHostSuitableForFtSecondaryFault NoHostSuitableForFtSecondary

func init() {
	t["NoHostSuitableForFtSecondaryFault"] = reflect.TypeOf((*NoHostSuitableForFtSecondaryFault)(nil)).Elem()
}

type NoLicenseEvent struct {
	LicenseEvent

	Feature LicenseFeatureInfo `xml:"feature"`
}

func init() {
	t["NoLicenseEvent"] = reflect.TypeOf((*NoLicenseEvent)(nil)).Elem()
}

type NoLicenseServerConfigured struct {
	NotEnoughLicenses
}

func init() {
	t["NoLicenseServerConfigured"] = reflect.TypeOf((*NoLicenseServerConfigured)(nil)).Elem()
}

type NoLicenseServerConfiguredFault NoLicenseServerConfigured

func init() {
	t["NoLicenseServerConfiguredFault"] = reflect.TypeOf((*NoLicenseServerConfiguredFault)(nil)).Elem()
}

type NoMaintenanceModeDrsRecommendationForVM struct {
	VmEvent
}

func init() {
	t["NoMaintenanceModeDrsRecommendationForVM"] = reflect.TypeOf((*NoMaintenanceModeDrsRecommendationForVM)(nil)).Elem()
}

type NoPeerHostFound struct {
	HostPowerOpFailed
}

func init() {
	t["NoPeerHostFound"] = reflect.TypeOf((*NoPeerHostFound)(nil)).Elem()
}

type NoPeerHostFoundFault NoPeerHostFound

func init() {
	t["NoPeerHostFoundFault"] = reflect.TypeOf((*NoPeerHostFoundFault)(nil)).Elem()
}

type NoPermission struct {
	SecurityError

	Object      ManagedObjectReference `xml:"object"`
	PrivilegeId string                 `xml:"privilegeId"`
}

func init() {
	t["NoPermission"] = reflect.TypeOf((*NoPermission)(nil)).Elem()
}

type NoPermissionFault BaseNoPermission

func init() {
	t["NoPermissionFault"] = reflect.TypeOf((*NoPermissionFault)(nil)).Elem()
}

type NoPermissionOnAD struct {
	ActiveDirectoryFault
}

func init() {
	t["NoPermissionOnAD"] = reflect.TypeOf((*NoPermissionOnAD)(nil)).Elem()
}

type NoPermissionOnADFault NoPermissionOnAD

func init() {
	t["NoPermissionOnADFault"] = reflect.TypeOf((*NoPermissionOnADFault)(nil)).Elem()
}

type NoPermissionOnHost struct {
	HostConnectFault
}

func init() {
	t["NoPermissionOnHost"] = reflect.TypeOf((*NoPermissionOnHost)(nil)).Elem()
}

type NoPermissionOnHostFault NoPermissionOnHost

func init() {
	t["NoPermissionOnHostFault"] = reflect.TypeOf((*NoPermissionOnHostFault)(nil)).Elem()
}

type NoPermissionOnNasVolume struct {
	NasConfigFault

	UserName string `xml:"userName,omitempty"`
}

func init() {
	t["NoPermissionOnNasVolume"] = reflect.TypeOf((*NoPermissionOnNasVolume)(nil)).Elem()
}

type NoPermissionOnNasVolumeFault NoPermissionOnNasVolume

func init() {
	t["NoPermissionOnNasVolumeFault"] = reflect.TypeOf((*NoPermissionOnNasVolumeFault)(nil)).Elem()
}

type NoSubjectName struct {
	VimFault
}

func init() {
	t["NoSubjectName"] = reflect.TypeOf((*NoSubjectName)(nil)).Elem()
}

type NoSubjectNameFault NoSubjectName

func init() {
	t["NoSubjectNameFault"] = reflect.TypeOf((*NoSubjectNameFault)(nil)).Elem()
}

type NoVcManagedIpConfigured struct {
	VAppPropertyFault
}

func init() {
	t["NoVcManagedIpConfigured"] = reflect.TypeOf((*NoVcManagedIpConfigured)(nil)).Elem()
}

type NoVcManagedIpConfiguredFault NoVcManagedIpConfigured

func init() {
	t["NoVcManagedIpConfiguredFault"] = reflect.TypeOf((*NoVcManagedIpConfiguredFault)(nil)).Elem()
}

type NoVirtualNic struct {
	HostConfigFault
}

func init() {
	t["NoVirtualNic"] = reflect.TypeOf((*NoVirtualNic)(nil)).Elem()
}

type NoVirtualNicFault NoVirtualNic

func init() {
	t["NoVirtualNicFault"] = reflect.TypeOf((*NoVirtualNicFault)(nil)).Elem()
}

type NoVmInVApp struct {
	VAppConfigFault
}

func init() {
	t["NoVmInVApp"] = reflect.TypeOf((*NoVmInVApp)(nil)).Elem()
}

type NoVmInVAppFault NoVmInVApp

func init() {
	t["NoVmInVAppFault"] = reflect.TypeOf((*NoVmInVAppFault)(nil)).Elem()
}

type NodeDeploymentSpec struct {
	DynamicData

	EsxHost                 *ManagedObjectReference `xml:"esxHost,omitempty"`
	Datastore               *ManagedObjectReference `xml:"datastore,omitempty"`
	PublicNetworkPortGroup  *ManagedObjectReference `xml:"publicNetworkPortGroup,omitempty"`
	ClusterNetworkPortGroup *ManagedObjectReference `xml:"clusterNetworkPortGroup,omitempty"`
	Folder                  ManagedObjectReference  `xml:"folder"`
	ResourcePool            *ManagedObjectReference `xml:"resourcePool,omitempty"`
	ManagementVc            *ServiceLocator         `xml:"managementVc,omitempty"`
	NodeName                string                  `xml:"nodeName"`
	IpSettings              CustomizationIPSettings `xml:"ipSettings"`
}

func init() {
	t["NodeDeploymentSpec"] = reflect.TypeOf((*NodeDeploymentSpec)(nil)).Elem()
}

type NodeNetworkSpec struct {
	DynamicData

	IpSettings CustomizationIPSettings `xml:"ipSettings"`
}

func init() {
	t["NodeNetworkSpec"] = reflect.TypeOf((*NodeNetworkSpec)(nil)).Elem()
}

type NonADUserRequired struct {
	ActiveDirectoryFault
}

func init() {
	t["NonADUserRequired"] = reflect.TypeOf((*NonADUserRequired)(nil)).Elem()
}

type NonADUserRequiredFault NonADUserRequired

func init() {
	t["NonADUserRequiredFault"] = reflect.TypeOf((*NonADUserRequiredFault)(nil)).Elem()
}

type NonHomeRDMVMotionNotSupported struct {
	MigrationFeatureNotSupported

	Device string `xml:"device"`
}

func init() {
	t["NonHomeRDMVMotionNotSupported"] = reflect.TypeOf((*NonHomeRDMVMotionNotSupported)(nil)).Elem()
}

type NonHomeRDMVMotionNotSupportedFault NonHomeRDMVMotionNotSupported

func init() {
	t["NonHomeRDMVMotionNotSupportedFault"] = reflect.TypeOf((*NonHomeRDMVMotionNotSupportedFault)(nil)).Elem()
}

type NonPersistentDisksNotSupported struct {
	DeviceNotSupported
}

func init() {
	t["NonPersistentDisksNotSupported"] = reflect.TypeOf((*NonPersistentDisksNotSupported)(nil)).Elem()
}

type NonPersistentDisksNotSupportedFault NonPersistentDisksNotSupported

func init() {
	t["NonPersistentDisksNotSupportedFault"] = reflect.TypeOf((*NonPersistentDisksNotSupportedFault)(nil)).Elem()
}

type NonVIWorkloadDetectedOnDatastoreEvent struct {
	DatastoreEvent
}

func init() {
	t["NonVIWorkloadDetectedOnDatastoreEvent"] = reflect.TypeOf((*NonVIWorkloadDetectedOnDatastoreEvent)(nil)).Elem()
}

type NonVmwareOuiMacNotSupportedHost struct {
	NotSupportedHost

	HostName string `xml:"hostName"`
}

func init() {
	t["NonVmwareOuiMacNotSupportedHost"] = reflect.TypeOf((*NonVmwareOuiMacNotSupportedHost)(nil)).Elem()
}

type NonVmwareOuiMacNotSupportedHostFault NonVmwareOuiMacNotSupportedHost

func init() {
	t["NonVmwareOuiMacNotSupportedHostFault"] = reflect.TypeOf((*NonVmwareOuiMacNotSupportedHostFault)(nil)).Elem()
}

type NotADirectory struct {
	FileFault
}

func init() {
	t["NotADirectory"] = reflect.TypeOf((*NotADirectory)(nil)).Elem()
}

type NotADirectoryFault NotADirectory

func init() {
	t["NotADirectoryFault"] = reflect.TypeOf((*NotADirectoryFault)(nil)).Elem()
}

type NotAFile struct {
	FileFault
}

func init() {
	t["NotAFile"] = reflect.TypeOf((*NotAFile)(nil)).Elem()
}

type NotAFileFault NotAFile

func init() {
	t["NotAFileFault"] = reflect.TypeOf((*NotAFileFault)(nil)).Elem()
}

type NotAuthenticated struct {
	NoPermission
}

func init() {
	t["NotAuthenticated"] = reflect.TypeOf((*NotAuthenticated)(nil)).Elem()
}

type NotAuthenticatedFault NotAuthenticated

func init() {
	t["NotAuthenticatedFault"] = reflect.TypeOf((*NotAuthenticatedFault)(nil)).Elem()
}

type NotEnoughCpus struct {
	VirtualHardwareCompatibilityIssue

	NumCpuDest int32 `xml:"numCpuDest"`
	NumCpuVm   int32 `xml:"numCpuVm"`
}

func init() {
	t["NotEnoughCpus"] = reflect.TypeOf((*NotEnoughCpus)(nil)).Elem()
}

type NotEnoughCpusFault BaseNotEnoughCpus

func init() {
	t["NotEnoughCpusFault"] = reflect.TypeOf((*NotEnoughCpusFault)(nil)).Elem()
}

type NotEnoughLicenses struct {
	RuntimeFault
}

func init() {
	t["NotEnoughLicenses"] = reflect.TypeOf((*NotEnoughLicenses)(nil)).Elem()
}

type NotEnoughLicensesFault BaseNotEno