## TFSA-2021-082: Division by zero in TFLite's convolution code

### CVE Number
CVE-2021-29594

### Impact
TFLite's [convolution
code](https://github.com/tensorflow/tensorflow/blob/09c73bca7d648e961dd05898292d91a8322a9d45/tensorflow/lite/kernels/conv.cc)
has multiple division where the divisor is controlled by the user and not
checked to be non-zero. For example:

```cc
const int input_size = NumElements(input) / SizeOfDimension(input, 0);
```

### Patches
We have patched the issue in GitHub commit
[ff489d95a9006be080ad14feb378f2b4dac35552](https://github.com/tensorflow/tensorflow/commit/ff489d95a9006be080ad14feb378f2b4dac35552).

The fix will be included in TensorFlow 2.5.0. We will also cherrypick this
commit on TensorFlow 2.4.2, TensorFlow 2.3.3, TensorFlow 2.2.3 and TensorFlow
2.1.4, as these are also affected and still in supported range.

### For more information
Please consult [our security
guide](https://github.com/tensorflow/tensorflow/blob/master/SECURITY.md) for
more information regarding the security model and how to contact us with issues
and questions.

### Attribution
This vulnerability has been reported by members of the Aivul Team from Qihoo
360.
