/*
 * Decompiled with CFR 0.152.
 */
package org.piccolo2d.extras.swt;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.InputEvent;
import java.awt.geom.Rectangle2D;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.piccolo2d.PCamera;
import org.piccolo2d.PComponent;
import org.piccolo2d.PLayer;
import org.piccolo2d.PNode;
import org.piccolo2d.PRoot;
import org.piccolo2d.event.PInputEventListener;
import org.piccolo2d.event.PPanEventHandler;
import org.piccolo2d.event.PZoomEventHandler;
import org.piccolo2d.extras.swt.PSWTKeyEvent;
import org.piccolo2d.extras.swt.PSWTMouseEvent;
import org.piccolo2d.extras.swt.PSWTRoot;
import org.piccolo2d.extras.swt.SWTGraphics2D;
import org.piccolo2d.util.PBounds;
import org.piccolo2d.util.PDebug;
import org.piccolo2d.util.PPaintContext;
import org.piccolo2d.util.PStack;

public class PSWTCanvas
extends Composite
implements PComponent {
    private static final int SWT_BUTTON1 = 1;
    private static final int SWT_BUTTON2 = 2;
    private static final int SWT_BUTTON3 = 3;
    public static PSWTCanvas CURRENT_CANVAS = null;
    private Image backBuffer;
    private boolean doubleBuffered = true;
    private PCamera camera;
    private final PStack cursorStack;
    private org.eclipse.swt.graphics.Cursor curCursor;
    private int interacting;
    private int defaultRenderQuality;
    private int animatingRenderQuality;
    private int interactingRenderQuality;
    private final PPanEventHandler panEventHandler;
    private final PZoomEventHandler zoomEventHandler;
    private boolean paintingImmediately;
    private boolean animatingOnLastPaint;
    private boolean isButton1Pressed;
    private boolean isButton2Pressed;
    private boolean isButton3Pressed;

    public PSWTCanvas(Composite parent, int style) {
        super(parent, style | 0x40000 | 0x100000);
        CURRENT_CANVAS = this;
        this.cursorStack = new PStack();
        this.setCamera(this.createBasicSceneGraph());
        this.installInputSources();
        this.setDefaultRenderQuality(1);
        this.setAnimatingRenderQuality(0);
        this.setInteractingRenderQuality(0);
        this.panEventHandler = new PPanEventHandler();
        this.zoomEventHandler = new PZoomEventHandler();
        this.addInputEventListener((PInputEventListener)this.panEventHandler);
        this.addInputEventListener((PInputEventListener)this.zoomEventHandler);
        this.installPaintListener();
        this.installDisposeListener();
    }

    private void installPaintListener() {
        this.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent pe) {
                PSWTCanvas.this.paintComponent(pe.gc, pe.x, pe.y, pe.width, pe.height);
            }
        });
    }

    private void installDisposeListener() {
        SWTGraphics2D.incrementGCCount();
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent de) {
                PSWTCanvas.this.getRoot().getActivityScheduler().removeAllActivities();
                SWTGraphics2D.decrementGCCount();
            }
        });
    }

    public PPanEventHandler getPanEventHandler() {
        return this.panEventHandler;
    }

    public PZoomEventHandler getZoomEventHandler() {
        return this.zoomEventHandler;
    }

    public PCamera getCamera() {
        return this.camera;
    }

    public void setCamera(PCamera newCamera) {
        if (this.camera != null) {
            this.camera.setComponent(null);
        }
        this.camera = newCamera;
        if (this.camera != null) {
            this.camera.setComponent((PComponent)this);
            Rectangle swtRect = this.getBounds();
            this.camera.setBounds((Rectangle2D)new Rectangle2D.Double(swtRect.x, swtRect.y, swtRect.width, swtRect.height));
        }
    }

    public PRoot getRoot() {
        return this.camera.getRoot();
    }

    public PLayer getLayer() {
        return this.camera.getLayer(0);
    }

    public void addInputEventListener(PInputEventListener listener) {
        this.getCamera().addInputEventListener(listener);
    }

    public void removeInputEventListener(PInputEventListener listener) {
        this.getCamera().removeInputEventListener(listener);
    }

    public PCamera createBasicSceneGraph() {
        PSWTRoot r = new PSWTRoot(this);
        PLayer l = new PLayer();
        PCamera c = new PCamera();
        r.addChild((PNode)c);
        r.addChild((PNode)l);
        c.addLayer(l);
        return c;
    }

    public boolean getInteracting() {
        return this.interacting > 0;
    }

    public boolean getAnimating() {
        return this.getRoot().getActivityScheduler().getAnimating();
    }

    public void setInteracting(boolean isInteracting) {
        this.interacting = isInteracting ? ++this.interacting : --this.interacting;
        if (!this.getInteracting()) {
            this.repaint();
        }
    }

    public boolean getDoubleBuffered() {
        return this.doubleBuffered;
    }

    public void setDoubleBuffered(boolean doubleBuffered) {
        this.doubleBuffered = doubleBuffered;
        if (!doubleBuffered && this.backBuffer != null) {
            this.backBuffer.dispose();
            this.backBuffer = null;
        }
    }

    public void setDefaultRenderQuality(int requestedQuality) {
        this.defaultRenderQuality = requestedQuality;
        this.repaint();
    }

    public void setAnimatingRenderQuality(int requestedQuality) {
        this.animatingRenderQuality = requestedQuality;
        this.repaint();
    }

    public void setInteractingRenderQuality(int requestedQuality) {
        this.interactingRenderQuality = requestedQuality;
        this.repaint();
    }

    public void pushCursor(Cursor newCursor) {
        org.eclipse.swt.graphics.Cursor swtCursor = null;
        if (newCursor.getType() == 8) {
            swtCursor = new org.eclipse.swt.graphics.Cursor((Device)this.getDisplay(), 10);
        } else if (newCursor.getType() == 7) {
            swtCursor = new org.eclipse.swt.graphics.Cursor((Device)this.getDisplay(), 14);
        } else if (newCursor.getType() == 6) {
            swtCursor = new org.eclipse.swt.graphics.Cursor((Device)this.getDisplay(), 17);
        } else if (newCursor.getType() == 9) {
            swtCursor = new org.eclipse.swt.graphics.Cursor((Device)this.getDisplay(), 11);
        } else if (newCursor.getType() == 5) {
            swtCursor = new org.eclipse.swt.graphics.Cursor((Device)this.getDisplay(), 15);
        } else if (newCursor.getType() == 4) {
            swtCursor = new org.eclipse.swt.graphics.Cursor((Device)this.getDisplay(), 16);
        } else if (newCursor.getType() == 11) {
            swtCursor = new org.eclipse.swt.graphics.Cursor((Device)this.getDisplay(), 12);
        } else if (newCursor.getType() == 10) {
            swtCursor = new org.eclipse.swt.graphics.Cursor((Device)this.getDisplay(), 13);
        } else if (newCursor.getType() == 2) {
            swtCursor = new org.eclipse.swt.graphics.Cursor((Device)this.getDisplay(), 19);
        } else if (newCursor.getType() == 12) {
            swtCursor = new org.eclipse.swt.graphics.Cursor((Device)this.getDisplay(), 21);
        } else if (newCursor.getType() == 13) {
            swtCursor = new org.eclipse.swt.graphics.Cursor((Device)this.getDisplay(), 5);
        } else if (newCursor.getType() == 1) {
            swtCursor = new org.eclipse.swt.graphics.Cursor((Device)this.getDisplay(), 2);
        } else if (newCursor.getType() == 3) {
            swtCursor = new org.eclipse.swt.graphics.Cursor((Device)this.getDisplay(), 1);
        }
        if (swtCursor != null) {
            if (this.curCursor != null) {
                this.cursorStack.push((Object)this.curCursor);
            }
            this.curCursor = swtCursor;
            this.setCursor(swtCursor);
        }
    }

    public void popCursor() {
        if (this.curCursor != null) {
            this.curCursor.dispose();
        }
        this.curCursor = this.cursorStack.isEmpty() ? null : (org.eclipse.swt.graphics.Cursor)this.cursorStack.pop();
        this.setCursor(this.curCursor);
    }

    protected void installInputSources() {
        MouseInputSource mouseInputSource = new MouseInputSource();
        this.addMouseListener(mouseInputSource);
        this.addMouseMoveListener(mouseInputSource);
        this.addKeyListener(new KeyboardInputSource());
    }

    protected void sendInputEventToInputManager(InputEvent awtEvent, int type) {
        this.getRoot().getDefaultInputManager().processEventFromCamera(awtEvent, type, this.getCamera());
    }

    public void setBounds(int x, int y, int newWidth, int newHeight) {
        this.camera.setBounds(this.camera.getX(), this.camera.getY(), (double)newWidth, (double)newHeight);
        if (this.backBufferNeedsResizing(newWidth, newHeight)) {
            this.resizeBackBuffer(newWidth, newHeight);
        }
        super.setBounds(x, y, newWidth, newHeight);
    }

    private void resizeBackBuffer(int newWidth, int newHeight) {
        if (this.backBuffer != null) {
            this.backBuffer.dispose();
        }
        this.backBuffer = new Image((Device)this.getDisplay(), newWidth, newHeight);
    }

    private boolean backBufferNeedsResizing(int newWidth, int newHeight) {
        if (!this.doubleBuffered) {
            return false;
        }
        if (this.backBuffer == null) {
            return true;
        }
        return this.backBuffer.getBounds().width < newWidth || this.backBuffer.getBounds().height < newHeight;
    }

    public void repaint() {
        super.redraw();
    }

    public void repaint(PBounds bounds) {
        bounds.expandNearestIntegerDimensions();
        bounds.inset(-1.0, -1.0);
        this.redraw((int)bounds.x, (int)bounds.y, (int)bounds.width, (int)bounds.height, true);
    }

    public void paintComponent(GC gc, int x, int y, int w, int h) {
        PDebug.startProcessingOutput();
        GC imageGC = null;
        SWTGraphics2D g2 = null;
        if (this.doubleBuffered) {
            imageGC = new GC((Drawable)this.backBuffer);
            g2 = new SWTGraphics2D(imageGC, (Device)this.getDisplay());
        } else {
            g2 = new SWTGraphics2D(gc, (Device)this.getDisplay());
        }
        ((Graphics)g2).setColor(Color.white);
        ((Graphics2D)g2).setBackground(Color.white);
        Rectangle rect = this.getBounds();
        ((Graphics)g2).fillRect(0, 0, rect.width, rect.height);
        if (PDebug.debugRegionManagement) {
            Rectangle r = gc.getClipping();
            Rectangle2D.Double r2 = new Rectangle2D.Double(r.x, r.y, r.width, r.height);
            ((Graphics2D)g2).setBackground(PDebug.getDebugPaintColor());
            ((Graphics2D)g2).fill(r2);
        }
        PPaintContext paintContext = new PPaintContext((Graphics2D)g2);
        if (this.getInteracting() || this.getAnimating()) {
            if (this.interactingRenderQuality > this.animatingRenderQuality) {
                paintContext.setRenderQuality(this.interactingRenderQuality);
            } else {
                paintContext.setRenderQuality(this.animatingRenderQuality);
            }
        } else {
            paintContext.setRenderQuality(this.defaultRenderQuality);
        }
        this.camera.fullPaint(paintContext);
        if (this.animatingOnLastPaint && !this.getAnimating()) {
            this.repaint();
        }
        this.animatingOnLastPaint = this.getAnimating();
        boolean region = PDebug.debugRegionManagement;
        PDebug.debugRegionManagement = false;
        PDebug.endProcessingOutput((Graphics)g2);
        PDebug.debugRegionManagement = region;
        if (this.doubleBuffered) {
            gc.drawImage(this.backBuffer, 0, 0);
            imageGC.dispose();
        }
    }

    public void paintImmediately() {
        if (this.paintingImmediately) {
            return;
        }
        this.paintingImmediately = true;
        this.redraw();
        this.update();
        this.paintingImmediately = false;
    }

    private final class MouseInputSource
    implements MouseListener,
    MouseMoveListener {
        private MouseInputSource() {
        }

        public void mouseMove(MouseEvent me) {
            if (PSWTCanvas.this.isButton1Pressed || PSWTCanvas.this.isButton2Pressed || PSWTCanvas.this.isButton3Pressed) {
                PSWTMouseEvent inputEvent = new PSWTMouseEvent(me, 506, 1);
                PSWTCanvas.this.sendInputEventToInputManager(inputEvent, 506);
            } else {
                PSWTMouseEvent inputEvent = new PSWTMouseEvent(me, 503, 1);
                PSWTCanvas.this.sendInputEventToInputManager(inputEvent, 503);
            }
        }

        public void mouseDown(MouseEvent mouseEvent) {
            PSWTMouseEvent balanceEvent;
            boolean shouldBalanceEvent = false;
            switch (mouseEvent.button) {
                case 1: {
                    if (PSWTCanvas.this.isButton1Pressed) {
                        shouldBalanceEvent = true;
                    }
                    PSWTCanvas.this.isButton1Pressed = true;
                    break;
                }
                case 2: {
                    if (PSWTCanvas.this.isButton2Pressed) {
                        shouldBalanceEvent = true;
                    }
                    PSWTCanvas.this.isButton2Pressed = true;
                    break;
                }
                case 3: {
                    if (PSWTCanvas.this.isButton3Pressed) {
                        shouldBalanceEvent = true;
                    }
                    PSWTCanvas.this.isButton3Pressed = true;
                    break;
                }
            }
            if (shouldBalanceEvent) {
                balanceEvent = new PSWTMouseEvent(mouseEvent, 502, 1);
                PSWTCanvas.this.sendInputEventToInputManager(balanceEvent, 502);
            }
            balanceEvent = new PSWTMouseEvent(mouseEvent, 501, 1);
            PSWTCanvas.this.sendInputEventToInputManager(balanceEvent, 501);
        }

        public void mouseUp(MouseEvent me) {
            PSWTMouseEvent balanceEvent;
            boolean shouldBalanceEvent = false;
            switch (me.button) {
                case 1: {
                    if (!PSWTCanvas.this.isButton1Pressed) {
                        shouldBalanceEvent = true;
                    }
                    PSWTCanvas.this.isButton1Pressed = false;
                    break;
                }
                case 2: {
                    if (!PSWTCanvas.this.isButton2Pressed) {
                        shouldBalanceEvent = true;
                    }
                    PSWTCanvas.this.isButton2Pressed = false;
                    break;
                }
                case 3: {
                    if (!PSWTCanvas.this.isButton3Pressed) {
                        shouldBalanceEvent = true;
                    }
                    PSWTCanvas.this.isButton3Pressed = false;
                    break;
                }
            }
            if (shouldBalanceEvent) {
                balanceEvent = new PSWTMouseEvent(me, 501, 1);
                PSWTCanvas.this.sendInputEventToInputManager(balanceEvent, 501);
            }
            balanceEvent = new PSWTMouseEvent(me, 502, 1);
            PSWTCanvas.this.sendInputEventToInputManager(balanceEvent, 502);
        }

        public void mouseDoubleClick(MouseEvent me) {
            PSWTMouseEvent inputEvent = new PSWTMouseEvent(me, 501, 2);
            PSWTCanvas.this.sendInputEventToInputManager(inputEvent, 501);
            inputEvent = new PSWTMouseEvent(me, 502, 2);
            PSWTCanvas.this.sendInputEventToInputManager(inputEvent, 502);
        }
    }

    private final class KeyboardInputSource
    implements KeyListener {
        private KeyboardInputSource() {
        }

        public void keyPressed(KeyEvent ke) {
            PSWTKeyEvent inputEvent = new PSWTKeyEvent(ke, 401);
            PSWTCanvas.this.sendInputEventToInputManager(inputEvent, 401);
        }

        public void keyReleased(KeyEvent ke) {
            PSWTKeyEvent inputEvent = new PSWTKeyEvent(ke, 402);
            PSWTCanvas.this.sendInputEventToInputManager(inputEvent, 402);
        }
    }
}

