#include <iostream>
#include <ctype.h>

#include "Symmetry.hh"
#include "PointConfiguration.hh"


  
int main(const int argc, const char** argv) {
  using namespace topcom;

  if (argc < 2) {
    std::cerr << "usage: " << argv[0] << " n" << std::endl;
    return 1;
  }
  parameter_type n = atoi(argv[1]);
  if (n <= 0) {
    std::cerr << "n > 0 required" << std::endl;
    return 1;
  }

  // first compute the group A_n generated by all 3-cycles:
  symmetry_collectordata A_data;
  Permutation cycle(n,3);
  do {
    Symmetry s(cycle);
    A_data.insert(s);
  } while (cycle.lexnext());
  SymmetryGroup A(n, A_data);

  // transform symmetries into permutation matrices:
  std::pair<PointConfiguration, SymmetryGroup> B_A_center(A.permutation_polytope(true));
  std::cout << B_A_center.first  << std::endl;
  B_A_center.second.write_generators(std::cout);
  std::cout << std::endl;
  return 0;
}

// eof B_A_center.cc
