/*
 * Copyright (C) 2023, KylinSoft Co., Ltd.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <http://www.gnu.org/licenses/>.
 *
**/
#ifndef MODULEPAGEWIDGET_H
#define MODULEPAGEWIDGET_H

#include <QWidget>
#include <QMap>
#include <QVariantMap>

class MainWindow;
class CommonInterface;
class KeyValueConverter;

class QListWidgetItem;

namespace Ui {
class ModulePageWidget;
}

class ModulePageWidget : public QWidget
{
    Q_OBJECT

public:
    explicit ModulePageWidget(QWidget *parent = 0);
    ~ModulePageWidget();

public:
    void initUI();
    void switchPage(QObject * plugin, bool recorded = true, QString jumpText = "");
    void refreshPluginWidget(CommonInterface * plu);
    void pluginLeave();

private:
    Ui::ModulePageWidget *ui;

public:
    QString mCurrentPluName = "";

private:
    MainWindow * pmainWindow;
    CommonInterface * prePlugin = nullptr;
    CommonInterface * currentPlugin = nullptr;
    QWidget *pluginwidget = nullptr;

private:
    bool flagBit;

Q_SIGNALS:
    void hScrollBarShow();
    void hScrollBarHide();
};

#endif // MODULEPAGEWIDGET_H
