/* Low IO interface for Turbo Linux */

/* phrno: Phrase Number, return in tt */
void LoadPhrase (HzInputTable_T *pClient, int phrno, char *tt)
{
}

static void InitPhrase (pClient, ITEM *p, long nPhrase, char *szCode)
{
    int len;
    u_long key1, key2;
    int k;
    
    len = strlen(szCode);
    if (len > pClient->table->MaxPress) 
         pClient->table->MaxPress=len;

    key1 = key2 = 0;
    for (i = 0; i < len; i++)
    {
        if(i<5)
        {
            k = pClient->table->KeyMap[szCode[i]];
            key1 |= k << (24-i*6);
        }
        else
        {
            k = pClient->table->KeyMap[szCode[i]];
            key2 |= k<< (24-(i-5)*6);
        }
    }
    memcpy(&p->key1,&key1,4);
    memcpy(&p->key2,&key2,4);
    p->nPhrase = nPhrase;
}

static int AddToAssociatePhrase (u_char *szPhrase, ITEM *pItem)
{
    AssociatePhrase *p = pClient->pAssociatePhrase;
    int index = CaculateAssociateIndex (szPhrase);

    p[index].total++;
    if (p[index].total == 1)
    {
        p[index].pPhrase = malloc (sizeof (ITEM));
    }
    else
    {
        p[index].pPhrase = realloc (p[index].pPhrase, 
                           sizeof (ITEM) * p[index].total);
    }
    p[index].pPhrase[p[index].total-1] = pItem;
    return 1;
}

int AppendPhrase (p, char *szCode, char *szPhrase)
{
    long n = AppendPhrase (szPhrase);
    p->table->TotalChar ++;
    p->table->item = realloc (p->table->item, sizeof(ITEM) * table->TotalChar);
    InitPhrase (p, &p->table->item[table->TotalChar-1], n, szCode);
    AddToAssociatePhrase (szPhrase, &p->table->item[table->TotalChar-1]);
}

