/*
 * Copyright (C) 2013 National University of Defense Technology(NUDT) & Kylin Ltd
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by Weihua Zhang <fly2high@126.com>
 * Authored by shijing <jingshi@ubuntukylin.com>
 * Modified Information:
 * 1. Modify build_search_uri function , building search condition.
 * 2. Reimplement the process_search_results function, get the information of video from youku.
 *
 */

/*
 * Copyright (C) 2012 Canonical Ltd
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by Pawel Stolowski <pawel.stolowski@canonical.com>
 *
 */

namespace Unity.VideoLens.UbuntuVideoSearch
{
    private static const string SERVER = "http://www.soku.com/search_video/";

  public static string sources_uri ()
  {
    return SERVER;
  }

  public static string recommendations_uri ()
  {
    return SERVER + "/search?q=&sources=Amazon";
  }

  public static string build_search_uri (string query, Gee.ArrayList<string>? sources)
  {
    var uri = new StringBuilder ();
    uri.append (SERVER);
    uri.append ("q_");
    uri.append (Uri.escape_string (query, "", false));
    if (sources != null && sources.size>0)
     {
      uri.append ("&sources=");
      uri.append (sources[0]);
      for (int i=1; i<sources.size; i++)
      {
        uri.append (",");
        uri.append (sources[i]);
      }
    }
   return uri.str;
  }


  /**
   * Parses JSON data returned by search requests, returns list of videos.
   */
  public Gee.ArrayList<RemoteVideoFile?>? process_search_results (string json_data, bool is_treat_yourself) throws Error
  {
         var videos = new Gee.ArrayList<RemoteVideoFile?> ();
         var video = RemoteVideoFile ();
         string content = json_data;

	 var iIndex = content.index_of("<div class=\"sk-vlist");
         var iEnd = content.index_of("<div class=\"sk-pager");
         content = content.substring(iIndex, iEnd - iIndex);
	  
         List<string> lilist = new List<string> ();
         var liIndex = content.index_of("<div class=\"v-meta-entry");
         while(liIndex != -1)
            {
                lilist.append(content.substring(0,liIndex+600));
                content = content.substring(liIndex+600);
                liIndex = content.index_of("<div class=\"v-meta-entry");
            }
	  
         foreach (string li in lilist)
            {
                iIndex = li.index_of("href=\"http://v.youku.com/v_show/id_");   //每个视频uri
                iEnd = li.substring(iIndex).index_of("\" ");
                video.uri = li.substring(iIndex+6,iEnd-6);

        		iIndex = li.index_of("<a title=");                           //每个视频标题
                iEnd = li.substring(iIndex).index_of("\" ");
                video.title = li.substring(iIndex+10,iEnd-10);
                iIndex = li.index_of("<img alt");                           //每个视频图片
                li = li.substring(iIndex);
                iIndex = li.index_of("src");
                iEnd = li.substring(iIndex).index_of("onerror");
                video.icon = li.substring(iIndex+5,iEnd-7);
                             
                iIndex = li.index_of("span class=\"v-time");
                iEnd = li.substring(iIndex).index_of("</span");
                video.comment = li.substring(iIndex+20,iEnd-20);  //每个视频图片time but do not show
/*
                iIndex = li.index_of("div class=\"v-meta-data");
                iEnd = li.substring(iIndex).index_of("</span");
                video.comment = li.substring(iIndex+20,iEnd-20);
*/				
                videos.add (video);                                 // the first video
           }
      return videos;
  }

  /**
   * Joins elements of JSON array of strings.
   */
  internal string join_array (Json.Array array, string separator)
  {
    var res = new StringBuilder ();
    var len = array.get_length ();
    array.foreach_element ((a, index, node) =>
    {
      res.append (node.get_string ());
      if (index < len - 1)
      res.append (separator);
    });
    return res.str;
  }

  public string[] json_array_to_str_array (Json.Array array)
  {
    string [] res = {};
    array.foreach_element ((a, index, node) =>
    {
      res += node.get_string ();
    });
    return res;
  }

  public RemoteVideoDetails process_details_results (string json_data) throws Error
  {
//此函数去掉或者将下列代码注释掉，preview页面图片不能正常显示，具体原因尚未搞清楚
    var parser = new Json.Parser ();
    parser.load_from_data (json_data);
    var details = parser.get_root ().get_object ();

    var video = RemoteVideoDetails ();
    video.title = details.get_string_member ("title");
    video.image = details.get_string_member ("image");
    video.description = details.get_string_member ("description");
    video.source = details.get_string_member ("source");
	  
    if (details.has_member ("release_date"))
    {
      // v1 spec states release_date will be YYYY-MM-DD
      var release_date = GLib.Time ();
      if (release_date.strptime (details.get_string_member ("release_date"), "%Y-%m-%d") != null)
      {
        video.release_date = release_date.format ("%Y");
      }
      else
      {
        warning ("Failed to parse release_date: '%s'", details.get_string_member ("release_date"));
      }
    }

    video.price = details.has_member ("formatted_price") ? details.get_string_member ("formatted_price") : "";

    video.duration = 0;
    if (details.has_member ("duration"))
      video.duration = int.parse (details.get_string_member ("duration")) / 60;

    video.directors = {};
    if (details.has_member ("directors"))
    {
      var directors = details.get_array_member ("directors");
      video.directors = json_array_to_str_array (directors);
    }

    if (details.has_member ("starring"))
    {
      var starring = details.get_array_member ("starring");
      video.starring = join_array (starring, ", ");
    }

    video.genres = {};
    if (details.has_member ("genres"))
    {
      var genres = details.get_array_member ("genres");
      video.genres = json_array_to_str_array (genres);
    }

    if (details.has_member ("uploaded_by"))
      video.uploaded_by = details.get_string_member ("uploaded_by");

    if (details.has_member ("date_uploaded"))
      video.date_uploaded = details.get_string_member ("date_uploaded");
    return video;
  }

  /**
   * Parses JSON data returned by 'sources' query, returns list of sources (e.g. "Amazon", "Youtube" etc.)
   */
  public Gee.ArrayList<string>? process_sources_results (string json_data) throws Error
  {
    var parser = new Json.Parser ();

    parser.load_from_data (json_data);
    var sources_array = parser.get_root ().get_array ();
    var results = new Gee.ArrayList<string> (null);

    sources_array.foreach_element ((array, index, node) =>
    {
      results.add (node.get_string ());
    });

    return results;
  }
}
