def _next_statement(content, idx):
    statement = ''
    initidx = idx
    while idx < len(content) and content[idx] != ';':
        idx = idx + 1
    idx = idx + 1
    statement = content[initidx:idx-1]
    return idx, statement.strip().replace('\n', '')

def _tokenize_statement(statement):
    tokens = r"""
    (?P<identifier>[a-zA-Z_][a-zA-Z0-9_]*)
    |(?P<coma>[,])
    |(?P<openparen>[\(])
    |(?P<closeparen>[\)])
    |(?P<star>[\*])
    |(?P<semicolumn>[;])
    |(?P<newline>[\n]) 
    |(?P<whitespace>[\s])
    |(?P<closebracket>[}]) 
    |(?P<openbracket>[{]) 
    """
    import re
    tre = re.compile(tokens,re.X)
    idx = 0
    m = tre.match(statement, idx)
    while m:
        idx = m.end()
        yield m.lastgroup.strip(), m.group(m.lastgroup).strip()
        m = tre.match(statement, idx)

def _is_whitespace_token(t):
    return t == 'newline' or t == 'whitespace'

def _next(stream):
    try:
        return stream.next()
    except:
        return None

def _eat_tokens(stream, stop_predicate):
    tokens = []
    while True:
        t = _next(stream)
        while t and _is_whitespace_token(t[0]):
            t = _next(stream)
        if not t:
            break
        tokens.append(t)
        if stop_predicate and stop_predicate(t):
            break
    return tokens

def _expect_tokens(types, stream):
    tokens = []
    try:
        while len(types) != 0:
            cur_type = types.pop(0)
            t = _next(stream)
            while _is_whitespace_token(t[0]):
                t = _next(stream)
            if not t:
                break
            tokens.append(t)
            if not t[0] == cur_type:
                return False, tokens
    except IndexError, e:
        pass
    return True, tokens

# TODO review this mess
def _parse_typedef_statement(statement, token_stream):
    # expects a given shape (callback definitions)
    t = _next(token_stream)
    while t and t[0] != 'openparen':
        t = _next(token_stream)
    if not t:
        print "Could not properly parse typedef statement:", statement
        return False, {}
    result, tokens = _expect_tokens(['star', 'identifier', 'closeparen'], token_stream)
    if not result or len(tokens) != 3:
        print 'Could not properly parse typedef statement (not a pointer to func):', statement
        return False, {}

    description = {'type': 'func_typedef', 'name': tokens[1]}

    param_tokens = _eat_tokens(token_stream, lambda t: len(t) == 2 and t[0] == 'closeparen')

    if not len(param_tokens) != 0 or not (param_tokens[0][0] == 'openparen' and param_tokens[-1][0] == 'closeparen'):
        print 'Could not properly parse typedef statement (not a pointer to func):', statement
        return False, {}
    param_tokens.pop(0); param_tokens.pop()

    description['parameters'] = []
    param = []
    while len(param_tokens) != 0:
        param.append(param_tokens.pop(0))
        if len(param_tokens) == 0 or param_tokens[0][0] == 'coma':
            # TODO validate params
            param_name = param.pop()[1]
            description['parameters'].append ({'name': param_name
                                               , 'type': ' '.join ([p[1] for p in param])})
        param = []
    return True, description

# TODO review this mess
def _parse_function_decl_statement(prev_token, statement, token_stream):
    # expects a given shape
    param_tokens = _eat_tokens(token_stream, lambda t: len(t) == 2 and t[0] == 'openparen')

    if not len(param_tokens) >= 2 or len(param_tokens[-1]) != 2 or param_tokens[-1][0] != 'openparen':
        print 'Could not properly parse function declaration statement:', statement
        return False, {}
    param_tokens.pop()
    # TODO validate 'identifier'
    description = {'type': 'func_decl', 'name': param_tokens.pop()}
    description['return'] = [prev_token[1]]
    description['return'].extend ([p[1] for p in param_tokens])

    tokens = _eat_tokens(token_stream, lambda t: len(t) == 2 and t[0] == 'closeparen')
    if not tokens or len(tokens) < 2 or tokens[-1][0] != 'closeparen':
        print 'Could not properly parse function declaration statement:', statement
        return False, {}

    description['parameters'] = []
    param = []
    while len(tokens) != 0:
        param.append(tokens.pop(0))
        if len(tokens) == 0 or tokens[0][0] == 'coma' or tokens[0][0] == 'closeparen':
            # TODO validate params
            # assume type + param name
            if len(param) >= 2:
                param_name = param.pop()[1]
                description['parameters'].append ({'name': param_name
                                                   , 'type': ' '.join ([p[1] for p in param])})
                param = []
            if len(tokens) != 0:
                tokens.pop(0)
    return True, description

def _parse_statement(statement):
    if len(statement.strip()) == 0:
        return False, {}
    token_stream = _tokenize_statement(statement)
    t = _next(token_stream)
    if not t:
        return False, {}
    if not t[0] == 'identifier':
        print 'Ignoring statement:', statement, 'does not start with a proper identifier'
        return False, {}
    if t[1] == 'typedef':
        return _parse_typedef_statement(statement, token_stream)
    if t[1] == 'struct':
        print 'Skipping struct statement:', statement
        return False, {}
    return _parse_function_decl_statement(t, statement, token_stream)

def parse(content):
    idx = 0
    idx, statement = _next_statement(content, idx)
    descriptions = []
    while statement != '' or idx < len(content):
        parsed, description = _parse_statement(statement)
        if parsed:
            descriptions.append (description)
        idx, statement = _next_statement(content, idx)
    return descriptions

