// ==UserScript==
// @include        http://*.newsblur.com
// @include        http://newsblur.com/*
// @include        http://*.newsblur.com/*
// @require        utils.js
// ==/UserScript==

// This placeholder gets munged with real data at build time.
var WebappsGettextDict = JSON.parse(unescape(
    "%7B%22GETTEXT%22%3A%22PLACEHOLDER%22%7D"
));

window.Unity = external.getUnityObject(1);

function unreadNews() {
    function getElementsByClassName(classname, node) {
        var a = [];
        if (!node) {
            node = document.getElementsByTagName("body")[0];
        }
        var re = new RegExp('\\b' + classname + '\\b');
        var els = node.getElementsByTagName("*");
        var j = els.length;
        var i = 0;
        for (i, j; i < j; i++) {
            if (re.test(els[i].className)) {
                a.push(els[i]);
            }
        }
        return a;
    }

    function getCount() {
        var neg;
        var neu;
        var pos;
        var total;
        neg = getElementsByClassName("NB-feeds-header-negative")[0].textContent;
        neu = getElementsByClassName("NB-feeds-header-neutral")[0].textContent;
        pos = getElementsByClassName("NB-feeds-header-positive")[0].textContent;
        total = parseInt(neg, 10) + parseInt(neu, 10) + parseInt(pos, 10);
        return total;
    }

    function updateLauncher() {
        var unread;
        unread = getCount();
        if (unread === 0) {
            Unity.Launcher.clearCount();
        } else {
            Unity.Launcher.setCount(unread);
        }
    }

    window.onfocus = updateLauncher;
    window.setInterval(wrapCallback(updateLauncher), 1000);
}

Unity.init({name: "Newsblur",
            iconUrl: "icon://unity-webapps-newsblur",
            domain: 'newsblur.com',
            homepage: 'http://newsblur.com/',
            onInit: wrapCallback(unreadNews)});
