/*******************************************************************************
 * Part of "Intel(R) Active Management Technology (Intel(R) AMT)
 *                   User Notification Service (UNS)"
 *
 * Copyright (c) 2007 Intel Corp.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer,
 *    without modification.
 * 2. Redistributions in binary form must reproduce at minimum a disclaimer
 *    substantially similar to the "NO WARRANTY" disclaimer below
 *    ("Disclaimer") and any redistribution must be conditioned upon
 *    including a substantially similar Disclaimer requirement for further
 *    binary redistribution.
 * 3. Neither the names of the above-listed copyright holders nor the names
 *    of any contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * Alternatively, this software may be distributed under the terms of the
 * GNU General Public License ("GPL") version 2 as published by the Free
 * Software Foundation.
 *
 * NO WARRANTY
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * HOLDERS OR CONTRIBUTORS BE LIABLE FOR SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
 * IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGES.
 *******************************************************************************/

#pragma once

//#define BASIC_AUTH	// Allow basic authentication
#define DIGEST_AUTH	// Allow digest authentication.
//#define NO_AUTH			// Allow anonymous access.

// Status of the UNS.
typedef enum _UNS_STATUS
{
	UNS_STATUS_SUCCESS				= 0x0,
	UNS_STATUS_INIT_FAILURE			= 0x1,
	UNS_STATUS_SOAP_SERVER_ERROR	= 0x2,
	UNS_STATUS_BIND_ERROR			= 0x3,
	UNS_STATUS_SUBSCRIPTION_ERROR   = 0x4,
	UNS_STATUS_CENCEL_ERROR			= 0x5,
	UNS_GET_NET_PARAM_ERROR			= 0x6,
	UNS_STATUS_UPDATE_REG_MODE		= 0x7

} UNS_STATUS;

// Status of soap request.
typedef enum _PT_STATUS
{
	PT_STATUS_SUCCESS							= 0x0,
	PT_STATUS_INTERNAL_ERROR					= 0x1,
	PT_STATUS_NOT_READY							= 0x2,
	PT_STATUS_INVALID_PT_MODE					= 0x3,
	PT_STATUS_INVALID_MESSAGE_LENGTH			= 0x4,
	PT_STATUS_TABLE_FINGERPRINT_NOT_AVAILABLE	= 0x5,
	PT_STATUS_INTEGRITY_CHECK_FAILED			= 0x6,
	PT_STATUS_UNSUPPORTED_ISVS_VERSION			= 0x7,
	PT_STATUS_APPLICATION_NOT_REGISTERED		= 0x8,
	PT_STATUS_INVALID_REGISTRATION_DATA			= 0x9,
	PT_STATUS_APPLICATION_DOES_NOT_EXIST		= 0xA,
	PT_STATUS_NOT_ENOUGH_STORAGE				= 0xB,
	PT_STATUS_INVALID_NAME						= 0xC,
	PT_STATUS_BLOCK_DOES_NOT_EXIST				= 0xD,
	PT_STATUS_INVALID_BYTE_OFFSET				= 0xE,
	PT_STATUS_INVALID_BYTE_COUNT				= 0xF,
	PT_STATUS_NOT_PERMITTED						= 0x10,
	PT_STATUS_NOT_OWNER							= 0x11,
	PT_STATUS_BLOCK_LOCKED_BY_OTHER				= 0x12,
	PT_STATUS_BLOCK_NOT_LOCKED					= 0x13,
	PT_STATUS_INVALID_GROUP_PERMISSIONS			= 0x14,
	PT_STATUS_GROUP_DOES_NOT_EXIST				= 0x15,
	PT_STATUS_INVALID_MEMBER_COUNT				= 0x16,
	PT_STATUS_MAX_LIMIT_REACHED					= 0x17,
	PT_STATUS_INVALID_AUTH_TYPE					= 0x18,
	PT_STATUS_AUTHENTICATION_FAILED				= 0x19,
	PT_STATUS_INVALID_DHCP_MODE					= 0x1A,
	PT_STATUS_INVALID_IP_ADDRESS				= 0x1B,
	PT_STATUS_INVALID_DOMAIN_NAME				= 0x1C,
	PT_STATUS_UNSUPPORTED_VERSION				= 0x1D,
	PT_STATUS_REQUEST_UNEXPECTED				= 0x1E,
	PT_STATUS_INVALID_TABLE_TYPE				= 0x1F,
	PT_STATUS_INVALID_PROVISIONING_STATE		= 0x20,
	PT_STATUS_UNSUPPORTED_OBJECT				= 0x21,
	PT_STATUS_INVALID_TIME						= 0x22,
	PT_STATUS_INVALID_INDEX						= 0x23,
	PT_STATUS_INVALID_PARAMETER					= 0x24,
	PT_STATUS_INVALID_NETMASK					= 0x25,
	PT_STATUS_FLASH_WRITE_LIMIT_EXCEEDED		= 0x26,
	PT_STATUS_NETWORK_IF_ERROR_BASE				= 0x800,
	PT_STATUS_UNSUPPORTED_OEM_NUMBER			= 0x801,
	PT_STATUS_UNSUPPORTED_BOOT_OPTION			= 0x802,
	PT_STATUS_INVALID_COMMAND					= 0x803,
	PT_STATUS_INVALID_SPECIAL_COMMAND			= 0x804,
	PT_STATUS_INVALID_HANDLE					= 0x805,
	PT_STATUS_INVALID_PASSWORD					= 0x806,
	PT_STATUS_INVALID_REALM						= 0x807,
	PT_STATUS_STORAGE_ACL_ENTRY_IN_USE			= 0x808,
	PT_STATUS_DATA_MISSING						= 0x809,
	PT_STATUS_DUPLICATE							= 0x80A,
	PT_STATUS_EVENTLOG_FROZEN					= 0x80B,
	PT_STATUS_INVALID_KEY						= 0x80E,
	PT_STATUS_INVALID_CERT						= 0x80F,
	PT_STATUS_CERT_KEY_NOT_MATCH				= 0x810,
	PT_STATUS_MAX_KERB_DOMAIN_REACHED			= 0x811,
	PT_STATUS_UNSUPPORTED						= 0x812,
	PT_STATUS_SDK_DEFINED_ERROR_BASE			= 0x1000
} PT_STATUS;
