// Copyright 2015, VIXL authors
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are met:
//
//   * Redistributions of source code must retain the above copyright notice,
//     this list of conditions and the following disclaimer.
//   * Redistributions in binary form must reproduce the above copyright notice,
//     this list of conditions and the following disclaimer in the documentation
//     and/or other materials provided with the distribution.
//   * Neither the name of ARM Limited nor the names of its contributors may be
//     used to endorse or promote products derived from this software without
//     specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS CONTRIBUTORS "AS IS" AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
// DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
// SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
// CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
// OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


// ---------------------------------------------------------------------
// This file is auto generated using tools/generate_simulator_traces.py.
//
// PLEASE DO NOT EDIT.
// ---------------------------------------------------------------------

#ifndef VIXL_SIM_URHADD_8H_TRACE_AARCH64_H_
#define VIXL_SIM_URHADD_8H_TRACE_AARCH64_H_

const uint16_t kExpected_NEON_urhadd_8H[] = {
  0x007e, 0x007f, 0x3333, 0x5555, 0x7ffd, 0x7ffe, 0x7fff, 0x0000,
  0x007f, 0x19d9, 0x4444, 0x6aa9, 0x7ffe, 0x7fff, 0x4000, 0x0001,
  0x19d9, 0x2aea, 0x5998, 0x6aaa, 0x7ffe, 0x3fff, 0x4000, 0x0001,
  0x2aea, 0x403e, 0x5999, 0x6aaa, 0x3fff, 0x4000, 0x4001, 0x0008,
  0x403e, 0x403f, 0x5999, 0x2aab, 0x3fff, 0x4000, 0x4008, 0x003f,
  0x403e, 0x403f, 0x199a, 0x2aab, 0x4000, 0x4007, 0x403e, 0x003f,
  0x403f, 0x0040, 0x199a, 0x2aac, 0x4007, 0x403e, 0x403f, 0x0040,
  0x003f, 0x0040, 0x199b, 0x2ab3, 0x403d, 0x403e, 0x403f, 0x199a,
  0x0040, 0x0041, 0x19a2, 0x2ae9, 0x403e, 0x403f, 0x5999, 0x2aab,
  0x0040, 0x0048, 0x19d8, 0x2aea, 0x403e, 0x5999, 0x6aaa, 0x3fff,
  0x0047, 0x007e, 0x19d9, 0x2aea, 0x5998, 0x6aaa, 0x7ffe, 0x3fff,
  0x007e, 0x007f, 0x19d9, 0x4444, 0x6aa9, 0x7ffe, 0x7fff, 0x4000,
  0x007e, 0x007f, 0x3333, 0x5555, 0x7ffd, 0x7ffe, 0x7fff, 0x4000,
  0x007f, 0x19d9, 0x4444, 0x6aa9, 0x7ffe, 0x7fff, 0x8000, 0x4001,
  0x19d9, 0x2aea, 0x5998, 0x6aaa, 0x7ffe, 0x7fff, 0x8000, 0x5555,
  0x2aea, 0x403e, 0x5999, 0x6aaa, 0x7fff, 0x8000, 0x9555, 0x6666,
  0x403e, 0x403f, 0x5999, 0x6aab, 0x7fff, 0x9554, 0xa666, 0x7fc0,
  0x403e, 0x403f, 0x599a, 0x6aab, 0x9554, 0xa665, 0xbfc0, 0x7fc1,
  0x403f, 0x4040, 0x599a, 0x8000, 0xa665, 0xbfbf, 0xbfc0, 0x7fc1,
  0x403f, 0x4040, 0x6eef, 0x9111, 0xbfbf, 0xbfc0, 0xbfc1, 0x7fc2,
  0x4040, 0x5595, 0x8000, 0xaa6b, 0xbfbf, 0xbfc0, 0xbfc1, 0x7ff8,
  0x5594, 0x66a6, 0x995a, 0xaa6b, 0xbfc0, 0xbfc1, 0xbff8, 0x7fff,
  0x66a5, 0x8000, 0x995a, 0xaa6c, 0xbfc0, 0xbff7, 0xbffe, 0x7fff,
  0x7fff, 0x8000, 0x995b, 0xaa6c, 0xbff7, 0xbffe, 0xbfff, 0x8000,
  0x8000, 0x995b, 0xaa6c, 0xbff7, 0xbffe, 0xbfff, 0x8000, 0x0001,
  0x8001, 0x995b, 0xaaa3, 0xbffd, 0xbffe, 0xbfff, 0x0000, 0x0001,
  0x8001, 0x9992, 0xaaa9, 0xbffe, 0xbfff, 0x4000, 0x0001, 0x0002,
  0x8038, 0x9998, 0xaaaa, 0xbffe, 0x3fff, 0x4000, 0x0001, 0x0009,
  0x803e, 0x9999, 0xaaaa, 0x3fff, 0x4000, 0x4001, 0x0008, 0x003f,
  0x803f, 0x9999, 0x2aab, 0x3fff, 0x4000, 0x4008, 0x003f, 0x0040,
  0x803f, 0x199a, 0x2aab, 0x4000, 0x4007, 0x403e, 0x003f, 0x0040,
  0x0040, 0x199a, 0x2aac, 0x4007, 0x403e, 0x403f, 0x0040, 0x199a,
  0x0040, 0x199b, 0x2ab3, 0x403d, 0x403e, 0x403f, 0x199a, 0x2aab,
  0x0041, 0x19a2, 0x2ae9, 0x403e, 0x403f, 0x5999, 0x2aab, 0x3fff,
  0x0048, 0x19d8, 0x2aea, 0x403e, 0x5999, 0x6aaa, 0x3fff, 0x4000,
  0x007e, 0x19d9, 0x2aea, 0x5998, 0x6aaa, 0x7ffe, 0x3fff, 0x4000,
  0x007f, 0x19d9, 0x4444, 0x6aa9, 0x7ffe, 0x7fff, 0x4000, 0x4001,
  0x007f, 0x3333, 0x5555, 0x7ffd, 0x7ffe, 0x7fff, 0x4000, 0x4001,
  0x19d9, 0x4444, 0x6aa9, 0x7ffe, 0x7fff, 0x8000, 0x4001, 0x5556,
  0x2aea, 0x5998, 0x6aaa, 0x7ffe, 0x7fff, 0x8000, 0x5555, 0x6667,
  0x403e, 0x5999, 0x6aaa, 0x7fff, 0x8000, 0x9555, 0x6666, 0x7fc1,
  0x403f, 0x5999, 0x6aab, 0x7fff, 0x9554, 0xa666, 0x7fc0, 0x7fc1,
  0x403f, 0x599a, 0x6aab, 0x9554, 0xa665, 0xbfc0, 0x7fc1, 0x7fc2,
  0x4040, 0x599a, 0x8000, 0xa665, 0xbfbf, 0xbfc0, 0x7fc1, 0x7fc2,
  0x4040, 0x6eef, 0x9111, 0xbfbf, 0xbfc0, 0xbfc1, 0x7fc2, 0x7ff9,
  0x5595, 0x8000, 0xaa6b, 0xbfbf, 0xbfc0, 0xbfc1, 0x7ff8, 0x7fff,
  0x66a6, 0x995a, 0xaa6b, 0xbfc0, 0xbfc1, 0xbff8, 0x7fff, 0x8000,
  0x8000, 0x995a, 0xaa6c, 0xbfc0, 0xbff7, 0xbffe, 0x7fff, 0x8000,
  0x995a, 0xaa6c, 0xbfc0, 0xbff7, 0xbffe, 0x7fff, 0x8000, 0x0001,
  0x995b, 0xaa6c, 0xbff7, 0xbffe, 0xbfff, 0x8000, 0x0001, 0x0002,
  0x995b, 0xaaa3, 0xbffd, 0xbffe, 0xbfff, 0x0000, 0x0001, 0x0002,
  0x9992, 0xaaa9, 0xbffe, 0xbfff, 0x4000, 0x0001, 0x0002, 0x0009,
  0x9998, 0xaaaa, 0xbffe, 0x3fff, 0x4000, 0x0001, 0x0009, 0x0040,
  0x9999, 0xaaaa, 0x3fff, 0x4000, 0x4001, 0x0008, 0x003f, 0x0040,
  0x9999, 0x2aab, 0x3fff, 0x4000, 0x4008, 0x003f, 0x0040, 0x0041,
  0x199a, 0x2aab, 0x4000, 0x4007, 0x403e, 0x003f, 0x0040, 0x199b,
  0x199a, 0x2aac, 0x4007, 0x403e, 0x403f, 0x0040, 0x199a, 0x2aac,
  0x199b, 0x2ab3, 0x403d, 0x403e, 0x403f, 0x199a, 0x2aab, 0x4000,
  0x19a2, 0x2ae9, 0x403e, 0x403f, 0x5999, 0x2aab, 0x3fff, 0x4000,
  0x19d8, 0x2aea, 0x403e, 0x5999, 0x6aaa, 0x3fff, 0x4000, 0x4001,
  0x19d9, 0x2aea, 0x5998, 0x6aaa, 0x7ffe, 0x3fff, 0x4000, 0x4001,
  0x19d9, 0x4444, 0x6aa9, 0x7ffe, 0x7fff, 0x4000, 0x4001, 0x4002,
  0x3333, 0x5555, 0x7ffd, 0x7ffe, 0x7fff, 0x4000, 0x4001, 0x5556,
  0x4444, 0x6aa9, 0x7ffe, 0x7fff, 0x8000, 0x4001, 0x5556, 0x6667,
  0x5998, 0x6aaa, 0x7ffe, 0x7fff, 0x8000, 0x5555, 0x6667, 0x7fc1,
  0x5999, 0x6aaa, 0x7fff, 0x8000, 0x9555, 0x6666, 0x7fc1, 0x7fc2,
  0x5999, 0x6aab, 0x7fff, 0x9554, 0xa666, 0x7fc0, 0x7fc1, 0x7fc2,
  0x599a, 0x6aab, 0x9554, 0xa665, 0xbfc0, 0x7fc1, 0x7fc2, 0x7fc3,
  0x599a, 0x8000, 0xa665, 0xbfbf, 0xbfc0, 0x7fc1, 0x7fc2, 0x7ff9,
  0x6eef, 0x9111, 0xbfbf, 0xbfc0, 0xbfc1, 0x7fc2, 0x7ff9, 0x8000,
  0x8000, 0xaa6b, 0xbfbf, 0xbfc0, 0xbfc1, 0x7ff8, 0x7fff, 0x8000,
  0x995a, 0xaa6b, 0xbfc0, 0xbfc1, 0xbff8, 0x7fff, 0x8000, 0x8001,
  0xaa6b, 0xbfc0, 0xbfc1, 0xbff8, 0x7fff, 0x8000, 0x8001, 0x0008,
  0xaa6c, 0xbfc0, 0xbff7, 0xbffe, 0x7fff, 0x8000, 0x0001, 0x0009,
  0xaa6c, 0xbff7, 0xbffe, 0xbfff, 0x8000, 0x0001, 0x0002, 0x0009,
  0xaaa3, 0xbffd, 0xbffe, 0xbfff, 0x0000, 0x0001, 0x0002, 0x0010,
  0xaaa9, 0xbffe, 0xbfff, 0x4000, 0x0001, 0x0002, 0x0009, 0x0047,
  0xaaaa, 0xbffe, 0x3fff, 0x4000, 0x0001, 0x0009, 0x0040, 0x0047,
  0xaaaa, 0x3fff, 0x4000, 0x4001, 0x0008, 0x003f, 0x0040, 0x0048,
  0x2aab, 0x3fff, 0x4000, 0x4008, 0x003f, 0x0040, 0x0041, 0x19a2,
  0x2aab, 0x4000, 0x4007, 0x403e, 0x003f, 0x0040, 0x199b, 0x2ab3,
  0x2aac, 0x4007, 0x403e, 0x403f, 0x0040, 0x199a, 0x2aac, 0x4007,
  0x2ab3, 0x403d, 0x403e, 0x403f, 0x199a, 0x2aab, 0x4000, 0x4007,
  0x2ae9, 0x403e, 0x403f, 0x5999, 0x2aab, 0x3fff, 0x4000, 0x4008,
  0x2aea, 0x403e, 0x5999, 0x6aaa, 0x3fff, 0x4000, 0x4001, 0x4008,
  0x2aea, 0x5998, 0x6aaa, 0x7ffe, 0x3fff, 0x4000, 0x4001, 0x4009,
  0x4444, 0x6aa9, 0x7ffe, 0x7fff, 0x4000, 0x4001, 0x4002, 0x555d,
  0x5555, 0x7ffd, 0x7ffe, 0x7fff, 0x4000, 0x4001, 0x5556, 0x666e,
  0x6aa9, 0x7ffe, 0x7fff, 0x8000, 0x4001, 0x5556, 0x6667, 0x7fc8,
  0x6aaa, 0x7ffe, 0x7fff, 0x8000, 0x5555, 0x6667, 0x7fc1, 0x7fc9,
  0x6aaa, 0x7fff, 0x8000, 0x9555, 0x6666, 0x7fc1, 0x7fc2, 0x7fc9,
  0x6aab, 0x7fff, 0x9554, 0xa666, 0x7fc0, 0x7fc1, 0x7fc2, 0x7fca,
  0x6aab, 0x9554, 0xa665, 0xbfc0, 0x7fc1, 0x7fc2, 0x7fc3, 0x8000,
  0x8000, 0xa665, 0xbfbf, 0xbfc0, 0x7fc1, 0x7fc2, 0x7ff9, 0x8007,
  0x9111, 0xbfbf, 0xbfc0, 0xbfc1, 0x7fc2, 0x7ff9, 0x8000, 0x8007,
  0xaa6b, 0xbfbf, 0xbfc0, 0xbfc1, 0x7ff8, 0x7fff, 0x8000, 0x8008,
  0xbfbf, 0xbfc0, 0xbfc1, 0x7ff8, 0x7fff, 0x8000, 0x8008, 0x003f,
  0xbfc0, 0xbfc1, 0xbff8, 0x7fff, 0x8000, 0x8001, 0x0008, 0x003f,
  0xbfc0, 0xbff7, 0xbffe, 0x7fff, 0x8000, 0x0001, 0x0009, 0x0040,
  0xbff7, 0xbffe, 0xbfff, 0x8000, 0x0001, 0x0002, 0x0009, 0x0047,
  0xbffd, 0xbffe, 0xbfff, 0x0000, 0x0001, 0x0002, 0x0010, 0x007d,
  0xbffe, 0xbfff, 0x4000, 0x0001, 0x0002, 0x0009, 0x0047, 0x007e,
  0xbffe, 0x3fff, 0x4000, 0x0001, 0x0009, 0x0040, 0x0047, 0x007e,
  0x3fff, 0x4000, 0x4001, 0x0008, 0x003f, 0x0040, 0x0048, 0x19d8,
  0x3fff, 0x4000, 0x4008, 0x003f, 0x0040, 0x0041, 0x19a2, 0x2ae9,
  0x4000, 0x4007, 0x403e, 0x003f, 0x0040, 0x199b, 0x2ab3, 0x403d,
  0x4007, 0x403e, 0x403f, 0x0040, 0x199a, 0x2aac, 0x4007, 0x403e,
  0x403d, 0x403e, 0x403f, 0x199a, 0x2aab, 0x4000, 0x4007, 0x403e,
  0x403e, 0x403f, 0x5999, 0x2aab, 0x3fff, 0x4000, 0x4008, 0x403f,
  0x403e, 0x5999, 0x6aaa, 0x3fff, 0x4000, 0x4001, 0x4008, 0x403f,
  0x5998, 0x6aaa, 0x7ffe, 0x3fff, 0x4000, 0x4001, 0x4009, 0x5594,
  0x6aa9, 0x7ffe, 0x7fff, 0x4000, 0x4001, 0x4002, 0x555d, 0x66a5,
  0x7ffd, 0x7ffe, 0x7fff, 0x4000, 0x4001, 0x5556, 0x666e, 0x7fff,
  0x7ffe, 0x7fff, 0x8000, 0x4001, 0x5556, 0x6667, 0x7fc8, 0x7fff,
  0x7ffe, 0x7fff, 0x8000, 0x5555, 0x6667, 0x7fc1, 0x7fc9, 0x8000,
  0x7fff, 0x8000, 0x9555, 0x6666, 0x7fc1, 0x7fc2, 0x7fc9, 0x8000,
  0x7fff, 0x9554, 0xa666, 0x7fc0, 0x7fc1, 0x7fc2, 0x7fca, 0x8037,
  0x9554, 0xa665, 0xbfc0, 0x7fc1, 0x7fc2, 0x7fc3, 0x8000, 0x803d,
  0xa665, 0xbfbf, 0xbfc0, 0x7fc1, 0x7fc2, 0x7ff9, 0x8007, 0x803e,
  0xbfbf, 0xbfc0, 0xbfc1, 0x7fc2, 0x7ff9, 0x8000, 0x8007, 0x803e,
  0xbfc0, 0xbfc1, 0x7fc2, 0x7ff9, 0x8000, 0x8007, 0x803e, 0x003f,
  0xbfc0, 0xbfc1, 0x7ff8, 0x7fff, 0x8000, 0x8008, 0x003f, 0x0040,
  0xbfc1, 0xbff8, 0x7fff, 0x8000, 0x8001, 0x0008, 0x003f, 0x0040,
  0xbff7, 0xbffe, 0x7fff, 0x8000, 0x0001, 0x0009, 0x0040, 0x0047,
  0xbffe, 0xbfff, 0x8000, 0x0001, 0x0002, 0x0009, 0x0047, 0x007e,
  0xbffe, 0xbfff, 0x0000, 0x0001, 0x0002, 0x0010, 0x007d, 0x007e,
  0xbfff, 0x4000, 0x0001, 0x0002, 0x0009, 0x0047, 0x007e, 0x007f,
  0x3fff, 0x4000, 0x0001, 0x0009, 0x0040, 0x0047, 0x007e, 0x19d9,
  0x4000, 0x4001, 0x0008, 0x003f, 0x0040, 0x0048, 0x19d8, 0x2aea,
  0x4000, 0x4008, 0x003f, 0x0040, 0x0041, 0x19a2, 0x2ae9, 0x403e,
  0x4007, 0x403e, 0x003f, 0x0040, 0x199b, 0x2ab3, 0x403d, 0x403e,
  0x403e, 0x403f, 0x0040, 0x199a, 0x2aac, 0x4007, 0x403e, 0x403f,
  0x403e, 0x403f, 0x199a, 0x2aab, 0x4000, 0x4007, 0x403e, 0x403f,
  0x403f, 0x5999, 0x2aab, 0x3fff, 0x4000, 0x4008, 0x403f, 0x4040,
  0x5999, 0x6aaa, 0x3fff, 0x4000, 0x4001, 0x4008, 0x403f, 0x5594,
  0x6aaa, 0x7ffe, 0x3fff, 0x4000, 0x4001, 0x4009, 0x5594, 0x66a5,
  0x7ffe, 0x7fff, 0x4000, 0x4001, 0x4002, 0x555d, 0x66a5, 0x7fff,
  0x7ffe, 0x7fff, 0x4000, 0x4001, 0x5556, 0x666e, 0x7fff, 0x8000,
  0x7fff, 0x8000, 0x4001, 0x5556, 0x6667, 0x7fc8, 0x7fff, 0x8000,
  0x7fff, 0x8000, 0x5555, 0x6667, 0x7fc1, 0x7fc9, 0x8000, 0x8001,
  0x8000, 0x9555, 0x6666, 0x7fc1, 0x7fc2, 0x7fc9, 0x8000, 0x8037,
  0x9554, 0xa666, 0x7fc0, 0x7fc1, 0x7fc2, 0x7fca, 0x8037, 0x803e,
  0xa665, 0xbfc0, 0x7fc1, 0x7fc2, 0x7fc3, 0x8000, 0x803d, 0x803e,
  0xbfbf, 0xbfc0, 0x7fc1, 0x7fc2, 0x7ff9, 0x8007, 0x803e, 0x803f,
  0xbfc0, 0x7fc1, 0x7fc2, 0x7ff9, 0x8007, 0x803e, 0x803f, 0x0040,
  0xbfc1, 0x7fc2, 0x7ff9, 0x8000, 0x8007, 0x803e, 0x003f, 0x0040,
  0xbfc1, 0x7ff8, 0x7fff, 0x8000, 0x8008, 0x003f, 0x0040, 0x0041,
  0xbff8, 0x7fff, 0x8000, 0x8001, 0x0008, 0x003f, 0x0040, 0x0048,
  0xbffe, 0x7fff, 0x8000, 0x0001, 0x0009, 0x0040, 0x0047, 0x007e,
  0xbfff, 0x8000, 0x0001, 0x0002, 0x0009, 0x0047, 0x007e, 0x007f,
  0xbfff, 0x0000, 0x0001, 0x0002, 0x0010, 0x007d, 0x007e, 0x007f,
  0x4000, 0x0001, 0x0002, 0x0009, 0x0047, 0x007e, 0x007f, 0x19d9,
  0x4000, 0x0001, 0x0009, 0x0040, 0x0047, 0x007e, 0x19d9, 0x2aea,
  0x4001, 0x0008, 0x003f, 0x0040, 0x0048, 0x19d8, 0x2aea, 0x403e,
  0x4008, 0x003f, 0x0040, 0x0041, 0x19a2, 0x2ae9, 0x403e, 0x403f,
  0x403e, 0x003f, 0x0040, 0x199b, 0x2ab3, 0x403d, 0x403e, 0x403f,
  0x403f, 0x0040, 0x199a, 0x2aac, 0x4007, 0x403e, 0x403f, 0x4040,
  0x403f, 0x199a, 0x2aab, 0x4000, 0x4007, 0x403e, 0x403f, 0x4040,
  0x5999, 0x2aab, 0x3fff, 0x4000, 0x4008, 0x403f, 0x4040, 0x5595,
  0x6aaa, 0x3fff, 0x4000, 0x4001, 0x4008, 0x403f, 0x5594, 0x66a6,
  0x7ffe, 0x3fff, 0x4000, 0x4001, 0x4009, 0x5594, 0x66a5, 0x8000,
  0x7fff, 0x4000, 0x4001, 0x4002, 0x555d, 0x66a5, 0x7fff, 0x8000,
  0x7fff, 0x4000, 0x4001, 0x5556, 0x666e, 0x7fff, 0x8000, 0x8001,
  0x8000, 0x4001, 0x5556, 0x6667, 0x7fc8, 0x7fff, 0x8000, 0x8001,
  0x8000, 0x5555, 0x6667, 0x7fc1, 0x7fc9, 0x8000, 0x8001, 0x8038,
  0x9555, 0x6666, 0x7fc1, 0x7fc2, 0x7fc9, 0x8000, 0x8037, 0x803e,
  0xa666, 0x7fc0, 0x7fc1, 0x7fc2, 0x7fca, 0x8037, 0x803e, 0x803f,
  0xbfc0, 0x7fc1, 0x7fc2, 0x7fc3, 0x8000, 0x803d, 0x803e, 0x803f,
  0x7fc1, 0x7fc2, 0x7fc3, 0x8000, 0x803d, 0x803e, 0x803f, 0x199a,
  0x7fc1, 0x7fc2, 0x7ff9, 0x8007, 0x803e, 0x803f, 0x0040, 0x199a,
  0x7fc2, 0x7ff9, 0x8000, 0x8007, 0x803e, 0x003f, 0x0040, 0x199b,
  0x7ff8, 0x7fff, 0x8000, 0x8008, 0x003f, 0x0040, 0x0041, 0x19a2,
  0x7fff, 0x8000, 0x8001, 0x0008, 0x003f, 0x0040, 0x0048, 0x19d8,
  0x7fff, 0x8000, 0x0001, 0x0009, 0x0040, 0x0047, 0x007e, 0x19d9,
  0x8000, 0x0001, 0x0002, 0x0009, 0x0047, 0x007e, 0x007f, 0x19d9,
  0x0000, 0x0001, 0x0002, 0x0010, 0x007d, 0x007e, 0x007f, 0x3333,
  0x0001, 0x0002, 0x0009, 0x0047, 0x007e, 0x007f, 0x19d9, 0x4444,
  0x0001, 0x0009, 0x0040, 0x0047, 0x007e, 0x19d9, 0x2aea, 0x5998,
  0x0008, 0x003f, 0x0040, 0x0048, 0x19d8, 0x2aea, 0x403e, 0x5999,
  0x003f, 0x0040, 0x0041, 0x19a2, 0x2ae9, 0x403e, 0x403f, 0x5999,
  0x003f, 0x0040, 0x199b, 0x2ab3, 0x403d, 0x403e, 0x403f, 0x599a,
  0x0040, 0x199a, 0x2aac, 0x4007, 0x403e, 0x403f, 0x4040, 0x599a,
  0x199a, 0x2aab, 0x4000, 0x4007, 0x403e, 0x403f, 0x4040, 0x6eef,
  0x2aab, 0x3fff, 0x4000, 0x4008, 0x403f, 0x4040, 0x5595, 0x8000,
  0x3fff, 0x4000, 0x4001, 0x4008, 0x403f, 0x5594, 0x66a6, 0x995a,
  0x3fff, 0x4000, 0x4001, 0x4009, 0x5594, 0x66a5, 0x8000, 0x995a,
  0x4000, 0x4001, 0x4002, 0x555d, 0x66a5, 0x7fff, 0x8000, 0x995b,
  0x4000, 0x4001, 0x5556, 0x666e, 0x7fff, 0x8000, 0x8001, 0x995b,
  0x4001, 0x5556, 0x6667, 0x7fc8, 0x7fff, 0x8000, 0x8001, 0x9992,
  0x5555, 0x6667, 0x7fc1, 0x7fc9, 0x8000, 0x8001, 0x8038, 0x9998,
  0x6666, 0x7fc1, 0x7fc2, 0x7fc9, 0x8000, 0x8037, 0x803e, 0x9999,
  0x7fc0, 0x7fc1, 0x7fc2, 0x7fca, 0x8037, 0x803e, 0x803f, 0x9999,
  0x7fc1, 0x7fc2, 0x7fca, 0x8037, 0x803e, 0x803f, 0x9999, 0x2aab,
  0x7fc2, 0x7fc3, 0x8000, 0x803d, 0x803e, 0x803f, 0x199a, 0x2aab,
  0x7fc2, 0x7ff9, 0x8007, 0x803e, 0x803f, 0x0040, 0x199a, 0x2aac,
  0x7ff9, 0x8000, 0x8007, 0x803e, 0x003f, 0x0040, 0x199b, 0x2ab3,
  0x7fff, 0x8000, 0x8008, 0x003f, 0x0040, 0x0041, 0x19a2, 0x2ae9,
  0x8000, 0x8001, 0x0008, 0x003f, 0x0040, 0x0048, 0x19d8, 0x2aea,
  0x8000, 0x0001, 0x0009, 0x0040, 0x0047, 0x007e, 0x19d9, 0x2aea,
  0x0001, 0x0002, 0x0009, 0x0047, 0x007e, 0x007f, 0x19d9, 0x4444,
  0x0001, 0x0002, 0x0010, 0x007d, 0x007e, 0x007f, 0x3333, 0x5555,
  0x0002, 0x0009, 0x0047, 0x007e, 0x007f, 0x19d9, 0x4444, 0x6aa9,
  0x0009, 0x0040, 0x0047, 0x007e, 0x19d9, 0x2aea, 0x5998, 0x6aaa,
  0x003f, 0x0040, 0x0048, 0x19d8, 0x2aea, 0x403e, 0x5999, 0x6aaa,
  0x0040, 0x0041, 0x19a2, 0x2ae9, 0x403e, 0x403f, 0x5999, 0x6aab,
  0x0040, 0x199b, 0x2ab3, 0x403d, 0x403e, 0x403f, 0x599a, 0x6aab,
  0x199a, 0x2aac, 0x4007, 0x403e, 0x403f, 0x4040, 0x599a, 0x8000,
  0x2aab, 0x4000, 0x4007, 0x403e, 0x403f, 0x4040, 0x6eef, 0x9111,
  0x3fff, 0x4000, 0x4008, 0x403f, 0x4040, 0x5595, 0x8000, 0xaa6b,
  0x4000, 0x4001, 0x4008, 0x403f, 0x5594, 0x66a6, 0x995a, 0xaa6b,
  0x4000, 0x4001, 0x4009, 0x5594, 0x66a5, 0x8000, 0x995a, 0xaa6c,
  0x4001, 0x4002, 0x555d, 0x66a5, 0x7fff, 0x8000, 0x995b, 0xaa6c,
  0x4001, 0x5556, 0x666e, 0x7fff, 0x8000, 0x8001, 0x995b, 0xaaa3,
  0x5556, 0x6667, 0x7fc8, 0x7fff, 0x8000, 0x8001, 0x9992, 0xaaa9,
  0x6667, 0x7fc1, 0x7fc9, 0x8000, 0x8001, 0x8038, 0x9998, 0xaaaa,
  0x7fc1, 0x7fc2, 0x7fc9, 0x8000, 0x8037, 0x803e, 0x9999, 0xaaaa,
  0x7fc2, 0x7fc9, 0x8000, 0x8037, 0x803e, 0x9999, 0xaaaa, 0x3fff,
  0x7fc2, 0x7fca, 0x8037, 0x803e, 0x803f, 0x9999, 0x2aab, 0x3fff,
  0x7fc3, 0x8000, 0x803d, 0x803e, 0x803f, 0x199a, 0x2aab, 0x4000,
  0x7ff9, 0x8007, 0x803e, 0x803f, 0x0040, 0x199a, 0x2aac, 0x4007,
  0x8000, 0x8007, 0x803e, 0x003f, 0x0040, 0x199b, 0x2ab3, 0x403d,
  0x8000, 0x8008, 0x003f, 0x0040, 0x0041, 0x19a2, 0x2ae9, 0x403e,
  0x8001, 0x0008, 0x003f, 0x0040, 0x0048, 0x19d8, 0x2aea, 0x403e,
  0x0001, 0x0009, 0x0040, 0x0047, 0x007e, 0x19d9, 0x2aea, 0x5998,
  0x0002, 0x0009, 0x0047, 0x007e, 0x007f, 0x19d9, 0x4444, 0x6aa9,
  0x0002, 0x0010, 0x007d, 0x007e, 0x007f, 0x3333, 0x5555, 0x7ffd,
  0x0009, 0x0047, 0x007e, 0x007f, 0x19d9, 0x4444, 0x6aa9, 0x7ffe,
  0x0040, 0x0047, 0x007e, 0x19d9, 0x2aea, 0x5998, 0x6aaa, 0x7ffe,
  0x0040, 0x0048, 0x19d8, 0x2aea, 0x403e, 0x5999, 0x6aaa, 0x7fff,
  0x0041, 0x19a2, 0x2ae9, 0x403e, 0x403f, 0x5999, 0x6aab, 0x7fff,
  0x199b, 0x2ab3, 0x403d, 0x403e, 0x403f, 0x599a, 0x6aab, 0x9554,
  0x2aac, 0x4007, 0x403e, 0x403f, 0x4040, 0x599a, 0x8000, 0xa665,
  0x4000, 0x4007, 0x403e, 0x403f, 0x4040, 0x6eef, 0x9111, 0xbfbf,
  0x4000, 0x4008, 0x403f, 0x4040, 0x5595, 0x8000, 0xaa6b, 0xbfbf,
  0x4001, 0x4008, 0x403f, 0x5594, 0x66a6, 0x995a, 0xaa6b, 0xbfc0,
  0x4001, 0x4009, 0x5594, 0x66a5, 0x8000, 0x995a, 0xaa6c, 0xbfc0,
  0x4002, 0x555d, 0x66a5, 0x7fff, 0x8000, 0x995b, 0xaa6c, 0xbff7,
  0x5556, 0x666e, 0x7fff, 0x8000, 0x8001, 0x995b, 0xaaa3, 0xbffd,
  0x6667, 0x7fc8, 0x7fff, 0x8000, 0x8001, 0x9992, 0xaaa9, 0xbffe,
  0x7fc1, 0x7fc9, 0x8000, 0x8001, 0x8038, 0x9998, 0xaaaa, 0xbffe,
  0x7fc9, 0x8000, 0x8001, 0x8038, 0x9998, 0xaaaa, 0xbffe, 0x3fff,
  0x7fc9, 0x8000, 0x8037, 0x803e, 0x9999, 0xaaaa, 0x3fff, 0x4000,
  0x7fca, 0x8037, 0x803e, 0x803f, 0x9999, 0x2aab, 0x3fff, 0x4000,
  0x8000, 0x803d, 0x803e, 0x803f, 0x199a, 0x2aab, 0x4000, 0x4007,
  0x8007, 0x803e, 0x803f, 0x0040, 0x199a, 0x2aac, 0x4007, 0x403e,
  0x8007, 0x803e, 0x003f, 0x0040, 0x199b, 0x2ab3, 0x403d, 0x403e,
  0x8008, 0x003f, 0x0040, 0x0041, 0x19a2, 0x2ae9, 0x403e, 0x403f,
  0x0008, 0x003f, 0x0040, 0x0048, 0x19d8, 0x2aea, 0x403e, 0x5999,
  0x0009, 0x0040, 0x0047, 0x007e, 0x19d9, 0x2aea, 0x5998, 0x6aaa,
  0x0009, 0x0047, 0x007e, 0x007f, 0x19d9, 0x4444, 0x6aa9, 0x7ffe,
  0x0010, 0x007d, 0x007e, 0x007f, 0x3333, 0x5555, 0x7ffd, 0x7ffe,
  0x0047, 0x007e, 0x007f, 0x19d9, 0x4444, 0x6aa9, 0x7ffe, 0x7fff,
  0x0047, 0x007e, 0x19d9, 0x2aea, 0x5998, 0x6aaa, 0x7ffe, 0x7fff,
  0x0048, 0x19d8, 0x2aea, 0x403e, 0x5999, 0x6aaa, 0x7fff, 0x8000,
  0x19a2, 0x2ae9, 0x403e, 0x403f, 0x5999, 0x6aab, 0x7fff, 0x9554,
  0x2ab3, 0x403d, 0x403e, 0x403f, 0x599a, 0x6aab, 0x9554, 0xa665,
  0x4007, 0x403e, 0x403f, 0x4040, 0x599a, 0x8000, 0xa665, 0xbfbf,
  0x4007, 0x403e, 0x403f, 0x4040, 0x6eef, 0x9111, 0xbfbf, 0xbfc0,
  0x4008, 0x403f, 0x4040, 0x5595, 0x8000, 0xaa6b, 0xbfbf, 0xbfc0,
  0x4008, 0x403f, 0x5594, 0x66a6, 0x995a, 0xaa6b, 0xbfc0, 0xbfc1,
  0x4009, 0x5594, 0x66a5, 0x8000, 0x995a, 0xaa6c, 0xbfc0, 0xbff7,
  0x555d, 0x66a5, 0x7fff, 0x8000, 0x995b, 0xaa6c, 0xbff7, 0xbffe,
  0x666e, 0x7fff, 0x8000, 0x8001, 0x995b, 0xaaa3, 0xbffd, 0xbffe,
  0x7fc8, 0x7fff, 0x8000, 0x8001, 0x9992, 0xaaa9, 0xbffe, 0xbfff,
  0x7fff, 0x8000, 0x8001, 0x9992, 0xaaa9, 0xbffe, 0xbfff, 0x4000,
  0x8000, 0x8001, 0x8038, 0x9998, 0xaaaa, 0xbffe, 0x3fff, 0x4000,
  0x8000, 0x8037, 0x803e, 0x9999, 0xaaaa, 0x3fff, 0x4000, 0x4001,
  0x8037, 0x803e, 0x803f, 0x9999, 0x2aab, 0x3fff, 0x4000, 0x4008,
  0x803d, 0x803e, 0x803f, 0x199a, 0x2aab, 0x4000, 0x4007, 0x403e,
  0x803e, 0x803f, 0x0040, 0x199a, 0x2aac, 0x4007, 0x403e, 0x403f,
  0x803e, 0x003f, 0x0040, 0x199b, 0x2ab3, 0x403d, 0x403e, 0x403f,
  0x003f, 0x0040, 0x0041, 0x19a2, 0x2ae9, 0x403e, 0x403f, 0x5999,
  0x003f, 0x0040, 0x0048, 0x19d8, 0x2aea, 0x403e, 0x5999, 0x6aaa,
  0x0040, 0x0047, 0x007e, 0x19d9, 0x2aea, 0x5998, 0x6aaa, 0x7ffe,
  0x0047, 0x007e, 0x007f, 0x19d9, 0x4444, 0x6aa9, 0x7ffe, 0x7fff,
  0x007d, 0x007e, 0x007f, 0x3333, 0x5555, 0x7ffd, 0x7ffe, 0x7fff,
  0x007e, 0x007f, 0x19d9, 0x4444, 0x6aa9, 0x7ffe, 0x7fff, 0x8000,
  0x007e, 0x19d9, 0x2aea, 0x5998, 0x6aaa, 0x7ffe, 0x7fff, 0x8000,
  0x19d8, 0x2aea, 0x403e, 0x5999, 0x6aaa, 0x7fff, 0x8000, 0x9555,
  0x2ae9, 0x403e, 0x403f, 0x5999, 0x6aab, 0x7fff, 0x9554, 0xa666,
  0x403d, 0x403e, 0x403f, 0x599a, 0x6aab, 0x9554, 0xa665, 0xbfc0,
  0x403e, 0x403f, 0x4040, 0x599a, 0x8000, 0xa665, 0xbfbf, 0xbfc0,
  0x403e, 0x403f, 0x4040, 0x6eef, 0x9111, 0xbfbf, 0xbfc0, 0xbfc1,
  0x403f, 0x4040, 0x5595, 0x8000, 0xaa6b, 0xbfbf, 0xbfc0, 0xbfc1,
  0x403f, 0x5594, 0x66a6, 0x995a, 0xaa6b, 0xbfc0, 0xbfc1, 0xbff8,
  0x5594, 0x66a5, 0x8000, 0x995a, 0xaa6c, 0xbfc0, 0xbff7, 0xbffe,
  0x66a5, 0x7fff, 0x8000, 0x995b, 0xaa6c, 0xbff7, 0xbffe, 0xbfff,
  0x7fff, 0x8000, 0x8001, 0x995b, 0xaaa3, 0xbffd, 0xbffe, 0xbfff,
  0x8000, 0x8001, 0x995b, 0xaaa3, 0xbffd, 0xbffe, 0xbfff, 0x4000,
  0x8000, 0x8001, 0x9992, 0xaaa9, 0xbffe, 0xbfff, 0x4000, 0x4001,
  0x8001, 0x8038, 0x9998, 0xaaaa, 0xbffe, 0x3fff, 0x4000, 0x4001,
  0x8037, 0x803e, 0x9999, 0xaaaa, 0x3fff, 0x4000, 0x4001, 0x4008,
  0x803e, 0x803f, 0x9999, 0x2aab, 0x3fff, 0x4000, 0x4008, 0x403f,
  0x803e, 0x803f, 0x199a, 0x2aab, 0x4000, 0x4007, 0x403e, 0x403f,
  0x803f, 0x0040, 0x199a, 0x2aac, 0x4007, 0x403e, 0x403f, 0x4040,
  0x003f, 0x0040, 0x199b, 0x2ab3, 0x403d, 0x403e, 0x403f, 0x599a,
  0x0040, 0x0041, 0x19a2, 0x2ae9, 0x403e, 0x403f, 0x5999, 0x6aab,
  0x0040, 0x0048, 0x19d8, 0x2aea, 0x403e, 0x5999, 0x6aaa, 0x7fff,
  0x0047, 0x007e, 0x19d9, 0x2aea, 0x5998, 0x6aaa, 0x7ffe, 0x7fff,
  0x007e, 0x007f, 0x19d9, 0x4444, 0x6aa9, 0x7ffe, 0x7fff, 0x8000,
  0x007e, 0x007f, 0x3333, 0x5555, 0x7ffd, 0x7ffe, 0x7fff, 0x8000,
  0x007f, 0x19d9, 0x4444, 0x6aa9, 0x7ffe, 0x7fff, 0x8000, 0x8001,
  0x19d9, 0x2aea, 0x5998, 0x6aaa, 0x7ffe, 0x7fff, 0x8000, 0x9555,
  0x2aea, 0x403e, 0x5999, 0x6aaa, 0x7fff, 0x8000, 0x9555, 0xa666,
  0x403e, 0x403f, 0x5999, 0x6aab, 0x7fff, 0x9554, 0xa666, 0xbfc0,
  0x403e, 0x403f, 0x599a, 0x6aab, 0x9554, 0xa665, 0xbfc0, 0xbfc1,
  0x403f, 0x4040, 0x599a, 0x8000, 0xa665, 0xbfbf, 0xbfc0, 0xbfc1,
  0x403f, 0x4040, 0x6eef, 0x9111, 0xbfbf, 0xbfc0, 0xbfc1, 0xbfc2,
  0x4040, 0x5595, 0x8000, 0xaa6b, 0xbfbf, 0xbfc0, 0xbfc1, 0xbff8,
  0x5594, 0x66a6, 0x995a, 0xaa6b, 0xbfc0, 0xbfc1, 0xbff8, 0xbfff,
  0x66a5, 0x8000, 0x995a, 0xaa6c, 0xbfc0, 0xbff7, 0xbffe, 0xbfff,
  0x7fff, 0x8000, 0x995b, 0xaa6c, 0xbff7, 0xbffe, 0xbfff, 0xc000,
  0x8000, 0x995b, 0xaa6c, 0xbff7, 0xbffe, 0xbfff, 0xc000, 0x4001,
  0x8001, 0x995b, 0xaaa3, 0xbffd, 0xbffe, 0xbfff, 0x4000, 0x4001,
  0x8001, 0x9992, 0xaaa9, 0xbffe, 0xbfff, 0x4000, 0x4001, 0x4002,
  0x8038, 0x9998, 0xaaaa, 0xbffe, 0x3fff, 0x4000, 0x4001, 0x4009,
  0x803e, 0x9999, 0xaaaa, 0x3fff, 0x4000, 0x4001, 0x4008, 0x403f,
  0x803f, 0x9999, 0x2aab, 0x3fff, 0x4000, 0x4008, 0x403f, 0x4040,
  0x803f, 0x199a, 0x2aab, 0x4000, 0x4007, 0x403e, 0x403f, 0x4040,
  0x0040, 0x199a, 0x2aac, 0x4007, 0x403e, 0x403f, 0x4040, 0x599a,
  0x0040, 0x199b, 0x2ab3, 0x403d, 0x403e, 0x403f, 0x599a, 0x6aab,
  0x0041, 0x19a2, 0x2ae9, 0x403e, 0x403f, 0x5999, 0x6aab, 0x7fff,
  0x0048, 0x19d8, 0x2aea, 0x403e, 0x5999, 0x6aaa, 0x7fff, 0x8000,
  0x007e, 0x19d9, 0x2aea, 0x5998, 0x6aaa, 0x7ffe, 0x7fff, 0x8000,
  0x007f, 0x19d9, 0x4444, 0x6aa9, 0x7ffe, 0x7fff, 0x8000, 0x8001,
  0x007f, 0x3333, 0x5555, 0x7ffd, 0x7ffe, 0x7fff, 0x8000, 0x8001,
  0x19d9, 0x4444, 0x6aa9, 0x7ffe, 0x7fff, 0x8000, 0x8001, 0x9556,
  0x2aea, 0x5998, 0x6aaa, 0x7ffe, 0x7fff, 0x8000, 0x9555, 0xa667,
  0x403e, 0x5999, 0x6aaa, 0x7fff, 0x8000, 0x9555, 0xa666, 0xbfc1,
  0x403f, 0x5999, 0x6aab, 0x7fff, 0x9554, 0xa666, 0xbfc0, 0xbfc1,
  0x403f, 0x599a, 0x6aab, 0x9554, 0xa665, 0xbfc0, 0xbfc1, 0xbfc2,
  0x4040, 0x599a, 0x8000, 0xa665, 0xbfbf, 0xbfc0, 0xbfc1, 0xbfc2,
  0x4040, 0x6eef, 0x9111, 0xbfbf, 0xbfc0, 0xbfc1, 0xbfc2, 0xbff9,
  0x5595, 0x8000, 0xaa6b, 0xbfbf, 0xbfc0, 0xbfc1, 0xbff8, 0xbfff,
  0x66a6, 0x995a, 0xaa6b, 0xbfc0, 0xbfc1, 0xbff8, 0xbfff, 0xc000,
  0x8000, 0x995a, 0xaa6c, 0xbfc0, 0xbff7, 0xbffe, 0xbfff, 0xc000,
  0x995a, 0xaa6c, 0xbfc0, 0xbff7, 0xbffe, 0xbfff, 0xc000, 0x5555,
  0x995b, 0xaa6c, 0xbff7, 0xbffe, 0xbfff, 0xc000, 0x4001, 0x5556,
  0x995b, 0xaaa3, 0xbffd, 0xbffe, 0xbfff, 0x4000, 0x4001, 0x5556,
  0x9992, 0xaaa9, 0xbffe, 0xbfff, 0x4000, 0x4001, 0x4002, 0x555d,
  0x9998, 0xaaaa, 0xbffe, 0x3fff, 0x4000, 0x4001, 0x4009, 0x5594,
  0x9999, 0xaaaa, 0x3fff, 0x4000, 0x4001, 0x4008, 0x403f, 0x5594,
  0x9999, 0x2aab, 0x3fff, 0x4000, 0x4008, 0x403f, 0x4040, 0x5595,
  0x199a, 0x2aab, 0x4000, 0x4007, 0x403e, 0x403f, 0x4040, 0x6eef,
  0x199a, 0x2aac, 0x4007, 0x403e, 0x403f, 0x4040, 0x599a, 0x8000,
  0x199b, 0x2ab3, 0x403d, 0x403e, 0x403f, 0x599a, 0x6aab, 0x9554,
  0x19a2, 0x2ae9, 0x403e, 0x403f, 0x5999, 0x6aab, 0x7fff, 0x9554,
  0x19d8, 0x2aea, 0x403e, 0x5999, 0x6aaa, 0x7fff, 0x8000, 0x9555,
  0x19d9, 0x2aea, 0x5998, 0x6aaa, 0x7ffe, 0x7fff, 0x8000, 0x9555,
  0x19d9, 0x4444, 0x6aa9, 0x7ffe, 0x7fff, 0x8000, 0x8001, 0x9556,
  0x3333, 0x5555, 0x7ffd, 0x7ffe, 0x7fff, 0x8000, 0x8001, 0xaaaa,
  0x4444, 0x6aa9, 0x7ffe, 0x7fff, 0x8000, 0x8001, 0x9556, 0xbbbb,
  0x5998, 0x6aaa, 0x7ffe, 0x7fff, 0x8000, 0x9555, 0xa667, 0xd515,
  0x5999, 0x6aaa, 0x7fff, 0x8000, 0x9555, 0xa666, 0xbfc1, 0xd516,
  0x5999, 0x6aab, 0x7fff, 0x9554, 0xa666, 0xbfc0, 0xbfc1, 0xd516,
  0x599a, 0x6aab, 0x9554, 0xa665, 0xbfc0, 0xbfc1, 0xbfc2, 0xd517,
  0x599a, 0x8000, 0xa665, 0xbfbf, 0xbfc0, 0xbfc1, 0xbfc2, 0xd54d,
  0x6eef, 0x9111, 0xbfbf, 0xbfc0, 0xbfc1, 0xbfc2, 0xbff9, 0xd554,
  0x8000, 0xaa6b, 0xbfbf, 0xbfc0, 0xbfc1, 0xbff8, 0xbfff, 0xd554,
  0x995a, 0xaa6b, 0xbfc0, 0xbfc1, 0xbff8, 0xbfff, 0xc000, 0xd555,
  0xaa6b, 0xbfc0, 0xbfc1, 0xbff8, 0xbfff, 0xc000, 0xd555, 0x6666,
  0xaa6c, 0xbfc0, 0xbff7, 0xbffe, 0xbfff, 0xc000, 0x5555, 0x6667,
  0xaa6c, 0xbff7, 0xbffe, 0xbfff, 0xc000, 0x4001, 0x5556, 0x6667,
  0xaaa3, 0xbffd, 0xbffe, 0xbfff, 0x4000, 0x4001, 0x5556, 0x666e,
  0xaaa9, 0xbffe, 0xbfff, 0x4000, 0x4001, 0x4002, 0x555d, 0x66a5,
  0xaaaa, 0xbffe, 0x3fff, 0x4000, 0x4001, 0x4009, 0x5594, 0x66a5,
  0xaaaa, 0x3fff, 0x4000, 0x4001, 0x4008, 0x403f, 0x5594, 0x66a6,
  0x2aab, 0x3fff, 0x4000, 0x4008, 0x403f, 0x4040, 0x5595, 0x8000,
  0x2aab, 0x4000, 0x4007, 0x403e, 0x403f, 0x4040, 0x6eef, 0x9111,
  0x2aac, 0x4007, 0x403e, 0x403f, 0x4040, 0x599a, 0x8000, 0xa665,
  0x2ab3, 0x403d, 0x403e, 0x403f, 0x599a, 0x6aab, 0x9554, 0xa665,
  0x2ae9, 0x403e, 0x403f, 0x5999, 0x6aab, 0x7fff, 0x9554, 0xa666,
  0x2aea, 0x403e, 0x5999, 0x6aaa, 0x7fff, 0x8000, 0x9555, 0xa666,
  0x2aea, 0x5998, 0x6aaa, 0x7ffe, 0x7fff, 0x8000, 0x9555, 0xa667,
  0x4444, 0x6aa9, 0x7ffe, 0x7fff, 0x8000, 0x8001, 0x9556, 0xbbbb,
  0x5555, 0x7ffd, 0x7ffe, 0x7fff, 0x8000, 0x8001, 0xaaaa, 0xcccc,
  0x6aa9, 0x7ffe, 0x7fff, 0x8000, 0x8001, 0x9556, 0xbbbb, 0xe626,
  0x6aaa, 0x7ffe, 0x7fff, 0x8000, 0x9555, 0xa667, 0xd515, 0xe627,
  0x6aaa, 0x7fff, 0x8000, 0x9555, 0xa666, 0xbfc1, 0xd516, 0xe627,
  0x6aab, 0x7fff, 0x9554, 0xa666, 0xbfc0, 0xbfc1, 0xd516, 0xe628,
  0x6aab, 0x9554, 0xa665, 0xbfc0, 0xbfc1, 0xbfc2, 0xd517, 0xe65e,
  0x8000, 0xa665, 0xbfbf, 0xbfc0, 0xbfc1, 0xbfc2, 0xd54d, 0xe665,
  0x9111, 0xbfbf, 0xbfc0, 0xbfc1, 0xbfc2, 0xbff9, 0xd554, 0xe665,
  0xaa6b, 0xbfbf, 0xbfc0, 0xbfc1, 0xbff8, 0xbfff, 0xd554, 0xe666,
  0xbfbf, 0xbfc0, 0xbfc1, 0xbff8, 0xbfff, 0xd554, 0xe666, 0x7fc0,
  0xbfc0, 0xbfc1, 0xbff8, 0xbfff, 0xc000, 0xd555, 0x6666, 0x7fc1,
  0xbfc0, 0xbff7, 0xbffe, 0xbfff, 0xc000, 0x5555, 0x6667, 0x7fc1,
  0xbff7, 0xbffe, 0xbfff, 0xc000, 0x4001, 0x5556, 0x6667, 0x7fc8,
  0xbffd, 0xbffe, 0xbfff, 0x4000, 0x4001, 0x5556, 0x666e, 0x7fff,
  0xbffe, 0xbfff, 0x4000, 0x4001, 0x4002, 0x555d, 0x66a5, 0x7fff,
  0xbffe, 0x3fff, 0x4000, 0x4001, 0x4009, 0x5594, 0x66a5, 0x8000,
  0x3fff, 0x4000, 0x4001, 0x4008, 0x403f, 0x5594, 0x66a6, 0x995a,
  0x3fff, 0x4000, 0x4008, 0x403f, 0x4040, 0x5595, 0x8000, 0xaa6b,
  0x4000, 0x4007, 0x403e, 0x403f, 0x4040, 0x6eef, 0x9111, 0xbfbf,
  0x4007, 0x403e, 0x403f, 0x4040, 0x599a, 0x8000, 0xa665, 0xbfbf,
  0x403d, 0x403e, 0x403f, 0x599a, 0x6aab, 0x9554, 0xa665, 0xbfc0,
  0x403e, 0x403f, 0x5999, 0x6aab, 0x7fff, 0x9554, 0xa666, 0xbfc0,
  0x403e, 0x5999, 0x6aaa, 0x7fff, 0x8000, 0x9555, 0xa666, 0xbfc1,
  0x5998, 0x6aaa, 0x7ffe, 0x7fff, 0x8000, 0x9555, 0xa667, 0xd515,
  0x6aa9, 0x7ffe, 0x7fff, 0x8000, 0x8001, 0x9556, 0xbbbb, 0xe626,
  0x7ffd, 0x7ffe, 0x7fff, 0x8000, 0x8001, 0xaaaa, 0xcccc, 0xff80,
  0x7ffe, 0x7fff, 0x8000, 0x8001, 0x9556, 0xbbbb, 0xe626, 0xff81,
  0x7ffe, 0x7fff, 0x8000, 0x9555, 0xa667, 0xd515, 0xe627, 0xff81,
  0x7fff, 0x8000, 0x9555, 0xa666, 0xbfc1, 0xd516, 0xe627, 0xff82,
  0x7fff, 0x9554, 0xa666, 0xbfc0, 0xbfc1, 0xd516, 0xe628, 0xffb8,
  0x9554, 0xa665, 0xbfc0, 0xbfc1, 0xbfc2, 0xd517, 0xe65e, 0xffbf,
  0xa665, 0xbfbf, 0xbfc0, 0xbfc1, 0xbfc2, 0xd54d, 0xe665, 0xffbf,
  0xbfbf, 0xbfc0, 0xbfc1, 0xbfc2, 0xbff9, 0xd554, 0xe665, 0xffc0,
  0xbfc0, 0xbfc1, 0xbfc2, 0xbff9, 0xd554, 0xe665, 0xffc0, 0x7fc1,
  0xbfc0, 0xbfc1, 0xbff8, 0xbfff, 0xd554, 0xe666, 0x7fc0, 0x7fc1,
  0xbfc1, 0xbff8, 0xbfff, 0xc000, 0xd555, 0x6666, 0x7fc1, 0x7fc2,
  0xbff7, 0xbffe, 0xbfff, 0xc000, 0x5555, 0x6667, 0x7fc1, 0x7fc9,
  0xbffe, 0xbfff, 0xc000, 0x4001, 0x5556, 0x6667, 0x7fc8, 0x7fff,
  0xbffe, 0xbfff, 0x4000, 0x4001, 0x5556, 0x666e, 0x7fff, 0x8000,
  0xbfff, 0x4000, 0x4001, 0x4002, 0x555d, 0x66a5, 0x7fff, 0x8000,
  0x3fff, 0x4000, 0x4001, 0x4009, 0x5594, 0x66a5, 0x8000, 0x995a,
  0x4000, 0x4001, 0x4008, 0x403f, 0x5594, 0x66a6, 0x995a, 0xaa6b,
  0x4000, 0x4008, 0x403f, 0x4040, 0x5595, 0x8000, 0xaa6b, 0xbfbf,
  0x4007, 0x403e, 0x403f, 0x4040, 0x6eef, 0x9111, 0xbfbf, 0xbfc0,
  0x403e, 0x403f, 0x4040, 0x599a, 0x8000, 0xa665, 0xbfbf, 0xbfc0,
  0x403e, 0x403f, 0x599a, 0x6aab, 0x9554, 0xa665, 0xbfc0, 0xbfc1,
  0x403f, 0x5999, 0x6aab, 0x7fff, 0x9554, 0xa666, 0xbfc0, 0xbfc1,
  0x5999, 0x6aaa, 0x7fff, 0x8000, 0x9555, 0xa666, 0xbfc1, 0xd516,
  0x6aaa, 0x7ffe, 0x7fff, 0x8000, 0x9555, 0xa667, 0xd515, 0xe627,
  0x7ffe, 0x7fff, 0x8000, 0x8001, 0x9556, 0xbbbb, 0xe626, 0xff81,
  0x7ffe, 0x7fff, 0x8000, 0x8001, 0xaaaa, 0xcccc, 0xff80, 0xff81,
  0x7fff, 0x8000, 0x8001, 0x9556, 0xbbbb, 0xe626, 0xff81, 0xff82,
  0x7fff, 0x8000, 0x9555, 0xa667, 0xd515, 0xe627, 0xff81, 0xff82,
  0x8000, 0x9555, 0xa666, 0xbfc1, 0xd516, 0xe627, 0xff82, 0xffb9,
  0x9554, 0xa666, 0xbfc0, 0xbfc1, 0xd516, 0xe628, 0xffb8, 0xffbf,
  0xa665, 0xbfc0, 0xbfc1, 0xbfc2, 0xd517, 0xe65e, 0xffbf, 0xffc0,
  0xbfbf, 0xbfc0, 0xbfc1, 0xbfc2, 0xd54d, 0xe665, 0xffbf, 0xffc0,
  0xbfc0, 0xbfc1, 0xbfc2, 0xd54d, 0xe665, 0xffbf, 0xffc0, 0x7fc1,
  0xbfc1, 0xbfc2, 0xbff9, 0xd554, 0xe665, 0xffc0, 0x7fc1, 0x7fc2,
  0xbfc1, 0xbff8, 0xbfff, 0xd554, 0xe666, 0x7fc0, 0x7fc1, 0x7fc2,
  0xbff8, 0xbfff, 0xc000, 0xd555, 0x6666, 0x7fc1, 0x7fc2, 0x7fc9,
  0xbffe, 0xbfff, 0xc000, 0x5555, 0x6667, 0x7fc1, 0x7fc9, 0x8000,
  0xbfff, 0xc000, 0x4001, 0x5556, 0x6667, 0x7fc8, 0x7fff, 0x8000,
  0xbfff, 0x4000, 0x4001, 0x5556, 0x666e, 0x7fff, 0x8000, 0x8001,
  0x4000, 0x4001, 0x4002, 0x555d, 0x66a5, 0x7fff, 0x8000, 0x995b,
  0x4000, 0x4001, 0x4009, 0x5594, 0x66a5, 0x8000, 0x995a, 0xaa6c,
  0x4001, 0x4008, 0x403f, 0x5594, 0x66a6, 0x995a, 0xaa6b, 0xbfc0,
  0x4008, 0x403f, 0x4040, 0x5595, 0x8000, 0xaa6b, 0xbfbf, 0xbfc0,
  0x403e, 0x403f, 0x4040, 0x6eef, 0x9111, 0xbfbf, 0xbfc0, 0xbfc1,
  0x403f, 0x4040, 0x599a, 0x8000, 0xa665, 0xbfbf, 0xbfc0, 0xbfc1,
  0x403f, 0x599a, 0x6aab, 0x9554, 0xa665, 0xbfc0, 0xbfc1, 0xbfc2,
  0x5999, 0x6aab, 0x7fff, 0x9554, 0xa666, 0xbfc0, 0xbfc1, 0xd516,
  0x6aaa, 0x7fff, 0x8000, 0x9555, 0xa666, 0xbfc1, 0xd516, 0xe627,
  0x7ffe, 0x7fff, 0x8000, 0x9555, 0xa667, 0xd515, 0xe627, 0xff81,
  0x7fff, 0x8000, 0x8001, 0x9556, 0xbbbb, 0xe626, 0xff81, 0xff82,
  0x7fff, 0x8000, 0x8001, 0xaaaa, 0xcccc, 0xff80, 0xff81, 0xff82,
  0x8000, 0x8001, 0x9556, 0xbbbb, 0xe626, 0xff81, 0xff82, 0xff83,
  0x8000, 0x9555, 0xa667, 0xd515, 0xe627, 0xff81, 0xff82, 0xffb9,
  0x9555, 0xa666, 0xbfc1, 0xd516, 0xe627, 0xff82, 0xffb9, 0xffc0,
  0xa666, 0xbfc0, 0xbfc1, 0xd516, 0xe628, 0xffb8, 0xffbf, 0xffc0,
  0xbfc0, 0xbfc1, 0xbfc2, 0xd517, 0xe65e, 0xffbf, 0xffc0, 0xffc1,
  0xbfc1, 0xbfc2, 0xd517, 0xe65e, 0xffbf, 0xffc0, 0xffc1, 0x7fc2,
  0xbfc1, 0xbfc2, 0xd54d, 0xe665, 0xffbf, 0xffc0, 0x7fc1, 0x7fc2,
  0xbfc2, 0xbff9, 0xd554, 0xe665, 0xffc0, 0x7fc1, 0x7fc2, 0x7fc3,
  0xbff8, 0xbfff, 0xd554, 0xe666, 0x7fc0, 0x7fc1, 0x7fc2, 0x7fca,
  0xbfff, 0xc000, 0xd555, 0x6666, 0x7fc1, 0x7fc2, 0x7fc9, 0x8000,
  0xbfff, 0xc000, 0x5555, 0x6667, 0x7fc1, 0x7fc9, 0x8000, 0x8001,
  0xc000, 0x4001, 0x5556, 0x6667, 0x7fc8, 0x7fff, 0x8000, 0x8001,
  0x4000, 0x4001, 0x5556, 0x666e, 0x7fff, 0x8000, 0x8001, 0x995b,
  0x4001, 0x4002, 0x555d, 0x66a5, 0x7fff, 0x8000, 0x995b, 0xaa6c,
  0x4001, 0x4009, 0x5594, 0x66a5, 0x8000, 0x995a, 0xaa6c, 0xbfc0,
  0x4008, 0x403f, 0x5594, 0x66a6, 0x995a, 0xaa6b, 0xbfc0, 0xbfc1,
  0x403f, 0x4040, 0x5595, 0x8000, 0xaa6b, 0xbfbf, 0xbfc0, 0xbfc1,
  0x403f, 0x4040, 0x6eef, 0x9111, 0xbfbf, 0xbfc0, 0xbfc1, 0xbfc2,
  0x4040, 0x599a, 0x8000, 0xa665, 0xbfbf, 0xbfc0, 0xbfc1, 0xbfc2,
  0x599a, 0x6aab, 0x9554, 0xa665, 0xbfc0, 0xbfc1, 0xbfc2, 0xd517,
  0x6aab, 0x7fff, 0x9554, 0xa666, 0xbfc0, 0xbfc1, 0xd516, 0xe628,
  0x7fff, 0x8000, 0x9555, 0xa666, 0xbfc1, 0xd516, 0xe627, 0xff82,
  0x7fff, 0x8000, 0x9555, 0xa667, 0xd515, 0xe627, 0xff81, 0xff82,
  0x8000, 0x8001, 0x9556, 0xbbbb, 0xe626, 0xff81, 0xff82, 0xff83,
  0x8000, 0x8001, 0xaaaa, 0xcccc, 0xff80, 0xff81, 0xff82, 0xff83,
  0x8001, 0x9556, 0xbbbb, 0xe626, 0xff81, 0xff82, 0xff83, 0xffba,
  0x9555, 0xa667, 0xd515, 0xe627, 0xff81, 0xff82, 0xffb9, 0xffc0,
  0xa666, 0xbfc1, 0xd516, 0xe627, 0xff82, 0xffb9, 0xffc0, 0xffc1,
  0xbfc0, 0xbfc1, 0xd516, 0xe628, 0xffb8, 0xffbf, 0xffc0, 0xffc1,
  0xbfc1, 0xd516, 0xe628, 0xffb8, 0xffbf, 0xffc0, 0xffc1, 0x7ff8,
  0xbfc2, 0xd517, 0xe65e, 0xffbf, 0xffc0, 0xffc1, 0x7fc2, 0x7ff9,
  0xbfc2, 0xd54d, 0xe665, 0xffbf, 0xffc0, 0x7fc1, 0x7fc2, 0x7ff9,
  0xbff9, 0xd554, 0xe665, 0xffc0, 0x7fc1, 0x7fc2, 0x7fc3, 0x8000,
  0xbfff, 0xd554, 0xe666, 0x7fc0, 0x7fc1, 0x7fc2, 0x7fca, 0x8037,
  0xc000, 0xd555, 0x6666, 0x7fc1, 0x7fc2, 0x7fc9, 0x8000, 0x8037,
  0xc000, 0x5555, 0x6667, 0x7fc1, 0x7fc9, 0x8000, 0x8001, 0x8038,
  0x4001, 0x5556, 0x6667, 0x7fc8, 0x7fff, 0x8000, 0x8001, 0x9992,
  0x4001, 0x5556, 0x666e, 0x7fff, 0x8000, 0x8001, 0x995b, 0xaaa3,
  0x4002, 0x555d, 0x66a5, 0x7fff, 0x8000, 0x995b, 0xaa6c, 0xbff7,
  0x4009, 0x5594, 0x66a5, 0x8000, 0x995a, 0xaa6c, 0xbfc0, 0xbff7,
  0x403f, 0x5594, 0x66a6, 0x995a, 0xaa6b, 0xbfc0, 0xbfc1, 0xbff8,
  0x4040, 0x5595, 0x8000, 0xaa6b, 0xbfbf, 0xbfc0, 0xbfc1, 0xbff8,
  0x4040, 0x6eef, 0x9111, 0xbfbf, 0xbfc0, 0xbfc1, 0xbfc2, 0xbff9,
  0x599a, 0x8000, 0xa665, 0xbfbf, 0xbfc0, 0xbfc1, 0xbfc2, 0xd54d,
  0x6aab, 0x9554, 0xa665, 0xbfc0, 0xbfc1, 0xbfc2, 0xd517, 0xe65e,
  0x7fff, 0x9554, 0xa666, 0xbfc0, 0xbfc1, 0xd516, 0xe628, 0xffb8,
  0x8000, 0x9555, 0xa666, 0xbfc1, 0xd516, 0xe627, 0xff82, 0xffb9,
  0x8000, 0x9555, 0xa667, 0xd515, 0xe627, 0xff81, 0xff82, 0xffb9,
  0x8001, 0x9556, 0xbbbb, 0xe626, 0xff81, 0xff82, 0xff83, 0xffba,
  0x8001, 0xaaaa, 0xcccc, 0xff80, 0xff81, 0xff82, 0xff83, 0xfff0,
  0x9556, 0xbbbb, 0xe626, 0xff81, 0xff82, 0xff83, 0xffba, 0xfff7,
  0xa667, 0xd515, 0xe627, 0xff81, 0xff82, 0xffb9, 0xffc0, 0xfff7,
  0xbfc1, 0xd516, 0xe627, 0xff82, 0xffb9, 0xffc0, 0xffc1, 0xfff8,
  0xd516, 0xe627, 0xff82, 0xffb9, 0xffc0, 0xffc1, 0xfff8, 0x7fff,
  0xd516, 0xe628, 0xffb8, 0xffbf, 0xffc0, 0xffc1, 0x7ff8, 0x7fff,
  0xd517, 0xe65e, 0xffbf, 0xffc0, 0xffc1, 0x7fc2, 0x7ff9, 0x8000,
  0xd54d, 0xe665, 0xffbf, 0xffc0, 0x7fc1, 0x7fc2, 0x7ff9, 0x8007,
  0xd554, 0xe665, 0xffc0, 0x7fc1, 0x7fc2, 0x7fc3, 0x8000, 0x803d,
  0xd554, 0xe666, 0x7fc0, 0x7fc1, 0x7fc2, 0x7fca, 0x8037, 0x803e,
  0xd555, 0x6666, 0x7fc1, 0x7fc2, 0x7fc9, 0x8000, 0x8037, 0x803e,
  0x5555, 0x6667, 0x7fc1, 0x7fc9, 0x8000, 0x8001, 0x8038, 0x9998,
  0x5556, 0x6667, 0x7fc8, 0x7fff, 0x8000, 0x8001, 0x9992, 0xaaa9,
  0x5556, 0x666e, 0x7fff, 0x8000, 0x8001, 0x995b, 0xaaa3, 0xbffd,
  0x555d, 0x66a5, 0x7fff, 0x8000, 0x995b, 0xaa6c, 0xbff7, 0xbffe,
  0x5594, 0x66a5, 0x8000, 0x995a, 0xaa6c, 0xbfc0, 0xbff7, 0xbffe,
  0x5594, 0x66a6, 0x995a, 0xaa6b, 0xbfc0, 0xbfc1, 0xbff8, 0xbfff,
  0x5595, 0x8000, 0xaa6b, 0xbfbf, 0xbfc0, 0xbfc1, 0xbff8, 0xbfff,
  0x6eef, 0x9111, 0xbfbf, 0xbfc0, 0xbfc1, 0xbfc2, 0xbff9, 0xd554,
  0x8000, 0xa665, 0xbfbf, 0xbfc0, 0xbfc1, 0xbfc2, 0xd54d, 0xe665,
  0x9554, 0xa665, 0xbfc0, 0xbfc1, 0xbfc2, 0xd517, 0xe65e, 0xffbf,
  0x9554, 0xa666, 0xbfc0, 0xbfc1, 0xd516, 0xe628, 0xffb8, 0xffbf,
  0x9555, 0xa666, 0xbfc1, 0xd516, 0xe627, 0xff82, 0xffb9, 0xffc0,
  0x9555, 0xa667, 0xd515, 0xe627, 0xff81, 0xff82, 0xffb9, 0xffc0,
  0x9556, 0xbbbb, 0xe626, 0xff81, 0xff82, 0xff83, 0xffba, 0xfff7,
  0xaaaa, 0xcccc, 0xff80, 0xff81, 0xff82, 0xff83, 0xfff0, 0xfffd,
  0xbbbb, 0xe626, 0xff81, 0xff82, 0xff83, 0xffba, 0xfff7, 0xfffe,
  0xd515, 0xe627, 0xff81, 0xff82, 0xffb9, 0xffc0, 0xfff7, 0xfffe,
  0xe627, 0xff81, 0xff82, 0xffb9, 0xffc0, 0xfff7, 0xfffe, 0x7fff,
  0xe627, 0xff82, 0xffb9, 0xffc0, 0xffc1, 0xfff8, 0x7fff, 0x8000,
  0xe628, 0xffb8, 0xffbf, 0xffc0, 0xffc1, 0x7ff8, 0x7fff, 0x8000,
  0xe65e, 0xffbf, 0xffc0, 0xffc1, 0x7fc2, 0x7ff9, 0x8000, 0x8007,
  0xe665, 0xffbf, 0xffc0, 0x7fc1, 0x7fc2, 0x7ff9, 0x8007, 0x803e,
  0xe665, 0xffc0, 0x7fc1, 0x7fc2, 0x7fc3, 0x8000, 0x803d, 0x803e,
  0xe666, 0x7fc0, 0x7fc1, 0x7fc2, 0x7fca, 0x8037, 0x803e, 0x803f,
  0x6666, 0x7fc1, 0x7fc2, 0x7fc9, 0x8000, 0x8037, 0x803e, 0x9999,
  0x6667, 0x7fc1, 0x7fc9, 0x8000, 0x8001, 0x8038, 0x9998, 0xaaaa,
  0x6667, 0x7fc8, 0x7fff, 0x8000, 0x8001, 0x9992, 0xaaa9, 0xbffe,
  0x666e, 0x7fff, 0x8000, 0x8001, 0x995b, 0xaaa3, 0xbffd, 0xbffe,
  0x66a5, 0x7fff, 0x8000, 0x995b, 0xaa6c, 0xbff7, 0xbffe, 0xbfff,
  0x66a5, 0x8000, 0x995a, 0xaa6c, 0xbfc0, 0xbff7, 0xbffe, 0xbfff,
  0x66a6, 0x995a, 0xaa6b, 0xbfc0, 0xbfc1, 0xbff8, 0xbfff, 0xc000,
  0x8000, 0xaa6b, 0xbfbf, 0xbfc0, 0xbfc1, 0xbff8, 0xbfff, 0xd554,
  0x9111, 0xbfbf, 0xbfc0, 0xbfc1, 0xbfc2, 0xbff9, 0xd554, 0xe665,
  0xa665, 0xbfbf, 0xbfc0, 0xbfc1, 0xbfc2, 0xd54d, 0xe665, 0xffbf,
  0xa665, 0xbfc0, 0xbfc1, 0xbfc2, 0xd517, 0xe65e, 0xffbf, 0xffc0,
  0xa666, 0xbfc0, 0xbfc1, 0xd516, 0xe628, 0xffb8, 0xffbf, 0xffc0,
  0xa666, 0xbfc1, 0xd516, 0xe627, 0xff82, 0xffb9, 0xffc0, 0xffc1,
  0xa667, 0xd515, 0xe627, 0xff81, 0xff82, 0xffb9, 0xffc0, 0xfff7,
  0xbbbb, 0xe626, 0xff81, 0xff82, 0xff83, 0xffba, 0xfff7, 0xfffe,
  0xcccc, 0xff80, 0xff81, 0xff82, 0xff83, 0xfff0, 0xfffd, 0xfffe,
  0xe626, 0xff81, 0xff82, 0xff83, 0xffba, 0xfff7, 0xfffe, 0xffff,
  0xff81, 0xff82, 0xff83, 0xffba, 0xfff7, 0xfffe, 0xffff, 0x8000,
  0xff81, 0xff82, 0xffb9, 0xffc0, 0xfff7, 0xfffe, 0x7fff, 0x8000,
  0xff82, 0xffb9, 0xffc0, 0xffc1, 0xfff8, 0x7fff, 0x8000, 0x8001,
  0xffb8, 0xffbf, 0xffc0, 0xffc1, 0x7ff8, 0x7fff, 0x8000, 0x8008,
  0xffbf, 0xffc0, 0xffc1, 0x7fc2, 0x7ff9, 0x8000, 0x8007, 0x803e,
  0xffbf, 0xffc0, 0x7fc1, 0x7fc2, 0x7ff9, 0x8007, 0x803e, 0x803f,
  0xffc0, 0x7fc1, 0x7fc2, 0x7fc3, 0x8000, 0x803d, 0x803e, 0x803f,
  0x7fc0, 0x7fc1, 0x7fc2, 0x7fca, 0x8037, 0x803e, 0x803f, 0x9999,
  0x7fc1, 0x7fc2, 0x7fc9, 0x8000, 0x8037, 0x803e, 0x9999, 0xaaaa,
  0x7fc1, 0x7fc9, 0x8000, 0x8001, 0x8038, 0x9998, 0xaaaa, 0xbffe,
  0x7fc8, 0x7fff, 0x8000, 0x8001, 0x9992, 0xaaa9, 0xbffe, 0xbfff,
  0x7fff, 0x8000, 0x8001, 0x995b, 0xaaa3, 0xbffd, 0xbffe, 0xbfff,
  0x7fff, 0x8000, 0x995b, 0xaa6c, 0xbff7, 0xbffe, 0xbfff, 0xc000,
  0x8000, 0x995a, 0xaa6c, 0xbfc0, 0xbff7, 0xbffe, 0xbfff, 0xc000,
  0x995a, 0xaa6b, 0xbfc0, 0xbfc1, 0xbff8, 0xbfff, 0xc000, 0xd555,
  0xaa6b, 0xbfbf, 0xbfc0, 0xbfc1, 0xbff8, 0xbfff, 0xd554, 0xe666,
  0xbfbf, 0xbfc0, 0xbfc1, 0xbfc2, 0xbff9, 0xd554, 0xe665, 0xffc0,
  0xbfbf, 0xbfc0, 0xbfc1, 0xbfc2, 0xd54d, 0xe665, 0xffbf, 0xffc0,
  0xbfc0, 0xbfc1, 0xbfc2, 0xd517, 0xe65e, 0xffbf, 0xffc0, 0xffc1,
  0xbfc0, 0xbfc1, 0xd516, 0xe628, 0xffb8, 0xffbf, 0xffc0, 0xffc1,
  0xbfc1, 0xd516, 0xe627, 0xff82, 0xffb9, 0xffc0, 0xffc1, 0xfff8,
  0xd515, 0xe627, 0xff81, 0xff82, 0xffb9, 0xffc0, 0xfff7, 0xfffe,
  0xe626, 0xff81, 0xff82, 0xff83, 0xffba, 0xfff7, 0xfffe, 0xffff,
  0xff80, 0xff81, 0xff82, 0xff83, 0xfff0, 0xfffd, 0xfffe, 0xffff,
};
const unsigned kExpectedCount_NEON_urhadd_8H = 576;

#endif  // VIXL_SIM_URHADD_8H_TRACE_AARCH64_H_
