(** types shared by the Xml and Dtd modules *)

type xml =
  | Element of (string * (string * string) list * xml list)
  | PCData of string

type dtd_child =
  | DTDTag of string
  | DTDPCData
  | DTDOptional of dtd_child
  | DTDZeroOrMore of dtd_child
  | DTDOneOrMore of dtd_child
  | DTDChoice of dtd_child list
  | DTDChildren of dtd_child list

type dtd_element_type = DTDEmpty | DTDAny | DTDChild of dtd_child

type dtd_attr_default =
  | DTDDefault of string
  | DTDRequired
  | DTDImplied
  | DTDFixed of string

type dtd_attr_type =
  | DTDCData
  | DTDNMToken
  | DTDEnum of string list
  | DTDID
  | DTDIDRef

type dtd_item =
  | DTDAttribute of string * string * dtd_attr_type * dtd_attr_default
  | DTDElement of string * dtd_element_type

type dtd = dtd_item list
