//-----------------------------------------------------------------------------
//  Copyright (C) 2002-2010 Thomas S. Ullrich 
//
//  This file is part of "xyscan".
//
//  This file may be used under the terms of the GNU General Public License.
//  This project is free software; you can redistribute it and/or modify it
//  under the terms of the GNU General Public License.
//  
//  Author: Thomas S. Ullrich
//  Last update: April 22, 2009
//-----------------------------------------------------------------------------
#include "xyscanStateMachine.h"

xyscanStateMachine::xyscanStateMachine() {clear();}

void xyscanStateMachine::clear()
{
    mScanErrorXSelected = false;
    mScanErrorYSelected = false;
    mErrorXScanPrepared = false;
    mErrorYScanPrepared = false;
    mXYScanDone = false;
    mScanXLeftDone = false;
    mScanXRightDone = false;
    mScanYLowerDone = false;
    mScanYUpperDone = false;
    mErrorXScanSetupRemoved = true;
    mErrorYScanSetupRemoved = true;
    mDataWritten = false;
}

bool xyscanStateMachine::allowKeyLeft()
{
    if (!mScanErrorXSelected && mScanErrorYSelected) {
        if (mDataWritten) return true;
        if (mXYScanDone)
            return false;
        else
            return true;
    }
    else if (mScanErrorXSelected && mScanErrorYSelected) {
        if (mDataWritten) return true;
        if (mScanXLeftDone && mScanXRightDone)
            return false;
        else
            return true;
    }
    else
        return true;
}

bool xyscanStateMachine::allowKeyRight()
{
    if (!mScanErrorXSelected && mScanErrorYSelected) {
        if (mDataWritten) return true;
        if (mXYScanDone)
            return false;
        else
            return true;
    }
    else if (mScanErrorXSelected && mScanErrorYSelected) {
        if (mDataWritten) return true;
        if (mScanXLeftDone && mScanXRightDone)
            return false;
        else
            return true;
    }
    else
        return true;
}

bool xyscanStateMachine::allowKeyUp()
{
    if (mScanErrorXSelected && !mScanErrorYSelected) {
        if (mDataWritten) return true;
        if (mXYScanDone)
            return false;
        else
            return true;
    }
    else if (mScanErrorXSelected && mScanErrorYSelected) {
        if (mDataWritten) return true;
        if (!mXYScanDone) return true;
        if (mScanXLeftDone && mScanXRightDone && mErrorXScanSetupRemoved)
            return true;
        else
            return false;
    }
    else
        return true;
}

bool xyscanStateMachine::allowKeyDown()
{
    if (mScanErrorXSelected && !mScanErrorYSelected) {
        if (mDataWritten) return true;
        if (mXYScanDone)
            return false;
        else
            return true;
    }
    else if (mScanErrorXSelected && mScanErrorYSelected) {
        if (mDataWritten) return true;
        if (!mXYScanDone) return true;
        if (mScanXLeftDone && mScanXRightDone && mErrorXScanSetupRemoved)
            return true;
        else
            return false;
    }
    return true;
}

bool xyscanStateMachine::allowXYScan()
{
    if (!mScanErrorXSelected && !mScanErrorYSelected)
        return true;
    else {
        if (mDataWritten) return true;
        if (mXYScanDone)
            return false;
        else
            return true;
    }
}

bool xyscanStateMachine::doPrepareErrorXScan()
{
    if (mScanErrorXSelected) {
        if (mDataWritten) return false;
        if (mXYScanDone && !mErrorXScanPrepared)
            return true;
        else
            return false;
    }
    else
        return false;
}

bool xyscanStateMachine::doPrepareErrorYScan()
{
    if (!mScanErrorXSelected && mScanErrorYSelected) {
        if (mDataWritten) return false;
        if (mXYScanDone && !mErrorYScanPrepared)
            return true;
        else
            return false;
    }
    else if (mScanErrorXSelected && mScanErrorYSelected) {
        if (mDataWritten) return false;
        if (!mErrorYScanPrepared && mScanXRightDone)
            return true;
        else
            return false;
    }
    else
        return false;
}

bool xyscanStateMachine::allowScanXLeft()
{
    if (mScanErrorXSelected && !mScanErrorYSelected) {
        if (mErrorXScanPrepared && !mScanXLeftDone)
            return true;
        else
            return false;
    }
    else if (mScanErrorXSelected && mScanErrorYSelected) {
        if (mErrorXScanPrepared && !mScanXLeftDone)
            return true;
        else
            return false;
    }
    else
        return false;
}

bool xyscanStateMachine::allowScanXRight()
{
    if (mScanErrorXSelected && !mScanErrorYSelected) {
        if (mErrorXScanPrepared && mScanXLeftDone && !mScanXRightDone)
            return true;
        else
            return false;
    }
    else if (mScanErrorXSelected && mScanErrorYSelected) {
        if (mErrorXScanPrepared && mScanXLeftDone && !mScanXRightDone)
            return true;
        else
            return false;
    }
    else
        return false;
}

bool xyscanStateMachine::allowScanYLower()
{
    if (!mScanErrorXSelected && mScanErrorYSelected) {
        if (mErrorYScanPrepared && !mScanYLowerDone)
            return true;
        else
            return false;
    }
    else if (mScanErrorXSelected && mScanErrorYSelected) {
        if (mErrorXScanSetupRemoved && mErrorYScanPrepared && !mScanYLowerDone)
            return true;
        else
            return false;
    }
    else
        return false;
}

bool xyscanStateMachine::allowScanYUpper()
{
    if (!mScanErrorXSelected && mScanErrorYSelected) {
        if (mErrorYScanPrepared && mScanYLowerDone && !mScanYUpperDone)
            return true;
        else
            return false;
    }
    else if (mScanErrorXSelected && mScanErrorYSelected) {
        if (!mScanYUpperDone && mScanYLowerDone)
            return true;
        else
            return false;
    }
    else
        return false;
}

bool xyscanStateMachine::removeErrorXScanSetup()
{
    if (mScanErrorXSelected && !mScanErrorYSelected) {
        if (mScanXRightDone && !mDataWritten)
            return true;
        else
            return false;
    }
    else if (mScanErrorXSelected && mScanErrorYSelected) {
        if (mScanXRightDone && !mScanYLowerDone && !mErrorXScanSetupRemoved)
            return true;
        else
            return false;
    }
    else
        return false;
}

bool xyscanStateMachine::removeErrorYScanSetup()
{
    if (!mScanErrorXSelected && mScanErrorYSelected) {
        if (mScanYUpperDone && !mDataWritten)
            return true;
        else
            return false;
    }
    else if (mScanErrorXSelected && mScanErrorYSelected) {
        if (mScanYUpperDone && !mErrorYScanSetupRemoved)
            return true;
        else
            return false;
    }
    else
        return false;
}

bool xyscanStateMachine::enableSettingsMenu()
{
    if (mScanErrorYSelected) {
        if (mScanYUpperDone && !mDataWritten)
            return true;
        else
            return false;
    }
    else {
        if (mScanErrorXSelected) {
            if (mScanXRightDone && !mDataWritten)
                return true;
            else
                return false;
        }
        else
            return false;
    }
}

bool xyscanStateMachine::disableSettingsMenu()
{
    if (mScanErrorXSelected) {
        if (mXYScanDone && !mDataWritten)
            return true;
        else
            return false;
    }
    else {
        if (mScanErrorYSelected) {
            if (mXYScanDone && !mDataWritten)
                return true;
            else
                return false;
        }
        else
            return false;
    }
}

bool xyscanStateMachine::allowWriteXY()
{
    if (!mScanErrorXSelected && !mScanErrorYSelected)
        return true;
    else
        return false;
}

bool xyscanStateMachine::allowWriteXYErrorX()
{
    if (mScanErrorXSelected && !mScanErrorYSelected) {
        if (mScanXRightDone && !mDataWritten)
            return true;
        else
            return false;
    }
    else
        return false;
}

bool xyscanStateMachine::allowWriteXYErrorY()
{
    if (!mScanErrorXSelected && mScanErrorYSelected) {
        if (mScanYUpperDone && !mDataWritten)
            return true;
        else
            return false;
    }
    else
        return false;
}

bool xyscanStateMachine::allowWriteXYErrorXErrorY()
{
    if (mScanErrorXSelected && mScanErrorYSelected) {
        if (mScanYUpperDone && !mDataWritten)
            return true;
        else
            return false;
    }
    else
        return false;
}

void xyscanStateMachine::setScanErrorXSelected(bool val)     {mScanErrorXSelected = val;}
void xyscanStateMachine::setScanErrorYSelected(bool val)     {mScanErrorYSelected = val;}
void xyscanStateMachine::setErrorXScanPrepared(bool val)     {mErrorXScanPrepared = val; mErrorXScanSetupRemoved = false;}
void xyscanStateMachine::setErrorYScanPrepared(bool val)     {mErrorYScanPrepared = val; mErrorYScanSetupRemoved = false;}
void xyscanStateMachine::setXYScanDone(bool val)             {mXYScanDone = val;}
void xyscanStateMachine::setScanXLeftDone(bool val)          {mScanXLeftDone = val;}
void xyscanStateMachine::setScanXRightDone(bool val)         {mScanXRightDone = val;}
void xyscanStateMachine::setScanYLowerDone(bool val)         {mScanYLowerDone = val;}
void xyscanStateMachine::setScanYUpperDone(bool val)         {mScanYUpperDone = val;}
void xyscanStateMachine::setErrorXScanSetupRemoved(bool val) {mErrorXScanSetupRemoved = val;}
void xyscanStateMachine::setErrorYScanSetupRemoved(bool val) {mErrorYScanSetupRemoved = val;}
void xyscanStateMachine::setDataWritten(bool val)            {mDataWritten = val; if (mDataWritten) clear();}


