Yash: yet another shell
=======================

http://yash.osdn.jp/
This README is also available in [English](README.md).


このプログラムは C 言語 (C99: ISO/IEC 9899:1999, JIS X 3010:2003) で
書いた Unix 系 OS 用コマンドライン端末シェルです。Yash は世界で最も
正確な POSIX 規格準拠を目指しながらも、対話シェルおよびシェルスクリプト
実行プログラムとして便利な機能を備えています。

 * グローバルエイリアス
 * 配列
 * ソケットリダイレクト・パイプリダイレクト・プロセスリダイレクト
 * ブレース展開・拡張パス名展開
 * 数式展開での小数の計算
 * プロンプトコマンド
 * コマンドが見付からないときのハンドラー
 * コマンドライン補完 (100 個以上のコマンドに対する補完設定付き)
 * コマンド履歴に基づくコマンドラインの推定

このプログラムは GNU General Public License (Version 2) の元で自由に
再配布・変更などができます。その代わり、プログラムの利用は全て各自の
自己責任の下で行っていただくことになります。作者はプログラムの瑕疵に
対して一切責任を取りません。ライセンスの本文については [COPYING](COPYING)
ファイルを参照してください。

このプログラムは OSDN のプロジェクトの一つとして開発されています。
プロジェクト概要ページは <https://osdn.jp/projects/yash/> にあります。


## 開発状況

Yash は既に POSIX.1-2008 (IEEE Std 1003.1, 2016 Edition) を全てサポート
しています (ただし下記制限事項を除く)。

Yash は安定しています。バグ修正のためのバージョンアップはおおよそ三箇月
に一度リリースされます。変更履歴は [NEWS.ja](NEWS.ja) ファイルにあります。


## 要件

Software Development Utilities オプションと C-Language Development
Utilities オプションを備えた任意の POSIX.1-2001 環境でビルド・実行
できるはずです。

今のところ yash の動作は主に Fedora と macOS と Cygwin で検証されて
います。


## インストール

Yash をビルドしインストールする方法については [INSTALL.ja](INSTALL.ja)
ファイルを 参照してください。

インストール後、マニュアルは

    $ man yash

で参照できます。また <https://yash.osdn.jp/doc/ja/> でオンラインで読む
こともできます。


## 基本設定

以下は、yash を使い始めるにあたって有用な設定の手引きです。設定の詳細は
マニュアルを参照してください。

### 初期化スクリプト

Yash がログインシェルとして起動されたとき、`~/.yash_profile` を読み込み
ます。このファイルはシェルスクリプトとして実行されます。この中で
export コマンドを使うことで環境変数を設定できます。

Yash が対話シェルとして起動されたとき、(`~/.yash_profile` も読み込む場合
はその後で) `~/.yashrc` を読み込みます。この中でエイリアス、プロンプト、
コマンド行編集のキーバインド設定、コマンドが見付からないときのハンドラ
ー等を設定します。サンプルとして [share/initialization/sample](
share/initialization/sample) ファイルを参考に自分用の `~/.yashrc`
を設定してください。

### Yash をログインシェルにする

多くの Unix 系 OS では、ログインシェルとして使用可能なシェルは
`/etc/shells` ファイルに名前が挙げられている必要があります。このファイル
を編集し、yash へのパスがファイルに含まれているようにしてください。

その後、端末で `chsh` コマンドを実行してログインシェルを yash に変更し
てください。環境によってはこれ以外の方法でログインシェルを設定するよう
になっているかもしれません。詳しくはお使いの環境のマニュアルを参照くだ
さい。


## 実装上の注意事項

 * C 言語では、ナル文字は文字列の終わりを表します。そのため、入力した
   ファイルの内容や文字列にナル文字が含まれているとそれ以降の部分が正
   しく処理されなくなってしまいます。
 * ソース内の随所で GCC の拡張機能である `__attribute__` キーワードを使
   用しています。GCC 以外の環境ではプリプロセッサによって消去するよう
   にしていますが、`__attribute__` 識別子を他の用途で使用している処理系
   ではコンパイルに支障をきたすかもしれません。他にもいくつか '_' で始
   まる識別子を使用しているため、非常に特殊な環境では正しくコンパイル
   できないかもしれません。
 * いくつかのシグナルは特定の番号を持っていると仮定しています:
     SIGHUP=1 SIGINT=2 SIGQUIT=3 SIGABRT=6
     SIGKILL=9 SIGALRM=14 SIGTERM=15
 * POSIX は対話的でないシェルが SIGTTIN, SIGTTOU, SIGTSTP をデフォルト
   で無視・キャッチすることを禁じています。しかし yash はジョブ制御が
   有効な時は対話的でなくてもこれらのシグナルを無視します。
 * ファイルアクセス権フラグは特定の値を持っていると仮定しています:
   ```
   0400=user read    0200=user write   0100=user execute
   0040=group read   0020=group write  0010=group execute
   0004=other read   0002=other write  0001=other execute
   ```
 * POSIX ロケール以外のロケールでの文字クラスの分類は POSIX ロケールで
   の分類と上位互換であると仮定しています。
 * `-o nolog` オプションには対応していません。(無視されます)
 * POSIX によると、`PS1` 変数の値はパラメータ展開されることになっていま
   す。Yash ではさらに `PS1` 変数の値に対してコマンド置換と数式展開も行
   います。これは実装上の都合によるものです。
 * POSIX によると、コマンド `printf %c foo` は文字列 `foo` の最初のバ
   イトを出力することになっています。Yash では `foo` の最初の文字を出
   力するので、出力が複数バイトになることがあります。
 * トラップの中で `return` 組込みコマンドを実行しても、トラップの外で
   実行されている関数やスクリプトを中断・続行させることはできません。
   この挙動は厳密には POSIX に従っていませんが、予測可能で一貫性のある
   動作を保つためにこのようになっています。
 * パス名展開の結果はその時のロケールでの辞書順でソートされます。
   ロケールの順序定義が全順序でない場合、比較不可能な結果同士の順序は
   不定です。この挙動は厳密には POSIX に従っていませんが、POSIX
   ロケールでのバイト単位再比較がワイド文字では不可能なためこのように
   なっています。


## 既知の問題

 * 行連結を含む複雑な展開があると行番号 (`$LINENO`) が正しく計算されない
   ことがあります。
 * Solaris では一部のロケールで非 ASCII 文字が正しく扱われないことが
   あります。`config.h` ヘッダーファイルで `HAVE_WCSNRTOMBS` マクロの定義
   を削除してビルドすると問題を回避できるかもしれません。


## お知らせ

感想・提案・バグ報告等を歓迎します。ただし、全ての提案やバグ報告に
応じることを約束するものではありません。

 * [課題管理システム](https://osdn.net/projects/yash/ticket/)
 * [掲示板](https://osdn.net/projects/yash/forums/)

翻訳に興味がおありの場合は以下のページをご覧ください
[HowToTranslate](https://osdn.net/projects/yash/wiki/HowToTranslate)


----------------------
渡邊裕貴 <magicant@users.osdn.me>
