/*
    Copyright (c) 2007-2013 Contributors as noted in the AUTHORS file

    This file is part of 0MQ.

    0MQ is free software; you can redistribute it and/or modify it under
    the terms of the GNU Lesser General Public License as published by
    the Free Software Foundation; either version 3 of the License, or
    (at your option) any later version.

    0MQ is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#include "testutil.hpp"

int main (void)
{
    setup_test_environment();
    void *ctx = zmq_ctx_new ();
    assert (ctx);

    void *sb = zmq_socket (ctx, ZMQ_PAIR);
    assert (sb);
    int rc = zmq_bind (sb, "inproc://a");
    assert (rc == 0);

    void *sc = zmq_socket (ctx, ZMQ_PAIR);
    assert (sc);
    rc = zmq_connect (sc, "inproc://a");
    assert (rc == 0);
    
    bounce (sb, sc);
    
    // Test zmq_send_const
    rc = zmq_send_const (sb, "foo", 3, ZMQ_SNDMORE);
    assert (rc == 3);
    rc = zmq_send_const (sb, "foobar", 6, 0);
    assert (rc == 6);
    
    zmq_msg_t msg;
    rc = zmq_msg_init (&msg);
    assert (rc == 0);
    rc = zmq_msg_recv (&msg, sc, 0);
    assert (rc == 3);
    assert (zmq_msg_size (&msg) == 3);
    void* data = zmq_msg_data (&msg);
    assert (memcmp ("foo", data, 3) == 0);
    rc = zmq_msg_recv (&msg, sc, 0);
    assert (rc == 6);
    data = zmq_msg_data (&msg);
    assert (memcmp ("foobar", data, 6) == 0);
    
    // Cleanup

    rc = zmq_close (sc);
    assert (rc == 0);

    rc = zmq_close (sb);
    assert (rc == 0);

    rc = zmq_ctx_term (ctx);
    assert (rc == 0);

    return 0 ;
}
