#    Licensed under the Apache License, Version 2.0 (the "License"); you may
#    not use this file except in compliance with the License. You may obtain
#    a copy of the License at
#
#         http://www.apache.org/licenses/LICENSE-2.0
#
#    Unless required by applicable law or agreed to in writing, software
#    distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
#    WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
#    License for the specific language governing permissions and limitations
#    under the License.

from sqlalchemy import Boolean, Column, MetaData, Table, String


def upgrade(migrate_engine):
    """Add columns to the transfers table.

    Add source_project_id, destination_project_id and accepted columns to the
    transfers table to improve volume transfer records.
    """
    meta = MetaData(bind=migrate_engine)
    transfers = Table('transfers', meta, autoload=True)

    if not hasattr(transfers.c, 'source_project_id'):
        transfers.create_column(Column('source_project_id', String(255),
                                       nullable=True))

    if not hasattr(transfers.c, 'destination_project_id'):
        transfers.create_column(Column('destination_project_id', String(255),
                                       nullable=True))

    if not hasattr(transfers.c, 'accepted'):
        transfers.create_column(Column('accepted', Boolean, default=False))
