#!/bin/sh
# Ensure "install -C" works. (basic tests)

# Copyright (C) 2008-2013 Free Software Foundation, Inc.

# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.

# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.

# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

. "${srcdir=.}/tests/init.sh"; path_prepend_ ./src
print_ver_ ginstall
skip_if_setgid_

mode1=0644
mode2=0755
mode3=2755


echo test > a || framework_failure_
echo "'a' -> 'b'" > out_installed_first || framework_failure_
echo "removed 'b'
'a' -> 'b'" > out_installed_second || framework_failure_
: > out_empty || framework_failure_

# destination file does not exist
ginstall -Cv -m$mode1 a b > out || fail=1
compare out out_installed_first || fail=1

# destination file exists
ginstall -Cv -m$mode1 a b > out || fail=1
compare out out_empty || fail=1

# destination file exists (long option)
ginstall -v --compare -m$mode1 a b > out || fail=1
compare out out_empty || fail=1

# destination file exists but -C is not given
ginstall -v -m$mode1 a b > out || fail=1
compare out out_installed_second || fail=1

# option -C ignored if any non-permission mode should be set
ginstall -Cv -m$mode3 a b > out || fail=1
compare out out_installed_second || fail=1
ginstall -Cv -m$mode3 a b > out || fail=1
compare out out_installed_second || fail=1

# files are not regular files
ln -s a c || framework_failure_
ln -s b d || framework_failure_
ginstall -Cv -m$mode1 c d > out || fail=1
echo "removed 'd'
'c' -> 'd'" > out_installed_second_cd
compare out out_installed_second_cd || fail=1

# destination file exists but content differs
echo test1 > a || framework_failure_
ginstall -Cv -m$mode1 a b > out || fail=1
compare out out_installed_second || fail=1
ginstall -Cv -m$mode1 a b > out || fail=1
compare out out_empty || fail=1

# destination file exists but content differs (same size)
echo test2 > a || framework_failure_
ginstall -Cv -m$mode1 a b > out || fail=1
compare out out_installed_second || fail=1
ginstall -Cv -m$mode1 a b > out || fail=1
compare out out_empty || fail=1

# destination file exists but mode differs
ginstall -Cv -m$mode2 a b > out || fail=1
compare out out_installed_second || fail=1
ginstall -Cv -m$mode2 a b > out || fail=1
compare out out_empty || fail=1

# options -C and --preserve-timestamps are mutually exclusive
ginstall -C --preserve-timestamps a b && fail=1

# options -C and --strip are mutually exclusive
ginstall -C --strip --strip-program=echo a b && fail=1

Exit $fail
