static const char* op_c_source =
"/* This file is an image processing operation for GEGL                        \n"
" *                                                                            \n"
" * GEGL is free software; you can redistribute it and/or                      \n"
" * modify it under the terms of the GNU Lesser General Public                 \n"
" * License as published by the Free Software Foundation; either               \n"
" * version 3 of the License, or (at your option) any later version.           \n"
" *                                                                            \n"
" * GEGL is distributed in the hope that it will be useful,                    \n"
" * but WITHOUT ANY WARRANTY; without even the implied warranty of             \n"
" * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU          \n"
" * Lesser General Public License for more details.                            \n"
" *                                                                            \n"
" * You should have received a copy of the GNU Lesser General Public           \n"
" * License along with GEGL; if not, see <http://www.gnu.org/licenses/>.       \n"
" *                                                                            \n"
" * Copyright (C) 2013 Téo Mazars  <teo.mazars@ensimag.fr>                    \n"
" *                                                                            \n"
" * This operation is inspired by and uses parts of blur-motion.c              \n"
" * from GIMP 2.8.4:                                                           \n"
" *                                                                            \n"
" * Copyright (C) 1995 Spencer Kimball and Peter Mattis                        \n"
" * Copyright (C) 1996 Torsten Martinsen       <torsten@danbbs.dk>             \n"
" * Copyright (C) 1996 Federico Mena Quintero  <federico@nuclecu.unam.mx>      \n"
" * Copyright (C) 1996 Heinz W. Werntges       <quartic@polloux.fciencias.unam.mx>\n"
" * Copyright (C) 1997 Daniel Skarda           <0rfelyus@atrey.karlin.mff.cuni.cz>\n"
" * Copyright (C) 2007 Joerg Gittinger         <sw@gittingerbox.de>            \n"
" *                                                                            \n"
" * This operation is also inspired by GEGL's blur-motion-linear.c :           \n"
" *                                                                            \n"
" * Copyright (C) 2006 Øyvind Kolås  <pippin@gimp.org>                       \n"
" */                                                                           \n"
"                                                                              \n"
"#include \"config.h\"                                                         \n"
"                                                                              \n"
"#include <glib/gi18n-lib.h>                                                   \n"
"#include <math.h>                                                             \n"
"                                                                              \n"
"#ifdef GEGL_PROPERTIES                                                        \n"
"                                                                              \n"
"property_double (center_x, _(\"Center X\"), 0.5)                              \n"
"    ui_range    (0.0, 1.0)                                                    \n"
"    ui_meta     (\"unit\", \"relative-coordinate\")                           \n"
"    ui_meta     (\"axis\", \"x\")                                             \n"
"                                                                              \n"
"property_double (center_y, _(\"Center Y\"), 0.5)                              \n"
"    ui_range    (0.0, 1.0)                                                    \n"
"    ui_meta     (\"unit\", \"relative-coordinate\")                           \n"
"    ui_meta     (\"axis\", \"y\")                                             \n"
"                                                                              \n"
"property_double (factor, _(\"Blurring factor\"), 0.1)                         \n"
"    value_range (-10, 1.0)                                                    \n"
"    ui_range    (-0.5, 1.0)                                                   \n"
"    ui_gamma    (2.0)                                                         \n"
"                                                                              \n"
"#else                                                                         \n"
"                                                                              \n"
"#define GEGL_OP_AREA_FILTER                                                   \n"
"#define GEGL_OP_C_SOURCE motion-blur-zoom.c                                   \n"
"                                                                              \n"
"#include \"gegl-op.h\"                                                        \n"
"                                                                              \n"
"#define SQR(c) ((c) * (c))                                                    \n"
"                                                                              \n"
"#define MAX_NUM_IT 200                                                        \n"
"#define NOMINAL_NUM_IT 100                                                    \n"
"                                                                              \n"
"static void                                                                   \n"
"prepare (GeglOperation *operation)                                            \n"
"{                                                                             \n"
"  GeglOperationAreaFilter *op_area = GEGL_OPERATION_AREA_FILTER (operation);  \n"
"  GeglProperties          *o       = GEGL_PROPERTIES (operation);             \n"
"  GeglRectangle           *whole_region;                                      \n"
"                                                                              \n"
"  whole_region = gegl_operation_source_get_bounding_box (operation, \"input\");\n"
"                                                                              \n"
"  if (whole_region != NULL)                                                   \n"
"    {                                                                         \n"
"     gdouble center_x, center_y;                                              \n"
"                                                                              \n"
"     center_x = gegl_coordinate_relative_to_pixel (                           \n"
"                  o->center_x, whole_region->width);                          \n"
"     center_y = gegl_coordinate_relative_to_pixel (                           \n"
"                  o->center_y, whole_region->height);                         \n"
"                                                                              \n"
"      op_area->left = op_area->right                                          \n"
"        = MAX (fabs (whole_region->x - center_x),                             \n"
"               fabs (whole_region->width + whole_region->x - center_x)) * fabs (o->factor) +1;\n"
"                                                                              \n"
"      op_area->top = op_area->bottom                                          \n"
"        = MAX (fabs (whole_region->y - center_y),                             \n"
"               fabs (whole_region->height + whole_region->y - center_y)) * fabs (o->factor) +1;\n"
"    }                                                                         \n"
"  else                                                                        \n"
"    {                                                                         \n"
"      op_area->left   =                                                       \n"
"      op_area->right  =                                                       \n"
"      op_area->top    =                                                       \n"
"      op_area->bottom = 0;                                                    \n"
"    }                                                                         \n"
"                                                                              \n"
"  gegl_operation_set_format (operation, \"input\",  babl_format (\"RaGaBaA float\"));\n"
"  gegl_operation_set_format (operation, \"output\", babl_format (\"RaGaBaA float\"));\n"
"}                                                                             \n"
"                                                                              \n"
"static inline gfloat *                                                        \n"
"get_pixel_color (gfloat              *in_buf,                                 \n"
"                 const GeglRectangle *rect,                                   \n"
"                 gint                 x,                                      \n"
"                 gint                 y)                                      \n"
"{                                                                             \n"
"  gint ix = x - rect->x;                                                      \n"
"  gint iy = y - rect->y;                                                      \n"
"                                                                              \n"
"  ix = CLAMP (ix, 0, rect->width  - 1);                                       \n"
"  iy = CLAMP (iy, 0, rect->height - 1);                                       \n"
"                                                                              \n"
"  return &in_buf[(iy * rect->width + ix) * 4];                                \n"
"}                                                                             \n"
"                                                                              \n"
"                                                                              \n"
"static gboolean                                                               \n"
"process (GeglOperation       *operation,                                      \n"
"         GeglBuffer          *input,                                          \n"
"         GeglBuffer          *output,                                         \n"
"         const GeglRectangle *roi,                                            \n"
"         gint                 level)                                          \n"
"{                                                                             \n"
"  GeglOperationAreaFilter *op_area = GEGL_OPERATION_AREA_FILTER (operation);  \n"
"  GeglProperties          *o       = GEGL_PROPERTIES (operation);             \n"
"  gfloat                  *in_buf, *out_buf, *out_pixel;                      \n"
"  gint                     x, y;                                              \n"
"  GeglRectangle            src_rect;                                          \n"
"                                                                              \n"
"  GeglRectangle           *whole_region;                                      \n"
"  gdouble                  center_x, center_y;                                \n"
"                                                                              \n"
"  whole_region = gegl_operation_source_get_bounding_box (operation, \"input\");\n"
"  center_x = gegl_coordinate_relative_to_pixel (                              \n"
"                o->center_x, whole_region->width);                            \n"
"  center_y = gegl_coordinate_relative_to_pixel (                              \n"
"                o->center_y, whole_region->height);                           \n"
"                                                                              \n"
"  src_rect = *roi;                                                            \n"
"  src_rect.x -= op_area->left;                                                \n"
"  src_rect.y -= op_area->top;                                                 \n"
"  src_rect.width += op_area->left + op_area->right;                           \n"
"  src_rect.height += op_area->top + op_area->bottom;                          \n"
"                                                                              \n"
"  in_buf  = g_new  (gfloat, src_rect.width * src_rect.height * 4);            \n"
"  out_buf = g_new0 (gfloat, roi->width * roi->height * 4);                    \n"
"  out_pixel = out_buf;                                                        \n"
"                                                                              \n"
"  gegl_buffer_get (input, &src_rect, 1.0, babl_format (\"RaGaBaA float\"),    \n"
"                   in_buf, GEGL_AUTO_ROWSTRIDE, GEGL_ABYSS_NONE);             \n"
"                                                                              \n"
"  for (y = roi->y; y < roi->height + roi->y; ++y)                             \n"
"    {                                                                         \n"
"      for (x = roi->x; x < roi->width + roi->x; ++x)                          \n"
"        {                                                                     \n"
"          gint c, i;                                                          \n"
"          gfloat dxx, dyy, ix, iy, inv_xy_len;                                \n"
"          gfloat sum[] = {0, 0, 0, 0};                                        \n"
"                                                                              \n"
"          gfloat x_start = x;                                                 \n"
"          gfloat y_start = y;                                                 \n"
"          gfloat x_end   = x + (center_x - (gfloat) x) * o->factor;           \n"
"          gfloat y_end   = y + (center_y - (gfloat) y) * o->factor;           \n"
"                                                                              \n"
"          gint dist = ceil (sqrt (SQR (x_end - x_start) + SQR (y_end - y_start)) +1);\n"
"                                                                              \n"
"          /* ensure quality when near the center or with small factor */      \n"
"          gint xy_len = MAX (dist, 3);                                        \n"
"                                                                              \n"
"          /* performance concern */                                           \n"
"          if (xy_len > NOMINAL_NUM_IT)                                        \n"
"            xy_len = MIN (NOMINAL_NUM_IT + (gint) sqrt (xy_len - NOMINAL_NUM_IT), MAX_NUM_IT);\n"
"                                                                              \n"
"          inv_xy_len = 1.0 / (gfloat) xy_len;                                 \n"
"                                                                              \n"
"          dxx = (x_end - x_start) * inv_xy_len;                               \n"
"          dyy = (y_end - y_start) * inv_xy_len;                               \n"
"                                                                              \n"
"          ix  = x_start;                                                      \n"
"          iy  = y_start;                                                      \n"
"                                                                              \n"
"          for (i = 0; i < xy_len; i++)                                        \n"
"            {                                                                 \n"
"              gfloat dx = ix - floor (ix);                                    \n"
"              gfloat dy = iy - floor (iy);                                    \n"
"                                                                              \n"
"              /* do bilinear interpolation to get a nice smooth result */     \n"
"              gfloat *pix0, *pix1, *pix2, *pix3;                              \n"
"              gfloat mixy0[4];                                                \n"
"              gfloat mixy1[4];                                                \n"
"                                                                              \n"
"              pix0 = get_pixel_color (in_buf, &src_rect, ix, iy);             \n"
"              pix1 = get_pixel_color (in_buf, &src_rect, ix+1, iy);           \n"
"              pix2 = get_pixel_color (in_buf, &src_rect, ix, iy+1);           \n"
"              pix3 = get_pixel_color (in_buf, &src_rect, ix+1, iy+1);         \n"
"                                                                              \n"
"              for (c = 0; c < 4; ++c)                                         \n"
"                {                                                             \n"
"                  mixy0[c] = dy * (pix2[c] - pix0[c]) + pix0[c];              \n"
"                  mixy1[c] = dy * (pix3[c] - pix1[c]) + pix1[c];              \n"
"                                                                              \n"
"                  sum[c] +=  dx * (mixy1[c] - mixy0[c]) + mixy0[c];           \n"
"                }                                                             \n"
"                                                                              \n"
"              ix += dxx;                                                      \n"
"              iy += dyy;                                                      \n"
"            }                                                                 \n"
"                                                                              \n"
"          for (c = 0; c < 4; ++c)                                             \n"
"            *out_pixel++ = sum[c] * inv_xy_len;                               \n"
"        }                                                                     \n"
"    }                                                                         \n"
"                                                                              \n"
"  gegl_buffer_set (output, roi, 0, babl_format (\"RaGaBaA float\"),           \n"
"                   out_buf, GEGL_AUTO_ROWSTRIDE);                             \n"
"                                                                              \n"
"  g_free (in_buf);                                                            \n"
"  g_free (out_buf);                                                           \n"
"                                                                              \n"
"  return  TRUE;                                                               \n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"gegl_op_class_init (GeglOpClass *klass)                                       \n"
"{                                                                             \n"
"  GeglOperationClass       *operation_class;                                  \n"
"  GeglOperationFilterClass *filter_class;                                     \n"
"                                                                              \n"
"  operation_class = GEGL_OPERATION_CLASS (klass);                             \n"
"  filter_class    = GEGL_OPERATION_FILTER_CLASS (klass);                      \n"
"                                                                              \n"
"  operation_class->prepare = prepare;                                         \n"
"  filter_class->process    = process;                                         \n"
"                                                                              \n"
"  gegl_operation_class_set_keys (operation_class,                             \n"
"      \"name\",               \"gegl:motion-blur-zoom\",                      \n"
"      \"title\",              _(\"Zooming Motion Blur\"),                     \n"
"      \"categories\",         \"blur\",                                       \n"
"      \"position-dependent\", \"true\",                                       \n"
"      \"license\",            \"GPL3+\",                                      \n"
"      \"description\", _(\"Zoom motion blur\"),                               \n"
"      NULL);                                                                  \n"
"}                                                                             \n"
"                                                                              \n"
"#endif                                                                        \n"
;
