Allows you to deploy gateway and back-end load-sharing clusters without the
need of load-balancers.
.PP
This match requires that all the nodes see the same packets. Thus, the cluster
match decides if this node has to handle a packet given the following options:
.TP
\fB\-\-cluster\-total\-nodes\fP \fInum\fP
Set number of total nodes in cluster.
.TP
[\fB!\fP] \fB\-\-cluster\-local\-node\fP \fInum\fP
Set the local node number ID.
.TP
[\fB!\fP] \fB\-\-cluster\-local\-nodemask\fP \fImask\fP
Set the local node number ID mask. You can use this option instead
of \fB\-\-cluster\-local\-node\fP.
.TP
\fB\-\-cluster\-hash\-seed\fP \fIvalue\fP
Set seed value of the Jenkins hash.
.PP
Example:
.IP
iptables \-A PREROUTING \-t mangle \-i eth1 \-m cluster
\-\-cluster\-total\-nodes 2 \-\-cluster\-local\-node 1
\-\-cluster\-hash\-seed 0xdeadbeef
\-j MARK \-\-set\-mark 0xffff
.IP
iptables \-A PREROUTING \-t mangle \-i eth2 \-m cluster
\-\-cluster\-total\-nodes 2 \-\-cluster\-local\-node 1
\-\-cluster\-hash\-seed 0xdeadbeef
\-j MARK \-\-set\-mark 0xffff
.IP
iptables \-A PREROUTING \-t mangle \-i eth1
\-m mark ! \-\-mark 0xffff \-j DROP
.IP
iptables \-A PREROUTING \-t mangle \-i eth2
\-m mark ! \-\-mark 0xffff \-j DROP
.PP
And the following commands to make all nodes see the same packets:
.IP
ip maddr add 01:00:5e:00:01:01 dev eth1
.IP
ip maddr add 01:00:5e:00:01:02 dev eth2
.IP
arptables \-A OUTPUT \-o eth1 \-\-h\-length 6
\-j mangle \-\-mangle\-mac\-s 01:00:5e:00:01:01
.IP
arptables \-A INPUT \-i eth1 \-\-h\-length 6
\-\-destination\-mac 01:00:5e:00:01:01
\-j mangle \-\-mangle\-mac\-d 00:zz:yy:xx:5a:27
.IP
arptables \-A OUTPUT \-o eth2 \-\-h\-length 6
\-j mangle \-\-mangle\-mac\-s 01:00:5e:00:01:02
.IP
arptables \-A INPUT \-i eth2 \-\-h\-length 6
\-\-destination\-mac 01:00:5e:00:01:02
\-j mangle \-\-mangle\-mac\-d 00:zz:yy:xx:5a:27
.PP
\fBNOTE\fP: the arptables commands above use mainstream syntax. If you
are using arptables-jf included in some RedHat, CentOS and Fedora
versions, you will hit syntax errors. Therefore, you'll have to adapt
these to the arptables-jf syntax to get them working.
.PP
In the case of TCP connections, pickup facility has to be disabled
to avoid marking TCP ACK packets coming in the reply direction as
valid.
.IP
echo 0 > /proc/sys/net/netfilter/nf_conntrack_tcp_loose
