; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt < %s -passes=instsimplify -S | FileCheck %s

declare i8 @llvm.smin.i8(i8, i8)
declare i8 @llvm.smax.i8(i8, i8)
declare i8 @llvm.umin.i8(i8, i8)
declare i8 @llvm.umax.i8(i8, i8)
declare <4 x i8> @llvm.smin.v4i8(<4 x i8>, <4 x i8>)
declare <4 x i8> @llvm.smax.v4i8(<4 x i8>, <4 x i8>)
declare <4 x i8> @llvm.umin.v4i8(<4 x i8>, <4 x i8>)
declare <4 x i8> @llvm.umax.v4i8(<4 x i8>, <4 x i8>)

; smin

define i8 @slt_xy_smin_fval(i8 %x, i8 %y) {
; CHECK-LABEL: @slt_xy_smin_fval(
; CHECK-NEXT:    [[M:%.*]] = call i8 @llvm.smin.i8(i8 [[X:%.*]], i8 [[Y:%.*]])
; CHECK-NEXT:    ret i8 [[M]]
;
  %i = icmp slt i8 %x, %y
  %m = call i8 @llvm.smin.i8(i8 %x, i8 %y)
  %r = select i1 %i, i8 %x, i8 %m
  ret i8 %r
}

define i8 @sle_xy_smin_fval(i8 %x, i8 %y) {
; CHECK-LABEL: @sle_xy_smin_fval(
; CHECK-NEXT:    [[M:%.*]] = call i8 @llvm.smin.i8(i8 [[Y:%.*]], i8 [[X:%.*]])
; CHECK-NEXT:    ret i8 [[M]]
;
  %i = icmp sle i8 %x, %y
  %m = call i8 @llvm.smin.i8(i8 %y, i8 %x)
  %r = select i1 %i, i8 %x, i8 %m
  ret i8 %r
}

define i8 @sgt_xy_smin_fval(i8 %x, i8 %y) {
; CHECK-LABEL: @sgt_xy_smin_fval(
; CHECK-NEXT:    ret i8 [[X:%.*]]
;
  %i = icmp sgt i8 %x, %y
  %m = call i8 @llvm.smin.i8(i8 %x, i8 %y)
  %r = select i1 %i, i8 %x, i8 %m
  ret i8 %r
}

define i8 @sge_xy_smin_fval(i8 %x, i8 %y) {
; CHECK-LABEL: @sge_xy_smin_fval(
; CHECK-NEXT:    ret i8 [[X:%.*]]
;
  %i = icmp sge i8 %x, %y
  %m = call i8 @llvm.smin.i8(i8 %y, i8 %x)
  %r = select i1 %i, i8 %x, i8 %m
  ret i8 %r
}

define i8 @ult_xy_smin_fval(i8 %x, i8 %y) {
; CHECK-LABEL: @ult_xy_smin_fval(
; CHECK-NEXT:    [[I:%.*]] = icmp ult i8 [[X:%.*]], [[Y:%.*]]
; CHECK-NEXT:    [[M:%.*]] = call i8 @llvm.smin.i8(i8 [[X]], i8 [[Y]])
; CHECK-NEXT:    [[R:%.*]] = select i1 [[I]], i8 [[X]], i8 [[M]]
; CHECK-NEXT:    ret i8 [[R]]
;
  %i = icmp ult i8 %x, %y
  %m = call i8 @llvm.smin.i8(i8 %x, i8 %y)
  %r = select i1 %i, i8 %x, i8 %m
  ret i8 %r
}

define i8 @ule_xy_smin_fval(i8 %x, i8 %y) {
; CHECK-LABEL: @ule_xy_smin_fval(
; CHECK-NEXT:    [[I:%.*]] = icmp ule i8 [[X:%.*]], [[Y:%.*]]
; CHECK-NEXT:    [[M:%.*]] = call i8 @llvm.smin.i8(i8 [[Y]], i8 [[X]])
; CHECK-NEXT:    [[R:%.*]] = select i1 [[I]], i8 [[X]], i8 [[M]]
; CHECK-NEXT:    ret i8 [[R]]
;
  %i = icmp ule i8 %x, %y
  %m = call i8 @llvm.smin.i8(i8 %y, i8 %x)
  %r = select i1 %i, i8 %x, i8 %m
  ret i8 %r
}

define i8 @ugt_xy_smin_fval(i8 %x, i8 %y) {
; CHECK-LABEL: @ugt_xy_smin_fval(
; CHECK-NEXT:    [[I:%.*]] = icmp ugt i8 [[X:%.*]], [[Y:%.*]]
; CHECK-NEXT:    [[M:%.*]] = call i8 @llvm.smin.i8(i8 [[X]], i8 [[Y]])
; CHECK-NEXT:    [[R:%.*]] = select i1 [[I]], i8 [[X]], i8 [[M]]
; CHECK-NEXT:    ret i8 [[R]]
;
  %i = icmp ugt i8 %x, %y
  %m = call i8 @llvm.smin.i8(i8 %x, i8 %y)
  %r = select i1 %i, i8 %x, i8 %m
  ret i8 %r
}

define i8 @uge_xy_smin_fval(i8 %x, i8 %y) {
; CHECK-LABEL: @uge_xy_smin_fval(
; CHECK-NEXT:    [[I:%.*]] = icmp uge i8 [[X:%.*]], [[Y:%.*]]
; CHECK-NEXT:    [[M:%.*]] = call i8 @llvm.smin.i8(i8 [[Y]], i8 [[X]])
; CHECK-NEXT:    [[R:%.*]] = select i1 [[I]], i8 [[X]], i8 [[M]]
; CHECK-NEXT:    ret i8 [[R]]
;
  %i = icmp uge i8 %x, %y
  %m = call i8 @llvm.smin.i8(i8 %y, i8 %x)
  %r = select i1 %i, i8 %x, i8 %m
  ret i8 %r
}

define i8 @eq_xy_smin_fval(i8 %x, i8 %y) {
; CHECK-LABEL: @eq_xy_smin_fval(
; CHECK-NEXT:    [[M:%.*]] = call i8 @llvm.smin.i8(i8 [[X:%.*]], i8 [[Y:%.*]])
; CHECK-NEXT:    ret i8 [[M]]
;
  %i = icmp eq i8 %x, %y
  %m = call i8 @llvm.smin.i8(i8 %x, i8 %y)
  %r = select i1 %i, i8 %x, i8 %m
  ret i8 %r
}

define i8 @ne_xy_smin_fval(i8 %x, i8 %y) {
; CHECK-LABEL: @ne_xy_smin_fval(
; CHECK-NEXT:    ret i8 [[X:%.*]]
;
  %i = icmp ne i8 %x, %y
  %m = call i8 @llvm.smin.i8(i8 %y, i8 %x)
  %r = select i1 %i, i8 %x, i8 %m
  ret i8 %r
}

; swap icmp operands

define i8 @slt_yx_smin_fval(i8 %x, i8 %y) {
; CHECK-LABEL: @slt_yx_smin_fval(
; CHECK-NEXT:    ret i8 [[X:%.*]]
;
  %i = icmp slt i8 %y, %x
  %m = call i8 @llvm.smin.i8(i8 %x, i8 %y)
  %r = select i1 %i, i8 %x, i8 %m
  ret i8 %r
}

define i8 @sle_yx_smin_fval(i8 %x, i8 %y) {
; CHECK-LABEL: @sle_yx_smin_fval(
; CHECK-NEXT:    ret i8 [[X:%.*]]
;
  %i = icmp sle i8 %y, %x
  %m = call i8 @llvm.smin.i8(i8 %y, i8 %x)
  %r = select i1 %i, i8 %x, i8 %m
  ret i8 %r
}

define i8 @sgt_yx_smin_fval(i8 %x, i8 %y) {
; CHECK-LABEL: @sgt_yx_smin_fval(
; CHECK-NEXT:    [[M:%.*]] = call i8 @llvm.smin.i8(i8 [[X:%.*]], i8 [[Y:%.*]])
; CHECK-NEXT:    ret i8 [[M]]
;
  %i = icmp sgt i8 %y, %x
  %m = call i8 @llvm.smin.i8(i8 %x, i8 %y)
  %r = select i1 %i, i8 %x, i8 %m
  ret i8 %r
}

define i8 @sge_yx_smin_fval(i8 %x, i8 %y) {
; CHECK-LABEL: @sge_yx_smin_fval(
; CHECK-NEXT:    [[M:%.*]] = call i8 @llvm.smin.i8(i8 [[Y:%.*]], i8 [[X:%.*]])
; CHECK-NEXT:    ret i8 [[M]]
;
  %i = icmp sge i8 %y, %x
  %m = call i8 @llvm.smin.i8(i8 %y, i8 %x)
  %r = select i1 %i, i8 %x, i8 %m
  ret i8 %r
}

define i8 @ult_yx_smin_fval(i8 %x, i8 %y) {
; CHECK-LABEL: @ult_yx_smin_fval(
; CHECK-NEXT:    [[I:%.*]] = icmp ult i8 [[Y:%.*]], [[X:%.*]]
; CHECK-NEXT:    [[M:%.*]] = call i8 @llvm.smin.i8(i8 [[X]], i8 [[Y]])
; CHECK-NEXT:    [[R:%.*]] = select i1 [[I]], i8 [[X]], i8 [[M]]
; CHECK-NEXT:    ret i8 [[R]]
;
  %i = icmp ult i8 %y, %x
  %m = call i8 @llvm.smin.i8(i8 %x, i8 %y)
  %r = select i1 %i, i8 %x, i8 %m
  ret i8 %r
}

define i8 @ule_yx_smin_fval(i8 %x, i8 %y) {
; CHECK-LABEL: @ule_yx_smin_fval(
; CHECK-NEXT:    [[I:%.*]] = icmp ule i8 [[Y:%.*]], [[X:%.*]]
; CHECK-NEXT:    [[M:%.*]] = call i8 @llvm.smin.i8(i8 [[Y]], i8 [[X]])
; CHECK-NEXT:    [[R:%.*]] = select i1 [[I]], i8 [[X]], i8 [[M]]
; CHECK-NEXT:    ret i8 [[R]]
;
  %i = icmp ule i8 %y, %x
  %m = call i8 @llvm.smin.i8(i8 %y, i8 %x)
  %r = select i1 %i, i8 %x, i8 %m
  ret i8 %r
}

define i8 @ugt_yx_smin_fval(i8 %x, i8 %y) {
; CHECK-LABEL: @ugt_yx_smin_fval(
; CHECK-NEXT:    [[I:%.*]] = icmp ugt i8 [[Y:%.*]], [[X:%.*]]
; CHECK-NEXT:    [[M:%.*]] = call i8 @llvm.smin.i8(i8 [[X]], i8 [[Y]])
; CHECK-NEXT:    [[R:%.*]] = select i1 [[I]], i8 [[X]], i8 [[M]]
; CHECK-NEXT:    ret i8 [[R]]
;
  %i = icmp ugt i8 %y, %x
  %m = call i8 @llvm.smin.i8(i8 %x, i8 %y)
  %r = select i1 %i, i8 %x, i8 %m
  ret i8 %r
}

define i8 @uge_yx_smin_fval(i8 %x, i8 %y) {
; CHECK-LABEL: @uge_yx_smin_fval(
; CHECK-NEXT:    [[I:%.*]] = icmp uge i8 [[Y:%.*]], [[X:%.*]]
; CHECK-NEXT:    [[M:%.*]] = call i8 @llvm.smin.i8(i8 [[Y]], i8 [[X]])
; CHECK-NEXT:    [[R:%.*]] = select i1 [[I]], i8 [[X]], i8 [[M]]
; CHECK-NEXT:    ret i8 [[R]]
;
  %i = icmp uge i8 %y, %x
  %m = call i8 @llvm.smin.i8(i8 %y, i8 %x)
  %r = select i1 %i, i8 %x, i8 %m
  ret i8 %r
}

define i8 @eq_yx_smin_fval(i8 %x, i8 %y) {
; CHECK-LABEL: @eq_yx_smin_fval(
; CHECK-NEXT:    [[M:%.*]] = call i8 @llvm.smin.i8(i8 [[X:%.*]], i8 [[Y:%.*]])
; CHECK-NEXT:    ret i8 [[M]]
;
  %i = icmp eq i8 %y, %x
  %m = call i8 @llvm.smin.i8(i8 %x, i8 %y)
  %r = select i1 %i, i8 %x, i8 %m
  ret i8 %r
}

define i8 @ne_yx_smin_fval(i8 %x, i8 %y) {
; CHECK-LABEL: @ne_yx_smin_fval(
; CHECK-NEXT:    ret i8 [[X:%.*]]
;
  %i = icmp ne i8 %y, %x
  %m = call i8 @llvm.smin.i8(i8 %y, i8 %x)
  %r = select i1 %i, i8 %x, i8 %m
  ret i8 %r
}

; swap select operands

define i8 @slt_xy_smin_tval(i8 %x, i8 %y) {
; CHECK-LABEL: @slt_xy_smin_tval(
; CHECK-NEXT:    ret i8 [[X:%.*]]
;
  %i = icmp slt i8 %x, %y
  %m = call i8 @llvm.smin.i8(i8 %x, i8 %y)
  %r = select i1 %i, i8 %m, i8 %x
  ret i8 %r
}

define i8 @sle_xy_smin_tval(i8 %x, i8 %y) {
; CHECK-LABEL: @sle_xy_smin_tval(
; CHECK-NEXT:    ret i8 [[X:%.*]]
;
  %i = icmp sle i8 %x, %y
  %m = call i8 @llvm.smin.i8(i8 %y, i8 %x)
  %r = select i1 %i, i8 %m, i8 %x
  ret i8 %r
}

define i8 @sgt_xy_smin_tval(i8 %x, i8 %y) {
; CHECK-LABEL: @sgt_xy_smin_tval(
; CHECK-NEXT:    [[M:%.*]] = call i8 @llvm.smin.i8(i8 [[X:%.*]], i8 [[Y:%.*]])
; CHECK-NEXT:    ret i8 [[M]]
;
  %i = icmp sgt i8 %x, %y
  %m = call i8 @llvm.smin.i8(i8 %x, i8 %y)
  %r = select i1 %i, i8 %m, i8 %x
  ret i8 %r
}

define i8 @sge_xy_smin_tval(i8 %x, i8 %y) {
; CHECK-LABEL: @sge_xy_smin_tval(
; CHECK-NEXT:    [[M:%.*]] = call i8 @llvm.smin.i8(i8 [[Y:%.*]], i8 [[X:%.*]])
; CHECK-NEXT:    ret i8 [[M]]
;
  %i = icmp sge i8 %x, %y
  %m = call i8 @llvm.smin.i8(i8 %y, i8 %x)
  %r = select i1 %i, i8 %m, i8 %x
  ret i8 %r
}

define i8 @ult_xy_smin_tval(i8 %x, i8 %y) {
; CHECK-LABEL: @ult_xy_smin_tval(
; CHECK-NEXT:    [[I:%.*]] = icmp ult i8 [[X:%.*]], [[Y:%.*]]
; CHECK-NEXT:    [[M:%.*]] = call i8 @llvm.smin.i8(i8 [[X]], i8 [[Y]])
; CHECK-NEXT:    [[R:%.*]] = select i1 [[I]], i8 [[M]], i8 [[X]]
; CHECK-NEXT:    ret i8 [[R]]
;
  %i = icmp ult i8 %x, %y
  %m = call i8 @llvm.smin.i8(i8 %x, i8 %y)
  %r = select i1 %i, i8 %m, i8 %x
  ret i8 %r
}

define i8 @ule_xy_smin_tval(i8 %x, i8 %y) {
; CHECK-LABEL: @ule_xy_smin_tval(
; CHECK-NEXT:    [[I:%.*]] = icmp ule i8 [[X:%.*]], [[Y:%.*]]
; CHECK-NEXT:    [[M:%.*]] = call i8 @llvm.smin.i8(i8 [[Y]], i8 [[X]])
; CHECK-NEXT:    [[R:%.*]] = select i1 [[I]], i8 [[M]], i8 [[X]]
; CHECK-NEXT:    ret i8 [[R]]
;
  %i = icmp ule i8 %x, %y
  %m = call i8 @llvm.smin.i8(i8 %y, i8 %x)
  %r = select i1 %i, i8 %m, i8 %x
  ret i8 %r
}

define i8 @ugt_xy_smin_tval(i8 %x, i8 %y) {
; CHECK-LABEL: @ugt_xy_smin_tval(
; CHECK-NEXT:    [[I:%.*]] = icmp ugt i8 [[X:%.*]], [[Y:%.*]]
; CHECK-NEXT:    [[M:%.*]] = call i8 @llvm.smin.i8(i8 [[X]], i8 [[Y]])
; CHECK-NEXT:    [[R:%.*]] = select i1 [[I]], i8 [[M]], i8 [[X]]
; CHECK-NEXT:    ret i8 [[R]]
;
  %i = icmp ugt i8 %x, %y
  %m = call i8 @llvm.smin.i8(i8 %x, i8 %y)
  %r = select i1 %i, i8 %m, i8 %x
  ret i8 %r
}

define i8 @uge_xy_smin_tval(i8 %x, i8 %y) {
; CHECK-LABEL: @uge_xy_smin_tval(
; CHECK-NEXT:    [[I:%.*]] = icmp uge i8 [[X:%.*]], [[Y:%.*]]
; CHECK-NEXT:    [[M:%.*]] = call i8 @llvm.smin.i8(i8 [[Y]], i8 [[X]])
; CHECK-NEXT:    [[R:%.*]] = select i1 [[I]], i8 [[M]], i8 [[X]]
; CHECK-NEXT:    ret i8 [[R]]
;
  %i = icmp uge i8 %x, %y
  %m = call i8 @llvm.smin.i8(i8 %y, i8 %x)
  %r = select i1 %i, i8 %m, i8 %x
  ret i8 %r
}

define i8 @eq_xy_smin_tval(i8 %x, i8 %y) {
; CHECK-LABEL: @eq_xy_smin_tval(
; CHECK-NEXT:    ret i8 [[X:%.*]]
;
  %i = icmp eq i8 %x, %y
  %m = call i8 @llvm.smin.i8(i8 %x, i8 %y)
  %r = select i1 %i, i8 %m, i8 %x
  ret i8 %r
}

define i8 @ne_xy_smin_tval(i8 %x, i8 %y) {
; CHECK-LABEL: @ne_xy_smin_tval(
; CHECK-NEXT:    [[M:%.*]] = call i8 @llvm.smin.i8(i8 [[Y:%.*]], i8 [[X:%.*]])
; CHECK-NEXT:    ret i8 [[M]]
;
  %i = icmp ne i8 %x, %y
  %m = call i8 @llvm.smin.i8(i8 %y, i8 %x)
  %r = select i1 %i, i8 %m, i8 %x
  ret i8 %r
}

; swap icmp and select operands

define i8 @slt_yx_smin_tval(i8 %x, i8 %y) {
; CHECK-LABEL: @slt_yx_smin_tval(
; CHECK-NEXT:    [[M:%.*]] = call i8 @llvm.smin.i8(i8 [[X:%.*]], i8 [[Y:%.*]])
; CHECK-NEXT:    ret i8 [[M]]
;
  %i = icmp slt i8 %y, %x
  %m = call i8 @llvm.smin.i8(i8 %x, i8 %y)
  %r = select i1 %i, i8 %m, i8 %x
  ret i8 %r
}

define i8 @sle_yx_smin_tval(i8 %x, i8 %y) {
; CHECK-LABEL: @sle_yx_smin_tval(
; CHECK-NEXT:    [[M:%.*]] = call i8 @llvm.smin.i8(i8 [[Y:%.*]], i8 [[X:%.*]])
; CHECK-NEXT:    ret i8 [[M]]
;
  %i = icmp sle i8 %y, %x
  %m = call i8 @llvm.smin.i8(i8 %y, i8 %x)
  %r = select i1 %i, i8 %m, i8 %x
  ret i8 %r
}

define i8 @sgt_yx_smin_tval(i8 %x, i8 %y) {
; CHECK-LABEL: @sgt_yx_smin_tval(
; CHECK-NEXT:    ret i8 [[X:%.*]]
;
  %i = icmp sgt i8 %y, %x
  %m = call i8 @llvm.smin.i8(i8 %x, i8 %y)
  %r = select i1 %i, i8 %m, i8 %x
  ret i8 %r
}

define i8 @sge_yx_smin_tval(i8 %x, i8 %y) {
; CHECK-LABEL: @sge_yx_smin_tval(
; CHECK-NEXT:    ret i8 [[X:%.*]]
;
  %i = icmp sge i8 %y, %x
  %m = call i8 @llvm.smin.i8(i8 %y, i8 %x)
  %r = select i1 %i, i8 %m, i8 %x
  ret i8 %r
}

define i8 @ult_yx_smin_tval(i8 %x, i8 %y) {
; CHECK-LABEL: @ult_yx_smin_tval(
; CHECK-NEXT:    [[I:%.*]] = icmp ult i8 [[Y:%.*]], [[X:%.*]]
; CHECK-NEXT:    [[M:%.*]] = call i8 @llvm.smin.i8(i8 [[X]], i8 [[Y]])
; CHECK-NEXT:    [[R:%.*]] = select i1 [[I]], i8 [[M]], i8 [[X]]
; CHECK-NEXT:    ret i8 [[R]]
;
  %i = icmp ult i8 %y, %x
  %m = call i8 @llvm.smin.i8(i8 %x, i8 %y)
  %r = select i1 %i, i8 %m, i8 %x
  ret i8 %r
}

define i8 @ule_yx_smin_tval(i8 %x, i8 %y) {
; CHECK-LABEL: @ule_yx_smin_tval(
; CHECK-NEXT:    [[I:%.*]] = icmp ule i8 [[Y:%.*]], [[X:%.*]]
; CHECK-NEXT:    [[M:%.*]] = call i8 @llvm.smin.i8(i8 [[Y]], i8 [[X]])
; CHECK-NEXT:    [[R:%.*]] = select i1 [[I]], i8 [[M]], i8 [[X]]
; CHECK-NEXT:    ret i8 [[R]]
;
  %i = icmp ule i8 %y, %x
  %m = call i8 @llvm.smin.i8(i8 %y, i8 %x)
  %r = select i1 %i, i8 %m, i8 %x
  ret i8 %r
}

define i8 @ugt_yx_smin_tval(i8 %x, i8 %y) {
; CHECK-LABEL: @ugt_yx_smin_tval(
; CHECK-NEXT:    [[I:%.*]] = icmp ugt i8 [[Y:%.*]], [[X:%.*]]
; CHECK-NEXT:    [[M:%.*]] = call i8 @llvm.smin.i8(i8 [[X]], i8 [[Y]])
; CHECK-NEXT:    [[R:%.*]] = select i1 [[I]], i8 [[M]], i8 [[X]]
; CHECK-NEXT:    ret i8 [[R]]
;
  %i = icmp ugt i8 %y, %x
  %m = call i8 @llvm.smin.i8(i8 %x, i8 %y)
  %r = select i1 %i, i8 %m, i8 %x
  ret i8 %r
}

define i8 @uge_yx_smin_tval(i8 %x, i8 %y) {
; CHECK-LABEL: @uge_yx_smin_tval(
; CHECK-NEXT:    [[I:%.*]] = icmp uge i8 [[Y:%.*]], [[X:%.*]]
; CHECK-NEXT:    [[M:%.*]] = call i8 @llvm.smin.i8(i8 [[Y]], i8 [[X]])
; CHECK-NEXT:    [[R:%.*]] = select i1 [[I]], i8 [[M]], i8 [[X]]
; CHECK-NEXT:    ret i8 [[R]]
;
  %i = icmp uge i8 %y, %x
  %m = call i8 @llvm.smin.i8(i8 %y, i8 %x)
  %r = select i1 %i, i8 %m, i8 %x
  ret i8 %r
}

define i8 @eq_yx_smin_tval(i8 %x, i8 %y) {
; CHECK-LABEL: @eq_yx_smin_tval(
; CHECK-NEXT:    ret i8 [[X:%.*]]
;
  %i = icmp eq i8 %y, %x
  %m = call i8 @llvm.smin.i8(i8 %x, i8 %y)
  %r = select i1 %i, i8 %m, i8 %x
  ret i8 %r
}

define i8 @ne_yx_smin_tval(i8 %x, i8 %y) {
; CHECK-LABEL: @ne_yx_smin_tval(
; CHECK-NEXT:    [[M:%.*]] = call i8 @llvm.smin.i8(i8 [[Y:%.*]], i8 [[X:%.*]])
; CHECK-NEXT:    ret i8 [[M]]
;
  %i = icmp ne i8 %y, %x
  %m = call i8 @llvm.smin.i8(i8 %y, i8 %x)
  %r = select i1 %i, i8 %m, i8 %x
  ret i8 %r
}

; smax

define i8 @slt_xy_smax_fval(i8 %x, i8 %y) {
; CHECK-LABEL: @slt_xy_smax_fval(
; CHECK-NEXT:    ret i8 [[X:%.*]]
;
  %i = icmp slt i8 %x, %y
  %m = call i8 @llvm.smax.i8(i8 %x, i8 %y)
  %r = select i1 %i, i8 %x, i8 %m
  ret i8 %r
}

define i8 @sle_xy_smax_fval(i8 %x, i8 %y) {
; CHECK-LABEL: @sle_xy_smax_fval(
; CHECK-NEXT:    ret i8 [[X:%.*]]
;
  %i = icmp sle i8 %x, %y
  %m = call i8 @llvm.smax.i8(i8 %y, i8 %x)
  %r = select i1 %i, i8 %x, i8 %m
  ret i8 %r
}

define i8 @sgt_xy_smax_fval(i8 %x, i8 %y) {
; CHECK-LABEL: @sgt_xy_smax_fval(
; CHECK-NEXT:    [[M:%.*]] = call i8 @llvm.smax.i8(i8 [[X:%.*]], i8 [[Y:%.*]])
; CHECK-NEXT:    ret i8 [[M]]
;
  %i = icmp sgt i8 %x, %y
  %m = call i8 @llvm.smax.i8(i8 %x, i8 %y)
  %r = select i1 %i, i8 %x, i8 %m
  ret i8 %r
}

define i8 @sge_xy_smax_fval(i8 %x, i8 %y) {
; CHECK-LABEL: @sge_xy_smax_fval(
; CHECK-NEXT:    [[M:%.*]] = call i8 @llvm.smax.i8(i8 [[Y:%.*]], i8 [[X:%.*]])
; CHECK-NEXT:    ret i8 [[M]]
;
  %i = icmp sge i8 %x, %y
  %m = call i8 @llvm.smax.i8(i8 %y, i8 %x)
  %r = select i1 %i, i8 %x, i8 %m
  ret i8 %r
}

define i8 @ult_xy_smax_fval(i8 %x, i8 %y) {
; CHECK-LABEL: @ult_xy_smax_fval(
; CHECK-NEXT:    [[I:%.*]] = icmp ult i8 [[X:%.*]], [[Y:%.*]]
; CHECK-NEXT:    [[M:%.*]] = call i8 @llvm.smax.i8(i8 [[X]], i8 [[Y]])
; CHECK-NEXT:    [[R:%.*]] = select i1 [[I]], i8 [[X]], i8 [[M]]
; CHECK-NEXT:    ret i8 [[R]]
;
  %i = icmp ult i8 %x, %y
  %m = call i8 @llvm.smax.i8(i8 %x, i8 %y)
  %r = select i1 %i, i8 %x, i8 %m
  ret i8 %r
}

define i8 @ule_xy_smax_fval(i8 %x, i8 %y) {
; CHECK-LABEL: @ule_xy_smax_fval(
; CHECK-NEXT:    [[I:%.*]] = icmp ule i8 [[X:%.*]], [[Y:%.*]]
; CHECK-NEXT:    [[M:%.*]] = call i8 @llvm.smax.i8(i8 [[Y]], i8 [[X]])
; CHECK-NEXT:    [[R:%.*]] = select i1 [[I]], i8 [[X]], i8 [[M]]
; CHECK-NEXT:    ret i8 [[R]]
;
  %i = icmp ule i8 %x, %y
  %m = call i8 @llvm.smax.i8(i8 %y, i8 %x)
  %r = select i1 %i, i8 %x, i8 %m
  ret i8 %r
}

define i8 @ugt_xy_smax_fval(i8 %x, i8 %y) {
; CHECK-LABEL: @ugt_xy_smax_fval(
; CHECK-NEXT:    [[I:%.*]] = icmp ugt i8 [[X:%.*]], [[Y:%.*]]
; CHECK-NEXT:    [[M:%.*]] = call i8 @llvm.smax.i8(i8 [[X]], i8 [[Y]])
; CHECK-NEXT:    [[R:%.*]] = select i1 [[I]], i8 [[X]], i8 [[M]]
; CHECK-NEXT:    ret i8 [[R]]
;
  %i = icmp ugt i8 %x, %y
  %m = call i8 @llvm.smax.i8(i8 %x, i8 %y)
  %r = select i1 %i, i8 %x, i8 %m
  ret i8 %r
}

define i8 @uge_xy_smax_fval(i8 %x, i8 %y) {
; CHECK-LABEL: @uge_xy_smax_fval(
; CHECK-NEXT:    [[I:%.*]] = icmp uge i8 [[X:%.*]], [[Y:%.*]]
; CHECK-NEXT:    [[M:%.*]] = call i8 @llvm.smax.i8(i8 [[Y]], i8 [[X]])
; CHECK-NEXT:    [[R:%.*]] = select i1 [[I]], i8 [[X]], i8 [[M]]
; CHECK-NEXT:    ret i8 [[R]]
;
  %i = icmp uge i8 %x, %y
  %m = call i8 @llvm.smax.i8(i8 %y, i8 %x)
  %r = select i1 %i, i8 %x, i8 %m
  ret i8 %r
}

define i8 @eq_xy_smax_fval(i8 %x, i8 %y) {
; CHECK-LABEL: @eq_xy_smax_fval(
; CHECK-NEXT:    [[M:%.*]] = call i8 @llvm.smax.i8(i8 [[X:%.*]], i8 [[Y:%.*]])
; CHECK-NEXT:    ret i8 [[M]]
;
  %i = icmp eq i8 %x, %y
  %m = call i8 @llvm.smax.i8(i8 %x, i8 %y)
  %r = select i1 %i, i8 %x, i8 %m
  ret i8 %r
}

define i8 @ne_xy_smax_fval(i8 %x, i8 %y) {
; CHECK-LABEL: @ne_xy_smax_fval(
; CHECK-NEXT:    ret i8 [[X:%.*]]
;
  %i = icmp ne i8 %x, %y
  %m = call i8 @llvm.smax.i8(i8 %y, i8 %x)
  %r = select i1 %i, i8 %x, i8 %m
  ret i8 %r
}

; swap icmp operands

define i8 @slt_yx_smax_fval(i8 %x, i8 %y) {
; CHECK-LABEL: @slt_yx_smax_fval(
; CHECK-NEXT:    [[M:%.*]] = call i8 @llvm.smax.i8(i8 [[X:%.*]], i8 [[Y:%.*]])
; CHECK-NEXT:    ret i8 [[M]]
;
  %i = icmp slt i8 %y, %x
  %m = call i8 @llvm.smax.i8(i8 %x, i8 %y)
  %r = select i1 %i, i8 %x, i8 %m
  ret i8 %r
}

define i8 @sle_yx_smax_fval(i8 %x, i8 %y) {
; CHECK-LABEL: @sle_yx_smax_fval(
; CHECK-NEXT:    [[M:%.*]] = call i8 @llvm.smax.i8(i8 [[Y:%.*]], i8 [[X:%.*]])
; CHECK-NEXT:    ret i8 [[M]]
;
  %i = icmp sle i8 %y, %x
  %m = call i8 @llvm.smax.i8(i8 %y, i8 %x)
  %r = select i1 %i, i8 %x, i8 %m
  ret i8 %r
}

define i8 @sgt_yx_smax_fval(i8 %x, i8 %y) {
; CHECK-LABEL: @sgt_yx_smax_fval(
; CHECK-NEXT:    ret i8 [[X:%.*]]
;
  %i = icmp sgt i8 %y, %x
  %m = call i8 @llvm.smax.i8(i8 %x, i8 %y)
  %r = select i1 %i, i8 %x, i8 %m
  ret i8 %r
}

define i8 @sge_yx_smax_fval(i8 %x, i8 %y) {
; CHECK-LABEL: @sge_yx_smax_fval(
; CHECK-NEXT:    ret i8 [[X:%.*]]
;
  %i = icmp sge i8 %y, %x
  %m = call i8 @llvm.smax.i8(i8 %y, i8 %x)
  %r = select i1 %i, i8 %x, i8 %m
  ret i8 %r
}

define i8 @ult_yx_smax_fval(i8 %x, i8 %y) {
; CHECK-LABEL: @ult_yx_smax_fval(
; CHECK-NEXT:    [[I:%.*]] = icmp ult i8 [[Y:%.*]], [[X:%.*]]
; CHECK-NEXT:    [[M:%.*]] = call i8 @llvm.smax.i8(i8 [[X]], i8 [[Y]])
; CHECK-NEXT:    [[R:%.*]] = select i1 [[I]], i8 [[X]], i8 [[M]]
; CHECK-NEXT:    ret i8 [[R]]
;
  %i = icmp ult i8 %y, %x
  %m = call i8 @llvm.smax.i8(i8 %x, i8 %y)
  %r = select i1 %i, i8 %x, i8 %m
  ret i8 %r
}

define i8 @ule_yx_smax_fval(i8 %x, i8 %y) {
; CHECK-LABEL: @ule_yx_smax_fval(
; CHECK-NEXT:    [[I:%.*]] = icmp ule i8 [[Y:%.*]], [[X:%.*]]
; CHECK-NEXT:    [[M:%.*]] = call i8 @llvm.smax.i8(i8 [[Y]], i8 [[X]])
; CHECK-NEXT:    [[R:%.*]] = select i1 [[I]], i8 [[X]], i8 [[M]]
; CHECK-NEXT:    ret i8 [[R]]
;
  %i = icmp ule i8 %y, %x
  %m = call i8 @llvm.smax.i8(i8 %y, i8 %x)
  %r = select i1 %i, i8 %x, i8 %m
  ret i8 %r
}

define i8 @ugt_yx_smax_fval(i8 %x, i8 %y) {
; CHECK-LABEL: @ugt_yx_smax_fval(
; CHECK-NEXT:    [[I:%.*]] = icmp ugt i8 [[Y:%.*]], [[X:%.*]]
; CHECK-NEXT:    [[M:%.*]] = call i8 @llvm.smax.i8(i8 [[X]], i8 [[Y]])
; CHECK-NEXT:    [[R:%.*]] = select i1 [[I]], i8 [[X]], i8 [[M]]
; CHECK-NEXT:    ret i8 [[R]]
;
  %i = icmp ugt i8 %y, %x
  %m = call i8 @llvm.smax.i8(i8 %x, i8 %y)
  %r = select i1 %i, i8 %x, i8 %m
  ret i8 %r
}

define i8 @uge_yx_smax_fval(i8 %x, i8 %y) {
; CHECK-LABEL: @uge_yx_smax_fval(
; CHECK-NEXT:    [[I:%.*]] = icmp uge i8 [[Y:%.*]], [[X:%.*]]
; CHECK-NEXT:    [[M:%.*]] = call i8 @llvm.smax.i8(i8 [[Y]], i8 [[X]])
; CHECK-NEXT:    [[R:%.*]] = select i1 [[I]], i8 [[X]], i8 [[M]]
; CHECK-NEXT:    ret i8 [[R]]
;
  %i = icmp uge i8 %y, %x
  %m = call i8 @llvm.smax.i8(i8 %y, i8 %x)
  %r = select i1 %i, i8 %x, i8 %m
  ret i8 %r
}

define i8 @eq_yx_smax_fval(i8 %x, i8 %y) {
; CHECK-LABEL: @eq_yx_smax_fval(
; CHECK-NEXT:    [[M:%.*]] = call i8 @llvm.smax.i8(i8 [[X:%.*]], i8 [[Y:%.*]])
; CHECK-NEXT:    ret i8 [[M]]
;
  %i = icmp eq i8 %y, %x
  %m = call i8 @llvm.smax.i8(i8 %x, i8 %y)
  %r = select i1 %i, i8 %x, i8 %m
  ret i8 %r
}

define i8 @ne_yx_smax_fval(i8 %x, i8 %y) {
; CHECK-LABEL: @ne_yx_smax_fval(
; CHECK-NEXT:    ret i8 [[X:%.*]]
;
  %i = icmp ne i8 %y, %x
  %m = call i8 @llvm.smax.i8(i8 %y, i8 %x)
  %r = select i1 %i, i8 %x, i8 %m
  ret i8 %r
}

; swap select operands

define i8 @slt_xy_smax_tval(i8 %x, i8 %y) {
; CHECK-LABEL: @slt_xy_smax_tval(
; CHECK-NEXT:    [[M:%.*]] = call i8 @llvm.smax.i8(i8 [[X:%.*]], i8 [[Y:%.*]])
; CHECK-NEXT:    ret i8 [[M]]
;
  %i = icmp slt i8 %x, %y
  %m = call i8 @llvm.smax.i8(i8 %x, i8 %y)
  %r = select i1 %i, i8 %m, i8 %x
  ret i8 %r
}

define i8 @sle_xy_smax_tval(i8 %x, i8 %y) {
; CHECK-LABEL: @sle_xy_smax_tval(
; CHECK-NEXT:    [[M:%.*]] = call i8 @llvm.smax.i8(i8 [[Y:%.*]], i8 [[X:%.*]])
; CHECK-NEXT:    ret i8 [[M]]
;
  %i = icmp sle i8 %x, %y
  %m = call i8 @llvm.smax.i8(i8 %y, i8 %x)
  %r = select i1 %i, i8 %m, i8 %x
  ret i8 %r
}

define i8 @sgt_xy_smax_tval(i8 %x, i8 %y) {
; CHECK-LABEL: @sgt_xy_smax_tval(
; CHECK-NEXT:    ret i8 [[X:%.*]]
;
  %i = icmp sgt i8 %x, %y
  %m = call i8 @llvm.smax.i8(i8 %x, i8 %y)
  %r = select i1 %i, i8 %m, i8 %x
  ret i8 %r
}

define i8 @sge_xy_smax_tval(i8 %x, i8 %y) {
; CHECK-LABEL: @sge_xy_smax_tval(
; CHECK-NEXT:    ret i8 [[X:%.*]]
;
  %i = icmp sge i8 %x, %y
  %m = call i8 @llvm.smax.i8(i8 %y, i8 %x)
  %r = select i1 %i, i8 %m, i8 %x
  ret i8 %r
}

define i8 @ult_xy_smax_tval(i8 %x, i8 %y) {
; CHECK-LABEL: @ult_xy_smax_tval(
; CHECK-NEXT:    [[I:%.*]] = icmp ult i8 [[X:%.*]], [[Y:%.*]]
; CHECK-NEXT:    [[M:%.*]] = call i8 @llvm.smax.i8(i8 [[X]], i8 [[Y]])
; CHECK-NEXT:    [[R:%.*]] = select i1 [[I]], i8 [[M]], i8 [[X]]
; CHECK-NEXT:    ret i8 [[R]]
;
  %i = icmp ult i8 %x, %y
  %m = call i8 @llvm.smax.i8(i8 %x, i8 %y)
  %r = select i1 %i, i8 %m, i8 %x
  ret i8 %r
}

define i8 @ule_xy_smax_tval(i8 %x, i8 %y) {
; CHECK-LABEL: @ule_xy_smax_tval(
; CHECK-NEXT:    [[I:%.*]] = icmp ule i8 [[X:%.*]], [[Y:%.*]]
; CHECK-NEXT:    [[M:%.*]] = call i8 @llvm.smax.i8(i8 [[Y]], i8 [[X]])
; CHECK-NEXT:    [[R:%.*]] = select i1 [[I]], i8 [[M]], i8 [[X]]
; CHECK-NEXT:    ret i8 [[R]]
;
  %i = icmp ule i8 %x, %y
  %m = call i8 @llvm.smax.i8(i8 %y, i8 %x)
  %r = select i1 %i, i8 %m, i8 %x
  ret i8 %r
}

define i8 @ugt_xy_smax_tval(i8 %x, i8 %y) {
; CHECK-LABEL: @ugt_xy_smax_tval(
; CHECK-NEXT:    [[I:%.*]] = icmp ugt i8 [[X:%.*]], [[Y:%.*]]
; CHECK-NEXT:    [[M:%.*]] = call i8 @llvm.smax.i8(i8 [[X]], i8 [[Y]])
; CHECK-NEXT:    [[R:%.*]] = select i1 [[I]], i8 [[M]], i8 [[X]]
; CHECK-NEXT:    ret i8 [[R]]
;
  %i = icmp ugt i8 %x, %y
  %m = call i8 @llvm.smax.i8(i8 %x, i8 %y)
  %r = select i1 %i, i8 %m, i8 %x
  ret i8 %r
}

define i8 @uge_xy_smax_tval(i8 %x, i8 %y) {
; CHECK-LABEL: @uge_xy_smax_tval(
; CHECK-NEXT:    [[I:%.*]] = icmp uge i8 [[X:%.*]], [[Y:%.*]]
; CHECK-NEXT:    [[M:%.*]] = call i8 @llvm.smax.i8(i8 [[Y]], i8 [[X]])
; CHECK-NEXT:    [[R:%.*]] = select i1 [[I]], i8 [[M]], i8 [[X]]
; CHECK-NEXT:    ret i8 [[R]]
;
  %i = icmp uge i8 %x, %y
  %m = call i8 @llvm.smax.i8(i8 %y, i8 %x)
  %r = select i1 %i, i8 %m, i8 %x
  ret i8 %r
}

define i8 @eq_xy_smax_tval(i8 %x, i8 %y) {
; CHECK-LABEL: @eq_xy_smax_tval(
; CHECK-NEXT:    ret i8 [[X:%.*]]
;
  %i = icmp eq i8 %x, %y
  %m = call i8 @llvm.smax.i8(i8 %x, i8 %y)
  %r = select i1 %i, i8 %m, i8 %x
  ret i8 %r
}

define i8 @ne_xy_smax_tval(i8 %x, i8 %y) {
; CHECK-LABEL: @ne_xy_smax_tval(
; CHECK-NEXT:    [[M:%.*]] = call i8 @llvm.smax.i8(i8 [[Y:%.*]], i8 [[X:%.*]])
; CHECK-NEXT:    ret i8 [[M]]
;
  %i = icmp ne i8 %x, %y
  %m = call i8 @llvm.smax.i8(i8 %y, i8 %x)
  %r = select i1 %i, i8 %m, i8 %x
  ret i8 %r
}

; swap icmp and select operands

define i8 @slt_yx_smax_tval(i8 %x, i8 %y) {
; CHECK-LABEL: @slt_yx_smax_tval(
; CHECK-NEXT:    ret i8 [[X:%.*]]
;
  %i = icmp slt i8 %y, %x
  %m = call i8 @llvm.smax.i8(i8 %x, i8 %y)
  %r = select i1 %i, i8 %m, i8 %x
  ret i8 %r
}

define i8 @sle_yx_smax_tval(i8 %x, i8 %y) {
; CHECK-LABEL: @sle_yx_smax_tval(
; CHECK-NEXT:    ret i8 [[X:%.*]]
;
  %i = icmp sle i8 %y, %x
  %m = call i8 @llvm.smax.i8(i8 %y, i8 %x)
  %r = select i1 %i, i8 %m, i8 %x
  ret i8 %r
}

define i8 @sgt_yx_smax_tval(i8 %x, i8 %y) {
; CHECK-LABEL: @sgt_yx_smax_tval(
; CHECK-NEXT:    [[M:%.*]] = call i8 @llvm.smax.i8(i8 [[X:%.*]], i8 [[Y:%.*]])
; CHECK-NEXT:    ret i8 [[M]]
;
  %i = icmp sgt i8 %y, %x
  %m = call i8 @llvm.smax.i8(i8 %x, i8 %y)
  %r = select i1 %i, i8 %m, i8 %x
  ret i8 %r
}

define i8 @sge_yx_smax_tval(i8 %x, i8 %y) {
; CHECK-LABEL: @sge_yx_smax_tval(
; CHECK-NEXT:    [[M:%.*]] = call i8 @llvm.smax.i8(i8 [[Y:%.*]], i8 [[X:%.*]])
; CHECK-NEXT:    ret i8 [[M]]
;
  %i = icmp sge i8 %y, %x
  %m = call i8 @llvm.smax.i8(i8 %y, i8 %x)
  %r = select i1 %i, i8 %m, i8 %x
  ret i8 %r
}

define i8 @ult_yx_smax_tval(i8 %x, i8 %y) {
; CHECK-LABEL: @ult_yx_smax_tval(
; CHECK-NEXT:    [[I:%.*]] = icmp ult i8 [[Y:%.*]], [[X:%.*]]
; CHECK-NEXT:    [[M:%.*]] = call i8 @llvm.smax.i8(i8 [[X]], i8 [[Y]])
; CHECK-NEXT:    [[R:%.*]] = select i1 [[I]], i8 [[M]], i8 [[X]]
; CHECK-NEXT:    ret i8 [[R]]
;
  %i = icmp ult i8 %y, %x
  %m = call i8 @llvm.smax.i8(i8 %x, i8 %y)
  %r = select i1 %i, i8 %m, i8 %x
  ret i8 %r
}

define i8 @ule_yx_smax_tval(i8 %x, i8 %y) {
; CHECK-LABEL: @ule_yx_smax_tval(
; CHECK-NEXT:    [[I:%.*]] = icmp ule i8 [[Y:%.*]], [[X:%.*]]
; CHECK-NEXT:    [[M:%.*]] = call i8 @llvm.smax.i8(i8 [[Y]], i8 [[X]])
; CHECK-NEXT:    [[R:%.*]] = select i1 [[I]], i8 [[M]], i8 [[X]]
; CHECK-NEXT:    ret i8 [[R]]
;
  %i = icmp ule i8 %y, %x
  %m = call i8 @llvm.smax.i8(i8 %y, i8 %x)
  %r = select i1 %i, i8 %m, i8 %x
  ret i8 %r
}

define i8 @ugt_yx_smax_tval(i8 %x, i8 %y) {
; CHECK-LABEL: @ugt_yx_smax_tval(
; CHECK-NEXT:    [[I:%.*]] = icmp ugt i8 [[Y:%.*]], [[X:%.*]]
; CHECK-NEXT:    [[M:%.*]] = call i8 @llvm.smax.i8(i8 [[X]], i8 [[Y]])
; CHECK-NEXT:    [[R:%.*]] = select i1 [[I]], i8 [[M]], i8 [[X]]
; CHECK-NEXT:    ret i8 [[R]]
;
  %i = icmp ugt i8 %y, %x
  %m = call i8 @llvm.smax.i8(i8 %x, i8 %y)
  %r = select i1 %i, i8 %m, i8 %x
  ret i8 %r
}

define i8 @uge_yx_smax_tval(i8 %x, i8 %y) {
; CHECK-LABEL: @uge_yx_smax_tval(
; CHECK-NEXT:    [[I:%.*]] = icmp uge i8 [[Y:%.*]], [[X:%.*]]
; CHECK-NEXT:    [[M:%.*]] = call i8 @llvm.smax.i8(i8 [[Y]], i8 [[X]])
; CHECK-NEXT:    [[R:%.*]] = select i1 [[I]], i8 [[M]], i8 [[X]]
; CHECK-NEXT:    ret i8 [[R]]
;
  %i = icmp uge i8 %y, %x
  %m = call i8 @llvm.smax.i8(i8 %y, i8 %x)
  %r = select i1 %i, i8 %m, i8 %x
  ret i8 %r
}

define i8 @eq_yx_smax_tval(i8 %x, i8 %y) {
; CHECK-LABEL: @eq_yx_smax_tval(
; CHECK-NEXT:    ret i8 [[X:%.*]]
;
  %i = icmp eq i8 %y, %x
  %m = call i8 @llvm.smax.i8(i8 %x, i8 %y)
  %r = select i1 %i, i8 %m, i8 %x
  ret i8 %r
}

define i8 @ne_yx_smax_tval(i8 %x, i8 %y) {
; CHECK-LABEL: @ne_yx_smax_tval(
; CHECK-NEXT:    [[M:%.*]] = call i8 @llvm.smax.i8(i8 [[Y:%.*]], i8 [[X:%.*]])
; CHECK-NEXT:    ret i8 [[M]]
;
  %i = icmp ne i8 %y, %x
  %m = call i8 @llvm.smax.i8(i8 %y, i8 %x)
  %r = select i1 %i, i8 %m, i8 %x
  ret i8 %r
}

; umin

define i8 @slt_xy_umin_fval(i8 %x, i8 %y) {
; CHECK-LABEL: @slt_xy_umin_fval(
; CHECK-NEXT:    [[I:%.*]] = icmp slt i8 [[X:%.*]], [[Y:%.*]]
; CHECK-NEXT:    [[M:%.*]] = call i8 @llvm.umin.i8(i8 [[X]], i8 [[Y]])
; CHECK-NEXT:    [[R:%.*]] = select i1 [[I]], i8 [[X]], i8 [[M]]
; CHECK-NEXT:    ret i8 [[R]]
;
  %i = icmp slt i8 %x, %y
  %m = call i8 @llvm.umin.i8(i8 %x, i8 %y)
  %r = select i1 %i, i8 %x, i8 %m
  ret i8 %r
}

define i8 @sle_xy_umin_fval(i8 %x, i8 %y) {
; CHECK-LABEL: @sle_xy_umin_fval(
; CHECK-NEXT:    [[I:%.*]] = icmp sle i8 [[X:%.*]], [[Y:%.*]]
; CHECK-NEXT:    [[M:%.*]] = call i8 @llvm.umin.i8(i8 [[Y]], i8 [[X]])
; CHECK-NEXT:    [[R:%.*]] = select i1 [[I]], i8 [[X]], i8 [[M]]
; CHECK-NEXT:    ret i8 [[R]]
;
  %i = icmp sle i8 %x, %y
  %m = call i8 @llvm.umin.i8(i8 %y, i8 %x)
  %r = select i1 %i, i8 %x, i8 %m
  ret i8 %r
}

define i8 @sgt_xy_umin_fval(i8 %x, i8 %y) {
; CHECK-LABEL: @sgt_xy_umin_fval(
; CHECK-NEXT:    [[I:%.*]] = icmp sgt i8 [[X:%.*]], [[Y:%.*]]
; CHECK-NEXT:    [[M:%.*]] = call i8 @llvm.umin.i8(i8 [[X]], i8 [[Y]])
; CHECK-NEXT:    [[R:%.*]] = select i1 [[I]], i8 [[X]], i8 [[M]]
; CHECK-NEXT:    ret i8 [[R]]
;
  %i = icmp sgt i8 %x, %y
  %m = call i8 @llvm.umin.i8(i8 %x, i8 %y)
  %r = select i1 %i, i8 %x, i8 %m
  ret i8 %r
}

define i8 @sge_xy_umin_fval(i8 %x, i8 %y) {
; CHECK-LABEL: @sge_xy_umin_fval(
; CHECK-NEXT:    [[I:%.*]] = icmp sge i8 [[X:%.*]], [[Y:%.*]]
; CHECK-NEXT:    [[M:%.*]] = call i8 @llvm.umin.i8(i8 [[Y]], i8 [[X]])
; CHECK-NEXT:    [[R:%.*]] = select i1 [[I]], i8 [[X]], i8 [[M]]
; CHECK-NEXT:    ret i8 [[R]]
;
  %i = icmp sge i8 %x, %y
  %m = call i8 @llvm.umin.i8(i8 %y, i8 %x)
  %r = select i1 %i, i8 %x, i8 %m
  ret i8 %r
}

define i8 @ult_xy_umin_fval(i8 %x, i8 %y) {
; CHECK-LABEL: @ult_xy_umin_fval(
; CHECK-NEXT:    [[M:%.*]] = call i8 @llvm.umin.i8(i8 [[X:%.*]], i8 [[Y:%.*]])
; CHECK-NEXT:    ret i8 [[M]]
;
  %i = icmp ult i8 %x, %y
  %m = call i8 @llvm.umin.i8(i8 %x, i8 %y)
  %r = select i1 %i, i8 %x, i8 %m
  ret i8 %r
}

define i8 @ule_xy_umin_fval(i8 %x, i8 %y) {
; CHECK-LABEL: @ule_xy_umin_fval(
; CHECK-NEXT:    [[M:%.*]] = call i8 @llvm.umin.i8(i8 [[Y:%.*]], i8 [[X:%.*]])
; CHECK-NEXT:    ret i8 [[M]]
;
  %i = icmp ule i8 %x, %y
  %m = call i8 @llvm.umin.i8(i8 %y, i8 %x)
  %r = select i1 %i, i8 %x, i8 %m
  ret i8 %r
}

define i8 @ugt_xy_umin_fval(i8 %x, i8 %y) {
; CHECK-LABEL: @ugt_xy_umin_fval(
; CHECK-NEXT:    ret i8 [[X:%.*]]
;
  %i = icmp ugt i8 %x, %y
  %m = call i8 @llvm.umin.i8(i8 %x, i8 %y)
  %r = select i1 %i, i8 %x, i8 %m
  ret i8 %r
}

define i8 @uge_xy_umin_fval(i8 %x, i8 %y) {
; CHECK-LABEL: @uge_xy_umin_fval(
; CHECK-NEXT:    ret i8 [[X:%.*]]
;
  %i = icmp uge i8 %x, %y
  %m = call i8 @llvm.umin.i8(i8 %y, i8 %x)
  %r = select i1 %i, i8 %x, i8 %m
  ret i8 %r
}

define i8 @eq_xy_umin_fval(i8 %x, i8 %y) {
; CHECK-LABEL: @eq_xy_umin_fval(
; CHECK-NEXT:    [[M:%.*]] = call i8 @llvm.umin.i8(i8 [[X:%.*]], i8 [[Y:%.*]])
; CHECK-NEXT:    ret i8 [[M]]
;
  %i = icmp eq i8 %x, %y
  %m = call i8 @llvm.umin.i8(i8 %x, i8 %y)
  %r = select i1 %i, i8 %x, i8 %m
  ret i8 %r
}

define i8 @ne_xy_umin_fval(i8 %x, i8 %y) {
; CHECK-LABEL: @ne_xy_umin_fval(
; CHECK-NEXT:    ret i8 [[X:%.*]]
;
  %i = icmp ne i8 %x, %y
  %m = call i8 @llvm.umin.i8(i8 %y, i8 %x)
  %r = select i1 %i, i8 %x, i8 %m
  ret i8 %r
}

; swap icmp operands

define i8 @slt_yx_umin_fval(i8 %x, i8 %y) {
; CHECK-LABEL: @slt_yx_umin_fval(
; CHECK-NEXT:    [[I:%.*]] = icmp slt i8 [[Y:%.*]], [[X:%.*]]
; CHECK-NEXT:    [[M:%.*]] = call i8 @llvm.umin.i8(i8 [[X]], i8 [[Y]])
; CHECK-NEXT:    [[R:%.*]] = select i1 [[I]], i8 [[X]], i8 [[M]]
; CHECK-NEXT:    ret i8 [[R]]
;
  %i = icmp slt i8 %y, %x
  %m = call i8 @llvm.umin.i8(i8 %x, i8 %y)
  %r = select i1 %i, i8 %x, i8 %m
  ret i8 %r
}

define i8 @sle_yx_umin_fval(i8 %x, i8 %y) {
; CHECK-LABEL: @sle_yx_umin_fval(
; CHECK-NEXT:    [[I:%.*]] = icmp sle i8 [[Y:%.*]], [[X:%.*]]
; CHECK-NEXT:    [[M:%.*]] = call i8 @llvm.umin.i8(i8 [[Y]], i8 [[X]])
; CHECK-NEXT:    [[R:%.*]] = select i1 [[I]], i8 [[X]], i8 [[M]]
; CHECK-NEXT:    ret i8 [[R]]
;
  %i = icmp sle i8 %y, %x
  %m = call i8 @llvm.umin.i8(i8 %y, i8 %x)
  %r = select i1 %i, i8 %x, i8 %m
  ret i8 %r
}

define i8 @sgt_yx_umin_fval(i8 %x, i8 %y) {
; CHECK-LABEL: @sgt_yx_umin_fval(
; CHECK-NEXT:    [[I:%.*]] = icmp sgt i8 [[Y:%.*]], [[X:%.*]]
; CHECK-NEXT:    [[M:%.*]] = call i8 @llvm.umin.i8(i8 [[X]], i8 [[Y]])
; CHECK-NEXT:    [[R:%.*]] = select i1 [[I]], i8 [[X]], i8 [[M]]
; CHECK-NEXT:    ret i8 [[R]]
;
  %i = icmp sgt i8 %y, %x
  %m = call i8 @llvm.umin.i8(i8 %x, i8 %y)
  %r = select i1 %i, i8 %x, i8 %m
  ret i8 %r
}

define i8 @sge_yx_umin_fval(i8 %x, i8 %y) {
; CHECK-LABEL: @sge_yx_umin_fval(
; CHECK-NEXT:    [[I:%.*]] = icmp sge i8 [[Y:%.*]], [[X:%.*]]
; CHECK-NEXT:    [[M:%.*]] = call i8 @llvm.umin.i8(i8 [[Y]], i8 [[X]])
; CHECK-NEXT:    [[R:%.*]] = select i1 [[I]], i8 [[X]], i8 [[M]]
; CHECK-NEXT:    ret i8 [[R]]
;
  %i = icmp sge i8 %y, %x
  %m = call i8 @llvm.umin.i8(i8 %y, i8 %x)
  %r = select i1 %i, i8 %x, i8 %m
  ret i8 %r
}

define i8 @ult_yx_umin_fval(i8 %x, i8 %y) {
; CHECK-LABEL: @ult_yx_umin_fval(
; CHECK-NEXT:    ret i8 [[X:%.*]]
;
  %i = icmp ult i8 %y, %x
  %m = call i8 @llvm.umin.i8(i8 %x, i8 %y)
  %r = select i1 %i, i8 %x, i8 %m
  ret i8 %r
}

define i8 @ule_yx_umin_fval(i8 %x, i8 %y) {
; CHECK-LABEL: @ule_yx_umin_fval(
; CHECK-NEXT:    ret i8 [[X:%.*]]
;
  %i = icmp ule i8 %y, %x
  %m = call i8 @llvm.umin.i8(i8 %y, i8 %x)
  %r = select i1 %i, i8 %x, i8 %m
  ret i8 %r
}

define i8 @ugt_yx_umin_fval(i8 %x, i8 %y) {
; CHECK-LABEL: @ugt_yx_umin_fval(
; CHECK-NEXT:    [[M:%.*]] = call i8 @llvm.umin.i8(i8 [[X:%.*]], i8 [[Y:%.*]])
; CHECK-NEXT:    ret i8 [[M]]
;
  %i = icmp ugt i8 %y, %x
  %m = call i8 @llvm.umin.i8(i8 %x, i8 %y)
  %r = select i1 %i, i8 %x, i8 %m
  ret i8 %r
}

define i8 @uge_yx_umin_fval(i8 %x, i8 %y) {
; CHECK-LABEL: @uge_yx_umin_fval(
; CHECK-NEXT:    [[M:%.*]] = call i8 @llvm.umin.i8(i8 [[Y:%.*]], i8 [[X:%.*]])
; CHECK-NEXT:    ret i8 [[M]]
;
  %i = icmp uge i8 %y, %x
  %m = call i8 @llvm.umin.i8(i8 %y, i8 %x)
  %r = select i1 %i, i8 %x, i8 %m
  ret i8 %r
}

define i8 @eq_yx_umin_fval(i8 %x, i8 %y) {
; CHECK-LABEL: @eq_yx_umin_fval(
; CHECK-NEXT:    [[M:%.*]] = call i8 @llvm.umin.i8(i8 [[X:%.*]], i8 [[Y:%.*]])
; CHECK-NEXT:    ret i8 [[M]]
;
  %i = icmp eq i8 %y, %x
  %m = call i8 @llvm.umin.i8(i8 %x, i8 %y)
  %r = select i1 %i, i8 %x, i8 %m
  ret i8 %r
}

define i8 @ne_yx_umin_fval(i8 %x, i8 %y) {
; CHECK-LABEL: @ne_yx_umin_fval(
; CHECK-NEXT:    ret i8 [[X:%.*]]
;
  %i = icmp ne i8 %y, %x
  %m = call i8 @llvm.umin.i8(i8 %y, i8 %x)
  %r = select i1 %i, i8 %x, i8 %m
  ret i8 %r
}

; swap select operands

define i8 @slt_xy_umin_tval(i8 %x, i8 %y) {
; CHECK-LABEL: @slt_xy_umin_tval(
; CHECK-NEXT:    [[I:%.*]] = icmp slt i8 [[X:%.*]], [[Y:%.*]]
; CHECK-NEXT:    [[M:%.*]] = call i8 @llvm.umin.i8(i8 [[X]], i8 [[Y]])
; CHECK-NEXT:    [[R:%.*]] = select i1 [[I]], i8 [[M]], i8 [[X]]
; CHECK-NEXT:    ret i8 [[R]]
;
  %i = icmp slt i8 %x, %y
  %m = call i8 @llvm.umin.i8(i8 %x, i8 %y)
  %r = select i1 %i, i8 %m, i8 %x
  ret i8 %r
}

define i8 @sle_xy_umin_tval(i8 %x, i8 %y) {
; CHECK-LABEL: @sle_xy_umin_tval(
; CHECK-NEXT:    [[I:%.*]] = icmp sle i8 [[X:%.*]], [[Y:%.*]]
; CHECK-NEXT:    [[M:%.*]] = call i8 @llvm.umin.i8(i8 [[Y]], i8 [[X]])
; CHECK-NEXT:    [[R:%.*]] = select i1 [[I]], i8 [[M]], i8 [[X]]
; CHECK-NEXT:    ret i8 [[R]]
;
  %i = icmp sle i8 %x, %y
  %m = call i8 @llvm.umin.i8(i8 %y, i8 %x)
  %r = select i1 %i, i8 %m, i8 %x
  ret i8 %r
}

define i8 @sgt_xy_umin_tval(i8 %x, i8 %y) {
; CHECK-LABEL: @sgt_xy_umin_tval(
; CHECK-NEXT:    [[I:%.*]] = icmp sgt i8 [[X:%.*]], [[Y:%.*]]
; CHECK-NEXT:    [[M:%.*]] = call i8 @llvm.umin.i8(i8 [[X]], i8 [[Y]])
; CHECK-NEXT:    [[R:%.*]] = select i1 [[I]], i8 [[M]], i8 [[X]]
; CHECK-NEXT:    ret i8 [[R]]
;
  %i = icmp sgt i8 %x, %y
  %m = call i8 @llvm.umin.i8(i8 %x, i8 %y)
  %r = select i1 %i, i8 %m, i8 %x
  ret i8 %r
}

define i8 @sge_xy_umin_tval(i8 %x, i8 %y) {
; CHECK-LABEL: @sge_xy_umin_tval(
; CHECK-NEXT:    [[I:%.*]] = icmp sge i8 [[X:%.*]], [[Y:%.*]]
; CHECK-NEXT:    [[M:%.*]] = call i8 @llvm.umin.i8(i8 [[Y]], i8 [[X]])
; CHECK-NEXT:    [[R:%.*]] = select i1 [[I]], i8 [[M]], i8 [[X]]
; CHECK-NEXT:    ret i8 [[R]]
;
  %i = icmp sge i8 %x, %y
  %m = call i8 @llvm.umin.i8(i8 %y, i8 %x)
  %r = select i1 %i, i8 %m, i8 %x
  ret i8 %r
}

define i8 @ult_xy_umin_tval(i8 %x, i8 %y) {
; CHECK-LABEL: @ult_xy_umin_tval(
; CHECK-NEXT:    ret i8 [[X:%.*]]
;
  %i = icmp ult i8 %x, %y
  %m = call i8 @llvm.umin.i8(i8 %x, i8 %y)
  %r = select i1 %i, i8 %m, i8 %x
  ret i8 %r
}

define i8 @ule_xy_umin_tval(i8 %x, i8 %y) {
; CHECK-LABEL: @ule_xy_umin_tval(
; CHECK-NEXT:    ret i8 [[X:%.*]]
;
  %i = icmp ule i8 %x, %y
  %m = call i8 @llvm.umin.i8(i8 %y, i8 %x)
  %r = select i1 %i, i8 %m, i8 %x
  ret i8 %r
}

define i8 @ugt_xy_umin_tval(i8 %x, i8 %y) {
; CHECK-LABEL: @ugt_xy_umin_tval(
; CHECK-NEXT:    [[M:%.*]] = call i8 @llvm.umin.i8(i8 [[X:%.*]], i8 [[Y:%.*]])
; CHECK-NEXT:    ret i8 [[M]]
;
  %i = icmp ugt i8 %x, %y
  %m = call i8 @llvm.umin.i8(i8 %x, i8 %y)
  %r = select i1 %i, i8 %m, i8 %x
  ret i8 %r
}

define i8 @uge_xy_umin_tval(i8 %x, i8 %y) {
; CHECK-LABEL: @uge_xy_umin_tval(
; CHECK-NEXT:    [[M:%.*]] = call i8 @llvm.umin.i8(i8 [[Y:%.*]], i8 [[X:%.*]])
; CHECK-NEXT:    ret i8 [[M]]
;
  %i = icmp uge i8 %x, %y
  %m = call i8 @llvm.umin.i8(i8 %y, i8 %x)
  %r = select i1 %i, i8 %m, i8 %x
  ret i8 %r
}

define i8 @eq_xy_umin_tval(i8 %x, i8 %y) {
; CHECK-LABEL: @eq_xy_umin_tval(
; CHECK-NEXT:    ret i8 [[X:%.*]]
;
  %i = icmp eq i8 %x, %y
  %m = call i8 @llvm.umin.i8(i8 %x, i8 %y)
  %r = select i1 %i, i8 %m, i8 %x
  ret i8 %r
}

define i8 @ne_xy_umin_tval(i8 %x, i8 %y) {
; CHECK-LABEL: @ne_xy_umin_tval(
; CHECK-NEXT:    [[M:%.*]] = call i8 @llvm.umin.i8(i8 [[Y:%.*]], i8 [[X:%.*]])
; CHECK-NEXT:    ret i8 [[M]]
;
  %i = icmp ne i8 %x, %y
  %m = call i8 @llvm.umin.i8(i8 %y, i8 %x)
  %r = select i1 %i, i8 %m, i8 %x
  ret i8 %r
}

; swap icmp and select operands

define i8 @slt_yx_umin_tval(i8 %x, i8 %y) {
; CHECK-LABEL: @slt_yx_umin_tval(
; CHECK-NEXT:    [[I:%.*]] = icmp slt i8 [[Y:%.*]], [[X:%.*]]
; CHECK-NEXT:    [[M:%.*]] = call i8 @llvm.umin.i8(i8 [[X]], i8 [[Y]])
; CHECK-NEXT:    [[R:%.*]] = select i1 [[I]], i8 [[M]], i8 [[X]]
; CHECK-NEXT:    ret i8 [[R]]
;
  %i = icmp slt i8 %y, %x
  %m = call i8 @llvm.umin.i8(i8 %x, i8 %y)
  %r = select i1 %i, i8 %m, i8 %x
  ret i8 %r
}

define i8 @sle_yx_umin_tval(i8 %x, i8 %y) {
; CHECK-LABEL: @sle_yx_umin_tval(
; CHECK-NEXT:    [[I:%.*]] = icmp sle i8 [[Y:%.*]], [[X:%.*]]
; CHECK-NEXT:    [[M:%.*]] = call i8 @llvm.umin.i8(i8 [[Y]], i8 [[X]])
; CHECK-NEXT:    [[R:%.*]] = select i1 [[I]], i8 [[M]], i8 [[X]]
; CHECK-NEXT:    ret i8 [[R]]
;
  %i = icmp sle i8 %y, %x
  %m = call i8 @llvm.umin.i8(i8 %y, i8 %x)
  %r = select i1 %i, i8 %m, i8 %x
  ret i8 %r
}

define i8 @sgt_yx_umin_tval(i8 %x, i8 %y) {
; CHECK-LABEL: @sgt_yx_umin_tval(
; CHECK-NEXT:    [[I:%.*]] = icmp sgt i8 [[Y:%.*]], [[X:%.*]]
; CHECK-NEXT:    [[M:%.*]] = call i8 @llvm.umin.i8(i8 [[X]], i8 [[Y]])
; CHECK-NEXT:    [[R:%.*]] = select i1 [[I]], i8 [[M]], i8 [[X]]
; CHECK-NEXT:    ret i8 [[R]]
;
  %i = icmp sgt i8 %y, %x
  %m = call i8 @llvm.umin.i8(i8 %x, i8 %y)
  %r = select i1 %i, i8 %m, i8 %x
  ret i8 %r
}

define i8 @sge_yx_umin_tval(i8 %x, i8 %y) {
; CHECK-LABEL: @sge_yx_umin_tval(
; CHECK-NEXT:    [[I:%.*]] = icmp sge i8 [[Y:%.*]], [[X:%.*]]
; CHECK-NEXT:    [[M:%.*]] = call i8 @llvm.umin.i8(i8 [[Y]], i8 [[X]])
; CHECK-NEXT:    [[R:%.*]] = select i1 [[I]], i8 [[M]], i8 [[X]]
; CHECK-NEXT:    ret i8 [[R]]
;
  %i = icmp sge i8 %y, %x
  %m = call i8 @llvm.umin.i8(i8 %y, i8 %x)
  %r = select i1 %i, i8 %m, i8 %x
  ret i8 %r
}

define i8 @ult_yx_umin_tval(i8 %x, i8 %y) {
; CHECK-LABEL: @ult_yx_umin_tval(
; CHECK-NEXT:    [[M:%.*]] = call i8 @llvm.umin.i8(i8 [[X:%.*]], i8 [[Y:%.*]])
; CHECK-NEXT:    ret i8 [[M]]
;
  %i = icmp ult i8 %y, %x
  %m = call i8 @llvm.umin.i8(i8 %x, i8 %y)
  %r = select i1 %i, i8 %m, i8 %x
  ret i8 %r
}

define i8 @ule_yx_umin_tval(i8 %x, i8 %y) {
; CHECK-LABEL: @ule_yx_umin_tval(
; CHECK-NEXT:    [[M:%.*]] = call i8 @llvm.umin.i8(i8 [[Y:%.*]], i8 [[X:%.*]])
; CHECK-NEXT:    ret i8 [[M]]
;
  %i = icmp ule i8 %y, %x
  %m = call i8 @llvm.umin.i8(i8 %y, i8 %x)
  %r = select i1 %i, i8 %m, i8 %x
  ret i8 %r
}

define i8 @ugt_yx_umin_tval(i8 %x, i8 %y) {
; CHECK-LABEL: @ugt_yx_umin_tval(
; CHECK-NEXT:    ret i8 [[X:%.*]]
;
  %i = icmp ugt i8 %y, %x
  %m = call i8 @llvm.umin.i8(i8 %x, i8 %y)
  %r = select i1 %i, i8 %m, i8 %x
  ret i8 %r
}

define i8 @uge_yx_umin_tval(i8 %x, i8 %y) {
; CHECK-LABEL: @uge_yx_umin_tval(
; CHECK-NEXT:    ret i8 [[X:%.*]]
;
  %i = icmp uge i8 %y, %x
  %m = call i8 @llvm.umin.i8(i8 %y, i8 %x)
  %r = select i1 %i, i8 %m, i8 %x
  ret i8 %r
}

define i8 @eq_yx_umin_tval(i8 %x, i8 %y) {
; CHECK-LABEL: @eq_yx_umin_tval(
; CHECK-NEXT:    ret i8 [[X:%.*]]
;
  %i = icmp eq i8 %y, %x
  %m = call i8 @llvm.umin.i8(i8 %x, i8 %y)
  %r = select i1 %i, i8 %m, i8 %x
  ret i8 %r
}

define i8 @ne_yx_umin_tval(i8 %x, i8 %y) {
; CHECK-LABEL: @ne_yx_umin_tval(
; CHECK-NEXT:    [[M:%.*]] = call i8 @llvm.umin.i8(i8 [[Y:%.*]], i8 [[X:%.*]])
; CHECK-NEXT:    ret i8 [[M]]
;
  %i = icmp ne i8 %y, %x
  %m = call i8 @llvm.umin.i8(i8 %y, i8 %x)
  %r = select i1 %i, i8 %m, i8 %x
  ret i8 %r
}

; umax

define i8 @slt_xy_umax_fval(i8 %x, i8 %y) {
; CHECK-LABEL: @slt_xy_umax_fval(
; CHECK-NEXT:    [[I:%.*]] = icmp slt i8 [[X:%.*]], [[Y:%.*]]
; CHECK-NEXT:    [[M:%.*]] = call i8 @llvm.umax.i8(i8 [[X]], i8 [[Y]])
; CHECK-NEXT:    [[R:%.*]] = select i1 [[I]], i8 [[X]], i8 [[M]]
; CHECK-NEXT:    ret i8 [[R]]
;
  %i = icmp slt i8 %x, %y
  %m = call i8 @llvm.umax.i8(i8 %x, i8 %y)
  %r = select i1 %i, i8 %x, i8 %m
  ret i8 %r
}

define i8 @sle_xy_umax_fval(i8 %x, i8 %y) {
; CHECK-LABEL: @sle_xy_umax_fval(
; CHECK-NEXT:    [[I:%.*]] = icmp sle i8 [[X:%.*]], [[Y:%.*]]
; CHECK-NEXT:    [[M:%.*]] = call i8 @llvm.umax.i8(i8 [[Y]], i8 [[X]])
; CHECK-NEXT:    [[R:%.*]] = select i1 [[I]], i8 [[X]], i8 [[M]]
; CHECK-NEXT:    ret i8 [[R]]
;
  %i = icmp sle i8 %x, %y
  %m = call i8 @llvm.umax.i8(i8 %y, i8 %x)
  %r = select i1 %i, i8 %x, i8 %m
  ret i8 %r
}

define i8 @sgt_xy_umax_fval(i8 %x, i8 %y) {
; CHECK-LABEL: @sgt_xy_umax_fval(
; CHECK-NEXT:    [[I:%.*]] = icmp sgt i8 [[X:%.*]], [[Y:%.*]]
; CHECK-NEXT:    [[M:%.*]] = call i8 @llvm.umax.i8(i8 [[X]], i8 [[Y]])
; CHECK-NEXT:    [[R:%.*]] = select i1 [[I]], i8 [[X]], i8 [[M]]
; CHECK-NEXT:    ret i8 [[R]]
;
  %i = icmp sgt i8 %x, %y
  %m = call i8 @llvm.umax.i8(i8 %x, i8 %y)
  %r = select i1 %i, i8 %x, i8 %m
  ret i8 %r
}

define i8 @sge_xy_umax_fval(i8 %x, i8 %y) {
; CHECK-LABEL: @sge_xy_umax_fval(
; CHECK-NEXT:    [[I:%.*]] = icmp sge i8 [[X:%.*]], [[Y:%.*]]
; CHECK-NEXT:    [[M:%.*]] = call i8 @llvm.umax.i8(i8 [[Y]], i8 [[X]])
; CHECK-NEXT:    [[R:%.*]] = select i1 [[I]], i8 [[X]], i8 [[M]]
; CHECK-NEXT:    ret i8 [[R]]
;
  %i = icmp sge i8 %x, %y
  %m = call i8 @llvm.umax.i8(i8 %y, i8 %x)
  %r = select i1 %i, i8 %x, i8 %m
  ret i8 %r
}

define i8 @ult_xy_umax_fval(i8 %x, i8 %y) {
; CHECK-LABEL: @ult_xy_umax_fval(
; CHECK-NEXT:    ret i8 [[X:%.*]]
;
  %i = icmp ult i8 %x, %y
  %m = call i8 @llvm.umax.i8(i8 %x, i8 %y)
  %r = select i1 %i, i8 %x, i8 %m
  ret i8 %r
}

define i8 @ule_xy_umax_fval(i8 %x, i8 %y) {
; CHECK-LABEL: @ule_xy_umax_fval(
; CHECK-NEXT:    ret i8 [[X:%.*]]
;
  %i = icmp ule i8 %x, %y
  %m = call i8 @llvm.umax.i8(i8 %y, i8 %x)
  %r = select i1 %i, i8 %x, i8 %m
  ret i8 %r
}

define i8 @ugt_xy_umax_fval(i8 %x, i8 %y) {
; CHECK-LABEL: @ugt_xy_umax_fval(
; CHECK-NEXT:    [[M:%.*]] = call i8 @llvm.umax.i8(i8 [[X:%.*]], i8 [[Y:%.*]])
; CHECK-NEXT:    ret i8 [[M]]
;
  %i = icmp ugt i8 %x, %y
  %m = call i8 @llvm.umax.i8(i8 %x, i8 %y)
  %r = select i1 %i, i8 %x, i8 %m
  ret i8 %r
}

define i8 @uge_xy_umax_fval(i8 %x, i8 %y) {
; CHECK-LABEL: @uge_xy_umax_fval(
; CHECK-NEXT:    [[M:%.*]] = call i8 @llvm.umax.i8(i8 [[Y:%.*]], i8 [[X:%.*]])
; CHECK-NEXT:    ret i8 [[M]]
;
  %i = icmp uge i8 %x, %y
  %m = call i8 @llvm.umax.i8(i8 %y, i8 %x)
  %r = select i1 %i, i8 %x, i8 %m
  ret i8 %r
}

define i8 @eq_xy_umax_fval(i8 %x, i8 %y) {
; CHECK-LABEL: @eq_xy_umax_fval(
; CHECK-NEXT:    [[M:%.*]] = call i8 @llvm.umax.i8(i8 [[X:%.*]], i8 [[Y:%.*]])
; CHECK-NEXT:    ret i8 [[M]]
;
  %i = icmp eq i8 %x, %y
  %m = call i8 @llvm.umax.i8(i8 %x, i8 %y)
  %r = select i1 %i, i8 %x, i8 %m
  ret i8 %r
}

define i8 @ne_xy_umax_fval(i8 %x, i8 %y) {
; CHECK-LABEL: @ne_xy_umax_fval(
; CHECK-NEXT:    ret i8 [[X:%.*]]
;
  %i = icmp ne i8 %x, %y
  %m = call i8 @llvm.umax.i8(i8 %y, i8 %x)
  %r = select i1 %i, i8 %x, i8 %m
  ret i8 %r
}

; swap icmp operands

define i8 @slt_yx_umax_fval(i8 %x, i8 %y) {
; CHECK-LABEL: @slt_yx_umax_fval(
; CHECK-NEXT:    [[I:%.*]] = icmp slt i8 [[Y:%.*]], [[X:%.*]]
; CHECK-NEXT:    [[M:%.*]] = call i8 @llvm.umax.i8(i8 [[X]], i8 [[Y]])
; CHECK-NEXT:    [[R:%.*]] = select i1 [[I]], i8 [[X]], i8 [[M]]
; CHECK-NEXT:    ret i8 [[R]]
;
  %i = icmp slt i8 %y, %x
  %m = call i8 @llvm.umax.i8(i8 %x, i8 %y)
  %r = select i1 %i, i8 %x, i8 %m
  ret i8 %r
}

define i8 @sle_yx_umax_fval(i8 %x, i8 %y) {
; CHECK-LABEL: @sle_yx_umax_fval(
; CHECK-NEXT:    [[I:%.*]] = icmp sle i8 [[Y:%.*]], [[X:%.*]]
; CHECK-NEXT:    [[M:%.*]] = call i8 @llvm.umax.i8(i8 [[Y]], i8 [[X]])
; CHECK-NEXT:    [[R:%.*]] = select i1 [[I]], i8 [[X]], i8 [[M]]
; CHECK-NEXT:    ret i8 [[R]]
;
  %i = icmp sle i8 %y, %x
  %m = call i8 @llvm.umax.i8(i8 %y, i8 %x)
  %r = select i1 %i, i8 %x, i8 %m
  ret i8 %r
}

define i8 @sgt_yx_umax_fval(i8 %x, i8 %y) {
; CHECK-LABEL: @sgt_yx_umax_fval(
; CHECK-NEXT:    [[I:%.*]] = icmp sgt i8 [[Y:%.*]], [[X:%.*]]
; CHECK-NEXT:    [[M:%.*]] = call i8 @llvm.umax.i8(i8 [[X]], i8 [[Y]])
; CHECK-NEXT:    [[R:%.*]] = select i1 [[I]], i8 [[X]], i8 [[M]]
; CHECK-NEXT:    ret i8 [[R]]
;
  %i = icmp sgt i8 %y, %x
  %m = call i8 @llvm.umax.i8(i8 %x, i8 %y)
  %r = select i1 %i, i8 %x, i8 %m
  ret i8 %r
}

define i8 @sge_yx_umax_fval(i8 %x, i8 %y) {
; CHECK-LABEL: @sge_yx_umax_fval(
; CHECK-NEXT:    [[I:%.*]] = icmp sge i8 [[Y:%.*]], [[X:%.*]]
; CHECK-NEXT:    [[M:%.*]] = call i8 @llvm.umax.i8(i8 [[Y]], i8 [[X]])
; CHECK-NEXT:    [[R:%.*]] = select i1 [[I]], i8 [[X]], i8 [[M]]
; CHECK-NEXT:    ret i8 [[R]]
;
  %i = icmp sge i8 %y, %x
  %m = call i8 @llvm.umax.i8(i8 %y, i8 %x)
  %r = select i1 %i, i8 %x, i8 %m
  ret i8 %r
}

define i8 @ult_yx_umax_fval(i8 %x, i8 %y) {
; CHECK-LABEL: @ult_yx_umax_fval(
; CHECK-NEXT:    [[M:%.*]] = call i8 @llvm.umax.i8(i8 [[X:%.*]], i8 [[Y:%.*]])
; CHECK-NEXT:    ret i8 [[M]]
;
  %i = icmp ult i8 %y, %x
  %m = call i8 @llvm.umax.i8(i8 %x, i8 %y)
  %r = select i1 %i, i8 %x, i8 %m
  ret i8 %r
}

define i8 @ule_yx_umax_fval(i8 %x, i8 %y) {
; CHECK-LABEL: @ule_yx_umax_fval(
; CHECK-NEXT:    [[M:%.*]] = call i8 @llvm.umax.i8(i8 [[Y:%.*]], i8 [[X:%.*]])
; CHECK-NEXT:    ret i8 [[M]]
;
  %i = icmp ule i8 %y, %x
  %m = call i8 @llvm.umax.i8(i8 %y, i8 %x)
  %r = select i1 %i, i8 %x, i8 %m
  ret i8 %r
}

define i8 @ugt_yx_umax_fval(i8 %x, i8 %y) {
; CHECK-LABEL: @ugt_yx_umax_fval(
; CHECK-NEXT:    ret i8 [[X:%.*]]
;
  %i = icmp ugt i8 %y, %x
  %m = call i8 @llvm.umax.i8(i8 %x, i8 %y)
  %r = select i1 %i, i8 %x, i8 %m
  ret i8 %r
}

define i8 @uge_yx_umax_fval(i8 %x, i8 %y) {
; CHECK-LABEL: @uge_yx_umax_fval(
; CHECK-NEXT:    ret i8 [[X:%.*]]
;
  %i = icmp uge i8 %y, %x
  %m = call i8 @llvm.umax.i8(i8 %y, i8 %x)
  %r = select i1 %i, i8 %x, i8 %m
  ret i8 %r
}

define i8 @eq_yx_umax_fval(i8 %x, i8 %y) {
; CHECK-LABEL: @eq_yx_umax_fval(
; CHECK-NEXT:    [[M:%.*]] = call i8 @llvm.umax.i8(i8 [[X:%.*]], i8 [[Y:%.*]])
; CHECK-NEXT:    ret i8 [[M]]
;
  %i = icmp eq i8 %y, %x
  %m = call i8 @llvm.umax.i8(i8 %x, i8 %y)
  %r = select i1 %i, i8 %x, i8 %m
  ret i8 %r
}

define i8 @ne_yx_umax_fval(i8 %x, i8 %y) {
; CHECK-LABEL: @ne_yx_umax_fval(
; CHECK-NEXT:    ret i8 [[X:%.*]]
;
  %i = icmp ne i8 %y, %x
  %m = call i8 @llvm.umax.i8(i8 %y, i8 %x)
  %r = select i1 %i, i8 %x, i8 %m
  ret i8 %r
}

; swap select operands

define i8 @slt_xy_umax_tval(i8 %x, i8 %y) {
; CHECK-LABEL: @slt_xy_umax_tval(
; CHECK-NEXT:    [[I:%.*]] = icmp slt i8 [[X:%.*]], [[Y:%.*]]
; CHECK-NEXT:    [[M:%.*]] = call i8 @llvm.umax.i8(i8 [[X]], i8 [[Y]])
; CHECK-NEXT:    [[R:%.*]] = select i1 [[I]], i8 [[M]], i8 [[X]]
; CHECK-NEXT:    ret i8 [[R]]
;
  %i = icmp slt i8 %x, %y
  %m = call i8 @llvm.umax.i8(i8 %x, i8 %y)
  %r = select i1 %i, i8 %m, i8 %x
  ret i8 %r
}

define i8 @sle_xy_umax_tval(i8 %x, i8 %y) {
; CHECK-LABEL: @sle_xy_umax_tval(
; CHECK-NEXT:    [[I:%.*]] = icmp sle i8 [[X:%.*]], [[Y:%.*]]
; CHECK-NEXT:    [[M:%.*]] = call i8 @llvm.umax.i8(i8 [[Y]], i8 [[X]])
; CHECK-NEXT:    [[R:%.*]] = select i1 [[I]], i8 [[M]], i8 [[X]]
; CHECK-NEXT:    ret i8 [[R]]
;
  %i = icmp sle i8 %x, %y
  %m = call i8 @llvm.umax.i8(i8 %y, i8 %x)
  %r = select i1 %i, i8 %m, i8 %x
  ret i8 %r
}

define i8 @sgt_xy_umax_tval(i8 %x, i8 %y) {
; CHECK-LABEL: @sgt_xy_umax_tval(
; CHECK-NEXT:    [[I:%.*]] = icmp sgt i8 [[X:%.*]], [[Y:%.*]]
; CHECK-NEXT:    [[M:%.*]] = call i8 @llvm.umax.i8(i8 [[X]], i8 [[Y]])
; CHECK-NEXT:    [[R:%.*]] = select i1 [[I]], i8 [[M]], i8 [[X]]
; CHECK-NEXT:    ret i8 [[R]]
;
  %i = icmp sgt i8 %x, %y
  %m = call i8 @llvm.umax.i8(i8 %x, i8 %y)
  %r = select i1 %i, i8 %m, i8 %x
  ret i8 %r
}

define i8 @sge_xy_umax_tval(i8 %x, i8 %y) {
; CHECK-LABEL: @sge_xy_umax_tval(
; CHECK-NEXT:    [[I:%.*]] = icmp sge i8 [[X:%.*]], [[Y:%.*]]
; CHECK-NEXT:    [[M:%.*]] = call i8 @llvm.umax.i8(i8 [[Y]], i8 [[X]])
; CHECK-NEXT:    [[R:%.*]] = select i1 [[I]], i8 [[M]], i8 [[X]]
; CHECK-NEXT:    ret i8 [[R]]
;
  %i = icmp sge i8 %x, %y
  %m = call i8 @llvm.umax.i8(i8 %y, i8 %x)
  %r = select i1 %i, i8 %m, i8 %x
  ret i8 %r
}

define i8 @ult_xy_umax_tval(i8 %x, i8 %y) {
; CHECK-LABEL: @ult_xy_umax_tval(
; CHECK-NEXT:    [[M:%.*]] = call i8 @llvm.umax.i8(i8 [[X:%.*]], i8 [[Y:%.*]])
; CHECK-NEXT:    ret i8 [[M]]
;
  %i = icmp ult i8 %x, %y
  %m = call i8 @llvm.umax.i8(i8 %x, i8 %y)
  %r = select i1 %i, i8 %m, i8 %x
  ret i8 %r
}

define i8 @ule_xy_umax_tval(i8 %x, i8 %y) {
; CHECK-LABEL: @ule_xy_umax_tval(
; CHECK-NEXT:    [[M:%.*]] = call i8 @llvm.umax.i8(i8 [[Y:%.*]], i8 [[X:%.*]])
; CHECK-NEXT:    ret i8 [[M]]
;
  %i = icmp ule i8 %x, %y
  %m = call i8 @llvm.umax.i8(i8 %y, i8 %x)
  %r = select i1 %i, i8 %m, i8 %x
  ret i8 %r
}

define i8 @ugt_xy_umax_tval(i8 %x, i8 %y) {
; CHECK-LABEL: @ugt_xy_umax_tval(
; CHECK-NEXT:    ret i8 [[X:%.*]]
;
  %i = icmp ugt i8 %x, %y
  %m = call i8 @llvm.umax.i8(i8 %x, i8 %y)
  %r = select i1 %i, i8 %m, i8 %x
  ret i8 %r
}

define i8 @uge_xy_umax_tval(i8 %x, i8 %y) {
; CHECK-LABEL: @uge_xy_umax_tval(
; CHECK-NEXT:    ret i8 [[X:%.*]]
;
  %i = icmp uge i8 %x, %y
  %m = call i8 @llvm.umax.i8(i8 %y, i8 %x)
  %r = select i1 %i, i8 %m, i8 %x
  ret i8 %r
}

define i8 @eq_xy_umax_tval(i8 %x, i8 %y) {
; CHECK-LABEL: @eq_xy_umax_tval(
; CHECK-NEXT:    ret i8 [[X:%.*]]
;
  %i = icmp eq i8 %x, %y
  %m = call i8 @llvm.umax.i8(i8 %x, i8 %y)
  %r = select i1 %i, i8 %m, i8 %x
  ret i8 %r
}

define i8 @ne_xy_umax_tval(i8 %x, i8 %y) {
; CHECK-LABEL: @ne_xy_umax_tval(
; CHECK-NEXT:    [[M:%.*]] = call i8 @llvm.umax.i8(i8 [[Y:%.*]], i8 [[X:%.*]])
; CHECK-NEXT:    ret i8 [[M]]
;
  %i = icmp ne i8 %x, %y
  %m = call i8 @llvm.umax.i8(i8 %y, i8 %x)
  %r = select i1 %i, i8 %m, i8 %x
  ret i8 %r
}

; swap icmp and select operands

define i8 @slt_yx_umax_tval(i8 %x, i8 %y) {
; CHECK-LABEL: @slt_yx_umax_tval(
; CHECK-NEXT:    [[I:%.*]] = icmp slt i8 [[Y:%.*]], [[X:%.*]]
; CHECK-NEXT:    [[M:%.*]] = call i8 @llvm.umax.i8(i8 [[X]], i8 [[Y]])
; CHECK-NEXT:    [[R:%.*]] = select i1 [[I]], i8 [[M]], i8 [[X]]
; CHECK-NEXT:    ret i8 [[R]]
;
  %i = icmp slt i8 %y, %x
  %m = call i8 @llvm.umax.i8(i8 %x, i8 %y)
  %r = select i1 %i, i8 %m, i8 %x
  ret i8 %r
}

define i8 @sle_yx_umax_tval(i8 %x, i8 %y) {
; CHECK-LABEL: @sle_yx_umax_tval(
; CHECK-NEXT:    [[I:%.*]] = icmp sle i8 [[Y:%.*]], [[X:%.*]]
; CHECK-NEXT:    [[M:%.*]] = call i8 @llvm.umax.i8(i8 [[Y]], i8 [[X]])
; CHECK-NEXT:    [[R:%.*]] = select i1 [[I]], i8 [[M]], i8 [[X]]
; CHECK-NEXT:    ret i8 [[R]]
;
  %i = icmp sle i8 %y, %x
  %m = call i8 @llvm.umax.i8(i8 %y, i8 %x)
  %r = select i1 %i, i8 %m, i8 %x
  ret i8 %r
}

define i8 @sgt_yx_umax_tval(i8 %x, i8 %y) {
; CHECK-LABEL: @sgt_yx_umax_tval(
; CHECK-NEXT:    [[I:%.*]] = icmp sgt i8 [[Y:%.*]], [[X:%.*]]
; CHECK-NEXT:    [[M:%.*]] = call i8 @llvm.umax.i8(i8 [[X]], i8 [[Y]])
; CHECK-NEXT:    [[R:%.*]] = select i1 [[I]], i8 [[M]], i8 [[X]]
; CHECK-NEXT:    ret i8 [[R]]
;
  %i = icmp sgt i8 %y, %x
  %m = call i8 @llvm.umax.i8(i8 %x, i8 %y)
  %r = select i1 %i, i8 %m, i8 %x
  ret i8 %r
}

define i8 @sge_yx_umax_tval(i8 %x, i8 %y) {
; CHECK-LABEL: @sge_yx_umax_tval(
; CHECK-NEXT:    [[I:%.*]] = icmp sge i8 [[Y:%.*]], [[X:%.*]]
; CHECK-NEXT:    [[M:%.*]] = call i8 @llvm.umax.i8(i8 [[Y]], i8 [[X]])
; CHECK-NEXT:    [[R:%.*]] = select i1 [[I]], i8 [[M]], i8 [[X]]
; CHECK-NEXT:    ret i8 [[R]]
;
  %i = icmp sge i8 %y, %x
  %m = call i8 @llvm.umax.i8(i8 %y, i8 %x)
  %r = select i1 %i, i8 %m, i8 %x
  ret i8 %r
}

define i8 @ult_yx_umax_tval(i8 %x, i8 %y) {
; CHECK-LABEL: @ult_yx_umax_tval(
; CHECK-NEXT:    ret i8 [[X:%.*]]
;
  %i = icmp ult i8 %y, %x
  %m = call i8 @llvm.umax.i8(i8 %x, i8 %y)
  %r = select i1 %i, i8 %m, i8 %x
  ret i8 %r
}

define i8 @ule_yx_umax_tval(i8 %x, i8 %y) {
; CHECK-LABEL: @ule_yx_umax_tval(
; CHECK-NEXT:    ret i8 [[X:%.*]]
;
  %i = icmp ule i8 %y, %x
  %m = call i8 @llvm.umax.i8(i8 %y, i8 %x)
  %r = select i1 %i, i8 %m, i8 %x
  ret i8 %r
}

define i8 @ugt_yx_umax_tval(i8 %x, i8 %y) {
; CHECK-LABEL: @ugt_yx_umax_tval(
; CHECK-NEXT:    [[M:%.*]] = call i8 @llvm.umax.i8(i8 [[X:%.*]], i8 [[Y:%.*]])
; CHECK-NEXT:    ret i8 [[M]]
;
  %i = icmp ugt i8 %y, %x
  %m = call i8 @llvm.umax.i8(i8 %x, i8 %y)
  %r = select i1 %i, i8 %m, i8 %x
  ret i8 %r
}

define i8 @uge_yx_umax_tval(i8 %x, i8 %y) {
; CHECK-LABEL: @uge_yx_umax_tval(
; CHECK-NEXT:    [[M:%.*]] = call i8 @llvm.umax.i8(i8 [[Y:%.*]], i8 [[X:%.*]])
; CHECK-NEXT:    ret i8 [[M]]
;
  %i = icmp uge i8 %y, %x
  %m = call i8 @llvm.umax.i8(i8 %y, i8 %x)
  %r = select i1 %i, i8 %m, i8 %x
  ret i8 %r
}

define i8 @eq_yx_umax_tval(i8 %x, i8 %y) {
; CHECK-LABEL: @eq_yx_umax_tval(
; CHECK-NEXT:    ret i8 [[X:%.*]]
;
  %i = icmp eq i8 %y, %x
  %m = call i8 @llvm.umax.i8(i8 %x, i8 %y)
  %r = select i1 %i, i8 %m, i8 %x
  ret i8 %r
}

define i8 @ne_yx_umax_tval(i8 %x, i8 %y) {
; CHECK-LABEL: @ne_yx_umax_tval(
; CHECK-NEXT:    [[M:%.*]] = call i8 @llvm.umax.i8(i8 [[Y:%.*]], i8 [[X:%.*]])
; CHECK-NEXT:    ret i8 [[M]]
;
  %i = icmp ne i8 %y, %x
  %m = call i8 @llvm.umax.i8(i8 %y, i8 %x)
  %r = select i1 %i, i8 %m, i8 %x
  ret i8 %r
}

; negative test - wrong cmp op

define i8 @ne_yz_umax_tval(i8 %x, i8 %y, i8 %z) {
; CHECK-LABEL: @ne_yz_umax_tval(
; CHECK-NEXT:    [[I:%.*]] = icmp ne i8 [[Y:%.*]], [[Z:%.*]]
; CHECK-NEXT:    [[M:%.*]] = call i8 @llvm.umax.i8(i8 [[Y]], i8 [[X:%.*]])
; CHECK-NEXT:    [[R:%.*]] = select i1 [[I]], i8 [[M]], i8 [[X]]
; CHECK-NEXT:    ret i8 [[R]]
;
  %i = icmp ne i8 %y, %z
  %m = call i8 @llvm.umax.i8(i8 %y, i8 %x)
  %r = select i1 %i, i8 %m, i8 %x
  ret i8 %r
}

; negative test - wrong max op

define i8 @ne_yx_umax_tval_wrong_op(i8 %x, i8 %y, i8 %z) {
; CHECK-LABEL: @ne_yx_umax_tval_wrong_op(
; CHECK-NEXT:    [[I:%.*]] = icmp ne i8 [[Y:%.*]], [[X:%.*]]
; CHECK-NEXT:    [[M:%.*]] = call i8 @llvm.umax.i8(i8 [[Z:%.*]], i8 [[X]])
; CHECK-NEXT:    [[R:%.*]] = select i1 [[I]], i8 [[M]], i8 [[X]]
; CHECK-NEXT:    ret i8 [[R]]
;
  %i = icmp ne i8 %y, %x
  %m = call i8 @llvm.umax.i8(i8 %z, i8 %x)
  %r = select i1 %i, i8 %m, i8 %x
  ret i8 %r
}

; negative test - wrong cmp op

define i8 @eq_yz_umax_tval(i8 %x, i8 %y, i8 %z) {
; CHECK-LABEL: @eq_yz_umax_tval(
; CHECK-NEXT:    [[I:%.*]] = icmp eq i8 [[Y:%.*]], [[Z:%.*]]
; CHECK-NEXT:    [[M:%.*]] = call i8 @llvm.umax.i8(i8 [[Y]], i8 [[X:%.*]])
; CHECK-NEXT:    [[R:%.*]] = select i1 [[I]], i8 [[M]], i8 [[X]]
; CHECK-NEXT:    ret i8 [[R]]
;
  %i = icmp eq i8 %y, %z
  %m = call i8 @llvm.umax.i8(i8 %y, i8 %x)
  %r = select i1 %i, i8 %m, i8 %x
  ret i8 %r
}

; negative test - wrong max op

define i8 @eq_yx_umax_tval_wrong_op(i8 %x, i8 %y, i8 %z) {
; CHECK-LABEL: @eq_yx_umax_tval_wrong_op(
; CHECK-NEXT:    [[I:%.*]] = icmp eq i8 [[Y:%.*]], [[X:%.*]]
; CHECK-NEXT:    [[M:%.*]] = call i8 @llvm.umax.i8(i8 [[Z:%.*]], i8 [[X]])
; CHECK-NEXT:    [[R:%.*]] = select i1 [[I]], i8 [[M]], i8 [[X]]
; CHECK-NEXT:    ret i8 [[R]]
;
  %i = icmp eq i8 %y, %x
  %m = call i8 @llvm.umax.i8(i8 %z, i8 %x)
  %r = select i1 %i, i8 %m, i8 %x
  ret i8 %r
}

; select with smin pred

define <4 x i8> @slt_xy_smin_select_y_shuf_fval(<4 x i8> %x, <4 x i8> %y) {
; CHECK-LABEL: @slt_xy_smin_select_y_shuf_fval(
; CHECK-NEXT:    [[M:%.*]] = call <4 x i8> @llvm.smin.v4i8(<4 x i8> [[X:%.*]], <4 x i8> [[Y:%.*]])
; CHECK-NEXT:    ret <4 x i8> [[M]]
;
  %i = icmp slt <4 x i8> %x, %y
  %m = call <4 x i8> @llvm.smin.v4i8(<4 x i8> %x, <4 x i8> %y)
  %s = shufflevector <4 x i8> %y, <4 x i8> %m, <4 x i32> <i32 0, i32 1, i32 6, i32 7>
  %r = select <4 x i1> %i, <4 x i8> %x, <4 x i8> %s
  ret <4 x i8> %r
}

; negative test - wrong pred

define <4 x i8> @sgt_xy_smin_select_y_shuf_fval(<4 x i8> %x, <4 x i8> %y) {
; CHECK-LABEL: @sgt_xy_smin_select_y_shuf_fval(
; CHECK-NEXT:    [[I:%.*]] = icmp sgt <4 x i8> [[X:%.*]], [[Y:%.*]]
; CHECK-NEXT:    [[M:%.*]] = call <4 x i8> @llvm.smin.v4i8(<4 x i8> [[X]], <4 x i8> [[Y]])
; CHECK-NEXT:    [[S:%.*]] = shufflevector <4 x i8> [[Y]], <4 x i8> [[M]], <4 x i32> <i32 0, i32 1, i32 6, i32 7>
; CHECK-NEXT:    [[R:%.*]] = select <4 x i1> [[I]], <4 x i8> [[X]], <4 x i8> [[S]]
; CHECK-NEXT:    ret <4 x i8> [[R]]
;
  %i = icmp sgt <4 x i8> %x, %y
  %m = call <4 x i8> @llvm.smin.v4i8(<4 x i8> %x, <4 x i8> %y)
  %s = shufflevector <4 x i8> %y, <4 x i8> %m, <4 x i32> <i32 0, i32 1, i32 6, i32 7>
  %r = select <4 x i1> %i, <4 x i8> %x, <4 x i8> %s
  ret <4 x i8> %r
}

; negative test - wrong shuffle op

define <4 x i8> @slt_xy_smin_select_x_shuf_fval(<4 x i8> %x, <4 x i8> %y) {
; CHECK-LABEL: @slt_xy_smin_select_x_shuf_fval(
; CHECK-NEXT:    [[I:%.*]] = icmp slt <4 x i8> [[X:%.*]], [[Y:%.*]]
; CHECK-NEXT:    [[M:%.*]] = call <4 x i8> @llvm.smin.v4i8(<4 x i8> [[X]], <4 x i8> [[Y]])
; CHECK-NEXT:    [[S:%.*]] = shufflevector <4 x i8> [[X]], <4 x i8> [[M]], <4 x i32> <i32 0, i32 1, i32 6, i32 7>
; CHECK-NEXT:    [[R:%.*]] = select <4 x i1> [[I]], <4 x i8> [[X]], <4 x i8> [[S]]
; CHECK-NEXT:    ret <4 x i8> [[R]]
;
  %i = icmp slt <4 x i8> %x, %y
  %m = call <4 x i8> @llvm.smin.v4i8(<4 x i8> %x, <4 x i8> %y)
  %s = shufflevector <4 x i8> %x, <4 x i8> %m, <4 x i32> <i32 0, i32 1, i32 6, i32 7>
  %r = select <4 x i1> %i, <4 x i8> %x, <4 x i8> %s
  ret <4 x i8> %r
}

; select with non-strict smax pred

define <4 x i8> @sge_xy_smax_select_y_shuf_fval(<4 x i8> %x, <4 x i8> %y) {
; CHECK-LABEL: @sge_xy_smax_select_y_shuf_fval(
; CHECK-NEXT:    [[M:%.*]] = call <4 x i8> @llvm.smax.v4i8(<4 x i8> [[Y:%.*]], <4 x i8> [[X:%.*]])
; CHECK-NEXT:    ret <4 x i8> [[M]]
;
  %i = icmp sge <4 x i8> %x, %y
  %m = call <4 x i8> @llvm.smax.v4i8(<4 x i8> %y, <4 x i8> %x)
  %s = shufflevector <4 x i8> %y, <4 x i8> %m, <4 x i32> <i32 4, i32 1, i32 6, i32 3>
  %r = select <4 x i1> %i, <4 x i8> %x, <4 x i8> %s
  ret <4 x i8> %r
}

; negative test - wrong (swapped) pred

define <4 x i8> @sle_yx_smax_select_y_shuf_fval(<4 x i8> %x, <4 x i8> %y) {
; CHECK-LABEL: @sle_yx_smax_select_y_shuf_fval(
; CHECK-NEXT:    [[I:%.*]] = icmp sge <4 x i8> [[Y:%.*]], [[X:%.*]]
; CHECK-NEXT:    [[M:%.*]] = call <4 x i8> @llvm.smax.v4i8(<4 x i8> [[Y]], <4 x i8> [[X]])
; CHECK-NEXT:    [[S:%.*]] = shufflevector <4 x i8> [[Y]], <4 x i8> [[M]], <4 x i32> <i32 4, i32 1, i32 6, i32 3>
; CHECK-NEXT:    [[R:%.*]] = select <4 x i1> [[I]], <4 x i8> [[X]], <4 x i8> [[S]]
; CHECK-NEXT:    ret <4 x i8> [[R]]
;
  %i = icmp sge <4 x i8> %y, %x
  %m = call <4 x i8> @llvm.smax.v4i8(<4 x i8> %y, <4 x i8> %x)
  %s = shufflevector <4 x i8> %y, <4 x i8> %m, <4 x i32> <i32 4, i32 1, i32 6, i32 3>
  %r = select <4 x i1> %i, <4 x i8> %x, <4 x i8> %s
  ret <4 x i8> %r
}

; negative test - wrong shuffle op

define <4 x i8> @sge_xy_smax_select_x_shuf_fval(<4 x i8> %x, <4 x i8> %y) {
; CHECK-LABEL: @sge_xy_smax_select_x_shuf_fval(
; CHECK-NEXT:    [[I:%.*]] = icmp sge <4 x i8> [[X:%.*]], [[Y:%.*]]
; CHECK-NEXT:    [[M:%.*]] = call <4 x i8> @llvm.smax.v4i8(<4 x i8> [[Y]], <4 x i8> [[X]])
; CHECK-NEXT:    [[S:%.*]] = shufflevector <4 x i8> [[X]], <4 x i8> [[M]], <4 x i32> <i32 4, i32 1, i32 6, i32 3>
; CHECK-NEXT:    [[R:%.*]] = select <4 x i1> [[I]], <4 x i8> [[X]], <4 x i8> [[S]]
; CHECK-NEXT:    ret <4 x i8> [[R]]
;
  %i = icmp sge <4 x i8> %x, %y
  %m = call <4 x i8> @llvm.smax.v4i8(<4 x i8> %y, <4 x i8> %x)
  %s = shufflevector <4 x i8> %x, <4 x i8> %m, <4 x i32> <i32 4, i32 1, i32 6, i32 3>
  %r = select <4 x i1> %i, <4 x i8> %x, <4 x i8> %s
  ret <4 x i8> %r
}

; select with non-strict inverted umin pred

define <4 x i8> @uge_xy_umin_select_y_shuf_tval(<4 x i8> %x, <4 x i8> %y) {
; CHECK-LABEL: @uge_xy_umin_select_y_shuf_tval(
; CHECK-NEXT:    [[M:%.*]] = call <4 x i8> @llvm.umin.v4i8(<4 x i8> [[X:%.*]], <4 x i8> [[Y:%.*]])
; CHECK-NEXT:    ret <4 x i8> [[M]]
;
  %i = icmp uge <4 x i8> %x, %y
  %m = call <4 x i8> @llvm.umin.v4i8(<4 x i8> %x, <4 x i8> %y)
  %s = shufflevector <4 x i8> %m, <4 x i8> %y, <4 x i32> <i32 0, i32 1, i32 2, i32 7>
  %r = select <4 x i1> %i, <4 x i8> %s, <4 x i8> %x
  ret <4 x i8> %r
}

; negative test - wrong pred

define <4 x i8> @uge_xy_umin_select_y_shuf_fval(<4 x i8> %x, <4 x i8> %y) {
; CHECK-LABEL: @uge_xy_umin_select_y_shuf_fval(
; CHECK-NEXT:    [[I:%.*]] = icmp uge <4 x i8> [[X:%.*]], [[Y:%.*]]
; CHECK-NEXT:    [[M:%.*]] = call <4 x i8> @llvm.umin.v4i8(<4 x i8> [[X]], <4 x i8> [[Y]])
; CHECK-NEXT:    [[S:%.*]] = shufflevector <4 x i8> [[M]], <4 x i8> [[Y]], <4 x i32> <i32 0, i32 1, i32 2, i32 7>
; CHECK-NEXT:    [[R:%.*]] = select <4 x i1> [[I]], <4 x i8> [[X]], <4 x i8> [[S]]
; CHECK-NEXT:    ret <4 x i8> [[R]]
;
  %i = icmp uge <4 x i8> %x, %y
  %m = call <4 x i8> @llvm.umin.v4i8(<4 x i8> %x, <4 x i8> %y)
  %s = shufflevector <4 x i8> %m, <4 x i8> %y, <4 x i32> <i32 0, i32 1, i32 2, i32 7>
  %r = select <4 x i1> %i, <4 x i8> %x, <4 x i8> %s
  ret <4 x i8> %r
}

; negative test - wrong shuffle op

define <4 x i8> @uge_xy_umin_select_x_shuf_tval(<4 x i8> %x, <4 x i8> %y) {
; CHECK-LABEL: @uge_xy_umin_select_x_shuf_tval(
; CHECK-NEXT:    [[I:%.*]] = icmp uge <4 x i8> [[X:%.*]], [[Y:%.*]]
; CHECK-NEXT:    [[M:%.*]] = call <4 x i8> @llvm.umin.v4i8(<4 x i8> [[X]], <4 x i8> [[Y]])
; CHECK-NEXT:    [[S:%.*]] = shufflevector <4 x i8> [[M]], <4 x i8> [[X]], <4 x i32> <i32 0, i32 1, i32 2, i32 7>
; CHECK-NEXT:    [[R:%.*]] = select <4 x i1> [[I]], <4 x i8> [[S]], <4 x i8> [[X]]
; CHECK-NEXT:    ret <4 x i8> [[R]]
;
  %i = icmp uge <4 x i8> %x, %y
  %m = call <4 x i8> @llvm.umin.v4i8(<4 x i8> %x, <4 x i8> %y)
  %s = shufflevector <4 x i8> %m, <4 x i8> %x, <4 x i32> <i32 0, i32 1, i32 2, i32 7>
  %r = select <4 x i1> %i, <4 x i8> %s, <4 x i8> %x
  ret <4 x i8> %r
}

; select with swapped umax pred

define <4 x i8> @ult_yx_umax_select_y_shuf_fval(<4 x i8> %x, <4 x i8> %y) {
; CHECK-LABEL: @ult_yx_umax_select_y_shuf_fval(
; CHECK-NEXT:    [[M:%.*]] = call <4 x i8> @llvm.umax.v4i8(<4 x i8> [[Y:%.*]], <4 x i8> [[X:%.*]])
; CHECK-NEXT:    ret <4 x i8> [[M]]
;
  %i = icmp ult <4 x i8> %y, %x
  %m = call <4 x i8> @llvm.umax.v4i8(<4 x i8> %y, <4 x i8> %x)
  %s = shufflevector <4 x i8> %y, <4 x i8> %m, <4 x i32> <i32 4, i32 1, i32 2, i32 3>
  %r = select <4 x i1> %i, <4 x i8> %x, <4 x i8> %s
  ret <4 x i8> %r
}

; negative test - wrong (inverted+swapped) pred

define <4 x i8> @ult_yx_umax_select_y_shuf_tval(<4 x i8> %x, <4 x i8> %y) {
; CHECK-LABEL: @ult_yx_umax_select_y_shuf_tval(
; CHECK-NEXT:    [[I:%.*]] = icmp ult <4 x i8> [[Y:%.*]], [[X:%.*]]
; CHECK-NEXT:    [[M:%.*]] = call <4 x i8> @llvm.umax.v4i8(<4 x i8> [[Y]], <4 x i8> [[X]])
; CHECK-NEXT:    [[S:%.*]] = shufflevector <4 x i8> [[Y]], <4 x i8> [[M]], <4 x i32> <i32 4, i32 1, i32 2, i32 3>
; CHECK-NEXT:    [[R:%.*]] = select <4 x i1> [[I]], <4 x i8> [[S]], <4 x i8> [[X]]
; CHECK-NEXT:    ret <4 x i8> [[R]]
;
  %i = icmp ult <4 x i8> %y, %x
  %m = call <4 x i8> @llvm.umax.v4i8(<4 x i8> %y, <4 x i8> %x)
  %s = shufflevector <4 x i8> %y, <4 x i8> %m, <4 x i32> <i32 4, i32 1, i32 2, i32 3>
  %r = select <4 x i1> %i, <4 x i8> %s, <4 x i8> %x
  ret <4 x i8> %r
}

; negative test - wrong shuffle mask

define <4 x i8> @ult_yx_umax_select_y_shuf_mask_fval(<4 x i8> %x, <4 x i8> %y) {
; CHECK-LABEL: @ult_yx_umax_select_y_shuf_mask_fval(
; CHECK-NEXT:    [[I:%.*]] = icmp ult <4 x i8> [[Y:%.*]], [[X:%.*]]
; CHECK-NEXT:    [[M:%.*]] = call <4 x i8> @llvm.umax.v4i8(<4 x i8> [[Y]], <4 x i8> [[X]])
; CHECK-NEXT:    [[S:%.*]] = shufflevector <4 x i8> [[Y]], <4 x i8> [[M]], <4 x i32> <i32 5, i32 1, i32 2, i32 3>
; CHECK-NEXT:    [[R:%.*]] = select <4 x i1> [[I]], <4 x i8> [[X]], <4 x i8> [[S]]
; CHECK-NEXT:    ret <4 x i8> [[R]]
;
  %i = icmp ult <4 x i8> %y, %x
  %m = call <4 x i8> @llvm.umax.v4i8(<4 x i8> %y, <4 x i8> %x)
  %s = shufflevector <4 x i8> %y, <4 x i8> %m, <4 x i32> <i32 5, i32 1, i32 2, i32 3>
  %r = select <4 x i1> %i, <4 x i8> %x, <4 x i8> %s
  ret <4 x i8> %r
}

define i8 @select_umin_with_icmp_zero(i8 %x, i8 %y) {
; CHECK-LABEL: @select_umin_with_icmp_zero(
; CHECK-NEXT:    ret i8 0
;
  %min = call i8 @llvm.umin.i8(i8 %x, i8 %y)
  %cmp = icmp eq i8 %x, 0
  %sel = select i1 %cmp, i8 %min, i8 0
  ret i8 %sel
}
