; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --version 5
; RUN: opt -S -passes="print<scalar-evolution>,loop-unroll" -unroll-runtime < %s 2>/dev/null | FileCheck %s

; Make sure we use %add.lcssa rather than %load when expanding the
; backedge taken count.

define void @test(i1 %c, ptr %p) {
; CHECK-LABEL: define void @test(
; CHECK-SAME: i1 [[C:%.*]], ptr [[P:%.*]]) {
; CHECK-NEXT:  [[ENTRY:.*:]]
; CHECK-NEXT:    br label %[[LOOP_1_PEEL_BEGIN:.*]]
; CHECK:       [[LOOP_1_PEEL_BEGIN]]:
; CHECK-NEXT:    br label %[[LOOP_1_PEEL:.*]]
; CHECK:       [[LOOP_1_PEEL]]:
; CHECK-NEXT:    [[LOAD_PEEL:%.*]] = load i64, ptr [[P]], align 8
; CHECK-NEXT:    [[ADD_PEEL:%.*]] = add i64 [[LOAD_PEEL]], 1
; CHECK-NEXT:    br i1 [[C]], label %[[IF:.*]], label %[[LOOP_1_PEEL_NEXT:.*]]
; CHECK:       [[LOOP_1_PEEL_NEXT]]:
; CHECK-NEXT:    br label %[[LOOP_1_PEEL_NEXT1:.*]]
; CHECK:       [[LOOP_1_PEEL_NEXT1]]:
; CHECK-NEXT:    br label %[[ENTRY_PEEL_NEWPH:.*]]
; CHECK:       [[ENTRY_PEEL_NEWPH]]:
; CHECK-NEXT:    br label %[[LOOP_1:.*]]
; CHECK:       [[LOOP_1]]:
; CHECK-NEXT:    [[LOAD:%.*]] = load i64, ptr [[P]], align 8
; CHECK-NEXT:    [[ADD:%.*]] = add i64 [[LOAD]], 1
; CHECK-NEXT:    br i1 [[C]], label %[[IF_LOOPEXIT:.*]], label %[[LOOP_1]], !llvm.loop [[LOOP0:![0-9]+]]
; CHECK:       [[IF_LOOPEXIT]]:
; CHECK-NEXT:    [[ADD_LCSSA_PH:%.*]] = phi i64 [ [[ADD]], %[[LOOP_1]] ]
; CHECK-NEXT:    br label %[[IF]]
; CHECK:       [[IF]]:
; CHECK-NEXT:    [[ADD_LCSSA:%.*]] = phi i64 [ [[ADD_PEEL]], %[[LOOP_1_PEEL]] ], [ [[ADD_LCSSA_PH]], %[[IF_LOOPEXIT]] ]
; CHECK-NEXT:    [[GEP:%.*]] = getelementptr i64, ptr [[P]], i64 [[ADD_LCSSA]]
; CHECK-NEXT:    [[TMP0:%.*]] = shl i64 [[ADD_LCSSA]], 3
; CHECK-NEXT:    [[TMP1:%.*]] = lshr i64 [[TMP0]], 3
; CHECK-NEXT:    [[TMP2:%.*]] = add nuw nsw i64 [[TMP1]], 1
; CHECK-NEXT:    [[XTRAITER:%.*]] = and i64 [[TMP2]], 7
; CHECK-NEXT:    [[LCMP_MOD:%.*]] = icmp ne i64 [[XTRAITER]], 0
; CHECK-NEXT:    br i1 [[LCMP_MOD]], label %[[LOOP_2_PROL_PREHEADER:.*]], label %[[LOOP_2_PROL_LOOPEXIT:.*]]
; CHECK:       [[LOOP_2_PROL_PREHEADER]]:
; CHECK-NEXT:    br label %[[LOOP_2_PROL:.*]]
; CHECK:       [[LOOP_2_PROL]]:
; CHECK-NEXT:    [[IV_PROL:%.*]] = phi ptr [ [[P]], %[[LOOP_2_PROL_PREHEADER]] ], [ [[IV_NEXT_PROL:%.*]], %[[LOOP_2_PROL]] ]
; CHECK-NEXT:    [[PROL_ITER:%.*]] = phi i64 [ 0, %[[LOOP_2_PROL_PREHEADER]] ], [ [[PROL_ITER_NEXT:%.*]], %[[LOOP_2_PROL]] ]
; CHECK-NEXT:    [[IV_NEXT_PROL]] = getelementptr i8, ptr [[IV_PROL]], i64 8
; CHECK-NEXT:    [[ICMP_PROL:%.*]] = icmp eq ptr [[IV_PROL]], [[GEP]]
; CHECK-NEXT:    [[PROL_ITER_NEXT]] = add i64 [[PROL_ITER]], 1
; CHECK-NEXT:    [[PROL_ITER_CMP:%.*]] = icmp ne i64 [[PROL_ITER_NEXT]], [[XTRAITER]]
; CHECK-NEXT:    br i1 [[PROL_ITER_CMP]], label %[[LOOP_2_PROL]], label %[[LOOP_2_PROL_LOOPEXIT_UNR_LCSSA:.*]], !llvm.loop [[LOOP2:![0-9]+]]
; CHECK:       [[LOOP_2_PROL_LOOPEXIT_UNR_LCSSA]]:
; CHECK-NEXT:    [[IV_UNR_PH:%.*]] = phi ptr [ [[IV_NEXT_PROL]], %[[LOOP_2_PROL]] ]
; CHECK-NEXT:    br label %[[LOOP_2_PROL_LOOPEXIT]]
; CHECK:       [[LOOP_2_PROL_LOOPEXIT]]:
; CHECK-NEXT:    [[IV_UNR:%.*]] = phi ptr [ [[P]], %[[IF]] ], [ [[IV_UNR_PH]], %[[LOOP_2_PROL_LOOPEXIT_UNR_LCSSA]] ]
; CHECK-NEXT:    [[TMP3:%.*]] = icmp ult i64 [[TMP1]], 7
; CHECK-NEXT:    br i1 [[TMP3]], label %[[EXIT:.*]], label %[[IF_NEW:.*]]
; CHECK:       [[IF_NEW]]:
; CHECK-NEXT:    br label %[[LOOP_2:.*]]
; CHECK:       [[LOOP_2]]:
; CHECK-NEXT:    [[IV:%.*]] = phi ptr [ [[IV_UNR]], %[[IF_NEW]] ], [ [[IV_NEXT_7:%.*]], %[[LOOP_2]] ]
; CHECK-NEXT:    [[IV_NEXT:%.*]] = getelementptr i8, ptr [[IV]], i64 8
; CHECK-NEXT:    [[IV_NEXT_1:%.*]] = getelementptr i8, ptr [[IV_NEXT]], i64 8
; CHECK-NEXT:    [[IV_NEXT_2:%.*]] = getelementptr i8, ptr [[IV_NEXT_1]], i64 8
; CHECK-NEXT:    [[IV_NEXT_3:%.*]] = getelementptr i8, ptr [[IV_NEXT_2]], i64 8
; CHECK-NEXT:    [[IV_NEXT_4:%.*]] = getelementptr i8, ptr [[IV_NEXT_3]], i64 8
; CHECK-NEXT:    [[IV_NEXT_5:%.*]] = getelementptr i8, ptr [[IV_NEXT_4]], i64 8
; CHECK-NEXT:    [[IV_NEXT_6:%.*]] = getelementptr i8, ptr [[IV_NEXT_5]], i64 8
; CHECK-NEXT:    [[IV_NEXT_7]] = getelementptr i8, ptr [[IV_NEXT_6]], i64 8
; CHECK-NEXT:    [[ICMP_7:%.*]] = icmp eq ptr [[IV_NEXT_6]], [[GEP]]
; CHECK-NEXT:    br i1 [[ICMP_7]], label %[[EXIT_UNR_LCSSA:.*]], label %[[LOOP_2]]
; CHECK:       [[EXIT_UNR_LCSSA]]:
; CHECK-NEXT:    br label %[[EXIT]]
; CHECK:       [[EXIT]]:
; CHECK-NEXT:    ret void
;
entry:
  br label %loop.1

loop.1:
  %phi = phi ptr [ null, %entry ], [ %p, %loop.1 ]
  %load = load i64, ptr %p, align 8
  %add = add i64 %load, 1
  br i1 %c, label %if, label %loop.1

if:
  %add.lcssa = phi i64 [ %add, %loop.1 ]
  %gep = getelementptr i64, ptr %p, i64 %add.lcssa
  br label %loop.2

loop.2:
  %iv = phi ptr [ %p, %if ], [ %iv.next, %loop.2 ]
  %iv.next = getelementptr i8, ptr %iv, i64 8
  %icmp = icmp eq ptr %iv, %gep
  br i1 %icmp, label %exit, label %loop.2

exit:
  ret void
}
;.
; CHECK: [[LOOP0]] = distinct !{[[LOOP0]], [[META1:![0-9]+]]}
; CHECK: [[META1]] = !{!"llvm.loop.peeled.count", i32 1}
; CHECK: [[LOOP2]] = distinct !{[[LOOP2]], [[META3:![0-9]+]]}
; CHECK: [[META3]] = !{!"llvm.loop.unroll.disable"}
;.
