; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=i386-unknown -mattr=+sse2 | FileCheck %s --check-prefix=X86
; RUN: llc < %s -mtriple=x86_64-unknown -mattr=+sse2 | FileCheck %s --check-prefix=X64

; These should both generate something like this:
;_test3:
;	movl	$1234567, %eax
;	andl	4(%esp), %eax
;	movd	%eax, %xmm0
;	ret

define <2 x i64> @test3(i64 %arg) nounwind {
; X86-LABEL: test3:
; X86:       # BB#0:
; X86-NEXT:    movl $1234567, %eax # imm = 0x12D687
; X86-NEXT:    andl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movd %eax, %xmm0
; X86-NEXT:    retl
;
; X64-LABEL: test3:
; X64:       # BB#0:
; X64-NEXT:    andl $1234567, %edi # imm = 0x12D687
; X64-NEXT:    movq %rdi, %xmm0
; X64-NEXT:    retq
  %A = and i64 %arg, 1234567
  %B = insertelement <2 x i64> zeroinitializer, i64 %A, i32 0
  ret <2 x i64> %B
}

define <2 x i64> @test2(i64 %arg) nounwind {
; X86-LABEL: test2:
; X86:       # BB#0:
; X86-NEXT:    movl $1234567, %eax # imm = 0x12D687
; X86-NEXT:    andl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movd %eax, %xmm0
; X86-NEXT:    retl
;
; X64-LABEL: test2:
; X64:       # BB#0:
; X64-NEXT:    andl $1234567, %edi # imm = 0x12D687
; X64-NEXT:    movq %rdi, %xmm0
; X64-NEXT:    retq
  %A = and i64 %arg, 1234567
  %B = insertelement <2 x i64> undef, i64 %A, i32 0
  ret <2 x i64> %B
}
