// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/cloud/dataproc/v1beta2/clusters.proto

/*
Package dataproc is a generated protocol buffer package.

It is generated from these files:
	google/cloud/dataproc/v1beta2/clusters.proto
	google/cloud/dataproc/v1beta2/jobs.proto
	google/cloud/dataproc/v1beta2/operations.proto
	google/cloud/dataproc/v1beta2/workflow_templates.proto

It has these top-level messages:
	Cluster
	ClusterConfig
	GceClusterConfig
	InstanceGroupConfig
	ManagedGroupConfig
	AcceleratorConfig
	DiskConfig
	LifecycleConfig
	NodeInitializationAction
	ClusterStatus
	SoftwareConfig
	ClusterMetrics
	CreateClusterRequest
	UpdateClusterRequest
	DeleteClusterRequest
	GetClusterRequest
	ListClustersRequest
	ListClustersResponse
	DiagnoseClusterRequest
	DiagnoseClusterResults
	LoggingConfig
	HadoopJob
	SparkJob
	PySparkJob
	QueryList
	HiveJob
	SparkSqlJob
	PigJob
	JobPlacement
	JobStatus
	JobReference
	YarnApplication
	Job
	JobScheduling
	SubmitJobRequest
	GetJobRequest
	ListJobsRequest
	UpdateJobRequest
	ListJobsResponse
	CancelJobRequest
	DeleteJobRequest
	ClusterOperationStatus
	ClusterOperationMetadata
	WorkflowTemplate
	WorkflowTemplatePlacement
	ManagedCluster
	ClusterSelector
	OrderedJob
	WorkflowMetadata
	ClusterOperation
	WorkflowGraph
	WorkflowNode
	CreateWorkflowTemplateRequest
	GetWorkflowTemplateRequest
	InstantiateWorkflowTemplateRequest
	UpdateWorkflowTemplateRequest
	ListWorkflowTemplatesRequest
	ListWorkflowTemplatesResponse
	DeleteWorkflowTemplateRequest
*/
package dataproc

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import _ "google.golang.org/genproto/googleapis/api/annotations"
import google_longrunning "google.golang.org/genproto/googleapis/longrunning"
import google_protobuf3 "github.com/golang/protobuf/ptypes/duration"
import google_protobuf4 "google.golang.org/genproto/protobuf/field_mask"
import google_protobuf5 "github.com/golang/protobuf/ptypes/timestamp"

import (
	context "golang.org/x/net/context"
	grpc "google.golang.org/grpc"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

// The cluster state.
type ClusterStatus_State int32

const (
	// The cluster state is unknown.
	ClusterStatus_UNKNOWN ClusterStatus_State = 0
	// The cluster is being created and set up. It is not ready for use.
	ClusterStatus_CREATING ClusterStatus_State = 1
	// The cluster is currently running and healthy. It is ready for use.
	ClusterStatus_RUNNING ClusterStatus_State = 2
	// The cluster encountered an error. It is not ready for use.
	ClusterStatus_ERROR ClusterStatus_State = 3
	// The cluster is being deleted. It cannot be used.
	ClusterStatus_DELETING ClusterStatus_State = 4
	// The cluster is being updated. It continues to accept and process jobs.
	ClusterStatus_UPDATING ClusterStatus_State = 5
)

var ClusterStatus_State_name = map[int32]string{
	0: "UNKNOWN",
	1: "CREATING",
	2: "RUNNING",
	3: "ERROR",
	4: "DELETING",
	5: "UPDATING",
}
var ClusterStatus_State_value = map[string]int32{
	"UNKNOWN":  0,
	"CREATING": 1,
	"RUNNING":  2,
	"ERROR":    3,
	"DELETING": 4,
	"UPDATING": 5,
}

func (x ClusterStatus_State) String() string {
	return proto.EnumName(ClusterStatus_State_name, int32(x))
}
func (ClusterStatus_State) EnumDescriptor() ([]byte, []int) { return fileDescriptor0, []int{9, 0} }

type ClusterStatus_Substate int32

const (
	ClusterStatus_UNSPECIFIED ClusterStatus_Substate = 0
	// The cluster is known to be in an unhealthy state
	// (for example, critical daemons are not running or HDFS capacity is
	// exhausted).
	//
	// Applies to RUNNING state.
	ClusterStatus_UNHEALTHY ClusterStatus_Substate = 1
	// The agent-reported status is out of date (may occur if
	// Cloud Dataproc loses communication with Agent).
	//
	// Applies to RUNNING state.
	ClusterStatus_STALE_STATUS ClusterStatus_Substate = 2
)

var ClusterStatus_Substate_name = map[int32]string{
	0: "UNSPECIFIED",
	1: "UNHEALTHY",
	2: "STALE_STATUS",
}
var ClusterStatus_Substate_value = map[string]int32{
	"UNSPECIFIED":  0,
	"UNHEALTHY":    1,
	"STALE_STATUS": 2,
}

func (x ClusterStatus_Substate) String() string {
	return proto.EnumName(ClusterStatus_Substate_name, int32(x))
}
func (ClusterStatus_Substate) EnumDescriptor() ([]byte, []int) { return fileDescriptor0, []int{9, 1} }

// Describes the identifying information, config, and status of
// a cluster of Google Compute Engine instances.
type Cluster struct {
	// Required. The Google Cloud Platform project ID that the cluster belongs to.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId" json:"project_id,omitempty"`
	// Required. The cluster name. Cluster names within a project must be
	// unique. Names of deleted clusters can be reused.
	ClusterName string `protobuf:"bytes,2,opt,name=cluster_name,json=clusterName" json:"cluster_name,omitempty"`
	// Required. The cluster config. Note that Cloud Dataproc may set
	// default values, and values may change when clusters are updated.
	Config *ClusterConfig `protobuf:"bytes,3,opt,name=config" json:"config,omitempty"`
	// Optional. The labels to associate with this cluster.
	// Label **keys** must contain 1 to 63 characters, and must conform to
	// [RFC 1035](https://www.ietf.org/rfc/rfc1035.txt).
	// Label **values** may be empty, but, if present, must contain 1 to 63
	// characters, and must conform to [RFC 1035](https://www.ietf.org/rfc/rfc1035.txt).
	// No more than 32 labels can be associated with a cluster.
	Labels map[string]string `protobuf:"bytes,8,rep,name=labels" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	// Output-only. Cluster status.
	Status *ClusterStatus `protobuf:"bytes,4,opt,name=status" json:"status,omitempty"`
	// Output-only. The previous cluster status.
	StatusHistory []*ClusterStatus `protobuf:"bytes,7,rep,name=status_history,json=statusHistory" json:"status_history,omitempty"`
	// Output-only. A cluster UUID (Unique Universal Identifier). Cloud Dataproc
	// generates this value when it creates the cluster.
	ClusterUuid string `protobuf:"bytes,6,opt,name=cluster_uuid,json=clusterUuid" json:"cluster_uuid,omitempty"`
	// Contains cluster daemon metrics such as HDFS and YARN stats.
	//
	// **Beta Feature**: This report is available for testing purposes only. It may
	// be changed before final release.
	Metrics *ClusterMetrics `protobuf:"bytes,9,opt,name=metrics" json:"metrics,omitempty"`
}

func (m *Cluster) Reset()                    { *m = Cluster{} }
func (m *Cluster) String() string            { return proto.CompactTextString(m) }
func (*Cluster) ProtoMessage()               {}
func (*Cluster) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{0} }

func (m *Cluster) GetProjectId() string {
	if m != nil {
		return m.ProjectId
	}
	return ""
}

func (m *Cluster) GetClusterName() string {
	if m != nil {
		return m.ClusterName
	}
	return ""
}

func (m *Cluster) GetConfig() *ClusterConfig {
	if m != nil {
		return m.Config
	}
	return nil
}

func (m *Cluster) GetLabels() map[string]string {
	if m != nil {
		return m.Labels
	}
	return nil
}

func (m *Cluster) GetStatus() *ClusterStatus {
	if m != nil {
		return m.Status
	}
	return nil
}

func (m *Cluster) GetStatusHistory() []*ClusterStatus {
	if m != nil {
		return m.StatusHistory
	}
	return nil
}

func (m *Cluster) GetClusterUuid() string {
	if m != nil {
		return m.ClusterUuid
	}
	return ""
}

func (m *Cluster) GetMetrics() *ClusterMetrics {
	if m != nil {
		return m.Metrics
	}
	return nil
}

// The cluster config.
type ClusterConfig struct {
	// Optional. A Google Cloud Storage staging bucket used for sharing generated
	// SSH keys and config. If you do not specify a staging bucket, Cloud
	// Dataproc will determine an appropriate Cloud Storage location (US,
	// ASIA, or EU) for your cluster's staging bucket according to the Google
	// Compute Engine zone where your cluster is deployed, and then it will create
	// and manage this project-level, per-location bucket for you.
	ConfigBucket string `protobuf:"bytes,1,opt,name=config_bucket,json=configBucket" json:"config_bucket,omitempty"`
	// Required. The shared Google Compute Engine config settings for
	// all instances in a cluster.
	GceClusterConfig *GceClusterConfig `protobuf:"bytes,8,opt,name=gce_cluster_config,json=gceClusterConfig" json:"gce_cluster_config,omitempty"`
	// Optional. The Google Compute Engine config settings for
	// the master instance in a cluster.
	MasterConfig *InstanceGroupConfig `protobuf:"bytes,9,opt,name=master_config,json=masterConfig" json:"master_config,omitempty"`
	// Optional. The Google Compute Engine config settings for
	// worker instances in a cluster.
	WorkerConfig *InstanceGroupConfig `protobuf:"bytes,10,opt,name=worker_config,json=workerConfig" json:"worker_config,omitempty"`
	// Optional. The Google Compute Engine config settings for
	// additional worker instances in a cluster.
	SecondaryWorkerConfig *InstanceGroupConfig `protobuf:"bytes,12,opt,name=secondary_worker_config,json=secondaryWorkerConfig" json:"secondary_worker_config,omitempty"`
	// Optional. The config settings for software inside the cluster.
	SoftwareConfig *SoftwareConfig `protobuf:"bytes,13,opt,name=software_config,json=softwareConfig" json:"software_config,omitempty"`
	// Optional. The config setting for auto delete cluster schedule.
	LifecycleConfig *LifecycleConfig `protobuf:"bytes,14,opt,name=lifecycle_config,json=lifecycleConfig" json:"lifecycle_config,omitempty"`
	// Optional. Commands to execute on each node after config is
	// completed. By default, executables are run on master and all worker nodes.
	// You can test a node's <code>role</code> metadata to run an executable on
	// a master or worker node, as shown below using `curl` (you can also use `wget`):
	//
	//     ROLE=$(curl -H Metadata-Flavor:Google http://metadata/computeMetadata/v1beta2/instance/attributes/dataproc-role)
	//     if [[ "${ROLE}" == 'Master' ]]; then
	//       ... master specific actions ...
	//     else
	//       ... worker specific actions ...
	//     fi
	InitializationActions []*NodeInitializationAction `protobuf:"bytes,11,rep,name=initialization_actions,json=initializationActions" json:"initialization_actions,omitempty"`
}

func (m *ClusterConfig) Reset()                    { *m = ClusterConfig{} }
func (m *ClusterConfig) String() string            { return proto.CompactTextString(m) }
func (*ClusterConfig) ProtoMessage()               {}
func (*ClusterConfig) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{1} }

func (m *ClusterConfig) GetConfigBucket() string {
	if m != nil {
		return m.ConfigBucket
	}
	return ""
}

func (m *ClusterConfig) GetGceClusterConfig() *GceClusterConfig {
	if m != nil {
		return m.GceClusterConfig
	}
	return nil
}

func (m *ClusterConfig) GetMasterConfig() *InstanceGroupConfig {
	if m != nil {
		return m.MasterConfig
	}
	return nil
}

func (m *ClusterConfig) GetWorkerConfig() *InstanceGroupConfig {
	if m != nil {
		return m.WorkerConfig
	}
	return nil
}

func (m *ClusterConfig) GetSecondaryWorkerConfig() *InstanceGroupConfig {
	if m != nil {
		return m.SecondaryWorkerConfig
	}
	return nil
}

func (m *ClusterConfig) GetSoftwareConfig() *SoftwareConfig {
	if m != nil {
		return m.SoftwareConfig
	}
	return nil
}

func (m *ClusterConfig) GetLifecycleConfig() *LifecycleConfig {
	if m != nil {
		return m.LifecycleConfig
	}
	return nil
}

func (m *ClusterConfig) GetInitializationActions() []*NodeInitializationAction {
	if m != nil {
		return m.InitializationActions
	}
	return nil
}

// Common config settings for resources of Google Compute Engine cluster
// instances, applicable to all instances in the cluster.
type GceClusterConfig struct {
	// Optional. The zone where the Google Compute Engine cluster will be located.
	// On a create request, it is required in the "global" region. If omitted
	// in a non-global Cloud Dataproc region, the service will pick a zone in the
	// corresponding Compute Engine region. On a get request, zone will always be
	// present.
	//
	// A full URL, partial URI, or short name are valid. Examples:
	//
	// * `https://www.googleapis.com/compute/v1/projects/[project_id]/zones/[zone]`
	// * `projects/[project_id]/zones/[zone]`
	// * `us-central1-f`
	ZoneUri string `protobuf:"bytes,1,opt,name=zone_uri,json=zoneUri" json:"zone_uri,omitempty"`
	// Optional. The Google Compute Engine network to be used for machine
	// communications. Cannot be specified with subnetwork_uri. If neither
	// `network_uri` nor `subnetwork_uri` is specified, the "default" network of
	// the project is used, if it exists. Cannot be a "Custom Subnet Network" (see
	// [Using Subnetworks](/compute/docs/subnetworks) for more information).
	//
	// A full URL, partial URI, or short name are valid. Examples:
	//
	// * `https://www.googleapis.com/compute/v1/projects/[project_id]/regions/global/default`
	// * `projects/[project_id]/regions/global/default`
	// * `default`
	NetworkUri string `protobuf:"bytes,2,opt,name=network_uri,json=networkUri" json:"network_uri,omitempty"`
	// Optional. The Google Compute Engine subnetwork to be used for machine
	// communications. Cannot be specified with network_uri.
	//
	// A full URL, partial URI, or short name are valid. Examples:
	//
	// * `https://www.googleapis.com/compute/v1/projects/[project_id]/regions/us-east1/sub0`
	// * `projects/[project_id]/regions/us-east1/sub0`
	// * `sub0`
	SubnetworkUri string `protobuf:"bytes,6,opt,name=subnetwork_uri,json=subnetworkUri" json:"subnetwork_uri,omitempty"`
	// Optional. If true, all instances in the cluster will only have internal IP
	// addresses. By default, clusters are not restricted to internal IP addresses,
	// and will have ephemeral external IP addresses assigned to each instance.
	// This `internal_ip_only` restriction can only be enabled for subnetwork
	// enabled networks, and all off-cluster dependencies must be configured to be
	// accessible without external IP addresses.
	InternalIpOnly bool `protobuf:"varint,7,opt,name=internal_ip_only,json=internalIpOnly" json:"internal_ip_only,omitempty"`
	// Optional. The service account of the instances. Defaults to the default
	// Google Compute Engine service account. Custom service accounts need
	// permissions equivalent to the folloing IAM roles:
	//
	// * roles/logging.logWriter
	// * roles/storage.objectAdmin
	//
	// (see https://cloud.google.com/compute/docs/access/service-accounts#custom_service_accounts
	// for more information).
	// Example: `[account_id]@[project_id].iam.gserviceaccount.com`
	ServiceAccount string `protobuf:"bytes,8,opt,name=service_account,json=serviceAccount" json:"service_account,omitempty"`
	// Optional. The URIs of service account scopes to be included in Google
	// Compute Engine instances. The following base set of scopes is always
	// included:
	//
	// * https://www.googleapis.com/auth/cloud.useraccounts.readonly
	// * https://www.googleapis.com/auth/devstorage.read_write
	// * https://www.googleapis.com/auth/logging.write
	//
	// If no scopes are specified, the following defaults are also provided:
	//
	// * https://www.googleapis.com/auth/bigquery
	// * https://www.googleapis.com/auth/bigtable.admin.table
	// * https://www.googleapis.com/auth/bigtable.data
	// * https://www.googleapis.com/auth/devstorage.full_control
	ServiceAccountScopes []string `protobuf:"bytes,3,rep,name=service_account_scopes,json=serviceAccountScopes" json:"service_account_scopes,omitempty"`
	// The Google Compute Engine tags to add to all instances (see
	// [Tagging instances](/compute/docs/label-or-tag-resources#tags)).
	Tags []string `protobuf:"bytes,4,rep,name=tags" json:"tags,omitempty"`
	// The Google Compute Engine metadata entries to add to all instances (see
	// [Project and instance metadata](https://cloud.google.com/compute/docs/storing-retrieving-metadata#project_and_instance_metadata)).
	Metadata map[string]string `protobuf:"bytes,5,rep,name=metadata" json:"metadata,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
}

func (m *GceClusterConfig) Reset()                    { *m = GceClusterConfig{} }
func (m *GceClusterConfig) String() string            { return proto.CompactTextString(m) }
func (*GceClusterConfig) ProtoMessage()               {}
func (*GceClusterConfig) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{2} }

func (m *GceClusterConfig) GetZoneUri() string {
	if m != nil {
		return m.ZoneUri
	}
	return ""
}

func (m *GceClusterConfig) GetNetworkUri() string {
	if m != nil {
		return m.NetworkUri
	}
	return ""
}

func (m *GceClusterConfig) GetSubnetworkUri() string {
	if m != nil {
		return m.SubnetworkUri
	}
	return ""
}

func (m *GceClusterConfig) GetInternalIpOnly() bool {
	if m != nil {
		return m.InternalIpOnly
	}
	return false
}

func (m *GceClusterConfig) GetServiceAccount() string {
	if m != nil {
		return m.ServiceAccount
	}
	return ""
}

func (m *GceClusterConfig) GetServiceAccountScopes() []string {
	if m != nil {
		return m.ServiceAccountScopes
	}
	return nil
}

func (m *GceClusterConfig) GetTags() []string {
	if m != nil {
		return m.Tags
	}
	return nil
}

func (m *GceClusterConfig) GetMetadata() map[string]string {
	if m != nil {
		return m.Metadata
	}
	return nil
}

// Optional. The config settings for Google Compute Engine resources in
// an instance group, such as a master or worker group.
type InstanceGroupConfig struct {
	// Optional. The number of VM instances in the instance group.
	// For master instance groups, must be set to 1.
	NumInstances int32 `protobuf:"varint,1,opt,name=num_instances,json=numInstances" json:"num_instances,omitempty"`
	// Optional. The list of instance names. Cloud Dataproc derives the names from
	// `cluster_name`, `num_instances`, and the instance group if not set by user
	// (recommended practice is to let Cloud Dataproc derive the name).
	InstanceNames []string `protobuf:"bytes,2,rep,name=instance_names,json=instanceNames" json:"instance_names,omitempty"`
	// Output-only. The Google Compute Engine image resource used for cluster
	// instances. Inferred from `SoftwareConfig.image_version`.
	ImageUri string `protobuf:"bytes,3,opt,name=image_uri,json=imageUri" json:"image_uri,omitempty"`
	// Optional. The Google Compute Engine machine type used for cluster instances.
	//
	// A full URL, partial URI, or short name are valid. Examples:
	//
	// * `https://www.googleapis.com/compute/v1/projects/[project_id]/zones/us-east1-a/machineTypes/n1-standard-2`
	// * `projects/[project_id]/zones/us-east1-a/machineTypes/n1-standard-2`
	// * `n1-standard-2`
	MachineTypeUri string `protobuf:"bytes,4,opt,name=machine_type_uri,json=machineTypeUri" json:"machine_type_uri,omitempty"`
	// Optional. Disk option config settings.
	DiskConfig *DiskConfig `protobuf:"bytes,5,opt,name=disk_config,json=diskConfig" json:"disk_config,omitempty"`
	// Optional. Specifies that this instance group contains preemptible instances.
	IsPreemptible bool `protobuf:"varint,6,opt,name=is_preemptible,json=isPreemptible" json:"is_preemptible,omitempty"`
	// Output-only. The config for Google Compute Engine Instance Group
	// Manager that manages this group.
	// This is only used for preemptible instance groups.
	ManagedGroupConfig *ManagedGroupConfig `protobuf:"bytes,7,opt,name=managed_group_config,json=managedGroupConfig" json:"managed_group_config,omitempty"`
	// Optional. The Google Compute Engine accelerator configuration for these
	// instances.
	//
	// **Beta Feature**: This feature is still under development. It may be
	// changed before final release.
	Accelerators []*AcceleratorConfig `protobuf:"bytes,8,rep,name=accelerators" json:"accelerators,omitempty"`
}

func (m *InstanceGroupConfig) Reset()                    { *m = InstanceGroupConfig{} }
func (m *InstanceGroupConfig) String() string            { return proto.CompactTextString(m) }
func (*InstanceGroupConfig) ProtoMessage()               {}
func (*InstanceGroupConfig) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{3} }

func (m *InstanceGroupConfig) GetNumInstances() int32 {
	if m != nil {
		return m.NumInstances
	}
	return 0
}

func (m *InstanceGroupConfig) GetInstanceNames() []string {
	if m != nil {
		return m.InstanceNames
	}
	return nil
}

func (m *InstanceGroupConfig) GetImageUri() string {
	if m != nil {
		return m.ImageUri
	}
	return ""
}

func (m *InstanceGroupConfig) GetMachineTypeUri() string {
	if m != nil {
		return m.MachineTypeUri
	}
	return ""
}

func (m *InstanceGroupConfig) GetDiskConfig() *DiskConfig {
	if m != nil {
		return m.DiskConfig
	}
	return nil
}

func (m *InstanceGroupConfig) GetIsPreemptible() bool {
	if m != nil {
		return m.IsPreemptible
	}
	return false
}

func (m *InstanceGroupConfig) GetManagedGroupConfig() *ManagedGroupConfig {
	if m != nil {
		return m.ManagedGroupConfig
	}
	return nil
}

func (m *InstanceGroupConfig) GetAccelerators() []*AcceleratorConfig {
	if m != nil {
		return m.Accelerators
	}
	return nil
}

// Specifies the resources used to actively manage an instance group.
type ManagedGroupConfig struct {
	// Output-only. The name of the Instance Template used for the Managed
	// Instance Group.
	InstanceTemplateName string `protobuf:"bytes,1,opt,name=instance_template_name,json=instanceTemplateName" json:"instance_template_name,omitempty"`
	// Output-only. The name of the Instance Group Manager for this group.
	InstanceGroupManagerName string `protobuf:"bytes,2,opt,name=instance_group_manager_name,json=instanceGroupManagerName" json:"instance_group_manager_name,omitempty"`
}

func (m *ManagedGroupConfig) Reset()                    { *m = ManagedGroupConfig{} }
func (m *ManagedGroupConfig) String() string            { return proto.CompactTextString(m) }
func (*ManagedGroupConfig) ProtoMessage()               {}
func (*ManagedGroupConfig) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{4} }

func (m *ManagedGroupConfig) GetInstanceTemplateName() string {
	if m != nil {
		return m.InstanceTemplateName
	}
	return ""
}

func (m *ManagedGroupConfig) GetInstanceGroupManagerName() string {
	if m != nil {
		return m.InstanceGroupManagerName
	}
	return ""
}

// Specifies the type and number of accelerator cards attached to the instances
// of an instance group (see [GPUs on Compute Engine](/compute/docs/gpus/)).
type AcceleratorConfig struct {
	// Full URL, partial URI, or short name of the accelerator type resource to
	// expose to this instance. See [Google Compute Engine AcceleratorTypes](
	// /compute/docs/reference/beta/acceleratorTypes)
	//
	// Examples
	// * `https://www.googleapis.com/compute/beta/projects/[project_id]/zones/us-east1-a/acceleratorTypes/nvidia-tesla-k80`
	// * `projects/[project_id]/zones/us-east1-a/acceleratorTypes/nvidia-tesla-k80`
	// * `nvidia-tesla-k80`
	AcceleratorTypeUri string `protobuf:"bytes,1,opt,name=accelerator_type_uri,json=acceleratorTypeUri" json:"accelerator_type_uri,omitempty"`
	// The number of the accelerator cards of this type exposed to this instance.
	AcceleratorCount int32 `protobuf:"varint,2,opt,name=accelerator_count,json=acceleratorCount" json:"accelerator_count,omitempty"`
}

func (m *AcceleratorConfig) Reset()                    { *m = AcceleratorConfig{} }
func (m *AcceleratorConfig) String() string            { return proto.CompactTextString(m) }
func (*AcceleratorConfig) ProtoMessage()               {}
func (*AcceleratorConfig) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{5} }

func (m *AcceleratorConfig) GetAcceleratorTypeUri() string {
	if m != nil {
		return m.AcceleratorTypeUri
	}
	return ""
}

func (m *AcceleratorConfig) GetAcceleratorCount() int32 {
	if m != nil {
		return m.AcceleratorCount
	}
	return 0
}

// Specifies the config of disk options for a group of VM instances.
type DiskConfig struct {
	// Optional. Size in GB of the boot disk (default is 500GB).
	BootDiskSizeGb int32 `protobuf:"varint,1,opt,name=boot_disk_size_gb,json=bootDiskSizeGb" json:"boot_disk_size_gb,omitempty"`
	// Optional. Number of attached SSDs, from 0 to 4 (default is 0).
	// If SSDs are not attached, the boot disk is used to store runtime logs and
	// [HDFS](https://hadoop.apache.org/docs/r1.2.1/hdfs_user_guide.html) data.
	// If one or more SSDs are attached, this runtime bulk
	// data is spread across them, and the boot disk contains only basic
	// config and installed binaries.
	NumLocalSsds int32 `protobuf:"varint,2,opt,name=num_local_ssds,json=numLocalSsds" json:"num_local_ssds,omitempty"`
}

func (m *DiskConfig) Reset()                    { *m = DiskConfig{} }
func (m *DiskConfig) String() string            { return proto.CompactTextString(m) }
func (*DiskConfig) ProtoMessage()               {}
func (*DiskConfig) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{6} }

func (m *DiskConfig) GetBootDiskSizeGb() int32 {
	if m != nil {
		return m.BootDiskSizeGb
	}
	return 0
}

func (m *DiskConfig) GetNumLocalSsds() int32 {
	if m != nil {
		return m.NumLocalSsds
	}
	return 0
}

// Specifies the cluster auto delete related schedule configuration.
type LifecycleConfig struct {
	// Optional. The longest duration that cluster would keep alive while staying
	//  idle; passing this threshold will cause cluster to be auto-deleted.
	IdleDeleteTtl *google_protobuf3.Duration `protobuf:"bytes,1,opt,name=idle_delete_ttl,json=idleDeleteTtl" json:"idle_delete_ttl,omitempty"`
	// Types that are valid to be assigned to Ttl:
	//	*LifecycleConfig_AutoDeleteTime
	//	*LifecycleConfig_AutoDeleteTtl
	Ttl isLifecycleConfig_Ttl `protobuf_oneof:"ttl"`
}

func (m *LifecycleConfig) Reset()                    { *m = LifecycleConfig{} }
func (m *LifecycleConfig) String() string            { return proto.CompactTextString(m) }
func (*LifecycleConfig) ProtoMessage()               {}
func (*LifecycleConfig) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{7} }

type isLifecycleConfig_Ttl interface {
	isLifecycleConfig_Ttl()
}

type LifecycleConfig_AutoDeleteTime struct {
	AutoDeleteTime *google_protobuf5.Timestamp `protobuf:"bytes,2,opt,name=auto_delete_time,json=autoDeleteTime,oneof"`
}
type LifecycleConfig_AutoDeleteTtl struct {
	AutoDeleteTtl *google_protobuf3.Duration `protobuf:"bytes,3,opt,name=auto_delete_ttl,json=autoDeleteTtl,oneof"`
}

func (*LifecycleConfig_AutoDeleteTime) isLifecycleConfig_Ttl() {}
func (*LifecycleConfig_AutoDeleteTtl) isLifecycleConfig_Ttl()  {}

func (m *LifecycleConfig) GetTtl() isLifecycleConfig_Ttl {
	if m != nil {
		return m.Ttl
	}
	return nil
}

func (m *LifecycleConfig) GetIdleDeleteTtl() *google_protobuf3.Duration {
	if m != nil {
		return m.IdleDeleteTtl
	}
	return nil
}

func (m *LifecycleConfig) GetAutoDeleteTime() *google_protobuf5.Timestamp {
	if x, ok := m.GetTtl().(*LifecycleConfig_AutoDeleteTime); ok {
		return x.AutoDeleteTime
	}
	return nil
}

func (m *LifecycleConfig) GetAutoDeleteTtl() *google_protobuf3.Duration {
	if x, ok := m.GetTtl().(*LifecycleConfig_AutoDeleteTtl); ok {
		return x.AutoDeleteTtl
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*LifecycleConfig) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _LifecycleConfig_OneofMarshaler, _LifecycleConfig_OneofUnmarshaler, _LifecycleConfig_OneofSizer, []interface{}{
		(*LifecycleConfig_AutoDeleteTime)(nil),
		(*LifecycleConfig_AutoDeleteTtl)(nil),
	}
}

func _LifecycleConfig_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*LifecycleConfig)
	// ttl
	switch x := m.Ttl.(type) {
	case *LifecycleConfig_AutoDeleteTime:
		b.EncodeVarint(2<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.AutoDeleteTime); err != nil {
			return err
		}
	case *LifecycleConfig_AutoDeleteTtl:
		b.EncodeVarint(3<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.AutoDeleteTtl); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("LifecycleConfig.Ttl has unexpected type %T", x)
	}
	return nil
}

func _LifecycleConfig_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*LifecycleConfig)
	switch tag {
	case 2: // ttl.auto_delete_time
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(google_protobuf5.Timestamp)
		err := b.DecodeMessage(msg)
		m.Ttl = &LifecycleConfig_AutoDeleteTime{msg}
		return true, err
	case 3: // ttl.auto_delete_ttl
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(google_protobuf3.Duration)
		err := b.DecodeMessage(msg)
		m.Ttl = &LifecycleConfig_AutoDeleteTtl{msg}
		return true, err
	default:
		return false, nil
	}
}

func _LifecycleConfig_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*LifecycleConfig)
	// ttl
	switch x := m.Ttl.(type) {
	case *LifecycleConfig_AutoDeleteTime:
		s := proto.Size(x.AutoDeleteTime)
		n += proto.SizeVarint(2<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *LifecycleConfig_AutoDeleteTtl:
		s := proto.Size(x.AutoDeleteTtl)
		n += proto.SizeVarint(3<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// Specifies an executable to run on a fully configured node and a
// timeout period for executable completion.
type NodeInitializationAction struct {
	// Required. Google Cloud Storage URI of executable file.
	ExecutableFile string `protobuf:"bytes,1,opt,name=executable_file,json=executableFile" json:"executable_file,omitempty"`
	// Optional. Amount of time executable has to complete. Default is
	// 10 minutes. Cluster creation fails with an explanatory error message (the
	// name of the executable that caused the error and the exceeded timeout
	// period) if the executable is not completed at end of the timeout period.
	ExecutionTimeout *google_protobuf3.Duration `protobuf:"bytes,2,opt,name=execution_timeout,json=executionTimeout" json:"execution_timeout,omitempty"`
}

func (m *NodeInitializationAction) Reset()                    { *m = NodeInitializationAction{} }
func (m *NodeInitializationAction) String() string            { return proto.CompactTextString(m) }
func (*NodeInitializationAction) ProtoMessage()               {}
func (*NodeInitializationAction) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{8} }

func (m *NodeInitializationAction) GetExecutableFile() string {
	if m != nil {
		return m.ExecutableFile
	}
	return ""
}

func (m *NodeInitializationAction) GetExecutionTimeout() *google_protobuf3.Duration {
	if m != nil {
		return m.ExecutionTimeout
	}
	return nil
}

// The status of a cluster and its instances.
type ClusterStatus struct {
	// Output-only. The cluster's state.
	State ClusterStatus_State `protobuf:"varint,1,opt,name=state,enum=google.cloud.dataproc.v1beta2.ClusterStatus_State" json:"state,omitempty"`
	// Output-only. Optional details of cluster's state.
	Detail string `protobuf:"bytes,2,opt,name=detail" json:"detail,omitempty"`
	// Output-only. Time when this state was entered.
	StateStartTime *google_protobuf5.Timestamp `protobuf:"bytes,3,opt,name=state_start_time,json=stateStartTime" json:"state_start_time,omitempty"`
	// Output-only. Additional state information that includes
	// status reported by the agent.
	Substate ClusterStatus_Substate `protobuf:"varint,4,opt,name=substate,enum=google.cloud.dataproc.v1beta2.ClusterStatus_Substate" json:"substate,omitempty"`
}

func (m *ClusterStatus) Reset()                    { *m = ClusterStatus{} }
func (m *ClusterStatus) String() string            { return proto.CompactTextString(m) }
func (*ClusterStatus) ProtoMessage()               {}
func (*ClusterStatus) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{9} }

func (m *ClusterStatus) GetState() ClusterStatus_State {
	if m != nil {
		return m.State
	}
	return ClusterStatus_UNKNOWN
}

func (m *ClusterStatus) GetDetail() string {
	if m != nil {
		return m.Detail
	}
	return ""
}

func (m *ClusterStatus) GetStateStartTime() *google_protobuf5.Timestamp {
	if m != nil {
		return m.StateStartTime
	}
	return nil
}

func (m *ClusterStatus) GetSubstate() ClusterStatus_Substate {
	if m != nil {
		return m.Substate
	}
	return ClusterStatus_UNSPECIFIED
}

// Specifies the selection and config of software inside the cluster.
type SoftwareConfig struct {
	// Optional. The version of software inside the cluster. It must match the
	// regular expression `[0-9]+\.[0-9]+`. If unspecified, it defaults to the
	// latest version (see [Cloud Dataproc Versioning](/dataproc/versioning)).
	ImageVersion string `protobuf:"bytes,1,opt,name=image_version,json=imageVersion" json:"image_version,omitempty"`
	// Optional. The properties to set on daemon config files.
	//
	// Property keys are specified in `prefix:property` format, such as
	// `core:fs.defaultFS`. The following are supported prefixes
	// and their mappings:
	//
	// * capacity-scheduler: `capacity-scheduler.xml`
	// * core:   `core-site.xml`
	// * distcp: `distcp-default.xml`
	// * hdfs:   `hdfs-site.xml`
	// * hive:   `hive-site.xml`
	// * mapred: `mapred-site.xml`
	// * pig:    `pig.properties`
	// * spark:  `spark-defaults.conf`
	// * yarn:   `yarn-site.xml`
	//
	// For more information, see
	// [Cluster properties](/dataproc/docs/concepts/cluster-properties).
	Properties map[string]string `protobuf:"bytes,2,rep,name=properties" json:"properties,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
}

func (m *SoftwareConfig) Reset()                    { *m = SoftwareConfig{} }
func (m *SoftwareConfig) String() string            { return proto.CompactTextString(m) }
func (*SoftwareConfig) ProtoMessage()               {}
func (*SoftwareConfig) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{10} }

func (m *SoftwareConfig) GetImageVersion() string {
	if m != nil {
		return m.ImageVersion
	}
	return ""
}

func (m *SoftwareConfig) GetProperties() map[string]string {
	if m != nil {
		return m.Properties
	}
	return nil
}

// Contains cluster daemon metrics, such as HDFS and YARN stats.
//
// **Beta Feature**: This report is available for testing purposes only. It may
// be changed before final release.
type ClusterMetrics struct {
	// The HDFS metrics.
	HdfsMetrics map[string]int64 `protobuf:"bytes,1,rep,name=hdfs_metrics,json=hdfsMetrics" json:"hdfs_metrics,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"varint,2,opt,name=value"`
	// The YARN metrics.
	YarnMetrics map[string]int64 `protobuf:"bytes,2,rep,name=yarn_metrics,json=yarnMetrics" json:"yarn_metrics,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"varint,2,opt,name=value"`
}

func (m *ClusterMetrics) Reset()                    { *m = ClusterMetrics{} }
func (m *ClusterMetrics) String() string            { return proto.CompactTextString(m) }
func (*ClusterMetrics) ProtoMessage()               {}
func (*ClusterMetrics) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{11} }

func (m *ClusterMetrics) GetHdfsMetrics() map[string]int64 {
	if m != nil {
		return m.HdfsMetrics
	}
	return nil
}

func (m *ClusterMetrics) GetYarnMetrics() map[string]int64 {
	if m != nil {
		return m.YarnMetrics
	}
	return nil
}

// A request to create a cluster.
type CreateClusterRequest struct {
	// Required. The ID of the Google Cloud Platform project that the cluster
	// belongs to.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId" json:"project_id,omitempty"`
	// Required. The Cloud Dataproc region in which to handle the request.
	Region string `protobuf:"bytes,3,opt,name=region" json:"region,omitempty"`
	// Required. The cluster to create.
	Cluster *Cluster `protobuf:"bytes,2,opt,name=cluster" json:"cluster,omitempty"`
}

func (m *CreateClusterRequest) Reset()                    { *m = CreateClusterRequest{} }
func (m *CreateClusterRequest) String() string            { return proto.CompactTextString(m) }
func (*CreateClusterRequest) ProtoMessage()               {}
func (*CreateClusterRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{12} }

func (m *CreateClusterRequest) GetProjectId() string {
	if m != nil {
		return m.ProjectId
	}
	return ""
}

func (m *CreateClusterRequest) GetRegion() string {
	if m != nil {
		return m.Region
	}
	return ""
}

func (m *CreateClusterRequest) GetCluster() *Cluster {
	if m != nil {
		return m.Cluster
	}
	return nil
}

// A request to update a cluster.
type UpdateClusterRequest struct {
	// Required. The ID of the Google Cloud Platform project the
	// cluster belongs to.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId" json:"project_id,omitempty"`
	// Required. The Cloud Dataproc region in which to handle the request.
	Region string `protobuf:"bytes,5,opt,name=region" json:"region,omitempty"`
	// Required. The cluster name.
	ClusterName string `protobuf:"bytes,2,opt,name=cluster_name,json=clusterName" json:"cluster_name,omitempty"`
	// Required. The changes to the cluster.
	Cluster *Cluster `protobuf:"bytes,3,opt,name=cluster" json:"cluster,omitempty"`
	// Optional. Timeout for graceful YARN decomissioning. Graceful
	// decommissioning allows removing nodes from the cluster without
	// interrupting jobs in progress. Timeout specifies how long to wait for jobs
	// in progress to finish before forcefully removing nodes (and potentially
	// interrupting jobs). Default timeout is 0 (for forceful decommission), and
	// the maximum allowed timeout is 1 day.
	//
	// Only supported on Dataproc image versions 1.2 and higher.
	GracefulDecommissionTimeout *google_protobuf3.Duration `protobuf:"bytes,6,opt,name=graceful_decommission_timeout,json=gracefulDecommissionTimeout" json:"graceful_decommission_timeout,omitempty"`
	// Required. Specifies the path, relative to <code>Cluster</code>, of
	// the field to update. For example, to change the number of workers
	// in a cluster to 5, the <code>update_mask</code> parameter would be
	// specified as <code>config.worker_config.num_instances</code>,
	// and the `PATCH` request body would specify the new value, as follows:
	//
	//     {
	//       "config":{
	//         "workerConfig":{
	//           "numInstances":"5"
	//         }
	//       }
	//     }
	// Similarly, to change the number of preemptible workers in a cluster to 5, the
	// <code>update_mask</code> parameter would be <code>config.secondary_worker_config.num_instances</code>,
	// and the `PATCH` request body would be set as follows:
	//
	//     {
	//       "config":{
	//         "secondaryWorkerConfig":{
	//           "numInstances":"5"
	//         }
	//       }
	//     }
	// <strong>Note:</strong> currently only some fields can be updated:
	// |Mask|Purpose|
	// |`labels`|Updates labels|
	// |`config.worker_config.num_instances`|Resize primary worker group|
	// |`config.secondary_worker_config.num_instances`|Resize secondary worker group|
	UpdateMask *google_protobuf4.FieldMask `protobuf:"bytes,4,opt,name=update_mask,json=updateMask" json:"update_mask,omitempty"`
}

func (m *UpdateClusterRequest) Reset()                    { *m = UpdateClusterRequest{} }
func (m *UpdateClusterRequest) String() string            { return proto.CompactTextString(m) }
func (*UpdateClusterRequest) ProtoMessage()               {}
func (*UpdateClusterRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{13} }

func (m *UpdateClusterRequest) GetProjectId() string {
	if m != nil {
		return m.ProjectId
	}
	return ""
}

func (m *UpdateClusterRequest) GetRegion() string {
	if m != nil {
		return m.Region
	}
	return ""
}

func (m *UpdateClusterRequest) GetClusterName() string {
	if m != nil {
		return m.ClusterName
	}
	return ""
}

func (m *UpdateClusterRequest) GetCluster() *Cluster {
	if m != nil {
		return m.Cluster
	}
	return nil
}

func (m *UpdateClusterRequest) GetGracefulDecommissionTimeout() *google_protobuf3.Duration {
	if m != nil {
		return m.GracefulDecommissionTimeout
	}
	return nil
}

func (m *UpdateClusterRequest) GetUpdateMask() *google_protobuf4.FieldMask {
	if m != nil {
		return m.UpdateMask
	}
	return nil
}

// A request to delete a cluster.
type DeleteClusterRequest struct {
	// Required. The ID of the Google Cloud Platform project that the cluster
	// belongs to.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId" json:"project_id,omitempty"`
	// Required. The Cloud Dataproc region in which to handle the request.
	Region string `protobuf:"bytes,3,opt,name=region" json:"region,omitempty"`
	// Required. The cluster name.
	ClusterName string `protobuf:"bytes,2,opt,name=cluster_name,json=clusterName" json:"cluster_name,omitempty"`
	// Optional. Specifying the `cluster_uuid` means the RPC should fail
	// (with error NOT_FOUND) if cluster with specified UUID does not exist.
	ClusterUuid string `protobuf:"bytes,4,opt,name=cluster_uuid,json=clusterUuid" json:"cluster_uuid,omitempty"`
}

func (m *DeleteClusterRequest) Reset()                    { *m = DeleteClusterRequest{} }
func (m *DeleteClusterRequest) String() string            { return proto.CompactTextString(m) }
func (*DeleteClusterRequest) ProtoMessage()               {}
func (*DeleteClusterRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{14} }

func (m *DeleteClusterRequest) GetProjectId() string {
	if m != nil {
		return m.ProjectId
	}
	return ""
}

func (m *DeleteClusterRequest) GetRegion() string {
	if m != nil {
		return m.Region
	}
	return ""
}

func (m *DeleteClusterRequest) GetClusterName() string {
	if m != nil {
		return m.ClusterName
	}
	return ""
}

func (m *DeleteClusterRequest) GetClusterUuid() string {
	if m != nil {
		return m.ClusterUuid
	}
	return ""
}

// Request to get the resource representation for a cluster in a project.
type GetClusterRequest struct {
	// Required. The ID of the Google Cloud Platform project that the cluster
	// belongs to.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId" json:"project_id,omitempty"`
	// Required. The Cloud Dataproc region in which to handle the request.
	Region string `protobuf:"bytes,3,opt,name=region" json:"region,omitempty"`
	// Required. The cluster name.
	ClusterName string `protobuf:"bytes,2,opt,name=cluster_name,json=clusterName" json:"cluster_name,omitempty"`
}

func (m *GetClusterRequest) Reset()                    { *m = GetClusterRequest{} }
func (m *GetClusterRequest) String() string            { return proto.CompactTextString(m) }
func (*GetClusterRequest) ProtoMessage()               {}
func (*GetClusterRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{15} }

func (m *GetClusterRequest) GetProjectId() string {
	if m != nil {
		return m.ProjectId
	}
	return ""
}

func (m *GetClusterRequest) GetRegion() string {
	if m != nil {
		return m.Region
	}
	return ""
}

func (m *GetClusterRequest) GetClusterName() string {
	if m != nil {
		return m.ClusterName
	}
	return ""
}

// A request to list the clusters in a project.
type ListClustersRequest struct {
	// Required. The ID of the Google Cloud Platform project that the cluster
	// belongs to.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId" json:"project_id,omitempty"`
	// Required. The Cloud Dataproc region in which to handle the request.
	Region string `protobuf:"bytes,4,opt,name=region" json:"region,omitempty"`
	// Optional. A filter constraining the clusters to list. Filters are
	// case-sensitive and have the following syntax:
	//
	// field = value [AND [field = value]] ...
	//
	// where **field** is one of `status.state`, `clusterName`, or `labels.[KEY]`,
	// and `[KEY]` is a label key. **value** can be `*` to match all values.
	// `status.state` can be one of the following: `ACTIVE`, `INACTIVE`,
	// `CREATING`, `RUNNING`, `ERROR`, `DELETING`, or `UPDATING`. `ACTIVE`
	// contains the `CREATING`, `UPDATING`, and `RUNNING` states. `INACTIVE`
	// contains the `DELETING` and `ERROR` states.
	// `clusterName` is the name of the cluster provided at creation time.
	// Only the logical `AND` operator is supported; space-separated items are
	// treated as having an implicit `AND` operator.
	//
	// Example filter:
	//
	// status.state = ACTIVE AND clusterName = mycluster
	// AND labels.env = staging AND labels.starred = *
	Filter string `protobuf:"bytes,5,opt,name=filter" json:"filter,omitempty"`
	// Optional. The standard List page size.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize" json:"page_size,omitempty"`
	// Optional. The standard List page token.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken" json:"page_token,omitempty"`
}

func (m *ListClustersRequest) Reset()                    { *m = ListClustersRequest{} }
func (m *ListClustersRequest) String() string            { return proto.CompactTextString(m) }
func (*ListClustersRequest) ProtoMessage()               {}
func (*ListClustersRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{16} }

func (m *ListClustersRequest) GetProjectId() string {
	if m != nil {
		return m.ProjectId
	}
	return ""
}

func (m *ListClustersRequest) GetRegion() string {
	if m != nil {
		return m.Region
	}
	return ""
}

func (m *ListClustersRequest) GetFilter() string {
	if m != nil {
		return m.Filter
	}
	return ""
}

func (m *ListClustersRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListClustersRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

// The list of all clusters in a project.
type ListClustersResponse struct {
	// Output-only. The clusters in the project.
	Clusters []*Cluster `protobuf:"bytes,1,rep,name=clusters" json:"clusters,omitempty"`
	// Output-only. This token is included in the response if there are more
	// results to fetch. To fetch additional results, provide this value as the
	// `page_token` in a subsequent <code>ListClustersRequest</code>.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken" json:"next_page_token,omitempty"`
}

func (m *ListClustersResponse) Reset()                    { *m = ListClustersResponse{} }
func (m *ListClustersResponse) String() string            { return proto.CompactTextString(m) }
func (*ListClustersResponse) ProtoMessage()               {}
func (*ListClustersResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{17} }

func (m *ListClustersResponse) GetClusters() []*Cluster {
	if m != nil {
		return m.Clusters
	}
	return nil
}

func (m *ListClustersResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

// A request to collect cluster diagnostic information.
type DiagnoseClusterRequest struct {
	// Required. The ID of the Google Cloud Platform project that the cluster
	// belongs to.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId" json:"project_id,omitempty"`
	// Required. The Cloud Dataproc region in which to handle the request.
	Region string `protobuf:"bytes,3,opt,name=region" json:"region,omitempty"`
	// Required. The cluster name.
	ClusterName string `protobuf:"bytes,2,opt,name=cluster_name,json=clusterName" json:"cluster_name,omitempty"`
}

func (m *DiagnoseClusterRequest) Reset()                    { *m = DiagnoseClusterRequest{} }
func (m *DiagnoseClusterRequest) String() string            { return proto.CompactTextString(m) }
func (*DiagnoseClusterRequest) ProtoMessage()               {}
func (*DiagnoseClusterRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{18} }

func (m *DiagnoseClusterRequest) GetProjectId() string {
	if m != nil {
		return m.ProjectId
	}
	return ""
}

func (m *DiagnoseClusterRequest) GetRegion() string {
	if m != nil {
		return m.Region
	}
	return ""
}

func (m *DiagnoseClusterRequest) GetClusterName() string {
	if m != nil {
		return m.ClusterName
	}
	return ""
}

// The location of diagnostic output.
type DiagnoseClusterResults struct {
	// Output-only. The Google Cloud Storage URI of the diagnostic output.
	// The output report is a plain text file with a summary of collected
	// diagnostics.
	OutputUri string `protobuf:"bytes,1,opt,name=output_uri,json=outputUri" json:"output_uri,omitempty"`
}

func (m *DiagnoseClusterResults) Reset()                    { *m = DiagnoseClusterResults{} }
func (m *DiagnoseClusterResults) String() string            { return proto.CompactTextString(m) }
func (*DiagnoseClusterResults) ProtoMessage()               {}
func (*DiagnoseClusterResults) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{19} }

func (m *DiagnoseClusterResults) GetOutputUri() string {
	if m != nil {
		return m.OutputUri
	}
	return ""
}

func init() {
	proto.RegisterType((*Cluster)(nil), "google.cloud.dataproc.v1beta2.Cluster")
	proto.RegisterType((*ClusterConfig)(nil), "google.cloud.dataproc.v1beta2.ClusterConfig")
	proto.RegisterType((*GceClusterConfig)(nil), "google.cloud.dataproc.v1beta2.GceClusterConfig")
	proto.RegisterType((*InstanceGroupConfig)(nil), "google.cloud.dataproc.v1beta2.InstanceGroupConfig")
	proto.RegisterType((*ManagedGroupConfig)(nil), "google.cloud.dataproc.v1beta2.ManagedGroupConfig")
	proto.RegisterType((*AcceleratorConfig)(nil), "google.cloud.dataproc.v1beta2.AcceleratorConfig")
	proto.RegisterType((*DiskConfig)(nil), "google.cloud.dataproc.v1beta2.DiskConfig")
	proto.RegisterType((*LifecycleConfig)(nil), "google.cloud.dataproc.v1beta2.LifecycleConfig")
	proto.RegisterType((*NodeInitializationAction)(nil), "google.cloud.dataproc.v1beta2.NodeInitializationAction")
	proto.RegisterType((*ClusterStatus)(nil), "google.cloud.dataproc.v1beta2.ClusterStatus")
	proto.RegisterType((*SoftwareConfig)(nil), "google.cloud.dataproc.v1beta2.SoftwareConfig")
	proto.RegisterType((*ClusterMetrics)(nil), "google.cloud.dataproc.v1beta2.ClusterMetrics")
	proto.RegisterType((*CreateClusterRequest)(nil), "google.cloud.dataproc.v1beta2.CreateClusterRequest")
	proto.RegisterType((*UpdateClusterRequest)(nil), "google.cloud.dataproc.v1beta2.UpdateClusterRequest")
	proto.RegisterType((*DeleteClusterRequest)(nil), "google.cloud.dataproc.v1beta2.DeleteClusterRequest")
	proto.RegisterType((*GetClusterRequest)(nil), "google.cloud.dataproc.v1beta2.GetClusterRequest")
	proto.RegisterType((*ListClustersRequest)(nil), "google.cloud.dataproc.v1beta2.ListClustersRequest")
	proto.RegisterType((*ListClustersResponse)(nil), "google.cloud.dataproc.v1beta2.ListClustersResponse")
	proto.RegisterType((*DiagnoseClusterRequest)(nil), "google.cloud.dataproc.v1beta2.DiagnoseClusterRequest")
	proto.RegisterType((*DiagnoseClusterResults)(nil), "google.cloud.dataproc.v1beta2.DiagnoseClusterResults")
	proto.RegisterEnum("google.cloud.dataproc.v1beta2.ClusterStatus_State", ClusterStatus_State_name, ClusterStatus_State_value)
	proto.RegisterEnum("google.cloud.dataproc.v1beta2.ClusterStatus_Substate", ClusterStatus_Substate_name, ClusterStatus_Substate_value)
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// Client API for ClusterController service

type ClusterControllerClient interface {
	// Creates a cluster in a project.
	CreateCluster(ctx context.Context, in *CreateClusterRequest, opts ...grpc.CallOption) (*google_longrunning.Operation, error)
	// Updates a cluster in a project.
	UpdateCluster(ctx context.Context, in *UpdateClusterRequest, opts ...grpc.CallOption) (*google_longrunning.Operation, error)
	// Deletes a cluster in a project.
	DeleteCluster(ctx context.Context, in *DeleteClusterRequest, opts ...grpc.CallOption) (*google_longrunning.Operation, error)
	// Gets the resource representation for a cluster in a project.
	GetCluster(ctx context.Context, in *GetClusterRequest, opts ...grpc.CallOption) (*Cluster, error)
	// Lists all regions/{region}/clusters in a project.
	ListClusters(ctx context.Context, in *ListClustersRequest, opts ...grpc.CallOption) (*ListClustersResponse, error)
	// Gets cluster diagnostic information.
	// After the operation completes, the Operation.response field
	// contains `DiagnoseClusterOutputLocation`.
	DiagnoseCluster(ctx context.Context, in *DiagnoseClusterRequest, opts ...grpc.CallOption) (*google_longrunning.Operation, error)
}

type clusterControllerClient struct {
	cc *grpc.ClientConn
}

func NewClusterControllerClient(cc *grpc.ClientConn) ClusterControllerClient {
	return &clusterControllerClient{cc}
}

func (c *clusterControllerClient) CreateCluster(ctx context.Context, in *CreateClusterRequest, opts ...grpc.CallOption) (*google_longrunning.Operation, error) {
	out := new(google_longrunning.Operation)
	err := grpc.Invoke(ctx, "/google.cloud.dataproc.v1beta2.ClusterController/CreateCluster", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clusterControllerClient) UpdateCluster(ctx context.Context, in *UpdateClusterRequest, opts ...grpc.CallOption) (*google_longrunning.Operation, error) {
	out := new(google_longrunning.Operation)
	err := grpc.Invoke(ctx, "/google.cloud.dataproc.v1beta2.ClusterController/UpdateCluster", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clusterControllerClient) DeleteCluster(ctx context.Context, in *DeleteClusterRequest, opts ...grpc.CallOption) (*google_longrunning.Operation, error) {
	out := new(google_longrunning.Operation)
	err := grpc.Invoke(ctx, "/google.cloud.dataproc.v1beta2.ClusterController/DeleteCluster", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clusterControllerClient) GetCluster(ctx context.Context, in *GetClusterRequest, opts ...grpc.CallOption) (*Cluster, error) {
	out := new(Cluster)
	err := grpc.Invoke(ctx, "/google.cloud.dataproc.v1beta2.ClusterController/GetCluster", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clusterControllerClient) ListClusters(ctx context.Context, in *ListClustersRequest, opts ...grpc.CallOption) (*ListClustersResponse, error) {
	out := new(ListClustersResponse)
	err := grpc.Invoke(ctx, "/google.cloud.dataproc.v1beta2.ClusterController/ListClusters", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clusterControllerClient) DiagnoseCluster(ctx context.Context, in *DiagnoseClusterRequest, opts ...grpc.CallOption) (*google_longrunning.Operation, error) {
	out := new(google_longrunning.Operation)
	err := grpc.Invoke(ctx, "/google.cloud.dataproc.v1beta2.ClusterController/DiagnoseCluster", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Server API for ClusterController service

type ClusterControllerServer interface {
	// Creates a cluster in a project.
	CreateCluster(context.Context, *CreateClusterRequest) (*google_longrunning.Operation, error)
	// Updates a cluster in a project.
	UpdateCluster(context.Context, *UpdateClusterRequest) (*google_longrunning.Operation, error)
	// Deletes a cluster in a project.
	DeleteCluster(context.Context, *DeleteClusterRequest) (*google_longrunning.Operation, error)
	// Gets the resource representation for a cluster in a project.
	GetCluster(context.Context, *GetClusterRequest) (*Cluster, error)
	// Lists all regions/{region}/clusters in a project.
	ListClusters(context.Context, *ListClustersRequest) (*ListClustersResponse, error)
	// Gets cluster diagnostic information.
	// After the operation completes, the Operation.response field
	// contains `DiagnoseClusterOutputLocation`.
	DiagnoseCluster(context.Context, *DiagnoseClusterRequest) (*google_longrunning.Operation, error)
}

func RegisterClusterControllerServer(s *grpc.Server, srv ClusterControllerServer) {
	s.RegisterService(&_ClusterController_serviceDesc, srv)
}

func _ClusterController_CreateCluster_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateClusterRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterControllerServer).CreateCluster(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dataproc.v1beta2.ClusterController/CreateCluster",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterControllerServer).CreateCluster(ctx, req.(*CreateClusterRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClusterController_UpdateCluster_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateClusterRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterControllerServer).UpdateCluster(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dataproc.v1beta2.ClusterController/UpdateCluster",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterControllerServer).UpdateCluster(ctx, req.(*UpdateClusterRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClusterController_DeleteCluster_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteClusterRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterControllerServer).DeleteCluster(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dataproc.v1beta2.ClusterController/DeleteCluster",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterControllerServer).DeleteCluster(ctx, req.(*DeleteClusterRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClusterController_GetCluster_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetClusterRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterControllerServer).GetCluster(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dataproc.v1beta2.ClusterController/GetCluster",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterControllerServer).GetCluster(ctx, req.(*GetClusterRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClusterController_ListClusters_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListClustersRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterControllerServer).ListClusters(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dataproc.v1beta2.ClusterController/ListClusters",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterControllerServer).ListClusters(ctx, req.(*ListClustersRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClusterController_DiagnoseCluster_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DiagnoseClusterRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterControllerServer).DiagnoseCluster(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dataproc.v1beta2.ClusterController/DiagnoseCluster",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterControllerServer).DiagnoseCluster(ctx, req.(*DiagnoseClusterRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _ClusterController_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.dataproc.v1beta2.ClusterController",
	HandlerType: (*ClusterControllerServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "CreateCluster",
			Handler:    _ClusterController_CreateCluster_Handler,
		},
		{
			MethodName: "UpdateCluster",
			Handler:    _ClusterController_UpdateCluster_Handler,
		},
		{
			MethodName: "DeleteCluster",
			Handler:    _ClusterController_DeleteCluster_Handler,
		},
		{
			MethodName: "GetCluster",
			Handler:    _ClusterController_GetCluster_Handler,
		},
		{
			MethodName: "ListClusters",
			Handler:    _ClusterController_ListClusters_Handler,
		},
		{
			MethodName: "DiagnoseCluster",
			Handler:    _ClusterController_DiagnoseCluster_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/dataproc/v1beta2/clusters.proto",
}

func init() { proto.RegisterFile("google/cloud/dataproc/v1beta2/clusters.proto", fileDescriptor0) }

var fileDescriptor0 = []byte{
	// 2093 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xbc, 0x59, 0xcd, 0x72, 0x1b, 0xc7,
	0x11, 0xd6, 0x12, 0x04, 0x09, 0x36, 0x08, 0x10, 0x1c, 0xd3, 0x0c, 0x4c, 0x45, 0xb1, 0xbc, 0x4e,
	0x1c, 0xda, 0x71, 0x00, 0x9b, 0x8a, 0xcb, 0x8e, 0x14, 0xb9, 0x4c, 0x91, 0x14, 0x49, 0x87, 0xa2,
	0x98, 0x05, 0x20, 0x45, 0x49, 0xa9, 0xb6, 0x06, 0xbb, 0x43, 0x68, 0xcc, 0xfd, 0xcb, 0xce, 0xac,
	0x6c, 0x48, 0xa5, 0x8b, 0x6f, 0xa9, 0x1c, 0x72, 0xf0, 0x03, 0xc4, 0xe7, 0x1c, 0x72, 0x4a, 0x55,
	0x2a, 0x87, 0xdc, 0x72, 0xce, 0xc5, 0xa9, 0x3c, 0x41, 0x0e, 0x79, 0x84, 0x1c, 0x53, 0xf3, 0xb3,
	0xc0, 0x2e, 0x48, 0x69, 0x09, 0x46, 0xe5, 0x13, 0x76, 0x7a, 0xfa, 0xe7, 0x9b, 0xee, 0x9e, 0x9e,
	0x9e, 0x01, 0xbc, 0x3b, 0x08, 0xc3, 0x81, 0x47, 0xda, 0x8e, 0x17, 0x26, 0x6e, 0xdb, 0xc5, 0x1c,
	0x47, 0x71, 0xe8, 0xb4, 0x1f, 0xbf, 0xdf, 0x27, 0x1c, 0x6f, 0xb4, 0x1d, 0x2f, 0x61, 0x9c, 0xc4,
	0xac, 0x15, 0xc5, 0x21, 0x0f, 0xd1, 0x15, 0xc5, 0xdd, 0x92, 0xdc, 0xad, 0x94, 0xbb, 0xa5, 0xb9,
	0xd7, 0xbe, 0xab, 0x95, 0xe1, 0x88, 0xb6, 0x71, 0x10, 0x84, 0x1c, 0x73, 0x1a, 0x06, 0x5a, 0x78,
	0xed, 0x4d, 0x3d, 0xeb, 0x85, 0xc1, 0x20, 0x4e, 0x82, 0x80, 0x06, 0x83, 0x76, 0x18, 0x91, 0x38,
	0xc7, 0xf4, 0x3d, 0xcd, 0x24, 0x47, 0xfd, 0xe4, 0xb8, 0xed, 0x26, 0x8a, 0x41, 0xcf, 0x5f, 0x9d,
	0x9c, 0x3f, 0xa6, 0xc4, 0x73, 0x6d, 0x1f, 0xb3, 0x13, 0xcd, 0xf1, 0xfa, 0x24, 0x07, 0xa7, 0x3e,
	0x61, 0x1c, 0xfb, 0x91, 0x62, 0x30, 0xff, 0x30, 0x0b, 0xf3, 0x5b, 0x6a, 0x5d, 0xe8, 0x0a, 0x40,
	0x14, 0x87, 0x9f, 0x11, 0x87, 0xdb, 0xd4, 0x6d, 0x1a, 0x57, 0x8d, 0xf5, 0x05, 0x6b, 0x41, 0x53,
	0xf6, 0x5d, 0xf4, 0x06, 0x2c, 0x6a, 0x0f, 0xd8, 0x01, 0xf6, 0x49, 0x73, 0x46, 0x32, 0x54, 0x35,
	0xed, 0x10, 0xfb, 0x04, 0x6d, 0xc3, 0x9c, 0x13, 0x06, 0xc7, 0x74, 0xd0, 0x2c, 0x5d, 0x35, 0xd6,
	0xab, 0x1b, 0xef, 0xb6, 0x5e, 0xe8, 0xa3, 0x96, 0xb6, 0xbc, 0x25, 0x65, 0x2c, 0x2d, 0x8b, 0x3e,
	0x85, 0x39, 0x0f, 0xf7, 0x89, 0xc7, 0x9a, 0x95, 0xab, 0xa5, 0xf5, 0xea, 0xc6, 0xc6, 0xf9, 0xb4,
	0xb4, 0x0e, 0xa4, 0xd0, 0x4e, 0xc0, 0xe3, 0xa1, 0xa5, 0x35, 0x08, 0x44, 0x8c, 0x63, 0x9e, 0xb0,
	0xe6, 0xec, 0x34, 0x88, 0x3a, 0x52, 0xc6, 0xd2, 0xb2, 0xa8, 0x03, 0x75, 0xf5, 0x65, 0x3f, 0xa2,
	0x8c, 0x87, 0xf1, 0xb0, 0x39, 0x2f, 0x91, 0x4d, 0xa7, 0xad, 0xa6, 0x74, 0xec, 0x29, 0x15, 0x59,
	0x7f, 0x26, 0x09, 0x75, 0x9b, 0x73, 0x39, 0x7f, 0xf6, 0x12, 0xea, 0xa2, 0x5d, 0x98, 0xf7, 0x09,
	0x8f, 0xa9, 0xc3, 0x9a, 0x0b, 0x12, 0xfe, 0x8f, 0xcf, 0x67, 0xf0, 0x8e, 0x12, 0xb2, 0x52, 0xe9,
	0xb5, 0x9f, 0x42, 0x35, 0xe3, 0x1d, 0xd4, 0x80, 0xd2, 0x09, 0x19, 0xea, 0x10, 0x8b, 0x4f, 0xb4,
	0x02, 0xe5, 0xc7, 0xd8, 0x4b, 0xd2, 0xa8, 0xaa, 0xc1, 0xf5, 0x99, 0x8f, 0x0c, 0xf3, 0x9f, 0x65,
	0xa8, 0xe5, 0xe2, 0x84, 0xde, 0x84, 0x9a, 0x8a, 0x94, 0xdd, 0x4f, 0x9c, 0x13, 0xc2, 0xb5, 0x9e,
	0x45, 0x45, 0xbc, 0x25, 0x69, 0xe8, 0x21, 0xa0, 0x81, 0x43, 0xec, 0x74, 0x85, 0x3a, 0x2d, 0x2a,
	0x72, 0x15, 0xed, 0x82, 0x55, 0xec, 0x3a, 0x24, 0x9f, 0x19, 0x8d, 0xc1, 0x04, 0x05, 0xdd, 0x87,
	0x9a, 0x8f, 0xb3, 0x9a, 0x95, 0x7f, 0x8a, 0x52, 0x65, 0x3f, 0x60, 0x1c, 0x07, 0x0e, 0xd9, 0x8d,
	0xc3, 0x24, 0xd2, 0xca, 0x17, 0x95, 0xa2, 0xb1, 0xe2, 0xcf, 0xc3, 0xf8, 0x64, 0xac, 0x18, 0x2e,
	0xae, 0x58, 0x29, 0xd2, 0x8a, 0x3f, 0x83, 0xef, 0x30, 0xe2, 0x84, 0x81, 0x8b, 0xe3, 0xa1, 0x9d,
	0x37, 0xb1, 0x78, 0x61, 0x13, 0xaf, 0x8e, 0x54, 0xde, 0xcf, 0xda, 0xba, 0x07, 0x4b, 0x2c, 0x3c,
	0xe6, 0x9f, 0xe3, 0x98, 0xa4, 0x36, 0x6a, 0xe7, 0xca, 0x9f, 0x8e, 0x96, 0xd2, 0xea, 0xeb, 0x2c,
	0x37, 0x46, 0x0f, 0xa0, 0xe1, 0xd1, 0x63, 0xe2, 0x0c, 0x1d, 0x6f, 0xa4, 0xb8, 0x2e, 0x15, 0xb7,
	0x0a, 0x14, 0x1f, 0xa4, 0x62, 0x5a, 0xf3, 0x92, 0x97, 0x27, 0xa0, 0x00, 0x56, 0x69, 0x40, 0x39,
	0xc5, 0x1e, 0x7d, 0x22, 0x6b, 0x9c, 0x8d, 0x1d, 0x59, 0x0b, 0x9b, 0x55, 0xb9, 0xd5, 0x3e, 0x2c,
	0x30, 0x70, 0x18, 0xba, 0x64, 0x3f, 0xa7, 0x60, 0x53, 0xca, 0x5b, 0xaf, 0xd2, 0x33, 0xa8, 0xcc,
	0xfc, 0x63, 0x09, 0x1a, 0x93, 0x79, 0x86, 0x5e, 0x83, 0xca, 0x93, 0x30, 0x20, 0x76, 0x12, 0x53,
	0x9d, 0xd4, 0xf3, 0x62, 0xdc, 0x8b, 0x29, 0x7a, 0x1d, 0xaa, 0x01, 0xe1, 0x22, 0x6e, 0x72, 0x56,
	0x6d, 0x13, 0xd0, 0x24, 0xc1, 0xf0, 0x03, 0xa8, 0xb3, 0xa4, 0x9f, 0xe5, 0x51, 0x1b, 0xba, 0x36,
	0xa6, 0x0a, 0xb6, 0x75, 0x68, 0xd0, 0x80, 0x93, 0x38, 0xc0, 0x9e, 0x4d, 0x23, 0x3b, 0x0c, 0x3c,
	0x51, 0x4c, 0x8c, 0xf5, 0x8a, 0x55, 0x4f, 0xe9, 0xfb, 0xd1, 0xdd, 0xc0, 0x1b, 0xa2, 0x1f, 0xc2,
	0x12, 0x23, 0xf1, 0x63, 0xea, 0x10, 0x1b, 0x3b, 0x4e, 0x98, 0x04, 0x5c, 0x6e, 0x9f, 0x05, 0xab,
	0xae, 0xc9, 0x9b, 0x8a, 0x8a, 0x7e, 0x02, 0xab, 0x13, 0x8c, 0x36, 0x73, 0xc2, 0x88, 0xb0, 0x66,
	0xe9, 0x6a, 0x69, 0x7d, 0xc1, 0x5a, 0xc9, 0xf3, 0x77, 0xe4, 0x1c, 0x42, 0x30, 0xcb, 0xf1, 0x40,
	0xd4, 0x45, 0xc1, 0x23, 0xbf, 0xd1, 0x03, 0xa8, 0xf8, 0x84, 0x63, 0xe1, 0xdc, 0x66, 0x59, 0xba,
	0xfd, 0xe6, 0x94, 0x5b, 0xb5, 0x75, 0x47, 0xcb, 0xab, 0x32, 0x3c, 0x52, 0xb7, 0x76, 0x03, 0x6a,
	0xb9, 0xa9, 0xa9, 0x6a, 0xd0, 0xbf, 0x4a, 0xf0, 0xca, 0x19, 0xe9, 0x2f, 0x2a, 0x51, 0x90, 0xf8,
	0x36, 0xd5, 0x53, 0x4c, 0x6a, 0x2b, 0x5b, 0x8b, 0x41, 0xe2, 0xa7, 0xec, 0x4c, 0x04, 0x26, 0x65,
	0x90, 0x07, 0x17, 0x6b, 0xce, 0xc8, 0x25, 0xd7, 0x52, 0xaa, 0x38, 0xba, 0x18, 0xba, 0x0c, 0x0b,
	0xd4, 0xc7, 0x03, 0x15, 0xfc, 0x92, 0x44, 0x50, 0x91, 0x04, 0x1d, 0x35, 0x1f, 0x3b, 0x8f, 0x68,
	0x40, 0x6c, 0x3e, 0x8c, 0x14, 0xcf, 0xac, 0x0a, 0x86, 0xa6, 0x77, 0x87, 0x91, 0xe4, 0xfc, 0x14,
	0xaa, 0x2e, 0x65, 0x27, 0xe9, 0xee, 0x28, 0xcb, 0xdd, 0xf1, 0x76, 0x81, 0x17, 0xb7, 0x29, 0x3b,
	0xd1, 0x1b, 0x03, 0xdc, 0xd1, 0xb7, 0x44, 0xce, 0xec, 0x28, 0x26, 0xc4, 0x8f, 0x38, 0xed, 0x7b,
	0x44, 0xa6, 0x54, 0xc5, 0xaa, 0x51, 0x76, 0x34, 0x26, 0x22, 0x07, 0x56, 0x7c, 0x1c, 0xe0, 0x01,
	0x71, 0xed, 0x81, 0x70, 0x4e, 0x6a, 0x7b, 0x5e, 0xda, 0x7e, 0xbf, 0xc0, 0xf6, 0x1d, 0x25, 0x9a,
	0xad, 0x2a, 0xc8, 0x3f, 0x45, 0x43, 0x5d, 0x58, 0xc4, 0x8e, 0x43, 0x3c, 0xd1, 0xa2, 0x84, 0x71,
	0x7a, 0x34, 0xbf, 0x57, 0xa0, 0x7c, 0x73, 0x2c, 0x92, 0x16, 0xc5, 0xac, 0x16, 0xf3, 0xb7, 0x06,
	0xa0, 0xd3, 0x00, 0x44, 0x46, 0x8f, 0x42, 0xc6, 0x89, 0x1f, 0x79, 0x98, 0xab, 0xd8, 0xe9, 0x74,
	0x59, 0x49, 0x67, 0xbb, 0x7a, 0x52, 0x76, 0x1f, 0x37, 0xe1, 0xf2, 0x48, 0x4a, 0x39, 0x42, 0xad,
	0x23, 0xd7, 0xaf, 0x34, 0x69, 0x36, 0x8f, 0x94, 0x6d, 0xd9, 0xbc, 0x98, 0x31, 0x2c, 0x9f, 0x82,
	0x8b, 0xde, 0x83, 0x95, 0x0c, 0xe0, 0x71, 0xf0, 0x15, 0x0e, 0x94, 0x99, 0x4b, 0x13, 0xe0, 0x47,
	0xb0, 0x9c, 0x95, 0x50, 0x1b, 0x77, 0x46, 0xe6, 0x65, 0x03, 0x67, 0xf5, 0x27, 0x01, 0x37, 0x1f,
	0x02, 0x8c, 0x63, 0x8f, 0xde, 0x86, 0xe5, 0x7e, 0x18, 0x72, 0x5b, 0x26, 0x10, 0xa3, 0x4f, 0x88,
	0x3d, 0xe8, 0xeb, 0x94, 0xae, 0x8b, 0x09, 0xc1, 0xda, 0xa1, 0x4f, 0xc8, 0x6e, 0x1f, 0x7d, 0x1f,
	0xea, 0x22, 0xf3, 0xbd, 0xd0, 0xc1, 0x9e, 0xcd, 0x98, 0xcb, 0xb4, 0x09, 0x91, 0xfa, 0x07, 0x82,
	0xd8, 0x61, 0x2e, 0x33, 0xff, 0x63, 0xc0, 0xd2, 0x44, 0xe5, 0x45, 0x9b, 0xb0, 0x44, 0x5d, 0x8f,
	0xd8, 0x2e, 0xf1, 0x08, 0x27, 0x36, 0xe7, 0x9e, 0x34, 0x51, 0xdd, 0x78, 0x2d, 0x8d, 0x65, 0xda,
	0x2c, 0xb6, 0xb6, 0x75, 0xbb, 0x69, 0xd5, 0x84, 0xc4, 0xb6, 0x14, 0xe8, 0x72, 0x0f, 0xdd, 0x86,
	0x06, 0x4e, 0x78, 0x38, 0x52, 0x41, 0xb5, 0x77, 0xab, 0x1b, 0x6b, 0xa7, 0x74, 0x74, 0xd3, 0x86,
	0x73, 0xef, 0x92, 0x55, 0x17, 0x52, 0x5a, 0x0d, 0xf5, 0x09, 0xda, 0x82, 0xa5, 0x9c, 0x1e, 0xee,
	0xe9, 0xbe, 0xf1, 0xf9, 0x50, 0xf6, 0x2e, 0x59, 0xb5, 0x8c, 0x16, 0xee, 0xdd, 0x2a, 0x43, 0x89,
	0x73, 0xcf, 0xfc, 0x9d, 0x01, 0xcd, 0xe7, 0x9d, 0x01, 0xa2, 0x94, 0x92, 0x2f, 0x88, 0x93, 0x70,
	0xdc, 0xf7, 0x88, 0x7d, 0x4c, 0xbd, 0x34, 0x91, 0xea, 0x63, 0xf2, 0x6d, 0xea, 0x11, 0x74, 0x1b,
	0x96, 0x15, 0x45, 0x1c, 0x40, 0x62, 0x5d, 0x61, 0xc2, 0xf5, 0xd2, 0x5e, 0xe0, 0x9e, 0xc6, 0x48,
	0xa6, 0xab, 0x44, 0xcc, 0xaf, 0x4b, 0xa3, 0xa6, 0x49, 0x35, 0x7f, 0x68, 0x0f, 0xca, 0xa2, 0xfd,
	0x53, 0x86, 0xeb, 0xe7, 0xed, 0x69, 0x95, 0x70, 0x4b, 0xfc, 0x10, 0x4b, 0x29, 0x40, 0xab, 0x30,
	0xe7, 0x12, 0x8e, 0xa9, 0xa7, 0x33, 0x5a, 0x8f, 0xd0, 0x36, 0x34, 0x24, 0x83, 0xcd, 0x38, 0x8e,
	0xb9, 0x8a, 0x4a, 0xa9, 0x28, 0x2a, 0x96, 0x6c, 0x6c, 0x49, 0x47, 0x88, 0xc8, 0x98, 0xfc, 0x02,
	0x2a, 0x2c, 0xe9, 0x2b, 0xa8, 0xb3, 0x12, 0xea, 0x07, 0xd3, 0x41, 0xd5, 0xc2, 0xd6, 0x48, 0x8d,
	0x79, 0x0f, 0xca, 0x72, 0x01, 0xa8, 0x0a, 0xf3, 0xbd, 0xc3, 0x9f, 0x1f, 0xde, 0xbd, 0x7f, 0xd8,
	0xb8, 0x84, 0x16, 0xa1, 0xb2, 0x65, 0xed, 0x6c, 0x76, 0xf7, 0x0f, 0x77, 0x1b, 0x86, 0x98, 0xb2,
	0x7a, 0x87, 0x87, 0x62, 0x30, 0x83, 0x16, 0xa0, 0xbc, 0x63, 0x59, 0x77, 0xad, 0x46, 0x49, 0x70,
	0x6d, 0xef, 0x1c, 0xec, 0x48, 0xae, 0x59, 0x31, 0xea, 0x1d, 0x6d, 0x2b, 0x99, 0xb2, 0xf9, 0x33,
	0xa8, 0xa4, 0xd6, 0xd0, 0x12, 0x54, 0x7b, 0x87, 0x9d, 0xa3, 0x9d, 0xad, 0xfd, 0xdb, 0xfb, 0x3b,
	0xdb, 0x8d, 0x4b, 0xa8, 0x06, 0x0b, 0xbd, 0xc3, 0xbd, 0x9d, 0xcd, 0x83, 0xee, 0xde, 0x83, 0x86,
	0x81, 0x1a, 0xb0, 0xd8, 0xe9, 0x6e, 0x1e, 0xec, 0xd8, 0x9d, 0xee, 0x66, 0xb7, 0xd7, 0x69, 0xcc,
	0x98, 0xdf, 0x18, 0x50, 0xcf, 0xb7, 0x3b, 0xe2, 0x38, 0x51, 0x47, 0xc0, 0x63, 0x12, 0x33, 0x1a,
	0x06, 0x69, 0x63, 0x2b, 0x89, 0xf7, 0x14, 0x0d, 0x3d, 0x94, 0xb7, 0xa4, 0x88, 0xc4, 0x9c, 0xea,
	0xa3, 0xa4, 0xf8, 0x94, 0xcc, 0xdb, 0x69, 0x1d, 0x8d, 0xe4, 0xd5, 0x29, 0x99, 0x51, 0xb8, 0x76,
	0x13, 0x96, 0x26, 0xa6, 0xa7, 0x3b, 0x29, 0x67, 0xa0, 0x9e, 0xbf, 0x04, 0x20, 0x0c, 0x8b, 0x8f,
	0xdc, 0x63, 0x66, 0xa7, 0x37, 0x09, 0x43, 0x42, 0xfe, 0x78, 0xaa, 0x9b, 0x44, 0x6b, 0xcf, 0x3d,
	0x66, 0xfa, 0x5b, 0x61, 0xae, 0x3e, 0x1a, 0x53, 0x84, 0x89, 0x21, 0x8e, 0x83, 0x91, 0x89, 0x99,
	0x8b, 0x98, 0x78, 0x80, 0xe3, 0x20, 0x6f, 0x62, 0x38, 0xa6, 0xac, 0x7d, 0x0c, 0x8d, 0x49, 0x0c,
	0x45, 0x8e, 0x29, 0x65, 0x1c, 0x23, 0xe4, 0x27, 0x0d, 0x4c, 0x23, 0x6f, 0xfe, 0xde, 0x80, 0x95,
	0xad, 0x98, 0x60, 0x9e, 0xf6, 0x3b, 0x16, 0xf9, 0x4d, 0x42, 0x18, 0x2f, 0xba, 0x35, 0xaf, 0xc2,
	0x5c, 0x4c, 0x06, 0x22, 0x99, 0x54, 0x4f, 0xa1, 0x47, 0xe8, 0x13, 0x98, 0xd7, 0x77, 0x23, 0x5d,
	0x5f, 0xde, 0x3a, 0x9f, 0xb7, 0xac, 0x54, 0xcc, 0xfc, 0xc7, 0x0c, 0xac, 0xf4, 0x22, 0xf7, 0xff,
	0x40, 0x54, 0xce, 0x21, 0x3a, 0xc7, 0xfd, 0x3e, 0x03, 0xba, 0x74, 0x21, 0xd0, 0xe8, 0x21, 0x5c,
	0x19, 0xc4, 0xd8, 0x21, 0xc7, 0x89, 0x67, 0xbb, 0xc4, 0x09, 0x7d, 0x9f, 0x32, 0x96, 0x2d, 0xb6,
	0x73, 0x45, 0xc5, 0xf6, 0x72, 0x2a, 0xbf, 0x9d, 0x11, 0xd7, 0x75, 0x17, 0xdd, 0x80, 0x6a, 0x22,
	0x5d, 0x22, 0x1f, 0x41, 0xf4, 0x9d, 0xff, 0x74, 0xf9, 0xbb, 0x4d, 0x89, 0xe7, 0xde, 0xc1, 0xec,
	0xc4, 0x02, 0xc5, 0x2e, 0xbe, 0xcd, 0xaf, 0x0c, 0x58, 0x51, 0xe7, 0xca, 0xcb, 0x09, 0xf1, 0x39,
	0x1c, 0x3a, 0xf9, 0x06, 0x30, 0x7b, 0xea, 0x0d, 0xc0, 0xf4, 0x61, 0x79, 0x97, 0xf0, 0x6f, 0x0b,
	0x91, 0xf9, 0xb5, 0x01, 0xaf, 0x1c, 0x50, 0x96, 0x1a, 0x64, 0x53, 0x5b, 0x9c, 0xcd, 0x59, 0x5c,
	0x85, 0xb9, 0x63, 0xea, 0x89, 0x84, 0xd1, 0xc9, 0xa6, 0x46, 0xa2, 0xdb, 0x8e, 0x44, 0xa5, 0x15,
	0x5d, 0x8e, 0x6e, 0x5d, 0x2a, 0x82, 0x20, 0xda, 0x1b, 0x69, 0x4b, 0x4c, 0xf2, 0xf0, 0x84, 0xa4,
	0x4b, 0x90, 0xec, 0x5d, 0x41, 0x30, 0xbf, 0x34, 0x60, 0x25, 0x0f, 0x91, 0x45, 0x61, 0xc0, 0x08,
	0xba, 0x05, 0x95, 0xf4, 0x8d, 0x4e, 0x57, 0xb9, 0xf3, 0xe6, 0xe7, 0x48, 0x0e, 0xbd, 0x05, 0x4b,
	0x01, 0xf9, 0x82, 0xdb, 0x19, 0x00, 0xca, 0x4b, 0x35, 0x41, 0x3e, 0x1a, 0x81, 0x88, 0x61, 0x75,
	0x9b, 0xe2, 0x41, 0x10, 0xb2, 0x6f, 0x2d, 0x5b, 0xcc, 0x0f, 0xcf, 0xb0, 0xc9, 0x12, 0x8f, 0x33,
	0x61, 0x33, 0x4c, 0x78, 0x94, 0xf0, 0x4c, 0x73, 0xba, 0xa0, 0x28, 0xbd, 0x98, 0x6e, 0xfc, 0xb7,
	0x02, 0xcb, 0xe3, 0x6b, 0x1a, 0x8f, 0x43, 0xcf, 0x23, 0x31, 0xfa, 0x93, 0x01, 0xb5, 0x5c, 0x49,
	0x43, 0xd7, 0x8a, 0xdc, 0x75, 0x46, 0x01, 0x5c, 0xbb, 0x92, 0x0a, 0x65, 0xde, 0x32, 0x5b, 0x77,
	0xd3, 0xb7, 0x4c, 0x73, 0xff, 0xcb, 0x6f, 0xfe, 0xfd, 0xd5, 0xcc, 0x96, 0xf9, 0xd1, 0xe8, 0x1d,
	0x55, 0xfb, 0x82, 0xb5, 0x9f, 0x8e, 0xfd, 0xf4, 0xac, 0xad, 0xdc, 0xc0, 0xda, 0x4f, 0xd5, 0xc7,
	0xb3, 0xd1, 0x73, 0xeb, 0xf5, 0x51, 0xf1, 0xf8, 0x9b, 0x01, 0xb5, 0x5c, 0xc5, 0x2b, 0x04, 0x7c,
	0x56, 0x7d, 0x2c, 0x02, 0xfc, 0x4b, 0x09, 0xd8, 0xda, 0xd8, 0xbd, 0x28, 0xe0, 0xf6, 0xd3, 0x6c,
	0x20, 0x9f, 0x8d, 0xf1, 0xff, 0xd9, 0x80, 0x5a, 0xae, 0xc0, 0x14, 0xe2, 0x3f, 0xab, 0x1c, 0x15,
	0xe1, 0xbf, 0x2b, 0xf1, 0xef, 0xbf, 0xf3, 0xb2, 0xf0, 0xa3, 0xbf, 0x18, 0x00, 0xe3, 0x12, 0x84,
	0x8a, 0xee, 0x7c, 0xa7, 0xaa, 0xd5, 0xda, 0x39, 0x77, 0x61, 0x8a, 0x1c, 0xbd, 0x34, 0xe4, 0x7f,
	0x35, 0x60, 0x31, 0x5b, 0x29, 0xd0, 0x46, 0xe1, 0x33, 0xd5, 0xa9, 0xca, 0xb7, 0x76, 0x6d, 0x2a,
	0x19, 0x55, 0x8a, 0xcc, 0x4f, 0xe4, 0x52, 0xae, 0xa3, 0x0b, 0x67, 0x3d, 0xfa, 0xbb, 0x01, 0x4b,
	0x13, 0xbb, 0x1d, 0x7d, 0x50, 0xf8, 0x8e, 0x70, 0x56, 0x45, 0x2a, 0x4a, 0x98, 0x5f, 0x4b, 0xac,
	0x3d, 0xf3, 0xe8, 0x65, 0x25, 0xbc, 0xab, 0x61, 0x5c, 0x37, 0xde, 0xb9, 0xf5, 0x14, 0xde, 0x70,
	0x42, 0xff, 0xc5, 0xb8, 0x6f, 0xa5, 0x77, 0x25, 0x76, 0x24, 0x4e, 0xe8, 0x23, 0xe3, 0x57, 0x3b,
	0x9a, 0x7f, 0x10, 0x7a, 0x38, 0x18, 0xb4, 0xc2, 0x78, 0xd0, 0x1e, 0x90, 0x40, 0x9e, 0xdf, 0x6d,
	0x35, 0x85, 0x23, 0xca, 0x9e, 0xf3, 0x47, 0xcd, 0x8d, 0x94, 0xd0, 0x9f, 0x93, 0x12, 0xd7, 0xfe,
	0x17, 0x00, 0x00, 0xff, 0xff, 0x82, 0x2f, 0x0d, 0xbd, 0xd9, 0x19, 0x00, 0x00,
}
