/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.weaver.loadtime;

import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import org.aspectj.weaver.loadtime.IWeavingContext;

public class DefaultWeavingContext
implements IWeavingContext {
    protected ClassLoader loader;
    private String shortName;

    public DefaultWeavingContext(ClassLoader loader) {
        this.loader = loader;
    }

    public Enumeration getResources(String name) throws IOException {
        return this.loader.getResources(name);
    }

    public String getBundleIdFromURL(URL url) {
        return "";
    }

    public String getClassLoaderName() {
        return this.loader != null ? this.loader.getClass().getName() + "@" + Integer.toHexString(System.identityHashCode(this.loader)) : "null";
    }

    public String getFile(URL url) {
        return url.getFile();
    }

    public String getId() {
        if (this.shortName == null) {
            this.shortName = this.getClassLoaderName().replace('$', '.');
            int index = this.shortName.lastIndexOf(".");
            this.shortName = this.shortName.substring(index + 1);
        }
        return this.shortName;
    }

    public String getSuffix() {
        return this.getClassLoaderName();
    }

    public boolean isLocallyDefined(String classname) {
        URL parentURL;
        String asResource = classname.replace('.', '/').concat(".class");
        URL localURL = this.loader.getResource(asResource);
        if (localURL == null) {
            return false;
        }
        boolean isLocallyDefined = true;
        ClassLoader parent = this.loader.getParent();
        if (parent != null && localURL.equals(parentURL = parent.getResource(asResource))) {
            isLocallyDefined = false;
        }
        return isLocallyDefined;
    }
}

