/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 4; tab-width: 4 -*- */
/*
 * unity-webapps-action-manager.h
 * Copyright (C) Canonical LTD 2011
 * 
 * Author: Robert Carr <racarr@canonical.com>
 * 
unity-webapps is free software: you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published
 * by the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * unity-webapps is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.";
 */


#ifndef __UNITY_WEBAPPS_ACTION_MANAGER_H
#define __UNITY_WEBAPPS_ACTION_MANAGER_H


#define UNITY_WEBAPPS_TYPE_ACTION_MANAGER              (unity_webapps_action_manager_get_type())
#define UNITY_WEBAPPS_ACTION_MANAGER(obj)              (G_TYPE_CHECK_INSTANCE_CAST((obj), UNITY_WEBAPPS_TYPE_ACTION_MANAGER, UnityWebappsActionManager))
#define UNITY_WEBAPPS_ACTION_MANAGER_CLASS(klass)      (G_TYPE_CHECK_CLASS_CAST((klass), UNITY_WEBAPPS_TYPE_ACTION_MANAGER, UnityWebappsActionManagerClass))
#define UNITY_WEBAPPS_IS_ACTION_MANAGER(obj)           (G_TYPE_CHECK_INSTANCE_TYPE((obj), UNITY_WEBAPPS_TYPE_ACTION_MANAGER))
#define UNITY_WEBAPPS_IS_ACTION_MANAGER_CLASS(klass)   (G_TYPE_CHECK_CLASS_TYPE ((klass), UNITY_WEBAPPS_TYPE_ACTION_MANAGER))
#define UNITY_WEBAPPS_ACTION_MANAGER_GET_CLASS(obj)    (G_TYPE_INSTANCE_GET_CLASS((obj), UNITY_WEBAPPS_TYPE_ACTION_MANAGER, UnityWebappsActionManagerClass))

#include <libdbusmenu-glib/menuitem.h>
#include <libdbusmenu-glib/server.h>

#include "unity-webapps-interest-tracker.h"

typedef struct _UnityWebappsActionManagerPrivate UnityWebappsActionManagerPrivate;

typedef struct _UnityWebappsActionManager UnityWebappsActionManager;

struct _UnityWebappsActionManager {
	GObject object;

	UnityWebappsActionManagerPrivate *priv;
	//	UnityWebappsGenActionManager *action_manager_proxy;
	//	GDBusConnection *session_bus;
};

typedef struct _UnityWebappsActionManagerClass UnityWebappsActionManagerClass;

struct _UnityWebappsActionManagerClass
{
	GObjectClass parent_class;
};

GType unity_webapps_action_manager_get_type (void) G_GNUC_CONST;

UnityWebappsActionManager *unity_webapps_action_manager_new (UnityWebappsInterestTracker *interest_tracker, const gchar *menu_pathx);
UnityWebappsActionManager *unity_webapps_action_manager_new_flat (UnityWebappsInterestTracker *interest_tracker, const gchar *menu_path);

DbusmenuMenuitem *unity_webapps_action_manager_get_root (UnityWebappsActionManager *manager);
DbusmenuServer *unity_webapps_action_manager_get_server (UnityWebappsActionManager *manager);


void unity_webapps_action_manager_add_action (UnityWebappsActionManager *manager,
											  const gchar *action_name,
											  gint interest_id);

void unity_webapps_action_manager_remove_action (UnityWebappsActionManager *manager,
												 const gchar *action_name,
												 gint interest_id);

void unity_webapps_action_manager_remove_all_actions (UnityWebappsActionManager *manager,
													  gint interest_id);

void unity_webapps_action_manager_set_track_activity (UnityWebappsActionManager *manager,
													  gboolean track_activity);

GVariant *unity_webapps_action_manager_serialize (UnityWebappsActionManager *manager);

gint unity_webapps_action_manager_get_most_recent_interest_with_action (UnityWebappsActionManager *manager,
	const gchar *path);

#endif
