/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 4; tab-width: 4 -*- */
/*
 * unity-webapps-available-application.h
 * Copyright (C) Canonical LTD 2011
 * 
 * Author: Robert Carr <racarr@canonical.com>
 * 
unity-webapps is free software: you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published
 * by the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * unity-webapps is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.";
 */


#ifndef __UNITY_WEBAPPS_AVAILABLE_APPLICATION_H
#define __UNITY_WEBAPPS_AVAILABLE_APPLICATION_H

#include <glib-object.h>


#define UNITY_WEBAPPS_TYPE_AVAILABLE_APPLICATION              (unity_webapps_available_application_get_type())
#define UNITY_WEBAPPS_AVAILABLE_APPLICATION(obj)              (G_TYPE_CHECK_INSTANCE_CAST((obj), UNITY_WEBAPPS_TYPE_AVAILABLE_APPLICATION, UnityWebappsAvailableApplication))
#define UNITY_WEBAPPS_AVAILABLE_APPLICATION_CLASS(klass)      (G_TYPE_CHECK_CLASS_CAST((klass), UNITY_WEBAPPS_TYPE_AVAILABLE_APPLICATION, UnityWebappsAvailableApplicationClass))
#define UNITY_WEBAPPS_IS_AVAILABLE_APPLICATION(obj)           (G_TYPE_CHECK_INSTANCE_TYPE((obj), UNITY_WEBAPPS_TYPE_AVAILABLE_APPLICATION))
#define UNITY_WEBAPPS_IS_AVAILABLE_APPLICATION_CLASS(klass)   (G_TYPE_CHECK_CLASS_TYPE ((klass), UNITY_WEBAPPS_TYPE_AVAILABLE_APPLICATION))
#define UNITY_WEBAPPS_AVAILABLE_APPLICATION_GET_CLASS(obj)    (G_TYPE_INSTANCE_GET_CLASS((obj), UNITY_WEBAPPS_TYPE_AVAILABLE_APPLICATION, UnityWebappsAvailableApplicationClass))

typedef struct _UnityWebappsAvailableApplicationPrivate UnityWebappsAvailableApplicationPrivate;

typedef struct _UnityWebappsAvailableApplication UnityWebappsAvailableApplication;

typedef void (*UnityWebappsAvailableApplicationInstalledQueryCallback) (UnityWebappsAvailableApplication *application,
																		gboolean installed,
																		gpointer user_data);
struct _UnityWebappsAvailableApplication {
	GObject object;

	UnityWebappsAvailableApplicationPrivate *priv;
};

typedef struct _UnityWebappsAvailableApplicationClass UnityWebappsAvailableApplicationClass;

struct _UnityWebappsAvailableApplicationClass
{
	GObjectClass parent_class;
	
	/* Package name */
	const gchar *(*get_name) (UnityWebappsAvailableApplication *self);
	/* Application name */
	const gchar *(*get_application_name) (UnityWebappsAvailableApplication *self);
	const gchar *(*get_application_domain) (UnityWebappsAvailableApplication *self);
	void (*get_is_installed) (UnityWebappsAvailableApplication *self, 
							  UnityWebappsAvailableApplicationInstalledQueryCallback callback,
							  gpointer user_data);
};

GType unity_webapps_available_application_get_type (void) G_GNUC_CONST;

const gchar *unity_webapps_available_application_get_name (UnityWebappsAvailableApplication *application);
const gchar *unity_webapps_available_application_get_application_name (UnityWebappsAvailableApplication *application);
const gchar *unity_webapps_available_application_get_application_domain (UnityWebappsAvailableApplication *application);

void unity_webapps_available_application_get_is_installed (UnityWebappsAvailableApplication *self, 
														   UnityWebappsAvailableApplicationInstalledQueryCallback callback,
														   gpointer user_data);

#endif
