/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 4; tab-width: 4 -*- */
/*
 * test-runner.c
 * Copyright (C) Canonical LTD 2011
 * 
 * Author: Robert Carr <racarr@canonical.com>
 * 
unity-webapps is free software: you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published
 * by the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * unity-webapps is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.";
 */
#include <stdlib.h>
#include <stdio.h>

#include <unistd.h>

#include <errno.h>

#include <glib.h>
#include <glib/gstdio.h>
#include <glib-object.h>

#include <gio/gio.h>

#include "uwa-test.h"

static GMainLoop *mainloop = NULL;


static gchar *name = NULL;
static gboolean do_not_trace = FALSE;
static gboolean echo = FALSE;
static gint check_count = 0;

static GOptionEntry option_entries[] =
	{
		{ "name", 'n',0,G_OPTION_ARG_STRING, &name, "Test name", NULL },
		{ "do-not-trace", 'd', 0, G_OPTION_ARG_NONE, &do_not_trace, "Do not trace (just run the test)", NULL},
		{ "echo", 'e', 0, G_OPTION_ARG_NONE, &echo, "Echo service output", NULL},
		{ NULL, }
	};

static gboolean
timeout_cb (gpointer user_data)
{
  UwaTest *test = (UwaTest *)user_data;
  
  if (uwa_test_passed (test, check_count == 50 ? TRUE : FALSE))
	{
	  g_printf ("Test passed\n");
	  exit (0);
	}

  if (check_count < 20)
	{
	  check_count++;
	  return TRUE;
	}
  
  printf("Test failed\n");
  exit(1);

  return FALSE;
}


static void
bus_filter_test_finished (GDBusConnection *connection,
						  const gchar *sender,
						  const gchar *object,
						  const gchar *interface,
						  const gchar *signal,
						  GVariant *params,
						  gpointer user_data)
{
  g_timeout_add (300, timeout_cb, user_data);
}

gint
main (gint argc, gchar **argv)
{
  GOptionContext *context;
  UwaTest *test;
  GDBusConnection *connection;
  GError *error;

  g_type_init ();
  
  error = NULL;
  
  context = g_option_context_new ("- Run libunity-webppps unit tests");
  
  // TODO: GETTEXT
  g_option_context_add_main_entries (context, option_entries, NULL);

  if (!g_option_context_parse (context, &argc, &argv, &error))
	{
	  printf("Failed to parse arguments: %s\n", error->message);
	  exit(1);
	}
  
  test = uwa_test_new (name, do_not_trace, echo);
  
  if (uwa_test_prepare_environment (test) == FALSE)
	{
	  printf("Failed to prepare test environment\n");
	  exit(1);
	}
  
  error = NULL;
  
  connection = g_bus_get_sync (G_BUS_TYPE_SESSION, NULL, &error);
  
  if (error != NULL)
	{
	  printf("Failed to get session bus\n");
	  exit(1);
	}
  
  g_dbus_connection_signal_subscribe (connection,
									  NULL,
									  "com.canonical.Unity.Webapps.TraceTester",
									  "TestFinished",
									  NULL,
									  NULL,
									  G_DBUS_SIGNAL_FLAGS_NONE,
									  bus_filter_test_finished,
									  test,
									  NULL);
  
  uwa_test_run (test);

  
  mainloop = g_main_loop_new (NULL, FALSE);
  g_main_loop_run (mainloop);
  
  g_object_unref (G_OBJECT (connection));
  
  exit (0);
}
