/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 4; tab-width: 4 -*- */
/*
 * unity-webapps-indicator-model.h
 * Copyright (C) Canonical LTD 2011
 * 
 * Author: Robert Carr <racarr@canonical.com>
 * 
unity-webapps is free software: you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published
 * by the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * unity-webapps is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.";
 */


#ifndef __UNITY_WEBAPPS_INDICATOR_MODEL_H
#define __UNITY_WEBAPPS_INDICATOR_MODEL_H


#define UNITY_WEBAPPS_TYPE_INDICATOR_MODEL              (unity_webapps_indicator_model_get_type())
#define UNITY_WEBAPPS_INDICATOR_MODEL(obj)              (G_TYPE_CHECK_INSTANCE_CAST((obj), UNITY_WEBAPPS_TYPE_INDICATOR_MODEL, UnityWebappsIndicatorModel))
#define UNITY_WEBAPPS_INDICATOR_MODEL_CLASS(klass)      (G_TYPE_CHECK_CLASS_CAST((klass), UNITY_WEBAPPS_TYPE_INDICATOR_MODEL, UnityWebappsIndicatorModelClass))
#define UNITY_WEBAPPS_IS_INDICATOR_MODEL(obj)           (G_TYPE_CHECK_INSTANCE_TYPE((obj), UNITY_WEBAPPS_TYPE_INDICATOR_MODEL))
#define UNITY_WEBAPPS_IS_INDICATOR_MODEL_CLASS(klass)   (G_TYPE_CHECK_CLASS_TYPE ((klass), UNITY_WEBAPPS_TYPE_INDICATOR_MODEL))
#define UNITY_WEBAPPS_INDICATOR_MODEL_GET_CLASS(obj)    (G_TYPE_INSTANCE_GET_CLASS((obj), UNITY_WEBAPPS_TYPE_INDICATOR_MODEL, UnityWebappsIndicatorModelClass))

typedef struct _UnityWebappsIndicatorModelPrivate UnityWebappsIndicatorModelPrivate;

typedef struct _UnityWebappsIndicatorModel UnityWebappsIndicatorModel;


struct _UnityWebappsIndicatorModel {
	GObject object;

	UnityWebappsIndicatorModelPrivate *priv;
	//	UnityWebappsGenIndicatorModel *indicator_model_proxy;
	//	GDBusConnection *session_bus;
};

typedef struct _UnityWebappsIndicatorModelClass UnityWebappsIndicatorModelClass;

struct _UnityWebappsIndicatorModelClass
{
	GObjectClass parent_class;
};

GType unity_webapps_indicator_model_get_type (void) G_GNUC_CONST;

UnityWebappsIndicatorModel *unity_webapps_indicator_model_new ();

void unity_webapps_indicator_model_show_indicator_for_interest (UnityWebappsIndicatorModel *model,
																const gchar *name,
																gint interest_id);
void unity_webapps_indicator_model_clear_indicator_for_interest (UnityWebappsIndicatorModel *model,
																 const gchar *name,
																 gint interest_id);
void unity_webapps_indicator_model_clear_indicators_for_interest (UnityWebappsIndicatorModel *model,
																  gint interest_id);

GVariant *unity_webapps_indicator_model_serialize (UnityWebappsIndicatorModel *model);

void
unity_webapps_indicator_model_set_indicator_property_for_interest (UnityWebappsIndicatorModel *model,
																   const gchar *indicator_name,
																   const gchar *property_name,
																   GVariant *value,
																   gint interest_id);

GVariant *unity_webapps_indicator_model_get_indicator_property (UnityWebappsIndicatorModel *model,
																const gchar *indicator_name,
																const gchar *property_name);


#endif
