/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 4; tab-width: 4 -*- */
/*
 * unity-webapps-launcher-context.h
 * Copyright (C) Canonical LTD 2011
 * 
 * Author: Robert Carr <racarr@canonical.com>
 * 
 unity-webapps is free software: you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published
 * by the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * unity-webapps is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.";
 */

#ifndef __UNITY_WEBAPPS_LAUNCHER_CONTEXT_H
#define __UNITY_WEBAPPS_LAUNCHER_CONTEXT_H

typedef struct _UnityWebappsLauncherContext UnityWebappsLauncherContext;

#include "unity-webapps-context-daemon.h"
#include "unity-webapps-action-manager.h"
#include "unity-webapps-application-info.h"

#include "../unity-webapps-gen-launcher.h"

#include <unity.h>
#include <libdbusmenu-glib/menuitem.h>

struct _UnityWebappsLauncherContext {
  GDBusConnection *connection;

  UnityWebappsGenLauncher *launcher_service_interface;
	
  UnityLauncherEntry *launcher_entry;
	
  guint num_actions;
  UnityWebappsActionManager *action_manager;
  
  UnityWebappsApplicationInfo *application_info;
};

UnityWebappsLauncherContext *unity_webapps_launcher_context_new (GDBusConnection *connection, const gchar *desktop_id, UnityWebappsInterestTracker *interest_tracker, UnityWebappsApplicationInfo *application_info);
void unity_webapps_launcher_context_free (UnityWebappsLauncherContext *launcher_context);



#endif
