#include <gio/gio.h>

#include "unity-webapps-application-manifest.h"
#include "unity-webapps-local-available-application.h"
#include "unity-webapps-debug.h"

typedef struct _AvailableApplicationTestFixture {
  UnityWebappsLocalAvailableApplication *app;
} AvailableApplicationTestFixture;


static void
setup_fixture_simple (AvailableApplicationTestFixture *fixture, gconstpointer user_data)
{
  fixture->app = 
    (UnityWebappsLocalAvailableApplication *) unity_webapps_local_available_application_new (
        unity_webapps_application_manifest_new_from_file (TESTDATADIR "test-manifest-1.json"));
}


static void
teardown_fixture_simple (AvailableApplicationTestFixture *fixture, gconstpointer user_data)
{
  g_object_unref (G_OBJECT (fixture->app));
}

static void
test_load_simple_application_patternspecs_1 (AvailableApplicationTestFixture *fixture, gconstpointer user_data)
{
  g_assert (unity_webapps_local_available_application_provides_url (fixture->app, "http://www.test.ts/*"));
  g_assert (unity_webapps_local_available_application_provides_url (fixture->app, "https://bar.bz") == FALSE);
}

int 
main (int argc, char **argv)
{
  g_type_init ();
  g_test_init (&argc, &argv, NULL);
  
  unity_webapps_debug_initialize_flags ();
  
  g_test_add("/Applications/Available/Local/PatternSpecs", AvailableApplicationTestFixture, NULL,
	     setup_fixture_simple, test_load_simple_application_patternspecs_1, teardown_fixture_simple);
  
  return g_test_run ();
}
