/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.gui.plaf.palette;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JToolBar;
import javax.swing.SwingConstants;
import javax.swing.SwingUtilities;
import javax.swing.border.AbstractBorder;
import org.apache.batik.ext.awt.LinearGradientPaint;
import org.apache.batik.ext.awt.MultipleGradientPaint;
import org.jhotdraw.gui.plaf.palette.PaletteToolBarUI;

public class PaletteToolBarBorder
extends AbstractBorder
implements SwingConstants {
    private static final float[] enabledStops = new float[]{0.0f, 0.5f, 1.0f};
    private static final Color[] enabledStopColors = new Color[]{new Color(0xF8F8F8), new Color(0xC8C8C8), new Color(0xF8F8F8)};
    private static final float[] selectedStops = new float[]{0.0f, 0.1f, 0.9f, 1.0f};
    private static final Color[] selectedStopColors = new Color[]{new Color(0x666666), new Color(0xCCCCCC), new Color(0x999999), new Color(0xB1B1B1)};
    private static final Color bright = new Color(0x999999, true);
    private static final Color dark = new Color(0x8C8C8C);
    private static final Color divider = new Color(0x9F9F9F);

    @Override
    public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
        JToolBar jToolBar;
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        if (component instanceof JToolBar && ((JToolBar)component).getUI() instanceof PaletteToolBarUI && (jToolBar = (JToolBar)component).isFloatable()) {
            int n5 = n;
            int n6 = n2;
            int n7 = n3;
            int n8 = n4;
            if (jToolBar.getOrientation() == 0) {
                if (jToolBar.getComponentOrientation().isLeftToRight()) {
                    int n9 = 18;
                    int n10 = n4;
                    int n11 = 0;
                    int n12 = 0;
                    int n13 = -5921371;
                    float[] fArray = enabledStops;
                    Color[] colorArray = enabledStopColors;
                    graphics2D.setColor(new Color(n13, true));
                    graphics2D.drawRect(n11, n12, n9 - 1, n10 - 1);
                    LinearGradientPaint linearGradientPaint = new LinearGradientPaint(new Point2D.Float(1.0f, 1.0f), new Point2D.Float(19.0f, 1.0f), fArray, colorArray, MultipleGradientPaint.REPEAT, MultipleGradientPaint.LINEAR_RGB);
                    graphics2D.setPaint(linearGradientPaint);
                    graphics2D.fillRect(n11 + 1, n11 + 1, n9 - 2, n10 - 2);
                    Icon icon = (Icon)jToolBar.getClientProperty("Palette.ToolBar.icon");
                    if (icon != null) {
                        icon.paintIcon(component, graphics, n11 + (n9 - icon.getIconWidth()) / 2, n12 + n10 - 4 - icon.getIconHeight());
                    }
                    int n14 = jToolBar.getClientProperty("Palette.ToolBar.icon") instanceof Integer ? (Integer)jToolBar.getClientProperty("Palette.ToolBar.icon") : 2;
                    String string = jToolBar.getName();
                    if (string != null) {
                        Font font = jToolBar.getFont();
                        FontMetrics fontMetrics = graphics2D.getFontMetrics();
                        int n15 = n10 - 8;
                        if (icon != null) {
                            n15 -= icon.getIconHeight() + n14;
                        }
                        string = this.clippedText(string, fontMetrics, n15);
                        AffineTransform affineTransform = graphics2D.getTransform();
                        AffineTransform affineTransform2 = graphics2D.getTransform();
                        affineTransform2.rotate(-1.5707963267948966, n11 + 2 + fontMetrics.getAscent(), n15 + 4);
                        graphics2D.setTransform(affineTransform2);
                        graphics2D.setColor(Color.black);
                        graphics2D.drawString(string, n11 + 2 + fontMetrics.getAscent(), n15 + 4);
                        graphics2D.setTransform(affineTransform);
                    }
                } else {
                    graphics2D.setColor(bright);
                    graphics2D.fillRect(n7 - n5 - 3, n6 + 2, 1, n8 - 4);
                    graphics2D.fillRect(n7 - n5 - 5, n6 + 2, 1, n8 - 4);
                    graphics2D.setColor(dark);
                    graphics2D.fillRect(n7 - n5 - 2, n6 + 2, 1, n8 - 4);
                    graphics2D.fillRect(n7 - n5 - 6, n6 + 2, 1, n8 - 4);
                }
            } else {
                graphics2D.setColor(bright);
                graphics2D.fillRect(n5 + 2, n6 + 2, n7 - 4, 1);
                graphics2D.fillRect(n5 + 2, n6 + 5, n7 - 4, 1);
                graphics2D.setColor(dark);
                graphics2D.fillRect(n5 + 2, n6 + 3, n7 - 4, 1);
                graphics2D.fillRect(n5 + 2, n6 + 6, n7 - 4, 1);
            }
        }
    }

    @Override
    public Insets getBorderInsets(Component component) {
        return this.getBorderInsets(component, new Insets(0, 0, 0, 0));
    }

    public Insets getDragInsets(Component component) {
        return new Insets(0, 18, 0, 0);
    }

    @Override
    public Insets getBorderInsets(Component component, Insets insets) {
        JComponent jComponent;
        if (insets == null) {
            insets = new Insets(0, 0, 0, 0);
        }
        if ((jComponent = (JComponent)component).getClientProperty("Palette.ToolBar.insetsOverride") instanceof Insets) {
            Insets insets2 = (Insets)jComponent.getClientProperty("Palette.ToolBar.insetsOverride");
            insets.top = insets2.top;
            insets.left = insets2.left;
            insets.bottom = insets2.bottom;
            insets.right = insets2.right;
            return insets;
        }
        insets.top = 0;
        insets.left = 18;
        insets.bottom = 0;
        insets.right = 0;
        return insets;
    }

    private String clippedText(String string, FontMetrics fontMetrics, int n) {
        if (string == null || string.equals("")) {
            return "";
        }
        int n2 = SwingUtilities.computeStringWidth(fontMetrics, string);
        String string2 = "\u2026";
        if (n2 > n) {
            int n3;
            int n4 = SwingUtilities.computeStringWidth(fontMetrics, string2);
            for (n3 = 0; n3 < string.length() && (n4 += fontMetrics.charWidth(string.charAt(n3))) <= n; ++n3) {
            }
            string = string.substring(0, n3) + string2;
        }
        return string;
    }

    public static class UIResource
    extends PaletteToolBarBorder
    implements javax.swing.plaf.UIResource {
    }
}

