/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.standard;

import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.IOException;
import java.io.ObjectInputStream;
import org.jhotdraw.framework.ConnectionFigure;
import org.jhotdraw.framework.Connector;
import org.jhotdraw.framework.Figure;
import org.jhotdraw.framework.FigureAttributeConstant;
import org.jhotdraw.framework.FigureChangeEvent;
import org.jhotdraw.framework.FigureChangeListener;
import org.jhotdraw.framework.FigureEnumeration;
import org.jhotdraw.framework.HandleEnumeration;
import org.jhotdraw.framework.Locator;
import org.jhotdraw.standard.AbstractFigure;
import org.jhotdraw.standard.TextHolder;
import org.jhotdraw.util.StorableInput;
import org.jhotdraw.util.StorableOutput;

public abstract class DecoratorFigure
extends AbstractFigure
implements FigureChangeListener {
    private Figure myDecoratedFigure;
    private static final long serialVersionUID = 8993011151564573288L;
    private int decoratorFigureSerializedDataVersion = 1;

    public DecoratorFigure() {
        this.initialize();
    }

    public DecoratorFigure(Figure figure) {
        this.initialize();
        this.decorate(figure);
    }

    protected void initialize() {
    }

    public Insets connectionInsets() {
        return this.getDecoratedFigure().connectionInsets();
    }

    public boolean canConnect() {
        return this.getDecoratedFigure().canConnect();
    }

    public boolean containsPoint(int n, int n2) {
        return this.getDecoratedFigure().containsPoint(n, n2);
    }

    public void decorate(Figure figure) {
        this.setDecoratedFigure(figure);
        this.getDecoratedFigure().addToContainer(this);
    }

    public Figure peelDecoration() {
        this.getDecoratedFigure().removeFromContainer(this);
        this.removeDependendFigure(this.getDecoratedFigure());
        return this.getDecoratedFigure();
    }

    public void setDecoratedFigure(Figure figure) {
        this.myDecoratedFigure = figure;
    }

    public Figure getDecoratedFigure() {
        return this.myDecoratedFigure;
    }

    public Rectangle displayBox() {
        return this.getDecoratedFigure().displayBox();
    }

    public void basicDisplayBox(Point point, Point point2) {
        this.getDecoratedFigure().basicDisplayBox(point, point2);
    }

    public void draw(Graphics graphics) {
        this.getDecoratedFigure().draw(graphics);
    }

    public Figure findFigureInside(int n, int n2) {
        Figure figure = this.getDecoratedFigure().findFigureInside(n, n2);
        if (figure != null && figure == this.getDecoratedFigure()) {
            return this;
        }
        return figure;
    }

    public HandleEnumeration handles() {
        return this.getDecoratedFigure().handles();
    }

    public boolean includes(Figure figure) {
        return super.includes(figure) || this.getDecoratedFigure().includes(figure);
    }

    public void moveBy(int n, int n2) {
        this.getDecoratedFigure().moveBy(n, n2);
    }

    protected void basicMoveBy(int n, int n2) {
    }

    public void release() {
        super.release();
        this.getDecoratedFigure().removeFromContainer(this);
        this.getDecoratedFigure().release();
    }

    public void figureInvalidated(FigureChangeEvent figureChangeEvent) {
        if (this.listener() != null) {
            this.listener().figureInvalidated(figureChangeEvent);
        }
    }

    public void figureChanged(FigureChangeEvent figureChangeEvent) {
    }

    public void figureRemoved(FigureChangeEvent figureChangeEvent) {
    }

    public void figureRequestUpdate(FigureChangeEvent figureChangeEvent) {
        if (this.listener() != null) {
            this.listener().figureRequestUpdate(figureChangeEvent);
        }
    }

    public void figureRequestRemove(FigureChangeEvent figureChangeEvent) {
        if (this.listener() != null) {
            this.listener().figureRequestRemove(new FigureChangeEvent(this));
        }
    }

    public FigureEnumeration figures() {
        return this.getDecoratedFigure().figures();
    }

    public FigureEnumeration decompose() {
        return this.getDecoratedFigure().decompose();
    }

    public void setAttribute(String string, Object object) {
        this.getDecoratedFigure().setAttribute(string, object);
    }

    public void setAttribute(FigureAttributeConstant figureAttributeConstant, Object object) {
        this.getDecoratedFigure().setAttribute(figureAttributeConstant, object);
    }

    public Object getAttribute(String string) {
        return this.getDecoratedFigure().getAttribute(string);
    }

    public Object getAttribute(FigureAttributeConstant figureAttributeConstant) {
        return this.getDecoratedFigure().getAttribute(figureAttributeConstant);
    }

    public Locator connectedTextLocator(Figure figure) {
        return this.getDecoratedFigure().connectedTextLocator(figure);
    }

    public Connector connectorAt(int n, int n2) {
        return this.getDecoratedFigure().connectorAt(n, n2);
    }

    public void connectorVisibility(boolean bl, ConnectionFigure connectionFigure) {
        this.getDecoratedFigure().connectorVisibility(bl, null);
    }

    public void write(StorableOutput storableOutput) {
        super.write(storableOutput);
        storableOutput.writeStorable(this.getDecoratedFigure());
    }

    public void read(StorableInput storableInput) throws IOException {
        super.read(storableInput);
        this.decorate((Figure)storableInput.readStorable());
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        objectInputStream.defaultReadObject();
        this.getDecoratedFigure().addToContainer(this);
    }

    public TextHolder getTextHolder() {
        return this.getDecoratedFigure().getTextHolder();
    }

    public synchronized FigureEnumeration getDependendFigures() {
        return this.getDecoratedFigure().getDependendFigures();
    }

    public synchronized void addDependendFigure(Figure figure) {
        this.getDecoratedFigure().addDependendFigure(figure);
    }

    public synchronized void removeDependendFigure(Figure figure) {
        this.getDecoratedFigure().removeDependendFigure(figure);
    }

    public String getMap() {
        return "";
    }
}

